<!-- @version $Id: autocomplete.js.php 7381 2024-11-26 23:41:50Z canajun2eh $ -->
<?php require_once 'js/jQuery.ui.php' ?>
<script type="text/javascript">
	jQuery.noConflict(); // @see http://docs.jquery.com/Using_jQuery_with_Other_Libraries/
	const ac_mapper = function(line,term) {
		const parts = line.split("|");
		const lab = parts[0].trim();
		const poz = lab.match(/<img.*\/>/);
		const markedLab = lab.replaceAll(term, function (t) {
			return "<strong>" + t + "</strong>";
		});
		return {
			label: markedLab,
			value: lab
		};
	}
	const ac_mapperID = function(line,term) {
		const parts = line.split("|");
		const lab = parts[0].trim() + " (" + parts[1].trim() + ")";
		const poz = lab.match(/<img.*\/>/);
		const markedLab = lab.replaceAll(term, function (t) {
			return "<strong>" + t + "</strong>";
		});
		return {
			label: markedLab,
			value: parts[1].trim()
		};
	}
	jQuery(function ($){
	$.widget("pgv-ui.autocompleteRestHtml", $.ui.autocomplete, {
		ac_cache: {
			term: "",
			data: [],
			flush: function () {
				this.term = "";
				this.data = [];
			},
			isEmpty: function () {
				return jQuery.isEmptyObject(this.data);
			},
			getFiltered: function (newTermRE) {
				return this.data.filter(function (e) {
					return newTermRE.test(e);
				});
			}
		},
		options: {
			change: function (event, ui) {
				const that = $(this).autocompleteRestHtml("instance");
				that.ac_cache.flush();
			},
			source: function (request, response) {
				const that = this;
				const extraParams = this.options.extraParams;
				const termRE = new RegExp($.ui.autocomplete.escapeRegex(request.term), "gi");
				const mapperF = extraParams.withID ? ac_mapperID : ac_mapper;
				if(!this.ac_cache.isEmpty()) {
					if(request.term.startsWith(this.ac_cache.term)) {
						response(this.ac_cache.getFiltered(termRE).map(line => mapperF(line,termRE)));
						return;
					} else {
						this.ac_cache.flush();
					}
				}
				$.ajax({
					url: "autocomplete.php",
					dataType: "text",
					data: {
						q: request.term.replaceAll("'", "`"),
						field: extraParams.field,
						option: extraParams.option,
						fmt: "text"
					},
					success: function (data) {
						if (!data) {
							response(null);
							return;
						}
						const lines = data.trim().split(/\r?\n/);
						try {
							const items = lines.map(line => mapperF(line,termRE));
							response(items);
							that.ac_cache.term=request.term;
							that.ac_cache.data=lines;
						} catch (e) {
							//console.error(e);
							response(null);
						}
					}, //success
					error: function (jqXHR, textStatus, errorThrown) {
						console.error("AJAX Error: ", textStatus, errorThrown);
					},
				}); //ajax
			}, //source
		}, //options
		_renderItem: function (ul, item) {
			return $("<li>")
				.attr("data-value", item.value)
				.append($("<div>").html(item.label))
				.appendTo(ul);
		} //_renderItem
	});
	// INDI
	$("#spouseid, input[id*=pid], input[id*=PID], input[id^=gedcomid], input[id^=rootid], input[id$=ROOT_ID], input[name^=FATHER], input[name^=MOTHER], input[name^=CHIL]").autocompleteRestHtml({
	extraParams: {field: 'INDI', withID: true},
	width: 400,
	minLength: 0
});
	// INDI ASSOciate
	$(".ASSO").autocompleteRestHtml({
	extraParams: {field: 'INDI', withID: true},
	width: 400,
	minLength: 1
});
	// FAM
	$(".FAM, input[id*=famid], #famid").autocompleteRestHtml({
	extraParams: {field:'FAM', withID: true},
	width: 400,
	minLength: 0
});
	// NOTE
	$(".NOTE").autocompleteRestHtml({
	extraParams: {field:'NOTE', withID: true},
	width: 400,
	minLength: 0
});
	// SOUR
	$(".SOUR, input[id*=sid]").autocompleteRestHtml({
	extraParams: {field:'SOUR', withID: true},
	width: 400,
	minLength: 0
});
	// SOUR:TITL
	$("#TITL").autocompleteRestHtml({
	extraParams: {field: 'SOUR_TITL'},
	width: 400,
	minLength: 0
});
	// SOUR*:PAGE*
	/*
	$("input[id^=PAGE]").autocompleteRestHtml({
		extraParams: {
			field: 'SOUR_PAGE',
		},
		width: 400,
		minLength: 0
	});
	// *SOUR:*PAGE
	$("input[id$=PAGE]").autocompleteRestHtml({
		extraParams: {
			field: 'SOUR_PAGE',
		},
		width: 400,
		minLength: 0
	});
	// Reset PAGE autocomplete cache when SOUR is changed
	$("input[id^=SOUR]").change( function() { $("input[id^=PAGE]").flushCache(); } );
	$("input[id$=SOUR]").change( function() { $("input[id$=PAGE]").flushCache(); } );
	*/
	// REPO
	$(".REPO, #REPO").autocompleteRestHtml({
	extraParams: {field:'REPO', withID: true},
	width: 400,
	minLength: 0
});
	// REPO:NAME
	/*$("#NAME").autocompleteRestHtml({
		extraParams: {field: 'REPO_NAME'},
		width: 400,
		minLength: 0
	});*/
	// OBJE
	$(".OBJE, #OBJE, #mediaid, #filter").autocompleteRestHtml({
	extraParams: {field:'OBJE', withID: true},
	width: 400,
	minLength: 0
});
	// INDI or FAM or SOUR or REPO or OBJE
	$("input[id$=privacy_access_ID], input[name^=gid], #cart_item_id").autocompleteRestHtml({
	extraParams: {field:'IFSRO', withID: true},
	width: 400,
	minLength: 2
});
	// PLAC : full [City, County, State/Province, Country]
	$(".PLAC, #place, input[id=place], input[name*=PLACS], input[name*=PLAC3], input[name^=PLAC], input[name$=PLAC]").autocompleteRestHtml({
	extraParams: {field:'PLAC'},
	width: 400,
	minLength: 2
}); /* .result(function(event, data, val){
		if (data[1] != undefined && data[1] != "0"){
					$('tr[id^="LATI"]').show();
			$('tr[id^="LONG"]').show();
			$('input[id^="LATI"]').val(data[1]).trigger('blur');
						$('input[id^="LONG"]').val(data[2]).trigger('blur');
		}
		}); */
	// PLAC : splitted (mainly for search.php)
	$("input[name=place], input[id=birthplace], input[id=marrplace], input[id=deathplace]").autocompleteRestHtml({
	extraParams: {
	field:'PLAC',
	option:'split'
},
	width: 300,
	minLength: 2
});
	// INDI:BURI:CEME
	$("input[id^=CEME]").autocompleteRestHtml({
	extraParams: {field:'INDI_BURI_CEME'},
	width: 300,
	minLength: 2
});
	// GIVN
	$("#GIVN, input[name*=GIVN], input[name*=firstname]").autocompleteRestHtml({
	extraParams: {field:'GIVN'},
	minLength: 1
});
	// SURN
	$("#SURN, input[name*=SURN], input[name*=lastname]").autocompleteRestHtml({
	extraParams: {field:'SURN'},
	width: 300,
	minLength: 1
});
	// NAME
	$("#NAME, input[id=name]").autocompleteRestHtml({
	extraParams: {field:'NAME'},
	width: 300,
	minLength: 2
});
	// NPFX
	var npfx_accept = new Array(<?php if (isset($NPFX_accept)) foreach ($NPFX_accept as $k => $v) echo "'", $v, "', "; echo "''";?>);
	$("#NPFX").autocomplete({
	source : npfx_accept,
	minLength: 0
});
	// SPFX
	var spfx_accept = new Array(<?php if (isset($SPFX_accept)) foreach ($SPFX_accept as $k => $v) echo "'", $v, "', "; echo "''";?>);
	$("#SPFX").autocomplete({source: spfx_accept,
	minLength: 0
});
	// NSFX
	var nsfx_accept = new Array(<?php if (isset($NSFX_accept)) foreach ($NSFX_accept as $k => $v) echo "'", $v, "', "; echo "''";?>);
	$("#NSFX").autocomplete({source: nsfx_accept,
	minLength: 0
});
	// FILE_FORM
	var file_form_accept = new Array(<?php if (isset($FILE_FORM_accept)) foreach ($FILE_FORM_accept as $k => $v) echo "'", $v, "', "; echo "''";?>);
	$("#FILE_FORM").autocomplete({source: file_form_accept,
	minLength: 0
});
});
</script>
