<?php
/**
 * Turkish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2019  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Kurt Norgaz
 * @author Adem GENÇ uzayuydu@gmail.com http://www.muttafi.com
 * @version $Id: admin.tr.php 7307 2021-07-11 11:22:17Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["analytics_config"]		= "Web Analizi";
$pgv_lang["google_analytics"]		= "Google Analizi";
$pgv_lang["USE_GOOGLE_ANALYTICS"]	= "Google Analizi aktiflestir?";
$pgv_lang["PGV_GOOGLE_ANALYTICS"]	= "Google Analizi hesap numarasi";
$pgv_lang["piwik_analytics"]		= "Matomo Analizi";
$pgv_lang["USE_PIWIK_ANALYTICS"]	= "Matomo Analizi aktiflestir?";
$pgv_lang["PGV_PIWIK_URL"]			= "Matomo Analizi sunucu URL";
$pgv_lang["PGV_PIWIK_SITE"]			= "Matomo Analizi site numarasi";
$pgv_lang["clustrmaps_analytics"]	= "ClustrMaps Analizi";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS"] = "ClustrMaps Analizi aktiflestir?";
$pgv_lang["PGV_CLUSTRMAPS_SITE"] 	= "PhpGedView URL";
$pgv_lang["PGV_CLUSTRMAPS_SERVER"] 	= "ClustrMaps sunucu numarasi";

$pgv_lang["module_admin"]			= "Modül Yönetimi";
$pgv_lang["mod_admin_installed"]	= "Kurulan Modüller";
$pgv_lang["mod_admin_tabs"]			= "Yönetim Sekmeleri";
$pgv_lang["mod_admin_menus"]		= "Yönetim Menüleri";
$pgv_lang["mod_admin_intro"]		= "Asagida PhpGedView'in bu örneginde kurulan tüm modüllerin listesidir. Modüller <i>modules</i> klasöre yerlestirilerek kurulur. Burada her bir modül için GEDCOM basina erisim düzeyini ayarlayabilirsiniz. Eger bir modül tek safa için sekmeleri veya menü çubugu için menü içeriyorsa ayni zamanda erisim düzeyi ve bunlarin her birinin sirasini ayarlayabilirsiniz.";
$pgv_lang["mod_admin_active"]		= "Aktif";
$pgv_lang["mod_admin_name"]			= "Modül Adi";
$pgv_lang["mod_admin_description"]	= "Açiklama";
$pgv_lang["mod_admin_version"]		= "PGV / Versiyon";
$pgv_lang["mod_admin_hastab"]		= "Sekme?";
$pgv_lang["mod_admin_hasmenu"]		= "Menü?";
$pgv_lang["mod_admin_access_level"]	= "Erisim Düzeyi";
$pgv_lang["mod_admin_order"]		= "Sira";
$pgv_lang["mod_admin_config"]		= "Mod Ayarlari";
$pgv_lang["mod_admin_settings"]		= "Modül Yapilandirma Ayarlari";
$pgv_lang["ret_module_admin"]		= "Modül Yönetim sayfasina dön";
$pgv_lang["ret_admin"]				= "Yönetim sayfasina dön";

$pgv_lang["enter_comment"]	= "Buraya yorum girebilirsiniz.";
$pgv_lang["upload_a_gedcom"] 		= "GEDCOM Dosya Yükle";
$pgv_lang["start_entering"] 		= "Veri girmeye basla";
$pgv_lang["add_gedcom_from_path"] 	= "Yerel dosyadan GEDCOM Dosya ekle";
$pgv_lang["get_started_instructions"]	= "PhpGedView kullanarak baslamak için asagidaki seçeneklerden birini seçin";

$pgv_lang["admin_users_exists"]		= "Asagida yönetici kullanicilar zaten mevcut:";
$pgv_lang["install_step_1"] = "Ortam Kontrolu";
$pgv_lang["install_step_2"] = "Veritabani Baglantisi";
$pgv_lang["install_step_3"] = "Tablolar Olustur";
$pgv_lang["install_step_4"] = "Site Yapilandirmasi";
$pgv_lang["install_step_5"] = "Lisanlar";
$pgv_lang["install_step_6"] = "Yapilandirmayi Kaydet";
$pgv_lang["install_step_7"] = "Yönetici olustur";
$pgv_lang["install_wizard"] = "Kurulum Sihirbazi";
$pgv_lang["basic_site_config"] = "Temel Ayarlar";
$pgv_lang["adv_site_config"] = "Gelismis Ayarlar";
$pgv_lang["config_not_saved"] = "*Ayarlariniz 6. adima<br /> kadar kaydedilmeyecektir";
$pgv_lang["download_config"] = "config.php indir";
$pgv_lang["site_unavailable"] = "Site su anda kullanilamiyor";
$pgv_lang["to_manage_users"] = "Kullanicilari yönetmek için <a href=\"useradmin.php\">Kullanici Yönetimi</a> sayfasini kullanin.";
$pgv_lang["db_tables_created"] = "Veritabani tablolari basariyla olusturuldu";
$pgv_lang["config_saved"] = "Yapilandirma basariyla kaydedildi";
$pgv_lang["checking_errors"]		= "Hatalar için kontrol et...";
$pgv_lang["checking_php_version"]		= "Gerekli PHP versiyonu denetleniyor:";
$pgv_lang["failed"]		= "Basarisiz";
$pgv_lang["pgv_requires_version"]		= "PhpGedView PHP sürüm #PGV_REQUIRED_PHP_VERSION# veya üstü gerektirir.";
$pgv_lang["using_php_version"]		= "PHP sürüm #PGV_ACTUAL_PHP_VERSION# kullaniyorsaniz";
$pgv_lang["checking_db_support"]		= "En az veritabani destegi için denetleniyor:";
$pgv_lang["no_db_extensions"]		= "Desteklenen veritabani uzantilarinin herhangi biri yok.";
$pgv_lang["db_ext_support"]		= "#DBEXT# desteginiz var";
$pgv_lang["checking_config.php"]		= "config.php denetleniyor:";
$pgv_lang["config.php_missing"]		= "config.php dosya bulunamadi.";
$pgv_lang["config.php_missing_instr"]		= "Bu kurulum sihirbazi config.php dosyasina ayarlarinizi yazamayacaktir.  config.php dosyasini yeniden adlandirip config.dist diye bir kopyasini yapabilirsiniz.  Bu sihirbazi sirayla degistirip tamamladiginda size indirmeniz için seçenek verecektir ve sonuçlanan config.php dosyayi yükleyebilirsini.";
$pgv_lang["config.php_not_writable"]		= "config.php yazilabilir degil.";
$pgv_lang["config.php_not_writable_instr"]		= "Bu kurulum sihirbazi config.php dosyasina ayarlarinizi yazamayacaktir. Dosyaniza siz izinleri yazabilirsiniz yada kurulum sihirbazi tamamlandiktan sonra config.php dosyanizi indirme seçenegi verecektir ve config.php dosyayi sunucunuza yüklemeniz gerekir.";
$pgv_lang["passed"]		= "Geçti";
$pgv_lang["config.php_writable"]		= "config.php mevcut ve yazilabilir.";
$pgv_lang["checking_warnings"]		= "Uyarilari için denetleniyor ...";
$pgv_lang["checking_timelimit"]		= "Degistirme zaman sinirinin yetenegi için denetleniyor:";
$pgv_lang["cannot_change_timelimit"]		= "Zaman siniri degistirilemiyor.";
$pgv_lang["cannot_change_timelimit_instr"]		= "Birçok birey ile büyük veritabanlari tüm fonksiyonlari çalistirmak mümkün olmayabilir.";
$pgv_lang["current_max_timelimit"]		= "En fazla zaman siniriniz";
$pgv_lang["check_memlimit"]		= "Degistirme bellek sinirin yetenegi için denetleniyor:";
$pgv_lang["cannot_change_memlimit"]		= "Bellek siniri degistirilemiyor.";
$pgv_lang["cannot_change_memlimit_instr"]		= "Birçok bireyler ile büyük veritabanlari tüm fonksiyonlari çalistirmak mümkün olmayabilir.";
$pgv_lang["current_max_memlimit"]		= "Geçerli bellek siniriniz";
$pgv_lang["check_upload"]		= "Dosyalari yükleme yeterlilik için kontrol et:";
$pgv_lang["current_max_upload"]		= "En fazla dosya yükleme boyutu:";
$pgv_lang["check_gd"]		= "GD resim kütüphane için kontrol et:";
$pgv_lang["cannot_use_gd"]		= "GD resim kütüphanesi yoktur. Tirnak önizlemeleri otomatik olarak olusturmak mümkün olmayacaktir.";
$pgv_lang["check_sax"]		= "SAX XML kütüphanesi için denetleniyor:";
$pgv_lang["cannot_use_sax"]		= "SAX XML kütüphanesi yoktur. Raporlari veya bazi diger yardimci fonksiyonlari herhangi bir çalistirmak mümkün olmayacaktir.";
$pgv_lang["check_dom"]		= "DOM XML kütüphane için kontrol et:";
$pgv_lang["cannot_use_dom"]		= "DOM XML kütüphanesi yoktur. XML disari aktarmak mümkün olmayacaktir.";
$pgv_lang["check_calendar"]		= "Gelismis Takvim kütüphanesi için kontrol et:";
$pgv_lang["cannot_use_calendar"]		= "Gelismis takvim destegi yok. Bazi gelismis takvim fonksiyonlari çalistirmak mümkün olmayacaktir.";
$pgv_lang["warnings_passed"]		= "Tüm uyari kontrolleri geçti.";
$pgv_lang["warning_instr"]		= "Eger herhangi bir uyari yokmus gibi geçirirseniz PhpGedView bu sunucuda çalistirmak mümkün olabilir ancak bazi islevler devre disi olabilir veya düsük performansla karsilasabilirsiniz.";

$pgv_lang["associated_files"]		= "Ortak olan dosyalar:";
$pgv_lang["remove_all_files"]		= "Tüm gerekli olmayan dosyalari kaldir";
$pgv_lang["warn_file_delete"]		= "Bu dosya dil ayarlari veya veri degisikligi bekleyen gibi önemli bilgiler içermektedir. Bu dosyayi silmek istediginizden emin misiniz?";
$pgv_lang["deleted_files"]          = " Silinen dosyalar:";
$pgv_lang["index_dir_cleanup_inst"]	= "Index klasöründen dosya veya alt-klasöru silmek için onu çöp kutusuna sürükle veya kutuyu seç. Kalici olarak kaldirmak için Sil butona basin. <br /><br /><img src=\"./images/RESN_confidential.gif\" /> ile isaretlenen dosyalar uygun çalisma için gereklidir ve kaldirilamazlar.<br /> <img src=\"./images/RESN_locked.gif\" /> ile isaretlenen dosyalar önemli dosyalar veya degistirilmis bunu silmek için gerekli izinleri verip silmek istediginizden emin olup silebilirsiniz.";
$pgv_lang["index_dir_cleanup"]		= "Index dizini temizle";
$pgv_lang["clear_cache_succes"]		= "Önbellek dosyalari kaldirilmistir.";
$pgv_lang["clear_cache"]			= "Önbellek dosyalarini temiz";
$pgv_lang["sanity_err0"]			= "Hatalar:";
$pgv_lang["sanity_err1"]			= "PHP sürüm #PGV_REQUIRED_PHP_VERSION# veya daha yüksek olmasi gerekir.";
$pgv_lang["sanity_err2"]			= "Dosya ya da dizin <i>#GLOBALS[whichFile]#</i> mevcut degil. Lütfen dosya veya dizinin mevcut olup, yanlis adlandirilmis olmadigini ve okuma izinleri dogru ayarlandigini dogrulayin.";
$pgv_lang["sanity_err3"]			= "Dosya <i>#GLOBALS[whichFile]#</i> dogru bir sekilde yüklenmedi. Dosyayi tekrar yüklemeyi deneyin.";
$pgv_lang["sanity_err4"]			= "Dosya <i>config.php</i> bozuk.";
$pgv_lang["sanity_err5"]			= "<i>config.php</i> dosya yazilabilir degil.";
$pgv_lang["sanity_err6"]			= "<i>#GLOBALS[INDEX_DIRECTORY]#</i> dizin yazilabilir degil.";
$pgv_lang["sanity_warn0"]			= "Uyarilar:";
$pgv_lang["sanity_warn1"]			= "<i>#GLOBALS[MEDIA_DIRECTORY]#</i> dizin yazilabilir degil. Medya dosyalarini yükleme veya PhpGedView içinde tirnak önizleme olusturmak mümkün olmayacaktir.";
$pgv_lang["sanity_warn2"]			= "<i>#GLOBALS[MEDIA_DIRECTORY]#thumbs</i> dizin yazilabilir degil. Tirnak önizleme yükleme veya PhpGedView içinde tirnak önizleme olusturmak mümkün olmayacaktir.";
$pgv_lang["sanity_warn3"]			= "GD görüntüleme kütüphanesi mevcut degil. PhpGedView çalismaya devam eder, ancak bazi küçük üretim ve daire diyagrami özellikleri, GD kütüphanesi olmadan ise yaramaz. Daha fazla bilgi için linki tiklayin <a href='http://www.php.net/manual/en/ref.image.php'>http://www.php.net/manual/en/ref.image.php</a>.";
$pgv_lang["sanity_warn4"]			= "XML Ayristirici kütüphanesi mevcut degil. PhpGedView çalismaya devam eder, ancak böyle bir rapor olusturma ve web servisleri gibi bazi özellikleri XML Ayristirici kütüphanesi olmadan çalismaz. Daha fazla bilgi için linki tiklayin <a href='http://www.php.net/manual/en/ref.xml.php'>http://www.php.net/manual/en/ref.xml.php</a>.";
$pgv_lang["sanity_warn5"]			= "DOM XML kütüphanesi mevcut degil. PhpGedView çalismaya devam eder, ancak bazi kupürleri sepeti, indir, ve web hizmetleri Gramps Disari Aktarma özellikleri gibi özellikleri, ise yaramaz. Daha fazla bilgi için linki tiklayin <a href='http://www.php.net/manual/en/ref.domxml.php'>http://www.php.net/manual/en/ref.domxml.php</a>.";
$pgv_lang["sanity_warn6"]			= "Takvim kütüphanesi mevcut degil. PhpGedView çalismaya devam eder, ancak bazi Ibranice veya Fransizca gibi diger takvimler dönüstürme gibi özellikleri, ise yaramaz. PhpGedView çalistirmak için gerekli degildir. Daha fazla bilgi için linki tiklayin <a href='http://www.php.net/manual/en/ref.calendar.php'>http://www.php.net/manual/en/ref.calendar.php</a>.";
$pgv_lang["ip_address"]				= "IP adresi";
$pgv_lang["date_time"]				= "Tarih ve saat";
$pgv_lang["log_message"]			= "Günlük Mesaji";
$pgv_lang["searchtype"]				= "Arama tipi";
$pgv_lang["query"]					= "Sorgu";
$pgv_lang["user"]					= "Onaylanmis kullanici";
$pgv_lang["editors"]				= "Editörler";
$pgv_lang["gedcom_admins"]			= "GEDCOM Yöneticileri";
$pgv_lang["site_admins"]			= "Site Yöneticileri";
$pgv_lang["nobody"]					= "Hiç kimse";
$pgv_lang["thumbnail_deleted"]		= "Tirnak önizleme dosya basariyla silindi.";
$pgv_lang["thumbnail_not_deleted"]	= "Tirnak önizleme dosya silinemedi.";
$pgv_lang["step2"]			= "4. adimin 2. adimi:";
$pgv_lang["refresh"]				= "Tazele";
$pgv_lang["move_file_success"]		= "Medya ve tirnak önizleme dosyalari basariyla tasindi.";
$pgv_lang["media_folder_corrupt"]	= "Medya klasörü bozulmus.";
$pgv_lang["media_file_not_deleted"]	= "Medya dosyasi silinemedi.";
$pgv_lang["gedcom_deleted"] 		= "GEDCOM [#GED#] basariyla silindi.";
$pgv_lang["gedadmin"]				= "GEDCOM yönetici";
$pgv_lang["full_name"]			= "Tam Adi";
$pgv_lang["error_header"]		= "GEDCOM dosyasi, <b>#GEDCOM#</b>, belirtilen yerde mevcut degil.";
$pgv_lang["confirm_delete_file"]	= "Bu dosyayi silmek istediginizden emin misiniz?";
$pgv_lang["confirm_folder_delete"] = "Bu klasörü silmek istediginizden emin misiniz?";
$pgv_lang["confirm_remove_links"]	= "Bu ögenin tüm baglantilari kaldirmak istediginizden emin misiniz?";
$pgv_lang["PRIV_PUBLIC"]			= "Herkese göster";
$pgv_lang["PRIV_USER"]			= "Sadece kullanicilara göster";
$pgv_lang["PRIV_NONE"]			= "Sadece yöneticilere göster";
$pgv_lang["PRIV_HIDE"]			= "Yöneticilerden bile gizle";
$pgv_lang["manage_gedcoms"]		= "GEDCOM Yönetme ve Mahremiyet Düzenleme";
$pgv_lang["keep_media"]				= "Medya linkleri koru";
$pgv_lang["current_links"]			= "Linkler";
$pgv_lang["add_more_links"]			= "Linkler ekle";
$pgv_lang["enter_pid_or_name"]		= "Birey ID yada adi girin";
$pgv_lang["set_links"]				= "Linkleri ayarla";
$pgv_lang["add_or_remove_links"]	= "Linkleri yönet";

$pgv_lang["keep"]					= "Koru";
$pgv_lang["unlink"]					= "Linksiz";
$pgv_lang["nav"]					= "Navigasyon";
$pgv_lang["fam_nav"]				= "Aile Navigasyonu";
$pgv_lang["remove"]					= "Kaldir";
$pgv_lang["keep_link"]				= "Listede Linki koru";
$pgv_lang["remove_link"]			= "Listeden Linki kaldir";
$pgv_lang["open_nav"]				= "Açik Aile Navigasyonu";
$pgv_lang["link_exists"]			= "Bu link zaten mevcut";
$pgv_lang["id_not_valid"]			= "Birey, Aile yada Kaynak ID geçerli degil";
$pgv_lang["add_fam_other_links"]	= "Aile Ekle, ve Linkleri ara";
$pgv_lang["search_add_links"]		= "Linkler listesine Eklemek için eklenecek Kisi için ara.";
$pgv_lang["enter_name"]				= "Bir ad girin";
$pgv_lang["add_indi_to_link_list"]	= "Link Listesine Eklemek için eklenecek kisi Adini tikla.";
$pgv_lang["click_choose_head"]		= "Ailenin Reisi olarak seçilecek #GLOBALS[tempStringHead]# kisiyi tiklayin.";
$pgv_lang["click_choose_head_text"]	= "Ailenin Reisi olarak seçilecek kisiyi tiklayin.";
$pgv_lang["head"]					= "Reis";
$pgv_lang["id_empty"]				= "Bir link eklenirken ID alani bos geçilemez.";
$pgv_lang["link_deleted"]			= "#GLOBALS[remLinkId]# için link silindi";
$pgv_lang["link_added"]				= "#GLOBALS[addLinkId]# için link eklendi";
$pgv_lang["no_update_CHANs"]		= "CHAN (Son Degisiklik) kayitlarini güncellestirme hayir";
$pgv_lang["no_CHANs_update"]		= "CHAN (Son Degisiklik) kayitlarini güncellenmedi";

$pgv_lang["files_in_backup"]		= "Bu yedeklemede içeren dosyalar";
$pgv_lang["created_remotelinks"]	= "<i>Uzak linkler</i> tablosu basariyla olusturuldu.";
$pgv_lang["created_remotelinks_fail"] 	= "<i>Uzak linkler</i> tablosu olusturulamadi.";
$pgv_lang["created_indis"]			= "<i>Bireyler</i> tablosu basariyla olusturuldu.";
$pgv_lang["created_indis_fail"] 	= "<i>Bireyler</i> tablo olusturulamadi.";
$pgv_lang["created_fams"]			= "<i>Aileler</i> tablo basariyla olusturuldu.";
$pgv_lang["created_fams_fail"]		= "<i>Aileler</i> tablosu olusturulamadi.";
$pgv_lang["created_sources"]		= "<i>Kaynaklar</i> tablosu basariyla olusturuldu.";
$pgv_lang["created_sources_fail"]	= "<i>Kaynaklar</i> tablosu olusturulamadi.";
$pgv_lang["created_other"]			= "<i>Diger</i> tablosu basariyla olusturuldu.";
$pgv_lang["created_other_fail"] 	= "<i>Diger</i> tablosu olusturulamadi.";
$pgv_lang["created_places"] 		= "<i>Yerler</i> tablosu basariyla olusturuldu.";
$pgv_lang["created_places_fail"]	= "<i>Yerler</i> tablosu olusturulamadi.";
$pgv_lang["created_placelinks"] 	= "<i>Yer linkleri</i> tablosu basariyla olusturuldu.";
$pgv_lang["created_placelinks_fail"]	= "<i>Yer linkleri</i> tablosu olusturulamadi.";
$pgv_lang["created_media_fail"]	= "<i>Medya</i> tablosu olusturulamadi.";
$pgv_lang["created_media_mapping_fail"]	= "<i>Medya Haritalari</i> tablosu olusturulamadi.";
$pgv_lang["no_thumb_dir"]			= "tirnak önizleme dizini mevcut degil ve olusturulamaz.";
$pgv_lang["folder_created"]		= "Dizin olusturuldu";
$pgv_lang["folder_no_create"]		= "Dizin olusturulamadi";
$pgv_lang["security_no_create"]		= "Güvenlik Uyarisi: <b><i>index.php</i></b> dosya olusturulamad ";
$pgv_lang["security_not_exist"]		= "Güvenlik Uyarisi: <b><i>index.php</i></b> dosya mevcut degil ";
$pgv_lang["label_delete"]           	= "Sil";
$pgv_lang["progress_bars_info"]			= "Asagidaki durum çubuklari içeri aktarim durumunu gösterecektir. Eger zaman asimina ugrarsa içeri aktarim durdurulur ve <b>Devam</b> butonu göreceksiniz. Eger  <b>Devam</b> butonu göremezseniz daha küçük zaman siniri ile içeri aktarmaya yeniden baslatmalisiniz.";
$pgv_lang["upload_replacement"]			= "Yenisini Yükle";
$pgv_lang["about_user"]			= "Önce ana yönetici olusturmaniz gerekir. Bu kullanici yapilandirma dosyalari güncellemek, özel veriyi görüntüleme, ve diger kullanicilari olusturmak için ayricaliklari olan kisidir.";
$pgv_lang["access"]						= "Erisim";
$pgv_lang["add_gedcom"]			= "GEDCOM ekle";
$pgv_lang["add_new_gedcom"]		= "Yeni bir GEDCOM olustur";
$pgv_lang["add_new_language"]		= "Yeni bir lisan için dosyalari ve ayarlari ekle";
$pgv_lang["add_user"]					= "Yeni bir kullanici ekle";
$pgv_lang["admin_gedcom"]		= "Yönetici GEDCOM";
$pgv_lang["admin_gedcoms"]		= "GEDCOM yönetmek için burayi tiklayin";
$pgv_lang["admin_geds"]					= "Veri ve GEDCOM yönetimi";
$pgv_lang["admin_info"]					= "Bilgilendirme";
$pgv_lang["admin_site"]					= "Site yönetimi";
$pgv_lang["admin_user_warnings"]		= "Bir veya daha fazla hesaplar var uyarilari";
$pgv_lang["admin_verification_waiting"] = "Kullanici hesaplari yöneticinin onayi bekliyor";
$pgv_lang["administration"]		= "Yönetim";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]		= "GEDCOM geçis izni";
$pgv_lang["ALLOW_USER_THEMES"]		= "Kullanici kendi temasini seçme izni";
$pgv_lang["ansi_encoding_detected"] 	= "ANSI kodlanmis dosya algilandi. PhpGedView UTF-8 olarak kodlanmis dosyalari ile daha iyi çalisir.";
$pgv_lang["ansi_to_utf8"]		= "Bu ANSI kodlanmis GEDCOM UTF-8 biçime dönüstürme?";
$pgv_lang["apply_privacy"]				= "Mahremiyet ayarlari uygula?";
$pgv_lang["back_useradmin"]				= "Kullanici Yönetimine geri dön";
$pgv_lang["bytes_read"]			= "Okunan bayt:";
$pgv_lang["can_admin"]					= "Yöneticilik yapabilir";
$pgv_lang["can_edit"]					= "Erisim düzeyi";
$pgv_lang["change_id"]					= "Birey ID degistir:";
$pgv_lang["choose_priv"]				= "Mahremiyet düzeyi seçin:";
$pgv_lang["cleanup_places"]		= "Yerleri Temizle";
$pgv_lang["cleanup_users"]				= "Kullanicilari Temizle";
$pgv_lang["click_here_to_continue"]		= "Devam etmek için buraya tikla.";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "Soy agacina gitmek için burayi tiklayin.";
$pgv_lang["comment"]							= "Kullanici hakkinda yönetici yorumlari";
$pgv_lang["comment_exp"]						= "Tarihte yöneiciyi uyar";
$pgv_lang["config_help"]						= "Yapilandirma yardimi";
$pgv_lang["config_still_writable"]				= "<i>config.php</i> dosyaniz hala yazilabilirdir. Güvenlik için bu dosyanin izinleri sitenizin yapilandirilmasi bittikten sonra sadece-okuma ayarlamalisiniz.";
$pgv_lang["configuration"]		= "Yapilandirma";
$pgv_lang["configure"]							= "PhpGedView Yapilandir";
$pgv_lang["configure_head"]						= "PhpGedView Yapilandirma";
$pgv_lang["confirm_gedcom_delete"]				= "Bu GEDCOM silmek istediginizden emin misiniz";
$pgv_lang["confirm_user_delete"]	= "Kullaniciyi silmek istediginizden emin misiniz";
$pgv_lang["create_user"]		= "Kullanici olustur";
$pgv_lang["current_users"]						= "Kullanici Listesi";
$pgv_lang["daily"]								= "Günlük";
$pgv_lang["dataset_exists"]		= "Bu dosya adi ile GEDCOM veritabanina zaten içeri aktarilmistir.";
$pgv_lang["unsync_warning"] 					= "Bu GEDCOM dosyasi veritabani ile senkronize <em>degil</em>. Veriniz son versiyon içermiyor. Dosya yerine veritabanindan tekrar içeri aktarmak için indirmek ve yeniden yüklemek gerekir.";
$pgv_lang["date_registered"]					= "Üyelik tarihi";
$pgv_lang["day_before_month"]		= "Aydan önce gün (GG AA YYYY)";
$pgv_lang["DEFAULT_GEDCOM"]						= "Varsayilan GEDCOM";
$pgv_lang["default_user"]						= "Varsayilan yönetici olustur.";
$pgv_lang["del_gedrights"]						= "GEDCOM artik aktif degil, kullanici referanslari kaldir.";
$pgv_lang["del_proceed"]						= "Devam";
$pgv_lang["del_unvera"]							= "Yönetici kullaniciyi onaylamadi.";
$pgv_lang["del_unveru"]							= "Kullanici 7 gün içinde onaylamadi.";
$pgv_lang["do_not_change"]		= "Degisiklik yok";
$pgv_lang["download_gedcom"]		= "GEDCOM Indir";
$pgv_lang["download_here"]						= "Dosyayi indirmek için buraya tiklayin.";
$pgv_lang["download_note"]						= "<b>Not:</b> Büyük veritabanlari indirme vermeden önce uzun bir zaman islem yapabilir. Eger PHP zaman asimi uygularsa indirme bitmeden önce indirilen veritabani dosyasi tam olmayabilir.<br /><br /> Dosya dogru olarak indirildiginden emin olmak için GEDCOM biçiminde indiriyorsaniz son satirinda <b>0&nbsp;TRLR</b> oldugunu kontrol edin, yada XML biçiminde indiriyorsaniz son satirinda <b>&lt;/database&gt;</b> oldugunu kontrol edin. <br /><br />Bu dosyalar metindir siz herhangi bir uygun metin editörü kullanarak açabilir içerigini görebilirsiniz. Indirdiginiz dosyalari kontrol için açtiginizda kesinlikle <b><u>kaydetmeyin</u></b> dosyaniz bozulabilir.<br /><br /> Genelde GEDCOM dosya indirildiginde uzun zaman aliyorsa içeri aktarirken de uzun zaman alabilir.";
$pgv_lang["editaccount"]		= "Bu hesap bilgileri düzenlemek için bu kullaniciya izin ver";
$pgv_lang["empty_dataset"]		= "Eski verileri silmek ve bu yeni veri ile degistirmek istiyor musunuz?";
$pgv_lang["empty_lines_detected"]	= "GEDCOM dosyanizda bos satirlar belirlendi. Temizlendiginde bu bos satirlar kaldirilacak.";
$pgv_lang["enable_disable_lang"]				= "Desteklenen lisanlari yapilandir";
$pgv_lang["error_ban_server"]       			= "Geçersiz IP adresi.";
$pgv_lang["error_delete_person"]   				= "Uzak baglantili silmek istediginiz kisiyi seçmelisiniz.";
$pgv_lang["error_header_write"] 	= "GEDCOM dosyasi <b>#GEDCOM#</b> yazilabilir degil. Nitelikleri ve erisim izinlerini kontrol edin.";
$pgv_lang["error_remove_site"]					= "Uzak sunucu kaldirilamadi.";
$pgv_lang["error_remove_site_linked"]			= "Uzak sunucu baglantilari listesi bos olmadigindan kaldirilamadi.";
$pgv_lang["error_remote_duplicate"]				= "Bu uzak veritabani <i>#GLOBALS[whichFile]#</i> olarak listede zaten kullanimda";
$pgv_lang["error_siteauth_failed"]				= "Uzak site kimlik dogrulamasi basarisiz";
$pgv_lang["error_url_blank"]					= "Lütfen uzak site basligi veya URL bos birakmayin";
$pgv_lang["error_view_info"]       				= "Bilgilerini görüntülemek istediginiz kisiyi seçmelisiniz.";
$pgv_lang["example_date"]		= "Sizin GEDCOM'da geçersiz tarih örnegi:";
$pgv_lang["example_place"]						= "Sizin GEDCOM'da geçersiz yer örnegi:";
$pgv_lang["fbsql"]								= "FrontBase";
$pgv_lang["found_record"]		= "Kayit bulundu";
$pgv_lang["ged_download"]						= "Indir";
$pgv_lang["ged_import"]			= "Içeri aktar";
$pgv_lang["ged_export"] 						= "Disari aktar";
$pgv_lang["ged_check"] 							= "Kontrol et";
$pgv_lang["gedcom_adm_head"]					= "GEDCOM Yönetimi";
$pgv_lang["gedcom_config_write_error"]	= "H A T A !!!<br /><i>#GLOBALS[whichFile]#</i> dosyasina yazilamadi. Lütfen gerekli yazma izinlerini denetleyin.";
$pgv_lang["gedcom_downloadable"]	= "Bu GEDCOM dosyasi internet üzerinden indirilebilir!<br />Bu sorunu gidermek için <a href=\"readme.txt\"><b>readme.txt</b></a> GÜVENLIK bölümüne bakin.";
$pgv_lang["gedcom_file"]		= "GEDCOM Dosya:";
$pgv_lang["gedcom_not_imported"]				= "Bu GEDCOM henüz içeri aktarimadi.";
$pgv_lang["ibase"]								= "InterBase";
$pgv_lang["ifx"]								= "Informix";
$pgv_lang["img_admin_settings"] 				= "Resim Manipülasyon Yapilandirmayi Düzenle";
$pgv_lang["autoContinue"]						= "Otomatikman bas «Devam» butona";
$pgv_lang["import_complete"]		= "Içerik aktarim tamamlandi";
$pgv_lang["import_options"]						= "Içeri Aktarma Seçenekleri";
$pgv_lang["import_progress"]		= "Içeri Aktarma Ilerleme...";
$pgv_lang["import_statistics"]					= "Içeri Aktarma Istatistikleri";
$pgv_lang["import_time_exceeded"]				= "Yürütme zaman sinirina ulasildi. GEDCOM dosya içeri aktarma islemin devam ettirmek için Devam butonu tiklayin.";
$pgv_lang["inc_languages"]		= "Lisanlar";
$pgv_lang["INDEX_DIRECTORY"]		= "Index dosya dizini";
$pgv_lang["invalid_dates"]		= "Saptanan geçersiz tarih biçimleri. temizlendiginde GG AAA YYYY (ör. 1 OCAK 2004) biçiminde degistirilmi olacak.";
$pgv_lang["BOM_detected"] 						= "Bir Bayt Sirasi Isareti (BOM) dosyanin basinda algilandi. Temizlendiginde bu özel kod kaldirilacaktir.";
$pgv_lang["invalid_header"] 					= "GEDCOM basligindan önce algilan satirlar <b>0&nbsp;HEAD</b>. Temizlendiginde bu satirlar kaldirilacaktir.";
$pgv_lang["label_added_servers"]				= "Uzak Sunucular";
$pgv_lang["label_banned_servers"]  				= "IP ile Siteleri Yasakla";
$pgv_lang["label_families"]         			= "Aileler";
$pgv_lang["label_gedcom_id2"]       			= "Veritabani ID:";
$pgv_lang["label_individuals"]      			= "Bireyler";
$pgv_lang["label_manual_search_engines"]		= "Elle IP ile Arama Motorlarini isaretle";
$pgv_lang["label_new_server"]     				= "Yeni site ekle";
$pgv_lang["label_password_id"]					= "Sifre";
$pgv_lang["label_server_info"]     				= "Uzak siteden baglanan tüm kisiler ve aileler:";
$pgv_lang["label_server_url"]       			= "Site URL/IP";
$pgv_lang["label_username_id"]					= "Kullanici adi";
$pgv_lang["label_view_local"]       			= "Kisinin yere bilgisini görüntüle";
$pgv_lang["label_view_remote"]     			 	= "Kisinin uzak site bilgisini görüntüle";
$pgv_lang["LANG_SELECTION"] 					= "Desteklenen lisanlar";
$pgv_lang["LANGUAGE_DEFAULT"]					= "Sitenizi destekleyecek lisanlari yapilandirmadiniz.<br />PhpGedView varsayilan eylemlerini kullanir.";
$pgv_lang["last_login"]							= "Son giris";
$pgv_lang["lasttab"]							= "Birey Için Son Ziyaretindeki Sekme";
$pgv_lang["leave_blank"]						= "Eger geçerli sifrenizi kullanmaya devam ediyorsaniz sifre alanlari bos geçin.";
$pgv_lang["link_manage_servers"]   				= "Siteleri Yönet";
$pgv_lang["logfile_content"]		= "Günlük dosyanin içerigi";
$pgv_lang["macfile_detected"]					= "Macintosh dosya algilandi. Temizlendiginde dosyaniz bir DOS dosyaya dönüstürülecek.";
$pgv_lang["mailto"]								= "Mailto link";
$pgv_lang["merge_records"]		= "Kayitlari birlestir";
$pgv_lang["message_to_all"]						= "Tüm kullanicilara mesaj gönder";
$pgv_lang["messaging"]							= "PhpGedView dahili mesajlasma";
$pgv_lang["messaging2"]							= "Emailler ile dahili mesajlasma";
$pgv_lang["messaging3"]							= "Email";
$pgv_lang["month_before_day"]		= "Günde önce ay (AA GG YYYY)";
$pgv_lang["monthly"]							= "Aylik";
$pgv_lang["msql"]								= "Küçük SQL";
$pgv_lang["mssql"]								= "Microsoft SQL sunucu";
$pgv_lang["mysql"]								= "MySQL";
$pgv_lang["never"]								= "Simdilik yok";
$pgv_lang["no_logs"]							= "Günlük tutma devredisi";
$pgv_lang["no_messaging"]						= "Irtibat metodu yok";
$pgv_lang["oci8"]								= "Kahin 7+";
$pgv_lang["page_views"]							= "&nbsp;&nbsp;sayfa görüntüleme&nbsp;&nbsp;";
$pgv_lang["performing_validation"]				= "GEDCOM dogrulama yapiliyor...";
$pgv_lang["pgsql"]								= "PostgreSQL";
$pgv_lang["pgv_config_write_error"] 			= "Hata!! PhpGedView yapilandirma dosyasina yazamiyor. Lütfen dosya ve dizin izinlerini kontrol edip tekrar deneyin.";
$pgv_lang["PGV_MEMORY_LIMIT"]					= "Bellek siniri";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Oturum kaydetme yolu";
$pgv_lang["PGV_SESSION_TIME"]		= "Oturum zaman asimi";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Harici emailler basit email basliklarini kullanin.";
$pgv_lang["PGV_SMTP_ACTIVE"] 					= "Harici emailleri göndermek için SMTP kullan";
$pgv_lang["PGV_SMTP_HOST"] 						= "Giden sunucu (SMTP) adi";
$pgv_lang["PGV_SMTP_HELO"] 						= "Gönderen domain adi";
$pgv_lang["PGV_SMTP_PORT"] 						= "SMTP Portu";
$pgv_lang["PGV_SMTP_AUTH"] 						= "Adi ve sifre kullan";
$pgv_lang["PGV_SMTP_AUTH_USER"] 				= "Kullanici adi";
$pgv_lang["PGV_SMTP_AUTH_PASS"] 				= "Sifre";
$pgv_lang["PGV_SMTP_SSL"] 						= "Güvenli baglanti";
$pgv_lang["PGV_SMTP_FROM_NAME"] 				= "Gönderen adi";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Çevrimiçi mesajlari sunucuya kaydet";
$pgv_lang["phpinfo"]							= "PHP bilgisi";
$pgv_lang["place_cleanup_detected"] 			= "Geçersiz yer kodlamalari algilandi. Bu hatalar düzeltilmelidir.";
$pgv_lang["please_be_patient"]		= "Lütfen sabirli olun";
$pgv_lang["privileges"]							= "Ayricaliklar";
$pgv_lang["reading_file"]		= "GEDCOM dosyasi okunuyor";
$pgv_lang["readme_documentation"]	= "BENIOKU belgeleri";
$pgv_lang["remove_ip"] 							= "IP Kaldir";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Yeni kullanicilari yönetici onaylar";
$pgv_lang["review_readme"]		= "PhpGedView yapilandirmak için önce <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> dosyasi gözden geçirilmelidir.<br /><br />";
$pgv_lang["seconds"]							= "&nbsp;&nbsp;ikincileri";
$pgv_lang["select_an_option"]		= "Asagidaki seçeneklerden birini seçin:";
$pgv_lang["SERVER_URL"]			= "PhpGedView URL";
$pgv_lang["show_phpinfo"]						= "PHP bilgi sayfasini göster";
$pgv_lang["siteadmin"]							= "Site yöneticisi";
$pgv_lang["sqlite"]								= "SQLite";
$pgv_lang["sybase"]								= "Sybase";
$pgv_lang["sync_gedcom"]						= "GEDCOM veri ile Kullanici Ayarlarini senkronize et";
$pgv_lang["system_time"]						= "Geçerli Sunucu Zamani: ";
$pgv_lang["user_time"]							= "Gerçerli Kullanici Zamani: ";
$pgv_lang["TBLPREFIX"]							= "Veritabani Tablo Öneki";
$pgv_lang["themecustomization"]					= "Tema Özellestirme";
$pgv_lang["time_limit"]							= "Zaman Siniri:";
$pgv_lang["title_manage_servers"]   			= "Siteleri Yönet";
$pgv_lang["title_view_conns"]       			= "Baglantilari Görüntüle";
$pgv_lang["translator_tools"]					= "Tercüman araçlari";
$pgv_lang["update_myaccount"]		= "Hesabimi Güncelle";
$pgv_lang["update_user"]		= "Kullanici Hesabi Güncelle";
$pgv_lang["upload_gedcom"]		= "GEDCOM Yükle";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Yeni kullanici kayit izni";
$pgv_lang["user_auto_accept"]					= "Bu kullanici tarafindan yapilan degisiklikleri otomatikman kabul et";
$pgv_lang["user_contact_method"]	= "Irtibat Yöntem Tercihi";
$pgv_lang["user_create_error"]		= "Kullanici eklenemiyor. Lütfen yeniden deneyin.";
$pgv_lang["user_created"]		= "Kullanici basariyla olusturuldu.";
$pgv_lang["user_default_tab"]		= "Birey bilgileri sayfasinda göstermek için varsayilan sekme";
$pgv_lang["user_path_length"]	= "En fazla akrabalik mayremiyet uzakligi";
$pgv_lang["user_relationship_priv"]	= "Ilgili kisilere erisimi sinirlama";
$pgv_lang["users_admin"]						= "Site Yöneticileri";
$pgv_lang["users_gedadmin"]						= "GEDCOM Yöneticileri";
$pgv_lang["users_total"]						= "Toplam kullanici sayisi";
$pgv_lang["users_unver"]			= "Kendini onaylamayan kullanici";
$pgv_lang["users_unver_admin"]		= "Yönetici onaylamadigi kullanici";
$pgv_lang["usr_deleted"]						= "Kullanici silindi: ";
$pgv_lang["usr_idle"]				= "Kullanicilari temizlemek için son x aydan beri giris yapmayan kullanicilari göster: ";
$pgv_lang["usr_idle_toolong"]		= "Kullanicinin son giris yaptigi tarih: ";
$pgv_lang["usr_no_cleanup"]						= "Temizlemek için hiçbir sey bulunamadi";
$pgv_lang["usr_unset_gedcomid"]					= "GEDCOM ID için Kurulmamis ";
$pgv_lang["usr_unset_rights"]					= "GEDCOM haklari için Kurulmamis ";
$pgv_lang["usr_unset_rootid"]					= "Kök ID için kurulmamis ";
$pgv_lang["valid_gedcom"]		= "Geçerli GEDCOM belilendi. Temizlemeye gerek yok. ";
$pgv_lang["validate_gedcom"]		= "Geçerli GEDCOM";
$pgv_lang["verified"]			= "Kullanici onayi";
$pgv_lang["verified_by_admin"]		= "Yönetici onayi";
$pgv_lang["verify_gedcom"]						= "GEDCOM Onayi";
$pgv_lang["verify_upload_instructions"]			= "Ayni adi tasiyan bir GEDCOM dosyasi bulundu. Eger devam etmeyi seçerseniz eski GEDCOM dosyasi yüklemeye çalistiginiz dosya ile degistirilecek ve içeri aktarma sürecine tekrar baslayacak. Eger iptal etmeyi seçersiniz eski GEDCOM dosyasi degistirilmeden kalacaktir.";
$pgv_lang["view_changelog"]						= "changelog.txt dosyasi görüntüle";
$pgv_lang["view_logs"]			= "Günlük dosyalari görüntüle";
$pgv_lang["view_readme"]						= "readme.txt dosyasi görüntüle";
$pgv_lang["visibleonline"]		= "Çevrimiçinde diger üyelere görülebilir?";
$pgv_lang["visitor"]							= "Ziyaretçi";
$pgv_lang["warn_users"]							= "Uyarilan kullanicilar";
$pgv_lang["weekly"]								= "Haftalik";
$pgv_lang["welcome_new"]			= "Yeni PhpGedView websitesine hos geldiniz.";
$pgv_lang["yearly"]								= "Yillik";
$pgv_lang["admin_OK_subject"]					= "#PGV_SERVER_NAME##PGV_SCRIPT_PATH# sitedeki hesabiniz onaylandi";
$pgv_lang["admin_OK_message"]					= "PhpGedView #PGV_SERVER_NAME##PGV_SCRIPT_PATH# sitedeki üyelik hesabiniz yönetici tarafindan onaylandi.\r\n\r\nSimdi asagidaki linki tiklayin PhpGedView sitesine kullanici adinizi ve sifrenizi kullanarak giris yapabilirsiniz: #PGV_SERVER_NAME##PGV_SCRIPT_PATH#\r\n";

$pgv_lang["batch_update"]="GEDCOM kümeyi güncelleme/düzenleme yönetimi";

// Text for the Gedcom Checker
$pgv_lang["gedcheck"]     = "Gedcom denetleyicisi";
$pgv_lang["gedcheck_text"] = "Bu modül <a href=\"http://phpgedview.sourceforge.net/ged551-5.pdf\">5.5.1 GEDCOM tanimlamasina karsi</a> bir GEDCOM dosyanin biçimini kontrol eder. Ayrica verinizin içindeki hatalarin sayisiniz kontrol eder. Not tanimlamada birçok verisyonlar, uzantilar ve degiskenler olduguna dikkat edin bü yüzden \"Kritik\" olarak o bayraktan baska herhangi bir konular ile ilgilenmemelisiniz. Yardim istemeden önce tüm hatalarin satirinda yine ayni satirda hatalar hakkinda tanimlamalar bulunabilir bu yüzden lütfen kontrol etmenizi rica ediyoruz.";
$pgv_lang["gedcheck_sync"] = "Veritabanina yapilan düzeltmelerle #GLOBALS[ged]# dosyasi senkronize edilemez. Dosya içerigi güncelligini yitirmis olabilir. Simdi <b><a \"#GLOBALS[ged_link]#\">disari aktararak</a></b> bu veritabani ile senkronize edebilirsiniz.";
$pgv_lang["gedcheck_nothing"] = "Bu düzeyde hata bulunamadi.";
$pgv_lang["level"]        = "Düzey";
$pgv_lang["critical"]     = "Kritik";
$pgv_lang["error"]        = "Hata";
$pgv_lang["warning"]      = "Uyari";
$pgv_lang["info"]         = "Bilgi";
$pgv_lang["open_link"]    = "Açik linkler";
$pgv_lang["same_win"]     = "Ayni sekmede/pencere";
$pgv_lang["new_win"]      = "Yeni sekme/pencere";
$pgv_lang["context_lines"]= "GEDCOM baglamin satirlari";
$pgv_lang["all_rec"]      = "Tüm kayitlar";
$pgv_lang["err_rec"]      = "Hatalari ile kayitlari";
$pgv_lang["missing"]      = "eksik";
$pgv_lang["multiple"]     = "çoklu";
$pgv_lang["invalid"]      = "geçersiz";
$pgv_lang["too_many"]     = "çok fazla";
$pgv_lang["too_few"]      = "çok az";
$pgv_lang["no_link"]      = "geriye baglantisiz";
$pgv_lang["data"]         = "veri";
$pgv_lang["see"]          = "gör";
$pgv_lang["noref"]        = "Bu kayda hiçbir referans yok";
$pgv_lang["tag"]          = "etiket";
$pgv_lang["spacing"]      = "uzaklik";
$pgv_lang["ADVANCED_NAME_FACTS"] = "Gelismis ad olgulari";
$pgv_lang["ADVANCED_PLAC_FACTS"] = "Gelismis yer adi olgulari";
$pgv_lang["SURNAME_TRADITION"] = "Soyadi gelenegi";
$pgv_lang["tradition_spanish"]		= "Ispanyol";
$pgv_lang["tradition_portuguese"]	= "Portekiz";
$pgv_lang["tradition_icelandic"]	= "Izlanda";
$pgv_lang["tradition_paternal"]		= "Baba tarafi";
$pgv_lang["tradition_polish"]		= "Polonya";
$pgv_lang["tradition_none"]			= "Hiçbiri";

// -- The following text is used to build the phrase "i years, j months, k days, l hours, m minutes"
// -- for use in text such as "xxx ago" or "after xxx" or "in xxx"
$pgv_lang["elapsedYear1"]	=	"1 yil";
$pgv_lang["elapsedYear2"]	=	"#pgv_lang[global_num1]# yil";
$pgv_lang["elapsedYears"]	=	"#pgv_lang[global_num1]# yil";
$pgv_lang["elapsedMonth1"]	=	"1 ay";
$pgv_lang["elapsedMonth2"]	=	"#pgv_lang[global_num1]# ay";
$pgv_lang["elapsedMonths"]	=	"#pgv_lang[global_num1]# ay";
$pgv_lang["elapsedDay1"]	=	"1 gün";
$pgv_lang["elapsedDay2"]	=	"#pgv_lang[global_num1]# gün";
$pgv_lang["elapsedDays"]	=	"#pgv_lang[global_num1]# gün";
$pgv_lang["elapsedHour1"]	=	"1 saat";
$pgv_lang["elapsedHour2"]	=	"#pgv_lang[global_num1]# saat";
$pgv_lang["elapsedHours"]	=	"#pgv_lang[global_num1]# saat";
$pgv_lang["elapsedMinute1"]	=	"1 dakika";
$pgv_lang["elapsedMinute2"]	=	"#pgv_lang[global_num1]# dakika";
$pgv_lang["elapsedMinutes"]	=	"#pgv_lang[global_num1]# dakika";

$pgv_lang["elapsedAgo"]		=	"#pgv_lang[global_string1]# önce";

?>
