<?php
/**
 * Chinese (Traditional) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 * @author PGV Developers
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: admin.zh.php 7307 2021-07-11 11:22:17Z canajun2eh $
 * @translation mr_bobwang
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["full_name"] = "全名";
$pgv_lang["error_header"] = "家譜文件,[#GEDCOM#], 文件位置不存在。";
$pgv_lang["PRIV_PUBLIC"] = "公開";
$pgv_lang["manage_gedcoms"] = "管理家譜文件";
$pgv_lang["label_ban_server"] = "發送";
$pgv_lang["label_delete"] = "刪除";
$pgv_lang["upload_replacement"] = "上傳替換";
$pgv_lang["access"] = "允許查看";
$pgv_lang["add_gedcom"] = "添加其它GEDCOM";
$pgv_lang["add_new_gedcom"] = "創建新的家譜";
$pgv_lang["add_new_language"] = "加入一個新的語言";
$pgv_lang["add_user"] = "加新用戶";
$pgv_lang["admin_gedcom"] = "管理家譜";
$pgv_lang["admin_gedcoms"] = "管理家譜文件";
$pgv_lang["admin_geds"] = "數據和家譜管理";
$pgv_lang["admin_site"] = "網站管理";
$pgv_lang["admin_approved"] = "你在#SERVER_NAME#的賬戶已經被批准通過";
$pgv_lang["administration"] = "管理";
$pgv_lang["ALLOW_CHANGE_GEDCOM"] = "可以換其它家譜";
$pgv_lang["ALLOW_REMEMBER_ME"] = "在登錄頁顯示 <b>記住我</b> ";
$pgv_lang["ALLOW_USER_THEMES"] = "允許用戶選擇主題";
$pgv_lang["ansi_to_utf8"] = "轉換這個ANSI (ISO-8859-1) 編碼GEDCOM 成UTF-8?";
$pgv_lang["apply_privacy"] = "設置隱私？";
$pgv_lang["back_useradmin"] = "回到用戶管理";
$pgv_lang["bytes_read"] = "讀起了Bytes:";
$pgv_lang["calc_marr_names"] = "計算婚後的名字";
$pgv_lang["can_admin"] = "設置用戶為管理員";
$pgv_lang["can_edit"] = "用戶對家譜權限";
$pgv_lang["cleanup_places"] = "清理地方";
$pgv_lang["cleanup_users"] = "清理用戶";
$pgv_lang["click_here_to_continue"] = "繼續";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "點擊瀏覽家譜結構樹。";
$pgv_lang["config_help"] = "設置幫助";
$pgv_lang["configuration"] = "設置";
$pgv_lang["configure"] = "設置家譜";
$pgv_lang["configure_head"] = "家譜設置";
$pgv_lang["confirm_gedcom_delete"] = "確認刪除這個家譜文件";
$pgv_lang["confirm_user_delete"] = "確認刪除用戶";
$pgv_lang["create_user"] = "創建用戶";
$pgv_lang["current_users"] = "用戶表";
$pgv_lang["daily"] = "每天";
$pgv_lang["dataset_exists"] = "GEDCOM 以這個文件名已經被導入入資料庫。";
$pgv_lang["date_registered"] = "註冊日";
$pgv_lang["day_before_month"] = "在一個月前面的日子 (DD MM YYYY)";
$pgv_lang["DEFAULT_GEDCOM"] = "設置默認顯示家譜";
$pgv_lang["default_user"] = "創建默認管理用戶";
$pgv_lang["del_proceed"] = "繼續";
$pgv_lang["del_unvera"] = "用戶沒有被管理員驗證";
$pgv_lang["del_unveru"] = "用戶在七天內沒有驗證";
$pgv_lang["do_not_change"] = "不要改";
$pgv_lang["download_gedcom"] = "下載家譜文件";
$pgv_lang["download_here"] = "下載文件";
$pgv_lang["editaccount"] = "用戶可以改自己的信息";
$pgv_lang["duplicate_username"] = "用戶名重複。其他用戶已使用此用戶名，請返回並選擇其它用戶名。";
$pgv_lang["empty_dataset"] = "覆蓋舊的信息嗎？";
$pgv_lang["enable_disable_lang"] = "設置語言";
$pgv_lang["found_record"] = "被查找的記錄";
$pgv_lang["ged_download"] = "下載";
$pgv_lang["ged_import"] = "導入文件";
$pgv_lang["ged_check"] = "檢查";
$pgv_lang["gedcom_adm_head"] = "家譜管理";
$pgv_lang["gedcom_file"] = "GEDCOM 文件:";
$pgv_lang["gedcom_not_imported"] = "家譜文件還沒有被導入";
$pgv_lang["autoContinue"] = "自動按《繼續》";
$pgv_lang["import_complete"] = "導入完全";
$pgv_lang["import_marr_names"] = "導入婚後名字";
$pgv_lang["import_options"] = "導入選項";
$pgv_lang["import_progress"] = "正在導入...";
$pgv_lang["import_statistics"] = "導入統計";
$pgv_lang["inc_languages"] = "語言";
$pgv_lang["INDEX_DIRECTORY"] = "索引目錄";
$pgv_lang["label_families"] = "家庭";
$pgv_lang["label_gedcom_id2"] = "家譜代碼：";
$pgv_lang["label_individuals"] = "個人";
$pgv_lang["label_password_id"] = "密碼";
$pgv_lang["label_username_id"] = "用戶名";
$pgv_lang["LANG_SELECTION"] = "支持的語言";
$pgv_lang["last_login"] = "上次登錄";
$pgv_lang["link_manage_servers"] = "管理網站";
$pgv_lang["logfile_content"] = "日誌文件";
$pgv_lang["mailto"] = "發電子郵件";
$pgv_lang["merge_records"] = "合併紀錄";
$pgv_lang["message_to_all"] = "發信息給所有的用戶";
$pgv_lang["monthly"] = "每月";
$pgv_lang["never"] = "從沒有";
$pgv_lang["PGV_MEMORY_LIMIT"] = "內存限制";
$pgv_lang["PGV_SESSION_SAVE_PATH"] = "工作的文件夾";
$pgv_lang["PGV_SESSION_TIME"] = "用戶時間限制";
$pgv_lang["phpinfo"] = "PHP信息";
$pgv_lang["mysql"] ="MySQL數據庫";
$pgv_lang["please_be_patient"] = "請耐心";
$pgv_lang["privileges"] = "特權";
$pgv_lang["reading_file"] = "讀取家譜文件";
$pgv_lang["readme_documentation"] = "README 文件";
$pgv_lang["remove_ip"] = "刪除IP地址";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"] = "需要管理人員確認新用戶註冊";
$pgv_lang["rootid"] = "家譜圖表開始點";
$pgv_lang["seconds"] = "&nbsp;&nbsp;秒";
$pgv_lang["select_an_option"] = "選項：";
$pgv_lang["SERVER_URL"] = "家譜網址";
$pgv_lang["show_phpinfo"] = "顯示PHP信息";
$pgv_lang["siteadmin"] = "網站管理員";
$pgv_lang["time_limit"] = "時限：";
$pgv_lang["translator_tools"] = "翻譯工具";
$pgv_lang["update_myaccount"] = "更新用戶帳號信息";
$pgv_lang["update_user"] = "更新用戶";
$pgv_lang["upload_gedcom"] = "上傳家譜文件";
$pgv_lang["USE_REGISTRATION_MODULE"] = "允許申請註冊";
$pgv_lang["user_auto_accept"] = "自動接受用戶的更改";
$pgv_lang["user_contact_method"] = "首選聯繫方式";
$pgv_lang["user_create_error"] = "無法增加用戶。 請返回並再次嘗試。";
$pgv_lang["user_created"] = "用戶成功地被創建。";
$pgv_lang["users_admin"] = "網頁管理員";
$pgv_lang["users_gedadmin"] = "家譜管理員";
$pgv_lang["users_total"] = "總共用戶";
$pgv_lang["users_unver"] = "未驗證的用戶";
$pgv_lang["users_unver_admin"] = "沒有被管理員驗證";
$pgv_lang["usr_deleted"] = "刪除用戶：";
$pgv_lang["verified"] = "通過郵件驗證:";
$pgv_lang["verified_by_admin"] = "用戶被管理員驗證通過";
$pgv_lang["verify_gedcom"] = "驗證家譜文件";
$pgv_lang["visitor"] = "遊客";
$pgv_lang["weekly"] = "每週";
$pgv_lang["welcome_new"] = "歡迎來到你的家族網站。";
$pgv_lang["yearly"] = "每年";
$pgv_lang["admin_OK_subject"] = "允許賬戶在#PGV_SERVER_NAME##PGV_SCRIPT_PATH#";
$pgv_lang["gedcheck"] = "家譜文件檢查";
$pgv_lang["level"] = "層次";
$pgv_lang["error"] = "出錯";
$pgv_lang["warning"] = "警告";
$pgv_lang["info"] = "信息";
$pgv_lang["all_rec"] = "所有記錄";
$pgv_lang["missing"] = "丟失";
$pgv_lang["data"] = "紀錄";
$pgv_lang["SURNAME_TRADITION"] = "姓放在前後";
$pgv_lang["you_may_login"] = " 由網站管理員。您現在可以通過以下鏈接登錄PhpGedView站點:";


$pgv_lang["associated_files"] = "有聯繫的文件：";
$pgv_lang["warn_file_delete"] = "這個文件有重要的語言設置或等待改變的數據。你要刪除它嗎？";
$pgv_lang["deleted_files"] = "被刪除的文件：";
$pgv_lang["index_dir_cleanup_inst"] = "如果想刪除次文件夾的文件，請把它們拉到垃圾箱或者把它打上鉤。按下刪除便永久刪除此文件。<br /><br />有<img src=\"./images/RESN_confidential.gif\" /> 標籤的文件不能被刪除，因為它被系統用。<br />有<img src=\"./images/RESN_locked.gif\" /> 標籤的文件有重要的設置或等待改變的數據，所以建議不要刪除。<br /><br />";
$pgv_lang["sanity_err0"] = "錯誤：";
$pgv_lang["sanity_warn0"] = "警告：";
$pgv_lang["refresh"] = "刷新";
$pgv_lang["gedadmin"] = "家譜管理員";
$pgv_lang["remove_all_files"] = "刪除沒有必要的文件";
$pgv_lang["label_timedban_servers"] = "定時拒絕IP訪問";
$pgv_lang["enter_banexpiry"] = "輸入拒絕訪問的到期日期和時間，例如：<br />2012.12.31@23:59";
$pgv_lang["analytics_config"] = "網絡分析";
$pgv_lang["google_analytics"] = "谷歌分析";
$pgv_lang["USE_GOOGLE_ANALYTICS"] = "激活Google Analytics？";
$pgv_lang["PGV_GOOGLE_ANALYTICS"] = "Google Analytics帳號";
$pgv_lang["piwik_analytics"] = "Matomo Analytics";
$pgv_lang["USE_PIWIK_ANALYTICS"] = "激活Matomo Analytics？";
$pgv_lang["PGV_PIWIK_URL"] = "Matomo Analytics服務器URL";
$pgv_lang["PGV_PIWIK_SITE"] = "Matomo Analytics網站編號";
$pgv_lang["clustrmaps_analytics"] = "ClustrMaps Analytics";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS"] = "激活ClustrMaps Analytics？";
$pgv_lang["PGV_CLUSTRMAPS_SITE"] = "PhpGedView網址";
$pgv_lang["PGV_CLUSTRMAPS_SERVER"] = "ClustrMaps服務器號";
$pgv_lang["module_admin"] = "模塊管理";
$pgv_lang["mod_admin_installed"] = "已安裝的模塊";
$pgv_lang["mod_admin_tabs"] = "管理標籤";
$pgv_lang["mod_admin_menus"] = "管理菜單";
$pgv_lang["mod_admin_intro"] = "下面是PhpGedView實例中安裝的所有模塊的列表。模塊通過將它們放在<i>modules</i>目錄中來安裝。在這裡你可以為每個模塊設置每個GEDCOM的訪問級別。如果是模塊包括單個頁面的選項卡或菜單欄的菜單，您還可以設置每個頁面的訪問級別和順序。";
$pgv_lang["mod_admin_active"] = "活性";
$pgv_lang["mod_admin_name"] = "模塊名稱";
$pgv_lang["mod_admin_description"] = "描述";
$pgv_lang["mod_admin_version"] = "版本/PGV";
$pgv_lang["mod_admin_hastab"] = "標籤？";
$pgv_lang["mod_admin_hasmenu"] = "菜單？";
$pgv_lang["mod_admin_access_level"] = "訪問權限";
$pgv_lang["mod_admin_order"] = "訂購";
$pgv_lang["mod_admin_config"] = "Mod設置";
$pgv_lang["mod_admin_settings"] = "模塊配置設置";
$pgv_lang["ret_module_admin"] = "返回模塊管理頁面";
$pgv_lang["ret_admin"] = "返回管理頁面";
$pgv_lang["enter_comment"] = "你可以在這裡輸入評論。";
$pgv_lang["upload_a_gedcom"] = "上傳GEDCOM文件";
$pgv_lang["start_entering"] = "開始輸入數據";
$pgv_lang["add_gedcom_from_path"] = "從文件位置添加GEDCOM";
$pgv_lang["get_started_instructions"] = "選擇其中一個選項開始使用PhpGedView";
$pgv_lang["admin_users_exists"] = "以下管理用戶已經存在：";
$pgv_lang["install_step_1"] = "檢查環境";
$pgv_lang["install_step_2"] = "數據庫連接";
$pgv_lang["install_step_3"] = "創建表";
$pgv_lang["install_step_4"] = "網站配置";
$pgv_lang["install_step_5"] = "語言";
$pgv_lang["install_step_6"] = "保存配置";
$pgv_lang["install_step_7"] = "創建管理員用戶";
$pgv_lang["install_wizard"] = "安裝嚮導";
$pgv_lang["basic_site_config"] = "基本設置";
$pgv_lang["adv_site_config"] = "高級設置";
$pgv_lang["config_not_saved"] = "*您的設置將不會被保存，直到第6步";
$pgv_lang["download_config"] = "下載config.php";
$pgv_lang["site_unavailable"] = "網站目前無法使用";
$pgv_lang["to_manage_users"] = "要管理用戶，請使用<a href=\"useradmin.php\">用戶管理</a>頁面。";
$pgv_lang["db_tables_created"] = "數據庫表創建成功";
$pgv_lang["config_saved"] = "配置已成功保存";
$pgv_lang["checking_errors"] = "檢查錯誤......";
$pgv_lang["checking_php_version"] = "檢查所需的PHP版本：";
$pgv_lang["failed"] = "失敗";
$pgv_lang["pgv_requires_version"] = "PhpGedView需要PHP版本#PGV_REQUIRED_PHP_VERSION#或更高版本。";
$pgv_lang["using_php_version"] = "您正在使用PHP版本#PGV_ACTUAL_PHP_VERSION#";
$pgv_lang["checking_db_support"] = "檢查最低數據庫支持：";
$pgv_lang["no_db_extensions"] = "您沒有任何受支持的數據庫擴展。";
$pgv_lang["db_ext_support"] = "你有#DBEXT#support";
$pgv_lang["checking_config.php"] = "檢查config.php：";
$pgv_lang["config.php_missing"] = "找不到config.php文件。";
$pgv_lang["config.php_missing_instr"] = "此安裝嚮導將無法將您的設置寫入config.php文件。您可以復制config.dist文件並將其重命名為config.php。或者，完成此嚮導後，您可以選擇下載您的設置並上傳生成的config.php文件。";
$pgv_lang["config.php_not_writable"] = "config.php不可寫。";
$pgv_lang["config.php_not_writable_instr"] = "此安裝嚮導將無法將您的設置寫入config.php文件。您可以在文件上設置寫入權限，或者在完成此嚮導後，您可以選擇下載設置並上傳生成的config.php文件。";
$pgv_lang["passed"] = "通過。";
$pgv_lang["config.php_writable"] = "config.php存在且可寫。";
$pgv_lang["checking_warnings"] = "檢查警告......";
$pgv_lang["checking_timelimit"] = "檢查改變時間限制的能力：";
$pgv_lang["cannot_change_timelimit"] = "無法改變時限。";
$pgv_lang["cannot_change_timelimit_instr"] = "你可能無法在擁有許多人的大型數據庫上運行所有功能。";
$pgv_lang["current_max_timelimit"] = "你的最長期限是";
$pgv_lang["check_memlimit"] = "檢查更改內存限制的能力：";
$pgv_lang["cannot_change_memlimit"] = "無法更改內存限制。";
$pgv_lang["cannot_change_memlimit_instr"] = "你可能無法在擁有許多人的大型數據庫上運行所有功能。";
$pgv_lang["current_max_memlimit"] = "你目前的記憶限制是";
$pgv_lang["check_upload"] = "檢查上傳文件的能力：";
$pgv_lang["current_max_upload"] = "您的最大上傳文件大小為：";
$pgv_lang["check_gd"] = "檢查GD圖像庫：";
$pgv_lang["cannot_use_gd"] = "你沒有GD圖像庫。你將無法自動創建圖像縮略圖。";
$pgv_lang["check_sax"] = "檢查SAX XML庫：";
$pgv_lang["cannot_use_sax"] = "你沒有SAX XML庫。你將無法運行任何報告或其他輔助功能。";
$pgv_lang["check_dom"] = "檢查DOM XML庫：";
$pgv_lang["cannot_use_dom"] = "你沒有DOM XML庫。你將無法導出XML。";
$pgv_lang["check_calendar"] = "檢查高級日曆庫：";
$pgv_lang["cannot_use_calendar"] = "您沒有高級日曆支持。您將無法運行某些高級日曆功能。";
$pgv_lang["warnings_passed"] = "所有警告檢查均已通過。";
$pgv_lang["warning_instr"] = "如果沒有通過任何警告，您仍然可以在此服務器上運行PhpGedView，但某些功能可能會被禁用，或者您可能會遇到性能不佳的情況。";
$pgv_lang["index_dir_cleanup"] = "清理索引目錄";
$pgv_lang["clear_cache_succes"] = "緩存文件已被刪除。";
$pgv_lang["clear_cache"] = "清除緩存文件";
$pgv_lang["sanity_err1"] = "你需要擁有PHP版本#PGV_REQUIRED_PHP_VERSION#或更高版本。";
$pgv_lang["sanity_err2"] = "文件或目錄<i>#GLOBALS[whichFile]#</i>不存在。請驗證文件或目錄是否存在，沒有錯誤命名，並且讀取權限設置正確。";
$pgv_lang["sanity_err3"] = "文件<i>#GLOBALS[whichFile]#</i>沒有正確上傳。請嘗試重新上傳文件。";
$pgv_lang["sanity_err4"] = "文件<i>config.php</i>已損壞。";
$pgv_lang["sanity_err5"] = "<i>config.php</i>文件不可寫。";
$pgv_lang["sanity_err6"] = "<i>#GLOBALS[INDEX_DIRECTORY]#</i>目錄不可寫。";
$pgv_lang["sanity_warn1"] = "<i>#GLOBALS[MEDIA_DIRECTORY]#</i>目錄不可寫。您將無法在PhpGedView中上傳媒體文件或生成縮略圖。";
$pgv_lang["sanity_warn2"] = "<i>#GLOBALS[MEDIA_DIRECTORY]#thumbs</i>目錄不可寫。您將無法在PhpGedView中上傳縮略圖或生成縮略圖。";
$pgv_lang["sanity_warn3"] = "GD成像庫不存在.PhpGedView仍然可以運行，但是一些功能，如縮略圖生成和圓圖，如果沒有GD庫，將無法工作。請參閱<a href='http://www.php.net/manual/en/ref.image.php'>http://www.php.net/manual/en/ref.image.php</a>了解更多信息。";
$pgv_lang["sanity_warn4"] = "XML Parser庫不存在.PhpGedView仍然可以運行，但是如果沒有XML Parser庫，某些功能（如報告生成和Web服務）將無法運行。請參閱<a href='http://www.php.net/manual/en/ref.xml.php'>http://www.php.net/manual/en/ref.xml.php</a>了解更多信息。";
$pgv_lang["sanity_warn5"] = "DOM XML庫不存在.PhpGedView仍然可以運行，但是一些功能，例如剪報購物車中的Gramps Export功能，下載和Web服務，將無法正常工作。請參閱<a href='http://www.php.net/manual/en/ref.domxml.php'>http://www.php.net/manual/en/ref.domxml.php</a>了解更多信息。 ";
$pgv_lang["sanity_warn6"] = "日曆庫不存在.PhpGedView仍然可以運行，但某些功能，例如轉換為其他日曆，如希伯來語或法語，將無法正常工作。運行PhpGedView並不是必需的。請參閱<a href='http://www.php.net/manual/en/ref.calendar.php'>http://www.php.net/manual/en/ref.calendar.php</a>了解更多信息。";
$pgv_lang["ip_address"] = "IP地址";
$pgv_lang["date_time"] = "日期和時間";
$pgv_lang["log_message"] = "日誌消息";
$pgv_lang["searchtype"] = "搜索類型";
$pgv_lang["query"] = "查詢";
$pgv_lang["user"] = "認證用戶";
$pgv_lang["editors"] = "修編員";
$pgv_lang["gedcom_admins"] = "GEDCOM管理員";
$pgv_lang["site_admins"] = "網站管理員";
$pgv_lang["nobody"] = "沒有人";
$pgv_lang["thumbnail_deleted"] = "縮略圖文件已成功刪除。";
$pgv_lang["thumbnail_not_deleted"] = "無法刪除縮略圖文件。";
$pgv_lang["step2"] = "第2步，共4步：";
$pgv_lang["move_file_success"] = "媒體和縮略圖文件已成功移動。";
$pgv_lang["media_folder_corrupt"] = "媒體文件夾已損壞。";
$pgv_lang["media_file_not_deleted"] = "無法刪除媒體文件。";
$pgv_lang["gedcom_deleted"] = "GEDCOM[#GED#]已成功刪除。";
$pgv_lang["confirm_delete_file"] = "你確定要刪除這個文件嗎？";
$pgv_lang["confirm_folder_delete"] = "你確定要刪除這個文件夾嗎？";
$pgv_lang["confirm_remove_links"] = "您確定要刪除此對象的所有鏈接嗎？";
$pgv_lang["PRIV_USER"] = "僅向經過身份驗證的用戶顯示";
$pgv_lang["PRIV_NONE"] = "僅向管理員用戶顯示";
$pgv_lang["PRIV_HIDE"] = "甚至隱藏來自管理員用戶";
$pgv_lang["keep_media"] = "保持媒體鏈接";
$pgv_lang["current_links"] = "鏈接";
$pgv_lang["add_more_links"] = "添加鏈接";
$pgv_lang["enter_pid_or_name"] = "輸入個人ID或姓名";
$pgv_lang["set_links"] = "設置鏈接";
$pgv_lang["add_or_remove_links"] = "管理鏈接";
$pgv_lang["keep"] = "保持";
$pgv_lang["unlink"] = "取消";
$pgv_lang["nav"] = "航海家";
$pgv_lang["fam_nav"] = "家庭導航員";
$pgv_lang["remove"] = "去掉";
$pgv_lang["keep_link"] = "將鏈接保留在列表中";
$pgv_lang["remove_link"] = "從列表中刪除鏈接";
$pgv_lang["open_nav"] = "開放家庭導航員";
$pgv_lang["link_exists"] = "這個鏈接已經存在";
$pgv_lang["id_not_valid"] = "不是有效的個人，家庭或來源ID";
$pgv_lang["add_fam_other_links"] = "添加家庭和搜索鏈接";
$pgv_lang["search_add_links"] = "搜索人員添加到添加鏈接列表。";
$pgv_lang["enter_name"] = "輸入名稱";
$pgv_lang["add_indi_to_link_list"] = "單擊名稱將人員添加到添加鏈接列表。";
$pgv_lang["click_choose_head"] = "點擊#GLOBALS[tempStringHead]#選擇人為家長。";
$pgv_lang["click_choose_head_text"] = "點擊選擇人為家長。";
$pgv_lang["head"] = "頭";
$pgv_lang["id_empty"] = "添加鏈接時，ID字段不能為空。";
$pgv_lang["link_deleted"] = "鏈接到#GLOBALS[remLinkId]#删除";
$pgv_lang["link_added"] = "鏈接到#GLOBALS[addLinkId]#添加";
$pgv_lang["no_update_CHANs"] = "不要更新CHAN（最後更改）記錄";
$pgv_lang["no_CHANs_update"] = "沒有陳（最後更改）記錄已更新";
$pgv_lang["files_in_backup"] = "此備份中包含的文件";
$pgv_lang["created_remotelinks"] = "成功創建了<i>Remotelinks</i>表。";
$pgv_lang["created_remotelinks_fail"] = "無法創建<i>Remotelinks</i>表。";
$pgv_lang["created_indis"] = "成功創建<i>個人</i>表。";
$pgv_lang["created_indis_fail"] = "無法創建<i>個人</i>表。";
$pgv_lang["created_fams"] = "成功創建<i>家庭</i>表。";
$pgv_lang["created_fams_fail"] = "無法創建<i>Families</i>表。";
$pgv_lang["created_sources"] = "成功創建了<i>Sources</i>表。";
$pgv_lang["created_sources_fail"] = "無法創建<i>Sources</i>表。";
$pgv_lang["created_other"] = "成功創建<i>其他</i>表。";
$pgv_lang["created_other_fail"] = "無法創建<i>其他</i>表。";
$pgv_lang["created_places"] = "成功創建<i>地方</i>表。";
$pgv_lang["created_places_fail"] = "無法創建<i>地方</i>表。";
$pgv_lang["created_placelinks"] = "已成功創建<i>放置鏈接</i>表。";
$pgv_lang["created_placelinks_fail"] = "無法創建<i>放置鏈接</i>表。";
$pgv_lang["created_media_fail"] = "無法創建<i>Media</i>表。";
$pgv_lang["created_media_mapping_fail"] = "無法創建<i>媒體映射</i>表。";
$pgv_lang["no_thumb_dir"] = "縮略圖目錄不存在，無法創建。";
$pgv_lang["folder_created"] = "目錄創建";
$pgv_lang["folder_no_create"] = "無法創建目錄";
$pgv_lang["security_no_create"] = "安全警告：無法在中創建文件<b><i>index.php</i></b>";
$pgv_lang["security_not_exist"] = "安全警告：文件<b><i>index.php</i></b>不存在於";
$pgv_lang["progress_bars_info"] = "下面的狀態欄將告訴您導入的進度。如果時間限制用完，導入將停止，並且將要求您按<b>繼續</b>按鈕。如果您沒有看到<b>繼續</b>按鈕，您必須以較小的時間限制值重新啟動導入。";
$pgv_lang["about_user"] = "您必須首先創建主管理用戶。此用戶將有權更新配置文件，查看私有數據以及創建其他用戶。";
$pgv_lang["admin_info"] = "信息化";
$pgv_lang["admin_user_warnings"] = "一個或多個用戶帳戶有警告";
$pgv_lang["admin_verification_waiting"] = "用戶帳戶正在等待管理員驗證";
$pgv_lang["ansi_encoding_detected"] = "檢測到ANSI文件編碼。";
$pgv_lang["change_id"] = "將個人ID更改為";
$pgv_lang["choose_priv"] = "選擇隱私級別：";
$pgv_lang["comment"] = "管理員對用戶的評論";
$pgv_lang["comment_exp"] = "日期管理員警告";
$pgv_lang["config_still_writable"] = "您的<i>config.php</i>文件仍然可寫。為了安全起見，您應該在完成站點配置後將此文件的權限設置為只讀。";
$pgv_lang["unsync_warning"] = "此GEDCOM文件<em>不</em>與數據庫同步。它可能不包含最新版本的數據。要從數據庫而不是文件重新導入，您應該下載並重新上傳。" ;
$pgv_lang["del_gedrights"] = "GEDCOM不再有效，刪除用戶引用。";
$pgv_lang["download_note"] = "注意：大型數據庫在下載之前可能需要很長時間才能處理。如果PHP在下載完成之前超時，則下載的文件可能不完整。<br /><br />要確保文件已正確下載，檢查GEDCOM格式的文​​​​件的最後一行是<b>0&nbsp;TRLR</b>，或者XML格式的文件的最後一行是<b>&lt;/database&gt;</b>。這些文件是文本;您可以使用任何合適的文本編輯器，但在檢查後確保<u>不</u>保存下載的文件。<br /><br />一般來說，可能需要花費很多時間下載導入原始GEDCOM文件。";
$pgv_lang["empty_lines_detected"] = "在您的GEDCOM文件中檢測到空行。";
$pgv_lang["error_ban_server"] = "無效的IP地址。";
$pgv_lang["error_delete_person"] = "您必須選擇要刪除其遠程鏈接的人。";
$pgv_lang["error_header_write"] = "GEDCOM文件<b>#GEDCOM#</b>不可寫。請檢查屬性和訪問權限。";
$pgv_lang["error_remove_site"] = "無法刪除遠程服務器。";
$pgv_lang["error_remove_site_linked"] = "無法刪除遠程服務器，因為其Connections列表不為空。";
$pgv_lang["error_remote_duplicate"] = "這個遠程數據庫已作為<i>#GLOBALS[whichFile]#</i>列在列表中";
$pgv_lang["error_siteauth_failed"] = "無法對遠程站點進行身份驗證";
$pgv_lang["error_url_blank"] = "請不要將遠程站點標題或URL留空";
$pgv_lang["error_view_info"] = "你必須選擇你想要查看其信息的人。";
$pgv_lang["example_date"] = "來自GEDCOM的無效日期示例：";
$pgv_lang["example_place"] = "你的GEDCOM無效地點的例子：";
$pgv_lang["fbsql"] = "FrontBase";
$pgv_lang["ged_export"] = "導出";
$pgv_lang["gedcom_config_write_error"] = "錯誤!!!<br />無法寫入文件<i>#GLOBALS[whichFile]#</i>。請檢查它是否有正確的寫入權限。";
$pgv_lang["gedcom_downloadable"] = "此GEDCOM文件可通過互聯網下載！<br />請參閱<a href=\"readme.txt\"> <b>readme.txt</b></a>文件的安全部分以修復這個問題";
$pgv_lang["ibase"] = "InterBase的";
$pgv_lang["ifx"] = "Informix的";
$pgv_lang["img_admin_settings"] = "編輯圖像處理配置";
$pgv_lang["import_time_exceeded"] = "達到了執行時間限制。單擊下面的繼續按鈕繼續導入GEDCOM文件。";
$pgv_lang["invalid_dates"] = "檢測到無效日期格式，清理後這些格式將更改為DD MMM YYYY格式（例如2004年1月1日）。";
$pgv_lang["BOM_detected"] = "在文件開頭檢測到字節順序標記（BOM）。在清理時，將刪除此特殊代碼。";
$pgv_lang["invalid_header"] = "在GEDCOM標題之前檢測到行<b>0&nbsp;HEAD</b>。在清理時，這些行將被刪除。";
$pgv_lang["label_added_servers"] = "遠程服務器";
$pgv_lang["label_banned_servers"] = "拒絕IP訪問";
$pgv_lang["label_manual_search_engines"] = "使用IP地址標記搜索引擎";
$pgv_lang["label_new_server"] = "添加新網站";
$pgv_lang["label_server_info"] = "所有通過網站遠程鏈接的人和家庭：";
$pgv_lang["label_server_url"] = "網站網址/IP";
$pgv_lang["label_view_local"] = "查看關於人的當地信息";
$pgv_lang["label_view_remote"] = "查看關於人的遠程信息";
$pgv_lang["LANGUAGE_DEFAULT"] = "您尚未配置您的網站將支持的語言。<br />PhpGedView將使用其默認操作。";
$pgv_lang["lasttab"] = "最後訪問個人標籤";
$pgv_lang["leave_blank"] = "如果要保留當前密碼，請將密碼留空。";
$pgv_lang["macfile_detected"] = "檢測到Macintosh文件。在清理時，您的文件將轉換為DOS文件。";
$pgv_lang["messaging"] = "PhpGedView內部消息";
$pgv_lang["messaging2"] = "通過電子郵件發送內部消息";
$pgv_lang["messaging3"] = "電子郵件";
$pgv_lang["month_before_day"] = "前一天（MM DD YYYY）";
$pgv_lang["msql"] = "迷你SQL";
$pgv_lang["mssql"] = "Microsoft SQL服務器";
$pgv_lang["no_logs"] = "禁用日誌記錄";
$pgv_lang["no_messaging"] = "沒有聯繫方式";
$pgv_lang["oci8"] = "Oracle 7+";
$pgv_lang["page_views"] = "&nbsp;&nbsp;page views in&nbsp;&nbsp";
$pgv_lang["performing_validation"] = "執行GEDCOM驗證......";
$pgv_lang["pgsql"] = "PostgreSQL的";
$pgv_lang["pgv_config_write_error"] = "錯誤!!!無法寫入PhpGedView配置文件。請檢查文件和目錄權限，然後重試。";
$pgv_lang["PGV_SIMPLE_MAIL"] = "在外部郵件中使用簡單的郵件標題";
$pgv_lang["PGV_SMTP_ACTIVE"] = "使用SMTP發送外部郵件";
$pgv_lang["PGV_SMTP_HOST"] = "發送服務器（SMTP）名稱";
$pgv_lang["PGV_SMTP_HELO"] = "發送域名";
$pgv_lang["PGV_SMTP_PORT"] = "SMTP端口";
$pgv_lang["PGV_SMTP_AUTH"] = "使用名稱和密碼";
$pgv_lang["PGV_SMTP_AUTH_USER"] = "用戶名";
$pgv_lang["PGV_SMTP_AUTH_PASS"] = "密碼";
$pgv_lang["PGV_SMTP_SSL"] = "安全連接";
$pgv_lang["PGV_SMTP_FROM_NAME"] = "發件人姓名";
$pgv_lang["PGV_STORE_MESSAGES"] = "允許在線存儲消息";
$pgv_lang["place_cleanup_detected"] = "檢測到無效的地點編碼。這些錯誤應該是固定的。";
$pgv_lang["review_readme"] = "在繼續配置PhpGedView之前，您應該查看<a href=\"readme.txt\" target=\"_blank\">readme.txt</a>文件。<br /><br />";
$pgv_lang["sqlite"] = "SQLite";
$pgv_lang["sybase"] = "Sybase";
$pgv_lang["sync_gedcom"] = "將用戶設置與GEDCOM數據同步";
$pgv_lang["system_time"] = "當前服務器時間：";
$pgv_lang["user_time"] = "當前用戶時間：";
$pgv_lang["TBLPREFIX"] = "數據庫表前綴";
$pgv_lang["themecustomization"] = "主題定制";
$pgv_lang["title_manage_servers"] = "管理網站";
$pgv_lang["title_view_conns"] = "查看連接";
$pgv_lang["user_default_tab"] = "默認選項卡顯示在個人信息頁面上";
$pgv_lang["user_path_length"] = "最大關係隱私路徑長度";
$pgv_lang["user_relationship_priv"] = "限制對相關人員的訪問";
$pgv_lang["usr_idle"] = "自上次登錄以來用戶帳戶被視為非活動狀態的月數：";
$pgv_lang["usr_idle_toolong"] = "用戶的帳戶已停用太長時間：";
$pgv_lang["usr_no_cleanup"] = "沒有找到清理工作";
$pgv_lang["usr_unset_gedcomid"] = "取消GEDCOM ID";
$pgv_lang["usr_unset_rights"] = "取消GEDCOM的權利";
$pgv_lang["usr_unset_rootid"] = "取消設置根ID";
$pgv_lang["valid_gedcom"] = "檢測到有效的GEDCOM。無需清理。";
$pgv_lang["validate_gedcom"] = "驗證GEDCOM";
$pgv_lang["verify_upload_instructions"] = "找到了一個同名的GEDCOM文件。如果你選擇繼續，舊的GEDCOM文件將替換為你上傳的文件，導入過程將重新開始。如果你選擇取消，舊的GEDCOM將保留不變。";
$pgv_lang["view_changelog"] = "查看changelog.txt文件";
$pgv_lang["view_logs"] = "查看日誌文件";
$pgv_lang["view_readme"] = "查看readme.txt文件";
$pgv_lang["visibleonline"] = "在線時可見其他用戶";
$pgv_lang["warn_users"] = "有警告的用戶";
$pgv_lang["admin_OK_message"] = "網站 #PGV_SERVER_NAME##PGV_SCRIPT_PATH# 的管理員已經批淮了您的帳戶申請。\r\n\r\n您現在可以通過訪問以下鏈接登錄：#PGV_SERVER_NAME##PGV_SCRIPT_PATH#";
$pgv_lang["batch_update"] = "在GEDCOM上執行批量更新/編輯";
//Text for the Gedcom Checker
$pgv_lang["gedcheck_text"] = "該模塊根據<a href=\"http://phpgedview.sourceforge.net/ged551-5.pdf\">5.5.1 GEDCOM規範</a>檢查GEDCOM文件的格式。它還檢查您的數據中存在許多常見錯誤。請注意，規範中有許多版本，擴展和變體，因此除了標記為嚴重的問題之外，您不應該關注任何問題。所有行的解釋- 在規範中可以找到線上錯誤，因此請在尋求幫助前查看。";
$pgv_lang["gedcheck_sync"] = "對數據庫所做的編輯不會同步到文件#GLOBALS[ged]#。文件內容可能已過時。您現在可以通過執行<b><a \"#GLOBALS[ged_link]#\">出口</a></b>。";
$pgv_lang["gedcheck_nothing"] = "檢查沒有發現任何錯誤。";
$pgv_lang["critical"] = "危急";
$pgv_lang["open_link"] = "打開鏈接"; //在哪裡打開鏈接
$pgv_lang["same_win"] = "相同標籤/窗口";
$pgv_lang["new_win"] = "新標籤/窗口";
$pgv_lang["context_lines"] = "GEDCOM背景線"; //錯誤的任一側的行數
$pgv_lang["err_rec"] = "有錯誤的記錄";
$pgv_lang["multiple"] = "多";
$pgv_lang["invalid"] = "無效";
$pgv_lang["too_many"] = "太多";
$pgv_lang["too_few"] = "太少了";
$pgv_lang["no_link"] = "沒有回鏈接";
$pgv_lang["see"] = "看到";
$pgv_lang["noref"] = "沒有人提到這條記錄";
$pgv_lang["tag"] = "標籤";
$pgv_lang["spacing"] = "間距";
$pgv_lang["ADVANCED_NAME_FACTS"] = "高級名稱事件";
$pgv_lang["ADVANCED_PLAC_FACTS"] = "高級地名事件";
$pgv_lang["tradition_spanish"] = "西班牙";
$pgv_lang["tradition_portuguese"] = "葡萄牙語";
$pgv_lang["tradition_icelandic"] = "冰島";
$pgv_lang["tradition_paternal"] = "繼承父姓";
$pgv_lang["tradition_polish"] = "波蘭";
$pgv_lang["tradition_none"] = "沒有";

?>
