<?php
/**
 * Hebrew Language Configure Help file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2021  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @translathor Meliza
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.he.php 7287 2021-02-14 14:41:32Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["SHOW_LIST_PLACES"]			= "רמות מקום ברשומות";

$pgv_lang["new_gedcom_title"]			= "חקר משפחה מקובץ [#GEDCOMFILE#]";
$pgv_lang["USE_MEDIA_VIEWER"]			= "השתמש במציג מדיה";
$pgv_lang["USE_MEDIA_FIREWALL"]		= "השתמש בחומת אש של מדיה";
$pgv_lang["USE_MEDIA_FIREWALL_help"]		= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />See the Wiki for a description of how to use the Media Firewall. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a><br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]	= "ספריית השורש בחומת האש של מדיה";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "כאשר שדה זה ריק, משתמשים בתיקיית <b>#GLOBALS[INDEX_DIRECTORY]#</b>.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]		= "הגן על תמונות ממוזערות של תמונות מוגנות";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "הראה tagline של עכבישים";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "הראה קרבה לאדם פרטי";
$pgv_lang["SYNC_GEDCOM_FILE"]		= "סנכרן שינויים לתוך קובץ GEDCOM";
$pgv_lang["COMMIT_COMMAND"] 			= "פקודת Commit של ניהול מהדורות";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "הראה חיפוש באתרים מרובים";
$pgv_lang["SHOW_NO_WATERMARK"]		= "מי יכול לראות תמונות ללא סימני מים?";
$pgv_lang["WATERMARK_THUMB"]		= "הוסף סימני מים לתמונות ממוזערות?";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "שמור תמונות ממוזערות בעלות סימני מים על השרת?";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "שמור תמונות בגודל מלא בעלות סימני מים על השרת?";
$pgv_lang["DB_UTF8_COLLATION"]			= "השתמש במאגר נתונים כדי לספק המרה colaion ל-UTF-8 ";
$pgv_lang["INDI_FACTS_ADD"] 			= "עובדות אישיות שניתן להוסיף";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "עובדות אישיות יחידות במינן";
$pgv_lang["INDI_FACTS_QUICK"] 			= "עובדות אישיות עיקריות";
$pgv_lang["FAM_FACTS_ADD"] 			= "עובדות משפחתיות שניתן להוסיף";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "עובדות משפחתיות יחידות במינן";
$pgv_lang["FAM_FACTS_QUICK"] 			= "עובדות משפחתיות עיקריות";
$pgv_lang["SOUR_FACTS_ADD"] 			= "עובדות מקור שניתן להוסיף";
$pgv_lang["SOUR_FACTS_UNIQUE"] 		= "עובדות מקור יחידות במינן";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "עובדות עיקריות של מקורות";
$pgv_lang["REPO_FACTS_ADD"] 			= "עובדות מאגר שניתן להוסיף";
$pgv_lang["REPO_FACTS_UNIQUE"] 		= "עובדות מאגר יחידות במינן";
$pgv_lang["REPO_FACTS_QUICK"] 			= "עובדות עיקריות של מאגר";
$pgv_lang["MEDIA_ID_PREFIX"]			= "קידומת קוד זיהוי של מדיה";
$pgv_lang["FAM_ID_PREFIX"]			= "קידומת קוד זיהוי של משפחה";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]	= "הראה תמיד עובדות של משפחות בעדכון מהיר";
$pgv_lang["QUICK_ADD_FAMFACTS"]		= "הראה עובדות של משפחות בעדכון מהיר";
$pgv_lang["QUICK_REQUIRED_FACTS"]		= "הראה תמיד עובדות בעדכון מהיר";
$pgv_lang["QUICK_ADD_FACTS"]			= "הראה עובדות בעדכון מהיר";
$pgv_lang["USE_GEONAMES"]			= "השתמש במאגר נתונים GeoNames";
$pgv_lang["AUTO_GENERATE_THUMBS"]		= "תמונות מזעריות שנוצרו בצורה אוטומטית";
$pgv_lang["more_help_advice"]			= "<br /><b>עזרה נוספת</b><br />עזרה נוספת זמינה ע\"י לחיצה על ה-<b>?</b> ליד פירטי הדף.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "רוחב התמונות המזעריות שייווצרו";
$pgv_lang["USE_SILHOUETTE"]			= "השתמש בצלליות";
$pgv_lang["SHOW_SOURCES"]			= "הצג מקורות";
$pgv_lang["SPLIT_PLACES"]			= "פצל מקומות במצב עריכה";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "קו מתחת לשמות בגרשיים";
$pgv_lang["PRIVACY_BY_RESN"]			= "השתמש בהגבלת הפרטיות של (GEDCOM (RESN";
$pgv_lang["SHOW_LDS_AT_GLANCE"]		= "הראה קודי חוק המורמונים בתיבות התרשימים";
$pgv_lang["GEDCOM_DEFAULT_TAB"]		= "חוצץ ברירת המחדל שיוצג על דף הנתונים האישיים";
$pgv_lang["SHOW_MARRIED_NAMES"]		= "הראה שמות נישואין ברשימת השמות";
$pgv_lang["SHOW_QUICK_RESN"]			= "הראה שדות פרטיים על טופס #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE"]			= "השתמש בטופס #pgv_lang[quick_update_title]#";
$pgv_lang["SEARCHLOG_CREATE"]		= "שמור קבצי לוג של החיפוש";
$pgv_lang["CHANGELOG_CREATE"]		= "שמור קבצי לוג של השינויים";
$pgv_lang["CHART_BOX_TAGS"]			= "נתונים אחרים שניתן להציג בתרשימים";
$pgv_lang["FULL_SOURCES"]			= "השתמש במקורות מלאים";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "סוג מקור ";

//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]				= "בסיס GEDCOM";
$pgv_lang["media_conf"]				= "מולטימדיה";
$pgv_lang["media_general_conf"]			= "כללי";
$pgv_lang["media_firewall_conf"]			= "חומת מגן של מדיה";
$pgv_lang["accpriv_conf"]				= "גישה ופרטיות";
$pgv_lang["displ_conf"]				= "תצוגה ומבנה";
$pgv_lang["displ_names_conf"]			= "שמות";
$pgv_lang["displ_comsurn_conf"] 			= "שמות משפחה שכיחים";
$pgv_lang["displ_layout_conf"]			= "מבנה";
$pgv_lang["displ_hide_conf"]				= "הסתר והראה";
$pgv_lang["editopt_conf"]				= "אפשרויות העריכה";
$pgv_lang["useropt_conf"]				= "בחירות משתמש";
$pgv_lang["contact_conf"]				= "נתוני קשר";
$pgv_lang["meta_conf"]				= "מאפייני תצורה של האתר ותווי META";
$pgv_lang["gedconf_head"]				= "תצורת GEDCOM";
$pgv_lang["other_theme"]				= "אחר, הקלד";
$pgv_lang["performing_update"]			= "מבצע עדכון:";
$pgv_lang["config_file_read"]				= "קריאת קובץ תצורה";
$pgv_lang["does_not_exist"]				= "לא קיים";
$pgv_lang["media_drive_letter"]			= "אין לכלול בכתובת המדיה את האות של הכונן; יתכן והמדיה לא תוצג.";
$pgv_lang["db_setup_bad"]				= "התצורה הנוכחית שלך של מסד הנתונים אינה מתאימה. נא בדוק את הפרמטרים של קישוריות מסד הנתונים ועצב מחדש.";
$pgv_lang["db"]					= "מסד נתונים";
//$pgv_lang["dbase"]					= "dBase";
$pgv_lang["current_gedcoms"]			= "GEDCOM-ים נוכחיים";
$pgv_lang["ged_gedcom"]				= "קובץ GEDCOM";
$pgv_lang["ged_title"]					= "כותרת GEDCOM";
$pgv_lang["ged_config"]				= "קובץ תצורה";
$pgv_lang["ged_search"]				= "קובצי לוג של החיפוש";
$pgv_lang["ged_change"]				= "קובצי לוג השינויים";
$pgv_lang["ged_privacy"]				= "קובץ פרטיות";
$pgv_lang["disabled"]					= "נפסל";
$pgv_lang["mouseover"]				= "עכבר עובר מעל";
$pgv_lang["mousedown"]				= "עכבר מושבת";
$pgv_lang["click"]					= "קליק עם עכבר";
$pgv_lang["enter_db_pass"]			= "עבור הגנה, עליך להכניס תמיד #pgv_lang[DBUSER]# ו#pgv_lang[DBPASS]# כאשר משנים את ערכי התצורה.";
$pgv_lang["server_url_note"]			= "זה צריך להיות ה-URL לתיקיית ה-PhpGedView שלך. שנה אותו רק אם אתה בטוח שאתה יודע מה שאתה עושה. PhpGedView חישב ערך <b><span dir=\"ltr\">#GUESS_URL#</span></b>";
$pgv_lang["DBTYPE"]				= "סוג מסד נתונים";
$pgv_lang["DBHOST"]			= "מארח מסד נתונים";
$pgv_lang["DBPORT"]			= "Port של מאגר מידע";
$pgv_lang["DBUSER"]			= "קוד משתמש של מסד נתונים";
$pgv_lang["DBPASS"]				= "סיסמת מסד הנתונים";
$pgv_lang["DBNAME"]			= "שם מסד הנתונים";
$pgv_lang["upload_path"]			= "נתיב טעינה";
$pgv_lang["gedcom_path"]			= "נתיב ושם קובץ ה-GEDCOM";
$pgv_lang["CHARACTER_SET"]		= "סוג קידוד תווים";
$pgv_lang["LANGUAGE"] 			= "שפה";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "האם כל משתמש יכול לשנות שפה";
$pgv_lang["CALENDAR_FORMAT"] 		= "מבנה לוח שנה";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "הראה אלפים בתאריך עברי";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "הראה גרשיים בתאריך עברי";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "מספר דורות באילן יוחסין";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]	= "מספר דורות מכסימלי באילן יוחסין";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "מכסימום דורות של צאצאים";
$pgv_lang["USE_RIN"]				= "השתמש במספר RIN במקום בקוד זיהוי של GEDCOM";
$pgv_lang["GENERATE_GUID"]              		= "צור בצורה אוטומטית קודי זיהוי גלובליים ייחודיים";
$pgv_lang["PEDIGREE_ROOT_ID"]			= "אדם ברירת המחדל לאילן יוחסין ולתרשים צאצאים";
$pgv_lang["GEDCOM_ID_PREFIX"]			= "קידומת קוד זיהוי אישי ";
$pgv_lang["SOURCE_ID_PREFIX"]			= "קידומת קוד זיהוי של מקור";
$pgv_lang["REPO_ID_PREFIX"]			= "קידומת קוד זיהוי של מאגר";
$pgv_lang["PEDIGREE_FULL_DETAILS"]		= "הראה נתוני לידה ופטירה בתרשימים";
$pgv_lang["PEDIGREE_SHOW_GENDER"]		= "הראה צלמית מין בתרשימים";
$pgv_lang["PEDIGREE_LAYOUT"]			= "מבנה ברירת המחדל של אילן היוחסין";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "הראה תיבות ריקות באילן היוחסין";
$pgv_lang["ZOOM_BOXES"]				= "אפשר הגדלה/הקטנה של תיבות התרשימים (ZOOM)";
$pgv_lang["LINK_ICONS"]				= "הופעת תיבות קישור בתיבת התרשימים";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "קצר תגים בתרשימים";
$pgv_lang["SHOW_AGE_DIFF"]			= "הראה הפרשי תאריכים";
$pgv_lang["SHOW_PARENTS_AGE"]		= "הראה את גיל ההורים ליד תאריך הלידה של הילד";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      	= "הראה מאורעות של קרובים על הדף האישי";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      	= "הרחב אוטומטית את רשימת המאורעות של קרובים";
$pgv_lang["EXPAND_SOURCES"]      		= "הרחב אוטומטית את המקורות";
$pgv_lang["EXPAND_NOTES"]      			= "הרחב אוטומטית את ההערות";
$pgv_lang["SHOW_LEVEL2_NOTES"]     		= "הראה את כל ההתייחסויות להערות ומקורות בחוצצי הערות ומקורות";
$pgv_lang["HIDE_LIVE_PEOPLE"]			= "אפשר פרטיות";
$pgv_lang["REQUIRE_AUTHENTICATION"] 	= "דרוש אשור מהמבקרים";
$pgv_lang["PAGE_AFTER_LOGIN"]			= "הדף שיעלה אחרי התחברות";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "טכסט ברוכים הבאים על דף התחברות ";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "אין טכסט מוגדר מראש";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "טכסט מוכן מראש המודיע שכל המשתמשים יכולים לבקש קוד משתמש.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "טכסט מוכן מראש המודיע שהמנהלן יחליט אם לתת קוד משתמש";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "טכסט מוכן מראש המודיע שרק בני משפחה יכולים לבקש קוד משתמש.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "בחר טכסט ברוכים הבאים שיוקלד למטה.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "טכסט ברוכים הבאים מותאם";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] 	 = "כותרת סטנדרטית לטכסט ברוכים הבאים מותאם";
$pgv_lang["SHOW_REGISTER_CAUTION"]		= "הראה הסכם הגנה על פרטיות על הדף «בקש קוד משתמש חדש»";
$pgv_lang["CHECK_CHILD_DATES"] 		= "בדוק תאריכי ילדים";
$pgv_lang["MAX_ALIVE_AGE"]			= "גיל שממנו מניחים שאדם ניפטר";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "לאפשר למשתמשים לראות נתוני קובץ GEDCOM";
$pgv_lang["ALLOW_EDIT_GEDCOM"]	= "אפשר עריכה מקוונת";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "אפשר סיום אוטומטי";
$pgv_lang["EDIT_AUTOCLOSE"]		= "סגור אוטומטית חלון עריכה";
$pgv_lang["POSTAL_CODE"]  		= "מיקום המיקוד";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "מספר מכסימלי של שמות משפחה אישיים";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "מספר מכסימלי של שמות משפחה של משפחות";
$pgv_lang["SURNAME_LIST_STYLE"]	= "סגנון רשימת שמות משפחה";
$pgv_lang["SHOW_LAST_CHANGE"]		= "הראה ברשימות את תאריך השינוי האחרון של רשומת ה-GEDCOM";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "הראה תאריכים מוערכים עבור לידה ופטירה";
$pgv_lang["SHOW_PEDIGREE_PLACES"]		= "מספר הרמות של המקומות המוצגים בתיבות האישיות:";
$pgv_lang["MULTI_MEDIA"]				= "אפשר מאפיינים של מולטימדיה";
$pgv_lang["MEDIA_EXTERNAL"]			= "שמור קישורים";
$pgv_lang["MEDIA_DIRECTORY"]			= "תיקיית מולטימדיה";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]		= "מספר הרמות של תיקיות מולטימדיה";
$pgv_lang["USE_THUMBS_MAIN"]			= "השתמש בתמונות מזעריות";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "הראה את שם הקובץ במציג המדיה";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "הראה קישור הורדה במציג המדיה";
$pgv_lang["ENABLE_CLIPPINGS_CART"]		= "אפשר עגלת גזירות";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "החבא שגיאות GEDCOM";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "הוסף רווח במקום שההערות גלשו";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "הראה קישור לעזרה ע\"י סימן <b>?</b>";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "הגבלת הימים באזור האירועים הקרובים";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "הכמות המינימאלית של מקרים כדי להיכלל ב-\"שמות המשפחה השכיחים\"";
$pgv_lang["COMMON_NAMES_ADD"]		= "שמות שיש להוסיף לרשימת שמות המשפחה השכיחים (הפרד ע\"י פסיק)";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "שמות שיש להסיר מרשימת שמות המשפחה השכיחים (הפרד ע\"י פסיק)";
$pgv_lang["HOME_SITE_URL"]		= "URL של האתר הראשי";
$pgv_lang["HOME_SITE_TEXT"]		= "טכסט של האתר הראשי";
$pgv_lang["CONTACT_EMAIL"]		= "הקשר לנתוני שושלת יוחסין";
$pgv_lang["CONTACT_METHOD"] 		= "שיטת הקשר";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "כתובת מענה עבור PhpGedView";
$pgv_lang["WEBMASTER_EMAIL"]		= "הקשר הטכני";
$pgv_lang["SUPPORT_METHOD"] 		= "שיטת התמיכה";
$pgv_lang["SHOW_FACT_ICONS"] 		= "הראה צלמיות של עובדות";
$pgv_lang["FAVICON"]			= "צלמית של מועדפים";
$pgv_lang["THEME_DIR"]			= "תיקיית עיצוב";
$pgv_lang["TIME_LIMIT"] 			= "הגבלת זמן של PHP";
$pgv_lang["LOGIN_URL"]			= "URL של התחברות";
$pgv_lang["SHOW_STATS"] 			= "הצג סטטיסטיקות של העיבוד";
$pgv_lang["SHOW_COUNTER"] 		= "הראה מוני פגיעה";
$pgv_lang["LOGFILE_CREATE"]		= "גנוז קבצי יומן";
$pgv_lang["ALLOW_THEME_DROPDOWN"]	= "הראה את הבחירה הנגללת של שינויי העיצוב";
$pgv_lang["MAX_VIEW_RATE"]		= "שעור צפייה מכסימלי של דפים";
$pgv_lang["META_AUTHOR"]		= "תווית META של מחבר";
$pgv_lang["META_AUTHOR_descr"]		= "השאר שדה זה ריק כדי להשתמש בשם המלא של #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "תווית META של מוציא לאור";
$pgv_lang["META_PUBLISHER_descr"]	= "השאר שדה זה ריק כדי להשתמש בשם המלא של #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "תווית META של זכויות יוצרים";
$pgv_lang["META_COPYRIGHT_descr"]	= "השאר שדה זה ריק כדי להשתמש בשם המלא של #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "תווית META של תאור";
$pgv_lang["META_DESCRIPTION_descr"]	= "השאר שדה זה ריק כדי להשתמש בכותרת של ה-GEDCOM הפעיל.";
$pgv_lang["META_PAGE_TOPIC"]		= "תווית META של נושא הדף";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "השאר שדה זה ריק כדי להשתמש בכותרת של ה-GEDCOM הפעיל עבור הערך זה.";
$pgv_lang["META_AUDIENCE"]		= "תווית META של קהל";
$pgv_lang["META_PAGE_TYPE"]		= "תווית META של סוג הדף";
$pgv_lang["META_ROBOTS"]		= "תווית META של רובוטים";
$pgv_lang["META_REVISIT"]			= "תדירות ש-METACRAWLER-ים אמורים לבקר תווית META";
$pgv_lang["META_KEYWORDS"]		= "תווית META של מילות מפתח";
$pgv_lang["META_TITLE"]			= "הוסף לתג הכתרת TITLE";
$pgv_lang["ENABLE_RSS"]			= "אפשר RSS";
$pgv_lang["RSS_FORMAT"]			= "מבנה RSS";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "בדוק שקובצי ה-GEDCOM ניתנים להורדה";
$pgv_lang["gedcom_download_secure"]	= "לא ניתן להוריד את קובץ #GEDCOM# .";
$pgv_lang["welcome_new2"]			= "<br /><br />מכיוון שאתה רואה דף זה, התקנת בהצלחה את PhpGedView על שרת האינטרנט שלך ואתה מוכן לעצב אותו לפי בחירתך.<br />";
$pgv_lang["return_editconfig"]			= "תוכל לחזור להגדרה זו מתי שתרצה ע\"י הצבעה של תוכנת הגלישה שלך על הקובץ <i>edit_config.php</i>, או ע\"י לחיצה על הקישור <b>תצורה</b> הנמצא בדף <b>ניהול של PhpGedView </b>.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "תוכל לחזור להגדרה זו מתי שתרצה ע\"י לחיצה על קישור: <b>ערוך</b> הנימצאת בטבלת <b>#pgv_lang[current_gedcoms]#</b> על הדף <b>#pgv_lang[gedcom_adm_head]#</b> או ע\"י הפניית הדפדפן שלך לקובץ ה-<i>editconfig_gedcom.php</i>.<br />";
$pgv_lang["save_config"] 			= "שמור תצורה";
$pgv_lang["download_gedconf"]		= "הורד את תצורת GEDCOM.";
$pgv_lang["not_writable"]			= "גילינו ש-PHP לא יכול לכתוב על קובץ התצורה שלך. אתה יכול להשתמש בכפתור <b>#pgv_lang[download_file]#</b> כדי לשמור את ההגדרה שלך לתוך קובץ שאותו תוכל להעלות ידנית.";
$pgv_lang["upload_to_index"]			= "העלה את הקובץ לתיקיית האינדקסים שלך: ";
$pgv_lang["import_sql"]			= "בתיקיית האינדקס שלך יש קבצי SQL. מכיוון שיתכן שמקורם בכלי ההגירה של משתמשים, תוכל לייבא את הנתונים למאגר הנתונים שלך. האם לנסות לייבא את הקובץ למאגר המידע שלך עכשיו? כל הנתונים הקשורים למשתמשים (משתמשים, חדשות, מועדפים, מבנה האזורים וההודעות) ייעלמו ממאגר המידע שלך.<br /><br />אם תחליט להמשיך לייבא את הנתונים, PhpGedView יינשא לייבא את הנתונים. אם דבר זה לא מצליח, תתבקש להגדיר את המשתמש האדמיניסטרטיבי הראשוני.<br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "ערוך פרטיות";
$pgv_lang["edit_privacy_title"]			= "ערוך הגדרת פרטיות של GEDCOM";
$pgv_lang["save_changed_settings"]		= "שמור שינויים";
$pgv_lang["add_new_pp_setting"]		= "הוסף הגדרות חדשות לפרטיות לפי קוד זיהוי";
$pgv_lang["add_new_up_setting"]		= "הוסף הגדרה חדשה לפרטיות משתמש";
$pgv_lang["add_new_gf_setting"]		= "הוסף הגדרה חדשה לפרטיות ערכים כלליים";
$pgv_lang["add_new_pf_setting"]		= "הוסף הגדרה חדשה לפרטיות ערכים לפי קוד זיהוי";
$pgv_lang["file_read_error"]			= "ש ג י א ה!!! לא ניתן לקרוא קובץ פרטיות!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "ערוך הגדרות קיימות לפרטיות לפי קוד זיהוי";
$pgv_lang["edit_exist_user_privacy_settings"]	= "ערוך הגדרות קיימות לפרטיות משתמש";
$pgv_lang["edit_exist_global_facts_settings"]	= "ערוך הגדרות קיימות לפרטיות ערכים כלליים";
$pgv_lang["edit_exist_person_facts_settings"]	= "ערוך הגדרה קיימת של פרטיות ערכים אישיים";
$pgv_lang["general_privacy"]			= "ערכי פרטיות כלליים";
$pgv_lang["person_privacy"]			= "ערכי פרטיות לפי קוד זיהוי";
$pgv_lang["user_privacy"]			= "ערכי פרטיות של משתמשים";
$pgv_lang["global_facts"]			= "ערכי פרטיות של נתונים גלובליים";
$pgv_lang["person_facts"]			= "ערכי פרטיות של נתונים לפי קוד זיהוי";
$pgv_lang["accessible_by"]			= "הראה ל-";
$pgv_lang["hide"]				= "הסתר";
$pgv_lang["show_question"]			= "הראה?";
$pgv_lang["user_name"]			= "קוד משתמש";
$pgv_lang["name_of_fact"]			= "שם העובדה";
$pgv_lang["choice"]				= "בחירה";
$pgv_lang["fact_show"]			= "הראה את העובדה";
$pgv_lang["fact_details"]			= "הראה פרטי העובדה";
$pgv_lang["privacy_header"]			= "ערוך הגדרות פרטיות";
$pgv_lang["unable_to_find_privacy_indi"]	= "לא נימצא אדם עם קוד זיהוי";
$pgv_lang["save_and_import"]		= "-אחרי שתשמור תצורת הGEDCOM תצטרך לייבא את ה-GEDCOM ע\"י לחיצה על כפתור <b>ייבא GEDCOM</b> או ע\"י מעבר ל<b>ניהול->ניהול GEDCOM-ים->ייבא</b>";
$pgv_lang["help_info"]				= "ניתן לקבל עזרה ע\"י לחיצה על \"?\" אדום ליד כל תא.";
$pgv_lang["SHOW_LIVING_NAMES"]	= "הראה שמות של אנשים חיים";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]	= "הראה עזרה למחקר";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]	= "השתמש בפרטיות בקשרי משפחה";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]	= "אורך מכסימלי של נתיב קשר משפחתי";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]	= "בדוק קשרי נישואין";
$pgv_lang["SHOW_DEAD_PEOPLE"]	= "הראה אנשים שנפטרו";
$pgv_lang["select_privacyfile_button"]	= "בחר קובץ פרטיות";
$pgv_lang["PRIVACY_BY_YEAR"]		= "הגבל את הפרטיות לפי גיל האירוע";

//-- language edit utility
$pgv_lang["edit_langdiff"]			= "ערוך תוכן קבצי השפות";
$pgv_lang["bom_check"]			= "בדיקת (Byte Order Mark (BOM";
$pgv_lang["bom_check_desc"]		= "בדיקה זו תנתח את כל קבצי השפה לגבי ה-(BOM (Byte Order Mark. אם ה-BOM ימצא, הוא ימחק מהקובץ המושפע. הקודים המיוחדים הללו עלולים לגרום לפעולה שגוייה בחלקים של PhpGedView.";
$pgv_lang["lang_debug"]			= "אופציית ניפוי באגים של טכסט עזרה";
$pgv_lang["lang_debug_desc"]		= "התרת האופציה מדפיסה שמות של משתני שפה שבשימוש בטכסט העזרה, בחלון הצץ של טכסט העזרה.<br />הוא עוזר למתרגמים לקבוע את שם המשתנה אם יש להתאים את הטכסט.<br />ההגדרה בתוקף רק בישיבת ה-PhpGedView הנוכחית שלך.";
$pgv_lang["lang_debug_use"]			= "השתמש באופציית ניפוי באגים של טכסט עזרה";
$pgv_lang["bom_not_found"]			= "אף BOM לא התגלה.";
$pgv_lang["bom_found"]			= "BOM נמצא ב-";
$pgv_lang["edit_lang_utility"]			= "תוכנת עריכה של קובץ שפה";
$pgv_lang["edit_lang_utility_desc"]		= "ניתן להשתמש בתוכנת עזר זו בעריכת תוכן של קובץ שפה ע\"י שימוש בקובץ האנגלי.<br /><br />התוכנה מראה את התוכן של קובץ השפה האנגלית המקורי (יש תשעה קבצים כאלה) ובמקביל את התוכן של קובץ השפה הנבחרת שלך.  לחץ על ההודעה מתחת לגרסה האנגלית ואז יפתח חלון חדש, ובו תוכל לעדכן את הטכסט. ניתן לשמור את השינוי או לוותר עליו.";
$pgv_lang["language_to_edit"]		= "שפת עריכה";
$pgv_lang["file_to_edit"]			= "סוג קובץ שפה לעריכה";
$pgv_lang["check"]			= "בדוק";
$pgv_lang["lang_save"]		= "שמור";
$pgv_lang["contents"]			= "תוכן";
$pgv_lang["listing"]			= "רישום";
$pgv_lang["no_content"]		= "אין תוכן";
$pgv_lang["editlang"]			= "ערוך";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />ערוך הודעה מקובץ שפה.<br />";
$pgv_lang["savelang"]			= "שמור";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />שמור הודעה שנערכה בקובץ השפה.<br />";
$pgv_lang["original_message"]		= "הודעה מקורית";
$pgv_lang["message_to_edit"]		= "הודעה שרוצים לערוך";
$pgv_lang["changed_message"]		= "שנה תוכן";
$pgv_lang["language_to_export"]		= "שפה שאותה רוצים לייצא";
$pgv_lang["export_lang_utility"]		= "תוכנת עזר ליצוא קובץ שפות";
$pgv_lang["export"]				= "יצא";
$pgv_lang["export_lang_utility_desc"]	= "ניתן ליצור תיעוד למנהלנים.<br /><br />כלי עזר זה ייצור גרסת HTML של קובץ העזרה של התצורה בשפה הנבחרת. תוכל להשתמש בדפדפן שלך כדי להסתכל על הקובץ הזה הנמצא במבנה להדפסה.";
$pgv_lang["export_ok"]			= "הודעות עזרה יוצאו";
$pgv_lang["compare_lang_utility"]		= "תוכנת השוואה של קובץ שפה";
$pgv_lang["compare_lang_utility_desc"]	= "כלי עזר זה משווה בין שני קבצי שפות ומספק רשימה של התוספות והחסרים ביניהם.<br /><br />קרא את הקבצי ה-CHANGELOG לגבי השינויים בגרסה האנגלית. קבצי האנגלית ישמשו יחוס לשפות האחרות.";
$pgv_lang["new_language"]			= "שפת המקור";
$pgv_lang["old_language"]			= "שפה משנית";
$pgv_lang["compare"]				= "השווה";
$pgv_lang["comparing"]			= "קבצי שפה שמושווים";
$pgv_lang["additions"]				= "הוספות";
$pgv_lang["no_additions"]			= "אין הוספות";
$pgv_lang["subtractions"]			= "הורדות";
$pgv_lang["no_subtractions"]			= "אין הורדות";
$pgv_lang["config_lang_utility"]		= "עיצוב השפות הנתמכות";
$pgv_lang["active"]				= "פעיל";
$pgv_lang["edit_settings"]			= "ערוך סביבה";
$pgv_lang["lang_edit"]				= "ערך";
$pgv_lang["lang_language"]			= "שפה";
$pgv_lang["export_filename"]			= "שם קובץ הפלט:";
$pgv_lang["lang_back"]			= "חזור לתפריט הראשי כדי לערוך ולעצב קבצי השפות";
$pgv_lang["lang_back_admin"]		= "חזור לתפריט הניהול";
$pgv_lang["lang_back_manage_gedcoms"]	= "חזור לתפריט ניהול GEDCOM-ים";
$pgv_lang["lang_name_catalan"]		= "קטלאנית (ולנסית)";
$pgv_lang["lang_name_czech"]		= "צ'כית";
$pgv_lang["lang_name_chinese"]		= "סינית";
$pgv_lang["lang_name_danish"]		= "דנית";
$pgv_lang["lang_name_dutch"]		= "הולנדית";
$pgv_lang["lang_name_english"]		= "אנגלית";
$pgv_lang["lang_name_english (uk)"]		= "אנגלית (בריטניה)";
$pgv_lang["lang_name_english (us)"]		= "אנגלית (ארה\"ב)";
$pgv_lang["lang_name_finnish"]		= "פינית";
$pgv_lang["lang_name_french"]		= "צרפתית";
$pgv_lang["lang_name_german"]		= "גרמנית";
$pgv_lang["lang_name_hebrew"]		= "עברית";
$pgv_lang["lang_name_hungarian"] 		= "הונגרית";
$pgv_lang["lang_name_indonesian"]		= "אינדונזית";
$pgv_lang["lang_name_italian"]		= "איטלקית";
$pgv_lang["lang_name_norwegian"]		= "נורבגית";
$pgv_lang["lang_name_polish"]		= "פולנית";
$pgv_lang["lang_name_portuguese"]		= "פורטוגזית";
$pgv_lang["lang_name_romanian"]		= "רומנית";
$pgv_lang["lang_name_russian"]		= "רוסית";
$pgv_lang["lang_name_serbian-la"]		= "סרבית (אותיות לטיניות)";
$pgv_lang["lang_name_spanish"]		= "ספרדית";
$pgv_lang["lang_name_spanish-ar"]		= "ספרדית (אמריקה הלטינית)";
$pgv_lang["lang_name_swedish"]		= "שוודית";
$pgv_lang["lang_name_turkish"]		= "טורקית";
$pgv_lang["lang_name_greek"]		= "יוונית";
$pgv_lang["lang_name_arabic"]		= "ערבית";
$pgv_lang["lang_name_lithuanian"]		= "ליטאית";
$pgv_lang["lang_name_vietnamese"]		= "ויאטנמית";
$pgv_lang["lang_name_slovak"]		= "סלובקית";
$pgv_lang["lang_name_slovenian"] 		= "סלובנית";
$pgv_lang["lang_name_estonian"]		= "אסטונית";
$pgv_lang["lang_new_language"]		= "שפה חדשה";
$pgv_lang["original_lang_name"]		= "שם המקורי של השפה ב#D_LANGNAME#";
$pgv_lang["lang_shortcut"]			= "סימון מקוצר לשפה בשם קובץ שפה";
$pgv_lang["lang_langcode"]			= "קודי השפה";
$pgv_lang["lang_filenames"]			= "קבצי שפות";
$pgv_lang["flagsfile"]				= "קובץ הדגל";
$pgv_lang["text_direction"]			= "כיוון הטכסט";
$pgv_lang["date_format"]			= "מבנה תאריך";
$pgv_lang["time_format"]			= "מבנה זמן";
$pgv_lang["week_start"]		= "יום תחילת השבוע";
$pgv_lang["name_reverse"]		= "שם משפחה קודם";
$pgv_lang["ltr"]				= "שמאל לימין";
$pgv_lang["rtl"]				= "ימין לשמאל";
$pgv_lang["file_does_not_exist"]	= "שגיאה! הקובץ לא קיים...";
$pgv_lang["optional_file_not_exist"]	= "קובץ בחירה זה אינו קיים.";
$pgv_lang["alphabet_upper"]		= "אותיות עיליות";
$pgv_lang["alphabet_lower"]		= "אותיות קטנות";
$pgv_lang["multi_letter_alphabet"]	= "אלף בית של צרוף אותיות";
$pgv_lang["multi_letter_equiv"]		= "תוים שהם ריבוי אותיות";
$pgv_lang["dictionary_sort"]		= "השתמש בכללי המילון למיון";
$pgv_lang["collation"]		= "סדר נתוני בסיס הנתונים שהומר collation";
$pgv_lang["lang_config_write_error"]	= "שגיאה בכתיבת הגדרת השפה לתוך קובץ <b>lang_settings.php</b>. בדוק הרשאות ונסה שנית.";
$pgv_lang["translation_forum"]		= "פורום התרגומים של PhpGedView על SourceForge";
$pgv_lang["lang_set_file_read_error"]	= "ש ג י א ה !!!לא הצליח לקרא את <b>lang_settings.php</b>!";
$pgv_lang["add_new_language_desc"]	= "תוכל להשתמש בתת מערכת זו כדי להוסיף שפה חדשה שעדיין לא נתמכת ב-PhpGedView.<br /><br />תוכל להגדיר את ההגדרות הסטנדרטיות של השפה החדשה. הן כוללות את קודי השפה, כיוון השפה, תחילת השבוע עבור השפה, מבנה השעה, אלף בית וכו'.<br /><br />תקבל עזרה נוספת על ההגדרות של השפות אשר נתמכות ב-PhpGedView אחרי שתבחר את השפה ותלחץ על כפתור ה-<b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />עזרה נוספת קיימת על דף העיצוב של השפה.<br />";
$pgv_lang["add_new_lang_button"]		= "הוסף שפה חדשה";
$pgv_lang["hide_translated"]			= "הסתר מה שתורגם";
$pgv_lang["lang_file_write_error"]		= "ש ג י א ה  !!!<br /><br />לא ניתן לכתוב את השינויים בקובץ השפה הנבחר!<br />בדוק הרשאות כתיבה על <b>#lang_filename#</b>";
$pgv_lang["no_open"]				= "ש ג י א ה !!!<br /><br />לא ניתן לפתוח את הקובץ  <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "שפות המשתמשים";
$pgv_lang["configured_languages"]		= "השפות שבשימוש";

//-- User Migration Tool messages
$pgv_lang["um_header"] 			= "כלי להגירת נתוני משתמשים";
$pgv_lang["um_proceed"] 			= "בחר אופציה או לחץ על הקישור למטה כדי לחזור לתפריט הניהול<br />";
$pgv_lang["um_creating"] 			= "יוצר";
$pgv_lang["um_sql_index"] 			= "כלי זה יצור <i>authenticate.php</i> ומספר קבצי <i>.dat</i> בתיקיית ה-index שלך.<br /><br />לאחר יצירה מוצלחת תוכל לעבור לצורת האינדקס עם כל המשתמשים הנוכחיים והודעותיהם, מועדפים, חדשות ומבנה ה-MyGedView זמינים.<br /><br />שים לב: לאחר מעבר לצורת אינדקס יש לייבא שוב את קבצי ה-GEDCOM.<br />";
$pgv_lang["um_file_create_fail1"] 		= "יצירת קובץ חדש נכשלה - קיים כבר קובץ בשם הזה:";
$pgv_lang["um_file_create_fail2"] 		= "לא ניתן ליצר";
$pgv_lang["um_file_create_fail3"] 		= "בדוק הרשאות גישה לתיקיה הזו.";
$pgv_lang["um_file_create_succ1"] 		= "קובץ חדש נוצר בהצלחה:";
$pgv_lang["um_file_not_created"] 		= "קובץ לא נוצר.";
$pgv_lang["um_nomsg"] 			= "נראה שאין הודעות במערכת.";
$pgv_lang["um_nofav"] 			= "נראה שאין מועדפים במערכת.";
$pgv_lang["um_nonews"] 			= "נראה שאין חדשות במערכת.";
$pgv_lang["um_noblocks"] 			= "נראה שאין אזורים במערכת.";
$pgv_lang["um_index_sql"] 			= "כלי זה ייבא <i>authenticate.php</i> וקבצי <i>.dat</i> אחרים מתיקית ה-index שלך למאגר המידע שלך.<br />";
$pgv_lang["um_noaction"] 			= "אין צורך בפעולה כלשהי להגירת נתוני משתמשים לצורת SQL.<br /><br />כאשר תעבור לצורת SQL, תצטרך להפעיל שנית את כלי הגירת המשתמשים כדי לייבא את כל הנתונים למאגר נתוני SQL.  PhpGedView ישתמש בקבצים הקיימים בצורת האינדקס.<br /><br /><b><u>אין</u> למחוק <i>authenticate.php</i> וקבצי <i>.dat</i> מתיקיית ה- index שלך בזמן המעבר.</b><br />";
$pgv_lang["um_import"] 			= "ייבא";
$pgv_lang["um_export"] 			= "ייצא";
$pgv_lang["um_explain"] 			= "כלי זה ייבא או ייצא נתוני משתמשים בין טבלאות SQL לבין קבצי צורת אינדקס.<br /><br />נתוני משתמשים, מועדפים, הגדרות של אזורים, הודעות וחדשות יהיו שוב זמינים לאחר ההגירה.<br /><br /><b>זהירות</b><br />לא ניתן להשתמש בכלי זה להגירת נתונים בין מהדורות שונות של PhpGedView. וודא שהנתונים מועברים בים מהדורות זהות של PhpGedView.<br /><br /><b>ייבוא</b><br />אם תבחר לייבא קבצי נתוני משתמשים מצורת אינדקס, אז כל נתוני המשתמשים בטבלאות מאגר הנתונים <b>ידרסו</b>. הכלי <b>אינו</b> מאחד את הנתונים. לאחר הרצת היבוא לא ניתן עוד לשחזר את המידע הישן על ידי PhpGedView.<br /><br /><b>ייצוא</b><br />אם אתה מייצא נתוני משתמשים ממאגר נתוני SQL שלך לקובצי צורת אינדקס, הכלי יבנה קבצי <i>authenticate.php</i> ומספר קבצי <i>.dat</i> בתיקיית ה-index. קבצים בעלי שם זהה שכבר קיימים <u>לא</u> ידרסו; <u>חייבים</u> להסירם ידנית. לאחר מעבר לצורת אינדקס, כל המידע יהיה זמין מידית.<br /><br /><b>הערה:</b> לאחר מעבר לצורת אינדקס, עליך לייבא שוב את קבצי ה-GEDCOM שלך.<br />";
$pgv_lang["um_tool_help"] 			= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] 		= "~הסב משתמשים מצורת SQL לצורת אינדקס~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] 		= "~הסב משתמשים מצורת אינדקס לצורת SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] 			= "מייבא משתמשים";
$pgv_lang["um_imp_blocks"] 			= "מייבא אזורים";
$pgv_lang["um_imp_favorites"] 		= "מייבא מועדפים";
$pgv_lang["um_imp_messages"] 		= "מייבא הודעות";
$pgv_lang["um_imp_news"] 			= "מייבא חדשות";
$pgv_lang["um_nousers"] 			= "קובץ <i>authenticate.php</i> לא נמצא בתיקיית ה-index שלך. ההגירה מבוטלת.";
$pgv_lang["um_imp_succ"] 			= "היבוא עבר בהצלחה";
$pgv_lang["um_imp_fail"] 			= "היבוא נכשל";
$pgv_lang["um_backup"] 			= "גיבוי";
$pgv_lang["um_zip_succ"] 			= "קובץ ZIP נוצר בהצלחה.";
$pgv_lang["um_zip_dl"] 			= "הורד קובץ גיבוי במבנה ZIP ";
$pgv_lang["um_bu_explain"] 			= "כלי זה יכול ליצור גיבוי לסוגי נתונים שונים של PhpGedView.<br /><br />הנתונים שתחליט לגבות יאספו בקובץ ZIP, שאותו תוכל להוריד על ידי לחיצה על הקישור בתחתית הדף לאחר שהגיבוי יסתיים בהצלחה.<br /><br />קובץ ה-ZIP ישמר בתיקיית ה-Index שלך עד שתסיר אותו בצורה ידנית.<br />";
$pgv_lang["um_bu_help"] 			= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 			= "קובץ תצורה של PhpGedView";
$pgv_lang["um_bu_gedcoms"] 		= "קבצי GEDCOM";
$pgv_lang["um_bu_gedsets"] 			= "קבצי הגדרות, תצורה ופרטיות של GEDCOM";
$pgv_lang["um_bu_logs"] 			= "קבצי לוג של חיפוש GEDCOM וקבצי לוג של PhpGedView";
$pgv_lang["um_bu_usinfo"] 			= "הגדרות משתמש, הגדרות אזורים, מועדפים, הודעות, חדשות";
$pgv_lang["um_bu_media"]			= "קובצי מדיה";
$pgv_lang["um_mk_bu"] 			= "צור גיבוי";
$pgv_lang["um_nofiles"] 			= "לא נמצאו קבצים לגיבוי.";
$pgv_lang["um_files_exist"] 			= "קובץ אחד או יותר קיימים כבר. האם אתה רוצה לעלות עליהם?";
$pgv_lang["um_results"]			= "תוצאות";
$pgv_lang["preview_faq_item"] 		= "הצגה מוקדמת של כל ישויות FAQ";
$pgv_lang["restore_faq_edits"] 		= "שחזר פונקציונאליות של עריכת FAQ";
$pgv_lang["add_faq_item"] 			= "הוסף ישות שאלות נפוצות (FAQ)";
$pgv_lang["edit_faq_item"] 			= "ערוך ישות FAQ";
$pgv_lang["delete_faq_item"] 			= "מחק ישותם FAQ";
$pgv_lang["moveup_faq_item"] 		= "העבר ישות FAQ למעלה";
$pgv_lang["movedown_faq_item"] 		= "העבר ישות FAQ למטה";
$pgv_lang["index_gedcom_news_adm_help"]= "אזור החדשות של ה-GEDCOM מאפשר שימוש ב<b>תווי וכניסות HTML</b>.<br /> אין להשתמש ב-HTML לכותרות של חדשות.<br /><br />חשוב תמיד להשתמש בתוויות התחלה וסיום. למנהלני האתר דרושה הבנה בסיסית של HTML.התוכנית משתמשת גם ב-<b>גיליונות סגנון - (Style Sheets (CSS </b>לכל עיצוב יש CSS משלו. תוכל להשתמש במשפחות - classes מה-CSS הללו כדי לשלוט בסגנון ההופעה של הודעתך.<br /><br />אם תזדקק לעזרה נוספת על נושא זה, באתר PhpGedView יש דוגמאות איך להשתמש בתווים הללו לאזור חדשות ה-GEDCOM שלך.<br /><br />בדומה לרשימת שאלות נפוצות  FAQ, הכותרות והטכסטים של חדשות מאפשרות הפניות משובצותGEDCOM embedded למשתני \$pgv_lang, \$factarray, ו-\$GLOBALS כדי לספק גמישות מושלמת ביצירת פרטי חדשות שיהיו רגישים לשפה הפעילה כעת.<br /><br />התיאור הבא נלקח מטכסט העזרה של רשימת שאלות הנפוצות ומתאים בצורה דומה equally applicable לפרטי החדשות של  GEDCOM.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";

// Media items

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] 		= "נמצאו תוצאות";
$pgv_lang["ged_filter_reset"] 			= "חיפוש נקי";
$pgv_lang["ged_filter_description"] 		= "טכסט של אופציות החיפוש";

?>
