<?php
/**
 * Italian Language file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Lorenzo Simionato, Fabio Parri
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.it.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />Il servizio #pgv_lang[google_analytics]# è descritto in questo <a href='https://it.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>articolo di Wikipedia</a>.<br /><br />Tieni presente che, se scegli di utilizzare questo servizio, Google acquisisce i diritti su tutti i dati che raccoglie sull'attività dei visitatori sul tuo sito.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Seleziona <b>#pgv_lang[yes]#</b> per abilitare il monitoraggio dell'attività sul tuo sito da parte del servizio #pgv_lang[google_analytics]#. È necessario iscriversi a questo servizio prima di abilitare questa opzione.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Inserisci il numero di conto assegnato al tuo sito quando ti sei iscritto al servizio #pgv_lang[google_analytics]#. Questo numero di conto ha il formato <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />Il progetto open source The #pgv_lang[piwik_analytics]#, originariamente chiamato «Piwik», è descritto, in inglese, <a href='https://matomo.org/' target='_blank' title='Sito web ufficiale di Matomo'>qui</a>.<br /><br />Matomo è un'alternativa a #pgv_lang[google_analytics]# che elimina molti dei problemi di privacy. Puoi installare l'applicazione Matomo sul tuo server web o nel tuo dominio, assicurandoti così di avere il controllo completo sui dati di attività che sono stati raccolti.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Seleziona <b>#pgv_lang[yes]#</b> per abilitare il monitoraggio dell'attività sul tuo sito da parte di un server #pgv_lang[piwik_analytics]#. Il tuo sito PhpGedView deve essere registrato su un server Matomo.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Inserisci l'URL di un server Matomo in cui è registrato il tuo sito PhpGedView.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Inserisci il numero del sito assegnato al tuo sito PhpGedView dal server Matomo.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# è un contatore di visite combinato, tracker di visitatori e strumento di visualizzazione geografica.<br /><br />Ogni pagina include un'immagine di mappa in miniatura generata da #pgv_lang[clustrmaps_analytics]#. Quando viene caricata quell'immagine, viene incrementato un contatore sul sito #pgv_lang[clustrmaps_analytics]#. Quando la mappa, visibile a tutti i tuoi visitatori, viene aggiornata (giornalmente, settimanalmente o mensilmente, a seconda del tuo traffico) mostra le posizioni di tutti i visitatori della tua pagina dall'inizio di un intervallo di tempo specifico.<br /><br />Se hai pagato per il servizio #pgv_lang[clustrmaps_analytics]#, facendo clic sull'immagine della mappa in miniatura viene visualizzata una mappa del mondo più grande.<br /><br />Maggiori dettagli sono disponibili, in inglese, sul <a href='http://www.clustrmaps.com/' target='_blank' title='sito #pgv_lang[clustrmaps_analytics]#'>sito #pgv_lang[clustrmaps_analytics]#</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Seleziona <b>#pgv_lang[yes]#</b> per abilitare il monitoraggio dell'attività sul tuo sito da parte di un server #pgv_lang[clustrmaps_analytics]#.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Inserisci l'URL del tuo sito PhpGedView. Questo valore è stato inserito per te e normalmente non dovresti cambiarlo.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Inserisci il numero del server assegnato dal servizio #pgv_lang[clustrmaps_analytics]# quando hai attivato l'account.";

$pgv_lang["SHOW_LIST_PLACES"]	= "Numero di livelli di posizione da mostrare negli elenchi";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Ciò determina la quantità di informazioni sul luogo mostrate nei campi del luogo negli elenchi.<br /><br />L'impostazione del valore su <b>9</b> assicurerà che vengano visualizzate tutte le informazioni sul luogo. Impostando il valore su <b>0</b> (zero) i luoghi verranno nascosti completamente. Impostando il valore su <b>1</b> verrà visualizzato il livello più alto, che normalmente è il paese. Impostandolo su <b>2</b> verranno visualizzati i due livelli più in alto. Il secondo livello più alto, sotto il paese, è spesso lo stato, la provincia o il territorio. Eccetera.";

$pgv_lang["new_gedcom_title"]		= "Genealogia da #GEDCOMFILE#";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />I collegamenti multimediali esistenti devono essere conservati nel database quando viene caricato un GEDCOM sostitutivo. L'opzione <b>#pgv_lang[no]#</b> rimuove i collegamenti multimediali esistenti dal database, mentre l'opzione <b>#pgv_lang[yes]#</b> li conserva.<br /><br />Questa opzione è utile quando esporti il tuo GEDCOM da PhpGedView a un programma di manutenzione GEDCOM offline che non gestisce puntatori multimediali correttamente, quindi reimportare che ha modificato GEDCOM in PhpGedView. In tali circostanze, i puntatori multimediali all'interno del GEDCOM che hai esportato nel tuo programma di editing offline vengono distrutti e dovresti ricollegare tutti i tuoi file multimediali ai record Persona, Famiglia e Fonte appropriati dopo la reimportazione il GEDCOM in PhpGedView.<br /><br />L'opzione <b>#pgv_lang[yes]#</b> dice a PhpGedView di mantenere i collegamenti multimediali esistenti in modo da non doverli ricreare dopo aver importato il GEDCOM modificato, ma ciò richiede la modifica off-line programma per produrre sempre gli stessi numeri di identificazione di persona, famiglia e fonte.<br /><br /><i>Family Tree Maker</i> è uno dei numerosi programmi di editing offline che <u>non</u> gestire correttamente i puntatori agli oggetti multimediali all'interno di GEDCOM. <i>Legacy</i>, tra molti altri, <u>li gestisce</u> correttamente.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Usa il visualizzatore multimediale";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Quando questa opzione è <b>#pgv_lang[yes]#</b>, facendo clic sulle immagini verrà visualizzata la pagina Media Viewer. Questa pagina mostra i dettagli dell'immagine. Se disponi di diritti sufficienti, puoi anche modificare questi dettagli.<br /><br />Quando questa opzione è <b>#pgv_lang[no]#</b>, facendo clic sulle immagini verrà prodotta un'immagine a grandezza naturale in una nuova finestra.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Usa firewall multimediale";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Vedere il Wiki per una descrizione di come utilizzare il firewall multimediale. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Directory principale per il firewall multimediale";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Directory in cui è possibile creare la directory multimediale protetta. #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Quando questo campo è vuoto, verrà utilizzata la directory <b>#GLOBALS[INDEX_DIRECTORY]#</b>.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Proteggi le miniature delle immagini protette";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Quando un'immagine si trova nella directory multimediale protetta, dovrebbe essere protetta anche la sua miniatura?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Mostra lo slogan dei motori di ricerca";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Nelle pagine generate per i motori di ricerca, mostra come ultima riga il particolare motore di ricerca della pagina rilevata. Se questa opzione è attiva, può pregiudicare Google&reg; AdSense verso gli strumenti di ottimizzazione dei motori di ricerca.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Questa opzione manterrà i legami familiari nei registri privatizzati. Ciò significa che vedrai caselle «#pgv_lang[private]#» vuote nell'albero genealogico e in altri grafici con persone private.<br /><br />Questa impostazione è disattivata per impostazione predefinita. Si consiglia invece di attivarlo, di indirizzare il tuo pedigree root nella tua configurazione GEDCOM a una persona che non è privata.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Mostra relazioni private";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />L'impostazione di questo valore su <b>#pgv_lang[yes]#</b> aggiornerà automaticamente il file GEDCOM quando le modifiche vengono accettate nel database. Ciò manterrà il file GEDCOM sincronizzato con il database.<br /><br />Potresti volerlo trasformare in <b>#pgv_lang[no]#</b> per migliorare la velocità del programma e per risparmiare memoria quando accetti le modifiche.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Sincronizza le modifiche nel file GEDCOM";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />La ricerca multi-sito consente agli utenti di cercare su più siti web PhpGedView che hai configurato nell'area di amministrazione Gestisci siti o collegati in remoto. Questa opzione controlla se la funzione di ricerca multisito è disponibile per tutti o solo per gli utenti autenticati.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Mostra ricerca multisito";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Chi può visualizzare le immagini senza filigrana?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Se il firewall multimediale è abilitato, gli utenti vedranno le filigrane se non hanno il livello di privilegio specificato qui.";
$pgv_lang["WATERMARK_THUMB"]			= "Aggiungere filigrane alle miniature?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Se il firewall multimediale è abilitato, le miniature dovrebbero essere filigranate? Gli elenchi di file multimediali verranno caricati più velocemente se non si filigrana le miniature.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Memorizzare le miniature con filigrana sul server?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Se il firewall multimediale è abilitato, le copie delle miniature con filigrana dovrebbero essere archiviate sul server oltre alle stesse miniature senza filigrane?<br /><br />Se impostato su <b>#pgv_lang[yes]#</b>, gli elenchi di file multimediali contenenti miniature con filigrana verranno prodotti più rapidamente la spesa per maggiori requisiti di spazio su disco del server.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Memorizzare le immagini a grandezza naturale con filigrana sul server?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Se il firewall multimediale è abilitato, dovrebbero essere archiviate sul server copie di immagini a grandezza intera con filigrana oltre alle stesse immagini senza filigrane?<br /><br />Se impostato su <b>#pgv_lang[yes]#</b>, verranno prodotte più immagini con filigrana a grandezza naturale rapidamente a scapito di maggiori requisiti di spazio su disco del server.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Utilizzare il database per fornire regole di confronto UTF-8";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Controlla se PhpGedView deve utilizzare le funzionalità di ordinamento e confronto integrate nel database. In genere è più veloce utilizzare il database per ordinare e filtrare i dati piuttosto che PHP, sebbene non tutti i database / versioni forniscano questa funzionalità. La sequenza di confronto utilizzata per ciascuna lingua è impostata nella pagina delle impostazioni di quella lingua.<br /><br /><span class=\"warning\">IMPORTANTE: impostare questo valore su <b>#pgv_lang[yes]#</b> solo se lo si fa PRIMA che le tabelle del database vengano create per la prima volta. Selezionarlo su un database esistente potrebbe causare il danneggiamento dei dati.</span><br /><br />MySQL e PostgreSQL offrono entrambi un buon supporto per UTF-8, sebbene non tutte le sequenze di confronto siano disponibili nelle versioni precedenti di MySQL. Altri database offrono poco o nessun supporto per UTF-8. Se non sei sicuro del supporto del tuo database per UTF-8, dovresti impostare questo valore su <b>#pgv_lang[no]#</b>.<br /><br />Questo <a href='https://it.wikipedia.org/wiki/UTF-8' target='_blank' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a> contiene informazioni complete e collegamenti su UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Fatti da aggiungere alla persona";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere alle persone. È possibile modificare questo elenco rimuovendo o aggiungendo nomi di fatti, anche personalizzati, se necessario. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Fatti unici da aggiungere alla persona";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere solo <u>una volta</u> alle persone. Ad esempio, se BIRT è in questo elenco, gli utenti non saranno in grado di aggiungere più di un record BIRT a una persona. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[INDI_FACTS_ADD]#</i>.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Fatti rapidi da aggiungere alla persona";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Questa è la breve lista di fatti GEDCOM di persone che appare accanto all'elenco completo e può essere aggiunta con un solo clic.";
$pgv_lang["FAM_FACTS_ADD"] 			= "Fatti da aggiungere alla famiglia";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere alle famiglie. È possibile modificare questo elenco rimuovendo o aggiungendo nomi di fatti, anche personalizzati, se necessario. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Fatti unici da aggiungere alla famiglia";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere solo <u>una volta</u> alle famiglie. Ad esempio, se MARR è in questo elenco, gli utenti non potranno aggiungere più di un record MARR a una famiglia. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[FAM_FACTS_ADD]#</i>.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Fatti rapidi da aggiungere alla famiglia";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Questo è il breve elenco di informazioni sulla famiglia GEDCOM che appare accanto all'elenco completo e può essere aggiunto con un solo clic.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Fatti da aggiungere alla fonte";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere alle fonti. È possibile modificare questo elenco rimuovendo o aggiungendo nomi di fatti, anche personalizzati, se necessario. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Fatti unici da aggiungere alla fonte";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere solo <u>una volta</u> alle fonti. Ad esempio, se TITL è in questo elenco, gli utenti non saranno in grado di aggiungere più di un record TITL a una fonte. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Fatti rapidi da aggiungere alla fonte";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Questo è il breve elenco delle fonti GEDCOM che appare accanto all'elenco completo e può essere aggiunto con un solo clic.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Fatti da aggiungere al repository";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere ai repository. È possibile modificare questo elenco rimuovendo o aggiungendo nomi di fatti, anche personalizzati, se necessario. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Fatti unici da aggiungere al repository";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Questo è l'elenco dei fatti GEDCOM che i tuoi utenti possono aggiungere solo <u>una volta</u> ai repository. Ad esempio, se NAME è in questo elenco, gli utenti non potranno aggiungere più di un record NAME a un repository. I nomi dei fatti che compaiono in questo elenco non devono comparire anche nell'elenco <i>#pgv_lang[REPO_FACTS_ADD]#</i>.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Fatti rapidi da aggiungere al repository";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Questo è il breve elenco di informazioni sul repository GEDCOM che appare accanto all'elenco completo e può essere aggiunto con un solo clic.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Puoi modificare l'elenco delle lingue supportate dal tuo sito PhpGedView aggiungendo o rimuovendo i segni di spunta a seconda dei casi. Ciò cambia le scelte di lingua disponibili per i tuoi utenti.<br /><br />Puoi ottenere lo stesso risultato tramite il collegamento <b>#pgv_lang[enable_disable_lang]#</b> nel menu #pgv_lang[admin]#, dove puoi anche modificare cose come l'icona della bandiera della lingua, il formato della data, o se il cognome deve essere sempre stampato per primo.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Prefisso dell'identificatore multimediale";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Quando un nuovo record multimediale viene aggiunto online in PhpGedView, verrà generato automaticamente un nuovo ID per quell'oggetto multimediale. L'ID di questo oggetto multimediale avrà questo prefisso.";
$pgv_lang["FAM_ID_PREFIX"]		= "Prefisso ID famiglia";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Quando un nuovo record di famiglia viene aggiunto online in PhpGedView, verrà generato automaticamente un nuovo ID per quella famiglia. L'ID famiglia avrà questo prefisso.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fatti per le famiglie da mostrare sempre su Aggiornamento rapido";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Questo è un elenco separato da virgole di tag dei fatti GEDCOM che verranno sempre mostrati nelle schede Famiglia del modulo Aggiornamento rapido, indipendentemente dal fatto che siano già presenti nel registro della famiglia. Ad esempio, se MARR è nell'elenco, i campi per la data e il luogo del matrimonio saranno sempre visualizzati nel modulo.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fatti per le famiglie da mostrare in Aggiornamento rapido";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Questo è un elenco separato da virgole di tag dei fatti GEDCOM che verranno visualizzati nelle schede Famiglia del modulo Aggiornamento rapido. Solo i fatti in questo elenco verranno visualizzati nel modulo o resi disponibili per la selezione nell'area in cui si aggiungono nuovi fatti nel modulo.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fatti da mostrare sempre in Aggiornamento rapido";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Questo è un elenco separato da virgole di tag dei fatti GEDCOM che verranno sempre mostrati nel modulo Aggiornamento rapido indipendentemente dal fatto che siano già presenti nel record della persona. Ad esempio, se BIRT è nell'elenco, i campi per la data di nascita e il luogo di nascita verranno sempre visualizzati nel modulo.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fatti da mostrare in Aggiornamento rapido";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Questo è un elenco separato da virgole di tag dei fatti GEDCOM che verranno visualizzati nel modulo di aggiornamento rapido. Solo i fatti in questo elenco verranno visualizzati nel modulo o resi disponibili per la selezione nell'area in cui si aggiungono nuovi fatti nel modulo.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Quando aggiungi nuovi membri a una famiglia, PhpGedView può fornire valori predefiniti per i cognomi in base alle consuetudini regionali.<br /><br /><ul><li>Nella tradizione <b>paterna</b>, tutti i membri della famiglia condividono il cognome del padre.</li><li>Nella tradizione <b>spagnola</b> e <b>portoghese</b>, i bambini ricevono un cognome da ogni genitore.</li><li>Nella tradizione <b>islandese</b>, i bambini ricevono il nome di battesimo del genitore maschio come cognome, con un suffisso che denota il sesso.</li><li>Nella tradizione <b>polacca</b>, tutti i membri della famiglia condividono il cognome del padre. Per alcuni cognomi, il suffisso indica il sesso. I suffissi <i>ski</i>, <i>cki</i>, e <i>dzki</i>indicano maschio, mentre i corrispondenti suffissi <i>ska</i>, <i>cka</i>, e <i>dzka</i> indicano femmina.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Questo è un elenco separato da virgole di tag dei fatti GEDCOM che verranno mostrati nel modulo di aggiunta / modifica del nome. Se usi alfabeti non latini come ebraico, greco, cirillico o arabo, potresti voler aggiungere tag come _HEB, ROMN, FONE, ecc. Per consentire di memorizzare i nomi in diversi alfabeti diversi.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Questo è un elenco separato da virgole di tag dei fatti GEDCOM che verranno visualizzati quando aggiungi o modifichi i nomi dei luoghi. Se utilizzi alfabeti non latini come ebraico, greco, cirillico o arabo, potresti voler aggiungere tag come _HEB, ROMN, FONE, ecc. Per consentire di memorizzare i nomi dei luoghi in diversi alfabeti diversi.";
$pgv_lang["GEONAMES_KEY"]				= "geonames.org Userid";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Questo ID utente è necessario per accedere al database gratuito di nomi geografici geonames.org. Se non fornisci un ID utente valido, non sarai in grado di cercare in questo database.<br /><br />Puoi richiedere un ID utente geonames.org sulla <a href='http://www.geonames.org/login' target='_blank'><b>pagina di accesso</b></a> di geonames.org.<br /><br />Riceverai quindi un'e-mail con un link di conferma e dopo aver confermato l'e-mail potrai abilitare il tuo account per il servizio web nella pagina del <a href='http://www.geonames.org/manageaccount' target='_blank'><b>tuo account</b></a>.";
$pgv_lang["GEONAMES_BIAS"]				= "pregiudizi per paese di geonames.org";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalmente, la ricerca nel database GeoNames presenta i suoi risultati in ordine alfabetico indipendentemente dal paese in cui si trova un luogo. Questa opzione specifica che i luoghi situati nel paese selezionato devono essere segnalati in cima all'elenco dei risultati.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Nessuna preferenza";
$pgv_lang["GEOCODE_KEY"]				= "Chiave Google Geocode Server";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Questa chiave è necessaria per accedere al database gratuito di Google dei nomi geografici. Se non fornisci una chiave valida, non sarai in grado di cercare nel database.<br /><br />Puoi richiedere una chiave tramite la tua <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Console per gli sviluppatori di Google</b></a>. È possibile visualizzare questa pagina in una lingua diversa dall'inglese scegliendo la lingua desiderata in fondo alla pagina.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Miniature generate automaticamente";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Il sistema dovrebbe generare automaticamente le miniature per le immagini che non le hanno. La tua installazione PHP potrebbe non supportare questa funzionalità.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Questa pagina fornisce informazioni dettagliate sul server su cui è ospitato PhpGedView. È possibile visualizzare molti dettagli di configurazione sul software del server, in relazione a PHP e PhpGedView.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Questa pagina raccoglie tutti i principali argomenti della Guida alla configurazione in un unico posto. È possibile visualizzare le informazioni sullo schermo o stamparle per un uso successivo.";
$pgv_lang["more_help_advice"]			= "<b>Più aiuto</b><br />È disponibile ulteriore assistenza facendo clic su <b>#pgv_lang[qm]#</b> accanto agli elementi nella pagina.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Larghezza delle miniature generate";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Questa è la larghezza (in pixel) che il programma utilizzerà durante la generazione automatica delle miniature. L'impostazione predefinita è 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Usa le sagome";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Usa immagini silhouette quando non è stata specificata alcuna immagine evidenziata per quella persona. Le immagini utilizzate sono specifiche per il sesso della persona in questione.<br /><br /><table><tr><td wrap valign=\"middle\">Questa immagine potrebbe essere utilizzata quando il sesso della persona è sconosciuto:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]			= "Visualizza le fonti";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Imposta il livello di accesso alla privacy per tutte le fonti. Se l'utente non ha accesso a Sorgenti, l'elenco Fonti verrà rimosso dal menu Elenchi e la scheda Fonti non verrà mostrata nella pagina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Se l'opzione <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> è abilitata, questa impostazione controlla se l'amministratore deve approvare la registrazione.<br /><br />L'impostazione di questa opzione su <b>#pgv_lang[yes]#</b> richiederà che tutti i nuovi utenti prima verifichino se stessi e poi siano approvati da un amministratore prima di poter accedere. Con questa impostazione su <b>#pgv_lang[no]#</b>, la casella <b>#pgv_lang[verified_by_admin]#</b> verrà selezionata automaticamente quando gli utenti verificano il proprio account, consentendo così un accesso immediato in seguito senza l'intervento dell'amministratore.";
$pgv_lang["SPLIT_PLACES"]		= "Dividi i luoghi in modalità Modifica";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Impostalo su <b>#pgv_lang[yes]#</b> per dividere ogni nome di luogo con virgole in sottocampi per facilitare la modifica. Esempio :<br /><ol><li>Modalità default<br /><u>Luogo</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Modalità divisa<br /><u>Paese</u>: USA<br /><u>Stato</u>: California<br /><u>Contea</u>: San Mateo<br /><u>Municipalità</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Sottolinea i nomi tra virgolette";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Molti programmi inseriranno il nome dato preferito tra virgolette (<b>\"</b>) nel GEDCOM. La consueta convenzione per questo è sottolineare il nome dato preferito. L'attivazione di questa opzione convertirà tutti i nomi racchiusi tra virgolette in &lt;span&gt; con una classe CSS di «starredname».<br /><br />Ad esempio, se il nome nel GEDCOM fosse 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ abilitare questa opzione cambierebbe la parte del nome racchiusa tra virgolette in &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; per scopi di stampa.  A seconda di altre impostazioni, il browser visualizzerà quel nome come <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> o <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Utilizza la restrizione sulla privacy di GEDCOM (RESN)";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />La specifica GEDCOM 5.5.1 include l'opzione di utilizzare i tag RESN per impostare le opzioni di privacy per persone e fatti nel file GEDCOM. Abilitando questa opzione il programma cercherà i tag RESN di livello 1 nei record GEDCOM. I tag RESN di livello 2+ vengono applicati automaticamente e non saranno influenzati da questa impostazione. Nota che questo potrebbe rallentare alcune delle funzioni di PhpGedView come l'elenco delle persone.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Mostra i codici delle ordinanze della chiesa SDG nei caselle del grafico";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Sottenendo questa opzione per <b>#pgv_lang[yes]#</b> verranno visualizzati i codici di stato per le ordinanze SDG nelle caselle del grafico.<ul><li><b>B</b> - Battesimo</li><li><b>E</b> - Dotato</li><li><b>S</b> - Sigillato al coniuge</li><li><b>P</b> - Sigillato ai genitori</li></ul>Una persona che ha completato tutte le ordinanze avrà stampato <b>BESP</b> dopo il proprio nome. Le ordinanze mancanti sono indicate da <b>_</b> al posto del codice lettera corrispondente. Ad esempio, <b>BE__</b> indica le ordinanze <b>S</b> e <b>P</b> mancanti.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Scheda predefinita da mostrare nella pagina «Dettagli personali#»";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Questa opzione ti consente di scegliere quale scheda si apre automaticamente nella pagina «Dettagli personali#» quando si accede a quella pagina.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Mostra i nomi dei coniugi nell'elenco delle persone";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Questa opzione mostrerà i nomi sposati delle donne nell'elenco delle persone. Questa opzione richiede che tu calcoli i nomi dei coniugi quando importi il file GEDCOM.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Mostra i campi della privacy nel modulo #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Questa opzione ti consente di attivare o disattivare i campi della privacy nel modulo #pgv_lang[quick_update_title]#. I campi sulla privacy consentono a un utente che aggiunge informazioni tramite il modulo di ignorare la privacy predefinita per il fatto che sta inserendo.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Usa il modulo #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Questa opzione determina i privilegi utente richiesti per inviare le modifiche tramite il modulo #pgv_lang[quick_update_title]#.<br /><br />La scelta <b>#pgv_lang[nobody]#</b> significa che questo modulo non può essere utilizzato affatto.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archivia files di Log delle ricerche";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Con quale frequenza il programma deve archiviare i file di registro della ricerca.";
$pgv_lang["CHANGELOG_CREATE"]		= "Archivia files di Log delle modifiche";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Con quale frequenza il programma deve archiviare i file di registro delle modifiche.";
$pgv_lang["CHART_BOX_TAGS"]		= "Altri fatti da mostrare nei grafici";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Dovrebbe essere un elenco separato da virgole o spazi di fatti, oltre a Nascita e Morte, che desideri vengano visualizzati nelle caselle del grafico come l'albero genealogico. Questo elenco richiede l'utilizzo dei tag dei fatti come definito nello Standard GEDCOM 5.5.1. Ad esempio, se desideri che l'occupazione venga visualizzata nella casella, devi aggiungere «OCCU» a questo campo.";
$pgv_lang["FULL_SOURCES"]		= "Usa citazioni complete della fonte";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Le citazioni della fonte possono includere campi per registrare la qualità dei dati (primari, secondari, ecc.) E la data in cui l'evento è stato registrato nella fonte. Se non utilizzi questi campi, puoi disabilitarli durante la creazione di nuove citazioni di fonti.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Tipo della fonte";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Quando si aggiungono nuovi parenti stretti, è possibile aggiungere citazioni della fonte ai record (ad esempio INDI, FAM) o ai fatti (BIRT, MARR, DEAT). Questa opzione controlla quali caselle sono spuntate per impostazione predefinita.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "Basi di GEDCOM";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["media_general_conf"]	= "Generale";
$pgv_lang["media_firewall_conf"]	= "Firewall multimediale";
$pgv_lang["accpriv_conf"]		= "Accesso e privacy";
$pgv_lang["displ_conf"]			= "Display, Presentazione, e Rapporti";
$pgv_lang["displ_names_conf"]	= "Nomi";
$pgv_lang["displ_comsurn_conf"] = "Cognomi ricorrenti";
$pgv_lang["displ_layout_conf"]	= "Presentazione";
$pgv_lang["displ_hide_conf"]	= "Nascondi e mostra";
$pgv_lang["displ_reports"]		= "Rapporti";
$pgv_lang["editopt_conf"]		= "Opzioni di modifiche";
$pgv_lang["useropt_conf"]		= "Opzioni degli utenti";
$pgv_lang["contact_conf"]		= "Informazioni sui contatti";
$pgv_lang["meta_conf"]			= "Configurazione del sito Web e dei tag META";
$pgv_lang["gedconf_head"]		= "Configurazione GEDCOM";
$pgv_lang["other_theme"]		= "Altro, digita";
$pgv_lang["performing_update"]		= "Aggiornamento in corso.";
$pgv_lang["config_file_read"]		= "File di configurazione letto.";
$pgv_lang["does_not_exist"]		= "non esiste";
$pgv_lang["media_drive_letter"]		= "Il percorso multimediale non deve contenere una lettera di unità; il multimediale potrebbe non essere visualizzato.";
$pgv_lang["db_setup_bad"]		= "La configurazione del database corrente è errata. Controlla i parametri di connessione del database e configura di nuovo.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView non è riuscito a stabilire una connessione all'host del database. Controlla l'host, il nome utente e la password per assicurarti che siano corretti.";
$pgv_lang["bad_database_name"]		= "PhpGedView ha stabilito una connessione all'host del database, ma non è stato in grado di utilizzare il database con il nome inserito. Verificare che il database esista e che il nome utente immesso disponga delle autorizzazioni appropriate per quel database.";
$pgv_lang["db"]				= "Base dei dati";
$pgv_lang["current_gedcoms"]		= "GEDCOM attuales";
$pgv_lang["ged_gedcom"]			= "File GEDCOM";
$pgv_lang["ged_title"]			= "Titolo del GEDCOM";
$pgv_lang["ged_config"]			= "File di configurazione";
$pgv_lang["ged_search"]			= "File del registro di ricerca";
$pgv_lang["ged_change"]			= "File del registro delle modifiche";
$pgv_lang["ged_privacy"]		= "File sulla privacy";
$pgv_lang["disabled"]			= "Disabilitato";
$pgv_lang["mouseover"]			= "Al passaggio sopra del mouse";
$pgv_lang["mousedown"]			= "Al passaggio giù del mouse";
$pgv_lang["click"]			= "Al clic del mouse";
$pgv_lang["enter_db_pass"]		= "Per sicurezza, è sempre necessario immettere #pgv_lang[DBUSER]# e #pgv_lang[DBPASS]# quando si modificano i valori di configurazione.";
$pgv_lang["server_url_note"]	= "Questo dovrebbe essere l'URL alla cartella di PhpGedView. Dovresti cambiarlo solo se sai quello che stai facendo. PhpGedView ha determinato che questo valore dovrebbe essere: <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Tipo di Database";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Il tipo di database a cui connettersi.<br /><br />PhpGedView può utilizzare qualsiasi database che abbia un driver PDO disponibile. Devi assicurarti che il tuo file php.ini carichi sia la libreria <b>php_pdo</b> e il driver appropriato per il tuo database, ad es. <b>php_pdo_mysql</b>.<br /><br />La maggior parte dei database richiede un nome utente e una password. È inoltre necessario creare il database prima di installare PhpGedView. Tuttavia, SQLite non ha bisogno di #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, o #pgv_lang[DBPASS]#, ma sarà necessario impostare un percorso file per il database nel campo #pgv_lang[DBNAME]#. PhpGedView creerà il file del database SQLite per te.";
$pgv_lang["DBHOST"]			= "Host di database";
$pgv_lang["DBHOST_help"] = "Il DNS o l'indirizzo IP del computer che ospita il tuo database. Questo parametro è ignorato se utilizzi un database SQLite.";
$pgv_lang["DBPORT"]			= "Porta del database";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />La porta TCP da utilizzare durante la connessione al server del database. Lascia questa impostazione vuota per utilizzare la porta predefinita per il tuo particolare tipo di database. Questa impostazione viene ignorata se si utilizza un database SQLite.";
$pgv_lang["DBUSER"]			= "Nome utente del database";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Il nome utente del database richiesto per accedere al database. Questa impostazione viene ignorata se si utilizza un database SQLite.";
$pgv_lang["DBPASS"]			= "Password del database";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />La password del database per l'utente immesso nel campo #pgv_lang[DBUSER]#. Questa impostazione viene ignorata se si utilizza un database SQLite.";
$pgv_lang["DBNAME"] = "Nome Database";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />Il database nel server che vuoi che PhpGedView utilizzi.<br /><br />Il nome utente che inserisci nel campo #pgv_lang[DBUSER]# deve avere i privilegi di creazione, inserimento, aggiornamento, eliminazione e selezione su questo database. In SQLite è necessario impostarlo su un nome di file in una directory scrivibile da PHP come la directory index (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Un prefisso ai nomi delle tabelle create da PhpGedView. Modificando questo valore è possibile configurare più siti PhpGedView per utilizzare lo stesso database fisico ma tabelle diverse. Ad esempio, lo stesso sito potrebbe ospitare un'installazione «test» e «produzione» di PhpGedView con tabelle di dati completamente indipendenti.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Se disponi di un ambiente con più GEDCOM, l'impostazione di questo valore su <b>#pgv_lang[yes]#</b> consente ai visitatori <u>e</u> agli utenti del tuo sito di avere la possibilità di modificare i GEDCOM. Impostandolo su <b>#pgv_lang[no]#</b> si disabilita la commutazione GEDCOM sia per i visitatori <u>che</u> per gli utenti registrati.";
$pgv_lang["upload_path"]			= "File da caricare";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Questo è il percorso in cui si trova il file GEDCOM che desideri caricare. Per selezionare il percorso, fai clic su <b>Sfoglia</b> e vai al tuo file GEDCOM, quindi fai clic su <b>Apri</b>.";
$pgv_lang["gedcom_path"]			= "Percorso e nome del GEDCOM sul server";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Ci sono due modi per importare il tuo file GEDCOM in PhpGedView. Sono:<ol><li>FTP il file sul server</li><li>Carica in PhpGedView</li></ol>Quando il tuo file esiste già sul server, esegui la procedura <i>#pgv_lang[add_gedcom]#</i> e inserisci il percorso e il nome del tuo file GEDCOM così come sono presenti sul server. Il nome può essere con o senza estensione. Se non viene fornita alcuna estensione, verrà assunto .ged. Il percorso è facoltativo. Se non viene fornito alcun percorso, verrà utilizzato il valore dell'opzione <i>#pgv_lang[INDEX_DIRECTORY]#</i>, come impostato nella configurazione del sito PhpGedView. Tieni presente che sulla maggior parte dei server, i nomi dei file e dei percorsi fanno distinzione tra maiuscole e minuscole.<br /><br />Quando attivi la procedura <i>#pgv_lang[upload_gedcom]#</i> incorporata in PhpGedView, puoi utilizzare il pulsante <b>Sfoglia</b> per individuare il file sul tuo computer locale. Può essere un normale file GEDCOM o un file ZIP contenente il file GEDCOM. PhpGedView estrarrà automaticamente e quindi utilizzerà il file GEDCOM contenuto in quel file ZIP.<br /><br />Quando si carica un file è possibile specificare un percorso alternativo e / o un nome file per salvarlo sul server.<br /><br />Vedere il file <a href=\"readme.txt\">Readme.txt</a> per ulteriori informazioni.";
$pgv_lang["CHARACTER_SET"]		= "Codifica Caratteri";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Questo è il set di caratteri del tuo file GEDCOM. UTF-8 è l'impostazione predefinita e dovrebbe funzionare per quasi tutti i siti. Se esporti il tuo GEDCOM utilizzando la codifica IBM Windows, dovresti mettere WINDOWS qui.<br /><br />NOTA: PhpGedView non può supportare UNICODE (UTF-16) perché il supporto manca in PHP.";
$pgv_lang["LANGUAGE"] = "Lingua";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Assegna la lingua predefinita per il sito.<br /><br />Quando l'opzione <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> è impostata, gli utenti possono sovrascrivere questa impostazione tramite la configurazione della lingua preferita del browser, le opzioni di configurazione nella pagina Account o tramite link o pulsanti nella maggior parte di PhpGedView pagine.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Consenti all'utente di cambiare lingua";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Impostare su <b>#pgv_lang[yes]#</b> per consentire agli utenti di sovrascrivere la lingua predefinita del sito. Possono farlo tramite la configurazione della lingua preferita del browser, le opzioni di configurazione nella pagina Account o tramite collegamenti o pulsanti nella maggior parte delle pagine PhpGedView.";
$pgv_lang["CALENDAR_FORMAT"]		= "Formato Calendario";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Le date possono essere registrate in vari calendari come il calendario gregoriano, giuliano o ebraico. Questa opzione ti consente di convertire le date in un calendario preferito. Ad esempio, puoi selezionare gregoriano per convertire le date giuliane ed ebraiche in gregoriane. La data convertita viene mostrata tra parentesi dopo la data normale.<br /><br />Le date vengono convertite solo se sono valide per il calendario. Ad esempio, solo le date comprese tra 22&nbsp;SEP&nbsp;1792 e 31&nbsp;DEC&nbsp;1805 verranno convertite nel calendario repubblicano francese e solo le date successive al 15&nbsp;OCT&nbsp;1582 verranno convertite nel calendario gregoriano.<br /><br />L'ebraico è uguale a Guidaico, ma utilizza caratteri ebraici. L'arabo è uguale a Hijri, ma utilizza caratteri arabi.<br /><br />Nota: poiché il giorno del calendario ebraico e hijri inizia al tramonto, qualsiasi evento che si svolge dal tramonto fino a mezzanotte verrà visualizzato come un giorno prima del corretto Data. La visualizzazione di ebraico e arabo può essere problematica nei vecchi browser, che possono visualizzare il testo al contrario (da sinistra a destra) o non visualizzare affatto.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Mostra migliaia di ebrei";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Mostra Alafim nei calendari ebraici.<br /><br />Impostando questo valore su <b>#pgv_lang[yes]#</b> verrà visualizzato l'anno 1969 come <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mentre lo si imposta su <b>#pgv_lang[no]#</b> verrà visualizzato l'anno come <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Ciò non ha alcun impatto sull'impostazione dell'anno ebraico. L'anno verrà visualizzato come 5729 indipendentemente da questa impostazione.<br /><br />Nota: questa impostazione è simile alla costante del calendario CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Mostra l'ebraico Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Mostra virgolette singole e doppie («'» e «\"») quando si visualizzano le date ebraiche.<br /><br />Impostando questo valore su <b>#pgv_lang[yes]#</b> verrà visualizzato l'8 febbraio 1969 come <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mentre lo si imposta su <b>#pgv_lang[no]#</b> verrà visualizzato come <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Ciò non ha alcun impatto sull'impostazione dell'anno giuliano poiché le virgolette non vengono utilizzate nelle date giuliano visualizzate con caratteri latini.<br /><br />Nota: questa impostazione è simile alle costanti del calendario CAL_JEWISH_ADD_ALAFIM_GERESH e CAL_JEWISH_ADD_GERESHAYIM. Questa singola impostazione influisce su entrambi.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Pronuncia giuliana Ashkenazita";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Se impostato su <b>#pgv_lang[yes]#</b>, i mesi di Cheshvan e Teves saranno scritti con la pronuncia ashkenazita. Impostandolo su <b>#pgv_lang[no]#</b> cambierà i mesi in Hesvan e Tevet. Questo riguarda solo l'ambiente giuliano. L'impostazione ebraica utilizzerà sempre l'alfabeto ebraico. ";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Numero di generazioni di pedigree";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Imposta il numero predefinito di generazioni da visualizzare nei grafici Discendenza e Albero genealogico.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Numero massimo di generazioni Pedigree";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Imposta il numero massimo di generazioni da visualizzare nei grafici genealogici.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Numero massimo di generazioni di discendenza";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Imposta il numero massimo di generazioni da visualizzare nei grafici Discendenza.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Larghezza normale dei numeri SOSA";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Quanto spazio deve essere riservato per i numeri SOSA sui grafici<br /><br /><b>#pgv_lang[variable]#</b> indica che la larghezza non è fissa e il numero SOSA stampato occuperà altrettanto spazio come necessita. Il resto del grafico verrà posizionato di conseguenza.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Larghezza extra dei numeri SOSA";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Quanto spazio deve essere riservato per i numeri SOSA nella visualizzazione Libretto del grafico Discendenza<br /><br /><b>#pgv_lang[variable]#</b> indica che la larghezza non è fissa e il numero SOSA stampato occuperà altrettanto spazio come necessita. Il resto del grafico verrà posizionato di conseguenza.";
$pgv_lang["USE_RIN"]			= "Usa il numero RIN invece dell'ID GEDCOM";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Impostare su <b>#pgv_lang[yes]#</b> per utilizzare il numero RIN invece dell'ID GEDCOM quando vengono richiesti gli ID persona nei file di configurazione, nelle impostazioni utente e nei grafici. Ciò è utile per i programmi di genealogia che non esportano costantemente GEDCOM con lo stesso ID assegnato a ciascuna persona ma utilizzano sempre lo stesso RIN.";
$pgv_lang["GENERATE_GUID"]		= "Crea automaticamente ID univoci globali";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> in questo contesto è l'acronimo di «Globally Unique ID» (ID univoco globale).<br /><br />I GUID hanno lo scopo di aiutare a identificare ogni individuo in modo ripetibile, in modo che le organizzazioni centrali come il Centro genealogico della Chiesa SUG a Salt Lake City, o anche programmi compatibili in esecuzione sul tuo server, possono determinare se hanno a che fare con la stessa persona, indipendentemente da dove ha origine il GEDCOM. L'obiettivo del Family History Center è quello di disporre di un archivio centrale di dati genealogici e di esporli tramite servizi web. Ciò consentirà a qualsiasi programma di accedere ai dati e aggiornare i propri dati al suo interno.<br /><br />Se non si intende condividere questo GEDCOM con nessun altro, non è necessario lasciare che PhpGedView crei questi GUID; tuttavia, così facendo non farà altro che aumentare le dimensioni del tuo GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Persona predefinita per i grafici dell'albero genealogico e dei discendenti";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Imposta l'ID della persona predefinita da visualizzare nei grafici albero genealogico e discendenza.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Prefisso ID persona";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Quando un nuovo record di persona viene aggiunto online in PhpGedView, verrà generato automaticamente un nuovo ID per quella persona. L'ID avrà questo prefisso.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Prefisso ID fonte";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Quando un nuovo record fonte viene aggiunto online in PhpGedView, verrà generato automaticamente un nuovo ID per quella fonte. L'ID avrà questo prefisso.";
$pgv_lang["REPO_ID_PREFIX"]		= "Prefisso ID repository";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Quando un nuovo record di repository viene aggiunto online in PhpGedView, verrà generato automaticamente un nuovo ID per quel repository. L'ID avrà questo prefisso.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Mostra i dettagli di nascita e morte sui grafici";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Questa opzione controlla se mostrare o meno i dettagli di nascita e morte della persona sui grafici.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Mostra l'icona del sesso sui grafici";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Questa opzione controlla se mostrare o meno l'icona del sesso della persona sui grafici.<br /><br />Poiché il sesso è indicato anche dal colore della casella, questa opzione non nasconde il sesso. L'opzione rimuove semplicemente alcune informazioni duplicate dalla scatola.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Layout predefinito dell'albero genealogico";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Questa opzione indica se l'albero genealogico deve essere generato in modalità orizzontale o verticale.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Mostra le caselle vuote sui grafici genealogici";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Questa opzione controlla se mostrare o meno le caselle vuote sui grafici dell'albero genealogico.";
$pgv_lang["ZOOM_BOXES"]			= "Ingrandisci le caselle sui grafici";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Consente a un utente di ingrandire le caselle sui grafici per ottenere maggiori informazioni.<br /><br />Impostare su <b>#pgv_lang[disabled]#</b> per disabilitare questa funzione. Impostare su <b>#pgv_lang[mouseover]#</b> per ingrandire le caselle quando l'utente passa il mouse sull'icona nella casella. Imposta <b>#pgv_lang[click]#</b> per ingrandire le caselle quando l'utente fa clic sull'icona nella casella.";
$pgv_lang["LINK_ICONS"]			= "Mostra collegamenti sui grafici";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Consente all'utente di selezionare collegamenti ad altri grafici e parenti stretti della persona.<br /><br />Impostare su <b>#pgv_lang[disabled]#</b> per disabilitare questa funzione. Impostare su <b>#pgv_lang[mouseover]#</b> per mostrare i collegamenti quando l'utente passa il mouse sull'icona nella casella. Imposta su <b>#pgv_lang[click]#</b> per mostrare i link quando l'utente fa clic sull'icona nella casella.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Abbrevia le etichette nei grafici";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Questa opzione controlla se abbreviare o meno le etichette come <b>Nascita</b> sui grafici con solo la prima lettera come <b>N</b>.<br /><br />Puoi personalizzare le abbreviazioni fornendo sovrascrivendo i valori nel file <i>languages/extra.xx.php</i> per ciascuna lingua. Ad esempio, se desideri utilizzare «*» invece di «N» per abbreviare il fatto BIRT nella lingua francese, dovresti inserire la seguente voce nel file <i>languages/extra.fr.php</i>:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Le lunghezze delle abbreviazioni specificate in questo modo non sono limitate a 1 carattere.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Mostra differenze di date";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Questa opzione controlla se la scheda Parenti stretti deve mostrare o meno le differenze tra le date di nascita dei coniugi, tra la data del matrimonio e la data di nascita del primo figlio e tra le date di nascita dei figli.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Mostra l'età dei genitori accanto alla data di nascita del bambino";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Questa opzione controlla se mostrare o meno l'età del padre e della madre accanto alla data di nascita del bambino sui grafici.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Mostra eventi di parenti stretti nella pagina «Dettagli personali»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Nascite, matrimoni e morti di parenti sono eventi importanti nella propria vita. Questa opzione controlla se mostrare o meno questi eventi nella scheda «Fatti e Dettagli personali» nella pagina «Dettagli personali».<br /><br />Gli eventi interessati da questa opzione sono:<ul><li>Morte del coniuge</li><li>Nascita e morte dei bambini</li><li>Morte dei genitori</li><li>Nascita e morte di fratelli</li><li>Morte dei nonni</li><li>Nascita e morte dei fratelli dei genitori</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Espandere automaticamente l'elenco degli eventi di parenti stretti";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Questa opzione controlla se espandere automaticamente o meno l'elenco <i>Eventi di parenti stretti</i>.";
$pgv_lang["EXPAND_SOURCES"]      = "Espandi automaticamente fonti";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Questa opzione controlla se visualizzare o meno automaticamente il contenuto di un record <i>SOUR</i> nella pagina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["EXPAND_NOTES"]      = "Espandi automaticamente note";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Questa opzione controlla se visualizzare o meno automaticamente il contenuto di un record <i>NOTE</i> nella pagina <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Mostra tutti i riferimenti a Note e Fonti nelle schede Note e Fonti";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Questa opzione controlla se i riferimenti a Note e Fonti che sono allegati a Fatti devono essere mostrati nelle schede Note e Fonti della pagina <i>#pgv_lang[personal_details]#</i>.<br /><br />Normalmente, le schede Note e Fonti mostrano solo riferimenti a Note e Fonti che sono allegate direttamente al record del database della persona. Questi sono riferimenti di <i>livello 1</i> a Note e Fonti.<br /><br />L'opzione <b>#pgv_lang[yes]#</b> fa sì che queste schede mostrino anche i riferimenti a Note e Fonti che fanno parte dei vari fatti nel record del database della persona. Questi sono riferimenti di <i>livello 2</i> a note e fonti perché i vari fatti sono al livello 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Attiva Privacy";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Questa opzione abiliterà tutte le impostazioni di privacy e nasconderà i dettagli delle persone viventi.<br /><br />Le persone viventi sono definite come coloro che non hanno un evento più recente del numero di anni specificato nell'impostazione <b>#pgv_lang[MAX_ALIVE_AGE]#</b>, che attualmente è <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. A tal fine, anche le nascite di bambini sono considerate eventi di questo tipo.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Richiedi l'autenticazione degli utenti";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />L'abilitazione di questa opzione costringerà tutti i visitatori ad accedere prima di poter visualizzare i dati sul sito.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Pagina da mostrare dopo l'accesso";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Quale pagina devono visualizzare gli utenti dopo aver effettuato l'accesso?<br /><br />La scelta effettuata qui determina se un accesso riuscito fa sì che la pagina di benvenuto o la pagina MyGedView venga visualizzata quando il login viene effettuato da #pgv_lang[welcome_page]#.<br /><br />Un accesso eseguito dal collegamento nella parte superiore di ogni altra pagina riporterà l'utente a quella pagina.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Testo di Benvenuti sulla pagina di Login";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Qui puoi scegliere il testo da visualizzare nella schermata di accesso. Devi determinare il testo predefinito più appropriato.<br /><br />Puoi anche scegliere di inserire il tuo testo di benvenuto personalizzato, ma il testo che inserisci non verrà tradotto quando gli utenti cambiano lingua. Tuttavia, se il tuo testo personalizzato contiene riferimenti a variabili di lingua che puoi definire nei vari file <i>languages/extra.xx.php</i>, il tuo sito può mostrare il testo tradotto. Fare riferimento al testo della Guida associato al campo <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> per ulteriori informazioni.<br /><br />The predefined texts are:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Nessun testo predefinito";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Testo predefinito: tutti gli utenti possono richiedere un nuovo account utente";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Testo predefinito: l'amministratore deciderà su ogni richiesta di nuovi account utente";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Testo predefinito: solo i parenti possono richiedere un account utente";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Testo di benvenuto a scelta dell'utente, inserito qui sotto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Testo di Benvenuto personalizzato";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Se hai scelto il testo di benvenuto personalizzato, puoi digitare quel testo qui. Il testo NON verrà tradotto nella lingua del visitatore, ma verrà mostrato esattamente come l'hai digitato. Tuttavia, se il tuo testo personalizzato contiene riferimenti a variabili di lingua che puoi definire nei vari file <i>languages/extra.xx.php</i>, il tuo sito può mostrare il testo tradotto.<br /><br />Puoi inserire tag HTML nel tuo testo di benvenuto personalizzato.<br /><br />La seguente descrizione, presa dal testo della guida per l'elenco delle domande frequenti, è ugualmente applicabile al testo di benvenuto personalizzato.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Usa l'intestazione standard per il testo di Benvenuto personalizzato";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Scegli di visualizzare un'intestazione standard per il tuo testo di benvenuto personalizzato. Quando i tuoi utenti cambiano lingua, questa intestazione apparirà nella nuova lingua.<br /><br />Se impostata su <b>#pgv_lang[yes]#</b>, l'intestazione avrà questo aspetto:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Mostra il contratto di utilizzo accettabile nella pagina «Richiedi nuovo account utente»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Se impostato su <b>#pgv_lang[yes]#</b>, il seguente messaggio apparirà sopra i campi di immissione nella pagina <i>#pgv_lang[requestaccount]#</i>:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Controlla date di nascita";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Controlla le date dei bambini per determinare se una persona è morta. Su sistemi meno recenti e GEDCOM di grandi dimensioni questo può rallentare il tempo di risposta del tuo sito.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Età a cui si assume che una persona sia morta";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Se questa persona ha eventi diversi da Morte, Sepoltura o Cremazione più recenti di questo numero di anni, è considerata «viva». Le date di nascita dei bambini sono considerate tali eventi per questo scopo.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Consenti agli utenti di visualizzare i record GEDCOM non elaborati";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Impostando questo valore su <b>#pgv_lang[yes]#</b>, verranno inseriti collegamenti nelle pagine di persone, fonti e famiglie per consentire agli utenti di visualizzare un'altra finestra contenente i dati grezzi estratti direttamente dal file GEDCOM.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Abilita la modifica in linea";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Questa opzione abilita le funzionalità di modifica in linea per questo database in modo che gli utenti con privilegi di modifica possano aggiornare i dati in linea.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Abilita il completamento automatico";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Questa opzione determina se il completamento automatico deve essere attivo durante l'immissione delle informazioni in determinati campi dei moduli di input. Quando questa opzione è impostata su <b>#pgv_lang[yes]#</b>, i campi di immissione del testo per cui è possibile il completamento automatico sono indicati da uno sfondo di colore diverso.<br /><br />Quando il completamento automatico è attivo, PhpGedView cercherà nel suo database le possibili corrispondenze in base a quanto già inserito. Man mano che si immettono ulteriori informazioni, l'elenco delle possibili corrispondenze viene perfezionato. Quando vedi l'input desiderato nell'elenco delle corrispondenze, puoi spostare il cursore del mouse su quella riga dell'elenco e quindi fare clic con il pulsante sinistro del mouse per completare l'inserimento.<br /><br />Gli svantaggi del completamento automatico sono che rallenta il programma, comporta una significativa attività del database e comporta anche l'invio di più dati al browser.";
$pgv_lang["USE_REFN"]		= "Usa il Numero di riferimento";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Questa opzione determina se il #factarray[REFN]# inserito nei dettagli di una <u>nuova</u> persona debba essere utilizzato come numero ID per quella nuova persona.<br /><br />Quando questa opzione è impostata su <b>#pgv_lang[yes]#</b>, il #factarray[REFN]# inserito deve seguire le regole stabilite per tutti i numeri ID e una persona con quell'ID non deve già esistere nel Banca dati. Se queste condizioni non sono soddisfatte, o quando questa opzione è impostata su <b>#pgv_lang[no]#</b>, PhpGedView assegnerà automaticamente il successivo numero ID disponibile a quella nuova persona.<br /><br />I numeri ID validi possono contenere solo le lettere dalla <b>A</b> alla <b>Z</b>, dalla <b>a</b> alla <b>z</b>, cifre dalla <b>0</b> alla <b>9</b> e i simboli speciali <b>. : -</b> e <b>_</b><br /><br />Devi anche abilitare la visualizzazione di #factarray[REFN]# aggiungendo la voce <b>REFN</b> alle opzioni di configurazione <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> e <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> di seguito.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Chiudi automaticamente la finestra di modifica";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Questa opzione controlla se chiudere automaticamente o meno la finestra Modifica dopo un aggiornamento riuscito.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Il percorso di una directory leggibile e scrivibile in cui PhpGedView dovrebbe memorizzare i file index (includere il finale «/»). PhpGedView non richiede che il nome di questa directory sia «index». Puoi scegliere il nome che preferisci.<br /><br />Per sicurezza, questa directory dovrebbe essere collocata da qualche parte nello spazio file del server che non è accessibile da Internet. Segue un esempio di tale struttura:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Per l'esempio mostrato, inserisci <b>../../dir4/dir5/dir6/index/</b> in questo campo.";
$pgv_lang["POSTAL_CODE"]  = "Posizione del codice postale";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Paesi diversi utilizzano modi diversi per scrivere l'indirizzo. Questa opzione ti consentirà di inserire il codice postale prima o dopo il nome della città.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Numero massimo di cognomi";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Elenchi lunghi di persone con lo stesso cognome possono essere suddivisi in sottoelenchi più piccoli in base alla prima lettera del nome di battesimo della persona.<br /><br />Questa opzione determina quando si verificherà il sottoelenco dei cognomi. Per disabilitare completamente il sottoelenco, impostare questa opzione su zero.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Numero massimo di cognomi";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lunghi elenchi di famiglie con lo stesso nome possono essere suddivisi in sottoelenchi più piccoli in base alla prima lettera del nome specificato.<br /><br />Questa opzione determina quando si verificherà il sottoelenco dei nomi di famiglia. Per disabilitare completamente il sottoelenco, impostare questa opzione su zero.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Stile dell'elenco dei cognomi";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Gli elenchi di cognomi, così come appaiono nel blocco #pgv_lang[block_top10]#, #pgv_lang[individual_list]# e #pgv_lang[family_list]#, possono essere visualizzati in stili diversi.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;In questo stile, i cognomi vengono visualizzati in una tabella che può essere ordinata per cognome o per conteggio.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;In questo stile, i cognomi vengono visualizzati in un elenco e la dimensione del carattere utilizzato per ciascun nome dipende dal numero di occorrenze di quel nome nel database. L'elenco non è ordinabile.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Questa opzione controlla se mostrare o meno i numeri ID tra parentesi dopo i nomi su grafici ed elenchi.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Mostra la data dell'ultima modifica del record GEDCOM sugli elenchi";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Questa opzione controlla se mostrare o meno la data dell'ultima modifica del record GEDCOM sugli elenchi.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Mostra le date stimate di nascita e morte";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Questa opzione controlla se mostrare o meno le date stimate di nascita e morte invece di lasciare spazi vuoti negli elenchi di persone e nei grafici per le persone le cui date non sono note.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Numero di livelli di posizione da mostrare di persona";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Questo imposta la quantità di informazioni sul luogo mostrate nelle caselle delle persone sui grafici.<br /><br />L'impostazione del valore su 9 garantirà la visualizzazione di tutti i livelli di posizione. L'impostazione del valore su 0 nasconderà completamente i luoghi. Impostando il valore su 1 verrà visualizzato il primo livello, impostandolo su 2 verranno visualizzati i primi due livelli, ecc.";
$pgv_lang["pageSizeDefault"]			= "Dimensione pagina predefinita";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Questa è la dimensione della pagina predefinita per tutti i rapporti. La tua scelta può essere sovrascritta nei singoli rapporti.";
$pgv_lang["pageSizeOptions"]			= "Dimensioni";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Questo è l'elenco delle dimensioni delle pagine attualmente supportate da PhpGedView durante la generazione dei report. Puoi estendere questo elenco aggiungendo altre dimensioni di pagina standard come elencato nell'<a href='https://it.wikipedia.org/wiki/Formato_carta' title='Articolo di Wikipedia' target='_blank'><b>Articolo di Wikipedia</b></a><br /><ul><li>Il formato pagina standard per la maggior parte del mondo è <b>A4</b>, che corrisponde a 210 x 297 mm (8,3 x 11,7 pol.)</li><li>Il formato pagina standard per il Nord America è <b>letter</b>, che corrisponde a 216 x 279 mm (8,5 x 11,0 pol.)</li><li>Sono disponibili altri formati <b>A3</b>, che corrisponde a 297 x 420 mm (11,7 x 16,5 pol.)</li><li>e <b>legal</b>, che corrisponde a 216 x 356 mm (8,5 x 14,0 pol.)</li></ul><br />Si consiglia di prestare attenzione quando si aggiungono formati carta diversi da quelli nell'elenco ISO «A»; non tutte le dimensioni standard ISO sono state testate.";
$pgv_lang["fontsDefault"]				= "Carattere predefinito";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Questo è il carattere predefinito per tutti i rapporti. La tua scelta può essere sovrascritta nei singoli rapporti.";
$pgv_lang["fontsOptions"]				= "Caratteri";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Questo è l'elenco dei caratteri attualmente supportati da PhpGedView durante la generazione dei rapporti.<br /><br />Puoi estendere questo elenco o accorciarlo secondo necessità. Si consiglia cautela quando si estende questo elenco; non tutti i caratteri trovati nella libreria <i>includes/tcpdf/fonts</i> sono stati testati.";
$pgv_lang["MULTI_MEDIA"]		= "Abilita funzionalità multimediali";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 ti consente di collegare immagini, video e altri oggetti multimediali nel tuo GEDCOM. Se non includi oggetti multimediali nel tuo GEDCOM, puoi disabilitare le funzionalità multimediali impostando questo valore su <b>#pgv_lang[no]#</b>.<br /><br />Vedi la sezione Multimedia nel file <a href=\"readme.txt\">readme.txt</a> per maggiori informazioni sull'inclusione di media nel tuo sito.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Mantieni collegamenti";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Quando viene trovato un collegamento multimediale che inizia con, ad esempio, http://, ftp://, mms:// non verrà modificato se impostato su <b>#pgv_lang[yes]#</b>. Ad esempio, http://www.myfamily.com/foto/papà.jpg rimarrà http://www.myfamily.com/foto/papà.jpg. Quando impostato su <b>#pgv_lang[no]#</b>, il collegamento verrà gestito come riferimento standard e verrà utilizzata la profondità del supporto. Ad esempio: http://www.myfamily.com/foto/papà.jpg verrà modificato in ./media/papà.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Directory multimediale";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Il percorso di una directory leggibile e scrivibile in cui PhpGedView dovrebbe memorizzare i file multimediali (includere il finale «/»). PhpGedView non richiede che il nome di questa directory sia «media». Puoi scegliere il nome che preferisci.<br /><br />Anche se la funzione firewall multimediale ti consente di archiviare i file multimediali in un'area dello spazio file del server non accessibile da Internet, la directory qui indicata deve ancora esistere e deve essere leggibile da Internet e scrivibile da PhpGedView. Per ulteriori informazioni, fare riferimento alle opzioni di configurazione del firewall multimediale nella sezione Multimedia della pagina di configurazione di GEDCOM.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Livelli di directory multimediali da mantenere";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Un valore di 0 ignorerà tutte le directory nel percorso del file per l'oggetto multimediale. Un valore di 1 manterrà la prima directory contenente questa immagine. L'aumento del numero aumenta il numero di directory principali da conservare nel percorso.<br /><br />Ad esempio, se colleghi un'immagine in GEDCOM con un percorso come <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, un valore 0 tradurrà questo percorso in <b>./media/grandpa.jpg</b>. Un valore di 1 lo tradurrà in <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, ecc. La maggior parte delle persone dovrà usare solo uno 0. Tuttavia, è possibile che alcuni oggetti multimediali siano conservati in directory diverse hanno nomi identici e si sovrascriverebbero a vicenda quando questa opzione è impostata su 0. Le impostazioni diverse da zero consentono di mantenere una certa organizzazione nel supporto evitando così conflitti di nomi.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Se hai abilitato la multimedialità nel tuo sito, puoi fare in modo che PhpGedView visualizzi un'immagine in miniatura accanto al nome della persona nei grafici e nei riquadri.<br /><br />Vedi la sezione Multimedia nel file <a href=\"readme.txt\">readme.txt</a> per maggiori informazioni sull'inclusione di media nel tuo sito.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Usa miniatura";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Questa opzione determina se PhpGedView deve inviare l'immagine grande o piccola al browser ogni volta che un grafico o la pagina <i>#pgv_lang[personal_details]#</i> richiede una miniatura.<br /><br />La scelta <b>#pgv_lang[no]#</b> farà sì che PhpGedView invii l'immagine grande, mentre il La scelta di <b>#pgv_lang[yes]#</b> provocherà l'invio della piccola immagine. Ogni singola immagine ha anche l'opzione «#factarray[_THUM]#» che, se impostata su <b>#pgv_lang[yes]#</b>, farà sì che l'immagine grande venga inviata indipendentemente dall'impostazione dell'opzione «#pgv_lang[USE_THUMBS_MAIN]#» nella configurazione GEDCOM. Non puoi forzare PhpGedView a inviare immagini piccole quando la configurazione di GEDCOM specifica che devono essere sempre usate immagini grandi.<br /><br />PhpGedView non ridimensiona l'immagine inviata; il browser lo fa in base alle specifiche della pagina che ha ricevuto. Ciò può avere conseguenze indesiderabili quando l'immagine inviata non è veramente una miniatura in cui PhpGedView si aspetta di inviare una piccola immagine. Questo non è un errore: ci sono occasioni in cui può essere desiderabile visualizzare un'immagine grande in luoghi dove normalmente ci si aspetterebbe di vedere un'immagine in miniatura.<br /><br />Dovresti evitare di impostare l'opzione «#pgv_lang[USE_THUMBS_MAIN]#» su <b>#pgv_lang[no]#</b>. Questa scelta farà sì che una quantità eccessiva di dati relativi alle immagini venga inviata al browser, solo per fare in modo che il browser scarti l'eccesso. I caricamenti delle pagine, in particolare dei grafici con molte immagini, possono essere seriamente rallentati.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Mostra il nome del file nel visualizzatore multimediale";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Il visualizzatore multimediale può mostrare il nome del file multimediale visualizzato. Questa opzione determina se il nome del file viene mostrato agli utenti o meno.<br /><br />Potrebbe essere necessario nascondere il nome del file per motivi di sicurezza.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Mostra il collegamento per il download nel visualizzatore multimediale";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Il visualizzatore multimediale può mostrare un collegamento che, se cliccato, scaricherà il file multimediale sul PC locale.<br /><br />Potrebbe essere necessario nascondere il collegamento per il download per motivi di sicurezza.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Abilita Carrello Ritagli";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Il carrello dei ritagli consente agli utenti di aggiungere persone a un file temporaneo che possono scaricare in formato GEDCOM per la successiva importazione nel loro software di genealogia.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Nascondi errori GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Impostandolo su <b>#pgv_lang[yes]#</b> si nascondono i messaggi di errore prodotti da PhpGedView quando non comprende un tag nel file GEDCOM. PhpGedView fa ogni sforzo per conformarsi allo standard GEDCOM 5.5.1, ma molti programmi software di genealogia includono i propri tag personalizzati. Consulta il file <a href=\"readme.txt\">readme.txt</a> per ulteriori informazioni. ";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Aggiungi spazi in cui sono state inserite le note";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Alcuni programmi di genealogia avvolgono le note ai confini delle parole mentre altri avvolgono le note ovunque. Ciò può far sì che PhpGedView esegua le parole insieme. Impostando questo valore su <b>#pgv_lang[yes]#</b> si aggiungerà uno spazio tra le parole in cui sono inserite nel GEDCOM originale.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Mostra contestuale Link di aiuto";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Questa opzione abiliterà i collegamenti, identificati da punti interrogativi, accanto agli elementi in molte pagine. Questi collegamenti consentono agli utenti di ottenere informazioni o assistenza su tali elementi.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Limite di giorni per il blocco degli eventi imminenti";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Il valore che inserisci qui determina quanto avanti PhpGedView guarda quando cerca eventi imminenti. I risultati di questa ricerca, eseguita una volta al giorno, vengono copiati in un file temporaneo.<br /><br />Nessun blocco di eventi imminenti nelle pagine di benvenuto o MyGedView può richiedere più giorni di questo valore. Più grande lo si ingrandisce, più tempo sarà necessario per creare l'estrazione giornaliera del database e più tempo ci vorrà per visualizzare il blocco, anche quando si richiede di visualizzare un numero di giorni inferiore a questa impostazione.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Numero minimo di occorrenze per essere un «cognome comune»";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Questo è il numero di volte che un cognome deve comparire prima che compaia nell'elenco dei cognomi comuni nella pagina di benvenuto.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Nomi da aggiungere all'elenco dei cognomi comuni";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Se il numero di volte in cui ricorre un determinato cognome è inferiore alla soglia, non verrà visualizzato nell'elenco. Può essere aggiunto qui manualmente. Se viene inserito più di un cognome, questi devono essere separati da una virgola. <b>I cognomi fanno distinzione tra maiuscole e minuscole.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Nomi da rimuovere dall'elenco dei cognomi comuni";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Se desideri rimuovere un cognome dall'elenco dei cognomi comuni senza aumentare il valore di soglia, puoi farlo inserendo il cognome qui. Se viene inserito più di un cognome, questi devono essere separati da una virgola. <b>I cognomi fanno distinzione tra maiuscole e minuscole.</b> I cognomi inseriti qui verranno rimossi anche dall'elenco dei primi 10 nella pagina di benvenuto.";
$pgv_lang["HOME_SITE_URL"]		= "URL del sito web principale";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Ogni pagina PhpGedView include un collegamento alla tua home page principale. L'aspetto di questo collegamento è controllato dal tema utilizzato. Inserisci qui l'URL effettivo del tuo sito Home.";
$pgv_lang["HOME_SITE_TEXT"]		= "Titolo del sito web principale";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />La legenda utilizzata per identificare il collegamento alla tua home page principale.";
$pgv_lang["CONTACT_EMAIL"]		= "Contatto genealogico";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />La persona da contattare in merito ai dati genealogici su questo sito.";
$pgv_lang["CONTACT_METHOD"]		= "Metodo di contatto";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Il metodo da utilizzare per contattare #pgv_lang[CONTACT_EMAIL]# in merito a domande sulla genealogia.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>L'opzione <b>#pgv_lang[mailto]#</b> creerà un collegamento «mailto» che può essere cliccato per inviare un'e-mail utilizzando il client di posta sul PC dell'utente.</li><li>L'opzione <b>#pgv_lang[messaging]#</b> utilizzerà un sistema di messaggistica interno a PhpGedView e non verranno inviate email.</li><li>L'opzione <b>#pgv_lang[messaging2]#</b> è l'impostazione predefinita. Utilizzerà il sistema di messaggistica PhpGedView e invierà anche copie dei messaggi tramite e-mail.</li><li>L'opzione <b>#pgv_lang[messaging3]#</b> consente a PhpGedView di gestire la messaggistica e invierà i messaggi come e-mail, ma non memorizzerà i messaggi internamente. Questa opzione è simile all'opzione <b>#pgv_lang[mailto]#</b>, tranne per il fatto che il messaggio verrà inviato da PhpGedView invece che dalla workstation dell'utente.</li><li>L'opzione <b>#pgv_lang[no_messaging]#</b> fa sì che i tuoi utenti non abbiano modo di contattarti.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Indirizzo di risposta di PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Indirizzo e-mail da utilizzare nel campo «Da:» di e-mail che PhpGedView crea automaticamente.<br /><br />PhpGedView può creare automaticamente e-mail per notificare agli amministratori le modifiche che devono essere riviste. PhpGedView invia anche e-mail di notifica agli utenti che hanno richiesto un account.<br /><br />Di solito, il campo «Da:» di queste e-mail create automaticamente è qualcosa del tipo <i>Da: phpgedview-noreply@tuosito</i> per mostrare che non è richiesta alcuna risposta all'e-mail. Per proteggersi dallo spam o da altri abusi della posta elettronica, alcuni sistemi di posta elettronica richiedono che ogni messaggio sia «Da:» per indicare un account di posta elettronica valido e non accetterà messaggi apparentemente dall'account <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Contatto assistenza";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />La persona da contattare per domande tecniche o errori riscontrati sul tuo sito.";
$pgv_lang["SUPPORT_METHOD"]		= "Metodo di supporto";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Il metodo da utilizzare per contattare #pgv_lang[WEBMASTER_EMAIL]# in merito a questioni tecniche.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Mostra icone dei fatti";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Impostalo su <b>#pgv_lang[yes]#</b> per visualizzare le icone vicino ai nomi dei fatti nella pagina <i>#pgv_lang[personal_details]#</i>. Le icone dei fatti verranno visualizzate solo se esistono nella directory <i>images/facts</i> del tema corrente.";
$pgv_lang["FAVICON"]			= "Icona dei preferiti";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Cambia questo in modo che punti all'icona che desideri visualizzare nel menu dei preferiti delle persone quando aggiungono il tuo sito ai preferiti.";
$pgv_lang["THEME_DIR"]			= "Directory dei temi";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />La directory in cui sono conservati i file dei temi di PhpGedView.<br /><br />Puoi personalizzare uno qualsiasi dei temi standard forniti con PhpGedView per dare al tuo sito un aspetto unico. Per ulteriori informazioni, vedere la sezione Personalizzazione del tema del file <a href=\"readme.txt\">readme.txt</a>.";
$pgv_lang["TIME_LIMIT"]			= "Limite di tempo PHP";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Il tempo massimo in secondi per l'esecuzione di PhpGedView.<br /><br />Il valore predefinito è 1 minuto. A seconda delle dimensioni del file GEDCOM, potrebbe essere necessario aumentare questo limite di tempo quando è necessario creare gli indici. Impostare questo valore su 0 per consentire a PHP di essere eseguito per sempre.<br /><br />ATTENZIONE: impostarlo su 0 o impostarlo su un valore troppo alto potrebbe causare il blocco del sito su determinati sistemi operativi fino al termine dello script. Impostarlo su 0 significa che potrebbe non finire mai fino a quando un amministratore del server non termina il processo o riavvia il server. L'esecuzione di un albero genealogico di grandi dimensioni può richiedere molto tempo; lasciare questo valore il più basso possibile assicura che qualcuno non possa mandare in crash il tuo server richiedendo un grafico eccessivamente grande.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Il percorso per memorizzare i file di sessione PhpGedView.<br /><br />Alcuni host non hanno PHP configurato correttamente e le sessioni non vengono mantenute tra le richieste di pagina. Questa opzione consente agli amministratori del sito di superare il problema salvando i file in una delle loro directory locali. La directory ./index/ è una buona scelta se è necessario cambiarla. L'impostazione predefinita è lasciare il campo vuoto, che utilizzerà il percorso di salvataggio come configurato in <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Se utilizzi https o una porta diversa da quella predefinita, dovrai inserire l'URL per accedere al tuo server qui.";
$pgv_lang["LOGIN_URL"]			= "URL di accesso";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Devi solo inserire un URL di accesso se desideri reindirizzare a un sito o una posizione diversi quando i tuoi utenti accedono. Questo è molto utile se devi passare da http a https quando i tuoi utenti accedono. Includi l'URL completo di <i>login.php</i>. Per esempio, https://www.yourserver.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Il tempo in secondi in cui una sessione PhpGedView rimane attiva prima di richiedere un accesso. L'impostazione predefinita è 7200, ovvero 2 ore.";
$pgv_lang["SHOW_STATS"]			= "Mostra le statistiche di esecuzione";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Mostra le statistiche di runtime e le query del database in fondo a ogni pagina.";
$pgv_lang["SHOW_COUNTER"]		= "Mostra contatori di visite";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Mostra i contatori di visite nelle pagine MyGedView e <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Offre ai visitatori la possibilità di registrarsi per un account sul sito.<br /><br />Il visitatore riceverà un messaggio di posta elettronica con un codice per verificare la sua richiesta di account. Dopo la verifica, l'amministratore dovrà approvare la registrazione prima che diventi attiva.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Offre agli utenti la possibilità di selezionare il proprio tema.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />Nelle normali intestazioni di posta per i messaggi esterni, vengono utilizzati sia l'indirizzo di posta elettronica che il nome. Alcuni sistemi di posta non lo accetteranno. Se impostato su <b>#pgv_lang[yes]#</b>, verrà utilizzato solo l'indirizzo e-mail.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Usa SMTP per inviare e-mail da PhpGedView.<br /><br />Questa opzione richiede l'accesso a un server di posta SMTP. Quando impostato su <b>#pgv_lang[no]#</b>, PhpGedView utilizzerà il sistema di posta elettronica integrato in PHP su questo server.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Quando l'opzione <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> è impostata su <b>#pgv_lang[yes]#</b>, PhpGedView utilizzerà il programma PHPMailer per inviare e-mail. Questo programma produce messaggi di errore quando incontra problemi durante il tentativo di inviare e-mail.<br /><br />Questa opzione, utile durante il tentativo di risolvere problemi di invio di e-mail, determina i tipi di errori che PHPMailer segnalerà. I tipi di errore che puoi selezionare sono:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Questo è il nome del server di posta SMTP. Esempio: <b>smtp.foo.bar.com</b>.<br /><br />Valori di configurazione per alcuni provider di posta elettronica:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 o 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 o 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (attualmente un servizio a pagamento)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Questa è la parte di dominio di un indirizzo e-mail valido sul server SMTP.<br /><br />Ad esempio, se hai un account e-mail come <b>tuonome@abc.xyz.com</b>, inserire <b>abc.xyz.com</b> qui.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Il numero di porta da utilizzare per le connessioni al server SMTP. In genere, questa è la porta <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Utilizzare l'autenticazione con nome e password per connettersi al server SMTP.<br /><br />Alcuni server SMTP richiedono che tutte le connessioni siano autenticate prima di accettare le e-mail in uscita.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Il nome utente richiesto per l'autenticazione con il server SMTP.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />La password richiesta per l'autenticazione con il server SMTP.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) e Secure Sockets Layer (SSL) sono protocolli di crittografia dei dati Internet.<br /><br />TLS 1.0, 1.1 e 1.2 sono sviluppi standardizzati di SSL 3.0. TLS 1.0 e SSL 3.1 sono equivalenti. Ulteriore lavoro su SSL viene ora svolto con il nuovo nome, TLS.<br /><br />Se il server SMTP richiede il protocollo SSL durante l'accesso, è necessario selezionare l'opzione <b>SSL</b>. Se il tuo server SMTP richiede il protocollo TLS durante l'accesso, devi selezionare l'opzione <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Inserisci il nome da utilizzare nel campo «Da:» delle e-mail provenienti da questo sito.<br /><br />Ad esempio, se il tuo nome è <b>John Smith</b> e sei l'amministratore del sito noto come <b>Jones Genealogy</b>, potresti inserire qualcosa come <b>John Smith</b> o <b>Jones Genealogy</b> o anche <b>John Smith, Amministratore: Jones Genealogy</b>. Puoi inserire quello che desideri, ma l'HTML non è consentito.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Inserisci un titolo descrittivo da visualizzare quando gli utenti scelgono tra i set di dati GEDCOM sul tuo sito.";
$pgv_lang["LOGFILE_CREATE"]		= "Archivia file di log";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Con quale frequenza il programma deve archiviare i file di log.";
$pgv_lang["REMINDER_FREQ"] 			= "Frequenza delle e-mail di promemoria «Rivedi modifiche»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Questa opzione controlla la frequenza con cui verranno inviate le e-mail di promemoria «Rivedi modifiche». <b>zero</b>: mai;&nbsp;&nbsp;<b>1</b>: tutti i giorni;&nbsp;&nbsp;<b>2</b>: ogni 2 giorni; ecc.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />La quantità massima di memoria che può essere consumata dagli script PhpGedView. L'impostazione predefinita è 64 Mb. Molti host disabilitano questa opzione nella loro configurazione PHP; la modifica di questo valore potrebbe non influire effettivamente sull'impostazione della memoria massima corrente.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Specifica se i messaggi inviati tramite PhpGedView possono essere archiviati nel database. Se impostato su <b>#pgv_lang[yes]#</b>, gli utenti saranno in grado di recuperare i loro messaggi quando accedono a PhpGedView. Se impostato su <b>#pgv_lang[no]#</b>, i messaggi verranno inviati solo tramite posta elettronica.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Visualizza un menu per le modifiche al tema";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Offre agli utenti la possibilità di selezionare il proprio tema da un menu.<br /><br />Anche con questa opzione impostata, il tema attualmente in vigore potrebbe non fornire tale menu. Per essere efficace, questa opzione richiede che sia impostata anche l'opzione <b>#pgv_lang[ALLOW_USER_THEMES]#</b>.";
$pgv_lang["MAX_VIEW_RATE"]		= "Velocità massima di visualizzazione della pagina";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Questa opzione limita la velocità con cui un utente può visualizzare le pagine.<br /><br />Se questa velocità viene superata, PhpGedView considera la sessione come un tentativo di hacking; la sessione verrà terminata con un apposito messaggio. Questi due valori dovrebbero porre un limite ragionevole alla quantità di larghezza di banda e byte scaricati dal server. Questa funzione può essere disattivata impostando l'intervallo di tempo su 0.";
$pgv_lang["META_AUTHOR"]		= "META tag: Author (Autore)";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Il valore da inserire nel metatag Author nell'intestazione della pagina HTML. Lascia vuoto questo campo per utilizzare il nome completo dell #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_AUTHOR_descr"]	= "Lascia vuoto questo campo per utilizzare il nome completo dell #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Publisher (Editore)";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Il valore da inserire nel metatag Publisher nell'intestazione della pagina HTML.  Lascia vuoto questo campo per utilizzare il nome completo dell #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER_descr"]	= "Lascia vuoto questo campo per utilizzare il nome completo dell #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: Copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Il valore da inserire nel metatag Copyright nell'intestazione della pagina HTML.  Lascia vuoto questo campo per utilizzare il nome completo dell #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT_descr"]	= "Lascia vuoto questo campo per utilizzare il nome completo dell #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Description (Descrizione)";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Il valore da inserire nel metatag Description nell'intestazione della pagina HTML. Lascia vuoto questo campo per utilizzare il titolo del database attualmente attivo.";
$pgv_lang["META_DESCRIPTION_descr"]	= "Lascia vuoto questo campo per utilizzare il titolo del database attualmente attivo.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Page-topic (Soggetto della pagina)";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Il valore da inserire nel metatag Page-topic nell'intestazione della pagina HTML. Lascia vuoto questo campo per utilizzare il titolo del database attualmente attivo.";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Lascia vuoto questo campo per utilizzare il titolo del database attualmente attivo.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Audience (Pubblico)";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Il valore da inserire nel metatag Audience nell'intestazione della pagina HTML.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag Page-type (Tipo di pagina)";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Il valore da inserire nel metatag Page-type nell'intestazione della pagina HTML.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robots (Robot)";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Il valore da inserire nel metatag Robots nell'intestazione della pagina HTML. Alcuni motori di ricerca ignorano questo valore.";
$pgv_lang["META_REVISIT"]		= "META tag: Revisit (Rivisitare)";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Con che frequenza i motori di ricerca dovrebbero rivisitare questo sito? Il valore da inserire nel metatag Revisit nell'intestazione della pagina HTML. Alcuni motori di ricerca ignorano questo valore.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Keywords (Parole chiave)";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Il valore da inserire nel metatag Keywords nell'intestazione della pagina HTML. Alcuni motori di ricerca utilizzeranno il meta tag Parole chiave per indicizzare la tua pagina.<br /><br />L'elenco #pgv_lang[common_surnames]# che appare nel blocco #pgv_lang[gedcom_stats]# sulla tua pagina di benvenuto può anche essere aggiunto a tutto ciò che inserisci qui.";
$pgv_lang["META_TITLE"]		= "Intestazione della pagina: tag TITLE (Titolo)";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Qualunque cosa su questa riga verrà aggiunta al tag TITLE nell'intestazione della pagina HTML dopo il titolo della pagina normale e prima del credito PhpGedView.";

$pgv_lang["ENABLE_RSS"]				= "Abilita RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Questa opzione ti consente di disabilitare la funzione RSS.<br /><br />RSS consente agli utenti di monitorare il tuo sito per le modifiche alla pagina Indice senza effettivamente visitare il tuo sito periodicamente. Se troppi utenti fanno uso di questa funzione o se la frequenza di aggiornamento impostata da questi utenti è troppo alta, RSS può utilizzare troppa larghezza di banda o capacità del server.<br /><br />Questo <a href='https://it.wikipedia.org/wiki/RSS' target='_blank' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a> contiene informazioni e collegamenti completi sugli RSS e sui vari formati RSS.";
$pgv_lang["RSS_FORMAT"]				= "Formato RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Il formato da utilizzare come formato di feed predefinito per il sito. I suffissi numerici <u>non</u> indicano la versione: identificano i formati. Ad esempio, RSS 2.0 non è più recente di RSS 1.0, ma un formato diverso. I lettori di feed dovrebbero essere in grado di leggere qualsiasi formato.<br /><br />Questo <a href='https://it.wikipedia.org/wiki/RSS' target='_blank' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a> contiene informazioni e collegamenti completi sugli RSS e sui vari formati RSS.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Controlla se i file GEDCOM sono scaricabili da Internet";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Per motivi di sicurezza, i file GEDCOM non dovrebbero trovarsi in una posizione in cui possono essere scaricati direttamente, aggirando così i controlli sulla privacy. Facendo clic su questo collegamento si verificherà se i file GEDCOM possono essere scaricati in rete.<br /><br />Su alcuni sistemi è noto che questo controllo richiede molto tempo o non viene nemmeno completato. Se questo è il tuo caso, dovresti provare a puntare il tuo browser direttamente sul tuo GEDCOM per vedere se può essere scaricato.";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# non può essere scaricato.";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Se stai vedendo questa pagina, hai correttamente installato PhpGedView sul tuo server e sei pronto per iniziare a configurarlo secondo le tue esigenze.<br /><br />Questa pagina di Aiuto ti guiderà attraverso il processo di configurazione. Mentre completerai i diversi campi, questa finestra ti darà informazioni sul campo che stai completando. Puoi chiudere questa finestra; per aprire di nuovo fare clic su uno dei «#pgv_lang[qm]#»  punti interrogativi accanto al nome del campo.<br />";
$pgv_lang["return_editconfig"]		= "Potrai tornare a questa configurazione in qualunque momento andando con il tuo browser su <i>edit_config.php</i> o cliccando il link per la <b>Configurazione</b> sulla pagina <b>#pgv_lang[gedcom_adm_head]#</b>.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "È possibile tornare a questa configurazione in qualsiasi momento facendo clic sul collegamento <b>Modifica</b> nella tabella <b>#pgv_lang[current_gedcoms]#</b> nella pagina <b>#pgv_lang[gedcom_adm_head]#</b> o puntando il browser su <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"] 	= "Salva configurazione";
$pgv_lang["download_gedconf"]		= "Scarica la configurazione GEDCOM.";
$pgv_lang["not_writable"]		= "Abbiamo rilevato che il tuo file di configurazione non è scrivibile da PHP. È possibile utilizzare il pulsante <b>#pgv_lang[download_file]#</b> per salvare le impostazioni in un file che è possibile caricare manualmente.";
$pgv_lang["upload_to_index"]		= "Carica il file nella directory index: ";
$pgv_lang["import_sql"]			= "I file SQL sono stati trovati nella directory dell'indice. Poiché potrebbero essere originati dallo #pgv_lang[um_header]#, hai la possibilità di importare le informazioni nel tuo database. Vuoi provare a importare questi file nel tuo database adesso? Tutte le informazioni esistenti relative agli utenti (utenti, notizie, preferiti, layout di blocco e messaggi) nel database andranno perse.<br /><br />Se scegli di procedere, PhpGedView tenterà di importare i dati. Se ciò non va a buon fine, ti verrà chiesto di creare comunque il primo account amministratore.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Modifica privacy";
$pgv_lang["edit_privacy_title"]			= "Modifica le impostazioni sulla privacy di GEDCOM";
$pgv_lang["save_changed_settings"]		= "Salva cambiamenti";
$pgv_lang["add_new_pp_setting"]			= "Aggiungi una nuova impostazione della privacy totale per ID persona";
$pgv_lang["add_new_up_setting"]			= "Aggiungi una nuova impostazione della privacy per il nome utente";
$pgv_lang["add_new_gf_setting"]			= "Aggiungi una nuova impostazione della privacy globale dei fatti";
$pgv_lang["add_new_pf_setting"]			= "Aggiungi una nuova impostazione della privacy dei fatti per ID persona";
$pgv_lang["file_read_error"]			= "E R R O R E !!! Impossibile leggere il file sulla privacy!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Modifica le impostazioni esistenti della privacy totale per ID persona";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Modifica le impostazioni esistenti della privacy per il nome utente";
$pgv_lang["edit_exist_global_facts_settings"]	= "Modifica le impostazioni esistenti della privacy globale dei fatti";
$pgv_lang["edit_exist_person_facts_settings"]	= "Modifica le impostazioni esistenti della privacy dei fatti per ID persona";
$pgv_lang["general_privacy"]			= "Impostazioni generali sulla privacy";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Puoi avere diverse impostazioni di privacy per ogni GEDCOM sul tuo sito web PhpGedView. Controlla sotto il titolo della pagina se stai modificando il GEDCOM corretto.<br /><br />Puoi sovrascrivere queste impostazioni generali utilizzando gli altri moduli sulla privacy nella pagina #pgv_lang[edit_privacy_title]#.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Impostazione della privacy totale per ID persona";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Queste impostazioni consentono agli amministratori di ignorare le impostazioni di privacy predefinite per una determinata persona, famiglia, fonte o oggetto multimediale.<br /><br />Supponi, ad esempio, di avere un figlio morto in tenera età. Normalmente, poiché il bambino è morto, i suoi dettagli sarebbero mostrati agli utenti pubblici. Tuttavia, tu e tutti gli altri nella tua famiglia siete ancora privati. Non vuoi rimuovere il record di morte per il bambino ma vuoi nascondere i dettagli e renderli privati. Se questo bambino aveva l'ID I100, dovresti inserire le seguenti impostazioni di privacy:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Funziona anche nell'altro modo. Se desideri rendere pubblici i dettagli di qualcuno (ID I101) di cui sai essere morto ma per cui non hai una data di morte, puoi aggiungere quanto segue:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Impostazione della privacy per il nome utente";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Queste impostazioni danno agli amministratori la possibilità di sovrascrivere le impostazioni di privacy predefinite per gli individui in GEDCOM in base al nome utente. Supponiamo che tu non voglia che il nome utente <b>John</b> sia in grado di vedere i dettagli dell'ID I100 in GEDCOM, puoi configurarlo in questo modo:<br />&nbsp;&nbsp;&nbsp;Nome utente:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e i dettagli per la persona specificata sarebbero nascosti solo per il nome utente \"John\".<br /><br />Da mostrare i dettagli di I101 (che di solito sarebbero nascosti perché I101 è ancora attivo) su Nome utente \"John\" impostato:<br />&nbsp;&nbsp;&nbsp;Nome utente:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Impostazione della privacy globale dei fatti";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Queste impostazioni definiscono i fatti a livello globale che dovrebbero essere nascosti a tutti gli individui nel GEDCOM. Questo si applica solo ai record dei fatti di livello 1 come BIRT o DEAT che appariranno con le proprie intestazioni nella scheda #pgv_lang[personal_facts]# della pagina <i>#pgv_lang[personal_details]#</i>.<br /><ul><li>L'elemento <b>#pgv_lang[name_of_fact]#</b> determina quale fatto deve essere nascosto.</li><li>L'elemento <b>#pgv_lang[choice]#</b> specifica il fatto stesso oi dettagli correlati.</li><li>L'elemento <b>#pgv_lang[accessible_by]#</b> determina a quale livello di accesso viene mostrato il fatto.</li></ul><br />Questa funzione ha lo scopo di nascondere determinati fatti, identificati dai tag GEDCOM, per tutti gli individui vivi o morti. Per impostazione predefinita, il tag SSN è nascosto agli utenti pubblici. Questo per impedire alle persone di rubare i numeri di previdenza sociale e di commettere furti di identità di persone morte. Questo è probabilmente per lo più rilevante per gli Stati Uniti.<br /><br />Se vuoi nascondere tutti i matrimoni agli utenti pubblici nel tuo GEDCOM puoi impostare:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Matrimonio<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Queste impostazioni nascondono i matrimoni e i relativi dettagli ai visitatori che non hanno effettuato l'accesso.<br /><br />A differenza di tutte le altre impostazioni, in <b>#pgv_lang[edit_exist_global_facts_settings]#</b> puoi nascondere i fatti anche agli utenti amministratori. I fatti indesiderati vengono completamente soppressi.";
$pgv_lang["person_facts"]				= "Impostazione della privacy dei fatti per ID persona";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Queste impostazioni definiscono i fatti che sono nascosti per una persona, famiglia o fonte specifica e il livello al quale sono nascosti. Ciò si applica solo ai record dei fatti di livello 1 come BIRT o DEAT che appariranno con le proprie intestazioni nella pagina dei dettagli pertinenti della persona, della famiglia o della fonte.<br /><br />Il primo elemento è l'ID del persona, famiglia o fonte. Il secondo elemento è il fatto. L'elemento <b>#pgv_lang[choice]#</b> specifica il fatto stesso oi dettagli correlati. L'elemento <b>#pgv_lang[accessible_by]#</b> determina a quale livello di accesso viene mostrato il fatto. Non tutti i fatti mostrati nell'elenco sono applicabili a tutti i tipi di ID. Ad esempio, i fatti di nascita e morte non sono rilevanti per i record di origine.<br /><br />Questo elenco è simile all'elenco <b>#pgv_lang[global_facts]#</b> tranne per il fatto che specifichi anche l'ID GEDCOM della persona per cui desideri nascondere i fatti. Ad esempio, potresti nascondere il certificato di matrimonio di una persona specifica.";
$pgv_lang["accessible_by"]			= "Mostra a?";
$pgv_lang["hide"]				= "Occultare";
$pgv_lang["show_question"]			= "Mostra?";
$pgv_lang["user_name"]				= "Nome utente";
$pgv_lang["name_of_fact"]			= "Nome del fatto";
$pgv_lang["choice"]				= "Opzione";
$pgv_lang["fact_show"]				= "Mostra il fatto";
$pgv_lang["fact_details"]			= "Mostra i dettagli dei fatti";
$pgv_lang["privacy_header"]			= "Modifica le impostazioni sulla privacy";
$pgv_lang["unable_to_find_privacy_indi"]	= "Impossibile trovare una persona con ID";
$pgv_lang["save_and_import"]			= "Dopo aver salvato questa configurazione GEDCOM, dovrai importare GEDCOM facendo clic sul pulsante <b>Importa GEDCOM</b> o andando su <b>Amministrazione --> Gestisci GEDCOM --> Importa</b>";
$pgv_lang["help_info"]				= "Puoi ottenere assistenza per ogni articolo facendo clic sul pulsante rosso «#pgv_lang[qm]#» accanto all'etichetta di ogni scatola.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Mostra nomi dei viventi";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />I nomi delle persone viventi dovrebbero essere mostrati al pubblico?<br /><br />Normalmente questa impostazione sarebbe «#pgv_lang[PRIV_USER]#». Questo serve a proteggere la privacy delle persone viventi nel tuo database, perché puoi determinare a chi concedi l'accesso generale ai tuoi dati genealogici.<br /><br />L'impostazione «#pgv_lang[PRIV_NONE]#» impedisce di mostrare i nomi di persone viventi a utenti che non hanno diritti di amministratore.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Mostra il assistente di ricerca";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Che tipo di utente può visualizzare il modulo dell'assistente di ricerca se è installato?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Usa la privacy delle relazioni";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> significa che gli utenti autenticati possono vedere i dettagli di tutte le persone viventi. <b>#pgv_lang[yes]#</b> significa che gli utenti possono vedere solo le informazioni private delle persone viventi a cui sono correlati.<br /><br />Questa opzione imposta l'impostazione predefinita per tutti gli utenti che hanno accesso a questo database genealogico. L'amministratore può ignorare questa opzione per i singoli utenti modificando i dettagli dell'account dell'utente.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Lunghezza massima del percorso di relazione";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Se l'opzione <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> è abilitata, gli utenti che hanno effettuato l'accesso potranno vedere o modificare solo le persone all'interno di questo numero di passaggi di relazione.<br /><br />Questa opzione imposta l'impostazione predefinita per tutti gli utenti che hanno accesso a questo database genealogico. L'amministratore può ignorare questa opzione per i singoli utenti modificando i dettagli dell'account dell'utente.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Controlla i relazioni matrimoniali";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Controlla le relazioni legate dal matrimonio.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Visualizza le persone morte";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Imposta il livello di accesso alla privacy per tutte le persone morte.";
$pgv_lang["select_privacyfile_button"]		= "Seleziona file privacy";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Limita la privacy in base all'età dell'evento";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />L'impostazione <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> nasconderà i dettagli delle persone in base all'età che avevano in eventi specifici, indipendentemente dal fatto che siano vivi o morti.<br /><br />Usa questa impostazione insieme all'impostazione <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Ad esempio, se si imposta Età 100 e si imposta questa opzione su <b>#pgv_lang[yes]#</b>, tutte le persone, vive o morte, nate meno di 100 anni fa verranno impostate come private. Anche le persone che si sono sposate meno di 85 anni fa e le persone che sono morte meno di 75 anni fa sarebbero state contrassegnate come private. Si noti che l'utilizzo di questa opzione rallenterà leggermente le prestazioni.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Questa pagina è destinata ai traduttori. Puoi tradurre, confrontare ed esportare file di lingua. C'è anche un'opzione per aiutare i traduttori a determinare l'origine del testo emesso da PhpGedView.<br /><br />Puoi usare le seguenti opzioni e utilità:";
$pgv_lang["edit_langdiff"]	= "Modifica il contenuto dei file di linguaggio";
$pgv_lang["bom_check"]		= "Controllo Byte Order Mark (BOM)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Questo controllo analizzerà tutti i file di lingua per il BOM (Byte Order Mark). Se trovato, rimuoverà la distinta base dal file interessato. Questi codici speciali possono causare malfunzionamenti in alcune parti di PhpGedView.";
$pgv_lang["lang_debug"]			= "Opzione di debug del testo della guida";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Quando si abilita questa opzione, i nomi delle variabili di lingua utilizzate nel testo della guida verranno stampati nella finestra popup del testo della guida. Ciò aiuterà i traduttori a determinare il nome della variabile quando il testo deve essere modificato.<br /><br />Questa impostazione sarà valida solo durante la sessione corrente di PhpGedView.";
$pgv_lang["lang_debug_use"]		= "Utilizzare l'opzione di debug del testo della guida";
$pgv_lang["bom_not_found"]		= "Nessuna distinta base è stata trovata.";
$pgv_lang["bom_found"]			= "BOM è stato trovato in ";
$pgv_lang["edit_lang_utility"]	= "Utility per editare i file di linguaggio";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "È possibile utilizzare questa utilità per modificare il contenuto di un file di lingua utilizzando il contenuto di quello inglese.<br /><br />Vedrai il contenuto del file in lingua inglese originale e il contenuto dello stesso tipo di file (ce ne sono nove) nella lingua scelta. Fai clic sul testo del messaggio mostrato sotto la versione inglese. Si apre una nuova finestra in cui è possibile modificare il testo. Puoi salvare le modifiche o abbandonarle.";
$pgv_lang["edit_lang_utility_warning"]	= "ATTENZIONE!<br /><br />Se premi il pulsante <b>#pgv_lang[close_window_without_refresh]#</b>, potresti non vedere i tuoi cambiamenti sullo schermo finché non ricaricherai la pagina manualmente. È possibile che il tuo file della lingua venga dsitrutto se aggiungi un messaggio che non è ancora apparso all'interno del file di linguaggio o se modifichi un messaggio ancora.<br /><br />Se non sai quello che stai facendo,  per favore non usare il pulsante <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]	= "Lingua da modificare";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />In questo elenco si seleziona la lingua di cui si desidera modificare i messaggi.";
$pgv_lang["file_to_edit"]	= "Tipo del file di lingua da modificare";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView ha implementato il supporto per molte lingue diverse. Ciò è stato ottenuto mantenendo tutto il testo visibile agli utenti nei file completamente separati dal programma principale. È disponibile un set di otto file per ciascuna lingua supportata ei vari testi sono stati separati in uno di questi file in base alla funzione. <b>Non è necessario che siano presenti tutti i file di lingua.</b> Quando un determinato testo non è ancora disponibile nella forma tradotta, PhpGedView utilizzerà sempre la versione inglese.<br /><br />I file in ogni lingua impostata siamo:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Questo file contiene termini ed espressioni comuni da utilizzare durante l'amministrazione di PhpGedView e dei database genealogici.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Questo file contiene il testo della guida da utilizzare durante la configurazione di PhpGedView. Il testo della Guida non è destinato alla visualizzazione da parte degli utenti ordinari.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Si tratta di un elenco di nomi di paesi, tratto dal sito Web della Divisione statistica, Dipartimento degli affari economici e sociali delle Nazioni Unite. Questo è il <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> pertinente alla lista inglese. L'elenco è disponibile in inglese o francese.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Questo file contiene termini ed espressioni comuni da utilizzare durante la modifica delle voci nei database genealogici.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Questo file contiene gli equivalenti testuali dei codici GEDCOM Fact trovati nello Standard GEDCOM 5.5.1. Contiene inoltre codici Fact aggiuntivi non presenti nello Standard ma utilizzati da vari programmi di genealogia.<br /><br />Una copia inglese dello <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>standard GEDCOM 5.5.1</b></a> può essere scaricata in PDF (Portable Document Format = formato di documento portatile).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Questo file è un insieme di <b>f</b>requently <b>a</b>sked <b>q</b>uestions (Domande frequenti) che sono stati raccolti dal team di sviluppo di PhpGedView. Ogni FAQ ha due voci in questo file. Una voce è l'intestazione della FAQ (di solito la domanda) e l'altra è il corpo della FAQ (solitamente la risposta). Le sostituzioni per i file <b><i>faqlist.xx.php</i></b>, che vengono aggiornate frequentemente, possono essere scaricate dal sito principale di PhpGedView.<br /><br />L'amministratore può utilizzare le FAQ in questo file per creare un elenco di FAQ specifico per il suo sito.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Questo file contiene il testo della Guida per gli utenti ordinari. Alcuni argomenti della Guida in questo file soddisfano le esigenze degli amministratori e sono nascosti agli utenti che non dispongono dei diritti di amministratore.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Molti termini ed espressioni comuni si trovano in questo file.</li></ul><br />PhpGedView supporta anche un file opzionale per la nona lingua, <b><i>extra.xx.php</i></b>. Questo file viene sempre caricato dopo tutti gli altri e fornisce un mezzo con cui un amministratore del sito può sovrascrivere o modificare qualsiasi testo standard nella lingua selezionata. Può anche essere utilizzato per fornire un titolo per i database genealogici che varia a seconda della lingua attualmente attiva.<br /><br />Il contenuto di questo file aggiuntivo è completamente a carico dell'amministratore del sito; questo file <b>non verrà mai</b> distribuito con nessuna versione di PhpGedView. L'amministratore non dovrebbe mai apportare modifiche ai file della lingua standard; tutte le modifiche locali dovrebbero essere concentrate in questo file opzionale.";
$pgv_lang["check"]			= "Controlla";
$pgv_lang["lang_save"]		= "Salva";
$pgv_lang["contents"]		= "Contenuti";
$pgv_lang["listing"]			= "Listato";
$pgv_lang["no_content"]		= "Nessun contenuto";
$pgv_lang["editlang"]			= "Modifica";
$pgv_lang["editlang_help"]	= "Modifica il messaggio dal file del linguaggio";
$pgv_lang["savelang"]			= "Salva";
$pgv_lang["savelang_help"]	= "Salva il messaggio modificato";
$pgv_lang["original_message"]	= "Messaggio originale";
$pgv_lang["message_to_edit"]		= "Messaggio da modificare";
$pgv_lang["changed_message"]		= "Contenuto modificato";
$pgv_lang["message_empty_warning"]	= "-&gt; Avvertimento!!! Questo messaggio è vuoto in #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]	= "Linguaggio da esportare";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Da questo elenco è possibile selezionare la lingua e i file di lingua di cui si desidera esportare il testo.<br /><br />L'output è un file HTML che è possibile stampare dal browser.";
$pgv_lang["export_lang_utility"]	= "Utilità di esportazione dei file di lingua";
$pgv_lang["export"]		= "Esporta";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "È possibile creare documentazione per gli amministratori.<br /><br />Questa utilità produrrà una versione HTML del file della lingua selezionata. Puoi usare il tuo browser per guardare questo file, che è formattato per la stampa.";
$pgv_lang["export_ok"]			= "Il testo in lingua è stato esportato";
$pgv_lang["compare_lang_utility"]	= "Utilità di confronto dei file di lingua";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Questa utility confronterà due serie di file di lingua per produrre un elenco delle aggiunte e delle sottrazioni tra di loro.<br /><br />I file in inglese devono essere utilizzati come riferimento da cui vengono prodotti tutti gli altri.";
$pgv_lang["new_language"]	= "Nuovo linguaggio";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Da questo elenco puoi selezionare la lingua di cui desideri confrontare i messaggi con quelli di un'altra lingua.<br /><br />Tutte le modifiche e le aggiunte ai file della lingua vengono prima apportate ai file della lingua <b>Inglese</b>, quindi normalmente selezioni l'inglese come una delle lingue da confrontare.";
$pgv_lang["old_language"]	= "Vecchio linguaggio";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Da questo elenco è possibile selezionare la lingua che si desidera confrontare con la lingua selezionata nell'elenco <b>#pgv_lang[new_language]#</b>.<br /><br />Dopo aver effettuato la scelta, fare clic su <b>Confronta</b> per ottenere un elenco di tutte le aggiunte e le sottrazioni in tutti i file di entrambe le lingue.<br /><br />Per aggiornare la memoria:<br /><b>Addizione</b> significa: è <u>nel</u> file di origine, ma <u>non</u> nel file secondario.<br /><br /><b>Sottrazione</b> significa: è <u>non</u> nel file di origine, ma <u>è</u> nel file secondario. Ciò potrebbe accadere quando un determinato messaggio non è più utilizzato e quindi è stato rimosso dai file in inglese. È possibile rimuovere in modo sicuro il messaggio corrispondente dai file della lingua secondaria.";
$pgv_lang["compare"]		= "Confronta";
$pgv_lang["comparing"]		= "File Linguaggio confrontati";
$pgv_lang["additions"]		= "Aggiunte";
$pgv_lang["no_additions"]	= "Nessuna aggiunta";
$pgv_lang["subtractions"]		= "Sottrazioni";
$pgv_lang["no_subtractions"]		= "Nessuna sottrazione";
$pgv_lang["config_lang_utility"]	= "Configurazione delle lingue supportate";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Questa pagina viene utilizzata per controllare le scelte di lingua disponibili per i tuoi utenti. Ad esempio, puoi impostare le cose in modo che siano disponibili solo l'italiano e il francese. Ciò potrebbe essere utile se, ad esempio, non sei in grado di comunicare con i tuoi utenti in ungherese.<br /><br />Utilizzi questa pagina anche per modificare alcuni aspetti di PhpGedView che dipendono dalla lingua selezionata. Ad esempio, qui è dove dici a PhpGedView come formattare i campi di data e ora.<br /><br />Le lingue che sono attive e in grigio non possono essere disabilitate perché sono in uso. Guarda la tabella in basso per vedere dove viene utilizzata la lingua. Quando una lingua non è più utilizzata dal GEDCOM o dall'utente, sarà possibile disattivarla.<br /><br />Tutte le modifiche verranno registrate in un nuovo file chiamato <i>language_settings.php</i> creato nella directory <b>#INDEX_DIRECTORY#</b>. Tutte le tue ulteriori modifiche verranno apportate a questo nuovo file e PhpGedView utilizzerà solo <u>questo</u> file. Puoi ripristinare le impostazioni della lingua predefinita originale eliminando questo file.<br /><br />Se devi segnalare problemi con le impostazioni della lingua, comunica al team di supporto di PhpGedView se questo nuovo file è presente o meno.";
$pgv_lang["active"]			= "Attiva";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Consenti agli utenti di selezionare questa lingua se l'opzione <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> è abilitata.";
$pgv_lang["edit_settings"]		= "Modificare le impostazioni";
$pgv_lang["lang_edit"]			= "Modificare";
$pgv_lang["lang_language"]		= "Linguaggio";
$pgv_lang["export_filename"]		= "Nome del file di output:";
$pgv_lang["lang_back"]			= "Torna al menu principale per modificare e configurare i file della lingua";
$pgv_lang["lang_back_admin"]		= "Torna al menu Amministratore";
$pgv_lang["lang_back_manage_gedcoms"]	= "Torna al menu di gestione di GEDCOM";
$pgv_lang["lang_name_arabic"]		= "Arabo";
$pgv_lang["lang_name_catalan"]		= "Catalano (Valenciano)";
$pgv_lang["lang_name_chinese"]		= "Cinese (Tradizionale)";
$pgv_lang["lang_name_chinese-cn"]	= "Cinese (Semplificato)";
$pgv_lang["lang_name_croatian"]		= "Croato";
$pgv_lang["lang_name_czech"]		= "Ceco";
$pgv_lang["lang_name_danish"]		= "Danese";
$pgv_lang["lang_name_dutch"]		= "Olandese";
$pgv_lang["lang_name_english"]		= "Inglese";
$pgv_lang["lang_name_estonian"]		= "Estone";
$pgv_lang["lang_name_finnish"]		= "Finlandese";
$pgv_lang["lang_name_french"]		= "Francese";
$pgv_lang["lang_name_german"]		= "Tedesco";
$pgv_lang["lang_name_greek"]		= "Greco";
$pgv_lang["lang_name_hebrew"]		= "Ebraico";
$pgv_lang["lang_name_hungarian"]	= "Ungherese";
$pgv_lang["lang_name_indonesian"]	= "Indonesiano";
$pgv_lang["lang_name_italian"]		= "Italiano";
$pgv_lang["lang_name_lithuanian"]	= "Lituano";
$pgv_lang["lang_name_norwegian"]	= "Norvegese";
$pgv_lang["lang_name_polish"]		= "Polacco";
$pgv_lang["lang_name_portuguese"]	= "Portoghese";
$pgv_lang["lang_name_romanian"]		= "Rumeno";
$pgv_lang["lang_name_russian"]		= "Russo";
$pgv_lang["lang_name_serbian-la"]	= "Serbo (Alfabeto latino)";
$pgv_lang["lang_name_slovak"]		= "Slovacco";
$pgv_lang["lang_name_slovenian"]	= "Sloveno";
$pgv_lang["lang_name_spanish"]		= "Spagnolo";
$pgv_lang["lang_name_spanish-ar"]	= "Spagnolo (America Latina)";
$pgv_lang["lang_name_swedish"]		= "Svedese";
$pgv_lang["lang_name_turkish"]		= "Turco";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamita";
$pgv_lang["lang_name_unknown"]		= "Nessuna di queste lingue";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]		= "Nuova lingua";
$pgv_lang["original_lang_name"]		= "Nome originale della lingua in #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Nome originale della lingua~<br /><br />Come viene chiamata questa lingua in questa lingua?<br /><br />L'inglese si definisce <b>English</b>; Il tedesco si chiama <b>Deutsch</b>; L'olandese si chiama <b>Nederlands</b>; Il ceco si chiama <b>Ceština</b>, ecc.";
$pgv_lang["lang_shortcut"]		= "Abbreviazione di file di lingua";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Questo codice definisce un'abbreviazione per il nome della lingua. Questa abbreviazione fa parte del nome di ciascuno dei file di lingua utilizzati da PhpGedView. Ad esempio, l'abbreviazione utilizzata per il francese è <b>fr</b> e di conseguenza i nomi dei file per il francese lo sono <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, e <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Codici di rilevamento della lingua";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Questi codici consentono a PhpGedView di rilevare l'impostazione della lingua preferita del browser in uso. PhpGedView determina la lingua effettivamente richiesta dal browser confrontando il codice della lingua del browser con questo elenco. Le singole voci dell'elenco devono essere separate da un punto e virgola.";
$pgv_lang["lang_filenames"]		= "File di lingua";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "File di bandiere";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Nome del file immagine della bandiera nazionale per la lingua selezionata.<br /><br />Le immagini per molti paesi sono disponibili dal sito <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>The WWWeb Factory.<br /><br />Quando trovi un'immagine della bandiera che ti piace, fai clic destro su di essa e salva l'immagine in una cartella temporanea. Successivamente, apri l'immagine salvata con un editor di immagini adatto (IrfanView è consigliato per i sistemi Windows), riduci la sua dimensione di 50x32 pixel, che è la dimensione normale utilizzata in PhpGedView, quindi salvalo come file GIF nella <i><b>imagesflags</b></i>. Tu possa usare qualsiasi nome tu voglia.";
$pgv_lang["text_direction"]		= "Direzione del testo";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Identifica la direzione utilizzata per scrivere il testo nella lingua scelta. La maggior parte delle lingue viene scritta da sinistra a destra. L'arabo e l'ebraico sono esempi di lingue scritte nella direzione opposta (da destra a sinistra).";
$pgv_lang["date_format"]			= "Formato data";
$pgv_lang["date_format_help"] = "~#pgv_lang[date_format]#~<br /><br />Questo campo definisce il formato della data che deve essere utilizzato da PhpGedView durante la visualizzazione delle date dal database. Puoi utilizzare il formato <b>Standard</b> o <b>Avanzato</b>.<ul><li><b>Standard</b><br />I seguenti codici vengono utilizzati per rappresentare diversi elementi della data. Tieni presente che <b>D</b> e <b>M</b> hanno significati diversi nel formato <b>Avanzato</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;giorno del mese, senza zeri iniziali; cioè da 1 a 31<br /><b>M</b>&nbsp;&nbsp;nome del mese; cioè gennaio, febbraio, ecc.<br /><b>Y</b>&nbsp;&nbsp;anno intero, ad esempio, 1999 o 44A.C.<br /><b>R</b>&nbsp;&nbsp;Conversione del calendario. Consulta l'argomento <b>Conversione del calendario</b> di seguito per una descrizione di questo codice.</p>Questi codici possono essere combinati in qualsiasi ordine, insieme a spazi e punteggiatura. Ad esempio, supponiamo che il tuo GEDCOM contenga la data 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">Un utente <b>inglese</b> potrebbe impostare il formato su <b>D&nbsp;M&nbsp;Y</b> ottenere <b>20&nbsp;August&nbsp;1965</b>.<br />Un utente <b>americano</b> potrebbe impostare il formato su <b>M&nbsp;D,&nbsp;Y</b> ottenere <b>August&nbsp;20,&nbsp;1965</b><br />Un utente <b>tedesco</b> potrebbe impostare il formato su <b>D.&nbsp;M&nbsp;Y</b> ottenere <b>20.&nbsp;August&nbsp;1965</b><br />Un utente <b>ungherese</b> potrebbe impostare il formato su <b>Y.&nbsp;M&nbsp;D.</b> ottenere <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Avanzato</b><br />Sono disponibili opzioni di formattazione più complesse. Se il formato della data include una lettera diversa da <b>D</b>, <b>M</b>, <b>Y</b>, o <b>R</b>, verrà considerata per utilizzare il formato <b>Avanzato</b>.<br /><br />I seguenti codici vengono utilizzati per rappresentare diversi elementi della data. Tieni presente che <b>D</b> e <b>M</b> hanno significati diversi nel formato <b>Standard</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;giorno del mese, con zeri iniziali; cioè da 01 a 31<br /><b>j</b>&nbsp;&nbsp;giorno del mese, senza zeri iniziali; cioè da 1 a 31<br /><b>S</b>&nbsp;&nbsp;suffisso ordinal per il numero del giorno; ad esempio, in inglese, le lettere <b>th</b> in <b>4th&nbsp;July</b>.<br /><b>l</b> («L» minuscola)&nbsp;&nbsp;giorno della settimana; cioè lunedì, martedì, ecc.<br /><b>D</b>&nbsp;&nbsp;giorno della settimana abbreviato; cioè L, Ma, Me, G, V, S, D<br /><b>N</b>&nbsp;&nbsp;numero del giorno ISO; cioè da 0 a 6<br /><b>w</b>&nbsp;&nbsp;numero del giorno; cioè da 1 a 7<br /><b>z</b>&nbsp;&nbsp;giorno dell'anno; cioè da 1 a 365 o 366<br /><b>F</b>&nbsp;&nbsp;nome del mese; cioè gennaio, febbraio, ecc.<br /><b>M</b>&nbsp;&nbsp;mese abbreviato, ad esempio gen, feb, ecc.<br /><b>m</b>&nbsp;&nbsp;numero del mese, con zeri iniziali; cioè da 01 a 12<br /><b>n</b>&nbsp;&nbsp;numero del mese, senza zeri iniziali; cioè da 1 a 12<br /><b>Y</b>&nbsp;&nbsp;anno intero, ad esempio, 1999 o 44A.C.<br /><b>y</b>&nbsp;&nbsp;anno abbreviato. Alcuni calendari consentono di abbreviare gli anni. Per il calendario giudaico questo è l'anno senza le migliaia. Per il calendario gregoriano questo è lo stesso dell'anno intero.<br /><b>R</b>&nbsp;&nbsp;Conversione del calendario. Consulta l'argomento <b>Conversione del calendario</b> di seguito per una descrizione di questo codice.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;formato GEDCOM interno</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;codice calendario, ad es. @#DGREGORIAN@, @#DHEBREW@, ecc.<br /><b>A</b>&nbsp;&nbsp;giorno, cioè da 01 a 31<br /><b>O</b>&nbsp;&nbsp;mese, ad es. JAN, FEB, MAR, ecc.<br /><b>E</b>&nbsp;&nbsp;anno, ad es. 1776, 1867, 2007, ecc.<br /><br />Per vedere le date non convertite, usa <b>A&nbsp;O&nbsp;E</b> o <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Qualche esempio</b>, utilizzando la data 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = Me&nbsp;8&nbsp;settembre&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;set&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = mercoledì&nbsp;-&nbsp;08&nbsp;-&nbsp;settembre&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] = "<ul><li><b>Conversione del calendario</b><br />Il codice <b>R</b> ha un comportamento piuttosto insolito. Quando questo codice viene visualizzato nel formato della data, la data normale verrà visualizzata una seconda volta, ma in un sistema di calendario diverso. Gli elementi di questa data di calendario alternativa obbediranno alle stesse regole della parte principale della specifica di formato, tranne per il fatto che l'output del codice di formattazione <b>R</b> è racchiuso tra parentesi per distinguerlo dalla data normale. Gli esempi forniti nel calendario <b>Rivoluzionario francese</b> renderanno questo un po 'più chiaro.<br /><br />Il calendario alternativo da utilizzare per il codice <b>R</b> è determinato in base a la lingua della pagina corrente. Quando la lingua della pagina è l'ebraico, verrà utilizzato il calendario <b>Giudaico</b>. Quando la lingua della pagina è l'arabo, verrà utilizzato il calendario <b>Hijri</b>. Per tutte le altre lingue della pagina, viene utilizzato il calendario <b>Rivoluzionario francese</b>.<br /><br />L'azione di questo codice è simile alla scelta del formato del calendario che puoi effettuare nella pagina Configurazione GEDCOM. La differenza tra i due metodi è che il codice <b>R</b>, essendo definito a livello di configurazione della lingua, funziona solo su lingue selezionate ma su tutti i GEDCOM del sito. L'opzione del calendario impostata a livello di configurazione GEDCOM funziona su tutte le lingue ma solo sui GEDCOM per i quali è stata impostata l'opzione.<br /><ul><li>Calendario <b>Rivoluzionario francese</b>&nbsp;&nbsp;&nbsp;Questo calendario è anche chiamato calendario <b>Repubblicano francese</b>.<br /><br />Ad eccezione di un periodo molto breve nel maggio 1871, questo sistema di calendario era in uso solo in Francia e solo tra 22&nbsp;SEP&nbsp;1792 e 31&nbsp;DEC&nbsp;1805.  Di conseguenza, il formato del calendario rivoluzionario francese sarà applicabile solo quando la data rientra in tale intervallo.<br /><br />Due formati di data di esempio, supponendo che la lingua della pagina sia l'inglese, illustreranno l'azione del codice <b>R</b>:<br /><b>Y.m.d&nbsp;R</b> potrebbe produrre <b>1805.04.26&nbsp;(XIII.08.06)</b> o <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> potrebbe produrre <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> o <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Alternative linguistiche</b><br />I testi abbreviati per i codici avanzati <b>D</b> e <b>M</b> sono impostati nel file <i>languages/lang.xx.php</i>, utilizzando istruzioni come<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Questi possono essere modificati utilizzando un file <i>languages/extra.xx.php</i> come descritto in Wiki e testo ReadMe per le regolazioni della lingua, ad esempio:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Localizzazione</b><br />Esistono regole di formattazione speciali per un certo numero di lingue, in particolare la declinazione delle terminazioni di mese in base a come è formulata la data. Queste regole speciali sono implementate nei vari file <i>includes/extras/functions.xx.php</i>.</li></ul>";
$pgv_lang["time_format"]		= "Formato orario";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />Questo campo definisce il formato dell'ora che deve essere utilizzato da PhpGedView.<br /><br />I simboli che puoi utilizzare sono:<br /><b>a</b> - Ante meridiem e Post meridiem minuscole; ad esempio <b>am</b> o <b>pm</b><br /><b>A</b> - Ante meridiem e Post meridiem maiuscole; ad esempio <b>AM</b> o <b>PM</b><br /><b>B</b> - Swatch Internet Time; cioè <b>000</b> a <b>999</b><br /><b>c</b> - Data ISO 8601; per esempio <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - giorno del mese, 2 cifre, zero iniziale; cioè <b>01</b> a <b>31</b><br /><b>D</b> - giorno, testuale, tre lettere; per esempio <b>Lun</b><br /><b>F</b> - mese, testuale, lungo; per esempio <b>gennaio</b><br /><b>g</b> - ora, formato 12 ore, nessuno zero iniziale; cioè <b>1</b> a <b>12</b><br /><b>G</b> - ora, formato 24 ore, nessuno zero iniziale; cioè <b>0</b> a <b>23</b><br /><b>h</b> - ora, formato 12 ore, zero iniziale; cioè <b>01</b> a <b>12</b><br /><b>H</b> - ora, formato 24 ore, zero iniziale; cioè <b>00</b> a <b>23</b><br /><b>i</b> - minuti, zero iniziale; cioè <b>00</b> a <b>59</b><br /><b>I</b> (maiuscola «i») - indicatore dell'ora legale; <b>1</b> se ora legale, <b>0</b> altrimenti.<br /><b>j</b> - giorno del mese, nessuno zero iniziale; cioè <b>1</b> a <b>31</b><br /><b>l</b> (minuscola «L») - giorno della settimana, testuale, lungo; per esempio <b>venerdì</b><br /><b>L</b> - indicatore dell'anno bisestile; <b>1</b> se è un anno bisestile, <b>0</b> altrimenti.<br /><b>m</b> - mese, numerico, zero iniziale; cioè <b>01</b> a <b>12</b><br /><b>M</b> - mese, testuale, 3 lettere; per esempio. <b>gen</b><br /><b>n</b> - mese, numerico, nessuno zero iniziale; cioè <b>1</b> a <b>12</b><br /><b>O</b> (maiuscola «o») - differenza tra l'ora locale e l'ora di Greenwich (GMT) in ore; per esempio <b>+0200</b><br /><b>r</b> - Data formattata RFC 2822; per esempio <b>Gio,&nbsp;21&nbsp;Dic&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - secondi, zero iniziale; cioè <b>00</b> a <b>59</b><br /><b>S</b> - suffisso del giorno del mese, solo in inglese, 2 caratteri; cioè <b>st</b>, <b>nd</b>, <b>rd</b> o <b>th</b>. Funziona bene con <b>j</b><br /><b>t</b> - numero di giorni nel mese dato; cioè <b>28</b> a <b>31</b><br /><b>T</b> - impostazione del fuso orario di questa macchina; per esempio <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - secondi dall'inizio dell'Epoch Unix (Gennaio&nbsp;1&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - giorno della settimana, numerico; cioè <b>0</b> (per domenica) a <b>6</b> (per sabato)<br /><b>W</b> - Numero della settimana ISO 8601 dell'anno, settimane che iniziano il lunedì; per esempio. <b>42</b> (la 42a settimana dell'anno)<br /><b>Y</b> - anno, 4 cifre; per esempio <b>1999</b><br /><b>y</b> - anno, 2 cifre; per esempio <b>99</b><br /><b>z</b> - giorno dell'anno, numerico, senza zeri iniziali; cioè <b>0</b> (1 gennaio) a <b>364</b> (31 dicembre quando non è un anno bisestile) o <b>365</b> (31 dicembre negli anni bisestili)<br /><b>Z</b> - differenza di fuso orario in secondi. L'offset per i fusi orari a ovest di Greenwich è sempre negativo e per quelli a est di Greenwich l'offset è sempre positivo. cioè <b>-43200</b> a <b>43200</b><br /><br />È possibile modificare l'ordine di questi simboli e aggiungere delimitatori al formato.<br />Ad esempio, in tedesco questo campo normalmente contiene <b>H:i:s</b> per produrre un display come <b>09:01:25</b>.<br />L'inglese di solito definisce il formato dell'ora come <b>g:i:sa</b> per produrre un display come <b>9:01:25am</b>.<br /><br />Nel sistema a 24 ore, la mezzanotte è 00:00. Nel sistema di 12 ore, mezzanotte è 12:00am e mezzogiorno è 12:00pm.";
$pgv_lang["week_start"]			= "Giorno di inizio settimana";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Il giorno della settimana che inizia una nuova settimana in questa lingua. La maggior parte delle lingue inizia la settimana di domenica, ma alcune iniziano il lunedì o altri giorni.";
$pgv_lang["name_reverse"]		= "Prima il cognome";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />In alcune lingue, il cognome dovrebbe essere visualizzato per primo invece di quello predefinito per visualizzarlo per ultimo. Abilitando questa opzione verrà visualizzato prima il cognome. Ungherese, cinese e giapponese sono esempi in cui di solito viene fornito per primo il cognome.";
$pgv_lang["ltr"]			= "Da sinistra a destra";
$pgv_lang["rtl"]			= "Da destra a sinistra";
$pgv_lang["file_does_not_exist"]	= "ERRORE! Il file non esiste...";
$pgv_lang["optional_file_not_exist"]	= "Questo file opzionale non esiste.";
$pgv_lang["alphabet_upper"]		= "Alfabeto maiuscolo";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Lettere dell'alfabeto maiuscole in questa lingua. Questo alfabeto viene utilizzato durante l'ordinamento degli elenchi di nomi.";
$pgv_lang["alphabet_lower"]		= "Alfabeto minuscolo";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Lettere dell'alfabeto minuscole in questa lingua. Questo alfabeto viene utilizzato durante l'ordinamento degli elenchi di nomi.";
$pgv_lang["multi_letter_alphabet"]		= "Alfabeto a più lettere";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Combinazioni di più lettere che devono essere trattate come una singola lettera distinta quando si ordinano elenchi di nomi e titoli in questa lingua.<br /><br />Alcune lingue, ad esempio ungherese e slovacco, considerano distinte alcune combinazioni di lettere lettere a sé stanti. L'ordine in cui si specificano queste combinazioni di lettere determina l'ordine in cui vengono inserite nel normale alfabeto durante l'ordinamento. Questo è importante quando più combinazioni di più lettere hanno la stessa prima lettera. Ad eccezione di <b>ch</b>, queste combinazioni di lettere vengono inserite nel normale alfabeto in base alla loro prima lettera. <b>ch</b> viene sempre inserito dopo <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Equivalenti di più lettere";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />In alcune lingue, più lettere vengono spesso trattate come equivalenti a una singola lettera quando si generano elenchi di nomi.<br /><br />Ad esempio, in olandese, i nomi che iniziano con <b>IJ</b> sono elencati insieme ai nomi che iniziano con <b>Y</b>. In norvegese, i nomi che iniziano con <b>Aa</b> sono elencati con <b>&Aring;</b>. In alcune lingue, ci sono lettere che possono essere scritte come uno o due caratteri. Ad esempio, in slovacco, i due caratteri D e \xC5\xBE possono essere scritti come il singolo carattere \xC7\x85. Specificando qui gli equivalenti, puoi consentire ai nomi che iniziano con queste lettere di essere raggruppati nelle singole pagine dell'elenco.<br /><br />Devi specificare un elenco di equivalenti separati da virgole. Per supportare i database che non riconoscono la codifica UTF-8, è necessario specificare gli equivalenti in maiuscolo e minuscolo. Questo esempio dimostra il formato da utilizzare.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Usa le regole del dizionario durante l'ordinamento";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Questa opzione controlla il modo in cui i caratteri con segni diacritici vengono gestiti durante l'ordinamento di elenchi di nomi e titoli.<br /><br />Quando è impostato su <b>#pgv_lang[yes]#</b>, tutti i caratteri con segni diacritici vengono trattati come se non avessero segni. I segni diacritici sono considerati solo quando le due parole considerate sono altrimenti identiche. Quando è impostato su <b>#pgv_lang[no]#</b>, tutte le lettere sono distinte, indipendentemente dalla presenza o dall'assenza di segni diacritici.";
$pgv_lang["collation"]		= "Sequenza di confronto del database";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Se si utilizzano le regole di confronto integrate nel database, questa opzione specifica la sequenza di confronto da utilizzare per questa lingua. È necessario assicurarsi che il database supporti tutte le sequenze di confronto che si desidera utilizzare.<br /><br />L'uso delle regole di confronto del database è controllato nelle impostazioni di configurazione del sito.";
$pgv_lang["lang_config_write_error"]	= "Errore durante la scrittura delle impostazioni della lingua nel file <i>language_settings.php</i>. Verifica le autorizzazioni e riprova.";
$pgv_lang["lang_set_file_read_error"]	= "E R R O R E !!! Impossibile leggere <i>language_settings.php</i>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Questa routine ti consente di aggiungere a PhpGedView una nuova lingua, precedentemente non disponibile e completamente non supportata.<br /><br />Puoi configurare le impostazioni standard della nuova lingua. Questi includono il codice di rilevamento della lingua, la direzione della lingua, l'inizio della settimana per questa lingua, le impostazioni dell'ora, l'alfabeto, ecc.<br /><br />Dopo aver selezionato la lingua e facendo clic sul pulsante <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Ulteriori informazioni sono disponibili nella pagina Configurazione per la lingua.";
$pgv_lang["add_new_lang_button"]	= "Aggiungi nuova lingua";
$pgv_lang["hide_translated"]		= "Nascondi tradotti";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Se impostato su <b>#pgv_lang[yes]#</b> vedrai solo quei messaggi del file della lingua selezionata che non sono stati tradotti. Ciò significa che il nuovo messaggio <u>non</u> appare nel file della lingua di destinazione.<br /><br />Alcuni file di lingua contengono testo inglese per vari messaggi non tradotti. Questa routine non è in grado di identificare questi elementi non tradotti, poiché sono già presenti nel file di destinazione. Il presupposto è: «Se il messaggio è presente nel file di destinazione, deve essere stato tradotto.»";
$pgv_lang["lang_file_write_error"]	= "E R R O R E !!! Impossibile scrivere le modifiche nel file della lingua selezionata. Controlla le autorizzazioni di scrittura su <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "E R R O R E !!! Non è possibile aprire il file <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "Lingue degli utenti";
$pgv_lang["configured_languages"]	= "Lingue utilizzate";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Strumento di migrazione delle informazioni utente";
$pgv_lang["um_proceed"] = "Scegli un'opzione o fai clic sul collegamento sottostante per tornare al menu Amministrazione";
$pgv_lang["um_creating"] = "Creazione";
$pgv_lang["um_sql_index"] = "Questo strumento creerà <i>authenticate.php</i> e diversi file <i>.dat</i> nella directory index.<br /><br />Dopo la creazione riuscita, puoi passare alla modalità Indice con tutti gli utenti attuali e i loro messaggi, preferiti, notizie e layout di MyGedview disponibili.<br /><br />Nota: dopo essere passati alla modalità Indice, dovrai importare nuovamente i tuoi file GEDCOM.";
$pgv_lang["um_file_create_fail1"] = "Creazione di un nuovo file non riuscita, esiste già un file con quel nome:";
$pgv_lang["um_file_create_fail2"] = "Non può creare";
$pgv_lang["um_file_create_fail3"] = "Verifica i diritti di accesso su questa directory.";
$pgv_lang["um_file_create_succ1"] = "Creazione di un nuovo file riuscita:";
$pgv_lang["um_file_not_created"] = "Il file non viene creato.";
$pgv_lang["um_nomsg"] = "Nessun messaggio sembra essere presente nel sistema.";
$pgv_lang["um_nofav"] = "Nessun preferito sembra essere presente nel sistema.";
$pgv_lang["um_nonews"] = "Nessuna notizia sembra essere presente nel sistema.";
$pgv_lang["um_noblocks"] = "Nessun blocco sembra essere presente nel sistema.";
$pgv_lang["um_index_sql"] = "Questo strumento importerà <i>authenticate.php</i> e altri file <i>.dat</i> dalla tua directory index nel tuo database.";
$pgv_lang["um_noaction"] = "Non è richiesta alcuna azione per migrare le informazioni utente alla modalità SQL.<br /><br />Dopo essere passati alla modalità SQL, è necessario riavviare lo <b>#pgv_lang[um_header]#</b> per importare tutti i dati nel database SQL. PhpGedView utilizzerà i file esistenti dalla modalità Index.<br /><br /><u>Non</u> rimuovere <i>authenticate.php</i> e i file <i>.dat</i> dalla directory index durante il passaggio.</b>";
$pgv_lang["um_import"] = "Importare";
$pgv_lang["um_export"] = "Esportare";
$pgv_lang["um_explain"] = "Questo strumento esporterà i dati utente da SQL alla modalità Indice o importerà dati utente da file Indice a tabelle SQL.<br /><br />I dati utente, i preferiti, le definizioni di blocco, i messaggi e le notizie saranno nuovamente disponibili dopo la migrazione.<br /><br /><b>ATTENZIONE</b><br />Non è possibile utilizzare questo strumento per migrare i dati utente tra diverse versioni di PhpGedView. Assicurati che i dati provengano o siano importati nella stessa versione di PhpGedView.<br /><br /><b>IMPORTA</b><br />Se scegli di importare i file di dati utente dalla modalità Indice, tutti i dati utente presenti nelle tabelle del database verranno <u>sovrascritti</u>. Questo strumento <u>non</u> unisce le informazioni. Dopo aver eseguito l'importazione, non è possibile recuperare le vecchie informazioni utilizzando PhpGedView.<br /><br /><b>ESPORTA</b><br />Se si esportano le informazioni utente dal database SQL a File in modalità Index, questo strumento creerà <i>authenticate.php</i> e diversi file <i>.dat</i> nella directory index. Se sono già presenti file con lo stesso nome, verrà chiesto se devono essere sovrascritti. Dopo essere passato alla modalità Index, tutte le informazioni saranno disponibili direttamente.<br /><br /><b>Nota:</b> Dopo essere passato alla modalità Index, dovrai importare nuovamente i tuoi file GEDCOM.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrare gli utenti dalla modalità SQL alla modalità Index~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrare gli utenti dalla modalità Index alla modalità SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importazione di utenti";
$pgv_lang["um_imp_blocks"] = "Importazione di blocchi";
$pgv_lang["um_imp_favorites"] = "Importazione dei preferiti";
$pgv_lang["um_imp_messages"] = "Importazione di messaggi";
$pgv_lang["um_imp_news"] = "Importazione di notizie";
$pgv_lang["um_nousers"] = "File <i>authenticate.php</i> non trovato nella directory index. La migrazione viene annullata.";
$pgv_lang["um_imp_succ"] = "Importazione riuscita";
$pgv_lang["um_imp_fail"] = "Importazione fallita";
$pgv_lang["um_backup"] = "Backup";
$pgv_lang["um_zip_succ"] = "File ZIP creato con successo.";
$pgv_lang["um_zip_dl"] = "Scarica il file di backup ZIP ";
$pgv_lang["um_bu_explain"] = "Questo strumento può eseguire un backup di diversi tipi di dati in PhpGedView.<br /><br />I dati di cui scegli di eseguire il backup verranno raccolti in un file ZIP, che puoi scaricare facendo clic sul collegamento nella parte inferiore del pagina, dopo che il backup è stato eseguito con successo.<br /><br />Il file ZIP rimarrà nella directory Index fino a quando non lo rimuoverai manualmente.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "File di configurazione PhpGedView";
$pgv_lang["um_bu_gedcoms"] = "File GEDCOM";
$pgv_lang["um_bu_gedsets"] = "File di impostazioni, configurazione e privacy di GEDCOM";
$pgv_lang["um_bu_logs"] = "Log di ricerca GEDCOM e file di log PhpGedView";
$pgv_lang["um_bu_usinfo"] = "Definizioni utente, impostazioni di blocco, preferiti, messaggi, notizie";
$pgv_lang["um_bu_media"]	= "File multimediali";
$pgv_lang["um_mk_bu"] = "Fare il backup";
$pgv_lang["um_nofiles"] = "Nessun file trovato per il backup.";
$pgv_lang["um_files_exist"] = "Uno o più file esistono già. Vuoi sovrascriverli?";
$pgv_lang["um_results"]		= "Risultati";
$pgv_lang["preview_faq_item"] = "Visualizza l'anteprima di tutti gli elementi delle domande frequenti";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Questa opzione consente a un utente amministratore di visualizzare la pagina delle domande frequenti senza tutte le opzioni di modifica e i collegamenti.<br /><br />Ad eccezione di un singolo collegamento <b>Modifica</b> sopra il primo elemento delle domande frequenti, l'aspetto delle domande frequenti sarà identica a ciò che vedrebbe un utente normale. Questo speciale collegamento <b>Modifica</b> ripristinerà la piena funzionalità di Modifica nella pagina delle domande frequenti.";
$pgv_lang["restore_faq_edits"] = "Ripristina la funzionalità di modifica delle FAQ";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Questa opzione ripristina la pagina delle FAQ a ciò che un utente amministratore vede normalmente, in modo che i singoli elementi delle FAQ possano essere modificati.";
$pgv_lang["add_faq_item"] = "Aggiungi elemento FAQ";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Questa opzione ti consentirà di aggiungere un elemento alla pagina delle domande frequenti.";
$pgv_lang["edit_faq_item"] = "Modifica elemento FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Questa opzione ti consentirà di modificare un elemento nella pagina delle domande frequenti.";
$pgv_lang["delete_faq_item"] = "Elimina elemento FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Questa opzione ti consente di eliminare un elemento dalla pagina delle domande frequenti";
$pgv_lang["moveup_faq_item"] = "Sposta in alto l'elemento FAQ";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Questa opzione ti consentirà di spostare un elemento verso l'alto nella pagina delle domande frequenti.<br /><br />Ogni volta che utilizzi questa opzione, il numero di posizione delle domande frequenti di questo elemento viene ridotto di uno. Puoi ottenere lo stesso effetto modificando l'elemento in questione e cambiando il campo Posizione FAQ. Quando più di un articolo FAQ ha lo stesso numero di posizione, solo uno di questi elementi sarà visibile.";
$pgv_lang["movedown_faq_item"] = "Sposta in basso l'elemento FAQ";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Questa opzione ti consente di spostare un elemento verso il basso nella pagina delle domande frequenti.<br /><br />Ogni volta che utilizzi questa opzione, il numero di posizione delle domande frequenti di questo elemento aumenta di uno. Puoi ottenere lo stesso effetto modificando l'elemento in questione e cambiando il campo Posizione FAQ. Quando più di un articolo FAQ ha lo stesso numero di posizione, solo uno di questi elementi sarà visibile.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Questo è il titolo o l'oggetto dell'elemento FAQ.<br /><br />Ciò che inserisci qui può essere formattato. Tag HTML come &lt;b&gt; e &lt;br /&gt; sono consentiti, così come le entità HTML come &amp;amp; e &amp;nbsp;. Tag HTML diversi da &lt;br /&gt; probabilmente non sono molto utili nel titolo delle FAQ e dovrebbero essere evitate.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />Il testo della voce FAQ viene inserito qui.<br /><br />Il testo può essere formattato. Tag HTML come &lt;b&gt; e &lt;br /&gt; sono consentiti, così come le entità HTML come &amp;amp; e &amp;nbsp;..<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "Le entità HTML sono un modo molto semplice per aggiungere caratteri speciali ai titoli e al testo delle domande frequenti. È possibile utilizzare nomi simbolici, numeri decimali o numeri esadecimali. Un elenco completo di entità HTML, la loro codifica e la loro rappresentazione dal tuo browser può essere trovato qui:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">Elenchi di entità HTML</a><br /><br />A volte, potresti dover mostrare un carattere tilde&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;o un segno numerico&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;nei tuoi URL o testo.Questi caratteri hanno un significato speciale per il sistema di aiuto di PhpGedView e possono essere inseriti solo nella loro forma esadecimale o decimale. Allo stesso modo, i caratteri&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;e&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;che di solito racchiudono tag HTML devono essere inseriti nei rispettivi esadecimali o decimali form se devono essere trattati come testo normale invece di segnalare un tag HTML.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;risulterà in&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;risulterà in&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;risulterà in&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;o&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;risulterà in&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Esiste un'entità HTML <b>&amp;tilde;</b>, ma questo simbolo non viene interpretato come una tilde quando viene codificato negli URL.";
$pgv_lang["add_faq_pgvLangRefs"] = "È possibile inserire riferimenti a voci nei file di lingua o a valori di variabili globali. Esempi: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;è un riferimento alla variabile della lingua \$pgv_lang[\"add_to_cart\"], e se dovesse apparire in questo campo, sarebbe visualizzato come <b>#pgv_lang[add_to_cart]#</b> quando l'elenco delle domande frequenti è visualizzato nella lingua corrente.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;è un riferimento al nome del fatto \$factarray[\"AFN\"], e se dovesse apparire in questo campo, mostrerebbe come <b>#factarray[AFN]#</b> quando l'elenco delle domande frequenti viene visualizzato nella lingua corrente.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;è un riferimento alla costante PGV_VERSION, uno spazio e un riferimento alla costante PGV_VERSION_RELEASE, e se dovessero apparire in questo campo, verrebbero visualizzati come <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> quando l'elenco delle domande frequenti viene visualizzato nella lingua corrente.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;è un riferimento alla variabile globale \$GEDCOM, che è il nome del file GEDCOM corrente. Se dovesse apparire in questo campo, apparirebbe come <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;è un riferimento alla variabile globale \$GEDCOM_TITLE, che è il titolo del file GEDCOM corrente. Se dovesse apparire in questo campo, apparirebbe come <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Questa funzione è utile quando desideri creare elenchi di domande frequenti diversi per ciascuna lingua supportata dal tuo sito. Dovresti inserire i titoli e le voci dell'elenco delle domande frequenti personalizzate nei file <i>languages / extra.xx.php</i> (<i>xx</i> è il codice per ciascuna lingua), utilizzando il seguente formato:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Questo è un titolo di FAQ di esempio\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Questo è un esempio di testo delle domande frequenti.\";</code>";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Questo campo controlla l'ordine in cui vengono visualizzati gli elementi delle FAQ.<br /><br />Non è necessario inserire i numeri in sequenza. Se lasci dei buchi nello schema di numerazione, puoi inserire altri elementi in un secondo momento. Ad esempio, se si utilizzano i numeri 1, 6, 11, 16, è possibile successivamente inserire elementi con i numeri di sequenza mancanti. I numeri negativi e lo zero sono consentiti e possono essere utilizzati per inserire elementi davanti al primo.<br /><br />Quando più di un elemento FAQ ha lo stesso numero di posizione, solo uno di questi elementi sarà visibile.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Puoi determinare se questa FAQ sarà visibile indipendentemente da GEDCOM o se sarà visibile solo al GEDCOM corrente.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Le FAQ appariranno in tutti gli elenchi di FAQ, indipendentemente da GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;Le FAQ appariranno solo nell'elenco delle FAQ di GEDCOM attualmente attivo.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "Il testo delle notizie GEDCOM consente l'uso di <b>tag HTML</b> e <b>entità HTML</b>. HTML non deve essere utilizzato nei titoli delle notizie.<br /><br />Assicurati di utilizzare sempre entrambi i tag di inizio e di fine. Può essere utile avere una comprensione dell'HTML appropriata per un amministratore del sito web. Questo programma utilizza anche <b>Cascading Style Sheets (CSS)</b>. Per ogni tema viene implementato un CSS diverso. Puoi usare le classi di questi fogli di stile per controllare l'aspetto dei tuoi messaggi.<br /><br />Se hai bisogno di ulteriore aiuto con questo, il sito web di PhpGedView ha alcuni esempi di come usare questi tag nel tuo blocco GEDCOM News.<br /><br />Come per l'elenco delle domande frequenti, i titoli delle notizie e il testo delle notizie di GEDCOM consentono riferimenti incorporati alle variabili \$pgv_lang, \$factarray e \$GLOBALS per fornire completa flessibilità nella creazione di elementi di notizie che sono sensibile alla lingua attualmente attiva.<br /><br />La seguente descrizione, presa dal testo della guida per l'elenco delle domande frequenti, è ugualmente applicabile alle notizie di GEDCOM.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Il tempo massimo consentito per l'esecuzione dell'importazione per l'elaborazione del file GEDCOM.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Risultati trovati";
$pgv_lang["ged_filter_reset"] = "Cancella ricerca";
$pgv_lang["ged_filter_description"] = "Testo della ricerca";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Questa opzione ti consente di cercare il testo associato alle opzioni di configurazione.<br /><br />Mentre digiti le lettere, la ricerca troverà tutte le opzioni di configurazione che contengono quella sequenza di lettere. La ricerca diventa più precisa man mano che digiti più lettere.";

?>
