<?php
/**
 * Norwegian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY eller FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * # $Id: configure_help.no.php 7328 2022-01-12 18:30:53Z canajun2eh $
 *
 * @translator Geir Håkon Eikland
 * @translator Thomas Rindal
 * @package PhpGedView
 * @subpackage Languages
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]			= "~#pgv_lang[google_analytics]#~<br /><br />#pgv_lang[google_analytics]# tjenesten er beskrevet, på engelsk, i dette <a href='https://en.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>Wikipedia artikkelen</a>. Den norske versjonen er lite nyttig.<br /><br />Vær oppmerksom på at hvis du velger å bruke denne tjenesten, får Google rettighetene til alle data de samler inn om besøkende aktivitet på nettstedet ditt.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Velg <b>#pgv_lang[yes]#</b> for å aktivere sporing av aktivitet på nettstedet ditt av #pgv_lang[google_analytics]# tjenesten. Du må abonnere på denne tjenesten før du aktiverer dette alternativet.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]		= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Skriv inn kontonummeret som er tildelt nettstedet ditt da du abonnerte på #pgv_lang[google_analytics]# tjenesten. Dette kontonummeret har formatet <b>UA-xxxxxx-x</b>.";
$pgv_lang["piwik_analytics_help"]			= "~#pgv_lang[piwik_analytics]#~<br /><br />#pgv_lang[piwik_analytics]# åpenkildeprosjektet, opprinnelig kalt «Piwik», er beskrevet, på engelsk, <a href='https://matomo.org/' target='_blank' title='Matomo offisielle nettsted'>her</a>.<br /><br />Matomo er et alternativ til #pgv_lang[google_analytics]# som eliminerer mange av personvernproblemene. Du kan installere Matomo-applikasjonen på din egen webserver eller i ditt eget domene, og dermed sikre at du har full kontroll over aktivitetsdataene som er samlet inn.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]		= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Velg <b>#pgv_lang[yes]#</b> for å aktivere sporing av aktivitet på nettstedet ditt av en #pgv_lang[piwik_analytics]# server. PhpGedView nettstedet ditt må være registrert på en Matomo server.";
$pgv_lang["PGV_PIWIK_URL_help"]				= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Skriv inn URL til en Matomo-server der PhpGedView nettstedet ditt er registrert.";
$pgv_lang["PGV_PIWIK_SITE_help"]			= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Angi nettstednummeret som er tildelt PhpGedView-nettstedet av Matomo-serveren.";
$pgv_lang["clustrmaps_analytics_help"]		= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# er et kombinert hit counter, besøkende tracker og geografisk visualiseringsverktøy.<br /><br />Hver side inneholder et miniatyrbildekart generert av #pgv_lang[clustrmaps_analytics]#. Når bildet lastes inn, økes en teller på #pgv_lang[clustrmaps_analytics]#-nettstedet. Når kartet, som er synlig for alle de besøkende, oppdateres (daglig, ukentlig eller månedlig, avhengig av trafikken), viser det plasseringen til alle besøkende på din siden begynnelsen av et bestemt tidsintervall.<br /><br />Hvis du har betalt for #pgv_lang[clustrmaps_analytics]# tjenesten, viser et større verdenskartvisning ved å klikke på dette miniatyrbildet.<br /><br />Flere detaljer er tilgjengelig på <a href='http://www.clustrmaps.com/' target='_blank' title='#pgv_lang[clustrmaps_analytics]# siden'>#pgv_lang[clustrmaps_analytics]# siden</a> på engelsk.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]	= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Velg <b>#pgv_lang[yes]#</b> for å aktivere sporing av aktivitet på nettstedet ditt av en #pgv_lang[clustrmaps_analytics]# server.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Skriv inn URL adressen til PhpGedView nettstedet. Denne verdien er fylt ut for deg, og du trenger normalt ikke å endre den.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]		= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Skriv inn servernummeret tildelt av #pgv_lang[clustrmaps_analytics]# tjenesten da du aktiverte din kontoen.";

$pgv_lang["SHOW_LIST_PLACES"]	= "Stedsnivåer for å vise i lister";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Dette valget bestemmer hvor mye stedinformasjon som vises i stedkolonnen i lister.<br /><br />Om du setter verdien til <b>9</b> sikrer du at all stedinformasjon vises.  Setter du verdien til <b>0</b> (null) skjuler du all stedinformasjon.  Verdien <b>1</b> vil vise det øverste nåvet, som normalt er landnavn.  Verdien <b>2</b> vil vise de to øverste nivåene.  Det nest øverste nivået, under land, er ofte fylke, delstat, provins osv.";

$pgv_lang["new_gedcom_title"]		= "Slektsbase fra #GEDCOMFILE#";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />Skulle eksisterende mediekoblinger beholdes i databasen når en ny GEDCOM lastes opp. Alternativet <b>#pgv_lang[no]#</b> fjerner eksisterende mediekoblinger fra databasen, mens alternativet <b>#pgv_lang[yes]#</b> beholder dem.<br /><br />Dette alternativet er nyttig når du eksporterer GEDCOM fra PhpGedView til et offline GEDCOM vedlikeholdsprogram som ikke håndterer innebygde mediepekere riktig, og deretter importerer det som endret GEDCOM til PhpGedView. Under slike omstendigheter blir mediepekerne i GEDCOM du eksporterte til redigeringsprogrammet ditt offline ødelagt, og du må koble alle mediefilene dine til riktig person-, familie- og kildepost etter at du har importert på nytt GEDCOM til PhpGedView.<br /><br />Alternativet <b>#pgv_lang[yes]#</b> forteller PhpGedView å beholde eksisterende mediekoblinger, slik at du ikke trenger å lage dem på nytt etter at du har importert det endrede GEDCOM, men dette krever at redigeringsprogrammet for offline alltid produserer de samme identifikasjonsnumrene for person, familie og kilde.<br /><br /><i>Family Tree Maker</i> er en av flere av-line redigeringsprogrammer som <u>ikke</u> håndterer pekere med medieobjekter riktig i GEDCOM. <i>Legacy</i>, blant mange andre, håndterer disse ordentlig.";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Bruk medieviser";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Når dette alternativet er <b>#pgv_lang[yes]#</b>, vil du klikke på bilder for å vise mediesiden. Denne siden viser detaljene i bildet. Hvis du har tilstrekkelige rettigheter, kan du også redigere disse detaljene.<br /><br />Når dette alternativet er <b>#pgv_lang[no]#</b>, vil du klikke på bilder for å gi et bilde i full størrelse i et nytt vindu.";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Bruk mediebrannmur";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Se Wiki for en beskrivelse av hvordan du bruker mediebrannmuren. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Rotmappe for mediebrannmur";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Mappe der den beskyttede mediemappen kan opprettes.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Når dette feltet er tomt, vil mappen <b>#GLOBALS[INDEX_DIRECTORY]#</b> bli brukt.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Beskytt miniatyrbilder av beskyttede bilder";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Når et bilde er i den beskyttede mediemappen, skal miniatyrbildet også beskyttes?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Vis søkemotorens tagline";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />På sidene som er generert for søkemotorer, viser du den siste linjen den bestemte søkemotoren siden oppdaget. Hvis dette alternativet er på, kan det påvirke Google&reg; AdSense mot verktøy for søkemotoroptimalisering.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Dette alternativet vil beholde slektskoblinger i privatiserte poster. Dette betyr at du vil se tomme «#pgv_lang[private]#» bokser på stamtavle og på andre diagrammer med private personer.<br /><br />Denne innstillingen er av som standard. Det anbefales i stedet for å slå dette på for å peke stamtavlepersonen i GEDCOM-konfigurasjonen til en person som ikke er privat.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Vis private forhold";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Hvis du setter denne verdien til <b>#pgv_lang[yes]#</b>, oppdateres GEDCOM-filen automatisk når endringer godtas i databasen. Dette vil holde GEDCOM-filen synkronisert med databasen.<br /><br />Det kan være lurt å slå den til <b>#pgv_lang[no]#</b> for å forbedre hastigheten på programmet og for å spare minne når du godtar endringer.";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synkroniser endringene i GEDCOM-filen";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multisite-søk lar brukerne søke på flere PhpGedView-nettsteder som du har satt opp i administrasjonsområdets administrasjonsområde eller eksternt knyttet til. Dette alternativet styrer om søkefunksjonen på flere nettsteder er tilgjengelig for alle eller bare for autentiserte brukere.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Vis søk på flere nettsteder";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Hvem kan se bilder som ikke er vannmerke?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Hvis mediebrannmuren er aktivert, vil brukerne se vannmerker hvis de ikke har det privilegienivået som er angitt her.";
$pgv_lang["WATERMARK_THUMB"]			= "Legge til vannmerker i miniatyrbilder?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Hvis mediebrannmuren er aktivert, skal miniatyrbilder være vannmerke? Medielistene dine lastes raskere hvis du ikke vannmerker miniatyrbildene.";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Lagre vannmerke-miniatyrbilder på serveren?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Hvis mediebrannmuren er aktivert, skal kopier av vannmerkede miniatyrbilder lagres på serveren i tillegg til de samme miniatyrbildene uten vannmerker?<br /><br />Når den er satt til <b>#pgv_lang[yes]#</b>, vil medielister som inneholder vannmerkede miniatyrbilder produseres raskere på bekostning av høyere krav til serverdiskplass.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Lagre bilder av vannmerke i full størrelse på serveren?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Hvis mediebrannmuren er aktivert, bør kopier av vannmerkede bilder i full størrelse lagres på serveren i tillegg til de samme bildene uten vannmerker?<br /><br />Når den er satt til <b>#pgv_lang[yes]#</b>, vannmerkebilder i full størrelse vil bli produsert raskere på bekostning av høyere serverdiskplassbehov.";
$pgv_lang["DB_UTF8_COLLATION"]			= "Bruk databasen til å gi UTF-8-sortering";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Kontrollerer om PhpGedView skal bruke databasens innebygde sorterings- og sorteringsanlegg. Det er vanligvis raskere å bruke databasen til å sortere og filtrere data i stedet for PHP, selv om ikke alle databaser / versjoner gir denne funksjonen. Sorteringssekvensen som brukes for hvert språk, er angitt på innstillingssiden for språket.<br /><br /><span class=\"warning\">VIKTIG: Du bør bare sette denne verdien til <b>#pgv_lang[yes]#</b> hvis du gjør det FØR databasetabellene blir opprettet for første gang. Hvis du velger det i en eksisterende database, kan dataene dine bli ødelagt.</span><br /><br />MySQL og PostgreSQL tilbyr begge god støtte for UTF-8, selv om ikke alle sorteringssekvenser er tilgjengelige i tidligere versjoner av MySQL. Andre databaser tilbyr liten eller ingen støtte for UTF-8. Hvis du er usikker på databasens støtte for UTF-8, bør du sette denne verdien til <b>#pgv_lang[no]#</b>.<br /><br />Denne <a href='https://no.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia artikkelen'><b>Wikipedia artikkelen</b></a> inneholder omfattende informasjon og lenker om UTF-8.";
$pgv_lang["INDI_FACTS_ADD"] 			= "Legg til fakta til personer";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Dette er en liste over fakta som brukere kan legge til personer. Du kan endre denne listen ved å fjerne eller legge til faktanavn, til og med egendefinerte, etter behov. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unike personen fakta";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Dette er en liste over fakta som brukere bare kan legge til <u>en gang</u> til personer. For eksempel, hvis BIRT er i denne listen, vil ikke brukerne kunne legge til mer enn en BIRT post til en person. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[INDI_FACTS_ADD]#</i> listen.";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Raskt legge til fakta til personer";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Dette er en kort liste over personen fakta som vises ved siden av hele listen og kan legges til med et enkelt klikk.";
$pgv_lang["FAM_FACTS_ADD"] 			= "Legg til fakta til familier";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br /><br />Dette er en liste over fakta som brukere kan legge til familier. Du kan endre denne listen ved å fjerne eller legge til faktanavn, til og med egendefinerte, etter behov. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unike familier fakta";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Dette er en liste over fakta som brukere bare kan legge til <u>en gang</u> til familier. For eksempel, hvis MARR er i denne listen, vil ikke brukerne kunne legge til mer enn en MARR post til en familie. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[FAM_FACTS_ADD]#</i> listen.";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Raskt legge til fakta til familier";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Dette er en kort liste over familier fakta som vises ved siden av hele listen og kan legges til med et enkelt klikk.";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Legg til fakta til kilder";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Dette er en liste over fakta som brukere kan legge til kilder. Du kan endre denne listen ved å fjerne eller legge til faktanavn, til og med egendefinerte, etter behov. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unike kilder fakta";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Dette er en liste over fakta som brukere bare kan legge til <u>en gang</u> til kilder. For eksempel, hvis TITL er i denne listen, vil ikke brukerne kunne legge til mer enn en TITL post til en kilde. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[SOUR_FACTS_ADD]#</i> listen.";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Raskt legge til fakta til kilder";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Dette er en kort liste over kilder fakta som vises ved siden av hele listen og kan legges til med et enkelt klikk.";
$pgv_lang["REPO_FACTS_ADD"] 			= "Legg til fakta til arkiver";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Dette er en liste over fakta som brukere kan legge til arkiver. Du kan endre denne listen ved å fjerne eller legge til faktanavn, til og med egendefinerte, etter behov. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> listen.";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unike arkiver fakta";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Dette er en liste over fakta som brukere bare kan legge til <u>en gang</u> til arkiver. For eksempel, hvis NAME er i denne listen, vil ikke brukerne kunne legge til mer enn en NAME post til en arkiv. Faktanavn som vises i denne listen, må ikke vises i <i>#pgv_lang[REPO_FACTS_ADD]#</i> listen.";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Raskt legge til fakta til arkiver";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Dette er en kort liste over arkiver fakta som vises ved siden av hele listen og kan legges til med et enkelt klikk.";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Du kan endre listen over språk som støttes av PhpGedView-nettstedet ditt ved å legge til eller fjerne avkrysningsmerker etter behov. Dette endrer språkvalget som er tilgjengelig for brukerne dine.<br /><br />Du kan oppnå det samme via <b>#pgv_lang[enable_disable_lang]#</b> lenken på #pgv_lang[admin]# menyen, der du også kan endre ting som språkets flaggikon, datoformat, eller om etternavnet alltid skal skrives ut først.";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Prefiks for medie-ID";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Når en ny medieoppføring legges til online i PhpGedView, genereres en ny ID for det mediet automatisk. ID-en vil ha dette prefikset.";
$pgv_lang["FAM_ID_PREFIX"]		= "Prefiks for familie-ID";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Når en ny familieoppføring legges til online i PhpGedView, genereres en ny ID for den familien automatisk. ID-en vil ha dette prefikset.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fakta for familier som alltid skal vises på hurtigoppdateringsskjemaet";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dette er en kommaseparert liste over fakta som alltid vil vises på Familie-fanene i hurtigoppdateringsskjemaet, enten de allerede finnes i familiens journal. For eksempel, hvis MARR er i listen, vil felt for ekteskapsdato og ekteskapssted alltid vises på skjemaet.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fakta for familier å vise på hurtigoppdateringsskjema";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dette er en kommaseparert liste over fakta som vises i Familie-fanene i hurtigoppdateringsskjemaet. Bare fakta i denne listen vil bli vist på skjemaet eller gjort tilgjengelig for valg i området der du legger til nye fakta på skjemaet.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakta som alltid skal vises på hurtigoppdateringsskjemaet";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dette er en kommaseparert liste over fakta som alltid vil vises på hurtigoppdateringsskjemaet, enten de allerede finnes i personens opptegnelse. For eksempel, hvis BIRT er i listen, vil felt for fødselsdato og fødested alltid vises på skjemaet.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakta å vise på hurtigoppdateringsskjema";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dette er en kommaseparert liste over fakta som vil vises på hurtigoppdateringsskjemaet. Bare fakta i denne listen vil bli vist på skjemaet eller gjort tilgjengelig for valg i området der du legger til nye fakta på skjemaet.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Når du legger til nye medlemmer i en familie, kan PhpGedView levere standardverdier for etternavn i henhold til regional skikk.<br /><br /><ul><li>I <b>farlig</b> tradisjon deler alle familiemedlemmer farens etternavn.</li><li>I <b>spansk</b> og <b>portugisisk</b> tradisjon får barn etternavn fra hver av foreldrene.</li><li>I <b>islandsk</b> tradisjon får barn den mannlige forelderens fornavn som etternavn, med et suffiks som betegner kjønn.</li><li>I <b>polske</b> tradisjon deler alle familiemedlemmer farens etternavn. For noen etternavn indikerer suffikset kjønn. Suffikset <i>ski</i>, <i>cki</i>, og <i>dzki</i> indikerer hann, mens de tilsvarende suffiksen <i>ska</i>, <i>cka</i>, og <i>dzka</i> indikerer kvinne.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dette er en kommaseparert liste over fakta som vil vises på skjemaet for å legge til / redigere navn. Hvis du bruker ikke-latinske alfabeter som hebraisk, gresk, kyrillisk eller arabisk, kan det være lurt å legge til koder som _HEB, ROMN, FONE osv. Slik at du kan lagre navn i flere forskjellige alfabet.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dette er en kommaseparert liste over fakta som vises når du legger til eller redigerer stedsnavn. Hvis du bruker ikke-latinske alfabeter som hebraisk, gresk, kyrillisk eller arabisk, kan det være lurt å legge til koder som _HEB, ROMN, FONE osv. Slik at du kan lagre stedsnavn i flere forskjellige alfabet.";
$pgv_lang["GEONAMES_KEY"]				= "geonames.org brukerid";
$pgv_lang["GEONAMES_KEY_help"]			= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Denne bruker-IDen er påkrevd for å få tilgang til den gratis geonames.org-databasen med geografiske navn. Hvis du ikke oppgir en gyldig bruker-ID, vil du ikke kunne søke i denne databasen.<br /><br />Du kan be om en bruker-ID for geonames.org på <a href='http://www.geonames.org/login' target='_blank'><b>innloggingsside for geonames.org</b></a>.<br /><br />Du vil da motta en e-post med en bekreftelseskobling, og etter at du har bekreftet e-posten, kan du aktivere kontoen din for webservicen på din <a href='http://www.geonames.org/manageaccount' target='_blank'><b>kontosiden</b></a>";
$pgv_lang["GEONAMES_BIAS"]				= "geonames.org landskjevhet";
$pgv_lang["GEONAMES_BIAS_help"]			= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalt presenterer GeoNames databasesøk resultatene i alfabetisk rekkefølge uten hensyn til landet der et sted ligger. Dette alternativet spesifiserer at steder i det valgte landet skal rapporteres øverst i resultatlisten.";
$pgv_lang["GEONAMES_BIAS_no_preference"]= "Ingen preferanse";
$pgv_lang["GEOCODE_KEY"]				= "Google Geocode Server nøkkel";
$pgv_lang["GEOCODE_KEY_help"]			= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Denne nøkkelen er nødvendig for å få tilgang til den gratis Google-databasen med geografiske navn. Hvis du ikke oppgir en gyldig nøkkel, vil du ikke kunne søke i denne databasen.<br /><br />Du kan be om en nøkkel gjennom <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. Du kan se denne siden på et annet språk enn engelsk ved å velge ønsket språk helt nederst på siden.";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatisk genererte miniatyrbilder";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Skulle systemet automatisk generere miniatyrbilder for bilder som ikke har dem. PHP installasjon din støtter kanskje ikke denne funksjonaliteten.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Denne siden gir omfattende informasjon om serveren der PhpGedView vert. Mange konfigurasjonsdetaljer om serverens programvare, når det gjelder PHP og PhpGedView, kan vises.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Denne siden samler alle hovedtemaene i Configuration Help på ett sted. Du kan se informasjonen på skjermen, eller du kan skrive den ut for senere bruk.";
$pgv_lang["more_help_advice"]			= "<b>Mer hjelp</b><br />Mer hjelp er tilgjengelig ved å klikke på <b>#pgv_lang[qm]#</b> ved siden av elementene på siden.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Bredden på genererte miniatyrbilder";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Dette er bredden (i piksler) som programmet vil bruke når det automatisk genererer miniatyrbilder. Standardinnstillingen er 100.";
$pgv_lang["USE_SILHOUETTE"]				= "Bruk silhuetter";
$pgv_lang["USE_SILHOUETTE_help"]		= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Bruk silhuettbilder når det ikke er spesifisert noe uthevet bilde for den personen. Bildene som brukes er spesifikke for kjønnet til vedkommende.<br /><br /><table><tr><td wrap valign=\"middle\">Dette bildet kan brukes når kjønnet til personen er ukjent:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]				= "Vis kilder";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Still inn tilgangsnivået for personvern for alle kilder. Hvis brukeren ikke har tilgang til kilder, fjernes kildelisten fra lister-menyen, og kategorien kilder vises ikke på siden <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Hvis alternativet <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> er aktivert, kontrollerer denne innstillingen om administratoren må godkjenne registreringen.<br /><br />Sett dette til <b>#pgv_lang[yes]#</b> vil kreve at alle nye brukere først bekrefter seg selv og deretter blir godkjent av en administrator før de kan logge inn. Med denne innstillingen på <b>#pgv_lang[no]#</b>, vil boksen <b>#pgv_lang[verified_by_admin]#</b> krysses av automatisk når brukerne bekrefter kontoen deres, og dermed tillater en umiddelbar pålogging etterpå uten admin intervensjon.";
$pgv_lang["SPLIT_PLACES"]		= "Del steder i redigeringsmodus";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Sett dette til <b>#pgv_lang[yes]#</b> for å dele hvert stedsnavn med komma i underfelt for enklere redigering. Eksempel :<br /><ol><li>Standard modus<br /><u>Sted</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Delt modus<br /><u>Land</u>: USA<br /><u>Stat</u>: California<br /><u>Fylke</u>: San Mateo<br /><u>By</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Understreke navn i anførselstegn (\")";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Mange programmer vil plassere det foretrukne fornavnet i anførselstegn (<b>\"</b>) i GEDCOM. Den vanlige konvensjonen for dette er å understreke det foretrukne fornavnet. Hvis du aktiverer dette alternativet, konverteres alle navn omgitt av anførselstegn til &lt;span&gt; med en CSS-klasse \"starredname\".<br /><br />For eksempel hvis navnet i GEDCOM var 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ aktivering av dette alternativet vil endre den delen av navnet som er vedlagt i anførselstegn til &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; for utskriftsformål. Avhengig av andre innstillinger, vil nettleseren da vise det navnet som <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> eller <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Bruk GEDCOM (RESN) personvernbegrensning";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />GEDCOM 5.5.1 spesifikasjonen inkluderer muligheten til å bruke RESN-koder for å angi personvernalternativer for personer og fakta i GEDCOM filen. Hvis du aktiverer dette alternativet, vil programmet be programmet om å se etter nivå 1 RESN koder i GEDCOM-poster. Nivå 2+ RESN koder brukes automatisk og påvirkes ikke av denne innstillingen. Merk at dette kan redusere noen av funksjonene til PhpGedView, for eksempel personlisten.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Vis ordinanskoder for SDH-kirken i kartbokser";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Hvis du setter dette alternativet til <b> #pgv_lang [yes] # </b>, vises statuskoder for SDH ordinanser i kartbokser.<ul><li><b>B</b> - Dåp</li><li><b>E</b> - Begavet</li><li><b>S</b> - Forseglet til ektefelle</li><li><b>P</b> - Forseglet til foreldrene</li></ul>En person som har gjort alle ordinansene, vil ha <b>BESP</b> skrevet ut etter navnet sitt. Manglende ordinanser er angitt med <b>_</b> i stedet for den tilsvarende bokstavkoden. For eksempel angir <b>BE__</b> manglende <b>S</b> og <b>P</b> ordinanser.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standardfanen som skal vises på «Personlige opplysninger» side";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Dette alternativet lar deg velge hvilken fane som åpnes automatisk på siden «Personlige opplysninger» når siden er tilgjengelig.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Vis gifte navn på personlisten";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Dette alternativet viser gifte navn på kvinner på personlisten. Dette alternativet krever at du beregner de gifte navnene når du importerer GEDCOM-filen.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Vis personvernfelt på skjemaet #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Dette alternativet lar deg slå på eller av personvernfeltene i skjemaet #pgv_lang[quick_update_title]#. Personvernfelt lar en bruker som legger til informasjon gjennom skjemaet, overstyre standard personvern for det faktum at de skriver inn.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Bruk skjemaet #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Dette alternativet bestemmer brukerrettighetene som kreves for å sende inn endringer gjennom skjemaet #pgv_lang[quick_update_title]#.<br /><br />Valget <b>#pgv_lang[nobody]#</b> betyr at dette skjemaet ikke kan brukes i det hele tatt.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Arkiver søkeloggfilene";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere søkeloggfilene.";
$pgv_lang["CHANGELOG_CREATE"]		= "Arkiver endringsloggfilene";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere endringsloggfilene.";
$pgv_lang["CHART_BOX_TAGS"]		= "Andre fakta å vise i diagrammer";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Dette bør være en komma- eller mellomromsseparert liste over fakta, i tillegg til fødsel og død, som du vil skal vises i kartbokser som stamtavle. Denne listen krever at du bruker faktakoder som definert i GEDCOM 5.5.1 Standard. Hvis du for eksempel vil at yrke skal vises i boksen, vil du legge til «OCCU» i dette feltet.";
$pgv_lang["FULL_SOURCES"]		= "Bruk full kilde sitater";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Kildesiteringer kan omfatte felt for å registrere datakvaliteten (primær, sekundær osv.) Og datoen da hendelsen ble registrert i kilden. Hvis du ikke bruker disse feltene, kan du deaktivere dem når du oppretter nye kildesitater.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Source type";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />When adding new close relatives, you can add source citations to the records (e.g. INDI, FAM) eller the facts (BIRT, MARR, DEAT).  This option controls which checkboxes are ticked by default.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "Grunnleggend";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["media_general_conf"]	= "Generell";
$pgv_lang["media_firewall_conf"]	= "Mediebrannmur";
$pgv_lang["accpriv_conf"]		= "Tilgang og personvern";
$pgv_lang["displ_conf"]			= "Display, Layout, og Rapporter";
$pgv_lang["displ_names_conf"]	= "Navn";
$pgv_lang["displ_comsurn_conf"] = "Hyppige etternavn";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]	= "Skjul og vis";
$pgv_lang["displ_reports"]		= "Rapporter";
$pgv_lang["editopt_conf"]		= "Redigeringsalternativer";
$pgv_lang["useropt_conf"]		= "Brukeralternativer";
$pgv_lang["contact_conf"]		= "Kontaktinformasjon";
$pgv_lang["meta_conf"]			= "Nettsted og META Tag innstillinger";
$pgv_lang["gedconf_head"]		= "GEDCOM konfigurasjon";
$pgv_lang["other_theme"]		= "Annet, vennligst skriv inn";
$pgv_lang["performing_update"]		= "Utfører oppdatering.";
$pgv_lang["config_file_read"]		= "Konfigurasjonsfil lest.";
$pgv_lang["does_not_exist"]		= "eksisterer ikke";
$pgv_lang["media_drive_letter"]		= "Mediebanen skal ikke inneholde en stasjonsbokstav; media vises kanskje ikke.";
$pgv_lang["db_setup_bad"]		= "Nåværende databasekonfigurasjon er dårlig. Kontroller databasetilkoblingsparameterne og konfigurer igjen.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView klarte ikke å opprette forbindelse til databaseverten. Sjekk verten, brukernavnet og passordet for å sikre at de er riktige.";
$pgv_lang["bad_database_name"]		= "PhpGedView opprettet en forbindelse til databaseverten, men klarte ikke å bruke databasen med navnet du skrev inn. Kontroller at databasen eksisterer, og at brukernavnet du skrev inn, har de riktige tillatelsene for den databasen.";
$pgv_lang["db"]				= "Database";
$pgv_lang["current_gedcoms"]		= "Nåværende GEDCOM";
$pgv_lang["ged_gedcom"]			= "GEDCOM fil";
$pgv_lang["ged_title"]			= "GEDCOM tittel";
$pgv_lang["ged_config"]			= "Konfigurasjonsfil";
$pgv_lang["ged_search"]			= "Søkeloggfilene";
$pgv_lang["ged_change"]			= "Endringsloggfilene";
$pgv_lang["ged_privacy"]		= "Personvernfilen";
$pgv_lang["disabled"]			= "Funksjonshemmet";
$pgv_lang["mouseover"]			= "På musen over";
$pgv_lang["mousedown"]			= "På museknappen nede";
$pgv_lang["click"]			= "Klikk på museknappen";
$pgv_lang["enter_db_pass"]		= "For sikkerhets skyld må du alltid oppgi #pgv_lang[DBUSER]# og #pgv_lang[DBPASS]# når du endrer konfigurasjonsverdier.";
$pgv_lang["server_url_note"]	= "Dette skal være URL-en til mappen PhpGedView. Du bør bare endre denne innstillingen hvis du er sikker på at du vet hva du gjør. PhpGedView har bestemt at denne verdien er <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Databastype";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />Hvilken type database du skal koble til.<br /><br />PhpGedView kan bruke hvilken som helst database som har en PDO-driver tilgjengelig. Du må sørge for at php.ini filen laster både <b>php_pdo</b> biblioteket og den aktuelle driveren for databasen din, f.eks. <b>php_pdo_mysql</b>.<br /><br />De fleste databaser krever brukernavn og passord. Du må også opprette databasen før du installerer PhpGedView. SQLite trenger imidlertid ikke #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, eller #pgv_lang[DBPASS]#, men du må angi en filbane for databasen din i feltet #pgv_lang[DBNAME]#. PhpGedView oppretter SQLite-databasefilen for deg.";
$pgv_lang["DBHOST"]			= "Database vert";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />DNS- eller IP-adressen til computer som er vert for databaseserveren. Denne innstillingen ignoreres hvis du bruker en SQLite-database.";
$pgv_lang["DBPORT"]			= "Database port";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />TCP-porten som skal brukes når du kobler til databaseserveren. La denne innstillingen være tom for å bruke standardporten for din spesifikke type database. Denne innstillingen ignoreres hvis du bruker en SQLite-database.";
$pgv_lang["DBUSER"]			= "Database brukernavn";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />Databasens brukernavn kreves for å logge på databasen. Denne innstillingen ignoreres hvis du bruker en SQLite-database.";
$pgv_lang["DBPASS"]			= "Database passord";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />Databasepassordet for brukeren du skrev inn i feltet #pgv_lang[DBUSER]#. Denne innstillingen ignoreres hvis du bruker en SQLite-database.";
$pgv_lang["DBNAME"]			= "Database navn";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />Databasen i serveren du vil at PhpGedView skal bruke.<br /><br />Brukernavnet du skriver inn i feltet #pgv_lang[DBUSER]#, må ha rettigheter Opprett, Sett inn, Oppdater, Slett og Velg i denne databasen. I SQLite må du sette dette til et filnavn i en mappe som kan skrives av PHP, for eksempel index mappen (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Et prefiks til navnene på tabellene opprettet av PhpGedView. Ved å endre denne verdien kan du sette opp flere PhpGedView-nettsteder for å bruke samme fysiske database, men forskjellige tabeller. For eksempel kan det samme nettstedet være vert for en «test» samt en «produksjons» installasjon av PhpGedView med helt uavhengige datatabeller.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Hvis du har et miljø med flere GEDCOMer, kan du ved å sette denne verdien til <b>#pgv_lang[yes]#</b> få besøkende <u>og</u> brukere til å endre muligheten til å endre GEDCOM-er. Hvis du setter den til <b>#pgv_lang[no]#</b>, deaktiveres GEDCOM bytte for både besøkende <u>og</u> påloggede brukere.";
$pgv_lang["upload_path"]			= "Last opp sti";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Dette er banen der GEDCOM filen du vil laste opp, kan bli funnet. For å velge banen, klikk på <b>Bla gjennom</b> og naviger til GEDCOM filen din, og klikk deretter <b>Åpne</b>.";
$pgv_lang["gedcom_path"]			= "Sti og navn til GEDCOM på serveren";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Det er to måter å importere GEDCOM filen til PhpGedView. De er:<ol><li>Bruk et FTP-program for å laste opp filen til serveren</li><li>Last opp i PhpGedView</li></ol>Når filen allerede finnes på serveren, aktiverer du <i>#pgv_lang[add_gedcom]#</i> prosedyren og fyller ut stien og navnet på GEDCOM-filen slik de finnes på serveren. Navnet kan være med eller uten utvidelse. Hvis ingen utvidelse er gitt, vil .ged antas. Stien er valgfri. Hvis ingen bane er gitt, vil verdien av alternativet <i>#pgv_lang[INDEX_DIRECTORY]#</i>, som angitt i PhpGedView-nettstedskonfigurasjonen, bli brukt. Vær oppmerksom på at på de fleste servere er navn på filer og stier store og små bokstaver.<br /><br />Når du bruker <i>#pgv_lang[upload_gedcom]#</i> prosedyren innebygd i PhpGedView, kan du bruke <b>Bla gjennom</b> knappen for å finne ønsket fil på den lokale datamaskinen. Dette kan være en vanlig GEDCOM fil eller en ZIP fil som inneholder GEDCOM-filen. PhpGedView vil automatisk trekke ut og deretter bruke GEDCOM filen i ZIP filen.<br /><br />Når du laster opp en fil, er det mulig å spesifisere en alternativ bane og / eller filnavn for å lagre den under på serveren.<br /><br />Se <a href=\"readme.txt\">Readme.txt</a> filen for mer informasjon.";
$pgv_lang["CHARACTER_SET"]		= "Tegnsettkoding";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dette er tegnsettet til GEDCOM-filen. UTF-8 er standard og skal fungere for nesten alle nettsteder. Hvis du eksporterer GEDCOM ved hjelp av IBM Windows-koding, bør du sette WINDOWS her.<br /><br />MERK: PhpGedView kan ikke støtte UNICODE (UTF-16) fordi støtten mangler i PHP.";
$pgv_lang["LANGUAGE"]			= "Språk";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Tilordne standardspråket for nettstedet.<br /><br />Når alternativet <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> er angitt, kan brukere overstyre denne innstillingen gjennom nettleserens foretrukne språkkonfigurasjon, konfigurasjonsalternativer på deres kontoside, eller gjennom lenker eller knapper på de fleste PhpGedView sider.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "La brukeren endre språk";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Sett til <b>#pgv_lang[yes]#</b> for å tillate brukere å overstyre nettstedets standardspråk. De kan gjøre dette gjennom nettleserens foretrukne språkkonfigurasjon, konfigurasjonsalternativer på kontosiden eller via lenker eller knapper på de fleste PhpGedView-sider.";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Datoer kan registreres i forskjellige kalendere som gregoriansk, julian eller den jødiske kalenderen. Dette alternativet lar deg konvertere datoer til en foretrukket kalender. For eksempel kan du velge gregoriansk for å konvertere julianske og hebraiske datoer til gregorianske. Den konverterte datoen vises i parentes etter den vanlige datoen.<br /><br />Datoer konverteres bare hvis de er gyldige for kalenderen. For eksempel er det bare datoer mellom 22&nbsp;SEP&nbsp;1792 og 31&nbsp;DEC&nbsp;1805 som blir konvertert til den franske republikanske kalenderen, og bare datoer etter 15&nbsp;OCT&nbsp;1582 blir konvertert til den gregorianske kalenderen.<br /><br />Hebraisk er det samme som jødisk, men bruker hebraiske tegn. Arabisk er det samme som Hijri, men bruker arabiske tegn.<br /><br />Merk: Siden den jødiske og Hijri-kalenderdagen begynner i skumringen, vil enhver hendelse som foregår fra skumring til midnatt vises som en dag før den korrekte Dato. Visningen av hebraisk og arabisk kan være problematisk i gamle nettlesere, som kan vise tekst bakover (fra venstre til høyre) eller ikke i det hele tatt.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Vis hebraiske tusenvis";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Vis Alafim på hebraiske kalendere.<br /><br />Hvis du setter dette til <b>#pgv_lang[yes]#</b>, vises året 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mens du setter den til <b>#pgv_lang[no]#</b>, vises året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Dette har ingen innvirkning på den jødiske årssettingen. Året vil vises som 5729 uavhengig av denne innstillingen.<br /><br />Merk: Denne innstillingen ligner kalenderkonstanten CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Vis hebraisk gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Vis enkle og doble anførselstegn («'» og «\"») når du viser hebraiske datoer.<br /><br />Hvis du setter dette til <b>#pgv_lang[yes]#</b>, vises 8. februar 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mens du setter den til <b>#pgv_lang[no]#</b>, vises den som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Dette har ingen innvirkning på innstillingen for jødisk år siden anførselstegn ikke brukes i jødiske datoer som vises med latinske tegn.<br /><br />Merk: Denne innstillingen ligner på kalenderkonstantene CAL_JEWISH_ADD_ALAFIM_GERESH og CAL_JEWISH_ADD_GERESHAYIM. Denne enkeltinnstillingen påvirker begge deler.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jødisk ashkenaz uttale";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Når det er satt til <b>#pgv_lang[yes]#</b>, blir månedene Cheshvan og Teves stavet med ashkenaz uttale. Hvis du setter den til <b>#pgv_lang[no]#</b>, endres månedene til Hesvan og Tevet. Dette påvirker bare den jødiske innstillingen. Den hebraiske innstillingen vil alltid bruke det hebraiske alfabetet.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Antall stamtavle generasjoner";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Angi standard antall generasjoner som skal vises på etterkommere og stamtavle.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maksimalt antall stamtavlegenerasjoner";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Angi maksimalt antall generasjoner som skal vises på stamtavle.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maksimalt antall etterkommere";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Angi maksimalt antall generasjoner som skal vises på etterkommerkart.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Normal bredde på SOSA-tall";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Hvor mye plass som skal reserveres for SOSA-tall på diagrammer<br /><br /><b>#pgv_lang[variable]#</b> indikerer at bredden ikke er fast, og det trykte SOSA-nummeret vil ta like mye plass som den trenger. Resten av diagrammet vil bli plassert tilsvarende.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Ekstra bredde på SOSA-tall";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Hvor mye plass som skal reserveres for SOSA-numre i heftevisningen i avstamningstabellen<br /><br /><b>#pgv_lang[variable]#</b> indikerer at bredden ikke er fast, og det trykte SOSA-nummeret vil ta like mye plass som den trenger. Resten av diagrammet vil bli plassert tilsvarende.";
$pgv_lang["USE_RIN"]			= "Bruk RIN-nummer i stedet for GEDCOM ID";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Sett til <b>#pgv_lang[yes]#</b> for å bruke RIN nummeret i stedet for GEDCOM IDer når du blir bedt om person IDer i konfigurasjonsfiler, brukerinnstillinger og diagrammer. Dette er nyttig for slektsprogrammer som ikke konsekvent eksporterer GEDCOM med samme ID som er tildelt hver person, men alltid bruker samme RIN.";
$pgv_lang["GENERATE_GUID"]		= "Lag automatisk globale unike IDer";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> er i denne sammenhengen et akronym for «Globalt Unik ID».<br /><br />GUIDer er ment å hjelpe til med å identifisere hver person på en måte som kan repeteres, slik at sentrale organisasjoner som Familiehistorisk senter for SDH-kirken i Salt Lake City, eller til og med kompatible programmer som kjører på din egen server, kan avgjøre om de har å gjøre med den samme personen uansett hvor GEDCOM kommer fra. Målet med Family History Center er å ha et sentralt arkiv med slektsdata og eksponere det gjennom nettjenester. Dette vil gjøre det mulig for ethvert program å få tilgang til dataene og oppdatere dataene i dem.<br /><br />Hvis du ikke har tenkt å dele denne GEDCOM med noen andre, trenger du ikke la PhpGedView lage disse GUIDene; Det vil imidlertid ikke skade noe annet enn å øke størrelsen på GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Standard person for stamtavle og etterkommere";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Angi IDen til standardpersonen som skal vises på stamtavle og etterkommere.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Prefiks til person ID";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Når en ny person post legges til online i PhpGedView, genereres en ny ID for den personen automatisk. IDen vil ha dette prefikset.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Prefiks til kilde ID";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Når en ny kilde post legges til online i PhpGedView, genereres en ny ID for den kilden automatisk. IDen vil ha dette prefikset.";
$pgv_lang["REPO_ID_PREFIX"]		= "Prefiks til arkiv ID";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Når en ny arkiv post legges til online i PhpGedView, genereres en ny ID for det depotet automatisk. IDen vil ha dette prefikset.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Vis fødsels- og dødsinformasjon på diagrammer";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Dette alternativet styrer om en persons fødsels- og dødsdetaljer skal vises i diagrammer eller ikke.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Vis kjønnikon på diagrammer";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Dette alternativet styrer om personens kjønnikon skal vises i diagrammer eller ikke.<br /><br />Siden kjønnet også er indikert av fargen på ruten, skjuler ikke dette alternativet kjønnet. Alternativet fjerner ganske enkelt noe duplikatinformasjon fra boksen.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standard stamtavleoppsett";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Dette alternativet indikerer om stamtavlen skal genereres i liggende eller stående modus.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Vis tomme bokser på stamtavle";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Dette alternativet styrer om tomme bokser skal vises på stamtavle eller ikke.";
$pgv_lang["ZOOM_BOXES"]			= "Zoom boksene på kartene";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Tillater en bruker å zoome ruter på diagrammer for å få mer informasjon.<br /><br />Sett til <b>#pgv_lang[disabled]#</b> for å deaktivere denne funksjonen. Sett til <b>#pgv_lang[mouseover]#</b> for å zoome i boksene når brukeren muser over ikonet i boksen. Sett til <b>#pgv_lang[click]#</b> for å zoome i boksene når brukeren klikker på ikonet i boksen.";
$pgv_lang["LINK_ICONS"]			= "Vis lenke-menyen på diagrammer";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Lar brukeren velge lenker til andre diagrammer og nære slektninger til personen.<br /><br />Sett til <b>#pgv_lang[disabled]#</b> for å deaktivere denne funksjonen. Sett til <b>#pgv_lang[mouseover]#</b> for å vise koblingene når brukeren muser over ikonet i boksen. Sett til <b>#pgv_lang[click]#</b> for å vise koblingene når brukeren klikker på ikonet i boksen.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Forkort kartetiketter";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Dette alternativet styrer om forkortelser som <b>Fødsel</b> på diagrammer skal forkortes med bare den første bokstaven som <b>F</b>.<br /><br />Du kan tilpasse forkortelsene ved å oppgi overordnede verdier i <i>languages/extra.xx.php</i> filen for hvert språk. For eksempel, hvis du vil bruke <b>*</b> i stedet for <b>N</b> for å forkorte BIRT fakta på fransk, bør du legge inn følgende oppføring i <i>languages/extra.fr.php</i> fil:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Lengden på forkortelser som er angitt på denne måten, er ikke begrenset til 1 tegn.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Vis datoforskjeller";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Dette alternativet styrer om nære slektninger-fanen skal vise forskjeller mellom ektefellens fødselsdato, mellom ekteskapsdato og fødselsdato for første barn og mellom fødselsdatoer for barn.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Vis foreldrenes alder ved siden av barnets fødselsdato";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Dette alternativet styrer hvorvidt alderen til far og mor skal vises ved siden av barnets fødselsdato i diagrammer.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Vis hendelser til nære slektninger på «Personlige opplysninger» siden";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Fødsler, ekteskap og død av slektninger er viktige hendelser i ens liv. Dette alternativet kontrollerer om disse hendelsene skal vises på «Personlige fakta og opplysninger» fanen på «Personlige opplysninger» siden.<br /><br />Hendelsene som påvirkes av dette alternativet er:<ul><li>Ektefellens død</li><li>Fødsel og død av barn</li><li>Foreldrenes død</li><li>Søskens fødsel og død</li><li>Besteforeldres død</li><li>Fødsel og død av foreldrenes søsken</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Utvid automatisk listen over hendelser til nære slektninger";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Dette alternativet styrer om <i>Hendelser til nære slektninger</i> automatisk skal utvides eller ikke.";
$pgv_lang["EXPAND_SOURCES"]      = "Utvid kilder automatisk";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Dette alternativet styrer om innholdet i en <i>SOUR</i> post automatisk skal vises på <i>#pgv_lang[personal_details]#</i> siden.";
$pgv_lang["EXPAND_NOTES"]      = "Utvid notater automatisk";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Dette alternativet styrer om innholdet i en <i>NOTE</i> post automatisk skal vises på <i>#pgv_lang[personal_details]#</i> siden eller ikke.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Vis alle referanser til notater og kilder i fanene Notater og Kilder";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Dette alternativet styrer om referanser til notater og kilder som er knyttet til fakta skal vises på fanene Notater og kilder på siden <i>#pgv_lang[personal_details]#</i>.<br /><br />Vanligvis viser fanene Notater og Kilder bare referanser til notater og kilder som er vedlagt direkte til personens databasepost. Dette er <i>nivå 1</i> Notater og kildereferanser.<br /><br />Alternativet <b>#pgv_lang[yes]#</b> fører til at disse fanene også viser notater og kildereferanser som er en del av de forskjellige fakta i personens databaseoppføring. Dette er <i>nivå 2</i> referanser fordi de forskjellige fakta er på nivå 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Aktiver personvern";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Dette alternativet vil aktivere alle personverninnstillinger og skjule detaljene til levende mennesker.<br /><br />Levende mennesker er definert som de som ikke har en hendelse som er nyere enn antall år som er angitt <b>#pgv_lang[MAX_ALIVE_AGE]#</b> innstilling, som for øyeblikket er <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. For dette formålet anses fødsler av barn også å være slike hendelser.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Krev godkjenning av besøkende";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Aktivering av dette alternativet vil tvinge alle besøkende til å logge på før de kan se data på nettstedet.";
$pgv_lang["PAGE_AFTER_LOGIN"]		= "Side for visning etter pålogging";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Hvilken side skal brukerne se etter at de har logget på?<br /><br /> Valget som gjøres her, avgjør om en vellykket pålogging får velkomst- eller MyGedView siden til å vises når påloggingen er gjort fra #pgv_lang[welcome_page]#.<br /><br />En pålogging gjort fra lenken øverst på annenhver side vil returnere brukeren til den siden.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Velkomsttekst på påloggingssiden";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Her kan du velge tekst som skal vises på påloggingsskjermen. Du må bestemme hvilken forhåndsdefinert tekst som er mest hensiktsmessig.<br /><br />Du kan også velge å legge inn din egen tilpassede velkomsttekst, men teksten du skriver inn, blir ikke oversatt når brukerne bytter språk. Imidlertid, hvis den tilpassede teksten din inneholder referanser til språkvariabler som du kan definere i de forskjellige <i>languages/extra.xx.php</i> filene, kan nettstedet ditt vise oversatt tekst. Se hjelpeteksten knyttet til <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> feltet for mer informasjon.<br /><br />De forhåndsdefinerte tekstene er:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Ingen forhåndsdefinert tekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Forhåndsdefinert tekst som sier at alle brukere kan be om en brukerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Forhåndsdefinert tekst som angir at admin vil avgjøre hver forespørsel om en brukerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Forhåndsdefinert tekst som bare sier at familiemedlemmer kan be om en brukerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Velg brukerdefinert velkomsttekst skrevet nedenfor";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Egendefinert velkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Hvis du har valgt tilpasset velkomsttekst, kan du skrive den teksten her. Teksten blir IKKE oversatt til språket til den besøkende, men vises nøyaktig slik du skrev den. Men hvis den tilpassede teksten din inneholder referanser til språkvariabler som du kan definere i de forskjellige <i>languages/extra.xx.php</i> filene, kan nettstedet ditt vise oversatt tekst.<br /><br />Du kan sette inn HTML koder i din tilpassede velkomsttekst.<br /><br />Følgende beskrivelse, hentet fra hjelpeteksten for FAQ listen, er like anvendelig for den tilpassede velkomstteksten.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standard overskrift for tilpasset velkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Velg å vise en standard overskrift for din tilpassede velkomsttekst. Når brukerne dine bytter språk, vises denne overskriften på det nye språket.<br /><br />Hvis den er angitt til <b>#pgv_lang[yes]#</b>, vil overskriften se slik ut:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Vis akseptabel bruksavtale på «Be om ny brukerkonto» siden";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Når den er satt til <b>#pgv_lang[yes]#</b>, vises følgende melding over inntastingsfeltene på <i>#pgv_lang[requestaccount]#</i> siden:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Sjekk barns datoer";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Sjekk barns datoer når du bestemmer om en person er død. På eldre systemer og store GEDCOM-er kan dette redusere responstiden på nettstedet ditt.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Alder å anta at en person er død";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Hvis denne personen har noen andre hendelser enn død, begravelse eller kremasjon nylig enn dette antall år, anses han å være «levend». Barnas fødselsdatoer anses å være slike hendelser for dette formålet.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Tillat brukere å se rå GEDCOM-poster";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Hvis du setter dette til <b>#pgv_lang[yes]#</b>, plasseres lenker på personer, kilder og familier for å la brukerne hente frem et nytt vindu som inneholder rådataene tatt rett ut av GEDCOM-filen.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Aktiver redigering på nettet";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Dette alternativet aktiverer online redigeringsfunksjoner for denne databasen, slik at brukere med redigeringsrettigheter kan oppdatere data online.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "Aktiver Autofullføring";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Dette alternativet avgjør om Autofullføring skal være aktiv mens informasjon legges inn i bestemte felt på inndatasskjemaer. Når dette alternativet er satt til <b>#pgv_lang[yes]#</b>, angis tekstinntastingsfelt som Autofullføring er mulig med en annen farget bakgrunn.<br /><br />Når Autofullføring er aktiv, er PhpGedView vil søke i databasen etter mulige treff i henhold til det du allerede har angitt. Når du skriver inn mer informasjon, blir listen over mulige treff raffinert. Når du ser ønsket inngang i listen over treff, kan du flytte musepekeren til den linjen i listen og deretter klikke venstre museknapp for å fullføre inngangen.<br /><br />Ulempene med Autofullføring er at det bremser programmet, medfører betydelig databaseaktivitet, og resulterer også i at flere data blir sendt til nettleseren.";
$pgv_lang["USE_REFN"]		= "Bruk Referensenummer";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Dette alternativet avgjør om #factarray[REFN]# angitt i detaljene til en <u>ny</u> person skal brukes som ID-nummer for den nye personen.<br /><br />Når dette alternativet er satt til <b>#pgv_lang[yes]#</b>, må #factarray[REFN]# angitt følge reglene som er etablert for alle ID-nummer, og en person med ID-en må ikke allerede eksistere i database. Hvis disse vilkårene ikke er oppfylt, eller når dette alternativet er satt til <b>#pgv_lang[no]#</b>, tilordner PhpGedView automatisk neste tilgjengelige ID-nummer til den nye personen.<br /><br />Gyldige ID-nummer kan bare inneholde bokstavene <b>A</b> til <b>Z</b>, <b>a</b> til <b>z</b>, sifre <b>0</b> til <b>9</b>, og spesielle symboler <b>. : -</b> og <b>_</b><br /><br />Du må også aktivere visning av #factarray[REFN]# ved å legge til oppføringen <b>REFN</b> i konfigurasjonsalternativene <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> og <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> nedenfor.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Lukk redigeringsvinduet automatisk";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Dette alternativet kontrollerer om du vil lukke Rediger-vinduet automatisk etter en vellykket oppdatering.";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Stien til en lesbar og skrivbar mappe der PhpGedView skal lagre indeksfiler (inkluderer etterfølgende «/»). PhpGedView krever ikke at denne mappens navn skal være «index». Du kan velge hvilket som helst navn du liker.<br /><br />For sikkerhets skyld bør denne mappen plasseres et sted i serverens filplass som ikke er tilgjengelig fra Internett. Et eksempel på en slik struktur følger:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />For eksemplet som vises, skriver du inn <b>../../dir4/dir5/dir6/index/</b> i dette feltet.";
$pgv_lang["POSTAL_CODE"]  = "Postnummer posisjon";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Ulike land bruker forskjellige måter å skrive adressen på. Dette alternativet gjør at du kan plassere postnummeret enten før eller etter bynavnet.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maksimalt antall etternavn";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange lister over personer med samme etternavn kan deles inn i mindre underlister i henhold til første bokstav i personens fornavn.<br /><br />Dette alternativet bestemmer når underoppføring av etternavn skal forekomme. For å deaktivere underoppføring helt, sett dette alternativet til null.";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maksimalt antall etternavn";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange lister over familier med samme navn kan deles inn i mindre underlister i henhold til den første bokstaven i det gitte navnet.<br /><br />Dette alternativet avgjør når underoppføring av familienavn skal forekomme. For å deaktivere underoppføring helt, sett dette alternativet til null.";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Etternavn liste stil";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Lister over etternavn, slik de vises i #pgv_lang[block_top10]# block, #pgv_lang[individual_list]#, og #pgv_lang[family_list]#, kan vises i forskjellige stiler.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;I denne stilen vises etternavnene i en tabell som kan sorteres etter etternavn eller antall.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;I denne stilen vises etternavnene i en liste, og skriftstørrelsen som brukes for hvert navn, avhenger av antall forekomster av det navnet i databasen. Listen kan ikke sorteres.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Dette alternativet styrer om ID-nummer i parentes skal vises etter navn i diagrammer og lister.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Vis siste endringsdato på lister";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Dette alternativet styrer om den siste endringsdatoen skal vises på lister eller ikke.";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Vis estimerte datoer for fødsel og død";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Dette alternativet kontrollerer om estimerte datoer for fødsel og død skal vises eller ikke i stedet for å legge igjen blanke på personlister og diagrammer for personer hvis datoer ikke er kjent.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Antall stedsnivåer som skal vises i personbokser";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Dette angir hvor mye av stedsinformasjonen som vises i personboksene på diagrammer.<br /><br />Hvis du setter verdien til 9, vil alle stednivåer garanteres. Hvis du setter verdien til 0, skjules steder helt. Hvis du setter verdien til 1, vises det første nivået, og hvis du setter den til 2, vises de to første nivåene osv.";
$pgv_lang["pageSizeDefault"]			= "Standard sidestørrelse";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Dette er standard sidestørrelse for alle rapporter. Valget ditt kan overstyres i de enkelte rapportene.";
$pgv_lang["pageSizeOptions"]			= "Sidestørrelser";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Dette er listen over sidestørrelser som for øyeblikket støttes av PhpGedView når du genererer rapporter. Du kan utvide denne listen ved å legge til andre standard sidestørrelser som oppført i <a href='https://nn.wikipedia.org/wiki/Papirstorleik' title='Wikipedia Artikkel' target='_blank'><b>Wikipedia Artikkel</b></a><br /><ul><li>Standard sidestørrelse for det meste av verden er <b>A4</b>, som tilsvarer 210 x 297 mm (8,3 x 11,7 tom.)</li><li>Den nordamerikanske standard sidestørrelsen er <b>letter</b>, som tilsvarer 216 x 279 mm (8,5 x 11,0 tom.)</li><li>Andre tilgjengelige størrelser er <b>A3</b>, som tilsvarer 297 x 420 mm (11,7 x 16,5 tom.)</li><li>og <b>legal</b>, som tilsvarer 216 x 356 mm (8,5 x 14,0 tom.)</li></ul><br />Det må utvises forsiktighet når du legger til andre papirstørrelser enn de i ISO «A» listen; ikke alle ISO-standardstørrelser er testet.";
$pgv_lang["fontsDefault"]				= "Standard skrift";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Dette er standard skrift for alle rapporter. Valget ditt kan overstyres i de enkelte rapportene.";
$pgv_lang["fontsOptions"]				= "Skrifttyper";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Dette er listen over skrift som for øyeblikket støttes av PhpGedView når du genererer rapporter.<br /><br />Du kan utvide denne listen eller forkorte den etter behov. Forsiktighet anbefales når du utvider denne listen; ikke alle skriftene som finnes i <i>includes/tcpdf/fonts</i> biblioteket, er testet.";
$pgv_lang["MULTI_MEDIA"]		= "Aktiver multimediafunksjoner";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 lar deg koble bilder, videoer og andre multimediaobjekter til GEDCOM. Hvis du ikke inkluderer multimediaobjekter i GEDCOM, kan du deaktivere multimediafunksjonene ved å sette denne verdien til <b>#pgv_lang[no]#</b>.<br /><br />Se Multimedia-delen i <a href=\"readme.txt\">readme.txt</a> fil for mer informasjon om å inkludere media på nettstedet ditt.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Behold lenker";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Når en multimedia-kobling blir funnet som starter med for eksempel http://, ftp://, mms:// vil den ikke bli endret når den er satt til <b>#pgv_lang[yes]#</b>. For eksempel vil http://www.myfamily.com/photo/dad.jpg forbli http://www.myfamily.com/photo/dad.jpg. Når den er satt til <b>#pgv_lang[no]#</b>, vil lenken håndteres som en standard referanse og mediedybden vil bli brukt. For eksempel: http://www.myfamily.com/photo/dad.jpg vil bli endret til ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Multimedia mappe";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Stien til en lesbar og skrivbar mappe der PhpGedView skal lagre mediefiler (inkluderer etterfølgende «/»). PhpGedView krever ikke at denne mappens navn skal være «media». Du kan velge hvilket som helst navn du liker.<br /><br />Selv om mediebrannmurfunksjonen lar deg lagre mediefiler i et område på serverens filplass som ikke er tilgjengelig fra Internett, må mappen som er nevnt her fortsatt eksistere og må kunne leses fra Internett og skrives av PhpGedView. For mer informasjon, se konfigurasjonsalternativene for mediebrannmur i delen Multimedia på GEDCOM-konfigurasjonssiden.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Multimediemappnivåer å beholde";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />En verdi på 0 vil ignorere alle kataloger i filbanen for medieobjektet. Verdien 1 beholder den første mappen som inneholder dette bildet. Å øke tallene øker antall foreldrekataloger som skal beholdes i banen.<br /><br />For eksempel hvis du kobler et bilde i GEDCOM med en bane som <b>C:\\Documents&nbsp;og&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, en verdi på 0 vil oversette denne banen til <b>./media/grandpa.jpg</b>. Verdien 1 vil oversette dette til <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc. De fleste trenger bare å bruke en 0. Det er imidlertid mulig at noen medieobjekter holdes i forskjellige kataloger har identiske navn og vil overskrive hverandre når dette alternativet er satt til 0. Innstillinger som ikke er null, lar deg beholde noen organisasjoner i media og dermed forhindre navnekollisjoner.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Hvis du har aktivert multimedia på nettstedet ditt, kan du få PhpGedView til å vise et miniatyrbilde ved siden av personens navn i diagrammer og bokser.<br /><br />Se delen Multimedia i <a href=\"readme.txt\">readme.txt</a> fil for mer informasjon om hvordan du inkluderer media på nettstedet ditt.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Bruk miniatyrbilde";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Dette alternativet avgjør om PhpGedView skal sende det store eller det lille bildet til nettleseren når et diagram eller siden <i>#pgv_lang[personal_details]#</i> krever et miniatyrbilde.<br /><br /><b>#pgv_lang[no]#</b> valg vil føre til at PhpGedView sender det store bildet, mens valget <b>#pgv_lang[yes]#</b> vil føre til at det lille bildet blir sendt. Hvert enkelt bilde har også alternativet «#factarray[_THUM]#» som, når det er satt til <b>#pgv_lang[yes]#</b>, vil føre til at det store bildet sendes uavhengig av innstillingen til «#pgv_lang[USE_THUMBS_MAIN]#» alternativ i GEDCOM-konfigurasjonen. Du kan ikke tvinge PhpGedView til å sende små bilder når GEDCOM-konfigurasjonen angir at store bilder alltid skal brukes.<br /><br />PhpGedView endrer ikke størrelsen på bildet som sendes. nettleseren gjør dette i henhold til sidespesifikasjonene den også har mottatt. Dette kan ha uønskede konsekvenser når bildet som sendes ikke er et miniatyrbilde der PhpGedView forventer å sende et lite bilde. Dette er ikke en feil: Det er anledninger hvor det kan være ønskelig å vise et stort bilde på steder der man normalt forventer å se et miniatyrstørrelsesbilde.<br /><br />Du bør unngå å sette «#pgv_lang [USE_THUMBS_MAIN] # »alternativ til <b>#pgv_lang[no]#</b>. Dette valget vil føre til at store mengder bilderelaterte data blir sendt til nettleseren, bare for at nettleseren skal forkaste det overskytende. Sidelast, spesielt med diagrammer med mange bilder, kan reduseres alvorlig.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Vis filnavnet i medieviser";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Medieviseren kan vise navnet på mediefilen som vises. Dette alternativet avgjør om filnavnet skal vises til brukerne eller ikke.<br /><br />Det kan være lurt å skjule filnavnet av sikkerhetsgrunner.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Vis nedlastingskobling i medieviser";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Medieviseren kan vise en lenke som, når du klikker på den, vil laste ned mediefilen til den lokale computer.<br /><br />Det kan være lurt å skjule nedlastingskoblingen av sikkerhetsgrunner.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Aktiver utklippsvognen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Utklippsvognen lar brukerne legge til folk i en midlertidig fil som de kan laste ned i GEDCOM-format for senere import til deres slektsprogramvare.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Skjul GEDCOM feil";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Hvis du setter dette til <b>#pgv_lang[yes]#</b>, skjules feilmeldinger produsert av PhpGedView når det ikke forstår en kode i GEDCOM-filen. PhpGedView gjør sitt ytterste for å overholde GEDCOM 5.5.1-standarden, men mange slektsforskningsprogrammer inkluderer egne tilpassede koder. Se <a href=\"readme.txt\">readme.txt</a> filen for mer informasjon.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Legg til mellomrom der notene ble pakket inn";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Noen slektsforskningsprogrammer pakker notater ved ordgrenser, mens andre pakker notater hvor som helst. Dette kan føre til at PhpGedView kjører ord sammen. Hvis du setter dette til <b>#pgv_lang[yes]#</b>, vil du legge til et mellomrom mellom ordene der de er pakket inn i den opprinnelige GEDCOM.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Vis kontekstuelle hjelpekoblinger";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Dette alternativet vil aktivere lenker, identifisert av spørsmålstegn, ved siden av elementer på mange sider. Disse koblingene lar brukerne få informasjon eller hjelp om disse elementene.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Kommende hendelser blokkerer dagsgrensen";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Angi maksimalt antall dager som skal vises i blokkeringer for kommende hendelser. Dette tallet kan ikke være større enn 30. Hvis du skriver inn en større verdi, vil 30 brukes.<br /><br />Verdien du skriver inn her, avgjør hvor langt fremover PhpGedView ser ut når du søker etter kommende arrangementer. Resultatene av dette søket, gjort en gang daglig, kopieres til en midlertidig fil.<br /><br />Ingen kommende hendelsesblokker på index eller portalsider kan be om flere dager enn denne verdien. Jo større du lager dette, jo lenger tid vil det ta å bygge det daglige databaseekstraktet, og jo lenger tid vil det ta å vise blokken, selv når du ber om å vise et antall dager mindre enn denne innstillingen.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Minimum antall forekomster for å være et «Hyppig Etternavn»";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Dette er antall ganger et etternavn må forekomme før det vises i listen over hyppige etternavn på velkomstsiden.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Navn å legge til i listen over hyppige etternavn";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Hvis antall ganger et bestemt etternavn oppstår er lavere enn terskelen, vil det ikke vises i listen. Det kan legges til her manuelt. Hvis mer enn ett etternavn skrives inn, må de skilles med komma. <b>Etternavn er store og små bokstaver.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Navn som skal fjernes fra listen over hyppige etternavn";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Hvis du vil fjerne et etternavn fra listen over hyppige etternavn uten å øke terskelverdien, kan du gjøre det ved å skrive inn etternavnet her. Hvis mer enn ett etternavn skrives inn, må de skilles med komma. <b>Etternavn er store og små bokstaver.</b> Etternavn som er angitt her, vil også bli fjernet fra Topp 10-listen på velkomstsiden.";
$pgv_lang["HOME_SITE_URL"]		= "URL til hovednettstedet";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Hver PhpGedView-side inneholder en lenke til hovedsiden din. Utseendet til denne lenken styres av temaet som brukes. Du skriver inn nettadressen til hjemmesiden din her.";
$pgv_lang["HOME_SITE_TEXT"]		= "Tittel på hovednettsted";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Forklaringen brukes til å identifisere lenken til hovedsiden din.";
$pgv_lang["CONTACT_EMAIL"]		= "Slektsforskningskontakt";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Personen som skal kontaktes om slektsdata på dette nettstedet.";
$pgv_lang["CONTACT_METHOD"]		= "Kontaktmetode";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Metoden som skal brukes til å kontakte #pgv_lang[CONTACT_EMAIL]# om slektsspørsmål.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] = "<ul><li>Alternativet <b>#pgv_lang[mailto]#</b> vil opprette en «mailto» lenke som kan klikkes for å sende en e-post ved hjelp av e-postklienten på brukerens computer.</li><li>Alternativet <b>#pgv_lang[messaging]#</b> vil bruke et internt meldingssystem til PhpGedView, og ingen e-post vil bli sendt.</li><li>Alternativet <b>#pgv_lang[messaging2]#</b> er standard. Den vil bruke PhpGedView-meldingssystemet og vil også sende kopier av meldingene via e-post.</li><li>Alternativet <b>#pgv_lang[messaging3]#</b> lar PhpGedView håndtere meldingene og sender meldingene som e-post, men lagrer ikke meldingene internt. Dette alternativet ligner på alternativet <b>#pgv_lang[mailto]#</b>, bortsett fra at meldingen blir sendt av PhpGedView i stedet for brukerens arbeidsstasjon.</li><li>Alternativet <b>#pgv_lang[no_messaging]#</b> fører til at brukerne ikke har noen måte å kontakte deg på.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "PhpGedView svaradresse";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />E-postadresse som skal brukes i feltet «Fra:» på e-post som PhpGedView oppretter automatisk.<br /><br />PhpGedView kan automatisk opprette e-post for å varsle administratorer om endringer som må gjennomgås. PhpGedView sender også e-postvarsler til brukere som har bedt om en konto.<br /><br />Vanligvis er «Fra:» feltet av disse automatisk opprettede e-postene noe sånt som <i>Fra: phpgedview-noreply@dittnettsted</i> for å vise at det ikke kreves noe svar på e-posten. For å beskytte mot spam eller annet e-postmisbruk, krever noen e-postsystemer «Fra:» feltet i hver melding for å gjenspeile en gyldig e-postkonto og godtar ikke meldinger som tilsynelatende kommer fra kontoen <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Støttekontakt";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Personen som skal kontaktes om tekniske spørsmål eller feil på nettstedet ditt.";
$pgv_lang["SUPPORT_METHOD"]		= "Kontaktmetode";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Metoden som skal brukes til å kontakte #pgv_lang[WEBMASTER_EMAIL]# om tekniske spørsmål.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Vis faktaikoner";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Sett dette til <b>#pgv_lang[yes]#</b> for å vise ikoner nær faktanavn på <i>#pgv_lang[personal_details]#</i> siden. Faktiske ikoner vises bare hvis de finnes i <i>images/facts</i> mappen til det gjeldende temaet.";
$pgv_lang["FAVICON"]			= "Favorittikon";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Endre dette for å peke på ikonet du vil vise i besøkendes favorittmeny når de bokmerker nettstedet ditt.";
$pgv_lang["THEME_DIR"]			= "Temamappe";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />Mappen der PhpGedView-temafilene oppbevares.<br /><br />Du kan tilpasse hvilket som helst av standardtemaene som følger med PhpGedView for å gi nettstedet ditt et unikt utseende. Se delen Tilpasning av tema i <a href=\"readme.txt\">readme.txt</a> filen for mer informasjon.";
$pgv_lang["TIME_LIMIT"]			= "PHP tidsgrense";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Maksimal tid i sekunder som PhpGedView skal få kjøre.<br /><br />Standard er 1 minutt. Avhengig av størrelsen på GEDCOM-filen din, kan det hende du må øke denne tidsfristen når du trenger å bygge indeksene. Sett denne verdien til 0 slik at PHP kan kjøre for alltid.<br /><br />FORSIKTIG: Hvis du setter denne til 0 eller setter den for høyt, kan nettstedet ditt henge på visse operativsystemer til skriptet er ferdig. Hvis du setter den til 0, betyr det at den kanskje aldri blir ferdig før en serveradministrator dreper prosessen eller starter serveren på nytt. Et stort stamtavle kan ta veldig lang tid å løpe; å la denne verdien være så lav som mulig, sikrer at noen ikke kan krasje serveren din ved å be om et for stort diagram.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Stien til å lagre PhpGedView-øktfiler.<br /><br />Noen verter har ikke PHP riktig konfigurert, og økter blir ikke vedlikeholdt mellom sideforespørsler. Dette alternativet lar nettstedsadministratorer løse problemet ved å lagre filer i en av de lokale katalogene. ./index/ mappen er et godt valg hvis du trenger å endre dette. Standard er å la feltet være tomt, som vil bruke Lagre banen som konfigurert i <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />If you use https eller a port other than the default, you will need to enter the URL to access your server here.";
$pgv_lang["LOGIN_URL"]			= "Påloggings-URL";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />YDu trenger bare å oppgi en påloggings-URL hvis du vil omdirigere til et annet nettsted eller et annet sted når brukerne logger inn. Dette er veldig nyttig hvis du trenger å bytte fra http til https når brukerne logger inn. Inkluder hele URL-en til <i>login.php</i>. For eksempel https://www.dinserver.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Tiden i sekunder som en PhpGedView-økt forblir aktiv før du krever pålogging. Standard er 7200, som er 2 timer.";
$pgv_lang["SHOW_STATS"]			= "Vis utførelsesstatistikk";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Vis kjøretidsstatistikk og databasespørsmål nederst på hver side.";
$pgv_lang["SHOW_COUNTER"]		= "Vis hit tellere";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Vis treffteller på Portal og #pgv_lang [personal_details] # sider.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Gir besøkende muligheten til å registrere seg for en konto på nettstedet.<br /><br />Den besøkende vil motta en e-postmelding med en kode for å bekrefte søknaden om en konto. Etter bekreftelse må administratoren godkjenne registreringen før den blir aktiv.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Gir brukerne muligheten til å velge sitt eget tema.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />I vanlige e-postoverskrifter for eksterne e-poster brukes e-postadressen samt navnet. Noen e-postsystemer godtar ikke dette. Når den er satt til <b>#pgv_lang[yes]#</b>, vil bare e-postadressen bli brukt.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Bruk SMTP til å sende e-post fra PhpGedView.<br /><br />Dette alternativet krever tilgang til en SMTP-e-postserver. Når den er satt til <b>#pgv_lang[no]#</b>, bruker PhpGedView e-postsystemet innebygd i PHP på denne serveren.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Når alternativet <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> er satt til <b>#pgv_lang[yes]#</b>, vil PhpGedView bruke PHPMailer-programmet til å sende e-post. Dette programmet produserer feilmeldinger når det støter på problemer mens du prøver å sende e-post.<br /><br />Dette alternativet, som er nyttig når du prøver å løse problemer med sending av e-post, bestemmer hvilke typer feil som PHPMailer vil rapportere. Feiltypene du kan velge er:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Dette er navnet på SMTP-postserveren. Eksempel: <b>smtp.foo.bar.com</b>.<br /><br />Konfigurasjonsverdier for noen e-postleverandører:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 eller 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 eller 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (for tiden en betalt tjeneste)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Dette er domenedelen av en gyldig e-postadresse på SMTP-serveren.<br /><br />For eksempel hvis du har en e-postkonto som <b>dittnavn@abc.xyz.com</b>, skriver du inn <b>abc.xyz.com</b> her.";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Portnummeret som skal brukes for tilkoblinger til SMTP-serveren. Vanligvis er dette port <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Bruk autentisering av navn og passord for å koble til SMTP-serveren.<br /><br />Noen SMTP-servere krever at alle tilkoblinger er autentiserte før de godtar utgående e-post.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Brukernavnet som kreves for autentisering med SMTP-serveren.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Passordet som kreves for autentisering med SMTP-serveren.";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) og Secure Sockets Layer (SSL) er krypteringsprotokoller for Internett-data.<br /><br />TLS 1.0, 1.1 og 1.2 er standardiserte utviklinger av SSL 3.0. TLS 1.0 og SSL 3.1 er ekvivalente. Ytterligere arbeid med SSL gjøres nå under det nye navnet TLS.<br /><br />Hvis SMTP-serveren din krever SSL-protokollen under pålogging, bør du velge alternativet <b>SSL</b>. Hvis SMTP-serveren din krever TLS-protokollen under pålogging, bør du velge alternativet <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Skriv inn navnet som skal brukes i feltet «Fra:» med e-postmeldinger som kommer fra dette nettstedet.<br /><br />Hvis du for eksempel heter <b>John Smith</b> og du er nettstedsadministrator for et nettsted som er kjent som <<b>Jones Genealogy</b>, kan du skrive inn noe sånt som <b>John&nbsp;Smith</b> elle <b>Jones&nbsp;Genealogy</b> eller til og med <b>John&nbsp;Smith,&nbsp;Administrator:&nbsp;Jones&nbsp;Genealogy</b>. Du kan angi hva du vil, men HTML er ikke tillatt.";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Skriv inn en beskrivende tittel som skal vises når brukere velger blant GEDCOM datasett på nettstedet ditt.";
$pgv_lang["LOGFILE_CREATE"]		= "Arkivér loggfilene";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere loggfilene.";
$pgv_lang["REMINDER_FREQ"] 			= "Hyppigheten av e-post påminnelser «Gjennomgå endringer»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Dette alternativet styrer hvor ofte e-post påminnelser «Gjennomgå endringer» vil bli sendt. <b>null</b>: aldri;&nbsp;&nbsp;<b>1</b>: daglig;&nbsp;&nbsp;<b>2</b>: annenhver dag; osv.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Maksimalt minne som kan forbrukes av PhpGedView-skript. Standard er 64 Mb. Mange verter deaktiverer dette alternativet i sin PHP-konfigurasjon; endring av denne verdien påvirker kanskje ikke den gjeldende maksimale minneinnstillingen.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Spesifiserer om meldinger sendt via PhpGedView kan lagres i databasen. Hvis angitt til <b>#pgv_lang[yes]#</b> vil brukere kunne hente meldingene sine når de logger på PhpGedView. Hvis angitt til <b>#pgv_lang[no]#</b>, vil meldinger bare sendes via e-post.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Vis tememeny for temaendringer";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Gir brukerne muligheten til å velge sitt eget tema fra en meny.<br /><br />Selv med dette alternativet er det mulig at temaet som er i kraft for øyeblikket ikke gir en slik meny. For å være effektiv, krever dette alternativet alternativet <b>#pgv_lang[ALLOW_USER_THEMES]#</b> også.";
$pgv_lang["MAX_VIEW_RATE"]		= "Maksimal sidevisningshastighet";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Dette alternativet begrenser hastigheten som en bruker kan se på sider.<br /><br />Hvis denne hastigheten overskrides, behandler PhpGedView økten som et hackingsforsøk; økten avsluttes med en passende melding. Disse to verdiene bør sette en rimelig grense for mengden båndbredde og nedlastede byte fra serveren. Denne funksjonen kan slås av ved å sette tidsintervallet til 0.";
$pgv_lang["META_AUTHOR"]		= "META tag: Author (forfatter)";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Teksten som skal plasseres i forfatter metakoden i HTML-sidens overskrift. #pgv_lang[META_AUTHOR_descr]#";
$pgv_lang["META_AUTHOR_descr"]	= "La dette feltet være tomt for å bruke det fulle navnet på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "META tag: Publisher (forlegger)";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Tekst som skal plasseres i forlegger metakoden i HTML-sidens overskrift. #pgv_lang[META_PUBLISHER_descr]#";
$pgv_lang["META_PUBLISHER_descr"]	= "La dette feltet være tomt for å bruke det fulle navnet på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "META tag: Copyright (opphavsrett)";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Tekst som skal plasseres i opphavsrett metakoden i HTML-sidens overskrift. #pgv_lang[META_COPYRIGHT_descr]#";
$pgv_lang["META_COPYRIGHT_descr"]	= "La dette feltet være tomt for å bruke det fulle navnet på #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "META tag: Description (beskrivelse)";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Tekst som skal plasseres i beskrivelse metakoden i HTML-sidens overskrift. #pgv_lang[META_DESCRIPTION_descr]#";
$pgv_lang["META_DESCRIPTION_descr"]	= "La dette feltet være tomt for å bruke tittelen på den aktive databasen.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag: Page-topic (tema)";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Tekst som skal plasseres i tema metakoden i HTML-sidens overskrift. #pgv_lang[META_PAGE_TOPIC_descr]#";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "La dette feltet være tomt for å bruke tittelen på den aktive databasen.";
$pgv_lang["META_AUDIENCE"]		= "META tag: Audience (publikum)";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Tekst som skal plasseres i publikum metakoden i HTML-sidens overskrift.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag: Page-type (sidetype)";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Tekst som skal plasseres i sidetype metakoden i HTML-sidens overskrift.";
$pgv_lang["META_ROBOTS"]		= "META tag: Robots (roboter)";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />Tekst som skal plasseres i roboter metakoden i HTML-sidens overskrift.  Noen søkemotorer ignorerer dette.";
$pgv_lang["META_REVISIT"]		= "META tag: Revisit (gå tilbake)";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />Hvor ofte bør søkemotorer gå tilbake? Nummeret du skal plassere i gå tilbake metakoden i HTML-sidens overskrift. Noen søkemotorer ignorerer dette.";
$pgv_lang["META_KEYWORDS"]		= "META tag: Keywords (nøkkelord)";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />The value to place in the Keywords meta tag in the HTML page header.  Some search engines will use the Keywords meta tag to help index your page.<br /><br />The #pgv_lang[common_surnames]# list that appears in the #pgv_lang[gedcom_stats]# block on your Welcome page can also be added to anything you enter here.";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Tekst som skal plasseres i nøkkelord metakoden i HTML-sideoverskriften. Noen søkemotorer vil bruke nøkkelord metakoden for å hjelpe deg med å indeksere siden din.<br /><br />#pgv_lang[common_surnames]# listen som vises i #pgv_lang[gedcom_stats]# blokken på velkomstsiden din kan også legges til alt du skriver inn her.";
$pgv_lang["META_TITLE"]		= "Legg til TITLE topptekst";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Alt på denne linjen vil bli lagt til TITLE-taggen i HTML-sideoverskriften etter den vanlige sidetittelen og før PhpGedView-kreditten.";
$pgv_lang["ENABLE_RSS"]				= "Aktiver RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Dette alternativet lar deg deaktivere RSS-funksjonen.<br /><br />RSS lar brukere overvåke nettstedet ditt for endringer på indeksiden uten å besøke nettstedet ditt med jevne mellomrom. Hvis for mange brukere benytter seg av denne funksjonen, eller hvis oppdateringsfrekvensen som er innstilt av disse brukerne, er for høy, kan RSS bruke for mye båndbredde eller serverkapasitet.<br /><br />Dette <a href='https://no.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia artikkel'><b>Wikipedia artikkel</b></a> inneholder omfattende informasjon og lenker om RSS og de forskjellige RSS-formatene.";
$pgv_lang["RSS_FORMAT"]				= "RSS format";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Formatet som skal brukes som standard feedformat for nettstedet. De numeriske suffiksen <u>indikerer ikke</u> versjon: de identifiserer formater. For eksempel er RSS 2.0 ikke nyere enn RSS 1.0, men et annet format. Strømlesere skal kunne lese hvilket som helst format.<br /><br />Dette <a href='https://no.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia artikkel'><b>Wikipedia artikkel</b></a> inneholder omfattende informasjon og lenker om RSS og de forskjellige RSS-formatene.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Sjekk om GEDCOM-filer kan lastes ned";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Av sikkerhetsmessige årsaker bør ikke GEDCOM-filer være på et sted der de kan lastes ned direkte, og dermed omgå personvernkontroller. Ved å klikke på denne lenken vil du kontrollere om GEDCOM-filene dine kan lastes ned over nettverket.<br /><br />På noen systemer har denne sjekken vært kjent for å ta veldig lang tid eller ikke engang fullført. Hvis det er tilfelle for deg, bør du prøve å peke nettleseren direkte mot GEDCOM for å se om den kan lastes ned.";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kan ikke lastes ned. ";

$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~<br /><br />Siden du ser denne siden, har du vellykket installert PhpGedView på serveren din og er klar til å begynne å konfigurere den til dine behov.<br /><br />Denne hjelpesiden vil guide deg gjennom konfigurasjonsprosessen. Når du går inn i forskjellige felt, vil dette vinduet gi deg hjelpinformasjon om feltet du befinner deg i. Du kan lukke dette vinduet; for å åpne den igjen, klikk på en av <b>#pgv_lang[qm]#</b> spørsmålstegn ved siden av feltetiketten.";
$pgv_lang["return_editconfig"]		= "Du kan når som helst gå tilbake til denne konfigurasjonen ved å peke nettleseren din til <i>editconfig.php</i> eller ved å klikke på lenken for <b>Konfigurasjon</b> på siden <b>Administrasjon av PhpGedView</b>.";
$pgv_lang["return_editconfig_gedcom"]	= "Du kan når som helst gå tilbake til denne konfigurasjonen ved å klikke på lenken <b>Rediger</b> i tabellen <b>#pgv_lang[current_gedcoms]#</b> i <b>#pgv_lang[gedcom_adm_head]#</b> side eller ved å peke nettleseren din til <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"] 		= "Lagre konfigurasjonen";
$pgv_lang["download_gedconf"]		= "Last ned GEDCOM-konfigurasjon.";
$pgv_lang["not_writable"]		= "Vi har oppdaget at konfigurasjonsfilen din ikke kan skrives av PHP. Du kan bruke <b>#pgv_lang[download_file]#</b> knappen for å lagre innstillingene dine i en fil som du kan laste opp manuelt.";
$pgv_lang["upload_to_index"]		= "Last opp filen til index mappen: ";
$pgv_lang["import_sql"]			= "SQL filer er funnet i indeksmappen. Siden de kan stamme fra #pgv_lang[um_header]#, har du muligheten til å importere informasjonen til databasen din. Ønsker du å prøve å importere disse filene til databasen din nå? All eksisterende brukerrelatert informasjon (brukere, nyheter, favoritter, blokkeringsoppsett og meldinger) i databasen din vil gå tapt.<br /><br />Hvis du velger å fortsette, vil PhpGedView prøve å importere dataene. Hvis dette ikke lykkes, vil du bli bedt om å opprette den første administratorkontoen uansett.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Rediger personvern";
$pgv_lang["edit_privacy_title"]			= "Rediger GEDCOM personvern innstillinger";
$pgv_lang["save_changed_settings"]		= "Lagre endringer";
$pgv_lang["add_new_pp_setting"]			= "Legg til ny innstilling av total personvern etter person-ID";
$pgv_lang["add_new_up_setting"]			= "Legg til ny innstilling av personvern for brukernavn";
$pgv_lang["add_new_gf_setting"]			= "Legg til ny innstilling av globalt personvern om fakta";
$pgv_lang["add_new_pf_setting"]			= "Legg til ny innstilling av personvern om fakta etter person-ID";
$pgv_lang["file_read_error"]			= "F E I L !!! Kunne ikke lese personvernfilen!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Rediger eksisterende innstillinger for total personvern etter person-ID";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Rediger eksisterende innstillinger for personvern for brukernavn";
$pgv_lang["edit_exist_global_facts_settings"]	= "Rediger eksisterende innstillinger for globalt personvern om fakta";
$pgv_lang["edit_exist_person_facts_settings"]	= "Rediger eksisterende innstillinger for personvern om fakta etter person-ID";
$pgv_lang["general_privacy"]			= "Generelle personvern innstillinger";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Du kan ha forskjellige personverninnstillinger for hver GEDCOM på PhpGedView-nettstedet. Sjekk under sidetittelen om du redigerer riktig GEDCOM.<br /><br />Du kan overstyre disse generelle innstillingene ved å bruke de andre personvernskjemaene på siden #pgv_lang[edit_privacy_title]#.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]				= "Innstillinger for total personvern etter person-ID";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Disse innstillingene tillater administratorer å overstyre standardinnstillingene for personvern for en bestemt person, familie, kilde eller medieobjekt.<br /><br />Anta at du for eksempel har et barn som døde i barndommen. Normalt fordi barnet er død, vil dets detaljer bli vist for offentlige brukere. Imidlertid er du og alle andre i familien fortsatt private. Du vil ikke fjerne dødsoppføringen for barnet, men du vil skjule detaljene og gjøre dem private. Hvis dette barnet hadde ID-en I100, bør du angi følgende personverninnstillinger:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Dette fungerer også den andre veien. Hvis du ønsket å offentliggjøre detaljene til noen (ID I101) som du vet er død, men ikke har dødsdato for, kan du legge til følgende:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]				= "Innstillinger for personvern for brukernavn";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Disse innstillingene gir administratorer muligheten til å overstyre standard personverninnstillinger for personer i GEDCOM basert på brukernavn. Anta at du ikke vil at brukernavnet <b>John</b> skal kunne se noen detaljer for ID I100 i GEDCOM, du kan konfigurere det slik:<br />&nbsp;&nbsp;&nbsp;Brukernavn:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;og detaljer for den angitte personen vil bare være skjult for brukernavnet «John».<br /><br />For å vise detaljene i I101 (som vanligvis ville være skjult fordi I101 fortsatt lever) til Brukernavn «John» sett:<br />&nbsp;&nbsp;&nbsp;Brukernavn:&nbsp;&nbsp;John<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]				= "Innstillinger for globalt personvern om fakta";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Disse innstillingene definerer fakta på et globalt nivå som skal skjules for alle personer i GEDCOM. Dette gjelder bare faktaposter på nivå 1 som BIRT eller DEAT som vil vises med egne overskrifter på #pgv_lang [personal_facts] # -fanen på <i>#pgv_lang[personal_details]#</i> siden.<br /><ul><li>Elementet <b>#pgv_lang[name_of_fact]#</b> bestemmer hvilket faktum som skal skjules.</li><li>Elementet <b>#pgv_lang[choice]#</b> spesifiserer selve fakta eller relaterte detaljer.</li><li>Elementet <b>#pgv_lang[accessible_by]#</b> bestemmer på hvilket tilgangsnivå fakta vises.</li></ul><br />Denne funksjonen er ment å skjule visse fakta, identifisert av GEDCOM-koder, for alle mennesker i live eller døde. Som standard er SSN-koden skjult for offentlige brukere. Dette er for å forhindre at folk stjeler personnummer og begår identitetstyveri av døde personer. Dette er sannsynligvis mest relevant for USA.<br /><br />Hvis du vil skjule alle ekteskap fra offentlige brukere i GEDCOM, kan du angi:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Ekteskap<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disse innstillingene vil skjule ekteskap og beslektede detaljer for besøkende som ikke er logget på.<br /><br />I motsetning til alle andre innstillinger, kan du i <b>#pgv_lang[edit_exist_global_facts_settings]#</b> skjule fakta selv fra administrator brukere. Uønskede fakta blir fullstendig undertrykt.";
$pgv_lang["person_facts"]				= "Innstillinger for personvern om fakta etter person-ID";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Disse innstillingene definerer fakta som er skjult for en bestemt person, familie eller kilde, og hvilket nivå de er skjult på. Dette gjelder bare faktaoppføringer på nivå 1 som BIRT eller DEAT som vil vises med sine egne overskrifter på den relevante informasjonssiden til personen, familien eller kilden.<br /><br />Det første elementet er ID-en til person, familie eller kilde. Det andre elementet er faktum. Elementet <b>#pgv_lang[choice]#</b> spesifiserer selve fakta eller relaterte detaljer. Elementet <b>#pgv_lang[accessible_by]#</b> bestemmer på hvilket tilgangsnivå fakta vises. Ikke alle fakta som vises i listen, gjelder for alle typer ID-er. Fødsels- og dødsfakta er for eksempel ikke relevant for kildeposter.<br /><br />Denne listen ligner på <b>#pgv_lang[global_facts]#</b> listen, bortsett fra at du også spesifiserer GEDCOM-ID av personen du vil skjule fakta for. Du kan for eksempel skjule ekteskapsoppføringen for en bestemt person.";
$pgv_lang["accessible_by"]			= "Vis til?";
$pgv_lang["hide"]				= "Gjemme";
$pgv_lang["show_question"]			= "Vise?";
$pgv_lang["user_name"]				= "Brukernavn";
$pgv_lang["name_of_fact"]			= "Faktanavn";
$pgv_lang["choice"]				= "Valg";
$pgv_lang["fact_show"]				= "Vis faktum";
$pgv_lang["fact_details"]			= "Vis faktadetaljer";
$pgv_lang["privacy_header"]			= "Rediger personverninnstillingene";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan ikke finne person med id";
$pgv_lang["save_and_import"]			= "Når du har lagret denne GEDCOM-konfigurasjonen, må du importere GEDCOM ved å klikke på <b>Importer GEDCOM</b> eller ved å gå til <b>Administrer --> Administrer GEDCOMs --> Importer</b>";
$pgv_lang["help_info"]				= "Du kan få hjelp til hvert element ved å klikke på den røde <b>#pgv_lang[qm]#</b> ved siden av etiketten for hver celle.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Vis navn på levende mennesker";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Bør navnene på levende mennesker vises for publikum?<br /><br />Normalt vil denne innstillingen være «#pgv_lang[PRIV_USER]#». Dette tjener til å beskytte personvernet til levende personer i databasen din, fordi du kan bestemme hvem du gir generell tilgang til dine slektsdata.<br /><br />Innstillingen «#pgv_lang[PRIV_NONE]#» forhindrer visning av navnene av levende mennesker til brukere som ikke har administratorrettigheter.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Vis forskningsassistent";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Hvilken type bruker kan vise forskningsassistentmodulen hvis den er installert?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Bruk personvern etter forhold";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> betyr at autentiserte brukere kan se detaljene til alle levende mennesker. <b>#pgv_lang[yes]#</b> betyr at brukere bare kan se den private informasjonen til levende mennesker de er relatert til.<br /><br />Dette alternativet angir standard for alle brukere som har tilgang til denne genealogiske databasen. Administratoren kan overstyre dette alternativet for individuelle brukere ved å redigere brukerens kontodetaljer.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Maksimal forholdsbane lengde";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Hvis alternativet <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> er aktivert, vil påloggede brukere bare kunne se eller redigere personer innenfor dette antallet forholdstrinn.<br /><br />Dette alternativet angir standard for alle brukere som har tilgang til denne genealogiske databasen. Administratoren kan overstyre dette alternativet for individuelle brukere ved å redigere brukerens kontodetaljer.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Sjekk forholdet etter ekteskap";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Sjekk forhold som er relatert av ekteskap.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Vis døde mennesker";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Angi tilgangsnivået for personvern for alle døde mennesker.";
$pgv_lang["select_privacyfile_button"]		= "Velg personvern fil";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Begrens personvernet etter begivenhetsalder";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Innstillingen <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> vil skjule detaljene til folk basert på hvor gamle de var ved bestemte arrangementer, uavhengig av om de er døde eller i live.<br /><br />Bruk denne innstillingen sammen med innstillingen <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Hvis du for eksempel har angitt aldersinnstillingen 100 og satt dette alternativet til <b>#pgv_lang[yes]#</b>, vil alle personer, levende eller døde, født for mindre enn 100 år siden, bli satt til private. Mennesker som var gift for mindre enn 85 år siden og personer som døde for mindre enn 75 år siden, ble også markert som private. Vær oppmerksom på at bruk av dette alternativet vil redusere ytelsen din noe.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Denne siden er ment å brukes av oversettere. Du kan oversette, sammenligne og eksportere språkfiler. Det er også et alternativ for å hjelpe oversetterne med å bestemme opprinnelsen til teksten som sendes ut av PhpGedView.<br /><br />Du kan bruke følgende alternativer og verktøy:";
$pgv_lang["edit_langdiff"]		= "Rediger og konfigurer språkfiler";
$pgv_lang["bom_check"]		= "Byte Order Mark (BOM) sjekk";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]		= "Denne sjekken vil analysere alle språkfilene for stykklisten (Byte Order Mark). Hvis den blir funnet, fjerner den stykklisten fra den berørte filen. Disse spesialkodene kan forårsake funksjonsfeil i noen deler av PhpGedView.";
$pgv_lang["lang_debug"]			= "Hjelp tekst feilsøking";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]	= "Når du aktiverer dette alternativet, vil navnene på språkvariablene som brukes i hjelpeteksten skrives ut i popup-vinduet i hjelpeteksten. Dette vil hjelpe oversetterne med å bestemme variabelnavnet når teksten må justeres.<br /><br />Denne innstillingen vil bare være gyldig under den nåværende PhpGedView-økten.";
$pgv_lang["lang_debug_use"]		= "Bruk feilsøking for hjelpetekst";
$pgv_lang["bom_not_found"]		= "Ingen BOM er funnet.";
$pgv_lang["bom_found"]			= "BOM er funnet i ";
$pgv_lang["edit_lang_utility"]		= "Redigeringsverktøy for språkfil";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]	= "Du kan bruke dette verktøyet til å redigere innholdet i en språkfil ved å bruke innholdet i den engelske.<br /><br />Du vil se innholdet i den originale engelskspråklige filen og innholdet av samme filtype (det er ni av disse) på det valgte språket ditt. Du klikker på meldingsteksten som vises under den engelske versjonen. Dette åpner et nytt vindu der du kan endre teksten. Du kan lagre endringene eller forlate dem.";
$pgv_lang["edit_lang_utility_warning"]	= "FORSIKTIG!<br /><br />Hvis du bruker <b>#pgv_lang[close_window_without_refresh]#</b> knappen, ser du kanskje ikke endringene dine på skjermen før du gjør en manuell sideopplasting. Det er mulig at språkfilen din kan bli ødelagt hvis du legger til en melding som ennå ikke har blitt vist i språkfilen, eller hvis du bare redigerer en melding du har redigert direkte før.<br /><br />Hvis du ikke egentlig vet hva du gjør, ikke bruk <b>#pgv_lang[close_window_without_refresh]#</b> knappen.";
$pgv_lang["language_to_edit"]		= "Språk å redigere";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />I denne listen velger du språket som du vil redigere meldingene til.";
$pgv_lang["file_to_edit"]		= "Språk filtype å redigere";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView har implementert støtte for mange forskjellige språk. Dette er oppnådd ved å holde all tekst som er synlig for brukere i filer helt atskilt fra hovedprogrammet. Det er et sett med åtte filer for hvert språk som støttes, og de forskjellige tekstene har blitt delt inn i en av disse filene i henhold til funksjon. <b>Ikke alle språkfiler trenger å være tilstede.</b> Når en gitt tekst ennå ikke er tilgjengelig i oversatt form, vil PhpGedView alltid bruke den engelske versjonen.<br /><br />Filene i hvert språk sett er:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder vilkår og vanlige uttrykk for bruk under administrasjonen av PhpGedView og genealogiske databaser.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder hjelpetekster for bruk under konfigurering av PhpGedView. Disse tekstene er ikke ment å bli sett på av vanlige brukere.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste over landnavn, hentet fra nettstedet til statistikkavdelingen, FNs avdeling for økonomiske og sosiale saker. Dette er den aktuelle <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>lenke</b></a> til den engelske listen. Listen er tilgjengelig på engelsk eller fransk.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder termer og vanlige uttrykk for bruk under redigering av oppføringer i slektsdatabaser.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder tekstekvivalenter til GEDCOM faktakoder som finnes i GEDCOM 5.5.1 Standard. Den inneholder også flere faktakoder som ikke finnes i standarden, men som brukes av forskjellige slektsforskningsprogrammer.<br /><br />En engelsk kopi av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kan lastes ned i PDF (Portable Document Format == bærbart dokumentformat).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Denne filen er et sett med <b>f</b>requently <b>a</b>sked <b>q</b>uestions (ofte stilte spørsmål) som er samlet inn av PhpGedView-utviklingsteamet. Hver FAQ har to oppføringer i denne filen. En oppføring er FAQ-overskriften (vanligvis spørsmålet), og den andre er FAQ-organet (vanligvis svaret). Erstatninger for <b><i>faqlist.xx.php</i></b> filene, som oppdateres ofte, kan lastes ned fra PhpGedView-hjemmesiden.<br /><br />Administratoren kan bruke FAQs i denne filen for å lage en FAQ liste som er spesifikk for nettstedet hans.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder hjelpetekster for vanlige brukere. Noen hjelpemner i denne filen dekker behovene til administratorer, og er skjult for brukere som ikke har administratorrettigheter.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Mange begreper og vanlige uttrykk finnes i denne filen.</li></ul><br />PhpGedView støtter også en valgfri niende språkfil, <b><i>extra.xx.php</i></b>. Denne filen lastes alltid inn etter alle de andre og gir et middel der en nettstedsadministrator kan overstyre eller endre hvilken som helst standardtekst på det valgte språket. Den kan også brukes til å gi en tittel for genealogiske databaser som varierer avhengig av det aktive språket.<br /><br />Innholdet i denne tilleggsfilen er helt opp til nettstedsadministratoren; denne filen vil <b>aldri</b> distribueres med noen versjon av PhpGedView. Administratoren skal aldri gjøre endringer i standardspråkfilene; alle lokale endringer bør konsentreres i denne valgfrie filen.";
$pgv_lang["check"]			= "Sjekk";
$pgv_lang["lang_save"]			= "Lagre";
$pgv_lang["contents"]			= "Innhold";
$pgv_lang["listing"]			= "Oppføring";
$pgv_lang["no_content"]			= "Ikke innhold";
$pgv_lang["editlang"]			= "Redigere";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Rediger melding fra språkfil.";
$pgv_lang["savelang"]			= "Lagre";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Lagre redigert melding i språkfilen.";
$pgv_lang["original_message"]		= "Opprinnelig melding";
$pgv_lang["message_to_edit"]		= "Melding å redigere";
$pgv_lang["changed_message"]		= "Endret innhold";
$pgv_lang["message_empty_warning"]	= "-&gt; Advarsel!!! Denne meldingen er tom i # LANGUAGE_FILE # &lt;-";
$pgv_lang["language_to_export"]		= "Språk å eksportere";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Fra denne listen kan du velge språk og språkfiler som du vil eksportere teksten til.<br /><br />Utdataene er en HTML-fil som du kan skrive ut fra nettleseren din.";
$pgv_lang["export_lang_utility"]	= "Språkfileksport verktøy";
$pgv_lang["export"]			= "Eksport";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Du kan opprette dokumentasjon for administratorer.<br /><br />Dette verktøyet produserer en HTML-versjon av den valgte språkfilen. Du kan bruke nettleseren din til å se på denne filen, som er formatert for utskrift.";
$pgv_lang["export_ok"]			= "Språktekst ble eksportert";
$pgv_lang["compare_lang_utility"]	= "Verktøy for sammenligning av språkfil";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Dette verktøyet vil sammenligne to sett med språkfiler for å lage en liste over tillegg og subtraksjoner mellom dem.<br /><br />De engelske filene skal brukes som referanse der alle andre er produsert.";
$pgv_lang["new_language"]		= "Opprinnelig språk";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Fra denne listen kan du velge språket som du vil sammenligne meldingene til med et annet språk.<br /><br />Alle endringer og tillegg til språkfiler blir først gjort i <b>engelsk</b> språkfiler, så du vil normalt velge engelsk som et av språkene du kan sammenligne.";
$pgv_lang["old_language"]		= "Sekundært språk";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Fra denne listen kan du velge språket du vil sammenligne med det valgte språket i listen <b>#pgv_lang[new_language]#</b>.<br /><br />Etter at du har valgt, klikker du knappen <b>Sammenlign</b> for å få en liste over alle tillegg og subtraksjoner i alle filene på begge språk.<br /><br />For å oppdatere minnet ditt:<br /><b>Tillegg</b> betyr: Det er <u>i</u> kildefilen, men <u>ikke</u> i den sekundære filen.<br /><br /><b>Subtraksjon</b> betyr: Det er <u>ikke</u> i kildefilen, men det <u>er</u> i sekundærfilen. Dette kan skje når en gitt melding ikke lenger brukes og derfor ble fjernet fra de engelske filene. Du kan trygt fjerne den tilsvarende meldingen fra sekundærspråkfilene.";
$pgv_lang["compare"]			= "Sammenligne";
$pgv_lang["comparing"]			= "Språkfiler som sammenlignes";
$pgv_lang["additions"]			= "Tillegg";
$pgv_lang["no_additions"]		= "Ingen tillegg";
$pgv_lang["subtractions"]		= "Subtraksjoner";
$pgv_lang["no_subtractions"]		= "Ingen subtraksjoner";
$pgv_lang["config_lang_utility"]	= "Konfigurasjon av støttede språk";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Denne siden brukes til å kontrollere hvilke språkvalg som er tilgjengelige for brukerne dine. For eksempel kan du sette opp ting slik at bare norsk og fransk er tilgjengelig. Dette kan være nyttig hvis du for eksempel ikke kan kommunisere med brukerne på ungarsk.<br /><br />Du bruker også denne siden til å endre visse aspekter av PhpGedView som avhenger av det valgte språket. Her er for eksempel hvor du forteller PhpGedView hvordan du formaterer dato og klokkeslettfelt.<br /><br />Språkene som er aktive og gråtonede, kan ikke deaktiveres fordi de er i bruk. Se på nederste tabell for å se hvor språket brukes. Når et språk ikke lenger brukes av GEDCOM eller brukeren, vil du kunne deaktivere det.<br /><br />Alle endringene dine blir registrert i en ny fil kalt <i>language_settings.php</i> opprettet i mappen <b>#INDEX_DIRECTORY#</b>. Alle dine ytterligere endringer vil bli gjort i denne nye filen, og PhpGedView bruker bare <u>denne</u> filen. Du kan gå tilbake til de opprinnelige standardspråkinnstillingene ved å slette denne filen.<br /><br />Hvis du må rapportere problemer med språkinnstillingene dine, kan du fortelle PhpGedView-supportteamet om denne nye filen er tilstede eller ikke.";
$pgv_lang["active"]			= "Aktiv";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Tillat brukere å velge dette språket hvis alternativet <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> er aktivert.";
$pgv_lang["edit_settings"]		= "Endre innstillinger";
$pgv_lang["lang_edit"]			= "Redigere";
$pgv_lang["lang_language"]		= "Språk";
$pgv_lang["export_filename"]		= "Utdatafilnavn:";
$pgv_lang["lang_back"]			= "Gå tilbake til hovedmenyen for å redigere og konfigurere språkfiler";
$pgv_lang["lang_back_admin"]		= "Gå tilbake til administrasjonsmenyen";
$pgv_lang["lang_back_manage_gedcoms"]	= "Gå tilbake til GEDCOM-administrasjonsmenyen";
$pgv_lang["lang_name_arabic"]			= "Arabisk";
$pgv_lang["lang_name_catalan"]			= "Catalansk (Valencian)";
$pgv_lang["lang_name_chinese"]			= "Kinesisk (Tradisjonell)";
$pgv_lang["lang_name_chinese-cn"]		= "Kinesisk (Forenklet)";
$pgv_lang["lang_name_croatian"]			= "Kroatisk";
$pgv_lang["lang_name_czech"]			= "Tsjekkisk";
$pgv_lang["lang_name_danish"]			= "Dansk";
$pgv_lang["lang_name_dutch"]			= "Nederlandsk";
$pgv_lang["lang_name_english"]			= "Engelsk";
$pgv_lang["lang_name_estonian"]			= "Estisk";
$pgv_lang["lang_name_finnish"]			= "Finsk";
$pgv_lang["lang_name_french"]			= "Fransk";
$pgv_lang["lang_name_german"]			= "Tysk";
$pgv_lang["lang_name_greek"]			= "Gresk";
$pgv_lang["lang_name_hebrew"]			= "Hebraisk";
$pgv_lang["lang_name_hungarian"]		= "Ungarsk";
$pgv_lang["lang_name_indonesian"]		= "Indonesisk";
$pgv_lang["lang_name_italian"]			= "Italiensk";
$pgv_lang["lang_name_lithuanian"]		= "Litauisk";
$pgv_lang["lang_name_norwegian"]		= "Norsk";
$pgv_lang["lang_name_polish"]			= "Polsk";
$pgv_lang["lang_name_portuguese"]		= "Portugisisk";
$pgv_lang["lang_name_romanian"]			= "Rumensk";
$pgv_lang["lang_name_russian"]			= "Russisk";
$pgv_lang["lang_name_serbian-la"]		= "Serbisk (Latinsk alfabet)";
$pgv_lang["lang_name_slovak"]			= "Slovakisk";
$pgv_lang["lang_name_slovenian"]		= "Slovensk";
$pgv_lang["lang_name_spanish"]			= "Spansk";
$pgv_lang["lang_name_spanish-ar"]		= "Latin-amerikansk spansk";
$pgv_lang["lang_name_swedish"]			= "Svensk";
$pgv_lang["lang_name_turkish"]			= "Tyrkisk";
$pgv_lang["lang_name_vietnamese"]		= "Vietnamesisk";
$pgv_lang["lang_name_unknown"]			= "Ingen av disse språkene";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]			= "Nytt språk";
$pgv_lang["original_lang_name"]		= "Opprinnelig navn på språk i #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Opprinnelig navn på språket~<br /><br />Hvordan heter dette språket på dette språket?<br /><br />Engelsk kaller seg <b>English</b>; Tysk kaller seg <b>Deutsch</b>; Nederlandsk kaller seg <b>Nederlands</b>; Tsjekkisk kaller seg <b>Ceština</b>, etc.";
$pgv_lang["lang_shortcut"]		= "Forkortelse for språkfiler";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Denne koden definerer en forkortelse for språknavnet. Denne forkortelsen utgjør en del av navnet på hver av språkfilene som brukes av PhpGedView. Forkortelsen som brukes for fransk er for eksempel <b>fr</b>, og følgelig er filnavnene for fransk<i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, og <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]		= "Språkregistreringskoder";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Disse kodene gjør det mulig for PhpGedView å oppdage innstillingen for ønsket språk i nettleseren som brukes. PhpGedView bestemmer språket som nettleseren faktisk ber om, ved å matche nettleserens språkkode mot denne listen. Individuelle listeoppføringer må være atskilt med semikolon.";
$pgv_lang["lang_filenames"]		= "Språkfiler";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Flaggfil";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Navnet på den nasjonale flaggbildefilen for det valgte språket.<br /><br />Bilder for mange land er tilgjengelige fra <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a> siden.<br /><br />Når du finner et flaggbilde du liker, høyreklikker du på det og lagrer bildet i en midlertidig mappe. Deretter åpner du det lagrede bildet med en passende bildeditor (IrfanView anbefales for Windows-systemer), reduserer størrelsen 50x32 piksler, som er den normale størrelsen som brukes i PhpGedView, og lagrer den deretter som en GIF-fil til <i><b>images/flags</b></i> mappe. Du kan bruke hvilket som helst navn du ønsker.";
$pgv_lang["text_direction"]		= "Tekstretning";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Identifiserer hvilken retning som brukes til å skrive tekst på det valgte språket. De fleste språk er skrevet fra venstre til høyre. Arabisk og hebraisk er eksempler på språk som er skrevet i motsatt retning (høyre mot venstre).";
$pgv_lang["date_format"]			= "Datoformat";
$pgv_lang["date_format_help"]			= "~#pgv_lang[date_format]#~<br /><br />Dette feltet definerer datoformatet som skal brukes av PhpGedView når du viser datoer fra databasen. Du kan bruke formatet <b>Standard</b> eller <b>Avansert</b>.<ul><li><b>Standard</b><br />Følgende koder brukes til å representere forskjellige elementer av datoen. Merk at <b>D</b> og <b>M</b> har forskjellige betydninger i formatet <b>Avansert</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dag i måneden, uten ledende nuller; dvs. 1 til 31<br /><b>M</b>&nbsp;&nbsp;månedens navn; dvs. januar, februar osv.<br /><b>Y</b>&nbsp;&nbsp;hele året, for eksempel 1999 eller 44f.Kr.<br /><b>R</b>&nbsp;&nbsp;Kalenderkonvertering. Se emnet <b>Kalenderkonvertering</b> nedenfor for en beskrivelse av denne koden.</p>Disse kodene kan kombineres i hvilken som helst rekkefølge, sammen med mellomrom og tegnsetting. Anta for eksempel at GEDCOM inneholder datoen 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">En <b>engelsk</b> bruker kan sette formatet til <b>D&nbsp;M&nbsp;Y</b> å få <b>20&nbsp;August&nbsp;1965</b>.<br />En <b>amerikansk</b> bruker kan sette formatet til <b>M&nbsp;D,&nbsp;Y</b> å få <b>August&nbsp;20,&nbsp;1965</b><br />En <b>tysk</b> bruker kan sette formatet til <b>D.&nbsp;M&nbsp;Y</b> å få <b>20.&nbsp;August&nbsp;1965</b><br />En <b>ungarsk</b> bruker kan sette formatet til <b>Y.&nbsp;M&nbsp;D.</b> å få <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Avansert</b><br />Mer komplekse formateringsalternativer er tilgjengelige. Hvis datoformatet ditt inneholder en annen bokstav enn <b>D</b>, <b>M</b>, <b>Y</b> eller <b>R</b>, antas det for å bruke formatet <b>Avansert</b>.<br /><br />Følgende koder brukes til å representere forskjellige elementer av datoen. Merk at <b>D</b> og <b>M</b> har forskjellige betydninger i formatet <b>Standard</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dag i måneden, med ledende nuller; dvs. 01 til 31<br /><b>j</b>&nbsp;&nbsp;dag i måneden, uten ledende nuller; dvs. 1 til 31<br /><b>S</b>&nbsp;&nbsp;ordinært suffiks for dagnummeret; for eksempel på engelsk bokstavene <b>th</b> i <b>4th&nbsp;July</b>.<br /><b>l</b> (små «L»)&nbsp;&nbsp;ukedag; dvs. mandag, tirsdag osv.<br /><b>D</b>&nbsp;&nbsp;forkortet ukedag; dvs. m, ti, o, to, f, l, s<br /><b>N</b>&nbsp;&nbsp;ISO dag nummer; dvs. 0 til 6<br /><b>w</b>&nbsp;&nbsp;dag nummer; dvs. 1 til 7<br /><b>z</b>&nbsp;&nbsp;årets dag; dvs. 1 til 365 eller 366<br /><b>F</b>&nbsp;&nbsp;månedens navn; dvs. januar, februar osv.<br /><b>M</b>&nbsp;&nbsp;forkortet måned, dvs. jan, feb, etc.<br /><b>m</b>&nbsp;&nbsp;månedstall, med ledende nuller; dvs. 01 til 12<br /><b>n</b>&nbsp;&nbsp;månedstall, uten ledende nuller; dvs. 1 til 12<br /><b>Y</b>&nbsp;&nbsp;hele året, for eksempel 1999 eller 44f.Kr.<br /><b>y</b>&nbsp;&nbsp;forkortet år. Noen kalendere gjør at år kan forkortes. For den jødiske kalenderen er dette året uten tusenvis. For den gregorianske kalenderen er dette det samme som hele året.<br /><b>R</b>&nbsp;&nbsp;Kalenderkonvertering. Se emnet <b>Kalenderkonvertering</b> nedenfor for en beskrivelse av denne koden.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;internt GEDCOM-format</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;kalenderkode, f.eks. @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;dag, dvs. 01 til 31<br /><b>O</b>&nbsp;&nbsp;måned, på engelsk, f.eks. JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;år, f.eks. 1776, 1867, 2007, etc.<br /><br />For å se ukonverterte datoer, bruk <b>A&nbsp;O&nbsp;E</b> eller <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Noen eksempler</b>, med dato 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = o&nbsp;8&nbsp;september&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = onsdag&nbsp;-&nbsp;08&nbsp;-&nbsp;september&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"]			= "<ul><li><b>Kalenderkonvertering</b><br /><b>R</b>-koden er noe uvanlig i sin oppførsel. Når denne koden vises i datoformatet, vises den normale datoen en gang til, men i et annet kalendersystem. Elementene i denne alternative kalenderdatoen vil overholde de samme reglene som de som er i hoveddelen av formatspesifikasjonen, bortsett fra at utdata fra <b>R</b> formateringskoden er omgitt av parenteser for å skille den fra den vanlige datoen. Eksemplene gitt under <b>Fransk revolusjonerende</b> kalender vil gjøre dette litt tydeligere.<br /><br />Den alternative kalenderen som skal brukes til <b>R</b>-koden bestemmes i henhold til gjeldende sidespråk. Når sidespråket er hebraisk, vil <b>jødisk</b> kalenderen bli brukt. Når sidespråket er arabisk, vil <b>Hijri</b> kalenderen bli brukt. For alle andre sidespråk brukes <b>Fransk revolusjonerende</b> kalenderen.<br /><br />Handlingen til denne koden ligner på valget av kalenderformat du kan lage på GEDCOM-konfigurasjonssiden. Forskjellen mellom de to metodene er at <b>R</b>-koden, som er definert på språkkonfigurasjonsnivå, bare fungerer på utvalgte språk, men på tvers av alle GEDCOM-er på nettstedet. Kalenderalternativet som er satt på GEDCOM-konfigurasjonsnivå, fungerer på alle språk, men bare på GEDCOM-ene som alternativet er satt til.<br /><ul><li><b>Fransk Revolusjon</b> kalender&nbsp;&nbsp;&nbsp;Denne kalenderen kalles også <b>Franske Republikk</b> kalender.<br /><br />Med unntak av en veldig kort periode i mai 1871, var dette kalendersystemet bare i bruk i Frankrike og bare mellom 22&nbsp;SEP&nbsp;1792 og 31&nbsp;DEC&nbsp;1805.  Følgelig vil kalenderformatet for den franske revolusjonen bare gjelde når datoen er innenfor dette området.<br /><br />To eksempler på datoformater, forutsatt at sidespråket er engelsk, vil illustrere handlingen til <b>R</b> kode:<br /><b>Y.m.d&nbsp;R</b> kunne produsere <b>1805.04.26&nbsp;(XIII.08.06)</b> eller <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> kunne produsere <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> eller <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Språkalternativer</b><br />De forkortede tekstene for de avanserte kodene <b>D</b> og <b>M</b> er satt i filen <i>languages/lang.xx.php</i>, ved kommandoer som<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Disse kan endres ved å bruke en <i>languages/extra.xx.php</i>-fil som beskrevet i Wiki og ReadMe-teksten for språkjusteringer, for eksempel:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Lokalisering</b><br />Det finnes spesielle formateringsregler for en rekke språk, spesielt avvisning av månedsslutt i henhold til hvordan datoen er formulert. Disse spesielle reglene er implementert i de forskjellige filene <i>includes/extras/functions.xx.php</i>.</li></ul>";
$pgv_lang["time_format"]				= "Tidsformat";
$pgv_lang["time_format_help"]			= "~#pgv_lang[time_format]#~<br /><br />Dette feltet definerer tidsformatet som skal brukes av PhpGedView.<br /><br />Symboler du kan bruke er:<br /><b>a</b> - små bokstaver Ante meridiem og Post meridiem; dvs. <b>am</b> eller <b>pm</b><br /><b>A</b> - store bokstaver Ante meridiem og Post meridiem; dvs. <b>AM</b> eller <b>PM</b><br /><b>B</b> - Swatch Internett-tid; dvs. <b>000</b> til <b>999</b><br /><b>c</b> - ISO 8601 dato; f.eks. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - måned i måneden, 2 sifre, ledende null; dvs. <b>01</b> til <b>31</b><br /><b>D</b> - day, tekst, tre bokstaver; f.eks. <b>man</b><br /><b>F</b> - måned, tekstlig, lang; f.eks. <b>januar</b><br /><b>g</b> - time, 12-timers format, ingen ledende null; dvs. <b>1</b> til <b>12</b><br /><b>G</b> - time, 24-timers format, ingen ledende null; dvs. <b>0</b> til <b>23</b><br /><b>h</b> - time, 12-timers format, ledende null; dvs. <b>01</b> til <b>12</b><br /><b>H</b> - time, 24-timers format, ledende null; dvs. <b>00</b> til <b>23</b><br /><b>i</b> - minutter, ledende null; dvs. <b>00</b> til <b>59</b><br /><b>I</b> (store «i») - indikator for sommertid; <b>1</b> hvis sommertid, ellers <b>0</b>.<br /><b>j</b> - dag i måneden, ingen ledende null; dvs. <b>1</b> til <b>31</b><br /><b>l</b> (små «L») - ukedag, tekstlig, lang; f.eks. <b>Fredag</b><br /><b>L</b> - skuddårsindikator; <b>1</b> hvis det er et skuddår, <b>0</b> ellers.<br /><b>m</b> - måned, numerisk, ledende null; dvs. <b>01</b> til <b>12</b><br /><b>M</b> - måned, tekst, 3 bokstaver; f.eks. <b>jan</b><br /><b>n</b> - måned, numerisk, ingen ledende null; dvs. <b>1</b> til <b>12</b><br /><b>O</b> (store «o») - forskjellen mellom lokal og Greenwich-tid (GMT) i timer; f.eks. <b>+0200</b><br /><b>r</b> - RFC 2822 formatert dato; f.eks. <b>tor,&nbsp;21&nbsp;des&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - sekunder, ledende null; dvs. <b>00</b> til <b>59</b><br /><b>S</b> - suffikset på dagen i måneden, kun på engelsk, 2 tegn; dvs. <b>st</b>, <b>nd</b>, <b>rd</b> eller <b>th</b>. Fungerer bra med <b>j</b><br /><b>t</b> - antall dager i den gitte måneden; dvs. <b>28</b> til <b>31</b><br /><b>T</b> - tidssoneinnstilling for denne maskinen; f.eks. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - sekunder siden starten på Unix Epoch (1.&nbsp;januar&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - ukedag, numerisk; dvs. <b>0</b> (søndag) til <b>6</b> (lørdag)<br /><b>W</b> - ISO 8601 uke antall år, uker som starter på mandag; f.eks. <b>42</b> (den 42. uken i året)<br /><b>Y</b> - år, 4 sifre; f.eks. <b>1999</b><br /><b>y</b> - år, to sifre; f.eks. <b>99</b><br /><b>z</b> - dag på året, numerisk, ingen ledende nuller; dvs. <b>0</b> (1. januar) til <b>364</b> (31. desember når det ikke er et skuddår) eller <b>365</b> (31. desember i skuddår)<br /><b>Z</b> - tidssone forskjøvet i sekunder. Offset for tidssoner vest for Greenwich er alltid negativt, og for de øst for Greenwich er forskyvningen alltid positiv. dvs. <b>-43200</b> til <b>43200</b><br /><br />Du kan endre rekkefølgen på disse symbolene, og du kan legge til skilletegn i formatet.<br />For eksempel, på tysk inneholder dette feltet vanligvis <b>H:i:s</b> for å produsere som <b>09:01:25</b>.<br />Engelsk definerer tidsformatet som <b>g:i:sa</b> for å produsere som <b>9:01:25am</b>.<br /><br />I 24-timerssystemet er midnatt 00:00. I 12-timerssystemet er midnatt 12:00am og er middag 12:00pm.";
$pgv_lang["week_start"]			= "Ukes startdag";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />Ukedagen som starter en ny uke på dette språket. De fleste språk starter uken på søndag, men noen starter på mandag eller andre dager.";
$pgv_lang["name_reverse"]		= "Etternavn først";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />På noen språk skal etternavnet vises først i stedet for standard for å vise det sist. Hvis du aktiverer dette alternativet, vises etternavnet først. Ungarsk, kinesisk og japansk er eksempler der etternavnet (familienavnet) vanligvis blir gitt først.";
$pgv_lang["ltr"]			= "Venstre til høyre";
$pgv_lang["rtl"]			= "Høyre til venstre";
$pgv_lang["file_does_not_exist"]	= "FEIL! Filen eksisterer ikke...";
$pgv_lang["optional_file_not_exist"]	= "Denne valgfrie filen eksisterer ikke.";
$pgv_lang["alphabet_upper"]		= "Store bokstaver i alfabetet";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Store bokstaver på dette språket. Dette alfabetet brukes når du sorterer lister over navn.";
$pgv_lang["alphabet_lower"]		= "Alfabetet små bokstaver";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Små alfabetbokstaver på dette språket. Dette alfabetet brukes når du sorterer lister over navn.";
$pgv_lang["multi_letter_alphabet"]		= "Alfabet med flere bokstaver";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Kombinasjoner med flere bokstaver som skal behandles som en enkelt bokstav når du sorterer lister over navn og titler på dette språket.<br /><br />Noen språk, for eksempel ungarsk og slovakisk, anser visse bokstavkombinasjoner som forskjellige bokstaver i seg selv. Rekkefølgen du spesifiserer disse bokstavkombinasjonene, bestemmer rekkefølgen de settes inn i det normale alfabetet under sortering. Dette er viktig når flere kombinasjoner med flere bokstaver har samme første bokstav. Med unntak av <b>ch</b>, settes disse bokstavkombinasjonene inn i det normale alfabetet i henhold til deres første bokstav. <b>ch</b> settes alltid inn etter <b>h</b>.";
$pgv_lang["multi_letter_equiv"]		= "Fler bokstavsekvivalenter";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />På noen språk blir flere bokstaver ofte behandlet som ekvivalente med en enkelt bokstav når de genererer lister med navn.<br /><br />For eksempel, på nederlandsk, blir navn som begynner med <b>IJ</b>, oppført sammen med navn som begynner med <b>Y</b>. På norsk, navn som begynner med <b>Aa</b> er oppført med <b>&Aring;</b>. På noen språk er det bokstaver som kan skrives som ett eller to tegn. For eksempel på slovakisk kan de to tegnene D og \xC5\xBE skrives som enkelttegnet \xC7\x85. Ved å spesifisere ekvivalenter her, kan du tillate at navn som begynner med disse bokstavene, grupperes på personlistesidene.<br /><br />Du bør spesifisere en kommaseparert liste med ekvivalenter. For å støtte databaser som ikke gjenkjenner UTF-8-koding, bør du spesifisere både store og små bokstaver. Dette eksemplet viser formatet du skal bruke.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Bruk ordbokregler mens du sorterer";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Dette alternativet styrer hvordan tegn med diakritiske merker håndteres når du sorterer lister med navn og titler.<br /><br />Når det er satt til <b>#pgv_lang[yes]#</b>, behandles alle tegn med diakritiske merker som om de ikke hadde noen merker. Diakritiske tegn blir bare vurdert når de to ordene som vurderes ellers er identiske. Når den er satt til <b>#pgv_lang[no]#</b>, er alle bokstaver forskjellige, uavhengig av tilstedeværelse eller fravær av diakritiske merker.";
$pgv_lang["collation"]		= "Databasesorteringssekvens";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Hvis du bruker databasens innebygde sorteringsregler, spesifiserer dette alternativet sorteringssekvensen som skal brukes for dette språket. Du bør sørge for at databasen din støtter alle sorteringssekvensene du har tenkt å bruke.<br /><br />Bruken av databasesortering styres i konfigurasjonsinnstillingene for nettstedet.";
$pgv_lang["lang_config_write_error"]	= "Feil ved skriving av språkinnstillinger i filen <i>language_settings.php</i>. Kontroller tillatelsene og prøv på nytt.";
$pgv_lang["lang_set_file_read_error"]	= "F E I L !!! Kunne ikke lese <i>language_settings.php</i>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Denne rutinen lar deg legge til et nytt, tidligere utilgjengelig og fullstendig ikke-støttet språk i PhpGedView.<br /><br />Du kan sette opp standardinnstillingene for det nye språket. Disse inkluderer språkregistreringskode, språkretning, ukens start for dette språket, tidsinnstillinger, alfabetet osv.<br /><br />Du vil få mer hjelp til innstillingene til språk som støttes av PhpGedView etter å ha valgt språk og ved å klikke på knappen <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Mer hjelp er tilgjengelig på konfigurasjonssiden for språket.";
$pgv_lang["add_new_lang_button"]	= "Legg til nytt språk";
$pgv_lang["hide_translated"]		= "Skjul oversatt";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Hvis angitt til <b>#pgv_lang[yes]#</b>, vil du bare se meldingene til den valgte språkfilen din som ikke er oversatt. Dette betyr at den nye meldingen <u>ikke</u> vises i målspråklisten.<br /><br />Noen språkfiler inneholder engelsk tekst for forskjellige ikke-oversatte meldinger. Denne rutinen kan ikke identifisere disse ikke-oversatte elementene, siden de allerede er tilstede i målfilen. Antagelsen er: «Hvis meldingen er tilstede i målfilen, må den ha blitt oversatt.»";
$pgv_lang["lang_file_write_error"]	= "F E I L !!! Kunne ikke skrive endringer i den valgte språkfilen. Kontroller skriv tillatelser på <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "F E I L !!! Kan ikke åpne filen <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "Brukernes språk";
$pgv_lang["configured_languages"]	= "Språk som brukes";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Brukerinformasjons migrasjons verktøy";
$pgv_lang["um_proceed"] = "Velg et alternativ eller klikk på lenken nedenfor for å gå tilbake til administrasjonsmenyen";
$pgv_lang["um_creating"] = "Opprette";
$pgv_lang["um_sql_index"] = "Dette verktøyet vil opprette <i>authenticate.php</i> og flere <i>.dat</i> filer i index mappe.<br /><br />Etter vellykket opprettelse kan du bytte til indeksmodus med alle nåværende brukere og deres meldinger, favoritter, nyheter og MyGedview-layout tilgjengelig.<br /><br />Merk: Når du har byttet til indeksmodus, må du importere GEDCOM filene dine igjen.";
$pgv_lang["um_file_create_fail1"] = "Opprettelsen av ny fil mislyktes, en fil med det navnet eksisterer allerede:";
$pgv_lang["um_file_create_fail2"] = "Kan ikke opprette";
$pgv_lang["um_file_create_fail3"] = "Kontroller tilgangsrettighetene i denne mappen.";
$pgv_lang["um_file_create_succ1"] = "Opprettelse av ny fil vellykket:";
$pgv_lang["um_file_not_created"] = "Filen opprettes ikke.";
$pgv_lang["um_nomsg"] = "Ingen meldinger ser ut til å være til stede i systemet.";
$pgv_lang["um_nofav"] = "Ingen favoritter ser ut til å være til stede i systemet.";
$pgv_lang["um_nonews"] = "Ingen nyheter ser ut til å være til stede i systemet.";
$pgv_lang["um_noblocks"] = "Ingen blokker ser ut til å være til stede i systemet.";
$pgv_lang["um_index_sql"] = "Dette verktøyet importerer <i>authenticate.php</i> og andre <i>.dat</i> filer fra indeksmappen til databasen din.";
$pgv_lang["um_noaction"] = "Ingen handling er nødvendig for å overføre brukerinformasjon til SQL-modus.<br /><br />Når du har byttet til SQL-modus, må du starte <b>#pgv_lang[um_header]#</b> på nytt for å importere alle data til SQL-databasen. PhpGedView vil bruke eksisterende filer fra indeksmodus.<br /><br /><b><u>Ikke</u> fjern <i>authenticate.php</i> og <i>.dat</i> filer fra indeksmappen mens du bytter.</b>";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Eksport";
$pgv_lang["um_explain"] = "Dette verktøyet vil enten eksportere brukerdata fra SQL til indeksmodus, eller importere brukerdata fra indeksfiler til SQL-tabeller.<br /><br />Brukerdata, favoritter, blokkdefinisjoner, meldinger og nyheter vil være tilgjengelig igjen etter overføring.<br /><br /><b>FORSIKTIG</b><br />Du kan ikke bruke dette verktøyet til å migrere brukerdata mellom forskjellige versjoner av PhpGedView. Forsikre deg om at dataene stammer fra, eller er importert til samme PhpGedView-versjon.<br /><br /><b>IMPORT</b><br />Hvis du velger å importere brukerdatafilene fra indeksmodus, alle brukerdata som er til stede i databasetabellene blir <u>overskrevet</u>. Dette verktøyet smelter <u>ikke</u> informasjonen. Når du har kjørt Importen, er det ingen måte å hente den gamle informasjonen ved hjelp av PhpGedView.<br /><br /><b>EKSPORT</b><br />Hvis du eksporterer brukerinformasjonen fra SQL-databasen til Indeksmodusfiler, dette verktøyet vil opprette <i>authenticate.php</i> og flere <i>.dat</i> filer i index mappen. Hvis filer med identisk navn allerede er til stede, blir du bedt om de må overskrives. Etter at du har byttet til indeksmodus, vil all informasjon være tilgjengelig direkte.<br /><br /><b>Merk:</b> Etter at du har byttet til indeksmodus, må du importere GEDCOM-filene dine igjen.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrere brukere fra SQL til index modus~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrere brukere fra index til SQL modus~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importerer brukere";
$pgv_lang["um_imp_blocks"] = "Importerer blokker";
$pgv_lang["um_imp_favorites"] = "Importerer favoritter";
$pgv_lang["um_imp_messages"] = "Importerer meldinger";
$pgv_lang["um_imp_news"] = "Importerer nyheter";
$pgv_lang["um_nousers"] = "File <i> authenticate.php </i> ble ikke funnet i index mappen. Migrering avbrytes.";
$pgv_lang["um_imp_succ"] = "Importen vellykket";
$pgv_lang["um_imp_fail"] = "Import mislyktes";
$pgv_lang["um_backup"] = "Sikkerhetskopiering";
$pgv_lang["um_zip_succ"] = "ZIP-filen ble opprettet.";
$pgv_lang["um_zip_dl"] = "Last ned ZIP sikkerhetskopifil ";
$pgv_lang["um_bu_explain"] = "Dette verktøyet kan ta sikkerhetskopi av flere typer data i PhpGedView.<br /><br />Dataene du velger å sikkerhetskopiere, blir samlet i en ZIP fil, som du kan laste ned ved å klikke på lenken nederst på siden sikkerhetskopien er vellykket.<br /><br />ZIP filen blir værende i index mappen til du fjerner den manuelt.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView konfigurasjonsfil";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM filer";
$pgv_lang["um_bu_gedsets"] = "GEDCOM Innstillinger, konfigurasjon og personvernfiler";
$pgv_lang["um_bu_logs"] = "Filer med søkelogger og PhpGedView-loggfiler";
$pgv_lang["um_bu_usinfo"] = "Brukerdefinisjoner, Blokker innstillinger, Favoritter, Meldinger, Nyheter";
$pgv_lang["um_bu_media"]	= "Mediefiler";
$pgv_lang["um_mk_bu"] = "Lag sikkerhetskopi";
$pgv_lang["um_nofiles"] = "Ingen filer funnet for sikkerhetskopiering.";
$pgv_lang["um_files_exist"] = "En eller flere filer eksisterer allerede. Vil du overskrive dem?";
$pgv_lang["um_results"]		= "Resultater";
$pgv_lang["preview_faq_item"] = "Forhåndsvisning av alle FAQ";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br /><br />Dette alternativet lar en administratorbruker se FAQ-siden uten alle redigeringsalternativene og koblingene.<br /><br />Med unntak av en enkelt <b>Rediger</b> lenke over den første FAQ, utseendet til FAQ-siden vil være identisk med hva en vanlig bruker vil se. Denne spesielle <b>rediger</b> lenken vil gjenopprette full redigeringsfunksjonalitet til FAQ-siden.";
$pgv_lang["restore_faq_edits"] = "Gjenopprett FAQ redigeringsfunksjonalitet";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br /><br />Dette alternativet gjenoppretter FAQ siden til det som en administratorbruker normalt ser, slik at individuelle ofte stilte spørsmål kan redigeres.";
$pgv_lang["add_faq_item"] = "Legg til FAQ (vanlige spørsmål)";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br /><br />Dette alternativet lar deg legge til en FAQ på FAQ siden.";
$pgv_lang["edit_faq_item"] = "Rediger FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br /><br />Dette alternativet lar deg redigere FAQ på FAQ siden.";
$pgv_lang["delete_faq_item"] = "Slett FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br /><br />Dette alternativet lar deg slette FAQ fra FAQ siden";
$pgv_lang["moveup_faq_item"] = "Flytt FAQ opp";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br /><br />Dette alternativet lar deg flytte en FAQ opp på FAQ siden.<br /><br />Hver gang du bruker dette alternativet, reduseres posisjonsnummeret til denne FAQ med en. Du kan oppnå den samme effekten ved å redigere spørsmålene i spørsmålet og endre posisjonsfeltet. Når mer enn én FAQ har samme posisjonsnummer, vil bare en av disse være synlige.";
$pgv_lang["movedown_faq_item"] = "Flytt FAQ ned";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br /><br />Dette alternativet lar deg flytte en FAQ nedover på FAQ-siden.<br /><br />Hver gang du bruker dette alternativet, økes posisjonsnummeret til denne FAQ med en. Du kan oppnå den samme effekten ved å redigere spørsmålene i spørsmålet og endre posisjonsfeltet. Når mer enn én FAQ har samme posisjonsnummer, vil bare en av disse være synlige.";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br /><br />Dette er tittelen eller emnet på FAQ.<br /><br />Det du skriver inn her kan formateres. HTML-koder som &lt;b&gt; og &lt;br /&gt; er tillatt, det samme er HTML-enheter som &amp;amp; og &amp;nbsp;. Andre HTML-koder enn &lt;br /&gt; er sannsynligvis ikke veldig nyttige i FAQ-tittelen og bør unngås.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br /><br />The text of the FAQ is entered here.<br /><br />The text can be formatted. HTML tags such as &lt;b&gt; og &lt;br /&gt; are allowed, as are HTML entities such as &amp;amp; og &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "Med HTML-entiteter  har du en veldig enkel metode for å legge til spesialtegn i FAQ-titler og tekst.  Du kan bruke symbolske navn, desimaltall, eller hexadesimale verdier.  En komplett liste over HTML-entiteter, koden, og representasjonen i din nettleser kan du finne her:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML-entitetslister</a><br /><br />Noen ganger, kan det hende du må vise et tilde-tegn&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;eller et tallsymboln&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;i dine URL'er eller tekst.  Disse tegnene har en spesiell funksjon i PhpGedViews hjelpesystem og kan bare legges inn i sin hexadesimale eller desimale form.  Likeledes,&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;og&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;tegn som vanligvis brukes til å lukke HTML-tagger må skrives inn i sin hexadesimale eller desimale former hvis de skal håndteres som normal tekst istedenfor å vise en HTML-tagg.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;eller&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Det finnes en&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML-entitet, men dette tegnet blir ikke tolket som en Tilde når det er kodet i URLer.";
$pgv_lang["add_faq_pgvLangRefs"] = "Du kan sette inn referanser til en oppføring i en språkfil eller til verdier av globale variable.  Eksempler: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;er  en  referanse ttil Språkvariabelen \$pgv_lang[\"add_to_cart\"], og hvis brukt i dette feltet, vil det vises som <b>#pgv_lang[add_to_cart]#</b> når OSS-listen vises i det gjeldende språket.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;er en referanse til faktanavnet \$factarray[\"AFN\"], og hvis det ble brukt i dette feltet ville det vises som <b>#factarray[AFN]#</b> når OSS-listen brukes i det gjeldende språket.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;er en referanse til konstanten PGV_VERSION, et mellomrom og en referanse til konstanten PGV_VERSION_RELEASE, og hvis de skulle vises i dette feltet, ville det vises som <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> når OSS-listen vises i det gjeldende språket.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;er en referanse til den globale variabelen \$GEDCOM, som er navnet på den gjeldende GEDCOM-filen. Brukt i dette feltet, vil det vises som <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp; er en referanse til den globale variabelen \$GEDCOM_TITLE, som er tittelen på den gjeldende GEDCOM-filen.  Brukt i dette feltet, vil det vises som <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Denne funksjonalitet er nyttig når du ønsker å lage OSS-lister som er forskjellige for hver språk nettstedet støtter. Du bør plassere titlene og oppføringene til den tilpassede OSS-listen i <i>languages/extra.xx.php</i>-filen (<i>xx</i> er koden for hvert språk), ved å bruke følgende format:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Dette er et eksempel på OSS-tittel\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Dette er eksempel på et OSS-avsnitt.\";</code>";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br /><br />Dette feltet styrer rekkefølgen FAQs vises i.<br /><br />Du trenger ikke å angi tallene sekvensielt. Hvis du legger igjen hull i nummereringsskjemaet, kan du sette inn andre vanlige spørsmål senere. Hvis du for eksempel bruker tallene 1, 6, 11, 16, kan du senere sette inn vanlige spørsmål med manglende sekvensnumre. Negative tall og null er tillatt, og kan brukes til å sette inn vanlige spørsmål foran den første.<br /><br />Når mer enn en FAQ har samme posisjonsnummer, vil bare en av disse være synlig.";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br /><br />Du kan bestemme om denne FAQ vil være synlig uavhengig av GEDCOM, eller om den bare vil være synlig for gjeldende GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;FAQ vil vises i alle FAQ lister, uavhengig av GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;FAQ kommer bare til å vises i den nåværende aktive GEDCOMs FAQ-liste.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]		= "GEDCOM News-teksten tillater bruk av <b>HTML koder</b> og <b>HTML enheter</b>. HTML bør ikke brukes i Nyhetstitler.<br /><br />Sørg for å alltid bruke både start- og sluttkoder. Det kan hjelpe å ha en forståelse av HTML som passer for en nettsideadministrator. Dette programmet bruker også <b>Cascading Style Sheets (CSS)</b>. En forskjellig CSS er implementert for hvert tema. Du kan bruke klasser fra disse stilarkene for å kontrollere utseendet til meldingene dine.<br /><br />Hvis du trenger mer hjelp med dette, har nettstedet PhpGedView noen eksempler på hvordan du bruker disse kodene i GEDCOM News-blokken din.<br /><br />Som med FAQ-listen, tillater GEDCOM News-titler og News-tekster innebygde referanser til \$pgv_lang, \$factarray og \$GLOBALS variabler for å gi fullstendig fleksibilitet i opprettelsen av nyheter som følsom for det aktive språket.<br /><br />Følgende beskrivelse, hentet fra hjelpeteksten for FAQ-listen, gjelder også for GEDCOM News-artikler.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Maksimalt tid importen får kjøre for behandling av GEDCOM-filen.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Resultater funnet";
$pgv_lang["ged_filter_reset"] = "Fjern søk";
$pgv_lang["ged_filter_description"] = "Tekst du skal søke etter";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br /><br />Dette alternativet lar deg søke i teksten som er knyttet til konfigurasjonsalternativene.<br /><br />Når du skriver bokstaver, finner søket alle konfigurasjonsalternativene som inneholder bokstavsekvensen. Søket blir mer presist når du skriver inn flere bokstaver.";

?>
