<?php
/**
 * Portugese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author José Monteiro
 * @author Maurício Menegazzo Rosa
 * @author Anderson Wilson and Clovis Bombardelli
 * @version $Id: configure_help.pt.php 7328 2022-01-12 18:30:53Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["google_analytics_help"]				= "~#pgv_lang[google_analytics]#~<br /><br />O serviço #pgv_lang[google_analytics]# descrito neste <a href='http://pt.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>Artigo da Wikipedia</a>.<br /><br /> Por favor note que, se você usar este serviço, o Google adquire os direitos de todos os dados que recolhe sobre a atividade do visitante no seu site.";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"]			= "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />Selecione <b>#pgv_lang[yes]#</b> para habilitar o controle da atividade em seu site pelo serviço #pgv_lang[google_analytics]#. Você deve subscrever este serviço antes de ativar essa opção.";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"]			= "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />Digite o número da conta atribuído ao seu site quando você se inscreveu para o serviço #pgv_lang[google_analytics]#. Este número conta o formato <b>UA-xxxxxx-x</b> .";
$pgv_lang["piwik_analytics_help"]				= "~#pgv_lang[piwik_analytics]#~<br /><br />O projeto open-source #pgv_lang[piwik_analytics]# é descrito <a href='https://matomo.org/' target='_blank' title='Matomo official web site'>aqui</a>.<br /><br />Matomo é uma alternativa para #pgv_lang[google_analytics]# que elimina muitas das preocupações com a privacidade. Você pode instalar o aplicativo Matomo em seu próprio servidor web ou em seu próprio domínio, garantindo assim que você tem o controle completo sobre os dados de atividade que foram coletados.";
$pgv_lang["USE_PIWIK_ANALYTICS_help"]			= "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />Selecione <b>#pgv_lang[yes]#</b> para habilitar o controle da atividade em seu site por um servidor #pgv_lang[piwik_analytics]#. Seu site PhpGedView deve ser registrado em um servidor Matomo.";
$pgv_lang["PGV_PIWIK_URL_help"]					= "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />Digite a URL para um servidor onde seu site Matomo PhpGedView está registrado.";
$pgv_lang["PGV_PIWIK_SITE_help"]				= "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />Digite o ID numérico atribuído ao seu site PhpGedView pelo servidor Matomo.";
$pgv_lang["clustrmaps_analytics_help"]			= "~#pgv_lang[clustrmaps_analytics]#~<br /><br />#pgv_lang[clustrmaps_analytics]# é um contador de visitas combinadas, visitante tracker e ferramenta de visualização geográfica.<br /><br />Cada página inclui uma imagem de mapa em miniatura gerada pelo #pgv_lang[clustrmaps_analytics]#. Ao que carrega imagem, um contador no site #pgv_lang[clustrmaps_analytics]# é incrementado. Quando o mapa, que é visível a todos os seus visitantes, é atualizado (diário, semanal ou mensal, dependendo do tráfego) é mostra a localização de todos os visitantes de sua página desde o início de um intervalo de tempo específico.<br /><br />Se você pagou para o serviço #pgv_lang[clustrmaps_analytics]#, clicando em que a imagem revela um mapa em miniatura maior mundo exibição do mapa.<br /><br />Mais detalhes estão disponíveis no <a href='http://www.clustrmaps.com/' target='_blank' title='#pgv_lang[clustrmaps_analytics]# site'>#pgv_lang[clustrmaps_analytics]# site</a>.";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"]		= "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />Selecione <b>#pgv_lang[yes]#</b> para habilitar o controle da atividade em seu site por um servidor #pgv_lang[clustrmaps_analytics]#.";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"]			= "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />Digite a URL do seu site PhpGedView. Este valor tem sido preenchido por você, e você normalmente não precisa mudar ele.";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"]			= "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />Digite o número do servidor designado pelo serviço #pgv_lang[clustrmaps_analytics]# quando ativado sua conta.";

$pgv_lang["SHOW_LIST_PLACES"]					= "Níveis de lugares para mostrar nas listas";
$pgv_lang["SHOW_LIST_PLACES_help"]				= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Isso determina quanto das informações do local é mostrado nos campos do local nas listas.<br /><br />Definir o valor para <b>9</b> garantirá que todas as informações do local serão mostradas. Definir o valor como <b>0</b> (zero) ocultará os lugares completamente. Definir o valor como <b>1</b> mostrará o nível mais alto, que normalmente é o país. Definir como <b>2</b> mostrará os dois níveis superiores. O segundo nível mais alto, abaixo do país, costuma ser o estado, a província ou o território. Etc.";

$pgv_lang["new_gedcom_title"]					= "Genealogia de #GEDCOMFILE#";
$pgv_lang["keep_media_help"]					= "~#pgv_lang[keep_media]#~<br /><br />Os links de mídia existentes devem ser retidos no banco de dados quando um GEDCOM substituto estiver sendo carregado. A opção <b>#pgv_lang[no]#</b> remove links de mídia existentes do banco de dados, enquanto a opção <b>#pgv_lang[yes]#</b> os mantém.<br /><br />Esta opção é útil quando você exporta seu GEDCOM de PhpGedView para um programa de manutenção GEDCOM off-line que não funciona com embutido ponteiros de mídia corretamente e, em seguida, reimporte esse GEDCOM alterado para PhpGedView. Sob tais circunstâncias, os ponteiros de mídia dentro do GEDCOM que você exportou para o seu programa de edição off-line são destruídos e você teria que vincular novamente todos os seus arquivos de mídia aos registros de Pessoa, Família e Fonte adequados depois de reimportar o GEDCOM em PhpGedView.<br /><br />A opção <b>#pgv_lang[yes]#</b> diz ao PhpGedView para manter os links de mídia existentes para que você não tenha que recriá-los depois de importar o GEDCOM alterado, mas isso requer que o programa de edição off-line sempre produza a mesma pessoa, família e identificação de origem números.<br /><br /><i>Family Tree Maker</i> é um dos vários programas de edição off-line que <u>não</u> manipula corretamente os ponteiros de objeto de mídia no GEDCOM. <i>Legacy</i>, entre muitos outros, <u>faz</u> os trata adequadamente.";
$pgv_lang["USE_MEDIA_VIEWER"]					= "Use visualizador de mídia";
$pgv_lang["USE_MEDIA_VIEWER_help"]				= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Quando esta opção é <b>#pgv_lang[yes]#</b>, clicar nas imagens irá produzir a página do visualizador de mídia. Esta página mostra os detalhes da imagem. Se você tiver direitos suficientes, também pode editar esses detalhes.<br /><br />Quando esta opção for <b>#pgv_lang[no]#</b>, clicar nas imagens irá produzir uma imagem em tamanho real em uma nova janela.";
$pgv_lang["USE_MEDIA_FIREWALL"]					= "Use firewall de mídia";
$pgv_lang["USE_MEDIA_FIREWALL_help"]			= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Consulte o Wiki para obter uma descrição de como usar o firewall de mídia. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]				= "Diretório Raiz para firewall de mídia";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]		= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Diretório no qual o diretório de mídia protegido pode ser criado.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]		= "Quando este campo estiver vazio, o diretório <b>#GLOBALS[INDEX_DIRECTORY]#</b> será usado.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]				= "Proteja miniaturas de imagens protegidas";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]			= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Quando uma imagem está no diretório de mídia protegido, sua miniatura também deve ser protegida?";
$pgv_lang["SHOW_SPIDER_TAGLINE"]				= "Mostrar slogan da máquina de pesquisae";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]			= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Em páginas geradas para mecanismos de pesquisa, exiba como última linha o mecanismo de pesquisa específico que a página detectou. Se esta opção estiver ativada, pode influenciar o Google&reg; AdSense para ferramentas de otimização de mecanismo de pesquisa.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"]	= "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Esta opção manterá os laços familiares nos registros privatizados. Isso significa que você verá caixas «#pgv_lang[private]#» vazias no gráfico de linhagem e em outros gráficos com pessoas privadas.<br /><br />Esta configuração está desativada por padrão. Recomenda-se, em vez de ativar isso, apontar sua pessoa raiz do pedigree em sua configuração GEDCOM para uma pessoa que não seja particular.";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]			= "Mostrar relacionamentos privados";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 				= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />Definir este valor como <b>#pgv_lang[yes]#</b> atualizará automaticamente o arquivo GEDCOM quando as alterações forem aceitas no banco de dados. Isso manterá o arquivo GEDCOM sincronizado com o banco de dados.<br /><br />Você pode querer mudá-lo para <b>#pgv_lang[no]#</b> para melhorar a velocidade do programa e economizar memória ao aceitar alterações.";
$pgv_lang["SYNC_GEDCOM_FILE"]					= "Sincronizar edições no arquivo GEDCOM";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]			= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Esta opção restringe ou não o uso da pesquisa Multi-Site aos usuários identificados. A pesquisa Multi-Site procura a informação nos sites cadastrados em \"Gerenciar Sites\" e nos sites remotos.";
$pgv_lang["SHOW_MULTISITE_SEARCH"]				= "Exibir Pesquisa Multi-Site";
$pgv_lang["SHOW_NO_WATERMARK"]					= "Quem pode visualizar imagens sem marca d'água?";
$pgv_lang["SHOW_NO_WATERMARK_help"]				= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Se o firewall de mídia estiver habilitado, os usuários verão marcas d'água se não tiverem o nível de privilégio especificado aqui.";
$pgv_lang["WATERMARK_THUMB"]					= "Adicionar marcas d'água às miniaturas?";
$pgv_lang["WATERMARK_THUMB_help"]				= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Se o firewall de mídia estiver habilitado, as miniaturas devem ter marca d'água? Suas listas de mídia carregarão mais rápido se você não colocar marcas d'água nas miniaturas.";
$pgv_lang["SAVE_WATERMARK_THUMB"]				= "Armazenar miniaturas com marca d'água no servidor?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]			= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Se o Firewall de mídia estiver habilitado, as cópias das miniaturas com marca d'água devem ser armazenadas no servidor além das mesmas miniaturas sem marcas d'água?<br /><br />Quando definido como <b>#pgv_lang[yes]#</b>, as listas de mídia contendo miniaturas com marca d'água serão produzidas mais rapidamente em à custa de maiores requisitos de espaço em disco do servidor.";
$pgv_lang["SAVE_WATERMARK_IMAGE"]				= "Armazenar imagens em tamanho real com marca d'água no servidor?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]			= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Se o firewall de mídia estiver ativado, as cópias das imagens com marca d'água em tamanho real devem ser armazenadas no servidor, além das mesmas imagens sem marcas d'água?<br /><br />Quando definido como <b>#pgv_lang[yes]#</b>, as imagens em tamanho real com marca d'água serão produzidas mais rapidamente às custas de maiores requisitos de espaço em disco do servidor.";
$pgv_lang["DB_UTF8_COLLATION"]					= "Use o banco de dados para fornecer agrupamento UTF-8";
$pgv_lang["DB_UTF8_COLLATION_help"]				= "Controla se PhpGedView deve usar os recursos integrados de classificação e agrupamento do banco de dados. Geralmente é mais rápido usar o banco de dados para classificar e filtrar dados em vez de PHP, embora nem todos os bancos de dados / versões forneçam esse recurso. A sequência de intercalação usada para cada idioma é definida na página de configurações desse idioma.<br /><br /><span class=\"warning\">IMPORTANTE: Você só deve definir este valor como <b>#pgv_lang[yes]#</b> se o fizer ANTES de as tabelas do banco de dados serem criadas pela primeira vez. Selecioná-lo em um banco de dados existente pode fazer com que seus dados sejam corrompidos.</span><br /><br />O MySQL e o PostgreSQL oferecem um bom suporte para UTF-8, embora nem todas as sequências de agrupamento estejam disponíveis nas versões anteriores do MySQL. Outros bancos de dados oferecem pouco ou nenhum suporte para UTF-8. Se você não tiver certeza do suporte do seu banco de dados para UTF-8, defina esse valor como <b>#pgv_lang[no]#</b>.<br /><br />Este <a href='https://pt.wikipedia.org/wiki/UTF-8' target='_blank' title='artigo da Wikipedia'><b>artigo da Wikipedia</b></a> contém informações abrangentes e links sobre UTF-8. ";
$pgv_lang["INDI_FACTS_ADD"]						= "Fatos/Eventos da Pessoa";
$pgv_lang["INDI_FACTS_ADD_help"]				= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Esta é a lista de fatos que os usuários podem adicionar às pessoas da árvore. Você pode criar novos tipos ou remover alguns deles conforme sua necessidade. Tipos de fatos que aperecem nesta lista não devem aparecer na lista <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.";
$pgv_lang["INDI_FACTS_UNIQUE"]					= "Fatos Singulares da Pessoa";
$pgv_lang["INDI_FACTS_UNIQUE_help"]				= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Esta é a lista de fatos que podem ser adicionados <u>uma única vez</u> a uma pessoa. Fatos que estejam nesta lista não podem estar na lista <i>#pgv_lang[INDI_FACTS_ADD]#</i>.";
$pgv_lang["INDI_FACTS_QUICK"] 					= "Fatos Rápidos da Pessoa";
$pgv_lang["INDI_FACTS_QUICK_help"]				= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Esta é a pequena lista de fatos pessoais GEDCOM que aparece ao lado da lista completa e pode ser adicionada com um único clique.";
$pgv_lang["FAM_FACTS_ADD"]						= "Fatos da Família";
$pgv_lang["FAM_FACTS_ADD_help"]					= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Estes são os fatos que podem ser adicionados às famílias. É permitido adicionar ou remover fatos a lista, mesmo os customizados. Entretanto fatos que estejam nesta lista, não podem aparecer na lista <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.";
$pgv_lang["FAM_FACTS_UNIQUE"]					= "Fatos Singulares da Família";
$pgv_lang["FAM_FACTS_UNIQUE_help"]				= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Esta é a lista de fatos da família, que os usuários podem adicionar uma <u>única</u> vez. Por exemplo, se MARR esta na lista, usuários não poderão adicionar mais de um MARR à família. Fatos que estejam nesta lista não podem estar na lista <i>#pgv_lang[FAM_FACTS_ADD]#</i>.";
$pgv_lang["FAM_FACTS_QUICK"] 					= "Fatos Rápidos da Família";
$pgv_lang["FAM_FACTS_QUICK_help"]				= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Esta é a pequena lista de fatos da família GEDCOM que aparece ao lado da lista completa e pode ser adicionada com um único clique.";
$pgv_lang["SOUR_FACTS_ADD"]						= "Fatos/Eventos de Fonte";
$pgv_lang["SOUR_FACTS_ADD_help"]				= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Esta é a lista de fatos que os usuários podem adicionar a uma fonte. A lista pode ser alterada, inclusive com a adição de eventos e fatos customisados, porém fatos e eventos desta lista não podem estar na lista <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.";
$pgv_lang["SOUR_FACTS_UNIQUE"]					= "Fatos Singulares de Fonte";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]				= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Esta é a lista de fatos de fontes, que os usuário podem adicionar uma <u>única</u> vez. Por exemplo, se TITL esta na lista, usuários poderão adicionar apenas uma vez TITL a uma fonte. Fatos e eventos desta lista não podem estar na lista <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.";
$pgv_lang["SOUR_FACTS_QUICK"] 					= "Fatos Rápidos de Fonte";
$pgv_lang["SOUR_FACTS_QUICK_help"]				= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Esta é a pequena lista de fatos de fontes GEDCOM que aparece ao lado da lista completa e pode ser adicionada com um único clique.";
$pgv_lang["REPO_FACTS_ADD"] 					= "Adicionar Fatos de Repositório";
$pgv_lang["REPO_FACTS_ADD_help"]				= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Esta é a lista de fatos GEDCOM que seus usuários podem adicionar aos repositórios. Você pode modificar essa lista removendo ou adicionando nomes de fatos, mesmo personalizados, conforme necessário. Os nomes dos fatos que aparecem nesta lista não devem aparecer também na lista <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.";
$pgv_lang["REPO_FACTS_UNIQUE"] 					= "Fatos Singulares de Repositório";
$pgv_lang["REPO_FACTS_UNIQUE_help"]				= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Esta é a lista de fatos GEDCOM que seus usuários só podem adicionar <u>única</u> vez aos repositórios. Por exemplo, se NAME estiver nesta lista, os usuários não poderão adicionar mais de um registro NAME a um repositório. Os nomes dos fatos que aparecem nesta lista não devem aparecer também na lista <i>#pgv_lang[REPO_FACTS_ADD]#</i>.";
$pgv_lang["REPO_FACTS_QUICK"] 					= "Fatos Rápidos de Repositório";
$pgv_lang["REPO_FACTS_QUICK_help"]				= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Esta é a pequena lista de fatos de repositório GEDCOM que aparece ao lado da lista completa e pode ser adicionada com um único clique.";
$pgv_lang["LANG_SELECTION_help"]				= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Selecione na lista, quais idiomas seu site PhpGedView oferecerá aos usuários.<br />O mesmo pode ser feito através do link <b>#pgv_lang[enable_disable_lang]#</b> no menu #pgv_lang[admin]#, onde também é possível alterar a bandeira do idioma, o formato de datas, ou se o sobrenome deve aparecer antes do nome.";
$pgv_lang["MEDIA_ID_PREFIX"]					= "Prefixo da ID da Mídia";
$pgv_lang["MEDIA_ID_PREFIX_help"]				= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Quando uma mídia é adicionada ao GEDCOM, uma nova ID é criada automaticamente para a mídia.";
$pgv_lang["FAM_ID_PREFIX"]						= "Prefixo da ID da Família";
$pgv_lang["FAM_ID_PREFIX_help"]					= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Quando um novo registro é adicionado à família, uma nova ID é atribuida a este registro com este prefixo.";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fatos da Família sempre exibidios na Edição Simplificada";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Esta é uma lista de fatos e eventos separados por virgula, que sempre serão exibidos no formulário de edição simplificada, mesmo que estes fatos ainda não tenho sido informados.";
$pgv_lang["QUICK_ADD_FAMFACTS"]					= "Fatos da Família sempre exibidios na Edição Simplificada";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]			= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Esta é uma lista separada por vírgulas de tags de fatos GEDCOM que serão mostradas nas guias Família do formulário de Atualização Rápida. Apenas os fatos desta lista serão mostrados no formulário ou disponibilizados para seleção na área onde você adicionar novos fatos ao formulário.";
$pgv_lang["QUICK_REQUIRED_FACTS"]				= "Fatos exibidos na Edição Simplificada";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]			= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Esta é uma lista separada por vírgulas de tags de fatos GEDCOM que sempre serão mostradas no formulário de Atualização Rápida, independentemente de já existirem ou não no registro da pessoa. Por exemplo, se o BIRT estiver na lista, os campos para data e local de nascimento sempre serão exibidos no formulário.";
$pgv_lang["QUICK_ADD_FACTS"]					= "Fatos exibidos na Edição Simplificada";
$pgv_lang["QUICK_ADD_FACTS_help"]				= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Esta é uma lista separada por vírgulas de tags de fatos GEDCOM que serão mostradas no formulário de Atualização Rápida. Apenas os fatos desta lista serão mostrados no formulário ou disponibilizados para seleção na área onde você adicionar novos fatos ao formulário.";
$pgv_lang["SURNAME_TRADITION_help"] 			= "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Quando você adiciona novos membros a uma família, PhpGedView pode fornecer valores padrão para sobrenomes de acordo com o costume regional.<br /><br /><ul><li>Na tradição <b>Paterna</b>, todos os membros da família compartilham o sobrenome do pai.</li><li>Na tradição <b>espanhola</b> e <b>portuguesa</b>, as crianças recebem um sobrenome de cada pai.</li><li>Na tradição <b>islandesa</b>, os filhos recebem o nome do pai como sobrenome, com um sufixo que denota gênero.</li><li>Na tradição <b>polonesa</b>, todos os membros da família compartilham o sobrenome do pai. Para alguns sobrenomes, o sufixo indica gênero. Os sufixos <i>ski</i>, <i>cki</i>, e <i>dzki</i> indicam homem, enquanto os sufixos correspondentes <i>ska</i>, <i>cka</i>, e <i>dzka</i> indicam mulheres.</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] 			= "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Esta é uma lista separada por vírgulas de tags de fatos GEDCOM que serão mostradas no formulário de adicionar / editar nome. Se você usar alfabetos não latinos, como hebraico, grego, cirílico ou árabe, pode adicionar marcas como _HEB, ROMN, FONE, etc. para permitir que você armazene nomes em vários alfabetos diferentes.";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] 			= "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Esta é uma lista separada por vírgulas de tags de fatos GEDCOM que serão mostradas quando você adicionar ou editar nomes de lugares. Se você usar alfabetos não latinos, como hebraico, grego, cirílico ou árabe, pode adicionar tags como _HEB, ROMN, FONE, etc. para permitir que você armazene nomes de lugares em vários alfabetos diferentes.";
$pgv_lang["GEONAMES_KEY"]						= "ID de usuário geonames.org";
$pgv_lang["GEONAMES_KEY_help"]					= "~#pgv_lang[GEONAMES_KEY]#~<br /><br />Este ID de usuário é necessário para acessar o banco de dados geonames.org gratuito de nomes geográficos. Se você não fornecer um ID de usuário válido, você não poderá pesquisar este banco de dados.<br /><br />Você pode solicitar um ID de usuário geonames.org na <a href='http://www.geonames.org/login' target='_blank'><b>página de login do geonames.org</b></a>.<br /><br />Você receberá um e-mail com um link de confirmação e, após ter confirmado o e-mail, poderá habilitar sua conta para o serviço da web na <a href='http://www.geonames.org/manageaccount' target='_blank'><b>página de sua conta</b></a>.";
$pgv_lang["GEONAMES_BIAS"]						= "Enviesamento do País geonames.org";
$pgv_lang["GEONAMES_BIAS_help"]					= "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />Normalmente, a pesquisa do banco de dados GeoNames apresenta seus resultados em ordem alfabética, independentemente do país em que o local está localizado. Esta opção especifica que os locais localizados no país selecionado devem ser relatados no topo da lista de resultados.";
$pgv_lang["GEONAMES_BIAS_no_preference"]		= "Sem preferência";
$pgv_lang["GEOCODE_KEY"]						= "Chave do servidor Google Geocode";
$pgv_lang["GEOCODE_KEY_help"]					= "~#pgv_lang[GEOCODE_KEY]#~<br /><br />Essa chave é necessária para acessar o banco de dados gratuito de nomes geográficos do Google. Se você não fornecer uma chave válida, não será possível pesquisar neste banco de dados.<br /><br />Você pode solicitar uma chave por meio do <a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'><b>Google Developer Console</b></a>. Você pode visualizar esta página em um idioma diferente do inglês, escolhendo o idioma desejado na parte inferior da página.";
$pgv_lang["AUTO_GENERATE_THUMBS"]				= "Miniaturas geradas automaticamente";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]			= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />O sistema deve gerar miniaturas automaticamente para imagens que não as possuem. Sua instalação do PHP pode não suportar esta funcionalidade.";
$pgv_lang["phpinfo_help"]						= "~#pgv_lang[phpinfo]#~<br /><br />Esta página fornece informações abrangentes sobre o servidor no qual o PhpGedView está sendo hospedado. Muitos detalhes de configuração sobre o software do servidor, no que se refere a PHP e PhpGedView, podem ser visualizados.";
$pgv_lang["config_help_help"]					= "~#pgv_lang[config_help]#~<br /><br />Esta página reúne todos os principais tópicos da Ajuda de configuração em um só lugar. Você pode ver as informações na tela ou imprimi-las para uso posterior.";
$pgv_lang["more_help_advice"]					= "<b>Mais Ajuda</b><br />Mais ajuda pode ser obtida clicando em <b>#pgv_lang[qm]#</b> ao lado dos itens da página.";
$pgv_lang["THUMBNAIL_WIDTH"]					= "Largura das Miniaturas geradas";
$pgv_lang["THUMBNAIL_WIDTH_help"]				= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Esta é a largura (em pixels) que o programa usará ao gerar miniaturas automaticamente. A configuração padrão é 100.";
$pgv_lang["USE_SILHOUETTE"]						= "Use silhuetas";
$pgv_lang["USE_SILHOUETTE_help"]				= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Use imagens de silhueta quando nenhuma imagem destacada para essa pessoa tiver sido especificada. As imagens utilizadas são específicas ao gênero da pessoa em questão.<br /><br /><table><tr><td wrap valign=\"middle\">Esta imagem pode ser usada quando o sexo da pessoa é desconhecido:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table>";
$pgv_lang["SHOW_SOURCES"]						= "Exibir Fontes";
$pgv_lang["SHOW_SOURCES_help"]					= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Defina o nível de acesso de privacidade para todas as fontes. Se o usuário não tiver acesso às Fontes, a lista de Fontes será removida do menu Listas e a guia Fontes não será exibida na página <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Se a opção <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> estiver habilitada, essa configuração controla se o administrador deve aprovar o registro.<br /><br />Definir como <b>#pgv_lang[yes]#</b> exigirá que todos os novos usuários primeiro verifiquem a si mesmos e, em seguida, sejam aprovados por um administrador antes de poderem fazer o login. Com esta configuração em <b>#pgv_lang[no]#</b>, a caixa <b>#pgv_lang[verified_by_admin]#</b> será marcada automaticamente quando os usuários verificarem sua conta, permitindo assim um login imediato sem intervenção do administrador.";
$pgv_lang["SPLIT_PLACES"]						= "Na edição, \"quebre\" os Locais";
$pgv_lang["SPLIT_PLACES_help"]					= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Defina como <b>#pgv_lang[yes]#</b> para dividir cada nome de local por vírgulas em subcampos para edição mais fácil. Exemplo:<br /><ol><li>Modo padrão<br /><u>Lugar</u>: Half Moon Bay, San Mateo, California, USA</li><br /><li>Modo de divisão<br /><u>País</u>: USA<br /><u>Estado</u>: California<br /><u>Condado</u>: San Mateo<br /><u>Cidade</u>: Half Moon Bay</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]				= "Sublinhe nomes entre aspas";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]			= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Muitos programas colocarão o nome preferencial entre aspas (<b>\"</b>) no GEDCOM. A convenção usual para isso é sublinhar o nome dado preferido. Ativar esta opção converterá todos os nomes entre aspas para &lt;span&gt; com uma classe CSS de 'starredname'.<br /><br />Por exemplo, se o nome no GEDCOM fosse<br /><br /> ativando esta opção mudaria a parte do nome entre aspas para &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; para impressão. Dependendo de outras configurações, o navegador exibiria esse nome como <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> ou <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]					= "Respeitar e Usar a restrição a priovacidade do GEDCOM (RESN)";
$pgv_lang["PRIVACY_BY_RESN_help"]				= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />A especificação GEDCOM 5.5.1 inclui a opção de usar tags RESN para definir opções de privacidade para pessoas e fatos no arquivo GEDCOM. Ativar esta opção instruirá o programa a procurar tags RESN de nível 1 nos registros GEDCOM. As tags RESN de nível 2+ são aplicadas automaticamente e não serão afetadas por esta configuração. Observe que isso pode desacelerar algumas das funções do PhpGedView, como a lista de pessoas.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]					= "Mostra os códigos de ordenança da igreja SUD nas caixas de gráfico";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]			= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Definir esta opção para <b>#pgv_lang[sim]#</b> mostrará os códigos de status para as ordenanças SUD nas caixas de gráfico.<ul><li><b>B</b> - Batismo</li><li><b>E</b> - Dotado</li><li><b>S</b> - Selado ao esposo</li><li><b>P</b> - Selado aos pais</li></ul>Uma pessoa que tiver todas as ordenanças realizadas terá <b>BESP</b> impresso após seu nome. As ordenanças ausentes são indicadas por <b>_</b> no lugar do código da letra correspondente. Por exemplo, <b>BE__</b> indica que faltam as ordenanças <b>S</b> e <b>P</b>.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]					= "A ficha que será exibida primeiro na página «Detalhes Pessoais»";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]			= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Esta opção permite escolher qual guia abre automaticamente na página «Detalhes Pessoais» quando essa página é acessada.";
$pgv_lang["SHOW_MARRIED_NAMES"]					= "Exibir nome de casada na lista de Pessoas";
$pgv_lang["SHOW_MARRIED_NAMES_help"]			= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Esta opção mostrará os nomes de casados de mulheres na lista de Pessoas. Esta opção requer que você calcule os nomes de casados ao importar o arquivo GEDCOM.";
$pgv_lang["SHOW_QUICK_RESN"]					= "Exibir campos no formulário #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]				= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Esta opção permite ativar ou desativar os campos de privacidade no formulário #pgv_lang[quick_update_title]#. Os campos de privacidade permitem que um usuário que está adicionando informações por meio do formulário substitua a privacidade padrão pelo fato de estar inserindo.";
$pgv_lang["USE_QUICK_UPDATE"]					= "Usar formulário #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]				= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Esta opção determina os privilégios do usuário necessários para enviar alterações através do formulário #pgv_lang[quick_update_title]#.<br /><br />A opção <b>#pgv_lang[nobody]#</b> significa que este formulário não pode ser usado de forma alguma.";
$pgv_lang["SEARCHLOG_CREATE"]					= "Arquivar arquivos SearchLog";
$pgv_lang["SEARCHLOG_CREATE_help"]				= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Com que freqüência o programa deve arquivar os arquivos SearchLog.";
$pgv_lang["CHANGELOG_CREATE"]					= "Arquivar arquivos ChangeLog";
$pgv_lang["CHANGELOG_CREATE_help"]				= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Com que freqüência o programa deve arquivar os arquivos ChangeLog.";
$pgv_lang["CHART_BOX_TAGS"]						= "Outros fatos a exibir nos gráficos";
$pgv_lang["CHART_BOX_TAGS_help"]				= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Deve ser uma lista de fatos separados por vírgulas ou espaços, além de Nascimento e Morte, que você deseja que apareça nas caixas do gráfico, como o Gráfico de Linhagem. Esta lista requer o uso de tags de fatos conforme definido no padrão GEDCOM 5.5.1. Por exemplo, se você deseja que a ocupação apareça na caixa, você deve adicionar «OCCU» a este campo.";
$pgv_lang["FULL_SOURCES"]						= "Use citações de fonte completa";
$pgv_lang["FULL_SOURCES_help"]					= "~#pgv_lang[FULL_SOURCES]#~<br /><br />As citações de fontes podem incluir campos para registrar a qualidade dos dados (primários, secundários, etc.) e a data em que o evento foi registrado na fonte. Se você não usar esses campos, poderá desativá-los ao criar novas citações de fontes.";
$pgv_lang["PREFER_LEVEL2_SOURCES"]				= "Tipo de fonte";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]			= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Ao adicionar novos parentes próximos, você pode adicionar citações de fontes aos registros (por exemplo, INDI, FAM) ou aos fatos (BIRT, MARR, DEAT). Esta opção controla quais caixas são marcadas por padrão.";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]						= "Fundamentos GEDCOM";
$pgv_lang["media_conf"]							= "Mídias";
$pgv_lang["media_general_conf"]					= "Geral";
$pgv_lang["media_firewall_conf"]				= "Firewall de Mídia";
$pgv_lang["accpriv_conf"]						= "Acesso e Privacidade";
$pgv_lang["displ_conf"]							= "Exibição, Formatação, e Relatórios";
$pgv_lang["displ_names_conf"]					= "Nomes";
$pgv_lang["displ_comsurn_conf"]					= "Sobrenomes Comuns";
$pgv_lang["displ_layout_conf"]					= "Formatação";
$pgv_lang["displ_hide_conf"]					= "Exibir ou Esconder";
$pgv_lang["displ_reports"]						= "Relatórios";
$pgv_lang["editopt_conf"]						= "Opções de Edição";
$pgv_lang["useropt_conf"]						= "Opções do Usuário";
$pgv_lang["contact_conf"]						= "Informação para Contato";
$pgv_lang["meta_conf"]							= "Configurações do site e da tag META";
$pgv_lang["gedconf_head"]						= "Configuração GEDCOM";
$pgv_lang["other_theme"]						= "Outro, informe";
$pgv_lang["performing_update"]					= "Executando atualização.";
$pgv_lang["config_file_read"]					= "Arquivo de configuração lido.";
$pgv_lang["does_not_exist"]						= "não existe";
$pgv_lang["media_drive_letter"]					= "A localização da Mídia não deve conter a letra do drive; a mídia pode não ser exibida.";
$pgv_lang["db_setup_bad"]						= "A configuração atual do seu banco de dados está com defeito. Verifique os parâmetros de conexão do banco de dados e configure novamente.";
$pgv_lang["bad_host_user_pass"]					= "PhpGedView não conseguiu estabelecer uma conexão com o host do seu banco de dados. Verifique o host, o nome de usuário e a senha para certificar-se de que estão corretos.";
$pgv_lang["bad_database_name"]					= "PhpGedView fez uma conexão com seu host de banco de dados, mas não conseguiu usar o banco de dados com o nome que você digitou. Verifique se o banco de dados existe e se o nome de usuário inserido possui as permissões apropriadas nesse banco de dados.";
$pgv_lang["db"]									= "Banco de Dados";
$pgv_lang["current_gedcoms"]					= "GEDCOMs Cadastrados";
$pgv_lang["ged_gedcom"]							= "Arquivo GEDCOM";
$pgv_lang["ged_title"]							= "Título GEDCOM";
$pgv_lang["ged_config"]							= "Arquivo de Configuração";
$pgv_lang["ged_search"]							= "Arquivos SearchLog";
$pgv_lang["ged_change"]							= "Arquivos ChangeLog";
$pgv_lang["ged_privacy"]						= "Arquivo de Privacidade";
$pgv_lang["disabled"]							= "Desativado";
$pgv_lang["mouseover"]							= "Se Mouse Em Cima";
$pgv_lang["mousedown"]							= "Se Mouse Pressionado";
$pgv_lang["click"]								= "Ao Clicar";
$pgv_lang["enter_db_pass"]						= "Por segurança, informe #pgv_lang[DBUSER]# e #pgv_lang[DBPASS]# antes de alterar a configuração.";
$pgv_lang["server_url_note"]					= "Este deve ser o URL para sua pasta PhpGedView. Você só deve alterar essa configuração se tiver certeza de que sabe o que está fazendo. PhpGedView determinou que este valor é <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]								= "Tipo de Banco de Dados";
$pgv_lang["DBTYPE_help"]						= "~#pgv_lang[DBTYPE]#~<br /><br />O tipo de banco de dados ao qual se conectar.<br /><br />PhpGedView pode usar qualquer banco de dados que tenha um driver PDO disponível. Você precisa garantir que seu arquivo php.ini carregue a biblioteca <b>php_pdo</b> e o driver apropriado para seu banco de dados, por exemplo, <b>php_pdo_mysql</b>.<br /><br />A maioria dos bancos de dados requer um nome de usuário e senha. Você também precisa criar o banco de dados antes de instalar o PhpGedView. No entanto, o SQLite não precisa de #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, ou #pgv_lang[DBPASS]#, mas você precisará definir um caminho de arquivo para seu banco de dados no campo #pgv_lang[DBNAME]#. PhpGedView criará o arquivo de banco de dados SQLite para você.";
$pgv_lang["DBHOST"]								= "Servidor de Banco de Dados";
$pgv_lang["DBHOST_help"]						= "~#pgv_lang[DBHOST]#~<br /><br />O DNS ou endereço IP do computador que hospeda seu servidor de banco de dados. Esta configuração é ignorada se você estiver usando um banco de dados SQLite.";
$pgv_lang["DBPORT"]								= "Port de banco de dados";
$pgv_lang["DBPORT_help"]						= "~#pgv_lang[DBPORT]#~<br /><br />A port TCP que deve ser usada ao se conectar ao servidor de banco de dados. Deixe esta configuração em branco para usar a porta padrão para seu tipo específico de banco de dados. Esta configuração é ignorada se você estiver usando um banco de dados SQLite.";
$pgv_lang["DBUSER"]								= "Nome de usuário do banco de dados";
$pgv_lang["DBUSER_help"]						= "~#pgv_lang[DBUSER]#~<br /><br />O nome de usuário do banco de dados necessário para fazer login em seu banco de dados. Esta configuração é ignorada se você estiver usando um banco de dados SQLite.";
$pgv_lang["DBPASS"]								= "Senha do banco de dados";
$pgv_lang["DBPASS_help"]						= "~#pgv_lang[DBPASS]#~<br /><br />A senha do banco de dados para o usuário que você inseriu no campo #pgv_lang[DBUSER]#. Esta configuração é ignorada se você estiver usando um banco de dados SQLite.";
$pgv_lang["DBNAME"]								= "Nome do Banco de Dados";
$pgv_lang["DBNAME_help"]						= "~#pgv_lang[DBNAME]#~<br /><br />O banco de dados no servidor que você deseja que o PhpGedView use.<br /><br />O nome de usuário inserido no campo #pgv_lang[DBUSER]# deve ter privilégios de Criar, Inserir, Atualizar, Excluir e Selecionar neste banco de dados. No SQLite você precisa definir isso para um nome de arquivo em um diretório que seja gravável pelo PHP como o seu diretório index (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]						= "~#pgv_lang[TBLPREFIX]#~<br /><br />Um prefixo para os nomes das tabelas criadas por PhpGedView. Ao alterar este valor, você pode configurar vários sites PhpGedView para usar o mesmo banco de dados físico, mas tabelas diferentes. Por exemplo, o mesmo site pode hospedar um «teste» bem como uma instalação de «produção» do PhpGedView com tabelas de dados completamente independentes.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]			= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Se você tiver um ambiente com vários GEDCOMs, definir este valor como <b>#pgv_lang[yes]#</b> permite que os visitantes do site <u>e</u> usuários tenham a opção de alterar os GEDCOMs. Definir como <b>#pgv_lang[no]#</b> desativa a alternância GEDCOM para visitantes <u>e</u> usuários conectados.";
$pgv_lang["upload_path"]						= "Pasta de destino";
$pgv_lang["upload_path_help"]					= "~#pgv_lang[upload_path]#~<br /><br />Este é o caminho onde o arquivo GEDCOM que você deseja carregar pode ser encontrado. Para selecionar o caminho, clique em <b>Procurar</b>, navegue até o arquivo GEDCOM e clique em <b>Abrir</b>.";
$pgv_lang["gedcom_path"]						= "Localização e nome do GEDCOM no servidor";
$pgv_lang["gedcom_path_help"]					= "~#pgv_lang[gedcom_path]#~<br /><br />Existem duas maneiras de importar seu arquivo GEDCOM para o PhpGedView. Eles são:<ol><li>FTP o arquivo para o servidor</li><li>Upload em PhpGedView</li></ol>Quando o seu arquivo já existe no servidor, você ativa o procedimento <i>#pgv_lang[add_gedcom]#</i> e preenche o caminho e o nome do seu arquivo GEDCOM conforme existem no servidor. O nome pode ser com ou sem extensão. Se nenhuma extensão for fornecida, .ged será assumido. O caminho é opcional. Se nenhum caminho for fornecido, o valor da opção <i>#pgv_lang[INDEX_DIRECTORY]#</i>, conforme definido na configuração do seu site PhpGedView, será usado. Observe que, na maioria dos servidores, os nomes de arquivo e caminho diferenciam maiúsculas de minúsculas.<br /><br />Quando você ativa o procedimento <i>#pgv_lang[upload_gedcom]#</i> embutido no PhpGedView, você pode usar o botão <b>Procurar</b> para localizar o arquivo desejado em seu computador local. Pode ser um arquivo GEDCOM normal ou um arquivo ZIP contendo o arquivo GEDCOM. PhpGedView irá extrair automaticamente e então usar o arquivo GEDCOM contido nesse arquivo ZIP.<br /><br />Ao enviar um arquivo, é possível especificar um caminho alternativo e / ou nome de arquivo para salvá-lo no servidor.<br /><br />Consulte o arquivo <a href=\"readme.txt\">Readme.txt</a> para obter mais informações.";
$pgv_lang["CHARACTER_SET"]						= "Codificação do Conjunto de Caracteres";
$pgv_lang["CHARACTER_SET_help"]					= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Este é o conjunto de caracteres do seu arquivo GEDCOM. UTF-8 é o padrão e deve funcionar para quase todos os sites. Se você exportar seu GEDCOM usando a codificação IBM Windows, você deve colocar WINDOWS aqui.<br /><br />NOTA: PhpGedView não pode suportar UNICODE (UTF-16) porque o suporte está faltando no PHP.";
$pgv_lang["LANGUAGE"]							= "Idioma";
$pgv_lang["LANGUAGE_help"]						= "~#pgv_lang[LANGUAGE]#~<br /><br />Assign the default language for the site.<br /><br />Quando a opção <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> é definida, os usuários podem substituir essa configuração por meio da configuração de idioma preferencial de seu navegador, opções de configuração em sua página de conta ou por meio de links ou botões na maioria das páginas PhpGedView.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]				= "Permitir a troca de idioma";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]			= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Defina como <b>#pgv_lang[yes]#</b> para permitir que os usuários substituam o idioma padrão do site. Eles podem fazer isso por meio da configuração de idioma preferencial de seu navegador, opções de configuração em sua página de conta ou por meio de links ou botões na maioria das páginas do PhpGedView.";
$pgv_lang["CALENDAR_FORMAT"]					= "Formato do Calendário";
$pgv_lang["CALENDAR_FORMAT_help"]				= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />As datas podem ser registradas em vários calendários, como Gregoriano, Juliano ou o Calendário Judaico. Esta opção permite converter datas em um calendário preferido. Por exemplo, você pode selecionar Gregoriano para converter as datas Julianas e Hebraicas em Gregorianas. A data convertida é mostrada entre parênteses após a data normal.<br /><br />As datas só são convertidas se forem válidas para o calendário. Por exemplo, apenas as datas entre 22&nbsp;SEP&nbsp;1792 e 31&nbsp;DEC&nbsp;1805 serão convertidas para o calendário republicano francês e somente datas após 15&nbsp;OCT&nbsp;1582 serão convertidas para o calendário gregoriano.<br /><br />Hebraico é o mesmo que judeu, mas usando caracteres hebraicos. Árabe é o mesmo que Hijri, mas usando caracteres árabes.<br /><br />Nota: Como o dia do calendário judaico e islâmico começa ao anoitecer, qualquer evento ocorrendo do anoitecer até a meia-noite será exibido como um dia antes da data correta. A exibição de hebraico e árabe pode ser problemática em navegadores antigos, que podem exibir o texto ao contrário (da esquerda para a direita) ou nem exibir.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]			= "Exibir Milhares em Hebráico";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]		= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Mostrar Alafim em calendários hebraicos.<br /><br />Definir como <b>#pgv_lang[yes]#</b> exibirá o ano de 1969 como <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; enquanto configurá-lo para <b>#pgv_lang[no]#</b> exibirá o ano como <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Isso não tem impacto no cenário do ano judaico. O ano será exibido como 5729, independentemente desta configuração.<br /><br />Nota: Esta configuração é semelhante à constante CAL_JEWISH_ADD_ALAFIM.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]			= "Mostrar Gershayim em Hebráico";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]		= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Mostrar aspas simples e duplas («'» e «\"») ao exibir datas hebraicas.<br /><br />Definir isso para <b>#pgv_lang[yes]#</b> exibirá 8&nbsp;FEB&nbsp;1969 como <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; enquanto configurá-lo para <b>#pgv_lang[no]#</b> irá exibi-lo como <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Isso não tem impacto sobre a configuração do ano judaico, pois as aspas não são usadas em datas judaicas exibidas com caracteres latinos.<br /><br />Nota: Esta configuração é semelhante às constantes de calendário CAL_JEWISH_ADD_ALAFIM_GERESH e CAL_JEWISH_ADD_GERESHAYIM. Esta única configuração afeta ambos.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]		= "Pronúncia de judeu Ashkenazi";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Quando definido como <b>#pgv_lang[yes]#</b>, os meses Cheshvan e Teves serão escritos com a pronúncia Ashkenazi. Definir como <b>#pgv_lang[no]#</b> mudará os meses para Hesvan e Tevet. Isso afeta apenas o ambiente judaico. A configuração hebraica sempre usará o alfabeto hebraico.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]		= "Gerações genealógicas";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Defina o número padrão de gerações para exibir nos gráficos de Descendência e Linhagem.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]			= "Gerações de pedigree máximas";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]		= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Defina o número máximo de gerações para exibir nos gráficos de linhagem.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]		= "Máximo de gerações de Descendentes";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Defina o número máximo de gerações para exibir nos gráficos de descendência.";
$pgv_lang["SOSA_WIDTH_NORMAL"]		= "Largura normal dos números SOSA";
$pgv_lang["SOSA_WIDTH_NORMAL_help"]	= "~#pgv_lang[SOSA_WIDTH_NORMAL]#~<br /><br />Quanto espaço deve ser reservado para números SOSA nos gráficos<br /><br /><b>#pgv_lang[variable]#</b> indica que a largura não é fixa e o número SOSA impresso ocupará o mesmo espaço como precisa. O resto do gráfico será posicionado de acordo.";
$pgv_lang["SOSA_WIDTH_WIDE"]		= "Largura extra dos números SOSA";
$pgv_lang["SOSA_WIDTH_WIDE_help"]	= "~#pgv_lang[SOSA_WIDTH_WIDE]#~<br /><br />Quanto espaço deve ser reservado para números SOSA na visualização de livreto do gráfico de Descendência<br /><br /><b>#pgv_lang[variable]#</b> indica que a largura não é fixa e o número SOSA impresso ocupará o mesmo espaço como precisa. O resto do gráfico será posicionado de acordo.";
$pgv_lang["USE_RIN"]							= "Use o número RIN em vez do ID GEDCOM";
$pgv_lang["USE_RIN_help"]						= "~#pgv_lang[USE_RIN]#~<br /><br />Defina como <b>#pgv_lang[yes]#</b> para usar o número RIN em vez do ID GEDCOM quando solicitado por IDs de pessoa em arquivos de configuração, configurações de usuário e gráficos. Isso é útil para programas de genealogia que não exportam consistentemente GEDCOMs com o mesmo ID atribuído a cada indivíduo, mas sempre usam o mesmo RIN.";
$pgv_lang["GENERATE_GUID"]						= "Crie automaticamente IDs globalmente únicos";
$pgv_lang["GENERATE_GUID_help"]					= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b>, neste contexto, é um acrônimo para «Globally Unique ID» (identificador globalmente único).<br /><br />Os GUID têm como objetivo ajudar a identificar cada indivíduo de uma maneira que seja repetível, para que organizações centrais, como o Centro de História da Família da Igreja SUD em Salt Lake City, ou mesmo programas compatíveis em execução em seu próprio servidor, podem determinar se estão lidando com a mesma pessoa, independentemente de onde o GEDCOM se origina. O objetivo do Centro de História da Família é ter um repositório central de dados genealógicos e expô-lo por meio de serviços da web. Isso permitirá que qualquer programa acesse os dados e atualize seus dados dentro deles.<br /><br />Se você não pretende compartilhar este GEDCOM com mais ninguém, não precisa permitir que o PhpGedView crie esses GUIDs; no entanto, isso não causará nenhum dano, a não ser aumentar o tamanho do seu GEDCOM.";
$pgv_lang["PEDIGREE_ROOT_ID"]					= "Pessoa padrão para gráficos de linhagem e descendência";
$pgv_lang["PEDIGREE_ROOT_ID_help"]				= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Defina o identificador da pessoa padrão para exibir nos gráficos de Linhagem e Descendência.";
$pgv_lang["GEDCOM_ID_PREFIX"]					= "Prefixo do identificador de pessoa";
$pgv_lang["GEDCOM_ID_PREFIX_help"]				= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Quando um novo registro de pessoa é adicionado online no PhpGedView, um novo identificador para essa pessoa será gerado automaticamente. O identificador de pessoa terá este prefixo.";
$pgv_lang["SOURCE_ID_PREFIX"]					= "Prefixo do identificador de origem";
$pgv_lang["SOURCE_ID_PREFIX_help"]				= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Quando um novo registro de fonte é adicionado online no PhpGedView, um novo identificador para aquela fonte será gerado automaticamente. O identificador de origem terá este prefixo.";
$pgv_lang["REPO_ID_PREFIX"]						= "Prefixo do identificador de repositório";
$pgv_lang["REPO_ID_PREFIX_help"]				= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Quando um novo registro de repositório é adicionado online no PhpGedView, um novo identificador para aquele repositório será gerado automaticamente. O identificador do repositório terá este prefixo.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]				= "Mostrar detalhes de nascimento e morte em gráficos";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]			= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Esta opção controla se deve ou não mostrar os detalhes de nascimento e morte de um indivíduo nos gráficos.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]				= "Mostrar ícone de gênero nos gráficos";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]			= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Esta opção controla a exibição ou não do ícone de gênero do indivíduo nos gráficos.<br /><br />Como o gênero também é indicado pela cor da caixa, esta opção não esconde o gênero. A opção simplesmente remove algumas informações duplicadas da caixa.";
$pgv_lang["PEDIGREE_LAYOUT"]					= "Layout de gráfico de linhagem padrão";
$pgv_lang["PEDIGREE_LAYOUT_help"]				= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Esta opção indica se o gráfico de linhagem deve ser gerado no modo paisagem ou retrato.";
$pgv_lang["SHOW_EMPTY_BOXES"]					= "Exibir caixas vazias no gráfico";
$pgv_lang["SHOW_EMPTY_BOXES_help"]				= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Esta opção controla se deve ou não mostrar caixas vazias nos gráficos de linhagem.";
$pgv_lang["ZOOM_BOXES"]							= "Caixas de zoom em gráficos";
$pgv_lang["ZOOM_BOXES_help"]					= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Permite que o usuário amplie as caixas nos gráficos para obter mais informações.<br /><br />Defina como <b>#pgv_lang[disabled]#</b> para desativar este recurso. Defina como <b>#pgv_lang[mouseover]#</b> para aplicar zoom nas caixas quando o usuário passar o mouse sobre o ícone na caixa. Defina como <b>#pgv_lang[click]#</b> para aplicar zoom nas caixas quando o usuário clicar no ícone da caixa.";
$pgv_lang["LINK_ICONS"]							= "Mostrar links em gráficos";
$pgv_lang["LINK_ICONS_help"]					= "~#pgv_lang[LINK_ICONS]#~<br /><br />Permite que o usuário selecione links para outros gráficos e parentes próximos da pessoa.<br /><br />Defina como <b>#pgv_lang[disabled]#</b> para desativar este recurso. Defina como <b>#pgv_lang[mouseover]#</b> para fazer com que os links apareçam quando o usuário passa o mouse sobre o ícone na caixa. Defina como <b>#pgv_lang[click]#</b> para fazer com que os links apareçam quando o usuário clicar no ícone da caixa.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Abreviar títulos do gráfico";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Esta opção controla se deve ou não abreviar rótulos como <b>Nascimento</b> em gráficos apenas com a primeira letra, como <b>N</b>.<br /><br />Você pode personalizar as abreviações fornecendo substituindo valores no arquivo <i>languages/extra.xx.php</i> para cada idioma. Por exemplo, se você deseja usar <b>*</b> em vez de <b>N</b> para abreviar o fato BIRT no idioma francês, você deve colocar a seguinte entrada no arquivo <i>languages/extra.fr.php</i>:<br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />Os comprimentos das abreviações especificadas desta forma não são limitados a 1 caractere.";
$pgv_lang["SHOW_AGE_DIFF"]						= "Mostrar diferenças de data ";
$pgv_lang["SHOW_AGE_DIFF_help"]					= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Esta opção controla se a guia Parentes Próximos deve ou não mostrar diferenças entre as datas de nascimento dos cônjuges, entre a data de casamento e a data de nascimento do primeiro filho e entre as datas de nascimento dos filhos.";
$pgv_lang["SHOW_PARENTS_AGE"]					= "Exibir idade dos pais ao lado da data de nascimento";
$pgv_lang["SHOW_PARENTS_AGE_help"]				= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Esta opção controla se deve ou não mostrar a idade do pai e da mãe ao lado da data de nascimento da criança nos gráficos.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]				= "Exibir eventos dos parentes próximos na página «Detalhes Pessoais»";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] 		= "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Nascimentos, casamentos e mortes de parentes são eventos importantes na vida de uma pessoa. Esta opção controla se esses eventos devem ou não ser mostrados na guia «Dados Pessoais e Detalhes» na página «Detalhes Pessoais».<br /><br />Os eventos afetados por esta opção são:<ul><li>Morte do esposo</li><li>Nascimento e morte de crianças</li><li>Morte de pais</li><li>Nascimento e morte de irmãos</li><li>Morte de avós</li><li>Nascimento e morte de irmãos dos pais</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]			= "Expandir automaticamente lista de eventos";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] 		= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Esta opção controla se deve ou não expandir automaticamente a lista <i>Eventos de parentes próximos</i>.";
$pgv_lang["EXPAND_SOURCES"]						= "Expandir automaticamente Fontes";
$pgv_lang["EXPAND_SOURCES_help"] 				= "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Esta opção controla se deve ou não exibir automaticamente o conteúdo de um registro <i>Fonte</i> na página <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["EXPAND_NOTES"]      					= "Expandir notas automaticamente";
$pgv_lang["EXPAND_NOTES_help"] 					= "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Esta opção controla se deve ou não exibir automaticamente o conteúdo de um registro <i>NOTE</i> na página <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["SHOW_LEVEL2_NOTES"]      			= "Mostrar todas as referências de Notas e Fontes nas guias Notas e Fontes";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] 			= "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Esta opção controla se as notas e referências de fontes anexadas aos fatos devem ser mostradas nas guias Notas e Fontes da página <i>#pgv_lang[personal_details]#</i>.<br /><br />Normalmente, as guias Notas e Fontes mostram apenas notas e referências de fontes que são anexados diretamente ao registro do banco de dados da pessoa. Estas são referências de notas e fontes de <i>nível 1</i>.<br /><br />A opção <b>#pgv_lang[yes]#</b> faz com que essas guias também mostrem notas e referências de fontes que fazem parte dos vários Fatos do registro do banco de dados da pessoa. Estas são as notas de <i>nível 2</i> e referências de fontes porque os vários fatos estão no nível 1.";
$pgv_lang["HIDE_LIVE_PEOPLE"]					= "Habilitar privacidade";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]				= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Esta opção irá habilitar todas as configurações de privacidade e ocultar os detalhes de pessoas vivas.<br /><br />Pessoas vivas são definidas como aquelas que não têm um evento mais recente do que o número de anos especificado na configuração <b>#pgv_lang[MAX_ALIVE_AGE]#</b>, que atualmente é <b>#GLOBALS[MAX_ALIVE_AGE]#</b>. Para este efeito, os nascimentos de crianças também são considerados eventos desse tipo.";
$pgv_lang["REQUIRE_AUTHENTICATION"]				= "Visitantes devem identificar-se";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]		= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Habilitar esta opção forçará todos os visitantes a fazer o login antes que eles possam visualizar quaisquer dados no site.";
$pgv_lang["PAGE_AFTER_LOGIN"]					= "Página para mostrar após o login";
$pgv_lang["PAGE_AFTER_LOGIN_help"]				= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Qual página os usuários devem ver depois de fazer login?<br /><br />A escolha feita aqui determina se um login bem-sucedido faz com que a página Bem-vindo ou MyGedView apareça quando o login é feito a partir do #pgv_lang[welcome_page]#.<br /><br />Um Login feito a partir do link no topo de todas as outras páginas retornará o usuário a essa página.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]				= "Texto de boas-vindas da página de identificação do modo Autenticador";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]		= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Aqui você pode escolher o texto a ser exibido na tela de login. Você deve determinar qual texto predefinido é mais apropriado.<br /><br />Você também pode optar por inserir seu próprio texto de boas-vindas personalizado, mas o texto inserido não será traduzido quando os usuários mudarem de idioma. No entanto, se seu texto personalizado contém referências a variáveis de idioma que você pode definir nos vários arquivos <i>languages/extra.xx.php</i>, seu site pode mostrar o texto traduzido. Consulte o texto de ajuda associado ao campo <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> para obter mais informações.<br /><br />Os textos predefinidos são:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]		= "Sem texto predefinido";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]		= "texto informando que qualquer um pode solicitar uma conta";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]		= "texto informando que o admin. aceitará ou não a solictação de conta";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]		= "texto informando que somente famíliares serão aceitos";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]		= "Exibir o texto abaixo como sendo o texto de boas-vindas";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]		= "Texto de boas-vindas personalizado";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Se você optou por um texto de boas-vindas personalizado, pode digitar esse texto aqui. O texto NÃO será traduzido para o idioma do visitante, mas será mostrado exatamente como você o digitou. No entanto, se o seu texto personalizado contém referências a variáveis de idioma que você pode definir nos vários arquivos <i>languages/extra.xx.php</i>, seu site pode mostrar o texto traduzido.<br /><br />Você pode inserir tags HTML em seu texto de boas-vindas personalizado.<br /><br />A descrição a seguir, retirada do texto de Ajuda da lista de perguntas frequentes, é igualmente aplicável ao texto de boas-vindas personalizado.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] 	= "Cabeçalho padrão para texto de boas-vindas personalizado";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Escolha exibir um cabeçalho padrão para seu texto de boas-vindas personalizado. Quando seus usuários mudarem de idioma, este cabeçalho aparecerá no novo idioma.<br /><br />Se definido como <b>#pgv_lang[yes]#</b>, o cabeçalho terá a seguinte aparência:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]				= "Mostrar acordo de uso aceitável na página «Solicitar nova conta de usuário»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]			= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Quando definido como <b>#pgv_lang[yes]#</b>, a seguinte mensagem aparecerá acima dos campos de entrada na página <i>#pgv_lang[requestaccount]#</i>:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]					= "Verificar data dos filhos";
$pgv_lang["CHECK_CHILD_DATES_help"]				= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Verifique as datas das crianças ao determinar se uma pessoa está morta. Em sistemas mais antigos e grandes GEDCOMs, isso pode diminuir o tempo de resposta do seu site.";
$pgv_lang["MAX_ALIVE_AGE"]						= "Pessoas serão consideradas falecidas a partir desta idade";
$pgv_lang["MAX_ALIVE_AGE_help"]					= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Se esta pessoa tiver qualquer evento diferente de morte, sepultamento ou cremação mais recente do que este número de anos, ela é considerada «viva». As datas de nascimento das crianças são consideradas eventos para este fim.";
$pgv_lang["SHOW_GEDCOM_RECORD"]					= "Exibir os registros do GEDCOM para os usuários";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]			= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Definir como <b>#pgv_lang[yes]#</b> colocará links em páginas de pessoas, fontes e famílias para permitir que os usuários abram outra janela contendo os dados brutos retirados diretamente do arquivo GEDCOM.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]					= "Permitir edição online";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]				= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Esta opção ativa recursos de edição online para este banco de dados para que os usuários com privilégios de edição possam atualizar os dados online.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]				= "Ativar preenchimento automático";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]			= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Esta opção determina se o Autocomplete deve estar ativo enquanto as informações são inseridas em determinados campos nos formulários de entrada. Quando esta opção é definida para <b>#pgv_lang[yes]#</b>, os campos de entrada de texto para os quais o Autocomplete é possível são indicados por um fundo de cor diferente.<br /><br />Quando o Autocomplete está ativo, PhpGedView irá pesquisar em seu banco de dados por possíveis correspondências de acordo com o que você já entrou. Conforme você insere mais informações, a lista de correspondências possíveis é refinada. Ao ver a entrada desejada na lista de correspondências, você pode mover o cursor do mouse para essa linha da lista e clicar com o botão esquerdo do mouse para completar a entrada.<br /><br />As desvantagens do preenchimento automático são que ele retarda o programa, envolve uma atividade significativa do banco de dados e também resulta no envio de mais dados ao navegador.";
$pgv_lang["USE_REFN"]		= "Use o Número de Referência";
$pgv_lang["USE_REFN_help"]	= "~#pgv_lang[USE_REFN]#~<br /><br />Esta opção determina se o #factarray[REFN]# inserido nos detalhes de uma <u>nova</u> pessoa deve ser usado como o número de identificação dessa nova pessoa.<br /><br />Quando esta opção é definida para <b>#pgv_lang[yes]#</b>, o #factarray[REFN]# inserido deve seguir as regras estabelecidas para todos os números de ID, e uma pessoa com esse ID ainda não deve existir no base de dados. Se essas condições não forem atendidas, ou quando esta opção for configurada para <b>#pgv_lang[no]#</b>, PhpGedView atribuirá automaticamente o próximo número de ID disponível para essa nova pessoa.<br /><br />Os números de ID válidos podem conter apenas as letras <b>A</b> a <b>Z</b>, <b>a</b> a <b>z</b>, dígitos <b>0</b> a <b>9</b e os símbolos especiais <b>. : -</b> e <b>_</b><br /><br />Você também deve habilitar a exibição do #factarray[REFN]# adicionando a entrada <b>REFN</b> às opções de configuração <b>#pgv_lang[INDI_FACTS_UNIQUE]#</b>, <b>#pgv_lang[INDI_FACTS_QUICK]#</b> e <b>#pgv_lang[QUICK_REQUIRED_FACTS]#</b> abaixo.";
$pgv_lang["EDIT_AUTOCLOSE"]						= "Fechamento automático da janela de edição.";
$pgv_lang["EDIT_AUTOCLOSE_help"]				= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Esta opção controla se a janela Editar deve ou não ser fechada automaticamente após uma atualização bem-sucedida.";
$pgv_lang["INDEX_DIRECTORY_help"]				= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />O caminho para um diretório legível e gravável onde PhpGedView deve armazenar arquivo index/ (incluindo o «/» à direita). PhpGedView não exige que o nome deste diretório seja «index/». Você pode escolher qualquer nome que desejar.<br /><br />Por segurança, este diretório deve ser colocado em algum lugar no espaço de arquivo do servidor que não seja acessível pela Internet. Um exemplo de tal estrutura segue:<br /><br />PhpGedView: dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Para o exemplo mostrado, você digitaria <b>../../dir4/dir5/dir6/index/</b> neste campo.";
$pgv_lang["POSTAL_CODE"]  						= "Posição do Código Postal";
$pgv_lang["POSTAL_CODE_help"] 					= "~#pgv_lang[POSTAL_CODE]#~<br /><br />Países diferentes usam maneiras diferentes de escrever o endereço. Esta opção permitirá que você coloque o código postal antes ou depois do nome da cidade.";
$pgv_lang["SUBLIST_TRIGGER_I"]					= "Número máximo de sobrenomes";
$pgv_lang["SUBLIST_TRIGGER_I_help"]				= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Listas longas de pessoas com o mesmo sobrenome podem ser divididas em sub-listas menores, de acordo com a primeira letra do nome da pessoa.<br /><br />Esta opção determina quando ocorrerá a sublista de sobrenomes. Para desativar completamente a sublistagem, defina esta opção como zero.";
$pgv_lang["SUBLIST_TRIGGER_F"]					= "Número máximo de nomes de famílias";
$pgv_lang["SUBLIST_TRIGGER_F_help"]				= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Listas longas de famílias com o mesmo nome podem ser divididas em sub-listas menores de acordo com a primeira letra do nome fornecido.<br /><br />Esta opção determina quando a sub-listagem de sobrenomes ocorrerá. Para desativar completamente a sublistagem, defina esta opção como zero.";
$pgv_lang["SURNAME_LIST_STYLE"]					= "Estilo da lista de apelidos";
$pgv_lang["SURNAME_LIST_STYLE_help"]			= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />As listas de sobrenomes, conforme aparecem no bloco #pgv_lang[block_top10]# e #pgv_lang[individual_list]# e #pgv_lang[family_list]#, podem ser exibidas em estilos diferentes.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;Neste estilo, os sobrenomes são apresentados em uma tabela que pode ser ordenada por sobrenome ou por contagem.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;Neste estilo, os sobrenomes são mostrados em uma lista, e o tamanho da fonte usada para cada nome depende do número de ocorrências desse nome no banco de dados. A lista não é classificável.</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"]				= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Esta opção controla se os números de ID devem ou não ser mostrados entre parênteses após nomes em gráficos e listas.";
$pgv_lang["SHOW_LAST_CHANGE"]					= "Mostrar data da última alteração nas listas";
$pgv_lang["SHOW_LAST_CHANGE_help"]				= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Esta opção controla se deve ou não mostrar a data da última alteração nas listas.";
$pgv_lang["SHOW_EST_LIST_DATES"]				= "Mostrar datas estimadas de nascimento e morte";
$pgv_lang["SHOW_EST_LIST_DATES_help"]			= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Esta opção controla se deve ou não mostrar datas estimadas de nascimento e morte em vez de deixar espaços em branco nas listas de pessoas e gráficos para pessoas cujas datas são desconhecidas.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]				= "Níveis de lugares para mostrar caixas pessoais";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]			= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Isso define quanto da informação de lugar é mostrado nas caixas de pessoa nos gráficos.<br /><br />Definir o valor para 9 garantirá a exibição de todos os níveis de lugar. Definir o valor como 0 ocultará os lugares completamente. Definir o valor como 1 mostrará o primeiro nível, configurá-lo como 2 mostrará os primeiros dois níveis, etc.";
$pgv_lang["pageSizeDefault"]			= "Tamanho de página padrão";
$pgv_lang["pageSizeDefault_help"]		= "~#pgv_lang[pageSizeDefault]#~<br /><br />Este é o tamanho de página padrão para todos os relatórios. Sua escolha pode ser substituída nos relatórios individuais.";
$pgv_lang["pageSizeOptions"]			= "Tamanhos de página";
$pgv_lang["pageSizeOptions_help"]		= "~#pgv_lang[pageSizeOptions]#~<br /><br />Esta é a lista de tamanhos de página atualmente suportados pelo PhpGedView ao gerar relatórios. Você pode estender essa lista adicionando outros tamanhos de página padrão, conforme listado na <a href='https://pt.wikipedia.org/wiki/Tamanho_de_papel' title='Artigo Wikipedia' target='_blank'><b>Artigo Wikipedia</b></a><br /><ul><li>O tamanho de página padrão para a maior parte do mundo é <b>A4</b>, que corresponde a 210 x 297 mm (8,3 x 11,7 pol.)</li><li>O tamanho de página padrão norte-americano é <b>letter</b>, que corresponde a 216 x 279 mm (8,5 x 11,0 pol.)</li><li>Outros tamanhos disponíveis são <b>A3</b>, que corresponde a 297 x 420 mm (11,7 x 16,5 pol.)</li><li>e <b>legal</b>, que corresponde a 216 x 356 mm (8,5 x 14,0 pol.)</li></ul><br />Recomenda-se cuidado ao adicionar tamanhos de papel diferentes daqueles na lista ISO «A»; nem todos os tamanhos padrão ISO foram testados.";
$pgv_lang["fontsDefault"]				= "Fonte padrão";
$pgv_lang["fontsDefault_help"]			= "~#pgv_lang[fontsDefault]#~<br /><br />Esta é a fonte padrão para todos os relatórios. Sua escolha pode ser substituída nos relatórios individuais.";
$pgv_lang["fontsOptions"]				= "Fontes";
$pgv_lang["fontsOptions_help"]			= "~#pgv_lang[fontsOptions]#~<br /><br />Esta é a lista de fontes atualmente suportadas pelo PhpGedView ao gerar relatórios.<br /><br />Você pode estender esta lista ou encurtá-la conforme necessário. Recomenda-se cuidado ao estender esta lista; nem todas as fontes encontradas na biblioteca <i>includes/tcpdf/fonts</i> foram testadas.";
$pgv_lang["MULTI_MEDIA"]						= "Habilitar recursos para Mídias";
$pgv_lang["MULTI_MEDIA_help"]					= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />O GEDCOM 5.5.1 permite vincular fotos, vídeos e outros objetos multimídia ao GEDCOM. Se você não incluir objetos multimídia em seu GEDCOM, poderá desabilitar os recursos multimídia configurando este valor para <b>#pgv_lang[no]#</b>.<br /><br />Consulte a seção Multimídia no arquivo <a href=\"readme.txt\">readme.txt</a> para obter mais informações sobre como incluir mídia em seu local.";
$pgv_lang["MEDIA_EXTERNAL"]						= "Guardar links";
$pgv_lang["MEDIA_EXTERNAL_help"]				= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Quando um link de multimídia é encontrado começando com, por exemplo, http://, ftp://, mms:// ele não será alterado quando definido como <b>#pgv_lang[yes]#</b>. Por exemplo, http://www.minhafamilia.com/foto/papai.jpg permanecerá http://www.minhafamilia.com/foto/papai.jpg. Quando definido como <b>#pgv_lang[no]#</b>, o link será tratado como uma referência padrão e a profundidade da mídia será usada. Por exemplo: http://www.minhafamilia.com/photo/papai.jpg será alterado para ./media/papai.jpg";
$pgv_lang["MEDIA_DIRECTORY"]					= "Pasta de Mídias";
$pgv_lang["MEDIA_DIRECTORY_help"]				= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />O caminho para um diretório legível e gravável onde PhpGedView deve armazenar arquivos de mídia (incluindo o «/» à direita). PhpGedView não requer que o nome deste diretório seja «media». Você pode escolher qualquer nome que desejar.<br /><br />Mesmo que o recurso firewall de mídia permita que você armazene arquivos de mídia em uma área do espaço de arquivo do servidor que não é acessível pela Internet, o diretório nomeado aqui ainda deve existir e deve ser legível na Internet e gravável pelo PhpGedView. Para obter mais informações, consulte as opções de configuração do firewall de mídia na seção Multimídia da página de configuração GEDCOM.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]				= "Número de sub-níveis da pasta de Mídias";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]		= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Um valor de 0 irá ignorar todos os diretórios no caminho do arquivo para o objeto de mídia. Um valor de 1 manterá o primeiro diretório que contém esta imagem. Aumentar os números aumenta o número de diretórios pais a serem retidos no caminho.<br /><br />Por exemplo, se você vincular uma imagem em seu GEDCOM a um caminho como <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, um valor de 0 traduzirá este caminho para <b>./media/grandpa.jpg</b>. Um valor de 1 irá traduzir isso para <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc. A maioria das pessoas só precisará usar um 0. No entanto, é possível que alguns objetos de mídia mantidos em diretórios diferentes têm nomes idênticos e se sobrescreveriam quando essa opção fosse definida como 0. Configurações diferentes de zero permitem que você mantenha alguma organização em sua mídia, evitando assim colisões de nomes.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]			= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Se você habilitou a multimídia em seu site, você pode fazer com que o PhpGedView exiba uma imagem em miniatura ao lado do nome da pessoa em gráficos e caixas.<br /><br />Consulte a seção Multimídia no arquivo <a href=\"readme.txt\">readme.txt</a> para obter mais informações sobre como incluir mídia em seu site.";
$pgv_lang["USE_THUMBS_MAIN"]					= "Usar miniatura da imagem principal na página de indivíduos";
$pgv_lang["USE_THUMBS_MAIN_help"]				= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Esta opção determina se PhpGedView deve enviar a imagem grande ou pequena para o navegador sempre que um gráfico ou a página <i>#pgv_lang[personal_details]#</i> exigir uma miniatura.<br /><br />A escolha <b>#pgv_lang[no]#</b> fará com que o PhpGedView envie a imagem grande, enquanto a escolha <b>#pgv_lang[yes]#</b> fará com que a imagem pequena seja enviada. Cada imagem individual também tem a opção «#factarray[_THUM]#» que, quando configurada para <b>#pgv_lang[yes]#</b>, fará com que a imagem grande seja enviada independentemente da configuração da opção «#pgv_lang[USE_THUMBS_MAIN]#» na configuração GEDCOM. Você não pode forçar o PhpGedView a enviar imagens pequenas quando a configuração GEDCOM especifica que imagens grandes sempre devem ser usadas.<br /><br />PhpGedView não redimensiona a imagem que está sendo enviada; o navegador faz isso de acordo com as especificações da página que também recebeu. Isso pode ter consequências indesejáveis quando a imagem que está sendo enviada não é realmente uma miniatura para a qual o PhpGedView espera enviar uma pequena imagem. Isso não é um erro: há ocasiões em que pode ser desejável exibir uma imagem grande em locais onde normalmente se esperaria ver uma imagem em miniatura.<br /><br />Você deve evitar definir a opção «#pgv_lang[USE_THUMBS_MAIN]#» como <b>#pgv_lang[no]#</b>. Essa escolha fará com que quantidades excessivas de dados relacionados à imagem sejam enviados ao navegador, apenas para que o navegador descarte o excesso. O carregamento de páginas, especialmente de gráficos com muitas imagens, pode ser seriamente retardado.";
$pgv_lang["SHOW_MEDIA_FILENAME"]				= "Mostrar o nome do arquivo no visualizador de mídia";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]			= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />O visualizador de mídia pode mostrar o nome do arquivo de mídia que está sendo visualizado. Esta opção determina se o nome do arquivo é mostrado aos usuários ou não.<br /><br />Você pode ocultar o nome do arquivo por razões de segurança.";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]				= "Mostrar link de download no visualizador de mídia";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]			= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />O visualizador de mídia pode mostrar um link que, quando clicado, fará o download do arquivo de mídia para o PC local.<br /><br />Você pode ocultar o link de download por motivos de segurança.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]				= "Habilitar carrinho de recortes";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]			= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />O carrinho de recortes permite que os usuários adicionem pessoas a um arquivo temporário, que podem ser baixados no formato GEDCOM para posterior importação para o software de genealogia.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]					= "Não exibir erros do GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]			= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Definir como <b>#pgv_lang[yes]#</b> ocultará as mensagens de erro produzidas pelo PhpGedView quando ele não entender uma tag em seu arquivo GEDCOM. PhpGedView faz todos os esforços para estar em conformidade com o padrão GEDCOM 5.5.1, mas muitos programas de software de genealogia incluem suas próprias tags personalizadas. Consulte o arquivo <a href=\"readme.txt\">readme.txt</a> para obter mais informações.";
$pgv_lang["WORD_WRAPPED_NOTES"]					= "Adicionar espaços para notas excluídas ";
$pgv_lang["WORD_WRAPPED_NOTES_help"]			= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Alguns programas de genealogia envolvem notas nos limites das palavras, enquanto outros embrulham notas em qualquer lugar. Isso pode fazer com que o PhpGedView execute as palavras juntas. Definir como <b>#pgv_lang[yes]#</b> adicionará um espaço entre as palavras onde são agrupadas no GEDCOM original.";
$pgv_lang["SHOW_CONTEXT_HELP"]					= "Mostrar links contextuais de ajuda";
$pgv_lang["SHOW_CONTEXT_HELP_help"]				= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Esta opção habilitará links, identificados por pontos de interrogação, próximos a itens em muitas páginas. Esses links permitem que os usuários obtenham informações ou ajuda sobre esses itens.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]					= "Limite de dias do bloco Próximos Eventos";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"]			= "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Insira o número máximo de dias para mostrar nos blocos de eventos futuros. Este número não pode ser maior que 30. Se você inserir um valor maior, 30 será usado.<br /><br />O valor que você inserir aqui determina a que distância o PhpGedView procura ao procurar por eventos futuros. Os resultados desta pesquisa, feita uma vez por dia, são copiados para um arquivo temporário.<br /><br />Nenhum bloco de eventos futuros nas páginas de boas-vindas ou MyGedView pode solicitar mais dias do que este valor. Quanto maior for isso, mais tempo levará para construir a extração diária do banco de dados e mais tempo levará para exibir o bloco, mesmo quando você solicitar a exibição de um número de dias a menos do que esta configuração.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]				= "Mínimo de ocorrências para ser um \"Nome Comum\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]		= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br /> Este é o número de vezes que um sobrenome deve ocorrer antes de aparecer na lista de sobrenomes comuns na página de boas-vindas.";
$pgv_lang["COMMON_NAMES_ADD"]					= "Nomes para adicionar à lista de sobrenomes comuns";
$pgv_lang["COMMON_NAMES_ADD_help"]				= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Se o número de vezes que um determinado sobrenome ocorre for inferior ao limite, ele não aparecerá na lista. Ele pode ser adicionado aqui manualmente. Se mais de um sobrenome for inserido, eles devem ser separados por uma vírgula. <b>Sobrenomes diferenciam maiúsculas de minúsculas.</b>";
$pgv_lang["COMMON_NAMES_REMOVE"]				= "Nomes a serem excluídos da lista de Nomes Comuns";
$pgv_lang["COMMON_NAMES_REMOVE_help"]			= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Se desejar remover um sobrenome da lista de sobrenomes comuns sem aumentar o valor limite, você pode fazer isso inserindo o sobrenome aqui. Se mais de um sobrenome for inserido, eles devem ser separados por uma vírgula. <b>Os sobrenomes diferenciam maiúsculas de minúsculas.</b> Os sobrenomes inseridos aqui também serão removidos da lista dos 10 principais na página de boas-vindas.";
$pgv_lang["HOME_SITE_URL"]						= "URL do site principal";
$pgv_lang["HOME_SITE_URL_help"]					= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Cada página do PhpGedView inclui um link para sua página inicial principal. A aparência deste link é controlada pelo tema que está sendo usado. Você insere o URL real do seu site inicial aqui.";
$pgv_lang["HOME_SITE_TEXT"]						= "Título do site principal";
$pgv_lang["HOME_SITE_TEXT_help"]				= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />O título usado para identificar o link para sua página inicial principal.";
$pgv_lang["CONTACT_EMAIL"]						= "Contato Genealógico";
$pgv_lang["CONTACT_EMAIL_help"]					= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />A pessoa a ser contatada sobre os dados genealógicos neste site.";
$pgv_lang["CONTACT_METHOD"]						= "Método de contato";
$pgv_lang["CONTACT_METHOD_help"]				= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />O método a ser usado para entrar em contato com o #pgv_lang[CONTACT_EMAIL]# sobre questões genealógicas.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["CONTACT_METHOD_desc"] 				= "<ul><li>A opção <b>#pgv_lang[mailto]#</b> criará um link \"mailto\" que pode ser clicado para enviar um e-mail usando o cliente de e-mail no PC do usuário.</li><li>A opção <b>#pgv_lang[messaging]#</b> usará um sistema de mensagens interno ao PhpGedView, e nenhum e-mail será enviado.</li><li>A opção <b>#pgv_lang[messaging2]#</b> é o padrão. Ele usará o sistema de mensagens PhpGedView e também enviará cópias das mensagens por e-mail.</li><li>A opção <b>#pgv_lang[messaging3]#</b> permite que o PhpGedView controle as mensagens e envie as mensagens como e-mails, mas não as armazene internamente. Esta opção é semelhante à opção <b>#pgv_lang[mailto]#</b>, exceto que a mensagem será enviada pelo PhpGedView em vez da estação de trabalho do usuário.</li><li>A opção <b>#pgv_lang[no_messaging]#</b> faz com que seus usuários não tenham como entrar em contato com você.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]					= "Endereço de resposta PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]				= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Endereço de e-mail a ser usado no campo «De:» de e-mails que o PhpGedView cria automaticamente.<br /><br />O PhpGedView pode criar e-mails automaticamente para notificar os administradores de mudanças que precisam ser revisadas. O PhpGedView também envia e-mails de notificação para usuários que solicitaram uma conta.<br /><br />Normalmente, o campo «De:»  desses e-mails criados automaticamente é algo como <i>De:phpgedview-noreply@seusite</i> para mostrar que nenhuma resposta ao e-mail é necessária. Para se proteger contra spam ou outro abuso de e-mail, alguns sistemas de e-mail exigem o «De:» de cada mensagem para refletir uma conta de e-mail válida e não aceitará mensagens que aparentemente sejam da conta <i>phpgedview-noreply</i>.";
$pgv_lang["WEBMASTER_EMAIL"]					= "Contato de suporte";
$pgv_lang["WEBMASTER_EMAIL_help"]				= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />A pessoa a ser contatada sobre questões técnicas ou erros encontrados em seu site.";
$pgv_lang["SUPPORT_METHOD"]						= "Método de suporte";
$pgv_lang["SUPPORT_METHOD_help"]				= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />O método a ser usado para entrar em contato com o #pgv_lang[WEBMASTER_EMAIL]# sobre questões genealógicas.#pgv_lang[CONTACT_METHOD_desc]#";
$pgv_lang["SHOW_FACT_ICONS"] 					= "Mostrar ícones de fatos";
$pgv_lang["SHOW_FACT_ICONS_help"]				= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Defina como <b>#pgv_lang[yes]#</b para exibir ícones perto de nomes de fatos na página <i>#pgv_lang[personal_details]#</i>. Os ícones de fatos serão exibidos apenas se existirem no diretório <i>images/facts</i> do tema atual.";
$pgv_lang["FAVICON"]							= "Ícone de favoritos";
$pgv_lang["FAVICON_help"]						= "~#pgv_lang[FAVICON]#~<br /><br />Altere isso para apontar para o ícone que você deseja exibir no menu de favoritos das pessoas quando elas adicionarem seu site aos favoritos.";
$pgv_lang["THEME_DIR"]							= "Diretório de temas";
$pgv_lang["THEME_DIR_help"]						= "~#pgv_lang[THEME_DIR]#~<br /><br />O diretório onde seus arquivos de tema PhpGedView são mantidos.<br /><br />Você pode personalizar qualquer um dos temas padrão que vêm com PhpGedView para dar ao seu site uma aparência única. Consulte a seção Personalização do tema do arquivo <a href=\"readme.txt\">readme.txt</a> para obter mais informações.";
$pgv_lang["TIME_LIMIT"]							= "Limite de tempo do PHP";
$pgv_lang["TIME_LIMIT_help"]					= "~#pgv_lang[TIME_LIMIT]#~<br /><br />O tempo máximo em segundos que o PhpGedView deve ser permitido para ser executado.<br /><br />O padrão é 1 minuto. Dependendo do tamanho do seu arquivo GEDCOM, pode ser necessário aumentar este limite de tempo quando precisar construir os índices. Defina este valor como 0 para permitir que o PHP seja executado para sempre.<br /><br />CUIDADO: Definir como 0 ou muito alto pode fazer com que seu site trave em certos sistemas operacionais até que o script termine. Definir como 0 significa que pode nunca terminar até que um administrador do servidor elimine o processo ou reinicie o servidor. Um gráfico de linhagem grande pode levar muito tempo para ser executado; deixar esse valor o mais baixo possível garante que alguém não possa travar seu servidor solicitando um gráfico excessivamente grande.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]			= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />O caminho para armazenar os arquivos de sessão do PhpGedView.<br /><br />Alguns hosts não têm o PHP configurado corretamente e as sessões não são mantidas entre as solicitações de página. Esta opção permite que os administradores do site superem esse problema salvando arquivos em um de seus diretórios locais. O diretório ./index/ é uma boa escolha se você precisar alterá-lo. O padrão é deixar o campo vazio, que usará o caminho Salvar conforme configurado no <i>php.ini</i>.";
$pgv_lang["SERVER_URL_help"]					= "~#pgv_lang[SERVER_URL]#~<br /><br />Se você usar https ou uma porta diferente da padrão, precisará inserir o URL para acessar o servidor aqui.";
$pgv_lang["LOGIN_URL"]							= "URL de login";
$pgv_lang["LOGIN_URL_help"]						= "~#pgv_lang[LOGIN_URL]#~<br /><br />Você só precisa inserir um URL de login se quiser redirecionar para um site ou local diferente quando seus usuários fizerem login. Isso é muito útil se você precisar mudar de http para https quando seus usuários fizerem login. Inclua o URL completo para <i>login.php</i>. Por exemplo, https://www.seuservidor.com/phpgedview/login.php .";
$pgv_lang["PGV_SESSION_TIME_help"]				= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />O tempo em segundos que uma sessão PhpGedView permanece ativa antes de requerer um login. O padrão é 7200, que é 2 horas.";
$pgv_lang["SHOW_STATS"]							= "Mostrar estatísticas de execução";
$pgv_lang["SHOW_STATS_help"]					= "~#pgv_lang[SHOW_STATS]#~<br /><br />Mostre estatísticas de tempo de execução e consultas de banco de dados na parte inferior de cada página.";
$pgv_lang["SHOW_COUNTER"]						= "Mostrar contadores de visitas";
$pgv_lang["SHOW_COUNTER_help"]					= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Mostre contadores de ocorrências na página MyGedView e na página <i>#pgv_lang[personal_details]#</i>.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]		= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Oferece ao visitante a opção de se cadastrar para uma conta no site.<br /><br />O visitante receberá um e-mail com um código para verificar sua inscrição em uma conta. Após a verificação, o administrador terá que aprovar o registro antes de se tornar ativo.";
$pgv_lang["ALLOW_USER_THEMES_help"]				= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Oferece aos usuários a opção de selecionar seu próprio tema.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] 				= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />Em cabeçalhos de e-mail normais para e-mails externos, tanto o endereço de e-mail quanto o nome são usados. Alguns sistemas de e-mail não aceitam isso. Quando definido como <b>#pgv_lang[yes]#</b>, apenas o endereço de e-mail será usado.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] 				= "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Use SMTP para enviar e-mails do PhpGedView.<br /><br />Esta opção requer acesso a um servidor de e-mail SMTP. Quando definido como <b>#pgv_lang[no]#</b>, o PhpGedView usará o sistema de e-mail integrado ao PHP neste servidor.";
$pgv_lang["PGV_SMTP_DEBUG_help"] = "~#pgv_lang[PGV_SMTP_DEBUG]#~<br /><br />Quando a opção <b>#pgv_lang[PGV_SMTP_ACTIVE]#</b> é configurada para <b>#pgv_lang[yes]#</b>, PhpGedView usará o programa PHPMailer para enviar e-mails. Este programa produz mensagens de erro quando encontra problemas ao tentar enviar e-mails.<br /><br />Esta opção, que é útil ao tentar resolver problemas de envio de e-mail, determina os tipos de erros que o PHPMailer relatará. Os tipos de erro que você pode selecionar são:<ul><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION0]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION1]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION2]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION3]#</li><li>#pgv_lang[PGV_SMTP_DEBUG_OPTION4]#</li></ul>";
$pgv_lang["PGV_SMTP_HOST_help"]					= "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Este é o nome do servidor de correio SMTP. Exemplo: <b>smtp.foo.bar.com</b>.<br /><br />Valores de configuração para alguns provedores de e-mail:<br /><br /><b>Gmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.gmail.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;465 ou 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;SSL<br /><br /><b>Hotmail</b><br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#&nbsp;&nbsp;smtp.live.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25 ou 587<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_SSL]#:&nbsp;&nbsp;TLS<br /><br /><b>Yahoo Mail Plus</b> (atualmente um serviço pago)<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_HOST]#:&nbsp;&nbsp;smtp.mail.yahoo.com<br />&nbsp;&nbsp;&nbsp;#pgv_lang[PGV_SMTP_PORT]#:&nbsp;&nbsp;25";
$pgv_lang["PGV_SMTP_HELO_help"] 				= "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Esta é a parte do domínio de um endereço de e-mail válido no servidor SMTP.<br /><br />Por exemplo, se você tiver uma conta de e-mail como <b>seunome@abc.xyz.com</b>, deverá inserir <b>abc.xyz.com</b> aqui.";
$pgv_lang["PGV_SMTP_PORT_help"] 				= "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />O número da porta a ser usado para conexões com o servidor SMTP. Geralmente, esta é a porta <b>25</b>.";
$pgv_lang["PGV_SMTP_AUTH_help"] 				= "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Use a autenticação de nome e senha para se conectar ao servidor SMTP.<br /><br />Alguns servidores SMTP exigem que todas as conexões sejam autenticadas antes de aceitarem e-mails enviados.";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] 			= "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />O nome de usuário necessário para autenticação com o servidor SMTP.";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] 			= "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />A senha necessária para autenticação com o servidor SMTP.";
$pgv_lang["PGV_SMTP_SSL_help"]		 			= "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />O Transport Layer Security (TLS) e o Secure Sockets Layer (SSL) são protocolos de criptografia de dados da Internet.<br /><br />TLS 1.0, 1.1 e 1.2 são desenvolvimentos padronizados do SSL 3.0. TLS 1.0 e SSL 3.1 são equivalentes. Trabalho adicional em SSL é feito agora com o novo nome, TLS.<br /><br />Se o seu servidor SMTP requer o protocolo SSL durante o login, você deve selecionar a opção <b>SSL</b>. Se o seu servidor SMTP requer o protocolo TLS durante o login, você deve selecionar a opção <b>TLS</b>.";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] 			= "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Insira o nome a ser usado na seção «De:» campo de e-mails originados neste site.<br /><br />Por exemplo, se o seu nome é <b>John Smith</b> e você é o administrador de um site conhecido como <b>Genealogia de Jones</b>, você pode inserir algo como <b>John Smith</b> ou <b>Genealogia de Jones</b> ou mesmo <b>John Smith, Administrador: Genealogia de Jones</b>. Você pode inserir o que quiser, mas HTML não é permitido.";
$pgv_lang["gedcom_title"]						= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]					= "~#pgv_lang[gedcom_title]#~<br /><br />Insira um título descritivo a ser exibido quando os usuários escolherem entre os conjuntos de dados GEDCOM em seu site.";
$pgv_lang["LOGFILE_CREATE"]						= "Frequência de arquivamento dos Logs";
$pgv_lang["LOGFILE_CREATE_help"]				= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Com que freqüência o programa deve arquivar os arquivos de log.";
$pgv_lang["REMINDER_FREQ"] 						= "Frequência de e-mails de lembrete «Revisão de alterações»";
$pgv_lang["REMINDER_FREQ_help"]		= "~#pgv_lang[REMINDER_FREQ]#~<br /><br />Esta opção controla a freqüência com que os e-mails de lembrete «Revisar alterações» serão enviados. <b>zero</b>: nunca;&nbsp;&nbsp;<b>1</b>: diariamente;&nbsp;&nbsp;<b>2</b>: a cada dois dias; etc.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]				= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />A quantidade máxima de memória que pode ser consumida por scripts PhpGedView. O padrão é 64 Mb. Muitos hosts desabilitam esta opção em suas configurações de PHP; alterar este valor pode não afetar a configuração de memória máxima atual.";
$pgv_lang["PGV_STORE_MESSAGES_help"]			= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Especifica se as mensagens enviadas por meio do PhpGedView podem ser armazenadas no banco de dados. Se definido como <b>#pgv_lang[yes]#</b>, os usuários poderão recuperar suas mensagens ao fazer login no PhpGedView. Se definido como <b>#pgv_lang[no]#</b>, as mensagens serão enviadas apenas por e-mail.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]				= "Exibir menu de tema para mudanças de tema";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]			= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Oferece aos usuários a capacidade de selecionar seu próprio tema em um menu.<br /><br />Mesmo com essa opção definida, o tema atualmente em vigor pode não fornecer esse menu. Para ser eficaz, esta opção requer que a opção <b>#pgv_lang[ALLOW_USER_THEMES]#</b> também seja definida.";
$pgv_lang["MAX_VIEW_RATE"]						= "Taxa máxima de page view";
$pgv_lang["MAX_VIEW_RATE_help"]					= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Esta opção limita a taxa na qual um usuário pode visualizar as páginas.<br /><br />Se essa taxa for excedida, o PhpGedView trata a sessão como uma tentativa de hacking; a sessão será encerrada com uma mensagem adequada. Esses dois valores devem colocar um limite razoável na quantidade de largura de banda e bytes baixados do servidor. Este recurso pode ser desativado configurando o intervalo de tempo para 0.";
$pgv_lang["META_AUTHOR"]						= "META tag: Author (Autor)";
$pgv_lang["META_AUTHOR_help"]					= "~#pgv_lang[META_AUTHOR]#~<br /><br />O valor a ser colocado no Author meta tag no cabeçalho da página HTML. Deixe este campo vazio para usar o nome completo do #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_AUTHOR_descr"]					= "Deixe este campo vazio para usar o nome completo do #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]						= "META tag: Publisher (Editor)";
$pgv_lang["META_PUBLISHER_help"]				= "~#pgv_lang[META_PUBLISHER]#~<br /><br />O valor a ser colocado no Publisher meta tag no cabeçalho da página HTML. Deixe este campo vazio para usar o nome completo do #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER_descr"]				= "Deixe este campo vazio para usar o nome completo do #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]						= "META tag: Copyright (Copirraite)";
$pgv_lang["META_COPYRIGHT_help"]				= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />O valor a ser colocado no Copyright meta tag no cabeçalho da página HTML. Deixe este campo vazio para usar o nome completo do #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT_descr"]				= "Deixe este campo vazio para usar o nome completo do #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]					= "META tag: Description (Descrição)";
$pgv_lang["META_DESCRIPTION_help"]				= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />O valor a ser colocado no Description meta tag no cabeçalho da página HTML. Deixe este campo vazio para usar o título do banco de dados ativo no momento.";
$pgv_lang["META_DESCRIPTION_descr"]				= "Deixe este campo vazio para usar o título do banco de dados ativo no momento.";
$pgv_lang["META_PAGE_TOPIC"]					= "META tag: Page-topic (Tópico da página)";
$pgv_lang["META_PAGE_TOPIC_help"]				= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />O valor a ser colocado no Page-topic meta tag no cabeçalho da página HTML. Deixe este campo vazio para usar o título do banco de dados ativo no momento.";
$pgv_lang["META_PAGE_TOPIC_descr"]				= "Deixe este campo vazio para usar o título do banco de dados ativo no momento.";
$pgv_lang["META_AUDIENCE"]						= "META tag: Audience (Público)";
$pgv_lang["META_AUDIENCE_help"]					= "~#pgv_lang[META_AUDIENCE]#~<br /><br />O valor a ser colocado no Audience meta tag no cabeçalho da página HTML.";
$pgv_lang["META_PAGE_TYPE"]						= "META tag: Page-type (Tipo de página)";
$pgv_lang["META_PAGE_TYPE_help"]				= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />O valor a ser colocado no Page-type meta tag no cabeçalho da página HTML.";
$pgv_lang["META_ROBOTS"]						= "META tag: Robots (Robôs)";
$pgv_lang["META_ROBOTS_help"]					= "~#pgv_lang[META_ROBOTS]#~<br /><br />O valor a ser colocado no Robots meta tag no cabeçalho da página HTML. Alguns mecanismos de pesquisa ignoram esse valor.";
$pgv_lang["META_REVISIT"]						= "META tag: Revisit (Revisitar)";
$pgv_lang["META_REVISIT_help"]					= "~#pgv_lang[META_REVISIT]#~<br /><br />O valor a ser colocado no Revisit meta tag no cabeçalho da página HTML. Alguns mecanismos de pesquisa ignoram esse valor.";
$pgv_lang["META_KEYWORDS"]						= "META tag: Keywords (Palavras-chave)";
$pgv_lang["META_KEYWORDS_help"]					= "~#pgv_lang[META_KEYWORDS]#~<br /><br />O valor a ser colocado no Keywords meta tag no cabeçalho da página HTML. Alguns mecanismos de pesquisa usarão o Keywords meta tag para ajudar a indexar sua página.<br /><br />A lista #pgv_lang[common_surnames]# que aparece no bloco #pgv_lang[gedcom_stats]# em sua página de boas-vindas também pode ser adicionada a qualquer coisa que você inserir aqui.";
$pgv_lang["META_TITLE"]							= "Adicionar à META tag TITLE";
$pgv_lang["META_TITLE_help"]					= "~#pgv_lang[META_TITLE]#~<br /><br />Qualquer coisa nesta linha será adicionada ao TITLE tag no cabeçalho da página HTML após o título da página regular e antes do crédito PhpGedView.";

$pgv_lang["ENABLE_RSS"]							= "Habilitar RSS";
$pgv_lang["ENABLE_RSS_help"]					= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Esta opção permite que você desative o recurso RSS.<br /><br />RSS permite que os usuários monitorem seu site quanto a alterações na página de índice sem realmente visitar o site periodicamente. Se muitos usuários usarem esse recurso ou se a frequência de atualização definida por esses usuários for muito alta, o RSS pode usar muita largura de banda ou capacidade do servidor.<br /><br />Este <a href='https://pt.wikipedia.org/wiki/RSS' target='_blank' title='artigo da Wikipedia'><b>artigo da Wikipedia</b></a> contém informações abrangentes e links sobre RSS e os vários formatos RSS.";
$pgv_lang["RSS_FORMAT"]							= "Formato RSS";
$pgv_lang["RSS_FORMAT_help"]					= "~#pgv_lang[RSS_FORMAT]#~<br /><br />O formato a ser usado como o formato de feed padrão do site. Os sufixos numéricos <u>não</u> indicam a versão: eles identificam os formatos. Por exemplo, RSS 2.0 não é mais recente que RSS 1.0, mas um formato diferente. Os leitores de feed devem ser capazes de ler qualquer formato.<br /><br />Este <a href='https://pt.wikipedia.org/wiki/RSS' target='_blank' title='artigo da Wikipedia'><b>artigo da Wikipedia</b></a> contém informações abrangentes e links sobre RSS e os vários formatos RSS.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Verifique se os arquivos GEDCOM podem ser baixados da Internet";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"]	= "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Por motivos de segurança, os arquivos GEDCOM não devem estar em um local onde possam ser baixados diretamente, ignorando as verificações de privacidade. Clicar neste link irá verificar se seus arquivos GEDCOM podem ser baixados pela rede.<br /><br />Em alguns sistemas, esta verificação costuma demorar muito ou nem mesmo ser concluída. Se for esse o seu caso, tente apontar o navegador diretamente para o GEDCOM para ver se ele pode ser baixado.";
$pgv_lang["gedcom_download_secure"]				= "#GEDCOM# não pode ser baixado.";

$pgv_lang["welcome_new_help"]					= "~#pgv_lang[welcome_new]#~<br /><br />Como está vendo esta página, você instalou com sucesso o PhpGedView em seu servidor e está pronto para começar a configurá-lo de acordo com seus requisitos.<br /><br />Esta página de Ajuda o guiará pelo processo de configuração. Conforme você insere campos diferentes, esta janela fornecerá informações de ajuda sobre o campo em que você está. Você pode fechar esta janela; para abri-lo novamente, clique em um dos pontos de interrogação <b>#pgv_lang[qm]#</b> próximo ao rótulo do campo.";
$pgv_lang["return_editconfig"]					= "Você pode retornar a esta configuração a qualquer momento apontando seu navegador para <i>editconfig.php</i> ou clicando no link <b>Configuração</b> na página <b>Administração do PhpGedView</b>.";
$pgv_lang["return_editconfig_gedcom"]			= "Você pode retornar a esta configuração a qualquer momento clicando no link <b>Editar</b> na tabela <b>#pgv_lang[current_gedcoms]#</b> na página <b>#pgv_lang[gedcom_adm_head]#</b> ou apontando seu navegador para <i>editconfig_gedcom.php</i>.";
$pgv_lang["save_config"]						= "Salvar Configuração";
$pgv_lang["download_gedconf"]					= "Baixe a configuração GEDCOM.";
$pgv_lang["not_writable"]						= "Nós detectamos que seu arquivo de configuração não pode ser escrito pelo PHP. Você pode usar o botão <b>#pgv_lang[download_file]#</b> para salvar suas configurações em um arquivo que pode ser carregado manualmente.";
$pgv_lang["upload_to_index"]					= "Faça upload do arquivo para o diretório index: ";
$pgv_lang["import_sql"]							= "Arquivos SQL foram encontrados em seu diretório de índice. Como eles podem ter se originado da #pgv_lang[um_header]#, você tem a opção de importar as informações para o seu banco de dados. Deseja tentar importar esses arquivos para o seu banco de dados agora? Todas as informações existentes relacionadas ao usuário (usuários, notícias, favoritos, layouts de bloco e mensagens) em seu banco de dados serão perdidas.<br /><br />Se você decidir continuar, o PhpGedView tentará importar os dados. Se isso não for bem-sucedido, você será solicitado a criar a primeira conta de administrador.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]						= "Editar privacidade";
$pgv_lang["edit_privacy_title"]					= "Editar configurações de privacidade GEDCOM";
$pgv_lang["save_changed_settings"]				= "Salvar alterações";
$pgv_lang["add_new_pp_setting"]					= "Adicionar nova configuração de privacidade total por ID de pessoa";
$pgv_lang["add_new_up_setting"]					= "Adicionar nova configuração de privacidade para o nome do usuário";
$pgv_lang["add_new_gf_setting"]					= "Adicionar nova configuração de privacidade global de fatos";
$pgv_lang["add_new_pf_setting"]					= "Adicionar nova configuração de privacidade de fatos por ID de pessoa";
$pgv_lang["file_read_error"]					= "E R R O !!! Não foi possível ler o arquivo de privacidade!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Editar configurações existentes de privacidade total por ID de pessoa";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Editar configurações existentes de privacidade para o nome do usuário";
$pgv_lang["edit_exist_global_facts_settings"]	= "Editar configurações existentes de privacidade global de fatos";
$pgv_lang["edit_exist_person_facts_settings"]	= "Editar configurações existentes de privacidade de fatos por ID de pessoa";
$pgv_lang["general_privacy"]					= "Configurações gerais de privacidade";
$pgv_lang["general_privacy_help"]				= "~#pgv_lang[general_privacy]#~<br /><br />Você pode ter diferentes configurações de privacidade para cada GEDCOM em seu site PhpGedView. Verifique sob o título da página se você está editando o GEDCOM correto.<br /><br />Você pode substituir essas configurações gerais usando os outros formulários de privacidade na página #pgv_lang[edit_privacy_title]#.<br /><br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]						= "Privacidade total por ID de pessoa";
$pgv_lang["person_privacy_help"]				= "~#pgv_lang[person_privacy]#~<br /><br />Essas configurações permitem que os administradores substituam as configurações de privacidade padrão para uma determinada pessoa, família, fonte ou objeto de mídia.<br /><br />Suponha, por exemplo, que você tenha um filho que morreu na infância. Normalmente, porque a criança está morta, seus detalhes seriam mostrados aos usuários públicos. No entanto, você e todos os outros em sua família ainda são privados. Você não deseja remover o registro de óbito da criança, mas deseja ocultar os detalhes e torná-los privados. Se esta criança tinha o ID I100, você deve inserir as seguintes configurações de privacidade:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_USER]#<br /><br />Isso também funciona da outra maneira. Se você quiser tornar públicos os detalhes de alguém (ID I101) que você sabe que está morto, mas não tem uma data de falecimento, você pode adicionar o seguinte:<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#:&nbsp;&nbsp;#pgv_lang[PRIV_PUBLIC]#";
$pgv_lang["user_privacy"]						= "Privacidade para o nome do usuário";
$pgv_lang["user_privacy_help"]					= "~#pgv_lang[user_privacy]#~<br /><br />Essas configurações fornecem aos administradores a capacidade de substituir as configurações de privacidade padrão para indivíduos no GEDCOM com base no nome de usuário. Suponha que você não queira que o nome de usuário <b>João</b> possa ver quaisquer detalhes do ID I100 no GEDCOM, você pode configurá-lo assim:<br />&nbsp;&nbsp;&nbsp;Nome de usuário:&nbsp;&nbsp;João<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I100<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[hide]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e os detalhes do indivíduo especificado seriam ocultados apenas para o nome de usuário \"João\".<br /><br />Para mostrar os detalhes de I101 (que normalmente estariam ocultos porque I101 ainda está vivo) para definir o nome de usuário \"João\":<br />&nbsp;&nbsp;&nbsp;Nome de usuário:&nbsp;&nbsp;João<br />&nbsp;&nbsp;&nbsp;ID:&nbsp;&nbsp;I101<br />&nbsp;&nbsp;&nbsp;#pgv_lang[show_question]#:&nbsp;&nbsp;#pgv_lang[show]#";
$pgv_lang["global_facts"]						= "Privacidade global de fatos";
$pgv_lang["global_facts_help"]					= "~#pgv_lang[global_facts]#~<br /><br />Essas configurações definem fatos em um nível global que devem ser ocultados para todos os indivíduos no GEDCOM. Isso se aplica apenas a registros de fatos de nível 1, como BIRT ou DEAT, que aparecerão com seus próprios cabeçalhos na guia #pgv_lang[personal_facts]# da página <i>#pgv_lang[personal_details]#</i>.<br /><ul><li>O elemento <b>#pgv_lang[name_of_fact]#</b> determina qual fato deve ser escondido.</li><li>O elemento <b>#pgv_lang[choice]#</b> especifica o próprio fato ou detalhes relacionados.</li><li>O elemento <b>#pgv_lang[accessible_by]#</b> determina em qual nível de acesso o fato é mostrado.</li></ul><br />Esse recurso tem como objetivo ocultar certos fatos, identificados por tags GEDCOM, para todos os indivíduos vivos ou mortos. Por padrão, a marca SSN fica oculta para usuários públicos. Isso evita que as pessoas roubem números de seguridade social e cometam roubo de identidade de pessoas mortas. Isso provavelmente é mais relevante para os EUA.<br /><br />Se você quiser ocultar todos os casamentos de usuários públicos em seu GEDCOM, poderá definir:<br />&nbsp;&nbsp;&nbsp;#pgv_lang[name_of_fact]#: (MARR) - Casamento<br />&nbsp;&nbsp;&nbsp;#pgv_lang[choice]#: #pgv_lang[fact_details]#<br />&nbsp;&nbsp;&nbsp;#pgv_lang[accessible_by]#: #pgv_lang[PRIV_USER]#<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Essas configurações ocultam casamentos e detalhes relacionados aos visitantes que não estão logados.<br /><br />Ao contrário de todas as outras configurações, no <b>#pgv_lang[edit_exist_global_facts_settings]#</b> você pode ocultar fatos até mesmo de usuários administradores. Os fatos indesejados são completamente suprimidos.";
$pgv_lang["person_facts"]						= "Privacidade de fatos por ID de pessoa";
$pgv_lang["person_facts_help"]					= "~#pgv_lang[person_facts]#~<br /><br />Essas configurações definem fatos que estão ocultos para uma pessoa, família ou fonte específica e o nível em que estão ocultos. Isso se aplica apenas a registros de fato de nível 1, como BIRT ou DEAT, que aparecerão com seus próprios cabeçalhos na página de detalhes relevantes da pessoa, família ou fonte.<br /><br />O primeiro elemento é o ID do pessoa, família ou fonte. O segundo elemento é o fato. O elemento <b>#pgv_lang[choice]#</b> especifica o próprio fato ou detalhes relacionados. O elemento <b>#pgv_lang[accessible_by]#</b> determina em qual nível de acesso o fato é mostrado. Nem todos os fatos mostrados na lista são aplicáveis a todos os tipos de IDs. Por exemplo, os fatos de nascimento e falecimento não são relevantes para os registros de origem.<br /><br />Esta lista é semelhante à lista <b>#pgv_lang[global_facts]#</b>, exceto que você também especifica o ID GEDCOM da pessoa de quem deseja ocultar os fatos. Você pode, por exemplo, ocultar o registro de casamento de uma pessoa específica.";
$pgv_lang["accessible_by"]						= "Mostrar a?";
$pgv_lang["hide"]								= "Ocultar";
$pgv_lang["show_question"]						= "Mostrar?";
$pgv_lang["user_name"]							= "Nome do usuário";
$pgv_lang["name_of_fact"]						= "Nome do fato";
$pgv_lang["choice"]								= "Escolha";
$pgv_lang["fact_show"]							= "Mostrar fato";
$pgv_lang["fact_details"]						= "Mostrar detalhes do fato";
$pgv_lang["privacy_header"]						= "Editar configurações de privacidade";
$pgv_lang["unable_to_find_privacy_indi"]		= "Incapaz de encontrar um indivíduo com id";
$pgv_lang["save_and_import"]					= "Depois de salvar esta configuração GEDCOM, você precisará importar o GEDCOM clicando no botão <b>Importar GEDCOM</b> ou indo para <b>Administração --> Gerenciar GEDCOM --> Importar</b>";
$pgv_lang["help_info"]							= "Você pode obter ajuda para cada item clicando no botão vermelho <b>#pgv_lang[qm]#</b> ao lado do rótulo de cada célula.";
$pgv_lang["SHOW_LIVING_NAMES"]					= "Mostrar nomes vivos";
$pgv_lang["SHOW_LIVING_NAMES_help"]				= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Os nomes de pessoas vivas devem ser mostrados ao público?<br /><br />Normalmente esta configuração seria «#pgv_lang[PRIV_USER]#». Isso serve para proteger a privacidade de pessoas vivas em seu banco de dados, porque você pode determinar a quem dará acesso geral aos seus dados genealógicos.<br /><br />A configuração «#pgv_lang[PRIV_NONE]#» impede a exibição dos nomes de pessoas vivas para usuários que não têm direitos de administrador.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Mostrar Assistente de Pesquisa";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Que tipo de usuário pode visualizar o módulo do Assistente de Pesquisa se estiver instalado?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]			= "Use privacidade de relacionamento";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]		= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>#pgv_lang[no]#</b> significa que usuários autenticados podem ver os detalhes de todas as pessoas vivas. <b>#pgv_lang[yes]#</b> significa que os usuários só podem ver as informações privadas de pessoas vivas com as quais estão relacionados.<br /><br />Esta opção define o padrão para todos os usuários que têm acesso a este banco de dados genealógico. O administrador pode substituir esta opção para usuários individuais, editando os detalhes da conta do usuário.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]			= "Comprimento máximo do caminho de relação";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]		= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Se a opção <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> estiver habilitada, os usuários logados só poderão ver ou editar indivíduos dentro deste número de etapas de relacionamento.<br /><br />Esta opção define o padrão para todos os usuários que têm acesso a este banco de dados genealógico. O administrador pode substituir essa opção para usuários individuais, editando os detalhes da conta do usuário.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]			= "Verifique as relações de casamento";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]		= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Verifique os relacionamentos que estão relacionados pelo casamento.";
$pgv_lang["SHOW_DEAD_PEOPLE"]					= "Mostrar pessoas mortas";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]				= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Defina o nível de acesso de privacidade para todas as pessoas mortas.";
$pgv_lang["select_privacyfile_button"]			= "Selecione o arquivo de privacidade";
$pgv_lang["PRIVACY_BY_YEAR"]					= "Limite de privacidade por idade do evento";
$pgv_lang["PRIVACY_BY_YEAR_help"]				= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Esta configuração irá ocultar os detalhes das pessoas com base em sua idade em eventos específicos, independentemente de estarem vivas ou mortas.<br /><br />Use esta configuração junto com a configuração <b>#pgv_lang[MAX_ALIVE_AGE]#</b>. Por exemplo, se você definiu a configuração de Idade 100 e definiu esta opção para <b>#pgv_lang[yes]#</b>, todas as pessoas, vivas ou mortas, nascidas há menos de 100 anos seriam definidas como privadas. Pessoas que se casaram há menos de 85 anos e pessoas que morreram há menos de 75 anos também seriam marcadas como privadas. Observe que usar esta opção tornará o programa um pouco mais lento.";

//-- language edit utility
$pgv_lang["lang_edit_help"]						= "~#pgv_lang[translator_tools]#~<br /><br />Esta página deve ser usada por tradutores. Você pode traduzir, comparar e exportar arquivos de idioma. Também existe uma opção para ajudar os tradutores a determinar a origem do texto que é produzido pelo PhpGedView.<br /><br />Você pode usar as seguintes opções e utilitários:";
$pgv_lang["edit_langdiff"]						= "Editar e configurar arquivos de idioma";
$pgv_lang["bom_check"]							= "Verificação de Byte Order Mark (BOM)";
$pgv_lang["bom_check_help"]						= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]						= "Esta verificação analisará todos os arquivos de idioma para o BOM (marca de ordem de byte). Se encontrado, ele removerá o BOM do arquivo afetado. Esses códigos especiais podem causar mau funcionamento em algumas partes do PhpGedView.";
$pgv_lang["lang_debug"]							= "Depurar texto de ajuda";
$pgv_lang["lang_debug_help"]					= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]					= "Ao ativar esta opção, os nomes das variáveis de idioma usadas no texto de ajuda serão impressos na janela pop-up do texto de ajuda. Isso ajudará os tradutores a determinar o nome da variável quando o texto precisar ser ajustado.<br /><br />Esta configuração só será válida durante a sua sessão PhpGedView atual.";
$pgv_lang["lang_debug_use"]						= "Use a depuração de texto de ajuda";
$pgv_lang["bom_not_found"]						= "Nenhum BOM foi encontrado.";
$pgv_lang["bom_found"]							= "BOM foi encontrado em ";
$pgv_lang["edit_lang_utility"]					= "Utilitário de edição de arquivo de linguagem";
$pgv_lang["edit_lang_utility_help"]				= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]				= "Você pode usar este utilitário para editar o conteúdo de um arquivo de idioma usando o conteúdo do em inglês.<br /><br />Você verá o conteúdo do arquivo do idioma inglês original e o conteúdo do mesmo tipo de arquivo (há nove deles) no idioma escolhido. Você clica no texto da mensagem mostrado abaixo da versão em inglês. Isso abre uma nova janela onde você pode modificar o texto. Você pode salvar as alterações ou abandoná-las.";
$pgv_lang["edit_lang_utility_warning"]			= "CUIDADO!<br /><br />Se você usar o botão <b>#pgv_lang[close_window_without_refresh]#</b>, talvez não veja as alterações na tela até que recarregue a página do manual. É possível que o seu arquivo de idioma seja destruído se você adicionar uma mensagem que ainda não apareceu dentro do arquivo de idioma ou se você apenas editar uma mensagem que você editou diretamente antes.<br /><br />Se você realmente não sabe o que está fazendo, por favor, não use o botão <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]					= "Idioma para editar";
$pgv_lang["language_to_edit_help"]				= "~#pgv_lang[language_to_edit]#~<br /><br />Nesta caixa, você seleciona o idioma cujas mensagens deseja editar.";
$pgv_lang["file_to_edit"]						= "Tipo de arquivo de idioma para editar";
$pgv_lang["file_to_edit_help"]					= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]				= "PhpGedView implementou suporte para muitos idiomas diferentes. Isso foi conseguido mantendo todo o texto visível aos usuários em arquivos completamente separados do programa principal. Há um conjunto de oito arquivos para cada idioma suportado, e os vários textos foram separados em um desses arquivos de acordo com a função. <b>Nem todos os arquivos de idioma precisam estar presentes.</b> Quando um determinado texto ainda não está disponível na forma traduzida, PhpGedView sempre usará a versão em inglês.<br /><br />Os arquivos em cada idioma definido está:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Este arquivo contém termos e expressões comuns para uso durante a administração do PhpGedView e dos bancos de dados genealógicos.</li><br /><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Este arquivo contém texto de ajuda para uso durante a configuração do PhpGedView. O texto da Ajuda não deve ser visualizado por usuários comuns.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Esta é uma lista de nomes de países, obtida do site da Divisão de Estatísticas do Departamento de Assuntos Econômicos e Sociais das Nações Unidas. Este é o <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> relevante para a lista em inglês. A lista está disponível em inglês ou francês.</li><br /><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Este arquivo contém termos e expressões comuns para uso durante a edição de entradas nos bancos de dados genealógicos.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Este arquivo contém os equivalentes textuais dos códigos de fatos GEDCOM encontrados no padrão GEDCOM 5.5.1. Ele também contém códigos de fatos adicionais não encontrados no Padrão, mas usados por vários programas de genealogia.<br /><br />Uma cópia em inglês do <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>padrão GEDCOM 5.5.1</b></a> pode ser baixada em PDF (Formato de Documento Portátil).</li><br /><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Este arquivo é um conjunto de <b>f</b>requently <b>a</b>sked <b>q</b>uestions (perguntas frequentes) que foi coletado pela equipe de desenvolvimento do PhpGedView. Cada FAQ possui duas entradas neste arquivo. Uma entrada é o título do FAQ (geralmente a pergunta) e a outra é o corpo do FAQ (geralmente a resposta). Substituições para os arquivos <b><i>faqlist.xx.php</i></b>, que são atualizados com freqüência, podem ser baixadas do site do PhpGedView.<br /><br />O administrador pode usar as perguntas frequentes neste arquivo para construir uma lista de perguntas frequentes que seja específica para seu site.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Este arquivo contém texto de ajuda para usuários comuns. Alguns tópicos da Ajuda neste arquivo atendem às necessidades dos administradores e estão ocultos para usuários que não têm direitos de administrador.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Muitos termos e expressões comuns são encontrados neste arquivo.</li></ul><br />PhpGedView também suporta um arquivo de nono idioma opcional, <b><i>extra.xx.php</i></b>. Este arquivo é sempre carregado após todos os outros e fornece um meio pelo qual um administrador do site pode substituir ou alterar qualquer texto padrão no idioma selecionado. Também pode ser usado para fornecer um título para os bancos de dados genealógicos que variam de acordo com o idioma ativo no momento.<br /><br />O conteúdo deste arquivo adicional é de total responsabilidade do administrador do site; este arquivo <b>nunca</b> será distribuído com qualquer versão do PhpGedView. O administrador nunca deve fazer alterações nos arquivos de idioma padrão; todas as mudanças locais devem ser concentradas neste arquivo opcional.";
$pgv_lang["check"]								= "Verificar";
$pgv_lang["lang_save"]							= "Salvar";
$pgv_lang["contents"]							= "Conteúdo";
$pgv_lang["listing"]							= "Listagem";
$pgv_lang["no_content"]							= "Sem conteúdo";
$pgv_lang["editlang"]							= "Editar";
$pgv_lang["editlang_help"]						= "~#pgv_lang[editlang]#~<br /><br />Edite a mensagem do arquivo de idioma.";
$pgv_lang["savelang"]							= "Salvar";
$pgv_lang["savelang_help"]						= "~#pgv_lang[savelang]#~<br /><br />Salve a mensagem editada no arquivo de idioma.";
$pgv_lang["original_message"]					= "Mensagem original";
$pgv_lang["message_to_edit"]					= "Mensagem para editar";
$pgv_lang["changed_message"]					= "Conteúdo alterado";
$pgv_lang["message_empty_warning"]				= "-&gt; Atenção!!! Esta mensagem está vazia em #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]					= "Idioma para exportar";
$pgv_lang["language_to_export_help"]			= "~#pgv_lang[language_to_export]#~<br /><br />A partir desta lista você pode selecionar o idioma e os arquivos de idioma cujo texto você deseja exportar.<br /><br />A saída é um arquivo HTML que você pode imprimir de seu navegador.";
$pgv_lang["export_lang_utility"]				= "Utilitário de exportação de arquivo de idioma";
$pgv_lang["export"]								= "Exportar";
$pgv_lang["export_lang_utility_help"]			= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]			= "Você pode criar documentação para administradores.<br /><br />Este utilitário produzirá uma versão HTML do arquivo de idioma selecionado. Você pode usar seu navegador para ver este arquivo, que está formatado para impressão.";
$pgv_lang["export_ok"]							= "O texto do idioma foi exportado";
$pgv_lang["compare_lang_utility"]				= "Utilitário de comparação de arquivos de idioma";
$pgv_lang["compare_lang_utility_help"]			= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]			= "Este utilitário irá comparar dois conjuntos de arquivos de idioma para produzir uma lista das adições e subtrações entre eles.<br /><br />Os arquivos em inglês devem ser usados como referência a partir da qual todos os outros são produzidos.";
$pgv_lang["new_language"]						= "Idioma de origem";
$pgv_lang["new_language_help"]					= "~#pgv_lang[new_language]#~<br /><br />A partir desta lista, você pode selecionar o idioma cujas mensagens deseja comparar com as de outro idioma.<br /><br />Todas as alterações e adições aos arquivos de idioma são feitas primeiro nos arquivos do idioma <b>inglês</b>, portanto, você normalmente selecionaria o inglês como um dos idiomas a serem comparados.";
$pgv_lang["old_language"]						= "Idioma secundário";
$pgv_lang["old_language_help"]					= "~#pgv_lang[old_language]#~<br /><br />Nessa lista, você pode selecionar o idioma que deseja comparar com o idioma selecionado na caixa de listagem <b>#pgv_lang[new_language]#</b>.<br /><br />Depois de fazer sua escolha, clique em botão <b>Comparar</b> para obter uma lista de todas as adições e subtrações em todos os arquivos de ambos os idiomas.<br /><br />Para refrescar sua memória:<br /><b>Adição</b> significa: Está <u>no</u> arquivo de origem, mas <u>não</u> no arquivo secundário.<br /><br /><b>Subtração</b> significa: é <u>não</u> no arquivo de origem, mas <u>está</u> no arquivo secundário. Isso pode acontecer quando uma determinada mensagem não é mais usada e, portanto, foi removida dos arquivos em inglês. Você pode remover com segurança a mensagem correspondente dos arquivos do idioma secundário.";
$pgv_lang["compare"]							= "Comparar";
$pgv_lang["comparing"]							= "Arquivos de idioma que são comparados";
$pgv_lang["additions"]							= "Adições";
$pgv_lang["no_additions"]						= "Sem adições";
$pgv_lang["subtractions"]						= "Subtrações";
$pgv_lang["no_subtractions"]					= "Sem subtrações";
$pgv_lang["config_lang_utility"]				= "Configuração de idiomas suportados";
$pgv_lang["config_lang_utility_help"]			= "~#pgv_lang[config_lang_utility]#~<br /><br />Esta página é usada para controlar quais opções de idioma estão disponíveis para seus usuários. Por exemplo, você pode configurar as coisas para que apenas alemão e francês estejam disponíveis. Isso pode ser útil se, por exemplo, você não conseguir se comunicar com seus usuários em húngaro.<br /><br />Você também pode usar esta página para alterar certos aspectos do PhpGedView que dependem do idioma selecionado. Por exemplo, aqui é onde você diz ao PhpGedView como formatar os campos de data e hora.<br /><br />Os idiomas que estão ativos e esmaecidos não podem ser desabilitados porque estão em uso. Observe a tabela inferior para ver onde o idioma é usado. Quando um idioma não for mais usado pelo GEDCOM ou pelo usuário, você poderá desativá-lo.<br /><br />Todas as suas mudanças serão gravadas em um novo arquivo chamado <b>lang_settings.php</b> criado no diretório <b>#INDEX_DIRECTORY#</b>. Todas as suas alterações posteriores serão feitas neste novo arquivo e PhpGedView usará apenas <u>este</u> arquivo. Você pode reverter para as configurações de idioma padrão originais excluindo este arquivo.<br /><br />Se você deve relatar problemas com as configurações de idioma, por favor, informe a equipe de suporte do PhpGedView se este novo arquivo está presente ou não.";
$pgv_lang["active"]								= "Ativa";
$pgv_lang["active_help"]						= "~#pgv_lang[active]#~<br /><br />Permite que os usuários selecionem este idioma se a opção <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> estiver habilitada.";
$pgv_lang["edit_settings"]						= "Editar Configurações";
$pgv_lang["lang_edit"]							= "Editar";
$pgv_lang["lang_language"]						= "Idioma";
$pgv_lang["export_filename"]					= "Nome do arquivo de saída:";
$pgv_lang["lang_back"]							= "Retorne ao menu principal para editar e configurar os arquivos de idioma";
$pgv_lang["lang_back_admin"]					= "Voltar ao menu Admin";
$pgv_lang["lang_back_manage_gedcoms"]			= "Retornar ao menu de gerenciamento GEDCOM";
$pgv_lang["lang_name_arabic"]					= "Árabe";
$pgv_lang["lang_name_catalan"]					= "Catalão (Valencià)";
$pgv_lang["lang_name_chinese"]					= "Chinês (Tradicional)";
$pgv_lang["lang_name_chinese-cn"]				= "Chinês (Simplificado)";
$pgv_lang["lang_name_croatian"]					= "Croata";
$pgv_lang["lang_name_czech"]					= "Tcheco";
$pgv_lang["lang_name_danish"]					= "Dinamarquês";
$pgv_lang["lang_name_dutch"]					= "Holandês";
$pgv_lang["lang_name_english"]					= "Inglês";
$pgv_lang["lang_name_estonian"]					= "Estônio";
$pgv_lang["lang_name_finnish"]					= "Finlandês";
$pgv_lang["lang_name_french"]					= "Francês";
$pgv_lang["lang_name_german"]					= "Alemão";
$pgv_lang["lang_name_greek"]					= "Grego";
$pgv_lang["lang_name_hebrew"]					= "Hebraico";
$pgv_lang["lang_name_hungarian"]				= "Húngaro";
$pgv_lang["lang_name_indonesian"]				= "Indonésio";
$pgv_lang["lang_name_italian"]					= "Italiano";
$pgv_lang["lang_name_lithuanian"]				= "Lituano";
$pgv_lang["lang_name_norwegian"]				= "Norueguês";
$pgv_lang["lang_name_polish"]					= "Polonês";
$pgv_lang["lang_name_portuguese"]				= "Português";
$pgv_lang["lang_name_romanian"]					= "Romeno";
$pgv_lang["lang_name_russian"]					= "Russo";
$pgv_lang["lang_name_serbian-la"]				= "Sérvio (Alfabeto Latino)";
$pgv_lang["lang_name_slovak"]					= "Eslovaco";
$pgv_lang["lang_name_slovenian"]				= "Esloveno";
$pgv_lang["lang_name_spanish"]					= "Espanhol";
$pgv_lang["lang_name_spanish-ar"]				= "Espanhol Latino Americano";
$pgv_lang["lang_name_swedish"]					= "Sueco";
$pgv_lang["lang_name_turkish"]					= "Turco";
$pgv_lang["lang_name_vietnamese"]				= "Vietnamita";
$pgv_lang["lang_name_unknown"]					= "Nenhum desses idiomas";		// used ONLY in "Find Special Characters"
$pgv_lang["lang_new_language"]					= "Novo idioma";
$pgv_lang["original_lang_name"]					= "Nome original do idioma em #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]			= "~Nome original do idioma~<br /><br /> Como esse idioma é denominado neste idioma?<br /><br /> O inglês se autodenomina <b>English</b>; O alemão se autodenomina <b>Deutsch</b>; O holandês se autodenomina <b>Nederlands</b>; O tcheco se autodenomina <b>Ceština</b>, etc.";
$pgv_lang["lang_shortcut"]						= "Abreviatura para arquivos de idioma";
$pgv_lang["lang_shortcut_help"]					= "~#pgv_lang[lang_shortcut]#~<br /><br />Este código define uma abreviação para o nome do idioma. Esta abreviatura faz parte do nome de cada um dos arquivos de idioma usados pelo PhpGedView. Por exemplo, a abreviatura usada para o francês é <b>fr</b> e, consequentemente, os nomes dos arquivos para o francês são <i>admin.<b>fr</b>.php</i>, <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>editor.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, e <i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode"]						= "Códigos de detecção de idioma";
$pgv_lang["lang_langcode_help"]					= "~#pgv_lang[lang_langcode]#~<br /><br />Esses códigos permitem que o PhpGedView detecte a configuração do idioma preferido do navegador em uso. PhpGedView determina o idioma realmente solicitado pelo navegador, comparando o código de idioma do navegador com esta lista. As entradas individuais da lista devem ser separadas por ponto e vírgula.";
$pgv_lang["lang_filenames"]						= "Arquivos de idioma";
$pgv_lang["lang_filenames_help"]				= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]							= "Arquivo de bandeira";
$pgv_lang["flagsfile_help"]						= "~#pgv_lang[flagsfile]#~<br /><br />Nome do arquivo de imagem da bandeira nacional para o idioma selecionado.<br /><br /> Imagens para muitos países estão disponíveis no site da <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>.<br /><br />Quando você encontrar uma imagem de bandeira de que goste, certo -clique nele e salve a imagem em uma pasta temporária. Em seguida, abra a imagem salva com um editor de imagens adequado (IrfanView é recomendado para sistemas Windows), reduza seu tamanho para 50x32 pixels, que é o tamanho normal usado no PhpGedView, e salve-o como um arquivo GIF na pasta <i><b>images/flags</b></i>. Você possa usar qualquer nome que desejar.";
$pgv_lang["text_direction"]						= "Direção do texto";
$pgv_lang["text_direction_help"]				= "~#pgv_lang[text_direction]#~<br /><br />Identifica a direção usada para escrever o texto no idioma escolhido. A maioria dos idiomas é escrita da esquerda para a direita. Árabe e hebraico são exemplos de idiomas escritos na direção oposta (da direita para a esquerda).";
$pgv_lang["date_format"]						= "Formato de data";
$pgv_lang["date_format_help"] 					= "~#pgv_lang[date_format]#~<br /><br />Este campo define o formato de data a ser usado pelo PhpGedView ao exibir datas do banco de dados. Você pode usar o formato <b>Padrão</b> ou <b>Avançado</b>.<ul><li><b>Padrão</b><br />Os códigos a seguir são usados para representar diferentes elementos da data. Observe que <b>D</b> e <b>M</b> têm significados diferentes no formato <b>Avançado</b>.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dia do mês, sem zeros à esquerda; ou seja, 1 a 31<br /><b>M</b>&nbsp;&nbsp;nome do mês; ou seja, janeiro, fevereiro, etc.<br /><b>Y</b>&nbsp;&nbsp;ano inteiro, por exemplo, 1999 ou 44A.C.<br /><b>R</b>&nbsp;&nbsp;Conversão de calendário. Consulte o tópico <b>Conversão de calendário</b> abaixo para obter uma descrição desse código.</p>Esses códigos podem ser combinados em qualquer ordem, junto com espaços e pontuação. Por exemplo, suponha que seu GEDCOM contenha a data 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">Um usuário <b>inglês</b> pode definir o formato como <b>D&nbsp;M&nbsp;Y</b> para obter <b>20&nbsp;August&nbsp;1965.</b><br />Um usuário <b>americano</b> pode definir o formato para <b>M&nbsp;D,&nbsp;Y</b> para obter <b>August&nbsp;20,&nbsp;1965</b><br />Um usuário <b>alemão</b> pode definir o formato como <b>D.&nbsp;M&nbsp;Y</b> para obter <b>20.&nbsp;August&nbsp;1965</b><br />Um usuário <b>húngaro</b> pode definir o formato como <b>Y.&nbsp;M&nbsp;D.</b> para obter <b>1965.&nbsp;augusztus&nbsp;20.</b>&nbsp;.</p><br /></li><li><b>Avançado</b><br />Opções de formatação mais complexas estão disponíveis. Se o formato da data incluir uma letra diferente de <b>D</b>, <b>M</b>, <b>Y</b>, ou <b>R</b>, será considerado para usar o formato <b>Avançado</b>.<br /><br />Os seguintes códigos são usados para representar diferentes elementos da data. Observe que <b>D</b> e <b>M</b> têm significados diferentes no formato <b>Padrão</b>.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dia do mês, com zeros à esquerda; ou seja, 01 a 31<br /><b>j</b>&nbsp;&nbsp;dia do mês, sem zeros à esquerda; ou seja, 1 a 31<br /><b>S</b>&nbsp;&nbsp;sufixo ordinal para o número do dia; por exemplo, em inglês, as letras <b>th</b> em <b>4th&nbsp;July</b>.<br /><b>l</b> (minúsculo «L»)&nbsp;&nbsp;dia da semana; ou seja, segunda, terça, etc.<br /><b>D</b>&nbsp;&nbsp;dia da semana abreviado; ou seja, seg, t, qua, qui, sex, sá, d<br /><b>N</b>&nbsp;&nbsp;Número do dia ISO; ou seja, 0 a 6<br /><b>w</b>&nbsp;&nbsp;número do dia; ou seja, 1 a 7<br /><b>z</b>&nbsp;&nbsp;dia do ano; ou seja, 1 a 365 ou 366<br /><b>F</b>&nbsp;&nbsp;nome do mês; ou seja, janeiro, fevereiro, etc.<br /><b>M</b>&nbsp;&nbsp;mês abreviado, ou seja, jan, fev, etc.<br /><b>m</b>&nbsp;&nbsp;número do mês, com zeros à esquerda; ou seja, 01 a 12<br /><b>n</b>&nbsp;&nbsp;número do mês, sem zeros à esquerda; ou seja, 1 a 12<br /><b>Y</b>&nbsp;&nbsp;ano inteiro, por exemplo, 1999 ou 44A.C.<br /><b>y</b>&nbsp;&nbsp;ano abreviado. Alguns calendários permitem que os anos sejam abreviados. Para o calendário judaico, este é o ano sem milhares. Para o calendário gregoriano, é igual ao ano inteiro.<br /><b>R</b>&nbsp;&nbsp;Conversão de calendário. Consulte o tópico <b>Conversão de calendário</b> abaixo para obter uma descrição desse código.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;formato GEDCOM interno</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;código do calendário, por exemplo @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;dia, ou seja, 01 a 31<br /><b>O</b>&nbsp;&nbsp;mês (apenas em inglês), por exemplo JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;ano, por exemplo 1776, 1867, 2007, etc.<br /><br />Para ver as datas não convertidas, use <b>A&nbsp;O&nbsp;E</b> ou <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Alguns exemplos</b>, usando a data 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Set&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8&nbsp;setembro&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Set&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = quarta-feira&nbsp;-&nbsp;08&nbsp;-&nbsp;setembro&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li></ul>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] 					= "<ul><li><b>Conversão de calendário</b><br />O código <b>R</b> é um tanto incomum em seu comportamento. Quando este código aparece no formato de data, a data normal será mostrada uma segunda vez, mas em um sistema de calendário diferente. Os elementos desta data alternativa do calendário obedecerão às mesmas regras da parte principal da especificação do formato, exceto que a saída do código de formatação <b>R</b> está entre parênteses para distingui-la da data normal. Os exemplos fornecidos no calendário <b>Revolucionário Francês</b> tornarão isso um pouco mais claro.<br /><br />O calendário alternativo a ser usado para o código <b>R</b> é determinado de acordo com o idioma da página atual. Quando o idioma da página for hebraico, o calendário <b>judaico</b> será usado. Quando o idioma da página for árabe, o calendário <b>Hijri</b> será usado. Para todos os outros idiomas da página, o calendário <b>Revolucionário Francês</b> é usado.<br /><br />A ação deste código é semelhante à escolha do formato do calendário que você pode fazer na página de configuração GEDCOM. A diferença entre os dois métodos é que o código <b>R</b>, sendo definido no nível de configuração do idioma, funciona apenas em idiomas selecionados, mas em todos os GEDCOMs do site. A opção de calendário definida no nível de configuração GEDCOM funciona em todos os idiomas, mas apenas nos GEDCOMs para os quais essa opção foi definida.<br /><ul><li>Calendário <b>Revolucionário Francês</b>&nbsp;&nbsp;&nbsp;Este calendário também é chamado de calendário <b>Republicano Francês</b>.<br /><br />Exceto por um breve período em maio de 1871, este sistema de calendário estava em uso apenas na França e apenas entre 22&nbsp;SEP&nbsp;1792 e 31&nbsp;DEC&nbsp;1805. Assim, o formato do calendário revolucionário francês só será aplicável quando a data estiver dentro dessa faixa.<br /><br />Dois formatos de data de exemplo, assumindo que o idioma da página seja o inglês, ilustrarão a ação do código <b>R</b>:<br /><b>Y.m.d&nbsp;R</b> poderia produzir <b>1805.04.26&nbsp;(XIII.08.06)</b> ou <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> poderia produzir <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> ou <b>1&nbsp;January&nbsp;1806</b>.</li></ul><br /></li><li><b>Alternativas de idioma</b><br />Os textos abreviados para os códigos avançados <b>D</b> e <b>M</b> são definidos no arquivo <i>languages/lang.xx.php</i>, usando declarações como<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br /Eles podem ser alterados usando um arquivo <i>languages/extra.xx.php</i> conforme descrito no Wiki e no texto ReadMe para ajustes de idioma, por exemplo:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code></li><br /><li><b>Localização</b><br />Existem regras especiais de formatação para vários idiomas, particularmente declínio de finais de meses de acordo com a forma como a data é expressa. Essas regras especiais são implementadas nos vários arquivos<i>includes/extras/functions.xx.php</i>.</li></ul>";
$pgv_lang["time_format"]						= "Formato de hora";
$pgv_lang["time_format_help"]					= "~#pgv_lang[time_format]#~<br /><br />Este campo define o formato de hora a ser usado pelo PhpGedView.<br /><br /> Os símbolos que você pode usar são:<br /><b>a</b> - minúsculo Ante Meridiem e Post Meridiem; ou seja <b>am</b> ou <b>pm</b><br /><b>A</b> - uppercase Ante meridiem e Post meridiem; ou seja <b>AM</b> or <b>PM</b><br /><b>B</b> - Tempo de Internet da Swatch; ou seja <b>000</b> a <b>999</b><br /><b>c</b> - Data ISO 8601; por exemplo <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - dia do mês, 2 dígitos, zero à esquerda; ou seja, <b>01</b> a <b>31</b><br /><b>D</b> - dia, textual, três letras; por exemplo. <b>sseg</b><br /><b>F</b> - mês, textual, longo; por exemplo <b>janeiro</b><br /><b>g</b> - hora, formato de 12 horas, sem zero à esquerda; ou seja, <b>1</b> a <b>12</b><br /><b>G</b> - hora, formato de 24 horas, sem zero à esquerda; ou seja, <b>0</b> a <b>23</b><br /><b>h</b> - hora, formato de 12 horas, zero à esquerda; ou seja, <b>01</b> a <b>12</b><br /><b>H</b> - hora, formato de 24 horas, zero à esquerda; ou seja, <b>00</b> a <b>23</b><br /><b>i</b> - minutos, zero à esquerda; ou seja, <b>00</b> a <b>59</b><br /><b>I</b> (maiúsculo «i») - indicador de horário de verão; <b>1</b> se for horário de verão, <b>0</b> caso contrário.<br /><b>j</b> - dia do mês, sem zero à esquerda; ou seja, <b>1</b> a <b>31</b><br /><b>l</b> (minúsculo «L») - dia da semana, textual, longo; por exemplo <b>sexta</b><br /><b>L</b> - indicador de ano bissexto; <b>1</b> se for um ano bissexto, <b>0</b> caso contrário.<br /><b>m</b> - mês, numérico, zero à esquerda; ou seja, <b>01</b> a <b>12</b><br /><b>M</b> - mês, textual, 3 letras; por exemplo <b>jan</b><br /><b>n</b> - mês, numérico, sem zero à esquerda; ou seja, <b>1</b> a <b>12</b><br /><b>O</b> (maiúsculo «o») - diferença entre o horário local e de Greenwich (GMT) em horas; por exemplo <b>+0200</b><br /><b>r</b> - Data formatada RFC 2822; por exemplo <b>Qui,&nbsp;21&nbsp;Dez&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - segundos, zero à esquerda; ou seja, <b>00</b> a <b>59</b><br /><b>S</b> - sufixo do dia do mês, apenas em inglês, 2 caracteres; ou seja <b>st</b>, <b>nd</b>, <b>rd</b> ou <b>th</b>. Funciona bem com <b>j</b><br /><b>t</b> - número de dias em determinado mês; ou seja, <b>28</b> a <b>31</b><br /><b>T</b> - configuração de fuso horário desta máquina; por exemplo <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - segundos desde o início da Época Unix (janeiro&nbsp;1&nbsp;1970&nbsp;00:00:00&nbsp;GMT)<br /><b>w</b> - dia da semana, numérico; ou seja, <b>0</b> (para domingo) a <b>6</b> (para sábado)<br /><b>W</b> - ISO 8601 semana número do ano, semanas começando na segunda-feira; por exemplo <b>42</b> (a 42ª semana do ano)<br /><b>Y</b> - ano, 4 dígitos; por exemplo. <b>1999</b><br /><b>y</b> - ano, 2 dígitos; por exemplo <b>99</b><br /><b>z</b> - dia do ano, numérico, sem zeros à esquerda; ou seja, <b>0</b> (1 de janeiro) a <b>364</b> (31 de dezembro quando não for um ano bissexto) ou <b>365</b> (31 de dezembro nos anos bissextos)<br /><b>Z</b> - deslocamento de fuso horário em segundos. O deslocamento para fusos horários a oeste de Greenwich é sempre negativo, e para aqueles a leste de Greenwich, o deslocamento é sempre positivo. ou seja, <b>-43200</b> a <b>43200</b><br /><br />Você pode alterar a ordem desses símbolos e adicionar delimitadores ao formato.<br />Por exemplo, em alemão, este campo normalmente contém <b>H:i:s</b> para produzir uma tela como <b>09:01:25</b>.<br />Inglês geralmente define o formato da hora como <b>g:i:sa</b> para produzir uma tela como <b>9:01:25am</b>.<br /><br />No sistema de 24 horas, meia-noite é 00:00. No sistema de 12 horas, meia-noite é 12:00am e meio-dia é 12:00pm.";
$pgv_lang["week_start"]							= "Semana começando dia";
$pgv_lang["week_start_help"]					= "~#pgv_lang[week_start]#~<br /><br />O dia da semana que inicia uma nova semana neste idioma. A maioria dos idiomas começa a semana no domingo, mas alguns começam na segunda-feira ou em outros dias.";
$pgv_lang["name_reverse"]						= "Sobrenome primeiro";
$pgv_lang["name_reverse_help"]					= "~#pgv_lang[name_reverse]#~<br /><br />Em alguns idiomas, o sobrenome deve ser exibido primeiro em vez do padrão para exibi-lo por último. Ativar esta opção exibirá o sobrenome primeiro. Húngaro, chinês e japonês são exemplos em que o sobrenome (o nome de família) geralmente é fornecido primeiro.";
$pgv_lang["ltr"]								= "Direita esquerda para";
$pgv_lang["rtl"]								= "Direita para esquerda";
$pgv_lang["file_does_not_exist"]				= "ERRO! O arquivo não existe...";
$pgv_lang["optional_file_not_exist"]			= "Este arquivo opcional não existe.";
$pgv_lang["alphabet_upper"]						= "Alfabeto maiúsculo";
$pgv_lang["alphabet_upper_help"]				= "~#pgv_lang[alphabet_upper]#~<br /><br />Letras maiúsculas do alfabeto neste idioma. Este alfabeto é usado ao classificar listas de nomes.";
$pgv_lang["alphabet_lower"]						= "Alfabeto minúsculo";
$pgv_lang["alphabet_lower_help"]				= "~#pgv_lang[alphabet_lower]#~<br /><br />Letras minúsculas do alfabeto neste idioma. Este alfabeto é usado ao classificar listas de nomes.";
$pgv_lang["multi_letter_alphabet"]				= "Alfabeto de várias letras";
$pgv_lang["multi_letter_alphabet_help"]			= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Combinações de várias letras que devem ser tratadas como uma única letra distinta ao classificar listas de nomes e títulos neste idioma.<br /><br />Alguns idiomas, húngaro e eslovaco, por exemplo, consideram certas combinações de letras como distintas letras por direito próprio. A ordem em que você especifica essas combinações de letras determina a ordem em que são inseridas no alfabeto normal durante a classificação. Isso é importante quando várias combinações de várias letras têm a mesma primeira letra. Exceto para <b>ch</b>, essas combinações de letras são inseridas no alfabeto normal de acordo com sua primeira letra. <b>ch</b> é sempre inserido após <b>h</b>.";
$pgv_lang["multi_letter_equiv"]					= "Equivalentes de várias letras";
$pgv_lang["multi_letter_equiv_help"]			= "~#pgv_lang[multi_letter_equiv]#~<br /><br />Em alguns idiomas, várias letras são frequentemente tratadas como equivalentes a uma única letra ao gerar listas de nomes.<br /><br />Por exemplo, em holandês, nomes que começam com <b>IJ</b> são listados junto com nomes que começam com <b>Y</b>. Em norueguês, os nomes que começam com <b>Aa</b> são listados com <b>&Aring;</b>. Em alguns idiomas, existem letras que podem ser escritas como um ou dois caracteres. Por exemplo, em eslovaco, os dois caracteres D e \xC5\xBE podem ser escritos como o único caractere \xC7\x85. Ao especificar equivalentes aqui, você pode permitir que nomes que começam com essas letras sejam agrupados nas páginas de lista individuais.<br /><br />Você deve especificar uma lista de equivalentes separados por vírgulas. Para oferecer suporte a bancos de dados que não reconhecem a codificação UTF-8, você deve especificar equivalentes em maiúsculas e minúsculas. Este exemplo demonstra o formato a ser usado.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]					= "Use as regras do dicionário ao classificar";
$pgv_lang["dictionary_sort_help"]				= "~#pgv_lang[dictionary_sort]#~<br /><br />Esta opção controla como os caracteres com sinais diacríticos são tratados ao classificar listas de nomes e títulos.<br /><br />Quando definido como <b>#pgv_lang[yes]#</b>, todos os caracteres com sinais diacríticos são tratados como se não tivessem quaisquer marcas. Os sinais diacríticos são considerados apenas quando as duas palavras consideradas são idênticas. Quando definido como <b>#pgv_lang[no]#</b>, todas as letras são distintas, independentemente da presença ou ausência de marcas diacríticas.";
$pgv_lang["collation"]							= "Sequência de agrupamento de banco de dados";
$pgv_lang["collation_help"]						= "~#pgv_lang[collation]#~<br /><br />Se você estiver usando as regras de agrupamento integradas do banco de dados, esta opção especifica a seqüência de agrupamento a ser usada para este idioma. Você deve garantir que seu banco de dados suporte todas as sequências de agrupamento que você pretende usar.<br /><br />O uso de agrupamento de banco de dados é controlado nas definições de configuração do site.";
$pgv_lang["lang_config_write_error"]			= "Erro ao gravar as configurações de idioma no arquivo <i>language_settings.php</i>. Por favor, verifique as permissões e tente novamente.";
$pgv_lang["lang_set_file_read_error"]			= "E R R O !!! Não foi possível ler <b>lang_settings.php</b>!";
$pgv_lang["add_new_language_help"]				= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]				= "Esta rotina permite adicionar um idioma novo, anteriormente indisponível e completamente não suportado ao PhpGedView.<br /><br />Você pode definir as configurações padrão do novo idioma. Isso inclui código de detecção de idioma, direção de idioma, início da semana para este idioma, configurações de hora, alfabeto, etc.<br /><br />Você obterá mais ajuda sobre as configurações de idiomas suportados pelo PhpGedView após selecionar o idioma e clicando no botão <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Mais ajuda está disponível na página de configuração para o idioma.";
$pgv_lang["add_new_lang_button"]				= "Adicionar novo idioma";
$pgv_lang["hide_translated"]					= "Ocultar traduzidos";
$pgv_lang["hide_translated_help"]				= "~#pgv_lang[hide_translated]#~<br /><br />Se definido como <b>#pgv_lang[yes]#</b>, você verá apenas as mensagens do arquivo de idioma selecionado que não foram traduzidas. Isso significa que a nova mensagem <u>não</u> aparece no arquivo de idioma de destino.<br /><br /> Alguns arquivos de idioma contêm texto em inglês para várias mensagens não traduzidas. Esta rotina não consegue identificar esses itens não traduzidos, pois eles já estão presentes no arquivo de destino. A suposição é: «Se a mensagem estiver presente no arquivo de destino, ela deve ter sido traduzida.»";
$pgv_lang["lang_file_write_error"]				= "E R R O !!! Não foi possível gravar alterações no arquivo de idioma selecionado. Verifique as permissões de gravação em <b>#lang_filename#</b>";
$pgv_lang["no_open"]							= "E R R O !!! Não pode abrir o arquivo <b>#lang_filename#</b>";
$pgv_lang["users_langs"]						= "Idiomas dos usuários";
$pgv_lang["configured_languages"]				= "Idiomas usados";

//-- User Migration Tool messages
$pgv_lang["um_header"] 							= "Ferramenta de migração de informações de usuários";
$pgv_lang["um_proceed"] 						= "Escolha uma opção ou clique no link abaixo para retornar ao menu Administração";
$pgv_lang["um_creating"] 						= "Criando";
$pgv_lang["um_sql_index"] 						= "Esta ferramenta criará <i>authenticate.php</i> e vários arquivos <i>.dat</i> em seu diretório index.<br /><br />Após a criação bem-sucedida, você pode alternar para o modo Index com todos os usuários atuais e suas mensagens, favoritos, notícias e layout MyGedview disponíveis.<br /><br />Nota: Após alternar para o modo Index, você precisará importar seus arquivos GEDCOM novamente.";
$pgv_lang["um_file_create_fail1"] 				= "A criação do novo arquivo falhou, já existe um arquivo com esse nome:";
$pgv_lang["um_file_create_fail2"] 				= "Não pode criar";
$pgv_lang["um_file_create_fail3"] 				= "Verifique os direitos de acesso neste diretório.";
$pgv_lang["um_file_create_succ1"] 				= "Criação de novo arquivo com sucesso:";
$pgv_lang["um_file_not_created"] 				= "O arquivo não foi criado.";
$pgv_lang["um_nomsg"] 							= "Nenhuma mensagem parece estar presente no sistema.";
$pgv_lang["um_nofav"] 							= "Nenhum favorito parece estar presente no sistema.";
$pgv_lang["um_nonews"] 							= "Nenhuma notícia parece estar presente no sistema.";
$pgv_lang["um_noblocks"] 						= "Nenhum bloco parece estar presente no sistema.";
$pgv_lang["um_index_sql"] 						= "Esta ferramenta importará <i>authenticate.php</i> e outros arquivos <i>.dat</i> de seu diretório index para seu banco de dados.";
$pgv_lang["um_noaction"] 						= "Nenhuma ação é necessária para migrar as informações do usuário para o modo SQL.<br /><br /Depois de alternar para o modo SQL, você precisa reiniciar a <b>#pgv_lang[um_header]#</b> para importar todos os dados para o banco de dados SQL. PhpGedView usará arquivos existentes no modo de índice.<br /><br /<b><u>Não</u> remova arquivos <i>authenticate.php</i> e <i>.dat</i> de seu diretório index durante a troca.</b>";
$pgv_lang["um_import"] 							= "Importar";
$pgv_lang["um_export"] 							= "Exportar";
$pgv_lang["um_explain"] 						= "Esta ferramenta exportará dados do usuário do SQL para o modo de índice ou importará dados do usuário de arquivos de índice para tabelas SQL.<br /><br />Dados do usuário, favoritos, definições de bloco, mensagens e notícias estarão disponíveis novamente após a migração.<br /><br /><b>CUIDADO</b><br />Você não pode usar esta ferramenta para migrar dados do usuário entre diferentes versões do PhpGedView. Certifique-se de que os dados são originados ou importados para a mesma versão do PhpGedView.<br /><br /><b>IMPORTAR</b><br />Se você escolher importar os arquivos de dados do usuário do modo Índice, todos os dados do usuário presentes nas tabelas do banco de dados serão <u>sobrescritos</u>. Esta ferramenta <u>não</u> mescla as informações. Depois de executar o Import, não há como recuperar as informações antigas usando PhpGedView.<br /><br /><b>EXPORTAR</b><br />Se você exportar as informações do usuário de seu banco de dados SQL para Arquivos no modo index, esta ferramenta criará <i>authenticate.php</i> e vários arquivos <i>.dat</i> em seu diretório index. Se arquivos com nomes idênticos já estiverem presentes, você será questionado se eles devem ser substituídos. Após alternar para o modo Index, todas as informações estarão disponíveis diretamente.<br /><br /><b>Observação:</b> Após alternar para o modo Índice, você precisará importar seus arquivos GEDCOM novamente.";
$pgv_lang["um_tool_help"] 						= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] 					= "~Migrar usuários do SQL para o modo Index~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] 					= "~Migrar usuários do modo Index para SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] 						= "Importando usuários";
$pgv_lang["um_imp_blocks"] 						= "Importando blocos";
$pgv_lang["um_imp_favorites"] 					= "Importando favoritos";
$pgv_lang["um_imp_messages"] 					= "Importando mensagens";
$pgv_lang["um_imp_news"] 						= "Importando notícias";
$pgv_lang["um_nousers"] 						= "O arquivo <i>authenticate.php</i> não foi encontrado no diretório de índice. A migração foi cancelada.";
$pgv_lang["um_imp_succ"] 						= "Importação com sucesso";
$pgv_lang["um_imp_fail"] 						= "Importação falhou";
$pgv_lang["um_backup"] 							= "Backup";
$pgv_lang["um_zip_succ"] 						= "Arquivo ZIP criado";
$pgv_lang["um_zip_dl"] 							= "Baixar arquivo de backup ZIP";
$pgv_lang["um_bu_explain"] 						= "Esta ferramenta pode fazer backup de vários tipos de dados no PhpGedView.<br /><br />Os dados que você escolher para fazer backup serão reunidos em um arquivo ZIP, que você pode baixar clicando no link na parte inferior do página, após o backup ter sido feito<br /><br />O arquivo ZIP permanecerá no diretório Index até que você o remova manualmente.";
$pgv_lang["um_bu_help"] 						= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 						= "Arquivo de configuração PhpGedView";
$pgv_lang["um_bu_gedcoms"] 						= "Arquivos GEDCOM";
$pgv_lang["um_bu_gedsets"] 						= "Configurações GEDCOM, arquivos de configuração e privacidade";
$pgv_lang["um_bu_logs"] 						= "Logs de pesquisa GEDCOM e arquivos de log PhpGedView";
$pgv_lang["um_bu_usinfo"] 						= "Definições de usuário, configurações de bloqueio, favoritos, mensagens, notícias";
$pgv_lang["um_bu_media"]						= "Arquivos de mídia";
$pgv_lang["um_mk_bu"] 							= "Faça backup";
$pgv_lang["um_nofiles"] 						= "Nenhum arquivo encontrado para backup.";
$pgv_lang["um_files_exist"] 					= "Um ou mais arquivos já existem. Você deseja substituí-los?";
$pgv_lang["um_results"]							= "Resultados";
$pgv_lang["preview_faq_item"] 					= "Visualize todos os itens de FAQ";
$pgv_lang["preview_faq_item_help"] 				= "~#pgv_lang[preview_faq_item]#~<br /><br />Esta opção permite que um usuário administrador visualize a página de FAQ sem todas as opções de edição e links.<br /><br />Exceto por um único link <b>Editar</b> acima do primeiro item de FAQ, a aparência do FAQ página será idêntica ao que um usuário comum veria. Este link especial <b>Editar</b> irá restaurar a funcionalidade completa de edição da página de perguntas frequentes.";
$pgv_lang["restore_faq_edits"] 					= "Restaurar funcionalidade de edição de FAQ";
$pgv_lang["restore_faq_edits_help"] 			= "~#pgv_lang[restore_faq_edits]#~<br /><br />Esta opção restaura a página de FAQ para o que um usuário administrador normalmente vê, para que itens individuais de FAQ possam ser editados.";
$pgv_lang["add_faq_item"] 						= "Adicionar item de FAQ";
$pgv_lang["add_faq_item_help"] 					= "~#pgv_lang[add_faq_item]#~<br /><br />Esta opção permitirá que você adicione um item à página de perguntas frequentes.";
$pgv_lang["edit_faq_item"] 						= "Editar item de FAQ";
$pgv_lang["edit_faq_item_help"] 				= "~#pgv_lang[edit_faq_item]#~<br /><br />Esta opção permitirá que você edite um item na página de FAQ.";
$pgv_lang["delete_faq_item"] 					= "Excluir item de FAQ";
$pgv_lang["delete_faq_item_help"] 				= "~#pgv_lang[delete_faq_item]#~<br /><br />Esta opção permitirá que você exclua um item da página de FAQ";
$pgv_lang["moveup_faq_item"] 					= "Mover item de FAQ para cima";
$pgv_lang["moveup_faq_item_help"] 				= "~#pgv_lang[moveup_faq_item]#~<br /><br />Esta opção permitirá que você mova um item para cima na página de FAQ.<br /><br />Cada vez que você usa esta opção, o número da posição de FAQ deste item é reduzido em um. Você pode obter o mesmo efeito editando o item em questão e alterando o campo Posição da FAQ. Quando mais de um item de FAQ tem o mesmo número de posição, apenas um desses itens estará visível.";
$pgv_lang["movedown_faq_item"] 					= "Mova o item do FAQ para baixo";
$pgv_lang["movedown_faq_item_help"] 			= "~#pgv_lang[movedown_faq_item]#~<br /><br />Esta opção permitirá que você mova um item para baixo na página de FAQ.<br /><br />Cada vez que você usa esta opção, o número da Posição de FAQ deste item é aumentado em um. Você pode obter o mesmo efeito editando o item em questão e alterando o campo Posição da FAQ. Quando mais de um item de FAQ tem o mesmo número de posição, apenas um desses itens estará visível.";
$pgv_lang["add_faq_header_help"] 				= "~#pgv_lang[add_faq_header]#~<br /><br />Este é o título ou assunto do item do FAQ.<br /><br />O que você inserir aqui pode ser formatado. Tags HTML, como &lt;b&gt; e &lt;br /&gt; são permitidos, assim como entidades HTML, como &amp;amp; e &amp;nbsp;. Tags HTML diferentes de &lt;br /&gt; provavelmente não são muito úteis no título do FAQ e devem ser evitados.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] 					= "~#pgv_lang[add_faq_body]#~<br /><br />O texto do item do FAQ é inserido aqui.<br /><br />O texto pode ser formatado. Tags HTML, como &lt;b&gt; e &lt;br /&gt; são permitidos, assim como entidades HTML, como &amp;amp; e &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] 						= "As entidades HTML são uma maneira muito fácil de adicionar caracteres especiais aos títulos e ao texto do FAQ. Você pode usar nomes simbólicos, números decimais ou números hexadecimais. Uma lista completa de entidades HTML, sua codificação e sua representação por seu navegador pode ser encontrada aqui: <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">Listas de entidades HTML</a><br /><br />Ocasionalmente, pode ser necessário mostrar um caractere Til&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;ou um Sinal numérico&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;em seus URLs ou texto. Esses caracteres têm um significado especial para o sistema de Ajuda do PhpGedView e só podem ser inseridos em sua forma hexadecimal ou decimal. Da mesma forma, os&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;e&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;e&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;caracteres que geralmente incluem as tags HTML devem ser inseridos em hexadecimal ou decimal formulários se eles devem ser tratados como texto normal em vez de sinalizar uma tag HTML.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;vai resultar em&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;vai resultar em&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;vai resultar em&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;ou&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;vai resultar em&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Existe uma entidade HTML&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;mas este símbolo não é interpretado como um Til quando codificado em URLs.";
$pgv_lang["add_faq_pgvLangRefs"] 				= "Você pode inserir referências a entradas nos arquivos de idioma ou a valores de variáveis globais. Exemplos:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;é uma referência à variável de linguagem \$pgv_lang[\"add_to_cart\"], e se aparecesse neste campo, seria mostrado como <b>#pgv_lang[add_to_cart]#</b> quando a lista de perguntas frequentes é exibida no idioma atual.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;é uma referência ao nome do fato \$factarray[\"AFN\"], e se aparecesse neste campo, seria mostrado como <b>#factarray[AFN]#</b> quando a lista de perguntas frequentes é exibida no idioma atual.</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;é uma referência à constante PGV_VERSION, um espaço, e uma referência à constante PGV_VERSION_RELEASE, e se elas aparecessem neste campo, seriam mostradas como <b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b> quando a lista de perguntas frequentes é exibida no idioma atual.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;é uma referência à variável global \$GEDCOM, que é o nome do arquivo GEDCOM atual. Se aparecesse neste campo, seria mostrado como <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;é uma referência à variável global \$GEDCOM_TITLE, que é o título do arquivo GEDCOM atual. Se aparecesse neste campo, seria mostrado como <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Este recurso é útil quando você deseja criar listas de perguntas frequentes que sejam diferentes para cada idioma que seu site suporta. Você deve colocar os títulos e entradas de sua lista de FAQs personalizados nos arquivos <i>languages/extra.xx.php</i> (<i>xx</i> é o código para cada idioma), usando o seguinte formato:<br /><code>\$pgv_lang[\"faq_title1\"]&nbsp;=&nbsp;\"Este é um exemplo de título de FAQ\";<br />\$pgv_lang[\"faq_body1\"]&nbsp;=&nbsp;\"Este é um exemplo de texto de FAQ.\";</code>";
$pgv_lang["add_faq_order_help"] 				= "~#pgv_lang[add_faq_order]#~<br /><br />Este campo controla a ordem em que os itens do FAQ são exibidos.<br /><br />Você não precisa inserir os números sequencialmente. Se você deixar lacunas no esquema de numeração, poderá inserir outros itens posteriormente. Por exemplo, se você usar os números 1, 6, 11, 16, poderá inserir itens posteriormente com os números de sequência ausentes. Números negativos e zero são permitidos e podem ser usados para inserir itens na frente do primeiro.<br /><br />Quando mais de um item do FAQ tem o mesmo número de posição, apenas um desses itens estará visível.";
$pgv_lang["add_faq_visibility_help"] 			= "~#pgv_lang[add_faq_visibility]#~<br /><br />Você pode determinar se este FAQ será visível independentemente do GEDCOM ou se será visível apenas para o GEDCOM atual.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;O FAQ aparecerá em todas as listas de FAQ, independentemente do GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;O FAQ aparecerá apenas na lista de FAQ do GEDCOM atualmente ativo.</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"]			= "O texto GEDCOM News permite o uso de <b>tags HTML</b> e <b>entidades HTML</b>. HTML não deve ser usado em títulos de notícias.<br /><br />Certifique-se de usar sempre as tags de início e fim. Pode ser útil ter um conhecimento de HTML apropriado para um administrador de site. Este programa também usa <b>Cascading Style Sheets (CSS)</b>. Um CSS diferente é implementado para cada tema. Você pode usar classes dessas folhas de estilo para controlar a aparência de suas mensagens.<br /><br />Se precisar de mais ajuda com isso, o site PhpGedView tem alguns exemplos de como usar essas tags em seu bloco GEDCOM News.<br /><br />Tal como acontece com a lista de FAQ, títulos de Notícias GEDCOM e textos de Notícias permitem referências incorporadas a variáveis \$pgv_lang, \$factarray e \$GLOBALS para fornecer flexibilidade completa na criação de itens de Notícias sensível ao idioma ativo no momento.<br /><br />A descrição a seguir, retirada do texto de Ajuda da lista de perguntas frequentes, é igualmente aplicável aos itens de notícias GEDCOM.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"]					= "~#pgv_lang[time_limit]#~<br /><br />O tempo máximo que a importação pode ser executada para processar o arquivo GEDCOM.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] 				= "Resultados encontrados";
$pgv_lang["ged_filter_reset"] 					= "Limpar pesquisa";
$pgv_lang["ged_filter_description"] 			= "Texto da opção de pesquisa";
$pgv_lang["ged_filter_description_help"] 		= "~#pgv_lang[ged_filter_description]#~<br /><br />Esta opção permite pesquisar o texto associado às opções de configuração<br /><br />À medida que você digita as letras, a pesquisa encontrará todas as opções de configuração que contêm aquela sequência de letras. A pesquisa se torna mais precisa à medida que você digita mais letras.";

?>
