<?php
/**
 * Chinese (Simplified) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 to 2021  PGV Development Team.  All rights reserved.
 *
 * This program is free software;you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @version $Id: configure_help.zh-cn.php 7287 2021-02-14 14:41:32Z canajun2eh $
 * @translation mr_bobwang
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "网站设置";

//-- edit privacy messages
$pgv_lang["edit_privacy"]		= "隐私文件设置";
$pgv_lang["SHOW_LIVING_NAMES"]			= "显示健在人员名单";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "编辑语言文件";
$pgv_lang["edit_lang_utility"]		= "语言编辑工具";
$pgv_lang["edit_lang_utility_help"]	= "您能使用这项公共事业编辑语言文件的内容由使用内容英国一个。<br />它将列出您原始的英语文件的内容和您选上的语言内容<br />在点击在您选上的文件消息以后一个新窗口将打开您能改变和保存您选上的语言消息的地方。";
$pgv_lang["language_to_edit"]		= "编辑的语言";
$pgv_lang["file_to_edit"]		= "编辑的语言文件";
$pgv_lang["check"]			= "检查";
$pgv_lang["lang_save"]			= "保存";
$pgv_lang["contents"]			= "内容";
$pgv_lang["listing"]			= "目录";
$pgv_lang["no_content"]			= "没有内容";
$pgv_lang["editlang"]			= "编辑";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />编辑语言文件的信息";
$pgv_lang["savelang"]			= "保存";
$pgv_lang["cancel"]			= "取消";
$pgv_lang["savelang_help"]		= "#pgv_lang[savelang]#~<br /><br />保存信息到语言文件。";
$pgv_lang["original_message"]		= "原始的消息";
$pgv_lang["message_to_edit"]		= "编辑的信息";
$pgv_lang["changed_message"]		= "改变后的信息";
$pgv_lang["message_empty_warning"]	= "-> 警告!!! 这个信息没有在#LANGUAGE_FILE#<- 里面。";
$pgv_lang["language_to_export"]		= "导出的语言";
$pgv_lang["export_lang_utility"]	= "导出语言文件";
$pgv_lang["export"]			= "导出";
$pgv_lang["compare_lang_utility"]	= "语言比较";
$pgv_lang["new_language"]		= "原语言";
$pgv_lang["compare"]			= "比较";
$pgv_lang["comparing"]			= "比较的语言文件";
$pgv_lang["config_lang_utility"]	= "设置支持的语言";
$pgv_lang["active"]			= "工作状态中";
$pgv_lang["edit_settings"]		= "编辑设置";
$pgv_lang["lang_edit"]			= "编辑";
$pgv_lang["lang_language"]		= "语言";
$pgv_lang["export_filename"]		= "导出的文件名:";
$pgv_lang["lang_name_chinese-cn"]		= "简体中文";
$pgv_lang["lang_name_chinese"]		= "繁体中文";
$pgv_lang["lang_name_english"]		= "英文";
$pgv_lang["lang_new_language"]		= "新的语言";
$pgv_lang["lang_langcode"]		= "语言的网页代码号";
$pgv_lang["lang_filenames"]		= "语言文件";
$pgv_lang["flagsfile"]			= "国旗文件";
$pgv_lang["text_direction"]		= "写字方向";
$pgv_lang["date_format"]			= "年月日格式";
$pgv_lang["time_format"]		= "时间格式";
$pgv_lang["week_start"]			= "一周的开始日";
$pgv_lang["name_reverse"]		= "姓在前";
$pgv_lang["ltr"]			= "从左到右";
$pgv_lang["rtl"]			= "从右到左";
$pgv_lang["file_does_not_exist"]	= "错误！文件不存在...";
$pgv_lang["optional_file_not_exist"]	= "多选的文件不存在。";
$pgv_lang["multi_letter_alphabet"]		= "多字母的单字";
$pgv_lang["dictionary_sort"]		= "用字典的格式来排列";
$pgv_lang["add_new_lang_button"]	= "增加新语言";
$pgv_lang["hide_translated"]		= "不要显示翻译过的信息";
$pgv_lang["users_langs"]			= "用户的语言";
$pgv_lang["configured_languages"]	= "被用的语言";
$pgv_lang["um_header"] = "用户转移工具";
$pgv_lang["um_creating"] = "创建中";
$pgv_lang["um_file_create_fail2"] = "不可以创建";
$pgv_lang["um_import"] = "导入";
$pgv_lang["um_export"] = "导出";
$pgv_lang["um_imp_succ"] = "导入成功";
$pgv_lang["um_imp_fail"] = "导入失败";
$pgv_lang["um_backup"] = "备份";
$pgv_lang["um_zip_succ"] = "压缩的文件成果创建";
$pgv_lang["um_zip_dl"] = "下载压缩的备份文件";
$pgv_lang["um_bu_config"] = "家谱设置文件";
$pgv_lang["um_bu_gedcoms"] = "家谱文件";
$pgv_lang["um_bu_media"]	= "多媒体文件";
$pgv_lang["um_mk_bu"] = "创建悲愤";
$pgv_lang["um_results"]		= "结果";
$pgv_lang["ged_filter_results"] = "搜索结果";
$pgv_lang["ged_filter_reset"] = "清除搜索";
$pgv_lang["ged_filter_description"] = "搜索选项";

$pgv_lang["new_gedcom_title"]		= "家谱来自于[#GEDCOMFILE#] 文件";
$pgv_lang["USE_MEDIA_VIEWER"]			= "使用媒体展览器";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "显示个人关系";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "自动生成缩略图";
$pgv_lang["SHOW_SOURCES"]			= "显示来源";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "名字底下划线";
$pgv_lang["gedcom_conf"]		= "家谱简单信息";
$pgv_lang["media_conf"]			= "多媒体";
$pgv_lang["media_general_conf"]	= "普通";
$pgv_lang["displ_names_conf"]	= "名字";
$pgv_lang["displ_layout_conf"]	= "格式";
$pgv_lang["contact_conf"]		= "联系方法";
$pgv_lang["DBUSER"]			= "数据库用户名";
$pgv_lang["DBNAME"]			= "数据库名称";
$pgv_lang["upload_path"]			= "上载文件夹";
$pgv_lang["LANGUAGE"]			= "语言";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "允许用户改变语言";
$pgv_lang["CALENDAR_FORMAT"]		= "日历格式";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "默认显示几代人";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "最大几代人限度";
$pgv_lang["GENERATE_GUID"]		= "自动创造新代码号";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "个人的代码号编码";
$pgv_lang["SOURCE_ID_PREFIX"]		= "来源的代码号编码";
$pgv_lang["REPO_ID_PREFIX"]		= "文件夹的代码号编码";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "在表中显示出生和去世日";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "表中显示性别标志";
$pgv_lang["ZOOM_BOXES"]			= "表中有放大功能";
$pgv_lang["SHOW_AGE_DIFF"]			= "显示日期差异";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "开启隐私功能";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "强制用户登录";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "登录页有欢迎短信";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "自己的欢迎短信";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "允许在网络上更改编辑";
$pgv_lang["EDIT_AUTOCLOSE"]		= "自动关闭编辑窗口";
$pgv_lang["POSTAL_CODE"]  = "邮编号码位置";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "个人中最多姓";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "家庭中最多的姓";
$pgv_lang["SURNAME_LIST_STYLE"]		= "姓列表的格式";
$pgv_lang["NAME_FROM_GEDCOM"]		= "从家铺文件中读取姓名";
$pgv_lang["SHOW_LAST_CHANGE"]		= "选择家谱记录近期改变的日期";
$pgv_lang["google_analytics_help"] = "~#pgv_lang[google_analytics]#~<br /><br />#pgv_lang[google_analytics]#服务在此<a href='http://en.wikipedia.org/wiki/Google_Analytics' target='_blank' title='Google Analytics'>维基百科文章</a>。<br /><br />请注意，如果您选择使用此服务，Google会获取其收集的有关访问者活动的所有数据的权利你的网站。";
$pgv_lang["USE_GOOGLE_ANALYTICS_help"] = "~#pgv_lang[USE_GOOGLE_ANALYTICS]#~<br /><br />选择<b>#pgv_lang[yes]#</b>以通过#pgv_lang[google_analytics]#服务跟踪您网站上的活动。在启用此选项之前，必须订阅此服务。";
$pgv_lang["PGV_GOOGLE_ANALYTICS_help"] = "~#pgv_lang[PGV_GOOGLE_ANALYTICS]#~<br /><br />当您订阅#pgv_lang[google_analytics]#服务时，输入分配给您网站的帐号。此帐号的格式为<b>UA-xxxxxx-x</b>。";
$pgv_lang["piwik_analytics_help"] = "~#pgv_lang[piwik_analytics]#~<br /><br />#pgv_lang[piwik_analytics]#开源条目被描述为<a href='https://matomo.org/' target='_blank' title='Matomo官方网站'>这里</a>。<br /><br />Matomo是#pgv_lang[google_analytics]#的替代品，它消除了许多隐私问题。您可以自己安装Matomo应用程序网络服务器或您自己的域，从而确保您可以完全控制已收集的活动数据。";
$pgv_lang["USE_PIWIK_ANALYTICS_help"] = "~#pgv_lang[USE_PIWIK_ANALYTICS]#~<br /><br />选择<b>#pgv_lang[yes]#</b>以启用#pgv_lang[piwik_analytics]#服务对您网站上的活动进行跟踪。 PhpGedView站点必须在Matomo服务器上注册。";
$pgv_lang["PGV_PIWIK_URL_help"] = "~#pgv_lang[PGV_PIWIK_URL]#~<br /><br />输入注册网站的Matomo服务器的URL。";
$pgv_lang["PGV_PIWIK_SITE_help"] = "~#pgv_lang[PGV_PIWIK_SITE]#~<br /><br />输入Matomo服务器分配给PhpGedView站点的数字站点ID。";
$pgv_lang["clustrmaps_analytics_help"] = "~#pgv_lang[clustrmaps_analytics]#~<br /><br />ClustrMaps是一个组合点击计数器，访客跟踪器和地理可视化工具。<br /><br />每个页面都包含由ClustrMaps生成的缩略图图像。当该图像加载时，ClustrMaps网站上的计数器会递增。当所有访问者都可以看到的地图（每日，每周或每月，具体取决于您的流量）时，它会显示所有访问者的位置。自特定时间间隔开始以来的页面。<br /><br />如果您已经为#pgv_lang[clustrmaps_analytics]#服务付费，点击该缩略图地图可以看到更大的世界地图显示。<br /><br />更多细节可以在<a href='http://www.clustrmaps.com/' target='_blank' title='ClustrMaps site'>ClustrMaps网站</a>上找到。";
$pgv_lang["USE_CLUSTRMAPS_ANALYTICS_help"] = "~#pgv_lang[USE_CLUSTRMAPS_ANALYTICS]#~<br /><br />选择<b>#pgv_lang[yes]#</b>以通过#pgv_lang[clustrmaps_analytics]#server跟踪您网站上的活动。";
$pgv_lang["PGV_CLUSTRMAPS_SITE_help"] = "~#pgv_lang[PGV_CLUSTRMAPS_SITE]#~<br /><br />输入您的网站的网址。这个值已经为您填写，您通常不需要更改它。";
$pgv_lang["PGV_CLUSTRMAPS_SERVER_help"] = "~#pgv_lang[PGV_CLUSTRMAPS_SERVER]#~<br /><br />当您激活帐户时，输入#pgv_lang[clustrmaps_analytics]#服务分配的服务器号码。";

$pgv_lang["SHOW_LIST_PLACES"] = "将级别显示在列表中";
$pgv_lang["SHOW_LIST_PLACES_help"] = "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />这决定了在列表的放置字段中显示了多少位置信息。<br /><br />将值设置为<b>9</b>将确保显示所有地方信息。将值设置为<b>0</b>（零）将完全隐藏地点。将值设置为<b>1</b>将显示最顶层等级，通常是国家。设置为<b>2</b>将显示最高的两个等级。第二个最高等级，低于国家，通常是州，省或领地。等等。";

$pgv_lang["keep_media_help"] = "~#pgv_lang[keep_media]#~<br /><br />当上传替代GEDCOM时，现有媒体链接是否应保留在数据库中。<b>否</b>选项将删除现有的媒体链接。数据库，而<b>是</b>选项保留它们。<br /><br />当您将GEDCOM从PhpGedView导出到不处理嵌入式媒体指针的离线GEDCOM维护程序时，此选项很有用正确，然后重新导入，将GEDCOM更改为PhpGedView。在这种情况下，您导出到离线编辑程序的GEDCOM中的媒体指针会被破坏，您必须重新链接所有媒体文件到将GEDCOM重新导入PhpGedView后，正确的人员，家庭和来源记录。<br /><br /><b>是</b>选项告诉PhpGedView保留现有的媒体链接，这样就不会导入更改后的GEDCOM后必须重新创建它们，但这需要离线编辑程序始终生成山姆e人员，家庭和来源识别号码。<br /><br /><i>Family Tree Maker</i>是几个离线编辑程序之一，它们<u>不</u>正确处理媒体GEDCOM中的对象指针。<i>Legacy</i>，以及其他许多人，正确处理这些问题。";
$pgv_lang["USE_MEDIA_VIEWER_help"] = "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />当此选项<b>#pgv_lang[yes]#</b>时，单击图像将生成Media Viewer页面。此页面显示详细信息如果你有足够的权利，你也可以编辑这些细节。<br /><br />当这个选项是<b>#pgv_lang[no]#</b>时，点击图片会产生一个完整的 - 在新窗口中显示大小的图像。";
$pgv_lang["USE_MEDIA_FIREWALL"] = "使用媒体防火墙";
$pgv_lang["USE_MEDIA_FIREWALL_help"] = "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />有关如何使用媒体防火墙的说明，请参阅Wiki。<a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"] = "媒体防火墙根目录";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"] = "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />可以在其中创建受保护的媒体目录的目录。#pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"] = "当此字段为空时，将使用<b>#GLOBALS[INDEX_DIRECTORY]#</b>目录。";
$pgv_lang["MEDIA_FIREWALL_THUMBS"] = "保护受保护图像的缩略图";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"] = "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />当图像在受保护的媒体目录中时，它的缩略图是否也应受到保护？";
$pgv_lang["SHOW_SPIDER_TAGLINE"] = "显示蜘蛛标语";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"] = "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />在为搜索引擎生成的页面上，显示为页面检测到的特定搜索引擎的最后一行。如果启用此选项，则可能会偏向Google&reg;AdSense搜索引擎优化工具。";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />此选项将保留私有化记录中的家庭链接。这意味着您将在谱系图表和其他私人图表上看到空的\"私人\"框这类似于v4.0之前的PhpGedView版本的行为。<br /><br />此设置默认是关闭的。建议不要打开它，将您的GEDCOM配置中的血统根人员指​​向非私人的人。";
$pgv_lang["SYNC_GEDCOM_FILE_help"] = "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />在过去的PGV版本中，待处理的编辑存储在GEDCOM文件中，然后将更改的记录接受到数据库中。从v4开始。 1个挂起的更改不再存储在GEDCOM文件中，而是存储在更改文件中。<br /><br />将此值设置为true将在更改被接受到数据库时更新GEDCOM文件。这将使GEDCOM文件保持同步与数据库的更好兼容性。此字段的默认值为on。<br /><br />您可能希望在接受更改时将其关闭以节省内存。";
$pgv_lang["SYNC_GEDCOM_FILE"] = "将编辑同步到GEDCOM文件中";
$pgv_lang["COMMIT_COMMAND_help"] = "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />如果您希望使用CVS等版本控制系统归档对GEDCOM文件和配置或隐私设置的更改，请在此处输入命令。如果您不想使用版本控制系统，则为空白。有效选项为<b>cvs</b>和<b>svn</b>。";
$pgv_lang["COMMIT_COMMAND"] = "版本控制提交命令";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"] = "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />多站点搜索允许用户搜索您在管理站点管理区域中设置或远程链接到的多个网站。此选项控制是否为Multi现场搜索功能适用于所有人或仅供经过身份验证的用户使用。";
$pgv_lang["SHOW_MULTISITE_SEARCH"] = "显示多站点搜索";
$pgv_lang["SHOW_NO_WATERMARK"] = "谁可以查看非水印图像？";
$pgv_lang["SHOW_NO_WATERMARK_help"] = "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />如果启用了媒体防火墙，用户将看到没有此处指定的权限级别的水印。";
$pgv_lang["WATERMARK_THUMB"] = "为缩略图添加水印？";
$pgv_lang["WATERMARK_THUMB_help"] = "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />如果启用了媒体防火墙，是否应为缩略图添加水印？如果不对缩略图添加水印，则媒体列表的加载速度会更快。";
$pgv_lang["SAVE_WATERMARK_THUMB"] = "在服务器上存储带水印的缩略图？";
$pgv_lang["SAVE_WATERMARK_THUMB_help"] = "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />如果启用了媒体防火墙，除了没有水印的相同缩略图外，是否应该在服务器上存储带水印缩略图的副本？<br /><br />当设置为<b>#pgv_lang[yes]#</b>时，包含水印缩略图的媒体列表将以更高的服务器磁盘空间要求为代价更快地生成。";
$pgv_lang["SAVE_WATERMARK_IMAGE"] = "在服务器上存储带水印的全尺寸图像？";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"] = "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />如果启用了媒体防火墙，除了没有水印的相同图像外，是否应将水印全尺寸图像的副本存储在服务器上？<br /><br />当设置为<b>#pgv_lang[yes]#</b>时，将以更高的服务器磁盘空间要求为代价，更快地生成全尺寸水印图像。";
$pgv_lang["DB_UTF8_COLLATION"] = "使用数据库提供UTF-8校对";
$pgv_lang["DB_UTF8_COLLATION_help"] = "控制PhpGedView是否应该使用数据库的内置排序和整理工具。使用数据库来排序和过滤数据而不是PHP通常更快，尽管并非所有数据库/版本都提供此功能。用于每种语言的归类序列在该语言的设置页面中设置。<br /><br /><span class=\"warning\">重要说明:如果您在第一次创建数据库表之前，应该只将此值设置为YES在现有数据库中选择它可能会导致数据损坏。</span><br /><br />MySQL和PostgreSQL都提供对UTF-8的良好支持，尽管并非所有的归类序列都可用于早期版本的MySQL。其他数据库很少或根本不支持UTF-8。如果您不确定数据库是否支持UTF-8，您应该将此值设置为<b>否</b>。<br /><br />这个<a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia article'><b>Wikipedia文章</b></a>包含有关UTF-8的综合信息和链接。";
$pgv_lang["INDI_FACTS_ADD"] = "个人添加事件";
$pgv_lang["INDI_FACTS_ADD_help"] = "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />这是您的用户可以添加到个人的GEDCOM事件列表。您可以根据需要删除或添加事件名称，甚至是自定义名称来修改此列表此列表中出现的事件名称也不得出现在<i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["INDI_FACTS_UNIQUE"] = "唯一的个人事件";
$pgv_lang["INDI_FACTS_UNIQUE_help"] = "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />这是GEDCOM事件列表，您的用户只能将<u>一次</u>添加到个人。例如，如果BIRT在此列表中，用户将无法向个人添加多个BIRT记录。此列表中显示的事件名称也不得出现在<i>#pgv_lang[INDI_FACTS_ADD]#</i>列表中。";
$pgv_lang["INDI_FACTS_QUICK"] = "快速个人事件";
$pgv_lang["INDI_FACTS_QUICK_help"] = "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />这是完整列表旁边显示的GEDCOM个人事件的简短列表，只需点击一下即可添加。";
$pgv_lang["FAM_FACTS_ADD"] = "家庭添加事件";
$pgv_lang["FAM_FACTS_ADD_help"] = "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />这是您的用户可以添加到家庭的GEDCOM事件列表。您可以根据需要删除或添加事件名称，甚至是自定义名称来修改此列表此列表中出现的事件名称不得出现在<i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["FAM_FACTS_UNIQUE"] = "唯一的家庭事件";
$pgv_lang["FAM_FACTS_UNIQUE_help"] = "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />这是您的用户只能将<u>一次</u>添加到家庭的GEDCOM事件列表。例如，如果MARR在此列表中，用户将无法向一个系列添加多个MARR记录。此列表中显示的事件名称也不得出现在<i>#pgv_lang[FAM_FACTS_ADD]#</i>列表中。";
$pgv_lang["FAM_FACTS_QUICK"] = "快速家庭事件";
$pgv_lang["FAM_FACTS_QUICK_help"] = "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />这是GEDCOM家族事件的简短列表，显示在完整列表旁边，只需点击一下即可添加。";
$pgv_lang["SOUR_FACTS_ADD"] = "来源添加事件";
$pgv_lang["SOUR_FACTS_ADD_help"] = "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />这是您的用户可以添加到源的GEDCOM事件列表。您可以通过删除或添加事件名称来修改此列表，甚至可以根据需要添加自定义名称。此列表中出现的事件名称也不得出现在<i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["SOUR_FACTS_UNIQUE"] = "唯一的来源事件";
$pgv_lang["SOUR_FACTS_UNIQUE_help"] = "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />这是GEDCOM事件列表，您的用户只能将<u>一次</u>添加到源。例如，如果TITL在此列表中，用户将无法向源添加多个TITL记录。此列表中显示的事件名称也不得出现在<i>#pgv_lang[SOUR_FACTS_ADD]#</i>列表中。";
$pgv_lang["SOUR_FACTS_QUICK"] = "快速消息来源";
$pgv_lang["SOUR_FACTS_QUICK_help"] = "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />这是完整列表旁边显示的GEDCOM源事件的简短列表，只需单击即可添加。";
$pgv_lang["REPO_FACTS_ADD"] = "存储库添加事件";
$pgv_lang["REPO_FACTS_ADD_help"] = "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />这是您的用户可以添加到存储库的GEDCOM事件列表。您可以根据需要删除或添加事件名称，甚至是自定义名称来修改此列表。此列表中出现的事件名称也不得出现在<i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>列表中。";
$pgv_lang["REPO_FACTS_UNIQUE"] = "唯一的存储库事件";
$pgv_lang["REPO_FACTS_UNIQUE_help"] = "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />这是您的用户只能将<u>一次</u>添加到存储库的GEDCOM事件列表。例如，如果NAME在此列表中，用户将无法向存储库添加多个NAME记录。此列表中显示的事件名称也不得出现在<i>#pgv_lang[REPO_FACTS_ADD]#</i>列表中。";
$pgv_lang["REPO_FACTS_QUICK"] = "快速存储库事件";
$pgv_lang["REPO_FACTS_QUICK_help"] = "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />这是完整列表旁边显示的GEDCOM存储库事件的简短列表，只需单击即可添加。";
$pgv_lang["LANG_SELECTION_help"] = "~#pgv_lang[LANG_SELECTION]#~<br /><br />您可以根据需要添加或删除复选标记来更改网站支持的语言列表。这会更改用户可用的语言选择。<br /><br />您可以通过#pgv_lang[admin]#菜单上的<b>#pgv_lang[enable_disable_lang]#</b>链接实现相同的功能，您还可以在其中更改语言的标志图标，日期格式，或者是否应该首先打印姓氏。";
$pgv_lang["MEDIA_ID_PREFIX"] = "媒体ID前缀";
$pgv_lang["MEDIA_ID_PREFIX_help"] = "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />当在PhpGedView中在线添加新媒体记录时，将自动生成该媒体的新ID。媒体ID将具有此前缀。";
$pgv_lang["FAM_ID_PREFIX"] = "家庭ID前缀";
$pgv_lang["FAM_ID_PREFIX_help"] = "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />当在PhpGedView中在线添加新的家庭记录时，将自动生成该家庭的新ID。家庭ID将具有此前缀。";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"] = "家庭总是在快速更新中显示的事件";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"] = "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />这是一个逗号分隔的GEDCOM事件标签列表，它们将始终显示在快速更新表单的\"系列\"选项卡上，无论它们是否已存在于系列中例如，如果MARR在列表中，则结婚日期和结婚地点的字段将始终显示在表单上。";
$pgv_lang["QUICK_ADD_FAMFACTS"] = "家庭在快速更新中展示的事件";
$pgv_lang["QUICK_ADD_FAMFACTS_help"] = "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />这是一个逗号分隔的GEDCOM事件标签列表，将在快速更新表单的\"系列\"选项卡上显示。只显示此列表中的事件在表格上或在您在表格上添加新事件的区域中可供选择。";
$pgv_lang["QUICK_REQUIRED_FACTS"] = "总是在快速更新中显示的事件";
$pgv_lang["QUICK_REQUIRED_FACTS_help"] = "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />这是一个逗号分隔的GEDCOM事件标签列表，无论它们是否已经存在于个人记录中，它们将始终显示在快速更新表格中。例如如果BIRT在列表中，则出生日期和出生地的字段将始终显示在表单上。";
$pgv_lang["QUICK_ADD_FACTS"] = "在快速更新中显示的事件";
$pgv_lang["QUICK_ADD_FACTS_help"] = "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />这是一个逗号分隔的GEDCOM事件标签列表，将在快速更新表单上显示。只有此列表中的事件才会显示在表格上或在您在表单上添加新事件的区域中可供选择。";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />当您向家庭添加新成员时，PhpGedView可以根据地区习惯为姓氏提供默认值。<br /><br /><ul><li>在<b>Paternal</b>传统中，所有家庭成员都分享父亲的姓氏。</li><li>在<b>西班牙语</b>和<b>葡萄牙语</b>传统中，孩子们从每个父母那里得到一个姓氏。</li><li>在<b>冰岛语</b>传统中，孩子们将男性父母的姓名作为姓氏，后缀表示性别。</li><li>在<b>波兰语</b>传统中，所有家庭成员都分享父亲的姓氏。对于某些姓氏，后缀表示性别。后缀<i>ski</i>，<i>cki</i>，<i>dzki</i>表示男性，而相应的后缀<i>ska</i>，<i>cka</i>和<i>dzka</i>表示女性。</li></ul>";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />这是一个逗号分隔的GEDCOM事件标签列表，将在添加/编辑名称表单中显示。如果您使用非拉丁字母，如希伯来语，希腊语，西里尔语或阿拉伯语，您可能需要添加标签，如_HEB，ROMN，FONE等，以便您可以将名称存储在几个不同的字母表中。";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />这是一个逗号分隔的GEDCOM事件标签列表，将在您添加或编辑地名时显示。如果您使用非拉丁字母，如希伯来语，希腊语，西里尔语或阿拉伯语，您可能需要添加标签，如_HEB，ROMN，FONE等，以便您可以将地名存储在几个不同的字母表中。";
$pgv_lang["GEONAMES_KEY"] = "geonames.org Userid";
$pgv_lang["GEONAMES_KEY_help"] = "~#pgv_lang[GEONAMES_KEY]#~<br /><br />此用户ID需要访问免费的geonames.org地理名称数据库。如果您没有提供有效的用户ID，您将无法搜索数据库。<br /><br />您可以在<a href='http://www.geonames.org/login' target='_blank'>geonames.org登录页面上请求geonames.org用户ID</a>。<br /><br />然后您将收到一封带有确认链接的电子邮件，在您确认电子邮件后，您可以在上启用您的网络服务帐户<a href='http://www.geonames.org/manageaccount' target='_blank'>您的帐户页面</a>";
$pgv_lang["GEONAMES_BIAS"] = "geonames.org Country Bias";
$pgv_lang["GEONAMES_BIAS_help"] = "~#pgv_lang[GEONAMES_BIAS]#~<br /><br />通常，GeoNames数据库搜索按字母顺序显示其结果，而不考虑地点所在的国家/地区。此选项指定位于所选地点的地点国家应该在结果清单的顶部报告。";
$pgv_lang["GEONAMES_BIAS_no_preference"] = "没有偏好";
$pgv_lang["GEOCODE_KEY"] = "Google地理编码服务器密钥";
$pgv_lang["GEOCODE_KEY_help"] = "~#pgv_lang[GEOCODE_KEY]#~<br /><br />访问免费的地理名称谷歌数据库需要此密钥。如果您没有提供有效密钥，您将无法搜索此数据库。<br /><br />您可以通过<a href='https://developers.google.com/maps/documentation/geocoding/get-api-key' target='_blank'> Google Developer请求密钥控制台</a>。您可以使用英语以外的其他语言查看此页面，方法是在页面底部选择所需的语言。";
$pgv_lang["AUTO_GENERATE_THUMBS_help"] = "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />系统是否应自动为没有它们的图像生成缩略图。您的PHP安装可能不支持此功能。";
$pgv_lang["phpinfo_help"] = "~#pgv_lang[phpinfo]#~<br /><br />此页面提供了有关托管PhpGedView的服务器的大量信息。有关服务器软件的许多配置详细信息，与PHP和PhpGedView相关，可以是看了。";
$pgv_lang["config_help_help"] = "~#pgv_lang[config_help]#~<br /><br />此页面将配置帮助的所有主要主题收集到一个位置。您可以在屏幕上查看信息，也可以将其打印出来供以后使用。";
$pgv_lang["more_help_advice"] = "<br /><b>更多帮助</b><br />点击页面上条目旁边的<b>？</b>即可获得更多帮助。";
$pgv_lang["THUMBNAIL_WIDTH"] = "生成缩略图的宽度";
$pgv_lang["THUMBNAIL_WIDTH_help"] = "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />这是程序在自动生成缩略图时将使用的宽度（以像素为单位）。默认设置为100. ";
$pgv_lang["USE_SILHOUETTE"] = "使用轮廓";
$pgv_lang["USE_SILHOUETTE_help"] = "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />当没有指定该人的突出显示图像时使用轮廓图像。使用的图像特定于相关人员的性别。<br /><br /><table><tr><td wrap valign=\"middle\">当人的性别未知时，可能会使用此图像:</td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"剪影图像\" title=\"剪影图像\"/></td></tr></table>";
$pgv_lang["SHOW_SOURCES_help"] = "~#pgv_lang[SHOW_SOURCES]#~<br /><br />设置所有来源的隐私访问级别。如果用户无权访问来源，将从列表菜单和来源选项卡中删除来源列表将不会显示在个人详细信息页面上。";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"] = "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />如果选项<b>#pgv_lang[USE_REGISTRATION_MODULE]#</b>已启用，此设置将控制管理员是否必须批淮注册。<br /><br />将此设置为<b>是</b>将要求所有新用户首先验证自己，然后在他们登录之前获得管理员的批淮。在<b>否</b>上进行此设置，当用户验证他们的帐户时，将自动检查<b>#pgv_lang[verified_by_admin]#</b>复选框，从而允许在没有管理员干预的情况下立即登录。<br />";
$pgv_lang["SPLIT_PLACES"] = "在编辑模式下拆分位置";
$pgv_lang["SPLIT_PLACES_help"] = "~#pgv_lang[SPLIT_PLACES]#~<br /><br />将此设置为<b>是</b>将逗号分隔每个地名到子字段中以便于编辑。例如:<br /><ol><li>默认模式<br /><u>地点</u>:美国加利福尼亚州圣马特奥半月湾<br /><br /></li><li>分裂模式<br /><u>国家</u>:美国<br /><u>州</u>:加州<br /><u>县</u>:圣马特奥<br /><u>城市</u>:半月湾</li></ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"] = "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />許多程序會將首選的名稱放在GEDCOM的引號中。通常的慣例是強調給定的首選名稱。選項會將引號括起的任何名稱轉換為&lt;span&gt;，並使用CSS類\"starredname\"。<br /><br />例如，如果GEDCOM中的名稱為1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/啟用此選項會將引號中包含的名稱部分更改為&lt;span&nbsp;class =\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt;以進行打印。根據其他設置，瀏覽器會將該名稱顯示為<b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b>或<b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b>。";
$pgv_lang["PRIVACY_BY_RESN"] = "使用GEDCOM（RESN）隐私限制";
$pgv_lang["PRIVACY_BY_RESN_help"] = "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />GEDCOM 5.5.1规范包括使用RESN标签为GEDCOM文件中的人员和事件设置隐私选项的选项。启用此选项将告诉程序在GEDCOM记录中查找1级RESN标签。级别2+ RESN标签会自动应用，不会受到此设置的影响。请注意，这可能会降低PhpGedView的某些功能，例如个人列表。<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"] = "在图表框中显示LDS条例代码";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"] = "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />将此选项设置为<b>是</b>将在图表框中显示LDS条例的状态代码。<ul><li><b>B</b>  - 洗礼</li><li><b>E</b>  - 赋予</li><li><b>S</b>  - 密封配偶</li><li><b> P</b>  - 密封给父母</li></ul>完成所有条例的人将在姓名后打印<b>BESP</b>。缺少的条例由<b表示> _</b>代替相应的字母代码。例如，<b>BE __</b>表示缺少<b>S</b>和<b>P</b>条例。";
$pgv_lang["GEDCOM_DEFAULT_TAB"] = "默认选项卡显示在个人页面上";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"] = "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />此选项允许您在访问该页面时选择在个人页面上自动打开哪个选项卡。";
$pgv_lang["SHOW_MARRIED_NAMES"] = "在个人名单上显示已婚姓名";
$pgv_lang["SHOW_MARRIED_NAMES_help"] = "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />此选项将在个人列表中显示已婚女性的名字。此选项要求您在导入GEDCOM文件时计算已婚姓名。";
$pgv_lang["SHOW_QUICK_RESN"] = "在#pgv_lang[quick_update_title]#上显示隐私字段";
$pgv_lang["SHOW_QUICK_RESN_help"] = "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />此选项允许您打开或关闭#pgv_lang[quick_update_title]#表单上的隐私字段。隐私字段允许通过以下方式添加信息的用户表格覆盖他们正在进入的事件的默认隐私。";
$pgv_lang["USE_QUICK_UPDATE"] = "使用表格#pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"] = "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />此选项确定通过#pgv_lang[quick_update_title]#表单提交更改所需的用户权限。<br /><br />选择<b>#pgv_lang[nobody]#</b>表示此表单根本无法使用。";
$pgv_lang["SEARCHLOG_CREATE"] = "归档SearchLog文件";
$pgv_lang["SEARCHLOG_CREATE_help"] = "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />程序应该多久归档一次Searchlog文件。";
$pgv_lang["CHANGELOG_CREATE"] = "存档ChangeLog文件";
$pgv_lang["CHANGELOG_CREATE_help"] = "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />程序应该多久存档一次Changelog文件。";
$pgv_lang["CHART_BOX_TAGS"] = "图表中显示的其他事件";
$pgv_lang["CHART_BOX_TAGS_help"] = "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />这应该是一个逗号或空格分隔的事件列表，除了出生和去世之外，你想要出现在图表框中，如谱系图表。此列表要求您使用GEDCOM 5.5.1标淮中定义的事件标签。例如，如果您希望职业显示在框中，您可以在此字段中添加\"OCCU\"。";
$pgv_lang["FULL_SOURCES"] = "使用完整的来源引用";
$pgv_lang["FULL_SOURCES_help"] = "~#pgv_lang[FULL_SOURCES]#~<br /><br />来源引用可以包括记录数据质量的字段（主要，次要等）以及事件在源中记录的日期。如果你不要使用这些字段，您可以在创建新的源引用时禁用它们。";
$pgv_lang["PREFER_LEVEL2_SOURCES"] = "来源类型";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"] = "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />添加新近亲时，可以在记录中添加源引用（例如INDI，FAM）或事件（BIRT，MARR，DEAT）。控制默认选中的复选框。";
$pgv_lang["media_firewall_conf"] = "媒体防火墙";
$pgv_lang["accpriv_conf"] = "访问和隐私";
$pgv_lang["displ_conf"] = "显示和布局";
$pgv_lang["displ_comsurn_conf"] = "普通姓氏";
$pgv_lang["displ_hide_conf"] = "显示和隐藏";
$pgv_lang["editopt_conf"] = "编辑选项";
$pgv_lang["useropt_conf"] = "用户选项";
$pgv_lang["meta_conf"] = "网站和META标签设置";
$pgv_lang["gedconf_head"] = "GEDCOM配置";
$pgv_lang["other_theme"] = "其他，请输入";
$pgv_lang["performing_update"] = "执行更新。";
$pgv_lang["config_file_read"] = "配置文件读取。";
$pgv_lang["does_not_exist"] = "不存在";
$pgv_lang["media_drive_letter"] = "媒体路径不应包含驱动器号;可能不会显示媒体。";
$pgv_lang["db_setup_bad"] = "您当前的数据库配置很糟糕。请检查您的数据库连接参数并重新配置。";
$pgv_lang["bad_host_user_pass"] = "PhpGedView无法建立与数据库主机的连接。检查主机，用户名和密码以确保它们是正确的。";
$pgv_lang["bad_database_name"] = "PhpGedView建立了与数据库主机的连接，但无法使用您输入的数据库。请检查数据库是否存在以及您输入的用户名是否具有该数据库的相应权限。";
$pgv_lang["db"] = "数据库";
$pgv_lang["current_gedcoms"] = "当前的GEDCOM";
$pgv_lang["ged_gedcom"] = "GEDCOM文件";
$pgv_lang["ged_title"] = "GEDCOM标题";
$pgv_lang["ged_config"] = "配置文件";
$pgv_lang["ged_search"] = "SearchLog文件";
$pgv_lang["ged_change"] = "ChangeLog文件";
$pgv_lang["ged_privacy"] = "隐私档案";
$pgv_lang["disabled"] = "已禁用";
$pgv_lang["mouseover"] = "鼠标悬停";
$pgv_lang["mousedown"] = "鼠标按下";
$pgv_lang["click"] = "鼠标点击";
$pgv_lang["enter_db_pass"] = "为了安全起见，在更改任何配置值时，必须始终输入#pgv_lang[DBUSER]#和#pgv_lang[DBPASS]#。";
$pgv_lang["server_url_note"] = "这应该是您的PhpGedView文件夹的URL。如果您确定知道自己在做什么，则只应更改此设置.PhpGedView已将此值确定为<b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"] = "数据库类型";
$pgv_lang["DBTYPE_help"] = "~#pgv_lang[DBTYPE]#~<br /><br />要连接的数据库类型。<br /><br />PhpGedView可以使用任何有PDO驱动程序的数据库。你需要确保你的php.ini文件加载<b>php_pdo</b>库和数据库的相应驱动程序，例如<b>php_pdo_mysql</b>。<br /><br />大多数数据库需要用户名和密码你还需要在安装PhpGedView之前创建数据库。但是，SQLite不需要#pgv_lang[DBHOST]#，#pgv_lang[DBUSER]#或#pgv_lang[DBPASS]#，但是你需要设置一个文件路径您的数据库在#pgv_lang[DBNAME]#字段中.PepGedView将为您创建SQLite数据库文件。";
$pgv_lang["DBHOST"] = "数据库主机";
$pgv_lang["DBHOST_help"] = "~#pgv_lang[DBHOST]#~<br /><br />托管数据库服务器的计算机的DNS或IP地址。如果您使用的是SQLite数据库，则忽略此设置。";
$pgv_lang["DBPORT"] = "数据库端口";
$pgv_lang["DBPORT_help"] = "~#pgv_lang[DBPORT]#~<br /><br />连接数据库服务器时应使用的TCP端口。将此设置留空以使用特定类型数据库的默认端口。此设置为如果您使用的是SQLite数据库，则会被忽略。";
$pgv_lang["DBUSER_help"] = "~#pgv_lang[DBUSER]#~<br /><br />登录数据库所需的数据库用户名。如果您使用的是SQLite数据库，则忽略此设置。";
$pgv_lang["DBPASS"] = "数据库密码";
$pgv_lang["DBPASS_help"] = "~#pgv_lang[DBPASS]#~<br /><br />您在#pgv_lang[DBUSER]#字段中输入的用户的数据库密码。如果您使用的是SQLite数据库，则会忽略此设置。";
$pgv_lang["DBNAME_help"] = "~#pgv_lang[DBNAME]#~<br /><br />您希望PhpGedView使用的服务器中的数据库。<br /><br />您在#pgv_lang[DBUSER]#字段中输入的用户名必须拥有此数据库的创建，插入，更新，删除和选择权限。在SQLite中，您需要将其设置为PHP可写入的目录中的文件名，例如索引目录（index/phpgedview.db）。 />";
$pgv_lang["TBLPREFIX_help"] = "~#pgv_lang[TBLPREFIX]#~<br /><br />前缀为PhpGedView创建的表。通过更改此值，您可以设置多个PhpGedView站点以使用相同的物理数据库但不同的表。例如，同一个站点可以托管一个测试以及一个带有完全独立数据表的PhpGedView的生产安装。";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] = "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />如果您的环境有多个GEDCOM，将此值设置为<b>是</b>可以让您的网站访问者<u>和</u>用户可以选择更改GEDCOM。将其设置为<b>否</b>禁用GEDCOM切换访问者<u>和</u>登录用户。";
$pgv_lang["upload_path_help"] = "~#pgv_lang[upload_path]#~<br /><br />这是您可以找到要上传的GEDCOM文件的路径。要选择路径，请单击<b>浏览</b>并导航到您的GEDCOM文件，然后单击<b>打开</b>。";
$pgv_lang["gedcom_path"] = "服务器上GEDCOM的路径和名称";
$pgv_lang["gedcom_path_help"] = "~#pgv_lang[gedcom_path]#~<br /><br />有兩種方法可以將GEDCOM文件導入PhpGedView。它們是:<ol><li>將文件FTP到服務器</li><li>在PhpGedView中上傳</li></ol>當您的文件已存在於服務器上時，您可以使用<i>#pgv_lang[add_gedcom]#</i>過程並填寫GEDCOM文件的路徑和名稱它們存在於服務器上。名稱可以有或沒有擴展名。如果沒有給出擴展名，則會假定.ged。路徑是可選的。如果沒有給出路徑，<i>#pgv_lang[INDEX_DIRECTORY]#</i>的值將使用您在PhpGedView站點配置中設置的選項。請注意，在大多數服務器上，文件和路徑名稱區分大小寫。<br /><br />當您使用時在PhpGedView中內置<i>#pgv_lang[upload_gedcom]#</i>程序，您可以使用<b>瀏覽</b>按鈕在本地計算機上找到所需的文件。这可以是常规GEDCOM文件或包含GEDCOM文件的ZIP文件。PhpGedView會自動提取和然後使用該ZIP文件中包含的GEDCOM文件。<br /><br />上傳文件時，可以指定備用路徑和/或文件名，以便將其保存在服務器上。<br /><br />有關詳細信息，請參閱<a href=\"readme.txt\">readme.txt</a>文件。";
$pgv_lang["CHARACTER_SET"] = "字符集编码";
$pgv_lang["CHARACTER_SET_help"] = "~#pgv_lang[CHARACTER_SET]#~<br /><br />这是你的GEDCOM文件的字符集.UTF-8是默认的，几乎适用于所有网站。如果你使用IBM Windows编码导出你的GEDCOM你应该把WINDOWS放在这里。<br /><br />注意:PhpGedView不支持UNICODE（UTF-16），因为PHP中缺少支持。";
$pgv_lang["LANGUAGE_help"] = "~#pgv_lang[LANGUAGE]#~<br /><br />分配网站的默认语言。<br /><br />当<b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>选项是设置，用户可以通过浏览器的首选语言配置，帐户页面上的配置选项或大多数PhpGedView页面上的链接或按钮覆盖此设置。";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />设置为<b>是</b>以允许用户覆盖网站的默认语言。他们可以通过浏览器的首选语言配置，配置选项来执行此操作在他们的帐户页面上，或通过大多数PhpGedView页面上的链接或按钮。";
$pgv_lang["CALENDAR_FORMAT_help"] = "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />日期可以记录在各种日历中，例如Gregorian，Julian或犹太人日历。此选项允许您将日期转换为首选日历。例如，您可以选择格里高利将朱利安和希伯来日期转换为格里高利。转换日期显示在常规日期后的括号中。<br /><br />日期只有在日历有效时才会被转换。例如，只有日期在22&nbsp;SEP&nbsp;1792和31&nbsp;DEC&nbsp;1805之间将转换为法国共和党日历，并且只有15月15日后的日期将被转换为公历。<br /><br />希伯来语与犹太人，但使用希伯来字符。阿拉伯语与Hijri相同，但使用阿拉伯字符。<br /><br />注意:由于犹太人和Hijri日历日在黄昏开始，所以从黄昏到午夜发生的任何事件都将显示在正确日期前一天。希伯来语和阿拉伯语的显示可能有问题旧浏览器中的matic，可以向后显示文本（从左到右）或根本不显示文本。";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] = "显示希伯来语千人";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] = "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />在希伯来日历中显示Alafim。<br /><br />将此设置为<b>是</b>将1969年显示为<span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;设置时它<b>否</b>将年份显示为<span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;。这对犹太年设置没有影响。无论此设置如何，年份都将显示为5729.<br /><br />注意:此设置类似于PHP 5.0 Calendar常量CAL_JEWISH_ADD_ALAFIM。";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"] = "显示希伯来语Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"] = "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />显示希伯来语日期时显示单引号和双引号。<br /><br />设置为<b>是</b>将显示2月8日1969年<span lang ='he-IL'dir ='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;将其设为<b>否</b>时会将其显示为<span lang ='he-IL'dir='rtl'>&#1499 ;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;。这对犹太年设置，因为引号不会用于显示拉丁字符的犹太日期。<br /><br />注意:此设置类似于PHP 5.0日历常量CAL_JEWISH_ADD_ALAFIM_GERESH和CAL_JEWISH_ADD_GERESHAYIM。此单一设置会影响两者。";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] = "Jewish Ashkenaz发音";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />使用犹太人的Ashkenazi发音。<br /><br />当设置为<b>是</b>时，Cheshvan和Teves的拼写将与Ashkenazi的发音。将它设置为<b>否</b>将改变Hesvan和Tevet的月份。这只会影响犹太人的设置。希伯来语设置将始终使用希伯来语字母。";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />设置要在Descendancy和Pedigree图表上显示的默认代数。";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] = "最大谱系世代";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] = "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />设置要在谱系图表上显示的最大代数。";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] = "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />设置在Descendancy图表上显示的最大代数。";
$pgv_lang["USE_RIN"] = "使用RIN编号代替GEDCOM ID";
$pgv_lang["USE_RIN_help"] = "~#pgv_lang[USE_RIN]#~<br /><br />当在配置文件，用户设置和用户设置中询问个人ID时，设置为<b>是</b>以使用RIN编号而不是GEDCOM ID这对于那些不能一直导出GEDCOM的家谱程序非常有用，这些GEDCOM具有分配给每个人的相同ID，但总是使用相同的RIN。";
$pgv_lang["GENERATE_GUID_help"] = "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b>在此上下文中是全球唯一ID的首字母缩写。<br /><br />GUID旨在帮助以可重复的方式识别每个人，以便盐湖城LDS教会的家庭历史中心等中央组织，甚至是在您自己的服务器上运行的兼容程序，可以确定他们是否在与同一个人打交道无论GEDCOM源自何处。家族历史中心的目标是拥有一个中心数据库系统数据库并通过网络服务公开它。这将使任何程序都能访问数据并更新其中的数据。<br /><br />如果你不打算与其他任何人分享这个GEDCOM，你不需要让PhpGedView创建这些GUID;但是，除了增加你的GEDCOM的大小之外，这样做不会有任何伤害。";
$pgv_lang["PEDIGREE_ROOT_ID"] = "谱系和后裔图表的默认人";
$pgv_lang["PEDIGREE_ROOT_ID_help"] = "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />设置要在谱系图和后裔图表上显示的默认人的ID。";
$pgv_lang["GEDCOM_ID_PREFIX_help"] = "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />当在PhpGedView中在线添加新的个人记录时，将自动生成该个人的新ID。个人ID将具有此前缀。";
$pgv_lang["SOURCE_ID_PREFIX_help"] = "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />当在PhpGedView中在线添加新的源记录时，将自动生成该源的新ID。源ID将具有此前缀。";
$pgv_lang["REPO_ID_PREFIX_help"] = "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />当在PhpGedView中在线添加新的存储库记录时，将自动生成该存储库的新ID。存储库ID将具有此前缀。";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />此选项控制是否在图表上显示个人的出生和去世详细信息。";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"] = "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />此选项控制是否在图表上显示个人的性别图标。<br /><br />由于性别也由颜色表示方框中，此选项不会隐藏性别。该选项只是从框中删除一些重复信息。";
$pgv_lang["PEDIGREE_LAYOUT"] = "默认谱系图表布局";
$pgv_lang["PEDIGREE_LAYOUT_help"] = "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />此选项指示是否应以横向或纵向模式生成谱系图表。";
$pgv_lang["SHOW_EMPTY_BOXES"] = "在谱系图表上显示空白框";
$pgv_lang["SHOW_EMPTY_BOXES_help"] = "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />此选项控制是否在谱系图表上显示空框。";
$pgv_lang["ZOOM_BOXES_help"] = "~#pgv_lang[ZOOM_BOXES]#~<br /><br />允许用户在图表上缩放框以获取更多信息。<br /><br />设置为<b>#pgv_lang[disabled]#</b>禁用此功能。当用户将鼠标悬停在框中的图标上时，设置为<b>#pgv_lang[mouseover]#</b>缩放框。设置为<b>#pgv_lang[click]#</b>当用户点击框中的图标时缩放框。";
$pgv_lang["LINK_ICONS"] = "图表上的PopUp链接";
$pgv_lang["LINK_ICONS_help"] = "~#pgv_lang[LINK_ICONS]#~<br /><br />允许用户选择指向其他图表和近亲的链接。<br /><br />设置为<b>#pgv_lang[disabled]#<b>禁用此功能。当用户将鼠标悬停在方框中的图标上时，设置为<b>#pgv_lang[mouseover]#</b>以弹出链接。设置为<b>#pgv_lang[click]#</b>在用户点击框中的图标时弹出链接。";
$pgv_lang["ABBREVIATE_CHART_LABELS"] = "缩略图标签";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"] = "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />此選項控制是否在第一個字母（如<b>B</b）的圖表上縮寫<b>Birth</b>等標籤>。<br /><br />您可以通過在每種語言的<i>languages/extra.xx.php</i>文件中提供覆蓋值來自定義縮寫。例如，如果要使用<b>*</b>而不是<b>N</b>以縮寫法語中的BIRT事件，您應該將以下條目放入<i>languages/extra.fr.php</i>文件中:<br /><br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />指定此縮寫的長度方式不限於1個字符。";
$pgv_lang["SHOW_AGE_DIFF_help"] = "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />此选项控制近亲选项卡是否应显示配偶的出生日期，第一个孩子的结婚日期和出生日期之间以及出生日期之间的差异孩子们。";
$pgv_lang["SHOW_PARENTS_AGE"] = "在孩子的出生日期旁边显示父母的年龄";
$pgv_lang["SHOW_PARENTS_AGE_help"] = "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />此选项控制是否在图表上显示孩子出生日期旁边的父亲和母亲的年龄。";
$pgv_lang["SHOW_RELATIVES_EVENTS"] = "在个人页面上显示近亲的事件";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />亲属的出生，婚姻和去世是一生中的重要事件。这个选项控制是否在<i>个人事件和个人页面上的详细信息</i>标签。<br /><br />受此选项影响的事件包括:<ul><li>配偶去世</li><li>儿童的出生和去世</li><li>父母的去世</li><li>兄弟姐妹的出生和去世</li><li>祖父母的去世</li><li>父母的兄弟姐妹的生死</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"] = "自动扩展近亲事件清单";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />此选项控制是否自动展开<i>近亲事件</i>列表。";
$pgv_lang["EXPAND_SOURCES"] = "自动扩展来源";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />此选项控制是否在个人页面上自动显示<i>Source</i>记录的内容。<br />";
$pgv_lang["EXPAND_NOTES"] = "自动扩展笔记";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />此选项控制是否在个人页面上自动显示<i>Note</i>记录的内容。";
$pgv_lang["SHOW_LEVEL2_NOTES"] = "在Notes和Sources选项卡上显示所有Notes和Source引用";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />此选项控制附加到Facts的Notes和Source引用是否应显示在Individual页面的Notes和Sources选项卡上。<br /><br />通常，Notes和Sources选项卡仅显示直接附加到个人数据库记录的Notes和Source引用。这些是<i>1级</i>Notes和Source引用。<br /><br /><b>#pgv_lang[yes]#</b>选项使这些选项卡还显示Notes和Source引用，这些引用是个人数据库记录中各种Facts的一部分。这些是<i>level 2</i>Notes和来源参考，因为各种事件都在1级。";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] = "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />此选项将启用所有隐私设置并隐藏在世人员的详细信息。<br /><br />在世人员被定义为不在世的人有一个事件比变量\$MAX_ALIVE_AGE中指定的年数更新。为此，孩子的出生也被认为是这样的事件。";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />启用此选项将强制所有访问者登录，然后才能查看网站上的任何数据。";
$pgv_lang["PAGE_AFTER_LOGIN"] = "登录后显示的页面";
$pgv_lang["PAGE_AFTER_LOGIN_help"] = "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />用戶登錄後應該看到哪個頁面？<br /><br />此處的選擇決定了成功登錄是否會導致歡迎或者從#pgv_lang[welcome_page]#登錄時出現MyGedView頁面。<br /><br />從每個其他頁面頂部的鏈接完成登錄將使用戶返回該頁面。";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />在這裡，您可以選擇要在登錄屏幕上顯示的文本。您必須確定哪種預定義文本最合適。<br /><br />您也可以選擇輸入您自己的自定義歡迎文本，但是當您的用戶更改語言時，您輸入的文本將不會被翻譯。但是，如果您的自定义文本包含可以在各种<i>languages/ extra.xx.php</i>文件中定义的语言变量的引用，则您的站点可以显示已翻译的文本。有關詳細信息，請參閱與<b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b>字段相關聯的幫助文本。<br /><br />預定義文本為:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"] = "没有预定义的文字";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"] = "预定义文本，声明所有用户都可以请求用户帐户";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"] = "规定管理员将根据用户帐户的每个请求决定的预定义文本";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"] = "仅定义家庭成员的预定义文本可以请求用户帐户";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"] = "选择下面键入的用户定义的欢迎文本";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />如果您选择了自定义欢迎文本，则可以在此处输入该文本。文本不会被翻译成访问者的语言，但会显示与您输入的完全一样。但是，如果您的自定义文本包含可以在各种<i>languages/extra.xx.php</i>文件中定义的语言变量的引用，则您的站点可以显示已翻译的文本。<br /><br />您可以在自定义欢迎文本中插入HTML标记。<br /><br />以下描述取自FAQ列表的帮助文本，同样适用于自定义欢迎文本。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "自定义欢迎文本的标淮标题";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />选择显示自定义欢迎文本的标淮标题。当用户更改语言时，此标题将以新语言显示。<br /><br />如果设置为<b>是</b>，标题看起来如下:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"] = "在申请新用户帐户»页面上显示可接受使用协议";
$pgv_lang["SHOW_REGISTER_CAUTION_help"] = "~#pgv_lang[SHOW_REGISTER_注意]#~<br /><br />當設置為<b>#pgv_lang[yes]#</b>時，上的輸入字段上方將顯示以下消息«#pgv_lang[requestaccount]#»页:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"] = "检查孩子日期";
$pgv_lang["CHECK_CHILD_DATES_help"] = "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />在确定一个人是否已经去世时检查孩子的日期。在较旧的系统和大型GEDCOM上，这可能会减慢您网站的响应时间。";
$pgv_lang["MAX_ALIVE_AGE"] = "假定一个人去世的年龄";
$pgv_lang["MAX_ALIVE_AGE_help"] = "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />如果这个人除了去世，埋葬或火葬以外的任何事件比这个年数更近，他被认为是活着的。儿童的出生日期被视为此类事件。";
$pgv_lang["SHOW_GEDCOM_RECORD"] = "允许用户查看原始GEDCOM记录";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] = "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />将此设置为<b>是</b>将在个人，来源和家庭上放置链接，让用户打开另一个包含原始数据的窗口就在GEDCOM档案之外。";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] = "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />此选项为此数据库启用在线编辑功能，以便具有编辑权限的用户可以在线更新数据。";
$pgv_lang["ENABLE_AUTOCOMPLETE"] = "启用自动完成功能";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"] = "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />此选项确定在输入表单的某些字段中输入信息时是否应激活自动完成。当此选项设置为<b>#pgv_lang[yes]#</b>，可以自动完成的文本输入字段由不同颜色的背景指示。<br /><br />当自动完成处于活动状态时，PhpGedView将根据您已经拥有的内容在其数据库中搜索可能的匹配项当您输入更多信息时，可能的匹配列表会被细化。当您在匹配列表中看到所需的输入时，您可以将鼠标光标移动到列表的该行，然后单击鼠标左键以完成输入。<br /><br />自动完成的缺点是它会降低程序速度，导致大量数据库活动，并导致更多数据被发送到浏览器。";
$pgv_lang["EDIT_AUTOCLOSE_help"] = "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />此选项控制是否在成功更新后自动关闭编辑窗口。";
$pgv_lang["INDEX_DIRECTORY_help"] = "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />PhpGedView应存储索引文件的可读写目录的路径（包括尾随的\"/\"）。PhpGedView不需要此目录的名称你可以选择任何你喜欢的名字。<br /><br />为了安全起见，这个目录应放在服务器文件空间的某个地方，无法从互联网上访问。结构如下:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>索引:</b> dir1/dir4/dir5/dir6/index<br /><br />对于显示的示例，您将在此字段中输入<b>../../dir4/dir5/dir6/index/</b>。";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />不同的国家/地区使用不同的方式来编写地址。此选项可让您在城市名称之前或之后放置邮政编码。";
$pgv_lang["SUBLIST_TRIGGER_I_help"] = "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />根据个人姓名的第一个字母，可以将具有相同姓氏的长名单分成较小的子列表。<br /><br此选项确定何时会出现姓氏的子列表。要完全禁用子列表，请将此选项设置为零。";
$pgv_lang["SUBLIST_TRIGGER_F_help"] = "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />根据给定名字的第一个字母，可以将具有相同名称的长列表分成较小的子列表。<br /><br />此选项确定何时会出现姓氏的子列表。要完全禁用子列表，请将此选项设置为零。";
$pgv_lang["SURNAME_LIST_STYLE_help"] = "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />姓氏列表，因为它们出现在#pgv_lang[block_top10]#block，#pgv_lang[individual_list]#和#pgv_lang[family_list]#中，可以用不同的风格显示。<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;在这种风格中，姓氏显示在一个表格中，可以按表格排序姓氏或按计数。</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;在此样式中，姓氏显示在列表中，并且每个姓氏使用的字体大小name取决于数据库中该名称的出现次数。该列表不可排序。</li></ul>";
$pgv_lang["SHOW_ID_NUMBERS_help"] = "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />此选项控制是否在图表和列表上的名称后面的括号中显示ID号。";
$pgv_lang["SHOW_LAST_CHANGE_help"] = "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />此选项控制是否在列表上显示GEDCOM记录的最后更改日期。";
$pgv_lang["SHOW_EST_LIST_DATES"] = "显示出生和去世的预计日期";
$pgv_lang["SHOW_EST_LIST_DATES_help"] = "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />此选项控制是否显示出生和去世的预计日期，而不是将个别列表和图表留空，以便日期未知。";
$pgv_lang["SHOW_PEDIGREE_PLACES"] = "放置水平以显示在人的框中";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] = "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />这会设置在图表上的人员框中显示多少地方信息。<br /><br />将值设置为9将保证显示所有位置级别。将值设置为0将完全隐藏位置。将值设置为1将显示第一级别，将其设置为2将显示前两个级别，等等。";
$pgv_lang["MULTI_MEDIA"] = "启用多媒体功能";
$pgv_lang["MULTI_MEDIA_help"] = "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1允许您将图片，视频和其他多媒体对象链接到您的GEDCOM。如果您没有在GEDCOM中包含多媒体对象，您可以通过将此值设置为<b>否</b>来禁用多媒体功能。<br /><br />请参阅<a href=\"readme.txt\"> readme.txt </a中的多媒体部分>文件，了解有关在您的网站中包含媒体的更多信息。";
$pgv_lang["MEDIA_EXTERNAL"] = "媒体外部链接";
$pgv_lang["MEDIA_EXTERNAL_help"] = "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />当找到以例如http://，ftp://，mms://开头的多媒体链接时，设置为<时不会更改b>是</b>。例如，http://www.myfamily.com/photo/dad.jpg将保留http://www.myfamily.com/photo/dad.jpg。设置为<b>时否</b>，链接将作为标淮参考处理，并将使用媒体深度。例如:http://www.myfamily.com/photo/dad.jpg将更改为./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"] = "MultiMedia目录";
$pgv_lang["MEDIA_DIRECTORY_help"] = "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />PhpGedView应存储媒体文件的可读写目录的路径（包括尾随的\"/\"）。PhpGedView不需要此目录的名称您可以选择任何您喜欢的名称。<br /><br />即使媒体防火墙功能允许您将媒体文件存储在无法从Internet访问的服务器文件空间区域，此处命名的目录必须仍然存在，并且必须可以从Internet读取并且可以通过PhpGedView写入。有关更多信息，请参阅GEDCOM配置页面的多媒体部分中的媒体防火墙配置选项。";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] = "保持多媒体目录级别";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />值為0將忽略媒體對象文件路徑中的所有目錄。值為1將保留包含此圖像的第一個目錄。增加要保留在路徑中的父目錄的數量。<br /><br />例如，如果您將GEDCOM中的圖像鏈接到之類的路徑<b>C:\\Documents&nbsp;和&nbsp;Settings\\User \\my&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>，值為0會將此路徑轉換為<b>./media/grandpa.jpg</b> 。值為1會將其轉換為<b>./media/Surname&nbsp;Line/grandpa.jpg</b>等。大多數人只需要使用0.但是，有可能保留一些媒體對象在此選項設置為0時，在不同目錄中具有相同的名稱並相互覆蓋。非零設置允許您在媒體中保留一些組織，從而防止名稱衝突。";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />如果您在网站上启用了多媒体功能，您可以让PhpGedView在图表和框中的人名旁边显示缩略图。<br /><br />目前，PhpGedView使用GEDCOM记录中列出的第一个多媒体对象作为高亮图像。对于拥有多个图像的人，您应该安排多媒体对象，使您希望突出显示的多媒体对象首先出现在任何其他对象之前。<br /><br />有关在您的站点中包含媒体的更多信息，请参阅<a href=\"readme.txt\">readme.txt</a>文件中的多媒体部分。";
$pgv_lang["USE_THUMBS_MAIN"] = "使用缩略图";
$pgv_lang["USE_THUMBS_MAIN_help"] = "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />此选项确定只要图表或个人详细信息页面需要缩略图，PhpGedView是否应将大图像或小图像发送到浏览器。<br /><br /><b>#pgv_lang[no]#</b>选项将导致PhpGedView发送大图像，而<b>#pgv_lang[yes]#</b>选项将导致小图像每个单独的图像还有&laquo;#factarray[_THUM]#&raquo;选项，当设置为<b>#pgv_lang[yes]#</b>时，将导致无论设置如何都会发送大图像GEDCOM配置中&laquo;#pgv_lang[USE_THUMBS_MAIN]#&raquo;选项。当GEDCOM配置指定应始终使用大图像时，不能强制PhpGedView发送小图像。<br /><br />PhpGedView不会重新调整正在发送的图像的大小;浏览器根据它收到的页面规范执行此操作。当发送的图像不是真正的图像时，这会产生不良后果PhpGedView期望发送小图像的缩略图。这不是错误:在某些情况下，可能需要在人们通常希望看到缩略图大小的图片的地方显示大图像。<br /><br />您应该避免设置&laquo;#pgv_lang[USE_THUMBS_MAIN]#&RAQUO;选项<b>#pgv_lang[no]#</b>。此选择将导致过多的图像相关数据被发送到浏览器，只是让浏览器丢弃多余的数据。页面加载，尤其是包含许多图像的图表，可能会严重减慢。";
$pgv_lang["SHOW_MEDIA_FILENAME"] = "在Media Viewer中显示文件名";
$pgv_lang["SHOW_MEDIA_FILENAME_help"] = "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />媒体查看器可以显示正在查看的媒体文件的名称。此选项确定是否向用户显示该文件名。<br /><br />出于安全原因，您可能希望隐藏文件名。";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"] = "在Media Viewer中显示下载链接";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"] = "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />媒体查看器可以显示一个链接，单击此链接后，会将媒体文件下载到本地PC。<br /><br />您可能需要出于安全原因隐藏下载链接。";
$pgv_lang["ENABLE_CLIPPINGS_CART"] = "启用Clippings Cart";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />剪报购物车允许用户将人们添加到临时文件中，他们可以用GEDCOM格式下载这些文件，以便随后导入他们的家谱软件。";
$pgv_lang["HIDE_GEDCOM_ERRORS"] = "隐藏GEDCOM错误";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] = "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />将此设置为<b>是</b>将隐藏PhpGedView在您不理解GEDCOM文件中的标记时产生的错误消息.PhpGedView make尽力遵守GEDCOM 5.5.1标淮，但许多家谱软件程序都包含自己的自定义标签。有关详细信息，请参阅<a href=\"readme.txt\"> readme.txt</a>文件。";
$pgv_lang["WORD_WRAPPED_NOTES"] = "添加包含备注的空格";
$pgv_lang["WORD_WRAPPED_NOTES_help"] = "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />一些族谱程序在单词边界处包装注释，而其他程序包在任何地方注释。这可能导致PhpGedView一起运行单词。将此设置为<b>是</b >将在原始GEDCOM中包含的单词之间添加一个空格。";
$pgv_lang["SHOW_CONTEXT_HELP"] = "显示上下文<b>？</b>帮助链接";
$pgv_lang["SHOW_CONTEXT_HELP_help"] = "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />此选项将在许多页面上的条目旁边启用由问号标识的链接。这些链接允许用户获取有关这些条目的信息或帮助。 />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"] = "即将举行的活动日期范围限制";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />输入在即将发生的事件块中显示的最大天数。此数字不能大于30.如果输入较大的值，将使用30。<br /><br />您在此处输入的值决定了PhpGedView在搜索即将发生的事件时所看到的距离。此搜索的结果每天进行一次，将被复制到临时文件中。<br /><br />索引页面或门户页面上的任何即将发生的事件块都可以请求比此值更多的天数。您创建的日期越大，构建每日数据库提取所需的时间越长，显示块所需的时间越长，即使您请求显示少于此设置的天数。";
$pgv_lang["COMMON_NAMES_THRESHOLD"] = "最少发生的事件是普通姓氏";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"] = "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />这是姓氏在欢迎页面的Common Surname列表中显示之前必须出现的次数。";
$pgv_lang["COMMON_NAMES_ADD"] = "要添加到Common Surnames的名称（以逗号分隔）";
$pgv_lang["COMMON_NAMES_ADD_help"] = "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />如果某个姓氏出现的次数低于阈值，它将不会出现在列表中。可以手动添加到此处。如果更多如果输入了一个姓氏，则必须用逗号分隔。<b>姓氏区分大小写。</b>";
$pgv_lang["COMMON_NAMES_REMOVE"] = "要从Common Surnames中删除的名称（以逗号分隔）";
$pgv_lang["COMMON_NAMES_REMOVE_help"] = "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />如果你想在不增加阈值的情况下从Common Surname列表中删除姓氏，你可以在这里输入姓氏来做到这一点。如果有多个姓氏输入时，必须用逗号分隔。<b>姓氏区分大小写。</b>此处输入的姓氏也将从欢迎页面的前10名列表中删除。";
$pgv_lang["HOME_SITE_URL"] = "主要网站网址";
$pgv_lang["HOME_SITE_URL_help"] = "~#pgv_lang[HOME_SITE_URL]#~<br /><br />每个PhpGedView页面都包含指向主页面的链接。此链接的外观由所使用的主题控制。您输入实际的URL到您的主页网站在这里。";
$pgv_lang["HOME_SITE_TEXT"] = "主要网站文字";
$pgv_lang["HOME_SITE_TEXT_help"] = "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />用于标识主页主页链接的图例。";
$pgv_lang["CONTACT_EMAIL"] = "家谱联系";
$pgv_lang["CONTACT_EMAIL_help"] = "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />有关本网站系谱数据的联系人。";
$pgv_lang["CONTACT_METHOD"] = "联系方式";
$pgv_lang["CONTACT_METHOD_help"] = "~#pgv_lang[CONTACT_METHOD]#~<br /><br />用於聯繫#pgv_lang[CONTACT_EMAIL]#關於家譜問題的方法。<ul> <li><b>#pgv_lang[mailto]#</b>選項將創建一個mailto鏈接，可以單擊該鏈接以使用用戶PC上的郵件客戶端發送電子郵件。</li><li><b>#pgv_lang[messaging]#</b>選項將使用PhpGedView內部的消息傳遞系統，並且不會發送任何電子郵件。</li><li><b>#pgv_lang[messaging2]#</b>選項是默認選項。它將使用PhpGedView消息系統，也將通過電子郵件發送消息的副本。</li><li><b>#pgv_lang[messaging3]#</b>選項允許PhpGedView處理消息，並將消息作為電子郵件發送，但不會在內部存儲消息。此選項類似於<b>#pgv_lang[mailto]#</b>選項，但消息將由PhpGedView而不是用戶的工作站發送。</li><li><b>#pgv_lang[no_messaging]#</b>此选项会阻止您的用户与您联系。</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"] = "PhpGedView回复地址";
$pgv_lang["PHPGEDVIEW_EMAIL_help"] = "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />在PhpGedView自动创建的电子邮件的&laquo;From:&raquo;字段中使用的电子邮件地址。<br /><br />PhpGedView可以自动创建电子邮件，通知管理员需要审核的更改.PhpGedView还会向已请求帐户的用户发送通知电子邮件。<br /><br />通常，&laquo;From:&raquo;这些自动创建的电子邮件的字段类似于<i>From:phpgedview-noreply@yoursite</i>，表明不需要回复电子邮件。为了防止垃圾邮件或其他电子邮件滥用，一些电子邮件系统要求每条消息的&laquo;From:&raquo;字段反映有效的电子邮件帐户，并且不接受明显来自帐户<i>phpgedview-noreply</i>的消息。";
$pgv_lang["WEBMASTER_EMAIL"] = "支持联系";
$pgv_lang["WEBMASTER_EMAIL_help"] = "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />有关您网站上遇到的技术问题或错误的联系人。";
$pgv_lang["SUPPORT_METHOD"] = "支持方法";
$pgv_lang["SUPPORT_METHOD_help"] = "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />用於聯繫#pgv_lang[WEBMASTER_EMAIL]#關於技術問題的方法。<ul><li><b>#pgv_lang[mailto]#</b>選項將創建一個mailto鏈接，可以單擊該鏈接以使用用戶PC上的郵件客戶端發送電子郵件。</li><li><b>#pgv_lang[messaging]# < /b>選項將使用PhpGedView內部的消息傳遞系統，並且不會發送任何電子郵件。</li><li><b>#pgv_lang[messaging2]#</b>選項是默認選項。它將使用PhpGedView消息系統，也將通過電子郵件發送消息的副本。</li><li><b>#pgv_lang[messaging3]#</b>選項允許PhpGedView處理消息，並將消息作為電子郵件發送，但不會在內部存儲消息。此選項類似於<b>#pgv_lang[mailto]#</b>選項，但消息將由PhpGedView而不是用戶的工作站發送。</li><li><b>#pgv_lang[no_messaging]#</b>此选项会阻止您的用户与您联系</li></ul>";
$pgv_lang["SHOW_FACT_ICONS"] = "显示事件图标";
$pgv_lang["SHOW_FACT_ICONS_help"] = "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />将此设置为<b>#pgv_lang[yes]#</b>，以在#pgv_lang[personal_facts]#页面上显示Fact name附近的图标。仅当图标存在于当前主题的<i>images/facts</i>目录中时，才会显示图标。";
$pgv_lang["FAVICON"] = "收藏夹图标";
$pgv_lang["FAVICON_help"] = "~#pgv_lang[FAVICON]#~<br /><br />将此更改为指向您希望在人们收藏的网站上显示的图标。";
$pgv_lang["THEME_DIR"] = "主题目录";
$pgv_lang["THEME_DIR_help"] = "~#pgv_lang[THEME_DIR]#~<br /><br />保存PhpGedView主题文件的目录。<br /><br />您可以自定义PhpGedView附带的任何标淮主题，以便为您提供网站具有唯一的外观和感觉。有关详细信息，请参阅<a href=\"readme.txt\">readme.txt</a>文件的主题自定义部分。";
$pgv_lang["TIME_LIMIT"] = "PHP时间限制";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />存储PhpGedView会话文件的路径。<br /><br />某些主机没有正确配置PHP，并且不在页面请求之间维护会话。此选项允许站点管理员通过将文件保存在其中一个本地目录中来克服该问题。如果需要更改此选项，./index/目录是一个不错的选择。默认情况下将该字段留空，这将使用保存路径在<i>php.ini</i>中配置。";
$pgv_lang["SERVER_URL_help"] = "~#pgv_lang[SERVER_URL]#~<br /><br />如果您使用https或默认端口以外的端口，则需要输入URL以访问您的服务器。";
$pgv_lang["LOGIN_URL"] = "登录网址";
$pgv_lang["LOGIN_URL_help"] = "~#pgv_lang[LOGIN_URL]#~<br /><br />如果您想在用户登录时重定向到其他站点或位置，则只需输入登录URL。如果您需要切换，这非常有用当您的用户登录时，从http到https。包括<i>login.php</i>的完整URL。例如，https://www.yourserver.com/phpgedview/login.php。";
$pgv_lang["PGV_SESSION_TIME_help"] = "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />PhpGedView会话在需要登录前保持活动状态的时间（以秒为单位）。默认为7200，即2小时。";
$pgv_lang["SHOW_STATS"] = "显示执行统计数据";
$pgv_lang["SHOW_STATS_help"] = "~#pgv_lang[SHOW_STATS]#~<br /><br />在每个页面的底部显示运行时统计信息和数据库查询。";
$pgv_lang["SHOW_COUNTER"] = "显示计数器";
$pgv_lang["SHOW_COUNTER_help"] = "~#pgv_lang[SHOW_COUNTER]#~<br /><br />在Portal和Individual页面上显示点击计数器。";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />为访问者提供在网站上注册帐户的选项。<br /><br />访问者将收到一封带有代码的电子邮件验证他的帐户申请。验证后，管理员必须在注册之前批淮注册。";
$pgv_lang["ALLOW_USER_THEMES_help"] = "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />为用户提供选择自己主题的选项。";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />在外部邮件的普通邮件标题中，使用了电子邮件地址和名称。有些邮件系统不接受此邮件。当设置为<b>时是的</b>，只会使用电子邮件地址。";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />使用SMTP从PhpGedView发送电子邮件。<br /><br />此选项需要访问SMTP邮件服务器。设置为<b时>#pgv_lang[no]#</b> PhpGedView将在此服务器上使用PHP内置的电子邮件系统。";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />这是SMTP邮件服务器的名称。例如:<b>smtp.foo.bar.com</b>。<br /><br />某些电子邮件提供商的配置值:<br /><br /><b>Gmail<br /></b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b>smtp.gmail.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b>465或587<br /><b>#pgv_lang[PGV_SMTP_SSL]#:</b>SSL<br /><br /><b>Hotmail<br /></b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b>smtp.live.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b>25或587<br /><b>#pgv_lang[PGV_SMTP_SSL]#:</b>TLS<br /><br /><b>Yahoo Mail Plus（目前是付费服务）</></b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b> smtp.mail.yahoo.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b>25";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />这是SMTP服务器上有效电子邮件地址的域名。<br /><br />例如，如果你有一个e邮箱帐户，例如<b>yourname@abc.xyz.com</b>，你可以在这里输入<b>abc.xyz.com</b>。";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />用于连接SMTP服务器的端口号。一般来说，这是端口<b>25</b>。";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />使用名称和密码身份验证连接到SMTP服务器。<br /><br />某些SMTP服务器要求所有连接在接受之前进行身份验证出境电子邮件。";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />使用SMTP服务器进行身份验证所需的用户名。";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />使用SMTP服务器进行身份验证所需的密码。";
$pgv_lang["PGV_SMTP_SSL_help"] = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />传输层安全性（TLS）和安全套接字层（SSL）是Internet数据加密协议。<br /><br />TLS 1.0,1.1和1.2是SSL 3.0的标淮化开发.TLS 1.0和SSL 3.1是等效的。现在使用新名称TLS进行SSL的进一步工作。<br /><br />如果您的SMTP服务器在登录期间需要SSL协议，您应该选择<b>SSL</b>选项。如果您的SMTP服务器在登录期间需要TLS协议，则应选择<b>TLS</b>选项。";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />输入在本网站发送的电子邮件的&laquo;From:&raquo;字段中使用的名称。<br /><br />例如，如果您的名字是<b>John Smith</b>并且您是一个名为<b>Jones Genealogy</b>的网站的网站管理员，则可以输入类似<b>John Smith</b>的内容b>或<b>Jones Genealogy</b>甚至<b>John Smith，管理员:Jones Genealogy</b>。您可以输入任何您想要的内容，但不允许使用HTML。";
$pgv_lang["gedcom_title"] = "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"] = "~#pgv_lang[gedcom_title]#~<br /><br />输入用户在您网站上的GEDCOM数据集中选择时要显示的描述性标题。";
$pgv_lang["LOGFILE_CREATE"] = "归档日志文件";
$pgv_lang["LOGFILE_CREATE_help"] = "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />程序应该多久归档一次日志文件。";
$pgv_lang["PGV_MEMORY_LIMIT_help"] = "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />PhpGedView脚本可以消耗的最大内存量。默认6432 Mb。许多主机在PHP配置中禁用此选项;更改此值可能实际上并没有影响当前的最大内存设置。";
$pgv_lang["PGV_STORE_MESSAGES_help"] = "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />指定通过PhpGedView发送的消息是否可以存储在数据库中。如果设置为<b>是</b>，用户将能够在何时检索消息他们登录PhpGedView。如果设置为<b>否</b>，则只会通过电子邮件发送消息。";
$pgv_lang["ALLOW_THEME_DROPDOWN"] = "显示主题更改的主题下拉选择器";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"] = "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />为用户提供从菜单中选择自己主题的选项。<br /><br />即使设置了此选项，当前有效的主题也可能不提供这样的菜单。为了有效，此选项还需要设置<b>#pgv_lang[ALLOW_USER_THEMES]#</b>选项。";
$pgv_lang["MAX_VIEW_RATE"] = "最大页面浏览率";
$pgv_lang["MAX_VIEW_RATE_help"] = "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />此选项限制用户查看页面的速率。<br /><br />如果超过该速率，PhpGedView会将会话视为黑客尝试;会话将以适当的消息终止。这两个值应对来自服务器的带宽和下载字节数量进行合理限制。可以通过将时间间隔设置为0来关闭此功能。";
$pgv_lang["META_AUTHOR"] = "META author标签";
$pgv_lang["META_AUTHOR_help"] = "~#pgv_lang[META_AUTHOR]#~<br /><br />要放置在HTML页面标题中的作者元标记中的值。将此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_AUTHOR_descr"] = "将此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_PUBLISHER"] = "META publisher标签";
$pgv_lang["META_PUBLISHER_help"] = "~#pgv_lang[META_PUBLISHER]#~<br /><br />要放置在HTML页面标题中的Publisher元标记中的值。将此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_PUBLISHER_descr"] = "将此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_COPYRIGHT"] = "META copyright标签";
$pgv_lang["META_COPYRIGHT_help"] = "~#pgv_lang[META_COPYRIGHT]#~<br /><br />要放置在HTML页面标题中的版权元标记中的值。将此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_COPYRIGHT_descr"] = "将此字段留空以使用#pgv_lang[CONTACT_EMAIL]#的全名。";
$pgv_lang["META_DESCRIPTION"] = "META description标签";
$pgv_lang["META_DESCRIPTION_help"] = "~#pgv_lang[META_DESCRIPTION]#~<br /><br />要放置在HTML页面标题中的描述元标记中的值。将此字段留空以使用当前活动数据库的标题。";
$pgv_lang["META_DESCRIPTION_descr"] = "将此字段留空以使用当前活动数据库的标题。";
$pgv_lang["META_PAGE_TOPIC"] = "META page-topic标签";
$pgv_lang["META_PAGE_TOPIC_help"] = "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />要放置在HTML页面标题中的Page-topic元标记中的值。将此字段留空以使用当前活动数据库的标题。 />";
$pgv_lang["META_PAGE_TOPIC_descr"] = "将此字段留空以使用当前活动数据库的标题。";
$pgv_lang["META_AUDIENCE"] = "META audience标签";
$pgv_lang["META_AUDIENCE_help"] = "~#pgv_lang[META_AUDIENCE]#~<br /><br />要放置在HTML页面标题中的Audience元标记中的值。";
$pgv_lang["META_PAGE_TYPE"] = "META page-type标签";
$pgv_lang["META_PAGE_TYPE_help"] = "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />要放置在HTML页面标题中的Page-type元标记中的值。";
$pgv_lang["META_ROBOTS"] = "META robots标签";
$pgv_lang["META_ROBOTS_help"] = "~#pgv_lang[META_ROBOTS]#~<br /><br />放置在HTML页面标题中的Robots元标记中的值。一些机器人或网络爬虫忽略了这个值。";
$pgv_lang["META_REVISIT"] = "爬虫应该多久重访一次META标签";
$pgv_lang["META_REVISIT_help"] = "~#pgv_lang[META_REVISIT]#~<br /><br />要放在HTML页面标题中的Revisit元标记中的值。有些网页抓取工具会忽略此值。<br />";
$pgv_lang["META_KEYWORDS"] = " META关键词";
$pgv_lang["META_KEYWORDS_help"] = "~#pgv_lang[META_KEYWORDS]#~<br /><br />要放置在HTML页面标题中的关键字元标记中的值。有些搜索引擎会使用关键字元标记来帮助索引页面。<br /><br />欢迎页面上#pgv_lang[gedcom_stats]#块中显示的#pgv_lang[common_surnames]#列表也可以添加到您在此处输入的任何内容。";
$pgv_lang["META_TITLE"] = 	 "添加到TITLE标签";
$pgv_lang["META_TITLE_help"] ="~#pgv_lang[META_TITLE]#~<br /><br />此行上的任何内容都将添加到常规页面标题之后和PhpGedView信用之前的HTML页面标题中的TITLE标记。";

$pgv_lang["ENABLE_RSS"] = "启用RSS";
$pgv_lang["ENABLE_RSS_help"] = "~#pgv_lang[ENABLE_RSS]#~<br /><br />此选项可让您禁用RSS功能。<br /><br />RSS允许用户监控您的网站以更改索引页面而无需实际访问如果有太多用户使用此功能或者这些用户设置的刷新频率太高，RSS会占用过多的带宽或服务器容量。<br /><br />这<a href='http://en.wikipedia.org/wiki/RSS' target='_blank' title='维基百科文章'><b>维基百科文章</b></a>包含有关RSS和各种RSS的综合信息和链接格式。<br />";
$pgv_lang["RSS_FORMAT"] = "RSS格式";
$pgv_lang["RSS_FORMAT_help"] = "~#pgv_lang[RSS_FORMAT]#~<br /><br />用作网站默认Feed格式的格式。数字后缀<u>不</u>表示版本:它们标识格式。例如，RSS 2.0并不比RSS 1.0更新，但格式不同。Feed阅读器应该能够读取任何格式。<br /><br />这<a href='http://en.wikipedia.org/wiki/RSS' target='_blank' title='维基百科文章'><b>维基百科文章</b></a>包含有关RSS和各种RSS格式的综合信息和链接。";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "检查GEDCOM文件是否可下载";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />出于安全考虑，GEDCOM文件不应该位于可以直接下载的位置，从而绕过隐私检查。点击此链接将检查您的GEDCOM文件可以通过网络下载。<br /><br />在某些系统上，这项检查已经花了很长时间甚至不完整。如果是这种情况，那么你应该尝试指向你的浏览器直接在您的GEDCOM上查看是否可以下载。";
$pgv_lang["gedcom_download_secure"] = "#GEDCOM#无法下载。";

$pgv_lang["welcome_new2"] = "<br /><br />由于您看到此页面，因此您已成功在服务器上安装了PhpGedView，并淮备开始根据您的要求进行配置。";
$pgv_lang["welcome_new_help"] = 	 "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#This Help page will guide you through the configuration process.  As you enter different fields, this window will provide you with help information about the field you are in.  You may close this window; to open it again click on one of the \"?\" question marks next to the field label.";
$pgv_lang["return_editconfig"] = "您可以随时通过将浏览器指向<i>editconfig.php</i>或单击<b>PhpGedView管理</b>上<b>配置</b>的链接返回此配置页面。<br />";
$pgv_lang["return_editconfig_gedcom"] = "您可以随时点击<b>#pgv_lang[gedcom_adm_head]#<上<b>#pgv_lang[current_gedcoms]#</b>表中的<b>编辑</b>链接返回此配置/b>页面或将浏览器指向<i>editconfig_gedcom.php</i>。";
$pgv_lang["save_config"] = 	 "Save configuration";
$pgv_lang["download_gedconf"] = "下载GEDCOM配置。";
$pgv_lang["not_writable"] = "我们检测到您的配置文件不能被PHP写入。您可以使用<b>#pgv_lang[download_file]#</b>按钮将设置保存到可以手动上传的文件中。";
$pgv_lang["upload_to_index"] = "将文件上传到索引目录:";
$pgv_lang["import_sql"] = "在您的索引目录中找到了SQL文件。由于它们可能来自用户迁移工具，您可以选择将信息导入数据库。您是否希望立即将这些文件导入数据库？所有现有用户数据库中相关的信息（用户，新闻，收藏夹，块布局和消息）将丢失。<br /><br />如果您选择继续，PhpGedView将尝试导入数据。如果这不成功，无论如何，你将被要求建立第一个管理员帐户。";

$pgv_lang["edit_privacy_title"] = "编辑GEDCOM隐私设置";
$pgv_lang["save_changed_settings"] = "保存更改";
$pgv_lang["add_new_pp_setting"] = "为ID添加隐私新设置";
$pgv_lang["add_new_up_setting"] = "为用户隐私添加新设置";
$pgv_lang["add_new_gf_setting"] = "为全球事件隐私添加新设置";
$pgv_lang["add_new_pf_setting"] = "按ID添加Facts Privacy的新设置";
$pgv_lang["file_read_error"] = "E R R O R !!!无法读取隐私文件！";
$pgv_lang["edit_exist_person_privacy_settings"] = "按ID编辑隐私的现有设置";
$pgv_lang["edit_exist_user_privacy_settings"] = "编辑用户隐私的现有设置";
$pgv_lang["edit_exist_global_facts_settings"] = "编辑Global Fact Privacy的现有设置";
$pgv_lang["edit_exist_person_facts_settings"] = "按ID编辑Facts Privacy的现有设置";
$pgv_lang["general_privacy"] = "一般隐私设置";
$pgv_lang["general_privacy_help"] = "~#pgv_lang[general_privacy]#~<br /><br />您可以在网站上为每个GEDCOM设置不同的隐私设置。在页面标题下检查您是否正在编辑正确的GEDCOM。<br /><br />您可以使用#pgv_lang[edit_privacy_title]#页面上的其他隐私表单覆盖这些常规设置。<br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"] = "ID的隐私设置";
$pgv_lang["person_privacy_help"] = "~#pgv_lang[person_privacy]#~<br /><br />这些设置允许管理员覆盖特定个人，家庭，来源或媒体对象的默认隐私设置。<br /><br />例如假设你有一个孩子在婴儿期去世。通常是因为孩子去世，它的细节会向公众用户显示。但是，你和你家里的其他人仍然是私人的。你不想删除去世记录。孩子，但你想要隐藏细节并将它们设为私人。如果这个孩子的ID为I100，你应该输入以下隐私设置:<br />ID:I100<br />显示:仅显示给经过身份验证的用户<br /><br />这也是另一种方式。如果你想公开你知道去世但没有去世日期的某人（ID I101）的详细信息，你可以添加以下内容:<br />ID:I101<br />显示:向公众展示";
$pgv_lang["user_privacy"] = "用户隐私设置";
$pgv_lang["user_privacy_help"] = "~#pgv_lang[user_privacy]#~<br /><br />这些设置使管理员能够根据用户名覆盖GEDCOM中个人的默认隐私设置。假设您不希望用户名<b>John</b>为了能够在GEDCOM中看到ID I100的任何细节，你可以这样配置:<br />用户名:John<br />ID:I100<br />显示？:\"隐藏\"<br /><br />指定个人的详细信息仅对用户名\"John\"隐藏。<br /><br />显示I101的详细信息（由于I101通常会被隐藏还活着）用户名约翰设置:<br /><br />用户名:John<br />ID:I101<br />显示？:显示<br />";
$pgv_lang["global_facts"] = "全球事件隐私设置";
$pgv_lang["global_facts_help"] = "~#pgv_lang[global_facts]#~<br /><br />这些设置在GEDCOM中为所有人隐藏的全局级别定义事件。这仅适用于BIRT或DEAT等1级事件记录。将在各个页面的个人事件和详细信息选项卡上显示自己的标题。<br /><ul><li><b>#pgv_lang[name_of_fact]#</b>元素确定应隐藏哪个事件。</li><li><b>#pgv_lang[choice]#</b>元素指定事件本身或相关细节。</li><li><b>#pgv_lang[accessible_by]#</b > element确定显示事件的访问级别。</li></ul><br />此功能旨在隐藏GEDCOM标记所标识的所有活着或去世的事件。默认情况下，SSN标记隐藏给公众用户。这是为了防止人们窃取社会安全号码并对死者进行身份盗窃。这可能与美国有关。<br /><br />如果你想隐瞒所有公共婚姻用户您可以设置的GEDCOM:<br /><br /><b>#pgv_lang[name_of_fact]#</b>（MARR） - 婚姻<br /><b>#pgv_lang[选择]#</b>\"#pgv_lang[fact_show]#\"<br /><b>#pgv_lang[accessible_by]#</b>\"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b>（MARR） - 婚姻<br /><b>#pgv_lang[选择]#</b>\"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b>\"#pgv_lang[PRIV_USER]#\"<br /><br />这些设置会隐藏婚姻和相关详细信息给非管理员。<br /><br />所有其他设置，在<b>#pgv_lang[edit_exist_global_facts_settings]#</b>中，您甚至可以隐藏管理员用户的事件。不必要的事件被完全压制。";
$pgv_lang["person_facts"] = "事件隐私设置ID";
$pgv_lang["person_facts_help"] = "~#pgv_lang[person_facts]#~<br /><br />这些设置定义了为特定人员，家庭或来源隐藏的事件以及隐藏它们的级别。这仅适用于1级事件记录例如BIRT或DEAT，它们将在个人，家庭或来源的相关详细信息页面上以自己的标题出现。<br /><br />第一个元素是人，家庭或来源的ID。第二个元素是事件。<b>#pgv_lang[choice]#</b>元素指定事件本身或相关细节。<b>#pgv_lang[accessible_by]#</b>元素确定在什么访问级别事件显示。并非列表中显示的所有事件都适用于所有类型的ID。例如，出生和去世事件与源记录无关。<br /><br />\person_facts数组的工作方式与\_global_facts数组除了你还指定了你要隐藏事件的人的GEDCOM ID。例如，你可以隐藏特定人的婚姻记录。 />";
$pgv_lang["accessible_by"] = "显示到？";
$pgv_lang["hide"] = "隐藏";
$pgv_lang["show_question"] = "显示？";
$pgv_lang["user_name"] = "用户名";
$pgv_lang["name_of_fact"] = "事件名称";
$pgv_lang["choice"] = "选择";
$pgv_lang["fact_show"] = "显示事件";
$pgv_lang["fact_details"] = "显示事件细节";
$pgv_lang["privacy_header"] = "编辑隐私设置";
$pgv_lang["unable_to_find_privacy_indi"] = "无法找到有id的人";
$pgv_lang["save_and_import"] = "保存此GEDCOM配置后，您需要通过单击<b>导入GEDCOM</b>按钮或转到<b>管理员 - >管理GEDCOM->导入</b>导入GEDCOM";
$pgv_lang["help_info"] = "您可以通过点击每个单元格标签旁边的红色\"？\"来获取每个条目的帮助。";
$pgv_lang["SHOW_LIVING_NAMES_help"] = "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />在世百姓的名字应该向公众展示吗？";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"] = "展示研究助理";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"] = "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />如果安装了Research Assistant模块，哪种类型的用户可以查看？";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"] = "使用关系隐私";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"] = "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>否</b>表示经过身份验证的用户可以查看所有在世人员的详细信息。<b>是</b>表示用户可以只看到与他们有关的在世人员的私人信息。<br /><br />此选项为有权访问此系谱数据库的所有用户设置默认值。管理员可以通过编辑用户的权限为个别用户覆盖此选项帐户详情。";
$pgv_lang["MAX_RELATION_PATH_LENGTH"] = "最大关系路径长度";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"] = "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />如果启用了<i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i>选项，登录用户将只能在此数量的关系步骤中查看或编辑个人。<br /><br />此选项为有权访问此系谱数据库的所有用户设置默认值。管理员可以通过编辑用户的帐户详细信息为单个用户覆盖此选项。";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"] = "检查婚姻关系";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"] = "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />检查与婚姻有关的关系。";
$pgv_lang["SHOW_DEAD_PEOPLE"] = "显示去世的人";
$pgv_lang["SHOW_DEAD_PEOPLE_help"] = "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />为所有死去的人设置隐私访问级别。";
$pgv_lang["select_privacyfile_button"] = "选择隐私文件";
$pgv_lang["PRIVACY_BY_YEAR"] = "按在世年龄限制隐私";
$pgv_lang["PRIVACY_BY_YEAR_help"] = "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br /><b>#pgv_lang[PRIVACY_BY_YEAR]#</b>设置将隐藏人们的详细信息，具体取决于他们在特定事件中的年龄，无论他们是死还是活。<br /><br />将此设置与<b>#pgv_lang[MAX_ALIVE_AGE]#</b> 设置一起使用。 例如，如果您将年龄设置为100并将此选项设置为<b>是</b>，那么100年内出生的所有活着或死亡的人都将设置为私人。结婚小于85年的人和不到75年前死亡的人也会被标记为私人注意请注意，使用此选项会减少数据展现。";

$pgv_lang["lang_edit_help"] = "~#pgv_lang[translator_tools]#~<br /><br />此页面旨在供翻译人员使用。您可以翻译，比较和导出语言文件。还有一个选项可以帮助翻译人员确定起源由PhpGedView输出的文本。<br /><br />您可以使用以下选项和实用程序:";
$pgv_lang["bom_check"] = "字节顺序标记（BOM）检查";
$pgv_lang["bom_check_help"] = "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"] = "此检查将分析BOM的所有语言文件（字节顺序标记）。如果找到，它将从受影响的文件中删除BOM。这些特殊代码可能会导致PhpGedView的某些部分出现故障。";
$pgv_lang["lang_debug"] = "帮助文本调试选项";
$pgv_lang["lang_debug_help"] = "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"] = "当您启用此选项时，帮助文本中使用的语言变量的名称将打印在帮助文本弹出窗口中。这将有助于翻译人员在需要调整文本时确定变量名称。<br /><br />设置仅在您当前的PhpGedView会话期间有效。";
$pgv_lang["lang_debug_use"] = "使用帮助文本调试选项";
$pgv_lang["bom_not_found"] = "没有找到BOM。";
$pgv_lang["bom_found"] = "已找到BOM";
$pgv_lang["edit_lang_utility_desc"] = "您可以使用此实用程序通过使用英语文本的内容来编辑语言文件的内容。<br /><br />您将看到原始英语语言文件的内容和相同文件类型的内容（您的所选语言中有9个）。您单击英文版本下方显示的消息文本。这将打开一个新窗口，您可以在其中修改文本。您可以保存更改或放弃更改。";
$pgv_lang["edit_lang_utility_warning"] = "小心！<br /><br />如果您使用<b>#pgv_lang[close_window_without_refresh]#</b>按钮，在您重新加载手册页之前，屏幕上可能看不到您的更改。可能是如果您添加一条尚未出现在语言文件中的消息，或者您只是编辑之前直接编辑的消息，您的语言文件可能会被销毁。<br /><br />如果您真的不知道你是什么我正在做，请不要使用<b>#pgv_lang[close_window_without_refresh]#</b>按钮。";
$pgv_lang["language_to_edit_help"] = "~#pgv_lang[language_to_edit]#~<br /><br />在此列表框中，您可以选择要编辑其消息的语言。";
$pgv_lang["file_to_edit_help"] = "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"] = "PhpGedView已经实现了对许多不同语言的支持。这是通过将文件中用户可见的所有文本与主程序完全分开来实现的。每种支持的语言都有一组八个文件，各种文本已经存在根据功能分成这些文件中的一个。<b>并非所有语言文件都必须存在。</b>当给定文本尚未翻译时，PhpGedView将始终使用英文版本。<br /><br />每种语言集中的文件是:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;此文件包含术语和在管理PhpGedView和家谱数据库期间使用的常用表达。<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;此文件包含在配置PhpGedView期间使用的帮助文本。普通用户无法查看帮助文本。<br /><br /></li><li><b><i>个国家/地区。 xx.php</i></b>&nbsp;&nbsp;这是一个列表国名，取自联合国经济和社会事务部统计司网站。这是相关的<a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>链接</b></a>到英文名单。该列表有英文或法文版本。<br /><br /></li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;此文件包含在谱系数据库中编辑条目时使用的术语和通用表达。<br /><br /></li><li><b><i>facts.xx.php</i></b >&nbsp;&nbsp;此文件包含GEDCOM 5.5.1标淮中找到的GEDCOM事件代码的文本等价物。它还包含标淮中未找到但由各种家谱程序使用的其他事件代码。<br /><br />的英文副本<a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_ blank\"><b>GEDCOM 5.5.1标淮</b></a>可以PDF格式下载（可移植文档格式）。<br /><br /></li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;此文件是<b>f</b>的一组<b>a</b> sked<b>q</b>由PhpGedView开发团队收集的提示。每个FAQ在此文件中都有两个条目。一个条目是FAQ标题（通常是问题），另一个是FAQ主体（通常是答案）。经常更新的<b><i>faqlist.xx.php</i></b>文件的替换可以从PhpGedView主站点下载。<br /><br />管理员可以使用此文件中的常见问题解答，用于构建特定于其网站的常见问题列表。<br /><br /></li><li><b><i>help_text.xx.php</i></b >&nbsp;&nbsp;此文件包含普通用户的帮助文本。此文件中的某些帮助主题可满足管理员的需求，并且对没有管理员权限的用户隐藏。<br /><br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;此文件中包含许多术语和常用表达。</li></ul><br />PhpGedView还支持可选的第九语言文件，<b><i>extra.xx.php</i>的</b>。此文件始终在所有其他文件之后加载，并提供一种方法，使站点管理员可以覆盖或更改所选语言的任何标淮文本。它还可用于为系谱数据库提供根据当前活动语言而有所不同的标题。<br /><br />此附加文件的内容完全取决于站点管理员;此文件将<b>永远</b>与任何版本的PhpGedView一起分发。管理员永远不应该更改标淮语言文件;所有本地更改都应集中在此可选文件中。<br />";
$pgv_lang["language_to_export_help"] = "~#pgv_lang[language_to_export]#~<br /><br />从这个列表框中，您可以选择要导出其消息的语言。<br /><br />该例程目前只导出该文件的内容。<i>configure_help.xx.php</i>，<i>help_text.xx.php</i>和<i>lang.xx.php</i>文件。输出是一个HTML文件，你可以从您的浏览器打印。";
$pgv_lang["export_lang_utility_help"] = "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"] = "您可以为管理员创建文档。<br /><br />此实用程序将以所选语言生成配置帮助文件的HTML版本。您可以使用浏览器查看此文件，该文件已格式化以进行打印。";
$pgv_lang["export_ok"] = "出口帮助信息";
$pgv_lang["compare_lang_utility_help"] = "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"] = "这个实用程序将比较两组语言文件，以生成它们之间的加法和减法列表。<br /><br />您还应检查各种CHANGELOG文件以查看英文版本的更改。英文文件应该是用作所有其他产品的参考。";
$pgv_lang["new_language_help"] = "~#pgv_lang[new_language]#~<br /><br />从此列表框中，您可以选择要与其他语言进行比较的语言。<br /><br />所有更改和添加首先将语言文件转换为<b>英语</b>语言文件，因此您通常会选择英语作为要比较的语言之一。";
$pgv_lang["old_language"] = "第二个语言";
$pgv_lang["old_language_help"] = "~#pgv_lang[old_language]#~<br /><br />从此列表框中，您可以选择要与<b>源</b>列表框中选择的语言进行比较的语言。选择后，单击<b>比较</b>按钮，获取两种语言的所有四个文件中所有添加和删除的列表。<br /><br />刷新你的记忆:<br /><b>添加</b>意味着:<u>在</u>源文件中，但<u>不是</u>在辅助文件中。<br /><br /><b>减法</b>表示:源文件中<u>不</u>，但辅助文件中。这可能在给定时发生消息不再使用，因此已从英文文件中删除。您可以安全地从辅助语言文件中删除相应的消息。";
$pgv_lang["additions"] = "加法";
$pgv_lang["no_additions"] = "没有补充";
$pgv_lang["subtractions"] = "减量";
$pgv_lang["no_subtractions"] = "没有减法";
$pgv_lang["config_lang_utility_help"] = "~#pgv_lang[config_lang_utility]#~<br /><br />此頁面用於控制用戶可以使用的語言選項。例如，您可以進行設置，以便只有德語和法語可用。例如，如果您無法與匈牙利語的用戶通信，則可能很有用。<br /><br />您還可以使用此頁面來改變依賴於所選語言的PhpGedView的某些方面。例如，這裡是告訴PhpGedView如何格式化日期和時間字段的地方。<br /><br />活動和灰顯的語言因為正在使用而無法禁用。請查看下表以查看語言的使用位置。當GEDCOM或用戶不再使用某種語言時，您可以將其禁用。<br /><br />所有更改都將記錄在名為<b>lang_settings.php</b>的新文件中>在<b>#INDEX_DIRECTORY#</b>目錄中創建。您將對此新文件進行所有進一步更改，PhpGedView將僅使用<u>此</u>文件。您可以通过删除此文件来恢复原始默认语言设置。<br /><br />如果您必須報告語言設置題，請告訴PhpGedView支持團隊是否存在此新文件。";
$pgv_lang["active_help"] = "~#pgv_lang[active]#~<br /><br />如果启用了选项<b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>，则允许用户选择此语言。";
$pgv_lang["lang_back"] = "返回主菜单编辑和配置语言文件";
$pgv_lang["lang_back_admin"] = "返回管理员菜单";
$pgv_lang["lang_back_manage_gedcoms"] = "返回GEDCOM管理菜单";
$pgv_lang["lang_name_arabic"] = "阿拉伯";
$pgv_lang["lang_name_catalan"] = "加泰罗尼亚语（瓦伦西亚语）";
$pgv_lang["lang_name_croatian"] = "克罗地亚";
$pgv_lang["lang_name_czech"] = "捷";
$pgv_lang["lang_name_danish"] = "丹麦";
$pgv_lang["lang_name_dutch"] = "荷兰";
$pgv_lang["lang_name_english (uk)"] = "英语（英国）";
$pgv_lang["lang_name_english (us)"] = "英语（美国）";
$pgv_lang["lang_name_estonian"] = "爱沙尼亚语";
$pgv_lang["lang_name_finnish"] = "芬兰";
$pgv_lang["lang_name_french"] = "法国";
$pgv_lang["lang_name_german"] = "德语";
$pgv_lang["lang_name_greek"] = "希腊语";
$pgv_lang["lang_name_hebrew"] = "希伯来文";
$pgv_lang["lang_name_hungarian"] = "匈牙利";
$pgv_lang["lang_name_indonesian"] = "印度尼西亚";
$pgv_lang["lang_name_italian"] = "意大利";
$pgv_lang["lang_name_lithuanian"] = "立陶宛";
$pgv_lang["lang_name_norwegian"] = "挪威";
$pgv_lang["lang_name_polish"] = "抛光";
$pgv_lang["lang_name_portuguese"] = "葡萄牙语";
$pgv_lang["lang_name_romanian"] = "罗马尼亚";
$pgv_lang["lang_name_russian"] = "俄语";
$pgv_lang["lang_name_serbian-la"] = "塞尔维亚语（拉丁字母）";
$pgv_lang["lang_name_slovak"] = "斯洛伐克";
$pgv_lang["lang_name_slovenian"] = "斯洛文尼亚";
$pgv_lang["lang_name_spanish"] = "西班牙";
$pgv_lang["lang_name_spanish-ar"] = "西班牙语（拉丁美洲）";
$pgv_lang["lang_name_swedish"] = "瑞典";
$pgv_lang["lang_name_turkish"] = "土耳其";
$pgv_lang["lang_name_vietnamese"] = "越南";
$pgv_lang["original_lang_name"] = "#D_LANGNAME#中的语言原始名称";
$pgv_lang["original_lang_name_help"] = "~语言的原始名称~<br /><br />这种语言如何用这种语言命名？<br /><br />英语称自己<b>英语</b>;德语称自己<b>Deutsch</b>;荷兰人称自己为<b>Nederlands</b>;捷克语称自己<b>Ceština</b>等。";
$pgv_lang["lang_shortcut"] = "语言文件的缩写";
$pgv_lang["lang_shortcut_help"] = "~#pgv_lang[lang_shortcut]#~<br /><br />此代碼定義了語言名稱的縮寫。這個縮寫形成了PhpGedView使用的每個語言文件名稱的一部分。例如，使用的縮寫對於法語是<b>fr</b>，因此法語的文件名是<i>configure_help.<b>fr</b>.php</i>，<i>countries<b>fr</b>.php</i>，<i>facts.<b>fr</b>.php</i>，<i>help_text.<b>fr</b>.php</i>，和<i>lang.<b>fr</b>.php</i>";
$pgv_lang["lang_langcode_help"] = "~#pgv_lang[lang_langcode]#~<br /><br />这些代码允许PhpGedView检测正在使用的浏览器的首选语言设置.PhpGedView通过匹配浏览器的语言代码来确定浏览器实际请求的语言个人列表条目必须用分号分隔。";
$pgv_lang["lang_filenames_help"] = "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile_help"] = "~#pgv_lang[flagsfile]#~<br /><br />所选语言的国旗图像文件的名称。<br /><br />许多国家的图像可从<a href=\"获得http://w3f.com/gifs/index.html\"><b>WWWeb工厂</b></a>网站。<br /><br />当您找到喜欢的国旗图片时，请点击 - 单击它并将图像保存在临时文件夹中。接下来，使用合适的图像编辑器打开保存的图像（建议Windows系统使用IrfanView），将其大小缩小50x32像素，这是PhpGedView中使用的正常大小，然后将其作为GIF文件保存到<i><b>images/flags</b></i>文件夹。<br /><br />虽然您可以使用任何您想要的名称，但您应该选择一致的名称使用两个字母的语言快捷方式。例如，克罗地亚语由两个字母的代码<i><b>hr</b></i>表示，因此克罗地亚国旗通常被命名为<i><b>hr.gif</b></i>。";
$pgv_lang["text_direction_help"] = "~#pgv_lang[text_direction]#~<br /><br />标识用于以所选语言书写文本的方向。大多数语言是从左到右书写的。阿拉伯语和希伯来语是用相反的方向（从右到左）。";
$pgv_lang["date_format_help"] = "~#pgv_lang[date_format]#~<br /><br />此字段定義PhpGedView在顯示數據庫日期時使用的日期格式。您可以使用<b>標淮</b >或<b>高級</b>格式。<ul><li><b>標淮</b><br />以下代碼用於表示日期的不同元素。請注意<b>D</b>和<b>M</b>在<b>高級</b>格式中有不同的含義。<p style=\"padding-left:25px\"><b>D</b>&nbsp;&nbsp;月中的某一天，沒有前導零;即1到31<br /><b>M</b>&nbsp;月份名稱;即1月，2月等。<br /><b>Y</b>&nbsp;&nbsp;全年，例如1999或44B.C.<br /><b>R</b>&nbsp;&nbsp;日曆轉換。請參閱主題<b>日曆轉換</b>以下是對此代碼的描述。</p>這些代碼可以按任何順序組合，還有空格和標點符號。例如，假設您的GEDCOM包含日期20&nbsp;AUG&nbsp;1965。<p style =\"padding-left:25px\"><b>英文</b>用戶可以將格式設置為<b>D&nbsp;M&nbsp;Y</b><b>20&nbsp;8月&nbsp;1965</b>。<br /><b>美國</b>用戶可以將格設置為<b>M&nbsp;D，&nbsp;Y</b>得到<b>8月&nbsp;20，&nbsp;1965</b><br />A<b>德國</b>用戶可以將格式設置為<b>D. &nbsp;M&nbsp;Y</b>獲取<b>20.&nbsp;8月&nbsp;1965</b><br /><b>匈牙利</b>用戶可以將格式設置為<b>Y.&nbsp ;M</b><b>1965年。&nbsp;augusztus&nbsp;20.</b><br />提供更複雜的格式選項。如果您的日期格式包含<b>D</b>，<b>M</b>，<b>Y</b>或<b>R</b>以外的字母，則會假設使用<b>高級</b>格式。<br /><br />以下代碼用於表示日期的不同元素。請注意，<b>D</b>和<b>M</b>在<b>標淮</b>格式中具有不同的含義。 <p style =\"padding-left:25px\"><b> d</b>&nbsp;&nbsp;該月的某天，前導零;即01至31<br /><b>j </b >&nbsp;&nbsp;該月的某一天，沒有前導零;即1至31<br /><b>S</b>&nbsp;&nbsp;日期編號的序數後綴;例如，<b>4月7日</b>中的字母<b></b>。<br /><b>l</b>（小寫字母\"L\"）&nbsp;&nbsp;一周中的天;即星期一，星期二等。<br /><b>D</b>&nbsp;&nbsp;縮短的星期幾;即M，Tu，W，Th，F，Sa，Su<br /><b>N</b>&nbsp;&nbsp ;ISO天數;即0至6<br /><b>w</b>&nbsp;&nbsp;數字日數;即1至7<br /><b>z</b>&nbsp;&nbsp;一年中的某一天;即1至365<br /><b>F</b>&nbsp;月份名稱;即1月，2月等。<br /><b>M</b>&nbsp;&nbsp;縮寫月份，即1月，2月等。<br /><b>m</b>&nbsp;&nbsp;月數字，前導零;即01至12<br /><b>n</b>&nbsp;&nbsp;月號，不帶前導零;即1至12<br /><b>Y</b>&nbsp;&nbsp;全年，例如1999或44B.C.<br /><b>y</b>&nbsp;&nbsp;縮寫年份。一些日曆允許多年縮寫。對於猶太歷，這是沒有數千人的年份。對於公曆，這與全年相同。<br /><b>R</b>&nbsp;&nbsp;日曆轉換。請參閱下面的主題<b>日曆轉換</b>以獲取此代碼的說明。<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;內部GEDCOM格式</p><p style=\"padding-left:50px\"><b>@ </b>&nbsp;&nbsp;日曆代碼，例如@#DGREGORIAN @，@#DHEBREW @等<br /><b>A</b>&nbsp;&nbsp;day，即01到31<br /><b>O</b>&nbsp;&nbsp;一個月，例如1月，2月，3月等。<br /><b>E</b>&nbsp;&nbsp;年，例如1776年，1867年，2007年等。<br /><br />要查看未轉換的日期，請使用<b>A&nbsp;O&nbsp;E</b>或<b>@&nbsp;A&nbsp;O&nbsp;E </b ></p><b>一些例子</b>，使用日期08&nbsp;SEP&nbsp;1965:<p style=\"padding-left:25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;9月&nbsp; 1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8月&nbsp;9月&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp ; 9月&nbsp;65<br /><b>l&nbsp; - &nbsp;d&nbsp; - &nbsp;F&nbsp; - &nbsp;Y</b> =星期三&nbsp;&nbsp;08&nbsp; - &nbsp;9月&nbsp; - &nbsp; 1965<br /><b>y/m/d</b> = 1965/09/08 </p><br /></li>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] = "<li><b>日曆轉換</b><br /><b>R</b>代碼的行為有點不尋常。當此代碼以日期格式顯示時，正常日期將顯示為第二次，但在不同的日曆系統中。此備用日曆日期的元素將遵循與格式規範的主要部分相同的規則，除了<b>R</b>格式代碼的輸出是括在括號中，以區別於常規日期。<b>法國革命</b>日曆下的例子將使這一點更加清晰。<br /><br />用於<b的備用日曆>R</b>代碼根據當前頁面語言確定。當頁面語言為希伯來語時，將使用<b>猶太</b>日曆。當頁面語言為阿拉伯語時，<b>Hijri</b>將使用日曆。對於所有其他頁面語言，使用<b>法國革命</b>日曆。<br /><br />此代碼的操作類似於日曆格式的選擇ÿ您可以在GEDCOM配置頁面上進行操作。這兩種方法的區別在於，語言配置級別定義的<b>R</b>代碼僅適用於所選語言，但適用於站點上的所有GEDCOM。在GEDCOM配置級別設置的日曆選項適用於所有語言，但僅適用於已設置該選項的GEDCOM。<br /><ul><li><b>法國革命</b>日曆&nbsp;&nbsp;&nbsp;這個日曆也被稱為<b>法國共和黨人</b>日曆。<br /><br />除了1871年5月的一個非常短暫的時期外，這個日曆系統僅在法國使用，僅在22&nbsp;SEP&nbsp;1792年和31&nbsp;DEC&nbsp;1805。因此，法國革命日曆格式僅適用於日期在該範圍內的情況。<br /><br />假設頁面語言為英語，兩種示例日期格式將說明<b>R的行為</b>代碼:<br /><b>Ymd&nbsp;R</b>可以產生<b>1805.04.26&nbsp;（XIII.08.06）</b>或<b>1806.01.01</b> ;&nbsp;<b>j&nbsp;F&nbsp;Y&nbsp;R</b>可以生成<b>13&nbsp;OCT&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI）</b>或<b>1&nbsp;JAN&nbsp;1806</b>。</li></ul><br /></li><li><b>語言備選方案</b>&nbsp;&nbsp;&nbsp;高級代碼<b>D</b>的縮寫文本和<b>M</b>在文件<i>languages/lang.xx.php</i>使用类似的声明<code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"蘇\";</代碼>&nbsp;&nbsp;和&nbsp;&nbsp;<code>\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />这些可以通过使用Wiki和ReadMe文本中描述的<i>languages/extra.xx.php</i>文件进行语言调整来更改，例如：<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\" ;<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code><br /><br /><br /></li><li> <b>本地化</b>&nbsp;&nbsp;&nbsp;針對多種語言存在特殊格式規則，尤其是根據日期的措辭來截斷月份結尾。這些特殊規則在各種<i>includes/extras/functions.xx.php</i>文件中實現。</li></ul>";
$pgv_lang["time_format_help"] = "~#pgv_lang[time_format]#~<br /><br />這個字段定義了PhpGedView使用的時間格式。<br /><br />你可以使用的符號是:<br /><b>a</b> - 小寫Ante meridiem和Post meridiem;即<b>am</b>或<b>pm</b><br /><b>A</b> - 大寫Ante meridiem和Post meridiem ;即<b>AM</b>或<b>PM</b><br /><b>B</b> - Swatch Internet時間;即<b>000</b>至<b>999</b><br /><b>c</b> - ISO 8601日期（在PHP 5中添加）;例如<b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - 月中的某一天，2位數，前導零;​​即<b>01</b>至<b>31</b><br /><b>D</b> - 天，文字，三個字母;例如<b>星期一</b><br /><b>F</b> - 月，文字，長;例如<b>1月</b><br /><b>g</b> - 小時，12小時格式，沒有前導零;即<b>1</b>到<b>12</b><br /><b>G</b > - 小時，24小時格式，無前導零;即<b>0</b>到<b>23</b><br /><b>h</b> - 小時，12小時格式，前導零;​​即<b>01</b>至<b>12</b><br /><b>H</b> - 小時，24小時格式，前導零;​​即<b>00</b>通過<b>23</b><br /><b>i</b> - 分鐘，領先零;即<b>00</b>至<b>59</b><br /><b>I</b>（大寫\"i\"） - 夏令時指標;如果夏令時<b>1</b>，否則<b>0</b>。<br /><b>j</b> -月中的某天，沒有前導零;即<b>1</b>至<b>31</b><br /><b>l</b>（小寫\"L\"） - 星期幾，文字，長;例如<b>星期五</b><br /><b>L</b> - 閏年指標;<b>1</b>如果是閏年，<b>0</b >否則。<br /><b>m</b> - 月，數字，前導零;即<b>01</b>至<b>12</b><br /><b>M</b> - 月份，文字，3個字母;例如<b>Jan</b><br /><b>n</b> - 月，數字，沒有前導零;即<b>1</b>至<b>12</b><br /><b>O</b>（資本\"o\"） - 本地和格林威治時間（GMT）之間的差異，以小時為單位;例如<b> +0200</b><br /><b>r</b> - RFC 2822格式化日期;例如<b>星期四，&nbsp;21&nbsp;Dec&nbsp;2000nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - 秒，領先零;即<b>00</b>至<b>59</b><br /><b>S</b> - 每月的後綴，僅限英文，2個字符;即<b>st</b>，<b>nd</b>，<b>rd</b>或<b>th</b>。適用於<b>j</b><br /><b>t</b> - 給定月份的天數;即<b>28</b>至<b>31</b><br /><b>T</b> - 本機的時區設定;例如<b>CEST</b>，<b>EST</b>，<b>MDT</b><br /><b>U</b> - 自Unix時代開始以來的秒數（1月&nbsp;1&nbsp;1970&nbsp;00:00:00 GMT）<br /><b>w</b> - 星期幾，數字;即<b>0</b>（星期日）至<b>6</b>（星期六）<br /><b>W</b> - ISO-8601星期一年，星期開始星期一;例如<b>42</b>（全年第42週）<br /><b>Y</b> - 年，4位數;例如<b>1999</b><br /><b>y</b> - 年，2位數;例如<b>99</b><br /><b>z</b> - 一年中的某一天，數字，沒有前導零;即<b>0</b>（1月1日）至<b>364</b>（12月31日不是閏年）或<b>365</b>（閏年12月31日）</><b>Z</b> - 以秒為單位的時區偏移量。格林威治以西時區的偏移總是負的，對於格林威治以東的時區偏移總是正的。即<b>-43200</b>至<b>43200</b><br /><br />您可以更改這些符號的順序，並可以為該格式添加分隔符。<br /><例如，在德語中，此字段通常包含<b>H:i:s</b>以生成<b>09:01:25</b>等顯示。英語通常將時間格式定義為<b>g:i:sa</b>以生成<b>上午9:01:25am</b>的顯示。<br /><br />24小時系統，午夜是00:00。在12小時制中，午夜是12:00am，中午是12:00pm。";
$pgv_lang["week_start_help"] = "~#pgv_lang[week_start]#~<br /><br />用这种语言开始新一周的星期几。大多数语言在星期日开始，但有些语言从星期一或其他日子开始。 ";
$pgv_lang["name_reverse_help"] = "~#pgv_lang[name_reverse]#~<br /><br />在某些语言中，应首先显示姓氏，而不是默认显示姓氏。启用此选项将首先显示姓氏。匈牙利语，中文和日语通常首先给出姓氏（姓氏）的例子。";
$pgv_lang["alphabet_upper"] = "字母表大写";
$pgv_lang["alphabet_upper_help"] = "~#pgv_lang[alphabet_upper]#~<br /><br />这种语言的大写字母。这个字母用于排序名称列表。";
$pgv_lang["alphabet_lower"] = "字母小写";
$pgv_lang["alphabet_lower_help"] = "~#pgv_lang[alphabet_lower]#~<br /><br />这种语言的小写字母。这个字母用于排序名称列表。";
$pgv_lang["multi_letter_alphabet_help"] = "~#pgv_lang[multi_letter_alphabet]#~<br /><br />在对该语言的名称和标题列表进行排序时，将被视为单个不同字母的多字母组合。<br /><br />有些语言，例如匈牙利语和斯洛伐克语，认为某些字母组合本身就是不同的字母。指定这些字母组合的顺序决定了它们在排序过程中插入正常字母表的顺序。这很重要当多个多字母组合具有相同的第一个字母时。除<b>ch</b>外，这些字母组合将根据其首字母插入正常字母。<b>ch</b>始终插入<b>h</b>。";
$pgv_lang["multi_letter_equiv"] = "多字母等价物";
$pgv_lang["multi_letter_equiv_help"] = "~#pgv_lang[multi_letter_equiv]#~<br /><br />在某些语言中，生成名称列表时，多个字母通常被视为等同于一个字母。<br /><br />例如，荷兰语，以IJ开头的名称与以Y开头的名称一起列出。在挪威语中，以AA开头的名称与&Aring;一起列出。在某些语言中，有些字母可以写成一个或两个字符。例如，斯洛伐克语，两个字符D和\xC5\xBE可以写成单个字符\xC7\x85。通过在此指定等价物，您可以允许以这些字母开头的名称在各个列表页面上组合在一起。<br /><br您应该指定以逗号分隔的等效列表。要支持不识别UTF-8编码的数据库，您应该同时指定大写和小写等效。此示例演示了要使用的格式。<br /><br />AA=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort_help"] = "~#pgv_lang[dictionary_sort]#~<br /><br />此选项控制在排序名称和标题列表时如何处理带变音符号的字符。<br /><br />设置为<b>#时pgv_lang[yes]#</b>，所有带变音符号的字符都被视为没有任何标记。只有在考虑的两个单词相同时才会考虑变音符号。设置为<b>#pgv_lang[no]#</b>，无论是否存在变音符号，所有字母都是不同的。";
$pgv_lang["collation"] = "数据库整理顺序";
$pgv_lang["collation_help"] = "~#pgv_lang[collat​​ion]#~<br /><br />如果您使用的是数据库的内置排序规则，则此选项指定要用于此语言的排序规则序列。您应该确保数据库支持所有您打算使用的整理顺序。<br /><br />数据库整理的使用在站点配置设置中进行控制。";
$pgv_lang["lang_config_write_error"] = "将语言设置写入文件<b>lang_settings.php</b>时出错。请检查权限，然后重试。";
$pgv_lang["translation_forum"] = 	 "PhpGedView Translations forum on SourceForge";
$pgv_lang["translation_forum_help"] = "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"] = "这个<a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>链接</b></a>开启了一个新的浏览器窗口。您将被重定向到PhpGedView的翻译论坛，在那里您可以讨论翻译主题。";
$pgv_lang["lang_set_file_read_error"] = "E R R O R !!!无法读取<b>lang_settings.php</b>！";
$pgv_lang["add_new_language_help"] = "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"] = "此例程允许您向PhpGedView添加新的，以前不可用且完全不受支持的语言。<br /><br />您可以设置新语言的标淮设置。这些设置包括语言检测代码，语言方向，启动这周语言，时间设置，字母表等等。<br /><br />选择语言并单击<b>#pgv_lang[add_new_lang_button]#<后，您将获得有关PhpGedView支持的语言设置的更多帮助。 /b>按钮。<br /><br />语言的配置页面提供了更多帮助。";
$pgv_lang["hide_translated_help"] = "~#pgv_lang[hide_translated]#~<br /><br />如果设置为<b>是</b>，您将只看到所选语言文件中尚未翻译的消息。这表示新消息<u>不</u>出现在目标语言文件中。<br /><br />某些语言文件包含各种未翻译消息的英文文本。此例程无法识别这些未翻译的条目，因为它们已存在于目标文件。假设是，如果消息存在于目标文件中，则必须已翻译。";
$pgv_lang["lang_file_write_error"] = "E R R O R !!!<br /><br />无法将更改写入所选语言文件。请检查<b>#lang_filename#</b>的写入权限";
$pgv_lang["no_open"] = "E R R O R !!!<br /><br />无法打开文件<b>#lang_filename#</b>";

//-- User Migration Tool messages
$pgv_lang["um_proceed"] = "选择一个选项或点击下面的链接返回 管理 菜单";
$pgv_lang["um_sql_index"] = "此工具将在索引目录中创建<i>authenticate.php</i>和几个<i>.dat</i>文件。<br /><br />成功创建后，您可以切换到索引模式可以使用所有当前用户及其消息，收藏夹，新闻和MyGedview布局。<br /><br />注意:切换到索引模式后，您需要再次导入GEDCOM文件。";
$pgv_lang["um_file_create_fail1"] = "创建新文件失败，已存在具有该名称的文件:";
$pgv_lang["um_file_create_fail3"] = "检查此目录的访问权限。";
$pgv_lang["um_file_create_succ1"] = "创建新文件成功:";
$pgv_lang["um_file_not_created"] = "文件未创建。";
$pgv_lang["um_nomsg"] = "系统中似乎没有消息。";
$pgv_lang["um_nofav"] = "系统中似乎没有收藏夹。";
$pgv_lang["um_nonews"] = "系统中似乎没有新闻。";
$pgv_lang["um_noblocks"] = "系统中似乎没有阻塞。";
$pgv_lang["um_index_sql"] = "此工具会将<i>authenticate.php</i>和其他<i>.dat</i>文件从索引目录导入数据库。";
$pgv_lang["um_noaction"] = "将用户信息迁移到SQL模式不需要执行任何操作。<br /><br />一旦切换到SQL模式，您需要重新启动用户迁移工具以将所有数据导入SQL数据库.PhpGedView将使用来自的现有文件索引模式。<br /><br /><b>从索引目录中删除<i>authenticate.php</i>和<i>.dat</i>文件时，<u>不</u>切换。</b>";
$pgv_lang["um_explain"] = "此工具将用户数据从SQL导出到索引模式，或将用户数据从索引文件导入SQL表格。<br /><br />用户数据，收藏夹，块定义，消息和新闻将在以后再次可用迁移。<br /><br /><b>注意</b><br />您无法使用此工具在不同版本的PhpGedView之间迁移用户数据。请确保数据来自或导入到相同的PhpGedView版本。<br /><br />进口<br />如果您选择从索引模式导入用户数据文件，则数据库表中存在的所有用户数据都将是<u>覆盖</u>。这个工具<u>不</u>合并信息。一旦你运行了导入，就无法使用PhpGedView检索旧信息。<br /><br /><b>导出</b><br />如果将用户信息从SQL数据库导出到索引模式文件，此工具将创建<i>authenticate.php</i>和几个<i>.dat</i>索引目录中的文件。如果已经预先命名了相同名称的文件nt，系统会提示您是否必须覆盖它们。切换到索引模式后，所有信息都将直接提供。<br /><br /><b>注意:</b>切换到索引模式后，您需要再次导入GEDCOM文件。";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~将用户从SQL迁移到索引模式~<br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~将用户从索引迁移到SQL模式~<br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "导入用户";
$pgv_lang["um_imp_blocks"] = "导入块";
$pgv_lang["um_imp_favorites"] = "导入收藏夹";
$pgv_lang["um_imp_messages"] = "导入消息";
$pgv_lang["um_imp_news"] = "导入新闻";
$pgv_lang["um_nousers"] = "在您的索引目录中找不到 文件<i>authenticate.php</i>。迁移已取消。";
$pgv_lang["um_bu_explain"] = "这个工具可以在PhpGedView中备份几种数据。<br /><br />您选择备份的数据将被收集到一个ZIP文件中，您可以通过单击底部的链接下载该文件。备份成功完成后的页面。<br /><br />ZIP文件将保留在您的索引目录中，直到您手动删除它为止。";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_gedsets"] = "GEDCOM设置，配置和隐私文件";
$pgv_lang["um_bu_logs"] = "GEDCOM SearchLogs和PhpGedView Logfiles";
$pgv_lang["um_bu_usinfo"] = "用户定义，阻止设置，收藏夹，消息，新闻";
$pgv_lang["um_nofiles"] = "找不到备份文件。";
$pgv_lang["um_files_exist"] = "一个或多个文件已经存在。你要覆盖它们吗？";
$pgv_lang["preview_faq_item"] = "预览所有常见问题条目";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />此选项允许管理员用户查看FAQ页面，而不包含所有编辑选项和链接。<br /><br />除了单个<b>编辑</b >链接到第一个FAQ条目上方，FAQ页面的外观将与普通用户看到的相同。这个特殊的<b>编辑</b>链接将完整的编辑功能恢复到FAQ页面。";
$pgv_lang["restore_faq_edits"] = "恢复常见问题编辑功能";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />此选项将FAQ页面恢复为管理员用户通常看到的内容，以便可以编辑各个FAQ条目。";
$pgv_lang["add_faq_item"] = "添加常见问题条目";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />此选项可让您将条目添加到常见问题解答页面。";
$pgv_lang["edit_faq_item"] = "编辑常见问题条目";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />此选项可让您编辑FAQ页面上的条目。";
$pgv_lang["delete_faq_item"] = "删除常见问题条目";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />此选项可让您从常见问题页面中删除条目";
$pgv_lang["moveup_faq_item"] = "移动常见问题条目";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />此选项可让您在常见问题页面上向上移动条目。<br /><br />每次使用此选项时，此条目的常见问题位置编号为通过编辑有问题的条目并更改常见问题解答位置字段，您可以达到同样的效果。当多个常见问题解答条目具有相同的位置编号时，只有其中一个条目可见。";
$pgv_lang["movedown_faq_item"] = "移动常见问题解答条目";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />此选项可让您在常见问题解答页面上向下移动条目。<br /><br />每次使用此选项时，此条目的常见问题位置编号为通过编辑相关条目并更改常见问题解答位置字段，您可以达到相同的效果。当多个常见问题条目具有相同的位置编号时，只有其中一个条目可见。";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br />这是FAQ条目的标题或主题。<br /><br />您输入的内容可以格式化.HTML标签，例如&lt;b&gt;和&lt;允许使用br /&gt;以及&amp;amp;和&amp;nbsp;等HTML实体。&lt;br /&gt;以外的HTML标记在FAQ标题中可能不是很有用，应该避免使用。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br />此处输入FAQ条目的文本。<br /><br />文本可以格式化.HTML标签，例如&lt;b&gt;和&lt;br/&gt;是允许的，例如&amp;amp;和&amp;nbsp;等HTML实体。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["add_faq_HTML"] = "HTML實體是一種非常簡單的方法，可以在FAQ標題和文本中添加特殊字符。您可以使用符號名稱，十進制數字或十六進制數字。完整的HTML實體列表，它們的編碼以及瀏覽器的表示形式可以是在此處找到:<a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML實體列表</a><br /><br />，您可能需要顯示一個Tilde字符&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;或一個數字簽名&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;在您的网址或文字中。這些字符對PhpGedView幫助系統有特殊含義，只能以十六進製或十進制形式輸入。同樣，&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;和&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;通常包含HTML標記的字符必須以十六進製或十進制形式輸入，如果它們被視為普通文本而不是發送HTML標記信號。<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b >&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;或&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;將導致&nbsp;&nbsp;<b>&#x7E;</b></li></ul>有一個&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML實體，但在URL中編碼時，此符號不會被解釋為Tilde。";
$pgv_lang["add_faq_pgvLangRefs"] = "您可以插入語言文件中的條目或全局變量值的引用。例如:<ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b >&nbsp;&nbsp;&nbsp;;是對語言變量\$pgv_lang[\"add_to_cart\"]的引用，如果它出現在此字段中，當FAQ列表為時，將顯示為<b>#pgv_lang[add_to_cart]#</b>用當前語言查看。</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;是對事件名稱的引用\$factarray[\"AFN\"]，如果它出現在此字段中，當以當前語言查看FAQ列表時，將顯示為<b>#factarray[AFN]#/b>。</li><li><b>&#x23;PGV_VERSION&#x23;&nbsp;&#x23;PGV_VERSION_RELEASE&#x23;</b>&nbsp;&nbsp;&nbsp;是對常量PGV_VERSION的引用，空格和對常量PGV_VERSION_RELEASE的引用，如果他們要出現在此字段中，當以當前語言查看常見問題列表時，將顯示為<b>#PGV_VERSION#&nbsp;#PGV_VERSION_RELEASE#</b>。</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;是對全局變量\$GEDCOM引用，它是當前GEDCOM文件的名稱。如果它出現在此字段中，它將顯示為<b>#GLOBALS[GEDCOM]#</b>。</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;是對全局變量\$GEDCOM_TITLE的引用，它是當前GEDCOM文件的標題。如果它出現在此字段中，它將顯示為<b>#GLOBALS[GEDCOM_TITLE]#</b>。</li></ul><br />當您希望創建常見問題列表時，此功能非常有用對於您的網站支持的每種語言，它們都不同。您應該使用以下格式將自定義的常見問題列表標題和條目放入<i>languages/extra.xx.php</i>文件（<i>xx</i>是每種語言的代碼）中:<br />\$pgv_lang[\"faq_title1\"]= \"This is a sample FAQ title\";<br />\$pgv_lang[\"faq_body1\"] = \"This is a sample FAQ body.\";";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br />此字段控制FAQ条目的显示顺序。<br /><br />您不必按顺序输入数字。如果您在编号方案，您可以稍后插入其他条目。例如，如果您使用数字1,6,11,16，您可以稍后插入缺少序列号的条目。允许使用负数和零，并且可以用于插入第一个条目前面的条目。<br /><br />当多个FAQ条目具有相同的位置编号时，只能看到其中一个条目。";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br />无论GEDCOM如何，您都可以确定此FAQ是否可见，或者只有当前的GEDCOM才能看到它。<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;常见问题解答将出现在所有常见问题列表中，无论GEDCOM如何。</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;常见问题解答只会出现在当前活跃的GEDCOM常见问题列表中。</li></ul>";
$pgv_lang["index_gedcom_news_adm_help"] = "GEDCOM新闻文本允许使用<b>HTML标记</b>和<b>HTML实体</b>。不应在新闻标题中使用HTML。<br /><br />请务必始终使用开始和结束标签。可能有助于理解适合网站管理员的HTML。该程序也使用<b>层迭样式表（CSS）</b>。为每个主题实现不同的CSS您可以使用这些样式表中的类来控制消息的外观。<br /><br />如果您需要更多帮助，网站上有一些如何在您的GEDCOM新闻中使用这些标签的示例与FAQ列表一样，GEDCOM新闻标题和新闻文本允许嵌入引用\$pgv_lang，\$factarray和\$GLOBALS变量，以便在创建新闻条目时提供完全的灵活性。对当前活动的语言很敏感。<br /><br />以下描述取自常见问题列表的帮助文本，同样适用于GEDCOM新闻条目。<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#";
$pgv_lang["time_limit_help"] = "~#pgv_lang[time_limit]#~<br /><br />允许导入以处理GEDCOM文件的最长时间。";

//editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br />此选项允许您搜索与配置选项关联的文本。<br /><br />当您键入字母时，搜索将查找包含该字母序列的所有配置选项当你输入更多的字母时，搜索变得更加精确。";
?>
