<?php
/**
 * Arabic Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Ezz (sfezz)
 * @translator Samar A Kadhi
 * @version $Id: facts.ar.php 7354 2022-10-27 18:46:54Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their English values
$factarray["ABBR"]	= "الاختصار";
$factarray["ADDR"]	= "العنوان";
$factarray["ADR1"]	= "العنوان ١";
$factarray["ADR2"]	= "العنوان ٢";
$factarray["ADOP"]	= "تبني";
$factarray["AFN"]	= "Ancestral File Number (AFN)";
$factarray["AGE"]	= "العمر";
$factarray["AGNC"]	= "Agency";
$factarray["ALIA"]	= "Alias";
$factarray["ANCE"]	= "أسلاف";
$factarray["ANCI"]	= "Ancestors Interest";
$factarray["ANUL"]	= "Annulment";
$factarray["ASSO"]	= "Associate";
$factarray["AUTH"]	= "مؤلف";
$factarray["BAPL"]	= "LDS Baptism";
$factarray["BAPM"]	= "Baptism";
$factarray["BARM"]	= "Bar Mitzvah";
$factarray["BASM"]	= "Bas Mitzvah";
$factarray["BIRT"]	= "الوِلادة";
$factarray["BLES"]	= "بركة";
$factarray["BLOB"]	= "Binary Data Object";
$factarray["BURI"]	= "الدفن";
$factarray["CALN"]	= "Call Number";
$factarray["CAST"]	= "Caste / Social Status";
$factarray["CAUS"]	= "سبب الوفاة";
$factarray["CEME"]      = "مقبرة";
$factarray["CENS"]	= "Census";
$factarray["CHAN"]	= "آخر تعديل";
$factarray["CHAR"]	= "Character Set";
$factarray["CHIL"]	= "طفل";
$factarray["CHR"]	= "حفلة التعميد";
$factarray["CHRA"]	= "حفلة التعميد للبالغين";
$factarray["CITY"]	= "المدينة";
$factarray["CONF"]	= "Confirmation";
$factarray["CONL"]	= "LDS Confirmation";
$factarray["COPR"]	= "Copyright";
$factarray["CORP"]	= "Corporation / Company";
$factarray["CREM"]	= "إحراق الجثة";
$factarray["CTRY"]	= "الدولة";
$factarray["DATA"]	= "بيانات";
$factarray["DATE"]	= "التاريخ";
$factarray["DEAT"]	= "الوفاة";
$factarray["DESC"]	= "أحفاد";
$factarray["DESI"]	= "Descendants Interest";
$factarray["DEST"]	= "Destination";
$factarray["DIV"]	= "طلاق";
$factarray["DIVF"]	= "Divorce filed";
$factarray["DSCR"]	= "الوصف";
$factarray["EDUC"]	= "المستوى التعليمي";
$factarray["EMIG"]	= "هجرة";
$factarray["ENDL"]	= "LDS Endowment";
$factarray["ENGA"]	= "خطوبة";
$factarray["EVEN"]	= "حدث";
$factarray["FAM"]	= "عائلة";
$factarray["FAMC"]	= "Family as a Child";
$factarray["FAMF"]	= "ملف العائلة";
$factarray["FAMS"]	= "Family as a Spouse";
$factarray["FCOM"]	= "First Communion";
$factarray["FILE"]	= "ملف خارجي";
$factarray["FORM"]	= "صيغة";
$factarray["GIVN"]	= "الاِسم الأول";
$factarray["GRAD"]	= "تخرج";
$factarray["HUSB"]  	= "الزوج";
$factarray["IDNO"]	= "رقم الهوية";
$factarray["IMMI"]	= "هجرة";
$factarray["LEGA"]	= "الوارث بوصية";
$factarray["MARB"]	= "Marriage Banns";
$factarray["MARC"]	= "عقد قران";
$factarray["MARL"]	= "رخصة الزواج";
$factarray["MARR"]	= "زواج";
$factarray["MARS"]	= "Marriage Settlement";
$factarray["MEDI"]	= "نوع الملف";
$factarray["NAME"]	= "الإسم";
$factarray["NATI"]	= "الجنسية";
$factarray["NATU"]	= "التجنس";
$factarray["NCHI"]	= "عدد الأولاد";
$factarray["NICK"]	= "الكنية";
$factarray["NMR"]	= "عدد مرات الزواج";
$factarray["NOTE"]	= "ملاحظة";
$factarray["NPFX"]	= "Prefix";
$factarray["NSFX"]	= "Suffix";
$factarray["OBJE"]	= "عنصر الوسائط المتعددة";
$factarray["OCCU"]	= "الوظيفة";
$factarray["ORDI"]	= "Ordinance";
$factarray["ORDN"]	= "Ordination";
$factarray["PAGE"]	= "Citation Details";
$factarray["PEDI"]	= "نسب";
$factarray["PLAC"]	= "مكان";
$factarray["PHON"]	= "الهاتف";
$factarray["POST"]	= "الرمز البريدي";
$factarray["PROB"]	= "إثبات صحة وصية";
$factarray["PROP"]	= "ممتلكات";
$factarray["PUBL"]	= "نشرة";
$factarray["QUAY"]	= "جودة البيانات";
$factarray["REPO"]	= "مستودع البيانات";
$factarray["REFN"]	= "الرقم المرجعي";
$factarray["RELA"]	= "العلاقة";
$factarray["RELI"]	= "الديانة";
$factarray["RESI"]	= "المسكن";
$factarray["RESN"]	= "قيد";
$factarray["RETI"]	= "تقاعد";
$factarray["RFN"]	= "رقم ملف السجل";
$factarray["RIN"]	= "رقم المعرف للسجل";
$factarray["ROLE"]	= "دور";
$factarray["SEX"]	= "الجنس";
$factarray["SLGC"]	= "LDS Child Sealing";
$factarray["SLGS"]	= "LDS Spouse Sealing";
$factarray["SOUR"]	= "المصدر";
$factarray["SPFX"]	= "Surname Prefix";
$factarray["SSN"]	= "رقم هوية الضمان الاجتماعي";
$factarray["STAE"]	= "ولاية";
$factarray["STAT"]	= "الحالة";
$factarray["SUBM"]	= "المقدم";
$factarray["SUBN"]	= "Submission";
$factarray["SURN"]	= "إسم العائلة";
$factarray["TEMP"]	= "معبد";
$factarray["TEXT"]	= "نص";
$factarray["TIME"]	= "وقت";
$factarray["TITL"]	= "عنوان";
$factarray["TYPE"]	= "نوع";
$factarray["WIFE"]  	= "زوجة";
$factarray["WILL"]	= "وصية";
$factarray["_EMAIL"]	= "عنوان البريد الالكتروني";
$factarray["EMAIL"]	= "عنوان البريد الالكتروني";
$factarray["_TODO"]	= "To Do Item";
$factarray["_UID"]	= "Globally unique Identifier";
$factarray["_PRIM"]	= "Highlighted Image";
$factarray["_DBID"] 	= "Linked database ID";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "تاريخ تغيير الحالة";
$factarray["DATA:DATE"] = "تاريخ الادخال في المصدر الأصلي";

$factarray["NAME:_HEB"]	= "اسم باللغة العبرية";
$factarray["PLAC:_HEB"]	= "المكان باللغة العبرية";
$factarray["TITL:_HEB"]	= "العنوان باللغة العبرية";
$factarray["NAME:ROMN"]	= "الاسم بالحروف اللاتينية";
$factarray["PLAC:ROMN"]	= "المكان بالحروف العبرية";
$factarray["TITL:ROMN"]	= "العنوان بالحروف اللاتينية";
$factarray["NAME:FONE"]	= "Phonetic Name";
$factarray["PLAC:FONE"]	= "Phonetic Place";
$factarray["TITL:FONE"]	= "Phonetic Title";

$factarray["SHARED_NOTE"]	= "ملاحظة مشتركة";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"]           = "اسم عائلة الوالد";
$factarray["FAMC:WIFE:SURN"]           = "اسم عائلة الوالدة";
$factarray["FAMC:HUSB:BIRT:PLAC"]      = "مكان ولادة الوالد";
$factarray["FAMC:WIFE:BIRT:PLAC"]      = "مكان ولادة الوالدة";
$factarray["FAMC:MARR:PLAC"]           = "مكان زواج الوالدين";
$factarray["FAMC:HUSB:OCCU"]           = "مهنة الأب";
$factarray[":BIRT:PLAC"]               = "مكان الولادة";
$factarray["FAMS:MARR:PLAC"]           = "مكان الزواج";
$factarray["FAMS:MARR:DATE"]           = "تاريخ الزواج";
$factarray["FAMS:SPOUSE:DEAT:PLAC"]    = "مكان وفاة الزوج";
$factarray["FAMC:HUSB:GIVN"]           = "اسم الأب الأول";
$factarray["FAMS:SPOUSE:BIRT:PLAC"]    = "مكان ولادة الزوج";
$factarray["FAMC:WIFE:GIVN"]           = "اسم الأم الأول";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "اسم الجد (والد الأب) الأول";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "اسم الجدة (والدة الأم) الأول";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "اسم الجد (والد الأم) الأول";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "اسم الجدة (والدة الأب) الأول";
$factarray["FAMS:CHIL:BIRT:PLAC"]      = "مكان ولادة الطفل";
$factarray["FAMS:NOTE"]                = "ملاحظة تخص الزوج";
$factarray["FAMS:CENS:DATE"]           = "Spouse Census Date";
$factarray["FAMS:CENS:PLAC"]           = "Spouse Census Place";
$factarray["FAMS:DIV:DATE"]            = "تاريخ طلاق الزوج";
$factarray["FAMS:DIV:PLAC"]            = "مكان طلاق الزوج";
$factarray["FAMS:SLGS:DATE"]           = "LDS Spouse Sealing Date";
$factarray["FAMS:SLGS:PLAC"]           = "LDS Spouse Sealing Place";
$factarray["FAMS:SLGS:TEMP"]           = "LDS Spouse Sealing Temple";

// These facts are all colon delimited
$factarray["BIRT:PLAC"]                = "مكان الولادة";
$factarray["BIRT:DATE"]                = "تاريخ الولادة";
$factarray["BIRT:SOUR"]                = "مصدر الولادة";
$factarray["DEAT:PLAC"]                = "مكان الوفاة";
$factarray["DEAT:DATE"]                = "تاريخ الوفاة";
$factarray["DEAT:SOUR"]                = "مصدر الوفاة";
$factarray["CHR:PLAC"]                 = "Christening Place";
$factarray["CHR:DATE"]                 = "Christening Date";
$factarray["CHR:SOUR"]                 = "Christening Source";
$factarray["CONF:PLAC"]                = "Confirmation Place";
$factarray["CONF:DATE"]                = "Confirmation Date";
$factarray["CONF:SOUR"]                = "Confirmation Source";
$factarray["BAPM:PLAC"]                = "Baptism Place";
$factarray["BAPM:DATE"]                = "Baptism Date";
$factarray["BAPM:SOUR"]                = "Baptism Source";
$factarray["_BRTM:PLAC"]               = "Brit Mila Place";
$factarray["_BRTM:DATE"]               = "Brit Mila Date";
$factarray["_BRTM:SOUR"]               = "Brit Mila Source";
$factarray["BARM:PLAC"]                = "Bar Mitzvah Place";
$factarray["BARM:DATE"]                = "Bar Mitzvah Date";
$factarray["BARM:SOUR"]                = "Bar Mitzvah Source";
$factarray["BASM:PLAC"]                = "Bas Mitzvah Place";
$factarray["BASM:DATE"]                = "Bas Mitzvah Date";
$factarray["BASM:SOUR"]                = "Bas Mitzvah Source";
$factarray["BURI:PLAC"]                = "مكان الدفن";
$factarray["BURI:DATE"]                = "تاريخ الدفن";
$factarray["BURI:SOUR"]                = "مصدر الدفن";
$factarray["FCOM:PLAC"]                = "First Communion Place";
$factarray["FCOM:DATE"]                = "First Communion Date";
$factarray["FCOM:SOUR"]                = "First Communion Source";
$factarray["MARB:PLAC"]                = "Marriage Banns Place";
$factarray["MARB:DATE"]                = "Marriage Banns Date";
$factarray["MARB:SOUR"]                = "Marriage Banns Source";
$factarray["MARR:PLAC"]                = "مكان الزواج";
$factarray["MARR:DATE"]                = "تاريخ الزواج";
$factarray["MARR:SOUR"]                = "مصدر الزواج";
$factarray["ENGA:PLAC"]                = "مكان الخطبة";
$factarray["ENGA:DATE"]                = "مكان الخطبة";
$factarray["ENGA:SOUR"]                = "مصدر الزواج";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]	= "طبي";
$factarray["_DEG"]	= "شهادة";
$factarray["_MILT"]	= "الخدمة العسكرية";
$factarray["_SEPR"]	= "منفصلين";
$factarray["_DETS"]	= "موت احد الزوجين";
$factarray["CITN"]	= "Citizenship";
$factarray["_FA1"]	= "Fact 1";
$factarray["_FA2"]	= "Fact 2";
$factarray["_FA3"]	= "Fact 3";
$factarray["_FA4"]	= "Fact 4";
$factarray["_FA5"]	= "Fact 5";
$factarray["_FA6"]	= "Fact 6";
$factarray["_FA7"]	= "Fact 7";
$factarray["_FA8"]	= "Fact 8";
$factarray["_FA9"]	= "Fact 9";
$factarray["_FA10"]	= "Fact 10";
$factarray["_FA11"]	= "Fact 11";
$factarray["_FA12"]	= "Fact 12";
$factarray["_FA13"]	= "Fact 13";
$factarray["_MREL"]	= "العلاقة بالأم";
$factarray["_FREL"]	= "العلاقة بالأب";
$factarray["_MSTAT"]	= "Marriage Beginning Status";
$factarray["_MEND"]	= "Marriage Ending Status";
$factarray["_NAMS"]	= "السمي";

// GEDCOM 5.5.1 related facts
$factarray["FAX"]       = "فاكس";
$factarray["FACT"]      = "Fact";
$factarray["WWW"]       = "صفحة الإنترنت";
$factarray["MAP"]       = "خريطة";
$factarray["LATI"]      = "خط العرض";
$factarray["LONG"]      = "خط الطول";
$factarray["FONE"]      = "Phonetic";
$factarray["ROMN"]      = "بالحروف اللاتينية";

// PAF related facts
$factarray["_NAME"]     = "Mailing Name";
$factarray["URL"]       = "رابط صفحة الإنترنت";
$factarray["_URL"]      = "رابط صفحة الإنترنت";
$factarray["_HEB"]      = "العبرية";
$factarray["_SCBK"]     = "ألبوم قصاصات";
$factarray["_TYPE"]     = "نوع الملف";
$factarray["_SSHOW"]    = "عرض الشرائح";

// Rootsmagic
$factarray["_SUBQ"]     = "النسخة قصيرة";
$factarray["_BIBL"]     = "قائمة المراجع";

// Reunion
$factarray["EMAL"]	= "عنوان البريد الالكتروني";

// Other common customized facts
$factarray["_ADPF"]	= "Adopted by Father";
$factarray["_ADPM"]	= "Adopted by Mother";
$factarray["_AKAN"]	= "Also known as";
$factarray["_AKA"] 	= "Also known as";
$factarray["_BRTM"]	= "Brit Mila";
$factarray["_COML"]	= "Common Law Marriage";
$factarray["_EYEC"]	= "لون العينين";
$factarray["_FNRL"]	= "جنازة";
$factarray["_HAIR"]	= "لون الشعر";
$factarray["_HEIG"]	= "الطول";
$factarray["_HOL"]      = "محرقة";
$factarray["_INTE"]	= "Interred";
$factarray["_MARI"]	= "Marriage Intention";
$factarray["_MBON"]	= "Marriage Bond";
$factarray["_MEDC"]	= "حالة طبية";
$factarray["_MILI"]	= "عسكري";
$factarray["_NMR"]	= "غير متزوج";
$factarray["_NLIV"]	= "لا يعيش";
$factarray["_NMAR"]	= "لم يتزوج قط";
$factarray["_PRMN"]	= "عدد دائم";
$factarray["_WEIG"]	= "الوزن";
$factarray["_YART"]	= "Yahrzeit";
$factarray["_MARNM"]    = "Married Name";
$factarray["_MARNM_SURN"] = "Married Surname";
$factarray["_STAT"]	= "الحالة الزوجية";
$factarray["COMM"]	= "تعليق";

// Aldfaer related facts
$factarray["MARR_CIVIL"]     = "Civil Marriage";
$factarray["MARR_RELIGIOUS"] = "Religious Marriage";
$factarray["MARR_PARTNERS"]  = "Registered Partnership";
$factarray["MARR_UNKNOWN"]   = "Marriage Type unknown";

$factarray["_HNM"] = "Hebrew Name";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "وفاة الزوج";
$factarray["_BURI_SPOU"] = "دفن الزوج";
$factarray["_CREM_SPOU"] = "احراق جثة الزوج";

$factarray["_BIRT_CHIL"] = "ولادة طفل";
$factarray["_CHR_CHIL"] = "Christening of a child";
$factarray["_BAPM_CHIL"] = "Baptism of a child";
$factarray["__BRTM_CHIL"] = "Brit Mila of a child";
$factarray["_ADOP_CHIL"] = "Adoption of a child";
$factarray["_MARR_CHIL"] = "زواج طفل";
$factarray["_MARB_CHIL"] = "Marriage Bann of a child";
$factarray["_DEAT_CHIL"] = "وفاة طفل";
$factarray["_BURI_CHIL"] = "دفن طفل";
$factarray["_CREM_CHIL"] = "احراق جثة طفل";

$factarray["_BIRT_GCHI"] = "ولادة حفيد";
$factarray["_CHR_GCHI"] = "Christening of a grandchild";
$factarray["_BAPM_GCHI"] = "Baptism of a grandchild";
$factarray["__BRTM_GCHI"] = "Brit Mila of a grandchild";
$factarray["_ADOP_GCHI"] = "Adoption of a grandchild";
$factarray["_MARR_GCHI"] = "زواج حفيد";
$factarray["_MARB_GCHI"] = "Marriage Bann of a grandchild";
$factarray["_DEAT_GCHI"] = "وفاة حفيد";
$factarray["_BURI_GCHI"] = "دفن حفيد";
$factarray["_CREM_GCHI"] = "احراق جثة حفيد";

$factarray["_BIRT_GGCH"] = "ولادة ولد الحفيد";
$factarray["_CHR_GGCH"] = "Christening of a great-grandchild";
$factarray["_BAPM_GGCH"] = "Baptism of a great-grandchild";
$factarray["__BRTM_GGCH"] = "Brit Mila of a great-grandchild";
$factarray["_ADOP_GGCH"] = "Adoption of a great-grandchild";
$factarray["_MARR_GGCH"] = "Marriage of a great-grandchild";
$factarray["_MARB_GGCH"] = "Marriage Bann of a great-grandchild";
$factarray["_DEAT_GGCH"] = "Death of a great-grandchild";
$factarray["_BURI_GGCH"] = "Burial of a great-grandchild";
$factarray["_CREM_GGCH"] = "Cremation of a great-grandchild";

$factarray["_MARR_FATH"] = "زواج الأب";
$factarray["_MARB_FATH"] = "Marriage Bann of father";
$factarray["_DEAT_FATH"] = "وفاة الأب";
$factarray["_BURI_FATH"] = "دفن الأب";
$factarray["_CREM_FATH"] = "احراق جثة الأب";

$factarray["_MARR_FAMC"] = "زواج الوالدان";
$factarray["_MARB_FAMC"] = "Marriage Bann of parents";

$factarray["_MARR_MOTH"] = "زواج الأم";
$factarray["_MARB_MOTH"] = "Marriage Bann of mother";
$factarray["_DEAT_MOTH"] = "وفاة الأم";
$factarray["_BURI_MOTH"] = "دفن الأم";
$factarray["_CREM_MOTH"] = "احراق جثة الأم";

$factarray["_BIRT_SIBL"] = "ولادة أحد الاخوة الأشقاء";
$factarray["_CHR_SIBL"] = "Christening of sibling";
$factarray["_BAPM_SIBL"] = "Baptism of sibling";
$factarray["__BRTM_SIBL"] = "Brit Mila of sibling";
$factarray["_ADOP_SIBL"] = "Adoption of sibling";
$factarray["_MARR_SIBL"] = "زواج أحد الاخوة الأشقاء";
$factarray["_MARB_SIBL"] = "Marriage Bann of sibling";
$factarray["_DEAT_SIBL"] = "وفاة أحد الاخوة الأشقاء";
$factarray["_BURI_SIBL"] = "دفن أحد الاخوة الأشقاء";
$factarray["_CREM_SIBL"] = "احراق جثة أحد الاخوة الأشقاء";

$factarray["_BIRT_HSIB"] = "ولادة أحد الاخوة غير الأشقاء";
$factarray["_CHR_HSIB"] = "Christening of half-sibling";
$factarray["_BAPM_HSIB"] = "Baptism of half-sibling";
$factarray["__BRTM_HSIB"] = "Brit Mila of half-sibling";
$factarray["_ADOP_HSIB"] = "Adoption of half-sibling";
$factarray["_MARR_HSIB"] = "زواج أحد الاخوة غير الأشقاء";
$factarray["_MARB_HSIB"] = "Marriage Bann of half-sibling";
$factarray["_DEAT_HSIB"] = "وفاة أحد الاخوة غير الأشقاء";
$factarray["_BURI_HSIB"] = "دفن أحد الاخوة غير الأشقاء";
$factarray["_CREM_HSIB"] = "احراق جثة أحد الاخوة غير الأشقاء";

$factarray["_BIRT_NEPH"] = "ولادة أحد ابناء الأشقاء";
$factarray["_CHR_NEPH"] = "Christening of a nephew or niece";
$factarray["_BAPM_NEPH"] = "Baptism of a nephew or niece";
$factarray["__BRTM_NEPH"] = "Brit Mila of a nephew";
$factarray["_ADOP_NEPH"] = "Adoption of a nephew or niece";
$factarray["_MARR_NEPH"] = "زواج أحد ابناء الأشقاء";
$factarray["_MARB_NEPH"] = "Marriage Bann of a nephew or niece";
$factarray["_DEAT_NEPH"] = "وفاة أحد ابناء الأشقاء";
$factarray["_BURI_NEPH"] = "دفن أحد ابناء الأشقاء";
$factarray["_CREM_NEPH"] = "احراق جثة أحد ابناء الأشقاء";

$factarray["_DEAT_GPAR"] = "وفاة أحد الأجداد";
$factarray["_BURI_GPAR"] = "دفن أحد الأجداد";
$factarray["_CREM_GPAR"] = "احراق جثة أحد الأجداد";

$factarray["_DEAT_GGPA"] = "Death of a great-grand-parent";
$factarray["_BURI_GGPA"] = "Burial of a great-grand-parent";
$factarray["_CREM_GGPA"] = "Cremation of a great-grand-parent";

$factarray["_BIRT_FSIB"] = "ولادة أحد أشقاءالأب";
$factarray["_CHR_FSIB"] = "Christening of father's sibling";
$factarray["_BAPM_FSIB"] = "Baptism of father's sibling";
$factarray["__BRTM_FSIB"] = "Brit Mila of father's sibling";
$factarray["_ADOP_FSIB"] = "Adoption of father's sibling";
$factarray["_MARR_FSIB"] = "زواج أحد أشقاءالأب";
$factarray["_MARB_FSIB"] = "Marriage Bann of father's sibling";
$factarray["_DEAT_FSIB"] = "وفاة أحد أشقاءالأب";
$factarray["_BURI_FSIB"] = "دفن أحد أشقاءالأب";
$factarray["_CREM_FSIB"] = "احراق جثة أحد أشقاءالأب";

$factarray["_BIRT_MSIB"] = "ولادة أحد أشقاءالأم";
$factarray["_CHR_MSIB"] = "Christening of mother's sibling";
$factarray["_BAPM_MSIB"] = "Baptism of mother's sibling";
$factarray["__BRTM_MSIB"] = "Brit Mila of mother's sibling";
$factarray["_ADOP_MSIB"] = "Adoption of mother's sibling";
$factarray["_MARR_MSIB"] = "زواج أحد أشقاءالأم";
$factarray["_MARB_MSIB"] = "Marriage Bann of mother's sibling";
$factarray["_DEAT_MSIB"] = "وفاة أحد أشقاءالأم";
$factarray["_BURI_MSIB"] = "دفن أحد أشقاءالأم";
$factarray["_CREM_MSIB"] = "احراق جثة أحد أشقاءالأم";

$factarray["_BIRT_COUS"] = "Birth of a first cousin";
$factarray["_CHR_COUS"]  = "Christening of a first cousin";
$factarray["_BAPM_COUS"] = "Baptism of a first cousin";
$factarray["__BRTM_COUS"] = "Brit Mila of a first cousin";
$factarray["_ADOP_COUS"] = "Adoption of a first cousin";
$factarray["_MARR_COUS"] = "Marriage of a first cousin";
$factarray["_MARB_COUS"] = "Marriage Bann of a first cousin";
$factarray["_DEAT_COUS"] = "Death of a first cousin";
$factarray["_BURI_COUS"] = "Burial of a first cousin";
$factarray["_CREM_COUS"] = "Cremation of a first cousin";

$factarray["_FAMC_EMIG"] = "هجرة الوالدين";
$factarray["_FAMC_RESI"] = "مكان إقامة الوالدين";

//-- PGV Only facts
$factarray["_THUM"]	= "استخدام الصورة الرئيسية دوماً؟";
$factarray["_PGVU"]	= "by"; // last changed by
$factarray["SERV"]      = "Remote Server";
$factarray["_GEDF"]     = "ملف شجرة العائلة";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev = array();		// Don't let other languages specify Fact abbreviations for this language

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>

