<?php
/**
 * Czech Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Jan Hapala
 * @version $Id: facts.cz.php 7354 2022-10-27 18:46:54Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their English values
$factarray["ABBR"]	= "Zkratka";
$factarray["ADDR"]	= "Adresa";
$factarray["ADR1"]	= "Adresa 1";
$factarray["ADR2"]	= "Adresa 2";
$factarray["ADOP"]	= "Adopce";
$factarray["AFN"]	= "Číslo souboru zděděný (AFN)";
$factarray["AGE"]	= "Věk";
$factarray["AGNC"]	= "Instituce";
$factarray["ALIA"]	= "Alias";
$factarray["ANCE"]	= "Předkové";
$factarray["ANCI"]	= "O předcích";
$factarray["ANUL"]	= "Anulování";
$factarray["ASSO"]	= "Sdružení";
$factarray["AUTH"]	= "Autor";
$factarray["BAPL"]	= "Křest (CJKSPD)";
$factarray["BAPM"]	= "Křest";
$factarray["BARM"]	= "Obřad dospělosti židovského chlapce";
$factarray["BASM"]	= "Obřad dospělosti židovské dívky";
$factarray["BIRT"]	= "Narození";
$factarray["BLES"]	= "Požehnání";
$factarray["BLOB"]	= "Binární datový objekt";
$factarray["BURI"]	= "Pohřeb";
$factarray["CALN"]	= "Signatura";
$factarray["CAST"]	= "Kasta / Společenské postavení";
$factarray["CAUS"]	= "Příčina úmrtí";
$factarray["CEME"]  = "Hřbitov";
$factarray["CENS"]	= "Sčítání lidu";
$factarray["CHAN"]	= "Poslední úprava";
$factarray["CHAR"]	= "Znaková sada";
$factarray["CHIL"]	= "Dítě";
$factarray["CHR"]	= "Křest (křesťanský)";
$factarray["CHRA"]	= "Křest v dospělosti";
$factarray["CITY"]	= "Město";
$factarray["CONF"]	= "Biřmování";
$factarray["CONL"]	= "Biřmování (CJKSPD)";
$factarray["COPR"]	= "Copyright";
$factarray["CORP"]	= "Společnost / firma";
$factarray["CREM"]	= "Kremace";
$factarray["CTRY"]	= "Země";
$factarray["DATA"]	= "Data";
$factarray["DATE"]	= "Datum";
$factarray["DEAT"]	= "Úmrtí";
$factarray["DESC"]	= "Potomci";
$factarray["DESI"]	= "O potomcích";
$factarray["DEST"]	= "Cíl";
$factarray["DIV"]	= "Rozvod";
$factarray["DIVF"]	= "Rozvodový spis";
$factarray["DSCR"]	= "Popis";
$factarray["EDUC"]	= "Vzdělání";
$factarray["EMIG"]	= "Emigrace";
$factarray["ENDL"]	= "Nadace (CJKSPD)";
$factarray["ENGA"]	= "Zasnoubení";
$factarray["EVEN"]	= "Události";
$factarray["FAM"]	= "Rodina";
$factarray["FAMC"]	= "Rodina, jako dítěte";
$factarray["FAMF"]	= "Soubory rodiny";
$factarray["FAMS"]	= "Rodina, jako partner";
$factarray["FCOM"]	= "První příjímání";
$factarray["FILE"]	= "Externí soubor";
$factarray["FORM"]	= "Formát";
$factarray["GIVN"]	= "Křestní jména";
$factarray["GRAD"]	= "Promoce";
$factarray["HUSB"]  = "manžel";
$factarray["IDNO"]	= "Identifikační číslo";
$factarray["IMMI"]	= "Imigrace";
$factarray["LEGA"]	= "Dědictví";
$factarray["MARB"]	= "Manželství ohlášky";
$factarray["MARC"]	= "Manželství smlouva";
$factarray["MARL"]	= "Manželství povolení";
$factarray["MARR"]	= "Sňatek";
$factarray["MARS"]	= "Manželská dohoda";
$factarray["MEDI"]	= "Typ média";
$factarray["NAME"]	= "Jméno";
$factarray["NATI"]	= "Národnost";
$factarray["NATU"]	= "Udělení občanství";
$factarray["NCHI"]	= "Počet dětí";
$factarray["NICK"]	= "Přezdívka";
$factarray["NMR"]	= "Počet sňatků";
$factarray["NOTE"]	= "Poznámka";
$factarray["NPFX"]	= "Prefix";
$factarray["NSFX"]	= "Suffix";
$factarray["OBJE"]	= "Multimediální objekt";
$factarray["OCCU"]	= "Povolání";
$factarray["ORDI"]	= "Ustanovení";
$factarray["ORDN"]	= "Vysvěcení na kněze";
$factarray["PAGE"]	= "Podrobnosti o citace";
$factarray["PEDI"]	= "Rodokmen";
$factarray["PLAC"]	= "Místo";
$factarray["PHON"]	= "Telefon";
$factarray["POST"]	= "PSČ";
$factarray["PROB"]	= "Soudní ověření poslední vůle";
$factarray["PROP"]	= "Vlastnictví";
$factarray["PUBL"]	= "Vydal";
$factarray["QUAY"]	= "Kvalita dat";
$factarray["REPO"]	= "Repozitáře";
$factarray["REFN"]	= "Referenční číslo";
$factarray["RELA"]	= "Příbuzenský vztah";
$factarray["RELI"]	= "Náboženství";
$factarray["RESI"]	= "Sídlo";
$factarray["RESN"]	= "Zákaz";
$factarray["RETI"]	= "Odchod do důchodu";
$factarray["RFN"]	= "Souborové číslo záznamu";
$factarray["RIN"]	= "ID číslo záznamu";
$factarray["ROLE"]	= "Postavení";
$factarray["SEX"]	= "Pohlaví";
$factarray["SLGC"]	= "Vydání záznamu o narození (CJKSPD)";
$factarray["SLGS"]	= "Vydání záznamu o sňatku (CJKSPD)";
$factarray["SOUR"]	= "Zdroj";
$factarray["SPFX"]	= "Prefix před příjmením";
$factarray["SSN"]	= "Číslo sociálního zabezpečení";
$factarray["STAE"]	= "Stát";
$factarray["STAT"]	= "Stav";
$factarray["SUBM"]	= "Pramen (KDO poskytl informaci)";
$factarray["SUBN"]	= "Rezignace";
$factarray["SURN"]	= "Příjmení";
$factarray["TEMP"]	= "Chrám (Temple)";
$factarray["TEXT"]	= "Text";
$factarray["TIME"]	= "Čas";
$factarray["TITL"]	= "Titul";
$factarray["TYPE"]	= "Typ";
$factarray["WIFE"]  = "Manželka";
$factarray["WILL"]	= "Závěť";
$factarray["_EMAIL"]= "Emailová adresa";
$factarray["EMAIL"]	= "Emailová adresa";
$factarray["_TODO"]	= "Chcete-li udělat položku";
$factarray["_UID"]	= "Univerzální identifikátor";
$factarray["_PRIM"]	= "Zvýrazněný obrázek";
$factarray["_DBID"] = "Související databáze ID";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Datum změny stavu";
$factarray["DATA:DATE"] = "Datum vstupu v originální zdroj";

$factarray["NAME:_HEB"]	= "Jméno v hebrejštině";
$factarray["PLAC:_HEB"]	= "Místo v hebrejštině";
$factarray["TITL:_HEB"]	= "Název v hebrejštině";
$factarray["NAME:ROMN"]	= "Jméno v latinkou";
$factarray["PLAC:ROMN"]	= "Místo v latinkou";
$factarray["TITL:ROMN"]	= "Název v latinkou";
$factarray["NAME:FONE"]	= "Název v fonetický";
$factarray["PLAC:FONE"]	= "Místo v fonetický";
$factarray["TITL:FONE"]	= "Název v fonetický";

$factarray["SHARED_NOTE"]	= "Sdílené Poznámka";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"] = "Otcův Příjmení";
$factarray["FAMC:WIFE:SURN"] = "Matky Příjmení";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Otcův narození";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Matky narození";
$factarray["FAMC:MARR:PLAC"] = "Místo Manželství rodičů";
$factarray["FAMC:HUSB:OCCU"] = "Otcův Povolání";
$factarray[":BIRT:PLAC"] = "Místo narození";
$factarray["FAMS:MARR:PLAC"] = "Místo manželství";
$factarray["FAMS:MARR:DATE"] = "Datum manželství";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Místo úmrtí partner";
$factarray["FAMC:HUSB:GIVN"] = "Křestní jméno otce";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Místo narození partner";
$factarray["FAMC:WIFE:GIVN"] = "Křestní jméno matky";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Křestní jméno otcovský dědeček";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Křestní jméno mateřská babička";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Křestní jméno mateřský dědeček";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Křestní jméno otcovská babička";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Místo narození dítěte";
$factarray["FAMS:NOTE"] = "Poznámka o partner";
$factarray["FAMS:CENS:DATE"] = "Datum sčítání partner";
$factarray["FAMS:CENS:PLAC"] = "Místo sčítání partner";
$factarray["FAMS:DIV:DATE"] = "Datum rozvodu partner";
$factarray["FAMS:DIV:PLAC"] = "Místo rozvodu partner";
$factarray["FAMS:SLGS:PLAC"] = "Místo těsnění partner (CJKSPD)";
$factarray["FAMS:SLGS:DATE"] = "Datum těsnění partner (CJKSPD)";
$factarray["FAMS:SLGS:TEMP"] = "Chrám těsnění partner (CJKSPD)";

// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Místo narození";
$factarray["BIRT:DATE"] = "Datum narození";
$factarray["BIRT:SOUR"] = "Zdroj narození";
$factarray["DEAT:PLAC"] = "Místo úmrtí";
$factarray["DEAT:DATE"] = "Datum úmrtí";
$factarray["DEAT:SOUR"] = "Zdroj úmrtí";
$factarray["CHR:PLAC"] = "Místo křtu";
$factarray["CHR:DATE"] = "Datum křtu";
$factarray["CHR:SOUR"] = "Zdroj křtu";
$factarray["CONF:PLAC"] = "Místo potvrzení";
$factarray["CONF:DATE"] = "Datum potvrzení";
$factarray["CONF:SOUR"] = "Zdroj potvrzení";
$factarray["BAPM:PLAC"] = "Místo křtu";
$factarray["BAPM:DATE"] = "Datum křtu";
$factarray["BAPM:SOUR"] = "Zdroj křtu";
$factarray["_BRTM:PLAC"] = "Místo Brit Mila";
$factarray["_BRTM:DATE"] = "Datum Brit Mila";
$factarray["_BRTM:SOUR"] = "Zdroj Brit Mila";
$factarray["BARM:PLAC"] = "Místo Bar Mitzvah";
$factarray["BARM:DATE"] = "Datum Bar Mitzvah";
$factarray["BARM:SOUR"] = "Zdroj Bar Mitzvah";
$factarray["BASM:PLAC"] = "Místo Bas Mitzvah";
$factarray["BASM:DATE"] = "Datum Bas Mitzvah";
$factarray["BASM:SOUR"] = "Zdroj Bas Mitzvah";
$factarray["BURI:PLAC"] = "Místo pohřbení";
$factarray["BURI:DATE"] = "Datum pohřbení";
$factarray["BURI:SOUR"] = "Zdroj pohřbení";
$factarray["FCOM:PLAC"] = "Místo prvního společenství";
$factarray["FCOM:DATE"] = "Datum prvního společenství";
$factarray["FCOM:SOUR"] = "Zdroj prvního společenství";
$factarray["MARB:PLAC"] = "Místo manželství svatebních ohlášek";
$factarray["MARB:DATE"] = "Datum manželství svatebních ohlášek";
$factarray["MARB:SOUR"] = "Zdroj manželství svatebních ohlášek";
$factarray["MARR:PLAC"] = "Místo manželství";
$factarray["MARR:DATE"] = "Datum manželství";
$factarray["MARR:SOUR"] = "Zdroj manželství";
$factarray["ENGA:PLAC"] = "Místo zásnubní";
$factarray["ENGA:DATE"] = "Datum zásnubní";
$factarray["ENGA:SOUR"] = "Zdroj zásnubní";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]	= "Lékařský";
$factarray["_DEG"]	= "Hodnost";
$factarray["_MILT"]	= "Vojenská služba";
$factarray["_SEPR"]	= "Odloučení";
$factarray["_DETS"]	= "Úmrtí jednoho z partner";
$factarray["CITN"]	= "Občanství";
$factarray["_FA1"] = "Údaj 1";
$factarray["_FA2"] = "Údaj 2";
$factarray["_FA3"] = "Údaj 3";
$factarray["_FA4"] = "Údaj 4";
$factarray["_FA5"] = "Údaj 5";
$factarray["_FA6"] = "Údaj 6";
$factarray["_FA7"] = "Údaj 7";
$factarray["_FA8"] = "Údaj 8";
$factarray["_FA9"] = "Údaj 9";
$factarray["_FA10"] = "Údaj 10";
$factarray["_FA11"] = "Údaj 11";
$factarray["_FA12"] = "Údaj 12";
$factarray["_FA13"] = "Údaj 13";
$factarray["_MREL"] = "Vztah k matce";
$factarray["_FREL"] = "Vztah k otci";
$factarray["_MSTAT"]	= "Rodinný začátek stav";
$factarray["_MEND"]	= "Rodinný ukončení stav";
$factarray["_NAMS"]	= "Jmenovec";

// GEDCOM 5.5.1 related facts
$factarray["FAX"] = "FAX";
$factarray["FACT"] = "Údaj";
$factarray["WWW"] = "Domácí stránka";
$factarray["MAP"] = "Mapa";
$factarray["LATI"] = "Zeměpsiná šířka";
$factarray["LONG"] = "Zeměpisná délka";
$factarray["FONE"] = "Fonetický přepis";
$factarray["ROMN"] = "Latinkou";

// PAF related facts
$factarray["_NAME"] = "Jméno na poštovních zásilkách";
$factarray["URL"] = "URL stránek";
$factarray["_URL"] = "URL stránek";
$factarray["_HEB"] = "Hebrejsky";
$factarray["_SCBK"] = "Zápisníku";
$factarray["_TYPE"] = "Typ média";
$factarray["_SSHOW"] = "Prezentace";

// Rootsmagic
$factarray["_SUBQ"]= "Zkráceně";
$factarray["_BIBL"] = "Bibliografie";

// Reunion
$factarray["EMAL"]	= "Emailová adresa";

// Other common customized facts
$factarray["_ADPF"]	= "Adoptován otcem";
$factarray["_ADPM"]	= "Adoptován matkou";
$factarray["_AKAN"]	= "Také znám jako";
$factarray["_AKA"] 	= "Také znám jako";
$factarray["_BRTM"]	= "Židovský obřad obřízky";
$factarray["_COML"]	= "Civilní sňatek";
$factarray["_EYEC"]	= "Barva očí";
$factarray["_FNRL"]	= "Pohřeb";
$factarray["_HAIR"]	= "Barva vlasů";
$factarray["_HEIG"]	= "Výška";
$factarray["_HOL"]  = "Naprostá zkáza";
$factarray["_INTE"]	= "Pohřeb do hrobu";
$factarray["_MARI"]	= "Oznámení sňatku";
$factarray["_MBON"]	= "Manželský svazek";
$factarray["_MEDC"]	= "Zdravotní stav";
$factarray["_MILI"]	= "Vojenská služba";
$factarray["_NMR"]	= "Svobodná/ý";
$factarray["_NLIV"]	= "Nežijící";
$factarray["_NMAR"]	= "Celý život svobodná/ý";
$factarray["_PRMN"]	= "Číslo občanského průkazu";
$factarray["_WEIG"]	= "Váha";
$factarray["_YART"]	= "Židovské datum narození Yahrzeit";
$factarray["_MARNM"]	= "Rodinný jméno";
$factarray["_MARNM_SURN"] = "Rodinný jmén";
$factarray["_STAT"]	= "Rodinný stav";
$factarray["COMM"]	= "Komentář";

// Aldfaer related facts
$factarray["MARR_CIVIL"] = "Občanský sňatek";
$factarray["MARR_RELIGIOUS"] = "náboženský sňatek";
$factarray["MARR_PARTNERS"] = "Registrované partnerství";
$factarray["MARR_UNKNOWN"] = "Sňatek typ neznámý";

$factarray["_HNM"] = "Jméno v hebrejštině";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Úmrtí partner";
$factarray["_BURI_SPOU"] = "Pohřeb partner";
$factarray["_CREM_SPOU"] = "Kremace partner";

$factarray["_BIRT_CHIL"] = "Narození dítěte";
$factarray["_CHR_CHIL"] = "Křest dítěte";
$factarray["_BAPM_CHIL"] = "Křest dítěte";
$factarray["__BRTM_CHIL"] = "Brit mila dítěte";
$factarray["_ADOP_CHIL"] = "Přijetí dítěte";
$factarray["_MARR_CHIL"] = "Manželství dítěte";
$factarray["_MARB_CHIL"] = "Manželství ohlášky dítěte";
$factarray["_DEAT_CHIL"] = "Úmrtí dítěte";
$factarray["_BURI_CHIL"] = "Pohřeb dítěte";
$factarray["_CREM_CHIL"] = "Kremace dítěte";

$factarray["_BIRT_GCHI"] = "Narození vnuka";
$factarray["_CHR_GCHI"] = "Křest vnuka";
$factarray["_BAPM_GCHI"] = "Křest vnuka";
$factarray["__BRTM_GCHI"] = "Brit Mila vnuka";
$factarray["_ADOP_GCHI"] = "Křest vnuka";
$factarray["_MARR_GCHI"] = "Manželství vnuka";
$factarray["_MARB_GCHI"] = "Manželství ohlášky vnuka";
$factarray["_DEAT_GCHI"] = "Úmrtí vnuka";
$factarray["_BURI_GCHI"] = "Pohřeb vnuka";
$factarray["_CREM_GCHI"] = "Kremace vnuka";

$factarray["_BIRT_GGCH"] = "Narození pravnuk";
$factarray["_CHR_GGCH"] = "Křest pravnuk";
$factarray["_BAPM_GGCH"] = "Křest pravnuk";
$factarray["__BRTM_GGCH"] = "Brit Mila pravnuk";
$factarray["_ADOP_GGCH"] = "Křest pravnuk";
$factarray["_MARR_GGCH"] = "Manželství pravnuk";
$factarray["_MARB_GGCH"] = "Manželství ohlášky pravnuk";
$factarray["_DEAT_GGCH"] = "Úmrtí pravnuk";
$factarray["_BURI_GGCH"] = "Pohřeb pravnuk";
$factarray["_CREM_GGCH"] = "Kremace pravnuk";

$factarray["_MARR_FATH"] = "Manželství otce";
$factarray["_MARB_FATH"] = "Manželství ohlášky otce";
$factarray["_DEAT_FATH"] = "Úmrtí otce";
$factarray["_BURI_FATH"] = "Pohřeb otce";
$factarray["_CREM_FATH"] = "Kremace otce";

$factarray["_MARR_FAMC"] = "Manželství rodičů";
$factarray["_MARB_FAMC"] = "Manželství ohlášky rodičů";

$factarray["_MARR_MOTH"] = "Manželství matky";
$factarray["_MARB_MOTH"] = "Manželství ohlášky matky";
$factarray["_DEAT_MOTH"] = "Úmrtí matky";
$factarray["_BURI_MOTH"] = "Pohřeb matky";
$factarray["_CREM_MOTH"] = "Kremace matky";

$factarray["_BIRT_SIBL"] = "Narození sourozenec";
$factarray["_CHR_SIBL"] = "Křest sourozenec";
$factarray["_BAPM_SIBL"] = "Křest sourozenec";
$factarray["__BRTM_SIBL"] = "Brit Mila sourozenec";
$factarray["_ADOP_SIBL"] = "Křest sourozenec";
$factarray["_MARR_SIBL"] = "Manželství sourozenec";
$factarray["_MARB_SIBL"] = "Manželství ohlášky sourozenec";
$factarray["_DEAT_SIBL"] = "Úmrtí sourozenec";
$factarray["_BURI_SIBL"] = "Pohřeb sourozenec";
$factarray["_CREM_SIBL"] = "Kremace sourozenec";

$factarray["_BIRT_HSIB"] = "Narození půl sourozenec";
$factarray["_CHR_HSIB"] = "Křest půl sourozenec";
$factarray["_BAPM_HSIB"] = "Křest půl sourozenec";
$factarray["__BRTM_HSIB"] = "Brit Mila půl sourozenec";
$factarray["_ADOP_HSIB"] = "Křest půl sourozenec";
$factarray["_MARR_HSIB"] = "Manželství půl sourozenec";
$factarray["_MARB_HSIB"] = "Manželství ohlášky půl sourozenec";
$factarray["_DEAT_HSIB"] = "Úmrtí půl sourozenec";
$factarray["_BURI_HSIB"] = "Pohřeb půl sourozenec";
$factarray["_CREM_HSIB"] = "Kremace půl sourozenec";

$factarray["_BIRT_NEPH"] = "Narození synovec nebo neteř";
$factarray["_CHR_NEPH"] = "Křest synovec nebo neteř";
$factarray["_BAPM_NEPH"] = "Křest synovec nebo neteř";
$factarray["__BRTM_NEPH"] = "Brit Mila z synovce";
$factarray["_ADOP_NEPH"] = "Křest synovec nebo neteř";
$factarray["_MARR_NEPH"] = "Manželství synovec nebo neteř";
$factarray["_MARB_NEPH"] = "Manželství ohlášky synovec nebo neteř";
$factarray["_DEAT_NEPH"] = "Úmrtí synovec nebo neteř";
$factarray["_BURI_NEPH"] = "Pohřeb synovec nebo neteř";
$factarray["_CREM_NEPH"] = "Kremace synovec nebo neteř";

$factarray["_DEAT_GPAR"] = "Úmrtí prarodiče";
$factarray["_BURI_GPAR"] = "Pohřeb prarodiče";
$factarray["_CREM_GPAR"] = "Kremace prarodiče";

$factarray["_DEAT_GGPA"] = "Úmrtí velký-velký-rodič";
$factarray["_BURI_GGPA"] = "Pohřeb velký-velký-rodič";
$factarray["_CREM_GGPA"] = "Kremace velký-velký-rodič";

$factarray["_BIRT_FSIB"] = "Narození sourozenec otce";
$factarray["_CHR_FSIB"] = "Křest sourozenec otce";
$factarray["_BAPM_FSIB"] = "Křest sourozenec otce";
$factarray["__BRTM_FSIB"] = "Brit Mila sourozenec otce";
$factarray["_ADOP_FSIB"] = "Křest sourozenec otce";
$factarray["_MARR_FSIB"] = "Manželství sourozenec otce";
$factarray["_MARB_FSIB"] = "Manželství ohlášky sourozenec otce";
$factarray["_DEAT_FSIB"] = "Úmrtí sourozenec otce";
$factarray["_BURI_FSIB"] = "Pohřeb sourozenec otce";
$factarray["_CREM_FSIB"] = "Kremace sourozenec otce";

$factarray["_BIRT_MSIB"] = "Narození sourozenec matky";
$factarray["_CHR_MSIB"] = "Křest sourozenec matky";
$factarray["_BAPM_MSIB"] = "Křest sourozenec matky";
$factarray["__BRTM_MSIB"] = "Brit Mila sourozenec matky";
$factarray["_ADOP_MSIB"] = "Křest sourozenec matky";
$factarray["_MARR_MSIB"] = "Manželství sourozenec matky";
$factarray["_MARB_MSIB"] = "Manželství ohlášky sourozenec matky";
$factarray["_DEAT_MSIB"] = "Úmrtí sourozenec matky";
$factarray["_BURI_MSIB"] = "Pohřeb sourozenec matky";
$factarray["_CREM_MSIB"] = "Kremace sourozenec matky";

$factarray["_BIRT_COUS"] = "Narození prvního bratrance";
$factarray["_CHR_COUS"]  = "Křest prvního bratrance";
$factarray["_BAPM_COUS"] = "Křest prvního bratrance";
$factarray["__BRTM_COUS"] = "Brit Mila prvního bratrance";
$factarray["_ADOP_COUS"] = "Křest prvního bratrance";
$factarray["_MARR_COUS"] = "Manželství prvního bratrance";
$factarray["_MARB_COUS"] = "Manželství ohlášky prvního bratrance";
$factarray["_DEAT_COUS"] = "Úmrtí prvního bratrance";
$factarray["_BURI_COUS"] = "Pohřeb prvního bratrance";
$factarray["_CREM_COUS"] = "Kremace prvního bratrance";

$factarray["_FAMC_EMIG"] = "Emigrace z rodičů";
$factarray["_FAMC_RESI"] = "Sídlo z rodičů";

//-- PGV Only facts
$factarray["_THUM"]	= "Použít tento obrázek jako náhled?";
$factarray["_PGVU"]	= "Naposledy změnil";
$factarray["SERV"] = "Vzdálený server";
$factarray["_GEDF"] = "GEDCOM souboru";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev = array();		// Don't let other languages specify Fact abbreviations for this language

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>
