<?php
/**
 * Norwegian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * # $Id: facts.no.php 7376 2024-09-17 14:41:00Z canajun2eh $
 *
 * @translator Geir Håkon Eikland
 * @translator Thomas Rindal
 * @package PhpGedView
 * @subpackage Languages
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their Norwegian values
$factarray["ABBR"] = "Forkortelse";
$factarray["ADDR"] = "Adresse";
$factarray["ADR1"] = "Adresse 1";
$factarray["ADR2"] = "Adresse 2";
$factarray["ADOP"] = "Adoptert";
$factarray["AFN"]  = "Slekts-filnr";
$factarray["AGE"]  = "Alder";
$factarray["AGNC"] = "Agentur";
$factarray["ALIA"] = "Alias";
$factarray["ANCE"] = "Forfedre";
$factarray["ANCI"] = "Interesse for forfedre";
$factarray["ANUL"] = "Annullert ekteskap";
$factarray["ASSO"] = "Forbindelser";
$factarray["AUTH"] = "Forfatter";
$factarray["BAPL"] = "Døpt SDH";
$factarray["BAPM"] = "Døpt";
$factarray["BARM"] = "Bar Mitzvah";
$factarray["BASM"] = "Bat Mitzvah";
$factarray["BIRT"] = "Født";
$factarray["BLES"] = "Velsignet / Navnefest";
$factarray["BLOB"] = "Binært dataobjekt";
$factarray["BURI"] = "Gravlagt";
$factarray["CALN"] = "Katalognummer";
$factarray["CAST"] = "Kaste / Sosial status";
$factarray["CAUS"] = "Dødsårsak";
$factarray["CEME"] = "Kirkegård";
$factarray["CENS"] = "Folketelling";
$factarray["CHAN"] = "Sist endret";
$factarray["CHAR"] = "Tegnsett";
$factarray["CHIL"] = "Barn";
$factarray["CHR"]  = "Barnedåp";
$factarray["CHRA"] = "Voksendåp";
$factarray["CITY"] = "Sted / by";
$factarray["CONF"] = "Konfirmasjon";
$factarray["CONL"] = "Konfirmasjon SDH";
$factarray["COPR"] = "Opphavsrett / Copyright";
$factarray["CORP"] = "Bedrifts-/firmanavn";
$factarray["CREM"] = "Kremasjon";
$factarray["CTRY"] = "Land";
$factarray["DATE"] = "Dato";
$factarray["DATA"] = "Data";
$factarray["DEAT"] = "Død";
$factarray["DESC"] = "Etterkommere";
$factarray["DESI"] = "Interesse for etterkommere";
$factarray["DEST"] = "Mål";
$factarray["DIV"]  = "Skilsmisse";
$factarray["DIVF"] = "Skilsmissebegjæring";
$factarray["DSCR"] = "Beskrivelse";
$factarray["EDUC"] = "Utdannelse";
$factarray["EMIG"] = "Utvandret";
$factarray["ENDL"] = "Gave SDH";
$factarray["ENGA"] = "Forlovet";
$factarray["EVEN"] = "Hendelse";
$factarray["FAM"]  = "Familie";
$factarray["FAMC"] = "Familie-ID for barn";
$factarray["FAMF"] = "Familiekort";
$factarray["FAMS"] = "Familie-ID for ektefelle/partner";
$factarray["FCOM"] = "Første nattverd-måltid";
$factarray["FILE"] = "Ekstern fil";
$factarray["FORM"] = "Format";
$factarray["GIVN"] = "Fornavn";
$factarray["GRAD"] = "Uteksaminert";
$factarray["HUSB"] = "Ektemann";
$factarray["IDNO"] = "Identifikasjonsnummer";
$factarray["IMMI"] = "Innvandret";
$factarray["LEGA"] = "Arving";
$factarray["MARB"] = "Lysning til ekteskap";
$factarray["MARC"] = "Ekteskapskontrakt";
$factarray["MARL"] = "Ekteskapsattest";
$factarray["MARR"] = "Ekteskap";
$factarray["MARS"] = "Ekteskapsavtale";
$factarray["MEDI"] = "Media-type";
$factarray["NAME"] = "Navn";
$factarray["NATI"] = "Nasjonalitet";
$factarray["NATU"] = "Statsborgerskap";
$factarray["NCHI"] = "Antall barn";
$factarray["NICK"] = "Kallenavn";
$factarray["NMR"]  = "Antall ekteskap";
$factarray["NOTE"] = "Note";
$factarray["NPFX"] = "Navn Prefiks";
$factarray["NSFX"] = "Navn Postfiks";
$factarray["OBJE"] = "Multimedia objekt";
$factarray["OCCU"] = "Yrke";
$factarray["ORDI"] = "Forordning";
$factarray["ORDN"] = "Ordinasjon";
$factarray["PAGE"] = "Sitatdetaljer";
$factarray["PEDI"] = "Slektsgrein";
$factarray["PLAC"] = "Stedsnavn";
$factarray["PHON"] = "Telefonnummer";
$factarray["POST"] = "Postnummer";
$factarray["PROB"] = "Skifte";
$factarray["PROP"] = "Eiendom";
$factarray["PUBL"] = "Publikasjon";
$factarray["QUAY"] = "Datakvalitet";
$factarray["REPO"] = "Oppbevaringssted";
$factarray["REFN"] = "Referensenummer";
$factarray["RELA"] = "Forholdet";
$factarray["RELI"] = "Religion";
$factarray["RESI"] = "Bosted";
$factarray["RESN"] = "Restriksjon";
$factarray["RETI"] = "Pensjonert";
$factarray["RFN"]  = "Ref.nr. (statisk)";
$factarray["RIN"]  = "Ref.nr. (dynamisk)";
$factarray["ROLE"] = "Rolle";
$factarray["SEX"]  = "Kjønn";
$factarray["SLGC"] = "Barn-kobling SDH";
$factarray["SLGS"] = "Ekteskap-kobling SDH";
$factarray["SOUR"] = "Kilde";
$factarray["SPFX"] = "Etternavn prefiks";
$factarray["SSN"]  = "Personnummer";
$factarray["STAE"] = "Stat/Region";
$factarray["STAT"] = "Status";
$factarray["SUBM"] = "Bidragsgiver";
$factarray["SUBN"] = "Del av datasamling";
$factarray["SURN"] = "Etternavn";
$factarray["TEMP"] = "Tempel";
$factarray["TEXT"] = "Tekst";
$factarray["TIME"] = "Klokkeslett";
$factarray["TITL"] = "Tittel";
$factarray["TYPE"] = "Type";
$factarray["WIFE"] = "Hustru";
$factarray["WILL"] = "Testamente";
$factarray["_EMAIL"] = "E-post adresse";
$factarray["EMAIL"] = "E-post adresse";
$factarray["_TODO"] = "Utestående gjøremål";
$factarray["_UID"] = "Universell ID";
$factarray["_PRIM"]	= "Merket som hovedbilde";
$factarray["_DBID"] = "Linket database ID";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Statusendringsdato";
$factarray["DATA:DATE"] = "Dato for oppføring i original kilde";

$factarray["NAME:_HEB"]	= "Navn på hebraisk";
$factarray["PLAC:_HEB"]	= "Sted på hebraisk";
$factarray["TITL:_HEB"]	= "Tittel på hebraisk";
$factarray["NAME:ROMN"]	= "Romanisert navn";
$factarray["PLAC:ROMN"]	= "Romanisert sted";
$factarray["TITL:ROMN"]	= "Romanisert tittel";
$factarray["NAME:FONE"]	= "Fonetisk navn";
$factarray["PLAC:FONE"]	= "Fonetisk sted";
$factarray["TITL:FONE"]	= "Fonetisk tittel";

$factarray["SHARED_NOTE"]	= "Delt notat";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"] = "Farens etternavn";
$factarray["FAMC:WIFE:SURN"] = "Morens etternavn";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Farens fødested";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Morens fødested";
$factarray["FAMC:MARR:PLAC"] = "Foreldrenes vielsessted";
$factarray["FAMC:HUSB:OCCU"] = "Farens yrke";
$factarray[":BIRT:PLAC"] = "Fødested";
$factarray["FAMS:MARR:PLAC"] = "Vielsessted";
$factarray["FAMS:MARR:DATE"] = "Vielsesdato";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Ektefellens dødssted";
$factarray["FAMC:HUSB:GIVN"] = "Farens fornavn";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Ektefellens fødested";
$factarray["FAMC:WIFE:GIVN"] = "Morens fornavn";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Farfarens fornavn";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Mormorens fornavn";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Morfarens fornavn";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Farmorens fornavn";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Barnets fødested";
$factarray["FAMS:NOTE"] = "Ektefelle merknad";
$factarray["FAMS:CENS:DATE"] = "Ektefellens folketellingsdato";
$factarray["FAMS:CENS:PLAC"] = "Ektefellens folketellingssted";
$factarray["FAMS:DIV:DATE"] = "Ektefellens skilsmissedato";
$factarray["FAMS:DIV:PLAC"] = "Ektefellens skilsmissested";
$factarray["FAMS:SLGS:DATE"] = "Dato for besegling SDH av ekteskap";
$factarray["FAMS:SLGS:PLAC"] = "Sted for besegling SDH av ekteskap";
$factarray["FAMS:SLGS:TEMP"] = "Tempel for besegling SDH av ekteskap";

// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Fødested";
$factarray["BIRT:DATE"] = "Fødselsdato";
$factarray["BIRT:SOUR"] = "Fødselskilde";
$factarray["DEAT:PLAC"] = "Dødssted";
$factarray["DEAT:DATE"] = "Dødsdato";
$factarray["DEAT:SOUR"] = "Dødskilde";
$factarray["CHR:PLAC"] = "Dåpssted";
$factarray["CHR:DATE"] = "Dåpsdato";
$factarray["CHR:SOUR"] = "Dåpskilde";
$factarray["CONF:PLAC"] = "Konfirmasjonssted";
$factarray["CONF:DATE"] = "Konfirmasjonsdato";
$factarray["CONF:SOUR"] = "Konfirmasjonskilde";
$factarray["BAPM:PLAC"] = "Dåpssted";
$factarray["BAPM:DATE"] = "Dåpsdato";
$factarray["BAPM:SOUR"] = "Dåpskilde";
$factarray["_BRTM:PLAC"] = "Brit Mila sted";
$factarray["_BRTM:DATE"] = "Brit Mila dato";
$factarray["_BRTM:SOUR"] = "Brit Mila kilde";
$factarray["BARM:PLAC"] = "Bar Mitzvah sted";
$factarray["BARM:DATE"] = "Bar Mitzvah dato";
$factarray["BARM:SOUR"] = "Bar Mitzvah kilde";
$factarray["BASM:PLAC"] = "Bas Mitzvah sted";
$factarray["BASM:DATE"] = "Bas Mitzvah dato";
$factarray["BASM:SOUR"] = "Bas Mitzvah kilde";
$factarray["BURI:PLAC"] = "Begravelsenssted";
$factarray["BURI:DATE"] = "Begravelsesdato";
$factarray["BURI:SOUR"] = "Begravelseskilde";
$factarray["FCOM:PLAC"] = "Første nattverd sted";
$factarray["FCOM:DATE"] = "Første nattverd dato";
$factarray["FCOM:SOUR"] = "Første nattverd kilde";
$factarray["MARB:PLAC"] = "Lysning til ekteskap sted";
$factarray["MARB:DATE"] = "Lysning til ekteskap dato";
$factarray["MARB:SOUR"] = "Lysning til ekteskap kilde";
$factarray["MARR:PLAC"] = "Vielsessted";
$factarray["MARR:DATE"] = "Vielsesdato";
$factarray["MARR:SOUR"] = "Vielseskilde";
$factarray["ENGA:PLAC"] = "Forlovetssted";
$factarray["ENGA:DATE"] = "Forlovetsdato";
$factarray["ENGA:SOUR"] = "Forlovetskilde";

$factarray["REPO:NAME"] = "Navnet på arkivet";
$factarray["REPO:ADDR"] = "Adresse for arkivet";
$factarray["REPO:PHON"] = "Telefonnummer for arkivet";
$factarray["REPO:FAX"]  = "Faksnummer for arkivet";
$factarray["REPO:EMAIL"] = "E-postadresse for arkivet";
$factarray["REPO:WWW"]  = "Hjemmeside for arkivet";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"] = "Helse";
$factarray["_DEG"] 	= "Akademisk grad";
$factarray["_MILT"] = "Militærtjeneste";
$factarray["_SEPR"] = "Separert";
$factarray["_DETS"] = "Ektefelles død";
$factarray["CITN"] 	= "Statsborgerskap";
$factarray["_FA1"]	= "Fakta 1";
$factarray["_FA2"]	= "Fakta 2";
$factarray["_FA3"]	= "Fakta 3";
$factarray["_FA4"]	= "Fakta 4";
$factarray["_FA5"]	= "Fakta 5";
$factarray["_FA6"]	= "Fakta 6";
$factarray["_FA7"]	= "Fakta 7";
$factarray["_FA8"]	= "Fakta 8";
$factarray["_FA9"]	= "Fakta 9";
$factarray["_FA10"]	= "Fakta 10";
$factarray["_FA11"]	= "Fakta 11";
$factarray["_FA12"]	= "Fakta 12";
$factarray["_FA13"]	= "Fakta 13";
$factarray["_MREL"]	= "Tilknytning til mor";
$factarray["_FREL"]	= "Tilknytning til far";
$factarray["_MSTAT"] = "Ekteskap start-status";
$factarray["_MEND"]	= "Ekteskap slutt-status";
$factarray["_NAMS"]	= "Navnesak";

// GEDCOM 5.5.1 related facts
$factarray["FAX"]	= "Faks";
$factarray["FACT"]	= "Fakta";
$factarray["WWW"]	= "Hjemmeside";
$factarray["MAP"]	= "Kart";
$factarray["LATI"]	= "Breddegrad";
$factarray["LONG"]	= "Lengdegrad";
$factarray["FONE"]	= "Fonetisk";
$factarray["ROMN"]	= "Romanisert";

// PAF related facts
$factarray["_NAME"]	= "Navn på postmottager";
$factarray["URL"]	= "Internett-adresse";
$factarray["_URL"]	= "Internett-adresse";
$factarray["_HEB"]	= "Hebraisk";
$factarray["_SCBK"] = "Utklippsbok";
$factarray["_TYPE"] = "Media-type";
$factarray["_SSHOW"] = "Lysbildeframvining";

// Rootsmagic
$factarray["_SUBQ"]	= "Kortversjon";
$factarray["_BIBL"] = "Bibliografi";

// Reunion
$factarray["EMAL"]	= "E-postadresse";

// Other common customized facts
$factarray["_ADPF"] = "Adopteret av faren";
$factarray["_ADPM"] = "Adopteret av moren";
$factarray["_AKAN"] = "Også kjent som";
$factarray["_AKA"] 	= "Også kjent som";
$factarray["_BRTM"] = "Brit Mila";
$factarray["_COML"]	= "Samboerskap";
$factarray["_EYEC"] = "Øyefarge";
$factarray["_FNRL"] = "Bisettelse";
$factarray["_HAIR"] = "Hårfarve";
$factarray["_HEIG"] = "Høyde";
$factarray["_HOL"]  = "Holocaust";
$factarray["_INTE"] = "Urnenedsettelse";
$factarray["_MARI"] = "Ekteskaps-intensjon";
$factarray["_MBON"] = "Ekteskapsgaranti";
$factarray["_MEDC"] = "Helsetilstand";
$factarray["_MILI"] = "Militærtjeneste";
$factarray["_NMR"] = "Samboer";
$factarray["_NLIV"] = "Lever ikke";
$factarray["_NMAR"] = "Aldri gift";
$factarray["_PRMN"] = "Permanent nummer";
$factarray["_WEIG"] = "Vekt";
$factarray["_YART"] = "Yahrzeit";
$factarray["_MARNM"] = "Navn som gift";
$factarray["_MARNM_SURN"] = "Etternavn som gift";
$factarray["_STAT"]	= "Sivilstatus";
$factarray["COMM"]	= "Kommentar";

// Aldfaer related facts
$factarray["MARR_RELIGIOUS"]	= "religiøs";
$factarray["MARR_CIVIL"]		= "borgerlig";
$factarray["MARR_PARTNERS"]		= "partnere";
$factarray["MARR_UNKNOWN"]		= "ukjent";

$factarray["_HNM"] = "Hebraisk navn";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Dødsfall til ektefelle";
$factarray["_BURI_SPOU"] = "Begravelse til ektefelle";
$factarray["_CREM_SPOU"] = "Kremasjon av ektefelle";

$factarray["_BIRT_CHIL"] = "Barns fødsel";
$factarray["_CHR_CHIL"] = "Barns dåp";
$factarray["_BAPM_CHIL"] = "Barns dåp";
$factarray["__BRTM_CHIL"] = "Barns Brit Mila";
$factarray["_ADOP_CHIL"] = "Barns adopsjon";
$factarray["_MARR_CHIL"] = "Barns ekteskap";
$factarray["_MARB_CHIL"] = "Barns lysning av ekteskap";
$factarray["_DEAT_CHIL"] = "Barns dødsfall";
$factarray["_BURI_CHIL"] = "Barns begravelse";
$factarray["_CREM_CHIL"] = "Barns kremasjon";

$factarray["_BIRT_GCHI"] 	= "Barnebarns fødsel";
$factarray["_CHR_GCHI"] 	= "Barnebarns dåp";
$factarray["_BAPM_GCHI"] 	= "Barnebarns dåp";
$factarray["__BRTM_GCHI"] 	= "Barnebarns Brit Mila";
$factarray["_ADOP_GCHI"] 	= "Barnebarns adopsjon";
$factarray["_MARR_GCHI"] 	= "Barnebarns ekteskap";
$factarray["_MARB_GCHI"] 	= "Barnebarns lysning av ekteskap";
$factarray["_DEAT_GCHI"] 	= "Barnebarns dødsfall";
$factarray["_BURI_GCHI"] 	= "Barnebarns begravelse";
$factarray["_CREM_GCHI"] 	= "Barnebarns kremasjon";

$factarray["_BIRT_GGCH"] 	= "Oldebarns fødsel";            
$factarray["_CHR_GGCH"] 	= "Oldebarns dåp";               
$factarray["_BAPM_GGCH"] 	= "Oldebarns dåp";               
$factarray["__BRTM_GGCH"] 	= "Oldebarns Brit Mila";          
$factarray["_ADOP_GGCH"] 	= "Oldebarns adopsjon";           
$factarray["_MARR_GGCH"] 	= "Oldebarns ekteskap";           
$factarray["_MARB_GGCH"] 	= "Oldebarns lysning av ekteskap";
$factarray["_DEAT_GGCH"] 	= "Oldebarns dødsfall";          
$factarray["_BURI_GGCH"] 	= "Oldebarns begravelse";         
$factarray["_CREM_GGCH"] 	= "Oldebarns kremasjon";          

$factarray["_MARR_FATH"] = "Farens ekteskap";
$factarray["_MARB_FATH"] = "Farens lysning av ekteskap";
$factarray["_DEAT_FATH"] = "Farens dødsfall";
$factarray["_BURI_FATH"] = "Farens begravelse";
$factarray["_CREM_FATH"] = "Farens kremasjon";

$factarray["_MARR_FAMC"] = "Foreldrenes ektekskap";
$factarray["_MARB_FAMC"] = "Foreldrenes lysning av ekteskap";

$factarray["_MARR_MOTH"] = "Morens ekteskap";
$factarray["_MARB_MOTH"] = "Morens lysning av ekteskap";
$factarray["_DEAT_MOTH"] = "Morens dødsfall";
$factarray["_BURI_MOTH"] = "Morens begravelse";
$factarray["_CREM_MOTH"] = "Morens kremasjon";

$factarray["_BIRT_SIBL"] 	= "Søsknenes fødsel";
$factarray["_CHR_SIBL"] 	= "Søsknenes då";
$factarray["_BAPM_SIBL"] 	= "Søsknenes dåp";
$factarray["__BRTM_SIBL"] 	= "Søsknenes Brit Mila";
$factarray["_ADOP_SIBL"] 	= "Søsknenes adopsjon";
$factarray["_MARR_SIBL"] 	= "Søsknenes ekteskap";
$factarray["_MARB_SIBL"] 	= "Søsknenes lysning av ekteskap";
$factarray["_DEAT_SIBL"] 	= "Søsknenes dødsfall";
$factarray["_BURI_SIBL"] 	= "Søsknenes begravelse";
$factarray["_CREM_SIBL"] 	= "Søsknenes kremasjon";

$factarray["_BIRT_HSIB"] 	= "Halvsøsknenes fødsel";            
$factarray["_CHR_HSIB"] 	= "Halvsøsknenes då";                
$factarray["_BAPM_HSIB"] 	= "Halvsøsknenes dåp";               
$factarray["__BRTM_HSIB"] 	= "Halvsøsknenes Brit Mila";          
$factarray["_ADOP_HSIB"] 	= "Halvsøsknenes adopsjon";           
$factarray["_MARR_HSIB"] 	= "Halvsøsknenes ekteskap";           
$factarray["_MARB_HSIB"] 	= "Halvsøsknenes lysning av ekteskap";
$factarray["_DEAT_HSIB"] 	= "Halvsøsknenes dødsfall";          
$factarray["_BURI_HSIB"] 	= "Halvsøsknenes begravelse";         
$factarray["_CREM_HSIB"] 	= "Halvsøsknenes kremasjon";          

$factarray["_BIRT_NEPH"] 	= "Søsknenbarns fødsel";            
$factarray["_CHR_NEPH"] 	= "Søsknenbarns då";                
$factarray["_BAPM_NEPH"] 	= "Søsknenbarns dåp";               
$factarray["__BRTM_NEPH"] 	= "Søsknenbarns Brit Mila";          
$factarray["_ADOP_NEPH"] 	= "Søsknenbarns adopsjon";           
$factarray["_MARR_NEPH"] 	= "Søsknenbarns ekteskap";           
$factarray["_MARB_NEPH"] 	= "Søsknenbarns lysning av ekteskap";
$factarray["_DEAT_NEPH"] 	= "Søsknenbarns dødsfall";          
$factarray["_BURI_NEPH"] 	= "Søsknenbarns begravelse";         
$factarray["_CREM_NEPH"] 	= "Søsknenbarns kremasjon";          

$factarray["_DEAT_GPAR"] = "Besteforeldrenes dødsfall";
$factarray["_BURI_GPAR"] = "Besteforeldrenes begravelse";
$factarray["_CREM_GPAR"] = "Besteforeldrenes kremasjon";

$factarray["_DEAT_GGPA"] = "Oldeforeldrenes dødsfall";
$factarray["_BURI_GGPA"] = "Oldeforeldrenes begravelse";
$factarray["_CREM_GGPA"] = "Oldeforeldrenes kremasjon";

$factarray["_BIRT_FSIB"] 	= "Farens søskens fødsel";
$factarray["_CHR_FSIB"] 	= "Farens søskens dåp";
$factarray["_BAPM_FSIB"] 	= "Farens søskens dåp";
$factarray["__BRTM_FSIB"] 	= "Farens søskens Brit Mila";
$factarray["_ADOP_FSIB"] 	= "Farens søskens adopsjon";
$factarray["_MARR_FSIB"] 	= "Farens søskens ekteskap";
$factarray["_MARB_FSIB"] 	= "Farens søskens lysning av ekteskap";
$factarray["_DEAT_FSIB"] 	= "Farens søskens dødsfall";
$factarray["_BURI_FSIB"] 	= "Farens søskens begravelse";
$factarray["_CREM_FSIB"] 	= "Farens søskens kremasjon";

$factarray["_BIRT_MSIB"] 	= "Morens søskens fødsel";            
$factarray["_CHR_MSIB"] 	= "Morens søskens dåp";               
$factarray["_BAPM_MSIB"] 	= "Morens søskens dåp";               
$factarray["__BRTM_MSIB"] 	= "Morens søskens Brit Mila";          
$factarray["_ADOP_MSIB"] 	= "Morens søskens adopsjon";           
$factarray["_MARR_MSIB"] 	= "Morens søskens ekteskap";           
$factarray["_MARB_MSIB"] 	= "Morens søskens lysning av ekteskap";
$factarray["_DEAT_MSIB"] 	= "Morens søskens dødsfall";          
$factarray["_BURI_MSIB"] 	= "Morens søskens begravelse";         
$factarray["_CREM_MSIB"] 	= "Morens søskens kremasjon";          

$factarray["_BIRT_COUS"] 	= "Tremennings fødsel";            
$factarray["_CHR_COUS"]  	= "Tremennings dåp";               
$factarray["_BAPM_COUS"] 	= "Tremennings dåp";               
$factarray["__BRTM_COUS"] 	= "Tremennings Brit Mila";          
$factarray["_ADOP_COUS"] 	= "Tremennings adopsjon";           
$factarray["_MARR_COUS"] 	= "Tremennings ekteskap";           
$factarray["_MARB_COUS"] 	= "Tremennings lysning av ekteskap";
$factarray["_DEAT_COUS"] 	= "Tremennings dødsfall";          
$factarray["_BURI_COUS"] 	= "Tremennings begravelse";         
$factarray["_CREM_COUS"] 	= "Tremennings kremasjon";          

$factarray["_FAMC_EMIG"] = "Foreldrenes emigrasjon";
$factarray["_FAMC_RESI"] = "Foreldrenes bosted";

//-- PGV Only facts
$factarray["_THUM"]	= "Bruk alltid hovedbildet?";
$factarray["_PGVU"]	= "Sist oppdatert av";
$factarray["SERV"] = "Fjerntjener";
$factarray["_GEDF"] = "GEDCOM-fil";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev = array();		// Don't let other languages specify Fact abbreviations for this language

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>
