<?php
/**
 * Portugese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author José Monteiro
 * @website http://existologoescrevo.blogspot.com/
 * @e-mail jalberto@bluewin.ch
 * @version $Id: facts.pt.php 7376 2024-09-17 14:41:00Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
// -- Define a fact array to map GEDCOM tags with their Portuguese values
$factarray["ABBR"]		= "Abreviação";
$factarray["ADDR"]		= "Endereço ";
$factarray["ADR1"]		= "Endereço 1";
$factarray["ADR2"]		= "Endereço 2";
$factarray["ADOP"]		= "Adoção";
$factarray["AFN"]		= "Número do Arquivo Ancestral (AFN)";
$factarray["AGE"]		= "Idade";
$factarray["AGNC"]		= "Agencia";
$factarray["ALIA"]		= "Apelido";
$factarray["ANCE"]		= "Ancestrais";
$factarray["ANCI"]		= "Interesse em antepassados";
$factarray["ANUL"]		= "Anulação";
$factarray["ASSO"]		= "Associado";
$factarray["AUTH"]		= "Autor";
$factarray["BAPL"]		= "Batismo SUD";
$factarray["BAPM"]		= "Batismo";
$factarray["BARM"]		= "Bar Mitzvah";
$factarray["BASM"]		= "Bas Mitzvah";
$factarray["BIRT"]		= "Nascimento";
$factarray["BLES"]		= "Batizado";
$factarray["BLOB"]		= "Objeto binário";
$factarray["BURI"]		= "Sepultamento";
$factarray["CALN"]		= "Número de catálogo";
$factarray["CAST"]		= "Casta / Estado social";
$factarray["CAUS"]		= "Causa do morte";
$factarray["CEME"]		= "Cemitério";
$factarray["CENS"]		= "Censo";
$factarray["CHAN"]		= "Atualizado em";
$factarray["CHAR"]		= "Conjunto de caracteres";
$factarray["CHIL"]		= "Filho";
$factarray["CHR"]		= "Batizado";
$factarray["CHRA"]		= "Batizado como adulto";
$factarray["CITY"]		= "Cidade";
$factarray["CONF"]		= "Confirmação";
$factarray["CONL"]		= "Confirmação SUD";
$factarray["COPR"]		= "Direitos autorais";
$factarray["CORP"]		= "Instituição / Empresa";
$factarray["CREM"]		= "Cremação";
$factarray["CTRY"]		= "Pais";
$factarray["DATA"]		= "Dados";
$factarray["DATE"]		= "Data";
$factarray["DEAT"]		= "Morte";
$factarray["DESC"]		= "Descendentes";
$factarray["DESI"]		= "Interesse em descendentes";
$factarray["DEST"]		= "Destino";
$factarray["DIV"]		= "Divórcio";
$factarray["DIVF"]		= "Pedido de divórcio";
$factarray["DSCR"]		= "Descrição ";
$factarray["EDUC"]		= "Educação";
$factarray["EMIG"]		= "Emigração";
$factarray["ENDL"]		= "Investidura SUD";
$factarray["ENGA"]		= "Noivado";
$factarray["EVEN"]		= "Evento";
$factarray["FAM"]		= "Família";
$factarray["FAMC"]		= "Família como filho";
$factarray["FAMF"]		= "Arquivo de família";
$factarray["FAMS"]		= "Família como cônjuge";
$factarray["FCOM"]		= "Primeira comunhão";
$factarray["FILE"]		= "Arquivo externo";
$factarray["FORM"]		= "Formato";
$factarray["GIVN"]		= "Nomes";
$factarray["GRAD"]		= "Graduação";
$factarray["HUSB"]		= "Marido";
$factarray["IDNO"]		= "Número de identificação";
$factarray["IMMI"]		= "Imigração";
$factarray["LEGA"]		= "Herdeiro";
$factarray["MARB"]		= "Anuncio de casamento";
$factarray["MARC"]		= "Contrato matrimonial";
$factarray["MARL"]		= "Licença de casamento";
$factarray["MARR"]		= "Casamento";
$factarray["MARS"]		= "Acordo matrimonial";
$factarray["MEDI"]		= "Tipo de mídia";
$factarray["NAME"]		= "Nome";
$factarray["NATI"]		= "Nacionalidade";
$factarray["NATU"]		= "Naturalização";
$factarray["NCHI"]		= "Número de filhos";
$factarray["NICK"]		= "Apelido";
$factarray["NMR"]		= "Número de casamentos";
$factarray["NOTE"]		= "Nota";
$factarray["NPFX"]		= "Prefixo do Nome";
$factarray["NSFX"]		= "Sufixo do Nome";
$factarray["OBJE"]		= "Mídia";
$factarray["OCCU"]		= "Ocupação";
$factarray["ORDI"]		= "Regulamento";
$factarray["ORDN"]		= "Ordenação";
$factarray["PAGE"]		= "Detalhes da citação";
$factarray["PEDI"]		= "Árvore genealógica";
$factarray["PLAC"]		= "Local";
$factarray["PHON"]		= "Telefone";
$factarray["POST"]		= "Código postal";
$factarray["PROB"]		= "Comprovação de legitimidade";
$factarray["PROP"]		= "Propriedade";
$factarray["PUBL"]		= "Publicação";
$factarray["QUAY"]		= "Credibilidade dos dados";
$factarray["REPO"]		= "Repositório ";
$factarray["REFN"]		= "Número de Referência";
$factarray["RELA"]		= "Relacionamento";
$factarray["RELI"]		= "Religião";
$factarray["RESI"]		= "Residência";
$factarray["RESN"]		= "Restrição";
$factarray["RETI"]		= "Aposentadoria";
$factarray["RFN"]		= "Número do registro";
$factarray["RIN"]		= "Número de identificação do registro";
$factarray["ROLE"]		= "Cargo";
$factarray["SEX"]		= "Sexo";
$factarray["SLGC"]		= "Vedação SUD de criança";
$factarray["SLGS"]		= "Vedação SUD do cônjuge";
$factarray["SOUR"]		= "Fonte";
$factarray["SPFX"]		= "Prefixo do sobrenome";
$factarray["SSN"]		= "Número do seguro social";
$factarray["STAE"]		= "Estado";
$factarray["STAT"]		= "Situação";
$factarray["SUBM"]		= "Submissor";
$factarray["SUBN"]		= "Submissão";
$factarray["SURN"]		= "Sobrenome";
$factarray["TEMP"]		= "Templo";
$factarray["TEXT"]		= "Texto";
$factarray["TIME"]		= "Hora";
$factarray["TITL"]		= "Titulo";
$factarray["TYPE"]		= "Tipo";
$factarray["WIFE"]		= "Esposa";
$factarray["WILL"]		= "Testamento";
$factarray["_EMAIL"]	= "Endereço de email";
$factarray["EMAIL"]		= "Endereço de email";
$factarray["_TODO"]		= "A fazer";
$factarray["_UID"]		= "Identificador Universal";
$factarray["_PRIM"]		= "Imagem de destaque";
$factarray["_DBID"] 	= "Ligada identificação do banco de dados";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Data da mudança de estado";
$factarray["DATA:DATE"] = "Data de entrada na fonte original";

$factarray["NAME:_HEB"]	= "Nome em hebraico";
$factarray["PLAC:_HEB"]	= "Local em hebraico";
$factarray["TITL:_HEB"]	= "Título em hebraico";
$factarray["NAME:ROMN"]	= "Nome romanizado";
$factarray["PLAC:ROMN"]	= "Local romanizado";
$factarray["TITL:ROMN"]	= "Titulo romanizado";
$factarray["NAME:FONE"]	= "Nome fonético";
$factarray["PLAC:FONE"]	= "Local fonética";
$factarray["TITL:FONE"]	= "Titulo fonética";

$factarray["SHARED_NOTE"]	= "Nota partilhada";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"] 			= "Sobrenome do pai";
$factarray["FAMC:WIFE:SURN"] 			= "Sobrenome da mãe";
$factarray["FAMC:HUSB:BIRT:PLAC"] 		= "Local de nascimento do pai";
$factarray["FAMC:WIFE:BIRT:PLAC"] 		= "Local de nascimento da mãe";
$factarray["FAMC:MARR:PLAC"] 			= "Local casamento dos pais";
$factarray["FAMC:HUSB:OCCU"] 			= "Ocupação do pai";
$factarray[":BIRT:PLAC"] 				= "Local de nascimento";
$factarray["FAMS:MARR:PLAC"] 			= "Local casamento";
$factarray["FAMS:MARR:DATE"] 			= "Data de casamento";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] 	= "Local da morte do cônjuge";
$factarray["FAMC:HUSB:GIVN"] 			= "Nome dado do Pai";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] 	= "Local de nascimento do cônjuge";
$factarray["FAMC:WIFE:GIVN"] 			= "Nome dado da mãe";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"]	= "Nome dado do avô´ paterno";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"]	= "Nome dado da avó³ materna";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"]	= "Nome dado do avó´ materno";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"]	= "Nome dado da avô³ paterna";
$factarray["FAMS:CHIL:BIRT:PLAC"] 		= "Local de nascimento do filho";
$factarray["FAMS:NOTE"] 				= "Nota do Cônjuge";
$factarray["FAMS:CENS:DATE"] 			= "Data censo do cônjuge";
$factarray["FAMS:CENS:PLAC"] 			= "Local censo do cônjuge";
$factarray["FAMS:DIV:DATE"] 			= "Data divórcio de cônjuge";
$factarray["FAMS:DIV:PLAC"] 			= "Local divórcio do cônjuge";
$factarray["FAMS:SLGS:DATE"] 			= "Data de vedação SUD do cônjuge";
$factarray["FAMS:SLGS:PLAC"] 			= "Local de vedação SUD do cônjuge";
$factarray["FAMS:SLGS:TEMP"] 			= "Templo de vedação SUD do cônjuge";

// These facts are all colon delimited
$factarray["BIRT:PLAC"]		= "Local de nascimento";
$factarray["BIRT:DATE"]		= "Data de nascimento";
$factarray["BIRT:SOUR"]		= "Fonte de nascimento";
$factarray["DEAT:PLAC"]		= "Local da morte";
$factarray["DEAT:DATE"]		= "Data do morte";
$factarray["DEAT:SOUR"]		= "Fonte de morte";
$factarray["CHR:PLAC"] 		= "Local de batismo";
$factarray["CHR:DATE"] 		= "Data do batismo";
$factarray["CHR:SOUR"] 		= "Fonte de batismo";
$factarray["CONF:PLAC"] 	= "Local de confirmação";
$factarray["CONF:DATE"] 	= "Data da confirmação";
$factarray["CONF:SOUR"] 	= "Fonte de confirmação";
$factarray["BAPM:PLAC"] 	= "Local de batismo";
$factarray["BAPM:DATE"] 	= "Data do batismo";
$factarray["BAPM:SOUR"] 	= "Fonte do batismo";
$factarray["_BRTM:PLAC"] 	= "Local de Brit Mila";
$factarray["_BRTM:DATE"] 	= "Data de Brit Mila";
$factarray["_BRTM:SOUR"] 	= "Fonte de Brit Mila";
$factarray["BARM:PLAC"] 	= "Local de Bar Mitzvah";
$factarray["BARM:DATE"] 	= "Data de Bar Mitzvah";
$factarray["BARM:SOUR"] 	= "Fonte de Bar Mitzvah";
$factarray["BASM:PLAC"] 	= "Local de Bas Mitzvah";
$factarray["BASM:DATE"]		= "Data de Bas Mitzvah";
$factarray["BASM:SOUR"]		= "Fonte de Bas Mitzvah";
$factarray["BURI:PLAC"]		= "Local de sepultamento";
$factarray["BURI:DATE"]		= "Data de sepultamento";
$factarray["BURI:SOUR"]		= "Fonte de sepultamento";
$factarray["FCOM:PLAC"]		= "Local da primeira comunhão";
$factarray["FCOM:DATE"]		= "Data da primeira comunhão";
$factarray["FCOM:SOUR"]		= "Fonte da primeira comunhão";
$factarray["MARB:PLAC"]		= "Local de anuncio de casamento";
$factarray["MARB:DATE"]		= "Data de anuncio de casamento";
$factarray["MARB:SOUR"]		= "Fonte de anuncio de casamento";
$factarray["MARR:PLAC"]		= "Local do casamento";
$factarray["MARR:DATE"]		= "Data do casamento";
$factarray["MARR:SOUR"]		= "Fonte do casamento";
$factarray["ENGA:PLAC"]		= "Local de noivado";
$factarray["ENGA:DATE"]		= "Data de noivado";
$factarray["ENGA:SOUR"]		= "Fonte de noivado";

$factarray["REPO:NAME"] = "Nome do arquivo";
$factarray["REPO:ADDR"] = "Endereço do arquivo";
$factarray["REPO:PHON"] = "Número de telefone do arquivo";
$factarray["REPO:FAX"]  = "Número de FAX do arquivo";
$factarray["REPO:EMAIL"] = "Endereço de e-mail do arquivo";
$factarray["REPO:WWW"]  = "Página inicial do arquivoe";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]			= "Prontuário";
$factarray["_DEG"]			= "Graduação";
$factarray["_MILT"]			= "Serviço militar";
$factarray["_SEPR"]			= "Separado";
$factarray["_DETS"]			= "Morte de Cônjuge";
$factarray["CITN"]			= "Cidadania";
$factarray["_FA1"]			= "Fato 1";
$factarray["_FA2"]			= "Fato 2";
$factarray["_FA3"]			= "Fato 3";
$factarray["_FA4"]			= "Fato 4";
$factarray["_FA5"]			= "Fato 5";
$factarray["_FA6"]			= "Fato 6";
$factarray["_FA7"]			= "Fato 7";
$factarray["_FA8"]			= "Fato 8";
$factarray["_FA9"]			= "Fato 9";
$factarray["_FA10"]			= "Fato 10";
$factarray["_FA11"]			= "Fato 11";
$factarray["_FA12"]			= "Fato 12";
$factarray["_FA13"]			= "Fato 13";
$factarray["_MREL"]			= "Relação materna";
$factarray["_FREL"]			= "Relação paterna";
$factarray["_MSTAT"]		= "Situação inicial do casamento";
$factarray["_MEND"]			= "Situação final do casamento";
$factarray["_NAMS"]			= "Homónimo";

// GEDCOM 5.5.1 related facts
$factarray["FAX"]			= "FAX";
$factarray["FACT"]			= "Fato";
$factarray["WWW"]			= "Página pessoal";
$factarray["MAP"]			= "Mapa";
$factarray["LATI"]			= "Latitude";
$factarray["LONG"]			= "Longitude";
$factarray["FONE"]			= "Fonético";
$factarray["ROMN"]			= "Romano";

// PAF related facts
$factarray["_NAME"]			= "Nome para correspondência";
$factarray["URL"]			= "URL na Internet";
$factarray["_URL"] 			= "URL na Internet";
$factarray["_HEB"] 			= "Hebreu";
$factarray["_SCBK"]			= "Livro de fotos";
$factarray["_TYPE"]			= "Tipo de mídia";
$factarray["_SSHOW"]		= "Apresentação de diapositivos";

// Rootsmagic
$factarray["_SUBQ"]			= "Versão reduzida";
$factarray["_BIBL"]			= "Bibliografia";

// Reunion
$factarray["EMAL"]= "Endereço de email";

// Other common customized facts
$factarray["_ADPF"]			= "Adoção paterna";
$factarray["_ADPM"]			= "Adoção materna";
$factarray["_AKAN"]			= "Também conhecido por";
$factarray["_AKA"]			= "Também conhecido por";
$factarray["_BRTM"]			= "Brit Mila";
$factarray["_COML"]			= "Coabitação marital";
$factarray["_EYEC"]			= "Cor dos olhos";
$factarray["_FNRL"]			= "Enterro";
$factarray["_HAIR"]			= "Cor do cabelo";
$factarray["_HEIG"]			= "Altura";
$factarray["_HOL"]			= "Holocausto";
$factarray["_INTE"]			= "Sepultado";
$factarray["_MARI"]			= "Intenção matrimonial";
$factarray["_MBON"]			= "Ligação familiar";
$factarray["_MEDC"]			= "Quadro clinico";
$factarray["_MILI"]			= "Militar";
$factarray["_NMR"]			= "Solteiro";
$factarray["_NLIV"]			= "Não Vivos";
$factarray["_NMAR"]			= "Nunca foi casado";
$factarray["_PRMN"]			= "Número permanente";
$factarray["_WEIG"]			= "Peso";
$factarray["_YART"]			= "Yahrzeit";
$factarray["_MARNM"]		= "Nome de casada";
$factarray["_MARNM_SURN"] 	= "Apelido casado";
$factarray["_STAT"]			= "Estado civil";
$factarray["COMM"]			= "Comentário";

// Aldfaer related facts
$factarray["MARR_RELIGIOUS"]	= "religioso";
$factarray["MARR_CIVIL"]		= "civil";
$factarray["MARR_PARTNERS"]		= "parceiros";
$factarray["MARR_UNKNOWN"]		= "desconhecido";

$factarray["_HNM"]= "Nome hebraico";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"]		= "Morte do Cônjuge";
$factarray["_BURI_SPOU"] 		= "Sepultamento do cônjuge";
$factarray["_CREM_SPOU"] 		= "Cremação do cônjuge";

$factarray["_BIRT_CHIL"]		= "Nascimento de filho";
$factarray["_CHR_CHIL"] 		= "Batizado de filho";
$factarray["_BAPM_CHIL"] 		= "Batismo de filho";
$factarray["__BRTM_CHIL"] 		= "Brit Mila de filho";
$factarray["_ADOP_CHIL"] 		= "Adoção de filho";
$factarray["_MARR_CHIL"]		= "Casamento de filho";
$factarray["_MARB_CHIL"] 		= "Anuncio de casamento de filho";
$factarray["_DEAT_CHIL"]		= "Morte de filho";
$factarray["_BURI_CHIL"] 		= "Sepultamento de filho";
$factarray["_CREM_CHIL"] 		= "Cremação de filho";

$factarray["_BIRT_GCHI"]		= "Nascimento de neto";
$factarray["_CHR_GCHI"] 		= "Batizado de neto";
$factarray["_BAPM_GCHI"] 		= "Batismo de neto";
$factarray["__BRTM_GCHI"] 		= "Brit Mila de neto";
$factarray["_ADOP_GCHI"] 		= "Adoção de neto";
$factarray["_MARR_GCHI"]		= "Casamento de neto";
$factarray["_MARB_GCHI"] 		= "Anuncio de casamento de neto";
$factarray["_DEAT_GCHI"]		= "Morte de neto";
$factarray["_BURI_GCHI"] 		= "Sepultamento de neto";
$factarray["_CREM_GCHI"] 		= "Cremação de neto";

$factarray["_BIRT_GGCH"] 		= "Nascimento de bisneto";
$factarray["_CHR_GGCH"] 		= "Batizado de bisneto";
$factarray["_BAPM_GGCH"] 		= "Batismo de bisneto";
$factarray["__BRTM_GGCH"] 		= "Brit Mila de bisneto";
$factarray["_ADOP_GGCH"] 		= "Adoção de bisneto";
$factarray["_MARR_GGCH"] 		= "Casamento de bisneto";
$factarray["_MARB_GGCH"] 		= "Anuncio de casamento de bisneto";
$factarray["_DEAT_GGCH"] 		= "Morte de bisneto";
$factarray["_BURI_GGCH"] 		= "Sepultamento de bisneto";
$factarray["_CREM_GGCH"] 		= "Cremação de bisneto";

$factarray["_MARR_FATH"]		= "Casamento do pai";
$factarray["_MARB_FATH"] 		= "Anuncio de casamento do pai";
$factarray["_DEAT_FATH"]		= "Morte do pai";
$factarray["_BURI_FATH"] 		= "Sepultamento do pai";
$factarray["_CREM_FATH"] 		= "Cremação do pai";

$factarray["_MARR_FAMC"] 		= "Casamento dos pais";
$factarray["_MARB_FAMC"] 		= "Anuncio de casamento dos pais";

$factarray["_MARR_MOTH"]		= "Casamento da mãe";
$factarray["_MARB_MOTH"] 		= "Anuncio de casamento da mãe";
$factarray["_DEAT_MOTH"]		= "Morte da mãe";
$factarray["_BURI_MOTH"] 		= "Sepultamento da mãe";
$factarray["_CREM_MOTH"] 		= "Cremação da mãe";

$factarray["_BIRT_SIBL"]		= "Nascimento de irmão/irmã";
$factarray["_CHR_SIBL"] 		= "Batizado de irmão/irmã";
$factarray["_BAPM_SIBL"] 		= "Batismo de irmão/irmã";
$factarray["__BRTM_SIBL"] 		= "Brit Mila de irmão/irmã";
$factarray["_ADOP_SIBL"] 		= "Adoção de irmão/irmã";
$factarray["_MARR_SIBL"]		= "Casamento de irmão/irmã";
$factarray["_MARB_SIBL"] 		= "Anuncio de casamento de irmão/irmã";
$factarray["_DEAT_SIBL"]		= "Morte de irmão/irmã";
$factarray["_BURI_SIBL"] 		= "Sepultamento de irmão/irmã";
$factarray["_CREM_SIBL"] 		= "Cremação de irmão/irmã";

$factarray["_BIRT_HSIB"]		= "Nascimento de meio-irmão/meia-irmã";
$factarray["_CHR_HSIB"] 		= "Batizado de meio-irmão/meia-irmã";
$factarray["_BAPM_HSIB"] 		= "Batismo de meio-irmão/meia-irmã";
$factarray["__BRTM_HSIB"] 		= "Brit Mila de meio-irmão/meia-irmã";
$factarray["_ADOP_HSIB"] 		= "Adoção de meio-irmão/meia-irmã";
$factarray["_MARR_HSIB"]		= "Casamento de meio-irmão/meia-irmã";
$factarray["_MARB_HSIB"] 		= "Anuncio de casamento de meio-irmão/meia-irmã";
$factarray["_DEAT_HSIB"]		= "Morte de meio-irmão/meia-irmã";
$factarray["_BURI_HSIB"] 		= "Sepultamento de meio-irmão/meia-irmã";
$factarray["_CREM_HSIB"] 		= "Cremação de meio-irmão/meia-irmã";

$factarray["_BIRT_NEPH"] 		= "Nascimento de sobrinho/sobrinha";
$factarray["_CHR_NEPH"] 		= "Batizado de sobrinho/sobrinha";
$factarray["_BAPM_NEPH"] 		= "Batismo de sobrinho/sobrinha";
$factarray["__BRTM_NEPH"] 		= "Brit Mila de sobrinho/sobrinha";
$factarray["_ADOP_NEPH"] 		= "Adoção de sobrinho/sobrinha";
$factarray["_MARR_NEPH"] 		= "Casamento de sobrinho/sobrinha";
$factarray["_MARB_NEPH"] 		= "Anuncio de casamento de sobrinho/sobrinha";
$factarray["_DEAT_NEPH"] 		= "Morte de sobrinho/sobrinha";
$factarray["_BURI_NEPH"] 		= "Sepultamento de sobrinho/sobrinha";
$factarray["_CREM_NEPH"] 		= "Cremação de sobrinho/sobrinha";

$factarray["_DEAT_GPAR"]		= "Morte de avô";
$factarray["_BURI_GPAR"] 		= "Sepultamento de avô";
$factarray["_CREM_GPAR"] 		= "Cremação de avô";

$factarray["_DEAT_GGPA"] 		= "Morte de bisavô";
$factarray["_BURI_GGPA"] 		= "Sepultamento de bisavô";
$factarray["_CREM_GGPA"] 		= "Cremação de bisavô";

$factarray["_BIRT_FSIB"]		= "Nascimento de irmão/irmã do pai";
$factarray["_CHR_FSIB"] 		= "Batizado de irmão/irmã do pai";
$factarray["_BAPM_FSIB"] 		= "Batismo de irmão/irmã do pai";
$factarray["__BRTM_FSIB"] 		= "Brit Mila de irmão/irmã do pai";
$factarray["_ADOP_FSIB"] 		= "Adoção de irmão/irmã do pai";
$factarray["_MARR_FSIB"]		= "Casamento de irmão/irmã do pai";
$factarray["_MARB_FSIB"] 		= "Anuncio de casamento de irmão/irmã do pai";
$factarray["_DEAT_FSIB"]		= "Morte de irmão/irmã do pai";
$factarray["_BURI_FSIB"] 		= "Sepultamento de irmão/irmã do pai";
$factarray["_CREM_FSIB"] 		= "Cremação de irmão/irmã do pai";

$factarray["_BIRT_MSIB"]		= "Nascimento de irmão/irmã da mãe";
$factarray["_CHR_MSIB"] 		= "Batizado de irmão/irmã da mãe";
$factarray["_BAPM_MSIB"] 		= "Batismo de irmão/irmã da mãe";
$factarray["__BRTM_MSIB"] 		= "Brit Mila de irmão/irmã da mãe";
$factarray["_ADOP_MSIB"] 		= "Adoção de irmão/irmã da mãe";
$factarray["_MARR_MSIB"]		= "Casamento de irmão/irmã da mãe";
$factarray["_MARB_MSIB"] 		= "Anuncio de casamento de irmão/irmã da mãe";
$factarray["_DEAT_MSIB"]		= "Morte de irmão/irmã da mãe";
$factarray["_BURI_MSIB"] 		= "Sepultamento de irmão/irmã da mãe";
$factarray["_CREM_MSIB"] 		= "Cremação de irmão/irmã da mãe";

$factarray["_BIRT_COUS"]		= "Nascimento de primo";
$factarray["_CHR_COUS"]  		= "Batizado de primo";
$factarray["_BAPM_COUS"] 		= "Batismo de primo";
$factarray["__BRTM_COUS"]		= "Brit Mila de primo";
$factarray["_ADOP_COUS"] 		= "Adoção de primo";
$factarray["_MARR_COUS"]		= "Casamento de primo";
$factarray["_MARB_COUS"] 		= "Anuncio de casamento de primo";
$factarray["_DEAT_COUS"]		= "Morte de primo";
$factarray["_BURI_COUS"] 		= "Sepultamento de primo";
$factarray["_CREM_COUS"] 		= "Cremação de primo";

$factarray["_FAMC_EMIG"]		= "Emigração dos pais";
$factarray["_FAMC_RESI"]		= "Residência dos pais";

//-- PGV Only facts
$factarray["_THUM"]				= "Usar esta imagem como miniatura?";
$factarray["_PGVU"]				= "Ultima alteração por";
$factarray["SERV"]				= "Servidor remoto";
$factarray["_GEDF"]				= "Arquivo GEDCOM";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev = array();		// Don't let other languages specify Fact abbreviations for this language

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>
