<?php
/**
 * Turkish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Kurt Norgaz
 * @author Adem GENÇ uzayuydu@gmail.com http://www.muttafi.com
 * @version $Id: facts.tr.php 7354 2022-10-27 18:46:54Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their English values
$factarray["ABBR"]	= "Kısaltma";
$factarray["ADDR"]	= "Adres";
$factarray["ADR1"]	= "Adres 1";
$factarray["ADR2"]	= "Adres 2";
$factarray["ADOP"]	= "Evlât edinme";
$factarray["AFN"]	= "Atalara İlişkin Dosya Numarası (AFN)";
$factarray["AGE"]	= "Yaşı";
$factarray["AGNC"]	= "Ajans";
$factarray["ALIA"]	= "Rumuz";
$factarray["ANCE"]	= "Ecdat";
$factarray["ANCI"]	= "Ecdat Nema";
$factarray["ANUL"]	= "Feshi";
$factarray["ASSO"]	= "İştirak";
$factarray["AUTH"]	= "Yazan";
$factarray["BAPL"]	= "SZA Vaftiz";
$factarray["BAPM"]	= "Vaftiz";
$factarray["BARM"]	= "Bar Mitzvah";
$factarray["BASM"]	= "Bas Mitzvah";
$factarray["BIRT"]	= "Doğum";
$factarray["BLES"]	= "Nimet";
$factarray["BLOB"]	= "İkili Veri Öğesi";
$factarray["BURI"]	= "Defin";
$factarray["CALN"]	= "Telefon Numara";
$factarray["CAST"]	= "Sosyal Sınıf / Sosyal Durumlar";
$factarray["CAUS"]	= "Ölüm nedeni";
$factarray["CEME"]  = "Kabristan";
$factarray["CENS"]	= "Nüfus sayımı";
$factarray["CHAN"]	= "Son Değişiklik";
$factarray["CHAR"]	= "Karakter kümesi";
$factarray["CHIL"]	= "Çocuk";
$factarray["CHR"]	= "Vaftiz etme";
$factarray["CHRA"]	= "Yetişkin Vaftiz etme";
$factarray["CITY"]	= "Belde";
$factarray["CONF"]	= "Tasdik";
$factarray["CONL"]	= "SZA Tasdik";
$factarray["COPR"]	= "Telif hakkı";
$factarray["CORP"]	= "Şirket / Firma";
$factarray["CREM"]	= "Ölü yakma";
$factarray["CTRY"]	= "Ülke";
$factarray["DATA"]	= "Veri";
$factarray["DATE"]	= "Tarih";
$factarray["DEAT"]	= "Vefat";
$factarray["DESC"]	= "Zürriyet";
$factarray["DESI"]	= "Zürriyet Nema";
$factarray["DEST"]	= "Gidilecek yer";
$factarray["DIV"]	= "Boşanma";
$factarray["DIVF"]	= "Boşanma dosyalanmış";
$factarray["DSCR"]	= "Açıklaması";
$factarray["EDUC"]	= "Öğrenim";
$factarray["EMIG"]	= "Dışgöç";
$factarray["ENDL"]	= "SZA Bağışı";
$factarray["ENGA"]	= "Nişanlanma";
$factarray["EVEN"]	= "Hadise";
$factarray["FAM"]	= "Aile";
$factarray["FAMC"]	= "Bir Çocuk olarak Aile";
$factarray["FAMF"]	= "Aile Dosyası";
$factarray["FAMS"]	= "Bir Eş olarak Aile";
$factarray["FCOM"]	= "İlk Cemaati";
$factarray["FILE"]	= "Harici Dosya";
$factarray["FORM"]	= "Biçim";
$factarray["GIVN"]	= "Verilen Adı";
$factarray["GRAD"]	= "Mezuniyet";
$factarray["HUSB"]  = "Koca";
$factarray["IDNO"]	= "Kimlik Numara";
$factarray["IMMI"]	= "İçgöç";
$factarray["LEGA"]	= "Vasiyet edilen";
$factarray["MARB"]	= "Evllik İlanı";
$factarray["MARC"]	= "Evlilik Akdi";
$factarray["MARL"]	= "Evlilik Cüzdanı";
$factarray["MARR"]	= "Evlilik";
$factarray["MARS"]	= "Evlilik Yerleşimi";
$factarray["MEDI"]	= "Medya Tipi";
$factarray["NAME"]	= "Adı";
$factarray["NATI"]	= "Vatandaşlık";
$factarray["NATU"]	= "Vatandaşlık Tanınması";
$factarray["NCHI"]	= "Çocuk Sayısı";
$factarray["NICK"]	= "Lakabı";
$factarray["NMR"]	= "Evlilik Sayısı";
$factarray["NOTE"]	= "Not";
$factarray["NPFX"]	= "Önek";
$factarray["NSFX"]	= "Sonek";
$factarray["OBJE"]	= "Multimedya Öğesi";
$factarray["OCCU"]	= "Meslek";
$factarray["ORDI"]	= "Buyruğu";
$factarray["ORDN"]	= "Kutsanma";
$factarray["PAGE"]	= "Alıntı Detayları";
$factarray["PEDI"]	= "Soyağacı / Seçere";
$factarray["PLAC"]	= "Yer";
$factarray["PHON"]	= "Telefon";
$factarray["POST"]	= "Posta kodu";
$factarray["PROB"]	= "Vasiyetname Onayı";
$factarray["PROP"]	= "Mal-Mülk";
$factarray["PUBL"]	= "Dağıtma";
$factarray["QUAY"]	= "Verinin Kalitesi";
$factarray["REPO"]	= "Havuz";
$factarray["REFN"]	= "Referans Numarası";
$factarray["RELA"]	= "Akrabalık Bağı";
$factarray["RELI"]	= "Din";
$factarray["RESI"]	= "İkamet";
$factarray["RESN"]	= "Kısıtlama";
$factarray["RETI"]	= "Emeklilik";
$factarray["RFN"]	= "Dosya Kayıt Numara";
$factarray["RIN"]	= "Kayıt ID Numara";
$factarray["ROLE"]	= "Görevi";
$factarray["SEX"]	= "Cinsiyet";
$factarray["SLGC"]	= "SZA Çocuk Kapatma";
$factarray["SLGS"]	= "SZA Eş Kapatma";
$factarray["SOUR"]	= "Kaynak";
$factarray["SPFX"]	= "Soyadı Önek";
$factarray["SSN"]	= "Sosyal Güvenlik Numara";
$factarray["STAE"]	= "Semt";
$factarray["STAT"]	= "Durumlar";
$factarray["SUBM"]	= "Gönderen";
$factarray["SUBN"]	= "Teslim";
$factarray["SURN"]	= "Soyadı";
$factarray["TEMP"]	= "Tapınak";
$factarray["TEXT"]	= "Metin";
$factarray["TIME"]	= "Saat";
$factarray["TITL"]	= "Başlık";
$factarray["TYPE"]	= "Tipi";
$factarray["WIFE"]  = "Hanım";
$factarray["WILL"]	= "Vasiyetname";
$factarray["_EMAIL"]	= "Email Adresi";
$factarray["EMAIL"]	= "Email Adresi";
$factarray["_TODO"]	= "Yapılacak Öğe";
$factarray["_UID"]	= "Genel benzersiz tanımlayıcı";
$factarray["_PRIM"]	= "Vurgulanan Resim";
$factarray["_DBID"] = "Bağlı veritabanı ID";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Değiştirilme Tarih İstatistik";
$factarray["DATA:DATE"] = "Orijinal kaynak girişin tarihi";

$factarray["NAME:_HEB"]	= "İbranice Adı";
$factarray["PLAC:_HEB"]	= "İbranice Yer";
$factarray["TITL:_HEB"]	= "İbranice Başlık";
$factarray["NAME:ROMN"]	= "Latince Adı";
$factarray["PLAC:ROMN"]	= "Latince Yer";
$factarray["TITL:ROMN"]	= "Latince Başlık";
$factarray["NAME:FONE"]	= "Fonetik Adı";
$factarray["PLAC:FONE"]	= "Fonetik Yer";
$factarray["TITL:FONE"]	= "Fonetik Başlık";

$factarray["SHARED_NOTE"]	= "Paylaşılan Not";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"] = "Babanın Soyadı";
$factarray["FAMC:WIFE:SURN"] = "Annenin Soyadı";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Babanın Doğumyeri";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Annenin Doğumyeri";
$factarray["FAMC:MARR:PLAC"] = "Ebeveynin Evlilik Yeri";
$factarray["FAMC:HUSB:OCCU"] = "Babanın Mesleği";
$factarray[":BIRT:PLAC"] = "Doğumyeri";
$factarray["FAMS:MARR:PLAC"] = "Evlilik Yeri";
$factarray["FAMS:MARR:DATE"] = "Evlilik Tarihi";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Eşin Ölüm Yeri";
$factarray["FAMC:HUSB:GIVN"] = "Babanın Verilen Adı";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Eşin Doğum Yeri";
$factarray["FAMC:WIFE:GIVN"] = "Annenin Verilen Adı";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Babatarafı Büyükbabanın Verilen Adı";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Annetarafı Anneannenin Verilen Adı";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Annetarafi Dedenin Verilen Adı";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Babatarafı Babaannenin Verilen Adı";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Çocuğun Doğum Yeri";
$factarray["FAMS:NOTE"] = "Eş Notu";
$factarray["FAMS:CENS:DATE"] = "Eşin Sayım Tarihi";
$factarray["FAMS:CENS:PLAC"] = "Eşin Sayım Yeri";
$factarray["FAMS:DIV:DATE"] = "Eşin Boşanma Tarihi";
$factarray["FAMS:DIV:PLAC"] = "Eşin Boşanma Yeri";
$factarray["FAMS:SLGS:DATE"] = "SZA Eşin Kapatma Tarihi";
$factarray["FAMS:SLGS:PLAC"] = "SZA Eşin Kapatma Yeri";
$factarray["FAMS:SLGS:TEMP"] = "SZA Eşin Kapatma Tapınak";

// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Doğum Yeri";
$factarray["BIRT:DATE"] = "Doğum Tarihi";
$factarray["BIRT:SOUR"] = "Doğum Kaynağı";
$factarray["DEAT:PLAC"] = "Ölüm Yeri";
$factarray["DEAT:DATE"] = "Ölüm Tarihi";
$factarray["DEAT:SOUR"] = "Ölüm Kaynağı";
$factarray["CHR:PLAC"] = "Vaftiz Etme Yeri";
$factarray["CHR:DATE"] = "Vaftiz Etme Tarihi";
$factarray["CHR:SOUR"] = "Vaftiz Etme Kaynağı";
$factarray["CONF:PLAC"] = "Tasdik Yeri";
$factarray["CONF:DATE"] = "Tasdik Tarihi";
$factarray["CONF:SOUR"] = "Tasdik Kaynağı";
$factarray["BAPM:PLAC"] = "Vaftiz Yeri";
$factarray["BAPM:DATE"] = "Vaftiz Tarihi";
$factarray["BAPM:SOUR"] = "Vaftiz Kaynağı";
$factarray["_BRTM:PLAC"] = "Brit Mila Yeri";
$factarray["_BRTM:DATE"] = "Brit Mila Tarihi";
$factarray["_BRTM:SOUR"] = "Brit Mila Kaynak";
$factarray["BARM:PLAC"] = "Bar Mitzvah Yeri";
$factarray["BARM:DATE"] = "Bar Mitzvah Tarihi";
$factarray["BARM:SOUR"] = "Bar Mitzvah Kaynak";
$factarray["BASM:PLAC"] = "Bas Mitzvah Yeri";
$factarray["BASM:DATE"] = "Bas Mitzvah Tarihi";
$factarray["BASM:SOUR"] = "Bas Mitzvah Kaynak";
$factarray["BURI:PLAC"] = "Defin Yeri";
$factarray["BURI:DATE"] = "Defin Tarihi";
$factarray["BURI:SOUR"] = "Defin Kaynağı";
$factarray["FCOM:PLAC"] = "İlk Cemaati Yeri";
$factarray["FCOM:DATE"] = "İlk Cemaati Tarihi";
$factarray["FCOM:SOUR"] = "İlk Cemaati Kaynağı";
$factarray["MARB:PLAC"] = "Evlilik İlan Yeri";
$factarray["MARB:DATE"] = "Evlilik İlan Tarihi";
$factarray["MARB:SOUR"] = "Evlilik İlan Kaynağı";
$factarray["MARR:PLAC"] = "Evlilik Yeri";
$factarray["MARR:DATE"] = "Evlilik Tarihi";
$factarray["MARR:SOUR"] = "Evlilik Kaynağı";
$factarray["ENGA:PLAC"] = "Nişanlanma Yeri";
$factarray["ENGA:DATE"] = "Nişanlanma Tarihi";
$factarray["ENGA:SOUR"] = "Nişanlanma Kaynağı";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]	= "Sağlık";
$factarray["_DEG"]	= "Derece";
$factarray["_MILT"]	= "Askerlik Hizmeti";
$factarray["_SEPR"]	= "Ayrılmış";
$factarray["_DETS"]	= "Bir Eşinin Ölümü";
$factarray["CITN"]	= "Yurttaşlık";
$factarray["_FA1"]	= "Olgu 1";
$factarray["_FA2"]	= "Olgu 2";
$factarray["_FA3"]	= "Olgu 3";
$factarray["_FA4"]	= "Olgu 4";
$factarray["_FA5"]	= "Olgu 5";
$factarray["_FA6"]	= "Olgu 6";
$factarray["_FA7"]	= "Olgu 7";
$factarray["_FA8"]	= "Olgu 8";
$factarray["_FA9"]	= "Olgu 9";
$factarray["_FA10"]	= "Olgu 10";
$factarray["_FA11"]	= "Olgu 11";
$factarray["_FA12"]	= "Olgu 12";
$factarray["_FA13"]	= "Olgu 13";
$factarray["_MREL"]	= "Anneye Akrabalık Bağı";
$factarray["_FREL"]	= "Babaya Akrabalık Bağı";
$factarray["_MSTAT"]	= "Evlilik Başlangıç Durumu";
$factarray["_MEND"]	= "Evlilik Biten Durumlar";
$factarray["_NAMS"]	= "Adaş";

// GEDCOM 5.5.1 related facts
$factarray["FAX"] = "Faks";
$factarray["FACT"] = "Olgu";
$factarray["WWW"]	= "Web sitesi";
$factarray["MAP"] = "Harıta";
$factarray["LATI"] = "Enlem";
$factarray["LONG"] = "Boylam";
$factarray["FONE"]	= "Fonetik";
$factarray["ROMN"] = "Latince";

// PAF related facts
$factarray["_NAME"] = "Posta Adı";
$factarray["URL"] = "Web URL";
$factarray["_URL"] = "Web URL";
$factarray["_HEB"]	= "İbrani";
$factarray["_SCBK"] = "Kupür";
$factarray["_TYPE"] = "Medya Tipi";
$factarray["_SSHOW"] = "Slayt gösterisi";

// Rootsmagic
$factarray["_SUBQ"]= "Kısa Versiyon";
$factarray["_BIBL"]	= "Kaynakça";

// Reunion
$factarray["EMAL"]	= "Email Adresi";

// Other common customized facts
$factarray["_ADPF"]	= "Baba tarafından evlatlık";
$factarray["_ADPM"]	= "Anne tarafından evlatlık";
$factarray["_AKAN"]	= "Olarak da bilinir";
$factarray["_AKA"]	= "Olarak da bilinir";
$factarray["_BRTM"]	= "Brit Mila";
$factarray["_COML"]	= "Resmi Nikahsız Evlilik";
$factarray["_EYEC"]	= "Göz rengi";
$factarray["_FNRL"]	= "Cenaze";
$factarray["_HAIR"]	= "Saç Rengi";
$factarray["_HEIG"]	= "Boy";
$factarray["_HOL"]  = "Soykırım";
$factarray["_INTE"]	= "Alelacele Gömülmüş";
$factarray["_MARI"]	= "Evlilik Niyeti";
$factarray["_MBON"]	= "Resmi Evlilik";
$factarray["_MEDC"]	= "Sağlık Durumu";
$factarray["_MILI"]	= "Askerlik";
$factarray["_NMR"]	= "Evli değil";
$factarray["_NLIV"]	= "Yaşamıyor";
$factarray["_NMAR"]	= "Hiç evlenmemiş";
$factarray["_PRMN"]	= "Kalıcı Numara";
$factarray["_WEIG"]	= "Ağırlık";
$factarray["_YART"]	= "Yahrzeit";
$factarray["_MARNM"]	= "Evlilik Adı";
$factarray["_MARNM_SURN"] = "Evlilik Soyadı";
$factarray["_STAT"]	= "Evlilik Durumu";
$factarray["COMM"]	= "Açıklama";

// Aldfaer related facts
$factarray["MARR_CIVIL"] = "Medeni Nikâh";
$factarray["MARR_RELIGIOUS"] = "Dini Nikâh";
$factarray["MARR_PARTNERS"] = "Kayıtlı Birliktelik";
$factarray["MARR_UNKNOWN"] = "Evlilik Tipi bilinmiyor";

$factarray["_HNM"] = "İbrani Adı";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Eşinin ölümü";
$factarray["_BURI_SPOU"] = "Eşinin defni";
$factarray["_CREM_SPOU"] = "Eşinin ölü yakma";

$factarray["_BIRT_CHIL"] = "Çocuğunun doğumu";
$factarray["_CHR_CHIL"] = "Bir çocuğunu vaftiz etme";
$factarray["_BAPM_CHIL"] = "Bir çocuğunun vaftizi";
$factarray["__BRTM_CHIL"] = "Bir çocuğunun Brit Mila";
$factarray["_ADOP_CHIL"] = "Bir çocuğunu evlat edinme";
$factarray["_MARR_CHIL"] = "Çocuğunun evliliği";
$factarray["_MARB_CHIL"] = "Bir çocuğunun evilik ilani";
$factarray["_DEAT_CHIL"] = "Bir çocuğunun ölümü";
$factarray["_BURI_CHIL"] = "Bir çocuğunun defni";
$factarray["_CREM_CHIL"] = "Bir çocuğunun ölü yakılması";

$factarray["_BIRT_GCHI"] = "Bir torununun doğumu";
$factarray["_CHR_GCHI"] = "Bir torununu vaftiz etme";
$factarray["_BAPM_GCHI"] = "Bir torununun vaftizi";
$factarray["__BRTM_GCHI"] = "Bir torununun Brit Mila";
$factarray["_ADOP_GCHI"] = "Bir torununun evlat edinme";
$factarray["_MARR_GCHI"] = "Bir torununun evliliği";
$factarray["_MARB_GCHI"] = "Bir torununun evlilik ilanı";
$factarray["_DEAT_GCHI"] = "Bir torununun ölümü";
$factarray["_BURI_GCHI"] = "Bir torununun defni";
$factarray["_CREM_GCHI"] = "Bir torununun ölü yakılması";

$factarray["_BIRT_GGCH"] = "Bir büyük-torununun doğumu";
$factarray["_CHR_GGCH"] = "Bir büyük torununun vaftiz etme";
$factarray["_BAPM_GGCH"] = "Bir büyük-torununun vaftizi";
$factarray["__BRTM_GGCH"] = "Bir büyük torununun Brit Mila";
$factarray["_ADOP_GGCH"] = "Bir büyük-torununun evlat edinme";
$factarray["_MARR_GGCH"] = "Bir büyük-torununun evliliği";
$factarray["_MARB_GGCH"] = "Bir büyük torunun evlilik ilanı";
$factarray["_DEAT_GGCH"] = "Bir büyük-torununun ölümü";
$factarray["_BURI_GGCH"] = "Bir büyük-torununun defni";
$factarray["_CREM_GGCH"] = "Bir büyük-torununun ölü yakılması";

$factarray["_MARR_FATH"] = "Babanın evliliği";
$factarray["_MARB_FATH"] = "Babanın evlilik ilanı";
$factarray["_DEAT_FATH"] = "Babanın ölümü";
$factarray["_BURI_FATH"] = "Babanın defni";
$factarray["_CREM_FATH"] = "Babanın ölü yakılması";

$factarray["_MARR_FAMC"] = "Ebeveyninin evliliği";
$factarray["_MARB_FAMC"] = "Ebeveyninin evliliğin ilanı";

$factarray["_MARR_MOTH"] = "Annenin evliliği";
$factarray["_MARB_MOTH"] = "Annenin evlilik ilanı";
$factarray["_DEAT_MOTH"] = "Annenin ölümü";
$factarray["_BURI_MOTH"] = "Annenin defni";
$factarray["_CREM_MOTH"] = "Annenin ölü yakılması";

$factarray["_BIRT_SIBL"] = "Kardeşin doğumu";
$factarray["_CHR_SIBL"] = "Kardeşin vaftiz etme";
$factarray["_BAPM_SIBL"] = "Kardeşin vaftizi";
$factarray["__BRTM_SIBL"] = "Kardeşin Brit Mila";
$factarray["_ADOP_SIBL"] = "Kardeşin evlat edinme";
$factarray["_MARR_SIBL"] = "Kardeşin evliliği";
$factarray["_MARB_SIBL"] = "Kardeşin evlilik ilanı";
$factarray["_DEAT_SIBL"] = "Kardeşin ölümü";
$factarray["_BURI_SIBL"] = "Kardeşin defni";
$factarray["_CREM_SIBL"] = "Kardeşin ölü yakılması";

$factarray["_BIRT_HSIB"] = "Üvey kardeşin doğumu";
$factarray["_CHR_HSIB"] = "Üvey kardeşin vaftiz etme";
$factarray["_BAPM_HSIB"] = "Üvey-kardeşin vaftizi";
$factarray["__BRTM_HSIB"] = "Üvey kardeşin Brit Mila";
$factarray["_ADOP_HSIB"] = "Üvey-kardeşin evlat edinme";
$factarray["_MARR_HSIB"] = "Üvey kardeşin evliliği";
$factarray["_MARB_HSIB"] = "Üvey kardeşin evlilik ilanı";
$factarray["_DEAT_HSIB"] = "Üvey kardeşin ölümü";
$factarray["_BURI_HSIB"] = "Üvey-kardeşin defni";
$factarray["_CREM_HSIB"] = "Üvey-kardeşin ölü yakılması";

$factarray["_BIRT_NEPH"] = "Bir kız veya erkek yeğenin doğumu";
$factarray["_CHR_NEPH"] = "Bir kız veya erkek yeğenin vaftiz etme";
$factarray["_BAPM_NEPH"] = "Bir kız veya erkek yeğenin vaftizi";
$factarray["__BRTM_NEPH"] = "Bir erkek yeğenin Brit Mila";
$factarray["_ADOP_NEPH"] = "Bir kız veya erkek yeğenin evlat edinme";
$factarray["_MARR_NEPH"] = "Bir kız veya erkek yeğenin evliliği";
$factarray["_MARB_NEPH"] = "Bir kız veya erkek yeğenin evlilk ilanı";
$factarray["_DEAT_NEPH"] = "Bir kız veya erkek yeğenin ölümü";
$factarray["_BURI_NEPH"] = "Bir kız veya erkek yeğenin defni";
$factarray["_CREM_NEPH"] = "Bir kız veya erkek yeğenin ölü yakılması";

$factarray["_DEAT_GPAR"] = "Bir büyük ebeveynin ölümü";
$factarray["_BURI_GPAR"] = "Bir büyük ebeveynin defni";
$factarray["_CREM_GPAR"] = "Bir büyük ebeveynin ölü yakılması";

$factarray["_DEAT_GGPA"] = "Bir büyük büyük ebeveynin ölümü";
$factarray["_BURI_GGPA"] = "Bir büyük büyük ebeveynin defni";
$factarray["_CREM_GGPA"] = "Bir büyük büyük ebeveynin ölü yakılması";

$factarray["_BIRT_FSIB"] = "Babanın kardeşinin doğumu";
$factarray["_CHR_FSIB"] = "Babanın kardeşinin vaftiz etme";
$factarray["_BAPM_FSIB"] = "Babanın kardeşinin vaftizi";
$factarray["__BRTM_FSIB"] = "Babanın kardeşinin Brit Mila";
$factarray["_ADOP_FSIB"] = "Babanın kardeşinin evlat edilme";
$factarray["_MARR_FSIB"] = "Babanın kardeşinin evliliği";
$factarray["_MARB_FSIB"] = "Babanın kardeşinin evlilik ilanı";
$factarray["_DEAT_FSIB"] = "Babanın kardeşinin ölümü";
$factarray["_BURI_FSIB"] = "Babanın kardeşinin defni";
$factarray["_CREM_FSIB"] = "Babanın kardeşinin ölü yakılması";

$factarray["_BIRT_MSIB"] = "Annenin kardeşinin doğumu";
$factarray["_CHR_MSIB"] = "Annenin kardeşinin vaftiz etme";
$factarray["_BAPM_MSIB"] = "Annenin kardeşinin vaftizi";
$factarray["__BRTM_MSIB"] = "Annenin kardeşinin Brit Mila";
$factarray["_ADOP_MSIB"] = "Annenin kardeşinin evlat edinme";
$factarray["_MARR_MSIB"] = "Annenin kardeşinin evliliği";
$factarray["_MARB_MSIB"] = "Annenin kardeşinin evlilik ilanı";
$factarray["_DEAT_MSIB"] = "Annenin kardeşinin ölümü";
$factarray["_BURI_MSIB"] = "Annenin kardeşinin defni";
$factarray["_CREM_MSIB"] = "Annenin kardeşinin ölü yakılması";

$factarray["_BIRT_COUS"] = "Bir ilk kuzeninin doğumu";
$factarray["_CHR_COUS"]  = "Bir ilk kuzeninin vaftiz edilme";
$factarray["_BAPM_COUS"] = "Bir ilk kuzeninin vaftizi";
$factarray["__BRTM_COUS"] = "Bir ilk kuzeninin Brit Mla";
$factarray["_ADOP_COUS"] = "Bir ilk kuzeninin evlat edilmesi";
$factarray["_MARR_COUS"] = "Bir ilk kuzeninin evliliği";
$factarray["_MARB_COUS"] = "Bir ilk kuzeninin evlilik ilanı";
$factarray["_DEAT_COUS"] = "Bir ilk kuzeninin ölümü";
$factarray["_BURI_COUS"] = "Bir ilk kuzeninin defni";
$factarray["_CREM_COUS"] = "Bir ilk kuzeninin ölü yakılması";

$factarray["_FAMC_EMIG"] = "Ebeveynin dışgöçü";
$factarray["_FAMC_RESI"] = "Ebeveynin ikameti";

//-- PGV Only facts
$factarray["_THUM"]	= "Daima ana resmi kullan?";
$factarray["_PGVU"]	= "Değiştiren";
$factarray["SERV"] = "Uzak Sunucu";
$factarray["_GEDF"] = "GEDCOM Dosya";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev = array();		// Don't let other languages specify Fact abbreviations for this language

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>
