<?php
/**
 * Chinese (Traditional) texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2019 PGV Development Team.  All rights reserved.
 *
 * This program is free software;you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation;either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: faqlist.zh.php 7223 2019-01-31 11:23:54Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$faqlist["FAQ_000_head"] = "\"常見問題解答\"：我聽說過這個，但是它是什麼？";
$faqlist["FAQ_000_body"] = "<b>常見問題</b>是<b>F</b>的首字母縮寫<b>A</b>sked <b>Q</b>uestion。<br /><br />常見問題列表是經常出現的問題列表（及其答案）。它由PhpGedView團隊編制，並經常更新。";

$faqlist["FAQ_010_head"] = "歡迎來到#GLOBALS[GEDCOM_TITLE]#FAQ";
$faqlist["FAQ_010_body"] = "#GLOBALS家庭成員[GEDCOM_TITLE]#想藉此機會歡迎我們家譜中的所有'表兄弟'，並鼓勵他們抓住研究他們祖先的錯誤。這很容易成為愛的勞動- 而且討厭- 因為它消耗了過多的時間，但獎勵非常好。我們為您提供了通過使用<a href=\"#PGV_PHPGEDVIEW_URL#\" target=\"_blank\">#PGV_PHPGEDVIEW#</a>，由John Finlay及其PGV團隊的才華編程技巧創建- 一個精彩的開源家譜計劃。來享受家譜的機會。";

$faqlist["FAQ_015_head"] = "這個PhpGedView樹與其他文字和動態樹之間有什麼區別？";
$faqlist["FAQ_015_body"] = "文本和動態樹以不同的方式顯示樹，但是沒有一個可以由您配置，更改或更新。只有網站管理員才能執行更新。<br /><br />PhpGedView是一個交互式樹。家人在這個擴展樹中的任何人都可以更新，添加和更改他們的近分支。（您必須先註冊才能進行這些更改。）";

$faqlist["FAQ_017_head"] = "這棵樹的主要特色是什麼？";
$faqlist["FAQ_017_body"] = "使用PhpGedView，您可以：<ul><li>保持生活隱私;網站管理員確定您可以看到誰。</li><li>享受查看樹的許多可能性：作為不同的圖表，報告或列表。 </li><li>這是一個協作樹;經過網站管理員的許可，每個人都可以參與更新樹。</li></ul>";

$faqlist["FAQ_020_head"] = "我需要一個訪問帳戶嗎？如果是，我如何申請一個？";
$faqlist["FAQ_020_body"] = "我們應該說\"歡迎，堂兄\"？<br /><br /><b>注意：#GLOBALS[GEDCOM_TITLE]#不要求註冊以獲取對已故親屬的數據的訪問權限。但是，貢獻或者看到推定的親屬的事實，你需要註冊並告訴我們你們的關係。</b>";
$faqlist["FAQ_020_body2"] = "註冊用戶可以看到所有網站所有人的姓名。他們會看到已故個人及其近親的詳細數據。<br /><br />與任何親屬沒有聯繫的用戶只能看到活著的個人姓名和詳細信息。已故個人的數據。";
$faqlist["FAQ_020_body3"] = "<ol><li>在許多情況下，註冊人應該是親戚，遠程親屬，或者與已經列出的某人有關，或者應該在我們的網站上列出的人;</li><li>註冊人應淮備訪問並定期為我們的網站做出貢獻，首先向我們提供他們的個人和直接家庭信息，以及稍後- 對我們現有數據的修改，擴充，擴充和補充;</li><li>註冊人必須承諾保護數據的隱私對於網站上的所有活人，以及如上所述，他們提供自己的個人信息。違規將導致立即終止訪問權限，並可能導致法律訴訟。我們認真對待身份盜竊或信息濫用的可能性。請有關詳細信息，請參閱下面的\"隱私權\"部分。</li></ol>如果您有資格註冊並同意遵守這些簡單的政策和程序，請隨時使用<b><a target=\"_ blank\"href =\"/phpGedView/login_register.php?action=register\">註冊表單</a></b>內置於網站中。請務必填寫小問卷，在那裡您解釋與現有網站中包含的親屬的關係，並明確說明您是否有意遵守我們的政策和訪問規則。我們將審核並考慮您的申請。";
$faqlist["FAQ_020_body4"] = "批淮新用戶帳戶必須由網站管理員手動完成。通常需要幾分鐘到24小時。";

$faqlist["FAQ_022_head"] = "我為什麼需要註冊？";
$faqlist["FAQ_022_body"] = "只有註冊用戶才能看到活著的人的名字。當你沒有註冊時，你只​​會看到\"私人\"，而不是活人的名字。";

$faqlist["FAQ_025_head"] = "如何批淮我的註冊批淮？";
$faqlist["FAQ_025_body"] = "批淮新用戶帳戶必須由網站管理員手動完成。通常需要幾分鐘到24小時。";

$faqlist["FAQ_027_head"] = "我已註冊並已獲得批淮。我可以看到生活中的人，但我看不到他們的任何細節。";
$faqlist["FAQ_027_body"] = "為了查看詳細信息（僅限您所在的分支機構），您必須是樹的一部分，並且必須通過電子郵件通知網站站長/Genmaster。";

$faqlist["FAQ_030_head"] = "我如何輸入數據？我應該使用哪種格式？";
$faqlist["FAQ_030_body"] = "這裡有幾點指示";
$faqlist["FAQ_030_body2"] = "對於被批淮在線編輯的用戶。";
$faqlist["FAQ_030_body3"] = "您也可以通過電子郵件發送更新。";
$faqlist["FAQ_030_HELP"] = "<strong>幫助</strong>：網站，每個頁面標題以及大多數鏈接和條款背後的其他地方都提供了幫助\"?\"圖片。如果您仍然感到困惑，只需通過電子郵件詢問我們。 ";
$faqlist["FAQ_030_DATES"] = "<strong>日期</strong>：我們使用GEDCOM v5.5標淮格式.DD MMM YYYY或1822年1月18日，而不是1822年1月1日或1822年1月1日。系統可以對輸入錯誤進行一些小的修正，但你不應該依賴於此。";
$faqlist["FAQ_030_HDATES"] = "<strong>HEBREW DATES</strong>以@#DHEBREW@ DD MMM YYYY或@#DHEBREW@ 21 AAV 5705的格式填寫- 這些月份填寫為TSH，CSH，KSL，TVT， SHV，ADR，ADS，根據GEDCOM v5.5標淮，NSN，IYR，SVN，TMZ，AAV和ELL。";
$faqlist["FAQ_030_PLACES"] = "<strong>地點</strong>：我們嘗試，無論何處知道，包括完整的地方描述：城市和/或鄉鎮（Twp）以及縣，州，我們通常添加美國（首選- 不是美國，國家背後的美國或美國。對於外國，我們使用GEDCOM批淮的3個字母標淮縮寫而不是國名：英格蘭[ENG]，蘇格蘭[SCT]，愛爾蘭[IRE]，法國[FRA]我們喜歡的格式是：<i>Indianapolis, Center Twp, Marion Co, Indiana, USA</i>各州不應縮寫為兩個字母;我們通常不使用句號（.）在名稱或位置，如<i>Shelbyville, Addison Twp, Shelby Co, Indiana, USA</i>而不是<i>Shelbyville, Addison Twp., Shelby Co., IN</i>或<i><i>Shelbyville, Addison Township, Shelby County, Indiana, U.S.A.</i>";
$faqlist["FAQ_030_PLACES2"] = "<strong>地點</strong>：我們嘗試，無論在哪裡知道，為美國地方包括完整的地方描述：城市或鄉鎮（Twp）以及兩個字母州，我們添加美國（首選- 不是美國，國家背後的美國或美國。對於其他國家，我們使用城市和/或鄉鎮和國家名稱。我們喜歡的格式是：<i>Indianapolis, IN, USA</i>和<i>Vilnius, Lithuania</i>。";
$faqlist["FAQ_030_PLACES3"] = "獲取地點正確格式有兩種有用的方法：<br /><ul><li>使用Place字段旁邊的小\"世界\"圖標查看我們的數據庫中已輸入的地點。這是查看某個城市縣的好方法，如果您不知道它可能已經存在於我們的數據中。使用過濾器縮小搜索範圍，只需單擊所需的結果，然後將其複製到空的Place字段，</li><li>點擊Place字段下面的+號。你會看到國家，州/省，縣，城市的另一系列字段。國家/地區字段旁邊是一個國家/地區的下拉列表標淮的3字母標識。</li></ul>";
$faqlist["FAQ_030_PLACES4"] = "獲取地點正確格式有兩種有用的方法：<br /><ul><li>使用地點字段旁邊的小\"世界\"圖標查看我們的數據庫中已輸入的地點。這是如果你不知道它可能已經存在於我們的數據中，那麼查找城市狀態的好方法。使用過濾器縮小搜索範圍，只需單擊所需的結果，然後將其複製到空的Place字段，</li><li>點擊Place字段下方的+號。您將看到國家，州/省，縣（N/A），城市的其他系列字段。國家/地區字段旁邊是下拉列表我們不使用標淮三字母標識的國家/地區列表。</li></ul>";
$faqlist["FAQ_030_PLACES5"] = "\"Place\"數據下的字段\"希伯來語\"旨在讓您輸入希伯來語的地名以及拉丁字母中的名稱。 ";
$faqlist["FAQ_030_NAMES"] = "<strong>NAMES</strong>：通過表單輸入名稱非常簡單，並提供幫助.INDI ENTRY BOX應該已經擴展了名稱字段。如果沒有，通過單擊它可以擴展它和地點框。相應的+符號。";
$faqlist["FAQ_030_PREFIX"] = "姓名<u>PREFIXes</u>通常是諸如Dr，Rabbi，Hon，Judge等名稱或敬意。不應輸入普通的敬意，如Mr，Mrs，Ms，Mstr。" ;
$faqlist["FAQ_030_GIVN"] = "<u>GIVN</u> - 名字是出生時通常選擇的第一個和中間名。";
$faqlist["FAQ_030_GIVN1"] = "當出生後名稱發生變化時，這些附加名稱可以在人員被記錄到數據庫後單獨輸入。也可以輸入為AKA（也稱為）名稱。<br /><br / >我們通常期望人們可以通過他們給出的第一個名字來調用。如果不是這樣的話，你應該通過在它後面放一個星號來指明哪個給定的名字是首選名稱。例如，<i>John James Mitchell* Jones</i>表示此人被稱為\"Mitchell\"。在這種情況下，\"Mitchell\"不是暱稱，儘管\"Mitch\"可能是。";
$faqlist["FAQ_030_GIVN2"] = "我們用一個大寫字母輸入給定的名字。名稱的其餘部分用小寫字母輸入";
$faqlist["FAQ_030_SURNAME"] = "<u>SURNAME</u>是姓氏或姓氏。這是已婚人士的<u>出生名稱</u>，而不是結婚後的姓氏。見<i>已婚姓名</i如果在出生後發生名稱更改，這些附加名稱可以在人員被記錄到數據庫後單獨輸入。也可以輸入為AKA（也稱為）名稱。";
$faqlist["FAQ_030_SURNAME2"] = "我們用一個大寫字母輸入SURNAME。其餘的名字用小寫字母輸入";
$faqlist["FAQ_030_SUFFIX"] = "姓名<u>SUFFIXes</u>是Jr，Sr，III等";
$faqlist["FAQ_030_NICKNAME"] = "<u>NICKNAME</u>是該人通常使用的名稱，如果與他們的名字不同;例如<i>傑克</i>將是約翰\"傑克\"阿諾德，丹尼爾威爾遜艾弗里的暱稱綽號<i>Tuggy</i>，許多瑪格麗特都有綽號<i>Maggie，Nancy，Peggy，Polly</i>等等";
$faqlist["FAQ_030_HEBNAME"] = "<u>HEBREW NAME</u>是拉丁字母中人名的希伯來語翻譯。沒有人可以擁有多個希伯來名字.PhpGedView希望你用斜線括起姓氏。名稱&#1497;&#1506;&#1511;&#1489; &#1500;&#1493;&#1497;將輸入&#1497;&#1506;&#1511;&#1489;/&#1500;&#1493;&#1497;/。";
$faqlist["FAQ_030_AKANAME"] = "<u>AKA NAME</u>是這個人所知的另一個名字。它可能是生命後期改名的人的出生名，也可能是別名，階段或筆名。也可能是這是在這裡輸入的給定名稱可能與主名稱的名稱不同.PhpGedView希望你用斜線括起姓氏。名稱<i>James Adams</i>將輸入為<i>詹姆斯/亞當斯/</i>。";
$faqlist["FAQ_030_AKANAME2"] = "其他希伯來名字或意第緒語名稱也作為AKA名稱填寫。";
$faqlist["FAQ_030_MARRNAME"] = "<u>MARRIED NAMES</u>是假設配偶姓氏時該人的新名字。當您在\"已婚姓名\"字段中輸入新姓時，該程序會自動創建。即<i>Mary Jane Smith</i>当她结婚<i>John Jones</i>並成為<i>Mary Jane Jones</i>當你在已婚姓氏字段中輸入<i>Jones</i>。已婚姓名不是針對性別的;你是可為任何性別的人輸入已婚姓名。";
$faqlist["FAQ_030_MARRNAME2"] = "希伯來語MARRIED名字取自希伯來名字給定名字的名字。";
$faqlist["FAQ_030_NAMES2"] = "<i>編輯名稱</i>選項，位於\"個人詳細信息\"頁面上人名下方，可以編輯個人姓名的任何方面。還可以找到<i>刪除姓名</i>選項在人名下方，您可以從數據庫中的人員信息中刪除姓名，而無需刪除或更改任何其他內容。您可以通過單擊<i>編輯名稱</i>編輯數據庫中的人員信息並添加更多名稱。或<i>添加新名稱</i>選項在<i>個人選項</i>菜單的<i>編輯</i>子菜單中。單擊與關聯的幫助圖標可獲得更多信息有了這些選擇。";
$faqlist["FAQ_030_SOURC"] = "<strong>SOURCES</strong>和<strong>CITATIONS</strong>：在家譜中，僅僅說出\"發生在這樣一個日期上的事情\"是不夠的。歷史學家喜歡證明。我們也這樣做！請提供您所提供信息來源的任何信息。查看可用的各種採購標記，如有疑問則使用NOTES選項，或者您需要寫入空間。加入的內容超出您的想像可能是必要的，它不會太多。有問題嗎？只要問你是否理解，我們會很樂意提供幫助。";
$faqlist["FAQ_030_CHNG"] = "<strong>更改</strong>和<strong>參賽作品</strong>：對於某個人或家庭的現有數據的更改，只有在獲得Genmaster批淮後才會顯示。雖然我們經常查看該網站，但請發送給我們如果您希望我們更快地審核和批淮添加或修改，請發送電子郵件。有關創建或修改家庭單元的事實，請在\"近親/家庭聯繫\"頁面上輸入。這是您記錄婚姻，離婚，子女，家庭普查的地方- 任何影響家庭單位的事實或事件。我們發現在添加幾個孩子時，最好為該丈夫/妻子調出VIEW FAMILY鏈接，並通過底部的鏈接添加每個孩子，'添加一個孩子到這個家庭'。它比使用Close Relative頁面更快，因為每次添加它都會默認返回View INDI頁面而不是Close Relative頁面。有問題嗎？只要問你是否理解。更正，建議和幫助都很容易並且免費提供。";
$faqlist["FAQ_030_MEDIA"] = "<strong>媒體</strong>：我們非常感謝您添加圖片，出生證明，婚姻許可證和證書，去世證書- 您獲得支持的任何內容。通過使用您自己的硬盤驅動器添加這些內容很容易。 MEDIA選項卡，ADD MEDIA鏈接和UPLOAD /browse功能。再次，如果您有任何問題，建議或希望得到幫助，請通過電子郵件將您的數字圖像發送給我們，我們也可以添加它們。";
$faqlist["FAQ_030_MEDIA2"] = "在輸入新媒體時，請考慮一種不太可能與現有媒體衝突的命名約定。系統允許您瀏覽硬盤並以完全不同的名稱上傳文檔，保留本地文件名完整。想像一下有多少\"john.jpg\"文件可能（只有一個）但你可能會覆蓋現有文件，如果你不改變文件名。我們喜歡保持簡短（少於35個字符）但描述性- 像J_Name-b1820-I23445.jpg或K_Name-I23444-Headstn.jpg。如果有疑問，請問我們。";
$faqlist["FAQ_030_NAVIGATE"] = "<strong>NAVIGATION</strong>：我們使用CIRCLE DIAGRAM函數和祖先和下降圖表進行導航。嘗試使用它們。請記住，在您創建個人INDI事實頁面之前，許多功能都不起作用，這些頁面與您的祖先相關聯。" ;

$faqlist["FAQ_032_head"] = "我可以添加/編輯/更新樹上任何個人的數據嗎？";
$faqlist["FAQ_032_body"] = "是的。<br />您必須是樹的一部分，並允許在線編輯。您只能進行更改或添加自己的和關閉的分支機構。您也可以通過電子郵件提交更新。";

$faqlist["FAQ_037_head"] = "我經歷了編輯樹的故障。我該怎麼辦？";
$faqlist["FAQ_037_body"] = "您可以將您的更新/更改/添加內容通過電子郵件發送給網站管理員<br />郵件：#GLOBALS[WEBMASTER_EMAIL]#";
$faqlist["FAQ_037_body2"] = "您可以通過電子郵件將您的更新/更改/添加內容髮送給Genmaster<br />郵件：#GLOBALS[CONTACT_EMAIL]#";

$faqlist["FAQ_040_head"] = "關於隱私的內容是什麼？";
$faqlist["FAQ_040_body"] = "<b>#GLOBALS[GEDCOM_TITLE]#認為保護個人信息非常重要</b>.PhpGedView的軟件隱私功能在執行一些隱私規則方面非常出色- 主要是我們的網站隱藏了有關活著的人或者向誰的人的詳細信息你沒有關聯。查看生活人員的詳細信息將要求你使用用戶名和密碼登錄網站。這與你在家譜中的位置相關聯。我們的網站也使用PhpGedView中的\"關係隱私\"。此功能允許您僅查看定義為近親的個人信息。如果您已登錄並查看標記為\"私人\"的某些個人或家庭，則此網站功能已激活。如果您認為您的查看訪問權限是太有限了，請發送電子郵件給網站管理員並解釋，詳細說明您被阻止的身份證號碼以及您認為應該看到這些信息的原因。";
$faqlist["FAQ_040_body2"] = "當然，沒有任何系統是完美的或不可破解的，因此無意中訪問數據的可能性仍然存在。我們會竭盡所能及時糾正隱私問題。如果您對此處存儲的某些個人詳細信息感到強烈，請通過下面的表單- 電子郵件鏈接聯繫網站管理員或Genmaster。您的詳細信息可以從網站上刪除，但您的訪問權限也可能受到限制。另請參閱網站上有哪些信息的常見問題解答。<br /><br /><b>我們嚴肅對待信息濫用，盜竊或濫用行為，我們將起訴與我們網站數據相關的參與或企圖身份盜用的人。請勿將我們的生活親屬數據複製到其他網站或地點，因為它們可能是無法保護其隱私，您可能需要承擔責任。</b>";

$faqlist["FAQ_050_head"] = "謝謝";
$faqlist["FAQ_050_body"] = "如果沒有這麼多親戚的支持和參與，就不可能獲得和維護這一系列的信息。家譜是非常有趣和豐富的學習經歷，拓寬了我們對家庭和地理和社會學的一般事實的認識。我們希望你會像我們一樣享受它，我們期待通過PhpGedView和我們的#GLOBALS[GEDCOM_TITLE]#網站的功能建立我們的相互合作和友誼。<br /><br />不要猶豫發送我們發電子郵件向你打招呼，告訴我們需要更正或補充，或詢問關係。我們所知道的大部分內容都是在線顯示的，只有生活親屬的細節沒有顯示。<br /><br />再次感謝";

?>
