<?php
/**
 * Catalan language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Antoni Planas i Vilà
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.ca.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />El text introduït aquí es mostrarà quan el punter del ratolí es posi sobre la icona de text de la llista d'usuaris. Heu d’intentar que aquest text sigui el més breu possible.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Introduïu la data després de la qual el registre d'aquest usuari hauria de ser considerat com a requeriment de la inspecció per part de l'administrador. Aquests registres es ressalten a la llista d'usuaris mostrant el nom d'usuari en <span class='warning'>vermell</span>.<br /><br />La data s'ha d'introduir en anglès. Exemples: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> etc.<br /><br />Quan el número del mes i el número del dia es troben entre 1 i 12, la puntuació (guió o barra) determina el significat, amb un guió <b>-</b> que significa que el primer número és el dia del mes, mentre que una barra inclinada <b>/</b> significa que el primer número és el mes.<br /><br />Si la informació introduïda aquí no té sentit per al programa, s'utilitzarà «yesterday» i aquest usuari el registre sempre es seleccionarà per ressaltar. «tomorrow» i textos similars no són significatius en aquest context i donaran lloc a que aquest registre d'usuari mai no sigui seleccionat per ressaltar.";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Escolliu el format en el que es farà l'exportació de la base de dades. L'elecció depèn dels requeriments i característiques del programa on vulgueu importar el fitxer. Podeu escollir entre:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Quan hom marca aquesta opció, el fitxer de sortida passarà pels filtres de privadesa d'acord amb l'opció seleccionada. Això pot fer que es retingui certa informació. El fitxer de sortida contindrà solament informació normalment visible a l'usuari segons el seu nivell d'atribucions.<br /><br />Si solament teniu drets de #pgv_lang[gedadmin]#, no podreu demanar que el fitxer de sortida estigui privatitzat d'acord amb les atribuicions de #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Aquesta opció defineix una ruta constant que s'avantposarà com a prefix a totes les rutes d'objectes multimèdia a l'arxiu de sortida.<br /><br />Per exemple: si el directori multimèdia s'ha configurat com a \"/media\" i si l'arxiu multimèdia a exportar te la ruta \"/media/fotos/xyz.jpg\" i en aquest camp hi heu posat \"c:\\les meves fotos\\la meva familia\", la ruta resultant a l'arxiu serà \"c:\\les meves fotos\\la meva familia/fotos/xyz.jpg\".<br /><br />Per aquest exemple veureu que:<ul><li>el nom del directori multimèdia actual s'eliminarà de la ruta</li><li>la ruta resultant no tindrà els separadors de nom de carpeta correctes.</li></ul><br />Si voleu conservar el directori multimèdia a les rutes de l'arxiu de sortida, heu d'incloure aquest nom al camp <b>#pgv_lang[convertPath]#</b>.<br /><br />També us convé emprar l'opció  <b>#pgv_lang[convertSlashes]#</b> per a garantir que els separadors de noms de carpeta son adequats als requeriments del sistema operatiu de destí.<br /><br />Les rutes multimèdia que siguin URLs no es modificacran.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Aquesta opció determina si els noms de les carpetes a l'especificacio FILE dels objectes multimèdia ha d'anar separat per barres normals o barres invertides. Heu d'escollir en funció dels requeriments del sistema operatiu destinatari.<br /><br />L'opció <b>#pgv_lang[forwardSlashes]#</b> és apropiada per a la majoria de sistemes operatius, excepte per a Microsoft Windows.  L'opció <b>#pgv_lang[backSlashes]#</b> cal si el programa de destí s'executa  en un entorn Microsoft Windows.<br /><br />Les rutes multimèdia que siguin URLs no es modificaran.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />Quan hom activa aquesta opció, el #pgv_lang[multi_title]# buscarà no solament al directori seleccionat des de la llista #pgv_lang[filter]# sinó també a tots els seus sotsdirectoris. Quan l'opció no és activa, solament es recerca al directori seleccionat.<br /><br />S'examinen tots els títols de tots els objectes multimèdia  trobats per veure si contenen el text introduït a  #pgv_lang[filter]#. El resultat d'aquestes dues acions determina els objectes multimèdia a llistar.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Només es mostraran els suports que no estiguin enllaçats a cap registre GEDCOM.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Seleccioneu el subdirectori de suports que vulgueu veure.";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br /><br />Seleccioneu l'ordre amb el que voleu veure la llista.";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br /><br />Feu servir l'#pgv_lang[interactive_tree]# per veure l'arbre genealògic familiar d'una persona en ambdues direccions. Aquesta vista és similar a la del Rellotge de Sorra, que mostra tant els avantpassats com els descendents d'una determinada persona. Aquest gràfic però, us dóna una visió més compacta, mostrant caixetins de matrimonis o famílies, en lloc de fer-ho de persones individuals.<br /><ul><li><b>Desplaçament</b><br />Quan el cursor del ratolí canvia cap a iciona de moviment podeu polsar i arrossegar l'arbre per veure'n altres trossos. Tal i com aneu arrossegant l'arbre, es van expandint automàticament posteriors generacions, fins que ja no resten en aquella direcció.<br /></li><li><b>Zoom</b><br />Podeu emprar les icones a l'esquerra de l'arbre per ampliar i reduir. Reduir us permet veure més tros d'arbre en pantalla. Però si reduïu molt pot resultar difícil de llegir; quan el ratolí plana sobre un caixetí, podeu obtenir una visió ampliada del que conté.<br /></li><li><b>Ampliació de detalls</b><br />Polsant sobre qualsevol caixetí s'expandeix i mostra una visió més detallada. En aquest estat, polsant sobre el nom d'una persona, s'obre la seva pàgina #pgv_lang[indi_info]#. Polsant a <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> es redibuixa l'arbre amb aquesta persona com a base. Polsant <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> aneu a parar a la pàgina de detalls familiars.<br /></li><li><b>Alternar els cònjuges</b><br />La icona <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> que hi ha sota les de Zoom alternarà -si o no- la visualització de tots els cònjues per la banda dels descendents. Quan és configurat per veure els cònjuges, tots els cònjuges de la persona base apareixeren al caixetí, al seu costat. També sortirà tota la seva mainada. Quan l'opció dels cònjuges és desactivada, solament es mostrarà el darrer cònjuge.<br /></li><li><b>Arbre Gran</b><br />L'#pgv_lang[interactive_tree]# és disponible des de diverses pàgines incloent-hi la pestanya d'arbre de la #pgv_lang[indi_info]#  i el bloc de gràfics de la de benvinguda. Quan us mireu l'arbre des d'alguna d'aquesta pàgines, també disposareu d'una icona d'arbre, sota les de Zoom. Si polseu a <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> us menarà a la pàgina d'#pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br /><br />Quan hi ha activat el tallafocs multimèdia, els fitxers s'emmagatzemen a un directori que no és accessibles des d'Internet.<br /><br />Aquest botons us permeten moure fàcilment l'estructura sencera d'un directori multimèdia entre  <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> protegit (no accessible per web) i els directoris normals <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br /><br />Recurrentment poseu els permisos del directori protegit (no accessible per web) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> i el normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b> amb permís d'escriptura o de solament lectura.";
$pgv_lang["update_CHAN_text"] 		= "Els administradors de vegades necessiten netejar i corregir les dades enviades pels usuaris. Per exemple, és possible que hagin de corregir la ubicació del PLAC per incloure el país. Quan els administradors fan aquestes correccions, normalment se substitueix la informació sobre el canvi original. Això pot no ser desitjable.<br /><br />Quan s'escull aquesta opció durant la sessió d'edició o correcció de l'administrador, PhpGedView conservarà la informació de canvi original en lloc de substituir-la per la de la sessió actual.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Aquesta opció controla l'estat inicial de la casella «#pgv_lang[no_update_CHAN]#» que es mostra a cada pàgina on els administradors poden fer canvis o correccions a la base de dades genealògica.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Cada registre de font especifica esdeveniments, generalment per un determinat període de temps i lloc de jurisdicció. Per exemple, un registre civil enregistra naixements i un de parroquial batejos, casaments i defuncions.<br /><br />Seleccioneu els esdeveniments que aquesta font de la llista d'esdeveniments facilitada. Podeu especificar la data en format de lapse com p.e. <i>FROM 1900 TO 1910</i>. El lloc de jurisdicció és el nom de menor jurisdicció que abasta tots nivells baixos de lloc esmentats en aquesta font, per exemple \"Oneida, Idaho, USA\" es farà servir com a lloc de jurisdicció de font per esdeveniments ocorreguts als diversos pobles del Comtat d'Oneida. \"Idaho, USA\" serà el lloc de jurisdicció no solament del Comtat d'Oneida, sinó de tots els altres comtats d'Idaho.";
$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />Per donar agilitat aquest bloc de pàgina d'inici es desa com a fitxer cau. Podeu controlar la freqüència amb la que aquest fitxer cau es refresca.<br /><ul><li><b>-1</b> fa que es no es refresqui mai automàticament. Per disposar d'una còpia fresca, heu d'esborrar tots els fitxers cau. Podeu fer-ho a la personalització de la personalització de la pàgina d'inici.</li><li><b>0</b> (Zero) fa que aquest bloc no s'encaui mai, sempre disposareu d'una còpia fresca i tots els blocs  de la pàgina d'inici del PhpGedView Welcome es presentaran sempre en còpies fresques. Aquest paràmetre es fa servir automàticament per a blocs que canvien sovint com el #pgv_lang[logged_in_users_block]# i el #pgv_lang[random_media_block]#.</li><li><b>1</b> (U) fa que es creï diàriament una còpia fresca del fitxer cau d'aquest bloc, <b>2</b> cada dos dies, <b>7</b> setmanalment, etc.</li></ul>";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />A fi de donar agilitat, alguns blocs de  la pàgina d'inici PhpGedView es guarden com a fitxers cau al directori índex. Els fitxers cau de molts blocs es refresquen diàriament, però pot haver-hi ocasions que vulgueu refrescar-los manualment.<br /><br />Aquest botó us permet fer-ho quan calgui.";
$pgv_lang["import_options_help"] 	= "Podeu escollir opcions addicionals per fer servir quan s'importi el GEDCOM.";
$pgv_lang["verify_gedcom_help"]	= "~#pgv_lang[verify_gedcom]#~<br /><br />Podeu triar entre continuar amb la càrrega i importació d'aquest fitxer GEDCOM o avortar-ho.";
$pgv_lang["add_gedcom_instructions"]= "Entreu un nom de fitxer per aquest nou GEDCOM. Es crearà al directori índex: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />La projecció de diapositives començarà automàticament quan la pàgina es carregui.<br /><br />La projecció canvia els continguts del bloc sense carregar prèviament la informació del servidor i sense recarregar la pàgina sencera.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Podeu fer servir aquesta configuració per mostrar o amagar els controls de presentació del bloc fitxer a l'atzar.<br /><br />Aquests controls permeten a l'usuari saltar aleatòriament a un altre objecte o anar canviant-los com si es tractés d'una projecció de diapositives. La projecció canvia el contingut del bloc sense carregar prèviament la informació des del servidor ni recarregar la pàgina sencera.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Feu servir aquest enllaç per afegir una nova font a la base de dades, sense vincular-la a una ressenya de font de cap registre. La nova apareixerà a la llista de fonts, però no a cap diagrama o lloc del programa mentre que no l'enllaceu a una ressenya de font.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Empreu aquest enllaç per afegir a la base de dades una nova nota compartida sense vilcular-la a cap registre. La nova nota sortira a la llista de Notes Compartides però no a cap gràfic ni enlloc més del programa, fins que es vinculi a una persona, família o esdeveniment.";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />En aquest camp cal entrar-hi l'ID de la persona que esteu vinculant (p.ex. I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Feu servir aquesta secció per a seleccionar l'identificador a la base de dades alternativa que conté la persona que esteu vinculant.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />En aquesta secció podeu especificar els paràmetres que calguin, per connectar al lloc remot que conté les dades que esteu vinculant. Hi ha l'opció d'escollir entre una llista de llocs coneguts que hagueu fet servir abans o d'entrar el #pgv_lang[label_site_url2]# i #pgv_lang[label_gedcom_id]# per a un de nou.<br /><br />Al camp <b>#pgv_lang[label_site_url2]#</b>, cal que hi entreu el URL per accedir al servei web de descripció de fitxer (WDSL) que informa al PhpGedView com accedir a les dades del lloc remot. Per a un lloc PhpGedView remot, el URL del fitxer WSDL ha d'ésser així: <u>http://www.llocremot.com/phpGedView/genservice.php?wsdl</u><br /><br />El camp <b>#pgv_lang[label_gedcom_id]#</b> serveix per entrar un identificador opcional de base de dades pels llocs remots que ho requereixin. Per a llocs PhpGedView, és el mateix nom que el fitxer GEDCOM.<br /><br />El camp <b>#pgv_lang[label_username_id]#</b> i el camp <b>#pgv_lang[label_password_id]#</b> son necessaris si la base de dades els requereix.";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Aquesta opció us permet escollir si les dades de la persona que esteu vinculant son al mateix lloc però en diferent base de dades, o si son a un lloc diferent, però accessible des d'Internet.<br /><br />Si la persona és al mateix lloc us demanarà que seleccioneu l'identificador de la base de dades i que entreu l'ID d'aquesta persona.<br /><br />Per a un lloc remot, us demanarà que entreu el seu URL, un identificador de la base de dades i l'ID remot de la persona.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Feu servir aquesta opció per seleccionar el parentiu que la persona remota té amb la d'aquest lloc a la que l'esteu vinculant. Per exemple, seleccionant <i>Pare</i> voldrà dir que la persona del lloc remot és el pare de la persona que esteu vinculant localment.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Feu servir aquest formulari per vincular unes persones amb altres, tant des d'un altre lloc, com des d'una altre base de dades genealògica accessible pel PhpGedView.<br /><br />Per afegir aquest vincle, primer seleccioneu el tipus de parentiu i llavors trieu un lloc ja conegut al PhpGedView o definiu-ne un de nou i entreu l'ID de la persona que voleu vincular des d'allà. Si cal, el PhpGedView importarà automàticament informació del lloc remot. La informació <u>no</u> s'incorporarà a vostra base de dades genealògica: seguirà al lloc original, però s'incorporarà a les diverses pàgines on es mostra la persona enllaçada remotament.<br /><br />Trobareu més informació a l'enllaç d'ajuda, al costat de cada element de la pàgina. També podeu mirar el tutorial (en anglès) en línea: <a href=\"http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />El nom de la biblioteca, l'arxiu o qualsevol altre dipòsit on s'emmagatzema el material d'origen.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />L'adreça d'aquesta biblioteca, arxiu o altre dipòsit. Introduïu l'adreça tal com ho escriuríeu en un sobre.<br /><br />Deixeu aquest camp en blanc si no voleu incloure una adreça.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />El número de telèfon d'aquesta biblioteca, arxiu o altre dipòsit. Introduïu el número que inclou el país i el codi d'àrea. Per exemple, un número a Alemanya pot ser el +49 25859 56 76 89 i un número als Estats Units o al Canadà és el +1 888 555-1212.<br /><br />Deixeu aquest camp en blanc si no voleu incloure-ho un número de telèfon.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />El número de fax d'aquesta biblioteca, arxiu o altre dipòsit. Introduïu el número que inclou el país i el codi d'àrea. Per exemple, un número a Alemanya pot ser el +49 25859 56 76 89 i un número als Estats Units o al Canadà és el +1 888 555-1212.<br /><br />Deixeu aquest camp en blanc si no voleu incloure-ho un número de FAX.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />L’adreça electrònica d’aquesta biblioteca, arxiu o altre dipòsit. Introduïu l'adreça electrònica. Exemple: <b>nom@hotmail.com</b><br /><br />Deixeu aquest camp en blanc si no voleu incloure una adreça de correu electrònic.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />La pàgina d'inici d'aquesta biblioteca, arxiu o altre dipòsit d'Internet. Introduïu l'adreça de la pàgina d'inici, inclosa la pàgina http:// o https://. Exemple: <b>https://www.phpgedview.net/</b><br /><br />Deixeu aquest camp en blanc si no voleu incloure una adreça de pàgina d'inici.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />Una descripció d'identificació o referència que s'utilitza per arxivar i recuperar elements del fons d'una biblioteca, un arxiu o un altre dipòsit. Els dipòsits informals no solen necessitar utilitzar un sistema #factarray[CALN]#.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Aquest és el número d'identificació de la biblioteca, arxiu o altre dipòsit on s'emmagatzema el material d'origen al qual es fa referència. El títol de l'arxiu actual es mostrarà a sota del número d'identificació.<br /><br />Podeu canviar el número d'identificació de l'arxiu on s'emmagatzema aquest material d'origen. Per eliminar la referència de l'arxiu, deixeu aquest camp en blanc. Aquesta acció no elimina el registre d'arxiu de la base de dades; només s'elimina la referència.<br /><br />Si introduïu directament l’identificador d’arxiu desitjat, aquest registre d’arxiu ja hauria d’existir a la base de dades. Podeu fer clic <b>#pgv_lang[find_repository]#</b> per cercar el número d’identificació d’un arxiu existent. Feu clic <b>#pgv_lang[create_repository]#</b> si necessiteu introduir un registre d'arxiu nou.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Quan i on es va crear el registre. Per a les obres publicades, inclou informació com ara la ciutat de publicació, el nom de l'editor i l'any de publicació.<br /><br />Per a una obra no publicada, hauria d'incloure la data de creació del registre i el lloc on es va crear. Per exemple, el comtat i l'estat de residència d'una persona que declara una pensió o la ciutat i l'estat de residència de l'escriptor d'una carta o d'un historial familiar privat.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />La persona, l'agència o l'entitat que va crear el registre. Per a una obra publicada, podria ser l'autor, el compilador, el transcriptor, l'abstracte o l'editor. Per a una font inèdita, pot ser un individu, una agència governamental, una organització eclesiàstica o una organització privada, etc.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Aquest camp s'utilitza normalment per enregistrar text de forma lliure per identificar aquest registre GEDCOM. Per exemple, pot ser un número de fitxer dins d’un sistema automatitzat o manual, o bé pot ser un número de pàgina i posició en un gràfic genealògic.<br /></br />Quan la configuració de GEDCOM s'ha configurat per permetre a l'usuari anul·lar el número d'identificació generat automàticament per a les persones noves, s'introdueix aquest número d'identificació principal. En aquest cas, el text s’ha d’ajustar a les regles establertes per als números d’identificació. Els números d'identificació vàlids només poden contenir les lletres <b>A</b> a <b>Z</b>, <b>a</b> a <b>z</b>, dígits <b>0</b> a <b>9</b> i els símbols especials <b>. : -</b> i <b>_</b><br /><br />L'opció que permet l'ús del #factarray[REFN]# en lloc del número d'identificació generat automàticament es troba a la configuració de GEDCOM, secció Opcions d'edició.";
$pgv_lang["edit_ABBR_help"]			= "~#factarray[ABBR]#~<br /><br />Feu servir aquest camp per desar una versió abreujada del títol. S'utilitzarà conjuntament amb el camp títol a les fonts. Per defecte PGV farà servir primer el títol i després el títol abreujat.<br /><br />D'acord amb lles especificacions del GEDCOM 5.5, \"aquesta entrada és per a fornir un títol abreujat emprat per ordenar, arxivar i recuperar registres de font (pàg. 62).\"<br /><br />A PhpGedView el títol abreujat és opcional, per a altres programes genealògics no.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "En algunes cultures és costum tenir el nom tradicional escrit amb caràcters tradicionals i també una versió romanitzada del nom perquè pugui ésser escrita o pronunciada en idiomes basats en l'alfabet llatí, com l'anglès.<br /><br />Si preferiu fer servir un alfabet no llatí, com l'hebreu, grec, rus, xinès o àrab, entreu el nom als camps habituals i llavors podeu fer servir aquest camp per entrar el mateix nom emprant alfabet llatí. Ambdues versions del nom apareixeran a llistes i gràfics.<br /><br />Malgrat que aquest camp estigui etiquetat com a  \"Romanitzat\", no necessàriament cal que contingui únicament caràcters basats en l'alfabet llatí. Es pot emprar amb noms japonesos, on poden concórrer tres alfabets diferents.";
$pgv_lang["edit_ROMN_GIVN_help"]	= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />En aquest camp heu d'introduir-hi els noms de pila de la persona. Per exemple, en el cas del nom  \"John Robert Finlay\", els noms de pila que cal introduir son \"John Robert\"";
$pgv_lang["edit_ROMN_SURN_help"]	= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />En aquest camp heu d'introduir-hi el cognom de la persona. Per exemple, per al nom  \"John Robert Finlay\", el cognom que cal introduir és  \"Finlay\"<br /><br />Per a les persones amb més d'un cognom, habitual a Espanya i Portugal, cal separar els cognoms amb una coma. Això fa que la persona surti relacionada sota cada un dels seus cgonoms. Per exemple, el cognom \"Cortes,Vega\" es llistarà tant sota la <b>C</b> com sota la  <b>V</b>, en canvi  \"Cortes Vega\" solament apareixerà sota la  <b>C</b>.";
$pgv_lang["edit__HEB_help"]			= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "En algunes cultures és costum tenir el nom tradicional escrit amb caràcters tradicionals i també una versió romanitzada del nom perquè pugui ésser escrita o pronunciada en idiomes basats en l'alfabet llatí, com l'anglès.<br /><br />Si preferiu fer servir l'alfabet llatí per entrar els noms als camps habituals, podeu emprar aquest camp per entrar-hi el mateix nom en alfabet no llatí com el grec, hebreu, rus, àrab o xinès. Ambdues versions del nom apareixeran a llistes i gràfics.<br /><br />Malgrat que aquest camp estigui etiquetat com \"Hebreu\", no necessàriament cal que contingui únicament caràcters hebreus.";
$pgv_lang["edit__HEB_GIVN_help"]	= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />En aquest camp heu d'introduir-hi els noms de pila de la persona. Per exemple, en el cas del nom  \"John Robert Finlay\", els noms de pila que cal introduir son \"John Robert\"";
$pgv_lang["edit__HEB_SURN_help"]	= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />En aquest camp heu d'introduir-hi el cognom de la persona. Per exemple, per al nom  \"John Robert Finlay\", el cognom que cal introduir és  \"Finlay\"<br /><br />Per a les persones amb més d'un cognom, habitual a Espanya i Portugal, cal separar els cognoms amb una coma. Això fa que la persona surti relacionada sota cada un dels seus cgonoms. Per exemple, el cognom \"Cortes,Vega\" es llistarà tant sota la <b>C</b> com sota la  <b>V</b>, en canvi  \"Cortes Vega\" solament apareixerà sota la  <b>C</b>.";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Feu servir aquest formulari per afegir una persona pendent de vincular.<br /><br />Quan afegiu una persona desvinculada de l'arbre familiar, no queda enllaçada a cap altre si no ho feu expressament. Posteriorment, podeu vincular-la mitjançant el diagrama de #pgv_lang[relatives]# o la pàgina de #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Entreu l'adreça URL incloent-hi el http://. Exemple: <b>http://www.phpgedview.net/</b><br /><br />Deixeu-ho en blanc si no voleu incloure'n cap.";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Entreu l'adreça de la pàgina d'inici web, inclosa la http://. Exemple: <b>http://www.phpgedview.net/</b><br /><br />Deixeu-ho en blanc si no voleu incloure'n cap.";
$pgv_lang["edit_EMAIL_help"]			= "~#factarray[EMAIL]#~<br /><br />Entreu l'adreça de correu electrònic. Exemple: <b>nom@hotmail.com</b><br /><br />Deixeu-ho en blanc si no la voleu incloure.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Entreu el número de FAX incloent-hi el codi de país i l'àrea.  Per exemple, un número espanyol pot ser el +34 93 831469 i un número dels USA o Canada pot ser +1 888 555-1212.<br /><br />Deixeu-ho en blanc si no el voleu incloure.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Entreu el número de telèfon incloent-hi en codi de país i àrea.  Per exemple, un número espanyol pot ser el +34 93 831469 i un número dels USA o Canada pot ser +1 888 555-1212.<br /><br />Deixeu-ho en blanc si no el voleu incloure.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Entreu l'adreça tal i com l'escriuríeu a un sobre.<br /><br />Deixeu-ho en blanc si no la voleu incloure.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Entreu o seleccioneu de la llista, els mots que precedeixen la part principal del cognom. Exemples d'aquestes d'aquest mots ho son <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Peguera,  <b>del</b> Villar, etc.<br /><br />En algunes circumstàncies, aquí es pot introduir un títol nobiliari. Per exemple, Peter <b>Freiherr von</b> Somewhere. La part «Freiherr» és en realitat un títol nobiliari, i no s'ha de repetir com a fet #factarray[TITL]#. El que s'introdueix aquí depèn en gran mesura de les preferències de la persona en qüestió.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Entreu el nom de casat/da per a aquesta persona fent servir les mateixes regles de format que les aplicades al camp del Nom. Aquest és un camp opcional.<br /><br />Per exemple, si Mary Jane Brown es casa amb John White, heu d'entrar (sense cometes, evidentment)<ul><li>Ús americà:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Ús europeu:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Un altre ús europeu:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" o \"Mary Jane /Brown-White/\"</li></ul>Fareu això solament si Mary Brown ha començat a identificar-se pel nou nom un cop casada amb John White. A alguns llocs com al Quebec (Canadà) per exemple, és il·legal canviar-se el nom d'aquesta forma.<br /><br />Els homes algun cop es canvien llur nom desprès de casats, molts fan servir la forma guionada però, ocasionalment, també poden prendre el cognom de la dona.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />Aquest camp descriu el vincle d'aquest fill amb llur família. Les possibilitats son:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;No pot determinar-se el vincle. Quan es selecciona aquesta opció el camp #factarray[PEDI]# no es copiarà a la base de dades.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Indica que el fill està vinculat a la família per naixença.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Aquesta opció indica que ha sigut adoptat per la família. Això <i>no</i> indica que no hi hagi consanguinitat entre el fill i la família; mostra que fou adoptat algun temps desprès del naixement.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Indica que és un fill de llet o adoptiu de la família. Generalment no hi ha consanguinitat entre el fill i la família.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;El fill s'ha segellat a aquesta família mitjançant la cerimònia ritual SUD del <i>segellament</i>. Un segellat infantil es realitza quan els pares es van segellar entre ells desprès del naixement del nen. El fills nascuts desprès del segellament dels pares, queden automàticament segellats a la família.</li></ul>";
$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />La organització, institució, corporació, persona o qualsevol altre entitat amb autoritat.<br /><br />Per exemple, un empleat o una persona o església que administri ritus o esdeveniments o una organització responsable de crear i/o arxivar registres.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />Aquest camp descriu el tipus d'unió que va formar la família.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;indica que la cerimònia que va formalitzar la unió de dues persones per formar una família va ser realitzada per un sacerdot, bisbe, cardenal, predicador, rabí, xaman o persona similar. La cerimònia no tenia lloc necessàriament en una església, sinagoga, temple o un altre lloc consagrat. Es podria haver fet a l'aire lliure o en una casa particular.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;indica que la cerimònia que va formalitzar la unió de dues persones per formar una família va ser realitzada per un jutge, magistrat, alcalde o persona similar d'autoritat que no sigui sacerdot, etc. L'autoritat per realitzar aquestes cerimònies sol ser atorgada per un govern. La cerimònia no necessàriament va tenir lloc en una sala de tribunals o en un despatx.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;descriu la relació entre dues persones, no casades entre elles, que es comporten com si fossin una família. <u>No</u> han participat en una cerimònia de matrimoni celebrada per un sacerdot, un bisbe, un jutge, un alcalde o qualsevol altra persona amb autoritat per celebrar matrimonis. És possible que hagin fet una declaració pública que es consideren casats, però això no és un requisit.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;indica que no es coneixen els detalls de la unió entre dues persones per formar una família.</li></ul>";

$pgv_lang["context_help"]			= "Teniu més ajuda disponible polsant l'<b>?</b> del costat de cada entrada.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Cada persona de la base de dades té un únic ID. Si sabeu quin és el vostre propi registre, entreu-lo aquí. Si el desconeixeu o no podeu trobar-lo degut a restriccions de privadesa, demaneu-ho a l'administrador al camp de Comentaris, a fi de que sigui ell qui li posi per compte vostre.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Feu servir aquest camp per dir a l'administrador perquè voleu enregistrar-vos i disposar d'accés. I quina és va vostra relació amb la genealogia que hi ha al lloc. També el podeu fer servir per altres comentaris que cregueu oportú que ha de saber.";
$pgv_lang["utf8_ansi_help"]		= "~#pgv_lang[utf8_to_ansi]#~<br /><br />Per a una òptima visualització a Internet, el PhpGedView empra el joc de caràcters UTF-8. Alguns programes, Family Tree Maker per exemple, no poden importar fitxers GEDCOM codificats amb UTF-8. Polsant aquest botó es convertirà el fitxer d'<b>UTF-8</b> a <b>ANSI (ISO 8859-1)</b>.<br /><br />El format que cal, depèn del programa que feu servir per treballar amb el fitxer GEDCOM descarregat. Si no n'esteu segur, consulteu la documentació del programa.<br /><br />Recordeu que, perquè els caràcters especials es conservin, cal manteniu el fitxer en format UTF-8 i convertir-lo al mètode del programa particular i manipular aquests caràcters especials per altres mitjans. Consulteu el manual d'usuari del programa.";
$pgv_lang["remove_tags_help"]	= "~#pgv_lang[remove_custom_tags]#~<br /><br />Triant aquesta opció eliminareu les etiquetes personalitzades que s'hagin afegit als registres amb el PhpGedView.<br /><br />Aquestes etiquetes son <b>_PGVU</b> que identifica l'usuari que ha canviat un registre en línea i el <b>_THUM</b> que diu al PhpGedView que la imatge pot fer-se servir com a miniatura.<br /><br />Les esmentades etiquetes poden produir errors quan s'importa el fitxer GEDCOM descarregat a un altre programari genealògic.";
$pgv_lang["download_zipped_help"]	= "~#pgv_lang[zip_files]#~<br /><br />Triant aquesta opció es comprimirà una còpia del fitxer GEDCOM en format ZIP abans de començar la descàrrega. Això redueix considerablement el volum però us caldrà un descompressor compatible (WinZIP, per exemple) per tractar el fitxer abans de fer-lo servir.<br /><br />És una bona opció quan es tracta de baixar fitxers GEDCOMs grans: Correm el risc que el temps de descàrrega per a fitxers descomprimits excedeixi el màxim permès i el procés quedi a mitges. La opció ZIP pot reduir-lo en un 75%.";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Entreu el nombre de mainada d'aquesta persona o família. Aquest és un camp opcional.";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Entreu l'hora d'aquest esdeveniment en format 24 hores amb zeros a l'esquerra si cal. Mitjanit és 00:00. Exemples: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />Les notes tenen format de text lliure i apareixen a la secció de detalls dels esdeveniments de la pàgina.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Les notes compartides tenen format de text lliure i apareixen als detalls d'esdeveniment de la pàgina.<br /><br />Cada nota compartida pot vincular-se a més d'una persona, família, font o esdeveniment.";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />Entreu el nom del cementiri o la tomba a on la persona s'hagi enterrat.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Introduïu l'identificador GEDCOM de la persona la relació amb la persona actual que voleu descriure.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Seleccioneu una #factarray[RELA]# de la llista. Seleccionar <b>#pgv_lang[godfather]#</b> significa: <i>La persona identificada al camp #factarray[ASSO]# és el #pgv_lang[godfather]# de la persona actual</i>.";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Per defecte aquest diagrama no ha de mostrar els cònjuges dels descendents perquè es complicaria. Posant aquesta opció hi sortiran els cònjuges.";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Les famílies al diagrama #pgv_lang[relatives]# surten per l'ordre en que apareixen al registre de persones del registre GEDCOM. No s'ordenen per data de casament perquè sovint hom les desconeix, però l'ordre si que <u>és</u> conegut.<br /><br />Aquesta opció permet de canviar l'ordre en el que es llisten les famílies al diagrama #pgv_lang[relatives]#. Si voleu ordenar les famílies per la data de casament, hi ha un botó que polsant-lo, ho fa automàticament.";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Quan el PhpGedView detecta que la importació del GEDCOM requereix més temps del permès per límit de temps mostrarà un boto <b>#pgv_lang[del_proceed]#</b> que podeu polsar per continuar la importació.<br /><br />Quan aquesta opció es fixa a <b>#pgv_lang[yes]#</b>, el PhpGedView polsa automàticament el botó <b>#pgv_lang[del_proceed]#</b> per compte vostre. Això estalvia la tediosa tasca d'haver d'anar polsant el botó repetidament en importacions llargues.";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />El cognom escollit el tenen més de #GLOBALS[SUBLIST_TRIGGER_I]# persones.<br /><br />Per ajudar-vos a trobar la persona que busqueu, la llista s'ha subdividit amb altres de més petites ordenades per la inicial del nom de pila. Aquest subíndex alfabètic funciona igual que el de cognoms.<ul><li>Polseu una lletra per veure tots els noms de pila que comencin per ella.</li><li>Escolliu <b>#pgv_lang[PN]#</b> per veure totes les persones de les que se'n desconeix el nom de pila.</li><li>Escollint <b>#pgv_lang[all]#</b> surt una llista de totes les persones amb el cognom prèviament seleccionat.</li></ul>";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />El nom de família que heu escollit té més de #GLOBALS[SUBLIST_TRIGGER_F]# persones.<br /><br />Per ajudar-vos a trobar la família que busqueu, la llista s'ha subdividit amb altres més petites ordenades per la inicial del nom de pila de les persones. Aquest subíndex alfabètic funciona igual que el de noms.<ul><li>Polseu una lletra per veure tots els noms de pila que comencin per ella.</li><li>Escolliu <b>#pgv_lang[PN]#</b> per veure una llista de la gent de la que se'n desconeix el nom de pila.</li><li>Escollint <b>#pgv_lang[all]#</b> sortirà una llista de totes les famílies amb el cognom prèviament seleccionat.</li></ul>";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />El camp #factarray[TYPE]# es fa servir per entrar informació addicional sobre l'entrada. En molts cassos el camp és de lliure format i hom pot entrar-hi el que li sembli.";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />Per als ritus SUD, aquest camp enregistra el temple on s'ha fet.";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Aquest és un camp opcional d'estatus i es fa servir generalment per als ritus SUD de la mateixa forma que al programa TempleReady.";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Feu servir aquest camp per a senyalar que aquesta imatge és la principal o de la persona a la que l'esteu vinculat. És la que es farà servir als caixetins i a la pàgina de la persona.";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Aquesta opció us permet substituir la selecció habitual per a una imatge en miniatura.<br /><br />El GEDCOM té una opció de configuració que especifica si PhpGedView ha d’enviar la imatge gran o petita al navegador sempre que la pàgina actual requereixi una miniatura. L'opció Â«#factarray[_THUM]#Â», quan s'estableix en <b>#pgv_lang[yes]#</b>, substitueix temporalment la configuració de l'opció de configuració de GEDCOM, de manera que PhpGedView sempre enviarà la imatge gran. No podeu obligar PhpGedView a enviar la imatge petita quan la configuració de GEDCOM especifica que sempre s’han d’utilitzar imatges grans.<br /><br />PhpGedView no redimensiona la imatge que s’envia; el navegador ho fa segons les especificacions de la pàgina que també ha rebut. Això pot tenir conseqüències indesitjables quan la imatge que s’envia no és realment una miniatura on PhpGedView espera enviar una imatge petita. Això no és un error: hi ha ocasions en què pot ser desitjable mostrar una imatge gran en llocs on normalment s’esperaria veure una imatge de mida de miniatura.<br /><br />Heu d'evitar configurar l'opció Â«#factarray[_THUM]#Â» a <b>#pgv_lang[yes]#</b>. Aquesta elecció farà que s'enviïn quantitats excessives de dades relacionades amb la imatge al navegador, només perquè el navegador descarti l'excés. Les càrregues de pàgines, sobretot de gràfics amb moltes imatges, es poden reduir seriosament.";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Poseu un títol per a l'entrada que esteu editant. Si ho és per a un fitxer multimèdia, cal que sigui descriptiu i que faciliti a l'usuari llur identificació.<br /><br />Si esteu editant els detalls d'una persona, feu servir aquest camp per introduir informació de la noblesa com ara <i>Sir, Lord, Baró, Comte, Duc, Graf, Freiherr,</i> etc.<br /><br />Les designacions professionals com ara <i>Dr., Almirall, Lt.Gen., Rev., Sister,</i> etc. s'han d'introduir al subcamp «#factarray[NPFX]#», mentre que sufixos de nom com ara <i>Jr., Sr., III, IV,</i> etc. i informació acadèmica com ara <i>PhD, PEng, FImechE, DVM, MD,</i> etc. pertanyen al subcamp «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Aquest és el camp més important al registre d'objectes multimèdia. Indica quin fitxer es farà servir. Com a mínim s'ha d'entrar el nom del fitxer. Segons com, pot ser d'ajuda més informació sobre llur localització.<br /><br />Podeu fer servir l'enllaç <b>#pgv_lang[find_media]#</b> per localitzar altres fitxers multimèdia carregats en aquest lloc.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />Aquest és un camp opcional que podeu fer servir per entrar-hi el format de l'objecte multimèdia. Alguns programes genealògics busquen aquest camp per determinar com tractar-lo. Tanmateix, atès que els fitxers multimèdia no es transfereixen gaire be a través dels sistemes informàtics, no és gaire important.";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />El vostre sistema pot generar automàticament miniatures de certs tipus d'imatges. Pot haver-hi suport per a fitxers BMP, GIF, JPG i PNG. Els tipus que el vostre sistema suporta es mostren al costat del caixetí de control.<br /><br />Marcant aquest caixetí indiqueu al sistema que esteu carregant imatges d'aquest tipus i que us interessa que us generi automàticament les miniatures. Deixeu-lo desmarcat si voleu fornir-li les vostres pròpies.";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Aquesta secció us permet afegir una nova nota a l'esdeveniment que esteu editant. Les notes son de text lliure i sortiran a la secció de detalls de la pàgina de l'esdeveniment.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Com les regulars, les notes compartides son de text amb format lliure. A diferencia d'aquelles però, cada compartida pot vincular-se a més d'una persona, família, font o esdeveniment.<br /><br />Polsant la icona adequada, podeu establir vincles a notes compartides preexistents o crear-ne de noves i vincular-les al mateix temps. Malgrat que s'hagi establert enllaços notes compartida existents, també podeu editar-ne el contingut.<br /><ul><li><b>Vincular a una nota compartida preexistent</b><div style=\"padding-left:20px;\">Si coneixeu el número d'ID de la nota compartida, podeu entrar-lo directament al camp.<br /><br />Si polseu la icona <b>#pgv_lang[find_shared_note]#</b>, podreu cercar entre els textos de totes les notes compartides existents i escollir-ne una. El número d'ID de l'escollida entrarà automàticament al camp.<br /><br />Us cal polsar el botó <b>#pgv_lang[add]#</b> per modificar-ne el registre original.</div><br /></li><li><b>Crear una nova nota compartida</b><div style=\"padding-left:20px;\">Si polseu la icona  <b>#pgv_lang[create_shared_note]#</b>, s'obre una finestra on podeu entrar-hi el text desitjat per a la nova nota. Igual que a les notes regulars podeu posar-hi URLs.<br /><br />Si polseu el botó <b>#pgv_lang[save]#</b>, us apareixerà un missatge amb el número d'ID de la nota compartida acabada de crear. Heu de polsar sobre aquest missatge per tancar la finestra d'edició i entrar manualment el número d'ID al camp corresponent. Recordeu que si solament tanqueu la finestra, el nou número d'ID no es copia automàticament.<br /><br />Heu de polsar el botó <b>#pgv_lang[add]#</b> per modificar el registre original.</div><br /></li><li><b>Editar una nota compartida preexistent</b><div style=\"padding-left:20px;\">Polsant la icona  <b>#pgv_lang[edit_shared_note]#</b>, s'obre una finestra on podeu canviar el text de la nota compatida al vostre gust. Tal i com a les notes regulars, també podeu entrar-hi URLs.<br /><br />Polsant el botó  <b>#pgv_lang[save]#</b>, s'actualitzarà el text de la nota compartida. Podeu tancar la finestra i desprès polsar el botó <b>#pgv_lang[save]#</b>.<br /><br />Quan modifiqueu el text d'una nota compartida, els canvis es reflectiran a tot arreu on aquesta nota compartida estigui vinculada. Els nous enllaços que establiu un cop fets els canvis, també empraràn els text modificat.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~UTILITZACIÓ DE L'AUXILIAR GEDFACT~<br /><br />En fer clic a la icona \"+\", s'obrirà la finestra de l'Assistent de notes compartides de GEDFact. Es redactarà un text d'ajuda d'aquest tema.<br /><br />El número d'ID acabat de crear es copiarà automàticament si polzeu l'enllaç.";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Aquesta secció us permet afegir una nova ressenya de font a l'esdeveniment que esteu editant.<br /><br />Al camp font heu d'entrar-hi l'ID de la font. Polseu l'enllaç <b>#pgv_lang[create_source]#</b> si cal entrar una nova font. Al camp detalls de la ressenya podeu entrar-hi el número de pàgina o altra ressenya que permeti localitzar la informació a la font. El camp text és per a que hi entreu la transcripció del text de la font.";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# permet relacionar un esdeveniment a una persona associada. És, per exemple, una forma d'enregistrar que algú és el padrí d'algú altre.";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Feu servir aquest camp per registrar la qualitat o la fiabilitat de les dades que es troben en aquesta font. Moltes aplicacions de genealogia utilitzen un nombre en el camp. <b>3</b> pot significar que les dades són una font principal, <b>2</b> pot significar que eren una font secundària, <b>1</b> pot significar que la informació és qüestionable, i <b>0</b> pot significar que la font no és fiable.";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />Al camp Detalls de la cita, introduiríeu el número de pàgina o altra informació que pugui ajudar algú a trobar la informació a la font.";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />En aquest camp podeu entrar-hi el text de referència per aquesta font. Per exemple una transcripció del text de la font o una descripció del que hi feia referència.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Aquest és el número d'identificació de la font d'aquest fet. El títol de la font actual es mostrarà a sota del número d'identificació.<br /><br />Podeu canviar el número d'identificació del registre d'origen al qual fa referència la cita font d'aquest fet. Per eliminar tota la cita, deixeu aquest camp en blanc. Aquesta acció no elimina el registre font de la base de dades; només s'elimina aquesta referència.<br /><br />Si introduïu directament l'identificador d'origen desitjat, aquest registre d'origen ja ha d'existir a la base de dades. Podeu fer clic <b>#pgv_lang[find_sourceid]#</b> per cercar el número d'identificació del registre d'origen existent. Feu clic <b>#pgv_lang[create_source]#</b> si necessiteu introduir un registre d'origen nou.";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Aquesta pàgina us permet editar el registre primari GEDCOM. Cal que aneu amb compte: requereix un bon coneixement de l'estàndard GEDCOM 5.5.1. Per més informació sobre el GEDCOM 5.5.1, aneu a l'ajuda <b>fitxer GEDCOM</b>.<br /><br />El PhpGedView disposa de diverses formes per afegir i editar informació, però pot donar-se el cas que calgui editar el registre primari GEDCOM. Sempre que sigui possible feu servir els camins que dóna el programa. Un cop desat el formulari la informació passarà una revisió bàsica de compatibilitat amb l'estàndard i és modificaran els registre CHAN.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView us permet copiar fins a 10 fets, amb totes les seves dades, en un porta-retalls. Aquest porta-retalls és diferent del Carro de retalls que podeu utilitzar per exportar parts de la vostra base de dades.<br /><br />Podeu seleccionar qualsevol dels fets del porta-retalls i copiar el fet seleccionat al registre de persona, família, mitjans de comunicació, font o arxiu que s'està editant. Tot i això, no podeu copiar fets de tipus de registres diferents. Per exemple, no es pot copiar un fet matrimonial a un registre d'origen o persona, ja que el fet matrimonial només s'associa als registres familiars.<br /><br />Això és molt útil per introduir fets similars, com ara fets censals, per a moltes persones o famílies.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Cal tenir cura d'entrar el noms de lloc d'acord als estàndards de genealogia: S'enregistren posant la informació més específica primer i la menys desprès, fent servir comes per separar els diferents nivells de lloc.<br /><br />Per exemple, un lloc com la ciutat de Salt Lake heu d'entrar-la així \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Permeteu-nos examinar cada part d'aquest lloc. La primera part, \"Salt Lake City\", és la població on ha ocorregut l'esdeveniment. En alguns països les ciutats poden dividir-se en municipalitats o districtes que sigui important considerar. En aquest cas han d'anar abans de la ciutat. La part següent, \"Salt Lake\", és el comtat.  \"Utah\" l'estat i \"USA\" el país. És important anotar cada lloc perquè els registres genealògics es mantenen per compartiments de cada nivell.<br /><br />Si hom desconeix el nivell del lloc, cal deixar un espai en blanc entre comes. Suposem, per a l'exemple d'abans que desconeixem el comtat de Salt Lake City. Cal enregistrar-lo així: \"Salt Lake City, , Utah, USA\". Suposeu-vos que solament sabeu que una persona ha nascut a Utah. Heu d'entrar la informació així: \", , Utah, USA\".<br /><br />Podeu fer servir l'enllaç <b>#pgv_lang[find_place]#</b> per ajudar-vos a cercar llocs que ja siguin a la base de dades.<br /><br /><b>Nota a la traducció catalana</b>:<br />Pot resultar apropiat per als noms de lloc catalans fer servir el següent esquema: \"Lloc, Municipi, Comarca, País\" on el Lloc pot ésser el nom d'un nucli poblacional, barri, masia,... .";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />Generalment, no es recomana introduir coordenades de latitud i longitud específiques, ja que només permet l'accés al mapatge des de la vista de l'element específic. És millor gestionar els llocs geogràfics.<br /><br />Tanmateix, introduir la latitud i la longitud permet una collocació més precisa del marcador.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />Generalment, no es recomana introduir coordenades de latitud i longitud específiques, ja que només permet l'accés al mapatge des de la vista de l'element específic. És millor gestionar els llocs geogràfics.<br /><br />Tanmateix, introduir la latitud i la longitud permet una collocació més precisa del marcador.";
$pgv_lang["edit_add_parent_help"]	= "~AFEGIR NOU PARE O MARE~<br /><br />Amb aquesta pàgina podeu afegir un pare o mare a la persona seleccionada. Ompliu el nom de la nova persona i les dates de naixement i defunció, si les coneixeu. Si no, deixeu-ho en blanc.<br /><br />Per afegir altres esdeveniments, primer cal que creeu la nova persona a la base de dades, desant els canvis. Llavors polseu sobre el nom de la persona a la pàgina de la família modificada o al diagrama de  #pgv_lang[relatives]# per veure la pàgina #pgv_lang[indi_info]# de la persona. Des de la pàgina #pgv_lang[indi_info]#  podeu afegir informació més detallada.";
$pgv_lang["edit_add_spouse_help"]	= "~AFEGIR NOU MARIT O MULLER~<br /><br />Amb aquesta pàgina podeu afegir un nou marit o nova muller a la persona seleccionada. Ompliu el nom de la nova persona i les dates de naixement i d'òbit, si les coneixeu. Si no, deixeu-ho en blanc.<br /><br />Per afegir altres esdeveniments que els esmentats, primer cal que creeu la nova persona a la base de dades, desant els canvis. Llavors polseu sobre el nom de la persona a la pàgina de la família modificada o al diagrama de  #pgv_lang[relatives]# per veure la pàgina #pgv_lang[indi_info]# de la persona. Des de la pàgina #pgv_lang[indi_info]#  podeu afegir informació més detallada.";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />Aquesta àrea us permet entrar informació de l'òbit. Primerament poseu la data de defunció amb format (1&nbsp;JAN&nbsp;2004) (atenció! noms de mesos en anglès!). Podeu polsar la icona del calendari per ajudar-vos a seleccionar-la. Desprès entreu el lloc on va morir. Podeu fer servir l'enllaç <b>#pgv_lang[find_place]#</b> per seleccionar-ne un de la base de dades.";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />Aquesta àrea us permet entrar informació del natalici. Primerament entreu la data de naixement amb format (1&nbsp;JAN&nbsp;2004) (atenció! noms de mesos en anglès). Podeu polsar la icona del calendari per ajudar-vos a seleccionar-la. Desprès entreu el lloc de naixement. Podeu fer servir l'enllaç <b>#pgv_lang[find_place]#</b> per seleccionar-ne un de la base de dades.";
$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Escolliu el sexe des del menú desplegable. La opció <b>desconegut</b> vol dir que no se sap.";
$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#~<br /><br />Aquest és el camp més important al registre del nom de la persona.<br /><br />Pot omplir-se automàticament com altres camps però es posa aquí perquè pugueu editar la informació d'acord amb les preferències personals.<br /><br />El nom d'aquest camp ha d'estar d'acord als estàndards GEDCOM 5.5.1 amb el cognom entre barres inclinades \"/\". Per exemple, el nom \"John Robert Finlay Jr.\" cal que l'entreu així: \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />En aquest camp heu d'introduir-hi el cognom de la persona. Per exemple, en el nom \"John Robert Finlay\", el cognom que cal entrar és  \"Finlay\"<br /><br />Les persones amb cognoms múltiples, com és el cas de l'Estat Espnayol i Portugal, cal separar els cognoms amb una coma. Això indica que la persona serà llistada sota cadascun dels noms. Per exemple, el cognom \"Cortes,Vega\" tant es llistarà amb la  <b>C</b> com amb la  <b>V</b>, mentre que el cognom \"Cortes Vega\" solament es llistarà sota la <b>C</b>.";
$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />En aquest camp podeu entrar-hi els àlies, motius, malnoms, diminutius o noms familiars de la persona. És un camp opcional.<br /><br />Formes de posar un àlies:<ul><li>Seleccioneu <b>modificar nom</b> i entreu-lo i deseu-ho</li><li>Seleccioneu <b>afegir un nou nom</b> entreu-lo i deseu-ho</li><li>Seleccioneu <b>editar registre GEDCOM</b> per afegir múltiples registres [2&nbsp;NICK] subordinats del principal [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />En aquest camp cal entrar-hi els noms de pila de la persona. Per exemple, de la persona \"John Robert Finlay\", els noms de pila són \"John Robert\"";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Aquest camp opcional us permet introduir un prefix de nom com ara <i>Dr.</i> o <i>Adm.</i><br /><br />Els títols nobiliaris com ara <i>Sir, Lord, Baró, Comte, Duc, Graf, Freiherr,</i> etc. s'introdueixen com a fet «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Aquest camp opcional us permet introduir un sufix de nom com ara <i>Jr., Sr., III, IV,</i> etc. i informació acadèmica com ara <i>PhD, PEng, FImechE, DVM, MD,</i> etc.";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />En aquesta pàgina podeu afegir més mainada a la família seleccionada. Ompliu el nom del fill o filla i la data de naixement i defunció, si la sabeu. Si no, deixeu-ho en blanc.<br /><br />Per afegir altres esdeveniments, primer cal que afegiu el fill a la base de dades i deseu els canvis. Llavors polseu sobre el seu nom a la pàgina de la família modificada o al diagrama #pgv_lang[relatives]# per veure la pàgina #pgv_lang[indi_info]# d'informació del fill. Des de la pàgina #pgv_lang[indi_info]# podeu afegir informació més detallada.";

$pgv_lang["review_changes_help"]	= "~#pgv_lang[review_changes_block]#~<br /><br />Aquest bloc mostra tots els registres que s'han modificat en línea i que resten pendents de revisar i acceptar.";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Feu servir els camps \"Modificar el nom\" per a canviar els de la persona que s'estigui editant. Hi ha un camp per al nom de pila i un altre per al cognom. Per exemple, si el que voleu entrar és \"John Robert Finlay\" cal que poseu \"John Robert\" al camp del nom de pila i \"Finlay\" al del cognom.<br /><br />Omplint-los el que es fa és <u>canviar</u> el nom de la persona, no pas afegir-n'hi un de nou.<br /><br /><i>Nota: <u>no</u> feu servir aquest camí per canviar noms per raó d'un nou matrimoni. Per a aquest fi, feu servir la opció d'afegir un nou marit.</i>";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Feu servir els camps \"Modificar un esdeveniment\" per afegir-hi nova informació o canviar el contingut de l'existent al registre que esteu editant. Primer escolliu el tipus d'esdeveniment a la llista desplegable. Desprès entreu-hi la data en que ocorregué amb el format estàndard per a genealogia (1&nbsp;JAN&nbsp;2004) (atenció: els noms de mesos en anglès!). Si cal, es polseu la icona del calendari per ajudar-vos a seleccionar-la. Seguidament entreu el lloc on va succeir. Pot ajudar-vos l'enllaç <b>#pgv_lang[find_place]#</b> per triar-ne una entre les que ja hi ha a la base de dades.<br /><br />Tal com tota la resta de camps d'aquest formulari, la informació entrada o substitueix a la prèviament existent o es crea de nou.";
$pgv_lang["quick_update_address_help"] = "~#pgv_lang[update_address]#~<br /><br />Feu servir el camp <b>#pgv_lang[update_address]#</b> tant per canviar la postal, la de correu electrònic o el número de telèfon de la persona que s'estigui editant.<br /><br />Com a tots els altres camps d'aquest formulari, el que s'hi escriu substituirà al que hi hagi prèviament o crearà noves entrades.";
$pgv_lang["quick_update_spouse_help"] = "~AFEGIR NOU MARIT O MULLER~<br /><br />Feu servir aquest camps quan vulgueu afegir un nou marit -o muller- de la persona que estigueu editant. Entreu el nom del nou cònjuge i dades de naixement als camps corresponents i també la data del casori. Entreu les dades en el format estàndard per a genealogia (1&nbsp;JAN&nbsp;2004) (atenció: noms de mesos en anglès!). Si cal, podeu polsar la icona del calendari per ajudar-vos a seleccionar-ne una. També podeu fer servir l'enlla <b>#pgv_lang[find_place]#</b> per triar un lloc entre els existents a la base de dades.<br /><br />Aquest camps solament serveixen per afegir una <i>nova</i> parella, no pas per a modificar la informació d'una antiga. Per fer això, cal que tanqueu aquesta finestra i polseu sobre el nom de la persona en qüestió al diagrama #pgv_lang[relatives]#. Seguidament polseu el menú d'editar persona.";
$pgv_lang["quick_update_marriage_help"] = "~MODIFICAR CASAMENT~<br /><br />El podeu fer servir aquests camps juntament amb els d'afegir nou cònjuge si preteneu enregistrar un nou casament. Si no, entrant-hi informació, el que fareu serà canviar la relativa al darrer casament de la persona. Entreu les dates en el format estàndard per a genealogia (1&nbsp;JAN&nbsp;2004) (atenció: noms de mesos en anglès!). Si cal, podeu polsar la icona del calendari per ajudar-vos a seleccionar-ne una. També podeu fer servir l'enllaç <b>#pgv_lang[find_place]#</b> per triar un lloc entre els existents a la base de dades.";
$pgv_lang["quick_update_child_help"] = "~#pgv_lang[add_new_chil]#~<br /><br />Feu servir aquests camps per afegir descendència a aquesta persona. Primerament entreu el nom i el sexe. Desprès la data i el lloc de naixement. Entreu les dates en el format estàndard per a genealogia (1&nbsp;JAN&nbsp;2004) (atenció: noms de mesos en anglès!). Podeu polsar la icona del calendari per ajudar-vos a seleccionar-ne una. També podeu fer servir l'enllaç <b>#pgv_lang[find_place]#</b> per triar un lloc entre els existents a la base de dades.<br /><br />Aquests camps solament serveixen per afegir un  <u>nou</u> fill/a. No per modificar la informació d'un de ja existent. Per fer això, tanqueu aquesta finestra i polseu sobre el nom de la persona en qüestió al diagrama #pgv_lang[relatives]#.  Seguidament polseu al menú d'editar persona.";
$pgv_lang["index_top10_pageviews_help"]		= "~#pgv_lang[top10_pageviews]#~<br /><br />Llista les persones, famílies o fons més visitades pels usuaris del lloc. Per a que aquest bloc aparegui, l'administrador ha d'haver activat els comptadors de visites.";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Aquest bloc mostra la política de cookies d’aquest lloc.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Deixeu aquest camp buit si voleu utilitzar el text estàndard.<br /><br />Si voleu utilitzar el text estàndard i també proporcioneu un enllaç a un fitxer de text o pàgina HTML que contingui detalls sobre la política de cookies específica de al vostre lloc, podeu introduir l’URL d’aquesta pàgina aquí.<br /><br />Per exemple, <b>http://foo.bar.com/policy/cookies.txt</b> podria apuntar a fitxer de text pla, mentre que <b>http://foo.bar.com/policy/cookies.htm</b> apunta a una pàgina amb format HTML i <b>http://foo.bar.com/policy/cookies.doc</b> apunta a un document en format Microsoft Word.";
$pgv_lang["cookiepolicy_link_advice"]		= "Deixeu-ho en blanc per utilitzar el text estàndard.<br /><br />Introduïu un URL com <b>http://foo.bar.com/policy/cookies.txt</b> per apuntar a una pàgina de política específica del lloc.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Aquest paràmetre permet especificar amb quin format s'obrirà automàticament, quan l'usuari accedeixi a la pàgina #pgv_lang[indi_info]#. Si té permís per editar el seu compte, podrà canviar aquest paràmetre més endavant.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Aquest paràmetre permet especificar amb quin format s'obrirà automàticament quan s'accedeixi a la pàgina #pgv_lang[indi_info]#.";
$pgv_lang["reorder_children_help"]	= "~#pgv_lang[reorder_children]#~<br /><br />La mainada surt en l'ordre en que apareixen al registre familiar. No s'ordena per dates de naixement perquè sovint és una dada desconeguda però l'ordre en que varen néixer <u>si</u> que és conegut.<br /><br />Aquesta opció us permet canviar l'ordre de la mainada al registre de la família. Si la voleu ordenar-la per data de naixement, hi ha un botó que polsant-lo, ho fa automàticament.<br /><br />També podeu 'copiar i enganxar' qualsevol caixetí per canviar l'ordre de la mainada. Quan passeu el cursor per sobre del caixetí, el seu aspecte canvia amb un parell de fletxes creuades bicèfales. Si polseu i manteniu el botó esquerra del ratolí abans de moure el cursor, el caixetí seguirà al ratolí, amunt o avall de la llista. Quan moveu un caixetí, els altres li fan lloc. Quan allibereu el botó esquerre del ratolí, el caixetí pren el seu nou lloc a la llista.";
$pgv_lang["rss_feed_help"]	= "~#pgv_lang[rss_feeds]#~<br /><br />Els fils RSS disponibles a PhpGedView us permeten veure el contingut principal de la pàgina d'inici des del vostre agregador (programa lector de fils, generalment incorporat al navegador) preferit, sense que us calgui visitar el lloc. La majoria d'agregadors us avisen quan quelcom ha canviat a la pàgina Índex. Això us permet monitoritzar un lloc PhpGedView sense que necessitat d'entrar-hi regularment.<br /><br />Al bloc de Fils RSS podeu personalitzar l'enllaç a la font i especificar el tipus (atès que molts lectors poden entendre's amb la majoria de tipus, podeu deixar-ho amb la configuració per defecte), i el mòdul específic que voleu al vostre fil. L'idioma del fil i del GEDCOM serà el que tingueu actiu al moment de seleccionar-lo.<br /><br />Els tipus de fils que es poden generar inclouen RSS 0.92, RSS 1.0, RSS 2.0, ATOM 1.0, ATOM 0.3, HTML i JavaScript. Els 5 primers son per a agregadors, mentre que JavaScript i HTML estan destinats a la inclusió de fils en altres pàgines web. Tingueu present que les diverses versions de números de fils RSS equivalen a diferents estils, no pas a diferents versions.<br /><br />Hi ha una opció per seleccionar la forma d'autenticació que permet a l'usuari la connexió per accedir, mitjançant un agregador, a qualsevol informació que disposaria en una connexió directe. La Autenticació Bàsica fa servir &quot;Basic HTTP Authentication&quot; per connectar. Futures ampliacions permetran la &quot;Digest Authentication&quot;.<br /><br />Aquest <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b> article Wikipedia</b></a> conté informació i enllaços sobre RSS i llur diversos formats. <i>La Autenticació Bàsica HTTP</i> es detalla en aquest <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='article Wikipedia' title='article Wikipedia'><b>article Wikipedia</b></a>, mentre que <i>la Autenticació Digest</i> pot veure's en aquest <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='article Wikipedia' title='article Wikipedia'><b>article Wikipedia</b></a>.";

$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Seleccioneu els fitxers del vostre ordinador a carregar al servidor. Tots els fitxers col·locaran al directori <b>#MEDIA_DIRECTORY#</b> o a un dels seus sotsdirectoris.<br /><br />Els noms de carpeta que especifiqueu s'afegiran a <b>#MEDIA_DIRECTORY#</b>. Per exemple, <b>#MEDIA_DIRECTORY#lamevafamilia</b>. Si el directori de miniatures no existeix, es crearà automàticament.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />La configuració del GEDCOM permet fins a #GLOBALS[MEDIA_DIRECTORY_LEVELS]# nivells de carpetes a partir de la bàsica <b>#GLOBALS[MEDIA_DIRECTORY]#</b> on s'hi emmagatzemen habitualment els fitxers multimèdia. Això facilita la seva organització i no cal que necessàriament tots els fitxers tinguin noms diferents.<br /><br />En aquest camp especifiqueu el directori de destí al servidor on serà emmagatzemat el fitxer que carregeu. Atenció a les minúscules i majúscules que entreu o seleccioneu aquí doncs, els nom de fitxers i directoris, discriminen per aquesta propietat.<br /><br />Si el directori que entreu no existeix, es crearà automàticament. Si entreu més subdirectoris que els #GLOBALS[MEDIA_DIRECTORY_LEVELS]# addicionals permesos, la vostra entrada quedarà convenientment truncada.<br /><br />Les miniatures es poden carregar o crear dins d'una estructura de directoris idèntica començant amb <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />En aquest camp especifiqueu la localització i nom, al vostre ordinador, del fitxer multimèdia que voleu carregar al servidor. Podeu emprar el botó <b>Cercar</b> per localitzar-lo.<br /><br />El fitxer carregat tindrà el mateix nom al servidor i es dipositarà al directori especificat al camp <b>#pgv_lang[folder]#</b>.<br /><br />Si no veieu aquest camp o no podeu canviar-lo, és que la configuració del GEDCOM s'ha fet de forma que no hi hagi nivells de carpetes per sota de <b>#GLOBALS[MEDIA_DIRECTORY]#</b> on s'emmagatzemen normalment els fitxers multimèdia.";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />En aquest camp especifiqueu la localització i nom, al vostre ordinador, del fitxer multimèdia que voleu carregar al servidor. Podeu emprar el botó <b>Cercar</b> per localitzar-lo. Quan ompliu aquest camp s'ignora el caixetí <b>#pgv_lang[auto_thumbnail]#</b>.<br /><br />Si el camp <b>#pgv_lang[media_file]#</b> s'ha omplert, el fitxer de miniatures que carregueu s'anomenarà d'acord al contingut d'aquest camp i si no s'ha omplert s'anomenarà igual que al vostre ordinador. Si el camp és buit, el fitxer de miniatura carregat serà copiat dos cops al servidor: un al directori esmentat al camp <b>#pgv_lang[folder]#</b> i l'altre dins d'una estructura idèntica de directoris començant amb <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Si no podeu veure el camp <b>#pgv_lang[folder]#</b> o no podeu canviar-lo, vol dir que el GEDCOM s'ha configurat per no permetre subdirectoris a partir del <b>#GLOBALS[MEDIA_DIRECTORY]#</b> on els fitxers multimèdia s'emmagatzemen normalment.";


//-- GENERAL
$pgv_lang["help_header"]			= "Informació sobre:";
$pgv_lang["privacy_error_help"]		= "~INFORMACIÓ PRIVADA~<br /><br />Hi ha diverses possibles raons per a aquest missatge:<br /><ul><li><b>La informació sobre les persones vives s'estableix en \"Privat\"</b><br />Els visitants i usuaris registrats que no hagin iniciat la sessió només poden veure la informació completa per a les persones mortes. Si l'administrador del sistema ho permet, els visitants poden registrar-se en un compte fent clic al botó Iniciar sessió i, a continuació, a l'enllaç #pgv_lang[requestaccount]#.</li><li><b>Sou un usuari amb nom d'usuari i contrasenya...</b><br />Però no heu iniciat la sessió correctament o heu estat inactiu durant un temps i la vostra sessió ha esgotat el temps d'espera.</li><li><b>A causa de la privadesa</b><br />La persona no vol mostrar-se en absolut (Oculta) i és possible que hagi demanat a l'administrador que el defineixi com a \"Privat\". La privadesa es pot establir en:<ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Fora de \"Camí de relació\"</b><br />Fins i tot si sou usuari normal <u>i</u> heu iniciat la sessió, pot passar que vegeu aquest missatge si la persona que que proveu de veure no està relacionat amb vosaltres dins del nombre de passos de relació (longitud del camí de relació) establerts per l'administrador del lloc per a aquest GEDCOM.<br /><br />Exemples:<br />Quan s'estableix la longitud del camí de relació a <b>1</b>, només podeu veure els detalls de la vostra pròpia família, pare, mare, germà, germana (però no els cònjuges i fills del vostre germà o germana)<br /><br />Quan el camí de la relació està establert a <b>2</b>, també podeu veure els detalls de la dona del vostre germà i dels seus fills (però no dels cònjuges dels seus fills).<br /><br />Com més alta sigui la relació Configuració de la longitud del camí, els parents més remots que podeu veure.</li></ul><br />Si creieu que podeu obtenir determinats detalls ocults, poseu-vos en contacte amb l'administrador. Utilitzeu l'enllaç de contacte de qualsevol pàgina.";
$pgv_lang["more_help"]				= "Hi ha disponible ajuda contextual a cada pantalla. Cal assegurar-vos que l'opció <b>#pgv_lang[show_context_help]#</b> del menú d'ajuda és activa i polsar l'interrogant <b>?</b> del costat de cada entrada.";
$pgv_lang["start_admin_help"]			= "+++ Inici d'Informació extra d'Administració +++";
$pgv_lang["end_admin_help"]			= "--- Fi d'informació extra d'Administració ---";
$pgv_lang["multiple_help"]			= "<span class='center'>--- Aquest és un text general d'ajuda per a múltiples pàgines ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>INFORMACIÓ GENERAL</b></div>";
$pgv_lang["best_display_help"]			= "~#pgv_lang[resolution]#~<br /><br />PhpGedView és dissenyada per a una resolució de 1024x768 píxels. És la mida mínima per a veure-ho tot correctament.<br /><br />Si teniu una resolució menor (per exemple 800x600), us caldrà fer córrer les barres de desplaçament horitzontal a algunes pàgines.";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br /><br />Si feu clic <b>#pgv_lang[print_preview]#</b>, s'eliminaran els elements que no es veuen bé en una pàgina impresa (menús, quadres d'entrada, enllaços addicionals, els signes d'interrogació per a l'ajuda contextual, etc.)<br /><br />Tindreu un botó <b>#pgv_lang[print]#</b> a la part inferior de la pàgina simplificada; quan feu clic a aquest botó apareixerà el diàleg d'impressió del vostre sistema. Després d'imprimir, feu clic <b>#pgv_lang[cancel_preview]#</b> i la pantalla es reconstruirà amb normalitat.<br /><br />Nota: encara que aquesta opció elimina molts enllaços de la pàgina que es mostra, els enllaços restants encara estan actius.";
$pgv_lang["readme_help"]			= "Llegiu <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> per més informació.";
$pgv_lang["is_user_help"]			= "--- Aquesta ajuda és la mateixa que poden llegir els visitants. ---<br />--- Per estalviar espai no hem fet un text especial per a l'administrador en aquesta entrada. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Polsant aquest enllaç s'obre una nova finestra amb les dades primàries del GEDCOM corresponents a aquesta pàgina.<br /><br />Així podeu editar-les directament. Però ull! cal assegurar-vos que entreu dades vàlides GEDCOM 5.5.1 doncs no es fan comprovacions. El que es canviï o afegeixi es veurà al PhpGedView com \"canvis\" i cal que sigui revisat i acceptat prèviament per un administrador, abans que passi a definitiu.";
$pgv_lang["RESN_help_title"]		= "Configuració de restriccions en esdeveniments";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />A banda dels paràmetres generals de privadesa, el PhpGedView té la possibilitat de posar restriccions per veure o editar informació d'esdeveniments corresponents a persones o famílies. Les pot posar qualsevol que tingui atribucions per editar informació, excepte que restriccions de privadesa o prèvies ho impedeixin.<br /><br />Poden posar-s'hi els següents valors:<br /><ul><li><b>#pgv_lang[none]#</b><br />Administradors del lloc, Administrador del GEDCOM i usuaris amb atribucions per a editar i canviar informació. La informació relativa a esdeveniments pot veure's d'acord als paràmetres de privadesa aplicats per l'administrador.</li><li><b>#pgv_lang[locked]#</b><br />Aquest paràmetre no afecta la visualització de les dades de l'esdeveniment. Restringeix els drets d'editar als administradors del lloc i del GEDCOM. Però si la informació es refereix al propi usuari, podrà veure-la i editar-la.</li><li><b>#pgv_lang[privacy]#</b><br />Els administradors del lloc i del GEDCOM poden veure i editar informació. Però si es refereix al propi usuari, llavors podrà veure-la i editar-la. Restarà oculta a la resta d'usuaris, amb accés o sense.</li><li><b>#pgv_lang[confidential]#</b><br />Solament els administradors del lloc i del GEDCOM poden veure i editar la informació que restarà oculta a la resta d'usuaris, independentment de que hagin accedit o no.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Propietari</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Altres</th></tr><tr><th></th><th></th><th>L</th><th>E</th><th></th><th>L</th><th>E</th><th></th><th>L</th><th>E</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : pot llegir</li><li>E : pot editar</li><li><img src=\"images/checked_qm.gif\" alt=\"\"/> : depèn dels paràmetres de privadesa globals</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~#pgv_lang[welcome_page]#~<br /><br />La pàgina d'inici us introdueix al fitxer <a href=\"#def_gedcom\">GEDCOM</a> actiu. Sempre hi podeu tornar polsant Inici al menú de la part superior de cada pàgina. Si en aquest lloc hi ha més d'un GEDCOM, podeu triar a quin anar. Aquesta d'ajuda conté informació sobre:<ul><li><a href=\"#index_portal\"><b>Inici</b></a></li><li><a href=\"#header\"><b>Àrea d'encapçalament</b></a></li><li><a href=\"#menu\"><b>Menús</b></a></li><li><a href=\"#header_general\"><b>Informació general</b></a></li><li><a href=\"#def\"><b>Definicions</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class='name_head center'><b>ÀREA DE CAPÇALERA</b></div><br />La capçalera surt al capdamunt de cada pàgina. Conté enllaços útils que podeu utilitzar arreu del lloc.<br /><br />Com que les pàgines poden tenir diferent aparença depenent de la <a href=\"#def_theme\">presentació</a>, les capçaleres poden veure's afectades i els enllaços variar.<br /><br />Els enllaços que hi podeu trobar son:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />És petit però potent. Permet posar PhpGedView a buscar coses. Si polseu el botó <b>&gt;</b> o <b>Cercar</b>, us mena directament a la pàgina de recerca per veure-hi els resultats de la consulta. Podeu trobar més ajuda sobre les diferents opcions a la pròpia pàgina de recerca.";
$pgv_lang["header_lang_select_help"]		= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />Una de les característiques més importants del PhpGedView és que suporta múltiples idiomes.<br /><br />L'idioma amb el que s'escriu cada pàgina es determina automàticament d'acord amb el de les Preferències d'Idioma definides al vostre navegador. Tanmateix els administradors poden limitar la disponibilitat d'alguns idiomes.<br /><br />Depenent de la configuració del lloc, podreu optar (o no) a canviar l'idioma des d'un menú desplegable o polsant una banderola. Un cop hagin accedit, els usuaris enregistrats poden configurar el PhpGedView per canviar l'idioma preferit.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />Son un petit bloc amb enllaços pràctics que es localitzen al mateix lloc de cada pàgina. La situació varia segons la presentació escollida.<br /><br />Mentre no hagueu accedit, solament podeu veure l'enllaç <b>Accés</b>. Desprès de fer-ho, podreu veure-hi:<ul><li><b>Heu accedit com a (nom d'usuari)</b>. Polsant-lo us mena a la pàgina del vostre compte.</li><li>Polseu <b>Surt</b> per desconnectar-vos.</li><li>Si teniu atribucions d'administrador també podeu veure-hi <b>Administrar</b>. Us mena directament a la pàgina principal d'administració.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />És una finestra desplegable que us mostra els favorits que heu seleccionat al portal personal (MyGedView). També hi veureu els favorits del GEDCOM actiu, que l'administrador del lloc ha escollit. Polsant un dels favorits us menarà directament a la pàgina #pgv_lang[indi_info]# de la persona corresponent.<br /><br />Disposeu d'ajuda per afegir favorits al portal MyGedView.";
$pgv_lang["header_theme_help"]		= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Si l'Administrador l'ha activat, aquesta llista desplegable us ofereix diversos formats de presentació que podeu emprar per visionar les pàgines d'aquest lloc.<br /><br />En altres paraules: us permet canviar l'aparença del lloc, seleccionant un tema diferent. Un cop hagueu accedit també us permet canviar la presentació personalitzada per una altra que es visualitzarà el proper cop que accediu.";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENÚS</b></div><br />Les capçaleres de pàgina tenen menús desplegables associats a cada icona.<br /><br />Passant el ratolí per sobre d'elles surt un sotsmenú. Polsant directament la icona aneu a parar a la seva primera entrada.<br /><br />Generalment hi ha disponibles els següents sotsmenús:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />En aquest menú hi apareixen les bases de dades genealògiques disponibles. Cada una té la seva pròpia pàgina d'inici personalitzada. Si solament hi ha una única base de dades, no es desplegarà cap sotsmenú sota la icona d'Inici.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Si heu accedit, aquest menú pot incloure les següents entrades:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Mena a la pàgina personalitzada o Portal My GedView.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Permet editar les dades personals com a usuari enregistrat.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Mena a l'arbre genealògic familiar, començant per la persona que hagueu seleccionat prèviament.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Mena a la pàgina #pgv_lang[indi_info]# on apareixen les vostres pròpies dades genealògiques i les de la vostra família.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />Els disponibles son:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Mostra l'arbre genealògic del fitxer GEDCOM actiu i que parteix de la persona configurada per l'administrador. En canvi, un cop heu accedit ho fa per la que hagueu configurat a les opcions del compte d'usuari.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />El diagrama de descendents és bàsicament un <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> en ordre invers. No és exactament això però, mentre l'arbre genealògic mostra tots els avantpassats d'una persona inicial, el diagrama de descendents mostra els d'aquesta mateixa persona.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Aquí podeu veure-hi els esdeveniments ocorreguts a una persona al llarg dels anys. És interessant comparar-los amb els d'una altra o més persones durant el mateix període.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Permet buscar el grau de parentiu d'una persona determinada respecte d'un mateix o d'una altra.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />és força semblant a <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, però amb més detalls i pantalla <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> alternativa.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Aquest és molt semblant a <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, però d'una forma més gràfica.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Hi ha disponibles les següents:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />Es tracta de dues llistes per cercar alfabèticament les persones o famílies d'aquest GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Aquesta entrada retorna un llistat amb tots els registres emprats al GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Aquí podeu cercar gent per llocs.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Aquesta entrada de menú solament es veu si l'ha activada l'administrador. Hi surten enllaços cap a tots els fitxers multimèdia del GEDCOM.</li></ul>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />El #pgv_lang[anniversary_calendar]# mostra els esdeveniments del GEDCOM per a una data determinada, més o any.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Aquestes entrades us menaran al #pgv_lang[anniversary_calendar]# per veure una llista de tots els esdeveniments ocorreguts el dia, mes o any escollits.</li></ul>";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]#~<br /><br />Aquesta entrada a la barra del menú, surt solament si l'administrador a activat l'opció.<br /><br />El #pgv_lang[clip_cart]# permet emmagatzemar informació sobre persones, famílies i fonts en un fitxer temporal que podeu descarregar posteriorment en format GEDCOM 5.5.1.";
$pgv_lang["menu_search_help"]			= "~#pgv_lang[search]#~<br /><br />La pàgina de recerca a la base de dades és una versió més potent que el caixetí de recerca que hi ha a la capçalera de cada pàgina.";
$pgv_lang["menu_help_help"]			= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>PÀGINA D'INICI</b></div>";
$pgv_lang["index_portal_help"]			= "La pàgina d'Inici consisteix en diversos blocs separats que podeu personalitzar. A llocs on hi hagi diverses bases de dades genealògiques, podeu veure-hi diferents pàgines d'inici per a cada una. Depenent de com l'administrador hagi configurat el lloc, apareixeran els següents blocs:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Mostra el títol de la base de dades activa, dia i hora i, si ho ha activat l'administrador, el comptador.<br /><br />El comptador solament és disponible aquí i a la pàgina #pgv_lang[indi_info]#. Controla els \"accessos\" a aquestes pàgines per conèixer quantes vegades han estat visitades. No controla les adreces d'Internet dels visitants, cada visita a una pàgina per part d'<u>alguna</u> adreça remota, compta com una de nova.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />L'accés podeu fer-lo des de quasi totes les pàgines del programa. El normal és fer-ho a la primera pàgina doncs, solament podeu disposar de tota la informació un cop hagueu accedit.<br /><br />Per a fer-ho cal escriure el <b>nom d'usuari</b> i la <b>contrasenya</b> i polsar el botó <b>#pgv_lang[login]#</b>.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Mostra els esdeveniments quin aniversari es commemorarà properament.<br /><br />L'administrador decideix quin lapse de temps sortirà en aquest bloc. Mitjançant certes opcions de configuració podeu fer-hi alguns retocs.";
$pgv_lang["todo_help"] = "~#pgv_lang[todo_block]#~<br /><br />Aquest bloc us ajuda a fer un seguiment de les tasques <b>_TODO</b> de la base de dades.<br /><br />Per afegir tasques pendents als vostres registres, primerament us caldrà canviar la configuració del GEDCOM a fi de que l'esdeveniment <b>_TODO</b> figuri a la llista d'esdeveniments que podeu afegir als registres de persones, famílies, fonts i arxius. Cadascuna d'aquestes llistes, que es troba a la secció Opcions d'edició de la configuració de GEDCOM, és independent. L'ordre de la llista d'entrades no és important, podeu afegir noves entrades al començament de cada llista.";
$pgv_lang["todo_show_other_help"]     = "Mostra tasques assignades a d'altres usuaris";
$pgv_lang["todo_show_unassigned_help"]= "Mostra tasques que no hagin sigut assignades a cap usuari";
$pgv_lang["todo_show_future_help"]= "Mostra tasques que tinguin data futura. Altrament solament es mostraran els ítems amb data vençuda.";
$pgv_lang["yahrzeit_help"]			="~#pgv_lang[yahrzeit_block]#~<br /><br />Aquest bloc mostra els vostres Yahrzeiten que s'esdevindran properament.<br /><br />Yahrzeiten (singular: Yahrzeit) son aniversaris de difunts. S'observen en la tradició jueva i, en general, no tant en altres tradicions. «Yahrzeit» també s'anomena «Jahrzeit» o «Yartzeit».<br /><br />L'administrador determina l'antelació que mostrarà el bloc. Podeu reajustar aquest paràmetre mitjançant les opcions de configuració.";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Entreu el nombre de dies a veure. No pot ésser major de <b>#DAYS_TO_SHOW_LIMIT#</b>. Si en poseu més, es farà servir aquest valor.<br /><br />El límit el posa l'administrador en configurar el GEDCOM, Secció Visualització i presentació, Sotssecció Amagar &amp; Mostrar.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Aquesta opció permet triar quin tipus de multimèdia voleu veure.<br /><br />Quan seleccioneu <b>#pgv_lang[random_media_persons]#</b>, solament veureu fitxers associats a persones, que normalment seran retrats. Quan escolliu <b>#pgv_lang[random_media_events]#</b>, el que veureu seran fitxers associats amb esdeveniments. Per exemple, la reproducció d'un certificat. Si opteu per <b>#pgv_lang[all]#</b>, veureu fitxers de tota mena.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />Podeu restringir el que hi ha permès veure a Fitxer a l'Atzar en funció del format i tipus de l'ítem multimèdia. Quan es marca una entrada el bloc permet mostrar les d'aquest format i tipus.<br /><br />Els format i tipus que existeixin a la vostra base de dades, però que no figurin a aquesta llista de marcatge, es consideraran com marcats per veure's. Per exemple, si la vostra base de dades conté objectes de format <b><i>pdf</i></b>, al bloc de Fitxer a l'Atzar sempre es permetrà mostrar-los. De forma similar, si a la base de dades conté objectes de tipus  <b><i>especial</i></b>, també sempre es permetrà veure'ls.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Aquesta opció us permet rebutjar alguns esdeveniments. Per exemple, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. Cal que tots tinguin data.<br /><br />Si seleccioneu <b>Si</b>, solament veureu els natalicis, òbits i casoris. Si poseu <b>No</b>, veureu tots els esdeveniments datats.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Aquesta opció controla com es presenta la informació.<br /><br />Quan seleccioneu <b>#pgv_lang[style1]#</b>, es presenta en format de text, semblant al que podeu veure als caixetins dels gràfics. Aquest format és seguit de blocs que apareixen a la dreta de la pàgina.<br /><br />Quan escolliu <b>#pgv_lang[style2]#</b>, es presenta en format tabular i és seguit de blocs allargassats que apareixen a l'esquerra de la pàgina.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Aquesta opció controla com s'ordena la informació.<br /><br />Quan seleccioneu  <b>#pgv_lang[by_alpha]#</b>, la informació es mostra per ordre alfebètic. Si seleccioneu <b>#pgv_lang[by_anniv]#</b>, s'ordena per aniversari, començant pels més recents.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Aquesta opció controla si el botó per descarregar el calendari d'esdeveniments es mostra o no als usuaris amb accés. El fitxer de calendari pot importar-se a programes compatibles com Microsoft Outlook per incorporar-lo al seu calendari o, posem per cas, generar correus electrònics automàtics recordatoris d'aniversaris.<br /><br />Quan el poseu a <b>#pgv_lang[no]#</b>, l'usuari amb accés no podrà descarregar el fitxer. Si el poseu a <b>#pgv_lang[yes]#</b>, veurà el botó i podrà baixar-se el calendari. Aquest botó no el veuran mai els usuaris sense accés.";
$pgv_lang["cal_download_user_help"]			= "Si heu iniciat la sessió, és possible que vegeu la icona <img src='images/ical.png' alt='' />. Si feu clic a la icona, baixareu els esdeveniments com a fitxer de calendari, que es pot importar a programes compatibles com Microsoft Outlook per, per exemple, generar recordatoris automàtics d'aniversaris per correu electrònic.<br /><br />Si heu iniciat la sessió i no veieu aquesta icona, l'administrador ha desactivat aquesta funció. Els visitants que no hagin iniciat la sessió no veuran aquesta icona i no poden descarregar el fitxer Calendar.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br /><br />Aquest bloc permet que l'arbre genealògic, els diagrames de descendents o rellotge de sorra, surtin a la pàgina d'inici o al MyGedView. Degut a limitacions d'espai els gràfics han de posar-se únicament a l'esquerra de la pàgina.<br /><br />Quan aquest bloc surt a la pàgina d'inici, la persona arrel i el tipus de gràfic els determina l'administrador. Quan ho fan a la pàgina personalitzada MyGedView, és l'usuari qui les determina.<br /><br />El funcionament aquí és idèntic que quan es criden dels del menús. Polsant el caixetí d'una persona per veure'n més detall.";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[todays_events_block]#~<br /><br />És semblant al de #pgv_lang[upcoming_events_block]#, però mostra solament els corresponents a avui.";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Aquest bloc és molt similar al bloc #pgv_lang[user_favorites_block]# de la pàgina #pgv_lang[mygedview]#. Solament que aquí només l'administrador o un usuari amb atribucions pot canviar la llista de persones favorites que hi sortiran.<br /><br />L’objectiu d’aquest bloc és cridar l’atenció del visitant sobre persones d’interès especial. La selecció dels favorits d'aquest GEDCOM també podeu fer-la des d'una finestra desplegable a la capçalera de cada pgina.<br /><br />Quan en polseu un, us mena a la pàgina #pgv_lang[indi_info]# de la persona escollida.";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br /><br />Aquest formulari us permet afegir una nova entrada a la vostra llista personal de favorits.<br /><br />Cal que hi entreu un ID de persona, família o font o un URL i el títol. El camp per a notes és opcional i podeu emprar-lo per descriure el favorit. El que hi escrigueu es veurà al bloc favorits, al costat de l'entrada corresponent.";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats_block]#~<br /><br />S'hi presenten dades estadístiques sobre el GEDCOM actiu. Si us cal més informació de la que hi surt, envieu un correu electrònic a la persona de contacte prevista a cada peu de pàgina.";
$pgv_lang["index_common_names_help"]		= "~#pgv_lang[block_top10]#~<br /><br />Aquest bloc us mostra una llista amb els cognoms més repetits a la base de dades. Un cognom ha de repetir-se #COMMON_NAMES_THRESHOLD# cops abans d'aparèixer aquí. És l'administrador qui decideix aquesta quantitat.<br /><br />Quan polseu un cognom de la llista, us mena a #pgv_lang[individual_list]#, on disposeu de més detalls sobre el nom.";
$pgv_lang["index_common_given_names_help"]		= "~#pgv_lang[block_givn_top10]#~<br /><br />Aquest bloc mostra un llista dels noms de pila més comuns o freqüents a la base de dades. Podeu configurar quans noms voleu que hi surtin.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />Aquí el PhpGedView, de forma aleatòria, escull un fitxer multimèdia per mostrar-lo a cada nova visita a la pagina.<br /><br />Si polseu la imatge, veureu la versió a mida real. Sota seu hi ha un enllaç vers la persona, família o font amb la que està relacionada. Quan polseu sobre la superfície de la imatge es veu reproduïda a la pàgina #pgv_lang[media_list]#. Quan polseu el nom de la persona, família o font, us mena a la seva pàgina #pgv_lang[indi_info]#.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Mostra els usuaris que estan visitant el lloc web.<br /><br />Si no sou administrador, la llista d'usuaris amb accés, és restringida a aquells que han optat per deixar-se veure. Podeu escollir restar visible als altres un cop hagueu fet l'accés, o no. Els usuaris invisibles que han accedit, compten com anònims.";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br /><br />Aquesta secció és com un tauler d'anuncis del GEDCOM. L'administrador pot posar-hi avisos importants o notícies interessants.<br /><br />Si teniu quelcom a dir-hi, contacteu amb l'administrador que hi posarà un missatge per compte vostre.";
$pgv_lang["recent_changes_help"]			= "~#pgv_lang[recent_changes_block]#~<br /><br />Us mostra els canvis més recents del GEDCOM tal i com recull l'etiqueta CHAN GEDCOM.";
$pgv_lang["gedcom_news_limit_help"]		= "És possible limitar el nombre de notícies a veure per reduir l'alçada del bloc.<br /><br />Aquesta opció determina si hi haurà límits i si es posen d'acord amb l'antiguitat o el nombre de notícies.";
$pgv_lang["gedcom_news_flag_help"]		= "Entreu el límit aquí.<br /><br />Si heu optat per limitar el nombre d'articles segons l'antiguitat no en mostrarà cap amb data anterior al nombre de dies fixats. Si heu optat per limitar el nombre, solament es veuran els més nous fins al nombre fixat, ordenats per antiguitat. La resta d'articles restaran ocults.<br /><br />Si hi entreu zeros es desactiva el límit i es veuran tots.";
$pgv_lang["gedcom_news_archive_help"]	= "Per a reduir l'alçada del bloc de Notícies, l'administrador ha fet que s'amaguessin alguns articles. Podeu veure'ls polsant a l'enllaç <b>#pgv_lang[gedcom_news_archive]#</b>.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Aquest bloc permet a l'administrador afegir informació a la pàgina Índex o Portal. La finalitat és semblant que la dels blocs HTML, Notícies i Estadístiques GEDCOM, però aquí l'administrador té més control sobre la presentació.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />Aquest text ha de restar en blanc o ésser molt breu. Si el deixeu en blanc, el bloc HTML avançat es veurà a les pàgines Índex o Portal com un bloc senzill, tal com ho és el bloc HTML. Si hi ha text, es veurà com la resta de blocs amb una barra amb el text entrat aquí, com a títol.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Per ajudar a introduir-vos en aquest bloc, hem creat alguns patrons. Si en seleccioneu un, l'àrea de text contindrà una còpia de l'original que podreu modificar d'acord amb els requeriments del lloc.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />A diferència dels blocs HTML, Notícies i Estadístiques GEDCOM, teniu control absolut sobre l'aparença d'aquest bloc. Podeu fer servir etiquetes HTML i també fulls d'estil CSS, de la presentació activa. El text pot contenir referències a informació de la base de dades genealògica activa.<br /><br />Aquestes referències es senyalen al text tancant les paraules dins d'un parell de <b>&#35;</b>. Per exemple, <b>&#35;totalFamilies&#35;</b> representa el nombre de famílies a la base de dades. En ocasions caldrà emprar aquestes referències com a text per comptes del seu verdader significat. Per fer-ho cal substituir els <b>&#35;</b> pel seu símbol equivalent. Per exemple, si el text conté <b>&&#35;35;totalFamilies&&#35;35;</b> sortirà com <b>&#35;totalFamilies&#35;</b> per comptes convertir-se en una referència de la base de dades.<br /><br />Per a un complet exemple de com emprar aquest bloc mireu-vos el patró &quot;#pgv_lang[gedcom_stats_block]#&quot; de la carpeta blocks/. Fa servir molts estils d'etiqueta incloent-hi enllaços a idiomes i textos d'ajuda.<br /><br />Per a veure totes les etiquetes disponibles polseu aquest botó &quot;<b><a href=\"javascript:;\" onclick=\"window.open('index.php?mod=gedstats&method=tagList', '_blank', 'top=50,left=10,width=600,height=600,scrollbars=1,resizable=1');\">#pgv_lang[htmlplus_block_taglist]#</a></b>&quot;.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Activa la compatibilitat amb versions antigues d'aquest bloc. Quan està marcat reconeixerà tant les antigues com les noves paraules clau.<br /><br />Per exemple, el text <b>&#35;TOTAL_FAM&#35;</b> es reconeixerà com a equivalent a <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> a <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> a <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />Si no és absolutament necessari, no feu servir el mode de compatibilitat.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Seleccioneu la base de dades a la que aplicar les paraules clau.<br /><br />Els vostre lloc suporta diverses bases de dades. Paraules clau com <b>&#35;totalFamilies&#35;</b> han de referir-se solament a una d'elles. Heu d'identificar la base de dades que serà consultada per a totes aquestes paraules. Cada bloc #pgv_lang[htmlplus_block_name]# solament pot accedir una base de dades.";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br /><br /> Amaga o mostra la llista de noms de persones de sexe desconegut.<br /><br /> El bloc #pgv_lang[block_givn_top10]# bloc sempre s'amaga la llista de noms quan hi ha persones amb aquesta situació a la base de dades. Aquesta opció permet amagar la llista de les persones de sexe desconegut, fins i tot quan existeixen aquests cassos a la vostra base de dades.<br /> ";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Es obvi que l'ideal seria crear un programa tant senzill i fàcil d'usar que no li calguessin explicacions enlloc: talment com llegir un llibre.<br /><br />El PhpGedView no és gens complicat i d'altra banda, força intuïtiu. Quasi tot pot fer-se córrer sense cap mena d'explicació. Però atès que podem tenir visitants i usuaris poc experimentats en l'ús de l'ordinador i d'Internet, oferim una mica d'ajuda a alguns llocs.<br /><br />Al menú d'ajuda podeu trobar-hi les següents entrades:";
$pgv_lang["help_page_help"]			= "<ul><li><b>Ajuda per aquesta pàgina</b><br />A totes les pàgines hi ha disponible una \"Ajuda\" general. Podeu polsar aquesta entrada del menú per veure un \"Text d'Ajuda\", que explica el sentit de cada una de les entrades que conté la pròpia pàgina.<br /><br />És necessàriament breu. Però si us cal més ajuda o informació podeu fer servir l'\"Ajuda Contextualitzada\".</li></ul>";
$pgv_lang["help_content_help"]		= "<ul><li><b>Índex d'ajuda</b><br />Quan polseu aquesta entrada del menú, disposeu d'una pàgina d'ajuda amb una llista de la majoria de temes. El volum d'informació d'ajuda disponible anirà augmentant a mesura que el temps ho permeti.</li></ul>";
$pgv_lang["help_faq_help"]			= "<ul><li><b>Llistat preguntes més freqüents</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]			= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]			= "<ul><li><b>Amagar / Mostrar ajuda contextual</b><br />Aquesta darrera entrada del menú pot resultar la més útil. Polsant aquest enllaç podeu activar o desactivar l'\"Ajuda Contextual\".<br /><br />Activada, surt una icona d'interrogació al costat d'alguns enllaços, finestres desplegables o botons. Polsant-lo emergeix una finestra d'ajuda que conté informació sobre l'objecte en qüestió.<br /><br />Naturalment, quan polseu \"Amagar ajuda contextual\", tots els interrogants desapareixen fins que no toneu a polsar \"Mostrar...\" de nou.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Heus aquí algunes explicacions de termes emprats en aquest text d'ajuda:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>format de fitxer PDF</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Presentació</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Portal~<br /><br />El portal d'aquest lloc és com el cancell d'una biblioteca pública. És a l'entrada però podeu trobar-hi important informació com explicacions, menús, etc.";
$pgv_lang["def_gedcom_help"]			= "~Fitxer GEDCOM~<br /><br />Una qüestió prèvia sobre l'estàndard GEDCOM 5.5.1:<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Versió en català:<div class=\"list_value_wrap\">El GEDCOM ha estat desenvolupat pel Departament d'Història Familiar de l'Església de Jesucrist dels Sants dels Últims Dies (Església SUD), per disposar d'un format uniforme i flexible d'intercanvi de dades genealògiques informatitzades.&nbsp; GEDCOM és l'acrònim de <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (Comunicació genealògica de dades).&nbsp; Llur propòsit és el foment de l'intercanvi de dades genealògiques i el desenvolupament d'un ample ventall de programari per ajudar els genealogistes, historiadors i altres investigadors.</div><br />Una còpia <u>resumida</u> de l'estàndard GEDCOM 5.5.1, a la que PhpGedView s'ha adherit, podeu descarregar-la en format PDF d'aquí:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">Estàndard GEDCOM 5.5.1</a> Solament en anglès.<br /><br />El fitxer GEDCOM conté tota la informació sobre la família.&nbsp; Tots els esdeveniments, dates, etc. s'hi emmagatzemen.&nbsp; Els fitxers GEDCOM han de seguir regles estrictes a fi de que siguin intercanviables entre diferents programes, independentment de llur plataforma o sistema operatiu.";
$pgv_lang["def_gedcom_date_help"]		= "~Les dates del fitxer GEDCOM~<br /><br />Malgrat que el camp data us permet entrar-lo com us sembli, hi ha unes regles de com posar-les d'acord amb l'estàndard GEDCOM 5.5.1.<ul><li>La data complerta s'entra amb aquest format DD MMM AAAA. Per exemple, <b>01&nbsp;Mar&nbsp;1801</b> o <b>14&nbsp;Dec&nbsp;1950</b>.</li><li>Si no teniu la data completa podeu ometre el que desconeixeu.  Exemple: <b>Mar&nbsp;1801</b> o <b>14&nbsp;Dec</b>.</li><li>Si no esteu segur o la data no és confirmada podeu entrar-hi <b>abt&nbsp;Mar&nbsp;1801</b> (abt = cap el), <b>bef&nbsp;20&nbsp;Dec&nbsp;1950</b> (bef = abans), <b>aft&nbsp;1949</b> (aft = desprès)<br /><br /><b>FROM</b> indica que l’esdeveniment que es descriu s’ha produït contínuament entre les dates indicades i s’utilitza amb esdeveniments com la professió. <b>BET</b> indica una ocurrència única de l’esdeveniment, entre les dates indicades i s’utilitza amb esdeveniments com el naixement.<br /><br />Dates imprecises, on es troba el dia del mes o falta el mes, s’interpreten sempre com la primera o l’última data possible, segons si aquesta data imprecisa es produeix abans o després de la paraula clau de separació. Per exemple, <b>FEB&nbsp;1804</b> s’interpreta com a <b>01&nbsp;FEB&nbsp;1804</b> quan es produeix abans del TO o AND, i com a <b>29&nbsp;FEB&nbsp;1804</b> quan es produeix després del TO o AND.</li></ul><br /><b>Assegureu-vos d'entrar les dates i abreujaments en <u>anglès</u>,</b> perquè el fitxer GEDCOM és intercanviable i el PhpGedView ja tradueix les dates i abreujaments correctament a l'idioma actiu. D'altra banda el PhpGedView fa càlculs amb aquestes dates. Si les entreu malament els càlculs fallaran. Podeu polsar la icona de calendari per ajudar-vos a seleccionar-ne una.<br /><br />S'utilitzen les següents abreviatures:<ul><li>JAN = January = gener</li><li>FEB = February = febrer</li><li>MAR = March = març</li><li>APR = April = abril</li><li>MAY = maig</li><li>JUN = June = juny</li><li>JUL = July = juliol</li><li>AUG = August = agost</li><li>SEP = September = setembre</li><li>OCT = October = octubre</li><li>NOV = November = novembre</li><li>DEC = December = desembre</li><li>bef = before = abans</li><li>abt = about = sobre</li><li>aft = after = després</li></ul>";
$pgv_lang["def_gramps_help"]		= "~Fitxer Base de dades XML GRAMPS~<br /><br />Una qüestió prèvia sobre el Projecte GRAMPS: <div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Versió en català:<div class=\"list_value_wrap\">GRAMPS ajuda a seguir el vostre arbre genealògic. Permet emmagatzemar, editar i cercar dades genealògiques. GRAMPS intenta fornir totes les capacitats comuns d'altres programes genealògics però, molt important, amb una capacitat addicional d'integració poc comú en aquests programes. És la facilitat d'entrar trossos o parts d'informació dins de GRAMPS i recomposar/manipular part/totes les dades d'esdeveniments a tota la base de dades (en qualsevol ordre i seqüència) per ajudar l'usuari en la recerca, anàlisi i correlació amb potencial per corregir omissions de parentiu.</div><br />Una còpia del format XML GRAMPS v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">podeu trobar-la aquí</a> tant en format RELAX NG Schema com en DTD.<br /><br />Per a més informació sobre el Projecte GRAMPS visiteu <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br /><br />PhpGedView (o PGV) no és solament posar pàgines estàtiques al Web. És dinàmic i hom pot personalitzar-lo de moltes formes.<br /><br />PhpGedView fou creat per John Finlay per a veure fitxers GEDCOM en línea. John va començar a desenvolupar el programa tot sol. Actualment se l'hi ha afegit un equip internacional de desenvolupadors i traductors, treballant per millorar-lo. Una de les característiques més significatives que s'han implementat al programa és el suport per idiomes diferents de l'anglès i la facilitat per afegir i editar esdeveniments en línea.";
$pgv_lang["def_theme_help"]			= "~Presentació~<br /><br />Aquest lloc pot tenir diferents \"aparences\", anomenades presentacions.<br /><br />L'administrador escull una presentació per defecte que tothom que hi entri al lloc pot veure inicialment. Si a més ha activat aquesta característica, tots els usuaris poden seleccionar la seva pròpia presentació. El PhpGedView recorda la darrera presentació seleccionada per cada usuari que efectua l'accés i així no li cal escollir-la el proper cop que hi torna.<br /><br />Les presentacions també es poden fer servir per a distingir entre diferents bases de dades del mateix lloc. Cada una d'elles en pot tenir una de diferent, per defecte.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br /><br />És la vostra Pàgina personal #pgv_lang[mgv]#.<br /><br />Podeu trobar-hi enllaços per accedir fàcilment a les vostres dades personal com <b>Dades de registre</b>, <b>La meva fitxa</b> (aquesta és la vostra pàgina #pgv_lang[indi_info]#) i <b>El meu arbre</b>. Podeu tenir-hi blocs amb una <b>Bústia</b>, un <b>Dietari</b> (com un bloc de notes) i molt més.<br /><br />El format d'aquesta pàgina es semblant a la d'Inici, la que podeu veure així que accediu al lloc. Però mentre les parts de la pàgina d'Inici les selecciona l'administrador, podeu escollir les que voleu incloure en aquesta i personalitzar-la al vostre gust. Podeu trobar l'enllaç per fer-ho al bloc de benvinguda o separat, quan aquest no és present.<br /><br />Podeu triar entre els següents blocs i enllaços:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Personalitzar «#pgv_lang[mygedview]#»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]		= "~PERSONALITZAR #pgv_lang[mygedview]#~<br /><br />Quan hi entreu per primer cop ja tindreu alguns blocs a la pàgina. Si voleu, podeu canviar-la.<br /><br />Polsant l'enllaç aneu a parar a un formulari que us permet afegir, moure o esborrar blocs. Hi ha explicació de com fer-ho en aquell formulari.";
$pgv_lang["mygedview_message_help"]		= "~#pgv_lang[user_messages_block]#~<br /><br />En aquest bloc podeu trobar-hi missatges enviats per altres usuaris o l'administrador. També podeu enviar-ne.<br /><br />El sistema de correu PhpGedView és dissenyat per protegir la vostra privadesa. No heu de deixar mai la vostra adreça de correu electrònic aquí ni deixar que puguin veure-la.<br /><br />Per expandir un missatge polseu al títol o al símbol \"<b>+</b>\" del costat. Podeu esborrar múltiples missatges marcant els caixetins del costat i polsant el botó <b>Esborrar els missatges seleccionats</b>.";
$pgv_lang["mygedview_favorites_help"]		= "~#pgv_lang[user_favorites_block]#~<br /><br />Els favorits son com ex libris.<br /><br />Suposem que hi ha algú del vostre arbre familiar quin record voleu rememorar regularment. Aneu a la seva pàgina #pgv_lang[indi_info]# i seleccioneu l'opció <b>Afegir als meus favorits</b>. Aquesta persona ha quedat marcada i afegida a la vostra llista de favorits.<br /><br />Sigueu on sigueu d'aquest lloc, podeu polsar el nom a la finestra desplegable \"Favorits\" de la capçalera. Us menarà a la pàgina #pgv_lang[indi_info]# d'aquesta persona.";
$pgv_lang["mygedview_myjournal_help"]		= "~#pgv_lang[user_news_block]#~<br /><br />Podeu fer servir aquest dietari per escriure-hi notes o recordatoris per a ús propi. Quan confeccioneu una nota la tindreu aquí el proper cop que visiteu el lloc.<br /><br />Com que les notes son privades, no poden veure-les els altres usuaris.";
$pgv_lang["mygedview_welcome_help"]		= "~#pgv_lang[welcome_block]#~<br /><br />Aquest bloc us mostra:<ul><li>El fitxer GEDCOM actual</li><li>Data i hora</li><li>Enllaços amb:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Nota:</b><br />Hi podeu veure enllaços a <b>#pgv_lang[my_indi]#</b> i <b>#pgv_lang[my_pedigree]#</b> solament si esteu enregistrat al fitxer GEDCOM actiu. Pot passar que vegeu aquests enllaços en un fitxer en el que hi esteu enregistrat i no us surtin en un que no hi sigueu.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~L'ARBRE GENEALÒGIC~<br /><br />Aquesta pàgina és una enumeració de tots els avantpassats de la persona inicial (arrel). Pels usuaris sense accés, aquesta persona la defineix l'administrador. Els que disposen d'accés poden optar per seleccionar la seva pròpia persona arrel.<br /><br />En aquest context, \"Tots els avantpassats\" vol dir pare i mare, llurs pares i així anar fent. L'arbre es mostra de forma gràfica. No cal barallar-vos a través de pàgines de text per determinar els vostres avantpassats.<br /><br />Totes les persones surten a la pantalla en caixetins individualitzats.<br /><ul><li><b>Caixetins individualitzats</b><br />Si la pàgina s'ha configurat per veure els detalls, hi sortiran les dates de naixement i defunció. Polsant al nom de la persona us mena directament a la seva pàgina #pgv_lang[indi_info]#.<br /><br />També hi ha dues icones dins del caixetí.</li><li><b>Icona d'avantpassats</b><br />Depenent de la configuració del lloc, cal passar-hi per sobre o polsar-la. Quan ho feu apareix un petit submenú.<br /><br />Les entrades <b>#pgv_lang[index_header]#</b> i <b>#pgv_lang[descend_chart]#</b> son semblants que les del menú principal. La diferència rau en que la persona arrel és la del caixetí. També hi surt <b>#pgv_lang[as_spouse]#</b>. Sota la que s'hi veu el nom del cònjuge seguit de la mainada. Podeu polsar tot els noms.</li><li><b>La lupa</b><br />Depenent de la configuració del lloc, cal passar-hi per sobre o polsar-la. Augmenta i apareixen més dates i esdeveniments. Podeu polsar cada nom.</li><li><b>Fletxes</b><br />A la dreta o esquerra dels caixetins hi poden aparèixer fletxes. Polsant-les, la pantalla és desplaça en llur direcció.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]			= "~#pgv_lang[show_details]#~<br /><br />Aquesta opció us permet escollir entre veure o no els detalls dels caixetins. N'hi cabran més si els oculteu.<br /><br />Quan no es veuen, tampoc surt la icona de la lupa però, si l'administrador ha activat aquesta opció, polsant qualsevol punt de l'àrea del caixetí, fa el mateix efecte que la lupa i us deixa veure els detalls de la persona.<br /><br />Quan trieu l'opció de veure els detalls, podeu veure'ls mitjançant la icona de la lupa. Depenent de com estigui configurat el programa, per activar-la, tan pot ser que calgui fer-ho polsant-la com passant-hi per sobre.<br /><br />Si el que us cal és polsar-la, per tornar a la vista normal, heu de tornar a polsar-hi. Si es passant-hi per sobre, torneu a la vista normal quan el punter surt fora de la lupa.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Amb aquesta opció podeu determinar l'orientació del disseny de la pàgina.<br /><br />Canviar aquest paràmetre pot ser útil si voleu fer una impressió de pantalla o si teniu un tipus de pantalla diferent.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;farà que l'arbre sigui més alt, de manera que un gràfic de 4 generacions hauria de cabre en una sola pàgina impresa verticalment.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;crearà un arbre més ampli que s’hauria d’imprimir en una sola pàgina impresa horitzontalment.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;gira el gràfic, però no els seus quadres, 90 graus en sentit antihorari, de manera que la generació més antiga es troba a la part superior del gràfic.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;gira el gràfic, però no els seus quadres, 90 graus en sentit horari, de manera que la generació més antiga es troba a la part inferior del gràfic.</li></ul>";
$pgv_lang["rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Si voleu veure el gràfic començant per una altra persona (arrel), heu d'escriure l'ID d'aquesta persona aquí.<br /><br />Si no sabeu, feu servir l'enllaç <b>Cercar l'ID</b>.<br /><br /><b>NÚMERO ID</b><br />Els números d'identificació ó ID que es fan servir al PhpGedView <u>no</u> son pas els oficials com el del permís de conduir, passaport, etc. L'ID és senzillament, un número que identifica cada persona dins la base de dades i ha sigut assignat pel programa genealògic que ha creat el fitxer GEDCOM importat dins del PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~#pgv_lang[generations]#~<br /><br />Aquí podeu posar-hi el nombre de generacions que voleu veure en aquesta pàgina.<br /><br />El número correcte depèn de la mida de la vostra pantalla i de si voleu veure els detalls personals o no. Els temps de procés augmenta en incrementar el nombre de generacions.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~#pgv_lang[login]#~<br /><br />Aquesta pàgina us permet accedir, demanar una nova contrasenya o permís d'accés.";
$pgv_lang["username_help"]			= "~#pgv_lang[username]#~<br /><br />Escriviu el vostre nom d'usuari en aquest caixetí.<br /><br /><b>És consideren caràcters diferents les majúscules i les minúscules.</b> Això significa que <b>ElMeuNom</b> és <u>diferent</u> de <b>elmeunom</b> o de <b>ELMEUNOM</b>.";
$pgv_lang["password_help"]			= "~#pgv_lang[password]#~<br /><br />Escriviu la vostra contrasenya en aquest caixetí.<br /><br /><b>És consideren caràcters diferents les majúscules i les minúscules.</b> Això significa que <b>LaMevaContrasenya</b> és <u>diferent</u> de <b>lamevacontrasenya</b> o de <b>LAMEVACONTRASENYA</b>.";
$pgv_lang["login_buttons_help"]			= "~BOTON D'ACCÉS~<br /><br />Aquí veieu un botó per iniciar sessió al sistema.<br /><br />Si feu clic a aquest botó, tornareu a la pàgina on esteu, però amb els drets d'accés registrats.<br /><br />Per exemple, si feu clic a <b>#pgv_lang[login]#</b> quan esteu a la pàgina Pedigree, tornareu a la mateixa pàgina. Si feu clic a aquest botó quan esteu a la pàgina principal de benvinguda, se us dirigirà a la pàgina «#pgv_lang[mygedview]#», on podreu editar la configuració, afegir o editar preferits, enviar i llegir missatges, etc.";
$pgv_lang["login_buttons_aut_help"]		= "~BOTON D'ACCÉS~<br /><br />Aquí veieu un botó per iniciar sessió al sistema.<br /><br />Si feu clic a aquest botó, accedireu i anireu directament a la pàgina «#pgv_lang[mygedview]#», on podreu editar la configuració, afegir o editar preferits, enviar i llegir missatges, etc.";
$pgv_lang["new_password_help"]			= "~#pgv_lang[requestpassword]#~<br /><br />Si heu perdut la contrasenya, podeu polsar aquest enllaç per demanar-ne una de nova.<br /><br />Anireu a parar a la pàgina «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]			= "~#pgv_lang[requestaccount]#~<br /><br />Si visiteu aquest lloc i voleu demanar un compte d'usuari heu de polsar a aquest enllaç.<br /><br />Depenent de la manera com l'administrador hagi configurat el lloc, és possible que s'iniciï el vostre client de correu electrònic perquè pugueu enviar un correu electrònic a l'administrador per demanar un nou identificador d'inici de sessió o us pot dirigir a la pàgina «#pgv_lang[requestaccount]#».";
$pgv_lang["mygedview_login_help"]		= "Per accedir a la pàgina «#pgv_lang[mygedview]#» cal que sigueu un usuari enregistrat del sistema. A la pàgina «#pgv_lang[mygedview]#» podeu fer exlibris amb les persones preferides, portar un dietari, gestionar correu, veure altres usuaris amb accés i personalitzar diversos aspectes de les pàgines de PhpGedView.<br /><br />Entreu el nom d'usuari i la contrasenya als camps corresponents per accedir a #pgv_lang[mgv]#.";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />En aquest caixetí heu d'escriure-hi el vostre nom de pila.<br /><br />Ens cal el nom i cognoms per determinar si esteu qualificat per a demanar un compte a aquest lloc i si hi teniu dret. El nom serà visible per a altres usuaris i membres de la família que estiguin accedint.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />En aquest caixetí heu d'escriure-hi els vostres cognoms.<br /><br />Ens cal el nom i cognoms per determinar si esteu qualificat per a demanar un compte a aquest lloc i si hi teniu dret. El nom serà visible per a altres usuaris i membres de la família que estiguin accedint.";
$pgv_lang["register_info_01"]		= "~#pgv_lang[requestaccount]#~<br /><br />La quantitat de dades que pot veure's públicament en aquest lloc web és limitat per la legislació aplicable a la protecció de la privadesa. Hi ha gent que no vol que les seves dades personals restin disponibles a Internet. Podria fer-se'n mal ús per a correu brossa o suplantació de personalitat.<br /><br />Es permet l'accés als visitants enregistrats (que disposen de compte d'usuari). Un cop l'administrador hagi verificat i autoritzat el permís, podreu accedir-hi.<br /><br />Si hi ha activada la Privadesa de Parentiu, solament disposareu d'accés a la informació privada dels vostres parents directes. D'altra banda l'administrador pot permetre l'edició de dades de la base a determinats usuaris, de forma que poden canviar o afegir informació.<br /><br />Si us cal algun tipus d'ajuda contacteu amb l'administrador mitjançant l'enllaç del peu de pàgina.";
$pgv_lang["register_info_02"]		= "~#pgv_lang[requestaccount]#~<br /><br />La quantitat de dades que poden veure's públicament en aquest lloc web és limitat per la legislació aplicable a la protecció de la privadesa. Hi ha gent que no vol que les seves dades personals restin disponibles a Internet. Podria fer-se'n mal ús per a correu brossa o suplantació de personalitat.<br /><br />L'accés a aquest lloc és permès solament a usuaris <u>autoritzats</u>. Un cop l'administrador hagi verificat i autoritzat el vostre permís podreu accedir i veure les dades privades.<br /><br />Si hi ha activada la Privadesa de Parentiu, solament disposareu d'accés a la informació privada dels vostres parents directes. D'altra banda l'administrador pot permetre l'edició de dades de la base a certs usuaris, de forma que poden canviar o afegir informació.<br /><br />Si us cal algun tipus d'ajuda contacteu amb l'administrador mitjançant l'enllaç del capdavall.";
$pgv_lang["register_info_03"]		= "~#pgv_lang[requestaccount]#S~<br /><br />La quantitat de dades que pot veure's públicament en aquest lloc web és limitat per la legislació aplicable a la protecció de la privadesa. Hi ha gent que no vol que les seves dades personals restin disponibles a Internet. Podria fer-se'n mal ús per a correu brossa o suplantació de personalitat.<br /><br />L'accés a aquest lloc és permès a <u>solament a membres de la família</u>. Un cop l'administrador hagi verificat i autoritzat el vostre permís podreu accedir i veure les dades privades.<br /><br />Si hi ha activada la Privadesa de Parentiu, solament disposareu d'accés a la informació privada dels vostres parents directes. D'altra banda l'administrador pot permetre l'edició de dades de la base a certs usuaris, de forma que poden canviar o afegir informació.<br /><br />Si us cal algun tipus d'ajuda contacteu amb l'administrador mitjançant l'enllaç del capdavall.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Mostra els descendents d'una persona.<br /><br />Podeu escollir la persona (arrel) de la pàgina o podeu haver-hi anat a parar polsant l'enllaç <b>#pgv_lang[descend_chart]#</b> des d'una altra pàgina. Polseu les fletxes per desplaçar-vos dins l'arbre en la direcció desitjada. Polseu la icona del gràfic, del caixetí de qualsevol persona, per veure el diagrama de descendents d'aquesta persona.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br /><br />En aquest gràfic podeu veure-hi una o més persones al llarg d'una línea de temps horitzontal. Us permet veure com coexisteixen les vides de diferents persones.<br /><br />Podeu afegir gent al gràfic individualment o per grups familiars, pel seu ID. Si hi afegiu gent, el gràfic manté la que hi havia prèviament. Sempre podeu buidar-la amb el botó <b>Buidar el gràfic</b>.<br /><br />També podeu afegir-hi gent buscant-la entre dues dates o localitats.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#<br /><br /><b>Selector d'incloure famíliars directes</b><br />Per defecte, està marcat sempre. D'aquesta forma veieu els pares, cònjuge, germans i mainada de la persona a portar al gràfic. Desmarqueu-lo si voleu ometre'ls.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />En aquest gràfic podeu veure-hi una o més persones al llarg d'una escala en el temps. Per exemple, podeu visualitzar la situació de dues o més persones en un moment determinat.<br /><br />Si polseu l'enllaç <b>Escala cronològica</b> des d'una altra pàgina al gràfic hi sortirà la persona que esteu visualitzant. Si el polseu des del menú de capçalera us hi sortirà la persona arrel que tingueu definida.";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Al gràfic podeu posar-hi diverses persones.<br /><br />Feu servir aquest caixetí per introduir cada ID de persona. Si no sabeu, podeu polsar l'enllaç <b>Cercar l'ID</b> del costat.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Polseu l'enllaç per treure la persona de l'escala cronològica.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Si seleccioneu aquesta entrada, veureu un indicador d'edats.<br /><br />Podeu fer-lo córrer amunt i avall del gràfic. És una bona eina per veure quina edat tenia una persona en un determinat esdeveniment. Podeu activar o desactivar l'indicador individualment, per a cada persona del gràfic.";
$pgv_lang["timeline_control_help"] = "~#pgv_lang[timeline_controls]#~<br /><br />~Velocitat~<br />Polseu la finestra desplegable per canviar la velocitat amb la que es recercarà.<br /><br />~Començant l'any~<br />Entreu l'any d'inici del període.<br /><br />~Acabant l'any~<br />Entreu el del final.<br /><br />~Cercar~<br />Polseu per començar a cercar esdeveniments ocorreguts dins del període especificat.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />En aquesta pàgina podeu cercar-hi el grau de parentiu entre dues persones. No cal que tinguin vincles de consanguinitat: pot trobar-se qualsevol mena de relació.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Si heu vingut cap aquesta pàgina des d'una altra havent polsat l'enllaç <b>Vincles amb mi</b>, hi sortirà el parentiu que us uneix amb la persona d'aquella pàgina.<br /><br />Si hi heu arribat a través de l'entrada del menú <b>Diagrama de parentiu</b> a la capçalera de qualsevol pàgina, heu d'entrar-hi els números ID de les persones quin parentiu voleu esbrinar. Si no coneixeu aquests números, podeu polsar l'enllaç <b>Cercar l'ID</b>.";
$pgv_lang["next_path_help"]			= "~#pgv_lang[next_path]#~<br /><br />Polseu aquest botó per a veure si hi ha altres vincles entre ambdues persones. Els anteriors poden veure's polsant l'enllaç del número de vincle.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Amb aquest selector <b>des</b>marcat, solament es recercaran vincles de consanguinitat. Marcat, també es buscaran els polítics (per matrimoni). Us sortiran més vincles deixant aquest selector marcat.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />Amb aquest selector marcat, al gràfic hi sortiran les persones de la mateixa generació alineades horitzontalment. Desmarcat, cada generació pot sortir a diferent alçada, atenent al tipus de parentiu.";
$pgv_lang["oldest_top_help"]          = "~#pgv_lang[oldest_top]#~<br /><br />Quan heu marcat aquest selector, al començament del gràfic hi sortiran la gent de més edat. Desmarcat, començarà pels més joves.<br /><br />Nota: Aquesta opció funciona solament si també teniu marcat el selector <b>#pgv_lang[line_up_generations]#</b>.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]#~<br /><br />El diagrama d'avantpassat és molt semblant a l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> però amb més detalls i diferents sortides (<a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>).<br /><br />A cada avantpassat se li assigna un número únic, calculat segons el sistema <i>Sosa-Stradonitz</i>:<div style=\"padding-left:30px;\"><b>Parells</b> pels homes (número del fill * 2)<br /><b>Senars</b> per les dones (número del cònjuge + 1) excepte pel número <b>1</b></div><br />Exemple:<br /><div style=\"padding-left:30px;\">La persona arrel és <b>1</b>, independentment del sexe.<br />El pare del <b>1</b> és <b>2</b> (<b>1</b> * 2), la mare <b>3</b> (<b>2</b> + 1).<br />El pare del <b>2</b> és <b>4</b> (<b>2</b> * 2), la mare <b>5</b> (<b>4</b> + 1).<br />El pare del <b>3</b> és <b>6</b> (<b>3</b> * 2), la mare <b>7</b> (<b>6</b> + 1).<br />El pare del <b>7</b> és <b>14</b> (<b>7</b> * 2), la mare <b>15</b> (<b>14</b> +1).<br />...</div>";
$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# - Amplada del caixetí~<br /><br />Podeu canviar l'amplada del caixetí del 50% al 300%. A 100% cada caixetí té uns 270 píxels d'ample.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />Hi ha disponibles dos estils:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Arbre vertical amb famílies expansibles/plegables.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Una família per pàgina amb pares, avis i tota la mainada enregistrada.<br /><br />Aquest format és fàcil d'imprimir per donar-lo als parents.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]#~<br /><br />El diagrama de cercle és molt semblant a l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> però més gràfic.<br /><br />La persona arrel es surt al centre, els seus pares al primer cercle, el avis al segon i així.<br /><br />Els natalicis i òbits (si es coneixen) surten sota del nom.<br /><br />Polsant un nom del gràfic s'obre un menú d'enllaços específic per la persona. Des d'aquest menú podeu optar per centrar el diagrama sobre aquesta persona o un dels seus parents directes o anar a la seva pàgina #pgv_lang[indi_info]# o a un altre gràfic seu.";
$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_chart]# - Amplada~<br /><br />Es pot canviar l'amplada del gràfic del 50% al 300%.  Al 100% l'amplada de la imatge és d'uns 640 píxels.";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# - Estil~<br /><br />Aquesta opció controla la forma del diagrama.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Mig cercle. Diagrama de 180&deg;</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Tres quarts. Diagrama de 270&deg;, també conegut <i>Vol de l'àngel</i></li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Tot el cercle. Diagrama de 360&deg;</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />El rellotge de sorra mostra avantpassats i descendents de la persona arrel escollida en un mateix diagrama i és una barreja entre el de descendents i l'arbre genealògic.<br /><br />La persona arrel ocupa el centre de la pàgina amb els descendents a l'esquerra i els avantpassats a la dreta. Les generacions s'alineen començant per la més antiga i acabant per la darrera.<br /><br />Si hi ha una fletxa cap avall sota la persona arrel, polsant-la surt una llista de familiars directes que podeu fer servir per navegar diagrama avall. Seleccionant un nom de la llista, es recarrega el diagrama amb aquesta persona com a arrel.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />És semblant al rellotge de sorra. Presenta avantpassats i descendents de la persona arrel escollida en un mateix diagrama. També mostra els descendents amb el mateix format que el rellotge de sorra.<br /><br />La persona arrel ocupa el centre de la pàgina amb els descendents a l'esquerra i els avantpassats a la dreta. Les generacions s'alineen començant per la més antiga i acabant per la darrera.<br /><br />Cada descendent pot esdevenir persona arrel d'un rellotge de sorra addicional, dins la mateixa pàgina. Aquest procés es repeteix fins que s'assoleix el nombre especificat de generacions.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Aquest valor determina el nombre de generacions de descendents de la persona arrel que apareixeran en format de rellotge de sorra.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~LLISTA DE PERSONES~<br /><br />És un llistat de persones ordenades alfabèticament pel cognom.<br /><br />El format d'aquesta llista canvia depenent de:<ul><li>La lletra polsada a l'índex alfabètic.</li><li>Si polseu \"Saltar\" o \"Mostrar\" el llistat de cognoms.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]				= "~ÍNDEX ALFABÈTIC~<br /><br />Polsant qualsevol caràcter de l'índex alfabètic surt una llista de cognoms que comencen amb la lletra escollida.<br /><br />Pot passar que la penúltima entrada de l'índex sigui <b>#pgv_lang[NN]#</b>. Apareix quan hi ha gent a la base de dades de la que no s'ha enregistrat el cognom o que conté algun caràcter no suportat per l'idioma. Els cognoms desconeguts sovint s'enregistren com <b>?</b> i es reconeixen com a <b>#pgv_lang[NN]#</b>. Tamb passa quan la persona és desconeguda.<br /><br /><b>Nota:</b><br />Els cognoms entrats per exemple com, <b>Nn</b>, <b>NN</b>, <b>Desconegut</b> o també <b>N.N.</b> <u>no</u> surten a la llista <b>#pgv_lang[NN]#</b>. Podeu trobar-los polsant la <b>N</b> o la <b>D</b> doncs son aquestes les inicials dels seus \"noms\". El PhpGedView no pot preveure totes les possibles formes d'entrar cognoms desconeguts. No hi ha una convenció generalment acceptada de com fer-ho.<br /><br />Al final de l'índex hi veureu <b>Tots</b>. Polsant aquest ítem surt una llista amb tots els cognoms de la base de dades.<br /><br /><b>Falten caràcters?</b><br />Si l'índex alfabètic surt incomplert, faltant-hi una o més lletres, és degut a que a la base de dades no hi ha cognoms que comencin per les que falten.";
$pgv_lang["name_list_help"]			= "~LLISTA DE NOMS~<br /><br />Tant pot mostrar una llista de cognoms com una de complerta amb noms i cognoms. En ambdós casos tots els cognoms començaran per la inicial activada a l'índex alfabètic, si és que no heu polsat <b>Tots</b>.<br /><br />Que vegeu una mena de llista o l'altra depèn de l'estat de l'enllaç <b>Salta't/Mostrar el llistat de cognoms</b>.";
$pgv_lang["skip_sublist_help"]			= "~SALTA'T LA SOTSLLISTA~<br /><br />El paràmetre estàndard es que, desprès que hagueu polsat un caràcter de la llista d'índex alfabètic, surti una sostllista de cognoms. Si polseu aquest enllaç, apareixerà immediatament una llista amb el nom complert de totes les persones quina inicial del cognom teniu seleccionada. Aquesta llista de persones seguirà sortit directament mentre que no polseu una altra inicial de l'índex alfabètic.<br /><br />Per invertir aquesta acció, polseu l'enllaç #pgv_lang[show_surnames]# de la pàgina #pgv_lang[individual_list]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Les pàgines amb llistes de persones i famílies poden incloure o no els noms de casada. Aquesta opció és útil quan cerqueu persones o famílies de les que solament en coneixeu el nom de casada. Els noms de casada solament poden incloure's si existeixen a la base de dades.<br /><br />A la llista de famílies, el valor per defecte és excloure'ls. A la pàgina de llista de persones el valor per defecte és el que hi ha fixat a la pàgina de configuració del GEDCOM.<br /><br />Quan canvieu aquesta opció la vostra elecció roman activa fins que no us desconnecteu o la vostra sessió finalitzi..";

//-- Families-page
$pgv_lang["help_famlist.php"]		= "~LLISTA DE FAMÍLIES~<br /><br />És un llistat de famílies ordenades alfabèticament pel cognom.<br /><br />El format canvia depenent de:<ul><li>La lletra polsada a l'índex alfabètic.</li><li>Si polseu \"Saltar\" o \"Mostrar\" el llistat de cognoms.</li></ul>Podeu buscar pel cognom del marit o de la muller, tot dos son al llistat.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~DETALLS DE LA FAMÍLIA~<br /><br />És una vista general de la família escollida a la pàgina precedent.<br /><br />De dalt a baix hi veieu els detalls personals del marit, els seus pares, l'esposa, els pares d'ella i la mainada.<br /><br />El format i contingut dels caixetins de cada persona son els iguals que els que ja coneixeu de les pàgines dels diagrames de descendència i de l'arbre genealògic.<br /><br />Si hi ha més avantpassats al fitxer, a la dreta dels caixetins dels pares hi surt una fletxa. Polsant-la correu una generació amunt cap a una nova pàgina amb els pares com a centre de la unitat familiar, que ara surten com a marit i muller.<br /><br />A la banda dreta del caixetí hi surt una lupa que es pot polsar per veure més detalls de la persona. Polsant sobre el nom es va a parar a la pàgina #pgv_lang[indi_info]# de la persona.<br /><br />També a la dreta s¡hi pot veure un petit menú per enllaçar amb altres diagrames o més informació. Alguna d'aquestes entrades de menú poden tenir sub-menús que apareixen quan el punter de ratolí toca l'entrada del menú.<br /><br />El caixetí d'informació del grup familiar mostra tots els esdeveniments i informacions sobre la família com per exemple casament, objectes multimèdia i notes. Als d'informació d'esdeveniments, polsant un lloc es surt a un llistat on hi apareixen les altres persones i famílies relacionades amb al mateix. Polsant una data es va a parar al calendari que m ostra els esdeveniments esdevinguts a la data escollida. També es poden polsar els objectes multimèdia i s'obre una nova finestra per visionar-los. Polsant sobre la superfície de la imatge n'apareix una altra a la pàgina #pgv_lang[media_list]#. Si es polsa l'enllaç d'una font se'n veuran als detalls.<br /><br />Sota dels noms de la mainada hi ha l'enllaç <b>Afegir fill a aquesta família</b>. I al costat dels noms de la mainada hi surt l'enllaç <b>Informació del grup familiar</b>. Si tens permís per a fer-ho, pots editar, esborrar i afegir dades i esdeveniments.<br /><br />Com a la pàgina #pgv_lang[indi_info]#, hi ha un menú, a dalt a la dreta. Les entrades d'aquest menú menen a altres pàgines on es pot obtenir més informació o realitzar altres tasques relacionades amb la família.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~AFEGIR FILL/A A AQUESTA FAMÍLIA~<br /><br />Podeu afegir un fill/a polsant aquest enllaç.<br /><br />És fàcil de fer: Polseu l'enllaç, ompliu els camps de la finestra i llestos!";
$pgv_lang["show_fam_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Polsant aquí veureu la informació de la família tal i com s'emmagatzema a la base de dades. En altres paraules: visualitzareu les dades primàries del GEDCOM.";
$pgv_lang["add_fam_clip_help"]		= "~POSAR LA FAMÍLIA AL CISTELL GENEALÒGIC~<br /><br />Podeu afegir tota o part de la informació de la família al #pgv_lang[clip_cart]#. A la següent pàgina podeu concretar quina informació voleu:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]	= "~MOSTRA LA PARELLA A L'ESCALA CRONOLÒGICA~<br /><br />Polsant aquí aneu a parar a una escala on s'hi mostren cronològicament tots els esdeveniments relacionats amb la parella.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~LLISTA DE FONTS~<br /><br />És un llistat de fonts.<br /><br />A diferència de la pàgina #pgv_lang[indi_info]# i la de famílies no hi ha índex alfabètic.<br /><br />Una font pot ésser una persona, una base de dades pública, una institució, un recurs d'Internet, etc. Degut a l'aleatòria naturalesa de les fonts genealògiques, resulta impossible ordenar-les de forma coherent com en altres casos. Malgrat tot el PhpGedView <u>necessita</u> ordenar les fonts alfabticament.<br /><br /><b>FONTS</b><br />Sense fonts no es pot construir una base de dades. N'hi ha una per cada entrada d'informació. La font pot ésser un parent, una institució, una base de dades pública, arxius governamentals o privats i recursos a Internet, etc.<br /><br />Una mateixa font pot estar relacionada amb més d'una persona. I una persona a diverses fonts. Pot haver-hi diverses fonts per a cada esdeveniment com natalicis, professió, casaments, mainada, etc.";
$pgv_lang["sourcelist_listbox_help"]		= "~CAIXETÍ DE LLISTAT DE FONTS~<br /><br />S'hi veuen els noms de les fonts tal com estan emmagatzemades al GEDCOM.<br /><br />Els noms surten per ordre alfabètic. Polsant-ne un de la llista, us mena a la pàgina de la font escollida que mostra quines persones o famílies hi ha relacionades amb ella.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~DETALLS DE LA FONT~<br /><br />En aquesta pàgina es mostren els detalls de cada font. Les fonts son molt importants per als investigadors genealògics i permeten seguir la pista que s'ha emprat per localitzar la informació.<br /><br />S'hi pot veure-hi informació sobre el títol, l'autor, la publicació i l'arxiu on s'ha localitzat. Atès que hi ha diferents tipus de fonts, unes poden tenir més informació que altres.<br /><br />Si hi ha enllaçat un fitxer multimèdia, com per exemple la reproducció d'un document, el podreu veure: Polsant sobre el nom de l'objecte aneu a parar a la pàgina #pgv_lang[media_list]# de l'objecte escollit.<br /><br />A continuació dels detalls de la font, hi ha una llista de persones i famílies relacionades amb ella. Això permet identificar totes les entrades que s'han obtingut d'aquesta font.<br /><br />Si l'administrador ha activat aquesta opció, podeu disposar d'una o dues icones de menú a la pàgina:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />que us mostra la informació en format GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />que us permet posar-la al #pgv_lang[clip_cart]# per baixar-vos-la més tard i importar-la al vostre programa de genealogia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~REGISTRES RELACIONATS AMB AQUESTA FONT~<br /><br />En aquest caixetí hi surten els noms de les persones i les famílies relacionats amb la font.<br /><br />Estan ordenats alfabèticament. Quan polseu sobre un nom de la llista aneu a parar la pàgina de detalls rellevants.";
$pgv_lang["show_source_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Polsant aquest enllaç veureu el registre de la font en format primari, tal i com s'emmagatzema a la base de dades.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Polsant aquest enllaç podeu afegir la informació al #pgv_lang[clip_cart]# per baixar-vos-la més tard i importar-la a un programa de genealogia.";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br /><br />Polsant aquesta opció marqueu la font per a ésser eliminada de la base de dades.<br /><br />Com funciona? Suposem que teniu una bona raó per treure aquesta font de la base de dades. Polseu l'enllaç. El sistema us demana confirmació per esborrar-la. Si continueu amb la visita, us adonareu que la font és encara visible, que pot emprar-se i que no s'ha esborrat.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b><u>No</u> hi ha cap error.</b> L'administrador del lloc rebrà un missatge notificant-li que s'han fet canvis a la base de dades i que has suprimit alguna cosa. Podrà acceptar o rebutjar el canvi. La supressió esdevindrà permanent només després que l'administrador hagi acceptat el vostre canvi. Si té algun dubte, l'administrador es posarà en contacte.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~JERARQUIA DE LLOC~ (o persones per lloc)<br /><br />Mostra la jerarquia de llocs del GEDCOM amb les persones o famílies que hi ha relacionades.<br /><br />Si hi ha relació entre una persona o família i un esdeveniment a un lloc determinat, el PhpGedView pot buscar-la.<br /><br />Els resultats es mostren en una llista a dues columnes. Una per les persones i l'altra per les famílies.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~FORMAT D'ORDRE DE LLOCS~<br /><br /><b>ORDRE PER DEFECTE</b><br />Això vol dir que, si no hi ha format de lloc explícitament declarat al fitxer GEDCOM, s'assumirà el que hi ha per defecte.<br /><br />Si no es troba cap altre format, es mostrarà entre <b>(</b> i <b>)</b> al final de la línea.";
$pgv_lang["ppp_match_one_help"]			= "~FORMAT D'ORDRE DE LLOCS~<br /><br /><b>ORDRE DEL GEDCOM</b><br />Els lloc es mostraran segons el format explícitament declarat al fitxer GEDCOM, que s'imposa per sobre de l'ordre per defecte.";
$pgv_lang["ppp_numfound_help"]			= "~LOCALITZA VINCLES DEL LLOC~<br /><br />Mostra el nombre de vincles. Si voleu veure una llista de llocs, no podeu depassar el nivell més baix.<br /><br />Podeu escollir entre veure tots els registres vinculats a un lloc o afinar la recerca polsant un altre lloc.";
$pgv_lang["ppp_levels_help"]			= "~NIVELLS DE LLOCS~<br /><br />Mostra els nivells que s'estan visualitzant. El llistat de llocs actual és una subllista del nivell situat més a l'esquerra.<br /><br /><b>Exemple:</b><ul><li>L'ordre per defecte és #pgv_lang[default_form]#.</li><li>Si el nivell actual és el \"Nivell superior\", al requadre hi veureu tots els països de la base de dades.</li><li>Si el nivell actual és \"USA, Nivell superior\", al requadre hi sortiran els estats dels USA</li><li>...</li></ul><br />Podeu polsar un nivell per tirar enrere un o més salts.";
$pgv_lang["ppp_placelist_help"]			= "~JERARQUIA DEL LLOC~<br /><br />És un llistat on s'hi mostren els llocs subordinats del que hagueu escollit. Si no n'heu seleccionat cap, sortirà un llistat del nivell superior (per exemple, països o estats).<br /><br />Podeu polsar sobre tots els noms de la llista. Fent-ho, actua com a filtre i us mena al nivell inferior.";
$pgv_lang["ppp_placelist_help2"]		= "~LLISTA DE LLOCS~<br /><br />En aquesta llista hi surten els llocs trobats en aquest nivell.<br /><br />Podeu polsar sobre tots els noms. Fent-ho, actua com a filtre i us mena al nivell inferior.<br /><br />Solament quan esteu al nivell superior no es mostra una llista de noms. A tots els nivells subordinats podeu obtenir una llista de persones o famílies vinculats a cada lloc.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Polsant aquest enllaç surt una llista de persones o famílies relacionades amb esdeveniments ocorreguts en aquest lloc. Quan sou al capdavall de la jerarquia de llocs, que serà normalment un poble o ciutat, el llistat de noms surt automàticament.";
$pgv_lang["ppp_name_list_help"]			= "~LLISTA DE NOMS~<br /><br />Aquest requadre mostra una llista completa de persones i famílies vinculades amb al lloc.<br /><br />Podeu polsar sobre tots els noms. Fent-ho, aneu a parar a la pàgina de detalls rellevants. Quan polseu una localització del capdamunt de la llista, es canvia la selecció.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~LLISTA D'OBJECTES MULTIMÈDIA~<br /><br />Aquesta pàgina llista tots els objectes multimèdia que hi ha a la base de dades.<br /><br />Per cada entrada es veu el títol o nom del fitxer de l'objecte, noms de les persones o famílies relacionades amb aquesta entrada i notes.<br /><br />Polsant el títol o nom del fitxer fa el mateix efecte que fer-ho sobre la seva miniatura. S'obre el fitxer al visor d'imatges del PhpGedView o a l'especificat a la configuració del navegador.<br /><br />Quan polseu l'enllaç \"Veure\" del costat de la persona o família, aneu a parar a la pàgina de detalls rellevants.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~CARREGAR FITXERS MULTIMÈDIA~<br /><br />Carregar fitxers multimèdia és força complex. Aquesta és una petita informació addicional.<br /><br /><b>Miniatures</b><br />Les miniatures tenen una mida aproximada de 100px d'amplada. Han de tenir <u>idèntic</u> nom que la versió sencera. Si el vostre sistema pot generar miniatures automàticament, veureu una nota de us afecta això, a la pàgina de Carregar Multimèdia.<br /><br /><b>Carregant</b><br />Els fitxers es carreguen automàticament al directori <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, les versions de mida natural. I al <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>, les miniatures.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Informació general</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Esdeveniments a mostrar</b></a></li><li><a href=\"#calendar_button\"><b>Botons d'un dia / Mes / Any</b></a></li><li><a href=\"#calendar_tip\"><b>Nota</b></a></li></ul><br /><a name=\"calendar_general\"></a>Al #pgv_lang[anniversary_calendar]# hi surten les persones i famílies relacionades amb un esdeveniment ocorregut un dia determinat, un mes o durant un cert període. Té un sistema avançat de filtre per seleccionar la data correcta, el període i els esdeveniments.<dl><dt><b>Veure <a href=\"#calendar_day\">D'un dia</a></b></dt><dd>Mostra els esdeveniments d'un dia en concret, independentment de l'any seleccionat. El format pot ser una llista simple amb els noms de les persones o famílies, o a dues columnes amb les persones en una i les famílies a l'altra.</dd><dt><b>Veure <a href=\"#calendar_month\">D'un mes</a></b></dt><dd>En aquest format els noms de les persones i famílies surten als requadres dels dies. El calendari és el de l'any que heu triat al caixetí corresponent. S'hi mostren tots els esdeveniments ocorreguts en anys precedents fins a l'escollit.<br /><br />En combinació amb l'opció <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, dóna una visió realista del calendari tal com el veien els avantpassats.</dd><dt><b>Veure <a href=\"#calendar_year\">D'un any</a></b></dt><dd>Mostra els esdeveniments ocorreguts durant un any determinat o un cert nombre d'anys. El resultat pot ésser una simple llista de persones i famílies o a dues columnes amb les persones a l'una i les famílies a l'altra.</dd></dl>El dia i mes que esteu veient surten ressaltats al menú del calendari.<br /><br />Podeu polsar tots els noms i les dates. Quan es polseu un nom aneu a parar a la pàgina de detalls rellevants de la persona. Polsant una data aneu al mode \"D'un dia\" o \"D'un any\" que us mostra els esdeveniments per al dia i mes de la data escollida.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~SELECTOR DE DIA~<br /><br />La primera fila de la taula de selecció és el selector de <b>dia</b>. El funcionament és obvi: Seleccioneu un <u>dia</u>.<br /><br />El resultat de polsar un dia determinat depèn si sou al mode <b>D'un dia</b> o <b>D'un mes</b>.<br /><dl><dt><b>mode d'un dia</b></dt><dd>Aquí, polsant un dia, la pantalla es refresca i surt la llista pel nou dia escollit.</dd><dt><b>Mode d'un mes</b></dt><dd>Teniu el calendari d'un determinat mes a la pantalla. Polseu sobre un dia i la pantalla es refresca però encara continuareu veient el mes que hi havia a la d'abans. La raó és que encara podeu decidir seleccionar un altre mes, any o ambdós, tot i que abans hagueu polsat botó <b>#pgv_lang[viewday]#</b> o el <b>#pgv_lang[viewmonth]#</b>.</dd></dl><br />Al capdavall de la fila del dia hi ha un <b>Enllaç immediat</b> a la data d'avui. Polsant-lo sortirà la llista per avui en mode <b>D'un dia</b>. Tan hi fa que estigueu en el mode <b>D'un més</b> com en el <b>D'un dia</b>.";
$pgv_lang["annivers_month_select_help"]	= "~SELECTOR DE MES~<br /><br />La fila del mig de la taula de selecció és el selector de <b>Mes</b>. El funcionament és obvi: Seleccioneu un <u>mes</u>.<br /><br />El resultat de polsar un determinat mes depèn si sou al mode <b>D'un dia</b> o <b>D'un mes</b>.<br /><dl><dt><b>Mode d'un dia</b></dt><dd>Aquí, polsant un mes, la pantalla es refresca i surt la llista pel mes escollit. Totes les altres seleccions com el dia, l'any i esdeveniments no varien.</dd><dt><b>Mode d'un mes</b></dt><dd>Quan hi ha el calendari en pantalla i polseu un mes a la fila <b>Mes</b>, surt el calendari per al nou mes.</dd></dl><br />Al capdavall de la fila hi ha un <b>Enllaç immediat</b> amb el mes i any actuals. Polsant-lo surt la llista del mes en mode <b>D'un mes</b>. Tant hi fa que esteu en mode <b>D'un mes</b> com <b>D'un dia</b>.";
$pgv_lang["annivers_year_select_help"]	= "~CAIXETÍ D'ENTRADA DE L'ANY~<br /><br />Aquest caixetí us permet canviar l'any del calendari. Entreu un any i polseu  <b>Enter</b> per canviar el calendari a aquest any.<br /><br /><b>Característiques avançades</b> per a <b>#pgv_lang[viewyear]#</b><dl><dt><b>Més d'un any</b></dt><dd>Podeu cercar dates en un lapse d'anys.<br /><br />Els lapses d'anys son <u>inclusius</u>. Fa que vagin de l' 1 de gener del primer any fins al  31 de desembre del darrer any esmentat. Heus ací alguns exemples de lapses d'anys:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;per a tots els esdeveniments entre 1992 i 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;per a tots els esdeveniments entre 1972 i 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;per a tots els esdeveniments entre 1610 i 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;per a tots els esdeveniments entre 1880 i 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;per a tots els esdeveniments entre 880 i 1105.<br /><br />Per a veure tots els esdeveniments d'una dècada o centúria determinada, podeu fer servir <b>#pgv_lang[qm]#</b> en lloc dels darrers dígits. Per exemple, <b>197?</b>&nbsp;&nbsp;&nbsp;per a tots els esdeveniments entre 1970 i 1979 o <b>16??</b>&nbsp;&nbsp;&nbsp;per a tos els esdeveniments entre 1600 i 1699.<br /><br />Seleccionant un lapse d'anys el calendari canviarà a la vista anual.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~VEURE ESDEVENIMENTS DE...~<br /><br />Hi ha disponibles les següents opcions:<br /><ul><li><b>Tothom</b><br />Amb aquesta opció surten totes les persones i famílies.</li><li><b>Esdeveniments recents (&lt; 100 anys)</b><br />Amb aquesta es mostraran tots els esdeveniments pel dia o mes escollit amb antiguitat inferior a 100 anys.</li><li><b>Gent viva</b><br />Si no és que l'administrador ha configurat el PhpGedView perquè la gent viva sigui visible a tothom, aquesta opció solament estarà disponible per a usuaris amb accés.<br /><br />Amb ella solament es mostraran esdeveniments relatius a persones vives.</li></ul>Quan entreu una opció, es mostren els esdeveniments de forma automàtica.<br /><br />Els paràmetres de dia, mes i any, així com els mode <b>D'un dia</b> o <b>D'un mes</b>, restaran inalterats.";
$pgv_lang["annivers_sex_help"]			= "~SELECTOR DE SEXE~<br /><br />Un cop hagueu accedit o quan l'administrador no ha activat la l'opció de privadesa, podeu seleccionar una d'aquestes opcions:<ul><li><b>Tots</b><br />És l'opció per defecte. Surten els esdeveniments relacionats amb totes les persones i famílies.</li><li><b>Home</b><br />Únicament es mostraran els esdeveniments relacionats amb persones de sexe masculí i apareixeran només els mascles de les famílies amb els esdeveniments relacionats amb elles.</li><li><b>Dona</b><br />Únicament es mostraran els esdeveniments relacionats amb persones de sexe femení i apareixeran només les femelles de les famílies amb els esdeveniments relacionats amb aquestes.</li></ul>Quan trieu una opció, els esdeveniments escollits surten automàticament.<br /><br />Els paràmetres de dia, mes i any així com els mode <b>D'un dia</b> o <b>D'un mes</b>, restaran inalterats.";
$pgv_lang["annivers_event_help"]		= "~ESDEVENIMENTS A MOSTRAR~<br /><br />Aquí podeu escollir desitgeu veure tots els esdeveniments de persones i famílies o els d'un determinat tipus. No es possible seleccionar més d'una categoria d'esdeveniments.<br /><br />Quan escolliu una opció, surt automàticament.<br /><br />Els paràmetres de dia, mes i any així com els mode <b>D'un dia</b> o <b>D'un mes</b>, restaran inalterats.";
$pgv_lang["annivers_tip_help"]			= "~NOTA~<br /><br />Ajusta el selector de data per a una d'antiga.<br /><br />Polsant els botons de visualitzar surt una llista o calendari per a aquella data. Totes les edats, aniversaris, etc. s'han recalculat per a la data escollida. Esteu veien el calendari o la llista tal i com l'haurien vista els vostres avantpassats, fa anys.";
$pgv_lang["day_month_help"]				= "~BOTONS D'UN DIA / D'UN MES / D'UN ANY~<br /><br /><ul><li>El botó <b>D'un dia</b> us mostra els esdeveniments de la data escollida en una llista. Es busquen tots els anys. Aquí solament podeu escollir el dia i el mes. Canviar l'any no té cap efecte. Podeu reduir la llista escollint l'opció <b>Esdeveniments recents</b> o <b>Gent viva</b>.<br /><br />Les edats es calculen des de l'any en curs.</li><li>El botó <b>D'un mes</b> us mostra el diagrama d'un calendari del més escollit i l'any. Aquí també podeu reduir les llistes escollint les opcions <b>Esdeveniments recents</b> o <b>Gent viva</b>.<br /><br />Escollint un any passat, en combinació amb <b>Esdeveniments recents</b>, disposeu d'una impressió força realista dels fulls de calendari que podien veure els vostres avantpassats. Totes les edats que hi surten son calculades en relació a l'any entrat al caixetí.</li><li>El botó <b>D'un any</b> treu una llista d'esdeveniments ocorreguts l'any escollit. També podeu reduir-la amb les opcions <b>Esdeveniments recents</b> o <b>Gent viva</b>.<br /><br />Podeu veure els esdeveniments ocorreguts en un període d'anys. Entreu els anys d'inici i final separats per un guió <b>-</b> entremig. Exemples:<br /><b>1992-4</b> per a tots els esdeveniments entre 1992 i 1994<br /><b>1976-1984</b> pels de 1976 a 1984<br /><br />Per veure tots els esdeveniments d’una dècada o segle determinats, podeu utilitzar <b>#pgv_lang[qm]#</b> en lloc dels darrers dígits. Per exemple, <b>197?</b> per a tots els esdeveniments del 1970 al 1979 o <b>16??</b> per a tots els esdeveniments del 1600 al 1699.</li></ul>Si voleu <b>canviar d'any</b> és <b>imprescindible</b> que polseu un d'aquests tres botons. La resta de paràmetres romanen inalterables.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />El #pgv_lang[clip_cart]# us permet prendre \"retalls\" de l'arbre familiar i empaquetar-los en un fitxer amb l'objecte de descarregar-lo i importar-lo posteriorment dins d'un programa de genealogia. El fitxer té el format GEDCOM.<br /><ul><li>Com prendre els retalls?<br />És molt senzill. Cada cop que surt un nom que podeu polsar (d'una persona, família o font) podeu anar a la pàgina de detalls d'aquest nom on hi veureu l'opció <b>#pgv_lang[add_to_cart]#</b>. Polsant l'enllaç, us oferirà diverses opcions per incorporar-hi dades.</li><li>Com descarregar-ho?<br />Un cop ho tingueu tot al cistell, podeu baixar-vos el fitxer polsant l'opció <b>Descarregar ara</b>. Solament cal que seguiu les instruccions i els enllaços.</li></ul>";
$pgv_lang["clip_download_help"]			= "~#pgv_lang[download_now]#~<br /><br />Polsant aquest enllaç aneu a la pàgina següent. Si algun dels retalls té fitxers multimèdia vinculats, també sortiran.<br /><br />Senzillament, seguiu les instruccions.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Polsant aquí buidareu el #pgv_lang[clip_cart]#.<br /><br />Si en voleu treure totes les persones, famílies, etc. des del contingut del #pgv_lang[clip_cart]#, podeu fer-ho individualment polsant la icona d'<b>Eliminar</b>. <u>No</u> us demana confirmació per a fer-ho. L'acció és immediata.";
$pgv_lang["add_by_id_help"]				= "~AFEGIR RETALLS PER L'ID~<br /><br />Aquest caixetí us permet entrar números ID de persones o famílies per posar-les al cistell genealògic. Un cop fet, sortiran opcions per posar-hi més parents alhora.<br /><br />Si desconeixeu el número d'ID, podeu fer una recerca pel nom, polsant la icona representativa d'una persona o família, al costat del botó d'afegir.";
$pgv_lang["zip_help"]					= "~FITXER ZIP~<br /><br />Amb aquesta opció es comprimeixen els retalls en un fitxer del tipus ZIP. Per a més informació sobre aquesta mena de compressió, visiteu <a href=\https://ca.wikipedia.org/wiki/ZIP\" target=\"_blank\">https://ca.wikipedia.org/wiki/ZIP</a>.";
$pgv_lang["include_media_help"]			= "~INCLOU MULTIMÈDIA~<br /><br />Amb aquesta opció seleccionada s'inclouen al cistell els fitxers multimèdia associats als registres seleccionats. Això fa que es comprimeixi automàticament el fitxer durant la descàrrega.";
$pgv_lang["clip_cart_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Aquest caixetí us mostra el contingut del cistell.<ul><li>La columna <i>Tipus</i> indica la natura de cada entrada que pot ésser una persona (INDI), Família (FAM), Font (SOUR), Arxiu (REPO), Nota (NOTE) i Multimèdia (OBJE). Cada una representada amb la seva pròpia icona.</li><li>A la columna <i>ID</i> hi surt el número d'ID de cada entrada.</li><li>A la columna <i>Nom / Descripció</i> hi surt o el nom de la persona o família o una descripció de l'entrada.</li></ul>El botó d'eliminar serveix per a treure l'entrada del cistell. <b>NO demana confirmació per a fer-ho!.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~#pgv_lang[review_changes]#~<br /><br />Quan surt aquest missatge, vol dir dues coses:<ol><li>Algú ha fet canvis al GEDCOM<br />S'hi poden haver canviat, afegit o esborrat registres.</li><li>Els canvis encara no han sigut acceptats per l'administrador.<br />Un cop acceptats o rebutjats, ja no sortirà més el missatge.</li></ol>Podeu veure quins canvis s'han fet polsant l'enllaç. Si veieu que algun canvi no és correcte, cal que ho notifiqueu a l'administrador.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~RECERCA A LA BASE DE DADES~<br /><br />Malgrat que aquesta pàgina sembli senzilla, és una potent i complicada eina de recerca, de dues maneres. Moltes pàgines web genealògiques solament permeten buscar noms. En canvi el PhpGedView permet buscar-ho quasi tot.<br /><br />El caixetí de recerca de la pantalla és semblant al de la capçalera de cada pàgina.<br /><br />Si cerqueu gent relacionada amb cert any, poseu-hi l'any. El programa cercarà totes les relacions.<br /><br />I si voleu buscar per un nom o lloc? Entreu-hi el nom o el lloc, complert o parcial i el PhpGedView farà la resta.<br /><br /><b>Mètode de recerca fonètica</b><br />Podeu buscar noms de persones i llocs, fins i tot desconeixent com s'escriuen exactament.<br /><br />Quan hi ha diverses bases de dades genealògiques a un mateix lloc i l'administrador ha activat passar de l'una a l'altra, la recerca retrona els resultats per a cada una d'elles.<br /><br />Podeu trobar més ajuda sobre aquestes dues formes polsant el <b>?</b> del costat del títol.";
$pgv_lang["search_enter_terms_help"]		= "~#pgv_lang[enter_terms]#~<br /><br />En aquest caixetí podeu entrar-hi dates, malnoms, cognoms, llocs, multimèdia, etc.<br /><br /><b>Comodins</b><br />Els comodins, tal com probablement els coneixeu (com * o ?), no es permeten, però el programa els assumeix automàticament.<br /><br />Suposem que entreu el següent: <b>Pete</b>. El resultat serà, suposant que aquests noms siguin a la base de dades:<div style=\"padding-left:30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />algú --Nascut el 01 gener 1901 a <b>Pete</b>rsburg<br />...</div><br /><b>Dates</b><br />Entrant un any, el resultat serà una llista de persones que tinguin alguna relació amb aquest any.<br /><br />Entrant <b>1950</b>, el resultat serà totes les persones relacionades amb un esdeveniment ocorregut l'any 1950. Aquests esdeveniments poden ésser natalicis, òbits, casaments, Segell SUD, etc.<br /><br />Si entreu <b>4 Dec</b>, es llistaran totes les persones relacionades amb un esdeveniment ocorregut el 4 de desembre de qualsevol any. I també les relacionades amb el 14 o el 24 de desembre. Com podeu veure, els comodins sempre s'assumeixen malgrat que no s'hi posin. A vegades els resultats poden ésser sorprenents.<br /><br /><b>Dates correctes</b><br />El PhpGedView cerca dates tal i com s'emmagatzemen al fitxer GEDCOM. Si, per exemple, es cerqueu un esdeveniment del 14 de desembre cal que entreu <b>14&nbsp;dec</b> perquè és així com està emmagatzemat a la base de dades.<br /><br />Si entreu <b>de&nbsp;14</b>, com a resultat pot sortir una persona relacionada amb un esdeveniment del 08&nbsp;<b>de</b>sembre&nbsp;18<b>14</b>. Altra volta els resultats poden ésser sorprenents.<br /><br />Es poden fer servir expressions regulars de recerca, si hi esteu familiaritzat. Per exemple, si voleu cercar gent amb dates del segle XX, cal que entreu la cadena <b>19[0-9][0-9]</b> i veureu tota la gent amb dades entre 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Si us cal més ajuda d'aquest sistema de recerca, digueu-ho i mirarem d'ampliar la informació.";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Podeu buscar paraules amb ortografia incorrecta o altre tipus d'informació inapropiada i esmenar-la.<br /><br /><b>Cercar</b><br />Aquesta funció fa el mateix que una <a href=\"help_text.php?help=search_enter_terms_help\">Recerca general</a>.<br /><br /><b>Cercar i substituir</b><br />Tots els termes de la base de dades que es trobin seran substituïts pel nou.<br /><br /><b>Per exemple...</b><br />Suposem que accidentalment entreu malament el nom del besavi Miquel. Hi heu posat 'Miqel.'<br /><br />Cal que entreu <b>Miqel</b> al caixetí de cercar i <b>Miquel</b> al de 'canviar-ho per'.<br />Totes les entrades de \"Miqel\" es substituiran per \"Miquel\"<br /><br /><b>Cercar per...</b><br />Seleccioneu l'abast de la recerca. Podeu limitar la recerca a noms, a llocs, a fonts o il·limitada (cercar-ho tot). És pràctic si no voleu substituir un nom de lloc, sinó solament un nom de persona.<br /><br />No cal patir si accidentalment substituïu quelcom que no calia. Solament us cal polsar als enllaços \"Acceptar/Rebutjar els canvis\" del capdavall de la pàgina.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex és un mètode de codificar paraules tal com es pronuncien. Això us permet cercar noms i llocs a la base de dades malgrat que en desconeixeu com s'escriuen. El PhpGedView suporta dos algoritmes Soundex que difereixen bastant.<ul><li><b>#pgv_lang[search_russell]#</b><br />Aquest mètode, patentat el 1918 per Russell, és molt senzill i es pot fer manualment.<br /><br />L'algorisme senzill no s'adapta bé als noms que originalment estaven en idiomes diferents de l'anglès, i fins i tot amb noms anglesos, els resultats són molt sorprenents. Per exemple, una cerca de Soundex senzill <b>Smith</b> dóna no solament <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, que son tots variacions d'<b>Smith</b>, sinó també <b>Smead, Sneed, Smoote, Sammett, Shand,</b> i <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Aquest mètode, desenvolupat el 1985, és molt més complex que el senzill i no és fàcil de fer-lo manualment.<br /><br />Dóna resultats molt més acurats.</li></ul>Per més informació sobre aquests dos algoritmes de recerca fonètica, podeu visitar aquesta pàgina web <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a>.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />L'opció <b>#pgv_lang[search_tagfon]#</b> fa que la funció de recerca ignori les següents etiquetes GEDCOM:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Autor del darrer canvi<br /><b>CHAN</b> - Data del darrer canvi<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />A més d'aquestes etiquetes d'exclusió opcional, la funció de recerca sempre exclou aquestes altres:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Aquesta opció fa que PhpGedView mostri a totes les persones registrades com a associacions amb aquesta persona o família. En canvi, el cas invers, no és possible.<br /><br />Exemple: Suposem la persona <b>A</b> és padrí de la persona <b>B</b>. Aquesta relació consta al registre GEDCOM dela persona  <b>B</b> mitjançant una etiqueta  ASSO. Però ni hi ha cap etiqueta corresponent al registre GEDCOM de la persona  <b>A</b>.<br /><br />Quan aquesta opció es posa a  <b>#pgv_lang[yes]#</b> i el llistat resultant de la recerca inclou a  <b>B</b>, <b>A</b> queda inclòs automàticament degut a l'etiqueta ASSO del registre GEDCOM de <b>B</b>. Tanmateix, si el llistat resultant de la recerca inclou a  <b>A</b>, <b>B</b> no serà incorporat automàticament perquè no existeix la corresponent etiqueta ASSO al registre GEDCOM de la persona  <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Aquesta funció us permet cercar els camps especificats dels registres de la persona a la vostra base de dades genealògica.<br /><br />Quan feu clic al botó <b>#pgv_lang[search]#</b>, tots els camps per als quals s'han introduït valors s'examinaran i es retornaran els registres de la vostra base de dades genealògica que compleixin <u>tots</u> els criteris. Tot i que el diàleg inicial ofereix alguns dels camps més habituals, a la part inferior del diàleg podeu fer clic a <b>#pgv_lang[more_fields]#</b> per ampliar la llista de camps a examinar.<br /><br />~Camps que contenen dates~<br />Les cerques avançades es basen en anys, de manera que a diferència del procediment «#pgv_lang[search_general]#» que pot acceptar una data sense any, tots aquests camps requereixen almenys l'any, però també poden acceptar especificacions de dia, mes i any complets. Per exemple, no és possible cercar alguna cosa que va passar a l'abril de cap any.<br /><br />Cada quadre de camp de data de cerca també té un modificador, de manera que podeu cercar la data <b>#pgv_lang[exact]#</b> tal com s'ha introduït, o una data relativa amb <b>+/-</b> a nombre d'anys. Si escriviu un any al camp de data, després escolliu un modificador i feu clic al botó <b>#pgv_lang[search]#</b>, es mostrarà una llista de persones connectades a aquest any o interval d'anys.<br /><br />Si, per exemple, escriviu «APR 1950» al camp de data de naixement que té el modificador <b>#pgv_lang[exact]#</b>, el resultat serà totes les persones amb un esdeveniment que només es va produir l'abril de 1950. Cada camp de data cercarà les dates específiques d'aquest esdeveniment. Afegir un modificador <b>+/- 10</b> tornaria dates entre l'1 d'abril de 1940 i el 31 de març de 1960. Els altres modificadors també alterarien els intervals d'anys de cerca. En introduir només un any, per exemple, «1950», la cerca retornarà tots els esdeveniments de l'any especificat.<br /><br /><b>Format de data per a les cerques</b><br />No es poden utilitzar comodins ni expressions regulars als camps de la data de cerca. L'ordre del dia, el mes, l'any i les majúscules són irrellevants. «dd MMM aaaa» té el mateix significat que «aaaa MMM dd». Tanmateix, si voleu cercar un esdeveniment el 14 de desembre de 1926, heu d'escriure-lo com a «14 DEC 1926» perquè així és com s'emmagatzema la data a la base de dades. Per cercar una data en diversos esdeveniments (és a dir, naixements, morts, matrimonis, Bar Mitzvahs, LDS Sealings, etc.) o si només es coneix el dia o el mes, és millor utilitzar la funció «#pgv_lang[search_general]#».<br /><br />~Camps que contenen Noms~<br />Els camps <b>#pgv_lang[given_name]#</b> i <b>#pgv_lang[surname]#</b> es poden utilitzar per especificar les diferents parts d'un nom que cal cercar. Això filtra fàcilment els noms que podrien ser noms de pila o cognoms, per exemple, «Terry» o «Henry».<br /><br />Els camps de noms també tenen un modificador que ajuda a qualificar el que s'introdueix versus el que es cerca. Els modificadors inclouen:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;especifica una cerca que distingeix entre majúscules i minúscules del camp complet per al text exacte introduït. La cerca també és sensible a tots els caràcters incrustats, espaiat, etc. Per exemple, si el camp conté un espai però el registre de la base de dades en té dos a la mateixa posició, el registre no es trobarà.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;especifica una cerca que no distingeix entre majúscules i minúscules de registres on qualsevol nom comença amb el que hi ha al camp. Si un camp de nom conté diversos noms (com el nom i el segon nom), la concordança es farà amb el començament de cada part del nom que està separada per un espai.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;especifica una cerca de registres que no distingeix entre majúscules i minúscules on es cercaran les dades completes introduïdes al camp en qualsevol lloc del text del nom del registre de destinació. Per exemple, posar un sol espai al camp de cerca <b>#pgv_lang[given_name]#</b> amb el modificador <b>#pgv_lang[contains]#</b> trobarà tots els registres que han de tenir un primer nom i almenys un segon nom o inicial.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;especifica una cerca que no distingeix entre majúscules i minúscules per a registres que són similars al que hi ha al camp. Això us permet cercar a la base de dades noms i llocs quan no sabeu amb precisió com estan escrits.</li></ul><br />~Camps sense modificadors~<br />Les entrades dels camps sense modificadors són cerques que no distingeixen entre majúscules i minúscules. El text introduït es cercarà a qualsevol lloc del text de l'esdeveniment del registre de destinació.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~PÀGINA DE #pgv_lang[indi_info]#~<br /><br />En aquesta pàgina s'hi presenten tots els detalls d'una persona.<br /><br />Si hi ha una fotografia disponible sortirà a dalt a l'esquerra. Els noms de la persona surten al costat de la fotografia.<br /><br />Els noms poden tenir notes i fonts relacionades que surten a sota.<br /><br />Una persona pot tenir un AKA (o sigui, coneguda per un àlies, nom familiar, diminutiu o malnom). Si és així també sortirà.<br /><br />Si teniu drets d'edició per a aquesta persona, també apareixeran enllaços per <b>Editar</b> i <b>Eliminar</b> al costat de les entrades corresponents.<br /><br />Surt un joc de pestanyes de <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b> i <b>#pgv_lang[relatives]#</b>. Aquestes pestanyes mostren tota la informació que hi ha emmagatzemada a la base de dades sobre la persona seleccionada.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;mostra els esdeveniments i detalls de la persona i el/s seu/s casament/s. Polsant sobre alguna data de la pestanya us mena al #pgv_lang[anniversary_calendar]# d'aquell dia en el que hi podeu veure altres esdeveniments ocorreguts durant el mateix. Polsant sobre un lloc, us mena a la llista de llocs on hi surt altra gent relacionada amb esdeveniments al mateix lloc. Per a casaments i altres esdeveniments familiars, hi ha disponible el nom del cònjuge per a revisar-lo i també un enllaç cap a la famlia.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;mostra notes generals relatives a aquesta persona.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;mostra totes les seves fonts <u>generals</u>. Aquestes fonts <u>no</u> tenen relació amb esdeveniments personals ni amb el seu nom sinó que estan relacionades directament amb la persona. Polsant sobre el títol d'una font us mena a una pàgina amb informació més detallada sobre l'esmentada font que pot mostrar altra gent relacionada alhora amb la mateixa.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;llista totes les imatges i altres entrades multimèdia vinculades a aquesta persona. Polsant sobre la miniatura de la imatge s'obre una finestra on surt ampliada. Polsant sobre l'enllaç corresponent sortirà la imatge a la seva pàgina #pgv_lang[media_list]#.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;llista els pares i germans així com els cònjuges i mainada que ha tingut. Aquesta gent surt en caixetins semblants als dels gràfics que ja coneixeu.</li></ul>A la dreta de la pantalla hi podeu veure un requadre amb enllaços. Alguns d'ells son iguals que els dels menús. Per exemple, polsant al de l'<b>#pgv_lang[pedigree_chart]#</b> us mena al d'aquesta persona. La diferència està en que si polseu l'<b>#pgv_lang[pedigree_chart]#</b> del menú us retorna al que comença amb la persona arrel definida a la base de dades.<br /><br />Un dels enllaços que pot sortir, si ha sigut habilitat per l'administrador, és el de <b>#pgv_lang[view_gedcom]#</b> que us mostra el registre primari (tal com s'emmagatzema al GEDCOM) de la persona.<br /><br />Si l'administrador ha activat el #pgv_lang[clip_cart]# també hi haurà un altre enllaç que us permetrà posar aquesta persona a l'esmentat #pgv_lang[clip_cart]#.<br /><br />L'enllaç <b>#pgv_lang[relationship_to_me]#</b> solament sortirà si heu accedit i teniu un ID assignat al GEDCOM. Mostra el parentiu que us vincula amb aquesta persona.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Polsant aquesta opció marqueu la persona seleccionada per a eliminar-la de la base de dades.<br /><br />Com funciona? Suposem que teniu una bona raó per eliminar-la. Polseu l'enllaç. Us demanarà confirmació. Si seguiu amb la visita, podreu comprovar que encara apareix com si esborrar-la no hagués tingut cap efecte.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~EDITAR o ELIMINAR UN NOM DEL GEDCOM~<br /><br /><b>EDITAR UN NOM</b><br />Polsant l'enllaç s'obre una altra finestra on podeu editar el nom de la persona. Solament us cal omplir els canvis als caixetins, polsar el botó, tancar la finestra i llestos!<br /><br /><b>ELIMINAR NOM</b><br />Polsant aquest opció marqueu el nom per esborrar-lo de la base de dades. Cal tenir en compte que eliminar el nom és ben diferent d'eliminar la persona. Fer-ho <u>no</u> suposa eliminar la persona. Si és un AKA (mot o malnom) el que voleu treure, la persona conserva els seus altres noms. Si és el seu <u>únic</u> nom el que es voleu treure, la persona no s'eliminarà però restarà enregistrada com a <b>#pgv_lang[NN]#</b>. Tampoc perdrà els vincles de parentiu, fonts, notes, etc.<br /><br />Com funciona? Us demana confirmació per esborrar-lo. Continuant la visita podeu veure que el nom és encara visible com si l'eliminació no s'hagués produït.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~AFEGIR UN ALTRE NOM~<br /><br />Aquest enllaç us permet afegir un altre nom a la persona, altrament dit àlies (malnom, motiu, diminutiu, nom familiar,...). Es fa sense canviar el seu antic nom.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Polsant l'enllaç es podeu afegir mainada a aquesta família.  \"Aquesta família\", en aquest cas, son el pare i la mare de la persona principal de la pantalla.<br /><br />Tingueu present doncs que esteu afegint un germà o germana d'aquesta persona. És fàcil de fer: polseu l'enllaç, ompliu els caixetins de la finestreta que s'obre i llestos!.<br /><br />Si cal afegir un fill o filla de la persona principal, córrer una mica més avall i polsar l'enllaç corresponent de l'apartat \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Polsant aquest l'enllaç podeu afegir un fill d'aquesta família.  \"Aquesta família\" és, en aquest cas, la formada per la persona principal de la pantalla i el seu o la seva cònjuge.<br /><br />Cal que tingueu clar que el fareu és afegir un fill o filla d'aquesta persona. És fàcil de fer: polseu l'enllaç, ompliu els caixetins de la finestreta que s'obre i llestos!<br /><br />Si voleu afegir un germà o germana de la persona principal, cal córrer una mica cap amunt i polsar l'enllaç corresponent de l'apartat \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Polsant aquí podeu vincular aquesta persona com a fill d'una família existent.<br /><br />Suposem que es desconeixien prèviament els pares de l'esmentada persona i més tard es descobreix que ja figuraven a la base de dades.<br /><br />Solament us cal polsar l'enllaç, entrar l'ID de la família i llestos. Si desconeixeu l'ID de la família podeu fer una recerca.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Polsant aquí us permet vincular aquesta persona com a cònjuge d'una família prèviament existent a la base de dades de la que, fina ara, se'n desconeixia el marit. Tots els esdeveniments, informació del casament i mainada conservaran els vincles actuals amb la família.<br /><br />Polseu l'enllaç, entreu l'ID de la família i llestos. És una opció d'edició avançada que podeu fer servir solament si la família ja existeix prèviament. Si el que voleu és crear una <u>nova</u> família, cal que empreu l'enllaç <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Polsant aquí podeu crear una <u>nova</u> persona masculina i vincular-la a la principal com a nou marit.<br /><br />Al fer-ho sortirà una finestra on us cal omplir quans més camps es pugui, millor. Desprès polseu el botó <b>Desar</b>.<br /><br />Això és tot que us cal per fer-ho.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Polsant aquí us permet vincular aquesta persona a una altra, prèviament existent, com a nou marit. Això farà que es creï una nova família amb el marit que heu seleccionat. També tindreu l'opció d'aportar dades sobre el casament d'aquesta nova família.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Polsant aquest enllaç, podeu afegir un <u>nou</u> fill a aquesta persona, creant una família monoparental.<br /><br />Solament polsant l'enllaç us apareixerà una finestra emergent on afegir-hi la nova persona. Ompliu tants camps com sigui possible i polseu el botó <b>Desa</b>.";
$pgv_lang["link_wife_help"]			= "~#pgv_lang[link_as_wife]#~<br /><br />Polsant aquí podeu vincular aquesta persona com a esposa d'una família prèviament existent a la base de dades.<br /><br />És una opció d'edició avançada que solament podeu emprar si la família ja existeix. Si el que es voleu és crear una <u>nova</u> família, cal que aneu a l'enllaç <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]			= "~#pgv_lang[add_new_wife]#~<br /><br />Polsant aquí podeu crear una <u>nova</u> persona femenina i vincular-la a la principal com a nova esposa.<br /><br />Al fer-ho sortirà una finestra on cal que ompliu quans més camps pugueu, millor. Desprès polseu el botó <b>Desar</b>.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Polsant aquí us permet vincular aquesta persona a una altra, prèviament existent, com a nova muller. Això farà que es creï una nova família amb l'esposa que heu seleccionat. També tindreu opció d'aportar dades sobre el casament d'aquesta nova família.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~AFEGIR NOU PARE o MARE~<br /><br />Hi han probablement diverses persones al GEDCOM sense registre del pare o la mare.<br /><br />En aquest cas a la pàgina <b>#pgv_lang[indi_info]#</b>, a la pestanya <b>#pgv_lang[relatives]#</b>, i a la taula <b>#pgv_lang[as_child]#</b>, podeu trobar-hi enllaços per afegir un <u>nou</u> pare o mare.<br /><br />Cal que tingueu clar que això el que fa és afegir una <u>nova</u> persona. Si el pare o la mare ja tenen un registre a la base de dades, us cal emprar l'enllaç <b>#pgv_lang[link_as_child]#</b>, amb el que podeu cercar la seva pàgina <b>#pgv_lang[indi_info]#</b> sota la darrera taula.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Quan hi ha aquesta opció marcada, podeu veure tots els registres de fonts o notes d'aquesta persona. Si no ho està, les notes o fonts relacionades amb altres esdeveniments d'aquesta persona, no es mostraran.";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br /><br />Quan hi ha aquesta opció marcada, la pestanya «#pgv_lang[relatives]#» mostra diferències entre dates d'aquesta manera:<ul><li><b>dates de naixement dels cònjuges.</b><br />Un valor negatiu indica que la segona parella té més edat que la primera.</li><li><b>data de casament i data de naixement del primer fill.</b><br />Un valor negatiu indica que va néixer abans del casament o que aquesta data és incorrecta.</li><li><b>dates de naixements dels germans.</b><br />Un valor negatiu indica que l'ordre dels germans és incorrecte o que ho és alguna de les dates de naixement.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~AFEGIR ESDEVENIMENTS~<br /><br />Aquí us permet afegir un esdeveniment al registre que esteu editant.<br /><br />Primer cal que escolliu l'esdeveniment a la llista desplegable i desprès polseu el botó <b>Afegir</b>. Tots els esdeveniments possibles que podeu introduir son a la llista.";
$pgv_lang["add_custom_facts_help"]		= "~Afegir un esdeveniment personalitzat~<br /><br />Si no podeu trobar l'esdeveniment desitjat a la llista del GEDCOM, també podeu entrar-ne un de <b>personalitzat</b>.<br /><br />Fer-ho és tant senzill com entrar-ne un de predefinit. L'única diferència es que cal donar-li un nom per comptes de triar-lo de la llista. Per fer-ho disposeu del darrer camp: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~AFEGIR UNA NOVA NOTA~<br /><br />Si teniu una nota per acompanyar aquest registre, aquest és el lloc per fer-ho.<br /><br />Polseu l'enllaç i s'obrirà una finestra on escriure-hi la nota. En acabar polseu el botó de sota el caixetí, tanqueu la finestra i ja està.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Polsant l'enllaç <b>#pgv_lang[add_shared_note]#</b>, s'obre una nova finestra. Podeu escollir entre vincular a una nota compartida preexistent o crear-ne una de nova tot i vinculant-la al mateix temps.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~AFEGIR UNA NOVA RESSENYA DE FONT~<br /><br />Aquí podeu afegir una <b>ressenya</b> de font a aquest registre.<br /><br />Polsant l'enllaç, s'obrirà una finestra on podreu escollir la font entre les de la llista (Cercar ID) o en creeu una de nova i desprès afegiu la ressenya.<br /><br />Posar fonts és important en genealogia doncs permet a altres investigadors verificar de on s'ha obtingut la informació.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />Afegir fitxers multimèdia (MM) al GEDCOM és una utilitat molt bonica. Malgrat que aquest programa ja tingui bona pinta sense, si hi afegiu fotografies o altres MM, encara estarà millor.<br /><br /><b>Què en coneixeu dels fitxers MM?</b><br />Hi ha diversos formats. Malgrat que el PhpGedView pot incorporar-ne molts, hi ha coses que cal tenir en compte.<br /><ul><li><b>Formats</b><br />Les fotografies poden editar-se i guardar-se en diversos formats. Per exemple, .jpg, .png, .bmp, .gif, etc. Si feu servir el mateix original per crear cada un dels formats, la imatge sortirà amb la mateixa mida, independentment del format. Tanmateix les imatges emmagatzemades a la base de dades poden variar considerablement de volum. Generalment les imatges .jpg es consideren les més eficients en termes d'espai.</li><li><b>Volum de la imatge</b><br />La grandària de la imatge original afecta al volum del fitxer. La fotografia cal que es pugui veure sense haver de fer córrer la pantalla. L'alçada o amplada màximes no han d'ésser majors que les de la pantalla. El PhpGedView està dissenyat per pantalles de 1024x768 píxels, però no es disposa de tot aquest espai per visionar fotografies. La seva mida ha d'anar en concordança. Cal reduir el volum dels fitxers. Les imatges més petites son més desitjables.</li><li><b>Resolució</b><br />La resolució d'una fotografia es mesura en \"dpi\" (dots/inch-punts/polzada), però solament val per a imatges impreses. Quan considerem imatges mostrades a pantalla, el correcte és emprar el nombre total de punts o píxels. Impresa, la imatge pot tenir una resolució de 150 - 300 dpi o més depenent de la impressora. Les resolucions de pantalla rarament son millors de 50 píxels per polzada. Si la imatge no s'ha d'imprimir podeu rebaixar llur resolució (i conseqüentment llur volum) sense afectar-ne la qualitat. Si una imatge s'imprimeix amb una ampliació molt gran la qualitat se'n veurà afectada. Sortirà com gravada.</li><li><b>Amplitud de color</b><br />Una altra forma de disposar de fitxers petits és rebaixar la paleta de colors que fa servir. El nombre de colors pot anar del blanc i negre purs (dos colors) a color verdader (milions de colors) i qualsevol entremig. Podeu comprovar que, quans més colors s'empren, més volum tenen els fitxers.</li></ul><br /><b>Perquè és important que els fitxers tinguin poc volum?</b><ul><li>Primer de tot: l'espai web és limitat. Quan més grans son els fitxers, més espai cal per al web al servidor. A més espai, més cost.</li><li>Ample de banda. Quan major volum de dades tingui d'enviar el servidor, més caldrà pagar. Això és degut a que la capacitat de la connexió del servidor a Internet és limitada i l'enllaç ha de compartir-se entre totes les aplicacions que hi ha al servidor. El PhpGedView és una més de les aplicacions que comparteixen el servidor. El cost és normalment proporcional al volum de dades que cada aplicació envia i rep.</li><li>Temps de descàrrega. Si teniu grans fitxers, a l'usuari li cal esperar molta estona per baixar la pàgina del servidor. No tothom disposa d'una connexió per cable, banda ample o DSL.</li></ul><br /><b>Com carregar els MM</b><br />Hi ha dues formes de carregar fitxers multimèdia al lloc. Si hi ha molts fitxers millor contactar amb l'administrador per veure la millor manera de fer-ho. Si ell ho ha activat, podeu emprar el formulari Carregar Media del menú #pgv_lang[mgv]#. També podeu fer servir la opció Carregar a la pàgina Multimèdia.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Aquesta opció és per a generar miniatures de tots els arxius del directori actual que encara no n'hi ha. És millor fer-ho per aquí que haver d'anar prement l'enllaç  <b>#pgv_lang[gen_thumb]#</b> de cada un d'ells.<br /><br />Però si voleu mantenir el control sobre els arxius que han de tenir miniatures i quins no, no heu d'utilitzar aquesta opció. Heu de polsar a l'enllaç <b>#pgv_lang[gen_thumb]#</b>.";
$pgv_lang["add_facts_general_help"]      = "~Informació general sobre afegir~<br /><br />Quan s'ha afegit un esdeveniment, nota, font o fitxer multimèdia a un registre de la base de dades, cal que sigui posteriorment autoritzat per un usuari que tingui atribucions per fer-ho.<br /><br />Mentre no son acceptats, s'identifiquen com a \"pendents\" mitjançant un marc de color diferenciador. Tots els usuaris amb atributs d'edició poden veure aquests canvis al mateix temps que la informació original. La resta d'usuaris solament poden veure la informació original. Quan s'han acceptat les addicions, els marcs desapareixen i les noves dades surten normalment, substituint les antigues. En aquest moment tots els usuaris ja les poden veure.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Aquí podeu modificar els vostres paràmetres i preferències personals.<br /><br />Podeu canviar el nom, nom d'usuari, contrasenya, idioma, adreça de correu electrònic, presentació del lloc i mètode de contacte.<br /><br />No podeu canviar el registre ID INDI (que indica qui és cada ú a la base de dades) GEDCOM.  Això cal que ho faci un administrador.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />En aquest caixetí podeu canviar el nom d'usuari. Si no us agrada el que teniu o per altres raons, podeu fer-ho emprant aquest camp.<br /><br />El nom d'usuari diferencia entre <u>majúscules i minúscules</u>. Això fa que <b>Joan</b> no sigui el mateix que <b>joan</b> o <b>JOAN</b>.<br /><br />Empreu <u>solament</u> caràcters d'alfabets suportats pel PhpGedView. Pot anar amb majúscules o minúscules, amb o sense signes diacrítics, números, guions (-) i sotsratllat (_). Però <u>no</u> podeu posar-hi signes de puntuació o espais.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />En aquest caixetí podeu canviar-vos el nom de pila. Aquest és el nom amb el que els altres usuaris us veuran, un cop hagueu accedit.<br /><br />Atès que l'elecció del què posar-hi és personal, caldria informar-ne l'administrador si el canvieu doncs, si un tercer veu persones desconegudes en línea, pot sorpendre'l i demanar-li-ho i l'administrador no haver-se'n adonat. Avisant-lo li estalvieu un treball innecessari.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />En aquest caixetí podeu canviar-vos el cognom. Son els que veuran els altres usuaris, un cop hagueu accedit.<br /><br />Atès que l'elecció de què posar-hi és personal, caldria que n'informéssiu l'administrador si ho canvieu doncs, si un tercer veu persones desconegudes en línea, pot sorprendre'l i demanar-li-ho i l'administrador no haver-se'n adonat. Avisant-lo li estalvieu un treball innecessari.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Aquest és el número d'identificació (ID) que vincula l'usuari amb la informació que sobre ell s'emmagatzema a la base de dades genealògica.<br /><br />No es pot canviar l'ID. Ho ha de fer l'administrador. Si creieu que aquest ID no és correcte, cal contactar amb ell per a que ho faci.";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Aquesta és la persona base (arrel) a tots els gràfics.<br /><br />Si, per exemple, polseu l'enllaç a l'arbre genealògic, sortirà aquesta persona arrel al requadre situat més a l'esquerra. Aquesta persona no cal que sigui un mateix. Els gràfics poden començar per qualsevol altra (l'avi o una tieta per part de mare, per exemple) doncs hom té permís per a canviar-la en qualsevol moment.<br /><br />És possible canviar la persona arrel a molts gràfics però des d'aquesta pàgina es canvia la que surt per defecte.";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />És una bona pràctica canviar la contrasenya regularment. Cal tenir present que qualsevol que conegui el nom d'usuari i la contrasenya tindrà accés a les dades.<br /><br />Cal fer una contrasenya de com a mínim sis caràcters, quans més millor. Pot anar amb majúscules o minúscules, amb o sense signes diacrítics, números, guions (-) i sotsratllat (_). Però <u>no</u> podeu posar-hi signes de puntuació o espais. Podeu combinar majúscules, minúscules, números i altres caràcters. Per exemple: <b>5Z_q\$P4=r9</b>.<br /><br />A l'igual que passa amb el nom d'usuari, diferencia entre <u>majúscules i minúscules</u>. Això fa que <b>Contrasenya.Secreta!#13</b> sigui diferent de <b>contrasenya.secreta!#13</b> o de <b>CONTRASENYA.SECRETA!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Si heu canviat la contrasenya, cal confirmar si està be. Això es fa per assegurar que no heu comès cap error teclejant-la.<br /><br />Si la nova i la de confirmació no son idèntiques, apareixerà un missatge d'error i llavors, caldrà que entreu de nou la contrasenya i la confirmació.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Aquí podeu canviar el idioma en el que el PhpGedview us mostrarà totes les pàgines i missatges, desprès d'accedir.<br /><br />Quan accediu al lloc, el PhpGedView assumeix que voleu veure-ho tot amb l'idioma configurat com a Idioma Preferent al vostre navegador. Si aquesta assumpció és incorrecta, es pot esmenar aquí. Per exemple, el navegador d'un usuari està configurat per a l'anglès perquè aquest és l'idioma més emprat a Internet. Tanmateix, per a qüestions genealògiques, aquest usuari prefereix el Finès o l'Hebreu. Aquí és el lloc de fer-ho.<br /><br />L'administrador controla els idiomes disponibles. Si el que es vol no és a la llista, cal contactar amb ell.<br /><br />Cal recordar que el PhpGedView és un treball compartit per un equip internacional de voluntaris. Els experts van i venen. En conseqüència el suport per a idiomes diferents de l'anglès no és tant bo com el que caldria.<br /><br />Si veieu alguna cosa que no s’ha traduït, s’ha traduït incorrectament o es pot redactar millor, informeu-lo al vostre administrador. L'administrador sabrà com posar-se en contacte amb l'equip de desenvolupadors de PhpGedView per atendre les vostres preocupacions. Millor encara, oferiu-vos voluntaris una mica del vostre temps. Podem utilitzar l’ajuda.";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />L'adreça de correu correcta, és important per nosaltres per poder mantenir el contacte amb cada usuari.<br /><br />Si es canvia l'adreça de correu, tal com sol passar quan es canvia de proveïdor d'Internet, cal tenir present informar de la nova també aquí. No rebreu cap confirmació des d'aquest lloc quan la canvieu, però qualsevol futur missatge anirà ja a la nova adreça.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Aquest lloc pot disposar de diferents aparences o presentacions. Altres programes les anomenen \"pells\", però aquí son \"presentacions\".<br /><br />Cada presentació mostra les mateixes dades, però la seva forma i fins i tot la localització a la pantalla, pot variar força. Això és com posar una quadre en un altre marc i fins i tot en una altra habitació. La pintura és la mateixa, però la forma de mirar-la, completament diferent.<br /><br />Feu la prova. Trieu un altre presentació. Mireu-la, trieu-ne una altra, torneu-la a mirar i compareu-la. Escolliu la que més us agradi. Cada cop que entreu, sortirà la darrera presentació que heu fet servir. Fins i tot no us cal anar a aquesta pàgina de configuració per canviar de presentació preferida.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />El PhpGedView té diferents mètodes de contacte. L'administrador determina quin cal fer servir per posar-se en contacte amb ell. L'usuari disposa del control per triar quin mètode es farà servir per posar-se en contacte amb <u>ell mateix</u>. Depenent de la configuració del lloc, alguns dels mètodes explicats poden no estar disponibles.";
$pgv_lang["mail_option1_help"]			= "Amb aquesta opció fareu servir el sistema intern de missatgeria del PhpGedView i no rebreu correus electrònics.<br /><br />Solament rebreu missatges <u>interns</u> dels altres usuaris que, quan n'enviïn un, sortirà a la bústia personal del #pgv_lang[mygedview]#. Si heu tret aquest bloc del #pgv_lang[mygedview]#, no podreu veure cap missatge. Tanmateix els recuperareu així que configureu el #pgv_lang[mygedview]# per tornar a disposar del Bloc de Bústia.";
$pgv_lang["mail_option2_help"]			= "Aquesta opció és igual que la #pgv_lang[messaging]#, amb un afegitó: Com un extra, s'envia una còpia del missatge a l'adreça de correu electrònic que hagueu configurat a la pàgina del compte.<br /><br />Aquest és el mètode de contacte per defecte.";
$pgv_lang["mail_option3_help"]			= "Amb aquesta opció solament rebreu missatges de correu electrònic a l'adreça configurada a la pàgina del compte. El sistema intern de missatgeria del PhpGedView no es farà servir per res i mai hi haurà missatges a bloc de bústia personal del #pgv_lang[mygedview]#.";
$pgv_lang["mail_option4_help"]			= "Amb aquesta opció no es rebrà mai cap missatge. Fins i tot l'administrador no podrà posar-se en contacte.";

//-- Admin
$pgv_lang["admin_help"]				= "En aquesta pàgina hi ha enllaços cap a pàgines de configuració, administració, documentació i fitxers de registre.<br /><br /><b>#pgv_lang[system_time]#</b> just sota el títol de la pàgina hi surt l'hora del servidor en el que s'allotja aquest lloc. Això fa que si el servidor és ubicat a New York i l'usuari a França, mostri sis hores menys que el temps local si no és que, òbviament, el servidor funcioni amb horari Greenwich Mean Time (GMT). El temps que surt és el que té el servidor al moment d'obrir o actualitzar la pàgina.<br /><br /><b>ATENCIÓ!</b><br />Quan surt un missatge d'avís en vermell sota l'hora del sistema, vol dir que el fitxer <i>config.php</i> té activat el permís d'escriptura. Desprès de configurar el lloc, per <b>seguretat</b>, cal tornar a posar els permisos d'aquest fitxer com a sols lectura. Cal fer-ho <u>manualment</u>. No podem encarregar-li al PhpGedView que ho faci per nosaltres.";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~#pgv_lang[user_admin]#~<br /><br />En aquesta pàgina administreu els usuaris actuals i podeu afegir-ne de nous.<br /><br /><b>#pgv_lang[current_users]#</b><br />A la taula s'hi veuen els usuaris actuals, el seu estatus i atributs. Podeu <b>eliminar-ne</b> o <b>editar-ne</b>.<br /><br /><b>#pgv_lang[add_user]#</b><br />Aquest formulari és força semblant al que veuen els usuaris a la pàgina <b>#pgv_lang[editowndata]#</b>.<br /><br />En algunes entrades no hem fet un text d'ajuda especial per a l'administrador. En aquest casos sortirà el següent missatge:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />L'#pgv_lang[gedcomid]# identifica l'usuari. Cal que sigui assignat per l'administrador.<br /><br />Aquest ID es fa servir a diferents pàgines com <b>#pgv_lang[my_indi]#</b> i <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Cal assignar l'ID INDI GEDCOM separadament per cada un dels fitxers GEDCOM existents. Si un usuari no ha d'estar identificat dins el fitxer GEDCOM, cal que deixeu aquest camp en blanc.";
$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Per cada base de dades genealògica, podeu designar una <b>Persona Arrel</b> de l'usuari.<br /><br />Aquesta persona arrel, no cal que sigui el propi usuari: pot ésser qualsevol altra, malgrat que els usuaris prefereixin, probablement, que l'arbre genealògic comenci per ells mateixos.<br /><br />Si l'usuari té permís per editar la informació del seu compte, pot canviar-se aquest paràmetre ell mateix.";
$pgv_lang["useradmin_can_admin_help"]		= "~#pgv_lang[can_admin]# ~<br /><br />Si és marcat, l'usuari té les mateixes atribucions que l'administrador.<br /><br />Aquestes atribucions inclouen:<ul><li>Afegir / Suprimir / Editar usuaris</li><li>Distribuir missatges a tots els usuaris</li><li>Editar missatges de benvinguda</li><li>Editar i configurar fitxers d'idiomes</li><li>Actualitzar el PhpGedView</li><li>Canviar la configuració del programa i dels GEDCOM</li><li>Administrar GEDCOMs</li><li>Canviar paràmetres de privadesa</li><li>I d'altres no esmentades.</li></ul><br />L'usuari però, <u>no pot</u> modificar res del servidor fora del PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# ~<br /><br />Si és marcat i l'usuari té registre ID al fitxer GEDCOM, les dades del seu compte es sincronitzaran automàticament amb les seves dades al GEDCOM. Això fa que, quan el registre d'usuari GEDCOM s'editi, part de la informació com l'adreça de correu electrònic i el nom, sigui copiada al compte d'usuari. I al revés, quan s'editi el compte d'usuari la informació corresponent es copiï al registre GEDCOM.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />L'usuari pot tenir diferents drets d'accés i d'edició per a cada base de dades genealògica allotjada al sistema.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;No pot accedir a veure dades privades d'aquest GEDCOM.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;No pot editar dades o acceptar canvis però pot veure les privades.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;Pot editar dades però un altre usuari amb drets per <b>#pgv_lang[accept]#</b>, cal que aprovi els canvis abans de que passin definitivament a la base de dades i es facin públiques.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;L'usuari pot editar i a més pot autoritzar canvis fets per altres usuaris.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;L'usuari edita i autoritza canvist fets per altres usuaris. Pot també editar la configuració i els paràmetres de privadesa per <u>aquest</u> GEDCOM.</li></ul>Els Administradors del Sistema, identificats mitjançant el caixetí  <b>#pgv_lang[can_admin]#</b>, estan facultats automaticament amb els privilegis de <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Autoregistre</b><br />Un usuari pot accedir a un nou compte per mitjà del mòdul d'<b>autoregistre</b>.<br /><br />Un cop ho hagi fet, rebrà un missatge de correu electrònic amb un enllaç per confirmar la seva comanda d'accés. Un cop hagi actuat d'acord amb les instruccions del correu electrònic, aquest marcador s'activarà i podrem procedir amb el següent pas d'<b>#pgv_lang[verified_by_admin]#</b>. Mentre aquest marcador resti sense activar, cal esperar la confirmació de l'usuari.<br /><br /><b>Afegir usuari manualment</b><br />Si es fa servir aquesta forma de donar d'alta un usuari manualment, veureu aquest marcador activat.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />Si un usuari ha fet servir el mòdul d'autoregistre i s'ha autoconfirmat, el darrer pas abans de que el seu compte s'activi, és que l'administrador l'autoritzi.<br /><br />Un cop fet això, l'usuari rebrà un correu electrònic dient-li que el seu nou compte ja és actiu. Llavors podrà accedir amb el nom d'usuari i la contrasenya escollits al demanar l'accés.";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />Aquest formulari serveix per a que l'administrador canviï dades del compte dels usuaris.<br /><br />És molt semblant al d'<b>#pgv_lang[add_user]#</b> i al de <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]		= "~#pgv_lang[visibleonline]#~<br /><br />Aquest marcador controla que l'usuari quan ha accedit pugui veure i ésser vist per la resta d'usuaris que també ho tinguin activat.<br /><br />Quan no és marcat, l'usuari resta invisible pels altres (compta com anònim), però tampoc pot veure qui ha accedit. Quan està marcat, passa just el contrari.";
$pgv_lang["useradmin_editaccount_help"]			= "~#pgv_lang[editaccount]#~<br /><br />Quan està marcat, l'usuari pot editar les dades del seu compte. Malgrat que no sigui una opció gaire recomanable, es pot crear un nom d'usuari i contrasenya per compartir entre diversos usuaris. Quan és desmarcat per a usuaris amb compte compartit, preserva que un d'ells pugui modificar-ne les dades que, d'aquesta forma, queda restringit per que ho faci l'administrador.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Quan està marcat a l'usuari solament se li permet accedir a persones vives amb les que hi estigui emparentat. Podrà veure qualsevol persona compresa dins del paràmetre de <i>#pgv_lang[user_path_length]#</i>. Es pot generalitzar la privadesa de parentiu per a tots els usuaris activant aquesta opció als paràmetres de privadesa del GEDCOM.<br /><br />Per a que es pugui accedir a detalls de cap persona viva, aquesta opció requereix que l'usuari estigui associat prèviament a un ID GEDCOM.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Si hi ha activat l'<i>#pgv_lang[user_relationship_priv]#</i>, aquest usuari solament podrà veure o editar persones vives fins al nombre especificat de graus.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Quan està marcat el sistema acceptarà automàticament qualsevol canvi fet per l'usuari. Caldrà que també disposi al GEDCOM de potestat per Acceptar per a que això tingui efecte.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />En aquesta pàgina podeu habilitar llocs remots així com rebutjar adreces IP.<br /><br />Per habilitar llocs remots cal entrar-ne el títol, l'URL, l'id de la base de dades (opcional), el nom d'usuari i la contrasenya del servidor web remot.<br /><br />L'exclusió d'adreces IP es fa entrant qualsevol rang d'adreça vàlid. Per exemple, 212.10.*.*  Els llocs remots dins dels rangs compresos a la llista d'exclusions no podran accedir al servidor web. També és possible rebutjar adreces concretes.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />Per habilitar un servidor remot cal entrar llur títol, l'URL del servidor web remot, l'id de la base de dades (opcional), el nom d'usuari i la contrasenya. Polseu el botó Afegir per a completar el procés. Si el lloc remot permet autenticació anònima podeu deixar en blanc el nom d'usuari i la contrasenya.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "Les adreces IPv4 estan formades per 4 segments separats per \".\" (punt) i contenen nombres decimals en el rang de zero a 255 sense zeros principals. Alguns exemples són: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> o <b>212.10.*.29</b> . Els segments que falten en aquests exemples s'interpretaran com \"*\" (asterisc), amb el símbol \"*\" que significa <i>coincideix amb qualsevol número en aquesta posició</i>.<br /><br />Les adreces IPv6 consisteixen en 8 segments separats per \":\" (dos punts) i que contenen números hexadecimals de 4 dígits. Aquests nombres no han de tenir zeros de punteria, i la primera seqüència de zeros pot ser eliminada i substituïda per un parell de símbols \":\" (dos punts). Si necessiteu utilitzar la <i>coincideix amb qualsevol número en aquesta posició</i>, necessiteu inserir explícitament \"*\" (asterisc) allà. Alguns exemples són: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> o <b>23:0:*::*:*</b> . En aquests exemples, el parell de dos punts representa una seqüència de 3 nombres, cadascun dels quals és zero, així: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />Per evitar que les adreces IPv4 o IPv6 específiques accedeixin al vostre lloc, introduïu una adreça IP exacta o un rang d'adreça IP vàlid i feu clic al botó Afegeix (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />Quan es detecta un intent de pirateig, PhpGedView evitarà automàticament l'accés des d'aquesta adreça IP durant una hora.<br /><br />Podeu afegir les vostres pròpies denegacions temporals d'accés introduint l'adreça IPv4 o IPv6 per bloquejar-la juntament amb la data i l'hora d'expiració de la negació d'accés al camp Comentaris. Assegureu-vos d'utilitzar el format correcte per a la informació de venciment. Si la informació de venciment no s'ha introduït correctament, la denegació d'accés no caducarà automàticament.<br /><br />L'expiració s'ha d'introduir en el format següent: <b>aaaa.mm.dd@hh:mm</b>. Per exemple, <b>2012.12.23@23:59</b>. Tingueu en compte l'ús del rellotge les 24 hores.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]	= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView proporciona automàticament als motors de cerca fitxers de dades més petits amb menys enllaços. Les dades es limiten a la persona i la família immediata, sense afegir informació sobre els pares o els néts. Molts informes i pàgines que requereixen molts servidors, com ara el calendari, estan fora dels límits dels motors de cerca.<br /><br />Molts motors de cerca populars com Google i Bing es detectaran automàticament. Si no es reconeix automàticament un motor de cerca i voleu proporcionar-li dades per indexar-les, podeu introduir la seva adreça IPv4 o IPv6 aquí. Si voleu excloure completament aquest nou motor de cerca, el llistareu a la secció <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Si voleu veure quines dades es proporcionen als motors de cerca per indexar, indiqueu la vostra pròpia adreça IP aquí.&nbsp; <span class='warning'>AVÍS:</span>&nbsp; Això <b>bloquejarà</b> la interfície d'administració i haureu de suprimir l'adreça IP iniciant la sessió des d'una altra màquina amb una adreça IP diferent o editant manualment el taula <i>#GLOBALS[TBLPREFIX]#ip_address</i> de base de dades.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Motor de recerca detectat~<br /><br />El PhpGedView forneix automàticament dades als motors de recerca en diminuts fitxers de dades amb breus enllaços. Les dades es limiten a la persona i llur família de primer grau, sense informació sobre avis o néts. Alguns informes i pàgines intensives com el calendari, resten fora de l'abast dels recercadors.<br /><br />Els intents dels recercadors d'accedir-hi, donen com a resultat que aparegui aquesta pàgina. Si esteu llegint aquest text és perquè el programa us identifica com un motor de recerca. A baix hi ha la llista de pàgines habilitades com a motors de recerca i que poden fornir dades abreujades.<br /><br />Els usuaris reals que emprin els enllaços d'aquest motors de recerca, podran veure les dades i pàgines completes i no els hi apareixerà aquesta pàgina.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Carregar fitxers GEDCOM</b><br />Podeu fer-ho en línea, des de qualsevol lloc i sense necessitat d'emprar un programa ftp.<br /><br /><b>Afegir fitxers GEDCOM</b><br />Si al directori GEDCOM hi ha un fitxer carregat prèviament, podeu fer-lo servir sense que us calgui carregar-lo de nou. A vegades, degut al limitacions de volum us caldrà fer servir l'opció afegir.<br /><br />Tant un procediment com l'altre poden dur-se a terme en quatre senzills passos. Solament el Pas 1 és diferent en un cas o l'altre.";
$pgv_lang["gedcom_configfile_help"]		= "~FITXER DE CONFIGURACIÓ DEL GEDCOM~<br /><br />Aquest és el fitxer on s'emmagatzemen tots els paràmetres bàsics relacionats amb les bases de dades genealògiques. Hi ha un fitxer independent per a cada una d'elles.<br /><br />Podeu veure el nom i la ubicació de cada fitxer a la taula <b>#pgv_lang[current_gedcoms]#</b> de la pàgina <b>#pgv_lang[gedcom_adm_head]#</b>.";
$pgv_lang["default_gedcom_help"]		= "~GEDCOM PER DEFECTE~<br /><br />Si hi ha més d'una base de dades genealògica, podeu determinar quina d'elles serà la que s'obri per defecte.<br /><br />És la que apareixerà primerament a tots els visitants i usuaris que no hagin accedit.<br /><br />Els usuaris que puguin editar els paràmetres del seu compte, poden modificar aquesta opció per defecte. En aquest cas, la base de dades preferida per cada usuari, sortirà així que accedeixi.";
$pgv_lang["delete_gedcom_help"]			= "~ELIMINAR UN GEDCOM~<br /><br />El PhpGedView crea la seva base de dades a partir d'un fitxer GEDCOM prèviament carregat. Quan seleccioneu <b>Eliminar</b>, s'esborra aquesta secció de la base de dades. L'ordre d'eliminar requereix confirmació.<br /><br />Excepte que s'hagi esborrat deliberadament del PhpGedView, el fitxer GEDCOM original, romandrà al directori on va ésser carregat. Si més endavant voleu tornar a treballar amb ell, no caldrà carregar-lo de nou. En aquest cas es pot feu servir la funció <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Quan feu servir la funció <b>#pgv_lang[add_gedcom]#</b>, es dóna per entès que hi ha carregat prèviament el fitxer GEDCOM al servidor emprant un programa o mètode <u>extern</u> al PhpGedView, per exemple, <i>ftp</i> o <i>per xarxa</i>.  El fitxer pot haver-se pujat també pel procediment <b>#pgv_lang[upload_gedcom]#</b>.<br /><br />Si no hi ha el fitxer d'entrada GEDCOM al servidor, <u>cal</u> pujar-lo primerament, abans de començar a Afegir.<br /><br />Per comptes de carregar un fitxer GEDCOM, també podeu pujar un ZIP contenint-lo, be directament amb el PhpGedView o amb un programa extern. El PhpGedView reconeixerà aquest ZIP automàticament i el descomprimirà.<br /><br />Si hi ha un altre GEDCOM amb el mateix nom al PhpGedView, serà sobreescrit. Tanmateix, es preservaran tots els paràmetres GEDCOM prèviament existents.<br /><br />El sistema guia pas a pas a través del procediment.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Podeu iniciar una base de dades genealògica de bell nou.<br /><br />Aquest procediment solament requereix uns senzills passos. El Pas 1 difereix del que ja coneixeu per carregar i afegir. La resta de passos us seran familiars.<ol><li><b>Anomeneu el nou GEDCOM</b><br />Teclegeu el nom del nou GEDCOM <u>sense</u> l'extensió <b>.ged</b>. Es crearà el nou fitxer al directori escollit al caixetí de sobre el que s'entra el nom. Polseu <b>Afegir</b>.</li><li><b>Pàgina de configuració</b><br />Ja coneixeu aquesta pàgina on s'hi configuren els paràmetres del nou fitxer GEDCOM.</li><li><b>Validar</b><br />Ja coneixeu aquesta pàgina; el nou GEDCOM és revisat. Com que no conté res, serà correcte.</li><li><b>Importar registres</b><br />Si hi ha solament un registre a importar, acabarà ràpid.</li></ol>Això és tot. Desprès caldrà que aneu a l'Arbre Genealògic per veure la primera persona del nou GEDCOM. Polseu sobre el nom de la persona i comenceu a editar-la. Desprès d'això aneu vinculant nous individus a aquesta primera persona.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Des d'aquesta pàgina podeu descarregar la base de dades genealògica  en format GEDCOM. Per importar-la a un altre programa de genealogia o per compartir aquesta informació amb altres.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />La pàgina #pgv_lang[gedcom_adm_head]# és el centre de control per administrar totes les bases de dades genealògiques.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />A la capçalera de la taula <b>#pgv_lang[current_gedcoms]#</b> hi surt una fila amb quatre enllaços:<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />A la taula de <b>#pgv_lang[current_gedcoms]#</b>, cada base de dades genealògica es llista separadament i hi han les següents opcions per a cada una d'elles:<ul><li>Importar</li><li>Eliminar</li><li>Descarregar</li><li>Editar configuració</li><li>Editar privadesa</li><li>Fitxers SearchLog</li></ul>Editar privadesa surt aquí degut a que cada GEDCOM té el seu propi fitxer de privadesa.<br /><br />Cada línea d'aquesta taula és autodescriptiva. El PhpGedView pot configurar-se per enregistrar totes les recerques a la base de dades. Els fitxers de registre SearchLog podeu inspeccionar-los mitjançant els enllaços d'aquesta pàgina.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]	= "~CONFIGURAR EL GEDCOM~<br /><br />Cada base de dades genealògica emprada pel PhpGedView té el seu propi <b>Fitxer de Configuració</b>.<br /><br />En aquest formulari podeu configurar algunes opcions com el títol de la base de dades, idioma, format del calendari, opcions de correu electrònic, registres de recerques a la base de dades, META capçaleres HTML, supressió de cognoms de la llista de Cognoms més habituals, etc.";
$pgv_lang["import_gedcom_help"]			= "~IMPORTAR UN GEDCOM~<br /><br />En molts cassos importar d'un fitxer GEDCOM creat externament deriva en canvis massius a la base de dades genealògica.<br /><br />Els passos a fer segueixen una seqüència i calen completar-se en l'ordre prescrit a fi de que la base de dades sigui utilitzable.<br /><br />Si, per alguna raó, no completeu aquests passos en l'ordre correcte, sortirà un missatge d'<u>avís</u> que el GEDCOM no s'ha importat encara. Per corregir aquest problema, polseu l'enllaç <b>Importar GEDCOM</b> per importar el fitxer.<br /><br />Els paràmetres de configuració preexistents del GEDCOM no es canviaran reimportant-lo. Les dades existents seran però tanmateix, sobreescrites.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />A diferència de la funció <b>#pgv_lang[add_gedcom]#</b>, el fitxer no ha d'ésser al servidor.<br /><br />Al Pas 1 seleccioneu un fitxer GEDCOM de vostre l'ordinador. Heu d'escriure el nom complet i el camí al caixetí o fer servir el botó <b>Cercar</b> de la pàgina.<br /><br />Amb aquesta funció també podeu carregar un fitxer ZIP contenint el GEDCOM. El PhpGedView el reconeixerà i descomprimirà automàticament.<br /><br />Si ja hi ha un GEDCOM amb el mateix nom serà, desprès de demanar-vos-en confirmació, sobreescrit. Tanmateix tots els paràmetres del GEDCOM entrats prèviament, es preservaran.<br /><br />Podeu trobar més ajuda a altres pàgines del procediment.";
$pgv_lang["validate_gedcom_help"]		= "~COMPROVAR EL GEDCOM~<br /><br />Aquest és el tercer pas del procediment d'afegir dades d'un GEDCOM creat externament a la base de dades genealògica.<br /><br />El PhpGedView revisa el fitxer d'entrada per si té un format de dades correcte, format de llocs, joc de caràcters, etc. Algunes desavinences amb l'estàndard GEDCOM 5.5.1, al que s'ha adherit el PhpGedView, poden corregir-se automàticament. Per exemple els finals de línea Macintosh o l'inadequat ús del format de llocs. Quan passa això apareix un missatge informant que s'han modificat les dades. Per altres anomalies surt un missatge d'avis amb la solució recomanada.<br /><br /><b>Eines opcionals</b><br />De moment solament disposeu d'una eina addicional: <b>Canviar l'ID de la persona a...</b>.<br /><br /><b>Més ajuda</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~CONVERTIR D'ANSI A UTF-8~<br /><br />Per assegurar que la informació del fitxer GEDCOM d'entrada es processa i visualitza correctament, cal que aquests fitxers siguin codificats en UTF-8.<br /><br />Alguns del més moderns programes de genealogia poden exportar les seves dades a un fitxer GEDCOM codificat en UTF-8. Altres programes però no tenen aquesta possibilitat. Si el programa que feu servir no la té, el PhpGedView pot fer-ho.<br /><br />Quan PhpGedView comprova el fitxer d'entrada detecta el tipus de codificació i us ho adverteix.";
$pgv_lang["detected_ansi2utf_help"]		= "~DETECTADA CODIFICACIÓ ANSI~<br /><br />El fitxer GEDCOM que ara s'està comprovant és codificat amb el joc de caràcters ANSI. És altament recomanable convertir aquesta codificació a UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~DETECTAT UN FORMAT INCORRECTE DE DATES~<br /><br /><b>CAL CANVIAR EL FORMAT DE LES DATES</b><br /><br />El format de dates estàndard pel PhpGedView, d'acord amb l'estàndard GEDCOM 5.5.1, és <b>DD&nbsp;MMM&nbsp;YYYY</b> (per exemple 01&nbsp;JAN&nbsp;2004)<br /><br />Si, un cop els fitxer GEDCOM hagi sigut comprovat, apareix un missatge que s'ha detectat un format incorrecte, el PhpGedView convertirà les dates amb format incorrecte al que està prescrit per l'estàndard.<br /><br />Tanmateix teniu l'opció d'escollir entre \"<b>dia</b> abans del mes\" (DD&nbsp;MMM&nbsp;YYYY), o \"<b>mes</b> abans del dia\" (MMM&nbsp;DD&nbsp;YYYY).<br /><br />És recomanable emprar el primer format (dia abans del mes).";
$pgv_lang["change_indi2id_help"]		= "~CANVIAR L'ID DE LA PERSONA A...~<br /><br />Aquesta eina ha sigut dissenyada per a usuaris quins programes genealògics fan servir diferents ID de persona cada cop que s'exporta el fitxer GEDCOM. Per exemple, el primer cop que s'exporta el GEDCOM un determinat número ID pot ésser el I100, però la propera vegada que es fa una exportació, a la mateixa persona se li assigna el I234. Aquests canvis dificulten l'administració del PhpGedView perquè l'ID és la forma de referenciar la gent.<br /><br />Molts programes genealògics també fan servir les etiquetes RIN o REFN per donar a cada persona un identificador únic que la referenciï. Aquesta eina canviarà tots els ID de les persones al fitxer GEDCOM pel que s'especifiqui (RIN or REFN).";
$pgv_lang["edit_privacy_help"]			= "En aquesta pàgina es podeu crear paràmetres de Privadesa per al GEDCOM seleccionat.<br /><br />Podeu mirar sota el títol de la pàgina per comprovar que esteu editant el fitxer de privadesa correcte. Surt així: (camí/nomdelgedcom_priv.php)<br /><br />Si calen molts paràmetres, podeu fer-hi canvis manualment. Podeu trobar més informació sobre aquesta qüestió al lloc web de PhpGedView.";
$pgv_lang["BOM_detected_help"]			= "~Detectada Marca d'Ordre de Bytes~<br /><br />El fitxer GEDCOM que esteu important té un codi especial de 3 bytes al començament. Aquest codi el fan servir alguns programes per indicar que el fitxer s'ha creat amb el joc de caràcters UTF-8.<br /><br />Això no es tracta pas d'un error, però el PhpGedView no funciona correctament quan els fitxers el porten. Heu de permetre que el PhpGedView l'elimini.";
$pgv_lang["invalid_header_help"]		= "~CAPÇALERA GEDCOM INCORRECTA~<br /><br />Un fitxer GEDCOM cal que comenci amb <b>0&nbsp;HEAD</b>. El PhpGedView ha detectat que el fitxer GEDCOM que esteu important no té <b>0&nbsp;HEAD</b> a la primera línea. Polsant al botó de Netejar, s'esborraran totes les línees abans de la primera <b>0&nbsp;HEAD</b>.<br /><br />Generalment aquest error és degut a que el programa emprat per generar el GEDCOM no l'ha fet correctament o no és un fitxer GEDCOM. Cal revisar que heu carregat el fitxer correcte i que comença amb una línea <b>0&nbsp;HEAD</b> i acaba amb una <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~DETECTAT UN FITXER MACINTOSH~<br /><br />El PhpGedView ha detectat que el fitxer GEDCOM s'ha creat amb un ordinador Macintosh.<ul><li>Els fitxers Macintosh acaben cada línea amb un codi de control CR. El CR és Ctrl+M.</li><li>Els fitxers Unix acaben cada línea amb un codi de control LF. L'LF és Ctrl+J.</li><li>El Windows i el DOS fan servir dues seqüències de codi, CR seguit d'LF.</li></ul>El PhpGedView necessita que tots els fitxers emprin finals de línea Unix o DOS. Polsant el botó Netejar es convertiran convenientment tots els finals de línea.";
$pgv_lang["cleanup_places_help"]		= "~NETEJA DE LLOCS~<br /><br />El PhpGedView ha detectat que el fitxer GEDCOM té posats llocs en etiquetes que no son destinades a llocs.<br /><br />Alguns programes genealògics com el Family Tree Maker, creen aquest tipus de fitxer. El PhpGedView pot treballar amb ell però apareixeran alguns llocs incorrectes al llistat de llocs.<br /><br />Per exemple, el GEDCOM pot portar la següent codificació<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Programador informàtic</div><br />D'acord amb l'estàndard GEDCOM 5.5.1 això caldria que es veges com<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Programador informàtic</div><br />Si seleccioneu <b>Si</b>, el PhpGedView corregirà automàticament aquests errors.";
$pgv_lang["empty_lines_detected_help"]	= "~DETECTADES LÍNEES BUIDES~<br /><br />El PhpGedView ha detectat que hi ha línees buides al fitxer d'entrada. Aquestes línees poden causar errors i cal eliminar-les abans d'importar-lo.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~CONFIGURAR EL PhpGedView~<br /><br />En aquesta pàgina configureu els paràmetres globals pel PhpGedView. Cal que ho feu així que hagueu instal·lat el programa i l'engegueu per primer cop.<br /><br />#pgv_lang[review_readme]#<br /><br />Com que son paràmetres <b>globals</b>, serveixen per a la totalitat del programa i per a qualsevol base de dades genealògica que feu servir al PhpGedView.<br /><br />Cada base de dades genealògica també té opcions de configuració addicionals que les fixareu polsant l'enllaç d'aquesta pàgina <b>#pgv_lang[admin_gedcoms]#</b><br /><br />També podeu accedir a la funció <b>#pgv_lang[gedcom_adm_head]#</b> des de la pàgina principal d'Administració, quin accés trobareu sota la icona #pgv_lang[mgv]# o a la capçalera de moltes pàgines. A la pàgina d'Administració l'enllaç rellevant s'anomena <b>#pgv_lang[manage_gedcoms]#.</b>";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Aquesta pàgina us permet barrejar dos registres GEDCOM del mateix fitxer.<br /><br />Això és pràctic per a qui hagi barrejat dos GEDCOMs i ara tingui gent, famílies i fonts duplicats.<br /><br />Consta de tres passos.<br /><ol><li>Entreu els dos ID GEDCOM. <u>Cal</u> que siguin del mateix tipus. No podeu barrejar persones amb famílies o amb fonts, per exemple.<br />Al camp <b>#pgv_lang[merge_to]#</b> entreu-hi l'ID del registre que voleu que sigui el nou, un cop la barreja s'hagi completat.<br />Al camp <b>#pgv_lang[merge_from]#</b> entreu-hi l'ID del registre quina informació es barrejarà dins del #pgv_lang[merge_to]#. Aquest s'esborrarà desprès de la barreja.</li><li>Seleccioneu els esdeveniments que es voleu mantenir dels dos registres, polsant els marcadors del costat dels que voleu conservar.</li><li>Reviseu els resultats de la barreja tal i com es fa als canvis fets en línea.</li></ol>Algú amb atributs per Acceptar ha d'autoritzar els canvis per a que esdevinguin permanents.";

//-- report engine
$pgv_lang["help_reportengine.php"]	= "~#pgv_lang[reports]#~<br /><br />Les entrades del menú de llistes generen fitxers PDF per a imprimir.<br /><br />El primer pas és escollir el tipus de llista. Un cop fet això us demana fornir informació específica com per exemple, per quines persones o famílies ha de començar i si posar-hi fotos o no. Quan la llista és a punt per generar-se, polseu el botó <b>#pgv_lang[download_report]#</b> per descarregar el resultat al vostre ordinador.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]	= "~FORMAT DE FITXER PDF~<br /><br />El Generador d'Informes PhpGedView produeix fitxers descarregables en format Adobe&reg; PDF. Les especificacions de l'estàndard GEDCOM 5.5.1, esmentades en diversos apartats d'aquest fitxer d'ajuda, també podeu baixar-vos-les en PDF. PDF és l'acrònim de <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br /><br />És un informe de la persona seleccionada i llurs avantpassats, impresa en format de fulletó. Comença per la primera persona i continua amb llurs pares, avis, besavis...<br /><br />Noteu que, de moment, l'informe ahnentafel és solament disponible en anglès.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br /><br />Amb aquest informe podeu llistat totes les persones nascudes una data o lloc determinats.";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br /><br />Aquest informe llista tots els parents de la persona seleccionada. Podeu escollir quins parents han de sortir-hi.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;mostrarà la persona seleccionada, llurs pares, germans i germanes.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;ho farà amb llurs cònjuges i mainada respectiva.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;posarà la persona, llurs pares, avis, besavis i continua arbre amunt amb tots els parents per llinatge.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;incorporarà totes les persones de la llista #pgv_lang[direct-ancestors]#&nbsp;&nbsp;&nbsp;però també inclourà oncles, besoncles i, a més a més, els germans de tots els avantpassats de l'arbre familiar. No inclourà la mainada dels germans (cosins).</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;llista els descendents de la persona (fils, néts, besnéts, etc.).</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;és una opció barreja de la de #pgv_lang[descendants]# i la d'#pgv_lang[ancestors]#, en un mateix informe.</li></ul>";
$pgv_lang["help_xml_reports"]	= "~Generador d'Informes~<br /><br />El Generador d'Informes de PhpGedView fa servir plantilles XML per generar informes PDF automàticament.<br /><br />El informes del desplegable <b>#pgv_lang[select_report]#</b> es generen en base als fitxers XML localitzats al directori \"reports\". Podeu crear els vostres propis personalitzats fent una còpia de les plantilles que venen amb la distribució i modificar-les. Per afegir-n'hi de personalitzats, solament cal que els poseu a l'esmentat directori i el PhpGedView ja els detectarà automàticament i els inclourà com a disponibles.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>CONTINGUT DE L'AJUDA</b>";
$pgv_lang["help_contents_gedcom_info"]		= "Informació GEDCOM";
$pgv_lang["help_contents_gedcom_places"]	= "Llocs al GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>CONTINGUT DE L'AJUDA<br /><br />ADMINISTRADOR D'ENTRADES D'AJUDA</b> afegit al començament de la llista.";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]				= "_Configura el PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Afegir vs Carregar";
$pgv_lang["ah4_help"]				= "_GEDCOM: Fitxer de configuració";
$pgv_lang["ah5_help"]				= "_GEDCOM: Per defecte";
$pgv_lang["ah6_help"]				= "_GEDCOM: Elimina";
$pgv_lang["ah7_help"]				= "_GEDCOM: Afegeix";
$pgv_lang["ah8_help"]				= "_GEDCOM: Creen un de nou";
$pgv_lang["ah9_help"]				= "_GEDCOM: Descarrega";
$pgv_lang["ah10_help"]				= "_GEDCOM: Pàgina d'administració";
$pgv_lang["ah11_help"]				= "_GEDCOM: Configura";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importa";
$pgv_lang["ah13_help"]				= "_GEDCOM: Carrega";
$pgv_lang["ah14_help"]				= "_GEDCOM: Comprova";
$pgv_lang["ah15_help"]				= "_GEDCOM: Converteix ANSI a UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Paràmetres de privadesa";
$pgv_lang["ah17_help"]				= "_Administració d'usuaris";
$pgv_lang["ah18_help"]				= "_Administració";
$pgv_lang["ah19_help"]				= "_GEDCOM: Eina multimèdia";
$pgv_lang["ah20_help"]				= "_GEDCOM: Canvia l'ID de la persona a...";
$pgv_lang["ah21_help"]				= "_Eines de traducció";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Configura idiomes suportats";
$pgv_lang["ah24_help"]				= "_User Information migrate (Index --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]				= "_Còpia de seguretat PhpGedView";
$pgv_lang["ah26_help"]				= "_Llista preguntes més freqüents: Edita";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~Gràfics estadístics~<br /><br />Aquesta és la pàgina resultant que mostra el gràfic estadístic de la base de dades, tal i com n'heu definit els paràmetres a la pàgina anterior.";
$pgv_lang["help_statistics.php"] = "~Gràfics estadístics~<br /><br />Aquesta pàgina us permet determinar el criteri per fer gràfics de diverses estadístiques de la base de dades.";
$pgv_lang["stat_help"]			= "~Opcions de Gràfics estadístics~<br /><br />Poden obtenir-se diversos gràfics estadístics de la base de dades.<br /><br />Seleccioneu els paràmetres des dels caixetins desplegables, desprès ajusteu les opcions a la segona secció.<br /><br />Les entrades incloses en cada gràfic depenen de les dades disponibles. Per exemple, no es poden incloure persones sense mes de naixement (p.e. així '1856') en un gràfic de naixements per mesos.";
$pgv_lang["stat_help_x"]		= "~Opcions de Gràfics estadístics~<br />~EIX X ~<br /><br />Hi ha disponibles les següents opcions per a l'eix de les X (horitzontal). Cada una es presentarà en funció del joc d'opcions dels eixos Y i Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;persones nascudes cada mes.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;defuncions per mesos.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;casaments per mesos.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;el nombre de primogènits per cada família per mesos.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;nombre de primers casaments per mesos.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;el nombre de mesos entre el casament i el naixement del primer fill per aquestes parelles.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;edat en morir en relació al període de temps que inclou l'any de naixement de cada persona.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;edat en morir en relació al període de temps que inclou l'any de defunció de la persona.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;mitjana d'edat de les persones a l'hora de casar-se.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;mitjana d'edat de les persones al moment del seu primer casament.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;mitjana de membres per família.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;col·locació de totes les persones o persones amb el nom especificat, per país.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;país de naixement.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;país de matrimoni.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;país de la mort.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;gràfic circular de persones amb fonts.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;gràfic circular de famílies amb fonts.</p>";
$pgv_lang["stat_help_y"]		= "~Opcions de Gràfics estadístics~<br />~EIX Y~<br /><br />Hi ha disponibles les següents opcions per a l'eix de les Y (vertical). Aquestes opcions modifiquen la forma de com es mostraran les entrades presentades a l'eix de les X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;mostra el nombre de persones de cada categoria definida a l'eix de les X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;calcula i mostra la proporció de cada ítem en les categories de l'eix de les X.</p>";
$pgv_lang["stat_help_z"]		= "~Opcions de Gràfics estadístics~<br />~EIX Z ~<br /><br />Les opcions següents son les disponibles per l'eix de les Z. Forneixen una subdivisió de les categories seleccionades a l'eix de les X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;mostra les entrades en una única columna per cada categoria de l'eix X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;mostra les entrades a doble columna (mascle i femella) per a cada categoria de l'eix X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;mostra les entrades en un nombre de columnes en relació als períodes de temps fixat a la propera secció, per a cada categoria de l'eix X.</p>";
$pgv_lang["stat_help_gwx"]		= "~Opcions de Gràfics estadístics~<br />~límits per l'eix X~<br /><br />Seleccioneu l'interval d'edat desitjat.<br /><br />Per exemple, <b>#pgv_lang[aft_marr]#</b> descriu el conjunt següent d'intervals de mesos:<div style=\"padding-left: 30px;\"> abans del matrimoni<br />del matrimoni a 8 mesos després<br />de 8 a 12<br />de 12 a 15<br />de 15 a 18<br />de 18 a 24<br />de 24 a 48<br />més de 48 mesos després del matrimoni</div><br />Quan vulgueu mostrar trimestres heu de triar <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]		= "~Opcions de Gràfics estadístics~<br />~Límits per l'eix X~<br /><br />Seleccioneu l'interval d'edat.<br /><br />Per exemple, un <b>interval de 10 anys</b> genera el següent joc de rangs d'edat:<div style=\"padding-left:30px;\">menors d'un any<br />un a 5 anys<br />6 a 10<br />11 a 20<br />21 a 30<br />31 a 40<br />41 a 50<br />51 a 60<br />61 a 70<br />71 a 80<br />81 a 90<br />91 a 100<br />majors de 100 anys</div>";
$pgv_lang["stat_help_gbx"]		= "~Opcions de Gràfics estadístics~<br />~Límits per l'eix X~<br /><br />Seleccioneu l'interval d'edat.<br /><br />Per exemple, un <b>interval de 2 anys</b> genera el següent joc de rangs d'edat: <div style=\"padding-left:30px;\">menors de 16 anys<br />16 a 18<br />19 a 20<br />21 a 22<br />23 a 24<br />25 a 26<br />27 a 28<br />29 a 30<br />31 a 32<br />33 a 35<br />36 a 40<br />41 a 50<br />majors de 50 anys</div>";
$pgv_lang["stat_help_gcx"]		= "~Opcions de Gràfics estadístics~<br />~Límits per l'eix X~<br /><br />Seleccioneu l'interval.<br /><br />Per exemple, <b>interval un fill</b> genera el següent joc de rangs de fills:<div style=\"padding-left:30px;\">sense mainada<br />un fill<br />dos fills<br />3, 4, 5, 6, 7, 8, 9, 10 fills<br />més de 10 fills</div>";
$pgv_lang["stat_help_gwz"]		= "~Opcions de Gràfics estadístics~<br />~Límits per l'eix Z~<br /><br />Seleccioneu l'any d'inici i l'interval desitjats<br /><br />Per exemple, <b>a partir del 1700 interval 50 anys</b> descriu el conjunt següent d’intervals de dates:<div style=\"padding-left: 30px;\">abans del 1700<br />1700 a 1749<br />1750 a 1799<br />1800 a 1849<br />1850 a 1899<br />1900 a 1949<br />1950 a 1999<br />2000 o posteriors</div>";
$pgv_lang["chart_type_help"]	= "~Opcions de Gràfics estadístics~<br /><br />Seleccioneu el que voleu veure al mapa gràfics. Podeu escollir:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;mostra la distribució per països de les persones de la base de dades.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;mostra els països en els que s'enregistra el cognom especificat.</div>";
$pgv_lang["google_chart_surname_help"]	= "~Opcions de Gràfics estadístics~<br /><br />Es mostrarà al mapa el nombre d'ocurrències del nom especificat. Si deixeu aquest camp buit, s'utilitzaran els cognoms més comuns.";
$pgv_lang["chart_area_help"]	= "~Opcions de Gràfics estadístics~<br /><br />Seleccioneu l'àrea geogràfica que voleu veure al mapa. Podeu escollir entre:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;mostra tots els continents.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;shows Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;mostra Amèrica del Sud.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;mostra Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;mostra l'Orient Mitjà.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;mostra Àfrica.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />En aquesta pàgina podreu gestionar fàcilment els vostres fitxers i directoris multimèdia.<br /><br />Quan creeu un nou subdirectori el  PhpGedView assegura que es mantindrà idèntica estructura de subdirectoris al directori <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>. Quan carregueu fitxers multimèdia, el PhpGedView pot crear-vos miniatures automàticament per compte vostre.<br /><br />Depenent de l'estatus del fitxer, al costat de cada imatge del llistat Multimèdia, podeu veure-hi les següents opcions. <ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Polsant aquesta opció us mena a una pàgina on podeu canviar el títol de l'objecte. Si no s'ha vinculat encara a cap persona, família o font de la base de dades activa, podeu establir-hi un enllaç. Podeu reanomenar el fitxer i fins i tot canviar-lo de lloc dins de la estructura del directori <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Si cal, el PhpGedView crearà automàticament els subdirectoris requerits o alguna miniatura extraviada.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Aquesta opció solament és disponible quan l'Administrador l'ha activat. Podeu veure i editar les dades primàries del fitxer GEDCOM associades a aquest objecte. Cal que aneu amb molt de compte si la feu servir.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Aquesta opció us permet eliminar qualsevol rastre del fitxer a la base de dades activa. La resta de bases de dades no es veuran afectades. Si el fitxer multimèdia no figura a cap altra base de dades, s'esborrarà juntament amb la seva miniatura associada..</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Aquesta opció us permet eliminar qualsevol rastre de l'objecte multimèdia de la base de dades activa. La resta de bases de dades no es veuran afectades. El fitxer multimèdia i la seva miniatura no s'esborraran.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Aquesta opció us permet eliminar tots els vincles de l'objecte multimèdia de la base de dades activa. El fitxer no s'esborrarà i l'objecte multimèdia amb el que és conegut a la base de dades activa, es conservarà. La resta de bases de dades no es veuran afectades.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Aquesta opció us permet establir enllaços entre el fitxer multimèdia i persones, famílies o fonts de la base de dades activa. Si cal, el PhpGedView també crearà l'objecte multimèdia amb el que el fitxer serà conegut a la base de dades.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Quan seleccioneu aquesta opció el PhpGedView crearà la miniatura perduda.</li></ul>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Simple filtre de recerca basat en els caràcters entrats. No s'admeten els comodins.";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Marcant aquest caixetí es veuran les miniatures.";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Us permet cercar en l'estructura de fitxers per localitzar l'entrada multimèdia que vulgueu vincular.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Cada entrada multimèdia pot estar associada a una o més persones, famílies o fonts de la base de dades.<br /><br />Per establir aquest vincle us cal entrar o cercar l'ID de la persona, família o font, al mateix temps que creeu l'entrada multimèdia. També podeu establir l'enllaç posteriorment, mitjançant les opcions d'edició de la Pàgina de Gestió de Multimèdia, o afegint entrades multimèdia mitjançant l'enllaç Afegir Multimèdia, disponible a les pàgines de detalls de la Persona, Família o Font.";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />El fitxer multimèdia que esteu pujant pot ser, i probablement serà, nomenat de forma diferent al servidor que al vostre ordinador. Això és així perquè sovint a l'ordinador local té un significat però és molt menys significatiu per a altres visitants del lloc. Cal que considereu també la possibilitat que vós mateix o algú altre torni a intentar carregar diferents fitxers anomenats \"joan.jpg\".<br /><br />En aquest camp especifiqueu-hi el nou nom del fitxer carregat. El que entreu aquí també es fa servir per anomenar la miniatura que pot ésser carregada per separat o generada automàticament. No cal que hi entreu l'extensió (jpg, gif, pdf, doc, etc.)<br /><br />Deixant aquest camp en blanc es conserva el nom original que té el fitxer al vostre ordinador.";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />L'administrador ha activat fins a #GLOBALS[MEDIA_DIRECTORY_LEVELS]# nivells de carpetes per sota la que hi ha per defecte anomenada <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Això us permet organitzar els fitxers multimèdia i redueix la possibilitat de col·lisió de noms.<br /><br />En aquest camp cal que especifiqueu la carpeta de destí en la que s'emmagatzemarà el fitxer multimèdia a carregar. El corresponent fitxer miniatura, be carregat a banda o generat automàticament, es desarà un una estructura similar de carpetes a <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> per comptes de <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. No cal que entreu la part <b>#GLOBALS[MEDIA_DIRECTORY]#</b> del nom de la carpeta de destí.<br /><br />Si no esteu segur sobre el que cal posar aquí, cal que contacteu amb l'administrador.";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />L'Administrador ha activat fins a #GLOBALS[MEDIA_DIRECTORY_LEVELS]# nivells de carpetes per sota de la <b>#GLOBALS[MEDIA_DIRECTORY]#</b> que hi ha per defecte. Això permet organitzar els fitxers multimèdia i redueix el risc de col·lisions de noms.<br /><br />En aquest camp podeu seleccionar la carpeta quin contingut voleu veure. Quan escolliu <b>#pgv_lang[all]#</b>, es mostraran tots els fitxers multimèdia sense tenir en compte la carpeta on son emmagatzemats. Es possible que es produeixi una llarga llista d'entrades.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En aquesta pàgina hi surt un llistat d'arxius.<br /><br />Els noms dels arxius s'ordenen alfabèticament.<br /><br /><b>ARXIUS</b><br />Sense ells no podem construir la base de dades. Hi ha una font per a qualsevol informació emmagatzemada a la base de dades. I aquesta font es conserva en un arxiu. Poden ser arxius personals, una institució, una base de dades pública, registres oficials o eclesiàstics, recursos d'Internet, etc. Per disposar d'accés a la font ens cal conèixer com i a quin lloc es localitza. Tota la informació necessària per localitzar una font cal que s'emmagatzemi el registre de l'arxiu.<br /><br />Un arxiu pot vincular-se a diverses font.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Aquí es veuen els detalls de l'arxiu. Juntament amb les fonts, els arxius son molt importants per als investigadors genealògics. Amb una informació acurada de fonts i arxius, es pot seguir la pista que ha fet servir un altre investigador per trobar la informació. Així es podrà localitzar la informació quan calgui.<br /><br />En aquesta pàgina podeu veure-hi informació sobre el títol de l'arxiu, l'adreça, correu electrònic i pàgina web.<br /><br />Darrera els detalls de l'arxiu hi va una llista de totes les fonts que té relacionades amb ell. Això permet veure tota la informació que s'ha obtingut d'un arxiu en particular.<br /><br />Si ho ha activat l'administrador, pot haver-hi una o dues icones de menú més a la pàgina:<ul><li><b>#pgv_lang[view_gedcom]#</b>, que us mostra la informació en format GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b>, que us permet posar-la al #pgv_lang[clip_cart]#. Des d'aquí podeu baixar-vos la informació en un fitxer format GEDCOM per importar-la dins d'un programa de genealogia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Quan polseu aquesta opció marqueu l'Arxiu per eliminar-lo de la base de dades.<br /><br />Com funciona? Suposem que teniu una bona raó per treure aquest arxiu. Polseu l'enllaç. Us demana confirmació per eliminar-lo. Continuant la visita, podeu veure que l'Arxiu encara existeix i es pot fer servir, que no s'ha eliminat.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Polsant aquest enllaç surt una finestra emergent amb la informació sobre l'Arxiu, tal i com s'emmagatzema a la base de dades.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Polsant aquest enllaç, podeu carregar al #pgv_lang[clip_cart]# la informació sobre l'Arxiu, tal i com s'emmagatzemen al GEDCOM.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />En aquest caixetí hi surten els noms dels Arxius tal i com estan emmagatzemats a la base de dades. Van en ordre alfabètic.<br /><br />Polsant-ne un de la llista, us mena a la pàgina #pgv_lang[repo_info]# en la que hi veureu un llistat de les fonts vinculades a l'Arxiu escollit.";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />En aquest caixetí hi surten els noms de les fonts vinculades a l'Arxiu. Van en ordre alfabètic.<br /><br />Polsant-ne una us mena a la pàgina de detalls de la font escollida.";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Canviar l'ordre de les entrades de la llista~<br /><br />Aquests botons son per a reordenar les entrades de la llista. Els blocs sortiran per l'ordre en que s'han llistat.<br /><br />Ressalteu l'entrada a moure i polseu el botó per fer-la anar amunt o avall.";
$pgv_lang["block_move_right_help"]	= "~Canviar les entrades de llista~<br /><br />Aquests botons son per a canviar una entrada d'una llista a una altra.<br /><br />Ressalteu l'entrada a moure i polseu un botó per moure-la o copiar-la vers la direcció de la fletxa. Feu servir els botons <b>»</b> i <b>«</b> per moure la ressaltada de les llistes de l'esquerra a les de la dreta, o a l'inrevés. Empreu els botons <b>&gt;</b> i <b>&lt;</b> per moure la ressaltada entre la llista #pgv_lang[available_blocks]# i la de la seva dreta o esquerra.<br /><br />Les entrades de la llista #pgv_lang[available_blocks]# no canvien, a no ser que es faci amb els botons #pgv_lang[move_right]# i #pgv_lang[move_left]#. Això és així perquè el mateix bloc por sortir diversos cops a la mateixa pàgina. El bloc HTML és un bon exemple del perquè pot caldre fer-ho.";
$pgv_lang["block_default_index"]	= "~Blocs per defecte a la pàgina #pgv_lang[welcome]#~<br /><br />Quan elimineu totes les entrades de les llistes #pgv_lang[main_section]# i #pgv_lang[right_section]#, o quan polseu el botó <b>#pgv_lang[reset_default_blocks]#</b>, la llista de blocs queda així:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]	= "~Blocs per defecte a la pàgina #pgv_lang[mygedview]#~<br /><br />Quan elimineu totes les entrades de les llistes #pgv_lang[main_section]# i #pgv_lang[right_section]#, o quan polseu el botó <b>#pgv_lang[reset_default_blocks]#</b>, la llista de blocs queda així:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"] = "~Preguntes més freqüents~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "La pàgina PMF (Preguntes més freqüents) pot contenir un resum o una llista de les preguntes i respostes sobre l'ús d'aquest lloc genealògic.<br /><br />El contingut d'aquesta pàgina és totalment a discreció dels administradors que controlen el contingut de cada entrada i l'ordre.";

// Help search
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Podeu fer recerques dins del manual d'ajuda del sistema PhpGedView. La funció #pgv_lang[hs_title]#, dóna un alt grau de control sobre la forma de com buscar i les opcions per fer-ho. Es fàcil trobar el que es vulgui.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br /><br />Entreu els mots o la frase a cercar.<br /><br />La recerca no discrimina entre majúscules o minúscules dels termes a buscar o del text examinat. Això fa que si busqueu <b>Persona</b>, trobi text contenint <b>Persona</b>, <b>persona</b>, o <b>PERSONA</b>. També es pot trobar text contenint <b>personal</b>, etc. atès que la recerca mira seqüències de caràcters, per comptes de paraules.<br /><br />Podeu fer recerques de diverses paraules alhora. Cal que entreu tot de paraules, separades cada una per un espai, d'aquesta forma: <b>persona&nbsp;família&nbsp;fill</b>. Quan s'entra més d'una paraula, el significat del que s'ha teclejat s'especifica al camp #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Aquí podeu determinar l'abast de la recerca.<br /><br />Els Administradors poden escollir entre cercar al Manual d'Usuari, al de Configuració o a tots dos. Els usuaris no poden triar. Atès no tenen accés a cap funció de configuració, solament accedeixen al Manual d'Usuari.<br /><br />Els manuals contenen no solament texts d'ajuda, sinó també certs texts per emplenar formularis d'entrada i altre material. Aquesta opció us permet determinar si s'examinarà el fitxer d'ajuda sencer o solament el text d'ajuda.";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br /><br />Cal que especifiqueu el significat del que heu entrat al camp #pgv_lang[hs_keyword]#, seleccionant entre les diverses possibilitats.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Si heu entrat <b>persona&nbsp;família&nbsp;fill</b>, aquesta opció cercarà text d'ajuda que contingui una de les paraules llistades. L'ordre de les paraules no importa. La forma de recerca és: \"Busca text d'ajuda que contingui <b>persona</b> <u>o</u> <b>família</b> <u>o</u> <b>fill</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Si heu entrat <b>persona&nbsp;família&nbsp;fill</b>, aquesta opció busca text que contingui totes les paraules llistades. L'ordre tampoc importa. La forma de recerca és: \"Busca text d'ajuda que contingui <b>persona</b> <u>i</u> <b>família</b> <u>i</u> <b>fill</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Si heu entrat <b>persona&nbsp;família&nbsp;fill</b>, aquesta opció busca text d'ajuda que contingui totes les paraules llistades en el mateix ordre en que s'han posat. La forma de recerca és: \"Busca text d'ajuda que contingui les paraules <b>persona&nbsp;família&nbsp;fill</b> exactament en aquest ordre, sense altres mots per entremig\".</dd></dl><br />Hi ha certes limitacions en aquest tipus de recerca. Alguns caràcters especials com <b>&quot; &lt; &gt; &quot;</b> etc. estan contingudes al text d'ajuda en forma de símbols i no poden localitzar-se formant part del text que s'entra. Cert text d'ajuda conté una mena de caràcter d'espai representat per <b>&amp;nbsp;</b> i no es podran localitzar frases contenint aquest caràcter.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Aquesta utilitat serveix als administradors del lloc per fer neteja de fitxers al directori Índex.<br /><br />Amb el temps, fitxers com registres d'accés, GEDCOM antics i còpies de seguretat antigues poden saturar el directori índex. Tenint en compte que alguns d'aquets fitxers han sigut creats directament pel programa, poden estar gestionats per l'usuari del compte del servidor web. Si n'hi ha que estan gestionats per l'usuari del servidor web, no hauríeu d'eliminar-los, malgrat que aquesta utilitat us permeti fer-ho.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
