<?php
/**
 * Danish language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * @author PGV Developers
 * @package PhpGedView
 * @version $Id: help_text.da.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />Teksten, der er indtastet her, vises, når din musemarkør svæver over Tekst-ikonet i brugerlisten. Du bør prøve at holde denne tekst så kort som muligt.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Indtast datoen, hvorefter denne brugers registrering skal behandles som en inspektion fra administratoren. Disse poster fremhæves på brugerlisten ved at vise brugernavnet i <span class='warning'>rødt</span>.<br /><br />Datoen skal angives på engelsk. Eksempler: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> osv.<br /><br />Når månedstallet og dagnummeret begge er i intervallet 1 til 12, bestemmer tegnsætningen (bindestreg eller skråstreg) betydningen med et bindestreg <b>-</b>, der betyder, at det første tal er dagen i måneden, mens en skråstreg <b>/</b> betyder, at det første tal er måneden.<br /><br />Hvis de oplysninger, der er indtastet her, er meningsløse for programmet, anvendes «yesterday», og denne bruger optagelse vil altid blive valgt til fremhævning. «tomorrow» og lignende tekster er ikke meningsfulde i denne sammenhæng og vil resultere i, at denne brugerpost aldrig bliver valgt til fremhævning.";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Vælg det format, som databaseeksporten skal oprettes i. Dit valg afhænger af kravene og kapaciteterne i det program, som du agter at importere den nyligt downloadede fil til. Du kan vælge:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Når denne indstilling er markeret, vil outputfilen passere fortrolighedskontrol i henhold til den valgte indstilling. Dette kan resultere i fjernelse af visse oplysninger. Outputtfilen indeholder kun de oplysninger, der normalt er synlige for en bruger med det angivne privilegieniveau.<br /><br />Hvis du kun har rettigheder #pgv_lang[gedadmin]#, kan du ikke angive, at outputfilen skal privatiseres i henhold til privilegieniveau #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Denne mulighed definerer en konstant sti, der skal forud for alle mediestier i outputfilen.<br /><br />For eksempel, hvis mediekataloget er konfigureret til at være \"/media\", og hvis den mediefil, der eksporteres, har en sti \"/media/billeder/xyz.jpg\", og du har indtastet \"c:\\mine billeder\\min familie\" i dette felt, vil den resulterende mediesti være \"c:\\mine billeder\\min familie/billeder/xyz.jpg\".<br /><br />Du vil bemærke i dette eksempel:<ul><li>det aktuelle mediekatalognavn fjernes fra stien</li><li>og den resulterende sti vil ikke have de korrekte separatorer for mappenavne.</li></ul><br />Hvis du ønsker at bevare mediebiblioteket i mediefilstier i outputfilen, skal du medtage dette navn i feltet <b>#pgv_lang[convertPath]#</b>.<br /><br />Du skal også bruge indstillingen <b>#pgv_lang[convertSlashes]#</b> for at sikre, at mappenavneseparatorer er konsistente og er enige med kravene i det modtagende operativsystem.<br /><br />Mediestier, der faktisk er webadresser, ændres ikke.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Denne indstilling bestemmer, om mappenavne i FILE-specifikationen af medieobjekter skal adskilles med skråstreg fremad eller med tilbageslag. Dit valg afhænger af kravene i det modtagende operativsystem.<br /><br />Valget <b>#pgv_lang[forwardSlashes]#</b> er passende for de fleste andre operativsystemer end Microsoft Windows. Valget <b>#pgv_lang[backSlashes]#</b> skal bruges, når destinationsprogrammet kører på et Microsoft Windows-system.<br /><br />Mediestier, der faktisk er webadresser, ændres ikke.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />Når denne valgmulighed er valgt, søger #pgv_lang[multi_title]# ikke kun den mappe, der er valgt fra listen #pgv_lang[filter]#, men også alle dens underkataloger. Når denne indstilling ikke er valgt, søges kun i den valgte mappe.<br /><br />Titlerne på alle fundne medieobjekter undersøges derefter for at afgøre, om de indeholder den tekst, der er indtastet i #pgv_lang[filter]#. Resultatet af disse to handlinger bestemmer de multimedieobjekter, der skal vises.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Kun medier, der ikke er knyttet til nogen GEDCOM-post, vises.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Vælg den medieunderkatalog, du vil se.";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br /><br />Vælg den rækkefølge, som du vil se listen i.";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br /><br />Brug #pgv_lang[interactive_tree]# til at se hele familietræet for en person i begge retninger. Denne opfattelse svarer til timeglasudsigten, idet den viser både forfædre og efterkommere af en given rodperson. Dette diagram giver dig en mere kompakt visning ved at vise kasser til par eller familier i stedet for kun personer.<br /><ul><li><b>Rulle</b><br />Hver gang din musemarkør skifter til et Move-ikon, kan du klikke og trække i træet for at se andre dele af træet. Når du trækker i træet, udvides fremtidige generationer automatisk, indtil der ikke er flere generationer tilbage at se i den retning.<br /></li><li><b>Zoom</b><br />Du kan bruge ikonerne til venstre for træet til at zoome ind og ud. Hvis du zoomer ud, kan du se mere af træet på skærmen ad gangen. Når du zoomer ud, kan teksten blive vanskelig at læse; når din mus svæver over en kasse, får du et forstørret billede af, hvad der er inde i den.<br /></li><li><b>Udvidede Detaljer</b><br />Ved at klikke på et vilkårligt felt udvides feltet og viser en mere detaljeret visning. I udvidet tilstand åbnes ved at klikke på en persons navn deres side #pgv_lang[indi_info]#.Hvis du klikker på <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' />, tegnes træet igen med denne person som den nye rod. Klik på <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> fører dig til familiens detaljeringsside.<br /></li><li><b>Skift Ægtefæller</b><br />Ikonet <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> direkte under zoomknapperne skifter visningen af alle ægtefæller til eller fra på efterkommersiden.Når skærmen er indstillet til at vise ægtefæller, vises alle en persons ægtefæller i feltet med dem. Alle personens børn vises også. Når muligheden for at vise ægtefæller er slået fra, vises kun personens sidste ægtefælle og børn med den ægtefælle.<br /></li><li><b>Stort Stamtræ</b><br />#pgv_lang[interactive_tree]# er tilgængelig fra mange forskellige sider, herunder fanen Stamtræ på siden #pgv_lang[indi_info]# og Diagramblokken på velkomstsiden. Når du ser stamtræet fra en af disse andre sider, vil du også have et stamtræikon under zoom-ikonerne. Hvis du klikker på <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' />, føres du til siden #pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br /><br />Når Media Firewall er aktiveret, kan Multi-Media-filer gemmes i et serverkatalog, der ikke er tilgængeligt fra Internettet.<br /><br />Disse knapper giver dig mulighed for let at flytte en hel mediekatalogstruktur mellem den beskyttede (ikke webadresserbare) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> og de normale mapper <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br /><br />Sæt rekursivt tilladelserne til den beskyttede (ikke webadresserbare) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> og de normale <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mapper til enten verdensskrivbare eller skrivebeskyttede.";
$pgv_lang["update_CHAN_text"] 		= "Administratorer har nogle gange brug for at rydde op og rette de data, der indsendes af brugere. For eksempel skal de muligvis rette PLAC-placeringen for at inkludere landet. Når administratorer foretager sådanne rettelser, erstattes oplysninger om den oprindelige ændring normalt. Dette er måske ikke ønskeligt.<br /><br />Når denne mulighed vælges under administratorens redigerings- eller rettelsessession, beholder PhpGedView den originale ændringsinformation i stedet for at erstatte den med den i den aktuelle session.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Denne indstilling styrer starttilstanden for afkrydsningsfeltet «#pgv_lang[no_update_CHAN]#», der vises på hver side, hvor administratorer kan foretage ændringer eller rettelser til den genealogiske database.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Hver kilde registrerer specifikke begivenheder, generelt for et givet datointerval og for et sted jurisdiktion. For eksempel registrerer en folketælling folketællingsbegivenheder og kirkeregistreringer registrerer fødsels-, ægteskabs- og dødsbegivenheder.<br /><br />Vælg de begivenheder, der er optaget af denne kilde, fra listen over begivenheder. Datoen skal specificeres i et intervalformat som f.eks <i>FROM 1900 TO 1910</i>. Stedsjurisdiktionen er navnet på den laveste jurisdiktion, der omfatter alle steder på lavere niveau, der er nævnt i denne kilde. For eksempel ville \"Oneida, Idaho, USA\" blive brugt som en kilde jurisdiktion sted for begivenheder, der forekommer i de forskellige byer i Oneida County. \"Idaho, USA\" ville være kildekompetence, hvis de registrerede begivenheder ikke kun fandt sted i Oneida County, men også i andre amter i Idaho.";
$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />For at forbedre ydeevnen gemmes denne PhpGedCom velkomstsideblok som en cache-fil. Du kan kontrollere, hvor ofte denne blocks cache-fil opdateres.<br /><ul><li><b>-1</b> betyder, at cachefilen aldrig opdateres automatisk. For at få en ny kopi skal du slette alle cache-filer. Du kan gøre dette på siden Tilpas velkomstside.</li><li><b>0</b> (Nul) betyder, at denne blok aldrig caches, og hver gang blokken vises på PhpGedView-velkomstsiden, ser du en ny kopi. Denne indstilling bruges automatisk til blokke, der ændres ofte, såsom blokke #pgv_lang[logged_in_users_block]# og #pgv_lang[random_media_block]#.</li><li><b>1</b> (Én) betyder, at der oprettes en ny kopi af denne blok cache-fil dagligt, <b>2</b> betyder, at der oprettes en ny kopi hver anden dag, <b>7</b> betyder, at en ny kopi er oprettet ugentligt osv.</li></ul>";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />For at forøge hastigheden, er adskillige af blokkene i phpGedview gemt som cachefiler i index mappen. De fleste blokkes cachefiler genopfriskes en gang om dagen, men der kan være situationer hvor du ønsker at genopfriske dem manuelt.<br /><br />Denne knap lader dig genopfriske cachefilerne når det er nødvendigt.";
$pgv_lang["import_options_help"] 	= "Du kan vælge yderligere indstillinger der skal bruges ved import af GEDCOM filen.";
$pgv_lang["verify_gedcom_help"]	= "~#pgv_lang[verify_gedcom]#~<br /><br />Her kan du vælge enten at fortsætte med upload og import af denne GEDCOM-fil eller at afbryde upload og import.";
$pgv_lang["add_gedcom_instructions"]= "Indtast et filnavn til denne nye GEDCOM. Den nye GEDCOM-fil oprettes i indeksmappen: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Skulle diasshowet starte automatisk, når siden indlæses.<br /><br />Diasshowet ændrer indholdet af blokken uden at forudindlæse oplysninger fra serveren og uden at genindlæse hele siden.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Du kan bruge denne indstilling til at vise eller skjule kontroller til lysbilledshow i Random Media-blokken.<br /><br />Disse kontroller giver brugeren mulighed for at hoppe til et andet tilfældigt objekt eller at afspille tilfældigt valgte medier som et lysbilledshow. Diasshowet ændrer indholdet af blokken uden at forudindlæse oplysninger fra serveren og uden at genindlæse hele siden.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Brug dette link til at tilføje en ny kilde til din database uden at kæde kilden til en kildehenvisning i en anden post. Den nye kilde vises i kildelisten, men vises ikke på nogen diagrammer eller andre steder i programmet, før den er linket op til en kildehenvisning.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Brug dette link til at tilføje en ny delt note til din database uden at linke noten til nogen post. Den nye note vises på listen over delte noter, men vises ikke i nogen diagrammer eller andre steder i programmet, før den er knyttet til en person, familie eller begivenhed.";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />I dette felt angiver du ID på den person du linker til (fx I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Brug denne sektion til at vælge den database ID, der indeholder den person du linker til.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />I denne sektion specificerer du de parametre, der kræves for at oprette en forbindelse til den eksterne site, der indeholder de data, du linker til. Du har muligheden for at vælge fra en liste over kendte sites, som du har anvendt før, eller angive #pgv_lang[label_site_url2]# og #pgv_lang[label_gedcom_id]# for en ny.<br /><br />I <b>#pgv_lang[label_site_url2]#</b> feltet, angiver du URL-adressen for at få adgang til web services description filen (WDSL), der fortæller PhpGedView, hvordan den skal få adgang til den eksterne site.  For en ekstern PhpGedView hjemmeside, ser URL-adressen for WSDL filen ud som følger: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b> feltet anvendes til at angive en valgfri database ID for de eksterne sites, der kræver en.  For PhpGedView sites, er det navnet på GEDCOM-filen.<br /><br />Felterne til <b>#pgv_lang[label_username_id]#</b> og <b>#pgv_lang[label_password_id]#</b> er nødvendige hvis databasen kræver det.";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Denne valgmulighed tillader dig at vælge om data for den person du linker til findes på den samme hjemmeside, men i et andet genealogisk database sæt, eller om dataene befinder sig på en anden hjemmeside, der er tilgængelig via internettet.<br /><br />Hvis personen findes på den samme hjemmeside, vil du blive bedt om at vælge identifikationen af datasættet og angive personens ID.<br /><br />For en ekstern hjemmeside, vil du blive bedt om at angive URL-adressen, en database identifikation, og den eksterne persons ID.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Bruges denne valgmulighed til at vælge den relation, som den eksterne person har til de personer du knytter personen til på din site.  For eksempel, vælges <i>Far</i> betyder det at personen på den eksterne site er far til den person du knytter ham til på din site.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Brug denne formular til at linke personer til andre personer fra enten en anden site eller en anden slægtsdatabase, du har adgang til via din kopi af PhpGedView.<br /><br />For at tilføje sådan et link skal du først vælge en relationstype, og derefter vælge en site der allerede kendes af PhpGedView eller definere en ny site og derefter indtaste sitens ID på den person du ønsker at linke til.  PhpGedView vil så automatisk downloade information fra den eksterne site.  Den downloadede information bliver <u>ikke</u> en del af din slægtsdatabase; den forbliver på den oprindelige site, men bliver integreret med de forskellige sider, hvor den eksterne person vises.<br /><br />Se hjælpen ved siden af hvert element på siden for mere information om elementet.  Du kan også checke den engelske online hjælp for mere information: <a href=\"http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />Navnet på biblioteket, arkivet eller andet lager, hvor kildematerialet er gemt.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />Adressen på dette bibliotek, arkiv eller andet lager. Indtast adressen ligesom du ville skrive den på en konvolut.<br /><br />Lad dette felt være tomt, hvis du ikke vil medtage en adresse.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Telefonnummeret til dette bibliotek, arkiv eller andet lager. Indtast nummeret inklusive land og områdekode. For eksempel kan et nummer i Tyskland være +49 25859 56 76 89, og et nummer i USA eller Canada kan være +1 888 555-1212.<br /><br />Lad dette felt være tomt, hvis du ikke vil medtage et telefonnummer.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />FAX-nummeret på dette bibliotek, arkiv eller andet lager. Indtast nummeret inklusive land og områdekode. For eksempel kan et nummer i Tyskland være +49 25859 56 76 89, og et nummer i USA eller Canada kan være +1 888 555-1212.<br /><br />Lad dette felt være tomt, hvis du ikke vil medtage et faxnummer.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />E-mail-adressen til dette bibliotek, arkiv eller andet lager. Indtast e-mail-adressen. Eksempel: <b>name@hotmail.com</b><br /><br /> Lad dette felt være tomt, hvis du ikke vil medtage en e-mail-adresse.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />Internetside for dette bibliotek, arkiv eller andet lager. Indtast startside-adressen inklusive http:// eller https://. Eksempel: <b>https://www.phpgedview.net/</b><br /><br />Lad dette felt være tomt, hvis du ikke vil medtage en startside-adresse.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />En identifikations- eller referencebeskrivelse, der bruges til at arkivere og hente emner fra beholdningerne i et bibliotek, arkiv eller andet lager. Uformelle opbevaringssteder behøver normalt ikke bruge et #factarray[CALN]# system.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Dette er ID-nummeret på biblioteket, arkivet eller andet depot, hvor det kildemateriale, der henvises til, er gemt. Titlen på det aktuelle arkiv vises under ID-nummeret.<br /><br />Du kan ændre ID-nummeret på arkivet, hvor dette kildemateriale er gemt. For at fjerne arkivreferencen skal du gøre dette felt tomt. Denne handling fjerner ikke arkivposten fra databasen; kun referencen fjernes.<br /><br />Hvis du indtaster det ønskede arkiv-ID direkte, skal arkivposten allerede findes i databasen. Du kan klikke <b>#pgv_lang[find_repository]#</b> for at slå et eksisterende arkivs ID-nummer op. Klik <b>#pgv_lang[create_repository]#</b>, hvis du har brug for at indtaste en ny arkivpost.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Hvornår og hvor posten blev oprettet. For udgivne værker inkluderer dette oplysninger såsom udgivelsesbyen, forlagets navn og udgivelsesåret.<br /><br />For et ikke-udgivet værk skal det indeholde datoen for optegnelsen blev oprettet og det sted, hvor det blev oprettet. For eksempel amt og bopælsstat for en person, der afgiver en erklæring om pension, eller den by og bopælsstat, der er skrevet af et brev eller en privat familiehistorie.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />Den person, agentur eller enhed, der oprettede posten. For et offentliggjort værk kan dette være forfatter, kompilator, transkriber, abstraktor eller redaktør. For en upubliceret kilde kan dette være en person, et regeringsorgan, kirkeorganisation eller privat organisation osv.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Dette felt bruges normalt til at optage tekst i fri form til at identificere denne GEDCOM-post. For eksempel kan det være et filnummer inden for et automatiseret eller manuelt system, eller det kan være et side- og positionsnummer på et stamtavle.<br /></br />Når GEDCOM-konfigurationen er indstillet til at tillade brugeren at tilsidesætte det automatisk genererede ID-nummer for nye personer, indtastes dette overordnede ID-nummer her. I dette tilfælde skal teksten være i overensstemmelse med reglerne for ID-numre. Gyldige ID-numre kan kun indeholde bogstaverne <b>A</b> til <b>Z</b>, <b>a</b> til <b>z</b>, cifre <b>0</b> til <b>9</b>, og specialsymbolerne <b>. : -</b> og <b>_</b><br /><br />Indstillingen, der muliggør brug af #factarray[REFN]# i stedet for det automatisk genererede ID-nummer, findes i GEDCOM-konfigurationen, sektionen Brugeres redigering.";
$pgv_lang["edit_ABBR_help"]			= "~#factarray[ABBR]#~<br /><br />Brug dette felt til at gemme en kort version af en titel.  Dette felt anvendes sammen med titelfeltet til kilder.  Som standard vil PGV først anvende den fulde titel, og derefter den korte titel.<br /><br />Ifølge GEDCOM 5.5 specifikationen, \"dette input giver en kort titel, der anvendes til ar sortere, gemme og finde kilde poster (side 62).\"<br /><br />I PhpGedView er det valgfrit at anvende korte titler, men i andre slægtsprogrammer er det påkrævet.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "I mange kulturer er det almindeligt at have et traditionelt navn stavet i de traditionelle tegn og også en romaniseret version af navnet, da det ville være stavet eller udtalt på sprog baseret på det latinske alfabet, såsom engelsk eller dansk.<br /><br />Hvis du foretrækker at bruge det latinske alfabet til at indtaste navnet i standardnavnsfelterne, kan du bruge dette felt til at indtaste det samme navn i det ikke-latinske alfabet, såsom græsk, hebraisk, russisk, arabisk eller kinesisk. Begge versioner af navnet vises i lister og diagrammer.<br /><br />Selvom dette felt er mærket \"Romaniseret\", er det ikke begrænset til kun at indeholde tegn baseret på det latinske alfabet. Dette kan være nyttigt med japanske navne, hvor tre forskellige alfabeter kan forekomme.";
$pgv_lang["edit_ROMN_GIVN_help"]	= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />I dette felt skal du indtaste de givne navne for personen. Som et eksempel i navnet \"John Robert Finlay\", de fornavne, der skal indtastes her, er \"John Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]	= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />I dette felt skal du indtaste efternavnet til personen. I navnet \"John Robert Finlay\" er efternavnet, der skal indtastes her, \"Finlay\".<br /><br />Personer med flere efternavne, der er almindelige i Spanien og Portugal, skal adskille efternavne med komma. Dette indikerer, at personen skal opføres under hvert af navnene. For eksempel vil efternavnet \"Cortes,Vega\" blive vist under både <b>C</b> og <b>V</b>, hvorimod efternavnet \"Cortes Vega\" kun vil blive anført under <b>C</b>.";
$pgv_lang["edit__HEB_help"]			= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "I mange kulturer er det almindeligt at have et traditionelt navn stavet i de traditionelle tegn og også en romaniseret version af navnet, da det ville være stavet eller udtalt på sprog baseret på det latinske alfabet, såsom engelsk eller dansk.<br /><br />Hvis du foretrækker at bruge det latinske alfabet til at indtaste navnet i standardnavnsfelterne, kan du bruge dette felt til at indtaste det samme navn i det ikke-latinske alfabet, såsom græsk, hebraisk, russisk, arabisk eller kinesisk. Begge versioner af navnet vises i lister og diagrammer.<br /><br />Selvom dette felt er mærket \"Hebraisk\", er det ikke begrænset til kun at indeholde hebraiske tegn.";
$pgv_lang["edit__HEB_GIVN_help"]	= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />I dette felt skal du indtaste de givne navne for personen. Som et eksempel i navnet \"John Robert Finlay\", de fornavne, der skal indtastes her, er \"John Robert\".";
$pgv_lang["edit__HEB_SURN_help"]	= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />I dette felt skal du indtaste efternavnet til personen. I navnet \"John Robert Finlay\" er efternavnet, der skal indtastes her, \"Finlay\".<br /><br />Personer med flere efternavne, der er almindelige i Spanien og Portugal, skal adskille efternavne med komma. Dette indikerer, at personen skal opføres under hvert af navnene. For eksempel vil efternavnet \"Cortes,Vega\" blive vist under både <b>C</b> og <b>V</b>, hvorimod efternavnet \"Cortes Vega\" kun vil blive anført under <b>C</b>.";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Brug dette skema til at tilføje en person, som ikke er knyttet til en familie.<br /><br />Når du tilføjer en \"fritstående\" person til din slægtsdatabase, vil personen ikke blive knyttet til andre personer førend du opgiver slægtskabet/familiebåndet.  Du kan når som helst knytte personer sammen ved at vælge dette under fanebladet #pgv_lang[relatives]# på siden for #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Angiv internet adresse (URL) inklusiv http://. Eksempel: <b>http://www.phpgedview.net/</b><br /><br />Lad dette felt være tomt hvis du ikke ønsker at opgive en adresse (URL).";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Angiv webside-adressen, inklusiv http://. Eksempel: <b>http://www.phpgedview.net/</b><br /><br />Lad dette felt være tomt hvis du ikke ønsker at opgive en adresse (URL).";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Angiv en e-mail-adresse. Eksempel: <b>navn@hotmail.com</b><br /><br />Lad feltet være tomt, hvis du ikke ønsker at opgive en e-mail-adresse.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Angiv et FAX-nummer, inklusiv landekode og eventuelt områdenummer. Eksempel: Norge: +47 35 00 00 01 ; Tyskland: +49 25859 56 76 89 ; USA: +1 888 555-1212<br /><br />Lad dette felt være tomt hvis du ikke ønsker at opgive et faxnummer.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Angiv et telefonnummer, inklusiv landekode og eventuelt områdenummer. Eksempel: Norge: +47 35 00 00 00 ; Tyskland: +49 25859 56 76 89 ; USA: +1 888 555-1212.<br /><br />Lad dette felt være tomt hvis du ikke ønsker at opgive et telefonnummer.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Angiv en postadresse i feltet på samme måde, som du ville gjort på en konvolut.<br /><br />Lad feltet være tomt, hvis du ikke ønsker at opgive en postadresse.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Indtast eller vælg ord på listen, der går foran hoveddelen af efternavnet. Eksempler på sådanne ord er <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, osv.<br /><br />Under visse omstændigheder kan en adelstitel indtastes her. For eksempel Peter <b>Freiherr von</b> Somewhere. «Freiherr» delen er faktisk en adelstitel, og bør ikke gentages som #factarray[TITL]#. Hvad der indtastes her, afhænger i høj grad af den pågældendes præferencer.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Indtast det gifte navn for denne person ved hjælp af de samme formateringsregler, der gælder for feltet Navn. Dette felt er valgfrit.<br /><br />Hvis Mary Jane Brown f.eks. giftede sig med John White, kan du gå ind (uden anførselstegn, selvfølgelig)<ul><li>Amerikansk brug:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Europæisk brug:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternativ europæisk brug:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" or \"Mary Jane /Brown-White/\"</li></ul>Du skal kun gøre dette, hvis Mary Brown begyndte at kalde sig selv med det nye navn efter at have giftet sig med John White. Nogle steder, for eksempel i Quebec (Canada), er det ulovligt, at navne ændres på denne måde.<br /><br />Mænd ændrer nogle gange deres navn efter ægteskabet og bruger ofte den bindestreg, men tager lejlighedsvis konens efternavn.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />Dette felt beskriver barnets forhold til dets familie. Mulighederne er:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Barnets forhold til dets familie kan ikke bestemmes. Når denne indstilling er valgt, kopieres feltet #factarray[PEDI]# ikke til databasen.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Denne indstilling indikerer, at barnet er slægtning med dets familie ved fødslen.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Denne mulighed indikerer, at barnet blev adopteret af sin familie. Dette indikerer <i>ikke</i>, at der ikke er noget blodforhold mellem barnet og dets familie; det viser, at barnet blev adopteret af den pågældende familie engang efter barnets fødsel.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Denne mulighed indikerer, at barnet er et plejebarn af familien. Normalt er der ikke noget blodforhold mellem barnet og dets familie.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Barnet blev beseglet til sin familie i en SDH <i>forsegling</i> ceremoni. En forsegling af et barn udføres, når forældrene blev forseglet til hinanden efter barnets fødsel. Børn født efter forældrenes forsegling forsegles automatisk til familien.</li></ul>";
$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />Organisationen, institutionen, selskabet, personen eller en anden enhed, der har autoritet.<br /><br />For eksempel en arbejdsgiver for en person eller en kirke, der administrerer ritualer eller begivenheder, eller en organisation, der er ansvarlig for oprettelse og/eller arkivering af poster.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />Dette felt beskriver den type forening, der dannede familien.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;angiver, at ceremonien, der formaliserede foreningen af to personer for at danne en familie, blev udført af en præst, biskop, kardinal, prædikant, rabbiner, shaman eller lignende person. Ceremonien fandt ikke nødvendigvis sted i en kirke, synagoge, tempel eller andet indviet sted. Det kunne have foregået udendørs eller i et privat hjem.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;angiver, at ceremonien, der formaliserede sammenslutningen af to personer for at danne en familie, blev udført af en dommer, magistrat, borgmester eller lignende myndighedsperson, som ikke er præst osv. Autoriteten til at udføre sådanne ceremonier gives normalt af en regering. Ceremonien fandt ikke nødvendigvis sted i et retslokale eller et kontor.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;beskriver forholdet mellem to personer, der ikke er gift med hinanden, og som opfører sig, som om de var en familie. De har <u>ikke</u> deltaget i en vielsesceremoni udført af en præst, en biskop, en dommer, en borgmester eller nogen anden person med bemyndigelse til at foretage vielser. De kan have afgivet en offentlig erklæring om, at de betragter sig selv som gift, men det er ikke et krav.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;angiver, at detaljerne om foreningen mellem to personer for at danne en familie ikke kendes.</li></ul>";

$pgv_lang["context_help"]			= "Mere hjælp er tilgængelig ved at klikke på <b>#pgv_lang[qm]#</b> du kan finde efter forskellige valg på siden.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Hver person i slægtsdatabasen har et entydigt ID nr.  Hvis du kender dit eget ID nr., kan du opgive det her.  Hvis du ikke kan huske ID nummeret, eller ikke kan finde det på grund af indstillingerne for privatlivets beskyttelse, så opgiv venligst nok information i Kommentar-feltet, sål administratoren af hjemmesiden kan identificere dig, og så han/hun kan angive ID nummeret for dig.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Brug dette felt til at fortælle administratoren af hjemmesiden hvem du er, og hvem du er i familie med, i slægtsdatabasen. Du kan også bruge feltet til at sende administratoren af hjemmesiden en kommentar.";
$pgv_lang["utf8_ansi_help"]			= "~#pgv_lang[utf8_to_ansi]#~<br /><br />For at dataene skal vises på den bedste måde på Internettet, så bruger PhpGedView UTF-8 tegnsættet.  Nogle programmer, som for eksempel Family Tree Maker, understøtter ikke import af GEDCOM-filer som bruger UTF-8 tegnsættet.  Ved at afkrydse denne checkboks, vil datafilen blive konverteret fra <b>UTF-8</b> til <b>ANSI (ISO 8859-1)</b>.<br /><br />Det format af GEDCOM-filen du skal downloade, afhænger af det program, du skal bruge til at arbejde videre med dataene i.  Hvis du ikke er sikker på, hvilke formater det understøtter, kan du se i brugervejledningen til programmet.<br /><br />NB! Vær opmærksom på at specielle nationale tegn/bogstaver kan forsvinde/vises forkert ved konvertering. Det er derfor altid det sikreste at bevare dataene i UTF-8 og lade dit eget program bruge sin egen metode til import og konvertering af dataene.  Hvis du får problemer bør du kontakte sælgeren eller udvikleren af dit program.<br /><br />Denne <a href='https://da.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a> indeholder omfattende oplysninger og links om UTF-8.";
$pgv_lang["remove_tags_help"]		= "~#pgv_lang[remove_custom_tags]#~<br /><br />Ved krydse denne valgmulighed af, vil alle bruger-definerede mærker som er tilføjet til PhpGedView blive fjernet.<br /><br />Bruger-mærker, som PhpGedView anvender er blandt andet <b>_PGVU</b> som identificerer brugere, der har ændret data online og <b>_THUM</b> som fortæller PhpGedView at billedet bør anvendes som miniaturebillede.<br /><br />Brugerdefinerede mærker kan forårsage fejl ved import til andre slægtsprogrammer.";
$pgv_lang["download_zipped_help"]	= "~#pgv_lang[zip_files]#~<br /><br />Når du afmærker denne valgmulighed, vil en kopi af GEDCOM-filen komprimeres til en ZIP-fil før downloading starter. Det vil reducere filens størrelse betydeligt, men du vil vil få brug for et program, der kan pakke filen ud igen (for eksempel WinZIP) førend du kan bruge den.<br /><br />Det er en god funtion i forbindelse med at downloade store GEDCOM-filer.  Der er en risiko for at download tiden overskrider den maksimale tilladte tid for GEDCOM-filer, der ikke er komprimeret (zippet), hvilket kan resultere i at den downloaded fil ikke er komplet.  ZIP-funktionen burde reducere download tiden med ca. 75%.";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />Angiv antal børn som personen eller familien har. Dette er et valgfrit felt.";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />Indtast tidspunktet for denne begivenhed i 24-timers format med førende nuller. Midnat er 00:00. Eksempler: 04:50 13:00 20:30";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />Noter er tekst i fri form og vises i afsnittet Faktiske detaljer på siden.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Delt noter er tekst i fri form og vises i afsnittet Faktiske detaljer på siden.<br /><br />Hver delt note kan linkes til mere end en person, familie, kilde eller begivenhed.";
$pgv_lang["edit_CEME_help"]			= "~#factarray[CEME]#~<br /><br />Angiv navnet på kirkegården eller andet bisættelsessted, hvor personen er stedt til hvile.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Indtast GEDCOM ID for den person, hvis forhold til den aktuelle person, du ønsker at beskrive.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Vælg et #factarray[RELA]# fra listen. At vælge <b>#pgv_lang[godfather]#</b> betyder: <i>Personen identificeret i feltet #factarray[ASSO]# er #pgv_lang[godfather]# for den aktuelle person</i>.";
$pgv_lang["show_spouse_help"]		= "~#pgv_lang[show_spouses]#~<br /><br />Som standard viser dette diagram ikke ægtefæller til efterkommerne, fordi det gør diagrammet sværere at læse og forstå. Aktivering af denne indstilling viser ægtefæller på diagrammet.";
$pgv_lang["reorder_families_help"]	= "~#pgv_lang[reorder_families]#~<br /><br />Familier på fanebladet #pgv_lang[relatives]# bliver vist i den rækkefølge, de er gemt i slægtsdatabasen.  Familierne er ikke sorteret efter vielsesdato fordi denne dato ofte er ukendt i modsætning til rækkefølgen af vielser.<br /><br />Dette valg giver dig mulighed for at ændre rækkefølgen for, hvordan de skal vises på denne side for #pgv_lang[relatives]#.  Hvis du ønsker at sortere familierne efter vielsesdato, kan du klikke på knappen for automatisk sortering.";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Når PhpGedView registrerer, at GEDCOM-importen kræver mere tid, end tidsgrænsen tillader, viser den en knap <b>#pgv_lang[del_proceed]#</b>, som du skal trykke på for at fortsætte importen.<br /><br />Når denne indstilling er indstillet til <b>#pgv_lang[yes]#</b>, vil PhpGedView automatisk trykke på knappen <b>#pgv_lang[del_proceed]#</b> for dig. Dette skal aflaste kedsomheden ved at skulle trykke på knappen gentagne gange for langvarig import.";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Det efternavn, du har valgt, har mere end #GLOBALS[SUBLIST_TRIGGER_I]# personer.<br /><br />For at hjælpe dig med at finde den person, du ønsker, er listen opdelt i mindre lister i henhold til det første bogstav i personens fornavn. Dette alfabetiske underindeks fungerer det samme som det alfabetiske indeks for efternavne.<ul><li>Klik på et bogstav for at se alle de fornavne, der starter med det bogstav.</li><li>Vælg <b>#pgv_lang[PN]#</b> for at liste alle personer med ukendte fornavne.</li><li>Hvis du vælger <b>#pgv_lang[all]#</b>, vises en liste over alle personer med det tidligere valgte efternavn.</li></ul>";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Familienavnet, du har valgt, har mere end #GLOBALS[SUBLIST_TRIGGER_F]# personer.<br /><br />For at hjælpe dig med at finde den familie, du ønsker, er listen opdelt i mindre lister i henhold til det første bogstav i personens fornavn. Dette alfabetiske underindeks fungerer det samme som det alfabetiske indeks for navne.<ul><li>Klik på et bogstav for at se alle de fornavne, der starter med det bogstav.</li><li>Vælg <b>#pgv_lang[PN]#</b> for at liste alle personer med ukendte fornavne.</li><li>Hvis du vælger <b>#pgv_lang[all]#</b>, vises en liste over alle familier med det tidligere valgte efternavn.</li></ul>";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />Feltet #factarray[TYPE]# giver dig mulighed for at angive en brugerdefineret begivenhed.  Feltet er ikke bundet til et format, så der er frit slag mht. hvad indholdet skal være.";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />Til SDH-ordinancer registrerer dette felt templet, hvor det blev udført.";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />Dette felt er et valgfrit statusfelt og anvendes for det meste til at angive, hvor langt en person er kommet i SDH TempleReady ordineringsprogrammet.";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Brug dette felt til at angive at dette billede er hovedbilledet for den person, det er knyttet til.  Hovedbilledet er det, der bliver anvendt i slægtstræer og på siden med personoplysninger for den pågældende person.";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Denne mulighed giver dig mulighed for at tilsidesætte det sædvanlige valg for et miniaturebillede.<br /><br />GEDCOM har en konfigurationsmulighed, der specificerer, om PhpGedView skal sende det store eller det lille billede til browseren, når den aktuelle side kræver et miniaturebillede. Indstillingen «#factarray[_THUM]#», når den er indstillet til <b>#pgv_lang[yes]#</b>, tilsidesætter midlertidigt indstillingen af GEDCOM-konfigurationsindstillingen, så PhpGedView altid sender det store billede. Du kan ikke tvinge PhpGedView til at sende det lille billede, når GEDCOM-konfigurationen angiver, at store billeder altid skal bruges.<br /><br />PhpGedView ændrer ikke størrelsen på det billede, der sendes; browseren gør dette i henhold til de sidespecifikationer, den også har modtaget. Dette kan have uønskede konsekvenser, når det billede, der sendes, ikke er en miniaturebillede, hvor PhpGedView forventer at sende et lille billede. Dette er ikke en fejl: Der er lejligheder, hvor det kan være ønskeligt at vise et stort billede steder, hvor man normalt forventer at se et billede i miniaturestørrelse.<br /><br />Du bør undgå at indstille «#factarray[_THUM]#» mulighed for at <b>#pgv_lang[yes]#</b>. Dette valg vil medføre, at der sendes for store mængder billedrelaterede data til browseren, kun for at browseren skal kassere det overskydende. Sideindlæsninger, især af diagrammer med mange billeder, kan sænkes alvorligt.";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />Angiv en titel på det objekt du redigerer.  Hvis det er titlen på et multimedieobjekt, angiver du en beskrivende titel, der også vil blive vist for besøgende på hjemmesiden.<br /><br />Hvis du redigerer en persons detaljer, skal du bruge dette felt til at indtaste adelsinformation såsom <i>Sir, Lord, Baron, Earl, Duke, Graf, Freiherr,</i> osv.<br /><br />Professionelle betegnelser ssom <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> osv. skal indtastes i underfeltet «#factarray[NPFX]#», mens navnesuffikser ssom <i>Jr., Sr., III, IV,</i> osv. og akademisk information ssom <i>PhD, PEng, FImechE, DVM, MD,</i> osv. hrer hjemme i underfeltet «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />Dette er det vigtigste felt i frobindelse med multimediefiler!  Her anføres det, hvilken fil, der skal anvendes.<br />Som et absolut minimum, skal du angive navnet på filen.  Afhængig af, hvilke indstillinger du har foretaget i PhpGedView, så skal du måske angive mere information vedr. filens placering.<br /><br />Du kan vælge <b>#pgv_lang[find_media]#</b> som en hjælp til at lokalisere de mediefiler, du allerede har uploadet til hjemmesiden.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]			= "~#factarray[FORM]#~<br /><br />Dette er et valgfrit felt, der kan anvendes til at angive format af multimediefilen.  Nogle slægtsprogrammer checker dette felt for at finde ud af, hvordan de skal håndtere objektet.  På den anden side, så er det ikke særlig vigtigt, fordi multimedieobjekter overføres forholdsvis dårlig mellem forskellige PC platforme.";
$pgv_lang["generate_thumb_help"]	= "~#pgv_lang[auto_thumbnail]#~<br /><br />Vi har fundet ud af at din server har mulighed for automatisk at generere miniaturebilleder ud fra bestemte billedformater.  Filformaterne BMP, JPG, GIF og PNG kan understøttes.  Formaterne, som din server understøtter, er vist ved siden af boksen.<br /><br />Ved at afkrydse denne boks, så fortæller du til systemet, at billeder uploades i et eller flere af disse formater, og at du ønsker, at der skal genereres miniaturebilleder af dem.  Hvis du ikke afkrydser checkboksen, så må du eventuelt lave miniaturebilleder selv.";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Denne del giver dig mulighed for at tilføje en ny note for de oplysninger, du redigerer.  Noter er fritekst og vil vises i detaljer for fakta på forskellige sider.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Delte noter, som almindelige noter, er tekst i fri form. I modsætning til almindelige noter kan hver delt note knyttes til mere end en person, familie, kilde eller kendsgerning.<br /><br />Ved at klikke på det relevante ikon kan du oprette et link til en eksisterende delt note eller oprette en ny delt note og samtidig linke til den. Hvis der allerede er oprettet et link til en eksisterende delt note, kan du også redigere noteens indhold.<br /><ul><li><b>Link til en eksisterende delt note</b><div style=\"padding-left: 20px;\">Hvis du allerede kender ID-nummeret på den ønskede delte note, kan du indtaste nummeret direkte i feltet.<br /><br />Når du klikker på ikonet ABC, kan du søge i teksten på alle eksisterende delte noter og derefter vælge en af dem.ID-nummeret for den valgte note vil automatisk blive indtastet i feltet.<br /><br />Du skal klikke på knappen <b>#pgv_lang[add]#</b> for at opdatere den originale post.</div><br /></li><li><b>Opret en ny delt note</b><div style=\"padding-left: 20px;\">Når du klikker på ikonet <b>#pgv_lang[create_shared_note]#</b>, åbnes et nyt vindue. Du kan indtaste teksten i den nye note, som du ønsker det. Som med almindelige noter kan du indtaste webadresser.<br /><br />Når du klikker på knappen <b>#pgv_lang[save]#</b>, vil du se en meddelelse med ID-nummeret på den nyoprettede delte note. Du skal klikke på denne meddelelse for at lukke redigeringsvinduet og også kopiere det nye ID-nummer direkte i feltet ID-nummer. Hvis du bare lukker vinduet, kopieres det nyoprettede ID-nummer ikke automatisk.<br /><br />Du skal klikke på knappen <b>#pgv_lang[add]#</b> for at opdatere den originale post.</div><br /></li><li><b>Rediger en eksisterende delt note</b><div style=\"padding-left: 20px;\">Når du klikker på ikonet <b>#pgv_lang[edit_shared_note]#</b>, åbnes et nyt vindue. Du kan ændre teksten i den eksisterende delte note, som du ønsker. Som med almindelige noter kan du indtaste webadresser.<br /><br />Når du klikker på knappen <b>#pgv_lang[save]#</b>, opdateres teksten til den delte note. Du kan lukke vinduet og derefter klikke på knappen <b>#pgv_lang[save]#</b> igen.<br /><br />Når du ændrer teksten i en delt note, reflekteres din ændring på alle de steder, som den delte note i øjeblikket er knyttet til. Nye links, som du opretter efter at have foretaget din ændring, bruger også den opdaterede tekst.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~BRUG AF GEDFACT ASSISTANT~<br /><br />Ved at klikke på ikonet \"+\" åbnes vinduet GEDFact Shared Note Assistant. Der findes specifik hjælp.<br /><br />Når du klikker på knappen \"Gem\", indsættes ID'et for den delte note her.";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Denne del giver dig mulighed for at tilføje en ny kildehenvisning til den oplysning du redigerer.<br /><br />I kildefeltet angiver du kildens ID.  Hvis du skal oprette en ny kilde, kan du klikke på <b>#pgv_lang[create_source]#</b>.  I feltet for henvisningsdetaljer kan du angive sidenummer eller anden information, som kan hjælpe med til at finde frem til oplysningerne i kilden.  I tekstfeltet kan du også skrive direkte tekstuddrag fra kilden.";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# giver dig mulighed til for at knytte en oplysning til en tilhørende person i slægtsdatabasen.  Det er den eneste måde, hvorpå du kan knytte en person som forlover, gudfar og lignende til en anden person.";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Du kan bruge dette felt til at angive kvaliteten eller pålideligheden af oplysningerne i denne kilde.  Mange slægtsprogrammer anvender et nummer i feltet. <b>3</b> kan betyde, at dataene er en primær kilde, <b>2</b> kan betyde, at det var en sekundær kilde, <b>1</b> kan betyde, at informationen er tvivlsom, og <b>0</b> kan betyde, at kilden er upålidelig.";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />I feltet for henvisningsdetaljer kan du angive sidenummer eller anden information, der kan hjælpe med til at finde frem til oplysningerne i kilden.";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />I dette feltet kan du angive en henvisningstekst for denne kilde.  Eksempler på oplysninger kan være et uddrag af kildeteksten eller en beskrivelse af, hvad der er i henvisningen.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Dette er ID-nummeret på kilden til denne fakta. Titlen på den aktuelle kilde vises under ID-nummeret.<br /><br />Du kan ændre ID-nummeret på den kildepost, som denne kendsgerning refererer til. For at fjerne hele citatet skal du gøre dette felt tomt. Denne handling fjerner ikke kildeposten fra databasen; kun denne reference fjernes.<br /><br />Hvis du indtaster det ønskede kilde-ID direkte, skal denne kildepost allerede findes i databasen. Du kan klikke <b>#pgv_lang[find_sourceid]#</b> for at slå en eksisterende kildeposts ID-nummer op. Klik <b>#pgv_lang[create_source]#</b> hvis du har brug for at indtaste en ny kildepost.";
$pgv_lang["edit_edit_raw_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Denne side giver dig mulighed for at ændre den \"rå\" GEDCOM-post.  Du bør anvende denne side med forsigtighed og omtanke; Det kræver at du har kendskab til og forstår GEDCOM 5.5.1 standarden.  For mere information om GEDCOM 5.5.1 standarden, se emnet <a href=\"?help=gedcom_info_help\">GEDCOM-fil</a>.<br /><br />PhpGedView giver dig mulighed for at tilføje og ændre information på mange måder, men der kan være situationer, hvor du ønsker at foretage ændringer direkte i det \"rå\" GEDCOM-format.  Hvis det er muligt, bør du benytte de tilbudte skemaer til at tilføje information. MEN, hvis det ikke er muligt, kan du anvende dette \"skema\".  Når du sender det færdig redigerede \"skema\", vil informationen blive checket efter nogle grundregler i standarden og posten CHAN (ændret af hvem og hvornår) bliver opdateret.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView giver dig mulighed for at kopiere op til 10 fakta med alle deres detaljer til et udklipsholder. Dette udklipsholder adskiller sig fra udklipskurven, som du kan bruge til at eksportere dele af din database.<br /><br />Du kan vælge en af fakta fra udklipsholderen og kopiere den valgte kendsgerning til individet, familien, medierne, Kilde eller lagerregister, der aktuelt redigeres. Du kan dog ikke kopiere fakta om forskellige poster. For eksempel kan du ikke kopiere en ægteskabsfakta til en kilde eller en individuel optegnelse, da ægteskabsfakta kun er knyttet til familieoptegnelser.<br /><br />Dette er meget nyttigt, når du indtaster lignende fakta, såsom folketællingsfakta, f.eks. mange enkeltpersoner eller familier.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Steder bør tilføjes i henhold til standarden GEDCOM 5.5.1.  I slægtsforskning skal steder tilføjes med det mest detaljerede stednavn først, og derefter mere og mere globale stednavne, separeret med komma for at angive de forskellige geografiske områder/niveauer.  Startstedet, du anvender for kilder, bør være navnet på et offentligt register eller en kirke, hvor de vitale oplysninger er opbevaret/arkiveret.<br /><br />For eksempel, et sted som Salt Lake City bør tilføjes som \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Lad os se nærmere på hvert stednavn.  Første sted, \"Salt Lake City\", er byen eller bydelen, hvor begivenheden indtraf.  I nogle lande kan det være bydele eller områder i en by, der er vigtig at få med. I de tilfælde bør de angives før navnet på byen.  Det næste sted, \"Salt Lake\", er kommunenavnet.  \"Utah\" er navnet på staten, og \"USA\" er navnet på landet.  Det er vigtigt at være opmærksom på, at offentlige myndigheder på alle stedniveauer, nævnt i eksemplet, kan have registre, der indeholder slægtsoplysninger.<br /><br />Hvis du ikke kender navnet på et niveau, bør du lade niveauet være tomt ved at tilføje et mellemrum mellem de to kommaer. Forestil dig at, i nævnte eksempel, at du ikke kendte navnet på den kommune Salt Lake City ligger i.  Da bør stederne på de forskellige niveauer, skrives således: \"Salt Lake City, , Utah, USA\". Forestil dig, at du kun ved at en person var født i Utah.  Da bør du skrive stedsangivelsen på denne måde: \", , Utah, USA\".<br /><br />Du kan bruge valgmuligheden <b>#pgv_lang[find_place]#</b> for at hjælpe dig med at finde steder, der allerede findes i slægtsdatabasen.";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />Indtastning af specifikke bredde- og længdegradskoordinater frarådes generelt, da det kun tillader kortlægning af adgang fra det specifikke element. Det er bedre at styre de geografiske steder.<br /><br />Indtastning af breddegrad og længdegrad tillader dog en mere præcis placering af markøren.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />Indtastning af specifikke bredde- og længdegradskoordinater frarådes generelt, da det kun tillader kortlægning af adgang fra det specifikke element. Det er bedre at styre de geografiske steder.<br /><br />Indtastning af breddegrad og længdegrad tillader dog en mere præcis placering af markøren.";
$pgv_lang["edit_add_parent_help"]	= "~Tilføj ny mor eller far~<br /><br />På denne side kan du tilføje en ny mor eller far til den valgte person.  Anfør navnet på den nye person, samt information om fødselsdato og dødsdato, hvis det kendes.  Har du ikke nok information til at udfylde alle felter, så er det OK at lade felterne være tomme.<br /><br />For at tilføje andre faktaoplysninger, så må du først gemme de ovenfor nævnte oplysninger.  Så kan du gå til den opdaterede familieside og klikke på personens navn. Så vil du få personens faktaside frem, hvor du kan tilføje flere faktaoplysninger.";
$pgv_lang["edit_add_spouse_help"]	= "~Tilføj ny ægtemand eller hustru~<br /><br />På denne siden kan du tilføje en ny ægtemand eller hustru til den valgte person.  Anfør navnet på den nye person, samt information om fødselsdato og dødsdato, hvis det kendes.  Har du ikke nok information til udfylde alle felter, så er det OK at lade felterne være tomme.<br /><br />For at tilføje andre faktaoplysninger, så må du først gemme de ovenfor nævnte oplysningene.  Så kan du gå til den opdaterede familieside og klikke på personens navn. Så vil du få personens faktaside frem, hvor du kan tilføje flere faktaoplysninger.";
$pgv_lang["edit_death_help"] 		= "~#pgv_lang[death]#~<br /><br />Dette område giver dig mulighed for at tilføje information om personens død. Anfør først personens dødsdato i standard datoformat for slægtsforskning (1&nbsp;OCT&nbsp;2004).  Du kan klikke på ikonet for Kalender for at få hjælp til at vælge en dato. Derefter angiver du stedet, hvor personen døde i standard stedformat for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.";
$pgv_lang["edit_birth_help"] 		= "~#pgv_lang[birth]#~<br /><br />Dette området giver dig mulighed for at tilføje information om personens fødsel. Angiv først personens fødselsdato i standard datoformat for slægtsforskning (1&nbsp;OCT&nbsp;2004).  Du kan klikke på ikonet for Kalender for at få hjælp til at vælge en dato. Derefter angiver du stedet, hvor personen blev født i standard stedformat for slægtsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for at vælge et sted, der allerede findes i slægtsdatabasen.";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />Vælg ret køn fra listen. <b>Ukendt</b> indikerer, at du ikke kender personens køn.";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Dette er det vigtigste feltet for en person i slægtsbasen.<br /><br />Dette felt skulle, som udgangspunkt have været udfyldt automatisk, men det er åbent så du kan ændre informationen i henhold til dine personlige preferencer.<br /><br />Navnet i dette felt bør skrives ind i henhold til GEDCOM 5.5.1 standarden med efternavnet omgivet af skråstreger \"/\". Som et eksempel, bør navnet \"John Robert Finlay Jr.\" skrives ind som: <b>John Robert /Finlay/ Jr.</b>";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />I dette felt skal du indtaste efternavnet til personen. I navnet \"John Robert Finlay\" er det efternavn, der skal indtastes her, \"Finlay\"<br /><br /> Personer med flere efternavne, der er almindelige i Spanien og Portugal, skal adskille efternavne med komma. Dette indikerer, at personen skal opføres under hvert af navnene. F.eks. Vil efternavnet \"Cortes,Vega\" blive opført under både <b>C</b> og <b>V</b>, mens efternavnet \"Cortes Vega\" kun vil blive opført under <b>C</b>.";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />I dette felt skal du indtaste eventuelle kaldenavne til personen. Dette er et valgfrit felt.<br /><br />Måder at tilføje et kaldenavn på:<ul><li>Vælg <b>rediger navn</b>, indtast derefter kaldenavn, og gem</li><li>Vælg <b>tilføj nyt navn</b>, indtast derefter kaldenavn OG navn, og gem</li><li>Vælg <b>rediger GEDCOM-post</b> for at tilføje flere [2&nbsp;NICK] poster, der er underordnet den primære [1&nbsp;NAME] post.</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />I dette felt kan du tilføje personens fornavne.  Som et eksempel, i navnet \"John Robert Finlay\", vil fornavnet være \"John Robert\".";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Dette valgfrie felt giver dig mulighed for at indtaste et navnepræfiks såsom <i>Dr.</i> eller <i>Adm.</i><br /><br />Adelstitler såsom <i>Sir, Lord, Baron, Earl, Duke, Graf, Freiherr,</i> osv. indtastes som et faktum «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Dette valgfri felt giver dig mulighed for at indtaste et navnesuffiks såsom <i>Jr., Sr., III, IV,</i> osv. og akademiske oplysninger såsom <i>PhD, PEng, FImechE, DVM, MD,</i> osv.";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />På denne side kan du tilføje et barn til den valgte familie.  Anfør barnets navn, samt information om fødselsdato og dødsdato, hvis det kendes.  Har du ikke nok information til udfylde alle felter, så er det OK at lade felterne være tomme.<br /><br />For at tilføje andre faktaoplysninger, så må du først gemme de ovenfor nævnte oplysninger.  Så kan du gå til den opdaterede familieside og klikke på barnets navn. Så vil du få barnets faktaside frem, hvor du kan tilføje flere faktaoplysninger.";

$pgv_lang["review_changes_help"]	= "~#pgv_lang[review_changes_block]#~<br /><br />Denne blok viser alle de ændringer, der er foretaget i slægtsdatabasen online, og som skal checkes og godkendes for at de kan vises i slægtstræer, lister og andre faktasider.";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Brug felterne \"Opdater navn\" til at ændre navnet på den person, du redigerer. I feltet Angivne navne skal du indtaste personens for- eller fornavne. Indtast personens efternavn eller efternavn i feltet Efternavn. For eksempel, hvis det navn, du vil indtaste, er \"John Robert Finlay\", skal du indtaste \"John Robert\" i feltet Fornavn og \"Finlay\" i feltet Efternavn.<br /><br />Udfyldning af disse felter vil <u>ændre</u> personens navn; det tilføjer ikke et nyt navn.<br /><br /><i>Bemærk: Du bør <u>ikke</u> bruge denne metode, hvis navnet ændres på grund af et nyt ægteskab. Brug i stedet indstillingerne til at tilføje en ny mand nedenfor.</i>";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Brug felterne \"Opdater fakta\" til at tilføje nye faktainformationer eller ændre en eksisterende fakta for den post, du redigerer. Vælg først en kendsgerning fra listen. Indtast derefter datoen, hvor denne kendsgerning opstod i standarddatoformatet for slægtsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på kalenderikonet for at få hjælp til at vælge en dato. Gå derefter ind på det sted, hvor denne kendsgerning opstod. Du kan bruge linket <b>#pgv_lang[find_place]#</b> til at vælge et sted, der allerede findes i databasen.<br /><br />Som med alle de andre felter i denne formular vil dine oplysninger blive enten udskift det, der allerede er der, eller det opretter nye poster efter behov.";
$pgv_lang["quick_update_address_help"]	= "~#pgv_lang[update_address]#~<br /><br />Brug felterne <b>#pgv_lang[update_address]#</b> for at ændre adressen, telefonnummeret eller e-mail-adressen til denne person.<br /><br />Som i alle de andre felter i dette skema, så vil oplysningerne du opgiver enten erstatte det eksisterende indhold eller blive oprettet som en ny faktaoplysning alt efter det der er valgt.";
$pgv_lang["quick_update_spouse_help"]	= "~TILFØJ EN NY MAND ELLER KONE~<br /><br />Brug disse felter, når du vil føje en ny mand eller kone til den person, du redigerer. Indtast den nye ægtefælles navn og fødselsoplysninger i felterne, og indtast derefter datoen for, at de blev gift under ægteskabsoplysningerne. Indtast datoer i standarddatoformatet for slægtsforskning (1. JAN 2004). Du kan klikke på kalenderikonet for at få hjælp til at vælge en dato. Du kan bruge linket <b>#pgv_lang[find_place]#</b> til at vælge et sted, der allerede findes i databasen.<br /><br />Disse felter tilføjer kun en <i>ny</i> partner; de opdaterer ikke oplysningerne om en gammel. For at redigere oplysningerne om en person, der allerede er optaget, skal du lukke dette vindue og klikke på personens navn i fanen #pgv_lang[relatives]#. Klik derefter på menuen Rediger person for at redigere oplysningerne.";
$pgv_lang["quick_update_marriage_help"] = "~OPDATER ÆGTESKAB~<br /><br />Du kan bruge disse felter sammen med felterne til at tilføje en ny mand eller kone, hvis du vil registrere et nyt ægteskab. Ellers vil indtastning af data i disse felter ændre oplysninger om personens sidste ægteskab. Indtast datoer i standarddatoformatet for slægtsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på kalenderikonet for at få hjælp til at vælge en dato. Du kan bruge linket <b>#pgv_lang[find_place]#</b> til at vælge et sted, der allerede findes i databasen.";
$pgv_lang["quick_update_child_help"] 	= "~#pgv_lang[add_new_chil]#~<br /><br />Brug disse felter til at føje et nyt barn til denne person. Indtast først barnets navn, og vælg køn. Indtast derefter datoen og stedet, hvor barnet blev født. Indtast datoer i standarddatoformatet for slægtsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på kalenderikonet for at få hjælp til at vælge en dato. Du kan bruge linket <b> #pgv_lang [find_place] # </b> til at vælge et sted, der allerede findes i databasen.<br /><br />Disse felter tilføjer kun en <u>ny</u> barn. De opdaterer ikke oplysningerne om et barn, der allerede er registreret. For at redigere oplysningerne om en person, der allerede er i databasen, skal du lukke dette vindue og klikke på personens navn i fanen #pgv_lang[relatives]#. Klik derefter på menuen Rediger person for at redigere oplysningerne.";
$pgv_lang["index_top10_pageviews_help"]	= "~#pgv_lang[top10_pageviews]#~<br /><br />Denne blok viser de mest viste personer, familier eller kilder på hjemmesiden.  For at kunne vise denne blok, skal administratoren af hjemmesiden have aktiveret tælleren.";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Denne blok viser cookiepolitikken på dette websted.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Lad dette felt være tomt, hvis du ønsker at bruge standardteksten.<br /><br />Hvis du ønsker at bruge standardteksten og også give et link til en tekstfil eller HTML-side, der indeholder detaljer om den cookiepolitik, der er specifik for dit websted, kan du indtaste URL'en til denne side her.<br /><br />For eksempel kan <b>http://foo.bar.com/policy/cookies.txt</b> pege på en almindelig tekstfil, mens <b>http://foo.bar.com/policy/cookies.htm</b> peger på en HTML-formateret side, og <b>http://foo.bar.com/policy/cookies.doc</b> peger på et dokument i Microsoft Word-format. ";
$pgv_lang["cookiepolicy_link_advice"]		= "Lad det være tomt for at bruge standardteksten.<br /><br />Indtast en URL som f.eks. <b>http://foo.bar.com/policy/cookies.txt</b> for at pege på en webstedsspecifik politikside.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Dette valg giver dig mulighed for at angive, hvilket faneblad, der skal åbnes automatisk når siden #pgv_lang[indi_info]# blir vist.  Hvis en bruger kan ændre sin konto, kan de forskellige brugere vælge sit eget standard faneblad.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Dette valg giver dig, som bruger, mulighed for at angive, hvilket faneblad, der skal åbnes automatisk når siden #pgv_lang[indi_info]# blir vist.";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br /><br />Børn vises i den rækkefølge, de vises i familiejournalen. Børn sorteres ikke automatisk efter fødselsdato, fordi fødselsdatoerne for nogle af børnene ofte er usikre, men rækkefølgen af deres fødsel <u>er kendt</u>.<br /><br />Denne mulighed giver dig mulighed for at ændre rækkefølgen af børnene inden for familiens optegnelse. Da du måske vil sortere børnene efter deres fødselsdatoer, er der en knap, du kan trykke på, der gør dette for dig.<br /><br />Du kan også trække og slippe ethvert informationsfelt for at ændre rækkefølgen af børnene. Når du bevæger musemarkøren over en informationsboks, ændres dens form til et par dobbeltkorsede pile. Hvis du trykker på og holder venstre museknap nede, før du flytter musemarkøren, følger informationsboksen musemarkøren op eller ned på listen. Når informationsfeltet flyttes, vil de andre felter give plads. Når du slipper venstre museknap, tager informationsfeltet sin nye plads på listen.";
$pgv_lang["rss_feed_help"]				= "~#pgv_lang[rss_feeds]#~<br /><br />ATOM / RSS-feedet, der er tilgængeligt i PhpGedView, giver alle mulighed for at se indholdet af dit sides velkomstside ved hjælp af en passende feedaggregator uden at besøge webstedet. De fleste aggregatorer viser en meddelelse, der fortæller brugeren, hvornår noget har ændret sig på en side, der overvåges. Dette giver i det væsentlige alle mulighed for at overvåge dit PhpGedView-websted uden at skulle besøge det regelmæssigt.<br /><br />Feedblokken bruges til at tilpasse linket til feedet, hvilket tillader specifikke feedtyper (de fleste læsere kan håndtere de fleste typer, så dette kan normalt efterlades som standard) og det specifikke modul, du gerne vil have i dit feed. Sproget i feedet og det anvendte GEDCOM vil være baseret på det sprog og GEDCOM, der er aktivt i PhpGedView, når du vælger feedet.<br /><br />De typer feed, der kan genereres, inkluderer ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML og JavaScript. De første fire typer er til feedaggregatorer, mens JavaScript og HTML er beregnet til at muliggøre inkludering af feedsne på andre websider. Bemærk, at numrene på RSS-feedet angiver forskellige stilarter, ikke en anden version.<br /><br />Der er en mulighed for at vælge godkendelse, der logger brugeren ind og giver brugeren mulighed for at se ved hjælp af en passende RSS aggregator, alle oplysninger, som han normalt kunne se, hvis han var logget ind. Grundlæggende godkendelse bruger <i>Grundlæggende HTTP-godkendelse</i> til at logge brugeren ind. Fremtidige forbedringer muligvis muligvis <i>Digest-godkendelse</i>.<br /><br />Denne <a href='https://da.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia artikel' title='Wikipedia artikel'><b>Wikipedia artikel</b></a> indeholder omfattende oplysninger og links om RSS og de forskellige RSS-formater.<i>Grundlæggende HTTP-godkendelse</i> diskuteres i dette <a href='https://da.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia-artikel' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a>, mens <i>Digest Authentication</i> diskuteres i dette <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia-artikel' title='Wikipedia-artikel'><b>Wikipedia-artikel</b></a>.";

$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Vælg filer fra din lokale computer der skal uploades til din server. Alle filer vil blive uploadet til mappen <b>#MEDIA_DIRECTORY#</b> eller til en af dens undermapper.<br /><br />De mappenavne du angiver vil blive tilføjet til <b>#MEDIA_DIRECTORY#</b>. For eksempel, <b>#MEDIA_DIRECTORY#minfamilie</b>. Hvis miniature mappen ikke eksisterer, vil den blive oprettet automatisk.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Din GEDCOM-konfiguration tillader op til #GLOBALS[MEDIA_DIRECTORY_LEVELS]# katalogniveauer ud over standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, hvor uploadede mediefiler normalt er gemt. Dette giver dig mulighed for at organisere dine mediefiler, og du behøver ikke være så bekymret for at opretholde unikke navne for hver mediefil.<br /><br />I dette felt angiver du destinationsmappen på din server, hvor den uploadede mediefil skal gemmes. Sørg for at være opmærksom på store og små bogstaver for det, du indtaster eller vælger her, da fil- og katalognavne er store og små bogstaver.<br /><br />Hvis katalognavnet, du indtaster her, ikke findes, oprettes det automatisk. Hvis du indtaster mere end de yderligere #GLOBALS[MEDIA_DIRECTORY_LEVELS]# katalogniveauer, der er tilladt i din GEDCOM-konfiguration, bliver din input afkortet i overensstemmelse hermed.<br /><br />Miniaturer uploades eller oprettes i en identisk mappestruktur, begyndende med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />I dette felt angiver du placeringen og navnet på din lokale computer for den mediefil, du vil uploade til serveren. Du kan bruge knappen <b>Gennemse</b> til at søge på din lokale computer efter den ønskede fil.<br /><br />Den uploadede fil har samme navn på serveren, og den uploades til den mappe, der er angivet i feltet <b>#pgv_lang[folder]#</b>.<br /><br />Hvis du ikke kan se feltet <b>#pgv_lang[folder]#</b> eller ikke kan ændre det, har du ikke tilstrækkelige tilladelser, eller din GEDCOM-konfiguration er indstillet til at tillade ingen katalogniveauer ud over standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. I dette tilfælde overføres mediefilen til mappe <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />I dette felt angiver du placeringen og navnet på den lokale computer for den miniaturefil, du vil uploade til serveren. Du kan bruge knappen <b>Gennemse</b> til at søge på din lokale computer efter den ønskede fil. Når dette felt er udfyldt, ignoreres afkrydsningsfeltet <b>#pgv_lang[auto_thumbnail]#</b>.<br /><br />Hvis feltet <b>#pgv_lang[media_file]#</b> er udfyldt, navngives din uploadede miniaturefil i henhold til indholdet af dette felt, uanset hvad det kaldes på din lokale computer. Hvis dette felt er tomt, vil den uploadede miniaturefil blive kopieret til to steder på serveren, en gang til den servermappe, der er nævnt i feltet <b>#pgv_lang[folder]#</b>, og derefter igen til en identisk mappestruktur, der starter med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Hvis du ikke kan se feltet <b>#pgv_lang[folder]#</b> eller ikke kan ændre det, har du ikke tilstrækkelige tilladelser, eller din GEDCOM-konfiguration er indstillet til at tillade ingen katalogniveauer ud over standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, hvor uploadede mediefiler normalt er gemt.";


//-- GENERAL
$pgv_lang["help_header"]				 = "Information om:";
$pgv_lang["privacy_error_help"]			= "~Private oplysninger~<br />Der er flere mulige årsager til denne meddelelse:<ul><li><b>Information om levende personer er sat til \"Privat\"</b><br>Besøgende og registrerede brugere som ikke er logget ind, kan bare se information for døde personer! Hvis administrator har åbnet for det, kan du registrere dig ved at klikke på 'Log ind', og derefter på  #pgv_lang[requestaccount]#.</li><li><b>Du er en registreret bruger med brugernavn og adgangskode</b><br />Men du har glemt at logge dig ind eller, at du ikke har været aktiv et stykke tid og er blevet logget ud automatisk.</li><li><b>Af hensyn til privatlivets beskyttelse</b><br />Personen ønsker at faktaoplysninger om sig selv skal være \"Privat\" eller at personen ikke ønsker at blive vist i det hele taget (skjult). Beskyttelse af privatlivet kan sættes til:<ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Ut fra \"Grad af slægtskab\"</b><br />Selvom du er en sædvanlig bruger <i>og</i> logget ind, så kan det ske, at du vil se denne meddelelse, hvis den person, du prøver at se, ikke er i <b>nær</b> slægt med dig. Slægtskab er defineret som et vist antal trin, og er bestemt af administratoren af denne slægtsside.<br /><br />Eksempler:<br />Når trinlængden for slægtskab er sat til <b>1</b>, så kan du kun se detaljerne for din egen familie, far, mor, bror og søster (men ikke din brors eller søsters ægtefæller og børn)<br /><br />Når trinlængden for slægtsskab er sat til <b>2</b>, så kan du også se detaljerne vedr. dine søkendes ægtefæller og deres børn (men ikke ægtefæller til deres børn).<br /><br />Jo højere trinlængde for slægtsskabet er sat til, jo flere detaljer for fjernere slægtninge kan du se.</li></ul><br />Hvis du mener, at du er kvalificeret til at se visse detaljer, så kontakt venligst administratoren ved at anvende kontaktlinket nederst på siderne.";
$pgv_lang["more_help"]					= "Hvis du ønsker mere (detaljeret) hjælp, kan du klikke på <b>#pgv_lang[qm]#</b> anbragt efter de forskellige valgmuligheder, blokke mm. på skærmen. Check at <b>#pgv_lang[show_context_help]#</b> (under hjælp i menuen) er aktiv.";
$pgv_lang["start_admin_help"]			= "<b>+++ Start ekstra info for Admin +++</b>";
$pgv_lang["end_admin_help"]				= "<b>--- Slut ekstra info for Admin ---</b>";
$pgv_lang["multiple_help"]				= "<span class='center'>--- Dette er en generel hjælpetekst for flere sider ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>GENEREL INFORMATION</b></div>";
$pgv_lang["best_display_help"]			= "~#pgv_lang[resolution]#~<br /><br />PhpGedView ses bedst med en skærmopløsning på 1024x768. Med denne opløsning vil du kunne se alle dele på en gang.<br /><br />Hvis du har valgt en lavere opløsning (for eksempel 800x600), vil du til en vis grad blive tvunget til at bruge den vandrette scroll-funktion for at kunne se al information.";
$pgv_lang["preview_help"]				= "~#pgv_lang[print_preview]#~<br /><br />Hvis du klikker <b>#pgv_lang[print_preview]#</b>, fjernes de elementer, der ikke ser godt ud på en udskrevet side (menuer, inputbokse, ekstra links, spørgsmålstegnene til den kontekstuelle hjælp osv.)<br /><br />Du får en knap <b>#pgv_lang[print]#</b> nederst på den forenklede side; når du klikker denne knap, vises dit systems udskriftsdialogboks. Efter udskrivning skal du klikke <b>#pgv_lang[cancel_preview]#</b>, og skærmen vil blive genopbygget normalt.<br /><br />Bemærk: Selvom denne mulighed fjerner mange links fra den viste side, er de resterende links stadig aktive.";
$pgv_lang["readme_help"]				= "Se i filen <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> for mere information.";
$pgv_lang["is_user_help"]				= "--- Denne hjælpetekst er den samme tekst, som besøgende vil læse. ---<br />--- For at spare plads oprettede vi ikke en særlig admin-tekst til denne vare. ---";
$pgv_lang["edit_raw_gedcom_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Når du klikker på dette link, åbnes et nyt vindue, der indeholder de rå GEDCOM-data for detaljerne på denne side.<br /><br />Her kan du redigere GEDCOM-dataene direkte. Sørg for at indtaste gyldige GEDCOM 5.5.1-data, da der ikke udføres yderligere gyldighedskontrol. De ændrede eller tilføjede data vises i PhpGedView som \"ændringer\" og skal accepteres af en bruger med acceptrettigheder.";
$pgv_lang["RESN_help_title"]			= "Fastsættelse af begrænsninger for fakta";
$pgv_lang["RESN_help"]					= "~#pgv_lang[RESN_help_title]#~<br /><br />Med undtagelse af generelle indstillinger for privatliv, har man i PhpGedView muligheden for at begrænse visning og ændring af faktaoplysninger for personer og familier. Begrænsningerne kan sættes af alle, der har ret til at ændre information, med undtagelse af, hvor tidligere indstillinger eller indstiller for privatliv forhindrer det.<br /><br />Følgende værdier kan anvendes:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Administratorer af hjemmesiden, administratorer af slægtsdatabasen (GEDCOM) og brugere, der har rettigheder til at ændre, kan ændre information.<br />Faktaoplysninger kan vises afhængig af indstillingerne mht. privatliv, der er lagt ind af administratoren.</li><li><b>#pgv_lang[locked]#</b><br />Denne indstilling har ingen indflydelse på, hvorledes faktaoplysninger vises. Den begrænser retten til at ændre for administratorer af hjemmesiden og administratorer af slægtsdatabasen (GEDCOM). Hvis oplysningerne gælder brugeren selv, kan han også se og ændre disse, hvis han har rettigheder til at ændre.</li><li><b>#pgv_lang[privacy]#</b><br />Administratorer af hjemmesiden og administratorer af slægtsdatabasen (GEDCOM) kan se og ændre oplysningerne. Hvis oplysningerne gælder brugeren selv, kan han også se og ændre disse, hvis han har rettigheder til at ændre. Oplysningerne vil være skjult for alle andre brugere uafhængig af brugerstatus.</li><li><b>#pgv_lang[confidential]#</b><br />Kun administratorer af hjemmesiden og administratorer af slægtsdatabasen (GEDCOM) kan se og ændre oplysningerne. Oplysningerne vil være skjult for alle andre brugere uafhengig af brugerstatus.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Ejer</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Andre</th></tr><tr><th></th><th></th><th>L</th><th>Æ</th><th></th><th>L</th><th>Æ</th><th></th><th>L</th><th>Æ</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : kan læse</li><li>Æ : kan ændre</li><li><img src=\"images/checked_qm.gif\"/> : afhængig af globale indstillinge for privatliv</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]					= "~#pgv_lang[welcome_page]#~<br /><br />Velkomstsiden er også hovedside, og  ønsker dig velkommen til denne slægtsdatabase (<a href=\"#def_gedcom\">GEDCOM</a>-fil). Du kan altid komme tilbage til denne side ved at vælge <i>#pgv_lang[welcome_page]#</i> i hovedmenuen. Hvis der er flere slægtsdatabaser på denne hjemmeside, vil du også få en undermenu op, hvor du kan vælge den ønskede slægtsdatabase. Du kan her få information om:<ul><li><a href=\"#index_portal\"><b>#pgv_lang[welcome_page]#</b></a><li><a href=\"#header\"><b>#pgv_lang[header]#</b></a><li><a href=\"#menu\"><b>#pgv_lang[menu]#</b></a><li><a href=\"#header_general\"><b>Generel information</b></a><li><a href=\"#def\"><b>Definitioner</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]				= "<div class='name_head center'><b>#pgv_lang[header]#</b></div><br />Den øverste del af siderne (topfeltet) bliver vist på hver side.<br />Her finder du nogle nyttige valgmuligheder / links, som du kan bruge på alle sider.<br />PhpGedView kan have forskellig udseende. Ved at vælge forskellige <a href=\"#def_theme\">temaer</a>, vil topfeltet kunne indeholde forskellige links / valgmuligheder.<br /><br />Valg / links, som du kan finde er:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Dette søgefelt er kort, men effektivt. Du kan skrive og søge på næsten hvadsomhelst, som du tror du kan finde i slægtsdatabasen. Når du klikker på knappen <b>&gt;</b> eller \"Søg\", vil du få søgeresultatet vist. Du kan finde yderligere hjælp om dette på søgehovedsiden.";
$pgv_lang["header_lang_select_help"]	= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />En af de vigtigste funktioner i PhpGedView er, at flere sprog understøttes.<br /><br />Sprog, som PhpGedView viser alle sider, bestemmes automatisk i henhold til browserens foretrukne sprogindstilling. Webstedsadministratoren kan dog have begrænset tilgængeligheden af bestemte sprog.<br /><br />Afhængigt af webstedskonfiguration kan du muligvis ændre sproget i PhpGedView ved at vælge et mere passende sprog fra en liste eller ved at klikke på et flagikon. Hvis du er en registreret bruger, kan du konfigurere PhpGedView til at skifte til dit foretrukne sprog, når du logger ind, uanset hvad din browser er indstillet til.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />Brugerlinks er en lille blok med nyttige links, der kan findes samme sted på hver side. Placeringen af disse links varierer alt efter det tema, der aktuelt er i kraft.<br /><br />Når du ikke er logget ind, vil du kun se linket <b>Login</b>. Når du er logget ind, vil du se:<ul><li><b>Logget ind som (dit brugernavn)</b>. Klik på dette link fører dig til din kontoside.</li><li>Klik på <b>Log ud</b> for at logge af.</li><li>Hvis du har administratorrettigheder, vil du også se <b>Administration</b>. Klik på dette link fører dig direkte til hovedsiden for administration.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />Denne liste vil vise dig favoritter i slægtsdatabasen, valgt af administratoren af hjemmesiden. Hvis du er en registreret bruger og har logget ind, vil du se dne favoritter, som du har valgt på din personlige hovedside. Ved at klikke på en af favoritterne, vil du få siden: <b>Oplysninger om personen</b> op for den valgte favoritperson.<br /><br />Mere hjælp om at tilføje nye links til  \"Dine favoritter\" er tilgængelig på din personlige side (Min GedView Portal).";
$pgv_lang["header_theme_help"]			= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Når denne mulighed er aktiveret af administratoren af hjemmesiden, vil listen for <i>Skift tema</i> vise dig en liste med forskellige temaer, som du kan anvende på denne hjemmeside.<br /><br />Ved at vælge et nyt tema fra denne liste, vil du bruge dette udseende så længe du besøger hjemmesiden.  Hvis du er logget ind, vil dette også ændre dit eget standard-tema således, at det nye også vil vises næste gang du logger dig ind.";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class='name_head center'><b>MENUEN</b></div><br />Øverst på hver side finder du menuen med tilhørende undermenuer.<br /><br />Flytter du musen henover menuens ikoner, vil du på de fleste også få en undermenu op. Klikker du direkte på et af ikonerne i menuen, vil du få den side op, der svarer til det første valg i undermenuen.<br /><br />Du kan få disse valgmuligheder i menuen:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />PhpGedView kan håndtere flere GEDCOM-filer. Hvis der er lagt flere ind, vil alle tilgængelige slægtsdatabaser blive vist i en undermenu. Hver slægtsdatabase vil have sin egen velkomstside eller hovedside, som vil kunne vise forskellige blokke og indhold.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Hvis du er logget ind, kan denne menu omfatte følgende punkter:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Dette fører dig til din egen startside, der kan tilpasses.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Du kan redigere dine personlige data her.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Hvis du har valgt en rodperson til denne GEDCOM, fører dette dig til stamtavle for den person.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Dette link fører dig til din #pgv_lang[indi_info]# side, hvor alle slægtsdata om dig selv og din familie vises.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />De tilgængelige diagrammer er:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Dette vil linke dig til stamtavlen for denne GEDCOM-fil. Stamtavlen starter med den person, der er konfigureret af administratoren. Når du er logget ind, kan startpersonen være den, du har konfigureret i dine kontoindstillinger.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Efterkommerdiagrammet er i det væsentlige et <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> i omvendt rækkefølge. Denne sammenligning er ikke helt korrekt, men mens stamtavlen viser dig alle forfædre til en startperson, viser efterkommerskemaet dig alle efterkommere af en startperson.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Her ser du begivenhederne for en person langs en tidslinje. Det er interessant at sammenligne begivenhederne for to eller flere personer på samme tidslinje.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Her kan du kontrollere en persons forhold til dig selv eller til en anden person.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Dette diagram svarer meget til <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men med flere detaljer og alternativ <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> vises.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Dette diagram er meget lig <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men på en mere grafisk måde.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Følgende lister er tilgængelige:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />På disse to lister kan du gennemse alfabetiske lister over personer eller familier i dette GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Dette punkt returnerer en liste over alle de kilder, der er brugt i GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Her kan du kigge efter folk efter sted.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Du ser kun dette menupunkt, hvis det er aktiveret af webstedsadministratoren. Dette viser links til alle multimediefiler i denne GEDCOM.</li></ul>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />#pgv_lang[anniversary_calendar]# viser begivenhederne i en GEDCOM for en given dato, måned eller år.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Disse menupunkter fører dig til #pgv_lang[anniversary_calendar]# for at få vist en liste over alle begivenhederne for den aktuelle dag, måned eller år.</li></ul>";
$pgv_lang["menu_clip_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Du vil kunne se denne menu, hvis hjemmesidens administrator har aktiveret det.<br /><br />Udklipsholderen giver dig mulighed for at \"kopiere\" dele af slægtsdatabasen, således at du senere kan downloade dem til din egen PC i GEDCOM 5.5.1 filformat.";
$pgv_lang["menu_search_help"]			= "~#pgv_lang[search]#~<br /><br />Ved at klikke på menupunktet: <b />Søg</b>, markeret med et forstørrelsesglas, her vil du få en søgeside frem. Her vil du få mulighed for at udføre flere type af søgninger i slægtsdatabasen end ved at anvende søgelinket du finder øverst på siden.";
$pgv_lang["menu_help_help"]				= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>#pgv_lang[welcome_page]#</b></div>";
$pgv_lang["index_portal_help"]			= "#pgv_lang[welcome_page]# ønsker dig velkommen til programmet.<br />Siden er opbygget af flere blokke, der kan tilpasses efter behov. Derfor kan det være, at du kan se flere forskellige velkomstsider på denne hjemmeside (såfremt der er mere end en tilgængelig slægtsdatabase). Du vil kunne se følgende blokke på denne side:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Velkomstblokken viser dig den aktuelle databasetitel, dato og klokkeslæt, og hvis aktiveret af administratoren, ramtæller.<br /><br />Ramtæller er kun tilgængelig i velkomstblokken og på #pgv_lang[indi_info]# side. Tælleren tæller Hits på disse sider. Det betyder, at det tæller, hvor mange gange disse sider er besøgt. Tælleren kontrollerer ikke den besøgendes internetadresse; hvert besøg på en side fra <u>enhver</u> fjernplacering tæller som endnu et hit.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />Selvom du kan logge dig ind på næsten alle sider i dette program, vil du sikkert normalt gøre dette via velkomstsiden, fordi det er kun når du er logget ind, at du kan få adgang til beskyttet information.<br /><br />Du kan logge dig ind ved at opgive dit <b>brugernavn</b> og <b>adgangskode</b> og klikke på knappen <b>#pgv_lang[login]#</b>.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Denne blok viser jubilæer for begivenheder, der kommer i den nærmeste fremtid.<br /><br />Administratoren bestemmer, hvor langt frem blokken vil se ud. Du kan yderligere forfine blokens visning af kommende begivenheder gennem flere konfigurationsindstillinger.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~#pgv_lang[todo_block]#~<br /><br />Denne blok hjælper dig med at holde styr på <b>_TODO</b>-opgaver i databasen.<br /><br />For at tilføje At Gøre opgaver til dine optegnelser skal du muligvis først ændre GEDCOM-konfigurationen, så det faktum, at <b>_TODO</b> er på listen over fakta, der kan føjes til optegnelser over enkeltpersoner, familier, kilder og opbevaringssteder. Hver af disse lister, som du finder i sektionen Rediger indstillinger i GEDCOM-konfigurationen, er uafhængige. Rækkefølgen af listen er ikke vigtig; du kan tilføje de nye poster i begyndelsen af hver liste.";
$pgv_lang["todo_show_other_help"]     = "Vis opgaver, der er tildelt andre brugere";
$pgv_lang["todo_show_unassigned_help"]= "Vis opgaver, der ikke er tildelt nogen bruger";
$pgv_lang["todo_show_future_help"]= "Vis opgaver, der har en dato i fremtiden. Ellers vises kun varer med en dato i fortiden.";
$pgv_lang["yahrzeit_help"]			= "~#pgv_lang[yahrzeit_block]#~<br /><br />Denne blok viser dig Yahrzeiten, der kommer i den nærmeste fremtid.<br /><br />Yahrzeiten (ental: Yahrzeit) er jubilæer for en persons død. Disse jubilæer observeres i den jødiske tradition; de er ikke længere i almindelig brug i andre traditioner. «Yahrzeit» kan også staves «Jahrzeit» eller «Yartzeit».<br /><br />Administratoren bestemmer, hvor langt frem blokken vil se ud. Blokens visning af kommende Yahrzeiten kan forbedres yderligere gennem konfigurationsindstillinger.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Angiv antallet af dage, der skal vises.  Dette tal kan ikke være større end <b>#DAYS_TO_SHOW_LIMIT#</b>.  Hvis du angiver en større værdi, vil grænseværdien blive anvendt.<br /><br />Den viste grænseværdi sættes af administratoren under: <b>Admin - Opsætning af GEDCOM</b>. Her vælger menuen: <b>Visning og layout</b>, og derefter undermenuen: <b>Skjul &amp; Vis</b>.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Her kan du vælge, hvilken medietype, der skal vises.<br /><br />Når du vælger <b>#pgv_lang[random_media_persons]#</b>, vil kun medier, der er knyttet til personer blive vist.  Normalt vil det være et fotografi af personen.  Når du vælger <b>#pgv_lang[random_media_events]#</b>, vil kun medier, der er knyttet til fakta eller begivenheder blive vist.  Dette kunne fx være et billede af en dåbsattest.  Når du vælger <b>#pgv_lang[all]#</b>, vil dene blok vise alle typer af medier.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />Du kan begrænse, hvad tilfældig medieblok har tilladelse til at vise i henhold til formatet og typen af medieelement. Når et givet afkrydsningsfelt er afkrydset, kan tilfældig medieblok vise medieelementer af det format eller den type.<br /><br />Format- eller typekoder, der findes i din database, men ikke er i disse afkrydsningsfelter, antages at have det tilsvarende afkrydsningsfelt. For eksempel, hvis din database indeholder medieobjekter i formatet <b><i>pdf</i></b>, er det tilfældigt medieblok altid tilladt at vise dem. Tilsvarende, hvis din database indeholder medieobjekter af typen <b><i>special</i></b>, er tilfældig medieblok altid tilladt at vise dem.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Her kan du udelukke nogle daterede begivenheder.  For eksempel, skulle #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, osv. alle være daterede.<br /><br />Når du vælger <b>Ja</b>, vil kun fødsler, dødsfald og vielser blive vist. Når du vælger <b>Nej</b>, vil alle daterede begivenheder blive vist.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Denne indstilling styrer, hvordan oplysningerne præsenteres.<br /><br />Når du vælger <b>#pgv_lang[style1]#</b>, vises oplysningerne i tekstform svarende til det, du ser i de forskellige diagramfelter. Dette format er velegnet til blokke, der udskrives på højre side af siden.<br /><br />Når du vælger <b>#pgv_lang[style2]#</b>, vises oplysningerne i tabelformat og er mere velegnede til de større blokke, der udskrives til venstre på siden.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Denne indstilling styrer, hvordan oplysningerne sorteres.<br /><br />Når du vælger <b>#pgv_lang[by_alpha]#</b>, vises oplysningerne i alfabetisk rækkefølge. Når du vælger <b>#pgv_lang[by_anniv]#</b>, bestilles oplysningerne efter jubilæum med de seneste jubilæer først.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Denne indstilling styrer, om knappen til download af kalenderbegivenheder vises til indloggede brugere. Den downloadede kalenderfil kan importeres til kompatible programmer som Microsoft Outlook for f.eks. At generere automatiske e-mail-påmindelser om jubilæer.<br /><br />Når den er indstillet til <b>#pgv_lang[no]#</b>, vil den loggede bruger ikke være i stand til at downloade kalenderfilen. Når den er indstillet til <b>#pgv_lang[yes]#</b>, vises knappen Download. Denne knap vises aldrig, når brugeren ikke er logget ind.";
$pgv_lang["cal_download_user_help"]			= "Hvis du er logget ind, kan du muligvis se ikonet <img src='images/ical.png' alt='' />. Hvis du klikker på ikonet, downloader du begivenhederne som en kalenderfil, som kan importeres til kompatible programmer som Microsoft Outlook for f.eks. At generere automatiske e-mail-påmindelser om jubilæer.<br /><br />Hvis du er logget ind og ikke kan se dette ikon, har administratoren deaktiveret denne funktion. Besøgende, der ikke er logget ind, kan ikke se dette ikon og kan ikke downloade kalenderfilen.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br /><br />Denne blok tillader en stamtavle, efterkommere eller timeglasdiagram på Velkomst- eller MyGedView-siden. På grund af pladsbegrænsninger bør diagrammerne kun placeres i venstre side af siden.<br /><br />Når denne blok vises på Velkomstsiden, bestemmes rodpersonen og typen af diagram, der skal vises af administratoren. Når denne blok vises på brugerens personaliserede MyGedView-side, bestemmes disse muligheder af brugeren.<br /><br />Opførelsen af disse diagrammer er identisk med deres adfærd, når de kaldes op fra menuerne. Klik på feltet for en person for at se flere detaljer om dem.";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[todays_events_block]#~<br /><br />Denne blok viser dig begivenheder i slægtsdatabasen på samme dato i året som i dag.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Denne blok er stort set den samme som #pgv_lang[user_favorites_block]# blokken på #pgv_lang[mygedview]# siden. I modsætning til portalsidekonfigurationen er det kun administratoren eller en bruger med administratorrettigheder, der kan ændre listen over favoritter i denne blok.<br /><br />Formålet med denne blok er at henlede den besøgendes opmærksomhed på personer af særlig interesse. Denne GEDCOMs favoritter kan vælges fra en liste i overskriften på hver side.<br /><br />Når du klikker på en af de anførte webstedsfavoritter, føres du til siden #pgv_lang[indi_info]# af den person.";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br /><br />Denne formular giver dig mulighed for at tilføje en ny favorit til din liste over favoritter.<br /><br />Du skal angive enten et ID for personen, familien, eller kilden, som du ønsker at gemme som en favorit, eller du skal angive en URL-adresse og en titel.  Notesfeltet er valgfrit og kan anvendes til at beskrive favoritten.  Alt, der anføres i notesfeltet vil blive vist i blokken: <b>Mine favoritter</b>.";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats_block]#~<br /><br />I denne blok vil du se nogle statistiske oplysninger vedr. den aktive slægtsdatabase. Hvis du ønsker mere information, kan du imidlertid sende en forespørgsel til kontaktpersonen, som du finder nederst på siden.";
$pgv_lang["index_common_names_help"]	= "~#pgv_lang[block_top10]#~<br /><br />Nederst i statistikrammen, finder du en oversigt over de oftest forekommende efternavne i den aktive slægtsdatabase. Ved at klikke på et af navnene, vil du blive sendt videre til en liste over personer med dette efternavn.<br /><br />Hvilke navne der vises, bestemmes af administratoren.";
$pgv_lang["index_common_given_names_help"]		= "~#pgv_lang[block_givn_top10]#~<br /><br />Denne blok viser de mest givne navne. Det viser mandlige og kvindelige navne i kolonner. En tredje kolonne vises, når der er personer, hvis køn ikke kendes.<br /><br />Administratoren bestemmer, hvor mange navne der faktisk vises.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />I denne blok vælger PhpGedView tilfældigt en mediefil, der skal vises ved hvert besøg på denne side.<br /><br />Når du klikker på billedet, vil du se dens version i fuld størrelse. Under billedet har du et link til den person, der er knyttet til billedet. Når du klikker på billedteksten, vil du se billedet på siden #pgv_lang[media_list]#. Når du klikker på personens navn, føres du til siden #pgv_lang[indi_info]# for den person.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Denne blok viser dig de brugere, der aktuelt er logget ind.<br /><br />Hvis du ikke er administrator, er dit syn på indloggede brugere begrænset til dem, der har valgt at være synlige, mens de er online. For at dette skal fungere, skal du også vælge at være synlig, mens du er online. Onlinebrugere, der er usynlige for dig, regnes for at være anonyme.";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br /><br />Nyhedsblok er på en måde en opslagstavle for denne slægtsdatabase. Administratoren af hjemmesiden kan her skrive vigtige meddelelser eller interessante nyheder.<br /><br />Hvis du har noget interessant at meddele andre brugere og besøgende, kontakt da venligst administratoren af hjemmesiden via linket nederst på siden.";
$pgv_lang["recent_changes_help"]		= "~#pgv_lang[recent_changes_block]#~<br /><br />Denne blok viser dig de seneste ændringer, der er foretaget i slægtsdatabasen. (Dette er knyttet til GEDCOM-tagget CHAN).";
$pgv_lang["gedcom_news_limit_help"]		= "Du kan begrænse antallet af nyhedsartikler, der vises, og derved reducere højden af nyhedsblokke.<br /><br />Denne mulighed bestemmer om der skal sættes en grænse eller ej, og om grænsen skal sættes efter artiklens alder eller antallet af artikler.";
$pgv_lang["gedcom_news_flag_help"]		= "Skriv grænseværdien her.<br /><br />Hvis du har valgt at begrænse antallet af artikler efter deres alder, vil alle artikler, der er ældre end det antal dage du har anført, ikke blive vist. Hvis du har valgt at begrænse visningen af artikler efter artiklernes antal, vil det specificerede antal af artikler, sorteret efter alder, blive vist. De resterende artikler vil ikke blive vist.<br /><br />Skrives et 0, vil der ikke blive sat nogen grænse, og alle artikler vil blive vist i nyhedsblokke.";
$pgv_lang["gedcom_news_archive_help"]	= "For at reducere højden af nyhedsblokke, har administratoren vlagt at skule nogle artikler. Du kan se de skjulte artikler ved at klikke på linket <b>#pgv_lang[gedcom_news_archive]#</b>";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Denne blok giver administratoren mulighed for at tilføje oplysninger til siden Indeks eller Portal. Dens formål svarer til #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, og #pgv_lang[gedcom_stats_block]# blokke, men administratoren har mere kontrol over udseendet.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />Der bør ingen tekst være eller også bør den være meget kort.  Når der ingen tekst angives, vil blokken til avanceret HTML blive vist på indeks-eller portalsiden som en almindelig blok, på samme måde som for en HTML blok.  Når der er agnivet noget tekst, vil blokken til avanceret HTML  bive vist som alle andre blokke, fuldstændig med en bloktitel indeholdende den tekst, du har skrevet.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />For at hjælpe di med at komme igang med denne blok, har vi oprettet adskillige standard skabeloner.  Når du vælger en af disse skabeloner vil tekstområdet indeholde en kopi som du kan ændre alt efter dit behov.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />I modsætning til blokke for HTML, Nyheder og GEDCOM statistik, så har du fuld kontrol over, hvordan din blok ser ud. Du kan anvende HTML tags, og blokken anvender CSS stylesheets fra det aktive tema.  Henvisninger til information fra den aktive slægtsdatabase kan inkluderes i teksten.<br /><br />Database henvisninger er vist i teksten vha. nøgleord omgivet af <b>&#35;</b> symboler.  For eksempel repræsenterer <b>&#35;TOTAL_FAM&#35;</b> antallet af familier i databasen.  Lejlighedsvis kan det være du ønsker at anvende en databasehenvisning som tekst istedet for selve tgeksten.  For at gøre det, skal du erstatte <b>&#35;</b> symbolerne, der omgiver nøgleord, med deres tilsvarende symbol.  For eksempel, hvis din tekst indeholder <b>&amp;&#35;35;TOTAL_FAM&amp&#35;35;</b> vil den blive printet som <b>&#35;TOTAL_FAM&#35;</b> istedet for at blive en database henvisning.<br /><br />For et komplet eksempel på brugen af denne blok, bedes du undersøge &quot;#pgv_lang[gedcom_stats_block]#&quot; skabelon, der findes i blokke / mappe, bruger den de fleste af typografierne for tags, herunder sprog- og hjælpetekstlinks.<br /><br />Skabelonen <b>#pgv_lang[htmlplus_block_keyword]#</b> indeholder en fuld liste over alle understøttede nøgleord.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Aktivér kompatibilitet med ældre versioner af denne blok. Når dette er markeret, genkendes og handles både gamle og nye søgeord.<br /><br />For eksempel vil teksten <b>&#35;TOTAL_FAM&#35;</b> blive anerkendt som svarende til <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> til <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> til <b>&#35;topTenLargestFamily&#35;</b> osv.<br /><br />Medmindre det er absolut nødvendigt, skal du ikke bruge kompatibilitetstilstand.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Vælg den database som søgeordne passer til.<br /><br />Din hjemmeside understøtter adskillige databaser. Nøgleord så som <b>&#35;totalFamilies&#35;</b> kan kun henvise til én database. Du kan identificer den database der skal henvises til for alle sådanne nøgleord. Hver #pgv_lang[htmlplus_block_name]# blok kan kun have adgang til én database.";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br /><br />Skjul eller vis listen over fornavne på personer af ukendt køn.<br /><br />Blokken #pgv_lang[block_givn_top10]# skjuler altid listen over fornavne, når der ikke findes nogen personer af det køn i din database. Denne mulighed giver dig mulighed for at skjule listen over personer af ukendt køn, selv når der er sådanne personer i din database.";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Naturligvis ville det være ideelt at oprette et program så enkelt og let at bruge, at det slet ikke har brug for nogen forklaring; det skal være så simpelt som at læse en bog.<br /><br />Selvom PhpGedView er meget kompliceret, skal du ikke bemærke det, når du bruger det; næsten alt kan bruges uden forklaring. Men da vi muligvis har mange besøgende og brugere, der ikke er meget erfarne med brugen af en computer eller med Internettet, tilbyder vi dig hjælp på bestemte steder.<br /><br />I menuen under hjælp, vil du finde følgende menuvalg:";
$pgv_lang["help_page_help"]				= "<ul><li><b>Hjælp til denne side</b><br />For alle sider er der en \"generel hjælp\" tilgængelig.<br />Når du er på en side, kan du klikke på dette menuvalg. Så vil du få \"hjælp til denne side\", som vil fortælle dig om de forskellige elementer, du kan finde på den pågældende side. Hjælpeteksterne er i de fleste tilfælde kortfattede.<br />Hvis du ønsker mere hjælp, eller info om specielle elementer på siden, kan du bruge de spørgsmålstegn, der findes efter forskellige elementer. Check for øvrigt at det tredje menuvalg i hjælpemenuen: \"Hjælp <b>#pgv_lang[qm]#</b> for tekst\" er aktiveret.</li></ul>";
$pgv_lang["help_content_help"]			= "<ul><li><b>Emner i hjælp</b><br />Ved at klikke på dette menupunkt, vil du få et hjælpevindue op, som viser en oversigt over de fleste emner du kan få hjælp til.</li></ul>";
$pgv_lang["help_faq_help"]				= "<ul><li><b>FAQ liste</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]				= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]				= "<ul><li><b>Skjul / Vis hjælp til tekst</b><br />Dette menupunkt er måske det mest nyttige for dig. Ved at klikke på dette link vil du enten slå \"hjælp til tekst\" til eller fra.<br /><br />Når den er slået til, vil du kunne finde et spørgsmålstegn til højre for nogle links eller knapper. Ved at klikke på dette <b>#pgv_lang[qm]#</b>, vil der dukke et lille hjælpevindue op med lidt information om dette objekt.<br /><br />Og modsat, når du klikker på \"Skjul hjælp til tekst\", vil der ikke blive vist nogen spørgsmålstegn, indtil til du klikker på \"Vis....\" igen.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]					= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Her er der en forklaring på nogle af de ord, der er anvendt i denne hjælpetekst:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF file format</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Theme</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Velkomstside~<br /><br />Dette er hovedindgangen til slægtsdatabasen. Det er her de fleste kommer ind når de besøger hjemmesiden. Her kan du finde vigtig information som forklaringer, beskeder osv.<br />Men, naturligvis er det også muligt at gå ind via en eller flere \"køkkenveje\" ...";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM-fil~<br /><br />Et engelsk citat fra introduktionen til GEDCOM 5.5.1-standarden:<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Dansk:<div class=\"list_value_wrap\">GEDCOM blev udviklet af Familiehistorisk Afdeling i Kirken Jesus Kristus af de Sidste Dages Hellige (SDH kirke) for at give et fleksibelt, ensartet format til udveksling af edb-slægtsdata.&nbsp; GEDCOM er et akronym for <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (slægtsforskning datakommunikation).&nbsp; Dens formål er at fremme deling af genealogiske oplysninger og udvikling af en bred vifte af interoperable softwareprodukter til at hjælpe slægtsforskere, historikere og andre forskere.</div><br />En kopi af GEDCOM 5.5.1 <u>kladden</u> Standard, som PhpGedView overholder, kan downloades i PDF-format her:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Denne standard er kun tilgængelig på engelsk.<br /><br />GEDCOM-filen indeholder alle oplysninger om familien. Her lagres alle fakta, datoer, begivenheder osv. GEDCOM-filer skal følge strenge regler, fordi de skal kunne udveksles mellem mange programmer uafhængigt af platforme eller operativsystemer.";
$pgv_lang["def_gedcom_date_help"]		= "~Datoer i en GEDCOM fil~<br /><br />Selvom datofeltet tillader friformularindtastning (hvilket betyder at du kan indtaste hvad du vil), er der nogle regler om, hvordan datoer skal indtastes i henhold til GEDCOM 5.5.1-standarden.<ul><li>En fuld dato indtastes i form DD MMM ÅÅÅÅ. For eksempel, <b>01&nbsp;MAR&nbsp;1801</b> eller <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Hvis du mangler en del af datoen, kan du udelade den del. For eksempel, <b>MAR&nbsp;1801</b> or <b>14&nbsp;DEC</b>.</li><li>Hvis du ikke er sikker, eller datoen ikke er bekræftet, kan du indtaste <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = om), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = før), <b>AFT&nbsp;1949</b> (aft = after = efter)</li><li>Datointervaller indtastes som <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> eller som <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = mellem)<br /><br /><b>FROM</b> angiver, at den begivenhed, der beskrives, skete kontinuerligt mellem de angivne datoer og bruges sammen med begivenheder som ansættelse. <b>BET</b> angiver en enkelt forekomst af begivenheden, et stykke tid mellem de angivne datoer og bruges sammen med begivenheder såsom fødsel.<br /><br />Ukorrekte datoer, hvor dagen i måneden eller måneden mangler, fortolkes altid som den første eller sidste mulige dato, afhængigt af om den upræcise dato forekommer før eller efter det adskilte nøgleord. For eksempel fortolkes <b>FEB&nbsp;1804</b> som <b>01&nbsp;FEB&nbsp;1804</b> når det sker før TO eller AND, og som <b>29&nbsp;FEB&nbsp;1804</b> når det sker efter TO eller AND.</li></ul><br /><b>Sørg for at indtaste datoer og forkortelser på <u>engelsk</u>,</b> for da kan GEDCOM-filen udskiftes, og PhpGedView kan oversætte alle datoer og forkortelser korrekt til det aktuelt aktive sprog. Desuden foretager PhpGedView beregninger ved hjælp af disse datoer. Hvis der er indtastet forkerte datoer i datofelterne, kan PhpGedView ikke beregne korrekt. Du kan klikke på kalenderikonet for at få hjælp til at vælge en dato.<br /><br />Følgende forkortelser anvendes:<ul><li>JAN = January = januar</li><li>FEB = February = februar</li><li>MAR = March = marts</li><li>APR = April = april</li><li>MAY = maj</li><li>JUN = June = juni</li><li>JUL = July = juli</li><li>AUG = August</li><li>SEP = September</li><li>OCT = October = oktober</li><li>NOV = November</li><li>DEC = December</li><li>bef = before = før</li><li>abt = about = ca.</li><li>aft = after = efter</li></ul>";
$pgv_lang["def_gramps_help"]			= "~GRAMPS XML databasefil~<br /><br />Et engelsk citat fra GRAMPS Project:<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Dansk:<div class=\"list_value_wrap\">GRAMPS hjælper dig med at spore dit stamtræ. Det giver dig mulighed for at gemme, redigere og undersøge slægtsdata. GRAMPS forsøger at tilvejebringe alle de fælles kapaciteter i andre slægtsforskningsprogrammer, men, vigtigere, at give en yderligere integrationsfunktion, der ikke er fælles for disse programmer. Dette er evnen til at indsætte bit og information direkte i GRAMPS og omarrangere / manipulere eventuelle / alle datahændelser i hele databasen (i en hvilken som helst rækkefølge eller rækkefølge) for at hjælpe brugeren med at udføre forskning, analyse og korrelation med potentialet af udfyldning af forholdshuller.</div><br />En engelsk kopi af GRAMPS XML-format v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">kan findes her</a> i både RELAX NG Schema-format og DTD-format.<br /><br />For mere information om GRAMPS-projektet, besøg <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]				= "~PhpGedView~<br /><br />PhpGedView (eller PGV) lægger ikke bare statiske sider på nettet; det er dynamisk og kan tilpasses på mange måder.<br /><br />PhpGedView blev oprettet af John Finlay for at se GEDCOM-filer online. John begyndte at udvikle programmet på egen hånd. Et internationalt team af udviklere og oversættere har siden tilsluttet sig ham og arbejder på at forbedre programmet. Blandt de mere betydningsfulde funktioner, der er tilføjet eller forbedret i programmet, er dets omfattende understøttelse af andre sprog end engelsk og muligheden for at tilføje og redigere begivenheder online.";
$pgv_lang["def_theme_help"]				= "~Tema~<br /><br />Dette websted kan have forskellige \"udseende\", kaldet Temaer. Webstedsadministratoren vælger et standardtema, som alle, der kommer ind på dette sted, oprindeligt vil se.<br /><br />Når administratoren har aktiveret denne funktion, kan alle brugere vælge deres egne temaer. PhpGedView husker det sidst valgte tema for hver bruger, der er logget ind, så brugeren automatisk ser temaet næste gang han logger ind.<br /><br />Temaer kan bruges som en måde at skelne mellem forskellige databaser på det samme sted. Hver database kan have et andet standardtema.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br /><br />Dette er din personlige GedView side.<br /><br />Her kan du finde hurtiglinks til dine personlige data, som <b>#pgv_lang[editowndata]#, #pgv_lang[my_indi]#</b> (dette er siden, hvor dine personlige data vises) og <b>#pgv_lang[my_pedigree]#</b>. I tillæg hertil kan du have en blok med <b>Beskeder</b>, en <b>Notatblok</b> (som en opslagstavle) og flere andre.<br /><br />Denne siden har det samme udseende som Hovedsiden. Mens blokke på din Hovedsiden er valgt af adminstratoren af hjemmesiden, kan du selv vælge dine egne blokke på denne side (med visse begrænsninger naturligvis...). I velkomstblok på din side, kan du finde linken til at ændre denne side.<br /><br />Du kan vælge imellem følgende blokke eller links:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Tilpas «#pgv_lang[mygedview]#»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]	= "~Tilpas #pgv_lang[mygedview]#~<br /><br />Da du kom ind på denne side første gang, havde du allerede nogle blokke på siden. Hvis du ønsker det, kan du tilpasse denne side efter dine egne ønsker/behov.<br /><br />Ved at klikke på dette link, vil du få et nyt vindue op med et skema, hvor du kan tilføje, slette eller flytte på blokke. Mere forklaring kan findes i skemaet.";
$pgv_lang["mygedview_message_help"]		= "~#pgv_lang[user_messages_block]#~<br /><br />I denne blok kan du finde de beskeder, der er sendt til dig fra andre brugere, eller fra Admin. Selvfølgelig kan du også sende dine egne beskeder til andre brugere eller administratorer.<br /><br />Mailsystemet i PhpGedView er lavet med henblik på at beskytte dit eget privatliv. Du behøver ikke at opgive din e-mail-adresse her, og andre vil heller ikke kunne se din e-mail-adresse.<br /><br />For at tilføje tekst til en besked, kan du klikke på beskedens overskrift eller på \"+\" tegnet ved siden af den.  Du kan slette flere beskeder ved at afkrydse checkboksen ved siden af de beskeder, du ønsker at slette og derefter klikke på knappen <b>Slet valgte beskeder</b>.";
$pgv_lang["mygedview_favorites_help"]	= "~#pgv_lang[user_favorites_block]#~<br /><br />Mine favoritter virker på samme måde som at indsætte bogmærker i slægtsdatabasen.<br /><br />Forestil dig, at du har nogle i slægten, hvis oplysninger, du ønsker at checke regelmæssigt. Du går da til siden med oplysninger om personen, og klikker på linket <b>Tilføj en ny favorit</b>. Denne person har nu fået et bogmærke og er blevet føjet til listen over <b>Mine favoritter</b>.<br /><br />Nu vil du kunne finde denne favorit hver gang du besøger siderne ved at klikke på <b>Mine favoritter</b> øverst på siderne. Ved at klikke på navnet, vil du blive sendt til siden med oplysninger om personen.";
$pgv_lang["mygedview_myjournal_help"]	= "~#pgv_lang[user_news_block]#~<br /><br />Du kan bruge denne notesblok til at skrive kommentarer (eller huskesedler) til eget brug. Naturligvis vil notatet også være der næste gang du besøger siden.<br /><br />Disse notater vil ikke være synlige for andre.";
$pgv_lang["mygedview_welcome_help"]		= "~#pgv_lang[welcome_block]#~<br /><br />Denne velkomstblok viser dig:<ul><li>Den aktive slægtsdatabase</li><li>Dato og klokkeslæt</li><li>Links til:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>PS :</b><br />Du vil kun kunne se links til <b>#pgv_lang[my_indi]#</b> og <b>#pgv_lang[my_pedigree]#</b> , hvis du er registreret i den aktive slægtsdatabase. Derfor vil du kunne se disse links i nogle af slægtsdatabaserne, mens i andre, hvor du ikke er registreret, vil du ikke kunne se disse links.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~Anetræ~<br /><br />En stamtavle er en optælling af alle forfædre til startpersonen. Brugere, der ikke er logget ind, ser stamtavlen til den startende (rod) person, der er valgt af webstedsadministratoren. Indloggede brugere kan vælge deres egen start (root) person.<br /><br />I denne sammenhæng betyder \"Alle forfædre\" far og mor, deres forældre osv. Stamtavlen vises grafisk; du behøver ikke at kæmpe gennem sider med tekst for at bestemme dine forfædre.<br /><br />Alle personerne bliver vist i særskilte bokse med linier imellem, der viser tilhørsforholdene.<br /><ul><li><b>Navneboksen i anetræet</b><br />Hvis anetræet er sat op til at vise detaljer, vil du se navnet på personen samt dato for fødsel og eventuelt død. Du kan klikke på personens navn for at få vist en side med fakta om denne person.<br /><br />Når <b>Vis detaljer</b> er aktiveret, er der to ikoner inde i navnefeltet.</li><li><b>Ikoner i navnefeltet</b><br />Når valget \"Vis detaljer\" er afmærket, vises der ikoner inde i hver navneboks. Afhængig af hjemmesidens opsætning, skal du enten flytte musen henover ikonet, eller klikke på det. Når du klikker, eller flytter musen henover ikonet, vil der dukke en ny undermenu op.<br /><br />Valgene \"#pgv_lang[index_header]#\" og \"#pgv_lang[descend_chart]#\" svarer til dem, du finder i hovedmenuen, men forskellen er at startpersonen nu er personen i den valgte boks. Du vil også se \"#pgv_lang[fam_spouse]#\". Nedenunder ser du navnet på ægtefælllen/partneren, efterfulgt af eventuelle børn. Du kan klikke på alle navne.</li><li><b>Forstørrelsesglasset inde i navneboksen</b><br />Dette ikon afhænger også af sidens opsætning. Du skal enten flytte musen henover det, eller klikke på det. Dette gør navneboksen større, så der bliver vist flere oplysninger om personen. Du kan se flere begivenheder og tilhørende datoer. Også her kan du klikke på eventuelle navne.</li><li><b>Pilene</b><br />Til venstre og højre for de yderste navnebokse hhv. til venstre og højre på skærmen, vil du kunne se nogle pile. De giver dig mulighed for, ved at klikke på dem, at forskyde anetræet en generation op eller ned.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]				= "~#pgv_lang[show_details]#~<br /><br />Med denne mulighed kan du enten vise eller skjule alle detaljer i boksene Navn. Du kan få vist flere felter på en skærm, når detaljerne er skjult.<br /><br />Når alle detaljer er skjult, vises ikke zoomikonet beskrevet nedenfor. Men hvis administratoren har aktiveret Zoom-funktionen, fungerer hele boksen som et Zoom-ikon for at afsløre alle detaljer om personen.<br /><br />Når detaljerne ikke skjules, og Zoom-funktionen identificeres med en forstørrelsesglasikon, er blevet aktiveret af administratoren, kan du afsløre endnu flere detaljer om den person. Hvis du normalt skal klikke på Zoom-ikonet for at zoome ind, kan du afsløre yderligere skjulte detaljer ved at klikke på ikonet her. Tilsvarende, hvis du kan zoome ind ved at svæve over Zoom-ikonet, vil skjulte detaljer blive afsløret ved at svæve over dette ikon her.<br /><br />Hvis du har klikket på Zoom-ikonet for at afsløre flere detaljer, kan du gendanne feltet til dets normale detaljeringsniveau ved at klikke på Zoom-ikonet igen. Hvis du har afsløret flere detaljer ved blot at flytte musemarkøren over Zoom-ikonet, gendannes feltet til dets normale detaljeringsgrad, når du flytter musemarkøren væk fra Zoom-ikonet.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Med denne indstilling bestemmer du sidelayoutretningen.<br /><br />Ændring af denne indstilling kan være nyttig, hvis du vil lave et skærmbillede eller hvis du har en anden type skærm.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;vil gøre træet højere, således at et 4-generationsskema skal passe på en enkelt side, der udskrives lodret.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;skaber et bredere træ, der skal udskrives på en enkelt side, der udskrives vandret.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;roterer diagrammet, men ikke dets felter, 90 grader mod uret, så den ældste generation er øverst i diagrammet.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;roterer diagrammet, men ikke dets felter, 90 grader med uret, så den ældste generation er i bunden af diagrammet.</li></ul>";
$pgv_lang["rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Hvis du vil vise et diagram med en ny startende (rod) person, indtastes id'et for den nye startperson her.<br /><br />Hvis du ikke kender id'et for den person, skal du bruge <b>Find ID</b> link.<br /><br /><b>ID-NUMMER</b><br />ID-numrene, der bruges i PhpGedView, er <u>ikke</u> de udstedte identifikationsnumre af forskellige regeringer (f.eks. kørekort eller pasnumre). Det ID-nummer, der henvises til her, er simpelthen et nummer, der bruges i databasen til entydigt at identificere hver person; det blev tildelt af herkomstprogrammet, der oprettede GEDCOM-filen, der blev importeret til PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[generations]#~<br /><br />Her kan du angive antallet af generationer, der skal vises på denne side.<br /><br />Hvad der er bedst for dig afhænger af størrelsen på din skærm, og om du viser detaljer eller ikke.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~#pgv_lang[login]#~<br /><br />På denne side kan du logge dig ind, bestille en ny adgangskode eller en ny brugerkonto.";
$pgv_lang["username_help"]				= "~#pgv_lang[username]#~<br /><br />I dette felt skriver du dit brugernavn.<br /><br /><b>Brugernavnet er følsomt for store og små bogstaver.</b> Dette betyder at <b>MitNavn</b> er <u>ikke</u> det samme som <b>mitnavn</b> eller <b>MITNAVN</b>.";
$pgv_lang["password_help"]				= "~#pgv_lang[password]#~<br /><br />I dette felt skriver du din adgangskode.<br /><br /><b>Adgangskoden er følsomt for store og små bogstaver.</b> Dette betyder at <b>MitAdgangskode</b> er <u>ikke</u> det samme som <b>mitadgangskode</b> eller <b>MITADGANGSKODE</b>.";
$pgv_lang["login_buttons_help"]			= "~Log ind knap~<br /><br />Her ser du en knap til at logge ind på systemet.<br /><br />Hvis du klikker på denne knap, vender du tilbage til den side, du lige var på, men med loggede adgangsrettigheder.<br /><br />Hvis du f.eks. klikker på <b>#pgv_lang[login]#</b>, da du var på stamtavlesiden, vender du tilbage til den samme side. Hvis du klikker på denne knap, da du var på hovedvelkomstsiden, føres du til siden «#pgv_lang[mygedview]#», hvor du kan redigere dine indstillinger, tilføje eller redigere favoritter, sende og læse beskeder osv.";
$pgv_lang["login_buttons_aut_help"]		= "~Log ind knap~<br /><br />Her ser du en knap til at logge ind på systemet.<br /><br />Hvis du klikker på denne knap, bliver du logget ind og går direkte til din siden «#pgv_lang[mygedview]#», hvor du kan redigere dine indstillinger, tilføje eller redigere favoritter, sende og læse beskeder osv.";
$pgv_lang["new_password_help"]			= "~#pgv_lang[requestpassword]#~<br /><br />Hvis du har glemt din adgangskode, kan du klikke på dette link for at anmode om en ny adgangskode.<br /><br />Du føres til siden «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]				= "~#pgv_lang[requestaccount]#~<br /><br />Hvis du er gæst på denne hjemmeside og ønsker at få en brugerkonto, kan du klikke pådette link.<br /><br />Afhængigt af hvordan administratoren har oprettet webstedet, kan din e-mail-klient muligvis startes, så du kan e-maile administratoren for at anmode om et nyt login-id, eller du kan føres til siden «#pgv_lang[requestaccount]#».";
$pgv_lang["mygedview_login_help"]		= "Siden «#pgv_lang[mygedview]#» er kun tilgængelig for registrerede brugere. I «#pgv_lang[mygedview]#» kan du lave dine egne genveje til favoritpersoner, notere i din notatblok, sende meddelelser, se loggen for andre brugere eller skræddersy din egen opsætning af PhpGedView.<br /><br />Hvis du har et brugernavn og en adgangskode, så log dig ind i felterne nedenfor.";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette felt kan du angive dit fornavn.<br /><br />Vi skal bruge dit fornavn og efternavn for at afgøre om du opfylder betingelserne for at få en brugerkonto, og hvilke rettigheder du skal have.  Navnene vil være synlige for andre familiemedlemmer og brugere, der er logget ind.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette felt kan dy skrive dit efternavn.<br /><br />Vi skal bruge dit fornavn og efternavn for at afgøre om du opfylder betingelserne for at få en brugerkonto, og hvilke rettigheder du skal have.  Navnene vil være synlige for andre familiemedlemmer og brugere, der er logget ind.";
$pgv_lang["register_info_01"]		= "~#pgv_lang[requestaccount]#~<br /><br />Mængden af data, der kan vises offentligt på denne hjemmeside kan begrænses af hensyn til love vedr. privatlivets beskyttelse. Mange mennesker ønsker ikke at deres personlige data gøres offentlig tilgængelig på Internettet. Personlige data kan misbruges til spam eller tyveri af identitet.<br /><br />Adgang til denne site er begrænset til alle, der har en brugerkonto. Efter at administratoren har verificeret og godkendt din ansøgning om en brugerkonto, kan du logge ind.<br /><br />Hvis privatlivsindstilling for relationer er aktiveret, vil du kun være i stand til at se private informationer for dine egne nærmeste slægtninge efter at du har logget ind. Administratoren kan også give visse brugere tilladelse til at redigere databasen, således at de kan ændre eller tilføje information.<br /><br />Hvis du har behov for mere hjælp, venligst bruge linket nedenfor til at kontakte administratoren.";
$pgv_lang["register_info_02"]		= "~#pgv_lang[requestaccount]#~<br /><br />Mængden af data, der kan vises offentligt på denne hjemmeside kan begrænses af hensyn til love vedr. privatlivets beskyttelse. Mange mennesker ønsker ikke at deres personlige data gøres offentlig tilgængelig på Internettet. Personlige data kan misbruges til spam eller tyveri af identitet.<br /><br />Adgang til denne site er kun tilladt for <u>godkendte</u> brugere. Efter at administratoren har verificeret og godkendt din ansøgning om en brugerkonto, kan du logge ind og de private data.<br /><br />Hvis privatlivsindstilling for relationer er aktiveret, vil du kun være i stand til at se private informationer for dine egne nærmeste slægtninge efter at du har logget ind. Administratoren kan også give visse brugere tilladelse til at redigere databasen, således at de kan ændre og tilføje information.<br /><br />Hvis du har behov for mere hjælp, venligst brug linket nedenfor til at kontakte administratoren.";
$pgv_lang["register_info_03"]		= "~#pgv_lang[requestaccount]#~<br /><br />Mængden af data, der kan vises offentligt på denne hjemmeside kan begrænses af hensyn til love vedr. privatlivets beskyttelse. Mange mennesker ønsker ikke at deres personlige data gøres offentlig tilgængelig på Internettet. Personlige data kan misbruges til spam eller tyveri af identitet.<br /><br />Adgang til denne site er kun tilladt for <u>familiemedlemmer</u>. AEfter at administratoren har verificeret og godkendt din ansøgning om en brugerkonto, kan du logge ind og de private data.<br /><br />IHvis privatlivsindstilling for relationer er aktiveret, vil du kun være i stand til at se private informationer for dine egne nærmeste slægtninge efter at du har logget ind. Administratoren kan også give visse brugere tilladelse til at redigere databasen, således at de kan ændre og tilføje information.<br /><br />vis du har behov for mere hjælp, venligst brug linket nedenfor til at kontakte administratoren.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Denne side vil vise personens efterkommere.<br /><br />Du kan vælge en startperson for efterkommeroversigten, eller du kan overføres til denne side ved at klikke på linket \"#pgv_lang[descend_chart]#\" på en anden side. Ved at klikke på en pil-op, vil startpersonen blive skiftet ud med forældrene til den person pilen stod ved siden af.  Klikker du på ikonet øverst til højre i personboksen vil du få en ny menu frem med nære slægtninge til denne person.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br /><br />På dette diagram kan du vise en eller flere personer langs en vandret tidslinje. Dette diagram giver dig mulighed for at se, hvordan forskellige menneskers liv overlappede hinanden.<br /><br />Du kan tilføje personer til diagrammet individuelt eller efter familiegrupper efter deres IDer. Den forrige liste huskes, når du tilføjer flere personer til diagrammet. Du kan når som helst rydde diagrammet med knappen <b>Ryd Diagram</b>.<br /><br />Du kan også tilføje personer til diagrammet ved at søge efter dem efter datointerval eller lokalitet.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#<br /><br /><b>Inkluder øjeblikkelig familie</b><br />Inkluder øjeblikkelig familie er markeret som standard. Efterlad markeret for at se far, mor, ægtefælle, søskende og børn til den person, der føjes til tidslinjen. Fjern markeringen, hvis du ønsker at udelade den nærmeste familie.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />På denne side kan du vise en eller flere person(er) langs en tidslinie. Du kan for eksempel vise status for to eller flere personer på et givet tidspunkt.<br /><br />Hvis du klikker på et Tidslinie-link på en faktaside for en person eller familie, vil denne person / partner vises som første person på tidslinien. Hvis du klikker på Tidslinie i topmenuen, så starter du med en \"blank\" side uden at der er valgt nogen person(er).";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Du kan have flere personer på tidslinien.<br /><br />Brug dette felt til at angive personens ID nummer. Hvis du ikke kender personens ID nummer, kan du klikke på linket <b>Finde ID</b> efter feltet.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Klik på dette link for at fjerne personen fra tidslinien.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Hvis du sætter et mærke i denne checkboks, vil du se en aldersmarkør.<br /><br />Du kan flytte op eller ned langs tidslinien. Den bevægelige aldersmarkør er en god funktion til at checke en persons alder i forhold til bestemte begivenheder. For hver person i oversigten kan du indsætte eller fjerne aldersmarkøren.";
$pgv_lang["timeline_control_help"] = "~#pgv_lang[timeline_controls]#~<br /><br />~HASTIGHED~<br />Klik på rullemenuen for at ændre den hastighed, hvormed tidslinjen ruller.<br /><br />~Begynd år~<br />Indtast startår for området.<br /><br />~Slutår~<br />Indtast afslutningsåret for intervallet.<br /><br />~Søg~<br />Klik på knappen Søg for at begynde at søge efter begivenheder inden for det interval, der er identificeret i felterne Begyndelsesår og Slutår.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />På denne side kan du vise slægtskabet mellem to personer. Det er ikke sikkert at disse personer har et direkte slægtskab (blodslinie). Ethvert tilhørsforhold vil blive fundet.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Hvis du blev overført til denne side fra en anden side (for eksempel ved at have klikket på linket <b>slægtskab med dig</b>), så vil du her se slægtskabet mellem de to personer.<br /><br />Ellers må du skrive ID nummeret på de personer, du ønsker at få oplyst slægtsskabet imellem. Hvis du ikke kender personernes ID nummer, kan du klikke på linket <b>Finde ID</b>";
$pgv_lang["next_path_help"]				= "~#pgv_lang[next_path]#~<br /><br />Du kan klikke på denne knap for at se om der findes en anden sti mellem de to personer. De andre stier kan vises igen ved at klikke på linket med stinummeret.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Når denne boks <b>ikke</b> er afmærket, bliver slægtsrelationer kun checket mellem dem, der er i familie med hinanden. Hvis boksen er afmærket, vil også slægtsrelationer mellem gifte blive kontrolleret.  Du vil sandsynligvis finde flest relationer, hvis dette valg er afmærket.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />Når denne checkboks er mærket af, vil slægtsrelationer blive vist med ens generationer på samme vandrette linie på skærmen.  Hvis boksen ikke er afmærket, vil hver generation blive vist nedover på siden uafhængig af slægtskabet imellem f.eks. børn og forældre.";
$pgv_lang["oldest_top_help"]			= "~#pgv_lang[oldest_top]#~<br /><br />Når denne boks er mærket af, vil slægtsrelationer blive vist med de ældste personer øverst. Hvis boksen ikke er afmærket, vil den/de yngste person(er) blive vist øverst.<br /><br />NB: Dette valg er kun muligt, hvis <i>#pgv_lang[line_up_generations]#</i> er afmærket.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]# siden~<br /><br />Ancestry-siden ligner meget <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men med flere detaljer og alternativ <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> vises.<br /><br />Hver afstamning vises med et entydigt tal, beregnet i henhold til <i>Sosa-Stradonitz</i> systemet:<div style=\"padding-left: 30px;\"><b>Lige</b> tal for mænd (barn * 2)<br /><b>Ulige</b> tal for kvinder (mand + 1) undtagen <b>1</b></div><br />Eksempel:<br /><div style=\"padding-left: 30px;\">Grundpersonen er <b>1</b>, uanset køn.<br /><b>1</b> far er <b>2</b> (<b>1</b> * 2), mor er <b>3</b> (<b>2</b> + 1).<br /><b>2</b> far er <b>4</b> (<b>2</b> * 2), mor er <b>5</b> (<b>4</b> + 1).<br /><b>3</b> far er <b>6</b> (<b>3</b> * 2), mor er <b>7</b> (<b>6</b> + 1).<br /><b>7</b> far er <b>14</b> (<b>7</b> * 2), mor er <b>15</b> (<b>14</b> +1 ).<br />osv.</div>";
$pgv_lang["box_width_help"]				= "~#pgv_lang[ancestry_chart]#: Boksbredde~</b><br /><br />Her kan du ændre bredden på boksen fra 50% til 300%. Standardværdi er 100%: Bredden på hver boks er da omtrent 270 pixels.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />To diagramstile er tilgængelige:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Vertikal træ med mulighed for at skjule / vise (udvide) familier.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;En familie pr. side, med forældre, bedsteforældre og alle registrerede børn.<br /><br />Dette slægtstræ giver pæne udskrifter, som man kan forære til slægtninge/interesserede.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]# siden~<br /><br />Cirkeldiagrammet ligner meget <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men på en mere grafisk måde.<br /><br />Rodperson vises i midten, hans forældre på den første ring, bedsteforældre på den anden ring osv.<br /><br />Fødselsår og død er trykt under navnet, når det er kendt.<br /><br />Ved at klikke på et navn i diagrammet åbnes en linkemenu, der er specifik for den pågældende person. Fra denne menu kan du vælge at centrere diagrammet på den pågældende person eller på en af personens nære slægtninge, eller du kan hoppe til personens #pgv_lang[indi_info]# side eller et andet diagram for den pågældende person.";
$pgv_lang["fan_width_help"]				= "~#pgv_lang[fan_width]#~<br /><br />Her kan du ændre bredden af anehjulet fra 50% til 300%. Standardværdien er 100%. Bredden på billedet er da omtrent 640 pixels.";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]# styper~<br /><br />Denne indstilling styrer udseendet af diagrammet.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Halvcirkel 180&deg; hjul / vifte</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Trekvart 270&deg; hjul /vifte eller 'Englevinge'</li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Helcirkel 360&deg; hjul</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]		= "~#pgv_lang[hourglass_chart]#~<br /><br />Slægtstræet <b>Timeglasvisning</b> vil vise forfædre og efterkommere til den valgte person i samme slægtstræ.  Timeglasvisningen er en blanding af et anetræ og en efterkommeroversigt.<br /><br />Hovedpersonen er centreret på siden med efterkommere vist til venstre og forfædre til højre.  I dette slægtstræ er hvert slægtsled vist så det yngste starter til venstre og slutter med det ældste til højre.<br /><br />Hvis der er en pil nedad på skærmen under rodpersonen, klikker du på den for at vise en liste over rodpersonens nære familiemedlemmer, som du kan bruge navigere ned i diagrammet. Hvis du vælger et navn fra denne liste, indlæses diagrammet igen med den valgte person som den nye rodperson.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Dette træ ligner meget timeglasvisningen.  Den viser aner og efterkommere til den valgte startperson i det samme diagram.  Den viser også startpersonens efterkommere i det samme timeglasformat.<br /><br />Startpersonen centreres på siden med hans/hendes efterkommere listet til venstre og anerne listet til højre.  I denne visning er hver generation opstillet tværs over siden startende med den ældste og sluttende med den yngste generation.<br /><br />Hver efterkommer af startpersonen vil blive startperson for en ekstra timeglasvisning, der printes ud på den samme side.  Denne proces gentages indtil det specificerede antal af efterkommergenerationer er blevet printet.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Denne værdi bestemmer antallet af efterkommergenerationer til startpersonen, der vil blive printet ud i timeglasformat.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~Personliste~<br /><br />På denne side kan du få en liste over enkeltpersoner. Navnene vil blive vist med efternavnene først og sorteret i alfabetisk rækkefølge.<br /><br />Hvordan personlisten bliver vist afhænger af:<ul><li>Det bogstav du klikkede på i den alfabetiske række.</li><li>Du klikkede på Vis \"udvidet liste\" eller \"kun efternavn\".</li></ul>Hvis du har brug for mere hjælp vedrørende dette, kan du klikke på <b>#pgv_lang[qm]#</b> bagefter det ønskede valg.";
$pgv_lang["alpha_help"]					= "~Alfabetisk indeks~<br /><br />Ved at klikke på et bogstav i den alfabetiske række, vil du få en liste frem med navne, der starter med det bogstav du valgte.<br /><br />Som en af de sidste i rækken vil du kunne se <b>#pgv_lang[NN]#</b> Denne vil du se, hvis der er personer uden efternavn i slægtsdatabasen eller har et efternavn, der begynder med en bogstav, der ikke findes i sprogets alfabet. Ukendte efternavne registreres ofte som <b>#pgv_lang[qm]#</b>, og disse genkendes som <b>#pgv_lang[NN]#</b>. Dette vil også ske, hvis personen er ukendt.<br /><br /><b>NB:</b><br />Hvis en person har et efternavn i slægtsdatabasen, som for eksempel: <b>Nn, NN, Ukendt</b> eller <b>N.N.</b>, vil denne persons navn <b>ikke</b> blive vist ved at klikke på <b>#pgv_lang[NN]#</b>. Disse personer kan du finde under \"<b>N</b>\" eller \"<b>U</b>\" i den alfabetiske række. PhpGedView kan ikke tage højde for alle de måder et efternavn kan angives på.<br /><br />Til sidst i den alfabetiske række vil du se \"<b>ALLE</b>\". Her vil du få en liste frem med alle efternavne i slægtsdatabasen.<br /><br /><b>Manglende bogstaver?</b><br />Hvis dit alfabetiske indeks ser ud til at være ufuldstændigt med manglende bogstaver, indeholder din database ikke efternavne, der starter med det manglende bogstav.";
$pgv_lang["name_list_help"]				= "~NAVN LISTE~<br /><br />Dette felt viser enten en efternavnsliste eller en komplet navneliste. I begge tilfælde starter alle efternavne med det første bogstav, som du har klikket på i det alfabetiske indeks, medmindre du har klikket på <b>ALLE</b>.<br /><br />Uanset om du vil se en efternavnsliste eller det komplette navn -listen afhænger af status for linket <b>Springe / Vis underliste</b>.";
$pgv_lang["skip_sublist_help"]			= "~SPRINGE UNDERLISTE~<br /><br />Standardindstillingen er, at når du har klikket på et bogstav i det alfabetiske indeks, får du en underliste med efternavne. Hvis du klikker på dette link, vises alle personer med efternavne, der har det aktuelt valgte startbogstav med det samme. Derefter vises listen over personer direkte, hver gang du klikker på et nyt første bogstav på den alfabetiske liste.<br /><br />For at vende denne handling skal du klikke på linket #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Siderne med person- og familieliste kan enten omfatte eller ekskludere gifte navne. Denne mulighed kan være nyttig, når du søger efter personer eller familier, hvor du kun kender det gifte navn. Gifte navne kan kun medtages, hvis de allerede findes i databasen.<br /><br />På familielisten er denne værdi som standard at ekskludere. På personlisten indstilles standardværdien på GEDCOM-konfigurationssiden.<br /><br />Når du ændrer denne indstilling, huskes dit valg, indtil du logger af, eller din session slutter.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~Familieliste~<br /><br />På denne side kan du få en liste over familier. Navnene vil blive vist med efternavnene først og sorteret i alfabetisk rækkefølge.<br /><br />Hvordan navnelisten bliver vist afhænger af:<ul><li>Bogstavet du klikkede på i den alfabetiske række.</li><li>Du klikkede på Vis \"udvidet liste\" eller \"kun efternavn\".</li></ul>Du kan søge efter efternavnet på både ægtemanden og hustruen. Begge findes i listen.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~FAMILIEDETALJER SIDEN~<br /><br />Denne side viser dig en oversigt over den familie, du valgte på en forrige side.<br /><br />Fra top til bund vil du se boksen Personlige detaljer for manden og hans forældre, konen og hendes forældre, og børnene.<br /><br />Layoutet og indholdet af personkasserne er det samme som de kasser, du allerede kender fra stamtavlen og efterkommerne.<br /><br />Til højre for Forældrekasser kan du se en pil, hvis der findes flere forfædre i filen. Når du klikker på pilen, bevæger du dig op en generation for at vise dig en ny familieside med de tidligere forældre, der nu er opført som mand og kone.<br /><br />Til højre i navnefeltet kan du muligvis se et Zoom-ikon (forstørrelsesglas), som du kan klikke på for at afsløre flere detaljer om personen. Når du klikker på navnet, føres du til siden #pgv_lang[indi_info]#for den person.<br /><br />Også i højre side finder du en lille menu, der fører dig til sider med diagrammer eller mere Information. Nogle af disse menupunkter har også undermenuer, der vises, når din musemarkør nærmer sig det overordnede menupunkt.<br /><br />I boksen Familiegruppeoplysninger vises alle kendte fakta og oplysninger om denne familie, såsom ægteskab, multimedieobjekter og noter. I feltet Faktaoplysninger fører du dig til stedlisten ved at klikke på et sted, hvor alle andre familier og personer, der er forbundet med dette sted, vises. Ved at klikke på en dato springes til dagskalenderen, som viser alle begivenheder, der skete den dag og måned i historien. Multimedieobjekter kan klikkes på; dette åbner et nyt vindue, hvor objektet vises. Når du klikker på billedteksten, vil du se billedet på siden #pgv_lang[media_list]#. Hvis du klikker på et kildelink, vises oplysningerne om kilden på kildesiden.<br /><br />Under navnefelterne for børnene finder du <b>Føj et barn til denne familie</b> link. Ved siden af navnefelterne for børnene ser du linket <b>Familiegruppeoplysninger</b>. Hvis du har tilstrækkelige rettigheder, kan du redigere, slette og tilføje data og fakta her.<br /><br />Som med siden #pgv_lang[indi_info]#, vil du se en menu øverst til højre på siden. Indlæg i denne menu fører dig til andre sider, hvor du kan få oplysninger om denne familie eller udføre andre opgaver relateret til denne familie.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]				= "~Tilføj et barn til denne familie~<br /><br />Ved at klikke på dette link, kan du tilføje et barn til denne familie.<br /><br />At tilføje et barn er enkelt: Bare klik på linket, og udfyld felterne i det vindue, der dukker op.";
$pgv_lang["show_fam_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Oplysningerne om familien, som de er gemt i databasen, vises, når du klikker på dette link. Displayet viser rå GEDCOM-data.";
$pgv_lang["add_fam_clip_help"]			= "~TILFØJ FAMILIE TIL #pgv_lang[clip_cart]#~<br /><br />Du kan tilføje alle eller nogle af denne families oplysninger til din #pgv_lang[clip_cart]#. På den næste side kan du vælge nøjagtigt, hvor meget information du vil tilføje:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]		= "~Vis ægtepar/partnere på en tidslinie~<br /><br />Ved at klikke på dette link, vil du få siden med Tidslinien frem. Her vil alle begivenheder knyttet til ægtefællerne blive vist på en grafisk tidslinie.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~KILDELISTE SIDE~<br /><br />En liste over kilder vises på denne side.<br /><br />I modsætning til #pgv_lang[indi_info]# og familiesiderne er der intet alfabetisk indeks.<br /><br />En kilde kan være en person , en offentlig database, en institution, en internetressource osv. På grund af genealogiske kilders helt tilfældige karakter er det umuligt at finde en sorteringsrækkefølge, der i alle tilfælde er meningsfuld. PhpGedView <u>sorterer dog</u> kildens navne i alfabetisk rækkefølge.<br /><br /><b>KILDER</b><br />Uden kilder kan vi ikke oprette vores database. Der er en kilde til alle oplysninger i databasen. Kilden kan være en pårørende, en institution, en offentlig database, offentlige eller private poster, en internetressource osv.<br /><br />En kilde kan linkes til mange personer. En person kan også knyttes til mange kilder. Du kan have forskellige kilder til hver begivenhed, hvad enten det er fødselsdato, erhverv, ægteskab, børn osv.";
$pgv_lang["sourcelist_listbox_help"]	= "~Listen med kilder~<br /><br />I denne liste kan du se navnet på kilderne, som de er gemt i slægtsfilen.<br /><br />Navnene vises i alfabetisk rækkefølge. Når du klikker på en kilde i listen, vil du få en side med detaljer om kilden frem, hvor der vises en liste over personer og/eller familier, der er knyttet til denne kilde.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~KILDE DETALJER SIDE~<br /><br />Detaljerne om kilden vises på denne side. Kilder er meget vigtige for slægtsforskere og giver dig mulighed for at følge stien, som en anden forsker brugte til at finde oplysningerne.<br /><br />Du kan se oplysninger om kildens titel, forfatter, publikation og arkivet, hvor kilden er blev kigget op. På grund af de mange forskellige typer kilder kan nogle kilder have mere information end andre.<br /><br />Hvis et multimedieobjekt, såsom en scanning af et dokument, er tilsluttet kilden, kan du se objektet ved at klikke på objektet. Når du klikker på objektnavnet, vil du se objektet på siden #pgv_lang[media_list]#.<br /><br />Efter kildedetaljerne er der en liste over alle personer og familier, der er forbundet med denne kilde. Dette giver dig mulighed for at identificere alle elementer, der blev hentet fra den datakilde.<br /><br />Når administratoren har aktiveret disse funktioner, har du et eller to ekstra menuikoner på denne side:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />som viser oplysningerne i GEDCOM-format.</li><li><b>#pgv_lang[add_to_cart]#</b><br />som giver dig mulighed for at gemme disse oplysninger i din #pgv_lang[clip_cart]# til senere download og import til dit eget slægtsforskningsprogram.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~Navne knyttet til denne kilde~<br /><br />I denne tabel ser du navne på personer og/eller familier, der er koblet til kilden.<br /><br />Navnene vises i alfabetisk rækkefølge. Hvis du klikker på et navn i tabellen, vil du gå til siden med fakta om den enkelt person eller familie.";
$pgv_lang["show_source_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Ved at klikke på dette link, vil information om kilden, som den er lagret i GEDCOM-filen.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Når du klikker på dette link, kan du tilføje kildens oplysninger til din #pgv_lang[clip_cart]# til senere download og import til dit eget slægtsforskningsprogram.";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br /><br />Ved at klikke på denne valgmulighed, vil du afmærke kilden til at blive slettet fra GEDCOM.<br /><br />Hvad betyder det? Lad os antage, at du har en god grund til at fjerne denne kilde fra GEDCOM. Når du klikker på linket vil du få et lille vindue op, hvor du blir spurgt, om du er er sikker eller om du vil afbryde. Når du så fortsætter med at bruge phpGedView, vil du lægge mærke til at kilden fortsat er synlig (ikke slettet?). Den kan faktisk fortsat bruges akkurat som før...!<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Dette er <u>ikke</u> en fejl.</b> Administratoren af siden vil få en besked om, at der er foretaget en ændring af GEDCOM, og at du slettede noget. Administratoren skal godkende (eller afslå) din ændring. Først efter at administratoren har accepteret din ændring, bliver sletningen faktisk permanent. Hvis administratoren er i tvivl, vil han/hun kontakte dig.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~Stednavne~ (eller Personer fra sted)<br /><br />På denne side kan du se, hvilke personer eller familier, der er koblet til forskellige steder vist som niveauer eller en udvidet liste med alle stednavne.<br /><br />Hvis der er en forbindelse imellem en person eller familie og en begivenhed på et bestemt sted, vil programmet finde det for dig.<br /><br />Resultatet blir vist i en todelt tabel, en for personer og en for familier.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~FORMAT af placeringssekvenser~<br /><br /><b>STANDARD SEKVENS</b><br />Dette betyder, at der ikke er angivet noget stedskodningsformat i denne GEDCOM-fil, og standardformatet antages.<br /><br />Hvis der var fundet et andet format, ville det være vist mellem <b>(</b> og <b>)</b> i slutningen af linjen.";
$pgv_lang["ppp_match_one_help"]			= "~FORMAT af placeringssekvenser~<br /><br /><b>GEDCOM SEKVENS</b><br />Placeringerne antages at være kodet i det stedformat, der udtrykkeligt er angivet i GEDCOM-filen. Dette tilsidesætter standardordren.";
$pgv_lang["ppp_numfound_help"]			= "~Koblinger til stednavn fundet~<br /><br />Her vises antallet af koblinger til personer, der er fundet indtil nu. Hvis du fortsat ser listen med steder, betyder det, at du ikke har nået det laveste stedniveau endnu.<br /><br />Du kan allerede nu vælge et navn fra <b>Listen med personer/familier</b> eller du kan gå ned yderligere et stedniveau ned ved at klikke på et andet <b>stednavn</b> i listen ovenover.";
$pgv_lang["ppp_levels_help"]			= "~Niveau for stednavne~<br /><br />Her vises den afgrænsning (niveau), der er valgt indtil nu. Tabellen, som viser steder, er egentlig en liste for de tilbageværende niveauer.<br /><br /><b>Eksempel</b>:<br /><ul><li>Standard niveauer er: #pgv_lang[default_form]#</li><li>Hvis nuværende niveau er \"#pgv_lang[top_level]#\", så vil tabellen vise alle de lande, der er repræsenteret i slægtsdatabasen.<li>Hvis det nuværende niveau viser: \"Danmark, Landsniveau (top)\", så vil tabellen vise alle byer i Danmark<li>Osv.</li></ul><br />Du kan klikke på et niveau for at gå et eller flere niveauer ned.";
$pgv_lang["ppp_placelist_help"]			= "~Stedhierarki~<br /><br />På denne liste kan du se de placeringer, der findes underordnet den aktuelle placering, du har valgt. Hvis du endnu ikke har valgt et sted, vil du se en liste over alle placeringer på øverste niveau (f.eks. Lande eller stater).<br /><br />Navnene på placeringerne på listen er klikbare; ved at klikke på en placering fungerer som et filter, bliver du ført til det næste niveau ned.";
$pgv_lang["ppp_placelist_help2"]		= "~STEDLISTE~<br /><br />På denne liste kan du se de placeringer, der er fundet til dette trin.<br /><br />Navnene på placeringerne på listen er klikbare; ved at klikke på en placering fungerer som et filter, bliver du ført til det næste niveau ned.<br /><br />Først når du er i øverste niveau, vises der ikke en navneliste. På alle underordnede niveauer får du en liste over familier og enkeltpersoner, der er knyttet til denne placering.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Ved at klikke på dette link, vil du se en liste med alle personer og familier, som begivenheder knyttet til samme sted.  Når du er kommet til enden af rækken med stedniveauer, som et sted eller en by, vil listen med person- / familienavn blive vist automatisk.";
$pgv_lang["ppp_name_list_help"]			= "~Navneliste~<br /><br />Denne tabel vil vise dig en liste over alle navne på personer og/eller familier, der er knyttet (på en eller anden måde) til dette sted.<br /><br />Navnene i tabellen kan du klikke på, og så vil føre dig til en side med oplysninger om personen eller familien. Du kan også vælge at ændre udvalget i tabellen ved at klikke på et stednavn over denne liste.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~Billeder eller andre medier~<br /><br />Denne liste viser alle Multimedie objekter (MMO), der er gemt i denne slægtsdatabase eller med et link til en Internetadresse (URL).<br /><br />For hvert MMO kan du finde en titel eller et filnavn, navn på personer eller familier, der er knyttet til objektet, og eventuelle noter.<br /><br />Ved at klikke på navnet eller direkte på billedet, så vil objektet, afhængig af formatet (eks.: *.gif, *.jpg), åbnes i den interne billedfremviser eller i din browser.<br /><br />Ved at klikke på \"Vis ...\" under navnet, så vil du få siden op med oplysninger om personen, familien eller kilden.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~Upload mediefiler~<br /><br />At uploade filer er enkelt, så her er lidt tillægsinfomation:<br /><br /><b>#pgv_lang[thumbnail]#</b><br />Disse små billeder bør have en bredde på ca. 100px. Filnavnet <u>skal</u> være det samme som originalen. Hvis dit system automatisk kan generere miniaturer, vil du se en meddelelse herom på siden Upload medie.<br /><br /><b>Upload</b><br />Filerne vil blive overført og gemt i mappen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> for de store billeder og <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> for de små billeder.<br /><br />#pgv_lang[readme_help]#</br>";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Generel information</b></a><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a><li><a href=\"#calendar_event\"><b>Begivenhed</b></a><li><a href=\"#calendar_button\"><b>Vis dag / Vis måned / Vis år knapperne</b></a><li><a href=\"#calendar_tip\"><b>Tips</b></a></li></ul><br /><a name=\"calendar_general\"></a>Mærkedage viser personer og familier, der er knyttet til en begivenhed på en bestemt dag og/eller måned eller i en bestemt tidsperiode. Kalenderen har flere avancerede funktioner til at vise dig de rette begivenheder.<dl><dt><b>Vis <a href=\"#calendar_day\">dag</a></b></dt><dd>Her vises de begivenheder, der er knyttet til en bestemt dag, uafhængig af det valgte år. Du vil se en <i>liste</i> med navne på personer eller familier, eller en tospaltet liste med personer i den første og familier i den anden.</dd><dt><b>Vis <a href=\"#calendar_month\">måned</a></b></dt><dd>Her får du en <i>kalender</i> med navn på personer og/eller familier fordelt på de enkelte dage i den valgte måned. Kalenderen bliver vist i henhold til det år, der er valgt i feltet for år. Det er kun begivenheder <i>frem til den valgte måned og år</i> der vil blive vist.<br />I kombination med valget \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" vil den give en autentisk visning, som dine forfædre ville have set den.</dd><dt><b>Vis <a href=\"#calendar_year\">år</a></b></dt><dd>Her vises de begivenheder, der er knyttet til et bestemt år, eller flere år. Du vil se en <i>liste</i> med navn på personer eller familier, eller en tospaltet liste med personer i den første og familier i den anden.</dd></dl>Valgt dag og måned bliver vist i en anden farve i menuen til kalenderen.<br /><br />De navne du finder i listen for dag eller år eller i kalenderen, kan du klikke på. Så vil du kunne se oplysninger om disse personer eller familier. Klikker du på en dato, vil du hoppe til \"Vis dag\" visning (eller år) med begivenheder knyttet til den dato du har klikket på.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~DAGS VÆLGER~<br /><br />Den øverste række i Selector-tabellen er <b>Dag</b> vælgeren. Dens betydning er indlysende: Du vælger en <u>dag</u>.<br /><br />Resultatet af at klikke på en bestemt dag afhænger af, om du er i <b>Dag</b> eller i <b>Måned</b> tilstand.<br /><dl><dt><b>Dagtilstand</b></dt><dd>I denne tilstand klikker du på en dag, skærmen opdateres, og listen for den dag vises.</dd><dt><b>Månedstilstand</b></dt><dd>Du har kalenderen for en bestemt måned på skærmen. Du klikker på en dag, og skærmen opdateres, men du vil stadig se den måned, du havde på skærmen før. Årsagen til dette er, at du stadig kan beslutte at vælge en anden måned, et år eller en begivenhed, før du enten klikker på <b>#pgv_lang[viewday]#</b> eller <b>#pgv_lang[viewmonth]#</b> knap.</dd></dl><br />I slutningen af rækken Dag vil du se et <b>Hurtigt link</b> med dagens dato. Ved at klikke på <b>Hurtigt link</b> vises listen til i dag i tilstanden <b>Dag</b>, uanset om du er i <b>Måned</b> eller i <b>Dag</b> tilstand.";
$pgv_lang["annivers_month_select_help"]	= "~MÅNED VÆLGER~<br /><br />Den midterste række i Selector-tabellen er <b>Måned</b> vælgeren. Dens betydning er indlysende: Du vælger en <u>måned</u>.<br /><br />Resultatet af at klikke på en bestemt måned afhænger af, om du er i <b>Dag</b> eller i <b>Måned</b> tilstand.<br /><dl><dt><b>Dagtilstand</b></dt><dd>I denne tilstand klikker du på en måned, skærmen opdateres, og listen for den måned vises. Alle andre valg som dag, år og begivenheder vil være uændrede.</dd><dt><b>Månedstilstand</b></dt><dd>Når du har kalenderen på skærmen og klikker på en måned i rækken <b>Måned</b>, vises kalenderen for den nye måned.</dd></dl><br />I slutningen af rækken Måned vises vil se et <b>hurtiglink</b> med dagens måned og år. Ved at klikke på <b>Hurtigt link</b> vises listen for den pågældende måned i tilstanden <b>Måned</b>, uanset om du er i <b>Måned</b> eller i <b>Dag</b> tilstand.";
$pgv_lang["annivers_year_select_help"]	= "~ÅR INPUTBOKS~<br /><br />Dette inputfelt giver dig mulighed for at ændre kalenderåret. Skriv et år i feltet og tryk på <b>Enter</b> for at ændre kalenderen til det år.<br /><br /><b>Avancerede funktioner</b> for <b>#pgv_lang[viewyear]#</b><dl><dt><b>Mere end et år</b></dt><dd>Du kan søge efter datoer inden for en række år.<br /><br />Årsintervaller er <u>inklusive</u>. Dette betyder, at datointervallet strækker sig fra 1. januar i det første år af intervallet til 31. december i det nævnte sidste år. Her er et par eksempler på årskategorier:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;for alle begivenheder fra 1992 til 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;til alle begivenheder fra 1972 til 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;for alle begivenheder fra 1610 til 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;til alle begivenheder fra 1880 til 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;til alle begivenheder fra 880 til 1105.<br /><br />For at se alle begivenhederne i et givet årti eller århundrede kan du bruge <b>#pgv_lang[qm]#</b> i stedet for de sidste cifre. For eksempel <b>197?</b>&nbsp;&nbsp;&nbsp;for alle begivenheder fra 1970 til 1979 eller <b>16??</b>&nbsp;&nbsp;&nbsp;for alle begivenheder fra 1600 til 1699.<br /><br />Valg af et interval på år ændrer kalenderen til årsvisningen.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~VIS BEGIVENHEDER OM ...~<br /><br />Følgende muligheder er tilgængelige:<br /><ul><li><b>Alle mennesker</b><br />Med denne mulighed vises alle personer og familier.</li><li><b>Seneste år (&lt; 100 år)</b><br />Med denne indstilling kan du se alle begivenheder for den valgte dag eller måned, men ingen begivenheder ældre end 100 år vises.</li><li><b>Levende mennesker</b><br />Medmindre administratoren har konfigureret PhpGedView, så levende mennesker er synlige for alle, vil denne mulighed kun være tilgængelig for dig, når du har logget ind.<br /><br />Med denne mulighed vises kun begivenheder for levende personer.</li></ul>Når du klikker på en mulighed, vises begivenhederne efter eget valg.<br /><br />Indstillingerne for dag, måned og år samt <b>dag</b> eller <b>måned</b> tilstand, forblive som de var.";
$pgv_lang["annivers_sex_help"]			= "~Vælg køn~<br /><br />Når du er logget ind (eller hvis administratoren ikke har aktiveret beskyttelse af privatliv), så vil du her få tre valgmuligheder:<ul><li>Ikonet <b>Alle</b><br />Her vil du se alle begivenheder for personer og/eller familier (standard).</li><li>Ikonet <b>Mand</b><br />Her vil kun begivenheder for personer af hankøn blive vist. I tillæg hertil vil mænd (ægtemænd) i familier blive vist med tilhørende familiebegivenheder.</li><li>Ikonet <b>Kvinde</b><br />Her vil kun begivenheder for personer af hunkøn bliv vist. I tillæg hertil vil kvinder (hustruer) i familier blive vist med tilhørende familiebegivenheder.</li></ul>Når du klikker på en af valgmulighederne, vil skærmbilledet blice opdateret, og i forhold til det valg du har foretaget.<br /><br />Andre valg, som dag, måned og år, og begivenheder og type af visning, vil ikke blive ændret.";
$pgv_lang["annivers_event_help"]		= "~Vælg begivenhed~<br /><br />Her kan du vælge om du vil se alle begivenheder for personer og familier<br />eller bare den begivenhed du vælger.<br /><br />Når du klikker på et af valgene, vil skærmbilledet blive opdateret og i forhold til det valg du har gjort.<br /><br />Andre valg, som dag, måned og år, og begivenheder og type visning vil ikke blive ændret.";
$pgv_lang["annivers_tip_help"]			= "~TIP~<br /><br />Juster datovælgeren til en hvilken som helst dato i fortiden.<br /><br />Når du klikker på en af visningsknapperne, vil du se en liste eller kalender for den dato. Alle aldre, jubilæer osv. Er blevet genberegnet og tæller nu fra den dato, du har angivet i datovælgeren. Du ser nu den kalender eller liste, som din forfader ville have set på den dato for mange år siden.";
$pgv_lang["day_month_help"]				= "~VIS DAG / VIS MÅNED / VIS ÅR KNAPPER~<br /><br /><ul><li>Knappen <b>Vis dag</b> viser begivenhederne for den valgte dato på en liste. Alle år scannes, så kun dag og måned kan indstilles her. Ændring af året har ingen effekt. Du kan reducere listen ved at vælge indstillingen <b>Seneste år</b> eller <b>Levende mennesker</b>.<br /><br />Alder på listen beregnes fra det aktuelle år.</li><li>Knappen <b>Vis måned</b> viser et kalenderdiagram over den valgte måned og år. Også her kan du reducere listerne ved at vælge indstillingen <b>Seneste år</b> eller <b>Levende mennesker</b>.<br /><br />Du får et realistisk indtryk af, hvad en kalender på muren til dine forfædre så ud ved at vælge et år i fortiden i kombination med <b>Seneste år</b>. Alle aldre i kalenderen vises i forhold til året i feltet År.</li><li>Knappen <b>Vis år</b> viser dig en liste over begivenheder for det valgte år. Også her kan du reducere listen ved at vælge indstillingen <b>Seneste år</b> eller <b>Levende mennesker</b>.<br /><br />Du kan vise begivenheder i en række år. Indtast bare begyndelses- og slutår af intervallet med et bindestreg <b>-</b> imellem dem. Eksempler:<br /><b>1992-4</b> for alle begivenheder fra 1992 til 1994<br /><b>1976-1984</b> til alle begivenheder fra 1976 til 1984<br /><br />For at se alle begivenhederne i et givet årti eller århundrede kan du bruge <b>#pgv_lang[qm]#</b> i stedet for de sidste cifre. For eksempel <b>197?</b> for alle begivenheder fra 1970 til 1979 eller <b>16??</b> for alle begivenheder fra 1600 til 1699.</li></ul>Når du vil <b>ændre året</b>, skal du trykke på en af disse tre knapper. Alle andre indstillinger forbliver som de var.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />#pgv_lang[clip_cart]# giver dig mulighed for at tage uddrag (\"udklip\") fra dette stamtræ og samle dem i en enkelt fil til download og efterfølgende import til dit eget slægtsforskningsprogram. Den fil, der kan downloades, er optaget i GEDCOM-format.<br /><ul><li>Hvordan tager man udklip?<br />Dette er virkelig simpelt. Når du ser et klikbart navn (person, familie eller kilde), kan du gå til siden Detaljer om det navn. Der vil du se indstillingen <b>#pgv_lang[add_to_cart]#</b>. Når du klikker på dette link, vil du blive tilbudt flere muligheder for at downloade.</li><li>Hvordan downloades?<br />Når du har varer i din kurv, kan du downloade dem bare ved at klikke på linket <b>Download nu</b>. Følg instruktionerne og linkene.</li></ul>";
$pgv_lang["clip_download_help"]			= "~#pgv_lang[download_now]#~<br /><br />Ved at klikke på dette link, vil du få en ny side op, hvor du får at vide, hvordan du downloader filen. Hvis der er flere valgmuligheder mht. hvad du kan downloade, vil de blive vist på denne side.<br /><br />Følg bare de viste instruktioner.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Når du klikker på dette link, tømmes din #pgv_lang[clip_cart]#.<br /><br />Hvis du ikke ønsker at fjerne alle personer, familier osv. Fra #pgv_lang[clip_cart]#, skal du kan fjerne emner individuelt ved at klikke på linket <b>Fjern </b> i boksen Navn. Der er <u>ingen</u> bekræftelsesdialog, når du klikker på et af disse links; den anmodede sletning finder sted med det samme.";
$pgv_lang["add_by_id_help"]				= "~UDKLIPSHOLDER TILFØJ AF ID~<br /><br />Dette indtastningsfelt giver dig mulighed for at indtaste en persons ID-nummer, så han kan føjes til udklipsholderen. Når du er tilføjet, vil du blive tilbudt muligheder for at linke personens forhold til din udklipskurv.<br /><br />Hvis du ikke kender en persons ID-nummer, kan du udføre en søgning efter navn ved at trykke på ikonet Person ud for knappen Tilføj.";
$pgv_lang["zip_help"]					= "~ZIP KLIPPER~<br /><br />Vælg denne indstilling for at gemme dine udklip i en ZIP-fil. For mere information om ZIP-filer, besøg <a href=\"https://da.wikipedia.org/wiki/Zip_(filformat)\" target=\"_blank\">https://da.wikipedia.org/wiki/Zip_(filformat)</a>.";
$pgv_lang["include_media_help"]			= "~INKLUDER MEDIER~<br /><br />Vælg denne indstilling for at medtage de mediefiler, der er knyttet til posterne, i din Udklipsholder. Hvis du vælger denne indstilling, zipes filerne automatisk under download.";
$pgv_lang["clip_cart_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Denne boks viser indholdet af din udklipsholder.<ul><li>Kolonnen <i>Typer</i> angiver typen for hver post, som kan være Person (INDI), Familie (FAM), Kilde (SOUR), Repository (REPO), Note (NOTE) og Media (OBJE) ; hver er repræsenteret med sit eget ikon.</li><li>Kolonnen <i>ID</i> viser ID-nummeret for hvert element af den pågældende type.</li><li>Kolonnen <i>Navn / Beskrivelse</i> giver enten navnet på familien eller personen eller en beskrivelse af varen.</li></ul>Fjern-knappen fjerner posten fra udklippsholder. <b>Der kræves IKKE bekræftelse for at fjerne.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~#pgv_lang[review_changes]#~<br /><br />Når du ser denne besked, kan det betyde to ting:<ol><li>Nogen har foretaget en ændring i databaseb (GEDCOM-filen)<br />Poster kan være tilføjet, slettet eller ændret.</li><li>Ændringerne er ikke blevet godkendt af administratoren endnu.<br />Når ændringerne er blevet godkendt (eller afslået), vil du ikke se denne besked længere.</li></ol>Ved at klikke på linket, kan du se, hvilke ændringer, der er foretaget.<br />Hvis du mener, at en ændring ikke er korrekt, giv da venligst besked til admin.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~SØGESIDEN~<br /><br />Selvom denne side ser meget enkel ud, er der en meget kraftig og kompliceret søgemaskine bag de to former. De fleste slægtsforskningswebsteder lader dig bare søge efter et navn. PhpGedView giver dig mulighed for at søge efter næsten alt.<br /><br />Søgefeltet til venstre på skærmen er det samme som søgefeltet i hver sideoverskrift.<br /><br />Hvis du leder efter mennesker i forbindelse med et bestemt år, skriv bare året. Programmet finder alle forbindelser til dig.<br /><br />Leder du efter et navn eller sted? Indtast bare navnet eller stedet, helt eller bare en del af det, og PhpGedView gør resten.<br /><br /><b>Soundex søgemetode</b><br />Med søgefelterne til højre kan du søge på navne på personer og steder, selvom du ikke ved præcist, hvordan man skriver navnet.<br /><br />Når der er flere slægtsdatabaser på et sted og administratoren har aktiveret skift mellem dem, din søgning returnerer resultaterne for dem alle.<br /><br />Du finder mere hjælp om disse to felter ved at klikke på <b>#pgv_lang[qm]#</b> over boksene.";
$pgv_lang["search_enter_terms_help"]	= "~#pgv_lang[enter_terms]#~<br /><br />I dette søgefelt kan du indtaste kriterier som datoer, fornavne, efternavne, steder, multimedier osv.<br /><br /><b>Jokertegn</b><br />Jokertegn, som du sandsynligvis kender dem (som * eller ?), er ikke tilladt, men programmet antager automatisk jokertegn.<br /><br />Antag at du skriver i søgefeltet følgende: <b>Pete</b>. Resultatet kan være, forudsat at navnene er i databasen:<div style=\"padding-left: 30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />nogen - Født den 1. januar 1901 i <b>Pete</b>rsburg<br />osv.</div><br /><b>Datoer</b><br />At skrive et år i søgefeltet vil resultere i en liste over personer, der på en eller anden måde er forbundet med det år.<br /><br />Hvis du skriver <b>1950</b>, bliver resultatet alle personer med en begivenhed, der fandt sted i 1950. Disse begivenheder kunne være fødsler, dødsfald, ægteskaber, bar mitzwaer, SLD forseglinger osv.<br /><br />Hvis du skriver <b>4&nbsp;Dec</b>, vises alle personer, der er forbundet med en begivenhed, der fandt sted den 4 december uanset år. Personer, der er knyttet til en begivenhed den 14 eller 24 december, vises også. Som du ser, antages wildcards altid, så du behøver ikke at skrive dem. Nogle gange kan resultaterne være overraskende.<br /><br /><b>Korrekte datoer</b><br />PhpGedView søger efter data, da de er gemt i GEDCOM-filen. Hvis du f.eks. Vil søge efter en begivenhed den 14. december, skal du skrive <b>14&nbsp;dec</b>, fordi det er sådan, datoen gemmes i databasen.<br /><br />Hvis du skriver <b>dec&nbsp;14</b>, kan resultatet være en person, der er forbundet til en begivenhed den 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>. Igen kan resultaterne være overraskende.<br /><br />Du kan bruge regulære udtryk i din søgning, hvis du er fortrolig med dem. Hvis du f.eks. vil finde alle de mennesker, der har datoer i det 20. århundrede, kan du gå ind i søgningen <b>19[0-9][0-9]</b> og du vil få alt det mennesker med datoer fra 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Hvis du har brug for mere hjælp til dette søgesystem, så lad os det vide, så vi også kan udvide denne hjælpefil.";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Her kan du søge efter stavefejl eller andre unøjagtige oplysninger og erstatte dem med korrekte oplysninger.<br /><br /><b>Søger</b><br />Denne funktion udfører søgning ligesom en <a href=\"help_text.php?help=search_enter_terms_help\">normal search</a>.<br /><br /><b>Udskiftning</b><br />Alle forekomster af søgeudtrykket, der findes, erstattes af erstatningstermet i databasen.<br /><br /><b>For eksempel...</b><br />Antag, at du ved en fejltagelse stavede din oldefar Michaels navn forkert. Du indtastet ved et uheld 'Micheal'.<br /><br />Du skriver <b>Micheal</b> i søgefeltet og <b>Michael</b> i feltet Erstat.<br />Hver forekomst af \"Micheal\" erstattes derefter af \"Michael\"<br /><br /><b>Søge efter...</b><br />Vælg søgningens omfang. Du kan begrænse søgningen til navne eller steder eller ikke anvende nogen grænse (søg i alt).Indstillingen <i>#pgv_lang[search_place_word]#</i> søger kun efter dit udtryk i stedfeltet som et helt ord. Det betyder, at søgning efter <i>UT</i> kun ville matche <b>UT</b> og ikke <i>UT</i> i de andre ord, såsom Connectic<b>ut</b>.<br /><br />Bare rolig, hvis du ved et uheld udskifter noget, hvor du ikke vil. Klik på linket \"Accepter / Afvis Ændringer\" nederst på siden for at acceptere de ønskede ændringer, og afvis de ændringer, du ikke ønsker.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex er en metode til kodning af ord i henhold til deres udtale. Dette giver dig mulighed for at søge i databasen efter navne og steder, når du ikke ved præcist, hvordan de er skrevet. PhpGedView understøtter to forskellige Soundex-algoritmer, der giver meget forskellige resultater.<ul><li><b>#pgv_lang[search_russell]#</b><br />Denne metode, patenteret i 1918 af Russell, er meget enkel og kan udføres manuelt.<br /><br />Den enkle algoritme er ikke velegnet til navne, der oprindeligt var på andre sprog end engelsk og endda med engelske navne, resultaterne er meget overraskende. For eksempel returnerer en enkle Soundex-søgning efter <b>Smith</b> ikke kun <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, som alle klart er variationer af <b>Smith</b>, men også <b>Smead, Sneed, Smoote, Sammett, Shand,</b> og <b>Snoddy</b></li><br /><li><b>#pgv_lang[search_DM]#</b><br />Denne metode, der blev udviklet i 1985, er meget mere kompleks end den enkle metode og gøres ikke let i hånden.<br /><br />En Soundex-søgning ved hjælp af denne metode giver meget mere nøjagtige resultater.</li></ul>For detaljer om begge Soundex-algoritmer, besøg dette <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> hjemmeside.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />Valget <b>#pgv_lang[search_tagfon]#</b> får søgefunktionen til at ignorere følgende GEDCOM-tags:<div style=\"padding-left: 30px;\"><b>_PGVU</b> - Sidste ændring af<br /><b>CHAN</b> - Sidste ændringsdato<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Ud over disse valgfrit ekskluderede tags udelukker søgefunktionen altid disse tags:<div style=\"padding-left: 30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Denne mulighed får PhpGedView til at vise alle personer, der registreres som en tilknytning til denne person eller familie. Det omvendte er ikke mulig.<br /><br />Eksempel: Antag at person <b>A</b> er fader til person <b>B</b>. Dette forhold registreres i GEDCOM-registreringen af person <b>B</b> ved hjælp af et tag ASSO. Der findes ikke noget tilsvarende tag i person <b>A</b> i GEDCOM-registreringen.<br /><br />Når denne indstilling er sat til <b>#pgv_lang[yes]#</b>, og søgeresultatlisten inkluderer <b>B</b>, medtages <b>A</b> automatisk på grund af tagget ASSO i GEDCOM-posten på <b>B</b>. Men hvis søgeresultatlisten indeholder <b>A</b>, medtages <b>B</b> ikke automatisk, da der ikke er noget matchende tagget ASSO i GEDCOM-registreringen af person <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Denne funktion giver dig mulighed for at søge i de angivne felter af personposter i din genealogiske database.<br /><br />Når du klikker på knappen <b>#pgv_lang[search]#</b>, er alle felter, som værdier blev indtastet for, vil blive undersøgt, og optegnelser i din genealogiske database, der opfylder <u>alle</u> kriterierne, vil blive returneret. Mens den indledende dialog tilbyder nogle af de mere almindelige felter, kan du nederst i dialogen klikke på <b>#pgv_lang[more_fields]#</b> for at udvide listen over felter, der skal undersøges.<br /><br />~Felter, der indeholder Datoer~<br />Avancerede søgninger er baseret på årstal, så i modsætning til «#pgv_lang[search_general]#» proceduren, der kan acceptere en dato uden et årstal, kræver alle disse felter mindst året, men kan også acceptere specifikationer for hele dagen, måneden og året. Det er f.eks. ikke muligt at søge efter noget, der skete i april noget år.<br /><br />Hver søgedatofeltboks har også en modifikator, så du kan søge efter <b>#pgv_lang[exact]#</b> datoen som indtastet, eller en relativ dato med <b>+/-</b> en antal år. Hvis du indtaster et år i datofeltet, vælger en modifikator og klikker på knappen <b>#pgv_lang[search]#</b>, vil det resultere i en liste over personer, der er knyttet til det pågældende år eller årstal.<br /><br />Hvis du for eksempel skriver «APR 1950» i fødselsdatofeltet, der har <b>#pgv_lang[exact]#</b> modifikator, vil resultatet være alle personer med en begivenhed, der først fandt sted i april 1950. Hvert datofelt vil søge efter de datoer, der er specifikke for den pågældende begivenhed. Tilføjelse af en <b>+/- 10</b> modifikator ville returnere datoer mellem 1. april 1940 og 31. marts 1960. De andre modifikatorer ville på samme måde ændre søgeårsintervallerne. Ved blot at indtaste et år, for eksempel «1950», vil søgningen returnere alle begivenheder inden for det angivne år.<br /><br /><b>Datoformat for søgninger</b><br />Hverken jokertegn eller regulære udtryk kan bruges i dine søgedatofelter. Rækkefølgen af dag, måned, år og store bogstaver er irrelevante. «dd MMM åååå» har samme betydning som «åååå MMM dd». Men hvis du ønsker at søge efter en begivenhed den 14. december 1926, skal du skrive den som «14 DEC 1926», fordi det er sådan datoen er gemt i databasen. For at søge efter en dato på tværs af flere begivenheder (dvs. fødsler, dødsfald, ægteskaber, bar Mitzvahs, LDS-forseglinger osv.), eller hvis kun dagen eller måneden er kendt, er det bedre at bruge «#pgv_lang[search_general]#» funktionen.<br /><br />~Felter, der indeholder navne~<br />Felterne <b>#pgv_lang[given_name]#</b> og <b>#pgv_lang[surname]#</b> kan bruges til at angive de forskellige dele af et navn, der skal søges i. Dette filtrerer nemt navne, der kan være både fornavne eller efternavne, for eksempel «Terry» eller «Henry».<br /><br />Navnefelterne har også en modifikator, der hjælper med at kvalificere det indtastede kontra det, der søges efter. Modifikatorerne inkluderer:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;angiver en søgning, der skelner mellem store og små bogstaver, i det fulde felt efter den nøjagtige indtastede tekst. Søgningen er også følsom over for alle indlejrede tegn, mellemrum osv. Hvis f.eks. feltet indeholder et mellemrum, men posten i databasen har to på samme position, vil posten ikke blive fundet.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;angiver en søgning uden store og små bogstaver efter poster, hvor ethvert navn begynder med det, der er i feltet. Hvis et navnefelt indeholder flere navne (såsom for- og mellemnavne), vil matchningen blive udført med begyndelsen af hver del af navnet, der er adskilt af et mellemrum.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;angiver en søgning uden store og små bogstaver efter poster, hvor alle de indtastede data i feltet vil blive søgt efter hvor som helst i målpostens navnetekst. Hvis du f.eks. indsætter et enkelt mellemrum i <b>#pgv_lang[given_name]#</b> søgefeltet med <b>#pgv_lang[contains]#</b> modifikatoren, finder du alle poster, der skal have et fornavn og mindst ét mellemnavn eller initial.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;specificerer en søgning uden store og små bogstaver efter poster, der ligner det, der er i feltet. Dette giver dig mulighed for at søge i databasen efter navne og steder, når du ikke ved præcis, hvordan de er skrevet.</li></ul><br />~Felter uden modifikatorer~<br />Indtastninger i felter uden modifikatorer er søgninger, der ikke skelner mellem store og små bogstaver. Den indtastede tekst vil blive søgt efter hvor som helst i målpostens begivenhedstekst.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# SIDE~<br /><br />Alle detaljer om en person vises på denne side.<br /><br />Hvis der er et billede tilgængeligt, kan du se det øverst til venstre. Du vil se navnene på personen ved siden af billedet.<br /><br />Navne kan være knyttet til noter og kilder. Hvis nogle af navnene har noter eller kilder, vil du se dem opført under de navne.<br /><br />En person kan have en AKA (måske er han kendt under et andet navn). Hvis det er tilfældet, vises det.<br /><br />Hvis du har redigeringsrettigheder til denne person, vil du også se <b>Rediger</b> og <b>Slet</b> links ved siden af de emner, du kan redigere.<br /><br />På denne side kan du se faneark til <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, og <b>#pgv_lang[relatives]#</b>.  Disse faneark viser dig alle de oplysninger om denne person, der er gemt i databasen.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;viser dig fakta og detaljer om denne person og enhver kendsgerning fra deres ægteskaber. Hvis du klikker på en vilkårlig dato på denne fane, kommer du til #pgv_lang[anniversary_calendar]# for den dato, så du kan se andre begivenheder, der skete den samme dag. Klik på et sted fører dig til stedhierarkiet, hvor du kan se andre mennesker, der havde begivenheder på samme sted. For ægteskab og andre familierelaterede fakta er navnet på personens ægtefælle tilgængelig, så du kan se ægtefællen, og fanen <b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;viser dig alle <u>generelle</u> kilder til denne person. Disse kilder er <u>ikke</u> knyttet til individuelle fakta, ikke engang personens navn; de er forbundet med personen selv. Hvis du klikker på titlen på en kilde, kommer du til en mere detaljeret kilde, og der findes også et link til familierekord.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;viser dig generelle noter, der vedrører denne person.</li><li>Informationssiden, der viser andre mennesker, der også er linket til den samme kilde.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;viser alle de billeder og andre medieemner, der er knyttet til denne person. Ved at klikke på en miniaturebillede af billedet åbnes en større visning af billedet. Ved at klikke på billedteksten vises billedet på #pgv_lang[media_list]# siden.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;viser denne persons forældre og søskende samt alle ægtefæller og børn, som denne person har haft. Disse personer vil blive opført i felter svarende til de diagrammer, som du måske allerede har set.</li></ul>Til højre på skærmen finder du et felt med links. Mange af linkene i feltet er de samme som linkene i menuerne. For eksempel, klik på linket <b>#pgv_lang[pedigree_chart]#</b> på sidelinks fører dig til stamtavle for denne person. Dette adskiller sig fra menulinkene, fordi at klikke på linket <b>#pgv_lang[pedigree_chart]#</b> i menuen fører dig tilbage til standardstamtavlen for denne database.<br /><br />Et af de links, der muligvis vises på denne liste, hvis det er blevet aktiveret af administratoren, er linket <b>#pgv_lang[view_gedcom]#</b>. Dette link viser dig den rå GEDCOM-post for denne person.<br /><br />Hvis #pgv_lang[clip_cart]# er aktiveret af webstedsadministratoren, har du også et link, der giver dig mulighed for at tilføje denne person til din #pgv_lang[clip_cart]#.<br /><br />Linket <b>#pgv_lang[relationship_to_me]#</b> vises kun, hvis du er logget ind og har fået tildelt et ID i GEDCOM. Dette link fører dig til stamtavlen og viser dig, hvordan du er relateret til denne person.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Ved at klikke på denne valgmulighed vil du sætte et MÆRKE ved denne PERSON mht. at blive slettet fra slægtsdatabasen.<br /><br />Hvad betyder det? Forestil dig, at du har en god grund til at fjerne denne person fra slægtsdatabasen. Du klikker på linket, og herefter vil du få et nyt vindue op, hvor du blir bedt om at bekræfte sletningen eller ønsker at afbryde. Hvis du checker om personen er slettet ved at prøve at vise personen pånyt, vil du se at personen stadig er synlig, som før sletningen.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~rediger eller slet navn fra GEDCOM~<br /><br /><b>REDIGER NAVN</b><br />Når du klikker på dette link, åbnes et andet vindue. Der kan du redigere navnet på personen. Skriv bare ændringerne i felterne, og klik på knappen, luk vinduet, og det er det.<br /><br /><b>SLET NAVN</b><br />Ved at klikke på denne mulighed markerer du dette navn, der skal slettes fra databasen. Bemærk, at sletning af navnet er helt anderledes end at slette personen. Sletning af navnet fjerner bare navnet fra personen. Personen slettes <u>ikke</u>. Hvis det er en AKA, som du vil slette, har personen stadig sine andre navne. Hvis det er det <u>eneste</u> navn, du vil fjerne, vil personen stadig ikke blive slettet, men vil nu blive registreret som <b>#pgv_lang[NN]#</b>. Personen vil heller ikke blive afbrudt fra andre til slægtninge, kilder, noter osv.<br /><br />Hvordan virker det? Du bliver bedt om at bekræfte din sletningsanmodning. Når du fortsætter med dit besøg, vil du bemærke, at navnet stadig er synligt og kan være brugt som om sletningen ikke havde fundet sted.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~Tilføj et nyt navn~<br /><br />Denne valgmulighed giver dig mulighed for at tilføje et nyt navn til denne person.  Nogle gange hænder det, at personer er bedre kendt under et andet navn og/eller et alias'.  Denne valgmulighed betyder, at du kan give en person et nyt navn uden at ændre det gamle og egentlige navn.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Ved at klikke på dette link, kan du tilføje et barn til denne familie. \"Denne familie\", er i dette tilfælde, faren og moren til hovedpersonen på denne side.<br /><br />Så, vær opmærksom på, at du tilføjer en bror eller søster til denne person. At tilføje en bror eller søster er enkelt: Bare klik på linket, og udfyld navnet i vinduet.<br /><br />Hvis du skal tilføje en søn eller datter til hovedpersonen, scroll lidt ned på skærmen og klik på linket i \"Familie med ægtemand/hustru\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Ved at klikke på dette link, kan du tilføje et barn til denne familie. \"Denne familie\", er i dette tilfælde, hovedpersonen på denne side og hans/hendes forældre.<br /><br />Så, vær opmærksom på, at du tilføjer en søn eller datter til denne person. At tilføje en søn eller datter er let: Bare klik på linket, og udfyld navnet i vinduet.<br /><br />Hvis du skal tilføje en bror eller søster  til hovedpersonen, scroll lidt ned på skærmen og klik på linket i \"Familie med forældre\".";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Ved at klikke på på dette link, kan du knytte denne person som et barn i en eksisterende familie.<br /><br />Forestil dig, at forældrene til personen var ukendte, og du fandt ud af at de (forældrene) har en post i denne slægtsbasen.<br /><br />Ved kun at klikke på linket, angive ID for familien (hvis du ikke kender ID, kan du søge efter det), og du har fuldført koblingen.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Dette valg giver dig mulighed for at knytte personen til en eksisterende familie som en ny ægtemand. Familien vil nå få koblet denne person som familiefar hvor det tidligere blev vist som Ukendt. Alle registerede begivenheder, information om ægteskabet og børn vil forblive uændret.<br /><br />Klik bare på linket, indtast familiens id, og du har konkurreret med opgaven. Dette er et avanceret ændringsvalg, som kun bør anvendes, hvis familien du ønsker at lave en kobling til, allerede eksisterer.  Hvis du kun ønsker at tilføje en ny familie, bruger du valgmuligheden Tilføj en ny hustru.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Ved at klikke på dette link, kan du tilføje en \"Ny\" (hankøn) person og knytte denne person til hovedpersonen som en ny ægtefælle/partner.<br /><br />Bare klikk på linken, så vil du få et vindue op for at tilføje den nye person.<br /><br />Udfyld så mange felter som muligt og klik på knappen \"Gem\".";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Dette vil give dig tilladelse til at knytte en anden person, der allerede findes, som ny ægtemand til denne person.  Det vil oprette en ny familie med den ægtemand du vælger.  Du vil også have mulighed for at specificere en vielse for denne nye familie.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Ved at klikke på dette link kan du føje et <u>nyt</u> barn til denne person og oprette en familie med en forælder.<br /><br />Klik bare på linket, så får du et pop op-vindue for at tilføje den nye person. Udfyld så mange felter, som du kan, og klik på knappen <b>Gem</b>.";
$pgv_lang["link_wife_help"]				= "~#pgv_lang[link_as_wife]#~<br /><br />Dette valg gør det muligt at knytte denne person som en hustru / partner til en familie som allerede findes i slægtsbasen.<br /><br />Dette er et avanceret valg, som kun bør anvendes, hvis den familie, du ønsker at lave en kobling til, findes.  Hvis du kun ønsker at tilføje en ny familie, må du bruge valgmuligheden Tilføj en ny ægtemand.";
$pgv_lang["add_wife_help"]				= "~#pgv_lang[add_new_wife]#~<br /><br />Ved at klikke på dette link, kan du tilføje en \"Ny\" (hunkøn) person og knytte denne person til hovedpersonen som en ny ægtefælle/partner.<br /><br />Bare klik på linket, så vil du få et vindue op for at tilføje den nye person. Udfyld så mange felter som muligt og klik på knappen \"Gem\".";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Dette vil give dig tilladelse til at knytte en anden person, der allerede findes i databasen, som en ny hustru til denne person.  Der vil blive oprettet en ny familie med den valgte hustru.  Du har også muligheden for at specificere vielsen for den nye familie.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~Tilføj en ny far eller mor~<br /><br />Det er selvsagt mange personer i slægtsdatabasen som ikke er registrert med sin far og/eller mor.<br /><br />Hvis du ønsker at tilføje en af disse kan du gøre dette på siden <b>#pgv_lang[indi_info]#</b>, fanebladet <b>#pgv_lang[relatives]#</b>, tabellen <b>#pgv_lang[as_child]#</b>, vil du finde linken til at tilføje en <b>ny</b> far og/eller mor til personen.<br /><br />Vær opmærksom på at disse links er for at tilføje en <b>ny</b> far og/eller mor. Hvis faren eller moren findes fra før i slægtsbasen, så må du anvende linket <b>#pgv_lang[link_as_child]#</b>, som du også finder på denne side under den nederste tabel.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Når denne indstilling er markeret, kan du se alle kilde- eller noteoptegnelser for denne person. Når denne indstilling ikke er markeret, vises ikke kilde- eller noteoptegnelser, der er knyttet til andre fakta for denne person.";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br /><br />Når dette valgfelt er markeret, viser fanen «#pgv_lang[relatives]#» datoforskelle som følger:<ul><li><b>fødselsdatoer for partnere.</b><br />En negativ værdi angiver, at den anden partner er ældre end den første.</li><li><b>ægteskabsdato og fødselsdato for det første barn.</b><br />En negativ værdi her angiver, at barnet blev født før ægteskabsdatoen, eller at enten fødselsdatoen eller ægteskabsdatoen er forkert.</li><li><b>fødselsdatoer for søskende.</b><br />En negativ værdi her angiver, at enten børnenes rækkefølge er forkert, eller at en af fødselsdatoerne er forkert.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~Tilføj nye fakta~<br /><br />Her kan du tilføje fakta for en eller flere personer.<br /><br />Vælg først en faktaoplysning fra listen, og klik så på knappen <b>\"Tilføj\"</b>. I listen finder du alle tilgængelige faktaoplysninger for slægtsdatabasen.";
$pgv_lang["add_custom_facts_help"]		= "~Tilføj egne fakta~<br /><br />Hvis du ikke finder den type faktaoplysning, du ønsker at tilføje i faktalisten, kan du selv tilføje <b>Egne fakta</b> til listen.<br /><br />Forskellen på at tilføje fra en forhåndsdefineret faktaoplysning er, at du må give den nye faktaoplysning et navn. Det gør du i det øverste felt: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~Tilføj ny note~<br /><br />Hvis du har en note/forklaring, som du ønsker at føje til denne person, så er det her du gør det.<br /><br />Klik på linket, og et vindue vil dukke op, hvor du kan skrive din note. Når du er færdig, klikker du bare på knappen \"Gem\" og lukker vinduet.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Når du klikker på linket <b>#pgv_lang[add_shared_note]#</b>, åbnes et nyt vindue. Du kan vælge at linke til en eksisterende delt note, eller du kan oprette en ny delt note og samtidig oprette et link til den.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~TILFØJ NY KILDEHENVISNING~<br /><br />Her kan du tilføje en kilde <b>Citat</b> til denne post.<br /><br />Klik blot på linket, et vindue åbnes, og du kan vælge kilden fra listen (Finde ID) eller Opret en ny kilde og tilføj derefter citatet.<br /><br />Tilføjelse af kilder er en vigtig del af slægtsforskning, fordi det giver andre forskere mulighed for at kontrollere, hvor du har fået dine oplysninger.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br /><br />Tilføjelse af multimediefiler (MM) til GEDCOM er en meget flot funktion. Selvom dette program allerede har et godt udseende uden medier, hvis du tilføjer billeder eller anden MM til dine slægtninge, bliver det kun bedre.<br /><br /><b>Hvad du skal forstå om MM.</b><br />Der er mange formater af MM. Selvom PhpGedView kan håndtere de fleste af dem, er der nogle ting at overveje.<br /><ul><li><b>Formater</b><br />Billeder kan redigeres og gemmes i mange formater. F.eks.  .jpg, .png, .bmp, .gif osv. Hvis det samme originale billede blev brugt til at oprette hvert af formaterne, ser det viste billede ud til at have samme størrelse, uanset hvilket format der bruges. Imidlertid vil billedfilerne, der er gemt i databasen, variere betydeligt i størrelse. Generelt betragtes .jpg billeder som de mest effektive med hensyn til lagerplads.</li><li><b>Billedestørrelse</b><br />Jo større det originale billede er, desto større bliver den resulterende fils størrelse. Billedet skal passe på skærmen uden at rulle; den maksimale bredde eller højde bør ikke være mere end skærmens bredde eller højde. PhpGedView er designet til skærme på 1024x768 pixels, men ikke alt dette rum er tilgængeligt til visning af billeder; billedets størrelse skal indstilles i overensstemmelse hermed. For at reducere filstørrelser er mindre billeder mere ønskelige.</li><li><b>Opløsning</b><br />Opløsning af et billede måles normalt i \"dpi\" (prikker / tomme), men dette gælder kun for trykte billeder. Når man overvejer billeder, der vises på skærmen, er den eneste korrekte måde at bruge samlede prikker eller pixels. Når det udskrives, kan billedet have en opløsning på 150 - 300 dpi eller mere afhængigt af printeren. Skærmopløsninger er sjældent bedre end 50 pixels per tomme. Hvis dit billede aldrig bliver udskrevet, kan du sikkert sænke dets opløsning (og dermed dets filstørrelse) uden at påvirke billedkvaliteten. Hvis et lavopløsningsbillede udskrives med for stor forstørrelse, vil dets kvalitet blive dårligere; det vil have et kornet udseende.</li><li><b>Farvedybde</b><br />En anden måde at holde en fil lille på er at mindske antallet af farver, du bruger. Antallet af farver kan variere fra ren sort og hvid (to farver) til ægte farver (millioner af farver) og alt imellem. Du kan se, at jo flere farver der bruges, jo større er filernes størrelse.</li></ul><br /><b>Hvorfor er det vigtigt at holde filstørrelsen lille?</b><ul><li>Først og fremmest: Dit webområde er begrænset. Jo flere store filer der er, jo mere webplads har vi brug for på serveren. Jo mere plads vi har brug for, jo højere bliver dine omkostninger.</li><li>Båndbredde. Jo flere data vores server skal sende til den eksterne placering (din placering), jo mere skal vi betale. Dette skyldes, at bæreevnen for serverens forbindelse til internettet er begrænset, og linket skal deles (og betales for) af alle de applikationer, der kører på serveren. PhpGedView er en af mange applikationer, der deler serveren. Omkostningerne fordeles normalt i henhold til mængden af data, som hver applikation sender og modtager.</li><li>Downloadtid. Hvis du har store filer, skal brugeren (også dig) vente længe på, at siden downloades fra serveren. Ikke alle er velsignet med en kabelforbindelse, bredbånd eller DSL.</li></ul><br /><b>Sådan uploades din MM</b><br />Der er to måder at uploade medier til webstedet. Hvis du har mange medieemner at uploade, skal du kontakte webstedsadministratoren for at diskutere de bedste måder. Hvis det er blevet aktiveret af din webstedsadministrator, kan du bruge formularen Upload medie under menuen #pgv_lang[mgv]#. Du kan også bruge indstillingen Upload i multimedieformularen til at uploade medieelementer.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Denne mulighed genererer miniaturer for alle filer i den aktuelle mappe, som ikke allerede har en miniaturebillede. Dette er meget mere praktisk end at klikke på linket <b>#pgv_lang[gen_thumb]#</b> for hver sådan fil.<br /><br />Hvis du ønsker at bevare kontrollen over, hvilke filer der skal have tilsvarende miniaturer, skal du ikke bruge denne mulighed. I stedet skal du klikke på de relevante <b>#pgv_lang[gen_thumb]#</b> links.";
$pgv_lang["add_facts_general_help"]		= "~Generel info om at tilføje~<br /><br />Når du har tilføjet en oplysning, note, kilde eller multimediefil for en eller flere personer, skal disse godkendes af en bruger, der har fået de nødvendige rettigheder af administratoren af hjemmesiden.<br /><br />Indtil ændringerne er accepteret, identificeres de som \"afventende\" af en forskelligt farvet kant. Alle brugere med redigeringsrettigheder kan se disse ændringer såvel som de originale oplysninger. Brugere, der ikke har redigeringsrettigheder, kan kun se de originale oplysninger. Når tilføjelsen er accepteret, forsvinder grænserne, og de nye data vises normalt og erstatter de gamle. På det tidspunkt vil brugere uden redigeringsrettigheder også se de nye data.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	= "På denne side kan du ændre din opsætning og dine valg.<br /><br />Du kan ændre dit brugernavn, fulde navn, adgangskode, sprog, e-mail-adresse, udseende (tema) på siden, og ønsket kontaktmetode.<br /><br />Du kan imidlertid ikke ændre valget for INDI-posten ID selv.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />I dette felt kan du ændre dit brugernavn. Hvis du er blevet træt af dit brugernavn, eller har en anden grund til at ændre det, kan du gøre det ved hjælp af dette felt.<br /><br />Brugernavnet er <u>følsomt mht. bogstavtyper (case-sensitiv)</u>. Det betyder, at <b>Jon</b> ikke er det samme som <b>jon</b> eller <b>JON</b>.<br /><br />Du bør <u>kun</u> bruge tegn fra de alfabeter, som PhpGedView understøtter. Du kan bruge store og små bogstaver med eller uden diakritiske tegn, tal, bindestreg (-) og understregning (_). Brug <u>ikke</u> tegnsætningstegn eller mellemrum.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette felt kan du ændre dit fornavn.  Det er det navn, som andre brugere kan se, når du er logget ind.<br /><br />Selvom det er dit valg hvad du skriver i dette felt, så bør du informere administratoren når du ændrer det.  Når andre ser en ukendt person, der er online, undrer de sig måske og begynder at stille spørgsmål. Administratoren kan selv finde ud af det uden at have modtaget en meddelelse herom, men du bør spare ham for dette unødvendige arbejde.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette felt kan du ændre dit efternavn.  Det er det navn som andre brugere kan se, når du er logget ind.<br /><br />Selvom det er dit valg hvad du skriver i dette felt, så bør du informere administratoren når du ændrer det.  Når andre ser en ukendt person, der er online, undrer de sig måske og begynder at stille spørgsmål.  Administratoren kan selv finde ud af det uden at have modtaget en besked derom, men du bør spare ham/hende for det unødvendige arbejde.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Dette er et internt nummer (GEDCOM ID), der knytter dig til dine egne data i slægtsdatabasen.<br /><br />Du kan ikke ændre dette ID. Dette link er lagt ind af adminstratoren af hjemmesiden. Hvis du tror, at dette ID ikke er korrekt, bør du kontakte admin for at få rettet det.";
$pgv_lang["edituser_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Dette er den startende (rod) person på alle dine diagrammer.<br /><br />Hvis du f.eks. skulle klikke på linket til stamtavlen, ville du se denne rodperson i feltet til venstre. Denne rodperson behøver ikke være dig; du kan starte med en hvilken som helst person (f.eks. din bedstefar eller din mors tante), så længe du har rettighederne til at se den pågældende person.<br /><br />Denne indstilling ændrer standardrodpersonen for de fleste diagrammer. Du kan ændre den rodperson, der faktisk bruges på mange diagrammer, men det er bare for den side på det bestemte tidspunkt.";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />Det er en god praksis at ændre dit kodeord regelmæssigt. Du skal huske på, at enhver, der kender dit brugernavn og din adgangskode, har adgang til dine data.<br /><br />Gør adgangskoden mindst 6 tegn, jo længere jo bedre. Du kan bruge store og små bogstaver med eller uden diakritiske tegn, tal, bindestreg (-) og understregning (_). Brug <u>ikke</u> tegnsætningstegn eller mellemrum. Brug en kombination af store og små bogstaver, tal og andre tegn. For eksempel: <b>5Z_q\$P4=r9</b>.<br /><br />Ligesom brugernavnet er adgangskoden <u>store og små bogstaver</u>. Det betyder, at <b>Hemmeligt.Kodeord!#13</b> ikke er det samme som <b>hemmeligt.kodeord!#13</b> eller <b>HEMMELIGT.KODEORD!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Hvis du har ændret din adgangskode, må du også bekræfte det. Dette er kun for at sikre dig mod, at du ikke skrev forkert i adgangskode-feltet.<br /><br />Hvis adgangskoden og dens bekræftelse ikke er identiske, får du en passende fejlmeddelelse. Du bliver nødt til at indtaste både den originale adgangskode og dens bekræftelse.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Her kan du ændre det sprog, som PhpGedview viser alle sine sider og meddelelser på, når du er logget ind.<br /><br />Når du først åbner siden, antager PhpGedView, at du vil se alt på det sprog, der er konfigureret som det foretrukne sprog i din browser. Hvis denne antagelse er forkert, vil du tilsidesætte den her. For eksempel er din browser muligvis indstillet til engelsk, fordi det er det mest udbredte sprog på Internettet. Til genealogiske formål foretrækker du dog at se alt på finsk eller hebraisk. Her er hvor du gør det.<br /><br />Administratoren kontrollerer, hvilke sprogvalg der er tilgængelige for dig. Hvis din præference ikke er angivet, skal du kontakte administratoren.<br /><br />Husk, at PhpGedView i høj grad er et projekt, der er bemandet med et internationalt team af ubetalte frivillige. Eksperter kommer og går. Derfor er understøttelse af andre sprog end engelsk undertiden ikke så god som den burde være.<br /><br />Hvis du ser noget, der ikke er oversat, er blevet oversat forkert eller kunne formuleres bedre, så lad din administrator ved godt. Administratoren ved, hvordan man kommer i kontakt med PhpGedView-udviklerteamet for at få dine bekymringer løst. Endnu bedre, frivillig noget af din tid. Vi kan bruge hjælp.";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Din korrekte e-mail-adresse er, naturligvis, vigtig for os for at holde kontakten.<br /><br />Hvis du har fået en ny e-mail-adresse, så husk venligst at ændre adressen her også.<br />Det kan også være, at du har flere e-mail-adresser og ønsker at modtage beskeder fra os på en anden e-mail-adresse.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Dette websted kan have flere forskellige udseende eller udseende. Andre programmer kan kalde dem \"skind\", men her er de \"temaer\".<br /><br />Hvert tema viser de samme data, men dets præsentation eller endda dets placering på skærmen kan variere. Dette er som at lægge et billede i en anden blok og også hænge det i et andet rum. Billedet ændres ikke, men den måde, du ser på det, er en helt anden.<br /><br />Bare prøv det. Indstil det til et andet tema. Se på det, prøv en anden. Skift tilbage til den, der passer dig bedst. Hver gang du logger ind, vil du se det tema, du sidst brugte; du behøver ikke engang at komme til denne konfigurationsside for at ændre dit foretrukne tema.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView har flere forskellige kontaktmetoder. Administratoren bestemmer, hvilken metode der skal bruges til at kontakte ham. Du har kontrol over den metode, der skal bruges til at kontakte <u>dig</u>. Afhængig af webstedskonfiguration er nogle af de listede metoder muligvis ikke tilgængelige for dig.";
$pgv_lang["mail_option1_help"]				= "Med denne indstilling vil PhpGedView interne messaging-systemet blive brugt, og der sendes ingen e-mails.<br /><br />Du modtager kun <u>interne</u> meddelelser fra de andre brugere. Når en anden webstedsbruger sender dig en besked, vises den besked i meddelelsesblokken på din personlige #pgv_lang[mygedview]# side. Hvis du har fjernet denne blok fra din #pgv_lang[mygedview]# side, kan du ikke se nogen beskeder. De vil dog dukke op, så snart du konfigurerer siden #pgv_lang[mygedview]# til igen at have meddelelsesblokken.";
$pgv_lang["mail_option2_help"]				= "Denne mulighed er som #pgv_lang[messaging]#, med en tilføjelse. Som en ekstra vil en kopi af meddelelsen også blive sendt til den e-mail-adresse, du har konfigureret på din kontoside.<br /><br />Dette er standardkontaktmetoden.";
$pgv_lang["mail_option3_help"]				= "Med denne mulighed modtager du kun e-mail-beskeder på den adresse, du har konfigureret på din kontoside. Meddelelsessystemet, der er internt i PhpGedView, bruges slet ikke, og der vil aldrig være nogen meddelelser i meddelelsesblokken på din personlige #pgv_lang[mygedview]# side.";
$pgv_lang["mail_option4_help"]				= "Med denne mulighed modtager du ingen beskeder. Selv administratoren kan ikke nå dig.";

//-- Admin
$pgv_lang["admin_help"]						= "På denne side finder du links til konfigurationssider, administrationssider, dokumentation og logfiler.<br /><br /><b>#pgv_lang[system_time]#</b>, lige under sidetitlen, viser tidspunktet for den server, hvor dit websted er hostet. Dette betyder, at hvis serveren er placeret i New York, mens du er i Danmark, vil den viste tid være seks timer mindre end din lokale tid, medmindre serveren selvfølgelig kører på Greenwich Mean Time (GMT). Det viste tidspunkt er servertiden, hvor du åbnede eller opdaterede denne side.<br /><br /><b>ADVARSEL</b><br />Når du ser en rød advarselsmeddelelse under systemtiden, betyder det, at din <i>config.php</i> kan stadig skrives. Når du har konfigureret dit websted, skal du af <b> sikkerhed </b> sætte filens tilladelser tilbage til skrivebeskyttet. Du skal gøre dette <u>manually</u>, da PhpGedView ikke kan gøre dette for dig.";

//-- User Admin
$pgv_lang["useradmin_help"]					= "~#pgv_lang[user_admin]#~<br /><br />På denne side kan du administrere de nuværende brugere og tilføje nye brugere.<br /><br /><b>#pgv_lang[current_users]#</b><br />I denne tabel vises de aktuelle brugere, deres status og deres rettigheder. Du kan <b>slette</b> eller <b>redigere</b> brugere.<br /><br /><b>#pgv_lang[add_user]#</b><br />Denne form er næsten den samme som brugerne ser på siden <b>#pgv_lang[editowndata]#</b>.<br /><br />For flere emner lavede vi ikke særlig hjælpetekst til administratoren. I disse tilfælde vil du se følgende meddelelse:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />#pgv_lang[gedcomid]# identificerer brugeren. Det skal indstilles af administratoren.<br /><br />Dette ID bruges som ID på flere sider såsom <b>#pgv_lang[my_indi]#</b> og <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Du kan indstille brugerens GEDCOM ID separat for hver GEDCOM. Hvis en bruger ikke har en post i en GEDCOM, skal du lade feltet være tomt.";
$pgv_lang["useradmin_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />For hver genealogisk database kan du udpege en <b> rodperson </b> til brugeren. <br /> <br /> Denne rodperson behøver ikke at være brugeren selv; det kan være nogen. Brugeren vil sandsynligvis gerne starte stamtavle med sig selv. Du styrer det såvel som standardrodpersonen på andre diagrammer her.<br /><br />Hvis brugeren har redigeringsrettigheder til sin egen kontoinformation, kan han selv ændre denne indstilling.";
$pgv_lang["useradmin_can_admin_help"]	= "~#pgv_lang[can_admin]#~<br /><br />Hvis denne checkboks er afmærket, vil brugeren have de samme rettigheder i programmet, som du har, som administrator.<br /><br />Brugeren kan da:<ul><li>Tilføje / Fjerne / Ændre brugere.</li><li>Sende beskeder til alle brugere på en gang.</li><li>Ændre beskeder på velkomstsiden.</li><li>Ændre og sætte sprogfiler op.</li><li>Herudover</li><li>Opgradere programmet.</li><li>Ændre programindstillinger.</li><li>Administrere slægtsfiler.</li><li>Ændre privatlivsindstillinger.</li><li>Og andre ting, som ikke er nævnt her...</li></ul><br />Brugeren kan <u>ikke</u> ændre noget på din server uden for PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Hvis denne checkboks er afmærket og brugeren har en GEDCOM-ID tilknyttet, så vil indstillingen af brugerkontoen automatisk blive synkroniseret med GEDCOM-posten.  Det betyder, at når brugerens GEDCOM-post redigeres, vil noget af informationen såsom e-mail-adresse og navn, blive kopieret til brugerens kontoopsætning.  Når brugerens konto redigeres, så vil den tilsvarende information blive kopieret til GEDCOM-posten.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />For hver GEDCOM-fil, der er installeret, kan brugere få forskellige rettigheder mht. hvor meget de kan se og ændre data.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;Brugeren kan ikke se private oplysninger.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;Brugeren kan se private oplysninger, men kan ikke foretage ændringer.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;Brugeren kan foretage ændringer, men en anden bruger med rettigheder til at <b>#pgv_lang[accept]#</b> skal sige god for ændringerne førend de bliver føjet til slægtsfilen, sådan at alle brugere kan se ændringerne.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;Brugeren kan både ændre og godkende egne og andre brugeres ændringer.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;Brugeren får rettigheder til at ændre konfigurationen og privatlivsindstillingerne for denne slægtsdatabase.</li></ul>Systemadministratorer, der identificeres gennem feltet <b>#pgv_lang[can_admin]#</b>, får automatisk <b>#pgv_lang[admin_gedcom]#</b> privilegier.";
$pgv_lang["useradmin_verified_help"]	= "~#pgv_lang[verified]#~<br /><br /><b>Bekræftelse</b><br />Dette betyder, at en bruger har ansøgt om at få en ny brugerkonto</b>.<br /><br />Brugeren har modtaget en e-mail med et link, hvor han/hun skal bekræfte ansøgningen. Hvis brugeren har gjort dette, vil du se, at checkboksen er afmærket, og du kan fortsætte med det næste trin <b><b>#pgv_lang[verified_by_admin]#</b></b>. Hvis ansøgeren ikke har bekræftet, bør du vente med godkendelsen.<br /><br /><b>Tilføj bruger manuelt</b><br />Hvis du bruger dette skema til at tilføje en bruger manuelt, vil du se, at checkboksen allerede er afmærket.";
$pgv_lang["useradmin_verbyadmin_help"]	= "~#pgv_lang[verified_by_admin]#~<br /><br />Hvis en bruger har anvendt skemaet \"Søg om brugerkonto\" og bekræftet ansøgningen, skal du godkende brugeren førend kontoen bliver aktiveret.<br /><br />Efter at du har godkendt at brugeren får en konto, vil den nye bruger modtage en e-mail med besked om, at kontoen er aktiveret, og at brugeren nu kan logge ind ved hjælp af brugernavnet og adgangskoden, der blev angivet på siden, hvor du søgte om en konto.";
$pgv_lang["useradmin_edit_user_help"]	= "~#pgv_lang[update_user]#~<br /><br />Dette skema blveir brugt af administratoren for at ændre en brugers konto.<br /><br />Skemaet svarer til skemaerne <b>#pgv_lang[add_user]#</b> og <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]	= "~#pgv_lang[visibleonline]#~<br /><br />Dette felt styrer din synlighed over for andre brugere, mens du er online. Det styrer også din evne til at se andre onlinebrugere, der er konfigureret til at være synlige.<br /><br />Når dette felt ikke er markeret, vil du være helt usynlig for andre, og du vil heller ikke være i stand til at se andre online brugere. Når dette felt er markeret, er det modsatte tilfældet. Du vil være synlig for andre, og du vil også kunne se andre, der er konfigureret til at være synlige.";
$pgv_lang["useradmin_editaccount_help"]			= "~#pgv_lang[editaccount]#~<br /><br />Hvis denne valgmulighed er afmærket, vil brugeren have rettigheder til at ændre sin egen brugerkonto.<br /><br />Hvis valget ikke er afmærket, vil brugeren ikke kunne ændre sine egne brugervalg.  Dette giver dig muligheden for at lave et fælles brugernavn og adgangskode for flere brugere og hindre dem i at ændre den fælles brugerkonto.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Hvis denne checkboks er afmærket vil brugeren kun få tilladelse til at se nulevende personer, som de er beslægtet med.  De vil kunne se alle, indenfor den relationsstilængde, der er sat i deres <i>#pgv_lang[user_path_length]#</i>. Du kan kræve privatlivsindstilling for alle dine brugere ved at slå den globale privatlivsindstilling til for GEDCOM-filen.<br /><br />Denne indstilling kræver at brugerne knyttes til et GEDCOM ID førend de kan se nulevende personer.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Hvis <i>#pgv_lang[user_relationship_priv]#</i> er aktiveret vil en bruger kun kunne se eller redigere levende personer indenfor dette antal af slægtstrin.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Sættes et checkmærke i denne checkboks giver du systemet tilladelse til automatisk at godkende ændringer, der er udført af denne bruger.  Brugeren skal ligeledes have godkendelsesrettigheder til GEDCOM-filen for at det virker.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />På denne side kan du tilføje eksterne sites og udelukke IP-adresser.<br /><br />Eksterne sites kan tilføjes ved at opgive sitens titel, URL-adresse, database ID (valgfri), brugernavn, og adgangskode for den eksterne webservice.<br /><br />Udelukkelse af IP-adresser gøres ved at angive en specifik IP-adresse eller en gyldigt IP-adresseområde, som fx. 212.10.*.* Eksterne sites indenfor dette IP-adresseområde på listen over udelukkede sites vil ikke kunne få adgang til din hjemmeside.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />For at tilføje en ekstern site, angives titlen på siten, URL-adressen på den eksterne hjemmeside, database ID (valgfri), og brugernavn og adgangskode. Klik på <b>Tilføj</b> knappen for at fuldføre processen.  Hvis den eksterne server tillader anonym adgang, bør du undlade at udfylde felterne med brugernavn og adgangskode.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "IPv4 adresser består af 4 segmenter adskilt af \".\" (punktum) og indeholder decimaltal i området nul til 255 uden førende nuller. Nogle eksempler er: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> eller <b>212.10.*.29</b> . De manglende segmenter i disse eksempler vil blive fortolket som \"*\" (stjerne), med det \"*\" symbol, der betyder <i>match et hvilket som helst nummer i denne position</i>.<br /><br />IPv6-adresser består af 8 segmenter adskilt af \":\" (kolon) og indeholder 4 cifrede hexadecimale tal. Disse tal bør ikke have førende nuller, og den første sekvens af nuller kan fjernes og erstattes af et par symboler \":\" (kolon). Hvis du skal bruge funktionen <i>match et hvilket som helst nummer i denne position</i>, skal du eksplicit indsætte \"*\" (stjerne) der. Nogle eksempler er: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> or <b>23:0:*::*:*</b> . I disse eksempler repræsenterer paret af kolonier en sekvens af 3 tal, som hver er nul, som sådan: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />For at forhindre specifikke IPv4- eller IPv6-adresser fra at få adgang til dit websted, indtast en nøjagtig IP-adresse eller et gyldigt IP-adresseområde, og klik på knappen Tilføj (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />Når et hackningsforsøg er registreret, forhindrer PhpGedView automatisk adgang fra den IP-adresse i en time.<br /><br />Du kan tilføje dine egne tidsbegrænsede adgangsbegærelser ved at indtaste IPv4- eller IPv6-adressen, der skal blokeres, sammen med datoen og tidspunktet for adgangsafslagets afvisning i feltet Kommentarer. Sørg for at bruge det korrekte format for udløbsoplysningerne. Hvis udløbsoplysningerne ikke er indtastet korrekt, udløber adgangsbegrænsningen ikke automatisk.<br /><br />Udløbet skal indtastes i følgende format: <b>åååå.mm.dd@tt:mm</b>. For eksempel, <b>2012.12.23@23:59</b>. Bemærk brugen af 24-timers uret.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]	= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView giver automatisk søgemaskiner med mindre datafiler med færre links. Dataene er begrænset til den enkelte og nærmeste familie uden at tilføje oplysninger om bedsteforældre eller småbørn. Mange rapporter og serverintensive sider som kalenderen er uden grænser for søgemaskiner.<br /><br />Mange populære søgemaskiner som Google og Bing registreres automatisk. Hvis en søgemaskine ikke automatisk genkendes, og du ønsker at give den data til indeks, kan du indtaste sin IPv4- eller IPv6-adresse her. Hvis du vil udelukke denne nye søgemaskine fuldstændigt, skal du liste den i sektionen <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Hvis du ønsker at se, hvilke data der gives til søgemaskiner til at indeksere, skal du angive din egen IP-adresse her.&nbsp; <span class='warning'>ADVARSEL:</span>&nbsp; Dette vil <b>låse dig ud</b> af administratorinterfacet, og du skal fjerne IP-adressen ved at logge ind fra en anden maskine med en anden IP-adresse eller manuelt redigere <i>#GLOBALS[TBLPREFIX]#ip_address</i> database tabel.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Søgemaskine fundet~<br /><br />PhpGedView forsyner automatisk søgemaskiner med mindre datafiler med færre links. Dataene er begrænset til personen og den nærmeste familie uden at tilføje oplysninger om bedsteforældre eller børnebørn. Mange rapporter og serverintensive sider som kalenderen er begrænset for søgemaskiner.<br /><br />Forsøg fra søgemaskiner på at gå til disse sider resulterer i at vise denne side. Hvis du ser denne tekst, mener softwaren, at du er en søgemaskine. Nedenfor er listen over sider, der har adgang til og vil give de forkortede data.<br /><br />Virkelige brugere, der følger søgemaskilinks til dette websted, vil se de fulde sider og data og ikke denne side.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Uploade GEDCOM-filer</b><br />At uploade filer kan gøres online, hvis du ikke har et FTP-program.<br /><br /><b>Tilføje en GEDCOM-fil</b><br />Hvis en fil stadigvæk findes i den <b>/index</b> mappe, hvor du gemmer dine GEDCOM-filer, kan du bruge den igen uden at hente den igen. Nogle gange skal man bruge \"Tilføj\" i stedet for at uploade på grund af filstørrelsen eller begrænsninger mht. at uploade.<br /><br />Både proceduren \"Tilføj\" og \"Upload\" kan udføres i 4 enkle trin. Det er kun trin 1, der er forskellig i procedurene.";
$pgv_lang["gedcom_configfile_help"]		= "~Konfigurationsfil~<br /><br />Denne fil indeholder alle de grundlæggende indstillinger af slægtsdatabasen.<br /><br />I kolonnen <b>#pgv_lang[current_gedcoms]#</b> på siden <b>#pgv_lang[gedcom_adm_head]#</b>, vises stien og navnet til konfigurationsfilen.";
$pgv_lang["default_gedcom_help"]		= "~Standard slægtsdatabase~<br /><br />Hvis du har mere end en slægtsdatabase i programmet, kan du her angive hvilken, der skal være <b>standard</b> slægtsdatabase.<br /><br />Denne vil blive vist til besøgende og brugere, der ikke er logget ind.<br /><br />Brugere kan ignorere denne indstilling ved at ændre valget af standard slægtsdatabase når de har logget sig ind via deres egen brugerkonto.";
$pgv_lang["delete_gedcom_help"]			= "~Slet slægtsdatabasen~<br /><br />PhpGedView importerer poster fra GEDCOM-filen. Hvis du klikker på <b>Slet</b>, vil programmet slette de poster, der blev importeret fra GEDCOM-filen. Efter at du har klikket på Slet, skal du bekræfte at du vil slette. Den originale GEDCOM-fil vil ikke blive slettet/berørt.<br /><br />Hvis du senere ønsker at anvende eller arbejde med denne GEDCOM-fil igen, kan du bare vælge: <b>Tilføj en GEDCOM-fil</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Når du bruger funktionen <b>#pgv_lang[add_gedcom]#</b>, antages det, at du allerede har uploadet GEDCOM-filen til din server ved hjælp af et program eller en metode <u> ekstern </u> til PhpGedView til f.eks. <i>ftp</i> eller <i>netværksforbindelse</i>. Den fil, du vil tilføje, kunne også have været til overs fra en tidligere <b>#pgv_lang[upload_gedcom]#</b> procedure.<br /><br />Hvis input GEDCOM-filen endnu ikke er på din server, du <u>skal</u> få den der først, før du kan begynde med Tilføjelse.<br /><br />I stedet for at uploade en GEDCOM-fil kan du også uploade en ZIP-fil, der indeholder GEDCOM-filen, enten med PhpGedView eller ved hjælp af et eksternt program. PhpGedView genkender ZIP-filen automatisk og udtrækker GEDCOM-filen og filnavnet fra ZIP-filen.<br /><br />Hvis der allerede findes en GEDCOM-fil med samme navn i PhpGedView, overskrives den. Alle GEDCOM-indstillinger, der er foretaget tidligere, bevares dog.<br /><br />Du bliver guidet trin for trin gennem proceduren.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Du har muligheden for at oprette en ny slægtsdatabase uden personer.<br /><br />Denne procedure kræver kun et par enkle trin. Trin 1 adskiller sig fra det, du allerede ved om upload og tilføjelse. De andre trin vil være velkendte.<ol><li><b>Giv den nye GEDCOM-fil et navn</b><br />Skriv navnet på den nye fil <u>uden</u> efternavnet <b>.ged</b>. Den nye fil vil blive oprettet/gemt i mappen, som nævnt i teksten over feltet, hvor du skriver filnavnet. Klik på <b>Tilføj</b>.</li><li><b>Konfigurationssiden.</b><br />Dette er den side, hvor du angiver indstillingerne for slægtsdatabasen.</li><li><b>Gyldighed</b><br />Den nye database er blevet checket og er godkendt.</li><li><b>Importer poster</b><br />Da der ikke er nogen poster at importere, er det meget hurtigt gjort...</li></ol>Nu kan du gå til Anetræet for at se den \"første\" person i den nye slægtsdatabase. Klik på personens navn og begynd derefter med at ændre denne. Derefter kan du begynde at tilføje nye personer knyttet til den første person.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Fra denne side kan du downloade din slægtsdatabase i GEDCOM-format. Det kan være en god idé at importere dataene til et andet genealogisk program, eller du vil måske dele oplysningerne med andre.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />Siden #pgv_lang[gedcom_adm_head]# er kontrolcentret til administration af alle dine slægtsdatabaser.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />I spidsen for <b>#pgv_lang[current_gedcoms]#</b> tabel ser du en handlingslinje med fire links.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />I tabellen <b>#pgv_lang[current_gedcoms]#</b> vises hver genealogisk database separat, og du har følgende muligheder for hver af dem:<ul><li>Importere</li><li>Slet</li><li>Download</li><li>Rediger konfiguration</li><li>Rediger privatlivsindstillinger</li><li>Søgeloggen filer</li></ul>Rediger fortrolighed vises her, fordi hver GEDCOM har sin egen privatlivsfil.<br /><br />Hver linje i denne tabel skal være selvforklarende. PhpGedView kan konfigureres til at logge alle databasesøgninger. Søgningslogfilerne kan inspiceres gennem links, der findes på denne side.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]	= "~KONFIGURER GEDCOM~<br /><br />Hver slægtsdatabase, der bruges med PhpGedView, har sin egen <b>konfigurationsfil</b>.<br /><br />På denne formular konfigurerer du mange muligheder såsom databasetitel, sprog, kalenderformat, e-mail-indstillinger, logning af database søgninger, HTML META-overskrifter, fjernelse af efternavne fra databasens liste over hyppige efternavne osv.";
$pgv_lang["import_gedcom_help"]			= "~Importere GEDCOM-filer~<br /><br />I de fleste tilfælde er import af en GEDCOM-fil en del af en større procedure, som for eksempel at tilføje, generere en ny eller uploade filen.<br /><br />Proceduren udføres i en logisk og nødvendig rækkefølge, og skal gennemføres helt for at importen skal ske rigtig.<br /><br />Hvis du ikke fuldfører alle dele af proceduren, som beskrevet ovenfor, vil du få en <u>advarsel</u> om at slægtsdatabasen ikke er bevet importeret endnu. Så bør du klikke på linket igen for at <b>importere GEDCOM-filen</b> påny.<br /><br />Indstillingerne af slægtsdatabasen vil ikke blive ændret når du importerer en GEDCOM-fil påny. Bare eksisterende slægtsdata vil blive overskrevet.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />I modsætning til funktionen <b>#pgv_lang[add_gedcom]#</b> behøver den GEDCOM-fil, du vil føje til din database, ikke at være på din server.<br /><br />I trin 1 vælger du en GEDCOM-fil fra din lokale computer. Indtast hele stien og filnavnet i tekstfeltet, eller brug knappen <b>Gennemse</b> på siden.<br /><br />Du kan også bruge denne funktion til at uploade en ZIP-fil, der indeholder GEDCOM-filen. PhpGedView genkender ZIP-filen og udpakker automatisk filen og filnavnet.<br /><br />Hvis der allerede findes en GEDCOM-fil med samme navn i PhpGedView, overskrives den efter din bekræftelse. Alle GEDCOM-indstillinger, der er foretaget tidligere, bevares dog.<br /><br />Du finder mere hjælp på andre sider i proceduren.";
$pgv_lang["validate_gedcom_help"]		= "~VALIDER GEDCOM~<br /><br />Dette er det tredje trin i proceduren for at tilføje eksternt oprettede GEDCOM-data til din slægtsdatabase.<br /><br />PhpGedView kontrollerer inputfilen for korrekt brug af datoformat, stedformat, tegnsæt osv. Nogle afvigelser fra GEDCOM 5.5.1 standarden, som PhpGedView overholder, kan rettes automatisk. Eksempler er Macintosh-linieendelser og forkert brug af stedformat. Når dette sker, vil du se en besked om, at dataene er blevet ændret. Ved andre abnormiteter får du en advarselsmeddelelse med en anbefalet løsning.<br /><br /><b>Valgfrie Værktøjer</b><br />I øjeblikket er der kun et ekstra værktøj: <b>Skift person-id til...</b>.<br /><br /><b>Mere hjælp</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~Konverter ANSI til UTF-8~<br /><br />For at være sikker på, at programmet kan håndtere GEDCOM-filerne korrekt, bør filerne være kodet i UTF-8 format.<br /><br />De fleste slægtsprogrammer har en valgmulighed  for at kunne eksportere GEDCOM-filer med tegnsættet UTF-8. Hvis det program, du anvender, ikke har denne valgmulighed, kan PhpGedView konvertere filen for dig.<br /><br />Når PhpGedview checker kvaliteten under uploading eller tilføjelse af en fil,  vil programmet opdage om filen har et ANSI tegnsæt.";
$pgv_lang["detected_ansi2utf_help"]		= "~ANSI tegnsæt opdaget~<br /><br />GEDCOM-filen, der nu er blevet checket mht. gyldighed, har ANSI tegnsæt. Det anbefales på kraftigste, at filen konverteres til UTF-8 tegnsættet (ellers vil sær-nationale tegn (f.eks. ÆØÅ) blive vist forkert).<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~FORKERT DATOFORMAT FUNDET~<br /><br /><b>DATOFORMAT ÆNDRES</b><br /><br />Datoformatet, der er standard for PhpGedView og også i henhold til GEDCOM 5.5.1 Standard er <b>DD&nbsp;MMM&nbsp;YYYY</b> (f.eks. 01&nbsp;JAN&nbsp;2004)<br /><br />Hvis efter din GEDCOM-fil er blevet valideret, du ser en meddelelse om, at der er registreret et forkert datoformat, PhpGedView konverterer de forkert formaterede datoer som foreskrevet af standarden.Du har dog mulighed for at vælge enten \"<b>dag</b> før måned\" (DD&nbsp;MMM&nbsp;YYYY) eller \"<b>måned</b> før dag\" (MMM&nbsp;DD&nbsp;YYYY).<br /><br />Vi anbefaler, at du bruger det første format (dag før måned).";
$pgv_lang["change_indi2id_help"]		= "~Skift person ID til ....~<br /><br />Dette værktøj blev lavet for brugere af slægtsprogrammer, der genererer forskellige ID numre for personerne hver gang disse eksporteres til en GEDCOM-fil. For eksempel så gav programmet ved første eksport til en GEDCOM-fil, en person ID I100. Næste gang fik samme person ID I234.  Disse udskiftninger af ID numre gør det vanskeligt at administrere PhpGedView, fordi ID nummeret anvendes til at identificere personer.<br /><br />De fleste slægtsprogrammer anvender også RIN- eller REFN-koder (tag) for at give hver person en unik identifikation, der kan bruges til at genkende personen. Dette værktøj vil erstatte alle personers ID numre i GEDCOM-filen med værdien i et andet felt, som du angiver.  Du kan vælge RIN- eller REFN-feltet som kilde til personernes ID numre i slægtsdatabase.";
$pgv_lang["edit_privacy_help"]			= "På denne siden kan du oprette dine egne indstillinger mht. beskyttelse af privatlivet den valgte slægtsdatabase (valgte - hvis du har flere end en).<br /><br />Du kan checke under titlen på siden, om det er den rigtige privatlivsfil. Den er vist således: (sti/navnet_til_din_gedcom_priv.php).<br /><br />Hvis du har behov for flere indstillinger, så kan du manuelt ændre privatlivsfilen. Du kan læse mere om dette på PhpGedViews hjemmeside.";
$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) opdaget~<br /><br />Den GEDCOM fil du er ved at importere har en speciel 3-byte kode i starten. Denne specielle kode bruges i nogle programmer til at indikerer at denne fil er blevet skrevet med UTF-8 tegnsæt.<br /><br />Selvom denne specielle kode egentlig ikke er en fejl, vil PhpGedView ikke virke ordentlig, når filen har denne kode. Du bør lade phpGedview fjerne koden.";
$pgv_lang["invalid_header_help"]		= "~Ugyldig start i GEDCOM-fil~<br /><br />En GEDCOM-fil skal, som første linie have <b>0&nbsp;HEAD</b>.  PhpGedView opdaget at GEDCOM-filen din har en annen start.  Etter at du har klikket på knappen Rydd, vil alle linjer før linjen med <b>0&nbsp;HEAD</b> bli fjernet i GEDCOM-filen din.<br /><br />Denne feilen betyr vanligvis at programmet du brukte for å lage GEDCOM-filen din ikke lagde en gyldig file eller at filen ikke er en GEDCOM-fil.  Du bør sjekke at du lastet op (uploaded) den rette GEDCOM-filen, og at den starter med linjen <b>0&nbsp;HEAD</b> og slutter med linjen <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSH-FIL FUNDET~<br /><br />PhpGedView registrerede, at din GEDCOM-fil blev oprettet på en Macintosh-computer.<ul><li>Macintosh-filer slutter hver linje med en CR-kontrolkode. CR er Ctrl+M.</li><li>Unix-filer slutter hver linje med en LF-kontrolkode. LF er Ctrl+J.</li><li>Windows og DOS bruger en to-kodesekvens, CR efterfulgt af LF.</li></ul>PhpGedView kræver, at alle filer bruger Unix- eller DOS-linieendelser. Når du klikker på knappen Oprydning, konverteres dine linjeafslutninger i overensstemmelse hermed.";
$pgv_lang["cleanup_places_help"]		= "~Ryd op i stedkoder~<br /><br />PhpGedView har opdaget at din GEDCOM-fil bruger stedkoden (2 PLAC) på de forkerte steder.<br /><br />Mange slægtsprogrammer, som f.eks Family Tree Maker, genererer GEDCOM-filer med denne fejl.  PhpGedView vil som udgangspunkt acceptere disse GEDCOM-filer, men ugyldige stedkoder vil snige sig ind imellem de gyldige stedkoder.<br /><br />For eksempel kan dn GEDCOM-fil have følgende kodning:<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Computer programmør</div><br />I henhold til gældende GEDCOM-specifikation skulle dette have været kodet sådan her:<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Computer programmør</div><br />Hvis du vælger <b>Ja</b>, vil PhpGedView søge efter og rydde op i disse kodefejl.";
$pgv_lang["empty_lines_detected_help"]	= "~Tomme linier opdaget~<br /><br />PhpGedView har opdaget, at der er tomme linier i din GEDCOM-fil.  Disse linier kan forårsag fejl og vil blive fjernet fra GEDCOM-filen førend den bliver importeret.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~KONFIGURERE PhpGedView~<br /><br />På denne side konfigurerer du de globale indstillinger for PhpGedView. Du skal gøre dette, når du har installeret PhpGedView og kører det for første gang.<br /><br />#pgv_lang[review_readme]#<br /><br />Da disse indstillinger er <b>globale</b>, er de til hele programmet og for alle slægtsdatabaser, du bruger med PhpGedView.<br /><br />Hver slægtsdatabase har også yderligere konfigurationsindstillinger, som du indstiller efter at have klikket på <b>#pgv_lang[admin_gedcoms]#</b> linket på dette side.<br /><br />Du kan også få adgang til funktionen #pgv_lang[gedcom_adm_head]# fra hovedadmin-siden, hvis link findes under ikonet #pgv_lang[mgv]# eller i overskriften på de fleste sider. På siden Administrator hedder det relevante link <b>#pgv_lang[manage_gedcoms]#</b>.";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Denne side giver dig mulighed for at flette (lægge sammen) 2 GEDCOM-poster i slægtsdatabasen.  Dette er en nyttig funktion, hvis du har importeret en anden slægtsdatabase (GEDCOM) ind i din egen, og du har fået dubletter af flere personer, familier og/eller kilder.<br /><br />Denne side indeholder 3 trin.<br /><ol><li>Du angiver to ID numre i slægtsdatabasen.  ID numrene skal være af samme type. (dvs. at du kan ikke flette en person og en familie, eller en familie og en kilde).<br />I feltet <b>#pgv_lang[merge_to]#</b> angiver du postens ID nummer (personen), som du ønsker skal være den nye post efter at fletningen er udført.<br />I feltet <b>#pgv_lang[merge_from]#</b> angiver du ID nummeret på den post, der skal flettes ind i den første og derefter vil blive slettet.</li><li>Du vælger hvilke oplysninger, du vil beholde fra de to poster efter at de flettet sammen til en post.  Du klikker bare på checkfeltet ved siden af dem du ønsker at beholde.</li><li>Viser dig resultatet af fletningen.</li></ol>For at ændringen skal være gyldig og kan vises til andre, skal du checke resultatet og godkende det først.";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~#pgv_lang[reports]#~<br /><br />Elementerne i rapportmenuen genererer PDF-filer til udskrivning.<br /><br />Det første trin er at vælge en rapport, der skal køres. Når du har valgt en rapport, der skal køres, bliver du bedt om at give nogle specifikke oplysninger for den rapport, såsom hvilken person eller familie du vil starte med, og om du vil vise fotos eller ej. Når du er klar til at køre rapporten, skal du klikke på knappen <b>#pgv_lang[download_report]#</b> for at downloade rapporten til din computer.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]		= "~PDF filformat~<br /><br />PhpGedView-rapporteringsmotoren producerer rapporter, der kan downloades i Adobe&reg; PDF-format. GEDCOM 5.5.1 Standard specifikationen, der er nævnt andetsteds i denne hjælpefil, kan også downloades som en PDF-fil. PDF er et akronym for <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (Bærbart dokumentformat).";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br /><br />Dette er en udskrift af den valgte persons og hans/hendes aner printed i bogformat.  Den starter med den første person og fortsætter med hans eller hendes forældre, bedsteforældre, osv.<br /><br />Bemærk, at p.t. er en anetavle udskrift i bogformat kun tilrængelig på engelsk.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br /><br />Med denne udskrift kan du vise alle personer, der blev født på en bestemt dato eller et bestemt sted.";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br /><br />Denne udskrift lister alle slægtninge til den valgte person.  Du kan vælge hvilke af slægtninge, der skal vises i udskriften.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;viser den valgte person, hans/hendes forældre og brødre og søstre.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;viser personen, og ægtefællen samt deres børn.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;viser personen, hans/hendes forældre, bedsteforældre, oldeforældre, og fortsætter op i træet med at vise alle forædrene til personerne i lige linie.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;viser alle personerne fra #pgv_lang[direct-ancestors]# listen, men medtager også tanter og onkler, grandtanter og grandonkler, samt indeholder søskende til alle aner i personens familietræ.  Den viser ikke kusiner og fætres børn.</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;viser alle personens efterkommere (børn, børnebørn, oldebørn, osv).</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Denne valgmulighed er en kombination af #pgv_lang[descendants]# og #pgv_lang[ancestors]# i en enkelt udskrift.</li></ul>";
$pgv_lang["help_xml_reports"]	= "~Rapporteringsmotor~<br /><br />PhpGedViews udskrift generator anvender skabeloner i form af XML filer til automatisk at generere PDF udskrifter.<br /><br />De udskrifter, der er til rådighed i <b>#pgv_lang[select_report]#</b> listen genereres ud fra XML filerne, der findes i \"reports\" mappen.  Du kan oprette dine egne udskrifter ved at lave en kopi af en af de medfølgende skabeloner og modificere den.  For at tilføje din egen tilpassede udskrift, skal du blot placere den i \"reports\" mappen. PhpGedView vil automatisk opdage den og gøre den tilgængelig i listen.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>HJÆLP INDHOLD</b>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-fil";
$pgv_lang["help_contents_gedcom_places"]	= "Steder i slægtsdatabasen (GEDCOM-fil)";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>HJÆLP INDHOLD<br /><br />ADMINISTRATOR HJÆLPEMÆLKER</b> tilføjet til begyndelsen af listen.";
// $pgv_lang["ah1_help"]					= "_Opgradere";
$pgv_lang["ah2_help"]					= "_PhpGedView indstillinger";
$pgv_lang["ah3_help"]					= "_GEDCOM: Tilføje kontra uploade";
$pgv_lang["ah4_help"]					= "_GEDCOM: Konfigurationsfil";
$pgv_lang["ah5_help"]					= "_GEDCOM: Standard";
$pgv_lang["ah6_help"]					= "_GEDCOM: Slette";
$pgv_lang["ah7_help"]					= "_GEDCOM: Tilføj";
$pgv_lang["ah8_help"]					= "_GEDCOM: Oprette ny";
$pgv_lang["ah9_help"]					= "_GEDCOM: Download";
$pgv_lang["ah10_help"]					= "_GEDCOM: Siden Administration";
$pgv_lang["ah11_help"]					= "_GEDCOM: Konfigurere";
$pgv_lang["ah12_help"]					= "_GEDCOM: Importere";
$pgv_lang["ah13_help"]					= "_GEDCOM: Upload";
$pgv_lang["ah14_help"]					= "_GEDCOM: Check gyldighed";
$pgv_lang["ah15_help"]					= "_GEDCOM: Konvertere ANSI til UTF-8";
$pgv_lang["ah16_help"]					= "_GEDCOM: Privatlivsindstillinger";
$pgv_lang["ah17_help"]					= "_Brugere og rettigheder";
$pgv_lang["ah18_help"]					= "_Administration";
$pgv_lang["ah19_help"]					= "_GEDCOM: Medieværktøj";
$pgv_lang["ah20_help"]					= "_GEDCOM: Ændre ID for person(er) til ...";
$pgv_lang["ah21_help"]					= "_Sprogfiler";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Konfigurer understøttede sprog";
$pgv_lang["ah24_help"]				= "_Bruger Information flet sammen (Index --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]				= "_PhpGedView backup";
$pgv_lang["ah26_help"]				= "_FAQ liste: Rediger";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~Statistik plot~<br /><br />Dette er resultatsiden, der viser det grafiske plot af statistikkerne fra din database som defineret af input på den forrige side.";
$pgv_lang["help_statistics.php"] = "~Statistik plot~<br /><br />På denne side kan du bestemme kriterierne for at fremstille en grafisk visning af forskellige statistikker fra din database.";
$pgv_lang["stat_help"]			= "~indstillinger FOR STATISTIKPLOTTER~<br /><br />Der kan produceres et antal forskellige diagrammer fra din database.<br /><br />Vælg diagrammet, og juster derefter indstillingerne i rullemenuerne.<br /><br />Tallene, der er inkluderet i hvert plot, afhænger af de tilgængelige data. F.eks. Kan enkeltpersoner uden en fødselsmåned (f.eks. kun '1856') ikke medtages i et plot af fødsler efter måned.";
$pgv_lang["stat_help_x"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~X AXIS~<br /><br />Følgende indstillinger er tilgængelige for X-aksen (vandret). Hver vil derefter blive præsenteret i henhold til indstillingerne for Y- og Z-akserne.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;personer født i hver måned.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;personer, der døde i hver måned.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;ægteskaber, der fandt sted i hver måned.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;antallet af førstefødte for hver familie efter måned.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;antallet af første ægteskaber pr. måned.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;antallet af måneder mellem ægteskab og fødsel af det første barn til det par.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;alder ved død, relateret til den tidsperiode, der inkluderer hver persons fødselsår.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;alder ved død, relateret til den tidsperiode, der inkluderer hver persons dødsår.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;gennemsnitsalderen for personer på tidspunktet for deres ægteskab.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;gennemsnitsalderen for personer på tidspunktet for deres første ægteskab.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;gennemsnitlige familiestørrelser.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;placering af alle personer eller personer med det angivne navn efter land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;fødeland.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;ægteskabsland.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;dødsland.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;cirkeldiagram over enkeltpersoner med kilder.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;cirkeldiagram over familier med kilder.</p>";
$pgv_lang["stat_help_y"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~Y AXIS~<br /><br />Følgende indstillinger er tilgængelige for Y-aksen (lodret). Disse indstillinger ændrer den måde, hvorpå elementerne på X-aksen vises.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;viser antallet af individer i hver kategori defineret af X-aksen.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;beregner og uddeler andelen af hvert emne i X-aksekategorierne.</p>";
$pgv_lang["stat_help_z"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~Z AXIS~<br /><br />Følgende indstillinger er tilgængelige for Z-aksen. Disse muligheder giver en underinddeling af de kategorier, der er valgt til X-aksen.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;viser elementerne som en enkelt kolonne for hver X-aksekategori.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;viser elementerne i 2 kolonner (mand og kvinde) for hver X-aksekategori.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;viser elementerne i et antal kolonner relateret til de tidsperioder, der er angivet i det næste afsnit, for hver X-aksekategori.</p>";
$pgv_lang["stat_help_gwx"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~grænser for X-aksen~<br /><br />Vælg det ønskede aldersinterval.<br /><br />For eksempel <b>#pgv_lang[aft_marr]#</b> beskriver følgende sæt månedintervaller:<div style=\"padding-left: 30px;\">inden ægteskabet<br />fra ægteskabet til 8 måneder efter<br />fra 8 til 12<br />fra 12 til 15<br />fra 15 til 18<br />fra 18 til 24<br />fra 24 til 48<br />over 48 måneder efter ægteskabet</div><br />Når du vil vise kvartaler, skal du vælge <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~grænser for X-aksen~<br /><br />Vælg det ønskede aldersinterval.<br /><br />F.eks. <b>interval 10 år</b> beskriver følgende aldersgrupper:<div style=\"padding-left: 30px;\">yngre end et år<br />et år til 5 år<br />6 til 10<br />11 til 20<br />21 til 30<br />31 til 40<br />41 til 50<br />51 til 60<br />61 til 70<br />71 til 80<br />81 til 90<br />91 til 100<br />ældre end 100 år</div>";
$pgv_lang["stat_help_gbx"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~grænser for X-aksen~<br /><br />Vælg det ønskede aldersinterval.<br /><br />F.eks. <b>interval 2 år</b> beskriver følgende sæt aldersgrupper:<div style=\"padding-left: 30px;\">yngre end 16 år<br />16 til 18<br />19 til 20<br />21 til 22<br />23 til 24<br />25 til 26<br />27 til 28<br />29 til 30<br />31 til 32<br />33 til 35<br />36 til 40<br />41 til 50<br />ældre end 50 år</div>";
$pgv_lang["stat_help_gcx"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~grænser for X-aksen~<br /><br />Vælg det ønskede optællingsinterval.<br /><br />F.eks. <b>interval et barn</b> beskriver følgende sæt rækkeantal for børn:<div style=\"padding-left: 30px;\">uden børn<br />et barn<br />to børn<br />3, 4, 5, 6, 7, 8, 9, 10 børn<br />mere end 10 børn</div>";
$pgv_lang["stat_help_gwz"]		= "~indstillinger FOR STATISTIKPLOTTER~<br />~grænser for Z-aksen~<br /><br />Vælg det ønskede startår og interval<br /><br />F.eks. <b>fra 1700 intervallet 50 år</b> beskriver følgende sæt datointervaller:<div style=\"padding-left: 30px;\">før 1700<br />1700 til 1749<br />1750 til 1799<br />1800 til 1849<br />1850 til 1899<br />1900 til 1949<br />1950 til 1999<br />2000 eller senere</div>";
$pgv_lang["chart_type_help"]	= "~indstillinger FOR STATISTIKPLOTTER~<br /><br />Vælg det, du vil se på kortkortet. Du kan vælge:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;viser de lande, hvor personer fra denne database forekommer.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;viser de lande, hvor det angivne efternavn forekommer.</div>";
$pgv_lang["google_chart_surname_help"]	= "~indstillinger FOR STATISTIKPLOTTER~<br /><br />Antallet af forekomster af det angivne navn vises på kortet. Hvis du efterlader dette felt tomt, bruges det mest almindelige efternavn.";
$pgv_lang["chart_area_help"]	= "~indstillinger FOR STATISTIKPLOTTER~<br /><br />Vælg det geografiske område, du vil se på kortet. Du kan vælge:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;viser alle kontinenter.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;viser Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;viser Sydamerika.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;viser Asien.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;viser Mellemøsten.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;viser Afrika.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />På denne side kan du nemt håndtere dine mediefiler og mapper.<br /><br />Når du opretter nye medie undermapper vil PgpGedView sørge for at den samme mappestruktur er vedligeholdt i <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b> mappen. Når du uploader nye mediefiler, kan PhpGedView automatisk oprette miniaturene for dig.<br /><br />Ved siden af hvert billede i medielisten, vil du finde følgende muligheder. Mulighederne der vises afhænger af den aktuelle status for mediefilen.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Når du klikker på denne funktion, vil du se en side hvor du kan ændre titlen på medieobjektet. Hvis medieobjektet endnu ikke er tilknyttet en person, familie eller kilde i den aktive database, kan du oprette denne tilknytning her. Du kan omdøbe filen eller endda ændre dens placering i <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mappestrukturen. Når det er nødvendigt, vil PhpGedView automatisk oprette de krævede undermapper eller evt. manglende miniaturer.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Denne funktion er kun tilgængelig når administratoren har aktiveret den. Du kan vise eller redigere de rå GEDCOM data der er tilknyttet dette medieobjekt. Du bør være yderst forsigtig når du bruger denne funktion.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp; Denne funktion lader dig slette al kendskab til denne mediefil fra den aktuelle database. Andre databaser vil ikke blive berørt. Hvis denne mediefil ikker er nævnt i andre databaser, vil den og dens tilknyttede miniature blive slettet.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Denne funktion lader dig slette al kendskab til mediefilen fra den aktuelle database. Andre databaser vil ikke blive berørt. Mediefilen og den tilknyttede miniature, vil ikke blive slettet.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Denne funktion lader dig fjerne alle links til medieobjektet i den aktuelle database. Filen vil ikke blive slettet, og medieobjektet som denne fil er kendt ved i den aktuelle database vil blive gemt. Andre databaser vil ikke blive berørt.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Denne funktion lader dig oprette links mellem mediefilen og personer, familier eller kilder i den aktuelle database. Hvis nødvendigt, vil PhpGedView også oprette medieobjektet ved hvilken denne mediefil er kendt af den aktuelle database.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Når du vælger denne funktion, vil PhpGedView oprette den manglende miniature.</li></ul>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Enkelt søgefilter baseret på de bogstaver/tegn, der er skrevet ind.  Ingen wildcards (? *) er tilladt.";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Miniaturebilleder vil blive vist, hvis du sætter et mærke i denne checkboks.";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Her har du muligheden for at søge i mappestrukturen for at finde den medie-fil, du ønsker at lave et link til.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Hvert medieelement skal tilknyttes en eller flere person-, familie- eller kildeposter i din database.<br /><br />For at oprette et sådant link kan du indtaste eller søge efter IDet for personen, familien eller kilden på samme tid som du opretter medieelementet. Du kan også oprette linket senere gennem redigeringsindstillinger på siden Manage MultiMedia eller ved at tilføje medieelementer via linket Tilføj medie, der er tilgængeligt på siderne Person, Familie eller Kildedetaljer.";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />Den mediefil, du uploader, kan navngives anderledes på serveren og sandsynligvis være navngivet på din lokale computer. Dette skyldes, at det lokale filnavn ofte har betydning for dig, men er meget mindre meningsfuldt for andre, der besøger dette websted. Overvej også muligheden for, at du og en anden begge prøver at uploade forskellige filer kaldet \"papa.jpg\".<br /><br />I dette felt angiver du det nye navn på den fil, du uploader. Navnet, du indtaster her, bruges også til at navngive miniaturebilledet, som kan uploades separat eller genereres automatisk. Du behøver ikke at indtaste filtypenavnet (jpg, gif, pdf, doc osv.)<br /><br />Lad dette felt være tomt for at holde det originale navn på den fil, du har uploadet fra din lokale computer.";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratoren har aktiveret op til #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappeniveauer under standardindstillingen <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Dette hjælper med at organisere mediefiler og reducerer muligheden for navnekollisioner.<br /><br />I dette felt angiver du destinationsmappen, hvor den uploadede mediefil skal gemmes.Den matchende miniaturefil, enten uploadet separat eller genereret automatisk, gemmes i en lignende mappestruktur, der starter ved <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> i stedet for <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.Du behøver ikke at indtaste <b>#GLOBALS[MEDIA_DIRECTORY]#</b> delen af destinationsmappens navn.<br /><br />Hvis du ikke er sikker på, hvad du skal indtaste her, skal du kontakte din webstedsadministrator for rådgivning.";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratoren har aktiveret op til #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappeniveauer under standardindstillingen <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Dette hjælper med at organisere mediefiler og reducerer muligheden for navnekollisioner.<br /><br />I dette felt vælger du den mediemappe, hvis indhold du vil se. Når du vælger <b>#pgv_lang[all]#</b>, vises alle mediefiler uden hensyntagen til den mappe, hvor de er gemt. Dette kan producere en meget lang liste over medieelementer.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En liste over opbevaringssteder eller arkiver bliver vist på denne side.<br />Navnene er vist i alfabetisk rækkefølge.<br /><br /><b>OPBEVARINGSSTED</b><br />Uden opbevaringssteder for kilder kan vi ikke lave slægtsdatabasen. Der er en kilde til al den information der er gemt her, og kilderne opbevares på et opbevaringssted. Opbevaringssteder kan være en person, en persons arkiv, en institution, en offentlig database, et offentligt eller kirkeligt arkiv, en Internetkilde, osv. For at få adgang til en kilde, så ønsker vi at vide hvor og på hvilket sted den befinder sig. Al nødvendig information til at finde en kilde bør gemmes i en liste over opbevaringssteder.<br /><br />Et opbevaringssted kan knyttes til mange kilder.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Detaljer vedr. opbevaringsstedet bliver vist her. Sammen med kilder, er information om opbevaringsstederne meget vigtig for slægtsforskere.  Ved at have nøjagtig information om kilder og opbevaringsteder, kan du følge de spore, som andre slægtsforskere brugte for at finde informationen.  Du bør kunne finde den samme information igen.<br /><br />På denne side vil du forhåbentligt kunne se information om navnet på opbevaringsstedet, adresse, e-mail og internetside.<br /><br />Efter informationen om opbevaringsstedet, vil du se en liste med alle kilder, der er knyttet til dette opbevaringssted. Det giver dig muligheden for at se al information, der er fundet på dette bestemte opbevaringssted.<br /><br />Du vil også have to eller flere valmuligheder i menuen på denne side, hvis administratoren af hjemmesiden har aktiveret det:<ul><li><b>#pgv_lang[view_gedcom]#</b>, som viser informationen i GEDCOM-format.</li><li><b>#pgv_lang[add_to_cart]#</b>, der gør det muligt at kopiere informationen til #pgv_lang[clip_cart]# ditt. Herfra kan du downloade informationen i GEDCOM-format og importe den i dit slægtsprogram på din lokale PC.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Når du klikker på denne valgmulighed, så sætter du et mærke ved opbevaringsstedet til at blive slettet i slægtsdatabasen.<br /><br />Hvad betyder det? Forestil dig, at du har en god grund til at fjerne opbevaringsstedet fra slægtsdatabasen. Du klikker på det valgte sted for at slette.  Du vil nu blive spurgt, om du virkelig ønsker at slette den. Hvis du viser listen med opbevaringssteder påny, vil du se, at opbevaringsstedet stadigvæk bliver vist og kan anvendes, som om det ikke var slettet.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Når du klikker på denne valgmulighed, vil informationen om opbevaringsstedet, som det er gemt i slægtsdatabasen, blive vist i et separat vindue.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Når du klikker på denne valgmulighed kan du kopiere informationen om opbevaringsstedet, som det er gemt i slægtsdatabasen, til din #pgv_lang[clip_cart]#.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />I denne liste kan du se navnene på opbevaringsstederne, som de er gemt i slægtsdatabasen. Navnene vises i alfabetisk rækkefølge.<br /><br />Hvis du klikker på et navn i listen, vil du gå til siden #pgv_lang[repo_info]#, hvor du vil se en ny liste med kilder, der er knyttet til opbevaringsstedet.";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />I denne liste kan du se navnene på de kilder, der er knyttet til opbevaringsstedet. Navnene er vist i alfabetisk rækkefølge.<br /><br />Når du klikker på et navn i listen, vil du gå til siden med detaljer for den valgte kilde.";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Flyt blokke på listen~<br /><br />Brug disse knapper til at ændre på rækkefølgen af blokke i listen.  blokke vil blive printet ud i den rækkefølge de er listet.<br /><br />Marker den blok, der skal flyttes, og klik på knappen for at flytte den op eller ned.";
$pgv_lang["block_move_right_help"]	= "~Flyt blokke på listen~<br /><br />Brug disse knapper til at flytte en blok fra en liste til en anden.<br /><br />Marker den blok, der skal flyttes, og klik derefter på en knap for enten at flytte eller kopiere blokken i pilens retning.  Brug <b>»</b> og <b>«</b> knapperne til at flytte den markerede blok fra den venstre liste til den højre liste eller omvendt.  Brug <b>&gt;</b> og <b>&lt;</b> knapperne til at flytte den markerede blok mellem #pgv_lang[available_blocks]# listen og listen til højre eler venstre herfor.<br /><br />Indførslerne i #pgv_lang[available_blocks]# listen ændres ikke, uanset hvad du gør med knapperne #pgv_lang[move_right]# og #pgv_lang[move_left]#, fordi den samme blok kan vises flere gange på den samme side.  HTML-blok er et godt eksempel på, hvorfor du måske ønsker at gøre dette.";
$pgv_lang["block_default_index"]	= "~Standard blokke på #pgv_lang[welcome]# siden~<br /><br />Når du fjerner alle blokke fra #pgv_lang[main_section]# og #pgv_lang[right_section]# lister, eller når du klikker på <b>#pgv_lang[reset_default_blocks]#</b> knappen, vil bloklisten sættes som følger:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]	= "~Standard blokke på #pgv_lang[mygedview]# side~<br /><br />Når du fjerner alle blokke fra #pgv_lang[main_section]# and #pgv_lang[right_section]# lister, eller når du klikker på <b>#pgv_lang[reset_default_blocks]#</b> knappen, så vil bloklisten sættes som følger:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"] = "~Ofte stillede spørgsmål~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "FAQ (Ofte stillede spørgsmål) siden kan indeholde et overblik eller en liste med spørgsmål og svar vedr. brugen af denne site.<br /><br />Hvordan FAQ-siden anvendes er helt op til administratoren. Administratoren af siten styrer indholdet af hvert emne og også den rækkefølge de vises i.";

// Help search
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Du kan søge i PhpGedView's hjælpesystem. Funktionen <b>#pgv_lang[hs_title]#</b> i hovedmenuen giver dig en høj grad af kontrol over den måde, hvorpå søgesystemet fungerer, så du let burde kunne finde det du søger efter.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br /><br />Du skriver de ord eller den sætning, som du ønsker at finde.<br /><br />Søgningen tager ikke hensyn til store og små bogstaver (er ikke case-sensitiv).  Det betyder, at hvis du søger på ordet <b>Person</b>, så vil du finde de tekster, der indholder ordene <b>Person</b>, <b>person</b>, eller <b>PERSON</b>.  Du vil også finde de tekster, der indeholder ordet i flertal som fx <b>personer</b>, osv. fordi søgesystemet vil lede efter sekvenser af bogstaver frm for ord.<br /><br />Du kan søge på flere ord samtidigt.  Skriv alle ordene adskilt med et mellemrum på følgende måde: <b>person&nbsp;familie&nbsp;barn</b>.  Når man angiver mere end et ord vil betydningen fremgå af feltet #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Du definerer omfanget af søgningen her.<br /><br />Administratorer har muligheden for at søge i Brugerhjælpen eller Konfigurationshjælpen eller i begge typer af hjælp.  Brugere har ikke denne mulighed, da de ikke har adgang til funktioner, der vedrører konfiguration (indstilling) af databasen. De kan kun søge i den fil, der indeholder brugerhjælpen.<br /><br />Hjælpefilen indeholder ikke kun hjælpetekst, men også tekststrenge, der anvendes til at opbygge formularer til indtastning samt andre ting.  Ved hjælp af denne valgmulighed kan du bestemme om hele hjælpefilen skal søges igennem eller kun hjælpeteksten.";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br /><br />Du kan give en forklaring på det, du har indtastet i #pgv_lang[hs_keyword]# feltet ved at vælge mellem de muligheder, der er vist her.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Hvis du har indtastet <b>person&nbsp;familie&nbsp;barn</b>, så vil hjælpeteksten, der indeholder et af disse ord, blive fundet.  Rækkefølgen af ordene er uden betydnng.  Søgningen betyder: \"Find den hjælpetekst, der indeholder ordene <b>person</b> <u>eller</u> <b>familie</b> <u>eller</u> <b>barn</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Hvis du har indtastet <b>person&nbsp;familie&nbsp;barn</b>, så vil den hjælpetekst, der indheolder alle de tre ord findes.  Rækkefølgen af ordene er uden betydning.  Søgningen betyder: \"Find den hjælpetekst, der indeholder ordene <b>person</b> <u>og</u> <b>familie</b> <u>og</u> <b>barn</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Hvis du har indtastet ordene <b>person&nbsp;familie&nbsp;barn</b>, så vil den hjælpetekst, der indeholder alle ordene i den rækkefølge, de er angivet, findes.  Søgningen betyder: \"Find den hjælpetekst, der indeholder ordene <b>person&nbsp;familie&nbsp;barn</b> i nøjagtig den rækkefølge, de er angiver uden andre ord eller tegn imellem\".  Du vil sandsynligvis ikke finde nøjagtigt denne sætning i en hjælpetekst.</dd></dl><br />For denne type søgning er der nogle få begrænsninger.  Visse specielle tegn som fx <b>&quot; &lt; &gt;</b> osv. findes i hjælpeteksten i form af symboler og vil ikke blive fundet, hvis de indgår i den tekst du indtaster.  Nogle hjælpetekster indeholder en speciel type af mellemrumstegn, der er repræsenteret af <b>&amp;nbsp;</b> og du vil ikke kunne finde sætninger, der indeholder dette tegn.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Dette værktøj kan hjælpe webstedsadministratorer med at rydde op i filer i indeksmappen.<br /><br />Over tid kan filer såsom logfiler, gamle GEDCOM-filer og gamle backupfiler opbygges i Index mappen. Da mange af disse filer oprettes af programmet, kan de ejes af webserverbrugeren. Hvis de ejes af webserverbrugeren, kan du muligvis ikke slette dem. Dette værktøj giver dig mulighed for at slette disse filer, selv når de ejes af webserverens brugerkonto.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
