<?php
/**
 * German language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Norgaz Kurt
 * @translator Peter Pluntke
 * @translator Gerd Kroll
 * @version $Id: help_text.de.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />Der hier eingegebene Text wird gezeigt, wenn Ihr Mauszeiger über das Textsymbol in der Benutzerliste schwebt. Sie sollten versuchen, diesen Text so kurz wie möglich zu halten.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Geben Sie das Datum ein, ab dem die Aufzeichnungen dieses Benutzers so behandelt werden sollen, als müssten sie vom Administrator überprüft werden. Diese Datensätze werden in der Benutzerliste hervorgehoben, indem der Benutzername in <span class='warning'>rot</span> gezeigt wird.<br /><br />Das Datum muss in Englisch eingegeben werden. Beispiele: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> usw.<br /><br />Wenn die Monatsnummer sowohl die Tagesnummer im Bereich von 1 bis 12 liegen, bestimmt das Trennzeichen (Bindestrich oder Schrägstrich) die Bedeutung, wobei ein Bindestrich <b>-</b> bedeutet, dass die erste Zahl der Tag des Monats ist, während ein Schrägstrich <b>/</b> bedeutet, dass die erste Zahl der Monat ist.<br /><br />Falls die hier eingegebenen Informationen für das Programm bedeutungslos sind, wird »yesterday« verwendet und dieser Datensatz wird dann immer hervorgehoben. »tomorrow« und ähnliche Texte sind in diesem Zusammenhang bedeutungslos und führen dazu, dass dieser Benutzerdatensatz nie hervorgehoben wird.";
$pgv_lang["file_type_help"]				= "~#pgv_lang[choose_file_type]#~<br /><br />Gewünschter Dateityp der exportierten Datenbank.  Ihre Wahl sollte den Bedürfnissen und Fähigkeiten des Programms, in das Sie diese Datei importieren möchten, entsprechen. Zur Wahl sind:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]			= "~#pgv_lang[apply_privacy]#~<br /><br />Wenn diese Option angekreuzt ist, wird die Ausgangsdatei folgend den Regeln der gewählten Option privatisiert.  Unter Umständen fehlen dann bestimmte Informationen in der Ausgangsdatei.  Diese enthält nur Informationen die normalerweise Nutzern mit den gewählten Rechten zugänglich sind.<br /><br />Wenn Sie nur #pgv_lang[gedadmin]# sind, können Sie nicht bestimmen, dass die Ausgangsdatei mit #pgv_lang[siteadmin]# Zugriffsrechten privatisiert werden soll.";
$pgv_lang["convertPath_help"]			= "~#pgv_lang[convertPath]#~<br /><br />Hier können Sie einen Präfix bestimmen, der an alle Medienpfade der Ausgabedatei angebracht wird.<br /><br />Zum Beispiel, Sie haben in der GEDCOM-Konfiguration bestimmt, dass das Medien-Verzeichnis \"/media\" ist.  Wenn der normale Pfad eines Medienobjektes \"/media/Bilder/xyz.jpg\" wäre und Sie in diesem Feld \"c:\\meine Bilder\\meine Familie\" eingegeben haben, ist der Ausgabepfad zu diesem Medienobjekt \"c:\\meine Bilder\\meine Familie/Bilder/xyz.jpg\".<br /><br />Sie können an diesem Beispiel erkennen:<ul><li>der aktuelle Medienpfad wird entfernt,</li><li>der Ausgabepfad zum Medienobjekt hat teilweise falsche Trennzeichen.</li></ul><br />Falls Sie das aktuelle Medienverzeichnis in der Ausgabedatei behalten möchten, müssen Sie dieses im <b>#pgv_lang[convertPath]#</b> Feld eingeben.<br /><br />Es ist auch wichtig, dass Sie das richtige Trennzeichen durch die Option <b>#pgv_lang[convertSlashes]#</b> wählen<br /><br />Medienpfade, die als URL angegeben sind, werden nicht geändert.";
$pgv_lang["convertSlashes_help"]		= "~#pgv_lang[convertSlashes]#~<br /><br />Diese Option bestimmt das Trennzeichen, das zwischen allen Unterverzeichnissen des vollen Medienpfads steht.  Sie können zwischen Schrägstrichen und Rückstrichen wählen.  Ihre Wahl sollte den Bedürfnissen des empfangenden Betriebssystems entsprechen.<br /><br />Die Wahl <b>#pgv_lang[forwardSlashes]#</b> sollte für die meisten Betriebssysteme, ausser Microsoft Windows, richtig sein.  Wenn das Programm, worin Sie die Ausgangsdatei importieren möchten, auf einem Microsoft Windows Betriebssystem läuft, wäre die Wahl <b>#pgv_lang[backSlashes]#</b> richtig.<br /><br />Medienpfade, die als URL angegeben sind, werden nicht geändert.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />Diese Option bestimmt, ob nur das aus der #pgv_lang[filter]# Liste gewählte Verzeichnis oder auch alle davon ausgehende Unterverzeichnisse nach Medienobjekten durchsucht werden sollen.<br /><br />Die Titel aller so gefundenen Medienobjekte werden danach untersucht, ob sie den als #pgv_lang[filter]# eingegebenen Text enthalten.  Die Resultate beider Suchen bestimmen die gezeigten Medienobjekte.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Nur Medien, die nicht mit einem GEDCOM-Datensatz verknüpft sind, werden gezeigt.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Wählen Sie das Medienunterverzeichnis, das Sie sehen möchten.";
$pgv_lang["sortby_help"]				= "~#pgv_lang[sortby]#~<br /><br />Sie können die Reihenfolge der Liste bestimmen.";
$pgv_lang["help_treenav.php"]			= "~#pgv_lang[interactive_tree]#~<br /><br />Diese Seite zeigt Ihnen den Stammbaum, in beiden Richtungen, der gewählten Person.  Das Diagramm ähnelt dem Sanduhr-Diagramm; es zeigt Ahnen und Nachfahren der gewählten Person.  Dieses Diagramm hat eine kompaktere Darstellung als das Sanduhr-Diagramm da es Ihnen Familienangaben anstatt Personenangaben zeigt.<br /><ul><li><b>Scrolling</b><br />Wenn sich der Mauszeiger in sich kreuzende Pfeile verwandelt, können Sie das Diagramm in jede Richtung verschieben um andere Teile des Diagrammes sichtbar zu machen.  Das tun Sie durch gleichzeitiges Drücken der linken Maustaste während Sie den Mauszeiger in der gewünschten Richtung bewegen.  Sie können das Diagramm so lange verschieben, als noch Generationen sichtbar gemacht werden können.<br /></li><li><b>Zoom</b><br />Mit den Zoom-Buttons an der linken Seite des Diagramms können Sie das Diagramm vergrößern oder verkleinern, um weniger oder mehr des Stammbaumes sichtbar zu machen.  Wenn Sie das Diagramm verkleinern, können unter Umständen die darin enthaltenen Informationen unlesbar werden.  Solche unlesbare Informationen werden Ihnen in lesbarer Form gezeigt, wenn Sie den Mauszeiger darüber schweben lassen.<br /></li><li><b>Mehr Details</b><br />Wenn Sie in einer beliebigen Box klicken, erhalten Sie eine größere Box mit mehr Informationen.  Diese größere Box verschwindet, wenn Sie darin klicken.  Wenn Sie den Namen einer in der vergößerten Box genannten Person klicken, gelangen Sie zu der #pgv_lang[indi_info]# Seite.  Wenn Sie das <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> Ikon in der vergrößerten Box klicken, erhalten Sie ein neues Diagramm worin die jeweilige Person als Startperson gewählt ist.  Wenn Sie das <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> Ikon klicken, gelangen Sie zu dem Diagramm dieser Familie.<br /></li><li><b>Alle Partner zeigen</b><br />Das <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> Ikon direkt unter den Zoom-Buttons bestimmt, ob alle Partner oder Gatten und Kinder gezeigt werden sollen oder nicht.  Wenn nicht, dann sehen Sie nur das letzte Verhältnis und die daraus gezeugten Kinder.<br /></li><li><b>Großer Stammbaum</b><br />Sie können das Diagramm von vielen Seiten erreichen.  Zum Beispiel, im »Stammbaum« Ordner der  #pgv_lang[indi_info]# Seite oder im »Diagramm« Block der Hauptseite.  Wenn Sie den Stammbaum auf einer dieser anderen Seiten aufrufen, erhalten Sie auch ein Stammbaum-Ikon unter den Zoom-Buttons.  Wenn Sie das <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> Ikon klicken, erreichen Sie das interaktive Baumdiagramm.</li></ul>";

$pgv_lang["move_mediadirs_help"]		= "~#pgv_lang[move_mediadirs]#~<br /><br />Wenn die Medien-Feuerwand benutzt wird, können Medien-Dateien in einem Server-Verzeichnis aufbewahrt werden, das nicht über das Internet zugreifbar ist.<br /><br />Diese Buttons ermöglichen Ihnen, ganze Medien-Unterverzeichnisstrukturen zwischen dem geschützten (nicht Internet-zugreifbar) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> und dem normalen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Medien-Verzeichnis zu verlegen.";
$pgv_lang["setperms_help"]				= "~#pgv_lang[setperms]#~<br /><br />Diese Option stellt Schreib- und Lese-Rechte im geschützten <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> und normalen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Verzeichnis, und in allen Unterverzeichnissen.  Sie können zwischen <b>weltweit beschreibbar</b> und <b>schreibgeschützt</b> wählen.";
$pgv_lang["update_CHAN_text"] 			= "Verwalter müssen gelegentlich die von Benutzern übermittelten Daten reinigen und korrigieren. Beispielsweise müssen sie möglicherweise den PLAC-Standort korrigieren, um das Land anzugeben. Wenn Administratoren solche Korrekturen vornehmen, werden normalerweise Informationen über die ursprüngliche Änderung ersetzt. Dies ist möglicherweise nicht erwünscht.<br /><br />Wenn diese Option während der Bearbeitungs- oder Korrektursitzung des Verwalters gewählt wird, behält PhpGedView die ursprünglichen Änderungsinformationen, anstatt sie durch die der aktuellen Sitzung zu ersetzen.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Diese Option steuert die Anfangsstellung des Kästchens »#pgv_lang[no_update_CHAN]#«, das auf jeder Seite gezeigt wird, wo Verwalter Änderungen oder Korrekturen an der genealogischen Datenbank vornehmen können.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 		= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]		= "~#pgv_lang[source_events]#~<br /><br />Jede Quelle enthält Einträge über bestimmte Ereignisse, im Großen und Ganzen für bestimmte Daten- und Zuständigkeitsbereiche.  Zum Beispiel, jede Volkszählung die als Quelle zitiert werden kann enthält Einträge die man als »Volkszählung« Ereignisse in die Datenbank eintragen kann.  In kirchlichen Registern sind gewöhnlich Ereignisse wie Geburten, Ehen, und Tode aufgezeichnet.<br /><br />Aus der Liste wählen Sie Ereignisse die in dieser Quelle aufgezeichnet sind.  Als Datum gibt man gewöhnlich einen Bereich wie zum Beispiel <i>FROM 1900 TO 1910</i> (bedeutet <i>VON Anfang 1900 BIS Ende 1910</i>).  Bitte beachten Sie dass alle Daten in der englischen Sprache eingetragen werden müssen.  Als Zuständigkeitsbereich gibt man gewöhnlich eine Ortschaft.  Zum Beispiel, die Eingabe »Oneida, Idaho, USA« bedeutet dass diese Quelle für Ereignisse in allen Orten in Oneida County (Idaho, USA) zuständig ist, aber nicht für Ereignisse anderer Orte.  Die Eingabe »Idaho, USA« bedeutet dass diese Quelle für Ereignisse in allen Orten im Staat Idaho (USA) zuständig ist, aber nicht für Ereignisse anderswo.";
$pgv_lang["cache_life_help"]			= "~#pgv_lang[cache_life]#~<br /><br />Wegen Leistungsverbesserung wird der Inhalt dieses Blocks der PhpGedView Start-Seite als Cache-Datei gespeichert.  Sie können bestimmen, wie oft die Cache-Datei neu erstellt wird.<br /><ul><li><b>-1</b> bedeutet dass die Cache-Datei niemals automatisch neu erstellt wird.  Um eine Neuerstellung zu bewirken, müssen Sie auf der Seite, wo die Start-Seite angepasst wird, den <b>#pgv_lang[clear_cache]#</b> Button klicken.</li><li><b>0</b> (Null) bedeutet dass dieser Block nie als Cache-Datei vorkommt, und dass dieser Block auf der PhpGedView Start-Seite immer neu erstellt wird.  Diese Einstellung wird für manche Blöcke, deren Inhalt sich oft ändert, automatisch benutzt.  Beispiele solcher Blöcke sind #pgv_lang[logged_in_users_block]# und #pgv_lang[random_media_block]#.</li><li><b>1</b> (Eins) bedeutet dass der Block täglich neu erstellt wird, <b>2</b> bedeutet dass der Block alle zwei Tage neu erstellt wird, <b>7</b> bedeutet eine wchentliche Neuerstellung, usw.</li></ul>";
$pgv_lang["clear_cache_help"]			= "~#pgv_lang[clear_cache]#~<br /><br />Wegen Leistungsverbesserung sind einige Blöcke der PhpGedView Start-Seite im Index-Verzeichnis als Cache-Dateien gespeichert.  Diese Cache-Dateien werden normalerweise automatisch einmal am Tag neu erstellt.  Es kann jedoch vorkommen, dass Sie diese Dateien manuell neu erstellen möchten.<br /><br />Dieser Button ermöglicht eine manuelle Neuerstellung durch das Löschen der Dateien.";
$pgv_lang["import_options_help"] 		= "Sie können zusätzliche Optionen wählen, die die Dateneinfuhr beeinflussen.";
$pgv_lang["verify_gedcom_help"]			= "~#pgv_lang[verify_gedcom]#~<br /><br />Sie können das Hochladen und Importieren dieser GEDCOM-Datei fortsetzen oder abbrechen.";
$pgv_lang["add_gedcom_instructions"]	= "Bitte geben Sie einen Namen für diese neue GEDCOM-Datei ein.  Die neue GEDCOM-Datei wird im Verzeichnis #INDEX_DIRECTORY# erstellt.";
$pgv_lang["random_media_start_slide_help"]	= "~#pgv_lang[random_media_start_slide]#~<br /><br />Soll der »Diavortrag« automatisch nach dem Laden der Seite starten.<br /><br />Der »Diavortrag« ändert den Inhalt des Blocks ohne vorheriges Übertragen der Bilder vom Server und ohne volles Neuladen der Seite.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Sie können durch diese Option die Bild-Regler verbergen.<br /><br />Diese Regler ermöglichen die Darstellung eines neuen Zufallbildes oder das automatische Abspielen einer Reihe von Zufallbildern als »Diavortrag«. Der »Diavortrag« ändert den Inhalt des Blocks ohne vorheriges Übertragen der Bilder vom Server und ohne volles Neuladen der Seite.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Mit diesem Link können Sie eine neue Quelle in Ihre Datenbank einfügen ohne sie zugleich mit anderen Datensätzen als Quellenangabe zu verbinden.<br /><br />Die neue Quelle ist immer in Quellenlisten zu finden, aber ohne Verbindung zu einer Quellenangabe wird sie niemals in Diagrammen oder sonstwo gezeigt.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Mit diesem Link können Sie eine neue gemeinsame Bemerkung in Ihre Datenbank einfügen ohne sie zugleich mit anderen Datensätzen zu verbinden. Die neue Bemerkung ist immer in der Liste gemeinsamer Bemerke zu finden, aber ohne Verbindung zu einer Person, einer Familie, oder einem Ereignis wird sie niemals in Diagrammen oder sonstwo gezeigt.";
$pgv_lang["link_person_id_help"]		= "~#pgv_lang[label_local_id]#~<br /><br />In diesem Feld geben Sie die ID-Nummer der zu verbindenen Person ein (z.B. I100).";
$pgv_lang["link_gedcom_id_help"]		= "~#pgv_lang[label_gedcom_id]#~<br /><br />Hier können Sie eine andere Datenbank wählen, wo Informationen über die gewünschte Person zu finden sind.";
$pgv_lang["link_remote_site_help"]		= "~#pgv_lang[label_site]#~<br /><br />Hier geben Sie die Einträge die zum Zugriff zu einer fremden Datenbank notwendig sind.  Sie können die gewünschte Datenbank aus einer Liste von schon bekannten Datenbanken wählen.  Sie können auch die Daten zu einer bisher unbekannten Datenbank eingeben.<br /><br />Im Feld <b>#pgv_lang[label_site_url2]#</b> geben Sie das URL zum Zugriff auf die <i>web services description (WDSL)</i> Datei, die für PhpGedView den Zugriff zur fremden Datenbank beschreibt.  Folgend ist ein Beispiel für solches URL, wenn die fremde Datenbank auch mit PhpGedView unterstützt ist: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />Im Feld <b>#pgv_lang[label_gedcom_id]#</b> geben Sie das Datenbank-Kennzeichen das manche fremde Internet-Seiten erfordern.  Bei fremden PhpGedView Seiten ist das der Name der dortigen GEDCOM-Datei.<br /><br />Falls notwendig, geben Sie auch die Daten in die <b>#pgv_lang[label_username_id]#</b> und <b>#pgv_lang[label_password_id]#</b> Felder.";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Durch diese Option können Sie andeuten, ob die gewünschte Person in einer anderen Datenbank auf Ihrem Server zu finden ist, oder ob sie anderswo durch das Internet zugänglich ist.<br /><br />Wenn die gewünschte Person auf Ihrem Server zu finden ist, müssen Sie die zuständige Datenbank wählen, und die ID-Nummer der Person darin eingeben. Falls die Person nur durch das Internet zugänglich ist, müssen Sie das URL der fremden Internet Seite, sowohl den Namen der dortigen Datenbank und die ID-Nummer der Person darin, eingeben.";
$pgv_lang["link_remote_rel_help"]		= "~#pgv_lang[label_rel_to_current]#~<br /><br />Mit dieser Option können Sie die Beziehung zwischen der Person in der fremden Datenbank und der hiesigen Person andeuten.  Zum Beispiel, die Option <i>Vater</i> bedeutet dass die Person in der fremden Datenbank Vater der Person in dieser Datenbank ist.";
$pgv_lang["link_remote_help"]   		= "~#pgv_lang[link_remote]#~<br /><br />Diese Seite ermöglicht Ihnen, Verbindungen zwischen Personen dieser Datenbank und Personen in fremden Datenbanken herzustellen.  Die fremden Datenbanken müssen entweder über das Internet oder auf diesem Server von PhpGedView zugreifbar sein.<br /><br />Um solche Verbindung herzustellen, müssen Sie zuerst die Beziehung zwischen den beiden Personen andeuten.  Danach können Sie eine bereits bekannte fremde Datenbank wählen oder die Zugangsdaten zu der neuen fremden Datenbank eingeben.  Nachdem Sie die ID-Nummer der Person in der fremden Datenbank eingegeben haben, kann PhpGedView die notwendigen Daten der Person aus der fremden Datenbank übertragen.  Diese übertragene Daten werden <u>niemals</u> in die hiesige Datenbank eingefügt, sondern nur auf den jeweiligen Seiten, wo diese Person auftritt, gezeigt.  Da diese Daten nicht in der hiesigen Datenbank sesshaft sind, ist es auch nicht möglich sie zu bearbeiten.<br /><br />Das Hilfe-Link neben jedem Element der Seite gibt Ihnen mehr Auskunft über das Element.  Sie können sich auch an diese englische »Hilfe«-Seiten wenden: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />Der Name der Bibliothek, des Archivs oder eines anderen Repositorys, in dem das Quellmaterial gespeichert ist.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />Die Adresse dieser Bibliothek, dieses Archivs oder eines anderen Repositorys. Geben Sie die Adresse so ein, wie Sie sie auf einen Umschlag schreiben würden.<br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Adresse angeben möchten.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Die Telefonnummer dieser Bibliothek, dieses Archivs oder eines anderen Repositorys. Geben Sie die Nummer einschließlich Land und Vorwahl ein. Beispielsweise könnte eine Nummer in Deutschland +49 25859 56 76 89 und eine Nummer in den USA oder Kanada +1 888 555-1212 sein.<br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Telefonnummer angeben möchten.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />Die Faxnummer dieser Bibliothek, dieses Archivs oder eines anderen Repositorys. Geben Sie die Nummer einschließlich Land und Vorwahl ein. Beispielsweise könnte eine Nummer in Deutschland +49 25859 56 76 89 und eine Nummer in den USA oder Kanada +1 888 555-1212 sein.<br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Faxnummer angeben möchten.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />Die E-Mail-Adresse dieser Bibliothek, dieses Archivs oder eines anderen Repositorys. Geben Sie die E-Mail-Adresse ein. Beispiel: <b>name@hotmail.com</b><br /><br />Lassen Sie dieses Feld leer, wenn Sie keine E-Mail-Adresse angeben möchten.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />Die Internet-Homepage dieser Bibliothek, dieses Archivs oder eines anderen Repositorys. Geben Sie die Homepage-Adresse einschließlich http:// oder https:// ein. Beispiel: <b>https://www.phpgedview.net/</b><br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Homepage-Adresse angeben möchten.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />Eine Beschreibung oder Referenznummer, die zum Ablegen und Abrufen von Elementen aus den Beständen einer Bibliothek, eines Archivs oder eines anderen Repositorys verwendet wird. Informelle Repositorys verwenden normalerweise kein #factarray[CALN]# System.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Dies ist die ID-Nummer der Bibliothek, des Archivs oder eines anderen Depots, in dem das Quellmaterial gespeichert ist, auf das verwiesen wird. Der Titel des aktuellen Archivs wird unter der ID-Nummer gezeigt.<br /><br />Sie können die ID-Nummer des Archivs, wo dieses Quellenmaterial gespeichert ist, ändern. Um die Archivreferenz zu entfernen, machen Sie dieses Feld leer. Diese Aktion entfernt nicht den Archivdatensatz aus der Datenbank; nur die Referenz wird entfernt.<br /><br />Wenn Sie das gewünschte Archiv-ID direkt eingeben, muss dieser Archivdatensatz bereits in der Datenbank vorhanden sein. Sie können <b>#pgv_lang[find_repository]#</b> klicken, um die ID-Nummer eines vorhandenen Archivs nachzuschlagen. Klicken Sie <b>#pgv_lang[create_repository]#</b>, wenn Sie einen neuen Archivdatensatz eingeben müssen.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Wann und wo der Datensatz erstellt wurde. Bei veröffentlichten Werken umfasst dies Informationen wie den Veröffentlichungsort, den Namen des Herausgebers und das Erscheinungsjahr.<br /><br />Bei unveröffentlichten Werken sollte das Erstellungsdatum des Datensatzes und der Ort, an dem sie veröffentlicht wurden, angegeben werden. Zum Beispiel der Kreis und der Wohnsitzstaat einer Person, die eine Erklärung für eine Rente abgibt, oder die Stadt und der Wohnsitzstaat des Verfassers eines Briefes oder einer privaten Familiengeschichte.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />Die Person, Agentur oder Entität, die den Datensatz erstellt hat. Bei einer veröffentlichten Arbeit kann dies der Autor, Compiler, Transkribent, Abstraktor oder Herausgeber sein. Bei einer unveröffentlichten Quelle kann dies eine Person, eine Regierungsbehörde, eine kirchliche Organisation oder eine private Organisation usw. sein.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Dieses Feld wird normalerweise zum Aufzeichnen von Freiformtext verwendet, um diesen GEDCOM-Datensatz zu identifizieren. Beispielsweise kann es sich um eine Dateinummer innerhalb eines automatisierten oder manuellen Systems handeln, oder es kann sich um eine Seiten- und Positionsnummer in einem Stammbaum handeln.<br /></br />Wenn die GEDCOM-Konfiguration so eingestellt wurde, dass der Benutzer die automatisch generierte ID-Nummer für neue Personen überschreiben kann, wird diese überschreibende ID-Nummer hier eingegeben. In diesem Fall muss der Text den Regeln für ID-Nummern entsprechen. Gültige ID-Nummern dürfen nur die Buchstaben <b>A</b> bis <b>Z</b>, <b>a</b> bis <b>z</b>, Ziffern <b>0</b> bis <b>9</b>, sowie die besonderen Symbole <b>. : -</b> und <b>_</b> enthalten.<br /><br />Die Option, die die Verwendung der #factarray[REFN]# anstelle der automatisch generierten ID-Nummer ermöglicht, finden Sie in der GEDCOM-Konfiguration im Abschnitt Bearbeitungsoptionen.";
$pgv_lang["edit_ABBR_help"]				= "~#factarray[ABBR]#~<br /><br />Dieses Feld enthält die Abkürzung des Quellen-Titels.  Es wird zusammen mit dem vollen Quellen-Titel benutzt.  Gewöhnlich benutzt PhpGedView zuerst den vollen Titel und danach die hier eingegebene Abkürzung.<br /><br />Seite 62 des GEDCOM 5.5.1 Standards beschreibt dieses Feld so: »<i>This entry is to provide a short title used for sorting, filing, and retrieving source records.</i>« (Dieser Eintrag sorgt für einen kurzen Titel der dem Sortieren, Speichern, und Abfragen von Quellen dient.)<br /><br />Bei PhpGedView ist der Gebrauch von Titelabkürzungen nicht notwendig; bei anderen Programmen können diese Abkürzungen notwendig sein.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "In vielen Kulturen kommt es vor, dass Namen in einem dort üblichen Alphabet geschrieben werden, und dass die Namen auch einen Äquivalent in Lateinischen Buchstaben haben.<br /><br />Falls Sie die normalen Namensfelder benutzen um Namen in Alphabeten wie Hebräisch, Griechisch, Russisch, Chinesisch oder Arabisch einzugeben, können Sie die Namensäquivalente in Lateinischen Buchstaben in diesem Feld eingeben.  Beide Werte sind dann in Listen und Diagrammen sichtbar.<br /><br />Obwohl dieses Feld »#factarray[ROMN]#« genannt ist, ist es nicht für die Eingabe von Lateinischen Buchstaben reserviert.  Das heißt, Sie können hier auch Japanische oder andere Ihnen beliebige Buchstaben eintragen.";
$pgv_lang["edit_ROMN_GIVN_help"]		= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />In dieses Feld geben Sie die Vornamen.  Die Vornamen von »John Robert Finlay Jr.«, die hier eingeben werden sollen sind <b>John Robert</b>.";
$pgv_lang["edit_ROMN_SURN_help"]		= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />In dieses Feld geben Sie den Nachnamen.  Der Nachname von »John Robert Finlay Jr.«, der hier eingeben werden soll ist <b>Finlay</b>.<br /><br />Personen mit mehreren Familiennamen, wie in Spanien und Portugal oft der Fall ist, sollen mit Komma zwischen den Familiennamen eingetragen werden.  Zum Beispiel, der Eintrag »Cortes,Vega« wird in Nachnamenslisten unter <b>C</b> und <b>V</b> gezeigt, während der Eintrag »Cortes Vega« nur unter <b>C</b> gezeigt wird.";
$pgv_lang["edit__HEB_help"]			= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "In vielen Kulturen kommt es vor, dass Namen in einem dort üblichen Alphabet geschrieben werden, und dass die Namen auch einen Äquivalent in Lateinischen Buchstaben haben.<br /><br />Falls Sie die normalen Namensfelder benutzen um Namen im Lateinischen Alphabet einzugeben, können Sie die Namensäquivalente in Alphabeten wie Hebräisch, Griechisch, Russisch, Chinesisch oder Arabisch in diesem Feld eingeben.  Beide Werte sind dann in Listen und Diagrammen sichtbar.<br /><br />Obwohl dieses Feld »#factarray[_HEB]#« genannt ist, ist es nicht für die Eingabe von Hebräischen Buchstaben reserviert.  Das heißt, Sie können hier auch Japanische oder andere Ihnen beliebige Buchstaben eintragen.";
$pgv_lang["edit__HEB_GIVN_help"]	= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />In dieses Feld geben Sie die Vornamen.  Die Vornamen von »John Robert Finlay Jr.«, die hier eingeben werden sollen sind <b>John Robert</b>.";
$pgv_lang["edit__HEB_SURN_help"]	= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />In dieses Feld geben Sie den Nachnamen.  Der Nachname von »John Robert Finlay Jr.«, der hier eingeben werden soll ist <b>Finlay</b>.<br /><br />Personen mit mehreren Familiennamen, wie in Spanien und Portugal oft der Fall ist, sollen mit Komma zwischen den Familiennamen eingetragen werden.  Zum Beispiel, der Eintrag »Cortes,Vega« wird in Nachnamenslisten unter <b>C</b> und <b>V</b> gezeigt, während der Eintrag »Cortes Vega« nur unter <b>C</b> gezeigt wird.";
$pgv_lang["edit_SEX_help"]				= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]				= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Hier können Sie eine allein stehende Person eintragen.<br /><br />Alleinstehende Personen sind am Anfang mit keinen anderen Personen verbunden.  Später, wenn Sie mehr über die Verwandtschaft dieser Person wissen, können Sie sie mit einer anderen Person über den #pgv_lang[relatives]# Ordner der #pgv_lang[indi_info]# Seite verbinden.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Geben Sie die URL-Adresse einschließlich http:// ein. Beispiel: <b>http://www.phpgedview.net/</b><br /><br />Lassen Sie dieses Feld leer, wenn Sie keine URL einfügen möchten.";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Geben Sie die Adresse der Web-Homepage einschließlich http:// ein. Beispiel: <b>http://www.phpgedview.net/</b><br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Web-Homepage-Adresse angeben möchten.";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Geben Sie die E-Mail-Adresse ein. Beispiel: <b>name@hotmail.com</b><br /><br />Lassen Sie dieses Feld leer, wenn Sie keine E-Mail-Adresse angeben möchten.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Geben Sie die Faxnummer einschließlich Land und Vorwahl ein. Beispielsweise könnte eine Nummer in Deutschland +49 25859 56 76 89 und eine Nummer in den USA oder Kanada +1 888 555-1212 sein.<br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Faxnummer angeben möchten.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Geben Sie die Telefonnummer einschließlich Land und Vorwahl ein. Beispielsweise könnte eine Nummer in Deutschland +49 25859 56 76 89 und eine Nummer in den USA oder Kanada +1 888 555-1212 sein.<br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Telefonnummer angeben möchten.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Geben Sie die Adresse so ein, wie Sie sie auf einem Umschlag schreiben würden.<br /><br />Lassen Sie dieses Feld leer, wenn Sie keine Adresse angeben möchten.";
$pgv_lang["edit_GIVN_help"]				= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]				= "~#factarray[SPFX]#~<br /><br />Sie können Wörter eingeben oder wählen, die vor dem Hauptteil des Nachnamens genannt werden.  Zum Beispiel: <b>von</b> Braun, <b>auf der</b> Maur, <b>van der</b> Kloot, <b>de</b> Graaf, usw.<br /><br />Hier kann unter Umständen ein Adelstitel eingetragen werden. Zum Beispiel, Peter <b>Freiherr von</b> Irgendwo. Der Teil »Freiherr« ist eigentlich ein Adelstitel und sollte als Faktum #factarray[TITL]# nicht wiederholt werden. Was hier eingetragen wird, hängt stark von den Vorlieben der jeweiligen Person ab.";
$pgv_lang["edit_SURN_help"]				= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]			= "~#factarray[_MARNM]#~<br /><br />Geben Sie wahlweise den Ehenamen dieser Person.  Die Eingaberegeln sind denen des normalen Namens gleich.<br /><br />Zum Beispiel, wenn Maria Elisabet Braun nach ihrer Ehe mit Hans Georg Fischer ihren Namen ändert, könnte diese Eingabe (natürlich ohne Hochkommata) so sein:<ul><li>Amerikanische Gewohnheit:&nbsp;&nbsp;\"Maria Elisabet Braun /Fischer/\"</li><li>Europäische Gewohnheit:&nbsp;&nbsp;\"Maria Elisabet /Fischer/\"</li><li>Alternative Europäische Gewohnheit:&nbsp;&nbsp;\"Maria Elisabet /Braun-Fischer/\" oder \"Maria Elisabet /Fischer-Braun/\"</li></ul>Sie sollten dies nur tun, wenn Maria Braun sich nach ihrer Ehe mit dem neuen Namen zu nennen begann. In manchen Ländern (z.B. Quebec, Kanada) ist jede Änderung der Namen durch die Ehe verboten.<br /><br />Gewöhnlich ändert die Frau ihren Namen, aber manchmal ist es der Mann.";
$pgv_lang["edit_PEDI_help"]				= "~#factarray[PEDI]#~<br /><br />Dieses Feld beschreibt die Beziehung des Kindes zu seiner Familie.  Folgende Wahlen sind möglich:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Die Beziehung des Kindes zu seiner Familie ist unbestimmt.  Mit dieser Wahl wird das #factarray[PEDI]# Feld nicht in die Datenbank eingetragen.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Diese Option bedeutet dass das Kind in die Familie geboren wurde.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Diese Option bedeutet dass das Kind in die Familie adoptiert wurde.  Man kann aber <i>nicht</i> dadurch schließen, dass das Kind nicht direkt mit seinen Eltern verwandt ist; diese Wahl bedeutet lediglich dass das Kind nach seiner Geburt von der Familie adoptiert wurde.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Das Kind ist ein Pflegekind der Familie.  Gewöhnlich sind Pflegekinder nicht direkt mit der Familie verwandt.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Das Kind wurde durch eine HLT <i>Siegelung</i> Zeremonie zu seiner Familie versiegelt.  Kinder-Siegelungen werden vorgenommen, wenn seine Eltern nach dessen Geburt zueinander versiegelt sind.  Kinder, die nach der Siegelung der Eltern geboren werden, sind automatisch zu der Familie versiegelt.</li></ul>";
$pgv_lang["edit_AGNC_help"]				= "~#factarray[AGNC]#~<br /><br />Zuständige Organisation, Behörde, Person, Unternehmen, usw.<br /><br />Z.B., Arbeitgeber der Person, oder Kirche wo das Ereignis stattfand, oder für Urkunden zuständige Behörde.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />In diesem Feld wird die Art der Verbindung beschrieben, durch die die Familie entstanden wurde.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;bedeutet, dass die Zeremonie, die die Verbindung zweier Personen zu einer Familie formalisierte, von einem Priester, Bischof, Kardinal, Prediger, Rabbiner, Schamanen oder einer ähnlichen Person durchgeführt wurde. Die Zeremonie könnte nicht nur in einer Kirche, Synagoge, einem Tempel oder einem anderen geweihten Ort stattgefunden haben. Sie könnte auch im Freien oder in einer privaten Wohnung stattgefunden haben.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;bedeutet, dass die Zeremonie, die die Verbindung zweier Personen zu einer Familie formalisierte, von einem Richter, Magistrat, Bürgermeister oder einer ähnlichen Autoritätsperson, die kein Priester usw. ist, durchgeführt wurde. Die Autorität zur Durchführung solcher Zeremonien wird normalerweise von einer Regierung erteilt. Es ist nicht nötig, dass die Zeremonie in einem Gerichtssaal, Standesamt, oder Büro statt fand.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;beschreibt die Beziehung zwischen zwei Personen, die nicht miteinander verheiratet sind, sich aber so verhalten, als wären sie eine Familie. Sie haben <u>nicht</u> an einer Trauungszeremonie teilgenommen, die von einem Priester, Bischof, Richter, Bürgermeister oder einer anderen Person mit der Autorität, Trauungen durchzuführen, durchgeführt wurde. Sie haben möglicherweise öffentlich erklärt, dass sie sich als verheiratet betrachten, aber dieses ist keine Voraussetzung.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;bedeutet, dass die Einzelheiten der Verbindung zweier Personen zur Gründung einer Familie nicht bekannt sind.</li></ul>";

$pgv_lang["context_help"]				= "Mehr Informationen zu diesen Themen ist durch das Klicken des <b>#pgv_lang[qm]#</b> neben den jeweiligen Einträgen erhältlich.";

$pgv_lang["register_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Jede Person in dieser Datenbank hat seine eigene Identifikations-Nummer (ID-Nummer).  Falls Ihre ID-Nummer Ihnen schon bekannt ist, können Sie sie hier eintragen.  Wenn Sie sie nicht wissen und eine Suche nach ihr erfolglos ist, geben Sie bitte im Kommentarfeld genügend Informationen dass der Verwalter diese ID-Nummer für Sie hier eingeben kann.";
$pgv_lang["register_comments_help"]		= "~#pgv_lang[comments]#~<br /><br />Bitte benutzen Sie dieses Feld um dem Verwalter mitzuteilen warum Sie einen Zugangsantrag machen und wie Sie mit diesem Stammbaum verbunden sind.  Sie können hier auch andere Bemerke machen, die Sie dem Verwalter mitteilen möchten.";
$pgv_lang["utf8_ansi_help"]				= "~#pgv_lang[utf8_to_ansi]#~<br /><br />PhpGedView benutzt intern den UTF-8 Zeichensatz, der das Bearbeiten von Texten in fast allen Sprachen der Welt ermöglicht.  Einige Programme, wie zum Beispiel Family Tree Maker, haben überhaupt keine Unterstützung für den UTF-8 Zeichensatz.  Wenn Sie diese Option ankreuzen, wandelt PhpGedView die Ausgabe-Datei in den <b>ANSI (ISO 8859-1)</b> Zeichensatz um.<br /><br />Ob die Ausgabe-Datei so konvertiert werden muss kommt darauf an, ob das Ziel-Programm den UTF-8 Zeichensatz unterstützt.  Im Fragefall müssen Sie sich an die Dokumentation des Programmes wenden.<br /><br />Bitte beachten Sie dass manche besondere Zeichen nicht im ANSI (ISO 8859-1) Zeichensatz vorhanden sind und Sie deshalb den UTF-8 Ausgangszeichensatz behalten sollten.  In diesem Fall müssen Sie auch eine andere Methode finden, die besonderen Zeichen in das andere Programm einzugeben.  Sie müssen sich wahrscheinlich auch an den Hersteller Ihres Programmes wenden.<br /><br />Ausführliche Informationen über UTF-8 können Sie in diesem <a href='https://de.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia Eintrag'><b>Wikipedia Eintrag</b></a> finden.";
$pgv_lang["remove_tags_help"]			= "~#pgv_lang[remove_custom_tags]#~<br /><br />Wenn diese Option angekreuzt ist, werden alle Tags die speziell für PhpGedView erdacht sind und nicht dem GEDCOM-Standard entsprechen, aus der Ausgangsdatei entfernt.<br /><br />Beispiele solcher Tags sind <b>_PGVU</b> wodurch der PhpGedView-Nutzer, der die letze Änderung dieses Datensatzes vorgenommen hat, bestimmt werden kann und <b>_THUM</b> wodurch PhpGedView erkennt dass dieses Bild auch als Miniaturbild benutzt werden soll.<br /><br />Wenn die Ausgangsdatei solche nicht dem Standard entsprechende Tags enthält kann sie womöglich für andere Programme ungültig sein.";
$pgv_lang["download_zipped_help"]		= "~#pgv_lang[zip_files]#~<br /><br />Diese Option ist besonders nützlich wenn große GEDCOM-Dateien übertragen werden sollen.  Wenn diese Option angekreuzt ist, erstellt PhpGedView vor dem Übertragen der GEDCOM-Datei eine komprimierte Version im ZIP-Format.  Die komprimierte Version, die gewöhnlich mindestens 75% kleiner ist, wird dann übertragen.  Das Komprimieren hat den Vorteil dass die Dateigröße wesenhaft geringer ist.  Der Nachteil ist dass die komprimierte Datei zuerst mit einem geeigneten Programm wie WinZip oder 7-Zip bearbeitet werden muss so dass sie für normale Programme gültig wird.<br /><br />Es besteht immer die Möglichkeit, dass bei unkomprimierten großen Dateien die maximale Laufzeit überschritten wird und die Übertragung deshalb vorzeitig abgebrochen wird.";
$pgv_lang["edit_NCHI_help"]				= "~#factarray[NCHI]#~<br /><br />Geben Sie hier wahlweise die Anzahl der Kinder dieser Person oder dieser Familie.";
$pgv_lang["edit_TIME_help"]				= "~#factarray[TIME]#~<br /><br />Geben Sie hier die Tageszeit, im 24-Std. Format, des Ereignisses ein.  Beispiele:  04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]				= "~#factarray[NOTE]#~<br /><br />Notizen haben kein bestimmtes Format.  Sie werden als Einzelheiten der jeweiligen Rubrik gezeigt.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Genau wie gewöhnliche Bemerke, haben gemeinsame Bemerke kein bestimmtes Format.  Jede gemeinsame Bemerkung kann mit mehreren Personen, Familien, Quellen, und Fakten verbunden werden.";
$pgv_lang["edit_CEME_help"]				= "~#factarray[CEME]#~<br /><br />Geben Sie hier den Namen des Friedhofs ein, wo diese Person beerdigt ist.";
$pgv_lang["edit_ASSO_help"]				= "~#factarray[ASSO]#~<br /><br />Geben Sie die GEDCOM-ID Nummer der Person ein, deren Zusammenhang zur aktuellen Person Sie beschreiben möchten.";
$pgv_lang["edit_RELA_help"]				= "~#factarray[RELA]#~<br /><br />Wählen Sie den entsprechenden #factarray[RELA]# aus der Liste. Die Wahl <b>#pgv_lang[godfather]#</b> bedeutet: <i>Die im Feld #factarray[ASSO]# identifizierte Person ist #pgv_lang[godfather]# der aktuellen Person</i>.";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Standardmäßig zeigt dieses Diagramm keine Gatten.  Gatten werden normalerweise nicht gezeigt weil das das Lesen und Verstehen des Diagramms erschwert.  Bei angekreuzter Option werden Gatten in diesem Diagramm sichtbar.";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Familien im #pgv_lang[relatives]# Ordner sind in der selben Reihenfolge sichtbar wie sie im GEDCOM Datensatz dieser Person vorkommen. Standardmäßig werden Familien nicht nach den Ehedaten sortiert da oft nur die Reihenfolge der Ehen bekannt ist.<br /><br />Diese Option ermöglicht Ihnen, die Reihenfolge der Ehen zu bestimmen.  Falls Sie die Ehen nach deren Daten sortieren möchten, können Sie den dafür gedachten Button klicken.";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Wenn PhpGedView erkennt, dass die Einfuhr der GEDCOM-Datei mehr Zeit benötigt als von der Zeitbeschränkung erlaubt ist, wird Ihnen der <b>#pgv_lang[del_proceed]#</b> Button gezeigt.  Sie müssen dann diesen Button klicken um die unterbrochene Einfuhr fortzusetzen.<br /><br />Wenn die Option auf <b>#pgv_lang[yes]#</b> gestellt ist, wird dieser Button automatisch geklickt.  Das vermeidet langweiliges Button-Klicken.";
$pgv_lang["firstname_i_help"]			= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Dieser Nachname hat mehr als #GLOBALS[SUBLIST_TRIGGER_I]# Einträge.<br /><br />Um das Finden des gewünschten Eintrages zu erleichtern, wurde die Liste in kleinere Listen, nach dem Anfangsbuchstaben des jeweiligen Vornamens, aufgeteilt. Diese unterstellten Listen funktionieren genau wie die Hauptlisten.<ul><li>Sie klicken einen der Buchstaben, und die Liste der mit diesem Buchstaben anfangende Vornamen wird dann sichtbar.</li><li>Falls Sie <b>#pgv_lang[PN]#</b> klicken, sehen Sie alle Einträge mit unbekanntem Vornamen.</li><li>Das Klicken auf <b>#pgv_lang[all]#</b> erzeugt eine Liste aller Personen mit dem vorher gewählten Nachnamen, ohne Rücksicht auf Vornamen.</li></ul>";
$pgv_lang["firstname_f_help"]			= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Dieser Familienname hat mehr als #GLOBALS[SUBLIST_TRIGGER_F]# Einträge.<br /><br />Um das Finden des gewünschten Eintrages zu erleichtern, wurde die Liste in kleinere Listen, nach dem Anfangsbuchstaben des jeweiligen Vornamens, aufgeteilt. Diese unterstellten Listen funktionieren genau wie die Hauptlisten.<ul><li>Sie klicken einen der Buchstaben, und die Liste der mit diesem Buchstaben anfangende Vornamen wird dann sichtbar.</li><li>Falls Sie <b>#pgv_lang[PN]#</b> klicken, sehen Sie alle Einträge mit unbekanntem Vornamen.</li><li>Das Klicken auf <b>#pgv_lang[all]#</b> erzeugt eine Liste aller Familien mit dem vorher gewählten Namen, ohne Rücksicht auf Vornamen.</li></ul>";
$pgv_lang["edit_TYPE_help"]				= "~#factarray[TYPE]#~<br /><br />In diesem Feld können Sie zusätzliche Informationen eingeben.  Meistens ist dieses Feld ohne vorgesetzes Format; Sie können eingeben was und wie Sie wollen.";
$pgv_lang["edit_TEMP_help"]				= "~#factarray[TEMP]#~<br /><br />Dieses Feld dokumentiert den Tempel wo HLT-Verfügungen vorgenommen wurden.";
$pgv_lang["edit_STAT_help"]				= "~#factarray[STAT]#~<br /><br />Dieses Feld dokumentiert den Status der HLT-Verfügungen.";
$pgv_lang["edit__PRIM_help"]			= "~#factarray[_PRIM]#~<br /><br />Dieses Feld deutet an dass das Medien-Objekt als primäres Objekt der verbundenen Person benutzt werden soll.  Als primäres Objekt wird das Bild dann auf der #pgv_lang[personal_facts]# Seite und auf allen Diagrammen benutzt.";
$pgv_lang["edit__THUM_help"]			= "~#factarray[_THUM]#~<br /><br />Diese Option ermöglicht Ihnen die normale Miniaturbild-Wahl vorübergehend abzuschalten.<br /><br />In der GEDCOM-Konfiguration ist eine Option vorhanden, die bestimmt, ob PhpGedView kleine oder große Bilder dem Browser zur Darstellung übermitteln soll.  Die »#factarray[_THUM]#« Option, wenn auf <b>#pgv_lang[yes]#</b> gestellt, bestimmt dass PhpGedView dieses Mal immer das große Bild verwenden soll, ohne Rücksicht auf die Bestimmung der GEDCOM-Konfiguration.  Es ist nicht möglich, PhpGedView zu veranlassen, Miniaturbilder zu übermitteln wenn die GEDCOM-Konfiguration bestimmt, dass immer große Bilder verwendet werden sollen.<br /><br />PhpGedView ändert niemals die Größe der übermittelten Bilder; das geschieht im Browser nachdem er das Bild und die Beschreibung der zu darstellenden Seite empfangen hat.  Es besteht immer die Möglichkeit, dass die dargestellte Seite falsch aussieht, wenn das übermittelte Miniaturbild zu groß ist.  Dies ist kein Fehler:  Es kann durchaus vorkommen, dass der Verwalter manchmal ein großes Bild zeigen möchte, wo man normalerweise ein Miniaturbild erwartet.<br /><br />Sie sollten vermeiden, die »#factarray[_THUM]#« Option auf <b>#pgv_lang[yes]#</b> zu stellen.  Diese Wahl verursacht die Übermittlung großer Dateien, wovon die meisten Daten nachher vom Browser verworfen werden müssen.  Das Laden von Diagrammen mit vielen Bildern wird so unnötig verzögert.";
$pgv_lang["edit_TITL_help"]				= "~#factarray[TITL]#~<br /><br />Geben Sie den Titel des Objekts das Sie bearbeiten.  Bei Multimedia-Objekten sollte der Titel das Objekt beschreiben.<br /><br />Wenn Sie Details einer Person bearbeiten, wird dieses Feld benutzt, um Adelsinformationen wie <i>Sir, Lord, Baron, Earl, Duke, Graf, Freiherr,</i> usw. einzugeben.<br /><br />Berufsbezeichnungen wie <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> etc. sollten im Unterfeld »#factarray[NPFX]#« eingetragen werden, während Namenszusätze wie <i>Jr., Sr., III, IV,</i> etc. und akademische Informationen wie <i>PhD, PEng, FImechE, DVM, MD,</i> etc. in das Unterfeld »#factarray[NSFX]#« gehören.";
$pgv_lang["edit_FILE_help"]				= "~#factarray[FILE]#~<br /><br />Dieses ist der wichtigste Eintrag des Multimedia Datensatzes.  Sie müssen mindestens den Dateinamen eingeben. Wenn andere Einstellungen es erlauben, können Verzeichnisnamen auch hilfreich sein.<br /><br />Sie können mit <b>#pgv_lang[find_media]#</b> nach Medien-Objekten suchen, die sich schon auf dem Server befinden.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]				= "~#factarray[FORM]#~<br /><br />Wenn Sie es möchten, können Sie hier den Datentyp des Multimedia Objektes eintragen.  Manche Programme (aber nicht PhpGedView) ermitteln durch diesen Eintrag wie das Objekt bearbeitet werden muss.  Die Richtigkeit des Eintrages ist für PhpGedView nicht wichtig.";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />PhpGedView hat festgestellt, dass Miniaturbilder automatisch erstellt werden können. Möglicherweise werden BMP, GIF, JPG, und PNG Dateien unterstützt. Die unterstützten Medientypen sind neben der Box angegeben.<br /><br />Das Ankreuzen dieser Option teilt dem Programm mit, dass beim Übertragen dieser Medientypen auch Miniaturbilder automatisch angefertigt werden sollen. Wenn nicht angekreuzt, nimmt das Programm an, dass Sie Ihre eigenen Miniaturbilder auf den Server übertragen möchten.";
$pgv_lang["edit_add_NOTE_help"]			= "~#pgv_lang[add_note]#~<br /><br />Hier ist es möglich, einen neuen Bemerk an diesen Fakt anzuschließen.  Bemerke sind ohne festgestelltes Format; Sie können eingeben was und wie Sie wollen.  Bemerke sind in der »Details« Spalte des betroffenen Faktes sichtbar.";
$pgv_lang["edit_add_SHARED_NOTE_help"]	= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Wie gewöhnliche Bemerke, sind gemeinsame Bemerke einfacher Text ohne besonderes Format.  Im Gegenteil zu gewöhnlichen Bemerke, kann jede gemeinsame Bemerkung mit mehr als einer Person, Familie, Quelle, usw. verbunden sein.<br /><br />Wenn Sie das richtige Ikon klicken, können Sie eine Verbindung zu einer bereits bestehenden gemeinsamen Bemerkung herstellen oder eine neue gemeinsame Bemerkung erstellen und auch gleichzeitig die Verbindung dazu herstellen.  Falls solche Verbindung bereits vorhanden ist, können Sie den Text der gemeinsamen Bemerkung bearbeiten und ändern.<br /><ul><li><b>Verbindung herstellen</b><div style=\"padding-left:20px;\">Wenn das ID der gewünschten gemeinsamen Bemerkung Ihnen bekannt ist, können Sie diese Nummer direkt in das Feld eingeben.<br /><br />Wenn Sie das <b>#pgv_lang[find_shared_note]#</b> Ikon klicken, können Sie den Text aller gemeinsamen Bemerke durchsuchen und dann eine davon wählen.  Die ID Nummer der gewählten Bemerkung wird dann automatisch in das Feld eingegeben.<br /><br />Sie müssen den <b>#pgv_lang[add]#</b> Button klicken, dass der ursprüngliche Datensatz aktualisiert wird.</div><br /></li><li><b>Neue Bemerkung erstellen</b><div style=\"padding-left:20px;\">Wenn Sie das <b>#pgv_lang[create_shared_note]#</b> Ikon klicken, öffnet sich ein Formular.  Sie können darin den Text der neuen gemeinsamen Bemerkung eingeben wie Sie möchten.  Wie bei gewöhnlichen Bemerke, können Sie auch URL-Adressen eingeben.<br /><br />Nachdem Sie den <b>#pgv_lang[save]#</b> Button klicken, erhalten Sie eine Notiz mit der ID-Nummer der neuen Bemerkung.  Um das Fenster zu schließen und die ID-Nummer in das Eingabefeld zu kopieren, sollten Sie auf dieser Notiz klicken.  Wenn Sie nur das Fenster schließen, wird die neue ID-Nummer nicht automatisch in das Eingabefeld kopiert.<br /><br />Sie müssen danach noch den <b>#pgv_lang[add]#</b> Button klicken, um den ursprünglichen Datensatz zu aktualisieren.</div><br /></li><li><b>Bemerkung bearbeiten</b><div style=\"padding-left:20px;\">Wenn Sie das <b>#pgv_lang[edit_shared_note]#</b> Ikon klicken, öffnet sich ein Formular.  Sie können den Text der bestehenden Bemerkung ändern wie Sie möchten.  Wie bei gewöhnlichen Bemerke, können Sie auch URL-Adressen eingeben.<br /><br />Nachdem Sie den <b>#pgv_lang[save]#</b> Button klicken, wird der Text der gemeinsamen Bemerkung aktualisiert.  Sie können dann das Fenster schließen und danach den <b>#pgv_lang[save]#</b> Button noch einmal klicken.<br /><br />Wenn Sie den Text einer gemeinsamen Bemerkung ändern, wird Ihre Änderung sofort in allen damit verbundenen Datensätzen sichtbar.  Der selbe geänderte Text wird auch in neu verbundenen Datensätzen sichtbar.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~Der GEDFact Assistent~<br /><br />Wenn Sie das »+« Ikon klicken, öffnet sich ein Fenster worin Sie die gemeinsame Bemerkung mit Hilfe des GEDFact Assistenten bearbeiten können. Gezielte Hilfe Themen sind dort zu finden.<br /><br />Wenn Sie den »Speichern« Button klicken, wird die ID-Nummer der eben bearbeiteten gemeinsamen Bermerkung hier eingefügt.";
$pgv_lang["edit_add_SOUR_help"]			= "~#pgv_lang[add_source]#~<br /><br />Hier ist es möglich, ein neues Quellenzitat an diesen Fakt anzuschließen.  Im »Quelle« Feld geben Sie die ID-Nummer der Quelle ein.  Falls die zitierte Quelle noch nicht in der Datenbank eingetragen ist, können Sie <b>#pgv_lang[create_source]#</b> klicken.  Sie können auch nach der zu zitierenden Quelle suchen.  Im #factarray[PAGE]# Feld geben Sie die Seite oder Details die Anderen das Finden dieses Zitats in der angedeuteten Quelle erleichtern.  Im #factarray[TEXT]# Feld können Sie, wenn notwending, das eigentliche Zitat oder eine Beschreibung des Zitates als Text eingeben.";
$pgv_lang["edit_add_ASSO_help"]			= "~#pgv_lang[add_asso]#~<br /><br />Diese Option ermöglicht Ihnen, eine Beziehung zwischen diesem Fakt und einer anderen Person zu erstellen.  Sie können, zum Beispiel, bezeichnen dass die andere Person Pate dieser Person ist.";
$pgv_lang["edit_QUAY_help"]				= "~#factarray[QUAY]#~<br /><br />Dieses Feld dokumentiert die Qualität oder Zuverlässigkeit der Informationen dieser Quelle. Viele Programme erfordern hier eine Nummer. <b>3</b> kann bedeuten dass die Quelle völlig zuverlässig ist, <b>2</b> kann bedeuten dass die Quelle nicht ganz völlig zuverlässig ist, <b>1</b> kann bedeuten dass die Informationen nicht ganz völlig zuverlässig sind, <b>0</b> kann bedeuten dass die Quelle unzuverlässig ist.";
$pgv_lang["edit_PAGE_help"]				= "~#factarray[PAGE]#~<br /><br />Im #factarray[PAGE]# Feld geben Sie die Seite oder Details die Anderen das Finden dieses Zitates in der erwähnten Quelle erleichtert.";
$pgv_lang["edit_TEXT_help"]				= "~#factarray[TEXT]#~<br /><br />Im #factarray[TEXT]# Feld können Sie, wenn notwending, das eigentliche Zitat oder eine Beschreibung des Zitates als Text eingeben.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Dies ist die ID-Nummer der Quelle für dieses Faktum. Der Titel der aktuellen Quelle wird unter der ID-Nummer gezeigt.<br /><br />Sie können die ID-Nummer des Quellendatensatzes ändern, auf den sich die Quellenangabe dieses Faktums bezieht. Machen Sie dieses Feld leer, um das gesamte Zitat zu entfernen. Diese Aktion entfernt nicht den Quellendatensatz aus der Datenbank; nur dieser Verweis wird entfernt.<br /><br />Wenn Sie die gewünschte Quellen-ID direkt eingeben, muss dieser Quellendatensatz bereits in der Datenbank vorhanden sein. Sie können <b>#pgv_lang[find_sourceid]#</b> klicken, um die ID-Nummer eines vorhandenen Quellendatensatzes nachzuschlagen. Klicken Sie <b>#pgv_lang[create_source]#</b> wenn Sie einen neuen Quellendatensatz eingeben müssen.";
$pgv_lang["edit_edit_raw_help"]			= "~#pgv_lang[edit_raw]#~<br /><br />Hier können Sie den rohen GEDCOM Datensatz bearbeiten.  Sie sollten das aber mit Vorsicht tun; falls Sie den GEDCOM 5.5.1 Standard nicht völlig verstehen, wäre es besser diese besondere Bearbeitung zu unterlassen.  Der erwähnte Standard wird kurz im »Hilfe« Thema <b>GEDCOM Datei</b> beschrieben.  Dieses Thema had auch ein Link zur englischen Version des Standards.<br /><br />PhpGedView unterstützt viele verschiedene Methoden die zum Bearbeiten oder Hinzufügen von Informationen dienen, aber es gibt auch Fälle wo das Bearbeiten durch direkten Eingriff im GEDCOM Datensatz leichter voran geht.  Ihnen wird strengstens geraten, wenn möglich, die dafür erdachten Bearbeitungs-Seiten zu benutzen. Nachdem Sie den »#pgv_lang[save]#« Button geklickt haben, wird die Übereinstimmung Ihrer Eingaben mit dem GEDCOM-Standard geprüft, und dann wird noch ein neuer CHAN Datensatz hinzugefügt.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView hat die Möglichkeit, bis zu 10 Fakten, mit allen Details, einzeln in eine Zwischenablage zu kopieren. Diese Zwischenablage unterscheidet sich vom Sammelbehälter, den Sie zum exportieren von Datensätzen aus Ihrer Datenbank benutzen.<br /><br />Sie können beliebige Fakten aus der Zwischenablage wählen, um sie einzeln dem aktuellen Datensatz hinzuzufügen.  Fakten können aber nur ihren richtigen Datensätzen hinzugefügt werden.  Das heisst, zum Beispiel, dass Ehen nicht Personen oder Quellen hinzugefügt werden können;  Ehen sind immer nur mit Familien verbunden.<br /><br />Sie können so die gleichen Fakte leicht mehreren Datensätzen hinfügen.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Orte sollten gemäß den Standards für Genealogie eingegeben werden. In der Genealogie werden Orte zuerst mit den spezifischsten Informationen über den Ort aufgezeichnet und dann bis zum am wenigsten spezifischen Ort zuletzt, wobei die verschiedenen Ortsstufen durch Kommas getrennt werden. Die Ebene, auf der Sie die Ortsinformationen aufzeichnen, sollte die Ebene der Regierung oder der Kirche darstellen, auf der wichtige Aufzeichnungen für diesen Ort aufbewahrt werden.<br /><br />Beispielsweise würde ein Ort wie Salt Lake City als »Salt Lake City, Salt Lake, Utah, USA« eingegeben.<br /><br />Lasst uns jeden Teil dieses Ortes untersuchen. Der erste Teil, »Salt Lake City«, ist die Stadt oder Gemeinde, wo das Ereignis stattfand. In einigen Ländern kann es innerhalb einer Stadt Gemeinden oder Bezirke geben, die zu beachten sind. In diesem Fall sollten diese vor der Stadt erwähnt werden. Der nächste Teil, »Salt Lake«, ist der Bezirk oder Kreis. »Utah« ist der Staat und »USA«, das Land.Es ist wichtig, jeden Ort zu notieren, da die Regierungen jeder Ebene genealogische Aufzeichnungen führen könnten.<br /><br />Wenn eine Ebene des Ortes unbekannt ist, sollten Sie ein Leerzeichen zwischen den Kommas lassen. Angenommen, im obigen Beispiel ist der Kreis für Salt Lake City unbekannt.Sie sollten es dann wie folgt eingeben: »Salt Lake City, Utah, USA«. Angenommen, Sie wissen nur, dass eine Person in Utah geboren wurde. Sie würden die Informationen wie folgt eingeben: »,, Utah, USA«.<br /><br />Sie können <b>#pgv_lang[find_place]#</b> verwenden, um Orte zu finden, die bereits in der Datenbank vorhanden sind.";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />Die Eingabe von Breiten- und Längengradkoordinaten wird im Allgemeinen nicht empfohlen, da der Zuordnungszugriff nur aus der Sicht des bestimmten Elements möglich ist. Es ist besser, die geografischen Orte zu verwalten.<br /><br />Die Eingabe des Breiten- und Längengrads ermöglicht jedoch eine genauere Plazierung des Markers.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />Die Eingabe von Breiten- und Längengradkoordinaten wird im Allgemeinen nicht empfohlen, da der Zuordnungszugriff nur aus der Sicht des bestimmten Elements möglich ist. Es ist besser, die geografischen Orte zu verwalten.<br /><br />Die Eingabe des Breiten- und Längengrads ermöglicht jedoch eine genauere Plazierung des Markers.";
$pgv_lang["edit_add_parent_help"]		= "~Mutter oder Vater hinzufügen~<br /><br />Auf dieser Seite können Sie der Datenbank bisher unbekannte Personen als Eltern hinzufügen.  Sie müssen mindestens den Namen des Vaters oder der Mutter eingeben.  Andere bekannte Informationen, wie Geburts- oder Todes-Datum können auch sofort eingegeben werden.  Unbekannte Geburts- oder Todes-Fakten sollten leer bleiben.<br /><br />Besondere Fakten wie Beruf oder Religion können erst nach dem Einfügen dieser Person bearbeitet werden.  Die Person wird durch Klicken des »#pgv_lang[save]#« Buttons eingefügt.  Alle Fakten der neu eingefügten Person können danach von dessen #pgv_lang[indi_info]# Seite bearbeitet oder aufgerufen werden.";
$pgv_lang["edit_add_spouse_help"]		= "~Ehepartner hinzufügen~<br /><br />Auf dieser Seite können Sie der Datenbank bisher unbekannte Personen als Ehepartner hinzufügen.  Sie müssen mindestens den Namen dieser Person eingeben.  Andere Informationen, wie Geburts- oder Todes-Datum können auch sofort eingegeben werden.  Unbekannte Geburts- oder Todes-Fakten sollten leer bleiben.<br /><br />Besondere Fakten wie Beruf oder Religion können erst nach dem Einfügen dieser Person bearbeitet werden.  Die Person wird durch Klicken des »#pgv_lang[save]#« Buttons eingefügt.  Alle Fakten der neu eingefügten Person können danach von dessen #pgv_lang[indi_info]# Seite bearbeitet oder aufgerufen werden.";
$pgv_lang["edit_death_help"]			= "~#pgv_lang[death]#~<br /><br />In dieser Feldergruppe können Sie Todes-Fakten eintragen.  Das Todesdatum wird im üblichen Format der Ahnenforschung eingegeben (z.B. 1&nbsp;JAN&nbsp;2004).  Das Programm hilft Ihnen, das Datum zu wählen nachdem Sie das Kalenderikon klicken.  Der Todesort soll auch im üblichen Format der Ahnenforschung (Ort,Kreis,Bundesland,Land) eingegeben werden.  Falls Sie <b>#pgv_lang[find_place]#</b> klicken, können Sie einen bereits in der Datenbank vorkommenden Ort wählen.";
$pgv_lang["edit_birth_help"]			= "~#pgv_lang[birth]#~<br /><br />In dieser Feldergruppe können Sie Geburts-Fakten eintragen.  Das Geburtsdatum wird im üblichen Format der Ahnenforschung eingegeben (z.B. 1&nbsp;JAN&nbsp;2004).  Das Programm hilft Ihnen, das Datum zu wählen nachdem Sie das Kalenderikon klicken.  Der Geburtsort soll auch im üblichen Format der Ahnenforschung (Ort,Kreis,Bundesland,Land) eingegeben werden.  Falls Sie <b>#pgv_lang[find_place]#</b> klicken, können Sie einen bereits in der Datenbank vorkommenden Ort wählen.";
$pgv_lang["edit_sex_help"]				= "~#pgv_lang[sex]#~<br /><br />Bitte wählen Sie das Geschlecht.  Die Option <b>#pgv_lang[unknown]#</b> bedeutet dass das Geschlecht dieser Person unbekannt ist.";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Dies ist das wichtigste Feld im Namensdatensatz einer Person.<br /><br />Dieses Feld sollte automatisch ausgefüllt werden, wenn die anderen Felder ausgefüllt werden. Es wird jedoch bereitgestellt, damit Sie die Informationen nach Ihren persönlichen Vorlieben bearbeiten können.<br /><br />Der Name in diesem Feld sollte gemäß den GEDCOM 5.5.1 Standards eingegeben werden, wobei der Nachname von Schrägstrichen »/« umgeben ist. Als Beispiel sollte der Name »John Robert Finlay Jr.« wie folgt eingegeben werden: »John Robert /Finlay/ Jr.«.";
$pgv_lang["edit_surname_help"]			= "~#pgv_lang[surname]#~<br /><br />In dieses Feld geben Sie den Nachnamen.  Der Nachname von »John Robert Finlay Jr.«, der hier eingeben werden soll ist <b>Finlay</b>.<br /><br />Personen mit mehreren Familiennamen, wie in Spanien und Portugal oft der Fall ist, sollen mit Komma zwischen den Familiennamen eingetragen werden.  Zum Beispiel, der Eintrag »Cortes,Vega« wird in Nachnamenslisten unter <b>C</b> und <b>V</b> gezeigt, während der Eintrag »Cortes Vega« nur unter <b>C</b> gezeigt wird.";
$pgv_lang["edit_NICK_help"]				= "~#factarray[NICK]#~<br /><br />In dieses Feld geben Sie Spitznamen dieser Person.  Das Feld kann leer bleiben.<br /><br />Methoden für das Eingeben von Spitznamen:<ul><li><b>#pgv_lang[update_name]#</b> wählen, Spitznamen eingeben, und zuletzt speichern</li><li><b>#pgv_lang[add_name]#</b> wählen, Spitznamen <u>und</u> vollen Namen eingeben, und zuletzt speichern</li><li>#pgv_lang[edit_raw]#</b> wählen, unter der ersten <b>1&nbsp;NAME</b> Zeile die gewünschten <b>2&nbsp;NICK</b> Zeilen eingeben, und zuletzt speichern</li></ul>";
$pgv_lang["edit_given_name_help"]		= "~#pgv_lang[given_name]#~<br /><br />In dieses Feld geben Sie die Vornamen.  Die Vornamen von »John Robert Finlay Jr.«, die hier eingeben werden sollen sind <b>John Robert</b>.";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Dieses Feld ermöglicht Ihnen die Eingabe eines Namenspräfixes wie <i>Dr.</i> oder <i>Adm.</i><br /><br />Adelsinformationen wie <i>Sir, Lord, Baron, Earl, Duke, Graf, Freiherr,</i> etc. werden als »#factarray[TITL]#« Faktum eingetragen.";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Hier können Sie einen Namenszusatz wie <i>Jr., Sr., III, IV,</i> usw. und akademische Informationen wie <i>PhD, PEng, FImechE, DVM, MD,</i> usw. eingeben.";
$pgv_lang["edit_add_child_help"]		= "~#pgv_lang[add_child]#~<br /><br />Auf dieser Seite können Sie ein der Datenbank bisher unbekanntes Kind hinzufügen.  Sie müssen mindestens den Namen des Kindes eingeben.  Andere bekannte Informationen, wie Geburts- oder Todes-Datum können auch sofort eingegeben werden.  Unbekannte Geburts- oder Todes-Fakten sollten leer bleiben.<br /><br />Besondere Fakten wie Beruf oder Religion können erst nach dem Einfügen dieser Person bearbeitet werden.  Die Person wird durch das Klicken des »#pgv_lang[save]#« Buttons eingefügt.  Alle Fakten der neu eingefügten Person können danach von dessen #pgv_lang[indi_info]# Seite bearbeitet oder aufgerufen werden.";

$pgv_lang["review_changes_help"]		= "~#pgv_lang[review_changes_block]#~<br /><br />Dieser Block zeigt alle Datensätze die mit PhpGedView bearbeitet wurden und noch nicht in die Datenbank übernommen sind.";
$pgv_lang["quick_update_name_help"] 	= "~#pgv_lang[update_name]#~<br /><br />Diese Feldergruppe erleichtert das Ändern des Namens dieser Person.<br /><br />Ins »#factarray[GIVN]#« Feld geben Sie die Vornamen und ins »#factarray[SURN]#« Feld geben Sie den Nachnamen.  Zum Beispiel, die Bestandteile des Namens »John Robert Finlay« sind: <b>John Robert</b> (#factarray[GIVN]#); <b>Finlay</b> (#factarray[SURN]#)<br /><br />Ihre Eingaben <u>ändern</u> den Namen dieser Person; neue Namen werden hier <u>nicht</u> hinzugefügt.<br /><br /><i>Bitte beachten Sie: Falls der Name dieser Person wegen einer Ehe geändert wurde, soll der neue Ehename <u>nicht</u> auf dieser Seite eingegeben werden.</i>";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Diese Feldergruppe erlaubt Ihnen, neue Fakteninformationen hinzuzufügen oder ein vorhandenes Faktum für den Datensatz den Sie bearbeiten, zu ändern. Wählen Sie zuerst ein Faktum aus der Liste. Geben Sie dann das Datum, an dem diese Tatsache aufgetreten ist, im Standard-Datumsformat für die Genealogie ein (1&nbsp;JAN&nbsp;2004).Sie können auf das Kalendersymbol klicken, um Hilfe bei Wahl eines Datums zu erhalten. Geben Sie dann den Ort ein, an dem dieses Ereignis statt fand. Sie können <b>#pgv_lang[find_place]#</b> verwenden, um einen Ort finden, der bereits in der Datenbank vorhanden ist.<br /><br />Wie bei allen anderen Feldern in diesem Formular werden Ihre Informationen angezeigt. Was bereits vorhanden ist wird ersetzt; nach Bedarf werden neue Einträge erstellt.";
$pgv_lang["quick_update_address_help"]	= "~#pgv_lang[update_address]#~<br /><br />In dieser Feldergruppe können Sie die Adresse, Telefon- und Fax-Nummern, sowie die Mail-Adresse dieser Person hinzufügen oder ändern.<br /><br />Änderungen bewirklichen Sie durch das Ersetzen der bestehenden Daten.  Falls Sie Daten löschen möchten, müssen Sie die gewünschten Felder leeren.";
$pgv_lang["quick_update_spouse_help"]	= "~Neuen Ehepartner hinzufügen~<br /><br />Diese Felder werden benutzt, wenn Sie der Person, die Sie bearbeiten, einen neuen Ehemann oder eine neue Ehefrau hinzufügen möchten. Geben Sie den Namen und die Geburtsdaten des neuen Ehepartners in die Felder ein und geben Sie dann das Datum der Ehe unter den Eheinformationen ein. Geben Sie die Daten im Standard-Datumsformat für Genealogie ein (1&nbsp;JAN&nbsp;2004). Sie können das Kalendersymbol klicken, um Hilfe bei der Wahl eines Datums zu erhalten. Sie können <b>#pgv_lang[find_place]#</b> verwenden, um einen Ort zu wählen, der bereits in der Datenbank vorhanden ist.<br /><br />In diesen Feldern wird nur ein <i>neuer</i> Partner hinzugefügt; sie werden die Informationen eines alten nicht ändern. Um die Informationen einer Person zu bearbeiten, die bereits aufgezeichnet wurde, schließen Sie dieses Fenster und klicken Sie auf den Namen dieser Person im Ordner #pgv_lang[relatives]#. Klicken Sie dann das Menü »Person bearbeiten«, um die Informationen zu bearbeiten.";
$pgv_lang["quick_update_marriage_help"]	= "~Ehe bearbeiten~<br /><br />Sie können diese Felder, zusammen mit den Feldern der Gruppe »Neuen Ehepartner hinzufügen« benutzen, die Daten einer bisher unbekannten Ehe einzugeben.  Falls Sie nur Ehedaten eingeben ohne auch gleichzeiting einen neuen Ehepartner hinzuzufügen, werden die Daten der <i>letzten</i> Ehe geändert. Bitte beachten Sie dass Daten immer im der Ahnenforschung üblichen Format eingegeben werden sollen.  (D.h., englische Monatsabkürzung, wie zum Beispiel <b>1&nbsp;JAN&nbsp;2004</b>.)  Für Hilfe beim Eingeben von Daten können Sie das Kalenderikon klicken.  Falls Sie einen Ort eingeben möchten, der bereits der Datenbank bekannt ist, können Sie <b>#pgv_lang[find_place]#</b> benutzen.";
$pgv_lang["quick_update_child_help"] 	= "~#pgv_lang[add_new_chil]#~<br /><br />Diese Felder ermöglichen Ihnen, dieser Person ein neues Kind hinzuzufügen. Geben Sie zuerst den Namen des Kindes ein und wählen Sie das Geschlecht. Geben Sie dann das Datum und den Ort ein, wo das Kind geboren wurde. Geben Sie die Daten im Standard-Datumsformat für die Genealogie ein (1&nbsp;JAN&nbsp;2004). Sie können das Kalendersymbol klicken, um Hilfe bei der Auswahl eines Datums zu erhalten. Sie können <b>#pgv_lang[find_place]#</b> verwenden, um einen Ort zu wählen, der bereits in der Datenbank vorhanden ist.<br /><br />In diesen Feldern wird nur ein <u>neues</u> Kind hinzugefügt. Sie aktualisieren nicht die Informationen eines Kindes, das bereits in der Datenbank vorhanden ist. Um die Informationen einer Person zu bearbeiten, die sich bereits in der Datenbank befindet, schließen Sie dieses Fenster und klicken Sie den Namen dieser Person im Ordner <b>#pgv_lang[find_place]#</b>. Klicken Sie dann das Menü Person bearbeiten, um die Informationen zu bearbeiten.";
$pgv_lang["index_top10_pageviews_help"]	= "~#pgv_lang[top10_pageviews]#~<br /><br />Dieser Block zeigt die meist aufgerufenen Personen, Familien, oder Quellen.  Um das zu bewirken, müssen Sie die <b>#pgv_lang[SHOW_COUNTER]#</b> Option der <b>#pgv_lang[displ_hide_conf]#</b> Gruppe innherhalb des Abschnitts <b>#pgv_lang[displ_conf]#</b> der GEDCOM Konfiguration auf <b>#pgv_lang[yes]#</b> stellen.";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Dieser Block zeigt die Cookie-Politik dieser Website.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Lassen Sie dieses Feld leer, wenn Sie den Standardtext verwenden möchten.<br /><br />Wenn Sie außer dem Standardtext auch ein Link zu einer Textdatei oder HTML-Seite, die Details über die Cookie-Politik Ihrer Website enthält, verwenden möchten, können Sie die URL dieser Seite eingeben.<br /><br />Zum Beispiel, <b>http://foo.bar.com/policy/cookies.txt</b> könnte auf eine einfache Text-Datei verweisen, während <b>http://foo.bar.com/policy/cookies.htm</b> zu einer HTML-formatierten Seite, oder <b>http://foo.bar.com/policy/cookies.doc</b> zu einem Dokument in Microsoft Word leitet.";
$pgv_lang["cookiepolicy_link_advice"]		= "Das leere Feld bedeutet daß nur der Standardtext verwendet wird.<br /><br />Geben Sie eine URL wie, z.B., <b>http://foo.bar.com/policy/cookies.txt</b> um auch zu einer Seite hinzuweisen, die Details über die Cookie-Politik Ihrer Website enthält.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Mit dieser Option können Sie den Ordner bestimmen, der automatisch beim Zugriff zur #pgv_lang[indi_info]# Seite geöffnet wird.  Die Option <b>#pgv_lang[all]#</b> bestimmt dass alle vorhandenen Ordner automatisch geöffnet werden sollen.<br /><br />Falls der Benutzer seine eigenen Optionen bearbeiten darf, kann er diese Option für sich ändern.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Mit dieser Option können Sie den Ordner bestimmen, der automatisch beim Zugriff zur #pgv_lang[indi_info]# Seite geöffnet wird.  Die Option <b>#pgv_lang[all]#</b> bestimmt dass alle vorhandene Ordner automatisch geöffnet werden sollen.";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br /><br />Kinder dieser Familie werden in der selben Reihenfolge gezeigt, wie sie im Datensatz der Familie vorkommen.  Gewöhnlich werden Kinder nicht nach Geburtsdaten sortiert da oft nur die Reihenfolge der Geburten bekannt ist.<br /><br />Diese Option ermöglicht Ihnen, die Reihenfolge der Kinder zu bestimmen.  Falls Sie die Kinder nach deren Daten sortieren möchten, können Sie den entsprechenden Button klicken.<br /><br />Sie können auch die Reihenfolge der Kinder mit der Maus bestimmen.  Wenn der Maus-Cursor über einem der Informations-Kasten steht, verändert er sich in zwei doppelte sich kreuzende Pfeile.  Wenn Sie nun die linke Maustaste drücken und danach den Maus-Cursor nach oben oder unten verschieben, folgt der Informations-Kasten.  Die anderen Kasten der Liste machen dem sich verschiebendem Kasten eine Lücke, bis Sie die linke Maustaste loslassen, wonach er in der Lücke Platz nimmt.";
$pgv_lang["rss_feed_help"]				= "~#pgv_lang[rss_feeds]#~<br /><br />Die von PhpGedView unterstützte ATOM oder RSS Versorgung ermöglicht das leichte Beobachten von Internetseiten um Änderungen darin schnell zu erkennen, ohne dass der RSS Abonnent jede beobachtete Seite direkt zugreifen muss.  Die meisten RSS-Sammler senden automatische Mails wenn in beobachteten Seiten Änderungen vorhanden sind.<br /><br />Der #pgv_lang[rss_feeds]# Block ermöglicht Ihnen, die RSS Versorgung nach Ihren Wünschen anzupassen.  Unterstützte Versorgungstypen sind ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML und JavaScript.  ATOM und RSS sind für RSS-Sammler bestimmt.  Die Standard-Einstellung (ATOM) ist für die meisten Sammler gültig. Die Nummern deuten den Stil, und NICHT Versionen. Mit HTML und JavaScript ist es möglich, den Inhalt der Hauptseite in andere Seiten einzufügen.<br /><br />Außer dem Versorgungstyp können Sie auch bestimmen, welche Blöcke der Hauptseite Sie durch RSS beobachten möchten.  Die Sprache in der diese Blöcke für Sie beobachtet werden, ist die gleiche, in der Sie eben arbeiten.  In diesem Fall ist es die deutsche Sprache.  Falls Sie zum Beispiel die französische Version der Blöcke beobachten möchten, müssen Sie PhpGedView auf Französisch umschalten bevor Sie die Hauptseite erneut aufrufen und anpassen.<br /><br />Eine Option mit der Sie die Authentifizierungsmethode wählen können ist auch vorhanden. Diese Option, falls eingeschaltet, erlaubt dem RSS Sammler die Hauptseite mit NutzerID und Kennwort zuzugreifen.  Dadurch können private Daten sichtbar werden, genau als ob ein normaler Nutzer sich mit den selben Daten angemeldet hätte. Der RSS-Sammler wird durch #pgv_lang[basic_auth]# angemeldet.  #pgv_lang[basic_auth]# benutzt die <i>Basic HTTP Authentication</i> Methode.  Wahrscheinlich wird in der Zukunft auch die #pgv_lang[digest_auth]# Methode unterstützt.<br /><br />In diesem <a href='https://de.wikipedia.org/wiki/RSS' target='_blank' alt='Wikipedia Artikel' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> finden Sie ausführliche Informationen über RSS. <i>Einfache HTTP Authentifikation</i> ist in diesem <u>englischen</u> <a href='https://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia Artikel' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> beschrieben während <i>#pgv_lang[digest_auth]#</i>in diesem <u>englischen</u> <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia Artikel' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> beschrieben ist.";

$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Wählen Sie die Dateien zum Hochladen auf Ihren Server. Alle Dateien werden in das <b>#MEDIA_DIRECTORY#</b> Verzeichnis aktualisiert  oder in eines seiner Unterverzeichnisse.<br /><br />Verzeichnisnamen die Sie eingeben, werden an <b>#MEDIA_DIRECTORY#</b> angehängt. Zum Beispiel, <b>#MEDIA_DIRECTORY#Müller</b>. Falls das Miniaturbild-Verzeichnis nicht existiert, wird es automatisch erstellt.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Ihre GEDCOM-Konfiguration erlaubt eine Unterverzeichnistiefe von #GLOBALS[MEDIA_DIRECTORY_LEVELS]#, zusätzlich zum Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> wo übertragene Medien-Dateien standardmäßig gespeichert werden. Sie können so Ihre Medien-Dateien besser ordnen, und brauchen auch nicht mehr darauf zu achten, dass Dateinamen im ganzen PhpGedView Medien-System nur einmal vorkommen.<br /><br />In dieses Feld geben Sie die Verzeichnisstruktur wo die von Ihrem lokalen Computer übertragene Datei gespeichert werden soll.  Bitte achten Sie auf die Schreibweise (Groß- und Kleinbuchstaben) der eingegebenen Verzeichnisnamen.  Verzeichnisnamen mit Kleinbuchstaben unterscheiden sich von den selben Namen in Großbuchstaben.<br /><br />Falls die eingegebene Verzeichnisstruktur nicht existiert, wird sie vor dem Übertragen automatisch erstellt.  Falls die von Ihnen eingegebene Verzeichnisstruktur mehr als die erlaubten #GLOBALS[MEDIA_DIRECTORY_LEVELS]# Unterverzeichnisse enthält, werden die überflüssigen Verzeichnisnamen von links nach rechts aus Ihrer Eingabe gelöscht.<br /><br />Miniaturbilder werden in einer identischen Verzeichnisstruktur gespeichert, die aber vom Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> ausgeht.";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />In diesem Feld geben Sie Verzeichnis und Namen der Medien-Datei die Sie auf den Server übertragen möchten.  Mit Hilfe des <b>Browse</b> Buttons können Sie Ihren lokalen Computer nach der gewünschten Datei durchsuchen.<br /><br />Die Datei wird mit dem selben Namen in das im <b>#pgv_lang[folder]#</b> Feld angegebenen Verzeichnis übertragen.<br /><br />Wenn das Feld <b>#pgv_lang[folder]#</b> nicht sichtbar ist oder Sie es nicht ändern können, haben Sie entweder nicht genügende Rechte, oder die Konfiguration hat bestimmt, dass Verzeichnisse unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> nicht erlaubt sind.  In diesem Fall werden alle Medien-Dateien in das erwähnte <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Verzeichnis übertragen.";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />In diesem Feld geben Sie Verzeichnis und Namen der Miniaturbild-Datei die Sie auf den Server übertragen möchten.  Mit Hilfe des <b>Browse</b> Buttons können Sie Ihren lokalen Computer nach der gewünschten Datei durchsuchen.  Nur wenn Sie dieses Feld leer lassen wird die <b>#pgv_lang[auto_thumbnail]#</b> Box beachtet.<br /><br />Falls Sie auch einen Namen ins <b>#pgv_lang[media_file]#</b> Feld eingetragen haben, erhält das hochgeladene Minaturbild den gleichen Namen, ohne Rücksicht auf dessen Namen in Ihrem lokalen Computer.  Das leere <b>#pgv_lang[media_file]#</b> Feld hat zur Folge dass die Miniaturbild-Datei nach dem Übertragen in zwei verschiedenen Server-Verzeichnissen vorkommt: einmal im Medien-Unterverzeichnis dessen Namen Sie im <b>#pgv_lang[folder]#</b> Feld eingegeben haben, und das zweite Mal in der selben Verzeichnisstruktur, die aber vom Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> ausgeht.<br /><br />Wenn das <b>#pgv_lang[folder]#</b> Feld nicht sichtbar ist oder Sie es nicht ändern können, haben Sie entweder nicht genügende Rechte, oder die Konfiguration hat bestimmt, dass Verzeichnisse unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> nicht erlaubt sind.";


//-- GENERAL
$pgv_lang["help_header"]				= "Informationen über:";
$pgv_lang["privacy_error_help"]			= "~PRIVATE DETAILS~<br /><br />Es gibt verschiedene Gründe, warum Sie diese Nachricht bekommen können:<br /><ul><li><b>Alle Daten lebender Personen sind als »Privat« eingestellt.</b><br />Unregistrierte oder nicht angemeldete Besucher können vollständige Informationen nur über verstorbene Personen sehen. Sofern vom Verwalter zugelassen, können Sie sich registrieren, indem Sie den Login Button klicken und anschließend #pgv_lang[requestaccount]#.<br /></li><li><b>Sie sind ein Benutzer mit Benutzername und Kennwort...</b><br />aber Sie haben sich nicht erfolgreich angemeldet oder Sie haben zu lange keine Eingabe gemacht und wurden deshalb automatisch abgemeldet.<br /></li><li><b>Aus Datenschutzgründen</b><br />Manche Personen können den Verwalter gebeten haben, bestimmte Daten auf »Privat« zu setzen oder möchten überhaupt nicht in der Datenbank erscheinen.<br />Der Datenschutz kann folgende Werte annehmen:<br /><ul><li>#pgv_lang[PRIV_USER]#<br /></li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Außerhalb des »Verwandtschafts-Pfades«</b><br />Auch wenn Sie ein <b>angemeldeter</b> Benutzer sind, kann es vorkommen, dass Sie diese Nachricht erhalten, wenn Sie Daten einer Person ansehen möchten, die mit Ihnen entfernter verwandt ist als der Verwalter zugelassen hat (Verwandtschafts-Pfad-Länge).<br />Beispiele:<br />Wenn die Länge des Verwandtschafts-Pfades auf <b>1</b> gesetzt ist, können Sie nur Daten Ihrer eigenen Familie, Vater, Mutter, Geschwister (aber nicht die des Ehepartners oder von Kindern Ihrer Geschwister) sehen.<br /><br />Wenn die Länge auf <b>2</b> eingestellt ist, können Sie auch die Daten des Ehepartners, die Ihrer Geschwister und deren Kindern sehen (aber nicht die der Ehepartner deren Kinder).<br /><br />Je länger der Verwandtschaftspfad eingestellt ist, umso weiter entferntere Verwandte können Sie im Detail sehen.<br /></li></ul><br />Wenn Sie glauben, Sie sollten das Recht haben bestimmte private Daten zu sehen, kontaktieren Sie den Verwalter über »Kontakt« auf der Seite.";
$pgv_lang["more_help"]					= "Wenn Sie auf allen Seiten die Kontexthilfe aktivieren möchten, stellen Sie bitte sicher, dass die <b>#pgv_lang[show_context_help]#</b> Option im Hilfe Menü aktiviert wurde und klicken Sie das <b>#pgv_lang[qm]#</b> neben dem gewünschten Objekt.";
$pgv_lang["start_admin_help"]			= "+++ Beginn zusätzliche Informationen für Verwalter +++";
$pgv_lang["end_admin_help"]				= "--- Ende zusätzliche Informationen für Verwalter ---";
$pgv_lang["multiple_help"]				= "<span class='center'>--- Dies ist ein allgemeiner Hilfetext, der mehrere Seiten betrifft ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>ALLGEMEINE INFORMATIONEN</b></div>";
$pgv_lang["best_display_help"]			= "~#pgv_lang[resolution]#~<br /><br />PhpGedView wurde für eine Bildschirmauflösung von 1024x768 Pixel entwickelt. Das ist die minimale Auflösung, in der alles optimal dargestellt werden kann.<br /><br />Falls Sie eine niedrigere Auflösung verwenden (z.B. 800x600 Pixel), werden Sie gelegentlich horizontal scrollen müssen, um alles zu sehen.";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br /><br />Wenn Sie <b>#pgv_lang[print_preview]#</b> klicken, werden die Elemente entfernt, die auf einer gedruckten Seite nicht gut aussehen (Menüs, Eingabefelder, zusätzliche Links, Fragezeichen für Kontexthilfe usw.).<br /><br />Sie erhalten einen <b>#pgv_lang[print]#</b> Button unten auf der vereinfachten Seite; wenn Sie diesen Button klicken, erscheint der Druckdialog Ihres Systems. Klicken Sie nach dem Drucken <b>#pgv_lang[cancel_preview]#</b>, wird der Bildschirm normal neu aufgebaut.<br /><br />Hinweis: Obwohl diese Option viele Links von der angezeigten Seite entfernt, sind die verbleibenden Links immer noch aktiv.";
$pgv_lang["readme_help"]				= "In der Datei <a href='readme.txt' target='_blank'><b>Readme.txt</b></a> finden Sie weitere Informationen.";
$pgv_lang["is_user_help"]				= "--- Dieser Hilfe Text ist identisch mit dem Hilfetext für Besucher. ---<br />--- Um Platz zu sparen, gibt es zu diesem Thema keine besondere Hilfe für Verwalter. ---";
$pgv_lang["edit_raw_gedcom_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Wenn Sie dieses Link klicken, öffnet sich ein weiteres Fenster, das die GEDCOM-Rohdaten zu den Informationen dieser Seite zeigt. Dort können Sie die GEDCOM-Rohdaten direkt bearbeiten. Achten Sie darauf, dass Ihre Eingaben dem GEDCOM 5.5.1 Standard entsprechen; es finden nämlich keine Gültigkeitsprüfungen für Ihre Eingaben statt.<br /><br />Die veränderten bzw. hinzugefügten Daten werden in PhpGedView als Änderungen gezeigt und müssen anschließend von einem Benutzer akzeptiert werden, der die dafür notwendigen Rechte besitzt.";
$pgv_lang["RESN_help_title"]			= "Fakten Beschränkung";
$pgv_lang["RESN_help"]					= "~#pgv_lang[RESN_help_title]#~<br /><br />Abgesehen vom allgemeinen Datenschutz besteht in PhpGedView auch noch die Möglichkeit das Zeigen oder Bearbeiten von Fakten zu beschränken.  Jeder mit Editier-Rechten kann Beschränkungen setzen, es sei denn dass Datenschutz oder vorher gesetzte Beschränkungen den Zugriff zu dem jeweiligen Fakten verbieten.<br /><br />Sie können die folgenden Beschränkungstypen setzen:<br /><ul><li><b>#pgv_lang[none]#</b><br />Verwalter und Nutzer mit Editier-Rechten dürfen die Fakt-Daten ändern.  Anderen werden die Fakt-Daten nur gezeigt, wenn die vom Verwalter bestimmten Datenschutzeinstellungen es erlauben.</li><li><b>#pgv_lang[locked]#</b><br />Bearbeiten von Fakt-Daten ist nur Verwaltern erlaubt.  Falls der Nutzer in der Datenbank mit Editier-Rechten eingetragen ist, darf er seine eigenen Fakt-Daten bearbeiten.  Anderen werden Fakt-Daten immer gezeigt.</li><li><b>#pgv_lang[privacy]#</b><br />Verwalter dürfen die Fakt-Daten sehen und bearbeiten.  Nutzer dürfen ihre eigenen Fakt-Daten sehen, und falls sie Editier-Rechte haben, dürfen sie sie auch bearbeiten.  Anderen sind die Fakt-Daten immer verborgen.</li><li><b>#pgv_lang[confidential]#</b><br />Nur Verwalter dürfen die Fakt-Daten sehen und bearbeiten.  Anderen sind die Fakt-Daten immer verborgen.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Verwalter</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Besitzer</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Andere</th></tr><tr><th></th><th></th><th>L</th><th>B</th><th></th><th>L</th><th>B</th><th></th><th>L</th><th>B</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L: Lesen erlaubt</li><li>B: Bearbeiten erlaubt</li><li><img src='images/checked_qm.gif' alt='' />: Datenschutzeinstellung befragen</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]					= "~#pgv_lang[welcome_page]#~<br /><br />Dies ist die Begrüßungs-Seite. Sie heißt Sie auf der gewählten <a href=\"#def_gedcom\"><b>GEDCOM</b></a>-Datei-Seite willkomen. Sie gelangen zurück zu dieser Seite über das Begrüßungs-Seite-Link in der oberen Menüleiste. Wenn mehrere GEDCOM-Dateien auf dieser Seite hinterlegt sind, können Sie eine davon über das Menü wählen. Diese Seite enthält Informationen über:<ul><li><a href=\"#index_portal\"><b>Begrüßungs-Seite</b></a></li><li><a href=\"#header\"><b>Kopfbereich</b></a></li><li><a href=\"#menu\"><b>Menüs</b></a></li><li><a href=\"#header_general\"><b>Allgemeine Informationen</b></a></li><li><a href=\"#def\"><b>Definitionen</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]				= "<div class='name_head center'><b>KOPFBEREICH</b></div><br />Der Kopfbereich wird im oberen Teil jeder Seite gezeigt.<br /><br />Der Kopfbereich enthält einige hilfreiche Links, die die gesamte Seite beeinflussen können. Da die Seite durch die Wahl verschiedener <a href=\"#def_theme\"><b>Themes</b></a> variieren kann, enthält der Kopfbereich je nach gewähltem Theme eventuell unterschiedliche Links.<br /><br />Links, die vorkommen können, sind:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# »#pgv_lang[search]#«~<br /><br />Obwohl diese Box klein ist, ist sie doch sehr nützlich.  Sie können damit PhpGedView befehlen, die Datenbank nach fast jedem beliebigen Etwas zu durchsuchen. Wenn Sie den <b>&gt;</b> oder <b>#pgv_lang[search]#</b> Button klicken, fordern Sie die #pgv_lang[search]#-Seite an, wo Sie die Ergebnisse Ihrer Suche sehen können.  Die selbe Seite enthält auch ausführliche Informationen über andere Such-Optionen";
$pgv_lang["header_lang_select_help"]	= "~#pgv_lang[header]# »#pgv_lang[change_lang]#«~<br /><br />Eine der wichtigsten Funktionen von PhpGedView ist, dass mehrere Sprachen unterstützt werden.<br /><br />Die Sprache, in der PhpGedView alle Seiten anzeigt, wird automatisch anhand der Einstellung für die bevorzugte Sprache des Browsers festgelegt. Möglicherweise hat der Site-Verwalter jedoch die Verfügbarkeit bestimmter Sprachen eingeschränkt.<br /><br />Abhängig von der Site-Konfiguration können Sie möglicherweise die Sprache von PhpGedView ändern, indem Sie eine geeignetere Sprache aus einer Liste auswählen oder auf ein Flaggensymbol klicken. Wenn Sie angemeldet sind, können Sie PhpGedView so konfigurieren, dass Sie nach der Anmeldung Ihre bevorzugte Sprache wechseln, unabhängig davon, auf was Ihr Browser eingestellt ist.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# »#pgv_lang[login]#«~<br /><br />Die Benutzerlinks sind ein kleiner Block mit nützlichen Links, die auf jeder Seite an derselben Stelle zu finden sind. Die Position dieser Links hängt vom aktuell gültigen Thema ab.<br /><br />Wenn Sie nicht angemeldet sind, wird nur <b>Anmelden</b> gezeigt. Nachdem Sie sich angemeldet haben, wird Folgendes gezeigt:<ul><li><b>Angemeldet als (Ihr Benutzername)</b>. Wenn Sie dieses Link klicken, gelangen Sie zu Ihrer Kontoseite.</li><li>Klicken Sie <b>Abmelden</b>, um sich abzumelden.</li><li>Wenn Sie über Verwalterrechte verfügen, wird auch <b>Admin</b> angezeigt. Wenn Sie dieses Link klicken, gelangen Sie direkt zur Administration Seite.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# »#pgv_lang[gedcom_favorites]#«~<br /><br />Diese Liste zeigt Ihnen Ihre Lesezeichen, sofern Sie welche erstellt haben. Sie zeigt auch die Lesezeichen, die der Verwalter für die GEDCOM-Datei erstellt hat. Wenn Sie auf eines Ihrer Lesezeichen klicken, gelangen Sie zur Seite mit persönlichen Informationen zur jeweiligen Person.<br /><br />Weitere Hilfe zum Erstellen von Lesezeichen finden Sie unter Ihrem persönlichen Portal.";
$pgv_lang["header_theme_help"]			= "~#pgv_lang[header]# »#pgv_lang[change_theme]#«~<br /><br />Wenn vom Verwalter aktiviert, wird eine Liste von Themen gezeigt.<br /><br />Sie können die Ansicht der Site ändern, indem Sie ein Thema aus der Liste wählen. Wenn Sie angemeldet sind, wird auch Ihr Benutzerthema in das von Ihnen gewählte geändert, sodass bei Ihrer nächsten Anmeldung automatisch das selbe Thema gewählt wird.";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class='name_head center'><b>MENÜS</b></div><br />Oben auf der Seite gibt es nun verschiedene Menüpunkte.<br /><br />Wenn Sie mit dem Mauszeiger über die Menüpunkte fahren, öffnet sich ein Untermenü, sofern der Menüpunkt Unterpunkte enthält. Klicken Sie einen Hauptmenüpunkt, so entspricht das einem Klick des obersten Untermenüpunktes.<br /><br />Sie können aus den folgenden Haupt-Menüpunkten wählen:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />Alle verfügbaren GEDCOM-Dateien werden in diesem Menü aufgeführt. Jede GEDCOM-Datei hat ihre eigene Startseite, so wie diese hier. Wenn nur eine GEDCOM-Datei vorhanden ist, gibt es kein Untermenü für den Menüpunkt »Begrüßungs-Seite«.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Wenn Sie angemeldet sind, kann das Menü folgende Unterpunkte beinhalten:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Führt Sie zu Ihrer eigenen konfigurierbaren »Startseite«.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Eigene Benutzerdaten bearbeiten</dt><dd>Hier können Sie Ihre persönlichen Daten einstellen.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Wenn Sie eine Startperson für diese GEDCOM-Datei gewählt haben, führt dieses Link zum Stammbaum-Diagramm dieser Person.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Dieses Link führt zu der Seite mit persönlichen Informationen über Sie selbst, auf der die genealogischen Daten zu Ihrer Person und Ihrer Familie dargestellt wird.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />Alle verfügbaren Diagramme sind in diesem Menü zu finden:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Führt Sie zum Stammbaum-Diagramm dieser GEDCOM-Datei. Der Stammbaum geht von der Startperson der GEDCOM-Datei aus. Wenn Sie angemeldet sind, können Sie die Startperson für diesen Menüpunkt selbst wählen.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Der Nachfahrenbaum ist vergleichbar mit einem umgekehrten <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>. Dieser Vergleich hinkt zwar, aber während der Stammbaum alle Vorfahren einer Person zeigt, zeigt der Nachfahrenbaum alle Nachfahren dieser Person.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Die Erlebnisse einer Person werden entlang einer Zeitleiste dargestellt. Es kann sehr interessant sein, die Ereignisse im Leben von 2 oder mehr Personen mittels einer Zeitleiste zu vergleichen.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Hier können Sie die Verwandtschaft einer Person zu Ihnen selbst oder zu einer anderen Person ermitteln.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Ähnelt sehr dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, zeigt aber mehr Detailinformationen und verschiedene <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#en</a>.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Ähnelt sehr dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, aber ist eine eher graphische Darstellung.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Dieses Menü führt Sie zu den verfügbaren Listen:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />In diesen beiden Listen können Sie alphabetisch nach Personen suchen.<br />Die erste zeigt eine Liste von Personen, die zweite von Familien.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Dieser Menüpunkt erstellt eine Liste aller Quellen, die in dieser GEDCOM-Datei vorkommen.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Hier können Sie nach Personen suchen, die irgend eine Verbindung mit dem jeweiligen Ort haben.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Dieser Menüpunkt erscheint nur, wenn der Verwalter ihn aktiviert hat.<br />Er führt zu einer Liste mit allen Multimedia-Dateien, die in dieser Datenbank vorkommen.</li></ul>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />Der #pgv_lang[anniversary_calendar]# zeigt die Ereignisse für ein bestimmtes Datum, einen bestimmten Monat oder ein bestimmtes Jahr an.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Über diese Menüelemente gelangen Sie zum #pgv_lang[anniversary_calendar]#, wo Sie eine Liste aller Ereignisse für den aktuellen Tag, Monat oder Jahr erhalten.</li></ul>";
$pgv_lang["menu_clip_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Sofern durch den Verwalter aktiviert, erscheint dieser Menüpunkt in der Menüleiste.<br /><br />Der #pgv_lang[clip_cart]# ermöglicht das Zusammenstellen von Daten über Personen, Familien und Quellen zum anschliessenden Download im GEDCOM 5.5.1 Format.";
$pgv_lang["menu_search_help"]			= "~#pgv_lang[search]#~<br /><br />Die Such-Seite, zu der Sie gelangen wenn Sie dieses Link klicken, ist die leistungsfähigere Schwester des Suchfeldes im Kopfbereich.";
$pgv_lang["menu_help_help"]				= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>DIE BEGRÜSSUNGS-SEITE</b></div>";
$pgv_lang["index_portal_help"]			= "Die #pgv_lang[welcome_page]# Seite besteht aus mehreren einzelnen Blöcken, die vom Verwalter zusammengestellt werden. Für jede GEDCOM-Datei auf dieser Seite, sofern hier mehrere GEDCOM-Dateien vorhanden sind, kann eine eigene Begrüßungs-Seite erstellt werden. Je nach Bestimmen des Verwalters kann die Begrüßungs-Seite eine Auswahl der folgenden Blöcke enthalten:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Der Begrüßungsblock zeigt Ihnen den aktuellen Datenbanktitel, das Datum und die Uhrzeit sowie, falls vom Verwalter aktiviert, den Trefferzähler.<br /><br />Der Trefferzähler ist nur im Begrüßungsblock und auf der #pgv_lang[indi_info]# Seite erhältlich. Der Zähler zählt die »Treffer« dieser Seiten. Das heißt, es zählt, wie oft diese Seiten besucht werden. Der Zähler überprüft nicht die Internetadresse des Besuchers. Jeder Besuch der Seite von <u>jedem</u>> Standort zählt als Treffer.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />Obwohl Sie sich auf fast jeder Seite anmelden können, werden Sie das üblicherweise auf der ersten Seite tun, weil Sie verborgene private Informationen eventuell nur nach der Anmeldung sehen können.<br /><br />Tragen Sie hierzu Ihren <b>Benutzernamen</b> und Ihr <b>Kennwort</b> ein und klicken Sie den <b>#pgv_lang[login]#</b> Button.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Dieser Block zeigt Ereignisse vom heutigen Tag bis zu einen Monat im voraus.<br /><br />Die Zeitspanne dieses Blocks wird vom Verwalter bestimmt. Weitere Optionen verändern das Aussehen des Blocks.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"]					= "~#pgv_lang[todo_block]#~<br /><br />Dieser Block hilft Ihnen, unerledigte Aufgaben (_TODO Ereignisse) in der Datenbank zu verfolgen.<br /><br />Um solche Aufgaben der Datenbank hinzuzufügen, müssen Sie eventuell erst die GEDCOM Konfigurations-Datei ändern.  Die Listen der Ereignisse, die den verschiedenen Seiten hinzugefügt werden können, müssen <b>_TODO</b> enthalten.  Die vier Listen, die Sie im »Bearbeitungsoptionen« Abteil der GEDCOM-Konfiguration finden, je eine für die Personen-, Familien-, Quellen-, und Archivseiten, sind voneinander unabhängig.  Die Reihenfolge der Einträge in diesen Listen ist ohne weitere Bedeutung; Sie können neue Einträge vorn an die Listen hinzufügen.";
$pgv_lang["todo_show_other_help"]		= "Anderen Benutzern zugewiesene Aufgaben zeigen";
$pgv_lang["todo_show_unassigned_help"]	= "Noch nicht zugewiesene Aufgaben zeigen";
$pgv_lang["todo_show_future_help"]		= "Zeige Aufgaben, deren Daten in der Zukunft liegen.  Normalerweise werden unerledigte Aufgaben gezeigt, deren Daten schon verlaufen sind.";
$pgv_lang["yahrzeit_help"]				="~#pgv_lang[yahrzeit_block]#~<br /><br />Dieser Block zeigt Jahrzeiten die sich in den nächsten Tagen jähren.  Das sind die Todestage naher Verwandten.<br /><br />Jahrzeiten sind in der jüdischen Tradition im Gebrauch; in anderen Traditionen kommen sie nur noch selten vor. In der jüdischen Schreibweise kann »Jahrzeit« auch als »Yahrzeit« oder »Yartzeit« geschrieben werden.<br /><br />Die Zeitspanne dieses Blocks wird vom Verwalter bestimmt. Weitere Optionen verändern das Aussehen des Blocks.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Geben Sie die Anzahl der Tage die in diesem Block gezeigt werden sollen.  Sie dürfen nicht mehr als <b>#GLOBALS[DAYS_TO_SHOW_LIMIT]#</b> eingeben.  Falls Sie eine größere Zahl eingeben, wird angenommen, dass Sie <b>#GLOBALS[DAYS_TO_SHOW_LIMIT]#</b> eingegeben haben.<br /><br />Die gegebene Limit ist vom Verwalter in der <b>#pgv_lang[DAYS_TO_SHOW_LIMIT]#</b> Option der <b>#pgv_lang[displ_hide_conf]#</b> Gruppe innherhalb des Abschnitts <b>#pgv_lang[displ_conf]#</b> der GEDCOM Konfiguration festgesetzt.";
$pgv_lang["random_media_persons_or_all_help"]	= "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Diese Option erlaubt Ihnen zu bestimmen, welche Medientypen gezeigt werden können.<br /><br />Wenn Sie <b>#pgv_lang[random_media_persons]#</b> wählen, werden nur Medien, die mit Personen verbunden sind, gezeigt. Normalerweise sind das Fotos oder Gemälde. Wenn Sie <b>#pgv_lang[random_media_events]#</b> wählen, werden nur Medien, die mit Fakten oder Ereignissen verbunden sind, gezeigt. Das könnten Abbilder von Urkunden sein. Wenn Sie <b>#pgv_lang[all]#</b> wählen, zeigt dieser Block alle Medientypen.";
$pgv_lang["random_media_filter_help"]	= "~#pgv_lang[filter]#~<br /><br />Sie können bestimmen, welche Medienformate und Medientypen von diesem Block gezeigt werden dürfen.  Alle markierte Formate und Typen sind zum Zeigen in diesem Block erlaubt.<br /><br />Formate und Typen, die in Ihrer Datenbank vorkommen aber nicht in diesen Listen enthalten sind, sind immer zum Zeigen erlaubt.  Zum Beispiel, falls Ihre Datenbank Medien im <b><i>pdf</i></b> Format enthält, sind sie stets zum Zeigen erlaubt.  Gleichfalls sind Medien vom Typ <b><i>special</i></b>, die in Ihrer Datenbank vorkommen, stets zum Zeigen erlaubt.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Mit dieser Option können Sie verursachen dass bestimmte datierte Ereignisse nicht gezeigt werden.  Zum Beispiel, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. haben gewöhnlich Daten.<br /><br />Wenn Sie <b>#pgv_lang[yes]#</b> wählen, werden nur Geburten, Tode, und Ehen gezeigt. Wenn Sie <b>#pgv_lang[no]#</b> wählen, werden alle datierte Ereignisse gezeigt.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Diese Option bestimmt das Format der Informations-Darstellung.<br /><br />Wenn Sie <b>#pgv_lang[style1]#</b> wählen, werden die Informationen als Text, ähnlich dem Text in Diagrammen, gezeigt. Dieses Format eignet sich gut für Blöcke die im rechten Teil der Seite gezeigt werden.<br /><br />Wenn Sie <b>#pgv_lang[style2]#</b> wählen, werden die Informationen in einer Tabelle gezeigt.  Dieses Format eignet sich besser für Blöcke die im linken Teil der Seite gezeigt werden.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Diese Option bestimmt die Reihenfolge der dargestellten Informationen.<br /><br />Die Wahl <b>#pgv_lang[by_alpha]#</b> bedeutet dass die Reihenfolge durch Namen bestimmt wird. Wenn Sie <b>#pgv_lang[by_anniv]#</b> wählen, werden alle Ereignisse nach deren Jährungen sortiert, und die neuesten Ereignisse sind dann oben in der Liste.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Diese Option bestimmt, ob der Button, der das Herunterladen von Kalender-Ereignissen betätigt, allen angemeldeten Nutzern gezeigt wird oder nicht.  Die mit Hilfe dieses Buttons übertragene Kalender-Datei kann in passende Programme wie Microsoft Outlook importiert werden, wodurch zum Beispiel automatische Erinnerungs-Mails gesendet werden können.<br /><br />Wenn Sie <b>#pgv_lang[no]#</b> wählen, können angemeldete Nutzer Kalender-Dateien nicht herunterladen. Wenn Sie <b>#pgv_lang[yes]#</b> wählen, wird der »Download« Button gezeigt. Der Button ist niemals sichtbar wenn der Nutzer sich nicht angemeldet hat.";
$pgv_lang["cal_download_user_help"]		= "Wenn Sie angemeldet sind, könnnen Sie unter Umständen das Ikon <img src='images/hcal.png' alt='' /> sehen. Wenn Sie das Ikon klicken, können Sie die Ereignisse als Kalenderdatei herunterladen.  Solche Dateien kann man in kompatible Programme wie zB Microsoft Outlook importieren. Diese Programme haben oft die Fähigkeit, Ihnen Erinnerungen an Jubiläen zuzuschicken.<br /><br />Wenn Sie angemeldet sind und dieses Ikon nicht sichtbar ist, hat der Verwalter diese Funktion deaktiviert. Anonyme Besucher sehen niemals dieses Ikon, und dürfen Kalenderdateien auch nicht herunterladen.";
$pgv_lang["index_charts_help"]			= "~#pgv_lang[charts_block]#~<br /><br />Der Diagramm-Block ermöglicht Ihnen, Stammbaum-, Nachkommen- oder Sanduhrdiagramme auf der Begrüßungsseite oder auf der »#pgv_lang[mygedview]#« Seite zu zeigen.  Dieser Block ist für den linken Teil der Seite gedacht, da der rechte Teil sehr schmal ist.<br /><br />Wenn dieser Block auf der Begrüßungsseite dargestellt wird, werden die Stammperson und der Typ des gewünschten Diagramms vom Verwalter bestimmt. Für die »#pgv_lang[mygedview]#« Seite bestimmt der Benutzer diese Optionen.<br /><br />Die Diagramme verhalten sich hier genau wie sie sich auf anderen Seiten verhalten.  Wenn Sie den Kasten einer Person klicken, erhalten Sie Details.";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[on_this_day]#~<br /><br />Dieser Block ist dem #pgv_lang[upcoming_events_block]# Block ähnlich, nur dass Ereignisse gezeigt werden, die sich heute jähren.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Dieser Block entspricht weitgehend dem Block #pgv_lang[user_favorites_block]# der Seite #pgv_lang[mygedview]#. Im Gegensatz zur Konfiguration der Portalseite kann nur der Verwalter oder ein Benutzer mit Verwalterrechten diese Liste ändern.<br /><br />Dieser Block dient dazu, den Besucher auf besondere Personen aufmerksam zu machen. Die Favoriten dieses GEDCOM können auf jeder Seite aus einer Liste in der Kopfzeile ausgewählt werden.<br /><br />Wenn Sie den Namen klicken gelangen Sie zu dessen #pgv_lang[indi_info]# Seite.";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br /><br />Durch Eingaben in diesem Formular können Sie neue Lesezeichen zu Ihrer Liste hinzufügen.<br /><br />Sie müssen ein Personen-, Familien-, oder Quellen-ID eingeben oder danach in der Datenbank suchen.  Anstatt dessen, können Sie auch eine Internet-Adresse mit Titel eingeben.  Bemerke über das Lesezeichen können leer bleiben.  Bemerke die hier eingegeben sind werden im Lesezeichen Block als Unterschrift des jeweiligen Eintrages gezeigt.";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats]#~<br /><br />Dieser Block zeigt einige statistische Daten über die aktuelle Datenbank. Falls Sie weitere Informationen benötigen, senden Sie eine Nachricht an die Kontaktadresse am unteren Rand der Seite.";
$pgv_lang["index_common_names_help"]	= "~#pgv_lang[common_surnames]#~<br /><br />Hier werden Nachnamen, die in der Datenbank häufig vorkommen, gezeigt. Wenn Sie einen Namen klicken, gelangen Sie zur #pgv_lang[individual_list]#, wo Sie genauere Informationen zu diesem Namen erhalten.<br /><br />Die Anzahl der dargestellten Namen wird vom Verwalter bestimmt.";
$pgv_lang["index_common_given_names_help"]	= "~#pgv_lang[block_givn_top10]#~<br /><br />Hier werden Vornamen, die in der Datenbank häufig vorkommen, gezeigt. Männliche und weibliche Namen werden in Spalten gezeigt. Eine dritte Spalte wird gezeigt, wenn Personen mit unbekanntem Geschlecht vorhanden sind.<br /><br />Die Anzahl der dargestellten Namen wird vom Verwalter bestimmt.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />Bei jedem Besuch der Seite zeigt dieser Block ein anderes Bild oder eine andere Multimedia-Datei.<br /><br />Wenn Sie das Bild oder seinen Namen klicken, erhalten Sie das Bild in Originalgröße. Unterhalb des Bildes gibt es ein Link zur Person, mit der das Bild verbunden ist. Klicken Sie den Namen dieser Person, um zur persönlichen Seite der Person zu gelangen.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />In diesem Block werden die aktuell angemeldeten Benutzer angezeigt.<br /><br />Wenn Sie nicht Verwalter sind, ist Ihre Ansicht der angemeldeten Benutzer auf diejenigen beschränkt, die sich dafür entschieden haben, online sichtbar zu sein. Damit dies funktioniert, müssen Sie sich auch dafür entscheiden, online sichtbar zu sein. Online-Benutzer, die für Sie unsichtbar sind, gelten als anonym.";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br /><br />Der »#pgv_lang[gedcom_news]#«-Block ist als Tafel nützlich. Der Verwalter kann wichtige Ankündigungen oder interessante Neuigkeiten hier bekanntgeben.<br /><br />Wenn Sie etwas Interessantes veröffentlichen möchten, kontaktieren Sie bitte den Verwalter, der Ihre Meldung dann in diesem Block bekanntgeben kann.";
$pgv_lang["recent_changes_help"]		= "~#pgv_lang[recent_changes_block]#~<br /><br />Dieser Block zeigt Ihnen die jüngsten Änderungen in der GEDCOM-Datei, welche anhand des CHAN-tags erkannt werden.";
$pgv_lang["gedcom_news_limit_help"]		= "Sie können die Anzahl der dargestellten Notizen beschränken, so dass der #pgv_lang[gedcom_news_block]# Block nicht zu hoch wird.<br /><br />Diese Option bestimmt ob überhaupt Beschränkungen belegt sind, oder ob diese Beschränkungen das Alter oder die Anzal der Notizen berücksichtigen.";
$pgv_lang["gedcom_news_flag_help"]		= "Geben Sie den Beschränkungswert ein.<br /><br />Wenn Sie die Altersbeschränkung gewählt haben, verbirgt das Programm alle Notizen die älter als die eingegebenen Tage sind.  Wenn Sie die Anzahlbeschränkung gewählt haben, wird nur die eingegebene Anzahl von Notizen, jüngste Notizen zuerst, gezeigt.  Die restlichen Notizen sind verborgen.<br /><br />Falls Sie hier <b>0</b> (null) eingeben, entfällt jede Beschränkung der Notizenanzeige.";
$pgv_lang["gedcom_news_archive_help"]	= "Zum Reduzieren der Höhe des #pgv_lang[gedcom_news]# Blocks sind mehrere Notizen verborgen.  Wenn Sie <b>#pgv_lang[gedcom_news_archive]#</b> klicken, können Sie alle Notizen sehen.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Dieser Block erlaubt dem Verwalter bestimmte Informationen auf der Hauptseite zu zeigen.  Der Zweck ähnelt den #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, und #pgv_lang[gedcom_stats_block]# Blöcken, aber der Verwalter hat über sein Aussehen weitaus mehr Einfluss.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />Dieser Text soll leer oder sehr kurz sein.  Falls er leer ist, wird der #pgv_lang[htmlplus_block_name]# Block als einfacher Block gezeigt, genau wie der #pgv_lang[html_block_name]# Block.  Wenn Sie einen kurzen Text eingeben, ändert sich das Aussehen dieses Blocks so dass er, genau wie die anderen Blöcke, auch einen Titel hat.  Der eingegebene Text wird als Titel benutzt.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Ihnen sind einige Standard-Vorlagen zur Verfügung gestellt, damit Sie schneller mit diesem Block voran kommen.  Wenn Sie eine dieser Standard-Vorlagen wählen, wird dessen Inhalt in der Textbox gezeigt.  Sie können dann die Angaben Ihren Wünschen gemäß anpassen.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />Im Gegenteil zu den #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, und #pgv_lang[gedcom_stats_block]# Blöcken haben Sie vollen Einfluss über das Aussehen des Blocks.  In diesem Block können Sie <b>HTML tags</b> einfügen. Bitte achten Sie darauf, die Start- und End-Tags korrekt einzutragen. Dieses Programm verwendet <i>Style Sheets</i> (CSS). Jedes Theme hat seine eigene CSS-Datei. Sie können auch »Klassen« aus diesen Style-Sheets verwenden. Der Block kann Auszüge der Informationen der aktuellen Datenbank zeigen.<br /><br />Verweise auf Informationen der Datenbank sind als Stichwörter zwischen <b>&#35;</b> Zeichen erkennbar. Zum Beispiel, <b>&#35;totalFamilies&#35;</b> ist ein Verweis auf die Anzahl der Familien die sich in der Datenbank befinden.  Gelegentlich möchten Sie wahrscheinlich solche Texte nicht als Datenbank-Verweise sondern als normale Texte verwenden.  Um das zu bewirklichen, müssen Sie die <b>&#35;</b> Zeichen in ihren symbolischen Äquivalent ändern. Zum Beispiel, der Text <b>&&#35;35;totalFamilies&&#35;35;</b> wird nicht als Datenbank-Verweis erkannt, sondern wird als <b>&#35;totalFamilies&#35;</b> gezeigt.<br /><br />Ausführliche Beispiele für diesen Block finden Sie in Vorlage-Dateien die sich im »blocks/« Verzeichnis befinden. Die Vorlagen benutzen sogar Verweise auf Sprach-Dateien.<br /><br />Die <b>#pgv_lang[htmlplus_block_keyword]#</b> Vorlage enthält eine Liste aller unterstützten Datenbank-Verweise.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Diese Option schaltet den Kompatibilitäts-Modus ein. Falls eingeschaltet, werden die alten sowie die neuen Datenbank-Verweise richtig erkannt.<br /><br />Zum Beispiel, der Text <b>&#35;TOTAL_FAM&#35;</b> wird genau wie der Text <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> wie <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> wie <b>&#35;topTenLargestFamily&#35;</b>, usw bearbeitet.<br /><br />Ihnen wird empfohlen, diesen Modus nur wenn absolut notwendig zu benutzen.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Bitte wählen Sie eine Datenbank.<br /><br />Bei Ihnen sind mehrere Datenbanken vorhanden.  Verweise wie <b>&#35;totalFamilies&#35;</b> können nur eine Datenbank zugreifen.  Mit dieser Option können Sie die Datenbank bestimmen, die für alle solche Verweise benutzt wird.  Jeder #pgv_lang[htmlplus_block_name]# Block kann nur eine Datenbank zugreifen.";
$pgv_lang["showUnknown_help"]			= "~#pgv_lang[showUnknown]#~<br /><br />Zeige oder verberge die Vornamensliste von Personen mit unbekanntem Geschlecht.<br /><br />Der #pgv_lang[block_givn_top10]# Block verbirgt immer leere Vornamenslisten.  Durch diese Option können Sie die Vornamensliste von Personen mit unbekanntem Geschlecht immer verbergen, obwohl solche Personen in Ihrer Datenbank vorhanden sind.";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Natürlich wäre der Idealfall ein Programm, das so einfach zu benutzen ist, dass man keine Erklärungen benötigt. Es sollte so einfach sein, wie ein Buch zu lesen.<br /><br />Obwohl dieses Programm recht kompliziert und leistungsstark ist, sollte man das am Benutzerinterface kaum bemerken. Fast alles kann ohne Erklärungen benutzt werden. Weil es sicherlich auch viele Ahnenforscher gibt, die noch wenig Erfahrung mit Computern oder dem Internet haben, steht dieses Hilfesystem bereit.<br /><br />Im Hilfe-Menü stehen folgende Punkte zur Verfügung:";
$pgv_lang["help_page_help"]				= "<ul><li><b>Hilfe zu dieser Seite</b><br />Für alle Seiten gibt es eine allgemeine »Hilfe für diese Seite«.<br /><br />Wenn Sie auf einer beliebigen Seite sind, klicken Sie diesen Menüpunkt, um die Seitenhilfe zu erhalten, die Sie über die Objekte informiert, die sich auf dieser Seite befinden. Die Seitenhilfe ist in den meisten Fällen kurz gehalten.<br /><br />Falls Sie mehr Hilfe oder Informationen über ein bestimmtes Objekt auf der Seite benötigen, sollten Sie die »Kontext-bezogene Hilfe« Option des Hilfemenüs beachten.</li></ul>";
$pgv_lang["help_content_help"]			= "<ul><li><b>Hilfe Inhalt</b><br />Wenn Sie diesen Menüpunkt klicken, öffnet sich ein Fenster, das ein Verzeichnis der Haupt-Hilfethemen enthält.<br /><br />Dieses Verzeichnis wird voraussichtlich noch mit Hilfe-Unterthemen ergänzt.</li></ul>";
$pgv_lang["help_faq_help"]				= "<ul><li><b>FAQ List</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]				= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]				= "<ul><li><b>Kontext-bezogene Hilfe zeigen/verbergen</b><br />Dieser Menüpunkt kann sehr hilfreich sein. Wenn Sie dieses Link klicken, wird die »Kontext-Hilfe« ein- bzw. ausgeschaltet.<br /><br />Was ist das? Wenn sie aktiviert ist, sehen Sie ein Fragezeichen neben den meisten Links, Boxen oder Buttons. Wenn Sie dieses <b>#pgv_lang[qm]#</b> klicken, erscheint ein Fenster mit weiteren Informationen zu diesem Element.<br /><br />Wenn Sie »Kontext-bezogene Hilfe verbergen« klicken, werden alle diese Fragezeichen verborgen, bis Sie »Kontext-bezogene Hilfe zeigen« klicken.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]					= "<div class='name_head center'><b>DEFINITIONEN</b></div><br />Einige Erklärungen zu Begriffen in diesem Hilfetext:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a></li><li><a href=\"#def_gedcom_date\"><b>Daten</b></a></li><li><a href=\"#def_pdf_format\"><b><b>PDF Format</b></b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Theme</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Portal~<br /><br />Auf dieser Webseite ist das Portal so etwas wie ein Empfang im Hotel. Es ist der Ausgangspunkt für Ihren Besuch auf dieser Seite, der auch wichtige Informationen, Erklärungen und Menüs usw. enthält.";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM Datei~<br /><br />Zitat aus der Einleitung zum GEDCOM 5.5.1 Standard:<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Deutsche Version:<div class=\"list_value_wrap\">GEDCOM wurde von der Abteilung für Familien-Geschichte der Kirche Jesu Christi der Heiligen der Letzten Tage (HLT Kirche) entwickelt, mit dem Ziel ein einheitliches aber auch anpaßbares Format für den Tausch von computer-liesbaren genealogischen Daten zu erstellen.&nbsp; GEDCOM ist ein Akronym von <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication.&nbsp; (Verbreitung von Daten der Ahnenforschung)&nbsp; Zum Zweck ist das Fördern des Tausches genealogischer Informationen und das Entwickeln von einer großen Reihe zusammenarbeitender Ahnenforschungs-Software für Ahnenforscher, Historiker, und andere.</div><br />Der GEDCOM 5.5.1 <u>vorläufige</u> Standard, nach dem sich PhpGedView richtet, kann als PDF-Datei von hier übertragen werden:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Bitte beachten Sie, dass dieser Standard nur in der englischen Sprache erhältlich ist.<br /><br />GEDCOM-Dateien enthalten alle Informationen über je einen Stammbaum. Alle Ereignisse, Daten, Namen usw. sind in der GEDCOM-Datei gespeichert. GEDCOM-Dateien enthalten diese Daten nach einer strengen Syntax, damit sie austauschbar bleiben, unabhängig von dem verwendeten Programm, dem Betriebssystem oder benutzten Rechner.";
$pgv_lang["def_gedcom_date_help"]		= "~Datumsangaben~<br /><br />Da die Datumsangaben innerhalb einer GEDCOM-Datei internationalen Regeln folgen müssen, gibt es eine einheitliche Schreibweise dafür. Obwohl das Datums-Feld freie Texteingabe erlaubt, sollten Sie folgende Beschreibungen beachten:<ul><li>Genaue Daten werden immer in der Form TT MMM JJJJ eingegeben.  Z.B., <b>01&nbsp;MAR&nbsp;1801</b> oder <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Bei ungenauen Daten, wo Ihnen ein Teil unbekannt ist, können Sie den unbekannten Teil weglassen.  Z.B. <b>MAR&nbsp;1801</b> oder <b>14&nbsp;DEC</b>.</li><li>Wenn Sie nicht über das Datum sicher sind, oder bei unbestätigten Daten, können Sie z.B. <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = ungefähr), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = vor), <b>AFT&nbsp;1949</b> (aft = after = nach) eingeben.</li><li>Datenbereiche werden in folgenden Formen eingegeben: <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> (from = von, to = bis) oder <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = zwischen ; and = und)<br /><br /><b>FROM</b> deutet an, dass das beschriebene Ereignis dauernd während diesem Zeitraum statt fand, und wird bei Ereignissen wie Berufen benutzt. <b>BET</b> deutet an, dass das beschriebene Ereignis einmal irgendwann in diesem Zeitraum statt fand, und wird bei Ereignissen wie Geburten benutzt.<br /><br />Bei ungenauen Datenangaben, wo der Tag oder der Monat fehlt, werden immer der erste oder der letze mögliche Tag angenommen, abhängig davon, ob dieses ungenaue Datum vor oder hinter den Wörtern TO oder AND vorkommt.  Z.B., <b>FEB&nbsp;1804</b> bedeutet <b>01&nbsp;FEB&nbsp;1804</b> wenn das Datum vor den Wörtern TO oder AND eingegeben wird, und <b>29&nbsp;FEB&nbsp;1804</b> wenn es hinter diesen Wörtern vorkommt.</li></ul><br /><b>Achten Sie darauf, die Daten und die Abkürzungen in englischer Sprache einzutragen,</b> damit die GEDCOM-Datei austauschbar bleibt und alle Programme Ihre Angaben richtig verstehen und berechnen können. Das Programm stellt mit Ihren Datumsangaben auch Berechnungen an. Wenn Daten fehlerhaft eingegeben sind, liefert das Programm falsche Berechnungen.<br /><br />Folgende Abkürzungen werden verwendet:<ul><li>JAN = January = Januar</li><li>FEB = February = Februar</li><li>MAR = March = März</li><li>APR = April</li><li>MAY = Mai</li><li>JUN = June = Juni</li><li>JUL = July = Juli</li><li>AUG = August</li><li>SEP = September</li><li>OCT = October = Oktober</li><li>NOV = November</li><li>DEC = December = Dezember</li><li>bef before = vor</li><li>abt about = ungefähr</li><li>aft after = nach</li></ul>";
$pgv_lang["def_gramps_help"]			= "~GRAMPS XML Dateien~<br /><br />Zitat aus der Beschreibung des GRAMPS Projekts:<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Deutsche Version:<div class=\"list_value_wrap\">GRAMPS hilft Ihnen, Ihrem Stammbaum zu folgen.&nbsp; Sie können genealogische Daten speichern, bearbeiten, und nachforschen.&nbsp; GRAMPS versucht, alle Funktionen, die andere genealogische Programme gemeinsam haben, zu unterstützen.&nbsp; Aber, was viel wichtiger und nicht in den meisten anderen Programmen vorhanden ist, GRAMPS versucht auch bessere Integrations-Methoden zu unterstützen.&nbsp; Mit GRAMPS können Sie Informationen teilweise in die Datenbank eingeben, und dann Ereignisse einzeln oder zusammen umsortieren oder anders bearbeiten wie Sie möchten.&nbsp; GRAMPS ermöglicht leichte Forschung, Analyse, und Beziehungsermittlung der genealogischen Daten um Lücken darin zu füllen.</div><br />Links zur Beschreibung von GRAMPS XML v1.1.0 im RELAX NG Schema und auch im DTD Format sind <b><a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">hier</a></b> zu finden. Um mehr Auskunft über das GRAMPS Projekt zu finden, sollten Sie sich an die <b><a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a></b> Hauptseite wenden. Informationen über GRAMPS sind leider nur in der englischen Sprache erhältlich.";
$pgv_lang["def_pgv_help"]				= "~PhpGedView~<br /><br />PhpGedView (oder PGV) liefert nicht nur statische Seiten ins Internet, sondern arbeitet dynamisch und kann vielen Bereichen angepasst werden.<br /><br />PhpGedView wurde von John Finlay entwickelt, um GEDCOM Dateien über das Internet zu betrachten.  John begann die Entwicklung allein aber inzwischen arbeitet ein internationales Team von Entwicklern und Übersetzern zusammen, um dieses Programm zu verbessern. Außer dem bloßen Betrachten von GEDCOM-Dateien, können berechtigte Benutzer auch zusammen arbeiten, und Ereignisse online hinzufügen oder editieren.";
$pgv_lang["def_theme_help"]				= "~Theme~<br /><br />Diese Seite kann unterschiedlich aussehen (in Bezug auf Farben, Anordnung der Elemente usw.), was durch sogenannte Themes erreicht wird. Der Verwalter wählt zunächst ein Standard-Theme aus. So sieht die Seite zunächst einmal für jeden Besucher gleich aus.<br /><br />Sofern vom Verwalter erlaubt, können Besucher aber auch ihr Lieblings-Theme aus einer Liste vorhandener Themes wählen. Wenn ein Benutzer sein bevorzugtes Theme gewählt hat, erscheint die Seite für ihn in diesem Aussehen, sobald er sich wieder angemeldet hat.<br /><br />Mithilfe von Themen können verschiedene Datenbanken auf derselben Site unterschieden werden. Jede Datenbank kann ein anderes Standardthema haben.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br /><br />Dies ist Ihre persönliche #pgv_lang[mygedview]# Seite.<br /><br />Sie finden hier Links zu Ihren persönlichen Daten wie <b>Meine Benutzerdaten, Mein Datenblatt</b> (das ist die Seite mit Informationen zu Ihrer Person), <b>Mein Stammbaum</b>. Außerdem können hier die Blöcke <b>Nachrichten</b>, <b>Journal</b> (wie ein Notizbuch) und weitere enthalten sein.<br /><br />Das Layout dieser Seite entspricht dem der Begrüßungs-Seite. Whrend die Begrüßungs-Seite vom Verwalter zusammengestellt wird, können Sie diese Seite selbst zusammenstellen. Das Link zum Anpassen dieser Seite finden Sie entweder im Willkommen-Block oder separat auf dieser Seite.<br /><br />Sie können folgende Blöcke und Links wählen:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>»#pgv_lang[mygedview]#« anpassen</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]	= "~#pgv_lang[mygedview]# ANPASSEN~<br /><br />Wenn Sie das erste Mal zur #pgv_lang[mygedview]# Seite kommen, sind schon einige Blöcke vorhanden.<br /><br />Wenn Sie möchten, können Sie diese Seite Ihren Wünschen anpassen. Klicken Sie dieses Link und Sie gelangen zu einem Formular in einem Fenster, in dem Sie Blöcke hinzufügen, löschen oder verlegen können. Weitere Hilfe finden Sie in diesem Formular.";
$pgv_lang["mygedview_message_help"]		= "~#pgv_lang[user_messages_block]#~<br /><br />In diesem Block finden Sie die Nachrichten, die Ihnen von anderen Benutzern oder vom Verwalter zugesandt wurden.<br /><br />Natürlich können Sie auch selbst Nachrichten an andere Benutzer schicken. Dieses Mail-System unterstützt den Schutz Ihrer persönlichen Daten. Da Sie Ihre Mail-Adresse nicht angeben müssen, können andere sie auch nicht sehen.<br /><br />Um eine Nachricht zu zeigen, klicken Sie die Betreffzeile oder das »+« Zeichen neben der Nachricht. Sie können mehrere Nachrichten auf einmal löschen, indem Sie die Kästchen neben den Nachrichten ankreuzen und auf »Gewählte Nachrichten löschen« klicken.";
$pgv_lang["mygedview_favorites_help"]	= "~#pgv_lang[user_favorites_block]#~<br /><br />»Meine Lesezeichen« arbeitet genauso wie gewöhnliche Lesezeichen.<br /><br />Angenommen Sie haben jemanden in Ihrem Stammbaum, dessen Eintrag Sie regelmäßig überprüfen möchten. Gehen Sie einfach zur Seite mit den persönlichen Informationen dieser Person und wählen Sie »Lesezeichen hinzufügen« aus dem Menü »Meine Lesezeichen«. Auf diese Person haben Sie nun ein Lesezeichen gesetzt, das in der Liste Ihrer Lesezeichen erscheint. Gleich auf welcher Seite in PhpGedView Sie sich befinden, können Sie immer einen Namen der Liste »Meine Lesezeichen« klicken. Dann gelangen Sie zur Seite mit persönlichen Informationen zu dieser Person.<br /><br />Wenn Sie den Namen klicken, gelangen Sie zur Seite mit den persönlichen Informationen dieser Person.";
$pgv_lang["mygedview_myjournal_help"]	= "~#pgv_lang[user_news_block]#~<br /><br />Sie können dieses Portal benutzen, um Notizen (oder Erinnerungen) für Ihren eigenen Gebrauch aufzuschreiben. Diese Notizen stehen Ihnen natürlich auch noch zur Verfügung, wenn Sie die Seite das nächste Mal besuchen.<br /><br />Diese Notizen sind für andere nicht sichtbar.";
$pgv_lang["mygedview_welcome_help"]		= "~#pgv_lang[welcome_block]#~<br /><br />Der Willkommen-Block zeigt Ihnen:<ul><li>Die aktuelle GEDCOM-Datei</li><li>Das Datum und die Uhrzeit</li><li>Links zu:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Anmerkung</b><br />Sie sehen die Links zu »#pgv_lang[my_indi]#« und »#pgv_lang[my_pedigree]#« nur, wenn Sie selbst als Person in der GEDCOM-Datei eingetragen sind. Daher kann es vorkommen, dass diese Links vorhanden sind oder fehlen.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~DIE STAMMBAUM SEITE~<br /><br />Die meisten Besucher wissen was ein Stammbaum ist, aber dennoch gibt es wichtige Zusatzinformationen zu diesem Stammbaum:<br />Dieser Stammbaum ist im wesentlichen eine Aufzählung aller Vorfahren der Ausgangsperson. Wenn Sie diese Seite aus dem Hauptmenü aufrufen, sehen Sie die Startperson in der Box ganz links.  Wenn Sie angemeldet sind, können Sie diese Startperson auch ändern.<br /><br />»Alle Vorfahren« bedeutet also Vater und Mutter, deren Eltern usw. Auf dieser Seite sehen Sie den Stammbaum als graphische Darstellung. Sie müssen nicht durch Seiten voller Text blättern, um Ihre Vorfahren zu finden. Jede Person wird in einer Namens-Box dargestellt.<br /><ul><li><b>Personen Boxen im Stammbaum</b><br />Wenn Sie »Details zeigen« gewählt haben, werden einige Grundinformationen, sofern bekannt, (z.B. Geburtsdatum) über jede Person in ihrer Box dargestellt. Sie können den Namen einer Person klicken, um zur Seite mit den persönlichen Details dieser Person zu gelangen. Wenn Sie »Details zeigen« gewählt haben, erscheinen zwei Symbole in der Namens-Box.</li><li><b>Stammbaum Symbol in der Namens-Box</b><br />Wenn Sie »Details zeigen« gewählt haben, sehen Sie ein Stammbaum-Symbol in der Namens-Box. Je nach Einstellung müssen Sie mit der Maus darüberfahren oder darauf klicken, um ein Menü zu erhalten. Der »Stammbaum« und der »Nachfahren-Baum« entsprechen denen im Hauptmenü, wobei die Start-Person dann diejenige ist, in deren Box Sie das Symbol geklickt haben. Außerdem sehen Sie »Familie mit Ehepartner«. Sie sehen den Namen des Ehepartners gefolgt von den Namen der Kinder. Alle Namen können geklickt werden.</li><li><b>Lupen-Symbol in den Boxen</b><br />Je nach Einstellung müssen Sie mit der Maus darüberfahren oder darauf klicken. Die gewählte Box wird dann vergrößert und es werden zusätzliche Informationen über die Person eingeblendet.</li><li><b>Pfeile</b><br />Auf der linken bzw. rechten Seite der äußersten Boxen werden eventuell Pfeile gezeigt. Klicken Sie diese Pfeile, um die Ansicht in die entsprechende Richtung zu verschieben.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]				= "~#pgv_lang[show_details]#~<br /><br />Mit dieser Option können Sie alle Details in den Namen-Boxen ein- oder ausblenden. Wenn die Details ausgeblendet sind, passen mehr Boxen auf den Bildschirm.<br /><br />Wenn alle Details verborgen sind, ist das unten beschriebene Zoom-Ikon nicht sichtbar. Wenn der Verwalter die Zoomfunktion aktiviert hat, verhält sich das gesamte Feld wie ein Zoom-Ikon, um alle Details der Person sichtbar zu machen.<br /><br />Wenn die Details nicht verborgen sind und die durch ein Lupen-Ikon gekennzeichnete Zoomfunktion vom Verwalter aktiviert ist, können Sie noch mehr Details zu dieser Person sichtbar machen. Wenn Sie normalerweise das Zoom-Ikon klicken müssen, können Sie zusätzliche versteckte Details sehen, indem Sie hier das Ikon klicken. Wenn Sie durch Bewegen des Mauszeigers über das Zoomsymbol zoomen können, werden versteckte Details gezeigt, wenn Sie den Mauszeiger über dieses Ikon bewegen.<br /><br />Wenn Sie das Zoom-Ikon geklickt haben, um weitere Details zu sehen, können Sie normale Details wiederherstellen, indem Sie erneut das Zoom-Ikon klicken. Wenn Sie durch einfaches Bewegen des Mauszeigers über das Zoom-Ikon weitere Details gezeigt haben, werden normale Details wiederhergestellt, wenn Sie den Mauszeiger vom Zoom-Ikon wegbewegen.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Mit dieser Option können Sie die Seitenausrichtung anpassen.<br /><br />Verändern Sie diese Einstellung z.B. für einen Druck oder falls Sie einen Hochformat-Bildschirm haben.<ul><li>Im <b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;wird der Baum etwas schmaler, so dass ein Diagramm über 4 Generationen noch auf eine Seite passen sollte.</li><li>Im <b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;sollte ein Diagramm mit 4 Generationen quergedruckt auf eine einzelne Seite passen.</li><li>Im Format <b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;ist das ganze Diagramm, aber nicht seine Boxen, um 90 Grad gegen den Uhrzeigersinn gedreht, so dass die älteste Generation oben auf der Seite gezeigt wird.</li><li>Im Format <b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;ist das ganze Diagramm, aber nicht seine Boxen, um 90 Grad im Uhrzeigersinn gedreht, so dass die älteste Generation unten auf der Seite gezeigt wird.</li></ul>";
$pgv_lang["rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Wenn Sie einen Stammbaum ausgehend von einer anderen Person sehen möchten, können Sie in dieses Feld die ID-Nummer der gewünschten Person eintragen. Wenn Sie die ID-Nummer nicht kennen, benutzen Sie einfach <b>ID suchen</b>.<br /><br /><b>ID NUMMER (=Identifikationsnummer)</b><br />Die ID-Nummern, die in PhpGedView benutzt werden, haben nichts zu tun mit z.B. der Personalausweisnummer oder der Führerscheinnummer. Die ID-Nummer ist nur eine Nummer, die in der GEDCOM-Datei benutzt wird und von der Genealogie-Software vergeben wird, um die GEDCOM-Datei zu erstellen.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[generations]#~<br /><br />Hier können Sie einstellen, wie viele Generationen auf dieser Seite dargestellt werden.<br /><br />Welche Einstellung für Sie optimal ist hängt auch von der Größe oder Auflösung Ihres Bildschirmes ab und ob z.B. die Details ein- oder ausgeblendet sind.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~#pgv_lang[login]#~<br /><br />Auf dieser Seite können Sie sich anmelden, ein neues Kennwort beantragen, oder einen Benutzer-Zugang beantragen.";
$pgv_lang["username_help"]				= "~#pgv_lang[username]#~<br /><br />Geben Sie in dieses Feld Ihren Benutzernamen ein.<br /><br /><b>Bitte beachten Sie die Groß- und Kleinschreibung.</b>  Dies bedeutet, dass <b>MeinName</b> <u>nicht</u> mit <b>meinname</b> oder <b>MEINNAME</b> identisch ist.";
$pgv_lang["password_help"]				= "~#pgv_lang[password]#~<br /><br />Geben Sie hier Ihr Kennwort ein.<br /><br /><b>Bitte beachten Sie die Groß- und Kleinschreibung.</b>  Dies bedeutet, dass <b>MeinKennwort</b> <u>nicht</u> mit <b>meinkennwort</b> oder <b>MEINKENNWORT</b> identisch ist.";
$pgv_lang["login_buttons_help"]			= "~LOGIN BUTTON~<br /><br />Es gibt hier einen Button, um sich anzumelden.<br /><br />Klicken Sie diesen Button, um zu der Seite zu gelangen, von welcher Sie die Login-Seite aufgerufen haben, allerdings nun mit den Ihnen zugewiesenen Zugriffs-Rechten.<br /><br />Wenn Sie also den <b>#pgv_lang[login]#</b> Button auf der Stammbaum-Seite geklickt haben, gelangen Sie zurück zur Stammbaum-Seite. Wenn Sie auf der Hauptseite auf diesen Button geklickt haben, werden Sie zur Seite »#pgv_lang[mygedview]#« weitergeleitet.  Von dieser Seite aus können Sie Ihre Einstellungen bearbeiten, Favoriten hinzufügen oder bearbeiten, Nachrichten senden und lesen, usw.";
$pgv_lang["login_buttons_aut_help"]		= "~LOGIN BUTTON~<br /><br />Es gibt hier einen Button, um sich anzumelden.<br /><br />Wenn Sie auf diesen Button geklickt haben, werden Sie zur Seite »#pgv_lang[mygedview]#« weitergeleitet, allerdings nun mit den Ihnen zugewiesenen Zugriffs-Rechten.  Von dieser Seite aus können Sie Ihre Einstellungen bearbeiten, Favoriten hinzufügen oder bearbeiten, Nachrichten senden und lesen, usw.";
$pgv_lang["new_password_help"]			= "~#pgv_lang[requestpassword]#~<br /><br />Wenn Sie Ihr Kennwort vergessen haben, klicken Sie dieses Link, um ein neues anzufordern.<br /><br />Sie werden zur Seite »#pgv_lang[lost_pw_reset]#« weitergeleitet.";
$pgv_lang["new_user_help"]				= "~#pgv_lang[requestaccount]#~<br /><br />Wenn Sie als Besucher dieser Site einen Benutzer-Zugang beantragen möchten, klicken Sie dieses Link.<br /><br />Abhängig davon, wie der Verwalter die Site eingerichtet hat, wird Ihr E-Mail-Client gestartet, so dass Sie dem Verwalter eine E-Mail senden können, um ein neues Nutzer-ID anzufordern, oder Sie werden zur Seite »#pgv_lang[requestaccount]#« weitergeleitet.";
$pgv_lang["mygedview_login_help"]		= "Um das »#pgv_lang[mygedview]#« zu sehen, müssen Sie als Benutzer eingetragen sein. Mit dem »#pgv_lang[mygedview]#« können Sie Lesezeichen auf Personen setzen, die Ihnen wichtig sind, ein Journal führen, Nachrichten verwalten, andere angemeldete Benutzer sehen und PhpGedView an Ihre Bedürfnisse anpassen.<br /><br />Geben Sie Ihren Benutzernamen und Ihr Kennwort in die jeweiligen Felder ein, um sich beim »#pgv_lang[mygedview]#« anzumelden.";
$pgv_lang["new_user_firstname_help"]	= "~#pgv_lang[firstname]#~<br /><br />Bitte geben Sie Ihren Vornamen.<br /><br />Ihre Vor- und Nachnamen sind notwendig um zu ermitteln welche Zugangs- und Zugriffsrechte Ihnen gestattet werden können.  Bitte beachten Sie, dass Ihr Name nachdem Sie sich angemeldet haben, auch anderen angemeldeten Benutzern gezeigt werden kann.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />Bitte geben Sie Ihren Nachnamen.<br /><br />Ihre Vor- und Nachnamen sind notwendig um zu ermitteln welche Zugangs- und Zugriffsrechte Ihnen gestattet werden können.  Bitte beachten Sie, dass Ihr Name nachdem Sie sich angemeldet haben, auch anderen angemeldeten Benutzern gezeigt werden kann.";
$pgv_lang["register_info_01"]			= "~#pgv_lang[requestaccount]#~<br /><br />Die Daten, die hier öffentlich sichtbar sind, können aus gesetzlichen oder Datenschutzgründen beschränkt sein.  Viele möchten nicht, dass ihre persönliche Informationen dem Publikum gezeigt werden.  Solche Daten könnten für kriminelle Zwecke abgewendet werden.<br /><br />Zugriff zu persönlichen Daten dieser Seiten ist allen angemeldeten Benutzern gestattet.  Nachdem der Verwalter Ihren Zugangsantrag genehmigt hat, können Sie sich hier mit Ihrem Benutzer-ID und Kennwort anmelden.<br /><br />Falls vom Verwalter eingeschaltet, können Sie nachdem Sie sich angemeldet haben, nur die Persönlichen Daten Ihrer nahen Verwandten sehen.  Der Verwalter kann auch bestimmten Benutzern gestatten, Daten der Datenbank zu ändern oder neue Daten hinzuzufügen.<br /><br />Falls Sie mehr Hilfe brauchen, sollten Sie sich durch das Link am unteren Rand der Seite an den Verwalter wenden.";
$pgv_lang["register_info_02"]			= "~#pgv_lang[requestaccount]#~<br /><br />Die Daten, die hier öffentlich sichtbar sind, können aus gesetzlichen oder Datenschutzgründen beschränkt sein.  Viele möchten nicht, dass ihre persönliche Informationen dem Publikum gezeigt werden.  Solche Daten könnten für kriminelle Zwecke abgewendet werden.<br /><br />Zugriff zu diesen Seiten ist nur <u>angemeldeten</u> Benutzern gestattet.  Nachdem der Verwalter Ihren Zugangsantrag genehmigt hat, können Sie sich hier mit Ihrem Benutzer-ID und Kennwort anmelden.<br /><br />Falls vom Verwalter eingeschaltet, können Sie nachdem Sie sich angemeldet haben, nur die Persönlichen Daten Ihrer nahen Verwandten sehen.  Der Verwalter kann auch bestimmten Benutzern gestatten, Daten der Datenbank zu ändern oder neue Daten hinzuzufügen.<br /><br />Falls Sie mehr Hilfe brauchen, sollten Sie sich durch das Link am unteren Rand der Seite an den Verwalter wenden.";
$pgv_lang["register_info_03"]			= "~#pgv_lang[requestaccount]#~<br /><br />Die Daten, die hier öffentlich sichtbar sind, können aus gesetzlichen oder Datenschutzgründen beschränkt sein.  Viele möchten nicht, dass ihre persönliche Informationen dem Publikum gezeigt werden.  Solche Daten könnten für kriminelle Zwecke abgewendet werden.<br /><br />Zugriff zu diesen Seiten ist nur <u>Familienmitgliedern</u> gestattet.  Nachdem der Verwalter Ihren Zugangsantrag genehmigt hat, können Sie sich hier mit Ihrem Benutzer-ID und Kennwort anmelden.<br /><br />Falls vom Verwalter eingeschaltet, können Sie nachdem Sie sich angemeldet haben, nur die Persönlichen Daten Ihrer nahen Verwandten sehen.  Der Verwalter kann auch bestimmten Benutzern gestatten, Daten der Datenbank zu ändern oder neue Daten hinzuzufügen.<br /><br />Falls Sie mehr Hilfe brauchen, sollten Sie sich durch das Link am unteren Rand der Seite an den Verwalter wenden.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Diese Seite zeigt die Nachfahren einer Person.<br /><br />Sie können eine Start-Person für diesen Nachfahren-Baum auf dieser Seite wählen, oder Sie können auf einer anderen Seite »Nachfahrenbaum« klicken, um zu dieser Seite zu gelangen. Klicken Sie den »nach-oben«-Pfeil, um im Baum nach oben zu navigieren. Klicken Sie das Diagramme-Icon in einer Personen-Box, um diese Person als Startperson für Diagramme zu wählen.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br /><br />Auf diesem Diagramm können die Lebensspannen mehrerer Personen gezeigt werden.  Anhand einer Skala können Sie leicht erkennen, wie die Geburts- und Todesjahre verschiedener Personen sich überschneiden.<br /><br />Sie können einzelne Personen oder ganze Familien dem bereits bestehendem Diagramm hinzufügen.  Das Diagramm kann jederzeit durch das Klicken des <b>#pgv_lang[clear_chart]#</b> Buttons gelöscht werden.<br /><br />Sie können auch Personen dem Diagramm hinzufügen indem Sie die Datenbank nach bestimmten Daten oder Orten durchsuchen.";
$pgv_lang["lifespan_add_person_help"]	= "#pgv_lang[add_person_help]#~pgv_lang[include_famly] Box~<br /><br />Standardmäßig ist diese Option angekreuzt.  Falls angekreuzt, werden Vater, Mutter, Ehepartner, Geschwister, und Kinder sowie die erwähnte Person dem Diagramm hinzugefügt. Falls nicht angekreuzt, wird nur die erwähnte Person dem Diagramm hinzugefügt.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />Auf dieser Seite können Sie eine oder mehrere Personen auf einer Zeitleiste darstellen. So können Sie zum Beispiel veranschaulichen wie alt Personen oder deren Verwandte an bestimmten Stationen ihres Lebens waren.<br /><br />Wenn Sie <b>#pgv_lang[timeline_chart]#</b> auf anderen Seiten klicken, finden Sie schon eine Person in dem Diagramm.  Wenn Sie die<br /><b>#pgv_lang[timeline_chart]#</b> Option im Menü des Kopfbereiches der Seite wählen, erscheint die vom Verwalter als Startperson bestimmte Person in dem Diagramm.";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Sie können mehrere Personen auf der Zeitleiste darstellen.<br /><br />Geben Sie in dieses Feld die ID einer weiteren Person ein. Wenn Sie die ID der Person nicht kennen, benutzen Sie  »ID suchen« hinter dem Eingabefeld.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Klicken Sie dieses Link, um die Person von der Zeitleiste zu entfernen.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Wenn Sie dieses Feld aktivieren, wird ein Alters-Feld eingeblendet, das man auf der Zeitleiste verschieben kann.<br /><br />Dieser Altersanker ist nützlich, um das Alter einer Person bei einem bestimmten Ereignis zu prüfen. Für jede Person im Diagramm kann man den Altersanker ein- oder ausschalten.";
$pgv_lang["timeline_control_help"]		= "~#pgv_lang[timeline_controls]#~<br /><br />~#pgv_lang[timeline_scrollSpeed]#~<br />Aus dem Menü können Sie eine Ihnen passende Blättergeschwindigkeit wählen.<br /><br />~#pgv_lang[timeline_beginYear]#~<br />Geben Sie das Anfangsjahr des Bereiches.<br /><br />~#pgv_lang[timeline_endYear]#~<br />Geben Sie das Endjahr des Bereiches.<br /><br />~#pgv_lang[search]#~<br />Wenn Sie diesen Button klicken, wird die Datenbank nach allen Ereignissen durchsucht, die in dem gegebenen Jahresbereich statt fanden.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />Auf dieser Seite kann der Verwandtschafts-Grad zwischen zwei Personen dargestellt werden. Dies bedeutet nicht, dass die Personen direkte Blutsverwandtschaft haben müssen. Jegliche Verwandtschaft wird gefunden.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Wenn Sie von einer anderen Seite zu dieser weitergeleitet wurden, indem Sie z.B. »Verwandtschaft zu mir« benutzt haben, werden Sie hier den Verwandtschaftsgrad zwischen diesen Personen sehen.<br /><br />Andernfalls müssen Sie die ID-Nummern von 2 Personen eingeben, deren Verwandtschafts-Grad zueinander Sie erfahren möchten. Wenn Sie die ID-Nummern nicht kennen, klicken Sie »ID suchen«.";
$pgv_lang["next_path_help"]				= "~#pgv_lang[next_path]#~<br /><br />Klicken Sie diesen Button, um zu prüfen, ob es einen weiteren Verwandtschafts-Pfad gibt, der diese beiden Personen verbindet. Zuvor gefundene Pfade können wieder gezeigt werden, indem man die entsprechende Pfad-Nummer klickt.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Wenn diese Option <u>nicht</u> aktiviert ist, werden nur Blutsverwandtschaften überprüft. Wenn diese Option aktiviert ist, werden auch Verwandtschaften durch Eheschließungen berücksichtigt. Es ist wahrscheinlich, dass mehr Zusammenhänge gefunden werden, wenn Sie diese Box aktivieren.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />Wenn Sie diese Option aktivieren, werden im Diagramm alle Personen, die der gleichen Generation angehören, nebeneinander auf einer Ebene dargestellt. Wenn diese Option nicht aktiviert ist, werden die Personen in einer Linie untereinander dargestellt, ganz gleich ob das Verhältnis zur vorigen Person Eltern oder Kind ist.";
$pgv_lang["oldest_top_help"]				= "~#pgv_lang[oldest_top]#~<br /><br />Wenn diese Option aktiviert ist, werden im Diagramm die ältesten Personen zuoberst gezeigt. Andernfalls stehen die jüngsten Personen oben.<br /><br />Anmerkung: Diese Option funktioniert nur, wenn das Feld <i>#pgv_lang[line_up_generations]#</i> aktiviert ist.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]# page~<br /><br />Die #pgv_lang[ancestry_chart]#-Seite ist der <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#-Seite</a> sehr ähnlich, zeigt aber mehr Details und bietet mehrere <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#en</a>.<br /><br />Jeder Vorfahre wird mit einer Nummer nach dem <i>Sosa-Stradonitz</i> System gekennzeichnet:<div style=\"padding-left:30px;\"><b>Gerade</b> Zahlen für Männer (Nummer des Kindes * 2)<br /><b>Ungerade</b> für Frauen (Nummer des Partners + 1) außer bei Nummer <b>1</b></div><br />Beispiel:<br /><div style=\"padding-left:30px;\">Die Anfangsperson hat Nummer <b>1</b>, ohne Rücksicht auf Geschlecht.<br />Vater von <b>1</b> hat Nummer <b>2</b> (<b>1</b> * 2), Mutter hat Nummer <b>3</b> (<b>2</b> + 1).<br /> Vater von <b>2</b> hat Nummer <b>4</b> (<b>2</b> * 2), Mutter hat Nummer <b>5</b> (<b>4</b> + 1).<br />Vater von <b>3</b> hat Nummer <b>6</b> (<b>3</b> * 2), Mutter hat Nummer <b>7</b> (<b>6</b> + 1).<br />Vater von <b>7</b> hat Nummer <b>14</b> (<b>7</b> * 2), Mutter hat Nummer <b>15</b> (<b>14</b> +1).<br />usw.</div>";
$pgv_lang["box_width_help"]				= "~#pgv_lang[ancestry_chart]# Box Breite~</b><br /><br />Hier können Sie die Box-Breite zwischen 50% und 300% verändern. Standard-Wert ist 100%: die Box-Breite beträgt dann ca. 270 Pixel.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# Diagramm Typ~<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Vertikaler Baum mit ein-/ausblendbaren Familien</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Eine Familie pro Seite mit Eltern, Großeltern und allen erfassten Kindern. Gut zum Druck und zur Weitergabe an Verwandte geeignet.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]# Seite~<br /><br />Das #pgv_lang[fan_chart]# ist dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> sehr ähnlich, bietet aber eine grafische Darstellung.<br /><br />Die Startperson steht in der Mitte, deren Eltern im ersten Ring, Großeltern im zweiten Ring usw.<br /><br />Geburts- und Todesdaten erscheinen unter den Namen wenn bekannt.<br /><br />Wenn Sie einen Namen im Diagramm klicken, wird diese Person als neue Startperson festgelegt, und erscheint dann in der Mitte. Bei der Person in der Mitte ist ein Pfeil zu sehen, der beim Klicken ein Menü öffnet, mit dem Sie eines der Kinder oder Geschwister der Person als neue Startperson wählen können (gleiche Arbeitsweise wie beim <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>).";
$pgv_lang["fan_width_help"]				= "~#pgv_lang[fan_width]#~</b><br /><br />Hier können Sie die Breite des Kreisdiagramms zwischen 50% und 300% verändern. Standard-Wert ist 100%: die Diagramm-Breite beträgt dann ca. 640 Pixel.";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]# style~<br /><br />This option controls the appearance of the diagram.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Halbkreis (180&deg;) Kreis-Diagramm</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Drei-Viertel (270&deg;) Kreis-Diagramm oder <i>Engels-Flügel</i></li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Vollkreis (360&deg;) Kreis-Diagramm</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Das #pgv_lang[hourglass_chart]# zeigt Vor- und Nachfahren der Startperson im selben Diagramm.  Es ist also eine Mischung zwischen dem #pgv_lang[decendancy_chart]# und dem #pgv_lang[pedigree_chart]#.<br /><br />Die Startperson wird in der Mitte der Seite dargestellt, mit dessen Nachfahren links und Vorfahren rechts.  In dieser Darstellung sind Personen der selben Generation in Spalten aufgeführt, angefangen mit der jüngsten am linken Rand der Seite.<br /><br />Wenn Sie den unter der Startperson sichtbaren Pfeil klicken, erhalten Sie eine Liste der nahen Verwandten dieser Person.  Wenn Sie danach den Namen einer dieser nahen Verwandten klicken, erhalten Sie ein #pgv_lang[hourglass_chart]# worin diese Person als neue Startperson benutzt ist.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]		= "~#pgv_lang[familybook_chart]#~<br /><br />In diesem Diagramm sind mehrere Sanduhr-Diagramme dargestellt. Das erste #pgv_lang[hourglass_chart]# benutzt als Startperson die eingegebene Person.  Weitere Sanduhr-Diagramme benutzen als Startperson alle Nachfahren der ersten Startperson, bis alle Nachfahren-Generationen gemäß der eingegebenen Anzahl dargestellt sind. Jedes #pgv_lang[hourglass_chart]# zeigt Vor- und Nachfahren der Startperson im selben Diagramm.<br /><br />Die Startperson wird in der Mitte der Seite dargestellt, mit dessen Nachfahren links und Vorfahren rechts.  In dieser Darstellung sind Personen der selben Generation in Spalten aufgeführt, angefangen mit der jüngsten am linken Rand der Seite.<br /><br />Wenn Sie den unter der Startperson sichtbaren Pfeil klicken, erhalten Sie eine Liste der nahen Verwandten dieser Person.  Wenn Sie danach den Namen einer dieser nahen Verwandten klicken, erhalten Sie ein #pgv_lang[familybook_chart]# worin diese Person als neue Startperson benutzt ist.";
$pgv_lang["fambook_descent_help"]		= "~#pgv_lang[descent_steps]#~<br /><br />Diese Eingabe bestimmt die Anzahl der Nachfahren-Generationen der Startperson die im Sanduhr-Format dargestellt werden.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONEN SEITE~<br /><br />Auf dieser Seite wird eine Liste von Personen gezeigt. Die Namen werden mit vorn stehendem Nachnamen, alphabetisch sortiert, gezeigt.<br /><br />Die ausgegebene Liste basiert auf folgenden Kriterien:<ul><li>Der Buchstabe, den Sie im Alphabet-Index angeklickt haben.</li><li>Sie können am unteren Ende der Liste die »Nachnamen-Sprungliste« oder »Nachnamen zeigen« wählen.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]					= "~ALPHABET-INDEX~<br /><br />Klicken Sie einen Buchstaben des Alphabetes und Sie erhalten eine neue Liste mit den Nachnamen des von Ihnen gewählten Buchstabens.<br /><br />An vorletzter Stelle sehen Sie eventuell <b>#pgv_lang[NN]#</b>.  Dies steht für Personen, deren Nachnamen nicht angegeben wurden, oder deren Nachnamen keine Buchstaben enthält. Unbekannte Namen sind oft als <b>#pgv_lang[qm]#</b> eingetragen; solche Namen werden als <b>#pgv_lang[NN]#</b> erkannt, genau wie leere Namen.<br /><br /><b>Achtung</b><br />Wenn im Datensatz einer Person der Nachname z.B. mit Nn, NN, Unbekannt oder auch N.N. eingetragen ist, erscheint diese Person <b>nicht</b> in der Rubrik <b>#pgv_lang[NN]#</b>. Solche Personen finden Sie unter <b>N</b> oder <b>U</b>. Dies liegt daran, dass das Programm nur prüft, ob ein Name vorhanden ist.<br /><br />Am Ende des Alphabetes sehen Sie <b>ALLE</b>. Klicken Sie hier, um eine Liste mit allen Nachnamen zeigen zu lassen.<br /><br /><b>Fehlende Buchstaben?</b><br />Es kann sein, dass in der Alphabet-Liste einige Buchstaben fehlen. Das bedeutet, dass es keine Nachnamen mit diesen Anfangsbuchstaben gibt.";
$pgv_lang["name_list_help"]				= "~NAMENS LISTE~<br /><br />In dieser Box erscheint entweder eine Liste von Nachnamen oder von einzelnen Personen. In beiden Fällen beginnen die Nachnamen mit dem Buchstaben, den Sie im Alphabet-Index gewählt haben, es sei denn, Sie haben <b>ALLE</b> geklickt.<br /><br />Ob Sie die Nachnamensliste oder die Liste einzelner Personen gezeigt bekommen, kommt auf den aktuellen Status des <b>Liste zeigen/überspringen</b> Links an.";
$pgv_lang["skip_sublist_help"]			= "~NACHNAMEN ZEIGEN~<br /><br />Normalerweise wird eine Unterliste gruppiert nach Nachnamen gezeigt, wenn Sie einen Buchstaben des Alphabetes gewählt haben. Wenn Sie dieses Link klicken, werden die Nachnamen nicht gruppiert, sondern jede einzelne Person, deren Nachname mit diesem Buchstaben beginnt, wird gezeigt.<br /><br />Um diese Aktion umzukehren, klicken Sie auf #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Die Personen- und Familien-Listen können Ehenamen ein- oder ausschließen.  Diese Option kann nützlich sein, wenn Sie Personen oder Familien suchen von denen Ihnen nur der Ehename bekannt ist.  Ehenamen können nur eigeschlossen werden wenn sie schon in der Datenbank vorhanden sind.<br /><br />Diese Option ist auf der Familien-Seite normalerweise auf »ausschließen« gestellt.  Auf der Personen-Seite bestimmt die GEDCOM-Konfiguration die Standard-Einstellung.<br /><br />Ihre Wahl wird bis zum Ende der Sitzung behalten.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~FAMILIEN SEITE~<br /><br />Auf dieser Seite wird eine Liste der Familien gezeigt. Die Namen werden mit vorn stehendem Nachnamen, alphabetisch sortiert, gezeigt.<br /><br />Die ausgegebene Liste basiert auf folgenden Kriterien:<ul><li>Der Buchstabe, den Sie im Alphabet-Index angeklickt haben.</li><li>Wahl der »Nachnamen-Sprungliste« oder »Nachnamen zeigen«.</li></ul>Sie können sowohl nach dem Nachnamen des Ehemannes als auch nach dem der Ehefrau suchen. Beide sind in der Liste enthalten.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~FAMILIEN DETAIL SEITE~<br /><br />Diese Seite zeigt Ihnen eine Übersicht der Familie, die Sie auf der vorigen Seite gewählt haben.<br /><br />Von oben nach unten sehen Sie die Detailinfo-Boxen von dem Gatten und seinen Eltern, der Gattin und ihrer Eltern, und den Kindern.<br /><br />Das Layout und der Inhalt der Personen-Boxen entspricht dem der Boxen, die Sie von der Stammbaum-Seite oder Nachfahren-Baum-Seite kennen.<br /><br />Rechts von den Namens-Boxen der Eltern sehen Sie einen Pfeil wenn weitere Vorfahren eingetragen sind. Wenn Sie diesen Pfeil klicken, gelangen Sie eine Generation höher und Sie sehen eine neue Familien-Seite in der die Eltern der vorigen Seite nun als Gatte und Gattin gezeigt sind.<br /><br />Auf der rechten Seite in der Namens-Box, sehen Sie eventuell ein Lupen-Symbol, das zu weiteren Detail-Information der Person führt. Wenn Sie den Namen klicken, gelangen Sie zur Seite #pgv_lang[indi_info]# dieser Person.<br /><br />Außerdem ist am rechten Rand ein kleines Menü vorhanden, das Sie zu anderen Seiten mir mehr Informationen oder zu anderen Diagrammen führt. Einige dieser Menüelemente verfügen auch über Untermenüs, die gezeigt werden, wenn sich der Mauszeiger dem übergeordneten Menüelement nähert.<br /><br />Die Familiengruppen-Information zeigt alle Fakten und Daten dieser Familie, wie Ehe, Multimedia-Objekte und Bemerke. Wenn Sie innerhalb der Informationen einen Ort klicken, gelangen Sie zur Ortsliste, in der alle anderen Familien und Personen aufgezählt sind, die zu diesem Ort ebenfalls einen Bezug haben. Wenn Sie ein Datum klicken, gelangen Sie zum Tages-Kalender, der alle Ereignisse zeigt, die an diesem Datum in der Vergangenheit stattfanden. Multimedia-Objekte können auch geklickt werden; dann öffnet sich ein größeres Bildfenster. Wenn Sie auf die Bildunterschrift klicken, wird das Bild auf der Seite #pgv_lang[media_list]# gezeigt. Wenn Sie eine Quelle klicken, erscheinen die Detailinformationen zu dieser Quelle.<br /><br />Unter den Namens-Boxen der Kinder sehen Sie eventuell »Kind zu dieser Familie hinzufügen«. Neben den Namens-Boxen der Kinder sehen Sie »Informationen zur Familiengruppe«. Wenn Sie die nötigen Rechte haben, können Sie Ereignisse und Daten verändern, löschen oder hinzufügen.<br /><br />Wie bei der Seite #pgv_lang[indi_info]# sehen Sie oben rechts auf der Seite ein Menü. Einträge in diesem Menü führen Sie zu anderen Seiten, wo Sie Informationen zu dieser Familie aufrufen oder andere Aufgaben im Zusammenhang mit dieser Familie ausführen können.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]				= "~EIN KIND ZU DIESER FAMILIE HINZUFÜGEN~<br /><br />Wenn Sie dieses Link klicken, können Sie ein Kind zur Familie hinzufügen.<br /><br />Ein Kind hinzuzufügen funktioniert einfach: Klicken Sie dieses Link und füllen Sie die Felder im Formular aus.";
$pgv_lang["show_fam_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Wenn Sie dieses Link klicken, wird die Information über diese Familie so gezeigt, wie Sie im Datensatz gespeichert ist.";
$pgv_lang["add_fam_clip_help"]			= "~FAMILIE DEM AUSSCHNITTSAMMELBEHÄLTER HINZUFÜGEN~<br /><br />Klicken Sie dieses Link, um die Daten der Familie aus der GEDCOM-Datei zum Ausschnittsammelbehälter hinzuzufügen. Auf der nächsten Seite können Sie dann im Detail wählen, welche Informationen Sie hinzufügen möchten<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]		= "~PAAR IN DER LEBENSSPANNENANZEIGE ZEIGEN~<br /><br />Wenn Sie dieses Link klicken, gelangen Sie zur Lebensspannendarstellung-Seite, wobei die Daten des Paares direkt in der Zeitleiste gezeigt werden.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~QUELLEN SEITE~<br /><br />Auf dieser Seite wird eine Liste aller Quellen gezeigt.<br /><br />Im Gegenteil zu den Personen- und Familien-Seiten gibt es keinen Alphabet-Index auf dieser Seite.<br /><br />Da die Quellen sowohl Personen mit unterschiedlichen Namen als auch öffentliche Datenbanken oder Institute sein können, würde eine alphabetische Unter-Gruppierung nicht viel Sinn machen. Die Namen erscheinen in alphabetischer Reihenfolge.<br /><br /><b>QUELLEN</b><br />Ohne Quellen könnte man keine Genealogie betreiben. Für jede Information in der Datenbank gibt es eine Quelle. Dies kann eine Person, ein Amt oder z.B. eine öffentliche Datenbank sein.<br /><br />Eine einzige Quelle kann mit vielen Personen verknüpft sein. Andererseits kann eine Person auch mit mehreren Quellen verknüpft sein. Sie können mehrere Quellen für ein Ereignis haben, gleich ob es ein Geburtstag, ein Beruf, eine Ehe usw. ist.";
$pgv_lang["sourcelist_listbox_help"]	= "~QUELLEN LISTE~<br /><br />In dieser Box erscheinen die Namen der Quellen, so wie sie gespeichert sind.<br /><br />Die Namen erscheinen alphabetisch sortiert. Wenn Sie eine Quelle in der Liste klicken, gelangen Sie zur Seite dieser Quelle, wo eine Liste der mit dieser Quelle verknüpften Personen und Familien gezeigt wird.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~QUELLEN DETAIL SEITE~<br /><br />Auf dieser Seite werden die Details einer Quelle gezeigt. Quellenangaben sind für Genealogen sehr wichtig und helfen die Ergebnisse von anderen Forschern nachzuvollziehen.<br /><br />Auf dieser Seite finden Sie Informationen über den Namen der Quelle, deren Autor, Veröffentlichung und dem Archiv oder Lagerort, wo diese Quelle gefunden wurde. Da es sehr viele verschiedene Arten von Quellen gibt, finden Sie eventuell unterschiedliche Mengen von Angaben vor.<br /><br />Wenn zu einem Multimedia-Objekt eine Quelle angegeben ist (z.B. Scan eines Dokumentes), gelangen Sie zu einer größeren Ansicht, indem Sie das Objekt oder den Dateinamen daneben klicken.<br /><br />Im Anschluss an die Quellen-Details wird eine Liste gezeigt, die Personen und Familien enthält, die mit dieser Quelle verknüpft sind. So finden Sie alle Informationen, die dieser Quelle entnommen sind.<br /><br />Eventuell werden zusätzliche Symbole gezeigt, je nach Konfiguration durch den Verwalter:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />was die Daten im GEDCOM-Format zeigt.</li><li><b>#pgv_lang[add_to_cart]#</b><br />was Ihnen erlaubt die Dateien in Ihrem Sammelbehälter zu speichern. Diesen »Behälter« können Sie später herunterladen und die Daten in Ihre eigenes Programm einfügen.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~MIT DIESER QUELLE VERBUNDENE EINTRÄGE~<br /><br />In dieser Box erscheint eine Liste der Personen und Familien, die mit dieser Quelle verknüpft sind. Die Namen erscheinen in alphabetischer Reihenfolge.<br /><br />Wenn Sie auf einen Namen in der Liste klicken, gelangen Sie zur Detail-Seite der betreffenden Person oder Familie.";
$pgv_lang["show_source_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Wenn Sie dieses Link klicken, werden die Informationen über diese Quelle genau so gezeigt, wie sie in der Datei als Rohdaten gespeichert sind.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Wenn Sie dieses Link klicken, werden die Daten, so wie in der Datei enthalten, in Ihren Ausschnittsammelbehälter hinzugefügt.";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br /><br />Wenn Sie dieses Link klicken, wird die Quelle zum Löschen markiert.<br /><br />Was bedeutet das? Angenommen Sie möchten aus irgendeinem Grund eine Quelle löschen. Klicken Sie dieses Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen. Bei näherem Betrachten werden Sie aber feststellen, dass die Quelle weiterhin sichtbar ist und wie zuvor gewählt werden kann.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Dies ist <u>kein</u> Fehler.</b> Der Verwalter wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie etwas gelöscht haben. Der Verwalter kann Ihre Änderung in die Datenbank übernehmen oder sie ablehnen. Erst nachdem der Verwalter Ihre Änderung akzeptiert hat, wird die Löschung tatsächlich dauerhaft. Im Zweifelsfall wird der Verwalter Sie kontaktieren.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~LISTE DER ORTE~ (oder Personen je Ort)<br /><br />Auf dieser Seite sehen Sie hierarchisch, welche Personen oder Familien mit einem Ort verknüpft sind.<br /><br />Wenn eine Verbindung zwischen einer Person oder Familie und einem Ereignis an einem bestimmten Ort besteht, bekommen Sie es gezeigt.<br /><br />Die Ergebnisse werden in Listen gezeigt, eine für Personen und eine für Familien.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~FORMAT FÜR ORTE~<br /><br /><b>STANDARDEINSTELLUNG</b><br />Das bedeutet, dass keine vorgegebene Anordnung in der GEDCOM-Datei gefunden wurde. In diesem Fall wird die Standard-Anordnung angenommen.<br /><br />Wenn ein anderes Ordnungs-Format in der GEDCOM-Datei gefunden wurde, würde das zwischen Klammern <b>(</b> und <b>)</b> am Ende der Zeile gezeigt werden.";
$pgv_lang["ppp_match_one_help"]			= "~FORMAT FÜR ORTE~<br /><br /><b>GEDCOM</b><br />Es wird angenommen, die Orte seien in der Ordnung, wie in der der GEDCOM-Datei vorgefunden, codiert. Diese Einstellung überschreibt die Standard-Anordnung, die benutzt würde, wenn die GEDCOM-Datei keine Ordnungs-Angabe enthält.";
$pgv_lang["ppp_numfound_help"]			= "~ORTS-VERBINDUNGEN GEFUNDEN~<br /><br />Hier wird die Anzahl der Verbindungen gezeigt. Wenn Sie noch eine Liste mit Orten sehen, bedeutet das, dass Sie noch nicht die unterste Ebene erreicht haben.<br /><br />Sie können entweder alle Datensätze, die zu diesem Ort gefunden wurden, zeigen oder die Suchangaben präzisieren, indem Sie einen Ort klicken.";
$pgv_lang["ppp_levels_help"]			= "~ORTS-EBENEN~<br /><br />Hier werden die bisher gewählten Ortsebenen gezeigt. Die Liste in der Box stellt eine Unterliste der zuletzt gewählten Ebene.<br /><br /><b>BEISPIEL:</b><ul><li>Die Reihenfolge ist: #pgv_lang[default_form]#</li><li>Wenn die aktuelle Ebene die oberste ist, zeigt die Box alle Länder.</li><li>Wenn als Ebene gezeigt wird: »Deutschland, zurück«, dann werden in der Box alle Regionen innerhalb Deutschlands gezeigt</li><li>usw.</li></ul><br />Sie können in der Zeile jede beliebige Ebene klicken, um wieder eine oder mehrere Ebenen nach oben zu springen.";
$pgv_lang["ppp_placelist_help"]			= "~ORTS-HIERARCHIE~<br /><br />In dieser Liste sehen Sie die Orte unter der angebenenen Ortswahl. Wenn Sie noch keinen Ort angegeben haben, sehen Sie eine Liste der obersten Ebene (z.B. Länder oder Staaten).<br /><br />Sie können die Namen der Ortsangaben in der Liste klicken. Dadurch wird der gewählte Ort als Filter aktiviert und Sie gelangen eine Ebene tiefer.";
$pgv_lang["ppp_placelist_help2"]		= "~ORTS-LISTE~<br /><br />In dieser Liste sehen Sie die bisher gefunden Orte.<br /><br />Sie können die Namen der Ortsangaben in der Liste klicken. Dadurch wird der gewählte Ort als Filter aktiviert und Sie gelangen eine Ebene tiefer.<br /><br />Nur solange Sie in der obersten Ebene arbeiten, wird keine Namensliste gezeigt. In allen tiefer gelegenen Ebenen erhalten Sie eine Liste von Personen oder Familien, die mit diesem Ort verknüpft sind.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Wenn Sie dieses Link klicken, erhalten Sie eine Liste mit allen Personen und Familien, bei denen Ereignisse am zuvor ausgewählten Ort stattgefunden haben. Wenn Sie in der untersten Ebene der Ortsangabe angelangt sind (z.B. ein Dorf oder eine Stadt), wird diese Namensliste automatisch gezeigt.";
$pgv_lang["ppp_name_list_help"]			= "~NAMEN-LISTE~<br /><br />Diese Box zeigt eine Liste aller Personen und Familien, die in irgendeiner Weise mit dem gewählten Ort verbunden sind.<br /><br />Sie können die Namen in der Liste klicken. Dadurch gelangen Sie zur Detail-Seite der Person oder Familie.<br /><br />Sie können Ihre Orts-Wahl auch abändern, indem Sie einen Ort oberhalb der Liste klicken.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTI MEDIA LISTE~<br /><br />Die Multi Media Seite listet alle Multi Media Objekte, die in der GEDCOM-Datei vorkommen.<br /><br />Zu jedem Objekt finden Sie den Titel oder Dateinamen des Objekts sowie die Namen der Personen oder Familien, die mit dem Objekt verbunden sind, sowie Bemerke zum Objekt.<br /><br />Den Titel oder Dateinamen des Objekts klicken bewirkt das gleiche wie ein Klick auf sein Miniaturbild. Das Objekt wird mit dem PGV-internen Betrachter geöffnet oder in einem Plugin Ihres Browsers.<br /><br />Wenn Sie »Zeige« einer Person oder Familie klicken, gelangen Sie zur Seite der jeweiligen Familie oder Person.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~MULTIMEDIA-DATEIEN HOCHLADEN~<br /><br />Das Hochladen der Dateien ist einfach, hier aber ein paar Zusatzinformationen.<br /><br /><b>Miniaturbilder</b><br />Miniaturbilder sollten ungefähr 100 Pixel breit sein. Der Dateiname muss der gleiche sein, wie der des Original-Bildes.<br /><br /><b>Hochladen</b><br />Die Dateien werden automatisch in das Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> übertragen, wenn es sich um Originale handelt und in das Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#/thumbs</b> bei Miniaturbildern.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Allgemeine Informationen</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Ereignis</b></a></li><li><a href=\"#calendar_button\"><b>Vorauswahl (Buttons)</b></a></li><li><a href=\"#calendar_tip\"><b>Tipp</b></a></li></ul><br /><a name=\"calendar_general\"></a>Der Jahrestag-Kalender stellt Personen und Familien dar, die mit einem Ereignis verbunden sind, das sich an einem bestimmten Tag oder Monat oder in einem bestimmten Zeitraum ereignet hat. Er besitzt ein mehrstufiges Filtersystem, um das gewünschte Datum oder den gewünschten Zeitraum und die Art der Ereignisse zu wählen.<br /><br /><dl><dt><b><a href=\"#calendar_day\">Tag zeigen</a></b></dt><dd>Dies zeigt die Ereignisse eines bestimmten Tages an (unabhängig vom gewählten Jahr). Eine Liste enthält Personen und eine andere Familien.</dd><dt><b><a href=\"#calendar_month\">Monat zeigen</a></b></dt><dd>Dies zeigt einen Kalender, wobei die Namen von Personen und Familien jeweils in den Tages-Kästchen erscheinen. Der Kalender erscheint wie in dem Jahr, das Sie im Jahres-Feld eingegeben haben. Alle Ereignisse, die sich in der Vergangenheit bis zu diesem Jahr ereignet haben, werden gezeigt. In Kombination mit der Option <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a> ergibt sich eine realistische Ansicht, wie sich die Ereignisse für die Vorfahren dargestellt haben.</dd><dt><b><a href=\"#calendar_year\">Jahr zeigen</a></b></dt><dd>Dies zeigt die Ereignisse eines oder mehrerer Jahre. Eine Liste enthält Personen und eine andere Familien.</dd></dl>Die aktuell eingestellten Datums-Werte sind im Kalender-Menü hervorgehoben dargestellt.<br /><br />Die Namen und Daten, die in der Liste oder im Kalender erscheinen, können Sie klicken. Wenn Sie einen Namen klicken, gelangen Sie zur Detail-Seite der betreffenden Person oder Familie; wenn Sie ein Datum klicken, gelangen Sie in die »Heute«-Ansicht (oder das Jahr) für das geklickte Datum.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /<a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~DATUMS WAHL~<br /><br />Die obere Zeile der Wahl-Tabelle ist die <b>Tageswahl</b>. Hier wählen Sie den Tag. Das Ergebnis hängt davon ab, ob Sie sich im »Tages Modus« oder im »Monats Modus« befinden.<br /><dl><dt><b>Tages Modus</b></dt><dd>Wenn Sie in diesem Modus einen Tag klicken, wird der Bildschirm aktualisiert und die Liste des geklickten Tages wird gezeigt.</dd><dt><b>Monats Modus</b></dt><dd>Wenn Sie im Monatsmodus einen Tag klicken, wird der Bildschirm zwar aktualisiert, aber Sie sehen immer noch den Kalender des gleichen Monats wie zuvor.<br /><br />Um den Modus zu wechseln klicken Sie einfach den <b>#pgv_lang[viewday]#</b> oder <b>#pgv_lang[viewmonth]# Button</b>.</dd></dl><br />Am Ende der Tages-Reihe finden Sie »Direkt« mit dem heutigen Datum. Wenn Sie »Direkt« klicken, sehen Sie die Liste für den heutigen Tag im »Tages-Modus«, gleich in welchem Modus Sie zuvor waren.";
$pgv_lang["annivers_month_select_help"]	= "~MONATS WAHL~<br /><br />Die mittlere Zeile der Wahl-Tabelle ist die <b>Monatswahl</b>. Hier wählen Sie den Monat. Das Ergebnis hängt davon ab, ob Sie sich im »Tages Modus« oder im »Monats Modus« befinden.<br /><dl><dt><b>Tages Modus</b></dt><dd>Wenn Sie in diesem Modus einen Monat klicken, wird der Bildschirm aktualisiert und die Liste des geklickten Datums mit dem neu gewählten Monat wird gezeigt.</dd><dt><b>Monats Modus</b></dt><dd>Wenn Sie im Monatsmodus einen Monat klicken, wird der Kalender des neuen Monats gezeigt.</dd></dl><br />Am Ende der Monats-Reihe finden Sie »Direkt« mit dem aktuellen Monat. Wenn Sie »Direkt« klicken, sehen Sie den Kalender des aktuellen Monats, gleich in welchem Modus Sie zuvor waren.";
$pgv_lang["annivers_year_select_help"]	= "~JAHRES EINGABEFELD~<br /><br />In diesem Eingabefeld können Sie das Jahr des Kalenders ändern. Geben Sie ein Jahr in das Feld ein und drücken Sie <b>Eingeben</b>, um den Kalender auf dieses Jahr zu ändern.<br /><br /><b>Erweiterte Funktionen</b> bei <b>#pgv_lang[viewyear]#</b><dl><dt><b>Mehrere Jahre</b></dt><dd>Sie können über mehrere Jahre suchen.<br /><br />Jahresbereiche sind <u>inklusiv</u>. Dies bedeutet, dass sich die Zeitspanne vom 1. Januar des ersten Jahres des Bereichs bis zum 31. Dezember des letzten genannten Jahres erstreckt. Einige Beispiele für Jahresspannen:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 1992 bis 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 1972 bis 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 1610 bis 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 1880 bis 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 880 bis 1105.<br /><br />Sie können auch die letzten Ziffern der Jahreszahl durch Fragezeichen <b>#pgv_lang[qm]#</b> erzetzen, um alle Ereignisse eines Jahrzehntes oder Jahrhundertes zu erhalten. Zum Beispiel, <b>197?</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 1970 bis 1979 oder <b>16??</b>&nbsp;&nbsp;&nbsp;für alle Ereignisse von 1600 bis 1699.<br /><br />Durch Wahl einer Jahresspanne wird der Kalender in die Jahresansicht geändert</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~EREIGNISWAHL~<br /><br />Wenn Sie nicht angemeldeter Benutzer sind, haben Sie diese Wahlmöglichkeiten:<br /><ul><li><b>Alle Personen</b><br />Mit dieser Option werden alle Personen und Familien gezeigt.</li><li><b>Jüngere Ereignisse (&lt; 100 Jahre)</b><br />Mit dieser Option sehen Sie alle Ereignisse des gewählten Datums oder Monates, die maximal 100 Jahre zurück liegen.</li><li><b>Lebende Personen</b><br />Hierfür müssen Sie entweder angemeldet sein, oder der Verwalter muss auch die Daten von lebenden Personen für alle sichtbar gemacht haben.<br /><br />Mit dieser Option sehen Sie nur Ereignisse noch lebender Personen.</li></ul>Wenn Sie eine Option wählen, wird der Bildschirm aktualisiert und die Ereignisse Ihrer Wahl werden aufgezählt.";
$pgv_lang["annivers_sex_help"]			= "~GESCHLECHT-FILTER~<br /><br />Wenn Sie angemeldet sind oder wenn der Verwalter die Datenschutzoptionen deaktiviert hat, können Sie zwischen diesen Optionen wählen:<ul><li><b>Symbol »beide«</b><br />Mit dieser voreingestellten Option werden alle Ereignisse von Personen und Familien gezeigt.</li><li><b>Symbol »männlich«</b><br />Hier werden nur Ereignisse von männlichen Personen gezeigt. Außerdem werden männliche Familienmitglieder bei Familien-Ereignissen gezeigt.</li><li><b>Symbol »weiblich«</b><br />Hier werden nur Ereignisse von weiblichen Personen gezeigt. Außerdem werden weibliche Familienmitglieder bei Familien-Ereignissen gezeigt.</li></ul>Wenn Sie ein Symbol klicken, wird der Bildschirm aktualisiert und die von Ihnen ausgewählten Ereignisse werden gezeigt.";
$pgv_lang["annivers_event_help"]		= "~EREIGNISWAHL~<br /><br />Hier können Sie wählen, ob Sie <b>alle</b> Ereignisse für Personen und Familien zeigen möchten, oder nur ein bestimmtes Ereignis.<br /><br />Wenn Sie eine Option wählen, wird der Bildschirm aktualisiert und die Ereignisse Ihrer Wahl werden gezeigt. Die übrigen Einstellungen von Tag, Monat, Jahr, Ereignis-Filter und Anzeige-Modus bleiben unverändert.";
$pgv_lang["annivers_tip_help"]			= "~TIPP~<br /><br />Angenommen Sie hätten einen Verwandten, der am am 25.&nbsp;Januar&nbsp;1875 geboren wurde.<br /><br />Stellen Sie die Datumsangabe auf dieses Datum ein. So können Sie sich eine Liste oder einen Kalender zeigen lassen, für genau diesen Tag. Alle Altersangaben, Jahrestage usw. werden neu auf den Tag berechnet, den Sie eingegeben haben. So sehen Sie die Angaben genau so, wie sie sich für Ihren Verwandten vor langer Zeit dargestellt haben.";
$pgv_lang["day_month_help"]				= "~TAG / MONAT / JAHR ZEIGEN~<br /><br /><ul><li>Wenn Sie <b>Tag zeigen</b> klicken, werden nur die Ereignisse genau dieses Datums in einer Liste gezeigt. Alle Jahre werden durchsucht, deshalb können hier auch nur Tag und Monat angegeben werden. Eine Änderung der Jahreszahl bewirkt nichts. Sie können die Liste einschränken, in dem Sie die Option »Jüngere Ereignisse« oder »Lebende Personen« wählen.<br /><br />Die Altersangaben in der Liste beziehen sich auf die angegebene Jahreszahl.</li><li>Der <b>Monat zeigen</b> Button zeigt den Kalender des gewählten Monats und Jahres. Auch hier können Sie die Liste durch die Wahl von »Jüngere Ereignisse« oder »Lebende Personen« einschränken.<br /><br />Wenn Sie ein Jahr in der Vergangenheit wählen und »Jüngere Ereignisse« wählen, erhalten Sie einen realistischen Eindruck, wie sich der Kalender Ihrer Vorfahren darbot. Alle Altersangaben beziehen sich auf die angegebene Jahreszahl.</li><li>Der Button <b>Jahr zeigen</b> zeigt eine Liste der Ereignisse des gewählten Jahres. Auch hier können Sie die Liste durch die Wahl von »Jüngere Ereignisse« oder »Lebende Personen« einschränken.<br /><br />Sie können Ereignisse für eine Reihe von Jahren anzeigen. Geben Sie einfach die Anfangs- und Endjahre des Bereichs mit einem Bindestrich <b>-</b> ein.Beispiele:<br /><b>1992-4</b> für alle Ereignisse von 1992 bis 1994)<br /><b>1976-1984</b> für alle Ereignisse von 1976 bis 1984).<br /><br />Sie können auch die letzten Ziffern der Jahreszahl durch Fragezeichen <b>#pgv_lang[qm]#</b> erzetzen, um alle Ereignisse eines Jahrzehntes oder Jahrhundertes zu erhalten. Zum Beispiel, <b>197?</b> für alle Ereignisse von 1970 bis 1979 oder <b>16??</b> für alle Ereignisse von 1600 bis 1699.</li></ul>Wenn Sie das <b>Jahr wechseln</b> möchten <b>müssen</b> Sie einen der drei Buttons benutzen. Alle anderen Einstellungen bleiben unverändert.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />Der Ausschnittsammelbehälter erlaubt Ausschnitte aus diesem Stammbaum zu sammeln und in eine separate GEDCOM-Datei zu speichern, die man anschließend herunterladen kann.<br /><ul><li>Wie wählt man Ausschnitte?<br />Jeder klickbare Name führt zur Detail-Seite der betreffenden Person (Familie, Quelle). Dort gibt es die Option <b>#pgv_lang[add_to_cart]#</b>. Klicken Sie dieses Link und Sie gelangen zu einer Liste von Optionen.</li><li>Wie herunterladen?<br />Sobald Sie Elemente in Ihrem Sammelbehälter haben, können Sie diese durch Klick auf <b>Download Now</b> herunterladen. Folgen Sie den weiteren Anweisungen.</li></ul>";
$pgv_lang["clip_download_help"]			= "~#pgv_lang[download_now]#~<br /><br />Wenn Sie dieses Link klicken, gelangen Sie auf eine andere Seite. Falls in den von Ihnen gesammelten Ausschnitten auch Multimedia-Objekte referenziert sind, werden auch diese auf der Seite gezeigt.<br /><br />Folgen Sie den Anweisungen.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Klicken Sie dieses Link, um den Ausschnittsammelbehälter zu leeren.<br /><br />Falls Sie nicht alle Personen, Familien usw. aus dem Sammelbehälter entfernen möchten, können Sie auch einzelne Elemente entfernenen, indem Sie jeweilige »Entfernen« in der Namensbox klicken. Es gibt <u>keine</u> Bestätigung, wenn Sie eines dieser Links klicken. Die Löschung erfolgt sofort.";
$pgv_lang["add_by_id_help"]				= "~ID-Nummer dem Sammelbehälter hinzufügen~<br /><br />Hier geben Sie die ID-Nummer der Person, dessen Datensatz dem Sammelbehälter hinzugefügt werden soll.  Nachdem Sie diese ID-Nummer eingegeben haben, können Sie bestimmen ob und welche Verwandte dem Sammelbehälter auch hinzugefügt werden sollen.<br /><br />Falls Sie die ID-Nummer der gewünschten Person nicht wissen, können Sie die Datenbank danach dursuchen.";
$pgv_lang["zip_help"]					= "~Ausschnitt als ZIP-Datei erstellen~<br /><br />Wenn diese Option angekreuzt ist, wird die Ausgangs-Datei im ZIP format erstellt. Bitte wenden Sie sich an <a href=\"https://de.wikipedia.org/wiki/ZIP_%28Dateiformat%29\" target=\"_blank\">https://de.wikipedia.org/wiki/ZIP_%28Dateiformat%29</a> um mehr Auskunft über ZIP Dateien zu erhalten.";
$pgv_lang["include_media_help"]			= "~Medien hinzufügen~<br /><br />Diese Option bestimmt ob Medien-Dateien die mit den Personen im Sammelbehälter verknüpft sind auch dem Sammelbehälter hinzugefügt werden sollen. Wenn diese Option angekreuzt ist, wird die Ausgangs-Datei automatisch im ZIP-Format erstellt.";
$pgv_lang["clip_cart_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Diese Tabelle zeigt Ihnen den aktuellen Inhalt des Sammelbehälters.<ul><li>In der <i>Typ</i> Spalte finden Sie den Typ des jeweiligen Eintrages.  Die Eintragstypen, die hier dargestellt sind können Person (INDI), Familie (FAM), Quelle (SOUR), Archiv (REPO), Bemerkung (NOTE), oder Medien-Objekte (OBJE) sein.</li><li>In der <i>ID</i> Spalte finden Sie die ID-Nummer des jeweiligen Eintrages.</li><li>Die <i>Name / Beschreibung</i> Spalte enthält den Namen der Familie oder Person, oder die in der Datenbank eingetragene Beschreibung des Datensatzes.</li></ul><b>Wenn Sie Einträge aus dem Sammelbehälter entfernen, fragt das Programm <u>nicht</u> ob Sie dessen sicher sind.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~#pgv_lang[review_changes]#~<br /><br />Wenn Sie diese Meldung sehen, bedeutet das:<ol><li>Jemand hat Änderungen an der GEDCOM-Datei vorgenommen.<br />Einer oder mehrere Datensätze wurden hinzugefügt, verändert oder gelöscht.</li><li>Die Änderungen wurden bisher noch nicht vom Verwalter in die Datenbank übernommen.<br /><br />Sobald die Änderungen übernommen oder abgelehnt sind, wird diese Meldung nicht mehr gezeigt.</li></ol>Indem Sie das Link klicken, sehen Sie, welche Änderungen beantragt wurden. Wenn Sie merken, dass eine Änderung nicht korrekt ist, informieren Sie bitte den Verwalter.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~Die SUCH-SEITE~<br /><br />Obwohl diese Seite sehr einfach aussieht, arbeitet sie mit einem vielseitigen Such-Algorithmus. Die meisten Genealogie-Webseiten ermöglichen nur eine einfache Nachnamen-Suche. Auf dieser Seite können Sie praktisch nach allem suchen.<br /><br />Das Such-Feld auf der linken Seite ist das gleiche wie im Seitenkopf.<br /><br />Wenn Sie nach Personen in Verbindung mit einer bestimmten Jahreszahl suchen, geben Sie nur das Jahr ein. Das Programm wird alle Verbindungen finden.<br /><br />Suchen Sie einen Namen oder einen Ort? Geben Sie den Namen oder den Ort (vollständing oder teilweise) ein, und das Programm erledigt den Rest.<br /><br /><b>SOUNDEX (Phonetische) Suche</b><br />Mit diesen Such-Feldern auf der rechten Seite können Sie nach Namen von Personen oder Orten suchen, auch wenn Sie die genaue Schreibweise nicht kennen.<br /><br />Wenn sich auf Ihrer Site mehrere genealogische Datenbanken befinden und der Verwalter das Umschalten zwischen ihnen aktiviert hat, gibt Ihre Suche die Ergebnisse für alle.<br /><br />Sie finden weitere Hilfe, wenn Sie das Fragezeichen <b>#pgv_lang[qm]#</b> an den Feldern klicken.";
$pgv_lang["search_enter_terms_help"]	= "~#pgv_lang[enter_terms]#~<br /><br />In dieses Feld können Sie Suchkriterien wie Daten, Vornamen, Nachnamen, Orte, Mediennamen usw. eingeben.<br /><br /><b>Wildcards (Joker)</b><br />Wildcards, die Sie sicherlich kennen (wie * oder ?), sind nicht erlaubt, aber das Programm <u>vermutet</u>, mit einer Ausnahme, immer Wildcards.<br /><br />Angenommen Sie geben in in das Such-Feld folgendes ein: <b>Pete</b>. Als Ergebnis erhalten Sie (vorausgesetzt diese Namen sind in der Datenbank enthalten):<div style=\"padding-left:30px;\"><b>Pete</b> Schmidt<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />irgendjemand --Geburt 1. Januar 1901 <b>Pete</b>rsburg<br />usw.</div><br /><b>Daten</b><br />Geben Sie ein Datum in das Such-Feld ein und Sie erhalten eine Liste aller Personen, die mit dieser Jahreszahl in Verbindung stehen.<br /><br />Wenn Sie 1950 eingeben, erhalten Sie alle Personen, die in diesem Jahr geboren wurden, geheiratet haben, gestorben sind usw.<br /><br />Wenn Sie <b>4&nbsp;Dec</b> eingeben, werden alle Personen, die Verbindung zu einem Ereignis an irgend einem 4. Dezember haben, aufgezählt. Es werden aber auch Personen mit Ereignissen am 14. oder 24. Dezember aufgezählt. Wie Sie sehen, werden auch hier Wildcards angenommen, so dass man sie nicht eingeben muss.<br /><br /><b>Richtige Datumsangabe</b><br />Das Programm sucht nach den Daten, so wie sie in der GEDCOM-Datei eingetragen sind. D. h., wenn Sie nach einem Ereignis an irgend einem 14. Dezember suchen, sollten Sie <b>14&nbsp;dec</b><br /> eingeben, weil diese englische Schreibweise in GEDCOM-Dateien verwendet wird. Wenn Sie z.B. <b>dec&nbsp;14</b> eingeben, würde das Ergebnis eine Person sein, die z.B. mit dem Datum 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b> verbunden ist.<br /><br />Sie können auch reguläre Ausdrücke im Sucher verwenden. Um z.B. alle Personen zu finden, die Daten im 20. Jahrhundert haben, geben Sie im Suchfeld <b>19[0-9][0-9]</b> ein, dann erhalten Sie Personen mit Daten von 1900 bis 1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Wenn Sie weitere Hilfe zu diesem Such-System benötigen, teilen Sie uns dies mit, damit wir die Hilfe-Datei erweitern können.";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Mit dieser Funktion können Sie die Datenbank nach Fehlern durchsuchen und diese korrigieren.<br /><br /><b>Suchen</b><br />Diese Option durchsucht die Datenbank genau wie eine <a href=\"help_text.php?help=search_enter_terms_help\">normale Suche</a>.<br /><br /><b>Ersetzen</b><br />Alle Vorkommen des Such-Objekts werden in der Datenbank mit dem Ersatz-Objekt ersetzt.<br /><br /><b>Zum Beispiel...</b><br />Sie haben versehentlich den Namen Ihres Ur-Großvaters »Michael« als »Micheal« eingegeben.<br /><br />Als Such-Objekt würden Sie <b>Micheal</b> eingeben, und als Ersatz-Objekt <b>Michael</b>.<br />Jedes Vorkommen von »Micheal« wird dann mit »Michael« ersetzt.<br /><br /><b>Suchen nach...</b><br />Zuerst sollten Sie den Umfang der Suche bestimmen.  Sie können die Suche auf Namen, Orte, oder nicht beschränken.  Falls Sie keine Beschränkung bestimmen, wird die ganze Datenbank durchsucht.  Falls Sie die Option <i>#pgv_lang[search_place_word]#</i> wählen, durchsucht das Programm Ortsangaben ohne zugleich Wildcards anzunehmen.  Dementsprechend wird Ihr Suchobjekt in Ortsangaben nur gefunden, wenn es dort als alleinstehendes Wort vorhanden ist. Zum Beispiel, eine Suche nach <b>UT</b> findet dann nicht »ut« innerhalb Connectic<b>ut</b>.<br /><br />Bitte machen Sie sich keine Sorgen über Fehler in der Ersetzung.  Am Ende der automatischen Ersetzung können Sie jede Änderung einzeln annehmen oder verwerfen.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex ist eine Methode zum Codieren von Wörtern entsprechend ihrer Aussprache. Auf diese Weise können Sie die Datenbank nach Namen und Orten durchsuchen, wenn Sie nicht genau wissen, wie sie geschrieben sind. PhpGedView unterstützt zwei verschiedene Soundex-Algorithmen, die sehr unterschiedliche Ergebnisse liefern.<ul><li><b>#pgv_lang[search_russell]#</b><br />Diese 1918 von Russell patentierte Methode ist sehr einfach und kann von Hand durchgeführt werden.<br /><br />Der einfache Algorithmus eignet sich nicht gut für Namen, die ursprünglich in anderen Sprachen als Englisch verfasst waren, und sogar mit englischen Namen sind die Ergebnisse sehr überraschend. Zum Beispiel eine einfache Soundex-Suche nach <b>Smith</b> nicht nur <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b> zurück, bei denen es sich eindeutig um Variationen von <b>Smith</b> handelt, aber auch <b>Smead, Sneed, Smoote, Sammett, Shand,</b> und <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Diese in 1985 entwickelte Methode ist viel komplexer als die einfache Methode und kann nicht leicht von Hand durchgeführt werden.<br /><br />Eine Soundex-Suche mit dieser Methode liefert viel genauere Ergebnisse.</li></ul>Weitere Informationen zu beiden Soundex-Algorithmen finden Sie in dieser <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> Website.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />Die Wahl <b>#pgv_lang[search_tagfon]#</b> bewirkt dass folgende GEDCOM Tags nicht durchsucht werden:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Letzte Änderung von<br /><b>CHAN</b> - Datum der letzten Änderung<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Folgende GEDCOM Tags werden nie durchsucht:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Diese Option bewirkt das Zeigen von allen Personen oder Familien die irgend eine Beziehung zu dieser Person oder Familie haben.  Das Umgekehrte ist leider nicht möglich.<br /><br />Beispiel: Angenommen, Person <b>A</b> ist Pate von Person <b>B</b>. Diese Beziehung wird im GEDCOM-Datensatz der Person B mittels eines ASSO-Tags aufgezeichnet. Im GEDCOM-Datensatz der Person <b>A</b> ist kein entsprechendes Tag vorhanden.<br /><br />Wenn diese Option auf <b>#pgv_lang[yes]#</b> gesetzt ist und das Suchergebnis <b>B</b> enthält, wird <b>A</b> auf Grund des ASSO-Tags im GEDCOM-Datensatz von <b>B</b> automatisch eingeschlossen. Wenn die Suchergebnisliste jedoch <b>A</b> enthält, wird <b>B</b> nicht automatisch aufgenommen, da der GEDCOM-Datensatz der Person <b>A</b> kein übereinstimmendes ASSO-Tag enthält.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Mit dieser Funktion können Sie die angegebenen Felder von Personendatensätzen in Ihrer genealogischen Datenbank durchsuchen.<br /><br />Wenn Sie den Button <b>#pgv_lang[search]#</b> klicken, werden alle Felder, für die Werte eingegeben wurden, untersucht und Datensätze in Ihrer genealogischen Datenbank zurückgegeben, die <u>alle</u> Kriterien erfüllen. Während das erste Dialogfeld einige der gebräuchlichsten Felder anbietet, können Sie unten im Dialogfeld auf <b>#pgv_lang[more_fields]#</b> klicken, um die Liste der zu untersuchenden Felder zu erweitern.<br /><br />~Felder mit Daten~<br />Erweiterte Suchen basieren auf Jahren. Anders als bei der Prozedur »#pgv_lang[search_general]#«, die ein Datum ohne Jahresangabe akzeptiert, erfordern alle diese Felder mindestens das Jahr, akzeptieren aber auch vollständige Angaben zu Tag, Monat und Jahr. So ist es beispielsweise nicht möglich, nach etwas zu suchen, das im April irgendeines Jahres passiert ist.<br /><br />Jedes Datumssuchfeld verfügt auch über einen Modifikator, sodass Sie nach dem eingegebenen Datum <b>#pgv_lang[exact]#</b> oder einem relativen Datum mit <b>+/-</b> einer Anzahl von Jahren suchen können. Wenn Sie ein Jahr in das Datumsfeld eingeben, dann einen Modifikator wählen und dann auf den Button <b>#pgv_lang[search]#</b> klicken, wird eine Liste der Personen gezeigt, die mit diesem Jahr oder diesem Jahresbereich verbunden sind.<br /><br />Wenn Sie beispielsweise »APR 1950« in das Feld für das Geburtsdatum eingeben, das den Modifikator <b>#pgv_lang[exact]#</b> enthält, sind als Ergebnis alle Personen mit einem Ereignis enthalten, das nur im April 1950 stattgefunden hat. In jedem Datumsfeld werden die für dieses Ereignis spezifischen Daten durchsucht. Durch Hinzufügen eines Modifikators <b>+/- 10</b> werden Daten zwischen dem 1. April 1940 und dem 31. März 1960 zurückgegeben. Die anderen Modifikatoren ändern die Suchjahresbereiche auf ähnliche Weise. Wenn Sie nur ein Jahr eingeben, beispielsweise »1950«, gibt die Suche alle Ereignisse innerhalb des angegebenen Jahres zurück.<br /><br /><b>Datumsformat für Suchen</b><br />In Ihren Suchdatumsfeldern können weder Jokers noch reguläre Ausdrücke verwendet werden. Die Reihenfolge von Tag, Monat, Jahr und Groß-/Kleinschreibung sind irrelevant. »TT MMM JJJJ« hat dieselbe Bedeutung wie »JJJJ MMM TT«. Wenn Sie jedoch nach einem Ereignis am 14. Dezember 1926 suchen möchten, sollten Sie es als »14 DEC 1926« eingeben, da das Datum so in der Datenbank gespeichert wird. Um nach einem Datum über mehrere Ereignisse hinweg zu suchen (z. B. Geburten, Todesfälle, Hochzeiten, Bar Mitzwas, LDS-Siegelungen usw.) oder wenn nur der Tag oder Monat bekannt sind, ist es besser, die Funktion »#pgv_lang[search_general]#« zu verwenden.<br /><br />~Felder mit Namen~<br />Die Felder <b>#pgv_lang[given_name]#</b> und <b>#pgv_lang[surname]#</b> können verwendet werden, um die verschiedenen Teile eines Namens anzugeben, nach denen gesucht werden soll. Dadurch können Namen, die sowohl Vor- als auch Nachnamen sein können, einfach gefiltert werden, z. B. »Terry« oder »Henry«.<br /><br />Die Namensfelder verfügen außerdem über einen Modifikator, der dabei hilft, zwischen dem Eingegebenen und dem Gesuchten zu unterscheiden. Zu den Modifikatoren gehören:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;gibt eine Groß-/Kleinschreibung beachtende Suche im gesamten Feld nach dem genau eingegebenen Text an. Die Suche berücksichtigt auch alle eingebetteten Zeichen, Leerzeichen usw. Wenn das Feld beispielsweise ein Leerzeichen enthält, der Datensatz in der Datenbank jedoch zwei an derselben Position hat, wird der Datensatz nicht gefunden.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;gibt eine Groß-/Kleinschreibungsunabhängige Suche nach Datensätzen an, bei denen ein beliebiger Name mit dem im Feld angegebenen Namen beginnt. Wenn ein Namensfeld mehrere Namen enthält (z. B. Vor- und Zweitnamen), wird die Übereinstimmung mit dem Anfang jedes durch ein Leerzeichen getrennten Namensteils durchgeführt.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;gibt eine Groß-/Kleinschreibungsunabhängige Suche nach Datensätzen an, bei der nach den vollständigen eingegebenen Daten im Feld überall im Namenstext des Zieldatensatzes gesucht wird. Wenn Sie beispielsweise ein einzelnes Leerzeichen in das Suchfeld <b>#pgv_lang[given_name]#</b> mit dem Modifikator <b>#pgv_lang[contains]#</b> eingeben, werden alle Datensätze gefunden, die einen Vornamen und mindestens einen zweiten Vornamen oder einen Anfangsbuchstaben enthalten müssen.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;gibt eine Groß-/Kleinschreibungsunabhängige Suche nach Datensätzen an, die dem Eintrag im Feld ähneln. Auf diese Weise können Sie die Datenbank nach Namen und Orten durchsuchen, deren genaue Schreibweise Sie nicht kennen.</li></ul><br />~Felder ohne Modifikatoren~<br />Bei Einträgen in Feldern ohne Modifikatoren wird die Groß-/Kleinschreibung nicht beachtet. Der eingegebene Text wird überall im Ereignistext des Zieldatensatzes gesucht.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# SEITE~<br /><br />Auf dieser Seite werden alle Details zu einer Person aufgezählt.<br /><br />Falls ein Bild vorhanden ist, wird es links oben gezeigt. Direkt neben dem Bild sehen Sie alle Namen der Person.<br /><br />Zu den Namen können Notizen oder Quellen angegeben sein. Wenn zu einem Namen diese Angaben vorhanden sind, werden Sie jeweils unter dem Namen gezeigt.<br /><br />Wenn die Person auch unter anderem Namen bekannt ist (AKA = Also Known As), erscheint dies hier ebenfalls.<br /><br />Wenn Sie Rechte zum Bearbeiten der Daten haben, sehen Sie bei einigen Angaben auch Links zum Bearbeiten oder Löschen.<br /><br />Auf dieser Seite gibt es außerdem die Ordner <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, und <b>#pgv_lang[relatives]#</b>. In diesen Ordnern finden Sie alle Informationen die in der GEDCOM-Datei zu dieser Person gespeichert sind.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;zeigt die Daten der Person und zu Ehen. Wenn Sie ein Datum in diesem Ordner klicken, gelangen Sie zum Jahrestagskalender für dieses Datum, der Ihnen andere Ereignisse dieses Datums aus der GEDCOM-Datei zeigt. Wenn Sie auf einen Ort klicken, gelangen Sie in die Liste der Orte und finden so andere Personen, in deren Leben dieser Ort irgendeine Rolle spielte. Bei Ehen und anderen Familienereignissen wird der Name des Ehepartners gezeigt, so dass Sie direkt zum Partner gelangen können; außerdem ist ein Link zur Familien-Seite vorhanden.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;zeigt alle allgemeinen Notizen, die zu dieser Person vorhanden sind.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;zeigt alle Quellen, in denen diese Person genannt wird. Diese Quellen sind <u>nicht</u> mit einzelnen Fakten verbunden, nicht einmal mit dem Namen der Person. Sie sind mit der Person selbst verbunden. Klicken Sie den Titel einer Quelle, erhalten Sie weitere Informationen zu dieser Quelle, sowie eine Liste von weiteren Personen, die in dieser Quelle genannt werden.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;zeigt alle Bilder oder andere Media-Dateien, die zu dieser Person verbunden sind. Wenn Sie das Miniaturbild eines Bildes klicken, öffnet sich ein größeres Bild-Betrachtungsfenster. Wenn Sie auf die Bildunterschrift klicken, wird das Bild auf der Seite #pgv_lang[media_list]# angezeigt.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;listet die Eltern und Geschwistern, sowie die Ehepartner und Kinder dieser Person. Alle Personen sind in Boxen dargestellt, die den Boxen in den Diagrammen ähneln.</li></ul><br />Am rechten Rand des Bildschirmes sehen Sie eine Box mit Links. Die meisten Links in dieser Box entsprechen denen im Menü der Kopfzeile. Wenn Sie z.B. »Stammbaum« an der rechten Seite klicken, gelangen Sie zum Stammbaum dieser Person. Das ist der Unterschied zu den Links im Menü, denn dort führt »Stammbaum« zum Grund-Stammbaum dieser GEDCOM-Datei.<br /><br />Wenn der Verwalter diese Funktion aktiviert hat, erscheint bei diesen Links rechts auch »GEDCOM-Datensatz zeigen«. Dieses Link zeigt Ihnen die GEDCOM Rohdaten dieser Person.<br /><br />Wenn der Ausschnittsammelbehälter aktiviert wurde, erscheint auch ein Link, das diese Person in den Ausschnittsammelbehälter hinzufügt.<br /><br /><b>#pgv_lang[relationship_to_me]#</b> erscheint nur, wenn Sie angemeldet sind und Ihnen eine ID-Nummer in der GEDCOM-Datei zugewiesen wurde. Ihnen wird mit diesem Link gezeigt, wie Sie mit dieser Person verwandt sind.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Wenn Sie dieses Link klicken, wird die Person zum Löschen markiert.<br /><br />Was bedeutet das? Angenommen Sie möchten aus irgendeinem Grund eine Person löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen. Bei näherem Betrachten werden Sie feststellen, dass die Person weiterhin sichtbar ist und wie zuvor gewählt werden kann.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~NAMEN EDITIEREN ODER LÖSCHEN~<br /><br /><b>Namen editieren</b><br />Wenn Sie dieses Link klicken, öffnet sich ein Fenster, in dem Sie den Namen der Person verändern können. Das funktioniert einfach, indem Sie die Änderungen in die Felder schreiben und auf Speichern klicken. Dann können Sie das Fenster einfach schließen.<br /><br /><b>Namen löschen</b><br />Wenn Sie dieses Link klicken, wird der Name zum Löschen markiert. Beachten Sie bitte, dass das Löschen eines Namens etwas anderes ist als das Löschen einer Person. Wenn Sie den Namen löschen, wird nur der Name der Person entfernt. Die Person selbst wird <u>nicht</u> gelöscht. Wenn Sie den Namen unter »auch bekannt als« löschen, trägt die Person immer noch ihre anderen Namen. Wenn Sie alle Namen löschen, wird die Person anschließend unter <b>#pgv_lang[NN]#</b> aufgezählt. Die Person wird aber nicht von den übrigen Verwandten getrennt, ebensowenig von den Links zu Quellen, Notizen usw.<br /><br />Wie funktioniert das? Angenommen Sie möchten aus irgendeinem Grund den Namen einer Person löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen. Bei näherem Betrachten werden Sie feststellen, dass der Name weiterhin sichtbar ist und wie zuvor gewählt werden kann.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~NEUEN NAMEN HINZUFÜGEN~<br /><br />Mit diesem Link können Sie einen weiteren Namen zu einer Person hinzufügen. Eventuell sind Personen unter anderen Namen oder Schreibweisen bekannt. Mit diesem Link können Sie einen neuen Namen zu einer Person hinzufügen, ohne die alten Namen zu ändern.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Wenn Sie dieses Link klicken, können Sie ein der Datenbank bisher unbekanntes Kind zu dieser Familie hinzufügen. »Diese Familie« ist in diesem Fall der Vater und die Mutter der Person, deren Seite Sie gerade betrachten.<br /><br />Das heißt, Sie fügen einen Bruder oder eine Schwester dieser Person hinzu. Das Verfahren ist einfach: Klicken Sie das Link, und füllen Sie die Felder im Formular aus.<br /><br />Wenn Sie einen Sohn oder eine Tochter der Hauptperson dieser Seite hinzufügen möchten, scrollen Sie ein wenig nach unten und klicken Sie das Link unter »#pgv_lang[as_spouse]#«.";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Wenn Sie dieses Link klicken, können Sie ein der Datenbank bisher unbekanntes Kind zu dieser Familie hinzufügen. »Diese Familie« ist in diesem Fall die Person, deren Seite Sie gerade betrachten und dessen Ehepartner.<br /><br />Das heißt, Sie fügen einen Sohn oder eine Tochter dieser Person hinzu. Das Verfahren ist einfach: Klicken Sie das Link, und füllen Sie die Felder im Formular aus.<br /><br />Wenn Sie einen Bruder oder eine Schwester der Hauptperson dieser Seite hinzufügen möchten, scrollen Sie ein wenig nach oben und klicken Sie das Link unter »pgv_lang[as_child]#«.";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Wenn Sie dieses Link klicken, können Sie die Person als Kind zu einer bestehenden Familie hinzufügen.<br /><br />Wenn z.B. die Eltern einer Person als unbekannt eingetragen wurden, und Sie später feststellen, dass die Eltern auch in der Datenbank eingetragen sind, klicken Sie dieses Link.<br /><br />Geben Sie die ID-Nummer der Familie an (wenn Sie die ID-Nummer nicht kennen, können Sie danach suchen) und die Verbindung ist schon eingetragen.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Wenn Sie dieses Link klicken, fügen Sie die aktuelle Person als Ehemann zu einer bereits bestehenden Familie hinzu. Wenn Sie dieses Link klicken, wird die Person zu einer bestehenden Familie hinzugefügt, in der der Ehemann bisher unbekannt war. Die Person wird den Platz dieses unbekannten Ehemannes einnehmen. Alle Ereignisse, Ehedaten, Informationen und Kinder werden ihre bestehenden Verbindungen zu dieser Familie behalten.<br /><br />Klicken Sie nur dieses Link und geben Sie die ID-Nummer der Familie ein.  Wenn Sie die ID-Nummer nicht kennen, können Sie danach suchen. Diese besondere Option darf nur verwendet werden, wenn die Familie wirklich schon in der Datei existiert. Wenn Sie eine <u>neue</u> Familie hinzufügen möchten, verwenden Sie bitte <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Wenn Sie dieses Link klicken, können Sie eine neue Person eintragen und mit der Hauptperson dieser Seite als Ehemann verknüpfen.<br /><br />Klicken Sie einfach dieses Link und es öffnet sich ein Formular zum Eingeben der neuen Person. Füllen Sie so viele Felder wie möglich aus und klicken Sie den »Speichern« Button.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Diese Option ermöglicht Ihnen, eine bereits bestehende Person als neuen Ehemann mit dieser Person zu verknüpfen.  Dadurch entsteht eine neue Familie, worin die von Ihnen eingegebene Person als Ehemann erscheint.  Sie können auch sofort Details über die Ehe eingeben.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Wenn Sie dieses Link klicken, können Sie dieser Person ein <u>neues</u> Kind hinzufügen.  Dadurch wird auch gleichzeitig eine neue Familie erstellt, die nur ein Elternteil hat.<br /><br />Klicken Sie einfach dieses Link und es öffnet sich ein Formular zum Eingeben des neuen Kindes. Füllen Sie so viele Felder wie möglich aus und klicken Sie den »Speichern« Button.";
$pgv_lang["link_wife_help"]				= "~#pgv_lang[link_as_wife]#~<br /><br />Wenn Sie dieses Link klicken, fügen Sie die aktuelle Person als Ehefrau zu einer bereits in der GEDCOM-Datei bestehenden Familie hinzu. Diese besondere Option darf nur verwendet werden, wenn die Familie wirklich schon in der Datei existiert. Wenn Sie eine neue Familie hinzufügen möchten, verwenden Sie bitte <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]				= "~#pgv_lang[add_new_wife]#~<br /><br />Wenn Sie dieses Link klicken, können Sie eine neue Person eintragen und mit der Hauptperson dieser Seite als Ehefrau verknüpfen.<br /><br />Klicken Sie einfach dieses Link und es öffnet sich ein Formular zum Eingeben der neuen Person. Füllen Sie so viele Felder wie möglich aus und klicken Sie den »Speichern« Button.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Diese Option ermöglicht Ihnen, eine bereits bestehende Person als neue Ehefrau mit dieser Person zu verknüpfen.  Dadurch entsteht eine neue Familie, worin die von Ihnen eingegebene Person als Ehefrau erscheint.  Sie können auch sofort Details über die Ehe eingeben.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~VATER oder MUTTER HINZUFÜGEN~<br /><br />Bei vielen Personen in der GEDCOM-Datei sind Vater bzw. Mutter noch nicht eingetragen.<br /><br />In diesem Fall sehen Sie auf der Seite <b>#pgv_lang[indi_info]#</b>, Ordner <b>#pgv_lang[relatives]#</b> in der Tabelle <b>#pgv_lang[as_child]#</b> die Links zum hinzufügen von Vater oder Mutter.<br /><br />Bitte beachten Sie, dass diese Links bestimmt sind, Eltern einzutragen, wenn <u>keine</u> Eltern vorhanden sind. Wenn Vater oder Mutter bereits in der GEDCOM-Datei eingetragen sind, benutzen Sie bitte <b>#pgv_lang[link_as_child]#</b>, das Sie ebenfalls auf der Seite <b>#pgv_lang[indi_info]#</b> unterhalb der letzten Tabelle finden.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Wenn diese Option angekreuzt ist, können Sie alle Quellenangaben oder Bemerke dieser Person sehen.  Wenn die Option nicht angekreuzt ist, werden Quellenangaben oder Bemerke, die mit Fakten verbunden sind, nicht gezeigt.";
$pgv_lang["age_differences_help"]		= "~#pgv_lang[age_differences]#~<br /><br />Wenn die Option angekreuzt ist, zeigt der »#pgv_lang[relatives]#« Ordner Differenzen zwischen Daten wie folgt:<ul><li><b>Geburtsdaten der Partner.</b><br />Die negative Zahl bedeutet dass der zweite Partner älter ist als der erste.</li><li><b>Ehedatum und Geburtsdatum des ersten Kindes.</b><br />Die negative Zahl bedeutet dass das Kind vor der Ehe geboren wurde oder dass entweder das Ehedatum oder das Geburtsdatum des ersten Kindes fehlerhaft ist.</li><li><b>Geburtsdaten der Geschwister.</b><br />Die negative Zahl bedeutet dass entweder die Reihenfolge oder die Geburtsdaten fehlerhaft sind.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~NEUE EREIGNISSE HINZUFÜGEN~<br /><br />Hier können Sie ein Ereignis zu einer Person hinzufügen.<br /><br />Wählen Sie zunächst das Ereignis aus der Liste, klicken Sie dann den »Hinzufügen« Button. In der Liste befinden sich schon alle möglichen Ereignisse, die zum Hinzufügen in Frage kommen.";
$pgv_lang["add_custom_facts_help"]		= "~Ein benutzerdefiniertes Ereignis hinzufügen~<br /><br />Wenn Sie das Ereignis, das Sie hinzufügen möchten, in der Liste der vordefinierten Ereignisse nicht finden können, benutzen Sie ein <b>Benutzerdefiniertes Ereignis</b>.<br /><br />Es gibt bei der Eingabe keinen wesentlichen Unterschied zu einem vordefinierten Ereignis. Sie müssen nur für das Ereignis zusätzlich eine Bezeichnung eingeben. Nutzen Sie hierfür das oberste Feld: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~NEUE NOTIZ HINZUFÜGEN~<br /><br />Wenn Sie eine Notiz zu einer Person hinzufügen möchten, können Sie das hier tun.<br /><br />Klicken Sie einfach das Link, dann öffnet sich ein Formular und Sie können die Notiz dort eingeben. Wenn Sie fertig sind, klicken Sie den Button unter der Box und schließen Sie das Formular.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]		= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Wenn Sie <b>#pgv_lang[add_shared_note]#</b> klicken, öffnet sich ein Formular.  Sie können dann eine Verbindung zu einer bereits bestehenden gemeinsamen Bemerkung herstellen, oder Sie können eine neue gemeinsame Bemerkung erstellen und auch gleichzeitig die notwendige Verbindung herstellen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~Neues Quellenzitat hinzufügen~<br /><br />Wenn Sie ein neues Quellenzitat hinzufügen möchten, können Sie das hier tun.<br /><br />Klicken Se einfach das Link, dann öffnet sich ein Formular.  Sie können die Quelle, die Sie zitieren möchten, aus einer Liste wählen, oder Sie können erst die neue Quelle erstellen und danach zitieren.<br /><br />Quellenzitate sind für Ahnenforscher sehr wichtig; Mit Quellenzitaten können Andere Ihrer Forschung folgen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br /><br />Das Hinzufügen von Multimediadateien (MM) zum GEDCOM ist eine sehr schöne Funktion. Obwohl dieses Programm ohne Medien bereits gut aussieht, wird es nur besser, wenn Sie Ihren Verwandten Bilder oder andere MM hinzufügen.<br /><br /><b>Was Sie über MM verstehen sollten.</b><br />Es gibt viele MM-Formate. Obwohl PhpGedView mit den meisten davon arbeiten kann, ist einiges zu beachten.<br /><ul><li><b>Formate</b><br />Bilder können in vielen Formaten bearbeitet und gespeichert werden. Beispiel: .jpg, .png, .bmp, .gif usw. Wenn zum Erstellen der einzelnen Formate dasselbe Originalbild verwendet wurde, scheint das angezeigte Bild unabhängig vom verwendeten Format dieselbe Größe zu haben. Die in der Datenbank gespeicherten Bilddateien variieren jedoch erheblich in der Größe. Im Allgemeinen werden JPG-Bilder als am effizientesten in Bezug auf den Speicherplatz betrachtet.</li><li><b>Bildgröße</b><br />Je größer das Originalbild ist, desto größer ist die Größe der resultierenden Datei. Das Bild sollte ohne Scrollen auf den Bildschirm passen. Die maximale Breite oder Höhe sollte nicht größer als die Breite oder Höhe des Bildschirms sein. PhpGedView wurde für Bildschirme mit 1024 x 768 Pixel entwickelt, aber diese Größe steht nicht ganz zum Anzeigen von Bildern zur Verfügung. Die Bildgröße sollte entsprechend eingestellt werden. Um die Dateigröße zu verringern, sind kleinere Bilder wünschenswerter.</li><li><b>Auflösung</b><br />Die Auflösung eines Bildes wird normalerweise in »dpi« (»dots per inch« = »Punkte pro Zoll«) gemessen. Dies gilt jedoch nur für gedruckte Bilder. Wenn Sie Bilder betrachten, die auf dem Bildschirm dargestellt sind, ist die einzig richtige Methode die Verwendung von Pixeln. Beim Drucken kann das Bild je nach Drucker eine Auflösung von 150 - 300 dpi oder mehr haben. Bildschirmauflösungen sind selten besser als 50 Pixel pro Zoll. Wenn Ihr Bild niemals gedruckt wird, können Sie die Auflösung (und damit die Dateigröße) sicher verringern, ohne die Bildqualität zu beeinträchtigen. Wenn ein Bild mit niedriger Auflösung mit zu großer Vergrößerung gedruckt wird, leidet seine Qualität: es wird ein körniges Aussehen haben.</li><li><b>Farbtiefe</b><br />Eine andere Möglichkeit, eine Datei klein zu halten, besteht darin, die Anzahl der verwendeten Farben zu verringern. Die Anzahl der Farben kann von reinem Schwarz und Weiß (zwei Farben) bis zu echten Farben (Millionen von Farben) und allem dazwischen variieren. Sie können sehen, dass die Dateien umso größer sind, je mehr Farben verwendet werden.</li></ul><br /><b>Warum ist es wichtig, die Dateigröße klein zu halten?</b><ul><li>Zunächst einmal: Unser Speicherplatz ist begrenzt. Je mehr große Dateien vorhanden sind, desto mehr Speicherplatz benötigen wir auf dem Server. Je mehr Platz wir brauchen, desto höher sind unsere Kosten.</li><li>Bandbreite. Je mehr Daten unser Server zu Ihnen senden muss, desto mehr müssen wir bezahlen. Dies liegt daran, dass die Tragfähigkeit der Verbindung des Servers zum Internet begrenzt ist und die Verbindung von allen Programmen auf dem Server gemeinsam genutzt (und bezahlt) werden muss. PhpGedView ist eine von vielen Programmen, die den Server gemeinsam nutzen. Die Kosten werden normalerweise nach der Datenmenge aufgeteilt, die jedes Programm sendet und empfängt.</li><li>Download-Zeit. Wenn Sie große Dateien haben, müssen Sie lange warten, bis die Seite vom Server vollkommen heruntergeladen ist. Nicht jeder ist mit einer Kabelverbindung, Breitband oder DSL gesegnet.</li></ul><br /><b>MM hochladen</b><br />Es gibt zwei Möglichkeiten, Medien auf die Site hochzuladen. Wenn Sie viele Medien hochladen müssen, sollten Sie sich an den Verwalter wenden, um die besten Möglichkeiten zu besprechen. Wenn es von dem Verwalter aktiviert wurde, können Sie das Formular zum Hochladen von Medien in Ihrem Menü #pgv_lang[mgv]# verwenden. Sie können auch die Option Hochladen im Multimedia-Formular verwenden, um Medienelemente hochzuladen.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Diese Option erzeugt fehlende Miniaturbilder für alle Bilder in diesem Verzeichnis.  Das ist leichter und schneller als das Benutzen der einzelnen <b>#pgv_lang[gen_thumb]#</b> Optionen.<br /><br />Sie müssen die einzelnen <b>#pgv_lang[gen_thumb]#</b> Optionen benutzen, wenn nicht alle fehlende Miniaturbilder erzeugt werden sollen.";
$pgv_lang["add_facts_general_help"]		= "~Allgemeine Informationen über das Hinzufügen~<br /><br />Wenn Sie ein Ereignis, eine Notiz, Quelle oder eine Multi-Media-Datei zu einer Person hinzugefügt haben, muss dieser Vorgang erst von einem Benutzer mit »Akzeptieren«-Rechten überprüft werden.<br /><br />Inzwischen sind die Änderungen auf der Seite nur für Benutzer mit Editier-Rechten sichtbar und mit einem andersfarbigen Rahmen gekennzeichnet. Wenn die Angaben überprüft sind, verschwinden die andersfarbigen Rahmen und die Daten werden dann wie üblich dargestellt.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	= "Auf dieser Seite können Sie Ihre persönlichen Einstellungen ändern.<br /><br />Sie können Ihren Benutzernamen, den richtigen Namen, Ihr Kennwort, die Sprachanzeige, Mail-Adresse, verwendetes Theme und die bevorzugte Kontakt-Methode anpassen.<br /><br />Was Sie nicht selbst ändern können, ist Ihre ID-Nummer in der Datenbank.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />In diesem Feld können Sie Ihren Benutzernamen ändern.<br /><br />Wenn Sie einen neuen Benutzernamen haben möchten, können Sie ihn hier eintragen. Beim Benutzernamen müssen Sie auf <u>Groß- und Kleinschreibung</u> achten. Das bedeutet, das <b>John</b> nicht das gleiche ist wie <b>john</b> oder <b>JOHN</b>.<br /><br />Sie sollten <u>ausschließlich</u> Buchstaben des vom Programm unterstützten Alphabets (große oder kleine Buchstaben) mit oder ohne Umlauten, Ziffern, Bindestriche (-) und Unterstriche (_) verwenden. Verwenden Sie <b>keine</b> Interpunktionszeichen oder Leerzeichen.";
$pgv_lang["edituser_firstname_help"]	= "~#pgv_lang[firstname]#~<br /><br />Durch Eingaben in diesem Feld können Sie Ihren Vornamen ändern.  Ihre Vor- und Nachnamen, die Sie hier eingeben, sind anderen angemeldeten Benutzern sichtbar wenn diese auch angemeldet sind.<br /><br />Obwohl diese Namen Ihnen überlassen sind, sollten Sie den Verwalter über Änderungen Ihres Benutzernamens benachrichtigen.  So hat der Verwalter immer über eingetragene Benutzer Bescheid, ohne die Benutzerliste mühsam nach Änderungen zu durchsuchen.  Er kann dann Fragen anderer Benutzer über neu erscheinende Benutzer leicht beantworten.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />Durch Eingaben in diesem Feld können Sie Ihren Nachnamen ändern.  Ihre Vor- und Nachnamen, die Sie hier eingeben, sind anderen angemeldeten Benutzern sichtbar wenn diese auch angemeldet sind.<br /><br />Obwohl diese Namen Ihnen überlassen sind, sollten Sie den Verwalter über Änderungen Ihres Benutzernamens benachrichtigen.  So hat der Verwalter immer über eingetragene Benutzer Bescheid, ohne die Benutzerliste mühsam nach Änderungen zu durchsuchen.  Er kann dann Fragen anderer Benutzer über neu erscheinende Benutzer leicht beantworten.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Diese interne ID-Nummer verweist auf Ihre Daten in der Datenbank.<br /><br />Diese ID-Nummer können Sie nicht selbst ändern, sie wird immer vom Verwalter eingetragen. Wenn Sie glauben, dass Ihre ID-Nummer nicht korrekt ist, kontaktieren Sie bitte den Verwalter, nur er kann sie ändern.";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Dies ist die Ausgangsperson aller Ihrer Diagramme.<br /><br />Wenn Sie z.B. einen Stammbaum darstellen lassen, dann ist diese Person die äußerste Person am linken Rand. Natürlich muss diese Person nicht immer Sie selbst sein. Sie können jede beliebige Person wählen, solange Sie berechtigt sind diese Person überhaupt zu sehen.<br /><br />Bei der Ausgangsperson beginnen die Diagramme. In einigen Diagrammen können Sie die Ausgangsperson auch speziell nur für diese Seite ändern.";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />Es wird empfohlen, Ihr Passwort regelmäßig zu ändern. Sie müssen bedenken, dass jeder, der Ihren Benutzernamen und Ihr Passwort kennt, Zugriff auf Ihre Daten hat.<br /><br />Machen Sie das Passwort mindestens 6 Zeichen lang, je länger desto besser. Sie können Groß- und Kleinbuchstaben mit oder ohne diakritische Zeichen, Zahlen, Bindestrich »-« und Unterstrich »_« verwenden. Verwenden Sie <u>keine</u> Satzzeichen oder Leerzeichen.Verwenden Sie eine Kombination aus Groß- und Kleinbuchstaben, Zahlen und anderen Zeichen. Beispiel: <b>5Z_q\$P4=r9</b>.<br /><br />Wie der Benutzername, unterscheidet auch das Kennwort zwischen <u>Groß-</u> und <u>Kleinschreibung</u>.Das bedeutet, dass <b>Geheimes.Kennwort!#13</b> nicht dasselbe ist wie <b><b>Geheimes.Kennwort!#13</b>!#13</b> oder <b>GEHEIMES.KENNWORT!#13</b>. " ;;
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Wenn Sie Ihr Kennwort geändert haben, muss es ein zweites Mal eingegeben werden. Dies soll sicherstellen, dass Sie sich nicht bei der Eingabe vertippt haben.<br /><br />Wenn die beiden Eingaben nicht übereinstimmen, erhalten Sie eine Fehlermeldung. Beide Felder (Kennwort- und Bestätigungsfeld) werden geleert und Sie müssen Ihr neues Kennwort nochmals in beiden Feldern eingeben.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Hier können Sie die Sprache ändern, in der PhpGedview alle Seiten und Nachrichten zeigt, nachdem Sie sich angemeldet haben.<br /><br />Wenn Sie zum ersten Mal auf die Site zugreifen, nimmt PhpGedView an, dass Sie alles in der Sprache sehen möchten, die in Ihrem Browser als bevorzugte Sprache konfiguriert ist. Wenn diese Annahme falsch ist, können Sie sie hier ändern. Ihr Browser ist möglicherweise auf Englisch eingestellt, da dies die im Internet am häufigsten verwendete Sprache ist. Aus genealogischen Gründen möchten Sie jedoch lieber alles auf Finnisch oder Deutsch sehen. Hier machen Sie das.<br /><br />Der Verwalter bestimmt, welche Sprachoptionen Ihnen zur Verfügung stehen. Wenn Ihre Präferenz nicht aufgeführt ist, müssen Sie sich an den Verwalter wenden.<br /><br />Bitte denken Sie daran, dass PhpGedView ein Projekt ist, das von einem internationalen Team unbezahlter Freiwilliger besetzt wird. Experten kommen und gehen. Folglich ist die Unterstützung für andere Sprachen als Englisch manchmal nicht so gut, wie sie sein sollte.<br /><br />Wenn Sie etwas sehen, das nicht übersetzt wurde, falsch übersetzt wurde oder besser formuliert werden könnte, teilen Sie dies dem Verwalter mit. Der Verwalter weiß, wie er sich mit dem PhpGedView-Entwicklerteam in Verbindung setzen kann, um Ihre Bedenken anzusprechen. Besser noch, melde Sie sich freiwillig für einen Teil Ihrer Zeit. Wir können die Hilfe nutzen.";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Ihre korrekte Mail-Adresse ist wichtig, damit der Verwalter mit Ihnen in Kontakt bleiben kann.<br /><br />Wenn Sie eine neue Mail-Adresse erhalten (z.B. bei Providerwechsel), vergessen Sie bitte nicht, diese auch hier einzutragen. Falls Sie mehrere Mail-Adressen haben und für genealogische Fragen eine bestimmte Adresse bevorzugen, geben Sie diese bitte hier an.";
$pgv_lang["edituser_user_theme_help"]	= "~#pgv_lang[user_theme]#~<br /><br />Diese Seite können Sie sich in verschiedenen Themes zeigen lassen.<br /><br />Man könnte es auch als »Seiten-Layout« bezeichnen. In jedem Theme sehen Sie die selben Daten aber in einer anderen Darstellung. Es ist vergleichbar mit dem Wechsel eines Bilderrahmens oder dem Aufhängen eines Bildes in einem anderen Zimmer. Das Bild verändert sich dabei nicht, aber die Ansicht ist doch eine ganz andere.<br /><br />Probieren Sie es einfach aus. Stellen Sie ein anderes Theme ein. Geben Sie hier Ihr bevorzugtes Theme an. Immer wenn Sie sich bei dieser Seite anmelden, wird das Programm Ihr zuletzt benutzes Theme verwenden.";
$pgv_lang["edituser_contact_meth_help"]	= "~#pgv_lang[user_contact_method]#~<br /><br />Das Nachrichten-System dieser Seite bietet verschiedene Methoden an. Die Sende-Methode wird vom Verwalter gewählt. Die Methode zum Nachrichten-Empfang können Sie hier einstellen.";
$pgv_lang["mail_option1_help"]			= "Wenn Sie diese Option nutzen, wird das interne PhpGedView Nachrichtensystem benutzt und es werden keine Mails versendet.<br /><br />Sie erhalten nur <u>interne</u> Nachrichten von den anderen Benutzern. Wenn ein anderer Site-Benutzer Ihnen eine Nachricht sendet, wird diese Nachricht im Nachrichtenblock auf Ihrer persönlichen #pgv_lang[mygedview]# Seite angezeigt. Wenn Sie diesen Block von Ihrer #pgv_lang[mygedview]# Seite entfernt haben, werden keine Nachrichten angezeigt. Sie werden jedoch angezeigt, sobald Sie die #pgv_lang[mygedview]# Seite konfigurieren dass sie erneut den Nachrichtenblock enthält.";
$pgv_lang["mail_option2_help"]			= "Diese standardmäßig eingestellte Option entspricht der Einstellung #pgv_lang[messaging]# mit einer Ergänzung.<br /><br />Zusätzlich wird eine Kopie der Nachricht an die Mail-Adresse geschickt, die Sie angegeben haben.";
$pgv_lang["mail_option3_help"]			= "Mit dieser Option erhalten Sie nur E-Mail-Nachrichten an der Adresse, die Sie auf Ihrer Kontoseite konfiguriert haben. Das in PhpGedView interne Nachrichtensystem wird überhaupt nicht verwendet, und es werden niemals Nachrichten im Nachrichtenblock auf Ihrer persönlichen #pgv_lang[mygedview]# Seite angezeigt.";
$pgv_lang["mail_option4_help"]			= "Mit dieser Option werden Sie überhaupt keine Nachrichten erhalten. Selbst der Verwalter kann Sie nicht erreichen.";

//-- Admin
$pgv_lang["admin_help"]					= "Auf dieser Seite finden Sie alle Links zur Konfigurations-Seiten, Dokumentation und Protokoll-Dateien.<br /><br />Die <b>#pgv_lang[system_time]#</b>, direkt unter der Seiten-Überschrift zeigt die Uhrzeit des Servers, auf dem Ihre Seite gehostet ist. Das heißt, wenn sich der Server in New York befindet, während Sie sich in Deutschland befinden, ist die angezeigte Zeit sechs Stunden kürzer als Ihre Ortszeit, es sei denn, der Server läuft natürlich mit Greenwich Mean Time (GMT). Die gezeigte Zeit ist die, bei der Sie die Seite geöffnet oder neu geladen haben.<br /><br /><b>ACHTUNG</b><br />Wenn unterhalb der System-Zeit eine Warnung erscheint, bedeutet das, dass die Datei <i>config.php</i> noch Schreibrechte besitzt. Nachdem Sie Ihre Seite konfiguriert haben, sollten Sie zur <b>Sicherheit</b> die Rechte für diese Datei wieder auf nur-lesen setzen. Dies müssen Sie <b>manuell</b> tun, da PhpGedView diesen Schritt nicht durchführen kann.";

//-- User Admin
$pgv_lang["useradmin_help"]				= "~#pgv_lang[user_admin]#~<br /><br />Auf dieser Seite können Sie die vorhandenen Benutzer verwalten und neue anlegen.<br /><br /><b>#pgv_lang[current_users]#</b><br />In dieser Tabelle werden die vorhandenen Benutzer, deren Status und Rechte gezeigt. Sie können Benutzer <b>löschen</b> oder <b>bearbeiten</b>.<br /><br /><b>#pgv_lang[add_user]#</b><br />Dieses Formular ähnelt dem Formular <b>#pgv_lang[editowndata]#</b>. Für viele Punkte gibt es keine speziellen Hilfe-Texte für Verwalter. Dort lesen Sie den Text:";
$pgv_lang["useradmin_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Diese ID muss der Verwalter für den Benutzer setzen. Sie identifiziert den Benutzer in der GEDCOM-Datei.<br /><br />Sie legt auch den Zugriff des Benutzers fest für die <b>#pgv_lang[my_indi]#</b> und <b>#pgv_lang[my_pedigree]#</b> Seiten.<br /><br />Für jede GEDCOM-Datei, die Sie in diesem Programm verwenden, können Sie die ID-Nummer für den Benutzer festlegen. Wenn ein Benutzer in einer Datei nicht genannt wird und daher auch keine ID-Nummer hat, lassen Sie dieses Feld leer.";
$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Für jede GEDCOM-Datei können Sie eine <b>Start-Person</b> je Benutzer festlegen.<br /><br />Wahrscheinlich möchtet der Benutzer das Programm mit seinem eigenen Stammbaum beginnen. Der Verwalter steuert dies hier, sowie die Standard-Start-Person in anderen Diagrammen.<br /><br />Wenn der Benutzer über Bearbeitungsrechte für seine eigenen Kontoinformationen verfügt, kann er diese Einstellung selbst ändern.";
$pgv_lang["useradmin_can_admin_help"]	= "~#pgv_lang[can_admin]#~<br /><br />Wenn diese Option angekreuzt ist, hat der Benutzer die gleichen Rechte für das Programm, wie Sie als Verwalter.<br /><br />Er kann:<ul><li>Benutzer hinzufügen / löschen / bearbeiten</li><li>Eine Nachricht an alle Nutzer gleichzeitig senden</li><li>Die Begrüßungs-Nachrichten bearbeiten</li><li>Sprachdateien bearbeiten und konfigurieren</li><li>Einen Upgrade des Programmes durchführen</li><li>Die Konfiguration ändern</li><li>Die GEDCOM-Dateien verwalten</li><li>Die Datenschutzeinstellungen ändern</li><li>Und vieles andere, was hier nicht genannt ist</li></ul><br />Außerhalb dieses Programmes hat er dadurch noch keine weiteren Rechte.";
$pgv_lang["useradmin_sync_gedcom_help"]	= "~#pgv_lang[sync_gedcom]#~<br /><br />Wenn diese Option angekreuzt ist und der Benutzer auch eine ID-Nummer in der Personen-Datenbank hat, werden einige Änderungen in der Personen-Datenbank die diesen Benutzer betreffen auch automatisch in dessen Benutzer-Datensatz übertragen. Wenn Sie in der Personen-Datenbank Einträge wie Mail-Adresse oder Namen ändern, werden diese Änderungen auch automatisch in den Benutzer-Datensatz dieser Person übertragen.  Änderungen an Daten der Benutzer-Datenbank die gemeinsam mit der Personen-Datenbank sind werden auch in die Personen-Datenbank übernommen.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />Für jede GEDCOM-Datei werden jedem Benutzer bestimmte Zugriffs- und Editier-Rechte zugewiesen.<ul><li><b>#pgv_lang[none]#</b>&nbsp;&nbsp;&nbsp;Der Benutzer hat keinen Zugriff auf private Daten in der GEDCOM-Datei.</li><li><b>#pgv_lang[access]#</b>&nbsp;&nbsp;&nbsp;Der Benutzer kann zwar keine Daten ändern und keine Änderungen akzeptieren, aber er darf private Daten sehen.</li><li><b>#pgv_lang[edit]#</b> Der Benutzer darf Daten ändern, aber ein anderer Benutzer mit dem Recht <b>#pgv_lang[accept]#</b> muss die Änderungen erst bestätigen, bevor sie in die Datenbank eingetragen werden und veröffentlicht werden.</li><li><b><b>#pgv_lang[accept]#</b></b>&nbsp;&nbsp;&nbsp;Der Benutzer darf sowohl Daten ändern, als auch Änderungen anderer freigeben.</li><li><b>#pgv_lang[admin_gedcom]#</b>&nbsp;&nbsp;&nbsp;Der Benutzer darf sowohl Daten ändern, als auch Änderungen anderer freigeben.  Er darf auch die Konfiguration und die Datenschutzeinstellungen dieser GEDCOM-Datei ändern.</li></ul>Systemadministratoren, die über das Feld <b>#pgv_lang[can_admin]#</b> gekennzeichnet sind, erhalten automatisch die Berechtigungen <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]	= "~#pgv_lang[verified]#~<br /><br /><b>Selbst-Registrierung</b><br />Ein Benutzer kann einen neuen Benutzerzugang mit Hilfe des <b>Selbst Registrierungs</b> Moduls anlegen.<br /><br />Wenn er dies tut, erhält er eine Mail mit einem Link zur Bestätigung seiner Angaben. Nachdem er diese Anweisungen durchgeführt hat, sehen Sie diese Box aktiviert und Sie können mit dem nächsten Schritt fortfahren: <b>#pgv_lang[verified_by_admin]#</b>.<br /><br />Wenn der Benutzer sich noch nicht selbst verifiziert hat, sollten Sie mit Ihrer Überprüfung warten.<br /><br /><b>Benutzer manuell erstellen</b><br />Wenn Sie dieses Formular benutzen um einen Benutzer manuell hinzuzufügen, dann ist diese Option bereits angekreuzt.";
$pgv_lang["useradmin_verbyadmin_help"]	= "~#pgv_lang[verified_by_admin]#~<br /><br />Wenn ein Benutzer sich mit Hilfe des Selbst Registrierungs Moduls angemeldet und bereits selbst verifiziert hat, dann ist der letzte Schritt Ihre Zustimmung, bevor der Benutzerzugang freigeschaltet ist.<br /><br />Nachdem Sie Ihre Zustimmung erteilt haben, erhält der Benutzer eine Mail-Nachricht, dass sein Zugang nun freigegeben ist und dass er sich mit seinem Benutzernamen und Kennwort anmelden kann.";
$pgv_lang["useradmin_edit_user_help"]	= "~#pgv_lang[update_user]#~<br /><br />Dieses Formular dient dem Verwalter zum Ändern der Benutzerdaten.<br /><br />Das Formular ähnelt den Formularen <b>#pgv_lang[add_user]#</b> und <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]	= "~#pgv_lang[visibleonline]#~<br /><br />Wenn aktiviert, können andere angemeldete Benutzer sehen, wenn diese Person ebenfalls angemeldet ist und umgekehrt.<br /><br />Wenn Sie nicht möchten dass andere Personen sehen wenn Sie angemeldet sind, sollten Sie die Option deaktivieren, dann sehen Sie aber auch nicht mehr andere angemeldete Benutzer.";
$pgv_lang["useradmin_editaccount_help"]	= "~#pgv_lang[editaccount]#~<br /><br />Wenn dieses Kästchen aktiviert ist, kann dieser Benutzer seine Kontoinformationen bearbeiten. Obwohl dies im Allgemeinen nicht empfohlen wird, können Sie einen einzelnen Benutzernamen und ein Kennwort für mehrere Benutzer erstellen. Wenn dieses Kästchen für alle Benutzer mit dem freigegebenen Konto deaktiviert ist, können sie die Kontoinformationen nicht bearbeiten, und nur ein Verwalter kann dieses Konto ändern.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Wenn aktiviert, darf der Benutzer Daten lebender Personen nur sehen, wenn er mit ihnen verwandt ist.<br /><br />Die <i>#pgv_lang[user_path_length]#</i> Option bestimmt die Verwandtschafts-Entfernung, innerhalb welcher Daten lebender sichtbar sind.  Datenschutz durch Verwandtschafts-Entfernung kann für alle Benutzer in der Konfiguration der Datenschutz-Datei eingestellt werden.<br /><br />Datenschutz durch Verwandtschafts-Berechnung erfordert dass der betroffene Benutzer in der Personen-Datenbank eingetragen ist.";
$pgv_lang["useradmin_path_length_help"]	= "~#pgv_lang[user_path_length]#~<br /><br />Wenn die Option <i>#pgv_lang[user_relationship_priv]#</i> aktiviert ist, bestimmt diese Option die maximale Verwandtschafts-Entfernung innerhalb welcher der Benutzer Daten lebender zugreifen kann.";
$pgv_lang["useradmin_auto_accept_help"]	= "~#pgv_lang[user_auto_accept]#~<br /><br />Falls angekreuzt, übernimmt das System automatisch alle von diesem Benutzer vorgenommene Änderungen.  Diese Option ist ohne Bedeutung wenn der Benutzer nur das Recht hat, Daten zu bearbeiten und nicht das Recht, Änderungen zu übernehmen.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />Hier können Sie fremde Seiten hinzufügen.  Sie können auch den Zugriff zu dieser Site von bestimmten IP Adressen sperren.<br /><br />Fremde Seiten werden hinzugefügt indem Sie Titel und Zugriffsdaten (URL, Datenbank ID, Benutzername, und Kennwort) eingeben.<br /><br />Dauerhafte oder zeitlich bestimmte Zugriffsperren können Sie durch das richtige Eingeben von Bereichen oder genauen IP-Adressen verwirklichen, zum Beispiel: <b>192.10.12.254</b> oder <b>212.10.*.*</b> .  Zugriffe zu diesen Seiten wird nur erlaubt wenn die IP-Adresse des anderen Endes nicht in einem der gesperrten IP-Adressen Bereiche enthalten ist.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />Um eine neue fremde Seite in die Liste einzutragen, müssen Sie den Titel und die Zugriffsdaten (URL, Datenbank-ID, Benutzername, und Kennwort) eingeben.  Falls die fremde Seite anonymen Zugriff erlaubt, müssen Sie die Benutzername und Kennwort Felder leer lassen.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "Adressen im IPv4 Format bestehen aus 4 Teilen, die durch \".\" (Punkt) getrennt sind, und Dezimalzahlen zwischen  0 und 255, ohne leitende Nullen, enthalten.  Zum Beispiel: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> oder <b>212.10.*.29</b> . Fehlende Teile in diesen Beispielen werden als \"*\" (Sternchen) erkannt.  Dieses Symbol bedeutet, <i>entspricht jeder beliebigen Zahl in diesem Teil</i>.<br /><br />Adressen im IPv6 Format bestehen aus 8 Teilen, die durch \":\" (Doppelpunkt) getrennt sind, und 4-stellige Hexadezimalzahlen enthalten.  Diese Zahlen sollen keine leitende Nullen haben, und die erste Reihe von Nullen darf mit \"::\" (doppelte Doppelpunkte) ersetzt werden.  Falls Sie eine beliebige Zahl andeuten möchten, müssen Sie an deren Stelle ein \"*\" (Sternchen) eingeben.  Zum Beispiel: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> oder <b>23:0:*::*:*</b> .  In diesen Beispielen, sind eine Reihe von 3 Nullen durch doppelte Doppelpunkte ersetzt worden, wie <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />Um den Zugriff von bestimmten IPv4- oder IPv6-Adressen zu sperren, können Sie hier genaue IP-Adressen oder einen IP-Adressen Bereich eingeben.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />Wenn ein Hacking-Versuch erkannt wird, verhindert PhpGedView automatisch den Zugriff von dieser IP-Adresse für eine Stunde.<br /><br />Sie können Ihre eigenen zeitgesteuerten Zugriffsverweigerungen hinzufügen, indem Sie die IPv4- oder IPv6-Adresse eingeben, zusammen mit dem Zeitpunkt des Ablaufs der Zugriffsverweigerung. Stellen Sie sicher, dass Sie das richtige Format für die Ablaufinformationen verwenden. Wenn die Ablaufinformationen nicht korrekt eingegeben werden, läuft die Zugriffsverweigerung nicht automatisch ab.<br /><br />Ablaufdatum und Zeit müssen im 24-Stunden Format <b>JJJJ.MM.TT@SS:MM</b> im Kommentarfeld eingegeben werden. Zum Beispiel, <b>2012.12.23@23:59</b> .<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]	= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView liefert Suchmaschinen automatisch kleinere Seiten, mit wenigeren Links.  Die gelieferten Daten sind auf die gesuchte Person und dessen sehr nahe Verwandtschaft beschränkt. Daten über Großeltern oder Enkel werden Suchmaschinen <u>nicht</u> geliefert.  Suchmaschinen können auch nicht auf Berichte, viele Diagramme, und den Jahrestag-Kalender zugreifen.<br /><br />Die meisten Suchmaschinen werden automatisch erkannt.  Falls eine Suchmaschine nicht automatisch erkannt wird und Sie die Datenlieferung beschränken möchten, können Sie hier die IPv4- oder IPv6-Adresse der neuen Suchmaschine eingeben.  Falls Sie den Zugriff der neuen Suchmaschine verbieten möchten, können Sie die IP-Adressen in der Liste <i>#pgv_lang[label_banned_servers]#</i> eintragen.<br /><br />Falls Sie versuchen möchten, welche Daten Suchmaschinen geliefert werden, können Sie die IP-Adresse Ihres lokalen Computers hier eingeben.&nbsp; <span class='warning'>WARNUNG</span>&nbsp; Wenn Sie die IP-Adresse Ihres Computers hier eingeben, können Sie sich <b>nicht mehr</b> als Verwalter anmelden.  Sie müssen sich dann mit einem Computer mit anderer IP-Adresse anmelden.  Sie können auch manuell die <i>#GLOBALS[TBLPREFIX]#ip_address</i> Datenbanktabelle ändern.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]	= "~Suchmaschine entdeckt~<br /><br />PhpGedView liefert Suchmaschinen automatisch kleinere Seiten, mit wenigeren Links.  Die gelieferten Daten sind auf die gesuchte Person und dessen sehr nahe Verwandtschaft beschränkt. Daten über Großeltern oder Enkel werden Suchmaschinen <u>nicht</u> geliefert.  Suchmaschinen können auch nicht auf Berichte, viele Diagramme, und den Jahrestag-Kalender zugreifen.<br /><br />Wenn Suchmaschinen versuchen, solchen Seiten zuzugreifen, erhalten sie diese Fehlermeldung.  Wenn Sie diese Fehlermedung erhalten, glaubt das Programm dass Ihr lokaler Computer eine Suchmaschine betreibt.  Unten sind alle Seiten, die von Suchmaschinen zugreifbar sind, aufgezeichnet.<br /><br />Gewöhnliche Benutzer, die von Suchmaschinen erstellte Links folgen, erhalten normale Seiten und Daten, und nicht diese Fehlermeldung.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Upload einer GEDCOM-Datei</b><br />Ein Upload wird online durchgeführt. Sie können von jedem Ort aus Daten hochladen, ohne Hilfe eines FTP-Programmes.<br /><br /><b>Hinzufügen von GEDCOM-Dateien</b><br />Wenn eine Datei in Ihrem GEDCOM-Verzeichnis noch existiert, können Sie sie benutzen, ohne sie erneut hochzuladen. Manchmal wählt man Hinzufügen anstelle von Upload, z.B. wegen der Dateigröße oder Upload-Beschränkungen.<br /><br />Beide Vorgänge können in vier einfachen Schritten durchgeführt werden. Nur der erste Schritt ist jeweils anders.";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM KONFIGURATIONS DATEI~<br /><br />Dies ist die Datei in der alle Grundeinstellungen zur GEDCOM-Datei gespeichert werden.<br /><br />In der Spalte <b>#pgv_lang[current_gedcoms]#</b> auf der <b>#pgv_lang[gedcom_adm_head]#</b> Seite wird der Pfad und der Dateiname dieser Datei gezeigt.";
$pgv_lang["default_gedcom_help"]		= "~STANDARD GEDCOM~<br /><br />Wenn Sie mehr als eine GEDCOM-Datei eingetragen haben, können Sie hier andeuten, welche davon die Standard GEDCOM-Datei für dieses Programm sein soll.<br /><br />Das heißt, dass diese Datei den Besuchern und unangemeldeten Benutzern gezeigt wird.<br /><br />Benutzer, die ihre Kontoeinstellungen bearbeiten können, können diese Standardeinstellung überschreiben. In diesem Fall wird die bevorzugte Datenbank des Benutzers nach der Anmeldung angezeigt..";
$pgv_lang["delete_gedcom_help"]			= "~GEDCOM LÖSCHEN~<br /><br />PhpGedView erstellt seine Datenbank aus einer zuvor hochgeladenen GEDCOM-Datei. Wenn Sie <b>Löschen</b> wählen, wird dieser Teil der Datenbank gelöscht. Sie müssen Ihre Löschanforderung bestätigen.<br /><br />Sofern Sie sie nicht absichtlich außerhalb von PhpGedView entfernt haben, verbleibt die ursprüngliche GEDCOM-Datei in dem Ordner, wo sie hochgeladen wurde. Wenn Sie später wieder mit dieser GEDCOM-Datei arbeiten möchten, ist es nicht nötlich, sie erneut hochzuladen. Sie können die Funktion <b>#pgv_lang[add_gedcom]#</b> benutzen.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Wenn Sie die Funktion <b>#pgv_lang[add_gedcom]#</b> verwenden, wird angenommen, dass Sie die GEDCOM-Datei bereits mit einem Programm oder einer Methode <u>extern</u> zu PhpGedView auf Ihren Server hochgeladen haben, wie zum Beispiel, mit einem <i>FTP</i>-Programm oder durch eine <i>Netzverbindung</i>. Die Datei, die Sie hinzufügen möchten, könnte auch von einem vorherigen <b>#pgv_lang[upload_gedcom]#</b> Verfahren übrig geblieben sein.<br /><br />Wenn sich die eingegebene GEDCOM-Datei noch nicht auf Ihrem Server befindet, müssen Sie sie <u>zuerst</u> dort hinbringen, bevor Sie mit dem Hinzufügen beginnen können.<br /><br />Anstatt eine GEDCOM-Datei hochzuladen, können Sie auch eine ZIP-Datei mit der GEDCOM-Datei hochladen, entweder mit PhpGedView oder mit einem externen Programm. PhpGedView erkennt die ZIP-Datei automatisch und extrahiert die GEDCOM-Datei und ihren Namen aus der ZIP-Datei.<br /><br />Wenn eine gleichnamige GEDCOM-Datei bereits vorhanden ist, wird diese überschrieben. Alle zuvor vorgenommenen GEDCOM-Einstellungen bleiben jedoch erhalten.<br /><br />Sie werden Schritt für Schritt durch den Vorgang geführt.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Sie können eine neue genealogische Datenbank von Grund auf neu starten.<br /><br />Dieses Verfahren erfordert nur wenige einfache Schritte. Schritt 1 unterscheidet sich von dem, was Sie bereits über das Hochladen und Hinzufügen wissen. Die anderen Schritte sind Ihnen schon bekannt.<ol><li><b>Benennung der neuen GEDCOM-Datei</b><br />Geben Sie den Namen der neuen GEDCOM-Datei <u>ohne</u> Namenserweiterung <b>.ged</b> ein. Die neue Datei wird in dem vorig genannten Ordner erstellt. Klicken Sie auf <b>Hinzufügen</b>.</li><li><b>Konfigurationsseite</b><br />Sie kennen diese Seite bereits; Sie konfigurieren die Einstellungen für Ihre neue GEDCOM-Datei.</li><li><b>Prüfen</b><br />Sie kennen diese Seite bereits; Die neue GEDCOM-Datei wird geprüft. Da nichts drin ist, wird sie in Ordnung sein.</li><li><b>Datensätze importieren</b><br />Da nur ein Datensatz importiert werden muss, ist dieser Schritt sehr schnell abgeschlossen.</li></ol>Jetzt können Sie in der Stammbaum-Seite Ihre erste Person in der neuen Datenbank sehen. Klicken Sie den Namen der Person und beginnen Sie mit der Bearbeitung. Danach können Sie neue Personen mit der ersten Person verknüpfen.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Von dieser Seite können Sie Ihre genealogische Datenbank im GEDCOM-Format herunterladen. Möglicherweise möchten Sie die Daten in ein anderes genealogisches Programm importieren oder ihre Informationen mit Anderen teilen.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />Die #pgv_lang[gedcom_adm_head]# Seite ist das Kontrollzentrum für die Verwaltung aller Ihrer genealogischen Datenbanken.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />Am Anfang der <b>#pgv_lang[current_gedcoms]#</b> Liste sehen Sie eine Aktionsleiste mit vier Links.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />In der <b>#pgv_lang[current_gedcoms]#</b> Liste wird jede genealogische Datenbank separat aufgeführt, und Sie haben für jede von ihnen die folgenden Optionen:<ul><li>Importieren</li><li>Löschen</li><li>Download</li><li>Konfiguration bearbeiten</li><li>Privatsphäre bearbeiten</li><li>Suchprotokolldateien</li></ul>»Datenschutz bearbeiten« wird hier aufgeführt, da jedes GEDCOM ihre eigene Datenschutzdatei hat.<br /><br />Jede Zeile in dieser Tabelle sollte selbsterklärend sein. PhpGedView kann so konfiguriert werden, dass alle Datenbanksuchen protokolliert werden. Die Suchprotokolldateien können durch Links auf dieser Seite überprüft werden.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]	= "~GEDCOM-KONFIGURATION BEARBEITEN~<br /><br />Jede in PhpGedView verwendete genealogische Datenbank verfügt über ihre eigene <b>Konfigurationsdatei</b>.<br /><br />In diesem Formular konfigurieren Sie viele Optionen wie Datenbanktitel, Sprache, Kalenderformat, E-Mail-Optionen, Protokollierung von Datenbanksuchen, HTML-META-Headern, Entfernen von Nachnamen aus der Liste der häufigen Nachnamen der Datenbank usw.";
$pgv_lang["import_gedcom_help"]			= "~GEDCOM-DATEI IMPORTIEREN~<br /><br /In den meisten Fällen ist das Importieren einer extern erstellten GEDCOM-Datei ein Schritt in Verfahren, die zu umfangreichen Änderungen an der genealogischen Datenbank führen.<br /><br /Diese Schritte erfolgen in einer logischen Reihenfolge und müssen in der vorgeschriebenen Reihenfolge ausgeführt werden dass die genealogische Datenbank verwendbar ist.<br /><br />Wenn Sie diese Schritte aus irgendeinem Grund nicht in der richtigen Reihenfolge ausgeführt haben, erhalten Sie eine <u>Warnmeldung</u>, dass die GEDCOM-Datei noch nicht importiert wurde. Um das Problem zu beheben, klicken Sie <b>GEDCOM importieren</b>, um die Datei zu importieren.<br /><br />Die Konfiguration der GEDCOM-Datei wird beim Importieren nicht geändert. Die alte Datenbank wird aber überschrieben.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />Im Gegenteil zur Funktion »GEDCOM hinzufügen«, muss noch keine GEDCOM-Datei auf Ihrem Server bereitliegen.<br /><br />In Schritt 1 wählen Sie eine GEDCOM-Datei aus Ihrem lokalen Computer. Geben Sie den vollständigen Pfad und den Dateinamen in das Textfeld ein oder verwenden Sie <b>Durchsuchen</b> auf der Seite.<br /><br />Mit dieser Funktion können Sie auch eine ZIP-Datei hochladen, die die GEDCOM-Datei enthält. PhpGedView erkennt die ZIP-Datei und extrahiert die Datei und den Dateinamen automatisch.<br /><br />Wenn bereits eine GEDCOM-Datei mit demselben Namen vorhanden ist, wird diese nach Ihrer Bestätigung überschrieben. Alle zuvor vorgenommenen GEDCOM-Einstellungen bleiben jedoch erhalten.<br /><br />Weitere Hilfe finden Sie auf anderen Seiten des Verfahrens.";
$pgv_lang["validate_gedcom_help"]		= "~GEDCOM-DATEI PRÜFEN~<br /><br />Die Überprüfung der GEDCOM-Datei, die Sie hochladen oder hinzufügen findet im 3. Schritt der Prozedur statt.<br /><br />Das Programm prüft das korrekte Format von Datumsangaben, Ortsangaben, Zeichensatz, usw. Einige Abweichungen kann das Programm selbst korrigieren, z.B. die Zeilenumbrüche von MacIntosh oder falsche Verwendung von Ortsangaben.  In diesen Fällen sehen Sie eine Meldung, dass das Programm die Daten geändert hat.  Bei anderen Abweichungen erhalten Sie eine Warn-Meldung mit einem Lösungsvorschlag.<br /><br /><b>Weitere Hilfe</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~ANSI NACH UTF-8 KONVERTIEREN~<br /><br />Um sicherzustellen, dass das Programm Ihre GEDCOM-Dateien korrekt behandeln kann, sollten die Dateien im UTF-8-Format gespeichert sein.<br /><br />Viele Genealogie-Programme besitzen eine Option, um Daten im UTF-8-Format zu exportieren.  Falls das Programm, welches Sie benutzen, diese Option nicht anbieten sollte, kann PhpGedView die Konvertierung für Sie übernehmen.<br /><br />Beim Überprüfen der hochgeladenen oder hinzugefügten Dateien, wird PhpGedView feststelllen, ob die Datei im ANSI-Format kodiert ist.";
$pgv_lang["detected_ansi2utf_help"]		= "~ANSI-CODIERUNG ERKANNT~<br /><br />Die überprüfte GEDCOM-Datei hat ANSI-Codierung. Es wird dringend empfohlen, die Codierung auf UTF-8 zu ändern.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~FALSCHES DATUMS-FORMAT ERKANNT~<br /><br /><b>DATUMS-FORMATIERUNG WIRD GEÄNDERT</b><br /><br />Das Standard-Datums-Format in PhpGedView ist, entsprechend des GEDCOM 5.5.1 Standard, TT&nbsp;MMM&nbsp;JJJJ (d.h. 01&nbsp;JAN&nbsp;2004)<br /><br />Wenn Sie nach der Überprüfung der GEDCOM-Datei eine Meldung erhalten, dass ein falsches Datums-Format erkannt wurde, wird das Programm diese Datumsangaben in diesen Standard konvertieren.<br /><br />Sie können aber wählen zwischen »<b>Tag</b> vor Monat« (TT&nbsp;MMM&nbsp;JJJJ) oder »<b>Monat</b> vor Tag« (MMM&nbsp;TT&nbsp;JJJJ).<br /><br />Empfohlen ist die erste Einstellung.";
$pgv_lang["change_indi2id_help"]		= "~PERSÖNLICHE ID ÄNDERN IN ...~<br /><br />Dieses Tool wurde erstellt für Benutzer, deren Genealogie Software bei jedem Export andere ID-Nummern für die Personen generiert. D.h. beim ersten Export ist die ID für eine Person I100 aber beim erneuten Export ist die ID der selben Person z.B. I234. Dieses Wechseln der IDs erschwert die Verwaltung in PhpGedView, denn die ID ist die Referenz auf die sich viele Personenangaben beziehen.<br /><br />Die meisten Genealogie-Programme nutzen aber zusätzlich einen RIN oder REFN Bezeichner, um jeder Person eine eindeutige Nummer zuzuordnen, die auch als Referenz verwendet werden kann. Dieses Tool ersetzt alle IDs in der GEDCOM-Datei mit dem Wert aus dem von Ihnen gewünschten Feld (RIN oder REFN).";
$pgv_lang["edit_privacy_help"]			= "Auf dieser Seite können Sie alle Datenschutzeinstellungen für die ausgewählte GEDCOM-Datei vornehmen.<br /><br />Unterhalb der Überschrift können Sie erkennen, ob Sie die richtige Datei bearbeiten.  Der Dateiname wird wie folgt dargestellt: (Pfad/NameIhrerGedcomDatei_priv.php)<br /><br />Wenn Sie weitergehende Einstellungen vornehmen möchten, können Sie auch Änderungen direkt in der Datenschutzdatei vornehmen. Dazu finden Sie weitere Informationen auf der PhpGedView Web Seite.";
$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) erkannt~<br /><br />Die GEDCOM-Datei, die Sie importieren möchten, hat ein besonderes 3-stelliges Zeichen am Anfang.  Durch dieses Zeichen erkennen manche Programme dass Dateien im UTF-8 Zeichensatz erstellt sind.<br /><br />Obwohl dieses Zeichen kein Fehler ist, funktioniert PhpGedView nur richtig wenn das Zeichen nicht vorhanden ist.  Sie sollten PhpGedView gestatten, das BOM-Zeichen zu entfernen.";
$pgv_lang["invalid_header_help"]		= "~UNGÜLTIGER GEDCOM HEADER~<br /><br />Eine GEDCOM-Datei muss in der ersten Zeile folgendermaßen beginnen: <b>0&nbsp;HEAD</b>. PhpGedView hat erkannt, dass Ihre GEDCOM-Datei in der ersten Zeile anders beginnt. Wenn Sie den Korrigieren-Button klicken, werden alle Zeile vor der ersten <b>0&nbsp;HEAD</b> Zeile entfernt.<br /><br />Dieser Fehler bedeutet meistens, dass das von Ihnen verwendete Programm die Datei nicht ordnungsgemäß erstellt hat oder dass es sich nicht um eine GEDCOM-Datei handelt. Sie sollten überprüfen, ob Sie die richtige Datei hochgeladen haben und ob sie mit der Zeile <b>0&nbsp;HEAD</b> beginnt und mit der Zeile <b>0&nbsp;TRLR</b> endet.";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSH DATEI ERKANNT~<br /><br />PhpGedView hat festgestellt, dass Ihre GEDCOM-Datei auf einem Macintosh-Computer erstellt wurde.<ul><li>Macintosh-Dateien beenden jede Zeile mit einem CR-Steuercode. CR ist Ctrl+M.</li><li>Unix-Dateien beenden jede Zeile mit einem LF-Steuercode. LF ist Ctrl+J.</li><li>Windows und DOS verwenden eine Zwei-Code-Sequenz, CR gefolgt von LF.</li></ul>Für PhpGedView müssen alle Dateien Unix- oder DOS-Zeilenenden verwenden. Wenn Sie »Bereinigen« klicken, werden Ihre Zeilenenden entsprechend korrigiert.";
$pgv_lang["cleanup_places_help"]		= "~ORTE KORRIGIEREN~<br /><br />PhpGedView hat erkannt, dass Ihre GEDCOM-Datei Ortsangaben zu GEDCOM-Daten macht, die keine Ortsangaben zulassen.<br /><br /Manche Genealogie-Programme, z.B. Family Tree Maker, erstellen solche GEDCOM-Dateien. PhpGedView funktioniert zwar mit solchen Dateien, aber es tauchen einige ungültige Orte in der Ortsliste auf.<br /><br />Beipiel: Ihre GEDCOM-Datei enthält folgende Zeilen<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Architekt</div><br />Nach den geltenden GEDCOM Regeln sollte dies eigentlich wie folgt notiert sein<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Architekt</div><br />Wenn Sie diese Option auf <b>#pgv_lang[yes]#</b> setzen, wird PhpGedView automatisch solche Fehler korrigieren.";
$pgv_lang["empty_lines_detected_help"]	= "~LEERE ZEILEN ERKANNT~<br /><br />PhpGedView hat erkannt, dass in Ihrer GEDCOM-Datei Leerzeilen enthalten sind. Diese Zeilen können zu Fehlern führen und werden vor dem Import aus der Datei entfernt.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~PhpGedView KONFIGURIEREN~<br /><br />Auf dieser Seite werden die Grundeinstellungen des Programmes vorgenommen, nachdem PhpGedView neu auf Ihrem Server installiert wurde und zum ersten Mal gestartet wird.<br /><br />#pgv_lang[review_readme]#<br /><br />Da diese <b>Grund</b>einstellungen sind, gelten sie für das gesamte Programm und für alle Datenbanken, die Sie darin benutzen.<br /><br />Jede genealogische Datenbank verfügt außerdem über zusätzliche Konfigurationsoptionen, die Sie festlegen, nachdem Sie <b>#pgv_lang[admin_gedcoms]#</b> auf dieser Seite geklickt haben.<br /><br />Sie können auch auf #pgv_lang[gedcom_adm_head]# Funktion von der Verwalters Seite, deren Link sich unter dem Symbol #pgv_lang[mgv]# oder in der Kopfzeile der meisten Seiten befindet zugreifen. Auf der Admin-Seite heißt das entsprechende Link <b>#pgv_lang[manage_gedcoms]#</b>.";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Hier können Sie zwei Datensätze der selben GEDCOM Datei zusammenfügen.<br /><br />Das kann nützlich sein, wenn Sie GEDCOM-Dateien zusammengefügt haben, und deshalb jetzt mehrere Datensätze für die selben Personen, Familien, Quellen, oder Archive haben.<br /><br />Das Verfahren besteht aus drei Schritten.<br /><ol><li>Sie geben zwei ID-Nummern des <u>gleichen</u> Typs ein.  Sie können nicht, zum Beispiel, Personen und Familien oder Familien und Quellen zusammenfügen.<br />Ins <b>#pgv_lang[merge_to]#</b> Feld geben Sie die gewünschte ID-Nummer des Ausgangs-Datensatzes.<br />Ins <b>#pgv_lang[merge_from]#</b> Feld geben Sie die ID-Nummer des Datensatzes dessen Informationen mit den Informationen des #pgv_lang[merge_to]# Datensatzes zusammengefügt werden sollen. Am Ende des Verfahrens wird dieser Datensatz gelöscht.</li><li>Für jedes Datum aus beiden Datensätzen wählen Sie durch ankreuzen ob es in den Ausgangs-Datensatz übernommen werden soll oder nicht.</li><li>Genau wie alle anderen Änderungen verifizieren Sie das Resultat.</li></ol>Jemand der genügend Rechte hat, Änderungen in die Datenbank zu übernehmen, muss noch Ihre zusammengefügte Datensätze kontrollieren, bevor sie endgültig in die Datenbank übernommen werden.";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~#pgv_lang[reports]#~<br /><br />Die Elemente im Menü »Berichte« generieren PDF-Dateien zum Drucken.<br /><br />Der erste Schritt besteht darin, einen Bericht zu wählen. Nachdem Sie einen Bericht gewählt haben, werden Sie aufgefordert, einige spezifische Informationen zu diesem Bericht anzugeben, z. B. welche Person oder Familie Sie beginnen sollen und ob Sie Fotos anzeigen möchten oder nicht. Wenn Sie bereit sind, den Bericht auszuführen, klicken Sie <b>#pgv_lang[download_report]#</b>, um den Bericht auf Ihren Computer herunterzuladen.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]		= "~Dateien im PDF-Format~<br /><br />PhpGedView erstellt Berichte als Dateien im Adobe&reg; PDF-Format, die Sie nach dem Erstellen auf Ihren lokalen Computer übertragen können.  Der GEDCOM 5.5.1 Standard, der anderswo in diesem Hilfe-System erwähnt ist, kann ebenfalls als PDF-Datei übertragen werden. PDF ist ein Akronym von <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (tragbares Dokument Format).";
$pgv_lang["help_ahnentafel.xml"]		= "~#pgv_lang[ahnentafel_report]#~<br /><br />Dies ist ein Bericht über die gewählte Person und seine Vorfahren, als Broschüre gedruckt.  Der Bericht beginnt mit der gewählten Startperson.  Seine Eltern, Großeltern, usw. folgen.<br /><br />Bitte beachten Sie dass der #pgv_lang[ahnentafel_report]# nur in der englischen Sprache erstellt werden kann.";
$pgv_lang["help_birthlist.xml"]			= "~#pgv_lang[birth_report]#~<br /><br />In diesem Bericht können Sie all Personen aufzählen, die an einem bestimmten Datum oder in einem bestimmten Ort geboren wurden.";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br /><br />Dieser Bericht zählt alle Verwandte der gewünschten Startperson auf.  Sie können bestimmen, welche Verwandte aufgezählt werden sollen.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;zeigt die Startperson, seine Eltern, und seine Geschwister.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;zeigt die Startperson, seine Ehepartner, und seine Kinder.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;zeigt die Startperson und alle seine Vorfahren (seine Eltern, seine Großeltern, seine Urgroßeltern, usw.) bis zum Anfang des Stammbaumes.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;zeigt nicht nur alle Personen der #pgv_lang[direct-ancestors]# Liste sondern auch Geschwister der Eltern (Tanten und Onkel), Großeltern (Großtanten, Großonkel), usw. Kinder dieser Geschwister (Cousinen) werden nicht aufgezählt.</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;zeigt alle Nachfahren der Startperson (Kinder, Enkel, Urenkel, usw.)</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Diese Option ist eine Mischung der #pgv_lang[descendants]# und #pgv_lang[ancestors]# Optionen in einem Bericht.</li></ul>";
$pgv_lang["help_xml_reports"]			= "~Bericht Erstellungsmaschine~<br /><br />Die Erstellungsmaschine für Berichte benutzt XML (E<b>x</b>tended <b>M</b>arkup <b>L</b>anguage) Vorlagen um bestimmte Berichte automatisch zu erstellen.  Die erstellten Berichte können als Dateien im PDF-Format für späteres Lesen oder Drucken heruntergeladen werden.<br /><br />Die <b>#pgv_lang[select_report]#</b> Liste, die alle erhältliche Berichte aufzählt, wird aus dem Inhalt des <i>reports</i> Verzeichnisses erstellt.  Sie können das Programm durch Ihre eigenen Berichte ergänzen, indem Sie eine der vorhandenen Vorlagen kopieren und dann nach Ihren Bedürfnissen ändern.  Um diesen neuen Bericht dem Programm bekannt zu geben, muss die XML-Vorlage richtig benannt werden (z.B. <i>MeinBericht.xml</i>) und im <i>reports</i> Verzeichnis zu finden sein.  Wenn Sie dann die Datei <i>reports.dat</i> aus dem <i>index</i> Verzeichnis löschen, erkennt PhpGedView dass eine neue Liste erstellt werden muss.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]	= "<b>HILFE INHALT</b>";
$pgv_lang["help_contents_gedcom_info"]	= "GEDCOM-Informationen";
$pgv_lang["help_contents_gedcom_places"]	= "Orte in der GEDCOM-Datei";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>HILFE INHALT<br /><br />HILFE FÜR VERWALTER</b> wurde der Liste vorangestellt.";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]					= "_PhpGedView konfigurieren";
$pgv_lang["ah3_help"]					= "_GEDCOM: Hinzufügen oder Upload";
$pgv_lang["ah4_help"]					= "_GEDCOM: Konfigurations-Datei";
$pgv_lang["ah5_help"]					= "_GEDCOM: Standard";
$pgv_lang["ah6_help"]					= "_GEDCOM: Löschen";
$pgv_lang["ah7_help"]					= "_GEDCOM: Hinzufügen";
$pgv_lang["ah8_help"]					= "_GEDCOM: neue GEDCOM-Datei erstellen";
$pgv_lang["ah9_help"]					= "_GEDCOM: Herunterladen";
$pgv_lang["ah10_help"]					= "_GEDCOM: Verwaltung";
$pgv_lang["ah11_help"]					= "_GEDCOM: Konfiguration bearbeiten";
$pgv_lang["ah12_help"]					= "_GEDCOM: Importieren";
$pgv_lang["ah13_help"]					= "_GEDCOM: Hochladen (Upload)";
$pgv_lang["ah14_help"]					= "_GEDCOM: Prüfen";
$pgv_lang["ah15_help"]					= "_GEDCOM: ANSI nach UTF-8 konvertieren";
$pgv_lang["ah16_help"]					= "_GEDCOM: Datenschutz-Datei konfigurieren";
$pgv_lang["ah17_help"]					= "_Benutzer-Verwaltung";
$pgv_lang["ah18_help"]					= "_Verwaltung";
$pgv_lang["ah19_help"]					= "_GEDCOM: Multimedia-Tool";
$pgv_lang["ah20_help"]					= "_GEDCOM: Persönliche ID ändern in ...";
$pgv_lang["ah21_help"]					= "_Sprach-Dateien";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]					= "_Unterstützte Sprachen konfigurieren";
$pgv_lang["ah24_help"]					= "_Benutzer-Informationen übertragen (Index --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]					= "_PhpGedView Sicherheits-Kopie";
$pgv_lang["ah26_help"]					= "_Häufig gestellte Fragen (FAQ) Liste: Bearbeiten";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"]	= "~Statistiken-Diagramm~<br /><br />Diese Seite zeigt Ihnen das Diagramm der Statistiken, die entsprechend den Eingaben der vorigen Seite aus der Datenbank aufgerufen wurden.";
$pgv_lang["help_statistics.php"]		= "~Statistiken-Diagramm~<br /><br />Auf dieser Seite bestimmen Sie die Statistiken die als Diagramm aus der Datenbank aufgerufen werden sollen.";
$pgv_lang["stat_help"]					= "~Optionen der Statistiken-Diagramme~<br /><br />Verschiedene Statistiken der Datenbank können durch Eingaben auf dieser Seite als Diagramm aufgerufen werden.<br /><br />Sie wählen das gewünschte Diagramm, und dann noch weitere Optionen.<br /><br />Die Zahlen, die in den Diagrammen gezeigt werden, hängen von den Eingabedaten ab.  Zum Beispiel, Personen von denen nur das Geburtsjahr (wie 1856) bekannt ist, können im Geburtsmonat-Diagramm nicht gezählt werden.";
$pgv_lang["stat_help_x"]				= "~Optionen der Statistiken-Diagramme~<br />~X Achse~<br /><br />Folgende Optionen sind für die X Achse (horizontal) gültig.  Das Diagramm wird dann durch weitere Optionen der Y und Z Achsen angefertigt.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;Anzahl der Geburten, pro Geburtsmonat.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;Anzahl der Tode, pro Sterbemonat.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;Anzahl der Ehen, pro Ehemonat.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;Anzahl der Erstgeborenen, pro Geburtsmonat.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;Anzahl der ersten Ehen, pro Ehemonat.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;Monate zwischen Eheschließung und Geburt des ersten Kindes dieses Paares.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;Todesalter, mit Geburtsjahr verglichen.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;Todesalter, mit Sterbejahr verglichen.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;Alter, mit Ehejahr verglichen.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;Alter, mit Jahr der ersten Ehe verglichen.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;Durchschnittliche Familiengröße.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;Anzahl der Personen, pro Land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;Geburtsland.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;Eheland.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;Sterbeland.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;Kreisdiagramm der Personen mit Quellen.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;Kreisdiagramm der Familien mit Quellen.</p>";
$pgv_lang["stat_help_y"]				= "~Optionen der Statistiken-Diagramme~<br />~Y Achse~<br /><br />Folgende Optionen sind für die Y Achse (vertikal) gültig.  Diese Optionen beeinflussen die Präsentation der für die X Achse gewählten Daten.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;zeigt die Anzahl der von der X Achse bestimmten Personen, Familien, usw.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;zeigt die Prozentzahl der von der X Achse bestimmten Personen, Familien, usw.</p>";
$pgv_lang["stat_help_z"]				= "~Optionen der Statistiken-Diagramme~<br />~Z Achse~<br /><br />Folgende Optionen sind für die Z Achse gültig.  Sie unterteilen die für die X Achse gewählten Kategorien.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;Keine Unterteilung.  Alle Daten der X Achse sind jeweils in einer Spalte dargestellt.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;Die Daten sind nach Geschlecht unterteilt und dann in zwei Spalten dargestellt.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;Die Daten sind in mehrere Bereiche unterteilt und dann in entsprechenden Spalten dargestellt.</p>";
$pgv_lang["stat_help_gwx"]				= "~Optionen der Statistiken-Diagramme~<br />~Bereichsgrenzen der X Achse~<br /><br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>#pgv_lang[aft_marr]#</b> bedeutet folgende Monatsbereiche:<div style=\"padding-left:30px;\">vor der Ehe<br />bis zu 8 Monate nach der Ehe<br />zwischen 8 und 12 Monate nach der Ehe<br />zwischen 12 und 15 Monate nach der Ehe<br />zwischen 15 und 18 Monate nach der Ehe<br />zwischen 18 und 24 Monate nach der Ehe<br />zwischen 24 und 48 Monate nach der Ehe<br />über 48 Monate nach der Ehe</div><br />Wenn Sie Quartale zeigen möchten, müssen Sie <b>#pgv_lang[quarters]#</b> wählen.";
$pgv_lang["stat_help_gax"]				= "~Optionen der Statistiken-Diagramme~<br />~Bereichsgrenzen der X Achse~<br /><br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>Spanne 10 Jahre</b> bedeutet folgende Altersbereiche:<div style=\"padding-left:30px;\">weniger als 1 Jahr alt<br />1 bis 5 Jahre<br />5 bis 10<br />10 bis 20<br />20 bis 30<br />30 bis 40<br />40 bis 50<br />50 bis 60<br />60 bis 70<br />70 bis 80<br />80 bis 90<br />90 bis 100<br />mehr als 100 Jahre alt</div>";
$pgv_lang["stat_help_gbx"]				= "~Optionen der Statistiken-Diagramme~<br />~Bereichsgrenzen der X Achse~<br /><br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>Spanne 2 Jahre</b> bedeutet folgende Altersbereiche:<div style=\"padding-left:30px;\">weniger als 16 Jahre alt<br />16 bis 18<br />20 bis 22<br />22 bis 24<br />24 bis 28<br />28 bis 30<br />30 bis 32<br />32 bis 35<br />35 bis 40<br />40 bis 50<br />mehr als 50 Jahre alt</div>";
$pgv_lang["stat_help_gcx"]				= "~Optionen der Statistiken-Diagramme~<br />~Bereichsgrenzen der X Achse~<br /><br />Bitte wählen Sie einen Anzahlabstand.<br /><br />Zum Beispiel, die Wahl <b>Spanne: 1 Kind</b> bedeutet folgende Anzahlbereiche:<div style=\"padding-left:30px;\">kinderlos<br />ein Kind<br />zwei Kinder<br />3, 4, 5, 6, 7, 8, 9, 10 Kinder<br />mehr als 10 Kinder</div>";
$pgv_lang["stat_help_gwz"]				= "~Optionen der Statistiken-Diagramme~<br />~Bereichsgrenzen der Z Achse~<br /><br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>von 1700 Spanne 50 Jahre</b> bedeutet folgende Jahresbereiche:<div style=\"padding-left:30px;\">vor 1700<br />zwischen 1700 und 1749<br />zwischen 1750 und 1799<br />zwischen 1800 und 1849<br />zwischen 1850 und 1899<br />zwischen 1900 und 1949<br />zwischen 1950 und 1999<br />2000 oder später</div>";
$pgv_lang["chart_type_help"]			= "~Optionen der Statistiken-Diagramme~<br /><br />Ihre Wahl wird auf einer Landkarte gezeigt.  Sie haben folgende Optionen zur Wahl:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;Zeigt, in welchen Ländern Personen dieser Datenbank vorkommen.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;Zeigt, in welchen Ländern Personen mit dem gewählten Nachnamen vorkommen.</div>";
$pgv_lang["google_chart_surname_help"]	= "~Optionen der Statistiken-Diagramme~<br /><br />Die Anzahl des gewählten Nachnamens wird auf einer Landkarte gezeigt.  Das leere Feld bedeutet, dass der häufigst vorkommende Nachname benutzt werden soll.";
$pgv_lang["chart_area_help"]			= "~Optionen der Statistiken-Diagramme~<br /><br />Sie können folgende Landkarten wählen:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;Alle Kontinente.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;Süd Amerika.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;Asien.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;Naher Osten.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;Afrika.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br /><br />Auf dieser Seite können Sie Ihre Medien-Dateien und Medien-Verzeichnisse leicht verwalten.<br /><br />Wenn Sie neue Medien-Unterverzeichnisse erstellen, sorgt das Programm dafür, dass die gleiche Struktur auch im <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b> Verzeichnis erstellt wird.  Wenn Sie neue Bilder auf den Server übertragen, kann PhpGedView die Miniaturbilder automatisch erstellen.<br /><br />Neben jedem Bild in der Medien-Liste finden Sie folgende Optionen.  Welche Optionen vorhanden sind hängt vom aktuellen Status der jeweiligen Medien-Datei ab.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Wenn Sie diese Option klicken, erhalten Sie ein Formular worin Sie den Titel der Datei ändern können.  Falls die Datei noch nicht mit einer Person, Familie, oder Quelle der aktuellen Datenbank verbunden ist, können Sie das hier tun.  Sie können auch den Dateinamen ändern oder sogar die Datei in ein anderes Verzeichnis verlegen.  Wenn notwendig, erstellt PhpGedView fehlende Verzeichnisse oder Miniaturbilder.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Diese Option ist nur sichtbar wenn sie vom Verwalter erlaubt ist.  Sie können die GEDCOM Rohdaten, die dieses Medien-Objekt betreffen, sehen und bearbeiten.  Sie sollten sehr vorsichtig sein wenn Sie diese Option benutzen.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Mit dieser Option können Sie alle Kenntnisse über diese Medien-Datei aus der aktuellen Datenbank entfernen.  Andere vorhandene Datenbanken werden nicht geändert.  Wenn diese Datei in keiner anderen Datenbank erwähnt ist, wird sie, sowie dessen Miniaturbild, entfernt.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Diese Option entfernt alle Kenntnisse über diese Medien-Datei aus der aktuellen Datenbank.  Die Medien-Datei wird nicht gelöscht.  Andere vorhandene Datenbanken werden nicht geändert.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Mit dieser Option können Sie alle Verbindungen zu diesem Medien-Objekt in der aktuellen Datenbank löschen.  Die Datei wird nicht entfernt, und das Medien-Objekt, mit dem diese Datei in der aktuellen Datenbank bekannt ist, wird auch nicht entfernt.  Andere vorhandene Datenbanken werden nicht geändert.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Diese Option lässt Sie Verbindungen zwischen dieser Medien-Datei und Personen, Familien, oder Quellen der aktuellen Datenbank erstellen.  Wenn notwending, erstellt das Programm auch das Medien-Objekt, mit dem die Datei in der Datenbank bekannt ist.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Wenn Sie diese Option wählen, erstellt PhpGedView das fehlende Miniaturbild.</li></ul>";
$pgv_lang["simple_filter_help"]			= "~#pgv_lang[filter]#~<br /><br />Ein einfacher Filter.  Die Medien-Liste wird nach Ihrer genauen Eingabe durchsucht.  Die <b>#pgv_lang[qm]#</b> und <b>*</b> Zeichen haben keine besondere Bedeutung.";
$pgv_lang["show_thumb_help"]			= "~#pgv_lang[show_thumbnail]#~<br /><br />Falls angekreuzt, werden vorhandene Miniaturbilder in der Liste gezeigt.";
$pgv_lang["find_media_help"]			= "~#pgv_lang[find_media]#~<br /><br />Mit dieser Option können Sie alle Medien-Verzeichnisse nach der gewünschten Datei, mit der Sie eine Verbindung erstellen möchten, durchsuchen.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]			= "~Link ID~<br /><br />Jedes Medien-Objekt soll mit mindestens einer Person, Familie, oder Quelle Ihrer Datenbank verbunden sein.<br /><br />Um solche Verbindung herzustellen, können Sie die Datenbank nach der ID-Nummer der gewünschten Person, Familie, oder Quelle zur gleichen Zeit durchsuchen, als Sie das Medien-Objekt erstellen. Es ist aber nicht nötig die Verbindungen sofort herzustellen.  Sie können das jederzeit durch das Betätigen des <b>#pgv_lang[edit]#</b> oder <b>#pgv_lang[set_link]#</b> Links der <b>#pgv_lang[manage_media]#</b> Seite oder des <b>#pgv_lang[add_media_lbl]#</b> Links der Personen-, Familien-, oder Quellen-Informationsseiten tun.";
$pgv_lang["upload_server_file_help"]	= "~#pgv_lang[server_file]#~<br /><br />Die Medien-Datei, die Sie auf den Server übertragen möchten, sollte dort anders benannt sein als auf Ihrem lokalen Computer.  Bedenken Sie, dass Dateinamen, die für Sie sinnvoll sind, anderen weniger Sinn haben können.  Es ist auch durchaus möglich, dass Sie und andere zur gleichen Zeit verschiedene Bilder mit dem gleichen Namen (z.B., »oma.jpg«) hochladen möchten.<br /><br />In diesem Feld geben Sie den Namen, mit dem die übertragene Datei, und auch dessen automatisch erstelltes Miniaturbild, auf dem Server benannt werden soll.  Ihre Eingabe des Namenszusatzes (jpg, gif, pdf, doc, usw.) wird nicht beachtet.  Das Programm benutzt immer den ursprünglichen Namenszusatz der hochgeladenen Datei.<br /><br />Wenn Sie dieses Feld leer lassen, erhält die hochgeladene Datei ihren ursprünglichen Namen.";
$pgv_lang["upload_server_folder_help"]	= "~#pgv_lang[server_folder]#~<br /><br />Der Verwalter hat bis zu #GLOBALS[MEDIA_DIRECTORY_LEVELS]# Verzeichnisebenen unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> erlaubt.  Das erleichtert das Verwalten der Medien-Dateien, und mindert die Möglichkeit von Namenskonflikten.<br /><br />In diesem Feld wählen Sie das Zielverzeichnis der zu übertragenden Datei.  Das dazugehörende Miniaturbild, entweder automatisch erstellt oder separat hochgeladen, wird in der gleichen Struktur, angefangen im <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> anstatt dem <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Verzeichnis, gespeichert. Es ist nicht notwendig, den <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Teil des Zielverzeichnisses einzugeben.<br /><br />Falls Sie sich nicht über diese Eingabe sicher sind, sollten Sie sich an den Verwalter wenden.";
$pgv_lang["view_server_folder_help"]	= "~#pgv_lang[server_folder]#~<br /><br />Der Verwalter hat bis zu #GLOBALS[MEDIA_DIRECTORY_LEVELS]# Verzeichnisebenen unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> erlaubt.  Das erleichtert das Verwalten der Medien-Dateien, und mindert die Möglichkeit von Namenskonflikten.<br /><br />Hier wählen Sie das Medien-Verzeichnis dessen Inhalt Sie sehen möchten.  Wenn Sie <b>#pgv_lang[all]#</b> wählen, wird der Inhalt aller Medien-Verzeichnisse gezeigt.  So erhalten Sie unter Umständen eine sehr lange Liste.";

//--Repository Help
$pgv_lang["help_repolist.php"]			= "~#pgv_lang[repo_list]#~<br /><br />Diese Seite zeigt Ihnen die Achivenliste. Die Namen der Archive sind in alphabetischer Reihenfolge sortiert.<br /><br /><b>ARCHIVE</b><br />Ohne Archive ist es unmöglich, die Datenbank zu erstellen.  Quellen existieren für alle Daten, und Quellen sind immer in Archiven aufbewahrt.  Solche Quellen-Lagerorte könnten persönliche Archive, öffentliche Datenbanken, kirchliche oder behördliche Archive, Internet-zugängliche Datenbanken, usw. sein.  Um Quellen später wieder zu finden, müssen genaue Kenntnisse über deren Lagerorte vorhanden sein.  Diese Informationen sind immer in Archiv-Datensätzen eingetragen.<br /><br />Jeder Archiv-Datensatz kann mit mehreren Quellen verbunden sein.";
$pgv_lang["help_repo.php"]				= "~#pgv_lang[repo_info]#~<br /><br />Einzelheiten über das Archiv sind hier aufgezeichnet.  Quellen und deren Lagerorte (Archive) sind für Ahnenforscher sehr wichtig.  Wenn Sie genaue Kenntnisse über eine Quelle und dessen Lagerort haben, können Sie jederzeit dem Pfad anderer Ahnenforscher zu den Informationen folgen.  So können Sie, oder andere, immer die Informationen bestätigen.<br /><br />Diese Seite zeichnet Informationen wie Titel, Post-, Mail-, und Internet-Adressen auf.<br /><br />Unter diesen Informationen sehen Sie noch eine Liste aller Quellen die mit diesem Archiv verbunden sind.  So können Sie leicht feststellen, welche Informationen der Datenbank in diesem Lagerort zu finden sind.<br /><br />Falls vom Verwalter erlaubt, sehen Sie noch folgende Links:<ul><li><b>#pgv_lang[view_gedcom]#</b> wodurch Sie die Einzelheiten dieses Archivs im GEDCOM Rohformat sehen können.  Diese Option ist für die meisten Fälle nicht sehr nützlich.</li><li><b>#pgv_lang[add_to_cart]#</b> wodurch Sie diesen Archiv-Datensatz dem #pgv_lang[clip_cart]# hinzufügen können. Der #pgv_lang[clip_cart]#-Inhalt kann auf Ihren lokalen Computer im GEDCOM-Format übertragen werden, für späteres Bearbeiten von anderen Programmen.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Wenn Sie dieses Link klicken, wird das Archiv zum Löschen markiert.<br /><br />Was bedeutet das? Angenommen Sie möchten aus irgendeinem Grund ein Archiv löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen. Bei näherem Betrachten werden Sie aber feststellen, dass das Archiv weiterhin sichtbar ist und wie zuvor ausgewählt werden kann.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Diese Option zeigt Ihnen, im GEDCOM Rohformat, alle Informationen über dieses Archiv.  Für die meisten Fälle ist diese Option wahrscheinlich nicht sehr nützlich.";
$pgv_lang["add_repository_clip_help"]	= "~#pgv_lang[add_to_cart]#~<br /><br />Mit dieser Option können Sie alle Einzelheiten dieses Archivs dem #pgv_lang[clip_cart]# hinzufügen.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />Diese Liste zeigt Ihnen alle in der Datenbank eingetragene Archive. Die Namen sind in alphabetischer Reihenfolge sortiert.<br /><br />Wenn Sie auf einen der Archivnamen klicken, erhalten Sie die #pgv_lang[repo_info]# Seite, wo alle mit diesem Archiv verbundene Quellen gezeigt werden.";
$pgv_lang["repos_listbox_help"]			= "~#pgv_lang[other_repo_records]#~<br /><br />Hier werden alle mit diesem Archiv verbundene Quellen gezeigt. Die Namen sind in alphabetischer Reihenfolge sortiert.<br /><br />Wenn Sie auf einen der Quellennamen klicken, gelangen Sie auf eine Seite, wo Ihnen Einzelheiten über diese Quelle gezeigt werden.";

// Index-Edit
$pgv_lang["block_move_up_help"]			= "~Reihenfolge ändern~<br /><br />Mit diesen Buttons können Sie die Reihenfolge der Blöcke ändern.  Die Blöcke werden auf der Startseite in der selben Reihenfolge dargestellt, wie sie in dieser Liste vorkommen.<br /><br />Um die Reihenfolge zu ändern, wählen Sie zuerst mit <u>einem</u> Klick der <u>linken</u> Maustaste den Block den Sie verschieben möchten.  Danach klicken Sie Buttons so oft wie notwendig um den gewählten Block in der Reihenfolge zu verschieben.";
$pgv_lang["block_move_right_help"]		= "~Listen ändern~<br /><br />Mit diesen Buttons können Sie Einträge aus einer Liste kopieren oder entfernen und in einer anderen Liste eintragen.<br /><br />Wie gewohnt, wählen Sie zuerst mit <u>einem</u> Klick der <u>linken</u> Maustaste den Block mit dem Sie eben arbeiten möchten.  Danach klicken Sie einen der Pfeile um den gewählten Block in der Pfeilrichtung zu verschieben.  Die <b>»</b> und <b>«</b> Pfeile verschieben den gewählten Block von der ganz linken zur ganz rechten Liste oder umgekehrt. Die  <b>&gt;</b> und <b>&lt;</b> Pfeile verschieben den gewählten Block zwischen der #pgv_lang[available_blocks]# Liste und der Liste rechts oder links daneben.<br /><br />Die Einträge in der #pgv_lang[available_blocks]# Liste werden niemals entfernt, weil der selbe Block, z.B. der HTML Block, mehrmals auf der Seite dargestellt werden kann.";
$pgv_lang["block_default_index"]		= "~Standard-Blöcke der #pgv_lang[welcome]# Seite~<br /><br />Wenn Sie alle Einträge der #pgv_lang[main_section]# und #pgv_lang[right_section]# Listen entfernen, oder wenn Sie den <b>#pgv_lang[reset_default_blocks]#</b> Button klicken, erhalten Sie folgende Standard-Einstellungen:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]		= "~Standard-Blöcke der #pgv_lang[mygedview]# Seite~<br /><br />Wenn Sie alle Einträge der #pgv_lang[main_section]# und #pgv_lang[right_section]# Listen entfernen, oder wenn Sie den <b>#pgv_lang[reset_default_blocks]#</b> Button klicken, erhalten Sie folgende Standard-Einstellungen:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"]				= "~FAQ - Frequently Asked Questions~<br />~Häufig gestellte Fragen~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"]				= "Die FAQ Seite kann eine Übersicht oder eine Liste der häufig gestellten Fragen (und natürlich deren Antworten) über diese Ahnenforschungs-Seiten enthalten. FAQ ist ein Akronym von <b>F</b>requently <b>A</b>sked <b>Q</b>uestions (häufig gestellte Fragen).<br /><br />Der Verwalter bestimmt, wie diese Seite benutzt wird, und er bestimmt auch dessen Inhalt und die Reihenfolge der Fragen.";

// Help search
$pgv_lang["hs_title_help"] 				= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]					= "Sie können das Hilfe-System in PhpGedView durchsuchen. Mit dem  #pgv_lang[hs_title]# Element haben Sie viel Einfluss über das Durchsuchen;  die gewünschten Auskünfte sollten leicht zu finden sein.";
$pgv_lang["hs_keyword_advice"] 			= "~#pgv_lang[hs_keyword]#~<br /><br />Sie geben das gewünschte Wort oder den Satzteil ein.<br /><br />Das Groß- oder Kleinschreiben spielt bei der Suche keine Rolle.  Wenn Sie, zum Beispiel, nach dem Wort <b>Suche</b> suchen, findet das Programm <b>Suche</b>, <b>suche</b>, oder <b>SUCHE</b>. Text, in dem das gewünschte Wort als Wortteil enthalten ist, wird auch gefunden.  Zum Beispiel: <b>suchen</b>, <b>durchsuchen</b>, usw.<br /><br />Sie können mehrere Wörter, mit Leerzeichen dazwischen, eingeben.  Zum Beispiel: <b>Person&nbsp;Familie&nbsp;Kind</b> Die Bedeutung solcher Eingaben wird dem Programm im #pgv_lang[hs_searchhow]# Feld angedeutet.";
$pgv_lang["hs_searchin_advice"]			= "~#pgv_lang[hs_searchin]#~<br /><br />Hier bestimmen Sie den Umfang der Suche.<br /><br />Verwalter können Benutzer oder Konfigurations-Hilfetexte durchsuchen.  Gewöhnlichen Benutzern ist diese Wahl nicht gestattet;  da diese keinen Zugang zu den Konfigurations-Seiten haben, ist es für sie nutzlos, die Konfigurations-Hilfetexte zu durchsuchen.<br /><br />Die Text-Dateien enthalten nicht nur Hilfetexte, sonder auch Texte die beim Erstellen der verschiedenen Formulare benutzt werden.  Mit dieser Option können Sie bestimmen, ob alle Texte durchsucht werden sollen, oder nur die Hilfetexte.";
$pgv_lang["hs_searchhow_advice"]		= "~#pgv_lang[hs_searchhow]#~<br /><br />Hier können Sie die Bedeutung Ihrer Eingaben im #pgv_lang[hs_keyword]# Feld erläutern.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Wenn Sie <b>Person&nbsp;Familie&nbsp;Kind</b> eingegeben haben, findet das Programm alle Texte in denen eines dieser Wörter vorkommt.  Die Reihenfolge der eingegebenen Wörter spielt keine Rolle.  Die aktuelle Bedeutung Ihrer Eingaben ist also:  »Finde alle Texte in denen <b>Person</b> <u>oder</u> <b>Familie</b> <u>oder</u> <b>Kind</b> vorkommt.«</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Wenn Sie <b>Person&nbsp;Familie&nbsp;Kind</b> eingegeben haben, findet das Programm alle Texte in denen alle eingegebenen Wörter vorkommen.  Die Reihenfolge der eingegebenen Wörter spielt keine Rolle.  Die aktuelle Bedeutung Ihrer Eingaben ist also:  »Finde alle Texte in denen <b>Person</b> <u>und</u> <b>Familie</b> <u>und</u> <b>Kind</b> vorkommen.«</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Wenn Sie <b>Person&nbsp;Familie&nbsp;Kind</b> eingegeben haben, findet das Programm alle Texte in denen die eingegebenen Wörter in der selben Reihenfolge vorkommen, ohne andere Texte dazwischen. Die aktuelle Bedeutung Ihrer Eingaben ist also:  »Finde alle Texte in denen <b>Person</b> <u>und</u> <b>Familie</b> <u>und</u> <b>Kind</b> in dieser Reihenfolge, ohne andere Texte dazwischen, vorkommen.«  Die Wörter die Sie eingeben sind also ein Satzteil. Das Beispiel kommt bestimmt nicht in den Hilfetexten vor.</dd></dl><br />Diese Suche hat einige Beschränkungen.  Bestimmte Sonderzeichen, wie <b>&quot; &lt; &gt;</b> usw. sind in den Texten oft symbolisch dargestellt und werden deshalb nicht gefunden, wenn Ihre Eingabe solche Zeichen enthält. Einige Texte enthalten besondere Leerzeichen, die symbolisch als <b>&amp;nbsp;</b> dargestellt sind.  Texte mit solchen besonderen Leerzeichen werden auch nicht gefunden.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]		= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Dieses Programm kann dem Verwalter das Reinigen der Dateien im Index-Verzeichnis ermöglichen.<br /><br />Unbrauchbare Dateien, wie zum Beispiel alte Log-Dateien, alte GEDCOM-Dateien, alte Sicherheits-Kopien, usw. sammeln sich oft im Index-Verzeichnis.  Da diese Dateien meistens von PhpGedView erstellt wurden, ist das Server-Nutzerid deren Besitzer.  Es kann dann vorkommen, dass Sie diese veralteten Dateien nicht direkt löschen können.  Dieses Programm ermöglicht Ihnen, solche Dateien zu löschen.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
