<?php
/**
 * Italian Language file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2016 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Pasquale Ceres
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.it.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />Il testo inserito qui verrà visualizzato quando il puntatore del mouse passa sull'icona Testo nell'elenco utenti. Dovresti cercare di mantenere questo testo il più breve possibile.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Immettere la data dopo la quale il record di questo utente deve essere considerato come soggetto a ispezione da parte dell'amministratore. Questi record sono evidenziati nell'elenco utenti visualizzando il nome utente in <span class='warning'>rosso</span>.<br /><br />La data deve essere inserita in inglese. Esempi: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> ecc.<br /><br />Quando il numero del mese e il numero del giorno sono entrambi nell'intervallo da 1 a 12, la punteggiatura (trattino o barra) determina il significato, con un trattino <b>-</b> a significare che il primo numero è il giorno del mese, mentre una barra <b>/</b> significa che il primo numero è il mese.<br /><br />Se le informazioni inserite qui non hanno alcun significato per il programma, verrà utilizzato «yesterday» e questo record utente sarà sempre selezionato per l'evidenziazione. «tomorrow» e testi simili non hanno significato in questo contesto e faranno sì che questo record utente non venga mai selezionato per l'evidenziazione.";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Scegli il formato in cui creare l'esportazione del database. La scelta dipende dai requisiti e dalle capacità del programma in cui si intende importare il file appena scaricato. Puoi scegliere:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Quando questa opzione è selezionata, il file di output passerà attraverso i controlli di privacy in base all'opzione selezionata. Ciò può comportare la rimozione di determinate informazioni. Il file di output conterrà solo le informazioni normalmente visibili a un utente con il livello di privilegio indicato.<br /><br />Se si dispone solo di diritti #pgv_lang[gedadmin]#, non è possibile specificare che il file di output debba essere privatizzato in base al privilegio livello #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Questa opzione definisce un percorso costante da aggiungere come prefisso a tutti i percorsi multimediali nel file di output.<br /><br />Ad esempio, se la directory multimediale è stata configurata come \"/media\" e se il file multimediale viene esportato ha un percorso \"/media/immagini/xyz.jpg\" e hai inserito \"c:\\mie foto\\mia famiglia\" in questo campo, il percorso multimediale risultante sarà \"c:\\mie foto\\mia famiglia/immagini/xyz.jpg\".<br /><br />Noterai in questo esempio:<ul><li>il nome della directory multimediale corrente viene rimosso dal percorso</li><li>e il percorso risultante non avrà separatori di nomi di cartella corretti.</li></ul><br />Se si desidera mantenere la directory multimediale nei percorsi dei file multimediali del file di output, sarà necessario includere quel nome nel campo b>#pgv_lang[convertPath]#</b>.<br /><br />Dovresti anche utilizzare l'opzione <b>#pgv_lang[convertSlashes]#</b> per assicurarti che i separatori dei nomi delle cartelle siano coerenti e concordino con i requisiti del sistema operativo ricevente.<br /><br />I percorsi multimediali che sono effettivamente URL non verranno modificati.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Questa opzione determina se i nomi delle cartelle nella specifica FILE degli oggetti multimediali devono essere separati da barre in avanti o da barre rovesciate. La tua scelta dipende dai requisiti del sistema operativo ricevente.<br /><br />La scelta <b>#pgv_lang[forwardSlashes]#</b> è appropriata per la maggior parte dei sistemi operativi diversi da Microsoft Windows. La scelta <b>#pgv_lang[backSlashes]#</b> dovrebbe essere utilizzata quando il programma di destinazione è in esecuzione su un sistema Microsoft Windows.<br /><br />I percorsi multimediali che sono effettivamente URL non verranno modificati.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />Quando questa opzione è selezionata, #pgv_lang[multi_title]# cercherà non solo la directory selezionata dall'elenco #pgv_lang[filter]# ma anche tutte le sue sottodirectory. Quando questa opzione non è selezionata, viene cercata solo la directory selezionata.<br /><br />I titoli di tutti gli oggetti multimediali trovati vengono quindi esaminati per determinare se contengono il testo inserito nel #pgv_lang[filter]#. Il risultato di queste due azioni determina gli oggetti multimediali da elencare.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Verranno mostrati solo i media che non sono collegati a nessun record GEDCOM.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Seleziona la sottodirectory multimediale che desideri visualizzare.";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br /><br />Seleziona la sequenza in cui desideri visualizzare l'elenco.";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br /><br />Usa #pgv_lang[interactive_tree]# per visualizzare l'intero albero genealogico di una persona in entrambe le direzioni. Questa vista è simile alla vista Clessidra in quanto mostra sia gli antenati che i discendenti di una data persona radice. Questo grafico offre una visualizzazione più compatta mostrando caselle per coppie o famiglie anziché solo per persone.<br /><ul><li><b>Scorrimento</b><br />Ogni volta che il cursore del mouse si trasforma in un'icona Sposta, è possibile fare clic e trascinare l'albero per visualizzare altre parti dell'albero. Mentre trascini l'albero, le generazioni future si espandono automaticamente fino a quando non ci saranno più generazioni da visualizzare in quella direzione.<br /></li><li><b>Ingrandisci</b><br />È possibile utilizzare le icone a sinistra dell'albero per ingrandire e ridurre. Lo zoom indietro ti permetterà di vedere più albero sullo schermo alla volta. Quando si rimpicciolisce il testo può diventare difficile da leggere; quando il mouse passa sopra un riquadro otterrai una visualizzazione ingrandita di ciò che è contenuto.<br /></li><li><b>Espandere i dettagli</b><br />Facendo clic su una casella qualsiasi la espanderà e verrà visualizzata una vista più dettagliata. In modalità espansa, facendo clic sul nome di una persona si aprirà la sua pagina #pgv_lang[indi_info]#. Facendo clic su <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> verrà ridisegnato l'albero con quella persona come nuova radice. Facendo clic su <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> verrai reindirizzato alla pagina dei dettagli di quella famiglia.<br /></li><li><b>Toggle coniugi</b><br />L'icona <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> direttamente sotto i pulsanti Zoom attiverà o disattiverà la visualizzazione di tutti i coniugi sul lato discendenza. Quando il display è impostato per mostrare i coniugi, tutti i coniugi di una persona appariranno nella casella con loro. Verranno mostrati anche tutti i figli della persona. Quando l'opzione per mostrare i coniugi è disattivata, verranno visualizzati solo l'ultimo coniuge della persona e i figli con quel coniuge.<br /></li><li><b>Grande albero</b><br />#pgv_lang[interactive_tree]# è disponibile da molte pagine diverse, inclusa la scheda Albero nella pagina #pgv_lang[indi_info]# e il blocco Grafici nella pagina di benvenuto. Quando visualizzi l'albero da una di queste altre pagine, avrai anche un'icona Albero sotto le icone Zoom. Se fai clic su <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> verrai indirizzato alla pagina #pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br /><br />Quando il firewall multimediale è abilitato, i file multimediali possono essere memorizzati in una directory del server che non è accessibile da Internet.<br /><br />Questi pulsanti consentono di spostare facilmente un'intera struttura di directory multimediale tra non indirizzabile al web) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> e le normali directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br /><br />Imposta in modo ricorsivo le autorizzazioni per le directory <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> protette (non indirizzabili al Web) e <b>#GLOBALS[MEDIA_DIRECTORY]#</b> normali su scrivibili in tutto il mondo o di sola lettura.";
$pgv_lang["update_CHAN_text"] 		= "Gli amministratori a volte devono ripulire e correggere i dati inviati dagli utenti. Ad esempio, potrebbero dover correggere la posizione PLAC per includere il Paese. Quando gli amministratori apportano tali correzioni, le informazioni sulla modifica originale vengono normalmente sostituite. Questo potrebbe non essere desiderabile.<br /><br />Quando questa opzione viene scelta durante la sessione di modifica o correzione dell'amministratore, PhpGedView manterrà le informazioni di modifica originali invece di sostituirle con quelle della sessione corrente.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Questa opzione controlla lo stato iniziale della casella «#pgv_lang[no_update_CHAN]#» che viene mostrata in ogni pagina in cui gli amministratori possono apportare modifiche o correzioni al database genealogico.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Ogni fonte registra eventi specifici, generalmente per un determinato intervallo di date e per un luogo giurisdizionale. Ad esempio, un censimento registra gli eventi del censimento e i registri della chiesa registrano gli eventi di nascita, matrimonio e morte.<br /><br /> Seleziona gli eventi registrati da questa fonte dall'elenco di eventi fornito. La data deve essere specificata in un formato di intervallo come <i>FROM 1900 TO 1910</i>. La giurisdizione del luogo è il nome della giurisdizione più bassa che comprende tutti i luoghi di livello inferiore nominati in questa fonte.Ad esempio, \"Oneida, Idaho, USA\" sarebbe utilizzato come luogo di giurisdizione di origine per eventi che si verificano nelle varie città all'interno della contea di Oneida. \"Idaho, USA\" sarebbe il luogo di giurisdizione della fonte se gli eventi registrati non avessero avuto luogo solo nella contea di Oneida ma anche in altre contee dell'Idaho.";
$pgv_lang["cache_life_help"]			= "~#pgv_lang[cache_life]#~<br /><br />Per migliorare le prestazioni, questo blocco Pagina di Benvenuto PhpGedView viene salvato in un file di cache.  Si può configurare la frequenza con cui il file di cache di questo blocco viene rigenerato.<br /><ul><li><b>-1</b> indica che il file di cache non viene mai rigenerato automaticamente.  Per averne una copia fresca, si devono cancellare tutti i file di cache.  Ciò si può fare dalla pagina Pagina di Benenuto Personalizzata.</li><li><b>0</b> (Zero) indica che questo blocco non viene mai messo in cache, ed ogni volta che il blocco viene mostrato sulla Pagina di Benvenuto PhpGedView, se ne vede una copia fresca.  Questa configurazione viene usata automaticamente per blocchi che cambiano frequentemente, come ad esempio i blocchi #pgv_lang[logged_in_users_block]# e #pgv_lang[random_media_block]#.</li><li><b>1</b> (Uno) indica che una copia fresca del file di cache di questo blocco viene generata quotidianamente, <b>2</b> indica che una copia fresca viene generata ogni 2 giorni, <b>7</b> indica che una copia fresca viene generata settimanalmente, ecc.</li></ul>";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />Per migliorare le prestazioni, molti dei blocchi nella pagina di benvenuto di PhpGedView vengono salvati come file di cache nella directory /index. I file della cache per la maggior parte dei blocchi vengono aggiornati una volta al giorno, ma a volte potrebbe essere necessario aggiornarli manualmente.<br /><br />Questo pulsante consente di aggiornare i file della cache quando necessario.";
$pgv_lang["import_options_help"] 	= "Puoi scegliere opzioni aggiuntive da utilizzare durante l'importazione di GEDCOM.";
$pgv_lang["verify_gedcom_help"]	= "~#pgv_lang[verify_gedcom]#~<br /><br />Qui puoi scegliere di continuare con il caricamento e l'importazione di questo file GEDCOM o di interrompere il caricamento e l'importazione.";
$pgv_lang["add_gedcom_instructions"]= "Inserisci un nome file per questo nuovo GEDCOM. Il nuovo file GEDCOM verrà creato nella directory #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />La presentazione dovrebbe avviarsi automaticamente quando la pagina viene caricata.<br /><br />La presentazione cambia i contenuti del blocco senza precaricare le informazioni dal server e senza ricaricare l'intera pagina.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />È possibile utilizzare questa impostazione per mostrare o nascondere i controlli della presentazione del blocco multimediale casuale.<br /><br />Questi controlli consentono all'utente di passare a un altro oggetto casuale o di riprodurre contenuti multimediali selezionati casualmente come una presentazione. La presentazione cambia il contenuto del blocco senza precaricare le informazioni dal server e senza ricaricare l'intera pagina.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Usa questo collegamento per aggiungere una nuova fonte al tuo database senza collegare la fonte a una citazione della fonte in un altro record. La nuova fonte apparirà nell'elenco delle fonti, ma non apparirà su nessun grafico o altrove nel programma finché non sarà collegata a una citazione della fonte.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Usa questo collegamento per aggiungere una nuova nota condivisa al tuo database senza collegare la nota a nessun record. La nuova nota apparirà nell'elenco delle note condivise, ma non apparirà su nessun grafico o altrove il programma fino a quando non è collegato a una persona, famiglia o evento.";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />In questo campo inserisci il numero di identificazione della persona a cui ti stai collegando (es. I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Usa questa sezione per selezionare l'identificatore di database alternativo che contiene la persona a cui ti stai collegando.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />In questa sezione si specificano i parametri necessari per connettersi al sito remoto che ospita i dati a cui ci si collega. Hai la possibilità di scegliere da un elenco di siti noti che hai utilizzato in precedenza o di inserire #pgv_lang[label_site_url2]# e #pgv_lang[label_gedcom_id]# per uno nuovo.<br /><br />Nel campo <b>#pgv_lang[label_site_url2]#</b>, inserisci l'URL per accedere al file di descrizione dei servizi web (WDSL) che dice a PhpGedView come accedere ai dati sul sito remoto. Per un sito Web PhpGedView remoto, l'URL del file WSDL sarà simile a questo: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />Il campo <b>#pgv_lang[label_gedcom_id]#</b> viene utilizzato per immettere un identificatore di database opzionale per i siti remoti che ne richiedono uno. Per i siti PhpGedView, questo è il nome del file GEDCOM.<br /><br />I campi <b>#pgv_lang[label_username_id]#</b> e <b>#pgv_lang[label_password_id]#</b> sono necessari se il database lo richiede.";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Questa opzione ti consente di scegliere se i dati della persona a cui ti stai collegando si trovano sullo stesso sito ma in un set di database genealogico diverso o se i dati si trovano su un sito diverso accessibile tramite Internet.<br /><br />Se la persona si trova sullo stesso sito, ti verrà chiesto di selezionare l'identificatore del set di dati e di inserire l'identificatore della persona.<br /><br />Per un sito remoto, ti verrà chiesto di inserire il suo URL, un identificatore di database, e l'identificatore remoto della persona.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Usa questa opzione per selezionare la relazione che la persona remota ha con la persona con cui la stai collegando sul tuo sito. Ad esempio, selezionare <i>Padre</i> significherebbe che la persona sul sito remoto è il padre della persona a cui lo stai collegando localmente.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Usa questo modulo per collegare persone ad altre persone da un altro sito o da un altro database genealogico accessibile alla tua copia di PhpGedView.<br /><br />Per aggiungere un tale collegamento, devi prima selezionare il tipo di relazione, quindi scegliere un sito già noto a PhpGedView o definire un nuovo sito, quindi inserire il numero di identificazione di quel sito della persona a cui si desidera collegarsi. PhpGedView scaricherà quindi automaticamente le informazioni dal sito remoto, se necessario. Le informazioni scaricate <u>non</u> diventano parte del tuo database genealogico; rimane sul sito originale ma è incorporato nelle varie pagine in cui viene visualizzata questa persona collegata in remoto.<br /><br />Fare riferimento al collegamento Guida accanto a ciascun elemento della pagina per ulteriori informazioni su tale elemento. Puoi anche controllare il tutorial di inglese online per ulteriori informazioni: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Persons_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />Il nome della libreria, dell'archivio o di un altro repository in cui è archiviato il materiale di origine.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />L'indirizzo di questa libreria, archivio o altro repository. Inserisci l'indirizzo come lo scriveresti su una busta.<br /><br />Lascia vuoto questo campo se non desideri includere un indirizzo.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Il numero di telefono di questa libreria, archivio o altro repository. Immettere il numero compreso il prefisso del paese e dell'area. Ad esempio, un numero in Germania potrebbe essere +49 25859 56 76 89 e un numero in USA o Canada potrebbe essere +1 888 555-1212.<br /><br />Lascia vuoto questo campo se non desideri includerlo un numero di telefono.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />Il numero di FAX di questa libreria, archivio o altro repository. Immettere il numero compreso il prefisso del paese e dell'area. Ad esempio, un numero in Germania potrebbe essere +49 25859 56 76 89 e un numero in USA o Canada potrebbe essere +1 888 555-1212.<br /><br />Lascia vuoto questo campo se non desideri includerlo un numero di FAX.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />L'indirizzo e-mail di questa libreria, archivio o altro repository. Inserisci l'indirizzo e-mail. Esempio: <b>name@hotmail.com</b><br /><br />Lascia vuoto questo campo se non desideri includere un indirizzo email.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />La home page Internet di questa libreria, archivio o altro repository. Immettere l'indirizzo della home page compreso http:// o https://. Esempio: <b>https://www.phpgedview.net/</b><br /><br />Lascia vuoto questo campo se non desideri includere un indirizzo della home page.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />Un'identificazione o una descrizione di riferimento utilizzata per archiviare e recuperare elementi dalle proprietà di una libreria, archivio o altro repository. I repository informali di solito non hanno bisogno di utilizzare un sistema #factarray[CALN]#.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Questo è il numero ID della libreria, dell'archivio o di un altro depot in cui è memorizzato il materiale di origine a cui si fa riferimento. Il titolo dell'archivio corrente verrà mostrato sotto il numero ID.<br /><br />È possibile modificare il numero ID dell'archivio in cui è memorizzato questo materiale sorgente. Per rimuovere il riferimento all'archivio, rendere vuoto questo campo. Questa azione non rimuove il record di archivio dal database; viene rimosso solo il riferimento.<br /><br />Se si immette direttamente l'ID di archivio desiderato, quel record di archivio deve già esistere nel database. Puoi fare clic <b>#pgv_lang[find_repository]#</b per cercare il numero ID di un archivio esistente. Fai clic <b>#pgv_lang[create_repository]#</b> se devi inserire un nuovo record di archivio.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Quando e dove è stato creato il record. Per le opere pubblicate, questo include informazioni come la città di pubblicazione, il nome dell'editore e l'anno di pubblicazione.<br /><br />Per un'opera non pubblicata, dovrebbe includere la data di creazione del record e il luogo in cui è stato creato. Ad esempio, la contea e lo stato di residenza di una persona che dichiara una pensione o la città e lo stato di residenza di chi scrive una lettera o una storia familiare privata.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />La persona, agenzia o entità che ha creato il record. Per un'opera pubblicata, questo potrebbe essere l'autore, il compilatore, il trascrittore, l'estrattore o l'editore. Per una fonte non pubblicata, può trattarsi di un individuo, un'agenzia governativa, un'organizzazione ecclesiastica o un'organizzazione privata, ecc.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Questo campo viene normalmente utilizzato per registrare il testo in formato libero per identificare questo record GEDCOM. Ad esempio, può essere un numero di file all'interno di un sistema automatico o manuale, oppure può essere un numero di pagina e posizione su un albero genealogico.<br /></br />Quando la configurazione GEDCOM è stata impostata per consentire all'utente di sovrascrivere il numero ID generato automaticamente per le nuove persone, quel numero ID sovrascritto viene inserito qui. In questo caso, il testo deve essere conforme alle regole stabilite per i numeri ID. I numeri ID validi possono contenere solo le lettere dalla <b>A</b> alla <b>Z</b>, dalla <b>a</b> alla <b>Z</b>, cifre dalla <b>0</b> alla <b>9</b> e i simboli speciali <b>. : -</b> e <b>_</b><br /><br />L'opzione che abilita l'uso di #factarray[REFN]# al posto del numero ID generato automaticamente si trova nella configurazione GEDCOM, sezione Opzioni di modifiche.";
$pgv_lang["edit_ABBR_help"]			= "~#factarray[ABBR]#~<br /><br />Utilizza questo campo per memorizzare una versione abbreviata di un titolo. Questo campo viene utilizzato insieme al campo del titolo nelle fonti. Per impostazione predefinita PGV utilizzerà prima il titolo e poi il titolo abbreviato.<br /><br />Secondo la specifica GEDCOM 5.5, \"questa voce serve per fornire un breve titolo utilizzato per l'ordinamento, l'archiviazione e il recupero dei record di origine (pg 62).\"<br /><br />In PhpGedView il titolo abbreviato è facoltativo, ma in altri programmi genealogici è obbligatorio.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "In molte culture è consuetudine avere un nome tradizionale scritto nei caratteri tradizionali e anche una versione romanizzata del nome come sarebbe scritto o pronunciato nelle lingue basate sull'alfabeto latino, come l'italiano.<br /><br />Se si preferisce utilizzare un alfabeto non latino come ebraico, greco, russo, cinese o arabo per inserire il nome nei campi del nome standard, è possibile utilizzare questo campo per inserire lo stesso nome utilizzando l'alfabeto latino. Entrambe le versioni del nome appariranno negli elenchi e nei grafici.<br /><br />Sebbene questo campo sia etichettato \"Romanizzato\", non è limitato a contenere solo caratteri basati sull'alfabeto latino. Questo potrebbe essere utile con i nomi giapponesi, dove possono essere presenti tre alfabeti diversi.";
$pgv_lang["edit_ROMN_GIVN_help"]	= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />In questo campo devi inserire i nomi dati per la persona. Ad esempio, nel nome \"John Robert Finlay\", i nomi dati che dovrebbero essere inseriti qui sono \"John Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]	= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />In questo campo devi inserire il cognome della persona. Ad esempio, nel nome \"John Robert Finlay\", il cognome da inserire qui è \"Finlay\".<br /><br />Le persone con più cognomi, comuni in Spagna e Portogallo, dovrebbero separare i cognomi con una virgola. Ciò indica che la persona deve essere elencata sotto ciascuno dei nomi. Ad esempio, il cognome \"Cortes,Vega\" sarà elencato sia sotto <b>C</b> che <b>V</b>, mentre il cognome \"Cortes Vega\" sarà elencato solo sotto <b>C</b>.";
$pgv_lang["edit__HEB_help"]			= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "In molte culture è consuetudine avere un nome tradizionale scritto nei caratteri tradizionali e anche una versione romanizzata del nome come sarebbe scritto o pronunciato nelle lingue basate sull'alfabeto latino, come l'italiano.<br /><br />Se si preferisce utilizzare l'alfabeto latino per immettere il nome nei campi del nome standard, è possibile utilizzare questo campo per immettere lo stesso nome nell'alfabeto non latino, ad esempio greco, ebraico, russo, arabo o cinese. Entrambe le versioni del nome appariranno negli elenchi e nei grafici.<br /><br />Sebbene questo campo sia etichettato come \"Ebraico\", non è limitato a contenere solo caratteri ebraici.";
$pgv_lang["edit__HEB_GIVN_help"]	= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />In questo campo devi inserire i nomi dati per la persona. Ad esempio, nel nome \"John Robert Finlay\", i nomi dati che dovrebbero essere inseriti qui sono \"John Robert\".";
$pgv_lang["edit__HEB_SURN_help"]	= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />In questo campo devi inserire il cognome della persona. Ad esempio, nel nome \"John Robert Finlay\", il cognome da inserire qui è \"Finlay\".<br /><br />Le persone con più cognomi, comuni in Spagna e Portogallo, dovrebbero separare i cognomi con una virgola. Ciò indica che la persona deve essere elencata sotto ciascuno dei nomi. Ad esempio, il cognome \"Cortes,Vega\" sarà elencato sia sotto <b>C</b> che <b>V</b>, mentre il cognome \"Cortes Vega\" sarà elencato solo sotto <b>C</b>.";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Usa questo modulo per aggiungere una persona non collegata.<br /><br /> Quando aggiungi una persona non collegata al tuo albero genealogico, la persona non sarà collegata ad altre persone finché non le colleghi. Successivamente, puoi collegare le persone insieme dalla scheda #pgv_lang[relatives]# sulla pagina #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Immettere l'indirizzo URL compreso http://. Esempio: <b>http://www.phpgedview.net/</b><br /><br />Lascia vuoto questo campo se non desideri includere un URL.";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Immettere l'indirizzo della home page Web incluso http://. Esempio: <b>http://www.phpgedview.net/</b><br /><br />Lascia vuoto questo campo se non desideri includere un indirizzo di home page Web.";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Inserisci l'indirizzo e-mail. Esempio: <b>nome@hotmail.com</b><br /><br />Lascia vuoto questo campo se non desideri includere un indirizzo email.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Immettere il numero di FAX compreso il prefisso del paese e dell'area. Ad esempio, un numero in Germania potrebbe essere +49 25859 56 76 89 e un numero negli USA o in Canada potrebbe esserlo +1 888 555-1212.<br /><br />Lascia vuoto questo campo se non desideri includere un numero di FAX.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Immettere il numero di telefono compreso il prefisso del paese e dell'area. Ad esempio, un numero in Germania potrebbe essere +49 25859 56 76 89 e un numero negli USA o in Canada potrebbe esserlo +1 888 555-1212.<br /><br />Lascia vuoto questo campo se non desideri includere un numero di telefono.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Inserisci l'indirizzo nel campo proprio come lo scriveresti su una busta.<br /><br />Lascia vuoto questo campo se non desideri includere un indirizzo.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Inserisci o seleziona dall'elenco le parole che precedono la parte principale del Cognome. Esempi di tali parole sono <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.<br /><br />In alcune circostanze, qui è possibile inserire un titolo nobiliare. Ad esempio, Peter <b>Freiherr von</b> Somewhere. La parte «Freiherr» è in realtà un titolo nobiliare, e non dovrebbe essere ripetuta come un fatto #factarray[TITL]#. Ciò che viene inserito qui dipende in gran parte dalle preferenze della persona in questione.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Immettere il nome da sposato per questa persona, utilizzando le stesse regole di formattazione che si applicano al campo Nome. Questo campo è facoltativo.<br /><br />Ad esempio, se Mary Jane Brown ha sposato John White, potresti inserire (senza virgolette, ovviamente)<ul><li>Uso americano:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Uso europeo:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Uso europeo alternativo:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" o \"Mary Jane /Brown-White/\"</li></ul>Dovresti farlo solo se Mary Brown ha iniziato a chiamarsi con il nuovo nome dopo aver sposato John White. In alcuni luoghi, ad esempio nel Quebec (Canada), è illegale cambiare i nomi in questo modo.<br /><br />Gli uomini a volte cambiano il loro nome dopo il matrimonio, il più delle volte usando il trattino ma occasionalmente prendendo il cognome della moglie.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />Questo campo descrive il rapporto del bambino con la sua famiglia. Le possibilità sono:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Il rapporto del bambino con la sua famiglia non può essere determinato. Quando questa opzione è selezionata, il campo #factarray[PEDI]# non verrà copiato nel database.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Questa opzione indica che il bambino è legato alla sua famiglia per nascita.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Questa opzione indica che il bambino è stato adottato dalla sua famiglia. Ciò <i>non</i> indica che non esiste una relazione di sangue tra il bambino e la sua famiglia; mostra che il bambino è stato adottato dalla famiglia in questione qualche tempo dopo la nascita del bambino.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Questa opzione indica che il bambino è un figlio adottivo della famiglia. Di solito, non esiste una relazione di sangue tra il bambino e la sua famiglia.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Il bambino è stato suggellato alla sua famiglia durante una cerimonia di <i>suggellamento</i> della chiesa SUG. Il suggellamento dei figli viene celebrato quando i genitori sono stati suggellati gli uni agli altri dopo la nascita del bambino. I figli nati dopo il suggellamento dei genitori vengono automaticamente suggellati alla famiglia.</li></ul>";
$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />L'organizzazione, istituzione, società, persona o altra entità che ha autorità.<br /><br />Ad esempio, un datore di lavoro di una persona, o una chiesa che ha amministrato riti o eventi, o un'organizzazione responsabile della creazione e / o archiviare record.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#:#factarray[TYPE]#~<br /><br />Questo campo descrive il tipo di unione che ha formato la famiglia.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;indica che la cerimonia che formalizzò l'unione di due persone per formare una famiglia fu eseguita da un prete, vescovo, cardinale, predicatore, rabbino, sciamano o persona simile. La cerimonia non ebbe necessariamente luogo in una chiesa, sinagoga, tempio o altro luogo consacrato. Poteva aver luogo all'aperto o in un'abitazione privata.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;indica che la cerimonia che ha formalizzato l'unione di due persone per formare una famiglia è stata eseguita da un giudice, magistrato, sindaco o persona di autorità simile che non sia un prete, ecc. L'autorità di eseguire tali cerimonie è solitamente concessa da un governo. La cerimonia non ha necessariamente avuto luogo in un'aula di tribunale o in un ufficio.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;descrive la relazione tra due persone, non sposate tra loro, che si comportano come se fossero una famiglia. <u>Non</u> hanno preso parte a una cerimonia di matrimonio celebrata da un prete, un vescovo, un giudice, un sindaco o qualsiasi altra persona con l'autorità di celebrare matrimoni. Possono aver fatto una dichiarazione pubblica in cui dichiarano di considerarsi sposati, ma questo non è un requisito.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;indica che non sono noti i particolari dell'unione tra due persone per formare una famiglia.</li></ul>";

$pgv_lang["context_help"]			= "È disponibile ulteriore assistenza facendo clic su <b>?</b> accanto agli elementi nella pagina.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Ogni persona nel database ha un numero di identificazione univoco su questo sito. Se conosci l'identificatore del tuo record, inseriscilo qui. Se non conosci il tuo identificatore o non sei riuscito a trovarlo a causa delle impostazioni sulla privacy, fornisci informazioni sufficienti nel campo Commenti per aiutare l'amministratore del sito a identificare chi sei su questo sito in modo che possa impostare l'identificatore per te.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Usa questo campo per dire all'amministratore del sito perché stai richiedendo un account e come sei correlato alla genealogia visualizzata su questo sito. Puoi anche usarlo per inserire altri commenti che potresti avere per l'amministratore del sito.";
$pgv_lang["utf8_ansi_help"]		= "~#pgv_lang[utf8_to_ansi]#~<br /><br />Per una visualizzazione ottimale su Internet, PhpGedView utilizza il set di caratteri UTF-8. Alcuni programmi, ad esempio Family Tree Maker, non supportano l'importazione di file GEDCOM codificati in UTF-8. Selezionando questa casella il file verrà convertito da <b>UTF-8</b> a <b>ANSI (ISO 8859-1)</b>.<br /><br />Il formato necessario dipende dal programma che utilizzi per lavorare con il file GEDCOM scaricato. Se non sei sicuro, consulta la documentazione di quel programma.<br /><br />Tieni presente che affinché i caratteri speciali rimangano invariati, dovrai mantenere il file in UTF-8 e convertirlo nel metodo del tuo programma per gestire questi caratteri speciali con altri mezzi. Consulta il produttore o l'autore del tuo programma.<br /><br />Questo <a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a> contiene informazioni complete e collegamenti su UTF-8.";
$pgv_lang["remove_tags_help"]	= "~#pgv_lang[remove_custom_tags]#~<br /><br />Selezionando questa opzione verranno rimossi tutti i tag speciali che potrebbero essere stati aggiunti ai record da PhpGedView.<br /><br />Tali tag includono il tag <b>_PGVU</b> che identifica l'utente che ha modificato un record online e il tag <b>_THUM</b> che dice a PhpGedView che l'immagine deve essere usata come miniatura.<br /><br />Tag speciali possono causare errori durante l'importazione del GEDCOM scaricato in un'altra applicazione di genealogia.";
$pgv_lang["download_zipped_help"]	= "~#pgv_lang[zip_files]#~<br /><br />Quando selezioni questa opzione, una copia del file GEDCOM verrà compressa in formato ZIP prima che inizi il download. Ciò ridurrà notevolmente le sue dimensioni, ma dovrai utilizzare un programma Unzip compatibile (WinZIP, ad esempio) per decomprimere il file GEDCOM trasmesso prima di poterlo utilizzare.<br /><br />Questa è un'opzione utile per il download file GEDCOM di grandi dimensioni. Esiste il rischio che il tempo di download per il file non compresso possa superare il tempo di esecuzione massimo consentito, con conseguente download incompleto dei file. L'opzione ZIP dovrebbe ridurre il tempo di download del 75%.";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Immettere il numero di bambini per questa persona o famiglia. Questo è un campo facoltativo.";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Immettere l'ora per questo evento in formato 24 ore con zeri iniziali. La mezzanotte è 00:00. Esempi: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />Le note sono testo in formato libero e verranno visualizzate nella sezione Dettagli Fatti della pagina.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Le note condivise sono testo in formato libero e verranno visualizzate nella sezione Dettagli Fatti della pagina.<br /><br />Ogni nota condivisa può essere collegata a più di una persona, famiglia, fonte o evento.";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />Inserisci il nome del cimitero o altro luogo di riposo in cui è sepolta la persona.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Inserisci l'ID GEDCOM della persona la cui rapporto con la persona attuale desideri descrivere.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Seleziona un #factarray[RELA]# dall'elenco. Selezionare <b>#pgv_lang[godfather]#</b> significa: <i>La persona identificata nel campo #factarray[ASSO]# è il #pgv_lang[godfather]# della persona attuale</i>.";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Per impostazione predefinita, questo grafico non mostra i coniugi per i discendenti perché rende il grafico più difficile da leggere e capire. L'attivazione di questa opzione mostrerà i coniugi sul grafico.";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Le famiglie nella scheda #pgv_lang[relatives]# vengono visualizzate nell'ordine in cui appaiono nel record GEDCOM della persona. Le famiglie non sono ordinate in base alla data del matrimonio perché spesso le date del matrimonio sono sconosciute ma l'ordine dei matrimoni <u>è</u> noto.<br /><br />Questa opzione ti consentirà di modificare l'ordine del famiglie in cui sono elencate nella scheda #pgv_lang[relatives]#. Se vuoi ordinare le famiglie in base alle loro date di matrimonio, c'è un pulsante che puoi premere che lo farà automaticamente per te.";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Quando PhpGedView rileva che l'importazione GEDCOM richiede più tempo di quanto consentito dal limite di tempo, visualizzerà un pulsante <b>#pgv_lang[del_proceed]#</b> che devi premere per continuare l'importazione.<br /><br />Quando questa opzione è impostata su <b>#pgv_lang[yes]#</b>, PhpGedView premerà automaticamente il pulsante <b>#pgv_lang[del_proceed]#</b> per te. Questo dovrebbe alleviare la noia di dover premere ripetutamente il pulsante per importazioni lunghe.";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Il cognome che hai scelto ha più di #GLOBALS[SUBLIST_TRIGGER_I]# persone.<br /><br />Per aiutarti a trovare la persona che desideri, l'elenco è stato suddiviso in elenchi più piccoli in base alla prima lettera del nome dato della persona. Questo sottoindice alfabetico funziona come l'indice alfabetico dei cognomi.<ul><li>Fare clic su una lettera per visualizzare tutti i nomi che iniziano con quella lettera.</li><li>Scegli <b>#pgv_lang[PN]#</b> per elencare tutte le persone con nomi sconosciuti.</li><li>Scegliendo <b>#pgv_lang[all]#</b> verrà visualizzato un elenco di tutte le persone con il cognome scelto in precedenza.</li></ul>Poiché ci sono molti nomi, potrebbe essere necessario molto tempo prima che l'elenco appaia sullo schermo.";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Il cognome che hai scelto ha più di #GLOBALS[SUBLIST_TRIGGER_F]# persone.<br /><br />Per aiutarti a trovare la famiglia che desideri, l'elenco è stato suddiviso in elenchi più piccoli in base alla prima lettera del nome dato della persona. Questo sottoindice alfabetico funziona come l'indice alfabetico dei nomi.<ul><li>Fare clic su una lettera per vedere tutti i nomi che iniziano con quella lettera.</li><li>Scegli <b>#pgv_lang[PN]#</b> per elencare tutte le persone con nomi sconosciuti.</li><li>Scegliendo <b>#pgv_lang[all]#</b> verrà visualizzato un elenco di tutte le famiglie con il cognome scelto in precedenza.</li></ul>Poiché ci sono molti nomi, potrebbe essere necessario molto tempo prima che l'elenco appaia sullo schermo.";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />Il campo #factarray[TYPE]# viene utilizzato per inserire ulteriori informazioni sull'articolo. Nella maggior parte dei casi, il campo è completamente in formato libero e puoi inserire tutto ciò che desideri.";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />Per le ordinanze della chiesa SUG, questo campo registra il Tempio dove è stato celebrato.";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Questo è un campo di stato opzionale e viene utilizzato principalmente per le ordinanze della chiesa SUG mentre vengono eseguite attraverso il programma TempleReady.";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Utilizza questo campo per segnalare che questo elemento multimediale è l'elemento evidenziato o principale per la persona a cui è associato. L'immagine evidenziata è quella che verrà utilizzata sui grafici e nella pagina Persona.";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Questa opzione ti consente di sovrascrivere la normale selezione per un'immagine in miniatura.<br /><br /> GEDCOM ha un'opzione di configurazione che specifica se PhpGedView deve inviare l'immagine grande o piccola al browser ogni volta che la pagina corrente richiede una miniatura. L'opzione «#factarray[_THUM]#», se impostata su <b>#pgv_lang[yes]#</b>, sovrascrive temporaneamente l'impostazione dell'opzione di configurazione GEDCOM, in modo che PhpGedView invii sempre l'immagine grande. Non puoi forzare PhpGedView a inviare l'immagine piccola quando la configurazione di GEDCOM specifica che devono essere sempre usate immagini grandi.<br /><br />PhpGedView non ridimensiona l'immagine inviata; il browser lo fa in base alle specifiche della pagina che ha ricevuto. Ciò può avere conseguenze indesiderabili quando l'immagine inviata non è veramente una miniatura in cui PhpGedView si aspetta di inviare una piccola immagine. Questo non è un errore: ci sono occasioni in cui potrebbe essere desiderabile visualizzare un'immagine grande in luoghi in cui normalmente ci si aspetterebbe di vedere un'immagine in miniatura.<br /><br />Dovresti evitare di impostare l'opzione «#factarray[_THUM]#» su <b>#pgv_lang[yes]#</b>. Questa scelta farà sì che una quantità eccessiva di dati relativi alle immagini venga inviata al browser, solo per fare in modo che il browser scarti l'eccesso. I caricamenti delle pagine, in particolare dei grafici con molte immagini, possono essere seriamente rallentati.";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Inserisci un titolo per l'elemento che stai modificando. Se questo è un titolo per un elemento multimediale, inserisci un titolo descrittivo che identificherà l'elemento per l'utente.<br /><br />Se stai modificando i dettagli di una persona, usa questo campo per inserire informazioni sulla nobiltà come <i>Sir, Lord, Barone, Conte, Duca, Graf, Freiherr,</i> ecc.<br /><br />Le designazioni professionali come <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> ecc. devono essere inserite nel sottocampo «#factarray[NPFX]#», mentre i suffissi dei nomi come <i>Jr., Sr., III, IV,</i> ecc. e le informazioni accademiche come <i>PhD, PEng, FImechE, DVM, MD,</i> ecc. appartengono al sottocampo «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Questo è il campo più importante nel record di oggetti multimediali. Indica quale file utilizzare. Come minimo, è necessario inserire il nome del file. A seconda delle impostazioni, potrebbero essere utili ulteriori informazioni sulla posizione del file.<br /><br />È possibile utilizzare il collegamento <b>#pgv_lang[find_media]#</b> per individuare gli elementi multimediali che sono già stati caricati sul sito.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />Questo è un campo opzionale che può essere utilizzato per inserire il formato del file dell'oggetto multimediale. Alcuni programmi di genealogia possono esaminare questo campo per determinare come gestire l'elemento. Tuttavia, poiché i media non si trasferiscono molto bene tra i sistemi informatici, questo campo non è molto importante.";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />Il sistema può generare automaticamente miniature per determinati tipi di immagini. Potrebbe esserci supporto per file BMP, GIF, JPG e PNG. I tipi supportati dal tuo sistema sono elencati accanto alla casella di controllo.Facendo clic su questa casella, segnali al sistema che stai caricando immagini di questo tipo e che desideri che provi a generare miniature per esse. Lascia la casella deselezionata se desideri fornire le tue miniature.";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Questa sezione ti consente di aggiungere una nuova nota al fatto che stai attualmente modificando. Le note sono testo in formato libero e verranno visualizzate nella sezione Dettagli Fatti della pagina.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Le note condivise, come le note normali, sono testo in formato libero. A differenza delle note normali, ogni nota condivisa può essere collegata a più di una persona, famiglia, fonte o fatto.<br /><br />Facendo clic sull'icona appropriata, è possibile stabilire un collegamento a una nota condivisa esistente o creare un nuova nota condivisa e allo stesso tempo link ad essa. Se è già stato stabilito un collegamento a una nota condivisa esistente, puoi anche modificare il contenuto di quella nota.<br /><ul><li><b>Collegamento a una nota condivisa esistente</b><div style=\"padding-left: 20px;\">Se conosci già l'identificativo della nota condivisa desiderata, puoi inserire quel numero direttamente nel campo.<br /><br />Quando fai clic sull'icona <b>#pgv_lang[find_shared_note]#</b>, sarai in grado di cercare il testo di tutte le note condivise esistenti e quindi sceglierne una. L'identificativo della nota scelta verrà inserito automaticamente nel campo.<br /><br />È necessario fare clic sul pulsante <b>#pgv_lang[add]#</b> per aggiornare il record originale.</div><br /></li><li><b>Crea una nuova nota condivisa</b><div style=\"padding-left: 20px;\">Quando fai clic sull'icona <b>#pgv_lang[create_shared_note]#</b>, si aprirà una nuova finestra. Puoi inserire il testo della nuova nota come desideri. Come con le note normali, puoi inserire URL.<br /><br />Quando fai clic sul pulsante <b>#pgv_lang[save]#</b>, vedrai un messaggio con il numero ID della nota condivisa appena creata. Fare clic su questo messaggio per chiudere la finestra di modifica e copiare anche il nuovo numero ID direttamente nel campo del numero ID. Se chiudi semplicemente la finestra, il numero ID appena creato non verrà copiato automaticamente.<br /><br />Devi fare clic sul pulsante <b>#pgv_lang[add]#</b> per aggiornare il record originale.</div><br /></li><li><b>Modifica una nota condivisa esistente</b><div style=\"padding-left: 20px;\">Quando fai clic sull'icona <b>#pgv_lang[edit_shared_note]#</b>, si aprirà una nuova finestra. Puoi modificare il testo della nota condivisa esistente come desideri. Come per le note normali, puoi inserire gli URL.<br /><br />Quando fai clic sul pulsante <b>#pgv_lang[save]#</b>, il testo della nota condivisa verrà aggiornato. Puoi chiudere la finestra e fare di nuovo clic sul pulsante <b>#pgv_lang[save]#</b>.<br /><br />Quando modifichi il testo di una nota condivisa, la tua modifica si rifletterà in tutti i posti a cui quella nota condivisa è attualmente collegata. Anche i nuovi collegamenti che stabilisci dopo aver apportato la modifica utilizzeranno il testo aggiornato.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~UTILIZZO DELL'ASSISTENTE GEDFACT~<br /><br />Facendo clic sull'icona \"+\" si aprirà la finestra Assistente note condivise di GEDFact. Lì troverai una guida specifica.<br /><br />Quando fai clic sul pulsante \"Salva\", l'ID di la nota condivisa verrà incollata qui.";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Questa sezione ti consente di aggiungere una nuova citazione della fonte al fatto che stai attualmente modificando.<br /><br />Nel campo Fonte inserisci l'identificatore della fonte. Fare clic sul collegamento <b>#pgv_lang[create_source]#</b> se è necessario inserire una nuova fonte. Nel campo Dettagli citazione inserire il numero di pagina o altre informazioni che potrebbero aiutare qualcuno a trovare le informazioni nella fonte. Nel campo Testo immetti la trascrizione del testo dalla fonte.";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />Ciò ti consente di collegare un fatto a una persona associata nel sito. Questo è un modo in cui potresti registrare che qualcuno era il Padrino di un'altra persona.";
$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#~<br /><br />Utilizzerai questo campo per registrare la qualità o l'affidabilità dei dati trovati in questa fonte. Molte applicazioni di genealogia utilizzano un numero nel campo. <b>3</b> potrebbe significare che i dati sono una fonte primaria, <b>2</b> potrebbe significare che si trattava di una fonte secondaria, <b>1</b> potrebbe significare che le informazioni sono discutibili, e <b>0</b> potrebbe significare che la fonte non è affidabile.";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />Nel campo Dettagli citazione inserire il numero di pagina o altre informazioni che potrebbero aiutare qualcuno a trovare le informazioni nella fonte.";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />In questo campo inserire il testo della citazione per questa fonte. Esempi di dati possono essere una trascrizione del testo dalla fonte o una descrizione di ciò che era nella citazione.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Questo è il numero ID della fonte per questo Fatto. Il titolo della fonte corrente verrà mostrato sotto il numero ID.<br /><br />È possibile modificare il numero ID del record della fonte a cui si riferisce la citazione della fonte di questo fatto. Per rimuovere l'intera citazione, rendere vuoto questo campo. Questa azione non rimuove il record di origine dal database; viene rimosso solo questo riferimento.<br /><br />Se si immette direttamente l'ID di origine desiderato, il record di origine deve già esistere nel database. Puoi fare clic <b>#pgv_lang[find_sourceid]#</b> per cercare il numero ID di un record di origine esistente. Fai clic <b>#pgv_lang[create_source]#</b> se devi inserire un nuovo record di origine.";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Questa pagina ti consente di modificare il record GEDCOM grezzo. Dovresti usare questa pagina con cautela; richiede una buona comprensione dello standard GEDCOM 5.5.1. Per ulteriori informazioni su GEDCOM 5.5.1 Standard, fare riferimento all'argomento della Guida <b>File GEDCOM</b>.<br /><br />PhpGedView fornisce molti modi per aggiungere e modificare le informazioni, ma potrebbero esserci occasioni in cui potrebbe voler modificare la struttura GEDCOM grezza. Quando possibile, dovresti utilizzare i moduli forniti per aggiungere informazioni, ma quando ciò è impossibile, puoi utilizzare questo modulo. Dopo aver inviato il modulo, le tue informazioni saranno controllate per verificarne la conformità di base allo Standard e il record CHAN verrà aggiornato.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView ti consente di copiare fino a 10 fatti, con tutti i loro dettagli, negli appunti. Questo appunti è diverso dal carrello dei ritagli che puoi utilizzare per esportare parti del tuo database.<br /><br />Puoi selezionare uno qualsiasi dei fatti dagli appunti e copiare il fatto selezionato in Persona, Famiglia, Media, Origine o record del repository attualmente in fase di modifica. Tuttavia, non è possibile copiare fatti di tipi di record diversi. Ad esempio, non è possibile copiare un fatto di matrimonio in una fonte o in un record di persona poiché il fatto di matrimonio è associato solo ai registri di famiglia.<br /><br />Ciò è molto utile quando si inseriscono fatti simili, come i fatti del censimento, per molte persone o famiglie.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />I luoghi devono essere inseriti secondo gli standard per la genealogia. Nella genealogia, i luoghi vengono registrati con le informazioni più specifiche sul luogo prima e poi lavorando fino all'ultimo luogo meno specifico, usando virgole per separare i diversi livelli di luogo. Il livello al quale si registrano le informazioni sul luogo deve rappresentare i livelli del governo o della chiesa in cui sono conservati i registri vitali per quel luogo.<br /><br />Ad esempio, un luogo come Salt Lake City verrebbe inserito come \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Esaminiamo ogni parte di questo luogo. La prima parte, \"Salt Lake City\", è la città in cui si è verificato l'evento. In alcuni paesi, potrebbero esserci comuni o distretti all'interno di una città che sono importanti da notare. In tal caso, dovrebbero venire prima della città. La parte successiva, \"Salt Lake\", è la contea. \"Utah\" è lo stato e \"USA\" è il paese. È importante annotare ogni luogo perché i registri genealogici sono conservati dai governi di ogni livello.<br /><br />Se un livello del luogo è sconosciuto, dovresti lasciare uno spazio tra le virgole. Supponi, nell'esempio sopra, di non conoscere la contea di Salt Lake City. Dovresti quindi registrarlo in questo modo: \"Salt Lake City, , Utah, USA\". Supponi di sapere solo che una persona è nata nello Utah. Dovresti inserire le informazioni in questo modo: \", , Utah, USA\".<br /><br />Puoi utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per trovare luoghi già esistenti nel database.";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />L'inserimento di coordinate di latitudine e longitudine specifiche è generalmente sconsigliato poiché consente l'accesso alla mappatura solo dalla vista dell'elemento specifico. È meglio gestire i luoghi geografici.<br /><br />Tuttavia, l'inserimento della latitudine e della longitudine consente un controllo più preciso del marker.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />L'inserimento di coordinate di latitudine e longitudine specifiche è generalmente sconsigliato poiché consente l'accesso alla mappatura solo dalla vista dell'elemento specifico. È meglio gestire i luoghi geografici.<br /><br />Tuttavia, l'inserimento della latitudine e della longitudine consente un controllo più preciso del marker.";
$pgv_lang["edit_add_parent_help"]	= "~AGGIUNGI NUOVA MADRE O PADRE~<br /><br />Con questa pagina puoi aggiungere una nuova madre o un nuovo padre alla persona selezionata. Compila il nome della nuova persona e le informazioni di nascita e morte, se conosciute. Se non conosci alcune informazioni, lascia il campo vuoto.<br /><br />Per aggiungere altri fatti oltre alla nascita e alla morte, aggiungi prima la nuova persona al database salvando le modifiche. Quindi fare clic sul nome della persona nella pagina Famiglia aggiornata o nella scheda #pgv_lang[relatives]# per visualizzare la pagina #pgv_lang[indi_info]# della persona. Dalla pagina #pgv_lang[indi_info]# puoi aggiungere informazioni più dettagliate.";
$pgv_lang["edit_add_spouse_help"]	= "~AGGIUNGI NUOVO MARITO O MOGLIE~<br /><br />Con questa pagina puoi aggiungere un nuovo marito o una nuova moglie alla persona selezionata. Compila il nome della nuova persona e le informazioni di nascita e morte, se conosciute. Se non conosci alcune informazioni lascia il campo vuoto.<br /><br />Per aggiungere altri fatti oltre alla nascita e alla morte, aggiungi prima la nuova persona al database salvando le modifiche. Quindi fare clic sul nome della persona nella pagina Famiglia aggiornata o nella scheda #pgv_lang[relatives]# per visualizzare la pagina #pgv_lang[indi_info]# della persona. Dalla pagina #pgv_lang[indi_info]# puoi aggiungere informazioni più dettagliate.";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />Quest'area ti permette di inserire le informazioni sulla morte. Per prima cosa inserisci la data in cui la persona è morta nel formato della data standard per la genealogia (1&nbsp;JAN&nbsp;2004) <u>in inglese</u>. È possibile fare clic sull'icona del calendario per assistenza nella selezione di una data. Quindi entra nel luogo in cui la persona è morta. È possibile utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per selezionare un luogo già esistente nel database.";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />Quest'area ti permette di inserire le informazioni sulla nascita. Per prima cosa inserisci la data di nascita della persona nel formato di data standard per la genealogia (1&nbsp;JAN&nbsp;2004) <u>in inglese</u>. È possibile fare clic sull'icona del calendario per assistenza nella selezione di una data. Quindi entra nel luogo in cui è nata la persona. È possibile utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per selezionare un luogo già esistente nel database.";
$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Scegli il sesso appropriato dall'elenco. L'opzione <b>sconosciuto</b> indica che il sesso è sconosciuto.";
$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#~<br /><br />Questo è il campo più importante nel record del nome di una persona.<br /><br />Questo campo dovrebbe essere compilato automaticamente mentre vengono compilati gli altri campi, ma viene fornito in modo che tu possa modificare le informazioni in base alle tue preferenze personali.<br /><br />Il nome in questo campo deve essere inserito secondo gli standard GEDCOM 5.5.1 con il cognome circondato da barre \"/\". Ad esempio, il nome \"John Robert Finlay Jr.\" deve essere inserito in questo modo: \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />In questo campo devi inserire il cognome della persona. Ad esempio, nel nome \"John Robert Finlay\", il cognome da inserire qui è \"Finlay\".<br /><br />Le persone con più cognomi, comuni in Spagna e Portogallo, dovrebbero separare il cognomi con virgola. Ciò indica che la persona deve essere elencata sotto ciascuno dei nomi. Ad esempio, il cognome \"Cortes,Vega\" sarà elencato sia sotto <b>C</b> e <b>V</b>, mentre il cognome \"Cortes Vega\" sarà elencato solo sotto <b>C</b>.";
$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />In questo campo devi inserire eventuali soprannome per la persona. Questo è un campo facoltativo.<br /><br />Modi per aggiungere un soprannome:<ul><li>Seleziona <b>modifica nome</b>, quindi inserisci nickname e salva</li><li>Seleziona <b>aggiungi nuovo nome</b>, quindi inserisci soprannome E nome e salva</li><li>Seleziona <b>modifica record GEDCOM</b> per aggiungere più record [2&nbsp;NICK] subordinati al record [1&nbsp;NAME] principale.</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />In questo campo devi inserire i nomi dati per la persona. Ad esempio, nel nome \"John Robert Finlay\", i nomi dati essere inseriti qui sono \"John Robert\".";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Questo campo facoltativo ti consente di inserire un prefisso del nome come <i>Dott.</i> o <i>Ammin.</i><br /><br />I titoli nobiliari come <i>Sir, Lord, Barone, Conte, Duca, Graf, Freiherr,</i> ecc. sono inseriti come un fatto «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Questo campo facoltativo consente di inserire un suffisso del nome come <i>Jr., Sr., III, IV,</i> ecc. e informazioni accademiche come <i>PhD, PEng, FImechE, DVM, MD,</i> ecc.";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />Con questa pagina puoi aggiungere un nuovo bambino alla famiglia selezionata. Compila il nome del bambino e le informazioni sulla nascita e sulla morte, se note. Se non conosci alcune informazioni lascia il campo vuoto.<br /><br />Per aggiungere altri fatti oltre alla nascita e alla morte, aggiungi prima il nuovo bambino al database salvando le modifiche. Quindi fare clic sul nome del bambino nella pagina Famiglia aggiornata o nella scheda #pgv_lang[relatives]# per visualizzare la pagina #pgv_lang[indi_info]# del bambino. Dalla pagina #pgv_lang[indi_info]# puoi aggiungere informazioni più dettagliate.";

$pgv_lang["review_changes_help"]	= "~#pgv_lang[review_changes_block]#~<br /><br />Questo blocco elencherà tutti i record che sono stati modificati online e che devono ancora essere esaminati e accettati nel database.";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Usa i campi \"Aggiorna nome\" per cambiare il nome della persona che stai modificando. Nel campo Nomi dati immettere il nome o il nome della persona. Nel campo Cognome inserire l'ultimo o il cognome della persona. Ad esempio, se il nome che desideri inserire è \"John Robert Finlay\", devi inserire \"John Robert\" nel campo Nome e \"Finlay\" nel campo Cognome.<br /><br />La compilazione di questi campi <u>cambierà</u> il nome della persona; non aggiungerà un nuovo nome.<br /><br /><i>Nota: <u>non</u> utilizzare questo metodo se il nome cambia a causa di un nuovo matrimonio. Utilizza invece le opzioni per aggiungere un nuovo marito di seguito.</i>";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Utilizza i campi \"Aggiorna fatto\" per aggiungere nuove informazioni sui fatti o modificare un fatto esistente per il record che stai modificando. Per prima cosa scegli un fatto dall'elenco. Quindi inserisci la data in cui si è verificato il fatto nel formato di data standard per la genealogia (1&nbsp;JAN&nbsp;2004) <u>in inglese</u>. È possibile fare clic sull'icona del calendario per assistenza nella selezione di una data. Quindi entra nel luogo in cui si è verificato il fatto. Puoi utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per selezionare un luogo già esistente nel database.<br /><br />Come con tutti gli altri campi di questo modulo, le tue informazioni sostituiranno ciò che è già presente o creeranno nuove voci come richiesto.";
$pgv_lang["quick_update_address_help"] = "~#pgv_lang[update_address]#~<br /><br />Utilizza i campi <b>#pgv_lang[update_address]#</b> per modificare l'indirizzo, il numero di telefono o l'indirizzo email della persona che stai modificando.<br /><br />Come con tutti gli altri campi di questo modulo, le tue informazioni sostituiranno ciò che è già presente o creerà nuove voci come richiesto.";
$pgv_lang["quick_update_spouse_help"] = "~AGGIUNGI UN NUOVO MARITO O MOGLIE~<br /><br />Utilizza questi campi quando desideri aggiungere un nuovo marito o una nuova moglie alla persona che stai modificando. Immettere il nome e le informazioni di nascita del nuovo coniuge nei campi, quindi inserire la data in cui si è sposato nelle informazioni sul matrimonio. Inserisci le date nel formato data standard per la genealogia (1&nbsp;JAN&nbsp;2004) <u>in inglese</u>. È possibile fare clic sull'icona del calendario per assistenza nella selezione di una data. È possibile utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per selezionare un luogo che già esiste nel database.<br /><br />Questi campi aggiungeranno solo un <i>nuovo</i> partner; non aggiorneranno le informazioni di uno vecchio. Per modificare le informazioni di qualcuno che è già registrato, chiudere questa finestra e fare clic sul nome di quella persona nella scheda #pgv_lang[relatives]#. Quindi fare clic sul menu Modifica persona per modificare le informazioni.";
$pgv_lang["quick_update_marriage_help"] = "~AGGIORNAMENTO DEL MATRIMONIO~<br /><br />È possibile utilizzare questi campi insieme ai campi per aggiungere un nuovo marito o una nuova moglie se si desidera registrare un nuovo matrimonio. In caso contrario, l'inserimento dei dati in questi campi modificherà le informazioni sull'ultimo matrimonio della persona. Inserisci le date nel formato data standard per la genealogia (1&nbsp;JAN&nbsp;2004) <u>in inglese</u>. È possibile fare clic sull'icona del calendario per assistenza nella selezione di una data. È possibile utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per selezionare un luogo già esistente nel database.";
$pgv_lang["quick_update_child_help"] = "~#pgv_lang[add_new_chil]#~<br /><br />Usa questi campi per aggiungere un nuovo bambino a questa persona. Per prima cosa inserisci il nome del bambino e scegli il sesso. Quindi inserisci la data e il luogo in cui è nato il bambino. Inserisci le date nel formato data standard per la genealogia (1&nbsp;JAN&nbsp;2004) <u>in inglese</u>. È possibile fare clic sull'icona del calendario per assistenza nella selezione di una data. Puoi utilizzare il collegamento <b>#pgv_lang[find_place]#</b> per selezionare un luogo già esistente nel database.<br /><br />Questi campi aggiungeranno solo un <u>nuovo</u> bambino. Non aggiorneranno le informazioni di un bambino già registrato. Per modificare le informazioni di qualcuno che è già nel database, chiudere questa finestra e fare clic sul nome di quella persona nella scheda #pgv_lang[relatives]#. Quindi fare clic sul menu Modifica persona per modificare le informazioni.";
$pgv_lang["index_top10_pageviews_help"]		= "~#pgv_lang[top10_pageviews]#~<br /><br />Questo blocco elencherà le persone, famiglie o fonti che sono state visualizzate dai visitatori di questo sito. Affinché questo blocco appaia, l'amministratore del sito deve aver abilitato i contatori di visite degli articoli.";
$pgv_lang["index_cookiepolicy_help"]	= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Questo blocco mostra la politica sui cookie adottata da questo sito.";
$pgv_lang["cookiepolicy_link_help"]		= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Lasciare questo campo vuoto se si vuole usare il messaggio standard.<br /><br />Se si vuole usare il testo standard e fornire inoltre un link ad un file di testo o ad una pagina HTML che contenga dettagli sulla politica di gestione dei cookie specifica per il sito, si può inserirne l'URL qui.<br /><br />Per esempio, <b>http://foo.bar.com/policy/cookies.txt</b> potrebbe puntare ad un file di testo, mentre <b>http://foo.bar.com/policy/cookies.htm</b> punta ad una pagina formattata in HTML, e <b>http://foo.bar.com/policy/cookies.doc</b> punta ad un documento in formato Microsoft Word.";
$pgv_lang["cookiepolicy_link_advice"]	= "Lasciare vuoto per usare il testo standard.<br /><br />Inserire un'URL come ad esempio <b>http://foo.bar.com/policy/cookies.txt</b> per puntare ad una pagina sulla politica dei cookie specifica per il sito.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Questa impostazione consente di specificare quale scheda viene aperta automaticamente quando l'utente accede alla pagina #pgv_lang[indi_info]#. Se è autorizzato a modificare il proprio account, l'utente può modificare questa impostazione in un secondo momento.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Questa impostazione specifica quale scheda viene aperta automaticamente quando si accede alla pagina #pgv_lang[indi_info]#.";
$pgv_lang["reorder_children_help"]	= "~#pgv_lang[reorder_children]#~<br /><br />I bambini vengono visualizzati nell'ordine in cui compaiono nel registro familiare. I bambini non vengono ordinati automaticamente per data di nascita perché spesso le date di nascita di alcuni bambini sono incerte ma l'ordine della loro nascita <u>è</u> noto.<br /><br />Questa opzione ti permetterà di cambiare l'ordine dei bambini nel registro della famiglia. Poiché potresti voler ordinare i bambini in base alla data di nascita, c'è un pulsante che puoi premere che lo farà per te.<br /><br />Puoi anche trascinare e rilasciare qualsiasi casella di informazioni per modificare l'ordine dei bambini. Quando sposti il cursore del mouse su una casella di informazioni, la sua forma cambierà in una coppia di frecce incrociate a due punte. Se si preme e si tiene premuto il pulsante sinistro del mouse prima di spostare il cursore del mouse, la casella delle informazioni seguirà il cursore del mouse in alto o in basso nell'elenco. Quando la casella delle informazioni viene spostata, le altre caselle faranno spazio. Quando rilasci il pulsante sinistro del mouse, la casella delle informazioni prenderà il suo nuovo posto nell'elenco.";
$pgv_lang["rss_feed_help"]	= "~#pgv_lang[rss_feeds]#~<br /><br />Il feed ATOM / RSS disponibile in PhpGedView consente a chiunque di visualizzare, utilizzando un apposito aggregatore di feed, i contenuti della pagina di benvenuto del tuo sito senza dover visitare il sito. La maggior parte degli aggregatori visualizzerà un avviso che informa l'utente quando qualcosa è cambiato in una pagina monitorata. Ciò consente essenzialmente a chiunque di monitorare il tuo sito PhpGedView senza bisogno di visitarlo regolarmente.<br /><br />Il blocco Feed viene utilizzato per personalizzare il collegamento al feed, consentendo tipi di feed specifici (la maggior parte dei lettori può gestire la maggior parte dei tipi, quindi questo di solito può essere lasciato al valore predefinito) e il modulo specifico che desideri nel tuo feed. La lingua del feed e il GEDCOM utilizzato saranno basati sulla lingua e sul GEDCOM attivo in PhpGedView quando selezioni il feed.<br /><br />I tipi di feed che possono essere generati includono ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML e JavaScript. I primi quattro tipi sono per gli aggregatori di feed, mentre JavaScript e HTML hanno lo scopo di consentire l'inclusione dei feed in altre pagine web. Tieni presente che i numeri del feed RSS indicano stili diversi, non una versione diversa.<br /><br />È disponibile un'opzione per selezionare l'autenticazione che accederà all'utente e consentirà all'utente di visualizzare, utilizzando un aggregatore RSS appropriato, tutte le informazioni che potrebbe normalmente visualizzare se ha effettuato l'accesso. L'autenticazione di base utilizza <i>l'autenticazione HTTP di base</i> per accedere all'utente. Miglioramenti futuri potrebbero consentire <i>l'autenticazione del digest</i>.<br /><br />Questo <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='articolo di Wikipedia' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a> contiene informazioni e collegamenti completi su RSS e sui vari formati RSS. <i>L'autenticazione HTTP di base</i> è discussa in questo <a href='https://it.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='articolo di Wikipedia' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a>, mentre <i>l'autenticazione del digest</i> è discussa in questo <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='articolo di Wikipedia' title='articolo di Wikipedia'><b>articolo di Wikipedia</b></a>.";

$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Seleziona i file da caricare nel server dal tuo computer. Tutti i file saranno caricati nella cartella <b>#MEDIA_DIRECTORY#</b> o in una delle sue sottocartelle.<br /><br />I nomi cartella che specificherai saranno aggiunti a <b>#MEDIA_DIRECTORY#</b>. Per esempio, <b>#MEDIA_DIRECTORY#miafamiglia</b>. Se la cartella miniatura non esiste, viene creata automaticamente.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />La tua configurazione GEDCOM consente fino a #GLOBALS[MEDIA_DIRECTORY_LEVELS]# livelli di directory oltre <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predefinito in cui vengono normalmente archiviati i file multimediali caricati. Ciò ti consente di organizzare i tuoi file multimediali e non devi preoccuparti di mantenere nomi univoci per ogni file multimediale.<br /><br />In questo campo specifichi la directory di destinazione sul tuo server in cui i media caricati il file deve essere memorizzato. Assicurati di prestare attenzione alle maiuscole (maiuscole o minuscole) di ciò che inserisci o selezioni qui, poiché i nomi di file e directory fanno distinzione tra maiuscole e minuscole.<br /><br />Se il nome della directory che inserisci qui non esiste, verrà creato automaticamente. Se inserisci più dei #GLOBALS[MEDIA_DIRECTORY_LEVELS]# livelli di directory aggiuntivi consentiti dalla tua configurazione GEDCOM, il tuo input verrà troncato di conseguenza.<br /><br />Le miniature verranno caricate o create in una struttura di directory identica, a partire da <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />In questo campo si specifica la posizione e il nome, sul computer locale, del file multimediale che si desidera caricare sul server. Puoi utilizzare il pulsante <b>Sfoglia</b> per cercare il file desiderato sul tuo computer locale.<br /><br />Il file caricato avrà lo stesso nome sul server e verrà caricato nella directory specificata nel campo <b>#pgv_lang[folder]#</b>.<br /><br />Se non vedi il campo <b>#pgv_lang[folder]#</b> o non puoi modificarlo, non disponi di autorizzazioni sufficienti o la tua configurazione GEDCOM è stata impostata per non consentire livelli di directory oltre il <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predefinito. In questo caso, il file multimediale verrà caricato nella directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />In questo campo si specifica la posizione e il nome, sul computer locale, del file della miniatura che si desidera caricare sul server. È possibile utilizzare il pulsante <b>Sfoglia</b> per cercare il file desiderato nel computer locale. Quando questo campo è compilato, la casella <b>#pgv_lang[auto_thumbnail]#</b> viene ignorata.<br /><br />Se il campo <b>#pgv_lang[media_file]#</b> è stato compilato, il file della miniatura caricato verrà denominato in base al contenuto di quel campo, indipendentemente da come viene chiamato sul computer locale. Se il campo è vuoto, il file di miniatura caricato verrà copiato in due posizioni sul server, una volta nella directory del server menzionata nel campo <b>#pgv_lang[folder]#</b>, e poi di nuovo in una struttura di directory identica a partire da <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Se non vedi il campo <b>#pgv_lang[folder]#</b> o non puoi modificarlo, non hai permessi sufficienti o la tua configurazione GEDCOM è stata impostata per non consentire livelli di directory oltre il <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predefinito in cui sono normalmente archiviati i file multimediali caricati.";


//-- GENERAL
$pgv_lang["help_header"]			= "Informazioni su:";
$pgv_lang["privacy_error_help"]			= "~DETTAGLI PRIVATI~<br /><br />Ci sono diverse possibili ragioni per questo messaggio:<br /><ul><li><b>Le informazioni sulle persone in vita sono impostate su \"Privato\"</b><br />I visitatori e gli utenti registrati che non hanno effettuato l'accesso possono visualizzare le informazioni complete solo per le persone decedute. Se consentito dall'amministratore di sistema, i visitatori possono registrarsi per un account facendo clic sul pulsante Accedi, quindi sul collegamento #pgv_lang[requestaccount]#.<br /></li><li><b>Sei un utente con nome utente e password...</b><br />Ma non hai effettuato l'accesso con successo o sei stato inattivo per un po 'e la tua sessione è scaduta.<br /></li><li><b>A causa della privacy</b><br />La persona non desidera affatto essere mostrata (Nascosta) e potrebbe aver chiesto all'amministratore di impostarla su \"Privato\". La privacy può essere impostata su:<br /><ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Fuori \"Percorso di relazione\"</b><br />Anche se sei un utente normale <u>e</u> hai effettuato l'accesso, può comunque accadere che visualizzi questo messaggio se la persona che stai cercando di visualizzare non è correlata a te entro il numero di passaggi della relazione (Lunghezza percorso relazione) impostato dall'amministratore del sito per questo GEDCOM.<br /><br />Esempi:<br />Quando la lunghezza del percorso di relazione è impostata su <b>1</b>, puoi vedere solo i dettagli della tua famiglia, padre, madre, fratello, sorella (ma non i coniugi e i figli di tuo fratello o tua sorella)<br /><br />Quando il Percorso relazione è impostato su <b>2</b>, puoi anche vedere i dettagli della moglie di tuo fratello e dei loro figli (ma non i coniugi dei loro figli).<br /><br />Maggiore è l'impostazione della lunghezza del percorso di relazione, più parenti remoti puoi vedere.<br /></li></ul><br />Se pensi di essere idoneo per vedere alcuni dettagli nascosti, contatta l'amministratore del sito. Usa il link di contatto in qualsiasi pagina.";
$pgv_lang["more_help"]				= "La guida contestuale è disponibile su ogni schermata; assicurati che l'opzione <b>#pgv_lang[show_context_help]#</b> nel menu Guida sia attiva e fai clic su <b>?</b> accanto all'oggetto.";
$pgv_lang["start_admin_help"]			= "+++ Inizia info amministratore extra +++";
$pgv_lang["end_admin_help"]				= "--- Termina info amministratore extra ---";
$pgv_lang["multiple_help"]			= "<span class='center'>--- Questo è un testo di aiuto generale per più pagine ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>INFORMAZIONE GENERALE</b></div>";
$pgv_lang["best_display_help"]			= "~#pgv_lang[resolution]#~<br /><br />PhpGedView è progettato per una dimensione dello schermo di 1024x768 pixel. Questa dovrebbe essere la dimensione minima per visualizzare tutto correttamente.<br /><br />Se si imposta la dimensione su un valore inferiore (ad esempio 800x600), potrebbe essere necessario eseguire lo scorrimento orizzontale su alcune pagine.";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br /><br />Facendo clic su <b>#pgv_lang[print_preview]#</b> verranno rimossi gli elementi che non hanno un bell'aspetto su una pagina stampata (menu, caselle di input, collegamenti extra, punti interrogativi per la guida contestuale, ecc.)<br /><br />Otterrai un pulsante <b>#pgv_lang[print]#</b> in fondo alla pagina semplificata; quando si fa clic su questo pulsante viene visualizzata la finestra di dialogo di stampa del sistema. Dopo la stampa, fai clic su <b>#pgv_lang[cancel_preview]#</b> e lo schermo verrà ricostruito normalmente.<br /><br />Nota: sebbene questa opzione rimuova molti collegamenti dalla pagina visualizzata, i collegamenti rimanenti sono ancora attivi.";
$pgv_lang["readme_help"]			= "Vedere <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> per ulteriori informazioni.";
$pgv_lang["is_user_help"]			= "--- Questo testo della guida è lo stesso testo letto dai visitatori del sito. ---<br />--- Per risparmiare spazio, non abbiamo creato un testo amministratore speciale per questo elemento. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Quando fai clic su questo collegamento, si aprirà una nuova finestra contenente i dati GEDCOM grezzi dei dettagli in questa pagina.<br /><br />Qui puoi modificare direttamente i dati GEDCOM. Assicurati di inserire dati GEDCOM 5.5.1 validi, poiché non verranno effettuati ulteriori controlli di validità. I dati modificati o aggiunti verranno visualizzati in PhpGedView come \"modifiche\" e devono essere accettati da un utente con diritti di accettazione.";
$pgv_lang["RESN_help_title"]		= "Stabilire restrizioni sui fatti";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />Oltre alle impostazioni generali sulla privacy, PhpGedView ha la capacità di impostare restrizioni sulla visualizzazione e la modifica delle informazioni sui fatti per persone e famiglie. Le restrizioni possono essere impostate da chiunque sia autorizzato a modificare le informazioni, a meno che la privacy o le restrizioni precedentemente impostate non lo vietino.<br /><br />È possibile utilizzare i seguenti valori:<br /><ul><li><b>#pgv_lang[none]#</b><br />Gli amministratori del sito, gli amministratori di GEDCOM e gli utenti che dispongono dei diritti di modifica possono modificare le informazioni. Le informazioni sui fatti possono essere visualizzate in base alle impostazioni sulla privacy applicate dall'amministratore.</li><li><b>#pgv_lang[locked]#</b><br />Questa impostazione non ha alcuna influenza sulla visibilità dei dati dei fatti. Limita i diritti di modifica agli amministratori del sito e agli amministratori GEDCOM. Se le informazioni si applicano all'utente stesso, può anche visualizzarle e, ammesso che disponga dei diritti di modifica, modificarle.</li><li><b>#pgv_lang[privacy]#</b><br />Gli amministratori del sito e gli amministratori GEDCOM possono visualizzare e modificare le informazioni. Se le informazioni si applicano all'utente stesso, può anche visualizzarle e, ammesso che disponga dei diritti di modifica, modificarle. Sarà nascosto a tutti gli altri utenti indipendentemente dal loro stato di accesso.</li><li><b>#pgv_lang[confidential]#</b><br />Solo gli amministratori del sito e gli amministratori GEDCOM possono visualizzare e modificare le informazioni. Sarà nascosto a tutti gli altri utenti indipendentemente dal loro stato di accesso.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Proprietario</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Altri</th></tr><tr><th></th><th></th><th>L</th><th>M</th><th></th><th>L</th><th>M</th><th></th><th>L</th><th>M</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : può leggere</li><li>M : può modificare</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : dipende dalle impostazioni globali sulla privacy</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~#pgv_lang[welcome_page]#~<br /><br />Questa è la pagina di benvenuto. Ti dà il benvenuto al file <a href=\"#def_gedcom\">GEDCOM</a> selezionato. Puoi tornare a questa pagina selezionando Pagina di benvenuto dal menu in alto. Se ci sono più GEDCOM su questo sito, puoi selezionare un GEDCOM dal menu.<br /><br />Questa pagina della Guida contiene informazioni su:<ul><li><a href=\"#index_portal\"><b>Pagina di benvenuto</b></a></li><li><a href=\"#header\"><b>Area dell'intestazione</b></a></li><li><a href=\"#menu\"><b>Menu</b></a></li><li><a href=\"#header_general\"><b>Informazione Generale</b></a></li><li><a href=\"#def\"><b>Definizioni</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class='name_head center'><b>AREA DI INTESTAZIONE</b></div><br />L'intestazione è mostrata nella parte superiore di ogni pagina. L'intestazione contiene alcuni collegamenti utili che puoi utilizzare in tutto il sito.<br /><br />Poiché questo sito può avere un aspetto diverso a seconda del <a href=\"#def_theme\">tema</a> selezionato, le intestazioni possono essere influenzate ei collegamenti possono variare.<br /><br />I link che potresti trovare sono:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Questa casella di ricerca è piccola ma potente. Puoi fare in modo che PhpGedView cerchi quasi tutto per te. Quando fai clic sul pulsante <b>&gt;</b> o <b>Cerca</b>, verrai collegato alla pagina di ricerca per visualizzare i risultati della tua ricerca. Troverai un ampio aiuto sulle opzioni di ricerca nella pagina di ricerca.";
$pgv_lang["header_lang_select_help"]		= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />Una delle caratteristiche più importanti di PhpGedView è che sono supportate più lingue.<br /><br />La lingua in cui PhpGedView visualizza tutte le pagine è determinata automaticamente in base all'impostazione della lingua preferita del browser. Tuttavia, l'amministratore del sito potrebbe aver limitato la disponibilità di alcune lingue.<br /><br />A seconda della configurazione del sito, potresti essere in grado di cambiare la lingua di PhpGedView selezionando una lingua più adatta da un elenco a discesa o facendo clic sull'icona di una bandiera. Se sei un utente registrato, puoi configurare PhpGedView in modo che passi alla tua lingua preferita dopo aver effettuato l'accesso, indipendentemente da ciò su cui è impostato il tuo browser.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />I link utente sono un piccolo blocco con link utili che possono essere trovati nello stesso posto in ogni pagina. La posizione di questi collegamenti varia in base al tema attualmente in vigore.<br /><br />Quando non si è effettuato l'accesso, verrà visualizzato solo il collegamento <b>Accesso</b>. Dopo aver effettuato l'accesso, vedrai:<ul><li><b>Accesso eseguito come (il tuo nome utente)</b>. Facendo clic su quel collegamento ti porterà alla pagina del tuo account.</li><li>Fare clic su <b>Esci</b> per disconnettersi.</li><li>Se disponi dei diritti di amministratore, vedrai anche <b>Amministratore</b>. Facendo clic su questo collegamento si accederà direttamente alla pagina principale di amministrazione.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />L'elenco dei preferiti mostra i preferiti selezionati nella pagina del portale personalizzata. Mostra anche i preferiti che l'amministratore del sito ha selezionato per il GEDCOM attualmente attivo. Facendo clic su una delle voci dei preferiti si accederà direttamente alla pagina #pgv_lang[indi_info]# di quella persona.<br /><br />Ulteriori informazioni sull'aggiunta di Preferiti sono disponibili nella pagina personalizzata del Portale.";
$pgv_lang["header_theme_help"]		= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Quando abilitato dall'amministratore del sito, l'elenco Cambia tema mostra un elenco dei temi che puoi utilizzare per visualizzare il sito.<br /><br />Puoi modificare l'aspetto del sito selezionando un tema dall'elenco. Se hai effettuato l'accesso, cambierà anche il tuo tema utente con quello che hai scelto in modo che il tuo prossimo accesso selezionerà automaticamente lo stesso tema.";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENU</b></div><br />Le intestazioni di pagina hanno menu associati a ciascuna icona di menu.<br /><br /> Quando sposti il puntatore del mouse su un'icona, verrà visualizzato un sottomenu, se presente. Quando fai clic su un'icona, verrai indirizzato alla prima voce del sottomenu.<br /><br />Di solito sono disponibili le seguenti icone di menu:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />Tutti i database genealogici disponibili di questo sito sono elencati in questo menu. Ogni database ha la sua pagina di benvenuto personalizzata, come questa. Se è presente un solo database in questo sito, non è presente alcun sottomenu sotto l'icona della pagina di benvenuto.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Se hai effettuato l'accesso, questo menu può includere le seguenti voci:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Questo ti porta alla tua pagina iniziale personalizzabile.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Puoi modificare i tuoi dati personali qui.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Se hai selezionato una persona Root per questo GEDCOM, questo ti porterà all'albero genealogico di quella persona.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Questo collegamento ti porterà alla tua pagina #pgv_lang[indi_info]#, dove vengono visualizzati tutti i dati genealogici su di te e sulla tua famiglia.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />I grafici disponibili sono:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Questo ti collegherà all'albero genealogico di questo file GEDCOM. Il pedigree inizierà con la persona configurata dall'amministratore. Una volta effettuato l'accesso, la persona iniziale può essere chiunque tu abbia configurato nelle preferenze del tuo account.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Il grafico dei discendenti è essenzialmente un <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> in ordine inverso. Questo confronto non è del tutto corretto, ma mentre l'albero genealogico mostra tutti gli antenati di una persona iniziale, il grafico Discendenza mostra tutti i discendenti di una persona iniziale.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Qui puoi visualizzare gli eventi di una persona lungo una linea temporale. È interessante confrontare gli eventi di due o più persone lungo la stessa linea temporale.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Qui puoi controllare la relazione di una persona con te stesso o con un'altra persona.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Questo grafico è molto simile all'<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, ma con maggiori dettagli e visualizzazioni <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> alternative.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Questo grafico è molto simile all'<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, ma in un modo più grafico.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Sono disponibili i seguenti elenchi:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />In questi due elenchi puoi sfogliare elenchi alfabetici di persone o famiglie in questo GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Questo elemento restituisce un elenco di tutte le fonti utilizzate in GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Qui puoi cercare persone per luogo.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Questa voce di menu viene visualizzata solo se abilitata dall'amministratore del sito. Questo mostrerà i collegamenti a tutti i file multimediali in questo GEDCOM.</li></ul>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />L'#pgv_lang[anniversary_calendar]# mostra gli eventi in un GEDCOM per una determinata data, mese o anno.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Queste voci di menu ti porteranno all'#pgv_lang[anniversary_calendar]# per visualizzare un elenco di tutti gli eventi per il giorno, il mese o l'anno corrente.</li></ul>";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]#~<br /><br />Vedrai questa voce nella barra dei menu solo quando l'amministratore ha abilitato questa funzione.<br /><br />#pgv_lang[clip_cart]# ti consente di memorizzare informazioni su persone, famiglie e fonti in un file temporaneo che potrai successivamente scaricare in formato GEDCOM 5.5.1. ";
$pgv_lang["menu_search_help"]			= "~#pgv_lang[search]#~<br /><br />La pagina di ricerca è una versione più potente della casella di ricerca che puoi trovare nell'intestazione di ciascuna pagina.";
$pgv_lang["menu_help_help"]			= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>LA PAGINA DI BENVENUTO</b></div>";
$pgv_lang["index_portal_help"]			= "La #pgv_lang[welcome_page]# è composta da diversi blocchi separati e può essere personalizzata. Sui siti che hanno più di un database genealogico, potresti vedere una pagina di benvenuto diversa per ciascuno. A seconda di come l'amministratore ha personalizzato il sito, è possibile che nella pagina di benvenuto vengano visualizzati i seguenti blocchi:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Il blocco di benvenuto mostra il titolo del database corrente, la data e l'ora e, se abilitato dall'amministratore, il contatore di visite.<br /><br />Il contatore di visite è disponibile solo nel blocco di benvenuto e sulla pagina #pgv_lang[indi_info]#. Il contatore conta gli \"Visite\" di queste pagine. Ciò significa che conta quante volte queste pagine vengono visitate. Il contatore non controlla l'indirizzo Internet di un visitatore; ogni visita a una pagina da <u>qualsiasi</u> posizione remota conta come un altro hit.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />Puoi accedere a quasi tutte le pagine di questo programma. Di solito lo farai sulla prima pagina, dal momento che puoi accedere alle informazioni privilegiate solo quando sei loggato.<br /><br />Puoi accedere digitando <b>#pgv_lang[username]#</b> e <b>#pgv_lang[password]#</b> e quindi facendo clic sul pulsante <b>#pgv_lang[login]#</b>. ";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Questo blocco mostra gli anniversari di eventi che si verificano nel prossimo futuro.<br /><br />L'amministratore determina quanto lontano sarà il blocco. È possibile perfezionare ulteriormente la visualizzazione del blocco degli eventi imminenti attraverso diverse opzioni di configurazione.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~#pgv_lang[todo_block]#~<br /><br />Questo blocco ti aiuta a tenere traccia delle <b>_TODO</b> attività nel database.<br /><br />Per aggiungere Da fare attività ai tuoi record, potresti prima dover modificare la configurazione GEDCOM in modo che il fatto <b>_TODO</b> sia nell'elenco dei fatti che possono essere aggiunti ai record di persone, famiglie, fonti e archivi. Ciascuno di questi elenchi, che troverai nella sezione Opzioni di modifica della configurazione di GEDCOM, è indipendente. L'ordine delle voci dell'elenco non è importante; è possibile aggiungere le nuove voci all'inizio di ogni elenco.";
$pgv_lang["todo_show_other_help"]     = "Mostra attività assegnati ad altri utenti";
$pgv_lang["todo_show_unassigned_help"]= "Mostra attività che non sono assegnate a nessun utente";
$pgv_lang["todo_show_future_help"]= "Mostra attività che hanno una data futura. In caso contrario, vengono visualizzati solo gli elementi con una data nel passato.";
$pgv_lang["yahrzeit_help"]			="~#pgv_lang[yahrzeit_block]#~<br /><br />Questo blocco mostra gli Yahrzeiten che stanno arrivando nel prossimo futuro.<br /><br />Gli Yahrzeiten (singolare: Yahrzeit) sono gli anniversari della morte di una persona. Questi anniversari sono osservati nella tradizione giudaica; non sono più di uso comune in altre tradizioni. «Yahrzeit» può anche essere scritto «Jahrzeit» o «Yartzeit».<br /><br />L'amministratore determina quanto lontano sarà il blocco. La visualizzazione del blocco dei prossimi Yahrzeiten può essere ulteriormente perfezionata attraverso le opzioni di configurazione.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Immettere il numero di giorni da visualizzare. Questo numero non può essere maggiore di <b>#DAYS_TO_SHOW_LIMIT#</b>. Se inserisci un valore maggiore, verrà utilizzato quel limite.<br /><br />Il limite mostrato è impostato dall'amministratore nella configurazione GEDCOM, sezione Visualizzazione e layout, Nascondi &amp; Mostra sottosezione.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Questa opzione ti consente di determinare il tipo di media da mostrare.<br /><br />Quando selezioni <b>#pgv_lang[random_media_persons]#</b>, verranno mostrati solo i media associati alle persone. Di solito, questa sarebbe la fotografia di una persona. Quando si seleziona <b>#pgv_lang[random_media_events]#</b>, verranno visualizzati solo i media associati a fatti o eventi. Questa potrebbe essere l'immagine di un certificato. Quando selezioni <b>#pgv_lang[all]#</b>, questo blocco mostrerà tutti i tipi di media.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />È possibile limitare ciò che il blocco Media Casuali può mostrare in base al formato e al tipo di elemento multimediale. Quando una determinata casella è selezionata, il blocco Media Casuali può visualizzare elementi multimediali di quel formato o tipo.<br /><br />Si presume che i codici di formato o tipo che esistono nel database ma non sono in questi elenchi la casella corrispondente selezionata. Ad esempio, se il tuo database contiene oggetti Media di formato <b><i>pdf</i></b>, il blocco Media Casuali può sempre visualizzarli. Allo stesso modo, se il tuo database contiene oggetti Media di tipo <b><i>speciale</i></b>, il blocco Media Casuali è sempre autorizzato a visualizzarli.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Questa opzione ti consente di eliminare alcuni eventi datati. Per esempio,#factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, ecc. dovrebbero essere tutti datati.<br /><br />Quando selezioni <b>#pgv_lang[yes]#</b>, verranno visualizzati solo Nascite, Morti e Matrimoni. Quando selezioni <b>#pgv_lang[no]#</b>, verranno visualizzati tutti gli eventi datati.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Questa opzione controlla il modo in cui vengono presentate le informazioni.<br /><br />Quando selezioni <b>#pgv_lang[style1]#</b>, le informazioni vengono visualizzate in forma di testo, in modo simile a ciò che vedi nelle varie caselle del grafico. Questo formato è adatto per i blocchi che vengono stampati sul lato destro della pagina.<br /><br />Quando si seleziona <b>#pgv_lang[style2]#</b>, le informazioni vengono visualizzate in formato tabulare ed è più adatto ai blocchi più grandi che vengono stampati sul lato sinistro della pagina.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Questa opzione controlla la modalità di ordinamento delle informazioni.<br /><br />Quando si seleziona <b>#pgv_lang[by_alpha]#</b>, le informazioni vengono visualizzate in ordine alfabetico. Quando si seleziona <b>#pgv_lang[by_anniv]#</b>, le informazioni vengono ordinate per anniversario, iniziando dagli anniversari più recenti.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Questa opzione controlla se il pulsante per il download degli eventi del calendario viene mostrato agli utenti che hanno effettuato l'accesso. Il file di calendario scaricato può essere importato in programmi compatibili come Microsoft Outlook, ad esempio, per generare promemoria automatici tramite posta elettronica degli anniversari.<br /><br />Quando è impostato su <b>#pgv_lang[no]#</b>, il l'utente connesso non potrà scaricare il file del calendario. Quando impostato su <b>#pgv_lang[yes]#</b>, verrà visualizzato il pulsante Download. Questo pulsante non viene mai mostrato quando l'utente non è connesso.";
$pgv_lang["cal_download_user_help"]			= "Se hai effettuato l'accesso, potresti vedere l'icona <img src='images/ical.png' alt='' />. Se fai clic sull'icona, scaricherai gli eventi come file di calendario, che può essere importato in programmi compatibili come Microsoft Outlook per, ad esempio, generare promemoria automatici via e-mail degli anniversari.<br /><br />Se sei loggato e non vedi questa icona, l'amministratore ha disabilitato questa funzione. I visitatori che non hanno effettuato l'accesso non vedranno questa icona e non potranno scaricare il file del calendario.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br /><br />Questo blocco consente di visualizzare un albero genealogico, una discendenza o un grafico a clessidra nella pagina di benvenuto o in MyGedView. A causa dei limiti di spazio, i grafici devono essere posizionati solo sul lato sinistro della pagina.<br /><br />Quando questo blocco viene visualizzato nella pagina di benvenuto, la persona principale e il tipo di grafico da visualizzare sono determinati da l'amministratore. Quando questo blocco viene visualizzato nella pagina MyGedView personalizzata dell'utente, queste opzioni sono determinate dall'utente.<br /><br />Il comportamento di questi grafici è identico al loro comportamento quando vengono richiamati dai menu. Fare clic sulla casella di una persona per vedere maggiori dettagli su di loro.";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[todays_events_block]#~<br /><br />Questo blocco è simile al blocco #pgv_lang[upcoming_events_block]#, tranne per il fatto che mostra gli eventi di oggi.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Questo blocco è molto simile al blocco #pgv_lang[user_favorites_block]# della pagina #pgv_lang[mygedview]#. A differenza della configurazione della pagina del portale, solo l'amministratore o un utente con diritti di amministratore può modificare l'elenco dei preferiti in questo blocco.<br /><br />Lo scopo di questo blocco è attirare l'attenzione del visitatore su persone di particolare interesse. I preferiti di questo GEDCOM possono essere selezionati da un elenco nell'intestazione di ogni pagina.<br /><br />Quando fai clic su uno dei preferiti del sito elencati, verrai indirizzato alla pagina #pgv_lang[indi_info]# di quella persona.";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br /><br />Questo modulo consente di aggiungere un nuovo elemento preferito all'elenco dei preferiti.<br /><br />È necessario immettere un identificatore per la persona, la famiglia o la fonte che si desidera memorizzare come preferito, oppure è necessario inserirlo un URL e un titolo. Il campo Nota è facoltativo e può essere utilizzato per descrivere il preferito. Tutto ciò che è inserito nel campo Nota verrà visualizzato nel blocco Preferiti dopo l'elemento.";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats_block]#~<br /><br />In questo blocco vedrai alcune statistiche sul file GEDCOM corrente. Se hai bisogno di più informazioni di quelle elencate, invia un messaggio al contatto in fondo alla pagina.";
$pgv_lang["index_common_names_help"]		= "~#pgv_lang[block_top10]#~<br /><br />Questo blocco elencherà i cognomi più frequenti, con un conteggio per ciascuno. Se fai clic su un nome, verrai reindirizzato all'elenco Persone, già filtrato in base al nome su cui hai fatto clic.<br /><br />L'amministratore determina quanti nomi vengono effettivamente visualizzati.";
$pgv_lang["index_common_given_names_help"]		= "~#pgv_lang[block_givn_top10]#~<br /><br />Questo blocco elencherà i nomi dati che si verificano più di frequente. Mostra nomi maschili e femminili in colonne. Una terza colonna apparirà quando ci sono persone di cui non si conosce il sesso.<br /><br />L'amministratore determina quanti nomi sono effettivamente mostrati.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />In questo blocco PhpGedView sceglie casualmente un file multimediale da mostrarti ad ogni visita a questa pagina.<br /><br />Quando fai clic sull'immagine, vedrai la sua versione a grandezza naturale. Sotto l'immagine hai un collegamento alla persona associata all'immagine. Quando fai clic sulla didascalia dell'immagine, vedrai l'immagine sulla pagina #pgv_lang[media_list]#. Quando fai clic sul nome della persona, verrai indirizzato alla pagina #pgv_lang[indi_info]# di quella persona.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Questo blocco ti mostrerà gli utenti attualmente loggati.<br /><br />Se non sei un amministratore, la tua visualizzazione degli utenti loggati è limitata a coloro che hanno scelto di essere visibili mentre sono in linea. Perché funzioni, devi anche scegliere di essere visibile mentre sei in linea. Gli utenti in linea che ti sono invisibili vengono considerati anonimi.";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br /><br />Il blocco delle notizie è come una bacheca per questo GEDCOM. L'amministratore del sito può inserire qui annunci importanti o messaggi di notizie interessanti.<br /><br />Se hai qualcosa di interessante da mostrare, contatta l'amministratore del sito; lui può mettere il tuo messaggio in questa bacheca.";
$pgv_lang["recent_changes_help"]			= "~#pgv_lang[recent_changes_block]#~<br /><br />Questo blocco mostra le modifiche più recenti al GEDCOM registrate dal tag CHAN.";
$pgv_lang["gedcom_news_limit_help"]		= "Puoi limitare il numero di articoli di notizie visualizzati, riducendo così l'altezza del blocco di notizie di GEDCOM.<br /><br />Questa opzione determina se applicare dei limiti o se il limite deve essere in base all'età dell'articolo o in base al numero di articoli.";
$pgv_lang["gedcom_news_flag_help"]		= "Immettere qui il valore limite.<br /><br />Se si è scelto di limitare la visualizzazione degli articoli di notizie in base all'età, qualsiasi articolo più vecchio del numero di giorni qui immesso verrà nascosto alla visualizzazione. Se si è scelto di limitare la visualizzazione degli articoli di notizie in base al numero, verrà visualizzato solo il numero specificato di articoli recenti, ordinato per età. Gli articoli rimanenti verranno nascosti alla vista.<br /><br />Gli zeri inseriti qui disabiliteranno il limite, facendo sì che tutti gli articoli di notizie vengano visualizzati.";
$pgv_lang["gedcom_news_archive_help"]	= "Per ridurre l'altezza del blocco delle notizie, l'amministratore ha nascosto alcuni articoli. Puoi rivelare questi articoli nascosti facendo clic sul collegamento <b>#pgv_lang[gedcom_news_archive]#</b>.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Questo blocco consente all'amministratore di aggiungere informazioni alla pagina di benvenuto o al portale. Il suo scopo è simile ai blocchi #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, e #pgv_lang[gedcom_stats_block]#, ma l'amministratore ha un maggiore controllo sul suo aspetto.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />Questo testo dovrebbe essere vuoto o molto breve. Quando è vuoto, il blocco HTML avanzato verrà visualizzato nella pagina Indice o Portale come un blocco semplice, proprio come fa il blocco HTML. Quando è presente del testo, il blocco HTML avanzato verrà visualizzato come tutti gli altri blocchi, completo di una barra del titolo del blocco contenente il testo immesso qui.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Per aiutarti a iniziare con questo blocco, abbiamo creato diversi modelli standard. Quando selezioni uno di questi modelli, l'area di testo conterrà una copia che potrai quindi modificare per adattarla ai requisiti del tuo sito.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />A differenza dei blocchi #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, e #pgv_lang[gedcom_stats_block]#, hai il pieno controllo sull'aspetto del tuo blocco. È possibile utilizzare tag HTML e il blocco utilizza i fogli di stile CSS del tema attualmente attivo. I riferimenti alle informazioni dal database genealogico attualmente attivo possono essere inclusi nel testo.<br /><br />I riferimenti al database vengono segnalati nel testo racchiudendo le parole chiave all'interno di simboli <b>&#35;</b> accoppiati. Ad esempio, <b>&#35;totalFamilies&#35;</b rappresenta il numero di famiglie nel database. A volte, potresti voler usare un riferimento al database come testo invece del suo vero significato. Per fare ciò, è necessario sostituire i simboli <b>&#35;</b> che racchiudono la parola chiave con il loro equivalente simbolico. Ad esempio, se il tuo testo contiene <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b>, verrà stampato come <b>&#35;totalFamilies&#35;</b> invece di diventare un riferimento al database.<br /><br />Per un esempio completo dell'uso di questo blocco, esamina il modello &quot;#pgv_lang[gedcom_stats_block]#&quot; che si trova nella directory blocks/ , utilizza la maggior parte degli stili di tag, inclusa la lingua e i link di testo della guida.<br /><br />Il modello <b>#pgv_lang[htmlplus_block_keyword]#</b> contiene un elenco completo di tutte le parole chiave supportate.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Abilita la compatibilità con le versioni precedenti di questo blocco. Se selezionata, verranno riconosciute sia le parole chiave vecchie che quelle nuove.<br /><br /> Ad esempio, il testo <b>&#35;TOTAL_FAM&#35;</b> verrà riconosciuto come equivalente a <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> a <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> a <b>&#35;topTenLargestFamily&#35;</b>, ecc.<br /><br />A meno che non sia assolutamente necessario, non utilizzare la modalità di compatibilità.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Seleziona il database a cui applicare le parole chiave.<br /><br /> Il tuo sito supporta diversi database. Parole chiave come <b>&#35;totalFamilies&#35;</b> possono fare riferimento a un solo database. È possibile identificare il database che deve essere consultato per tutte queste parole chiave. Ogni blocco #pgv_lang[htmlplus_block_name]# può accedere a un solo database.";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br /><br />Nasconde o mostra l'elenco dei nomi dati di persone di sesso sconosciuto.<br /><br /> Il blocco #pgv_lang[block_givn_top10]# nasconde sempre l'elenco dei nomi dati quando non esistono persone di quel genere nel database. Questa opzione ti consente di nascondere l'elenco delle persone di sesso sconosciuto anche quando ci sono tali persone nel tuo database.";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Naturalmente, l'ideale sarebbe creare un programma così semplice e facile da usare da non aver bisogno di alcuna spiegazione; dovrebbe essere semplice come leggere un libro.<br /><br />Sebbene PhpGedView sia molto complicato, non dovresti notarlo mentre lo usi; quasi tutto può essere utilizzato senza spiegazioni. Tuttavia, poiché potremmo avere molti visitatori e utenti che non hanno molta esperienza con l'uso di un computer o con Internet, ti offriamo un aiuto in alcuni luoghi.<br /><br />Troverai quanto segue voci nel menu del aiuto:";
$pgv_lang["help_page_help"]			= "<ul><li><b>Aiuto con questa pagina</b><br />Per tutte le pagine è disponibile un \"Aiuto Pagina\" generale. Puoi fare clic su questa voce nel menu per ottenere \"Aiuto pagina\", dove sarai informato sugli elementi in quella stessa pagina.<br /><br />L'aiuto della pagina è spesso breve. Se hai bisogno di più aiuto o informazioni su un determinato elemento della pagina rispetto a quello fornito dalla Guida in linea, puoi utilizzare la funzione \"Aiuto contestual\".</li></ul>";
$pgv_lang["help_content_help"]		= "<ul><li><b>Contenuti della guida</b><br />Quando si fa clic su questa voce di menu, verrà visualizzata una pagina della guida che mostra un indice dei principali argomenti della guida. La quantità di informazioni di aiuto disponibili sarà aumentata se il tempo lo permetterà.</li></ul>";
$pgv_lang["help_faq_help"]			= "<ul><li><b>FAQ List</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]			= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]			= "<ul><li><b>Nascondi / Mostra la Guida contestuale</b><br />Quest'ultima voce di menu potrebbe essere la più utile per te. Facendo clic su questo collegamento si attiva o si disattiva la \"Guida contestuale\".<br /><br />Con la Guida contestuale attivata, è possibile trovare un punto interrogativo o un'icona simile accanto ad alcuni collegamenti, caselle a discesa o pulsanti. Quando si fa clic su questa icona, verrà visualizzata una schermata della Guida. Questa schermata della Guida contiene informazioni su quell'oggetto.<br /><br />Ovviamente, quando fai clic su \"Nascondi Guida contestuale\", tutti i punti interrogativi o le icone scompaiono finché non fai clic su \"Mostra ....\" ancora.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Di seguito sono riportate alcune spiegazioni dei termini utilizzati in questo testo della Guida:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF file format</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Theme</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Portale~<br /><br />Il portale di questo sito è come l'atrio di un ristorante o di una biblioteca pubblica. È il luogo in cui entri, ma puoi anche trovare informazioni importanti come spiegazioni, menu ecc.";
$pgv_lang["def_gedcom_help"]			= "~File GEDCOM~<br /><br />Una citazione dall'Introduzione allo standard GEDCOM 5.5.1 (in inglese):<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />La traduzione italiana:<div class=\"list_value_wrap\">GEDCOM è stato sviluppato dal Dipartimento di storia familiare della Chiesa di Gesù Cristo dei Santi degli Ultimi Giorni (Chiesa SUG) per fornire un formato flessibile e uniforme per lo scambio di dati genealogici computerizzati.&nbsp; GEDCOM è l'acronimo di <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (italiano: Comunicazione genealogica dei dati).&nbsp; Il suo scopo è promuovere la condivisione di informazioni genealogiche e lo sviluppo di un'ampia gamma di prodotti software interoperabili per assistere genealogisti, storici e altri ricercatori.</div><br />Una copia dello standard GEDCOM 5.5.1 <u>bozza</u>, a cui aderisce PhpGedView, può essere scaricata in formato PDF qui:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Questo standard è disponibile solo in inglese.<br /><br />Il file GEDCOM contiene tutte le informazioni sulla famiglia. Tutti i fatti, le date, gli eventi, ecc. sono memorizzati qui. I file GEDCOM devono seguire regole rigide perché devono essere scambiabili tra molti programmi, indipendentemente dalle piattaforme o dai sistemi operativi.";
$pgv_lang["def_gedcom_date_help"]		= "~Date in un file GEDCOM~<br /><br />Sebbene il campo della data consenta l'immissione in formato libero (il che significa che puoi digitare quello che vuoi), ci sono alcune regole su come inserire le date secondo lo standard GEDCOM 5.5.1.<ul><li>Una data completa viene inserita <u>in inglese</u> nel formato GG MMM AAAA. Ad esempio, <b>01&nbsp;MAR&nbsp;1801</b> o <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Se ti manca una parte della data, puoi omettere quella parte. Esempio: <b>MAR&nbsp;1801</b> o <b>14&nbsp;DEC</b>.</li><li>Se non sei sicuro o la data non è confermata, puoi entrare <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = circa), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = prima), <b>AFT&nbsp;1949</b> (aft = after = dopo)</li><li>Gli intervalli di date vengono inseriti <u>in inglese</u> come <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> o come <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = fra)<br /><br /><b>FROM</b> indica che l'evento descritto è accaduto continuamente tra le date indicate e viene utilizzato con eventi come l'occupazione. <b>BET</b> indica una singola occorrenza dell'evento, a volte tra le date indicate e viene utilizzato con eventi come la nascita.<br /><br />Le date imprecise, in cui manca il giorno del mese o il mese, vengono sempre interpretate come la prima o l'ultima data possibile, a seconda che tale data imprecisa si trovi prima o dopo la parola chiave di separazione. Per esempio, <b>FEB&nbsp;1804</b> è interpretato come <b>01&nbsp;FEB&nbsp;1804</b> quando si verifica prima di TO o AND e come <b>29&nbsp;FEB&nbsp;1804</b> quando si verifica dopo TO o AND.</li></ul><br /><b>Assicurati di inserire date e abbreviazioni in <u>inglese</u>,</b> perché allora il file GEDCOM è scambiabile e PhpGedView può tradurre tutte le date e le abbreviazioni correttamente nella lingua attualmente attiva. Inoltre, PhpGedView esegue calcoli utilizzando queste date. Se vengono inserite date improprie nei campi della data, PhpGedView non sarà in grado di calcolarle correttamente.<br /><br />Puoi fare clic sull'icona del calendario per aiuto nella selezione di una data.<br /><br />Vengono utilizzate le seguenti abbreviazioni:<ul><li>JAN = January = Gennaio</li><li>FEB = February = Febbraio</li><li>MAR = March = Marzo</li><li>APR = April = Aprile</li><li>MAY = Maggio</li><li>JUN = June = Giugno</li><li>JUL = July = Luglio</li><li>AUG = August = Agosto</li><li>SEP = September = Settembre</li><li>OCT = October = Ottobre</li><li>NOV = November = Novembre</li><li>DEC = December = Dicembre</li><li>bef = before = prima</li><li>abt = about = circa</li><li>aft = after = dopo</li></ul>";
$pgv_lang["def_gramps_help"]		= "~File di database XML GRAMPS~<br /><br />Una citazione dal progetto GRAMPS: <div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Traduzione in italiano: <div class=\"list_value_wrap\">GRAMPS ti aiuta a tenere traccia del tuo albero genealogico. Ti consente di memorizzare, modificare e ricercare dati genealogici. GRAMPS cerca di fornire tutte le funzionalità comuni di altri programmi genealogici, ma, cosa più importante, di fornire una capacità aggiuntiva di integrazione non comune a questi programmi. Questa è la capacità di inserire qualsiasi bit e pezzo di informazione direttamente in GRAMPS e riorganizzare / manipolare qualsiasi / tutti gli eventi di dati nell'intero database (in qualsiasi ordine o sequenza) per assistere l'utente nel fare ricerca, analisi e correlazione con il potenziale di colmare le lacune nelle relazioni.</div><br />Una copia del formato XML GRAMPS v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">può essere trovata qui</a> sia in formato RELAX NG Schema che in formato DTD.<br /><br />Per ulteriori informazioni sul progetto GRAMPS, visitare <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br /><br />PhpGedView (o PGV) non mette solo pagine statiche sul Web; è dinamico e può essere personalizzato in molti modi.<br /><br />PhpGedView è stato creato da John Finlay per visualizzare i file GEDCOM online. John ha iniziato a sviluppare il programma da solo. Da allora si è unito a lui un team internazionale di sviluppatori e traduttori che sta lavorando per migliorare il programma. Tra le caratteristiche più significative che sono state aggiunte o migliorate nel programma vi sono il suo ampio supporto di lingue diverse dall'inglese e la possibilità di aggiungere e modificare eventi online.";
$pgv_lang["def_theme_help"]			= "~Tema~<br /><br />Questo sito può avere diversi \"aspetti\", chiamati Temi.<br /><br />L'amministratore del sito sceglie un tema predefinito, che tutti coloro che accedono a questo sito vedranno inizialmente. Quando l'amministratore ha abilitato questa funzione, tutti gli utenti possono selezionare i propri temi. PhpGedView ricorda l'ultimo tema selezionato per ogni utente connesso, in modo che l'utente vedrà automaticamente quel tema la prossima volta che accede. I temi possono essere usati come un modo per distinguere tra diversi database sullo stesso sito. Ogni database può avere un tema predefinito diverso.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br /><br />Questa è la tua pagina personale #pgv_lang[mgv]#.<br /><br />Qui troverai facili collegamenti per accedere ai tuoi dati personali come <b>mio account</b>, <b>miei dati</b> la tua pagina #pgv_lang[indi_info]#) e <b>mio pedigree</b>. Puoi avere blocchi con <b>Messaggi</b>, un <b>Diario</b> (come un Blocco note) e molti altri.<br /><br />Il layout di questa pagina è simile al pagina Benvenuto che vedi quando accedi per la prima volta a questo sito. Sebbene le parti della pagina di benvenuto siano selezionate dall'amministratore del sito, è possibile selezionare quali parti includere in questa pagina personalizzata. Troverai il collegamento per personalizzare questa pagina nel blocco di benvenuto o separatamente quando il blocco di benvenuto non è presente.<br /><br />Puoi scegliere tra i seguenti blocchi e collegamenti:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Personalizza «#pgv_lang[mygedview]#»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]		= "~PERSONALIZZARE #pgv_lang[mygedview]#~<br /><br />Quando sei entrato qui per la prima volta, avevi già alcuni blocchi in questa pagina. Se lo desideri, puoi personalizzare questa pagina del portale.<br /><br /> Quando fai clic su questo link verrai indirizzato a un modulo in cui puoi aggiungere, spostare o eliminare blocchi. Ulteriori spiegazioni sono disponibili su quel modulo.";
$pgv_lang["mygedview_message_help"]		= "~#pgv_lang[user_messages_block]#~<br /><br />In questo blocco troverai i messaggi che ti vengono inviati da altri utenti o dall'amministratore. Anche tu puoi inviare messaggi ad altri utenti o all'amministratore.<br /><br />Il sistema di posta PhpGedView è progettato per proteggere la tua privacy. Non è necessario lasciare il tuo indirizzo email qui e gli altri non saranno in grado di vedere il tuo indirizzo email.<br /><br />Per espandere un messaggio, fai clic sull'oggetto del messaggio o sul <b>+</b> accanto al simbolo. Puoi eliminare più messaggi selezionando le caselle accanto ai messaggi che desideri eliminare e facendo clic sul pulsante <b>Elimina messaggi selezionati</b>.";
$pgv_lang["mygedview_favorites_help"]		= "~#pgv_lang[user_favorites_block]#~<br /><br />I preferiti sono simili ai segnalibri.<br /><br />Supponi di avere qualcuno nell'albero genealogico di cui desideri controllare regolarmente i dati. Vai alla pagina #pgv_lang[indi_info]# della persona e seleziona l'opzione <b>Aggiungi a Preferiti</b> dall'elenco Preferiti. Questa persona è ora contrassegnata dal libro e aggiunta al tuo elenco di preferiti.<br /><br />Ovunque ti trovi su questo sito, puoi fare clic su un nome nell'elenco a discesa \"Preferiti\" nell'intestazione. Questo ti porterà alla pagina #pgv_lang[indi_info]# di quella persona.";
$pgv_lang["mygedview_myjournal_help"]		= "~#pgv_lang[user_news_block]#~<br /><br />Puoi usare questo diario per scrivere note o promemoria per uso personale. Quando prendi una nota di questo tipo, sarà ancora lì la prossima volta che visiti il sito.<br /><br />Queste note sono private e non saranno visibili agli altri.";
$pgv_lang["mygedview_welcome_help"]		= "~#pgv_lang[welcome_block]#~<br /><br />Il blocco benvenuto mostra:<ul><li>Il file GEDCOM corrente</li><li>La data e l'ora</li><li>Collegamenti a:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Nota:</b><br />Vedrai i link a <b>#pgv_lang[my_indi]#</b> e <b>#pgv_lang[my_pedigree]#</b> solo se conosci il file GEDCOM corrente, mentre in un altro file GEDCOM non hai un record e di conseguenza questi link sono non visualizzato.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~LA PAGINA PEDIGREE~<br /><br />Un pedigree è un'enumerazione di tutti gli antenati della persona iniziale. Gli utenti che non hanno effettuato l'accesso vedono il pedigree della persona iniziale (root) scelta dall'amministratore del sito. Gli utenti che hanno eseguito l'accesso possono selezionare la propria persona (root) iniziale.<br /><br />In questo contesto, \"Tutti gli antenati\" indica il padre e la madre, i loro genitori e così via. Il pedigree viene visualizzato graficamente; non devi lottare tra le pagine di testo per determinare i tuoi antenati.<br /><br />Tutte le persone vengono visualizzate nelle caselle Nome sullo schermo.<br /><ul><li><b>Caselle dei nomi sul pedigree</b><br />Se la pagina dell'albero genealogico è impostata per mostrare i dettagli, vedrai il nome della persona e le date di nascita e morte. Puoi fare clic sul nome di una persona per portarti direttamente alla pagina #pgv_lang[indi_info]# di quella persona.<br /><br />Quando <b>Mostra dettagli</b> è attivo, ci sono due icone all'interno della casella del nome.</li><li><b>Icona dell'albero genealogico nella casella Nome</b><br />Quando l'opzione <b>Mostra dettagli</b> è attiva, vedrai un'icona dell'albero genealogico nella casella Nome. A seconda delle impostazioni del sito, devi passare il mouse sull'icona o fare clic su di essa. Quando si fa clic su o si passa con il mouse su questa icona, viene visualizzato un piccolo sottomenu.<br /><br />Le voci <b>#pgv_lang[index_header]#</b> e <b>#pgv_lang[descend_chart]#</b> sono simili a quelle del menu principale, ma la differenza è che la persona iniziale è ora la persona menzionata nella casella Nome. Vedi anche <b>#pgv_lang[as_spouse]#</b>. Sotto vedrai il nome del coniuge seguito dai nomi dei figli. Tutti i nomi sono selezionabili.</li><li><b>Lente d'ingrandimento all'interno della casella Nome</b><br />A seconda delle impostazioni del sito, devi passare il mouse sull'icona o fare clic su di essa. Ciò ingrandisce la casella Nome in modo da visualizzare più dettagli. Vedrai più date ed eventi. I nomi sono cliccabili.</li><li><b>Frecce</b><br />A sinistra oa destra delle caselle Nome più a sinistra o più a destra potresti vedere delle frecce. Quando si fa clic su queste frecce, la visualizzazione dello schermo si sposterà nella direzione della freccia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]			= "~#pgv_lang[show_details]#~<br /><br />Con questa opzione puoi mostrare o nascondere tutti i dettagli nelle caselle Nome. È possibile visualizzare più caselle su una schermata quando i dettagli sono nascosti.<br /><br />Quando tutti i dettagli sono nascosti, l'icona Zoom descritta di seguito non viene visualizzata. Tuttavia, se l'amministratore ha abilitato la funzione Zoom, l'intera scatola agirà come un'icona Zoom per rivelare tutti i dettagli sulla persona.<br /><br />Quando i dettagli non sono nascosti e la funzione Zoom, identificata da un'icona a forma di lente di ingrandimento, è stata abilitata dall'amministratore, è possibile rivelare ancora più dettagli su quella persona. Se normalmente devi fare clic sull'icona Zoom per ingrandire, puoi rivelare ulteriori dettagli nascosti facendo clic su quell'icona qui. Allo stesso modo, se puoi ingrandire passando il mouse sopra l'icona Zoom, i dettagli nascosti verranno rivelati passando con il mouse sopra quell'icona qui.<br /><br />Se hai fatto clic sull'icona Zoom per rivelare ulteriori dettagli, puoi ripristinare la casella al suo normale livello di dettaglio facendo nuovamente clic sull'icona Zoom. Se hai rivelato più dettagli semplicemente spostando il puntatore del mouse sull'icona Zoom, la casella verrà ripristinata al suo normale livello di dettaglio quando allontani il puntatore del mouse dall'icona Zoom.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Con questa opzione si determina l'orientamento del layout di pagina.<br /><br />La modifica di questa impostazione potrebbe essere utile se si desidera eseguire una serigrafia o se si dispone di un diverso tipo di schermo.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;renderà l'albero più alto, in modo tale che un grafico di 4 generazioni dovrebbe stare su una singola pagina stampata verticalmente.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;creerà un albero più ampio che dovrebbe essere stampato su una singola pagina stampata orizzontalmente.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;ruota il grafico, ma non le sue caselle, di 90 gradi in senso antiorario, in modo che la generazione più vecchia si trovi nella parte superiore del grafico.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;ruota il grafico, ma non le sue caselle, di 90 gradi in senso orario, in modo che la generazione più vecchia si trovi nella parte inferiore del grafico.</li></ul>";
$pgv_lang["rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Se desideri visualizzare un grafico con una nuova persona iniziale (root), l'identificatore di quella nuova persona iniziale viene digitato qui.<br /><br />Se non conosci l'identificativo di quella persona, usa il link <b>Trova l'identificatore</b>.<br /><br /><b>NUMERO IDENTIFICATIVO</b><br />I numeri utilizzati all'interno di PhpGedView <u>non</u> sono i numeri di identificazione emessi da vari governi (patente di guida o numeri di passaporto, ad esempio). Il numero a cui si fa riferimento qui è semplicemente un numero utilizzato all'interno del database per identificare in modo univoco ogni persona; è stato assegnato dal programma di ascendenza che ha creato il file GEDCOM che è stato importato in PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~#pgv_lang[generations]#~<br /><br />Qui puoi impostare il numero di generazioni da visualizzare in questa pagina.<br /><br />Il numero giusto per te dipende dalle dimensioni dello schermo e dal fatto che tu mostri i dettagli o meno. Il tempo di elaborazione aumenterà all'aumentare del numero di generazioni.";

//-- LOGIN-page
$pgv_lang["login_page_help"]		= "~#pgv_lang[login]#~<br /><br />In questa pagina puoi effettuare il login, richiedere una nuova password o richiedere un nuovo account utente.";
$pgv_lang["username_help"]			= "~#pgv_lang[username]#~<br /><br />In questa casella inserisci il tuo nome utente.<br /><br /><b>Il nome utente fa distinzione tra maiuscole e minuscole.</b> Ciò significa che <b>MioNome</b> è <u>non</u> uguale a <b>mionome</b> o <b>MIONOME</b>.";
$pgv_lang["password_help"]			= "~#pgv_lang[password]#~<br /><br />In questa casella digiti la tua password.<br /><br /><b>La password fa distinzione tra maiuscole e minuscole.</b> Ciò significa che <b>MiaPassword</b> <u>non</u> è uguale a <b>miapassword</b> o <b>MIAPASSWORD</b>.";
$pgv_lang["login_buttons_help"]			= "~PULSANTE LOGIN~<br /><br />Qui viene visualizzato un pulsante per accedere al sistema.<br /><br />Se fai clic su questo pulsante, tornerai alla pagina in cui ti trovavi, ma con i diritti di accesso registrati.<br /><br />Ad esempio, se fai clic su <b>#pgv_lang[login]#</b> quando eri nella pagina Pedigree, tornerai alla stessa pagina. Se fai clic su questo pulsante quando sei nella pagina principale di benvenuto, verrai indirizzato alla pagina «#pgv_lang[mygedview]#», dove potrai modificare le tue impostazioni, aggiungere o modificare i preferiti, inviare e leggere messaggi, ecc.";
$pgv_lang["login_buttons_aut_help"]		= "~PULSANTE LOGIN~<br /><br />Qui vedrai un pulsante per accedere al sistema.<br /><br />Se fai clic su questo pulsante, effettuerai l'accesso e andrai direttamente alla tua pagina «#pgv_lang[mygedview]#», dove potrai modificare le tue impostazioni, aggiungere o modificare i preferiti, inviare e leggere messaggi, ecc.";
$pgv_lang["new_password_help"]			= "~#pgv_lang[requestpassword]#~<br /><br />Se hai dimenticato la password, puoi fare clic su questo collegamento per richiedere una nuova password.<br /><br />Verrai indirizzato alla pagina «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]			= "~#pgv_lang[requestaccount]#~<br /><br />Se sei un visitatore di questo sito e desideri richiedere un account utente, puoi fare clic su questo collegamento.<br /><br />A seconda di come l'amministratore ha impostato il sito, il tuo client di posta elettronica potrebbe essere avviato in modo che puoi inviare un'e-mail all'amministratore per richiedere un nuovo ID di accesso, oppure potresti essere indirizzato alla pagina «#pgv_lang[requestaccount]#».";
$pgv_lang["mygedview_login_help"]		= "Per accedere alla pagina «#pgv_lang[mygedview]#», devi essere un utente registrato nel sistema. In questa pagina puoi aggiungere ai preferiti le tue persone preferite, tenere un diario utente, gestire i messaggi, vedere altri utenti che hanno effettuato l'accesso e personalizzare vari aspetti delle pagine di PhpGedView.<br /><br />Inserisci il tuo nome utente e la password nei campi appropriati per accedere a «#pgv_lang[mygedview]#».";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In questa casella devi digitare il tuo nome.<br /><br />Abbiamo bisogno del tuo nome e cognome per determinare se sei idoneo per un account su questo sito e quali dovrebbero essere i tuoi diritti. Questi nomi saranno visibili ad altri membri e utenti della famiglia che hanno effettuato l'accesso.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />In questa casella devi digitare il tuo cognome.<br /><br />Abbiamo bisogno del tuo nome e cognome per determinare se sei idoneo per un account su questo sito e quali dovrebbero essere i tuoi diritti. Questi nomi saranno visibili ad altri membri e utenti della famiglia che hanno effettuato l'accesso.";
$pgv_lang["register_info_01"]		= "~#pgv_lang[requestaccount]#~<br /><br />La quantità di dati che possono essere visualizzati pubblicamente su questo sito Web può essere limitata a causa della legge applicabile in materia di protezione della privacy. Molte persone non vogliono che i propri dati personali siano disponibili pubblicamente su Internet. I dati personali potrebbero essere utilizzati in modo improprio per spam o furto di identità.<br /><br />L'accesso a questo sito è consentito a tutti i visitatori che dispongono di un account utente. Dopo che l'amministratore ha verificato e approvato la tua richiesta di account, sarai in grado di accedere.<br /><br />Se la Privacy per le relazioni è stata attivata, potrai accedere alle informazioni private dei tuoi parenti stretti solo dopo aver effettuato l'accesso. L'amministratore può anche consentire la modifica del database per determinati utenti, in modo che possano modificare o aggiungere informazioni.<br /><br />Se hai bisogno di ulteriore supporto, utilizza il link sottostante per contattare l'amministratore.";
$pgv_lang["register_info_02"]		= "~#pgv_lang[requestaccount]#~<br /><br />La quantità di dati che possono essere visualizzati pubblicamente su questo sito Web può essere limitata a causa della legge applicabile in materia di protezione della privacy. Molte persone non vogliono che i propri dati personali siano disponibili pubblicamente su Internet. I dati personali potrebbero essere utilizzati in modo improprio per spam o furto di identità.<br /><br />L'accesso a questo sito è consentito solo agli utenti <u>autorizzati</u>. Dopo che l'amministratore ha verificato e approvato la tua richiesta di account, sarai in grado di accedere e visualizzare i dati privati.<br /><br />Se la Privacy per le relazioni è stata attivata, potrai accedere solo al privato dei tuoi parenti stretti informazioni dopo l'accesso. L'amministratore può anche consentire la modifica del database per determinati utenti, in modo che possano modificare o aggiungere informazioni.<br /><br />Se hai bisogno di ulteriore supporto, utilizza il link sottostante per contattare l'amministratore.";
$pgv_lang["register_info_03"]		= "~#pgv_lang[requestaccount]#~<br /><br />La quantità di dati che possono essere visualizzati pubblicamente su questo sito Web può essere limitata a causa della legge applicabile in materia di protezione della privacy. Molte persone non vogliono che i propri dati personali siano disponibili pubblicamente su Internet. I dati personali potrebbero essere utilizzati in modo improprio per spam o furto di identità.<br /><br />L'accesso a questo sito è consentito <u>solo ai membri della famiglia</u>. Dopo che l'amministratore ha verificato e approvato la tua richiesta di account, sarai in grado di accedere e visualizzare i dati privati.<br /><br />Se la Privacy per le relazioni è stata attivata, potrai accedere solo al privato dei tuoi parenti stretti informazioni dopo l'accesso. L'amministratore può anche consentire la modifica del database per determinati utenti, in modo che possano modificare o aggiungere informazioni.<br /><br />Se hai bisogno di ulteriore supporto, utilizza il link sottostante per contattare l'amministratore.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Questa pagina mostrerà i discendenti di una persona.<br /><br />Puoi scegliere una persona iniziale (radice) per questo diagramma di discendenza o puoi essere collegato a questa pagina facendo clic sul collegamento <b>#pgv_lang[descend_chart]#</b> in un'altra pagina. Fare clic sulle icone delle frecce per navigare in questo albero nella direzione della freccia. Fare clic sull'icona Grafico in qualsiasi casella Persona per modificare la radice dell'albero in quella persona.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br /><br />In questo grafico puoi visualizzare una o più persone lungo una linea temporale orizzontale. Questo grafico ti consente di vedere come le vite di persone diverse si sono sovrapposte.<br /><br />Puoi aggiungere persone al grafico personalmente o per gruppi familiari in base ai loro ID. L'elenco precedente verrà ricordato man mano che si aggiungono più persone al grafico. Puoi cancellare il grafico in qualsiasi momento con il pulsante <b>Cancella grafico</b>.<br /><br />Puoi anche aggiungere persone al grafico cercandole per intervallo di date o località.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#<br /><br /><b>Includi famiglia immediata</b><br /><br />Includi famiglia immediata è selezionato per impostazione predefinita. Lascia selezionato per visualizzare il padre, la madre, il coniuge, i fratelli e i figli della persona aggiunta alla sequenza temporale. Deseleziona se desideri omettere i parenti stretti.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />In questo grafico puoi visualizzare una o più persone lungo una sequenza temporale. Puoi, ad esempio, visualizzare lo stato di due o più persone in un determinato momento.<br /><br />Se fai clic sul collegamento <b>Sequenza Temporale</b> in un'altra pagina ne vedrai già uno persona sulla sequenza temporale. Se hai fatto clic sulla voce di menu <b>Sequenza Temporale</b> nell'intestazione di una pagina, devi fornire l'identificazione della persona iniziale.";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Puoi avere più persone nella cronologia.<br /><br />Usa questa casella per fornire l'identificativo di ciascuna persona. Se non conosci l'identificatore della persona, puoi fare clic sul link <b>Trova identificatore</b> accanto alla casella.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Fare clic su questo collegamento per rimuovere la persona dalla cronologia.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Se selezioni questa casella, vedrai un indicatore di età.<br /><br />Puoi far scorrere questo indicatore di età verso l'alto o verso il basso lungo la linea del tempo. L'indicatore scorrevole dell'età è un ottimo strumento per controllare l'età di una persona in un determinato evento. Puoi abilitare o disabilitare personalmente l'indicatore di età per ogni persona nel grafico.";
$pgv_lang["timeline_control_help"] = "~#pgv_lang[timeline_controls]#~<br /><br />~VELOCITÀ~<br />Fare clic sul menu per modificare la velocità di scorrimento della sequenza temporale.<br /><br />~Anno iniziale~<br />Immettere l'anno di inizio dell'intervallo.<br /><br />~Anno finale~<br />Immettere l'anno di fine dell'intervallo.<br /><br />~Ricerca~<br />Fare clic sul pulsante Cerca per iniziare a cercare gli eventi che si sono verificati nell'intervallo identificato dai campi Inizio anno e Anno fine.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />In questa pagina puoi visualizzare la relazione tra due persone qualsiasi. Queste persone non devono essere collegate direttamente dalla linea sanguigna; qualsiasi relazione verrà trovata.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Se sei passato da un'altra pagina a questa facendo clic sul collegamento <b>Relazione con me</b>, vedrai qui la relazione tra te e l'altra persona.<br /><br />Se sei arrivato in questa pagina tramite la voce di menu <b>Grafico delle relazioni</b> su qualsiasi intestazione di pagina, devi digitare i numeri identificativi delle due persone di cui desideri vedere la relazione. Se non conosci l'identificatore della persona desiderata, puoi fare clic sul link <b>Trova identificatore</b>.";
$pgv_lang["next_path_help"]			= "~#pgv_lang[next_path]#~<br /><br />È possibile fare clic su questo pulsante per vedere se esiste un altro percorso di relazione tra le due persone. I percorsi trovati in precedenza possono essere visualizzati nuovamente facendo clic sul collegamento con il numero di percorso.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Con questa casella <b>deselezionata</b>, le relazioni vengono controllate solo tra parenti di sangue. Con questa casella selezionata, vengono selezionate anche le relazioni per matrimonio. Probabilmente troverai più relazioni lasciando selezionata questa casella.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />Quando questa casella è selezionata, il grafico verrà stampato con le stesse generazioni allineate orizzontalmente sulla pagina. Quando è deselezionata, ogni generazione apparirà scendendo nella pagina indipendentemente dal tipo di relazione.";
$pgv_lang["oldest_top_help"]          = "~#pgv_lang[oldest_top]#~<br /><br />Quando questa casella è selezionata, il grafico verrà stampato con le persone più anziane in alto. Quando è deselezionato, i più giovani appariranno in alto.<br /><br />Nota: questa opzione funziona solo se è selezionata anche <b>#pgv_lang[line_up_generations]#</b>.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# - pagina~<br /><br />La pagina Antenati è molto simile ad <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ma con maggiori dettagli e visualizzazioni <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> alternative.<br /><br />Ogni ascendenza è indicata con un numero univoco, calcolato secondo il sistema <i>Sosa-Stradonitz</i>:<div style=\"padding-left: 30px;\">Numeri <b>pari</b> per gli uomini (bambino * 2)<br />Numeri <b>dispari</b> per le donne (marito + 1) ad eccezione di <b>1</b></div><br />Esempio:<br /><div style=\"padding-left: 30px;\">La persona radice è <b>1</b>, indipendentemente dal sesso.<br />Il padre di <b>1</b> è <b>2</b> (<b>1</b> * 2), la madre è <b>3</b> (<b>2</b> + 1).<br />Il padre di <b>2</b> è <b>4</b> (<b>2</b> * 2), la madre è <b>5</b> (<b>4</b> + 1).<br />Il padre di <b>3</b> è <b>6</b> (<b>3</b> * 2), la madre è <b>7</b> (<b>6</b> + 1).<br />Il padre di <b>7</b> è <b>14</b> (<b>7</b> * 2), la madre è <b>15</b> (<b>14</b> +1).<br />ecc.</div>";
$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# larghezza della scatola~<br /><br />Qui puoi modificare la larghezza della casella dal 50% al 300%. Al 100% ogni riquadro è largo circa 270 pixel.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />Sono disponibili due stili di grafico:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Albero verticale, con famiglie abbattibili / espandibili.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Una famiglia per pagina, con genitori, nonni e tutti i bambini registrati.<br /><br />Questo formato è facile da stampare per regalarlo ai tuoi parenti.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# - pagina~<br /><br />Il diagramma circolare è molto simile ad <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ma in un modo più grafico.<br /><br />La persona Root è mostrata al centro, i suoi genitori sul primo anello, i nonni sul secondo anello e così via.<br /><br />Gli anni di nascita e morte sono stampati sotto il nome quando noto.<br /><br />Facendo clic su un nome nel grafico si aprirà un menu di collegamenti specifico per quella persona. Da questo menu puoi scegliere di centrare il diagramma su quella persona o su uno dei suoi parenti stretti, oppure puoi saltare alla pagina #pgv_lang[indi_info]# di quella persona o a un grafico diverso per quella persona.";
$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_chart]# - larghezza~<br /><br />Qui puoi modificare la larghezza del diagramma dal 50% al 300%. Al 100% l'immagine in uscita è larga circa 640 pixel.";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# - stile~<br /><br />Questa opzione controlla l'aspetto del diagramma.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Diagramma semicerchio 180&deg;</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Diagramma tre quarti di cerchio 270&deg;, a volte chiamato <i>Ala d'angelo</i></li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Diagramma del cerchio completo 360&deg;</li></ul>";  

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Il grafico a clessidra mostrerà gli antenati e i discendenti della persona radice selezionata sullo stesso grafico. Questo grafico è un mix tra il grafico dei discendenti e l'albero genealogico.<br /><br />La persona radice è centrata al centro della pagina con i suoi discendenti elencati a sinistra e i suoi antenati elencati a destra. In questa visualizzazione, ogni generazione è allineata sulla pagina a partire dalla prima generazione e termina con l'ultima.<br /><br />Se sullo schermo è presente una freccia verso il basso sotto la persona root, facendo clic su di essa verrà visualizzato un elenco dei familiari stretti della persona root che puoi utilizzare per navigare nel grafico. Selezionando un nome da questo elenco verrà ricaricato il grafico con la persona selezionata come nuova persona root.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Questo grafico è molto simile al grafico a clessidra. Mostrerà gli antenati ei discendenti della persona radice selezionata sulla stessa carta. Mostrerà anche i discendenti della persona radice nello stesso formato a clessidra.<br /><br />La persona radice è centrata al centro della pagina con i suoi discendenti elencati a sinistra ei suoi antenati elencati a destra. In questa visualizzazione, ogni generazione è allineata sulla pagina a partire dalla prima generazione e termina con l'ultima.<br /><br />Ogni discendente della persona radice diventerà la persona radice di un grafico a clessidra aggiuntivo, stampato su la stessa pagina. Questo processo si ripete fino a quando non viene stampato il numero specificato di generazioni discendenti.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Questo valore determina il numero di generazioni discendenti della persona radice che verranno stampate in formato Hourglass.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PAGINA ELENCO PERSONE~<br /><br />In questa pagina puoi visualizzare un elenco di persone. I nomi verranno visualizzati con i cognomi prima e ordinati in ordine alfabetico.<br /><br />Il contenuto dell'elenco dei nomi dipende da:<ul><li>La lettera su cui hai cliccato nell'indice alfabetico.</li><li>Sia che tu abbia fatto clic su \"Salta\" o \"Mostra\" elenco cognomi.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]				= "~INDICE ALFABETICO~<br /><br />Facendo clic su una lettera nell'indice alfabetico verrà visualizzato un elenco dei nomi che iniziano con la lettera su cui si è fatto clic.<br /><br />La penultima voce nell'indice alfabetico può essere <b>#pgv_lang[NN]#</b>. Questa voce sarà presente quando ci sono persone nel database il cui cognome non è stato registrato o non contiene lettere riconoscibili. I cognomi sconosciuti vengono spesso registrati come <b>?</b> e verranno riconosciuti come <b>#pgv_lang[NN]#</b>. Ciò accadrà anche se la persona è sconosciuta.<br /><br /><b>Nota:</b><br />I cognomi inseriti come, ad esempio, <b>Nn</b>, <b>NN</b>, <b>Sconosciuto</b> o anche <b>N.N.</b> <u>non</u> essere trovato nell'elenco <b>#pgv_lang[NN]#</b>. Invece, troverai queste persone facendo clic su <b>N</b> o <b>S</b> perché queste sono le lettere iniziali di quei nomi. PhpGedView non può assolutamente tenere conto di tutti i modi possibili per inserire cognomi sconosciuti; non esiste una convenzione riconosciuta per questo.<br /><br />Alla fine dell'indice alfabetico vedrai <b>TUTTO</b>. Quando fai clic su questo elemento, vedrai un elenco di tutti i cognomi nel database.<br /><br /><b>Lettere mancanti?</b><br />Se il tuo indice alfabetico sembra essere incompleto, con lettere mancanti, il tuo database non contiene cognomi che iniziano con quella lettera mancante.";
$pgv_lang["name_list_help"]			= "~LISTA DI NOMI~<br /><br />Questa casella mostrerà un elenco di cognomi o un elenco di nomi completo. In entrambi i casi tutti i cognomi inizieranno con la lettera iniziale che hai cliccato nell'indice alfabetico, a meno che tu non abbia cliccato <b>TUTTO</b>.<br /><br />Se vedrai un elenco di cognomi o il nome completo l'elenco dipende dallo stato del collegamento <b>Salta / Mostra elenchi di cognomi</b>.";
$pgv_lang["skip_sublist_help"]			= "~SALTA SUBLISTA~<br /><br />L'impostazione standard è che, dopo aver cliccato su una lettera dell'indice alfabetico, otterrai un sottoelenco con i cognomi. Se si fa clic su questo collegamento, verranno immediatamente visualizzate tutte le persone con cognomi che hanno la lettera iniziale attualmente selezionata. Successivamente, l'elenco delle persone verrà visualizzato direttamente ogni volta che si fa clic su una nuova lettera iniziale nell'elenco alfabetico.<br /><br />Per annullare questa azione, fare clic sul collegamento #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Le pagine dell'elenco delle persone e dei familiari possono includere o escludere i nomi dei coniugi. Questa opzione può essere utile quando si cercano persone o famiglie di cui si conosce solo il nome del matrimonio. I nomi dei coniugi possono essere inclusi solo se esistono già nel database.<br /><br />Nell'elenco delle famiglie, questo valore è escluso per impostazione predefinita. Nell'elenco delle persone, il valore predefinito è impostato nella pagina Configurazione GEDCOM.<br /><br />Quando modifichi questa opzione, la tua selezione verrà ricordata fino a quando non ti disconnetti o la sessione termina.";

//-- Families-page
$pgv_lang["help_famlist.php"]		= "~PAGINA ELENCO FAMIGLIA~<br /><br />In questa pagina puoi visualizzare un elenco di famiglie. I nomi verranno visualizzati con i cognomi prima e ordinati in ordine alfabetico.<br /><br />Il contenuto dell'elenco dei nomi dipende da:<ul><li>La lettera su cui hai cliccato nell'indice alfabetico.</li><li>Sia che tu abbia fatto clic su \"Salta\" o \"Mostra\" cognomi.</li></ul>Puoi cercare il cognome del marito o della moglie; entrambi sono inclusi nell'elenco.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~PAGINA DETTAGLI FAMIGLIA~<br /><br />Questa pagina ti mostrerà una panoramica della famiglia che hai scelto in una pagina precedente.<br /><br />Dall'alto verso il basso vedrai le caselle dei dettagli personali del marito e dei suoi genitori, della moglie e dei suoi genitori, e i bambini.<br /><br />Il layout e il contenuto delle caselle delle persone sono gli stessi delle caselle che già conosci dalle pagine dell'albero genealogico e della discendenza.<br /><br />A destra delle Nelle caselle principali potresti vedere una freccia se nel file sono presenti più antenati. Quando fai clic su quella freccia, salirai di una generazione per mostrarti una nuova pagina di famiglia con i genitori precedenti ora elencati come marito e moglie.<br /><br />Sul lato destro all'interno della casella del nome potresti vedere un'icona Zoom (lente d'ingrandimento) su cui è possibile fare clic per visualizzare ulteriori dettagli sulla persona.Quando fai clic sul nome verrai indirizzato alla pagina #pgv_lang[indi_info]# di quella persona.<br /><br />Sempre sul lato destro troverai un piccolo menu per portarti a pagine con grafici o maggiori informazioni. Alcune di queste voci di menu hanno anche sottomenu che appariranno quando il puntatore del mouse si avvicina alla voce di menu genitore.<br /><br />La casella Informazioni sul gruppo familiare mostra tutti i fatti noti e le informazioni su questa famiglia, oggetti multimediali e note. Nella casella Informazioni sui fatti, facendo clic su un luogo si accederà all'elenco dei luoghi, dove vengono mostrate tutte le altre famiglie e persone collegate a quel luogo. Facendo clic su una data si passerà al calendario Giorno, che mostrerà tutti gli eventi accaduti in quel giorno e mese nella cronologia. È possibile fare clic su oggetti multimediali; questo aprirà una nuova finestra in cui l'oggetto viene visualizzato. Quando fai clic sulla didascalia dell'immagine, vedrai l'immagine sulla pagina #pgv_lang[media_list]#. Se fai clic su un collegamento Sorgente, i dettagli di tale sorgente verranno visualizzati nella pagina Sorgente.<br /><br />Sotto le caselle dei nomi dei bambini trovi il link <b>Aggiungi un bambino a questa famiglia</b>. Accanto alle caselle dei nomi dei bambini vedrai il link <b>Informazioni sul gruppo familiare</b>. Se disponi di diritti sufficienti, puoi modificare, eliminare e aggiungere dati e fatti qui.<br /><br />Come per la pagina #pgv_lang[indi_info]#, vedrai un menu in alto a destra nella pagina. Le voci in questo menu ti portano ad altre pagine dove puoi ottenere informazioni su questa famiglia o eseguire altre attività relative a questa famiglia.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~AGGIUNGI BAMBINO A QUESTA FAMIGLIA~<br /><br />Puoi aggiungere un bambino a questa famiglia facendo clic su questo collegamento.<br /><br />Aggiungere un bambino è semplice: fai clic sul collegamento, compila le caselle nella nuova finestra e basta.";
$pgv_lang["show_fam_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Le informazioni sulla famiglia, così come sono memorizzate nel database, verranno visualizzate quando si fa clic su questo collegamento. Il display mostrerà i dati GEDCOM grezzi.";
$pgv_lang["add_fam_clip_help"]		= "~AGGIUNGI FAMIGLIA AL CARRELLO DI CLIPPINGS~<br /><br />Puoi aggiungere tutte o alcune delle informazioni di questa famiglia al tuo #pgv_lang[clip_cart]#. Nella pagina successiva puoi scegliere con precisione quante informazioni aggiungere:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]	= "~MOSTRA COPPIA SULLA CRONOLOGIA~<br /><br />Quando fai clic su questo collegamento, salterai alla pagina Cronologia, dove tutti i fatti della coppia verranno visualizzati su una scala cronologica.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~PAGINA DELL'ELENCO DELLE FONTI~<br /><br />In questa pagina viene visualizzato un elenco di fonti.<br /><br />A differenza delle pagine #pgv_lang[indi_info]# e Famiglia, non esiste un indice alfabetico.<br /><br />Una fonte può essere una persona, un database pubblico, un'istituzione, una risorsa Internet, ecc. A causa della natura completamente casuale delle fonti genealogiche, è impossibile trovare un ordinamento che sia significativo in tutti i casi. Tuttavia, PhpGedView <u>ordina</u> i nomi delle sorgenti in ordine alfabetico.<br /><br /><b>FONTI</b><br />Senza sorgenti non possiamo costruire il nostro database. C'è una fonte per ogni elemento di informazione nel database. La fonte può essere un parente, un'istituzione, un database pubblico, documenti governativi o privati, una risorsa Internet, ecc.<br /><br />Una fonte può essere collegata a molte persone. Una persona può anche essere collegata a molte fonti. Puoi avere diverse fonti per ogni evento, che si tratti di data di nascita, professione, matrimonio, figli, ecc.";
$pgv_lang["sourcelist_listbox_help"]		= "~CASELLA ELENCO FONTI~<br /><br />In questa casella vengono visualizzati i nomi delle fonti così come sono archiviate in GEDCOM.<br /><br />I nomi vengono visualizzati in ordine alfabetico. Quando fai clic su un nome nell'elenco, andrai alla pagina Sorgente in cui viene visualizzato un elenco. Questo elenco mostra quali persone o famiglie sono collegate a quella fonte.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~PAGINA DETTAGLI FONTE~<br /><br />I dettagli della fonte sono visualizzati in questa pagina. Le fonti sono molto importanti per i ricercatori genealogici e ti permetteranno di seguire la traccia usata da un altro ricercatore per trovare le informazioni.<br /><br />Puoi vedere le informazioni sul titolo della fonte, l'autore, la pubblicazione e il repository dove la fonte è stato guardato in alto. A causa dei diversi tipi di fonti, alcune fonti potrebbero contenere più informazioni di altre.<br /><br />Se un oggetto multimediale come la scansione di un documento è connesso alla fonte, puoi visualizzare quell'oggetto facendo clic su l'oggetto. Quando fai clic sul nome dell'oggetto, vedrai l'oggetto sulla pagina #pgv_lang[media_list]#.<br /><br />Dopo i dettagli della fonte c'è un elenco di tutte le persone e le famiglie che sono collegate a questa fonte. Ciò consente di identificare tutti gli elementi ottenuti da tale origine dati.<br /><br />Quando l'amministratore ha abilitato queste funzionalità, in questa pagina saranno presenti una o due icone di menu aggiuntive:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />che mostra le informazioni in formato GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />che ti consente di memorizzare queste informazioni nel tuo #pgv_lang[clip_cart]# per il successivo download e importazione nel tuo programma di genealogia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~REGISTRAZIONI COLLEGATE A QUESTA FONTE~<br /><br />In questa casella vengono visualizzati i nomi delle persone e delle famiglie collegate alla fonte.<br /><br />I nomi vengono visualizzati in ordine alfabetico. Quando si fa clic su un nome nell'elenco, si accederà alla relativa pagina dei dettagli.";
$pgv_lang["show_source_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Quando si fa clic su questo collegamento, i record della fonte verranno visualizzati in formato database non elaborato.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Quando si fa clic su questo collegamento, è possibile aggiungere le informazioni sulla fonte al proprio #pgv_lang[clip_cart]# per il successivo download e importazione nel proprio programma di genealogia.";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br /><br />Quando si fa clic su questa opzione, si contrassegna questa origine da eliminare dal database.<br /><br />Che cosa significa? Supponiamo che tu abbia una buona ragione per rimuovere questa fonte dal database. Fai clic sul collegamento. Ti verrà chiesto di confermare la tua richiesta di cancellazione. Quando prosegui con la tua visita, noterai che la fonte è ancora visibile e può essere utilizzato come se l'eliminazione non fosse avvenuta.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Questo <u>non</u> è un errore.</b> L'amministratore riceverà un messaggio indicante che è stata apportata una modifica al database e che hai cancellato qualcosa. L'amministratore può accettare o rifiutare la tua modifica. Solo dopo che l'amministratore avrà accettato la modifica, l'eliminazione diventerà effettivamente permanente. In caso di dubbi sulla modifica, l'amministratore ti contatterà.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~GERARCHIA DEI LUOGHI~<br /><br />(o persone per luogo)<br /><br />Questa pagina ti mostrerà una gerarchia dei luoghi nel GEDCOM e quali persone o famiglie sono collegate a una località.<br /><br />Se c'è una connessione tra una persona o una famiglia e un evento in una determinata località, PhpGedView lo troverà.<br /><br />I risultati vengono visualizzati in un elenco di due colonne, una per le persone e una per le famiglie.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~SEQUENZA DI LUOGHI~<br /><br /><b>SEQUENZA PREDEFINITA</b><br />Ciò significa che non esiste alcun formato di codifica del luogo dichiarato in questo file GEDCOM e si presume il formato predefinito.<br /><br />Se fosse stato trovato un altro formato, sarebbe stato mostrato tra i <b>(</b> e <b>)</b> alla fine della riga.";
$pgv_lang["ppp_match_one_help"]			= "~SEQUENZA DI LUOGHI~<br /><br /><b>SEQUENZA GEDCOM</b><br />Si presume che i luoghi siano codificati nel formato del luogo esplicitamente dichiarato nel file GEDCOM. Questo annulla la sequenza predefinita";
$pgv_lang["ppp_numfound_help"]			= "~LINK A LUOGHI TROVATI~<br /><br />Il numero di corrispondenze trovate viene visualizzato qui. Se visualizzi ancora una casella di riepilogo con luoghi che non hai ancora raggiunto il livello più basso.<br /><br />Puoi scegliere di visualizzare tutti i record collegati a questo luogo oppure puoi perfezionare la ricerca facendo clic su un altro luogo.";
$pgv_lang["ppp_levels_help"]			= "~LIVELLI DI LUOGHI~<br /><br />Questo mostra i livelli che vengono visualizzati ora. La casella che mostra i luoghi è in realtà una sottolista del livello più a sinistra.<br /><br />ESEMPIO:<ul><li>La sequenza predefinita è #pgv_lang[default_form]#.</li><li>Se il livello corrente è \"Primo livello\", la casella elencherà tutti i paesi nel database.</li><li>Se il livello corrente è \"USA, Primo livello\", la casella elencherà tutti gli stati nel USA</li><li>ecc.</li></ul><br />Puoi fare clic su un livello per tornare indietro di uno o più passaggi.";
$pgv_lang["ppp_placelist_help"]			= "~GERARCHIA DEI LUOGHI~<br /><br />In questo elenco puoi vedere i luoghi che si trovano subordinati al luogo corrente che hai scelto. Se non hai ancora selezionato un luogo, vedrai un elenco di tutti i luoghi di primo livello (ad esempio paesi o stati).<br /><br />I nomi dei luoghi nell'elenco sono cliccabili; fare clic su un luogo funziona come un filtro, verrai portato al livello successivo.";
$pgv_lang["ppp_placelist_help2"]		= "~ELENCO DI LUOGHI~<br /><br />In questo elenco puoi vedere i luoghi che sono stati trovati in questa fase.<br /><br />I nomi dei luoghi nell'elenco sono cliccabili; facendo clic su un luogo funziona come un filtro, verrai portato al livello successivo inferiore.<br /><br />Solo quando sei nel livello superiore non verrà visualizzato un elenco di nomi. A tutti i livelli subordinati otterrai un elenco di famiglie e persone legate a quel luogo.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Facendo clic su questo collegamento verrà visualizzato un elenco di tutte le persone e le famiglie che hanno eventi che si verificano in questo luogo. Quando arrivi alla fine di una gerarchia di luoghi, che normalmente è una città o una città, l'elenco dei nomi verrà mostrato automaticamente.";
$pgv_lang["ppp_name_list_help"]			= "~ELENCO DI NOMI~<br /><br />Questa casella mostrerà un elenco completo di persone e famiglie collegate a quel luogo.<br /><br />I nomi nell'elenco sono cliccabili. Quando fai clic su un nome, verrai indirizzato alla pagina dei dettagli pertinente. Quando fai clic su un luogo in cima a questo elenco, modifichi la selezione del luogo.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~ELENCO OGGETTI MULTIMEDIALI~<br /><br />Questa pagina elenca tutti gli oggetti multimediali che possono essere trovati in questo database.<br /><br />Per ciascuno degli elementi multimediali vedi il titolo o il nome del file, i nomi delle persone o delle famiglie collegate all'elemento e note sull'elemento.<br /><br />Fare clic sul titolo o sul nome del file dell'elemento ha lo stesso effetto che fare clic sulla sua miniatura. L'elemento verrà aperto nel visualizzatore di immagini integrato in PhpGedView o nel visualizzatore specificato nella configurazione del browser.<br /><br />Quando fai clic sul collegamento \"Visualizza\" accanto alla persona o alla famiglia, lo farai essere portato alla pagina Dettagli pertinente.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~CARICARE FILE MULTIMEDIALI~<br /><br />Il caricamento di file multimediali è abbastanza semplice. Ecco alcune informazioni aggiuntive.<br /><br /><b>Miniature</b><br />Le miniature dovrebbero avere una dimensione di circa 100 px di larghezza. La miniatura <u>deve</u> essere denominata in modo identico alla versione a grandezza naturale. Se il tuo sistema è in grado di generare miniature automaticamente, vedrai un avviso in tal senso nella pagina Carica media.<br /><br /><b>Caricamento</b><br />I file verranno caricati automaticamente nella directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b> per la versione a grandezza naturale e in <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> per le miniature.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Informazione Generale</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Evento</b></a></li><li><a href=\"#calendar_button\"><b>Pulsanti Visualizza giorno / mese / anno</b></a></li><li><a href=\"#calendar_tip\"><b>Mancia</b></a></li></ul><br /><a name=\"calendar_general\"></a>Il #pgv_lang[anniversary_calendar]# mostra le persone e le famiglie che sono collegate a un evento in un determinato giorno o mese o durante un certo periodo di tempo. Ha un sistema di filtraggio avanzato per selezionare la data, il periodo e gli eventi giusti per te.<dl><dt><b>Visualizza <a href=\"#calendar_day\">Giorno</a></b></dt><dd>Mostra gli eventi in un determinato giorno, indipendentemente dall'anno selezionato. L'output sarà un singolo elenco con i nomi delle persone o delle famiglie o un elenco di due colonne con le persone da un lato e le famiglie dall'altro.</dd><dt><b>Visualizza <a href=\"#calendar_month\">Mese</a></b></dt><dd>In questo calendario i nomi delle persone e delle famiglie sono mostrati all'interno delle caselle Giorno. Il calendario viene visualizzato com'era nell'anno immesso nella casella Anno. Vengono visualizzati tutti gli eventi accaduti nel passato fino a quell'anno.<br /><br />In combinazione con l'opzione <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, fornirà una visione realistica di come appariva un calendario dei tuoi antenati.</dd><dt><b>Visualizza <a href=\"#calendar_year\">Anno</a></b></dt><dd>Mostra gli eventi in un determinato anno o durante un certo numero di anni. L'output sarà un elenco con i nomi delle persone o delle famiglie, oppure un elenco di due colonne con le persone da un lato e le famiglie dall'altro.</dd></dl>Il giorno e il mese attualmente visualizzati sono evidenziati nel menu del calendario.<br /><br />Tutti i nomi e le date sono selezionabili. Quando si fa clic su un nome, si verrà indirizzati alla pagina dei dettagli pertinente. Facendo clic su una data si passerà alla modalità \"Oggi\" o \"Anno\", che visualizzerà tutti gli eventi del giorno e del mese nella data selezionata.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~SELETTORE GIORNO~<br /><br />La riga superiore della tabella Selector è il selettore <b>Giorno</b>. Il suo significato è ovvio: selezioni un <u>giorno</u>.<br /><br />Il risultato del clic su un determinato giorno dipende dal fatto che ti trovi in modalità <b>Giorno</b> o <b>Mese</b>.<br /><dl><dt><b>Modalità Giorno</b></dt><dd>In questa modalità, fai clic su un giorno, lo schermo si aggiornerà e verrà visualizzato l'elenco per quel giorno.</dd><dt><b>Modalità Mese</b></dt><dd>Hai il calendario di un determinato mese sullo schermo. Fai clic su un giorno e lo schermo si aggiornerà, ma vedrai comunque il mese che avevi prima sullo schermo. Il motivo è che puoi ancora decidere di selezionare un altro mese, anno o evento prima di fare clic sul pulsante <b>#pgv_lang[viewday]#</b> o <b>#pgv_lang[viewmonth]#</b>.</dd></dl><br />Alla fine della riga Giorno vedrai un <b>collegamento rapido</b> con la data odierna. Facendo clic su questo <b>Collegamento rapido</b> verrà visualizzato l'elenco di oggi in modalità <b>Giorno</b>, indipendentemente dal fatto che ti trovi in modalità <b>Mese</b> o <b>Giorno</b>.";
$pgv_lang["annivers_month_select_help"]	= "~SELETTORE MESE~<br /><br />La riga centrale della tabella del selettore è il selettore <b>Mese</b>. Il suo significato è ovvio: selezioni un <u>mese</u>.<br /><br />Il risultato del clic su un determinato mese dipende dal fatto che ti trovi in modalità <b>Giorno</b> o <b>Mese</b>.<br /><dl><dt><b>Modalità Giorno</b></dt><dd>In questa modalità, fai clic su un mese, la schermata si aggiornerà e verrà visualizzato l'elenco per quel mese. Tutte le altre selezioni come giorno, anno ed eventi rimarranno invariate.</dd><dt><b>Modalità Mese</b></dt><dd>Quando hai il calendario sullo schermo e fai clic su un mese nella riga <b>Mese</b>, verrà visualizzato il calendario per quel nuovo mese.</dd></dl><br />Alla fine della riga Mese vedrà un <b>collegamento rapido</b> con il mese e l'anno di oggi. Facendo clic su questo <b>collegamento rapido</b> verrà visualizzato l'elenco per quel mese in modalità <b>Mese</b>, indipendentemente dal fatto che ci si trovi in modalità <b>Mese</b> o <b>Giorno</b>.";
$pgv_lang["annivers_year_select_help"]	= "~CASELLA IMMISSIONE ANNO~<br /><br />Questa casella di input consente di modificare quell'anno del calendario. Digita un anno nella casella e premi <b>Invio</b> per modificare il calendario in quell'anno.<br /><br /><b>Funzionalità avanzate</b> per <b>#pgv_lang[viewyear]#</b><dl><dt><b>Più di un anno</b></dt><dd>Puoi cercare le date in un intervallo di anni.<br /><br />Gli intervalli di anni sono <u>inclusi</u>. Ciò significa che l'intervallo di date va dal 1 gennaio del primo anno dell'intervallo al 31 dicembre dell'ultimo anno menzionato. Di seguito sono riportati alcuni esempi di intervalli di anni:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 1992 al 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 1972 al 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 1610 al 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 1880 al 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 880 al 1105.<br /><br />Per vedere tutti gli eventi in un dato decennio o secolo, puoi utilizzare <b>?</b> al posto delle cifre finali. Ad esempio, <b>197?</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 1970 al 1979 o <b>16??</b>&nbsp;&nbsp;&nbsp;per tutti gli eventi dal 1600 al 1699.<br /><br />Selezione di un intervallo di anni cambierà il calendario in vista anno.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~MOSTRA EVENTI DI...~<br /><br />Sono disponibili le seguenti opzioni:<br /><ul><li><b>Tutte le persone</b><br />Con questa opzione, vengono visualizzate tutte le persone e le famiglie.</li><li><b>Anni recenti (&lt; 100 anni)</b><br />Con questa opzione vedrai tutti gli eventi per il giorno o il mese scelto, ma non verranno mostrati eventi più vecchi di 100 anni.</li><li><b>Persone viventi</b><br />A meno che l'amministratore non abbia configurato PhpGedView in modo che le persone viventi siano visibili a chiunque, questa opzione sarà disponibile solo dopo aver effettuato l'accesso.<br /><br />Con questa opzione verranno visualizzati solo gli eventi delle persone viventi.</li></ul>Quando fai clic su un'opzione, verranno visualizzati gli eventi di tua scelta.<br /><br />Le impostazioni di giorno, mese e anno, nonché modalità <b>Giorno</b> o <b>Mese</b>, rimangono come erano.";
$pgv_lang["annivers_sex_help"]			= "~SELETTORE GENERE~<br /><br />Quando sei loggato o quando l'amministratore non ha abilitato l'opzione Privacy, puoi selezionare una di queste opzioni:<ul><li>Icona <b>Tutte</b><br />Questa è l'opzione predefinita. Vengono visualizzati gli eventi di tutte le persone e famiglie.</li><li>Icona <b>maschile</b><br />Vengono visualizzati solo gli eventi di persone di sesso maschile. Solo i membri maschi delle famiglie verranno visualizzati con gli eventi Famiglia.</li><li>Icona <b>femminile</b><br />Vengono visualizzati solo gli eventi di persone di sesso femminile. Solo i membri di sesso femminile delle famiglie verranno visualizzati con gli eventi Famiglia.</li></ul>Quando fai clic su un'opzione, verranno visualizzati gli eventi di tua scelta.<br /><br />Le impostazioni di giorno, mese e anno, nonché modalità <b>Giorno</b> o <b>Mese</b>, rimangono come erano.";
$pgv_lang["annivers_event_help"]		= "~SELETTORE EVENTI~<br /><br />Qui puoi scegliere se visualizzare tutti gli eventi per persone e famiglie o solo un evento selezionato. Non puoi selezionare più di una categoria di eventi.<br /><br />Quando fai clic su un'opzione, verranno visualizzati gli eventi di tua scelta.<br /><br />Le impostazioni di giorno, mese e anno, nonché modalità <b>Giorno</b> o <b>Mese</b>, rimangono come erano.";
$pgv_lang["annivers_tip_help"]			= "~MANCIA~<br /><br />Regola il selettore della data su qualsiasi data nel passato.<br /><br />Quando fai clic su uno dei pulsanti Visualizza, vedrai un elenco o un calendario per quella data. Tutte le età, gli anniversari, ecc. Sono stati ricalcolati e ora contano dalla data impostata nel selettore Data. Ora stai vedendo il calendario o l'elenco che il tuo antenato avrebbe visto in quella data, anni fa.";
$pgv_lang["day_month_help"]				= "~PULSANTI : VISUALIZZA GIORNO / VISUALIZZA MESE / VISUALIZZA ANNO~<br /><br /><ul><li>Il pulsante <b>Visualizza Giorno</b> mostrerà gli eventi della data scelta in un elenco. Vengono scansionati tutti gli anni, quindi qui è possibile impostare solo il giorno e il mese. La modifica dell'anno non avrà alcun effetto. Puoi ridurre l'elenco scegliendo l'opzione <b>Anni recenti</b> o <b>Persone in vita</b>.<br /><br />Le età nell'elenco verranno calcolate dall'anno in corso.</li><li>Il pulsante <b>Visualizza Mese</b> mostrerà un diagramma del calendario del mese e dell'anno scelti. Anche qui puoi ridurre gli elenchi scegliendo l'opzione <b>Anni recenti</b> o <b>Persone viventi</b>.<br /><br />Avrai un'impressione realistica di cosa sia un calendario l'aspetto del muro dei tuoi antenati scegliendo un anno nel passato in combinazione con <b>Anni recenti</b>. Tutte le età sul calendario vengono visualizzate in relazione all'anno nella casella Anno.</li><li>Il pulsante <b>Visualizza Anno</b> ti mostrerà un elenco di eventi dell'anno scelto. Anche qui puoi ridurre l'elenco scegliendo l'opzione <b>Anni recenti</b> o <b>Persone viventi</b>.<br /><br />Puoi mostrare eventi per un intervallo di anni. Basta digitare l'inizio e la fine degli anni dell'intervallo, con un trattino <b>-</b> tra di loro. Esempi:<br /><b>1992-4</b> per tutti gli eventi dal 1992 al 1994<br /><b>1976-1984</b> per tutti gli eventi dal 1976 al 1984<br /><br />Per vedere tutti gli eventi in un dato decennio o secolo, puoi utilizzare <b>?</b> al posto delle cifre finali. Ad esempio, <b>197?</b> per tutti gli eventi dal 1970 al 1979 o <b>16??</b> per tutti gli eventi dal 1600 al 1699.</li></ul>Quando desideri <b>cambiare l'anno</b>, <b>devi</b> premere uno di questi tre pulsanti. Tutte le altre impostazioni rimangono come erano.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />Il #pgv_lang[clip_cart]# ti consente di prendere estratti (\"ritagli\") da questo albero genealogico e di raggrupparli in un unico file per il download e la successiva importazione nel tuo programma di genealogia. Il file scaricabile viene registrato in formato GEDCOM.<br /><ul><li>Come prendere i ritagli?<br />Questo è davvero semplice. Ogni volta che vedi un nome cliccabile (persona, famiglia o fonte) puoi andare alla pagina Dettagli di quel nome. Lì vedrai l'opzione <b>#pgv_lang[add_to_cart]#</b>. Quando fai clic su quel link ti verranno offerte diverse opzioni per il download.</li><li>Come scaricare?<br />Una volta che hai gli articoli nel carrello, puoi scaricarli semplicemente facendo clic sul link <b>Scarica ora</b>. Segui le istruzioni e i link.</li></ul>";
$pgv_lang["clip_download_help"]			= "~#pgv_lang[download_now]#~<br /><br />Quando fai clic su questo link verrai indirizzato alla pagina successiva. Se uno qualsiasi dei ritagli nel carrello fa riferimento ad articoli multimediali, anche questi elementi verranno visualizzati in quella pagina.<br /><br />Segui semplicemente le istruzioni.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Quando fai clic su questo link, il tuo #pgv_lang[clip_cart]# sarà completamente svuotato.<br /><br />Se non desideri rimuovere tutte le persone, le famiglie, ecc. dall'#pgv_lang[clip_cart]#, puoi rimuovere gli elementi singolarmente facendo clic sul collegamento <b>Rimuovi</b> nelle caselle Nome. <u>Nessuna</u> dialogo ti conferma quando fai clic su uno di questi link; la cancellazione richiesta avviene immediatamente.";
$pgv_lang["add_by_id_help"]				= "~CARRELLO RITAGLI AGGIUNTO PER IDENTIFICATORE~<br /><br />Questa casella di input ti consente di inserire il numero di identificazione di una persona in modo che possa essere aggiunta al carrello dei ritagli. Una volta aggiunto ti verranno offerte le opzioni per collegare le relazioni di quella persona al tuo carrello dei ritagli.<br /><br />Se non conosci il numero di identificazione di una persona, puoi eseguire una ricerca per nome premendo l'icona Persona accanto a il pulsante Aggiungi.";
$pgv_lang["zip_help"]					= "~ZIP i ritagli~<br /><br />Seleziona questa opzione per salvare i tuoi ritagli in un file ZIP. Per ulteriori informazioni sui file ZIP, visitare <a href=\https://it.wikipedia.org/wiki/ZIP_(formato_di_file)\" target=\"_blank\">https://it.wikipedia.org/wiki/ZIP_(formato_di_file)</a>.";
$pgv_lang["include_media_help"]			= "~INCLUDERE MEDIA~<br /><br />Seleziona questa opzione per includere i file multimediali associati ai record nel carrello dei ritagli. La scelta di questa opzione comprimerà automaticamente i file durante il download.";
$pgv_lang["clip_cart_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Questa casella mostra il contenuto del tuo carrello dei ritagli.<ul><li>La colonna <i>Tipi</i> indica il tipo di ciascuna voce, che può essere Persona (INDI), Famiglia (FAM), Fonte (SOUR), Repository (REPO), Nota (NOTE) e Media (OBJE) ; ognuno è rappresentato dalla propria icona.</li><li>La colonna <i>ID</i> mostra il numero di identificazione per ogni elemento di quel particolare tipo.</li><li>La colonna <i>Nome / Descrizione</i> fornisce il nome della famiglia o della persona oppure una descrizione dell'articolo.</li></ul>Il pulsante Rimuovi rimuoverà quel record dal carrello dei ritagli. <b>NON è richiesta la conferma per la rimozione.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~#pgv_lang[review_changes]#~<br /><br />Quando vedi questo messaggio, significa due cose:<ol><li>Qualcuno ha apportato modifiche al GEDCOM<br />I record potrebbero essere stati aggiunti, eliminati o modificati.</li><li>Le modifiche non sono state ancora accettate dall'amministratore.<br />Una volta che le modifiche sono state accettate o rifiutate, non vedrai più questo messaggio.</li></ol>Puoi vedere quali modifiche sono state apportate facendo clic sul collegamento. Se noti che una modifica non è corretta, avvisa l'amministratore.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~la pagina ricerca~<br /><br />Anche se questa pagina sembra molto semplice, c'è un motore di ricerca molto potente e complicato dietro le due forme. La maggior parte dei siti web di genealogia ti consente solo di cercare un nome. PhpGedView ti consente di cercare quasi qualsiasi cosa.<br /><br />La casella di ricerca sulla sinistra dello schermo è la stessa della casella di ricerca nell'intestazione di ciascuna pagina.<br /><br />Se stai cercando persone in relazione a un certo anno, basta digitare l'anno. Il programma troverà tutte le connessioni per te.<br /><br />Cerchi un nome o un luogo? Basta digitare il nome o il luogo, completamente o solo una parte, e PhpGedView farà il resto.<br /><br /><b>Metodo di ricerca Soundex</b><br /><br />Con le caselle di ricerca sul giusto, puoi cercare nomi di persone e luoghi, anche se non sai esattamente come scrivere il nome.<br /><br />Quando ci sono diversi database genealogici su un sito e l'amministratore ha abilitato il passaggio tra, la tua ricerca restituirà i risultati per tutti loro.<br /><br />Troverai ulteriore aiuto su queste due caselle facendo clic su <b>?</b> sopra le caselle.";
$pgv_lang["search_enter_terms_help"]		= "~#pgv_lang[enter_terms]#~<br /><br />In questa casella di ricerca puoi inserire criteri come date, nomi, cognomi, luoghi, multimedia, ecc.<br /><br /><b>Caratteri jolly</b><br />I caratteri jolly, come probabilmente li conosci (come * o ?), non sono consentiti, ma il programma assumerà automaticamente i caratteri jolly.<br /><br />Supponi di digitare nella casella di ricerca quanto segue: <b>Pete</b>. Il risultato potrebbe essere, supponendo che i nomi siano nel database:<div style=\"padding-left: 30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />qualcuno, nato il 1 gennaio 1901 <b>Pete</b>rsburg<br />ecc.</div><br /><b>Date</b><br />Digitando un anno nella casella di ricerca, verrà visualizzato un elenco di persone che sono in qualche modo collegate a quell'anno.<br /><br />Se digiti <b>1950</b>, il risultato sarà tutte le persone con un evento che si è verificato nel 1950. Questi eventi potrebbero essere nascite, morti, matrimoni, Bar Mitzvah, Sigilli SUG, ecc.<br /><br />Se digiti <b>4 Dec</b>, verranno elencate tutte le persone collegate a un evento che si è verificato il 4 dicembre di qualsiasi anno. Verranno elencate anche le persone collegate a un evento del 14 o 24 dicembre. Come vedi, i caratteri jolly vengono sempre considerati, quindi non è necessario digitarli. A volte, i risultati possono essere sorprendenti.<br /><br /><b>Date corrette</b><br />PhpGedView cerca i dati, poiché sono memorizzati nel file GEDCOM. Se, ad esempio, desideri cercare un evento il 14 dicembre, devi digitare <b>14&nbsp;dec</b> perché è così che la data viene memorizzata nel database.<br /><br />Se dovevi digitare <b>dec&nbsp;14</b>, il risultato potrebbe essere una persona collegata a un evento in data 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>. Ancora una volta, i risultati possono essere sorprendenti.<br /><br />Puoi usare espressioni regolari nella tua ricerca se le conosci. Ad esempio, se volessi trovare tutte le persone che hanno date nel 20 ° secolo, potresti inserire la ricerca <b>19[0-9][0-9]</b> e otterrai tutte le persone con date dal 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Se hai bisogno di ulteriore assistenza con questo sistema di ricerca, faccelo sapere, così possiamo migliorare anche questo file della Guida.";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Qui puoi cercare un errore di ortografia o altre informazioni imprecise e sostituirle con informazioni corrette.<br /><br /><b>Ricerca</b><br />Questa funzione esegue la ricerca proprio come una <a href=\"help_text.php?help=search_enter_terms_help\">normale ricerca</a>.<br /><br /><b>Sostituzione</b><br />Tutte le istanze del termine di ricerca trovate vengono sostituite dal termine sostitutivo nel database.<br /><br /><b>Per esempio...</b><br />Supponi di aver sbagliato a scrivere accidentalmente il nome del tuo bisnonno Michael. Hai inserito accidentalmente 'Micheal'.<br /><br />Dovresti digitare <b>Micheal</b> nella casella di ricerca e <b>Michael</b> nella casella Sostituisci.<br />Ogni istanza di \"Micheal\" verrebbe quindi sostituita da \"Michael\"<br /><br /><b>Cercare...</b><br />Seleziona l'ambito della ricerca. Puoi limitare la ricerca a nomi o luoghi oppure non applicare alcun limite (cercare tutto). L'opzione <i>#pgv_lang[search_place_word]#</i> cercherà solo il tuo termine nel campo del luogo come una parola intera. Ciò significa che la ricerca di <i>UT</i> corrisponderà solo a <b>UT</b> e non a <i>UT</i> in altre parole come Connectic<b>ut</b>.<br /><br />Non preoccuparti se sostituisci accidentalmente qualcosa che non desideri. Fai clic sul link \"Accetta / Rifiuta modifiche\" in fondo alla pagina per accettare le modifiche desiderate e rifiutare le modifiche che non desideri.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex è un metodo per codificare le parole in base alla loro pronuncia. Ciò ti consente di cercare nel database nomi e luoghi quando non sai esattamente come sono scritti. PhpGedView supporta due diversi algoritmi Soundex che producono risultati molto diversi.<ul><li><b>#pgv_lang[search_russell]#</b><br />Questo metodo, brevettato nel 1918 da Russell, è molto semplice e può essere fatto a mano.<br /><br />Il semplice algoritmo non è adatto a nomi originariamente in lingue diverse dall'inglese, e anche con nomi inglesi i risultati sono molto sorprendenti. Ad esempio, una semplice ricerca Soundex per <b>Smith</b> restituirà non solo <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, che sono chiaramente variazioni di <b>Smith</b>, ma anche <b>Smead, Sneed, Smoote, Sammett, Shand,</b> e <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Questo metodo, sviluppato nel 1985, è molto più complesso del metodo semplice e non è facilmente eseguibile a mano.<br /><br />Una ricerca Soundex che utilizza questo metodo produce risultati molto più accurati.</li></ul>Per i dettagli su entrambi gli algoritmi Soundex, visitare questa pagina web della <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a>.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />L'opzione <b>#pgv_lang[search_tagfon]#</b> costringer&agrave la funzione Ricerca ad ignorare i seguenti tag GEDCOM:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Autore dell'ultima modifica<br /><b>CHAN</b> - Data dell'ultima modifica<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />In aggiunta ai precedenti tag che possono essere selezionati opzionalmente, la funzione Ricerca esclude sempre i seguenti tag:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Questa opzione fa in modo che PhpGedView mostri tutti gli individui registrati come associati a questa persona o famiglia. L'inverso non è possibile.<br /><br />Esempio: supponiamo che la persona <b>A</b> sia il padrino della persona <b>B</b>. Questa relazione viene registrata nel record GEDCOM della persona <b>B</b> mediante un tag ASSO. Non esiste alcun tag corrispondente nel record GEDCOM della persona <b>A</b>.<br /><br />Quando questa opzione è impostata su <b>#pgv_lang[yes]#</b> e l'elenco dei risultati di ricerca include <b>B</b>, <b>A</b> verrà incluso automaticamente a causa del tag ASSO nel record GEDCOM di <b>B</b>. Tuttavia, se l'elenco dei risultati di ricerca include <b>A</b>, <b>B</b> non verrà incluso automaticamente poichpoiché non esiste un tag ASSO corrispondente nel record GEDCOM della persona <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Questa funzionalità consente di cercare i campi specificati dei record Persona nel database genealogico.<br /><br />Quando si fa clic sul pulsante <b>#pgv_lang[search]#</b>, tutti i campi per i quali sono stati immessi valori verranno esaminati e i record nel database genealogico che soddisfano <u>tutti</u> i criteri verranno restituiti. Mentre la finestra di dialogo iniziale offre alcuni dei campi più comuni, nella parte inferiore della finestra di dialogo è possibile fare clic su <b>#pgv_lang[more_fields]#</b> per espandere l'elenco dei campi da esaminare.<br /><br />~Campi contenenti date~<br />Le ricerche avanzate si basano sugli anni, quindi a differenza della procedura «#pgv_lang[search_general]#» che può accettare una data senza anno, tutti questi campi richiedono almeno l'anno, ma possono anche accettare specifiche complete di giorno, mese e anno. Ad esempio, non è possibile cercare qualcosa che è accaduto ad aprile di un anno qualsiasi.<br /><br />Ogni casella del campo data di ricerca ha anche un modificatore, in modo che tu possa cercare la data <b>#pgv_lang[exact]#</b> come inserita, o una data relativa con <b>+/-</b> un numero di anni. Digitando un anno nel campo data, quindi scegliendo un modificatore e quindi cliccando sul pulsante <b>#pgv_lang[search]#</b> si otterrà un elenco di persone che sono collegate a quell'anno o intervallo di anni.<br /><br />Se, ad esempio, digiti «APR 1950» nel campo data di nascita che ha il modificatore <b>#pgv_lang[exact]#</b>, il risultato sarà tutte le persone con un evento che si è verificato solo nell'aprile 1950. Ogni campo data cercherà le date specifiche di quell'evento. Aggiungendo un modificatore <b>+/- 10</b> si otterrebbero date comprese tra il 1° aprile 1940 e il 31 marzo 1960. Gli altri modificatori modificherebbero in modo simile gli intervalli di anni di ricerca. Inserendo solo un anno, ad esempio «1950», la ricerca restituirà tutti gli eventi nell'anno specificato.<br /><br /><b>Formato data per le ricerche</b><br />Nei campi data di ricerca non è possibile utilizzare né caratteri jolly né espressioni regolari. L'ordine di giorno, mese, anno e maiuscole sono irrilevanti. «gg MMM aaaa» ha lo stesso significato di «aaaa MMM gg». Tuttavia, se si desidera cercare un evento del 14 dicembre 1926, è necessario digitarlo come «14 DEC 1926» perché è così che la data viene archiviata nel database. Per cercare una data in più eventi (ad esempio nascite, decessi, matrimoni, Bar Mitzvah, suggellamenti LDS, ecc.) o se si conoscono solo il giorno o il mese, è meglio utilizzare la funzionalità «#pgv_lang[search_general]#».<br /><br />~Campi contenenti nomi~<br />I campi <b>#pgv_lang[given_name]#</b> e <b>#pgv_lang[surname]#</b> possono essere utilizzati per specificare le diverse parti di un nome da ricercare. Ciò filtra facilmente i nomi che potrebbero essere sia nomi propri che cognomi, ad esempio «Terry» o «Henry».<br /><br />I campi dei nomi hanno anche un modificatore che aiuta a qualificare ciò che è stato immesso rispetto a ciò che è stato cercato. I modificatori includono:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;specifica una ricerca case-sensitive dell'intero campo per il testo esatto immesso. La ricerca è anche sensibile a tutti i caratteri incorporati, spaziatura, ecc. Ad esempio, se il campo contiene uno spazio ma il record nel database ne ha due nella stessa posizione, il record non verrà trovato.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;specifica una ricerca senza distinzione tra maiuscole e minuscole per i record in cui un nome inizia con ciò che è nel campo. Se un campo nome contiene più nomi (come nome e secondo nome), la corrispondenza verrà eseguita con l'inizio di ogni parte del nome separata da uno spazio.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;specifica una ricerca non sensibile alle maiuscole/minuscole per i record in cui i dati completi immessi nel campo verranno cercati ovunque all'interno del testo del nome del record di destinazione. Ad esempio, inserendo un singolo spazio nel campo di ricerca <b>#pgv_lang[given_name]#</b> con il modificatore <b>#pgv_lang[contains]#</b>, verranno trovati tutti i record che devono avere un nome e almeno un secondo nome o iniziale.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;specifica una ricerca non sensibile alle maiuscole/minuscole per i record simili a quelli presenti nel campo. Ciò consente di cercare nel database nomi e luoghi quando non si sa esattamente come sono scritti.</li></ul><br />~Campi senza modificatori~<br />Le voci nei campi senza modificatori sono ricerche non sensibili alle maiuscole/minuscole. Il testo inserito verrà cercato ovunque all'interno del testo dell'evento del record di destinazione.";

//-- Person Information-page
$pgv_lang["help_individual.php"]		= "~Pagina #pgv_lang[indi_info]#~<br /><br />Tutti i dettagli di una persona sono visualizzati in questa pagina.<br /><br />Se è disponibile un'immagine, la vedrai in alto a sinistra. Vedrai i nomi della persona accanto all'immagine.<br /><br />Ai nomi possono essere associate note e fonti. Se uno qualsiasi dei nomi ha note o fonti, li vedrai elencati sotto i nomi a cui si riferiscono.<br /><br />Una persona potrebbe avere un AKA (forse è conosciuto con un altro nome). In tal caso, verrà visualizzato.<br /><br />Se disponi dei diritti di modifica per questa persona, vedrai anche i collegamenti <b>Modifica</b> e <b>Elimina</b> accanto agli elementi che puoi modificare.<br /><br />In questa pagina vedi le schede per <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, e <b>#pgv_lang[relatives]#</b>. Queste schede mostrano tutte le informazioni su questa persona memorizzate nel database.<br /><ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;ti mostrerà i fatti e i dettagli su questa persona e qualsiasi fatto relativo al loro matrimonio. Facendo clic su una data qualsiasi in questa scheda verrai reindirizzato al #pgv_lang[anniversary_calendar]# per quella data, in modo da poter vedere altri eventi accaduti lo stesso giorno. Se fai clic su un luogo, verrai reindirizzato alla Gerarchia dei luoghi dove potrai visualizzare altre persone che hanno avuto eventi nello stesso luogo. Per il matrimonio e altri fatti relativi alla famiglia, è disponibile il nome del coniuge della persona in modo da poter visualizzare il coniuge e viene fornito anche un collegamento al registro familiare.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;ti mostrerà eventuali note generali relative a questa persona.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;ti mostrerà tutte le fonti <u>generali</u> per questa persona. Queste fonti <u>non</u> sono collegate a fatti personali, nemmeno al nome della persona; sono associati alla persona stessa. Fare clic sul titolo di una fonte ti porterà a una pagina di informazioni sulla fonte più dettagliata che mostrerà altre persone che sono anche collegate alla stessa fonte.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;elencherà tutte le immagini e altri elementi multimediali allegati a questa persona. Facendo clic su una miniatura dell'immagine si aprirà una visualizzazione ingrandita dell'immagine. Facendo clic sulla didascalia dell'immagine verrà visualizzata l'immagine nella pagina #pgv_lang[media_list]#.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;elenca i genitori e i fratelli di questa persona, nonché tutti i coniugi e i figli che questa persona ha avuto. Queste persone verranno elencate in caselle simili ai grafici che potresti aver già visto.</li></ul>Sulla destra dello schermo troverai una casella con i link. Molti dei collegamenti nella casella sono gli stessi dei collegamenti nei menu. Ad esempio, facendo clic sul collegamento <b>#pgv_lang[pedigree_chart]#</b> sui collegamenti laterali, verrai reindirizzato all'albero genealogico di questa persona. Questo è diverso dai collegamenti del menu, perché facendo clic sul collegamento <b>#pgv_lang[pedigree_chart]#</b> nel menu tornerai al grafico dell'albero genealogico predefinito per questo database.<br /><br /> Uno dei collegamenti che potrebbero apparire in questo elenco se è stato abilitato dall'amministratore, è il collegamento <b>#pgv_lang[view_gedcom]#</b>. Questo collegamento ti mostrerà il record GEDCOM grezzo di questa persona.<br /><br />Se #pgv_lang[clip_cart]# è stato abilitato dall'amministratore del sito, avrai anche un link che ti permetterà di aggiungere questa persona al tuo #pgv_lang[clip_cart]#.<br /><br />Il link <b>#pgv_lang[relationship_to_me]#</b> apparirà solo se sei loggato e hai è stato assegnato un ID in GEDCOM. Questo link ti porterà all'albero genealogico e ti mostrerà come sei imparentato con questa persona.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Quando fai clic su questa opzione, contrassegnerai questa persona da eliminare dal database.<br /><br />Che cosa significa? Supponiamo che tu abbia una buona ragione per rimuovere questa persona dal database. Fai clic sul collegamento. Ti verrà chiesto di confermare la tua richiesta di cancellazione. Quando continui con la tua visita, noterai che la persona è ancora visibile e può essere utilizzato come se l'eliminazione non fosse avvenuta.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~MODIFICARE O ELIMINARE NOME DA GEDCOM~<br /><br /><b>MODIFICARE NOME</b><br />Quando fai clic su questo collegamento, si aprirà un'altra finestra. Lì puoi modificare il nome della persona. Basta digitare le modifiche nelle caselle e fare clic sul pulsante, chiudere la finestra e il gioco è fatto.<br /><br /><b>ELIMINARE NOME</b><br />Facendo clic su questa opzione contrassegnerai questo nome da eliminare dal database. Tieni presente che l'eliminazione del nome è completamente diversa dall'eliminazione della persona. L'eliminazione del nome rimuove semplicemente il nome dalla persona. La persona <u>non</u> verrà eliminata. Se è un AKA che vuoi eliminare, la persona ha ancora i suoi altri nomi. Se è <u>solo</u> il nome che desideri rimuovere, la persona non verrà comunque eliminata, ma sarà ora registrata come <b>#pgv_lang[NN]#</b>. La persona inoltre non verrà scollegata da nessun altro a parenti, fonti, note, ecc.<br /><br />Come funziona? Ti verrà chiesto di confermare la tua richiesta di cancellazione. Quando continui con la tua visita, noterai che il nome è ancora visibile e può essere utilizzato come se l'eliminazione non fosse avvenuta.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~AGGIUNGI UN NUOVO NOME~<br /><br />Questo collegamento ti consentirà di aggiungere un altro nome a questa persona. A volte le persone sono conosciute con altri nomi o alias. Questo collegamento ti consente di aggiungere nuovi nomi a una persona senza modificare il vecchio nome.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Puoi aggiungere un bambino a questa famiglia facendo clic su questo collegamento. \"Questa famiglia\", in questo caso, è il padre e la madre della persona principale di questa schermata.<br /><br />Tieni presente che stai per aggiungere un fratello di quella persona. Aggiungere un fratello o una sorella è semplice: basta fare clic sul collegamento, compilare le caselle nella schermata a comparsa e questo è tutto.<br /><br />Se devi aggiungere un figlio o una figlia della persona principale, scorri leggermente verso il basso e fai clic sul collegamento in \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Puoi aggiungere un bambino a questa famiglia facendo clic su questo collegamento. \"Questa famiglia\", in questo caso, è la persona principale di questa schermata e il suo coniuge.<br /><br />Tieni presente che stai per aggiungere un figlio o una figlia di quella persona. Aggiungere un figlio o una figlia è semplice: basta fare clic sul collegamento, compilare le caselle nella schermata popup e questo è tutto.<br /><br />Se devi aggiungere un fratello o una sorella della persona principale, scorri verso l'alto a piccolo e fare clic sul collegamento in \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Puoi collegare questa persona da bambino a una famiglia esistente quando fai clic su questo collegamento.<br /><br />Supponi che una volta i genitori della persona fossero sconosciuti e hai scoperto in seguito che i genitori hanno un record in questo database.<br /><br />Basta fare clic sul collegamento, inserire il numero di identificazione della famiglia e hai completato l'attività. Se non conosci il numero di famiglia, puoi cercarlo.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Questo elemento ti consentirà di collegare la persona attuale come marito a una famiglia già presente nel database. Facendo clic su questo collegamento è possibile aggiungere questa persona a una famiglia esistente, di cui il marito era sconosciuto fino ad ora. Questa persona prenderà il posto del marito precedentemente sconosciuto. Tutti gli eventi, le informazioni sul matrimonio e i figli manterranno i loro collegamenti esistenti alla famiglia.<br /><br />Basta fare clic sul collegamento, inserire il numero di identificazione della famiglia e avrai completato il compito. Questa è un'opzione di modifica avanzata che dovrebbe essere utilizzata solo se la famiglia a cui desideri collegarti esiste già. Se desideri aggiungere una <u>nuova</u> famiglia a questa persona, utilizza il collegamento <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Facendo clic su questo collegamento, è possibile aggiungere una <u>nuova</u> persona di sesso maschile e collegare questa persona alla persona principale come nuovo marito.<br /><br />Basta fare clic sul collegamento e riceverai un finestra pop-up per aggiungere la nuova persona. Compila il maggior numero di caselle possibile e fai clic sul pulsante <b>Salva</b>.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Ciò ti consentirà di collegare un'altra persona, che già esiste, come nuovo marito a questa persona. Questo creerà una nuova famiglia con il marito che selezioni. Avrai anche la possibilità di specificare un matrimonio per questa nuova famiglia.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Facendo clic su questo collegamento, puoi aggiungere un <u>nuovo</u> bambino a questa persona, creando una famiglia monoparentale.<br /><br />Fai clic sul collegamento e apparirà una finestra per aggiungere la nuova persona. Compila il maggior numero di caselle possibile e fai clic sul pulsante <b>Salva</b>.<br /><br />Questo è tutto.";
$pgv_lang["link_wife_help"]			= "~#pgv_lang[link_as_wife]#~<br /><br />Questo elemento ti consentirà di collegare la persona attuale come moglie a una famiglia già presente nel database.<br /><br />Questa è un'opzione di modifica avanzata che dovrebbe essere utilizzata solo se la famiglia a cui desideri collegarti esiste già. Se desideri aggiungere una <u>nuova</u> famiglia a questa persona, utilizza il collegamento <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]			= "~#pgv_lang[add_new_wife]#~<br /><br />Facendo clic su questo collegamento, puoi aggiungere una <u>nuova</u> persona di sesso femminile e collegare questa persona alla persona principale come nuova moglie.<br /><br />Fai clic sul collegamento e otterrai un finestra per aggiungere la nuova persona. Compila il maggior numero di caselle possibile e fai clic sul pulsante <b>Salva</b>.<br /><br />Questo è tutto.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Ciò ti consentirà di collegare un'altra persona, che già esiste, come nuova moglie a questa persona. Questo creerà una nuova famiglia con la moglie che selezioni. Avrai anche la possibilità di specificare un matrimonio per questa nuova famiglia.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~AGGIUNGI NUOVO PADRE O MADRE~<br /><br />Ci sono certamente molte persone nel GEDCOM senza un record di un padre o di una madre.<br /><br />In tal caso, nella pagina <b>#pgv_lang[indi_info]#</b>, scheda <b>#pgv_lang[relatives]#</b>, tabella <b>#pgv_lang[as_child]#</b>, troverai i collegamenti per aggiungere un <u>nuovo</u> padre o madre alla persona.<br /><br />Tieni presente che questi collegamenti servono per aggiungere un <u>nuovo</u> padre o madre. Se il padre o la madre ha già un record in questo database, devi utilizzare il link <b>#pgv_lang[link_as_child]#</b>, che troverai su quella pagina <b>#pgv_lang[indi_info]#</b> sotto l'ultima tabella.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br /> Quando questa opzione è selezionata, puoi vedere tutti i record Sorgente o Nota per questa persona. Quando questa opzione è deselezionata, i record Sorgente o Nota associati ad altri fatti per questa persona non verranno visualizzati.";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br /><br />Quando questa casella di opzione è selezionata, la scheda «#pgv_lang[relatives]#» mostrerà le differenze di data come segue:<ul><li><b>date di nascita dei partner.</b><br />Un valore negativo indica che il secondo partner è più vecchio del primo.</li><li><b>data del matrimonio e data di nascita del primo figlio.</b><br />Un valore negativo qui indica che il bambino è nato prima della data del matrimonio o che la data di nascita o la data del matrimonio è sbagliata.</li><li><b>date di nascita dei fratelli.</b><br />Un valore negativo qui indica che l'ordine dei bambini è sbagliato o che una delle date di nascita è sbagliata.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~AGGIUNGERE NUOVI FATTI~<br /><br />Qui puoi aggiungere un fatto al record in fase di modifica.<br /><br />Prima scegli un fatto dall'elenco, quindi fai clic sul pulsante <b>Aggiungi</b>. Tutti i fatti possibili che puoi aggiungere al database sono in quell'elenco.";
$pgv_lang["add_custom_facts_help"]		= "~Aggiungi fatti personalizzati~<br /><br />Se non riesci a trovare il fatto che desideri aggiungere nell'elenco dei fatti GEDCOM, puoi inserire anche un <b>fatto personalizzato</b>.<br /><br />Inserire un fatto personalizzato è solo semplice come entrare in uno di quelli predefiniti. L'unica differenza è che devi nominare il fatto invece di prenderne il nome da un elenco. Devi farlo nel campo in alto: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~AGGIUNGI NUOVA NOTA~<br /><br />Se hai una nota da aggiungere a questo record, questo è il posto giusto per farlo.<br /><br />Fai clic sul link, si aprirà una finestra e potrai digitare la tua nota. Quando hai finito di digitare, fai clic sul pulsante sotto la casella, chiudi la finestra e questo è tutto.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Quando fai clic sul collegamento <b>#pgv_lang[add_shared_note]#</b>, si aprirà una nuova finestra. Puoi scegliere di collegarti a una nota condivisa esistente oppure puoi creare una nuova nota condivisa e allo stesso tempo creare un collegamento ad essa.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~AGGIUNGERE UNA NUOVA CITAZIONE DELLA FONTE~<br /><br />Qui puoi aggiungere una <b>citazione</b> di origine a questo record.<br /><br />Fai clic sul collegamento, si aprirà una finestra e potrai scegliere la fonte dall'elenco (Trova ID) o crea una nuova fonte e poi aggiungi la citazione.<br /><br />L'aggiunta di fonti è una parte importante della genealogia perché consente ad altri ricercatori di verificare dove hai ottenuto le tue informazioni.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />L'aggiunta di file multimediali a GEDCOM è una caratteristica molto interessante. Sebbene questo programma abbia già un bell'aspetto senza media, se aggiungi immagini o altri media ai tuoi parenti, migliorerà solo.<br /><br /><b>Cosa dovresti capire sui media.</b><br />Ci sono molti formati di media. Sebbene PhpGedView possa gestirne la maggior parte, ci sono alcune cose da considerare.<br /><ul><li><b>Formati</b><br />Le immagini possono essere modificate e salvate in molti formati. Per esempio, .jpg, .png, .bmp, .gif, ecc.  Se la stessa immagine originale è stata utilizzata per creare ciascuno dei formati, l'immagine visualizzata apparirà della stessa dimensione indipendentemente dal formato utilizzato. Tuttavia, le dimensioni dei file di immagine archiviati nel database variano notevolmente. In generale, le immagini .jpg sono considerate le più efficienti in termini di spazio di archiviazione.</li><li><b>Dimensione dell'immagine</b><br />Più grande è l'immagine originale, maggiore sarà la dimensione del file risultante. L'immagine dovrebbe adattarsi allo schermo senza scorrere; la larghezza o l'altezza massima non deve essere superiore alla larghezza o all'altezza dello schermo. PhpGedView è progettato per schermi di 1024x768 pixel ma non tutto questo spazio è disponibile per la visualizzazione delle immagini; la dimensione dell'immagine dovrebbe essere impostata di conseguenza. Per ridurre le dimensioni dei file, sono preferibili immagini più piccole.</li><li><b>Risoluzione</b><br />La risoluzione di un'immagine viene solitamente misurata in \"dpi\" (dots per inch == punti / pollice), ma questo è valido solo per le immagini stampate. Quando si considerano le immagini mostrate sullo schermo, l'unico modo corretto è utilizzare punti o pixel totali. Una volta stampata, l'immagine potrebbe avere una risoluzione di 150 - 300 dpi o più a seconda della stampante. Le risoluzioni dello schermo sono raramente migliori di 50 pixel per pollice. Se la tua immagine non verrà mai stampata, puoi tranquillamente abbassare la sua risoluzione (e di conseguenza la dimensione del file) senza influire sulla qualità dell'immagine. Se un'immagine a bassa risoluzione viene stampata con un ingrandimento troppo grande, la sua qualità ne risentirà; avrà un aspetto granuloso.</li><li><b>Profondità di colore</b><br />Un altro modo per mantenere un file piccolo è diminuire il numero di colori che usi. Il numero di colori può variare dal bianco e nero puro (due colori) ai colori reali (milioni di colori) e qualsiasi altra via di mezzo. Puoi vedere che più colori vengono utilizzati, maggiore è la dimensione dei file.</li></ul><br /><b>Perché è importante mantenere piccole le dimensioni del file?</b><ul><li>Prima di tutto: il nostro spazio web è limitato. Più file di grandi dimensioni ci sono, maggiore è lo spazio web necessario sul server. Più spazio abbiamo bisogno, maggiori saranno i nostri costi.</li><li>Larghezza di banda.  Più dati il nostro server deve inviare alla posizione remota (la tua posizione), più dobbiamo pagare. Questo perché la capacità di carico della connessione del server a Internet è limitata e il collegamento deve essere condiviso (e pagato) da tutte le applicazioni in esecuzione sul server. PhpGedView è una delle tante applicazioni che condividono il server. Il costo viene normalmente ripartito in base alla quantità di dati inviati e ricevuti da ciascuna applicazione.</li><li>Tempo di download. Se hai file di grandi dimensioni, l'utente (anche tu) dovrà attendere a lungo affinché la pagina venga scaricata dal server. Non tutti sono benedetti con una connessione via cavo, a banda larga o DSL.</li></ul><br /><br /><b>Come caricare i tuoi media</b><br />Esistono due modi per caricare i media sul sito. Se hai molti elementi multimediali da caricare, contatta l'amministratore del sito per discutere i modi migliori. Se è stato abilitato dall'amministratore del tuo sito, puoi utilizzare il modulo Carica media nel menu #pgv_lang[mgv]#. È inoltre possibile utilizzare l'opzione Carica nel modulo Multimedia per caricare elementi multimediali.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Questa opzione genererà le miniature per tutti i file nella directory corrente che non hanno già una miniatura. Questo è molto più comodo che fare clic sul collegamento <b>#pgv_lang[gen_thumb]#</b> per ciascuno di questi file.<br /><br />Se desideri mantenere il controllo su quali file dovrebbero avere le miniature corrispondenti, non dovresti usare questa opzione. Fare invece clic sui collegamenti <b>#pgv_lang[gen_thumb]#</b> appropriati.";
$pgv_lang["add_facts_general_help"]      = "~Informazioni generali sull'aggiunta~<br /><br />Dopo aver aggiunto un fatto, una nota, una fonte o un file multimediale a un record nel database, l'aggiunta deve ancora essere approvata da un utente che dispone dei diritti di accettazione.<br /><br />Fino a quando le modifiche non sono state accettate, sono identificati come \"in sospeso\" da un bordo colorato in modo diverso. Tutti gli utenti con diritti di modifica possono vedere queste modifiche così come le informazioni originali. Gli utenti che non dispongono dei diritti di modifica vedranno solo le informazioni originali. Quando l'aggiunta è stata accettata, i bordi scompariranno e i nuovi dati verranno visualizzati normalmente, sostituendo i vecchi. A quel punto, anche gli utenti senza diritti di modifica vedranno i nuovi dati.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Qui puoi modificare le impostazioni e le preferenze.<br /><br /> Puoi cambiare il tuo nome utente, nome completo, password, lingua, indirizzo email, tema del sito e metodo di contatto preferito.<br /><br />Non è possibile modificare l'identificativo del record GEDCOM INDI; che deve essere fatto da un amministratore.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />In questa casella puoi modificare il tuo nome utente. Se non ti piace più il tuo nome utente o se hai altri motivi per cambiarlo, puoi farlo utilizzando questo modulo.<br /><br />Il nome utente <u>tiene conto del maiuscolo o minuscolo</u>. Ciò significa che <b>John</b> non è uguale a <b>john</b> o <b>JOHN</b>.<br /><br />Dovresti <u>solo</u> usa i caratteri degli alfabeti supportati da PhpGedView. È possibile utilizzare lettere maiuscole e minuscole con o senza segni diacritici, numeri, trattino (-) e trattino basso (_). <u>Non</u> utilizzare segni di punteggiatura o spazi.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In questa casella puoi cambiare il tuo nome. Questo è il nome che gli altri utenti vedono quando si effettua il login.<br /><br />Sebbene la scelta di cosa inserire in questo campo sia tua, dovresti informare l'amministratore quando lo modifichi. Quando altri vedono una persona sconosciuta in linea, potrebbero chiedersi e fare domande. L'amministratore può scoprirlo senza aver ricevuto il tuo avviso, ma dovresti risparmiargli quel lavoro non necessario.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />In questa casella puoi cambiare il tuo cognome. Questo è il nome che gli altri utenti vedono quando si effettua il login.<br /><br />Sebbene la scelta di cosa inserire in questo campo sia tua, dovresti informare l'amministratore quando lo modifichi. Quando altri vedono una persona sconosciuta in linea, potrebbero chiedersi e fare domande. L'amministratore può scoprirlo senza aver ricevuto il tuo avviso, ma dovresti risparmiargli quel lavoro non necessario.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Questo è un numero di identificazione che ti collega ai tuoi dati nel database.<br /><br />Non puoi modificare questo numero; è impostato dall'amministratore. Se ritieni che questo identificatore non sia corretto, contatta l'amministratore per farlo cambiare.";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Questa è la persona iniziale (radice) di tutti i tuoi grafici.<br /><br />Se, ad esempio, facessi clic sul collegamento al pedigree, vedresti questa persona radice nel riquadro più a sinistra. Questa persona radice non devi essere tu; puoi iniziare con qualsiasi persona (tuo nonno o la zia di tua madre, per esempio), purché tu abbia i diritti per vedere quella persona.<br /><br />Questa opzione cambia la persona radice predefinita per la maggior parte dei grafici. Puoi cambiare la persona Root effettivamente utilizzata in molti grafici, ma è solo per quella pagina in quel particolare momento.";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />È buona norma cambiare la password regolarmente. Tieni presente che chiunque conosca il tuo nome utente e la tua password avrà accesso ai tuoi dati.<br /><br />Rendi la password lunga almeno 6 caratteri, più lunga è, meglio è. È possibile utilizzare lettere maiuscole e minuscole con o senza segni diacritici, numeri, trattino (-) e trattino basso (_). <u>Non</u> utilizzare segni di punteggiatura o spazi. Usa una combinazione di lettere maiuscole e minuscole, numeri e altri caratteri. Ad esempio: <b>5Z_q\$P4=r9</b>.<br /><br />Come il nome utente, la password utente <u>tiene conto del maiuscolo o minuscolo</u>. Ciò significa che <b>Password.Segreta!#13</b> non è uguale a <b>password.segreta!#13</b> o <b>PASSWORD.SEGRETA!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Se hai cambiato la tua password, devi confermarla anche tu. Questo è solo per assicurarti di non aver commesso un errore di digitazione nel campo della password.<br /><br />Se la password e la sua conferma non sono identiche, riceverai un messaggio di errore appropriato. Dovrai ridigitare sia la password originale che la sua conferma.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Qui puoi cambiare la lingua in cui PhpGedview mostrerà tutte le sue pagine e messaggi dopo aver effettuato l'accesso.<br /><br />Quando accedi per la prima volta al sito, PhpGedView presume che tu voglia vedere tutto nella lingua configurata come la lingua preferita nel tuo browser. Se questo presupposto non è corretto, lo sovrascriveresti qui. Ad esempio, il tuo browser potrebbe essere impostato sull'inglese perché questa è la lingua più diffusa su Internet. Tuttavia, per scopi genealogici, preferiresti vedere tutto in finlandese o italiano. Ecco dove puoi farlo.<br /><br />L'amministratore controlla le scelte di lingua disponibili. Se la tua preferenza non è elencata, devi contattare l'amministratore.<br /><br />Ricorda che PhpGedView è un progetto gestito da un team internazionale di volontari non retribuiti. Gli esperti vanno e vengono. Di conseguenza, il supporto per lingue diverse dall'inglese a volte non è buono come dovrebbe essere.<br /><br />Se vedi qualcosa che non è stato tradotto, è stato tradotto in modo errato o potrebbe essere formulato meglio, lascia che il tuo amministratore conoscere. L'amministratore saprà come mettersi in contatto con il team di sviluppatori di PhpGedView per far fronte alle tue preoccupazioni. Meglio ancora, offri volontariamente un po 'del tuo tempo. Possiamo usare l'aiuto.";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Il tuo indirizzo email corretto è importante per noi per restare in contatto con te.<br /><br />Se ricevi un nuovo indirizzo email, come di solito accade quando cambi il tuo provider Internet, non dimenticare di cambiare l'indirizzo qui anche. Non riceverai un messaggio di conferma da questo sito quando cambi questo indirizzo, ma tutti i messaggi futuri diretti a te andranno a questo nuovo indirizzo.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Questo sito può avere diversi sguardi o aspetti diversi. Altri programmi potrebbero chiamarli \"skin\", ma qui sono \"temi\".<br /><br />Ogni tema mostrerà gli stessi dati, ma la sua presentazione o anche la sua posizione sullo schermo può variare. È come mettere un'immagine in una cornice diversa e appenderla anche in una stanza diversa. L'immagine non cambia, ma il modo in cui la guardi è completamente diverso.<br /><br />Fai un tentativo. Impostalo su un altro tema. Guardalo, provane un altro. Torna a quello che ti si addice meglio. Ogni volta che accedi, vedrai il tema che hai utilizzato l'ultima volta; non è nemmeno necessario accedere a questa pagina di configurazione per modificare il tema preferito.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView ha diversi metodi di contatto differenti. L'amministratore determina quale metodo verrà utilizzato per contattarlo. Hai il controllo sul metodo da utilizzare per contattare <u>te</u>. A seconda della configurazione del sito, alcuni dei metodi elencati potrebbero non essere disponibili.";
$pgv_lang["mail_option1_help"]			= "Con questa opzione, verrà utilizzato il sistema di messaggistica interno di PhpGedView e non verranno inviate email.<br /><br /> Riceverai solo messaggi <u>interni</u> dagli altri utenti. Quando un altro utente del sito ti invia un messaggio, quel messaggio apparirà nel blocco dei messaggi sulla tua pagina personale #pgv_lang[mygedview]#. Se hai rimosso questo blocco dalla tua pagina #pgv_lang[mygedview]#, non vedrai alcun messaggio. Tuttavia, verranno visualizzati non appena configurerai la pagina #pgv_lang[mygedview]# per avere nuovamente il blocco messaggi.";
$pgv_lang["mail_option2_help"]			= "Questa opzione è come #pgv_lang[messaging]#, con un'aggiunta. Inoltre, una copia del messaggio verrà inviata anche all'indirizzo e-mail che hai configurato nella pagina del tuo account.<br /><br />Questo è il metodo di contatto predefinito.";
$pgv_lang["mail_option3_help"]			= "Con questa opzione, riceverai solo messaggi di posta elettronica all'indirizzo che hai configurato nella pagina Account. Il sistema di messaggistica interno a PhpGedView non verrà utilizzato affatto e non ci saranno mai messaggi nel blocco Messaggi sulla tua pagina personale #pgv_lang[mygedview]#.";
$pgv_lang["mail_option4_help"]			= "Con questa opzione non riceverai alcun messaggio. Anche l'amministratore non potrà contattarti.";

//-- Admin
$pgv_lang["admin_help"]				= "In questa pagina troverai collegamenti alle pagine di configurazione, pagine di amministrazione, documentazione e file di registro.<br /><br /><b>#pgv_lang[system_time]#</b>, appena sotto il titolo della pagina, mostra l'ora del server su cui è ospitato il tuo sito. Ciò significa che se il server si trova a New York mentre sei in Italia, l'ora mostrata sarà di sei ore inferiore all'ora locale, a meno che, ovviamente, il server non sia in esecuzione sul Greenwich Mean Time (GMT). L'ora mostrata è l'ora del server quando hai aperto o aggiornato questa pagina.<br /><br /><b>AVVERTIMENTO</b><br />Quando vedi un messaggio di avviso rosso sotto l'ora di sistema, significa che il tuo <i>config.php</i> è ancora scrivibile. Dopo aver configurato il tuo sito, dovresti, per <b>sicurezza</b>, impostare di nuovo le autorizzazioni di questo file su sola lettura. Devi farlo <u>manualmente</u>, poiché PhpGedView non può farlo per te.";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~#pgv_lang[user_admin]#~<br /><br />In questa pagina puoi amministrare gli utenti attuali e aggiungere nuovi utenti.<br /><br /><b>#pgv_lang[current_users]#</b><br />In questa tabella vengono visualizzati gli utenti correnti, il loro stato e i loro diritti. Puoi <b>eliminare</b> o <b>modificare</b> gli utenti.<br /><br /><b>#pgv_lang[add_user]#</b><br />Questo modulo è quasi uguale a quello che gli utenti vedono nella pagina <b>#pgv_lang[editowndata]#</b>.<br /><br />Per diversi argomenti non abbiamo creato un testo di aiuto speciale per l'amministratore. In questi casi vedrai il seguente messaggio:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />L'#pgv_lang[gedcomid]# identifica l'utente. Deve essere impostato dall'amministratore.<br /><br />Questo numero viene utilizzato come identificatore in diverse pagine come <b>#pgv_lang[my_indi]#</b> e <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Puoi impostare l'identificatore GEDCOM dell'utente separatamente per ogni GEDCOM. Se un utente non ha un record in un GEDCOM, lasci la casella vuota.";
$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Per ogni database genealogico, puoi designare una <b>persona radice</b> per l'utente.<br /><br />Questa persona radice non deve essere l'utente stesso; può essere chiunque. L'utente probabilmente vorrà iniziare da solo l'albero genealogico. Puoi controllare questo, così come la persona root predefinita su altri grafici, qui.<br /><br />Se l'utente dispone dei diritti di modifica delle informazioni del proprio account, può modificare questa impostazione da solo.";
$pgv_lang["useradmin_can_admin_help"]		= "~#pgv_lang[can_admin]#~<br /><br />Se questa casella è selezionata, l'utente avrà gli stessi diritti che hai tu.<br /><br />Questi diritti includono:<ul><li>Aggiungi / Rimuovi / Modifica utenti</li><li>Trasmetti messaggi a tutti gli utenti</li><li>Modifica i messaggi di benvenuto</li><li>Modifica e configura i file di lingua</li><li>Aggiorna PhpGedView</li><li>Cambia programma e configurazioni GEDCOM</li><li>Amministra i GEDCOM</li><li>Modifica le impostazioni sulla privacy</li><li>E tutto ciò che non è menzionato qui.</li></ul><br />L'utente <u>non può</u> modificare nulla sul tuo server al di fuori di PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Se questa casella è selezionata e all'utente è stato assegnato un identificatore GEDCOM, le impostazioni dell'account utente verranno automaticamente sincronizzate con i dati GEDCOM. Ciò significa che quando il record GEDCOM dell'utente viene modificato, alcune delle informazioni come l'indirizzo e-mail e il nome verranno copiate nell'account dell'utente. Quando l'account dell'utente viene modificato, le informazioni corrispondenti verranno copiate nel record GEDCOM.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />L'utente può avere diversi privilegi di accesso e modifica per ogni database genealogico nel sistema.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;L'utente non può accedere ai dati privati in questo GEDCOM.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;L'utente non può modificare o accettare dati nel database ma può vedere i dati privati.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;L'utente può modificare i valori ma un altro utente con privilegi <b>#pgv_lang[accept]#</b> deve approvare le modifiche prima che vengano aggiunte al database e rese pubbliche.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;L'utente può modificare. Può anche modificare e approvare le modifiche apportate da altri utenti.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;L'utente modifica e approva le modifiche apportate da altri utenti. L'utente può anche modificare la configurazione e le impostazioni di privacy per <u>questo</u> GEDCOM.</li></ul>Gli amministratori di sistema, identificati tramite la casella <b>#pgv_lang[can_admin]#</b>, ricevono automaticamente i privilegi <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Auto registrazione</b><br />Un utente può richiedere un nuovo account tramite il modulo <b>auto registrazione</b>.<br /><br />Quando lo farà, riceverà un messaggio di posta elettronica con un collegamento per verificare la sua domanda. Dopo che il richiedente ha agito in base alle istruzioni in quell'e-mail, vedrai questa casella selezionata e potrai procedere con il passaggio successivo, <b>#pgv_lang[verified_by_admin]#</b>. Dovresti attendere la tua approvazione finché questa casella non è selezionata.<br /><br /><b>Aggiungi utente manualmente</b><br />Se utilizzi questo modulo per aggiungere manualmente un utente, lo farai trova questa casella già selezionata.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />Se un utente ha utilizzato il modulo di autoregistrazione e si è verificato, l'ultimo passaggio, prima che il suo account diventi attivo, è la tua approvazione.<br /><br />Dopo aver approvato la richiesta dell'utente per un nuovo account, il l'utente riceverà un messaggio di posta elettronica. Il messaggio dirà all'utente che il suo account è ora attivo. Può accedere con il nome utente e la password che ha fornito quando ha richiesto l'account.";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />Questo modulo viene utilizzato dall'amministratore per modificare l'account di un utente.<br /><br />Il modulo è molto simile ai moduli <b>#pgv_lang[add_user]#</b> e <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]		= "~#pgv_lang[visibleonline]#~<br /><br />Questa casella controlla la tua visibilità ad altri utenti mentre sei online. Controlla anche la tua capacità di vedere altri utenti online che sono configurati per essere visibili.<br /><br /> Quando questa casella è deselezionata, sarai completamente invisibile agli altri e non potrai nemmeno vedere altri utenti online utenti. Quando questa casella è selezionata, è vero esattamente il contrario. Sarai visibile agli altri e potrai anche vedere gli altri che sono configurati per essere visibili.";
$pgv_lang["useradmin_editaccount_help"]			= "~#pgv_lang[editaccount]#~<br /><br />Se questa casella è selezionata, questo utente sarà in grado di modificare le informazioni del suo account. Sebbene ciò non sia generalmente consigliato, è possibile creare un unico nome utente e password per più utenti. Quando questa casella è deselezionata per tutti gli utenti con l'account condiviso, viene loro impedito di modificare le informazioni sull'account e solo un amministratore può modificare quell'account.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Se questa casella è selezionata, all'utente sarà consentito l'accesso solo alle persone in vita a cui è correlato. Saranno in grado di vedere chiunque si trovi all'interno della lunghezza del percorso di relazione impostata dalla loro impostazione <i>#pgv_lang[user_path_length]#</i>. Puoi richiedere la privacy della relazione per tutti i tuoi utenti attivando l'opzione globale nelle impostazioni della privacy di GEDCOM.<br /><br />Questa impostazione richiede che l'utente sia associato a un identificatore GEDCOM prima di poter vedere le persone in vita.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Se <i>#pgv_lang[user_relationship_priv]#</i> è abilitato, questo utente sarà in grado di vedere o modificare solo le persone in vita entro questo numero di passaggi della relazione.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Selezionando questa casella si consente al sistema di accettare automaticamente qualsiasi modifica apportata da questo utente. L'utente deve anche avere i privilegi di accettazione su GEDCOM affinché questa impostazione abbia effetto.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />In questa pagina puoi aggiungere siti remoti e negare l'accesso da indirizzi IP specifici.<br /><br />I siti remoti possono essere aggiunti fornendo il titolo del sito, l'URL, l'ID database (opzionale), il nome utente e la password per il telecomando servizio Web.<br /><br />La negazione dell'accesso IP permanente o temporizzata si ottiene fornendo un indirizzo IP esatto o qualsiasi intervallo di indirizzi IP valido. Ad esempio, 212.10.*.* I siti remoti all'interno degli intervalli di indirizzi IP nell'elenco non saranno in grado di accedere al tuo sito.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />Per aggiungere un sito remoto, fornire il titolo del sito, l'URL del servizio Web remoto, l'ID del database (facoltativo) e il nome utente e la password. Fare clic sul pulsante Aggiungi (+) per completare il processo. Se il server remoto consente l'autenticazione anonima, è necessario lasciare il nome utente e la password vuoti.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "Gli indirizzi IPv4 sono costituiti da 4 segmenti separati da \".\" (punto) e contenenti numeri decimali compresi tra zero e 255 senza zeri iniziali. Esempi sono: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> o <b>212.10.*.29</b> .  I segmenti mancanti in questi esempi verranno interpretati come \"*\" (asterisco), con quel simbolo \"*\" che significa <i>corrisponde a qualsiasi numero in questa posizione</i>.<br /><br />Gli indirizzi IPv6 sono costituiti da 8 segmenti separati da \":\" (due punti) e contenenti numeri esadecimali di 4 cifre. Questi numeri non devono avere zero iniziali e la prima sequenza di zeri può essere rimossa e sostituita da una coppia di simboli  \":\" (due punti). Se è necessario utilizzare la funzione <i>abbina qualsiasi numero in questa posizione</i>, è necessario inserire esplicitamente \"*\" (asterisco) lì. Esempi sono: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> o <b>23:0:*::*:*</b> .  In questi esempi, la coppia di due punti rappresenta una sequenza di 3 numeri, ciascuno dei quali è zero, in questo modo: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />Per impedire a indirizzi IPv4 o IPv6 specifici di accedere al tuo sito, inserisci un indirizzo IP esatto o un intervallo di indirizzi IP valido e fai clic sul pulsante Aggiungi (+).<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />Quando viene rilevato un tentativo di hacking, PhpGedView impedirà automaticamente l'accesso da quell'indirizzo IP per un'ora.<br /><br />Puoi aggiungere i tuoi dinieghi di accesso a tempo inserendo l'indirizzo IPv4 o IPv6 da bloccare insieme alla data e l'ora di scadenza del rifiuto di accesso nel campo Commenti. Assicurati di utilizzare il formato corretto per le informazioni sulla scadenza. Se le informazioni sulla scadenza non vengono inserite correttamente, il rifiuto di accesso non scadrà automaticamente.<br /><br />La scadenza deve essere inserita nel seguente formato: <b>aaaa.mm.gg@hh:mm</b>. Ad esempio, <b>2012.12.23@23:59</b>. Notare l'uso dell'orologio a 24 ore.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]	= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView fornisce automaticamente ai motori di ricerca file di dati più piccoli con meno collegamenti. I dati sono limitati all'individuo e alla famiglia immediata, senza aggiungere informazioni sui nonni o nipoti. Molti rapporti e pagine ad alta intensità di server come il calendario sono vietati ai motori di ricerca.<br /><br />Molti motori di ricerca popolari come Google e Bing verranno rilevati automaticamente. Se un motore di ricerca non viene riconosciuto automaticamente e desideri fornirgli i dati da indicizzare, puoi inserire qui il suo indirizzo IPv4 o IPv6. Se vuoi escludere completamente questo nuovo motore di ricerca, inseriscilo nella sezione <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Se desideri vedere quali dati vengono forniti ai motori di ricerca da indicizzare, elenca qui il tuo indirizzo IP.&nbsp; <span class='warning'>AVVISO:</span>&nbsp; Questo <b>ti bloccherà</b> dell'interfaccia di amministrazione e dovrai rimuovere l'indirizzo IP accedendo da una macchina diversa con un indirizzo IP diverso o modificando manualmente la tabella del database <i>#GLOBALS[TBLPREFIX]#ip_address</i>.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Motore ricerca rilevato~<br /><br />PhpGedView fornisce automaticamente ai motori di ricerca file di dati più piccoli con meno collegamenti. I dati sono limitati alla persona e ai familiari stretti, senza aggiungere informazioni sui nonni o nipoti. Molti rapporti e pagine ad alta intensità di server come il calendario sono vietati ai motori di ricerca.<br /><br />I tentativi da parte dei motori di ricerca di accedere a tali pagine risultano nella visualizzazione di questa pagina. Se stai vedendo questo testo, il software crede che tu sia un motore di ricerca. Di seguito è riportato l'elenco delle pagine a cui è consentito l'accesso e fornirà i dati abbreviati.<br /><br />Gli utenti reali che seguono i collegamenti dei motori di ricerca in questo sito vedranno le pagine complete e i dati, e non questa pagina.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Caricamento di file GEDCOM</b><br />Il caricamento dei file può essere effettuato in linea. Puoi caricare da qualsiasi luogo senza bisogno di un programma ftp.<br /><br /><b>Aggiunta di file GEDCOM</b><br />Se un file caricato in precedenza è ancora presente nella directory <b>/index</b>, puoi utilizzarlo di nuovo senza caricarlo. A volte, a causa dei limiti di dimensione del file o del caricamento, è necessario utilizzare Aggiungi.<br /><br />La procedura di aggiunta e caricamento può essere completata in quattro semplici passaggi. In entrambe le procedure, solo il passaggio 1 è diverso.";
$pgv_lang["gedcom_configfile_help"]		= "~File configurazione GEDCOM~<br /><br />Questo è il file in cui sono memorizzate tutte le impostazioni di base relative al database genealogico. C'è un file separato per ciascuno di questi database.<br /><br />Troverai il percorso e il nome di ogni file di configurazione nella tabella <b>#pgv_lang[current_gedcoms]#</b> nella pagina <b>#pgv_lang[gedcom_adm_head]#</b>.";
$pgv_lang["default_gedcom_help"]		= "~GEDCOM PREDEFINITO~<br /><br />Se hai più di un database genealogico, puoi impostare qui quale di essi sarà quello predefinito.<br /><br /> Questo valore predefinito verrà mostrato a tutti i visitatori e agli utenti che non hanno ancora effettuato l'accesso.<br /><br /> Gli utenti che possono modificare le impostazioni dell'account possono ignorare questa impostazione predefinita. In tal caso, il database preferito dell'utente verrà visualizzato dopo il login.";
$pgv_lang["delete_gedcom_help"]			= "~ELIMINARE GEDCOM~<br /><br />PhpGedView crea il suo database da un file GEDCOM precedentemente caricato. Quando selezioni <b>Elimina</b>, quella sezione del database verrà cancellata. Devi confermare la tua richiesta di eliminazione.<br /><br />A meno che tu non l'abbia deliberatamente rimosso al di fuori di PhpGedView, il file GEDCOM originale rimarrà nella directory in cui è stato caricato. Se in seguito desideri lavorare di nuovo con quel file GEDCOM, non devi caricarlo di nuovo.Puoi scegliere la funzione <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Quando utilizzi la funzione <b>#pgv_lang[add_gedcom]#</b>, si presume che tu abbia già caricato il file GEDCOM sul tuo server utilizzando un programma o un metodo <u>esterno</u> a PhpGedView, ad esempio <i>ftp</i> o <i>connessione di rete</i>. Il file che desideri aggiungere potrebbe anche essere stato lasciato da una precedente procedura <b>#pgv_lang[upload_gedcom]#</b>.<br /><br />Se il file GEDCOM di input non è ancora sul tuo server, <u>devi</u> scaricarlo lì prima, prima di poter iniziare con l'aggiunta.<br /><br />Invece di caricare un file GEDCOM, puoi anche caricare un file ZIP contenente il file GEDCOM, sia con PhpGedView, sia utilizzando un programma esterno. PhpGedView riconoscerà automaticamente il file ZIP ed estrarrà il file GEDCOM e il nome del file dal file ZIP.<br /><br />Se un file GEDCOM con lo stesso nome esiste già in PhpGedView, verrà sovrascritto. Tuttavia, tutte le impostazioni GEDCOM effettuate in precedenza verranno conservate.<br /><br />Sarai guidato passo passo attraverso la procedura.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Puoi avviare un nuovo database genealogico da zero.<br /><br /> Questa procedura richiede solo pochi semplici passaggi. Il passaggio 1 è diverso da quello che sai già sul caricamento e sull'aggiunta. Gli altri passaggi risulteranno familiari.<ol><li><b>Denominazione del nuovo GEDCOM</b><br />Digita il nome del nuovo GEDCOM <u>senza</u> l'estensione <b>.ged</b>. Il nuovo file verrà creato nella directory denominata sopra la casella in cui inserisci il nome. Fare clic su <b>Aggiungi</b>.</li><li><b>Pagina di configurazione</b><br />Conosci già questa pagina; configuri le impostazioni per il tuo nuovo file GEDCOM.</li><li><b>Convalidare</b><br />Conosci già questa pagina; il nuovo GEDCOM viene verificato. Dato che non contiene nulla, andrà bene.</li><li><b>Importazione di record</b><br />Poiché ci sarà un solo record da importare, questo verrà completato molto velocemente.</li></ol>Ora puoi andare all'albero genealogico per vedere la tua prima persona nel nuovo GEDCOM. Fare clic sul nome della persona e iniziare a modificare. Successivamente, puoi collegare nuove persone alla prima persona.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Da questa pagina puoi scaricare il tuo database genealogico in formato GEDCOM. Potresti voler importare i dati in un altro programma genealogico o condividere le sue informazioni con altri.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />Questa pagina è il centro di controllo per l'amministrazione di tutti i tuoi database genealogici.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />All'inizio della tabella <b>#pgv_lang[current_gedcoms]#</b>, vedi una barra delle azioni con quattro collegamenti.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />Nella tabella <b>#pgv_lang[current_gedcoms]#</b> ogni database genealogico è elencato separatamente e hai le seguenti opzioni per ciascuno di essi:<ul><li>Importare</li><li>Elimina</li><li>Scarica</li><li>Modifica configurazione</li><li>Modifica privacy</li><li>File di registro di ricerca</li></ul>Modifica privacy appare qui perché ogni GEDCOM ha il proprio file di privacy.<br /><br />Ogni riga in questa tabella dovrebbe essere autoesplicativa. PhpGedView può essere configurato per registrare tutte le ricerche nel database. I file di registro di ricerca possono essere controllati tramite i collegamenti presenti in questa pagina.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]		= "~CONFIGURARE GEDCOM~<br /><br />Ogni database genealogico utilizzato con PhpGedView ha il proprio <b>File di configurazione</b>.<br /><br />In questo modulo si configurano molte opzioni come titolo del database, lingua, formato del calendario, opzioni di posta elettronica, registrazione del database ricerche, intestazioni META HTML, rimozione di cognomi dall'elenco dei cognomi frequenti del database, ecc.";
$pgv_lang["import_gedcom_help"]			= "~IMPORTA GEDCOM~<br /><br />Nella maggior parte dei casi l'importazione di un file GEDCOM creato esternamente è un passaggio nelle procedure che comportano modifiche di massa al database genealogico.<br /><br />Questi passaggi sono in una sequenza logica e devono essere completati nell'ordine prescritto, quindi che il database genealogico è utilizzabile.<br /><br />Se, per qualche motivo, non hai completato questi passaggi nell'ordine corretto, vedrai un <u>avviso</u> messaggio che GEDCOM non è ancora importato. Per correggere il problema, fai clic sul link <b>Importa GEDCOM</b> per importare il file.<br /><br />Le impostazioni di configurazione GEDCOM esistenti non cambieranno quando reimporterai un GEDCOM. I dati esistenti, tuttavia, verranno sovrascritti.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />A differenza della funzione <b>#pgv_lang[add_gedcom]#</b>, il file GEDCOM che desideri aggiungere al tuo database non deve essere necessariamente sul tuo server.<br /><br />Nel passaggio 1 seleziona un file GEDCOM dal tuo computer locale. Digita il percorso completo e il nome del file nella casella di testo o utilizza il pulsante <b>Sfoglia</b> nella pagina.<br /><br />Puoi anche utilizzare questa funzione per caricare un file ZIP contenente il file GEDCOM. PhpGedView riconoscerà il file ZIP ed estrarrà automaticamente il file e il nome del file.<br /><br />Se un file GEDCOM con lo stesso nome esiste già in PhpGedView, dopo la tua conferma verrà sovrascritto. Tuttavia, tutte le impostazioni GEDCOM effettuate in precedenza verranno conservate.<br /><br />Troverai ulteriore aiuto in altre pagine della procedura.";
$pgv_lang["validate_gedcom_help"]		= "~CONVALIDA GEDCOM~<br /><br />Questo è il terzo passaggio della procedura per aggiungere dati GEDCOM creati esternamente al tuo database genealogico.<br /><br />PhpGedView controllerà il file di input per il corretto utilizzo del formato data, formato luogo, set di caratteri, ecc. le deviazioni dallo Standard GEDCOM 5.5.1, a cui PhpGedView aderisce, possono essere corrette automaticamente. Esempi sono le terminazioni di riga Macintosh e l'uso non corretto del formato Luogo. Quando ciò accade, vedrai un messaggio che i dati sono stati modificati. Per altre anomalie riceverai un messaggio di avviso con una soluzione consigliata.<br /><br /><b>Strumenti opzionali</b><br />Al momento è disponibile solo uno strumento aggiuntivo: <b>Cambia l'identificativo della persona in ...</b>.<br /><br /><b>Più aiuto</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~CONVERTI ANSI IN UTF-8~<br /><br />Per garantire che le informazioni nei file GEDCOM di input vengano elaborate e visualizzate correttamente, questi file dovrebbero essere codificati in UTF-8.<br /><br />Alcuni dei più moderni programmi di genealogia possono esportare i propri dati in un file GEDCOM in Codifica UTF-8. I programmi più vecchi spesso non hanno questa capacità. Se il tuo programma non ti offre questa opzione, PhpGedView può convertire il file per te.<br /><br />Quando PhpGedView convalida il file di input, rileverà la codifica del file e ti consiglierà di conseguenza.";
$pgv_lang["detected_ansi2utf_help"]		= "~CODIFICA ANSI RILEVATA~<br /><br />Il file GEDCOM da convalidare ora è codificato nel set di caratteri ANSI. Si consiglia vivamente di convertire la codifica del file in UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~RILEVATO FORMATO DI DATA ERRATO~<br /><br /><b>IL FORMATO DELLA DATA VERRÀ MODIFICATO</b><br /><br />Il formato della data che è standard per PhpGedView e anche secondo lo standard GEDCOM 5.5.1 è <b>GG&nbsp;MMM&nbsp;AAAA (solo in inglese)</b> (e.g. 01&nbsp;JAN&nbsp;2004)<br /><br />Se, dopo che il tuo file GEDCOM è stato convalidato, vedi un messaggio che indica che è stato rilevato un formato di data errato, PhpGedView convertirà le date formattate in modo errato come prescritto dallo Standard.<br /><br />Tuttavia, puoi scegliere tra \"<b>giorno</b> prima del mese\" (GGG&nbsp;MMM&nbsp;AAAA), o \"<b>mese</b> prima del giorno\" (MMM&nbsp;GGG&nbsp;AAAA).<br /><br />Si consiglia di utilizzare il primo formato (giorno prima del mese).";
$pgv_lang["change_indi2id_help"]		= "~CAMBIA L'IDENTIFICATIVO DELLA PERSONA IN....~<br /><br />Questo strumento è stato progettato per gli utenti i cui programmi di genealogia utilizzano un identificatore diverso per le persone ogni volta che il GEDCOM viene esportato. Ad esempio, la prima volta che il GEDCOM viene esportato, l'identificativo di una persona potrebbe essere I100, ma la prossima volta che il GEDCOM viene esportato, l'identificativo della stessa persona viene cambiato in I234. Questi numeri che cambiano rendono difficile amministrare PhpGedView perché l'identificatore è il modo in cui le persone vengono referenziate.<br /><br />La maggior parte dei programmi di genealogia utilizza anche il tag RIN o REFN per dare a ogni persona un identificatore univoco che può essere utilizzato per fare riferimento al persona. Questo strumento sostituirà tutti gli identificatori di persona nel file GEDCOM con il campo (RIN o REFN) specificato.";
$pgv_lang["edit_privacy_help"]			= "In questa pagina puoi configurare tutte le impostazioni di privacy per il GEDCOM selezionato.<br /><br />Puoi controllare sotto il titolo della pagina per vedere che stai modificando il file di privacy corretto. Viene visualizzato in questo modo: (percorso/nomedeltuogedcom_priv.php)<br /><br /Se hai bisogno di più impostazioni, puoi apportare modifiche al file di privacy manualmente. Puoi leggere di più su questo sul sito web PhpGedView.";
$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) rilevato~<br /><br />Il file GEDCOM che stai importando ha uno speciale codice a 3 byte all'inizio. Questo codice speciale viene utilizzato da alcuni programmi per indicare che il file è stato registrato nel set di caratteri UTF-8.<br /><br />Sebbene questo codice speciale non sia realmente un errore, PhpGedView non funzionerà correttamente quando l'input file contiene il codice. Dovresti lasciare che PhpGedView rimuova il codice.";
$pgv_lang["invalid_header_help"]		= "~INTESTAZIONE GEDCOM NON VALIDA~<br /><br />Un file GEDCOM deve iniziare con <b>0&nbsp;HEAD</b>. PhpGedView ha rilevato che il file GEDCOM che stai importando non ha <b>0&nbsp;HEAD</b> come prima riga. Quando fai clic sul pulsante Pulisci, tutte le righe prima della prima riga <b>0&nbsp;HEAD</b> verranno rimosse.<br /><br />Questo errore di solito significa che il programma che hai utilizzato per creare il tuo GEDCOM non lo ha creato correttamente o non è un GEDCOM file. Dovresti verificare di aver caricato il file corretto e che inizi con la riga <b>0&nbsp;HEAD</b> e termini con la riga b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~FILE MACINTOSH RILEVATO~<br /><br />PhpGedView ha rilevato che il tuo file GEDCOM è stato creato su un computer Macintosh.<ul><li>I file Macintosh terminano ogni riga con un codice di controllo CR. CR è Ctrl+M.</li><li>I file Unix terminano ogni riga con un codice di controllo LF. LF è Ctrl+J.</li><li>Windows e DOS utilizzano una sequenza di due codici, CR seguito da LF.</li></ul>PhpGedView richiede che tutti i file utilizzino terminazioni di riga Unix o DOS. Quando fai clic sul pulsante Pulisci, le terminazioni di riga verranno convertite di conseguenza.";
$pgv_lang["cleanup_places_help"]		= "~PULIRE LUOGHI~<br /><br />PhpGedView ha rilevato che il tuo file GEDCOM utilizza luoghi sui tag GEDCOM che non dovrebbero avere luoghi.<br /><br />Molti programmi di genealogia, come Family Tree Maker, creeranno questo tipo di file GEDCOM. PhpGedView funzionerà con questi file GEDCOM, ma alcuni luoghi non validi verranno visualizzati nella gerarchia dei luoghi.<br /><br />Ad esempio, il tuo GEDCOM potrebbe avere la seguente codifica<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Programmatore di computer</div><br />Secondo lo standard GEDCOM 5.5.1 questo dovrebbe essere mostrato come<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Programmatore di computer</div><br />Se selezioni <b>Sì</b>, PhpGedView correggerà automaticamente questi errori di codifica.";
$pgv_lang["empty_lines_detected_help"]	= "~RILEVATE RIGHE VUOTE~<br /><br />PhpGedView ha rilevato che ci sono righe vuote nel file di input. Queste righe possono causare errori e verranno rimosse dal file prima dell'importazione.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~CONFIGURARE PhpGedView~<br /><br />In questa pagina si configurano le impostazioni globali per PhpGedView. Devi farlo dopo aver installato PhpGedView e averlo eseguito per la prima volta.<br /><br />#pgv_lang[review_readme]#<br /><br />Poiché queste impostazioni sono <b>globali</b>, sono per l'intero programma e per tutti i database genealogici che utilizzi con PhpGedView.<br /><br />Ogni database genealogico ha anche opzioni di configurazione aggiuntive che puoi impostare dopo aver fatto clic su il collegamento <b>#pgv_lang[admin_gedcoms]#</b> in questa pagina.<br /><br />È inoltre possibile accedere alla funzione #pgv_lang[gedcom_adm_head]# dalla pagina principale di amministrazione, il cui collegamento si trova sotto l'icona #pgv_lang[mgv] o nell'intestazione della maggior parte delle pagine. Nella pagina Amministratore, il collegamento pertinente è denominato <b>#pgv_lang[manage_gedcoms]#.</b>";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Questa pagina ti consentirà di unire due record GEDCOM dallo stesso file GEDCOM.<br /><br />Questo è utile per le persone che hanno unito GEDCOM e ora hanno molte persone, famiglie e fonti che sono le stesse.<br /><br />La pagina è composta da tre passaggi.<br /><ol><li>Inserisci due identificatori GEDCOM. Gli identificatori <u>devono</u> essere dello stesso tipo. Non puoi unire una persona e una famiglia o una famiglia e una fonte, per esempio.<br />Nel campo <b>#pgv_lang[merge_to]#</b> inserisci l'identificativo del record che vuoi che diventi il nuovo record dopo che l'unione è stata completata.<br />Nel campo <b>#pgv_lang[merge_from]#</b> inserisci l'identificativo del record le cui informazioni saranno unite nel record #pgv_lang[merge_to]#. Questo record verrà eliminato dopo l'unione.</li><li>Seleziona i fatti che desideri conservare dai due record quando vengono uniti. Basta fare clic sulle caselle di controllo accanto a quelle che desideri conservare.</li><li>Controlli i risultati dell'unione, proprio come con tutte le altre modifiche apportate online.</li></ol>Qualcuno con diritti di accettazione dovrà autorizzare le tue modifiche per renderle permanenti.";

//-- report engine
$pgv_lang["help_reportengine.php"]	= "~#pgv_lang[reports]#~<br /><br />Gli elementi nel menu dei rapporti genereranno file PDF per la stampa.<br /><br />Il primo passo è scegliere un rapporto da eseguire. Dopo aver selezionato un rapporto da eseguire, ti verrà chiesto di fornire alcune informazioni specifiche per quel rapporto, ad esempio con quale persona o famiglia iniziare e se mostrare o meno le foto. Quando sei pronto per eseguire il rapporto, fai clic sul pulsante <b>#pgv_lang[download_report]#</b> per scaricare il rapporto sul tuo computer.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]	= "~FORMATO DI FILE PDF~<br /><br />Il motore di reportistica di PhpGedView produce report scaricabili in Adobe&reg; Formato PDF. La specifica GEDCOM 5.5.1 Standard, menzionata altrove in questo file della Guida, è anche scaricabile come file PDF. PDF è l'acronimo di <b>P</b> ortable <b>D</b>ocument <b>F</b>ormat (Formato Documento Portatile).";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br /><br />Questa è un rapporto della persona selezionata e dei suoi antenati, stampata in formato opuscolo. Inizia con la prima persona e poi continua con i suoi genitori, nonni, ecc.<br /><br />Si noti che al momento il rapporto ahnentafel è disponibile solo in inglese.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br /><br />Con questo rapporto puoi elencare tutte le persone che sono nate in un determinato momento o luogo.";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br /><br />Questo rapporto elencherà tutti i parenti della persona selezionata. Puoi scegliere quale dei parenti della persona mostrare nel rapporto.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;mostrerà la persona selezionata, i suoi genitori e i suoi fratelli e sorelle.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;elencherà la persona con i suoi coniugi e i loro figli.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;elencherà la persona, i suoi genitori, i nonni, i bisnonni e continuerà l'albero elencando tutte le persone che sono genitori nel lignaggio della persona.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;elencherà tutte le persone dell'elenco #pgv_lang[direct-ancestors]# ma includerà anche zie e zii, prozie e prozii, quindi includerà i fratelli di tutti gli antenati nell'albero genealogico di questa persona. Non elencherà i figli dei fratelli (cugini).</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;elencherà tutti i discendenti di questa persona (figli, nipoti, pronipoti, ecc.)</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;questa opzione è una combinazione di #pgv_lang[descendants]# e #pgv_lang[ancestors]# in un unico rapporto.</li></ul>";
$pgv_lang["help_xml_reports"]	= "~MOTORE RAPPORTO~<br /><br />Il motore di rapporto di PhpGedView utilizza file modello XML per generare automaticamente report PDF.<br /><br />I rapporti disponibili nell'elenco <b>#pgv_lang[select_report]#</b> vengono generati dai file XML dei rapporti che si trovano nella directory \"reports\". È possibile creare report personalizzati facendo una copia di uno qualsiasi dei modelli forniti e modificando il modello XML. Per aggiungere il tuo report personalizzato, basta inserirlo nella directory \"reports\" e PhpGedView lo rileverà automaticamente e lo renderà disponibile nell'elenco.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>CONTENUTI DELLA GUIDA</b>";
$pgv_lang["help_contents_gedcom_info"]		= "Informazioni su GEDCOM";
$pgv_lang["help_contents_gedcom_places"]	= "Luoghi nel GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>CONTENUTI DELLA GUIDA<br /><br />ELEMENTI DELLA GUIDA DELL'AMMINISTRATORE</b> aggiunto all'inizio dell'elenco.";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]				= "_Configura PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Aggiungi vs Carica";
$pgv_lang["ah4_help"]				= "_GEDCOM: File di configurazione";
$pgv_lang["ah5_help"]				= "_GEDCOM: Predefinito";
$pgv_lang["ah6_help"]				= "_GEDCOM: Elimina";
$pgv_lang["ah7_help"]				= "_GEDCOM: Inserisci";
$pgv_lang["ah8_help"]				= "_GEDCOM: Creare nuovo";
$pgv_lang["ah9_help"]				= "_GEDCOM: Scarica";
$pgv_lang["ah10_help"]				= "_GEDCOM: Pagina di amministrazione";
$pgv_lang["ah11_help"]				= "_GEDCOM: Configura";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importare";
$pgv_lang["ah13_help"]				= "_GEDCOM: Caricare";
$pgv_lang["ah14_help"]				= "_GEDCOM: Convalidare";
$pgv_lang["ah15_help"]				= "_GEDCOM: Converti ANSI in UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Impostazioni della privacy";
$pgv_lang["ah17_help"]				= "_Amministrazione utenti";
$pgv_lang["ah18_help"]				= "_Amministrazione";
$pgv_lang["ah19_help"]				= "_GEDCOM: Strumento multimediale";
$pgv_lang["ah20_help"]				= "_GEDCOM: Cambia identificatore persona in ...";
$pgv_lang["ah21_help"]				= "_Strumenti del traduttore";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Configura le lingue supportate";
$pgv_lang["ah24_help"]				= "_Migrazione delle informazioni utente (Index --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]				= "_Backup di PhpGedView";
$pgv_lang["ah26_help"]				= "_Elenco delle domande frequenti: modifica";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~Grafico delle statistiche~<br /><br />Questa è la pagina dei risultati, che mostra il grafico delle statistiche dal database come definito dagli input nella pagina precedente.";
$pgv_lang["help_statistics.php"] = "~Grafico delle statistiche~<br /><br />Questa pagina consente di determinare i criteri per la produzione di una visualizzazione grafica di varie statistiche dal database, richiamate dagli input nella pagina precedente.";
$pgv_lang["stat_help"]		= "~OPZIONI PER GRAFICI STATISTICI~<br /><br />È possibile produrre diversi grafici di statistiche dal database.<br /><br /> Selezionare il grafico, quindi modificare le opzioni dalle caselle.<br /><br />I numeri inclusi in ciascun grafico dipendono da i dati disponibili. Ad esempio, le persone senza un mese di nascita (ad es. Solo '1856') non possono essere incluse in un grafico delle nascite per mese.";
$pgv_lang["stat_help_x"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~ASSE X~<br /><br />Le seguenti opzioni sono disponibili per l'asse X (orizzontale). Ciascuno verrà quindi presentato in base alle opzioni impostate per gli assi Y e Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;persone nate in ogni mese.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;persone che sono morte in ogni mese.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;matrimoni che si sono verificati in ogni mese.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;numero di primogeniti per famiglia per mese.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;numero di primi matrimoni al mese.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;numero di mesi tra il matrimonio e la nascita del primo figlio di quella coppia.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;età alla morte, relativa al periodo di tempo che include l'anno di nascita di ogni persona.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;età al momento della morte, correlata al periodo di tempo che include l'anno di morte di ciascuna persona.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;età media delle persone al momento del matrimonio.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;età media delle persone al momento del primo matrimonio.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;dimensioni medie della famiglia.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;collocamento di tutte le persone o persone con il nome specificato, per paese.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;paese di nascita.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;paese di matrimonio.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;paese di morte.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;diagramma del cerchio di persone con fonti.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;diagramma del cerchio delle famiglie con fonti.</p>";
$pgv_lang["stat_help_y"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~ASSE Y~<br /><br />Le seguenti opzioni sono disponibili per l'asse Y (verticale). Queste opzioni modificano il modo in cui vengono visualizzati gli elementi presentati sull'asse X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;visualizza il numero di persone in ciascuna categoria definita dall'asse X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;calcola e visualizza la proporzione di ogni elemento nelle categorie dell'asse X.</p>";
$pgv_lang["stat_help_z"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~ASSE Z~<br /><br />Le seguenti opzioni sono disponibili per l'asse Z. Queste opzioni forniscono una suddivisione delle categorie selezionate per l'asse X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;visualizza gli elementi come una singola colonna per ciascuna categoria dell'asse X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;mostra gli elementi in 2 colonne (maschio e femmina) per ciascuna categoria dell'asse X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;visualizza gli elementi in un numero di colonne relative ai periodi di tempo impostati nella sezione successiva, per ciascuna categoria dell'asse X.</p>";
$pgv_lang["stat_help_gwx"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~confini per l'asse X~<br /><br />Seleziona l'intervallo di età desiderato.<br /><br />Ad esempio, <b>#pgv_lang[aft_marr]#</b> descrive il seguente insieme di intervalli di mesi:<div style=\"padding-left: 30px;\">prima del matrimonio<br />dal matrimonio a 8 mesi dopo<br />dalle 8 alle 12<br />dalle 12 alle 15<br />dalle 15 alle 18<br />dalle 18 alle 24<br />dalle 24 alle 48<br />oltre 48 mesi dopo il matrimonio</div><br />Quando vuoi mostrare i trimestri devi scegliere <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~confini per l'asse X~<br /><br />Seleziona l'intervallo di età desiderato.<br /><br />Ad esempio, <b>intervallo 10 anni</b> descrive il seguente insieme di fasce di età:<div style=\"padding-left: 30px;\">meno di un anno<br />da un anno a 5 anni<br />6 a 10<br />11 a 20<br />21 a 30<br />31 a 40<br />41 a 50<br />51 a 60<br />61 a 70<br />71 a 80<br />81 a 90<br />91 a 100<br />più vecchio di 100 anni</div>";
$pgv_lang["stat_help_gbx"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~confini per l'asse X~<br /><br />Seleziona l'intervallo di età desiderato.<br /><br />Ad esempio, <b>intervallo 2 anni</b> descrive il seguente insieme di fasce di età:<div style=\"padding-left: 30px;\">minore di 16 anni<br />16 a 18<br />19 a 20<br />21 a 22<br />23 a 24<br />25 a 26<br />27 a 28<br />29 a 30<br />31 a 32<br />33 a 35<br />36 a 40<br />41 a 50<br />più di 50 anni</div>";
$pgv_lang["stat_help_gcx"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~confini per l'asse X~<br /><br />Selezionare l'intervallo di conteggio desiderato.<br /><br />Ad esempio, <b>intervallo un figlio</b> descrive il seguente insieme di intervalli di conteggio figli:<div style=\"padding-left: 30px;\">senza figli<br />un bambino<br />due bambini<br />3, 4, 5, 6, 7, 8, 9, 10 bambini<br />più di 10 bambini</div>";
$pgv_lang["stat_help_gwz"]		= "~OPZIONI PER GRAFICI STATISTICI~<br />~confini per l'asse Z~<br /><br />Selezionare l'anno e l'intervallo di inizio desiderati<br /><br />Ad esempio, <b>dal 1700 intervallo 50 anni</b> descrive il seguente insieme di intervalli di date:<div style=\"padding-left: 30px;\">prima del 1700<br />1700 a 1749<br />1750 a 1799<br />1800 a 1849<br />1850 a 1899<br />1900 a 1949<br />1950 a 1999<br />2000 o più tardi</div>";
$pgv_lang["chart_type_help"]	= "~OPZIONI PER GRAFICI STATISTICI~<br /><br />Seleziona ciò che desideri vedere sulla mappa. Puoi scegliere:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;mostra i paesi in cui si trovano le persone di questo database.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;mostra i paesi in cui compare il cognome specificato.</div>";
$pgv_lang["google_chart_surname_help"]	= "~OPZIONI PER GRAFICI STATISTICI~<br /><br />Il numero di occorrenze del nome specificato verrà visualizzato sulla mappa. Se lasci questo campo vuoto, verrà utilizzato il cognome più comune.";
$pgv_lang["chart_area_help"]	= "~OPZIONI PER GRAFICI STATISTICI~<br /><br />Seleziona l'area geografica che desideri visualizzare sulla mappa. Puoi scegliere:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;mostra tutti i continenti.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;mostra l'Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;mostra il Sud America.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;mostra l'Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;mostra il Medio Oriente.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;mostra l'Africa.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />In questa pagina puoi gestire facilmente i tuoi file multimediali e le directory.<br /><br />Quando crei nuove sottodirectory Media, PhpGedView assicurerà che la struttura di directory identica sia mantenuta all'interno della directory <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>. Quando carichi nuovi file multimediali, PhpGedView può creare automaticamente le miniature per te.<br /><br />Accanto a ciascuna immagine nell'elenco Media troverai le seguenti opzioni. Le opzioni effettivamente visualizzate dipendono dallo stato corrente del file multimediale.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Quando fai clic su questa opzione, vedrai una pagina in cui puoi modificare il titolo dell'oggetto Media. Se l'oggetto Media non è ancora collegato a una persona, una famiglia o una fonte nel database attualmente attivo, puoi stabilire questo collegamento qui. È possibile rinominare il file o persino modificarne la posizione all'interno della struttura della directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Quando necessario, PhpGedView creerà automaticamente le sottodirectory richieste o eventuali miniature mancanti.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Questa opzione è disponibile solo quando l'amministratore l'ha abilitata. Puoi visualizzare o modificare i dati GEDCOM non elaborati associati a questo oggetto Media. Dovresti stare molto attento quando usi questa opzione.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Questa opzione ti consente di cancellare tutta la conoscenza del file multimediale dal database corrente. Gli altri database non saranno interessati. Se questo file multimediale non è menzionato in nessun altro database, esso e la relativa miniatura associata verranno eliminati.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Questa opzione ti consente di cancellare tutta la conoscenza del file multimediale dal database corrente. Gli altri database non saranno interessati. Il file multimediale e la relativa miniatura associata non verranno eliminati.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Questa opzione consente di rimuovere tutti i collegamenti all'oggetto multimediale dal database corrente. Il file non verrà eliminato e l'oggetto Media con cui questo file è noto al database corrente verrà mantenuto. Gli altri database non saranno interessati.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Questa opzione consente di stabilire collegamenti tra il file multimediale e persone, famiglie o fonti del database corrente. Quando necessario, PhpGedView creerà anche l'oggetto Media con il quale il file Media è noto al database.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Quando selezioni questa opzione, PhpGedView creerà la miniatura mancante.</li></ul>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Filtro di ricerca semplice basato sui caratteri inseriti, non sono accettati caratteri jolly.";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Se selezioni questa casella, verranno visualizzate le miniature.";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Ciò consente di cercare nella struttura del file per trovare l'elemento multimediale a cui si desidera collegarsi.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~Collega questo identificatore~<br /><br />Ogni elemento multimediale deve essere associato a una o più persone, famiglia o record di origine nel database.<br /><br />Per stabilire tale collegamento, è possibile inserire o cercare l'identificativo della persona, della famiglia o sorgente contemporaneamente alla creazione dell'elemento multimediale. È inoltre possibile stabilire il collegamento in un secondo momento tramite le opzioni di modifica nella pagina Gestisci supporto multimediale o aggiungendo elementi multimediali tramite il collegamento Aggiungi supporto disponibile nelle pagine Dettagli persona, Famiglia o Fonte.";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />Il file multimediale che stai caricando può avere, e probabilmente dovrebbe essere, un nome diverso sul server rispetto a quello sul tuo computer locale. Questo perché spesso il nome del file locale ha un significato per te ma è molto meno significativo per gli altri che visitano questo sito. Considera anche la possibilità che tu e qualcun altro proviate a caricare file diversi chiamati \"nonna.jpg\".<br /><br />In questo campo, specificate il nuovo nome del file che state caricando. Il nome immesso qui verrà utilizzato anche per denominare la miniatura, che può essere caricata separatamente o generata automaticamente. Non è necessario inserire l'estensione del nome del file (jpg, gif, pdf, doc, ecc.)<br /><br />Lascia vuoto questo campo per mantenere il nome originale del file che hai caricato dal tuo computer locale.";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />L'amministratore ha abilitato fino a #GLOBALS[MEDIA_DIRECTORY_LEVELS]# livelli di cartelle al di sotto del valore predefinito <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Ciò aiuta a organizzare i file multimediali e riduce la possibilità di conflitti di nomi.<br /><br />In questo campo si specifica la cartella di destinazione in cui deve essere archiviato il file multimediale caricato. Il file della miniatura corrispondente, caricato separatamente o generato automaticamente, verrà archiviato in una struttura di cartelle simile a partire da <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> anziché <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Non è necessario inserire la parte <b>#GLOBALS[MEDIA_DIRECTORY]#</b> del nome della cartella di destinazione.<br /><br />Se non sei sicuro di cosa inserire qui, dovresti contattare l'amministratore del sito per un consiglio.";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />L'amministratore ha abilitato fino a #GLOBALS[MEDIA_DIRECTORY_LEVELS]# livelli di cartelle al di sotto del <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predefinito. Ciò aiuta a organizzare i file multimediali e riduce la possibilità di conflitti di nomi.<br /><br />In questo campo si seleziona la cartella multimediale di cui si desidera visualizzare i contenuti. Quando si seleziona <b>#pgv_lang[all]#</b>, verranno visualizzati tutti i file multimediali indipendentemente dalla cartella in cui sono archiviati. Questo può produrre un elenco molto lungo di elementi multimediali.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />In questa pagina viene visualizzato un elenco dei archivi.<br /><br />I nomi dei archivi sono ordinati in ordine alfabetico.<br /><br /><b>ARCHIVIO</b><br />Senza archivi non possiamo costruire il nostro database. Esiste una fonte per tutte le informazioni memorizzate nel database e tale fonte è conservata in un repository. I archivi possono essere l'archivio personale di una persona, un'istituzione, un database pubblico, un ufficio del governo o della chiesa, una risorsa Internet, ecc. Per avere accesso a una fonte, vorremo sapere dove e in che luogo si trova. Tutte le informazioni necessarie per trovare una sorgente devono essere archiviate nel record del archivio.<br /><br />Un archivio può essere collegato a molte sorgenti.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />I dettagli del archivio vengono visualizzati qui. Insieme alle fonti, i repository sono molto importanti per i ricercatori genealogici. Con accurate informazioni su Fonte e Archivi, puoi seguire il percorso utilizzato da un altro ricercatore per trovare le informazioni. Dovresti essere in grado di trovare di nuovo le stesse informazioni.<br /><br />In questa pagina potresti vedere le informazioni sul titolo, l'indirizzo, l'email e la pagina web del archivio.<br /><br />Dopo i dettagli del archivio, sarà un elenco di tutte le fonti che sono collegate a questo archivio. Questo ti permette di vedere tutte le informazioni che sono state ottenute da un particolare archivio.<br /><br />Se abilitato dall'amministratore del sito, avrai una o due altre icone di menu in questa pagina:<ul><li><b>#pgv_lang[view_gedcom]#</b>, che mostra le informazioni in formato GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b>, che ti consente di memorizzare queste informazioni nel tuo #pgv_lang[clip_cart]#. Da lì puoi scaricare le informazioni nel formato di file GEDCOM e importarle nel tuo programma di genealogia.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Quando fai clic su questa opzione, contrassegni questo repository da eliminare dal database.<br /><br />Che cosa significa? Supponiamo che tu abbia una buona ragione per rimuovere questo repository dal database. Fai clic sul collegamento. Ti verrà chiesto di confermare la tua richiesta di cancellazione. Quando continui con la tua visita, noterai che il repository è ancora visibile e può essere utilizzato come se l'eliminazione non fosse avvenuta.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Quando si fa clic su questo collegamento, le informazioni sul repository, così come sono archiviate nel database, verranno visualizzate in una finestra.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Quando fai clic su questo link puoi aggiungere il repository, così come è archiviato in GEDCOM, al tuo #pgv_lang[clip_cart]#.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />In questa casella vengono visualizzati i nomi dei repository così come sono memorizzati nel database. I nomi vengono visualizzati in ordine alfabetico.<br /><br />Quando fai clic su un nome nell'elenco, andrai alla pagina #pgv_lang[repo_info]# dove vedrai un elenco delle fonti che sono collegate a quel repository.";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />In questa casella vengono visualizzati i nomi delle fonti collegate al repository. I nomi vengono visualizzati in ordine alfabetico.<br /><br />Quando si fa clic su un nome nell'elenco, andrai alla pagina dei dettagli di quella fonte.";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Spostare voci dell'elenco~<br /><br />Utilizzare questi pulsanti per riorganizzare la sequenza delle voci all'interno dell'elenco. I blocchi verranno stampati nella sequenza in cui sono elencati.<br /><br />Evidenzia la voce da spostare, quindi fai clic su un pulsante per spostare quella voce in alto o in basso.";
$pgv_lang["block_move_right_help"]	= "~Spostare voci dell'elenco~<br /><br />Utilizzare questi pulsanti per spostare una voce da un elenco a un altro.<br /><br />Evidenziare la voce da spostare, quindi fare clic su un pulsante per spostare o copiare quella voce nella direzione della freccia. Utilizza i pulsanti <b>»</b> e <b>«</b> per spostare la voce evidenziata dall'elenco più a sinistra a quello più a destra o viceversa. Utilizza i pulsanti <b>&gt;</b> e <b>&lt;</b> per spostare la voce evidenziata tra l'elenco #pgv_lang[available_blocks]# e l'elenco a destra o a sinistra.<br /><br />Le voci nell'elenco #pgv_lang[available_blocks]# non cambiano, indipendentemente da ciò che fai con i pulsanti #pgv_lang[move_right]# e #pgv_lang[move_left]#. Questo perché lo stesso blocco può apparire più volte sulla stessa pagina. Il blocco HTML è un buon esempio del motivo per cui potresti volerlo fare.";
$pgv_lang["block_default_index"]	= "~Blocchi predefiniti sulla pagina #pgv_lang[welcome]#~<br /><br />Quando rimuovi tutte le voci dagli elenchi #pgv_lang[main_section]# e #pgv_lang[right_section]# o quando fai clic sul pulsante <b>#pgv_lang[reset_default_blocks]#</b>, l'elenco dei blocchi verrà impostato come segue:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]	= "~Blocchi predefiniti sulla pagina #pgv_lang[mygedview]#~<br /><br />Quando rimuovi tutte le voci dagli elenchi #pgv_lang[main_section]# e #pgv_lang[right_section]# o quando fai clic sul pulsante <b>#pgv_lang[reset_default_blocks]#</b>, l'elenco dei blocchi verrà impostato come segue:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"] = "~Domande frequenti~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "La pagina FAQ (Frequently Asked Questions == Domande frequenti) può contenere una panoramica o un elenco di domande e risposte sull'uso di questo sito di genealogia.<br /><br />L'utilizzo della pagina delle FAQ spetta interamente al sito amministratore. L'amministratore del sito controlla il contenuto di ogni elemento e anche l'ordine in cui gli elementi vengono mostrati nella pagina.";

// Help search
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Puoi cercare nel sistema di aiuto di PhpGedView. La funzione #pgv_lang[hs_title]# offre un alto grado di controllo sul modo in cui funziona la ricerca; dovresti essere in grado di trovare facilmente ciò che stai cercando.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br /><br />Inserisci le parole o la frase che desideri trovare.<br /><br />La ricerca non presta attenzione al caso (superiore o inferiore) dei termini di ricerca o del testo in esame. Ciò significa che se cerchi <b>person</b>, troverai del testo contenente <b>Person</b>, <b>person</b> o <b>PERSON</b>. Troverai anche testo contenente <b>persone</b>, ecc. poiché la ricerca cerca sequenze di caratteri piuttosto che parole.<br /><br />Puoi fare in modo che la ricerca cerchi più parole contemporaneamente. Inserisci tutte le parole, separandole ciascuna da uno spazio, in questo modo: <b>persona&nbsp;famiglia&nbsp;bambino</b>. Quando si inserisce più di una parola, il significato di ciò che è stato digitato viene chiarito nel campo #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Qui puoi determinare l'ambito della ricerca.<br /><br />Gli amministratori possono scegliere di cercare nella Guida utente, nella Guida alla configurazione o in entrambe. Gli utenti non hanno questa scelta; poiché non hanno accesso ad alcuna funzione di configurazione, possono solo cercare nel file della Guida dell'utente.<br /><br />I file della Guida contengono non solo il testo della guida ma anche alcune stringhe di testo utilizzate per creare moduli di input e altro materiale. Questa opzione consente di controllare se deve essere esaminato l'intero file della Guida o se deve essere esaminato solo il testo della Guida.";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br /><br />Chiarisci il significato di ciò che hai inserito nel campo #pgv_lang[hs_keyword]# selezionando tra le possibilità qui presentate.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Se hai inserito <b>persona&nbsp;famiglia&nbsp;bambino</b>, questa opzione troverà il testo della guida che contiene una delle parole elencate. L'ordine delle parole non ha importanza. Il significato della ricerca è: \"Trova testo della guida contenente le parole <b>persona</b> <u>o</u> <b>famiglia</b> <u>o</u> <b>bambino</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Se hai inserito <b>persona&nbsp;famiglia&nbsp;bambino</b>, questa opzione troverà il testo della guida che contiene una delle parole elencate. L'ordine delle parole non ha importanza. Il significato della ricerca è: \"Trova testo della guida contenente le parole <b>persona</b> <u>e</u> <b>famiglia</b> <u>e</u> <b>bambino</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Se hai inserito <b>persona&nbsp;famiglia&nbsp;bambino</b>, questa opzione troverà il testo della guida che contiene tutte le parole elencate nell'ordine dato. Il significato della ricerca è: \"Trova testo della guida contenente le parole <b>persona&nbsp;famiglia&nbsp;bambino</b> esattamente in quell'ordine senza altre parole o caratteri tra\". Probabilmente non troverai questa frase in particolare in nessun testo di aiuto.</dd></dl><br />Ci sono alcune limitazioni su questo tipo di ricerca. Alcuni caratteri speciali come <b>&quot; &lt; &gt;</b> ecc. sono contenuti nel testo della Guida in forma simbolica e non verranno trovati se fanno parte del testo immesso. Alcuni testi della Guida contengono un tipo speciale di carattere spazio rappresentato da <b>&amp;nbsp;</b> e non troverai frasi contenenti questo carattere.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Questo strumento può aiutare gli amministratori del sito a ripulire i file nella directory Index.<br /><br />Nel tempo, file come file di log, vecchi file GEDCOM e vecchi file di backup possono accumularsi nella directory /index. Poiché molti di questi file vengono creati dal programma, potrebbero essere di proprietà dell'utente del server web. Se sono di proprietà dell'utente del server web, potresti non essere in grado di eliminarli. Questo strumento ti consente di eliminare questi file anche quando sono di proprietà dell'account utente del server web.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
