<?php
/**
 * Norwegian language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * # $Id: help_text.no.php 7378 2024-11-02 14:25:09Z canajun2eh $
 *
 * @translator Geir Håkon Eikland
 * @translator Thomas Rindal
 * @package PhpGedView
 * @subpackage Languages
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]	= "~#pgv_lang[comment]#~<br /><br />Teksten som er angitt her, vises når musepekeren svever på Tekst-ikonet i brukerlisten. Du bør prøve å holde denne teksten så kort som mulig.";
$pgv_lang["useradmin_comment_exp_help"]	= "~#pgv_lang[comment_exp]#~<br /><br />Angi datoen etter at denne brukerens oppføring skal behandles som et behov for inspeksjon av administratoren. Disse postene er uthevet i brukerlisten ved å vise brukernavnet i <span class='warning'>rødt</span>.<br /><br />Datoen må angis på engelsk. Eksempler: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> osv.<br /><br />Når månedstallet og dagnummeret begge er i området 1 til 12, bestemmer skilletegn (bindestrek eller skråstrek) betydningen, med et bindestrek <b>-</b> som betyr at det første tallet er dagen i måneden, mens en skråstrek <b>/</b> betyr at det første tallet er måneden.<br /><br />Hvis informasjonen som er angitt her, er meningsløs for programmet, vil «yesterday» bli brukt og denne brukeren post vil alltid bli valgt for utheving. «tomorrow» og lignende tekster er ikke meningsfylte i denne sammenhengen og vil føre til at denne brukeroppføringen aldri blir valgt for utheving.";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Velg formatet som databaseeksporten skal opprettes i. Valget ditt avhenger av kravene og evnene til programmet du vil importere den nylig nedlastede filen til. Du kan velge:<br /><ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Når dette alternativet er merket av, vil utdatafilen passere personvernkontroller i henhold til det valgte alternativet. Dette kan føre til at visse opplysninger blir fjernet. Utdatafilen vil bare inneholde informasjonen som normalt er synlig for en bruker med angitt privilegienivå.<br /><br />Hvis du bare har #pgv_lang[gedadmin]# rettigheter, kan du ikke spesifisere at utdatafilen skal privatiseres i henhold til privilegienivået #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Dette alternativet definerer en konstant bane som skal prefiks til alle mediebaner i utdatafilen.<br /><br />For eksempel, hvis mediekatalogen er konfigurert til å være \"/media\", og hvis mediefilen som eksporteres har en sti \"/media/bilder/xyz.jpg\", og du har angitt \"c:\\mine bilder\\min familie\" i dette feltet, vil den resulterende mediebanen være \"c:\\mine bilder\\min familie/bilder/xyz.jpg\".<br /><br />Du vil merke i dette eksemplet:<ul><li>det nåværende mediekatalognavnet fjernes fra banen</li><li>og den resulterende banen vil ikke ha riktige skilletegn for mappenavn.</li></ul><br />Hvis du vil beholde mediekatalogen i mediefilbanene til utdatafilen, må du inkludere det navnet i feltet <b>#pgv_lang[convertPath]#</b>.<br /><br />Du bør også bruke alternativet <b>#pgv_lang[convertSlashes]#</b> for å sikre at skilletegnene for mappenavnene er konsistente og stemmer overens med kravene i det mottatte operativsystemet.<br /><br />Mediebaner som faktisk er nettadresser vil ikke bli endret.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Dette alternativet avgjør om mappenavn i FILE-spesifikasjonen til medieobjekter skal skilles med skråstrek fremover eller bakover. Valget ditt avhenger av kravene til det mottakende operativsystemet.<br /><br />Valget <b>#pgv_lang[forwardSlashes]#</b> er passende for de fleste andre operativsystemer enn Microsoft Windows. Valget <b>#pgv_lang[backSlashes]#</b> skal brukes når destinasjonsprogrammet kjører på et Microsoft Windows-system.<br /><br />Mediebaner som faktisk er nettadresser vil ikke bli endret.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />Når dette alternativet er valgt, søker #pgv_lang[multi_title]# ikke bare katalogen som er valgt fra #pgv_lang[filter]# listen, men også alle underkataloger. Når dette alternativet ikke er valgt, blir det bare søkt i den valgte katalogen.<br /><br />Titlene på alle medieobjekter som blir funnet blir deretter undersøkt for å avgjøre om de inneholder teksten som er skrevet inn i #pgv_lang[filter]#.  Resultatet av disse to handlingene bestemmer multimediaobjektene som skal vises.";
$pgv_lang["medialist_unlinked_help"]	= "~#pgv_lang[medialist_unlinked]#~<br /><br />Bare medier som ikke er koblet til noen GEDCOM-post vises.";
$pgv_lang["medialist_current_dir_help"]	= "~#pgv_lang[medialist_current_dir]#~<br /><br />Velg undermappen du vil vise.";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br /><br />Velg rekkefølgen du vil se listen i.";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br /><br />Bruk #pgv_lang[interactive_tree]# for å se hele slektstreet til en person i begge retninger. Denne visningen ligner timeglassvisningen ved at den viser både forfedre og etterkommere av en gitt rotperson. Dette diagrammet gir deg en mer kompakt visning ved å vise bokser for par eller familier i stedet for bare personer.<br /><ul><li><b>Ruller</b><br />Når musemarkøren endres til et flytteikon, kan du klikke og dra treet for å se andre deler av treet. Når du drar treet, utvides fremtidige generasjoner automatisk til det ikke er flere generasjoner igjen å se i den retningen.<br /></li><li><b>Zoom</b><br />Du kan bruke ikonene til venstre for treet for å zoome inn og ut. Hvis du zoomer ut, kan du se mer av treet på skjermen om gangen. Når du zoomer ut, kan teksten bli vanskelig å lese; når musen svever over en boks, får du en forstørret oversikt over hva som er inni den.<br /></li><li><b>Utvidede detaljer</b><br />Ved å klikke på en hvilken som helst rute utvides ruten og viser en mer detaljert visning. I utvidet modus åpnes #pgv_lang[indi_info]# siden ved å klikke på navnet på en person. Ved å klikke på <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> vil trekke treet på nytt med vedkommende som den nye roten. Hvis du klikker på <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' />, kommer du til familiens detaljside.<br /></li><li><b>Bytt ektefeller</b><br /><img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> ikonet direkte under zoomknappene vil bytte visning av alle ektefeller på eller av på etterkommersiden. Når skjermen er satt til å vise ektefeller, vises alle ektefellene til en person i ruten med dem. Alle barnets barn vil også bli vist. Når muligheten til å vise ektefeller er av, vises bare personens siste ektefelle og barn med den ektefellen.<br /></li><li><b>Stort tre</b><br />#pgv_lang[interactive_tree]# er tilgjengelig fra mange forskjellige sider, inkludert trefanen på #pgv_lang[indi_info]# siden og diagramblokk på velkomstsiden. Når du ser på treet fra en av disse andre sidene, vil du også ha et treikon under Zoom-ikonene. Hvis du klikker på <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> blir du ført til siden #pgv_lang[interactive_tree]#.</li></ul>";

$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br /><br />Når mediebrannmuren er aktivert, kan multimediefiler lagres i en serverkatalog som ikke er tilgjengelig fra Internett.<br /><br />Disse knappene lar deg enkelt flytte en hel mediekatalogstruktur mellom den beskyttede (ikke nettadresserbare) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> og de normale katalogene <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. ";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br /><br />Angi rekursivt tillatelsene for den beskyttede (ikke nettadresserbare) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> og de vanlige katalogene <b>#GLOBALS[MEDIA_DIRECTORY]#</b> til begge verdens-skrivbar eller skrivebeskyttet. ";
$pgv_lang["update_CHAN_text"] 		= "Administratorer må noen ganger rydde opp og korrigere dataene som sendes inn av brukere. For eksempel kan det hende de må korrigere PLAC-plasseringen for å inkludere landet. Når administratorer foretar slike rettelser, erstattes normalt informasjon om den opprinnelige endringen. Dette er kanskje ikke ønskelig.<br /><br />Når dette alternativet velges under administratorens redigerings- eller korrigeringsøkt, vil PhpGedView beholde den opprinnelige endringsinformasjonen i stedet for å erstatte den med den gjeldende økten.";
$pgv_lang["config_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Dette alternativet kontrollerer starttilstanden til «#pgv_lang[no_update_CHAN]#» avmerkingsboksen som vises på hver side der administratorer kan gjøre endringer eller korrigeringer i den genealogiske databasen.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Hver kilde registrerer spesifikke hendelser, vanligvis for et gitt datoperiode og for et sted jurisdiksjon. For eksempel registrerer en folketelling folketellingshendelser og kirkeopptegnelser registrerer fødsels-, ekteskaps- og dødshendelser.<br /><br />Velg hendelsene som er registrert av denne kilden fra listen over hendelser. Datoen skal spesifiseres i et format som f.eks <i>FROM 1900 TO 1910</i>. Stedsjurisdiksjonen er navnet på den laveste jurisdiksjonen som omfatter alle steder på lavere nivå som er nevnt i denne kilden. For eksempel vil \"Oneida, Idaho, USA\" bli brukt som et kildedistriktssted for hendelser som skjer i de forskjellige byene i Oneida County. \"Idaho, USA\" ville være stedet for jurisdiksjon hvis hendelsene som ble registrert, ikke bare fant sted i Oneida County, men også i andre fylker i Idaho.";
$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />For å forbedre ytelsen lagres denne PhpGedCom-velkomstsideblokken som en cache-fil. Du kan kontrollere hvor ofte denne blokkens cache-fil oppdateres.<br /><ul><li><b>-1</b> betyr at hurtigbufferfilen aldri oppdateres automatisk. For å få en ny kopi, må du slette alle hurtigbufferfilene. Du kan gjøre dette på siden Tilpass velkomstside.</li><li><b>0</b> (Null) betyr at denne blokken aldri blir hurtigbufret, og hver gang blokken vises på PhpGedView velkomstside, ser du en fersk kopi. Denne innstillingen brukes automatisk for blokker som endres ofte, for eksempel blokkene #pgv_lang[logged_in_users_block]# og #pgv_lang[random_media_block]#.</li><li><b>1</b> (En) betyr at en ny kopi av denne blokkens cache-fil opprettes daglig, <b>2</b> betyr at en fersk kopi lages annenhver dag, <b>7</b> betyr at det opprettes en fersk kopi ukentlig osv.</li></ul>";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />For å forbedre ytelsen lagres flere av blokkene på PhpGedView-velkomstsiden som cache-filer i indekskatalogen. Cache-filene for de fleste blokker oppdateres en gang hver dag, men det kan være tider når du vil oppdatere dem manuelt.<br /><br />Denne knappen lar deg oppdatere hurtigbufferfilene når det er nødvendig.";
$pgv_lang["import_options_help"] 	= "Du kan velge alternative måter å importere slektsfilen (ged) din.";
$pgv_lang["verify_gedcom_help"]		= "~#pgv_lang[verify_gedcom]#~<br /><br />Her kan du velge om du skal hente og importere denne slektsfilen eller om du vil avbryte prosessen.";
$pgv_lang["add_gedcom_instructions"]	= "Tast inn et filnavn for denne nye slektsfilen (GEDCOM). Den blir opprettet i mappen index: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Skulle lysbildefremvisningen starte automatisk når siden lastes inn.<br /><br />Lysbildefremvisningen endrer innholdet i blokken uten å forhåndslaste informasjon fra serveren og uten å laste hele siden på nytt.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Du kan bruke denne innstillingen til å vise eller skjule lysbildefremvisningskontrollene til blokken Tilfeldige Medier.<br /><br />Disse kontrollene lar brukeren hoppe til et annet tilfeldig objekt eller å spille gjennom tilfeldig utvalgte medier som en lysbildefremvisning. Lysbildefremvisningen endrer innholdet i blokken uten å forhåndslaste informasjon fra serveren og uten å laste hele siden på nytt.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Bruk denne lenken til å legge til en ny kilde i databasen uten å koble kilden til en kildesitering i en annen post. Den nye kilden vises i kildelisten, men vises ikke i noen diagblokker eller andre steder i programmet før den er koblet opp til en kildesitering.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Bruk denne lenken for å legge til et nytt delt notat i databasen uten å koble notatet til noen post. Det nye notatet vises i listen over delte notater, men vises ikke i noen diagblokker eller andre steder i programmet før det er knyttet til en person, familie eller begivenhet.";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />I dette feltet skriver du inn ID-en til personen du lenker til (f.eks. I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Bruk denne delen til å velge den alternative databasens identifikator som inneholder personen du lenker til.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />I denne delen angir du parametrene som kreves for å koble til den eksterne websiden som er vert for dataene du kobler til. Du har muligheten til å velge fra en liste over kjente nettsteder som du har brukt før, eller angi #pgv_lang[label_site_url2]# og #pgv_lang[label_gedcom_id]# for en ny.<br /><br />I feltet <b>#pgv_lang[label_site_url2]#</b> skriver du inn nettadressen for å få tilgang til webtjenestebeskrivelsesfilen (WDSL) som forteller PhpGedView hvordan du får tilgang til dataene på den eksterne siden. For en ekstern PhpGedView-nettside vil nettadressen til WSDL-filen se slik ut: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />Feltet <b>#pgv_lang[label_gedcom_id]#</b> brukes til å angi en valgfri databaseidentifikator for eksterne nettsteder som krever en. For PhpGedView-områder er dette navnet på GEDCOM-filen.<br /><br />Feltene <b>#pgv_lang[label_username_id]#</b> og <b>#pgv_lang[label_password_id]#</b> er nødvendig hvis databasen krever det.";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Dette alternativet lar deg velge om data for personen du lenker til er på samme sted, men i et annet slektsdatabasesett, eller om dataene er på et annet nettsted som er tilgjengelig via Internett.<br /><br />Hvis personen er på samme side, blir du bedt om å velge datasettidentifikatoren og angi personens ID.<br /><br />For et eksternt nettsted blir du bedt om å oppgi URL-adressen, en databaseidentifikator og personens eksterne ID.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Bruk dette alternativet for å velge forholdet den eksterne personen har til personen du kobler dem til på nettstedet ditt. Hvis du for eksempel velger <i>Far</i>, vil personen på det eksterne nettstedet være faren til personen du kobler dem til lokalt.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Bruk dette skjemaet til å koble folk til andre mennesker, enten fra et annet nettsted eller en annen genealogisk database som er tilgjengelig for din kopi av PhpGedView.<br /><br />For å legge til en slik lenke, må du først velge relasjonstypen, deretter velge et nettsted som PhpGedView allerede har kjent eller definere et nytt nettsted, og deretter angi nettstedets ID for personen du vil koble til. PhpGedView vil da automatisk laste ned informasjon fra det eksterne nettstedet etter behov. Den nedlastede informasjonen blir <u>ikke</u> en del av din slektsdatabase; den forblir på det opprinnelige nettstedet, men er innlemmet i de forskjellige sidene der denne eksternt tilknyttede personen vises.<br /><br />Se hjelpelinken ved siden av hvert element på siden for mer informasjon om dette elementet. Du kan også sjekke den elektroniske engelskopplæringen for mer informasjon:<a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]	= "~#factarray[REPO:NAME]#~<br /><br />Navnet på biblioteket, arkivet eller annet depot der kildematerialet er lagret.";
$pgv_lang["edit_REPO_ADDR_help"]	= "~#factarray[REPO:ADDR]#~<br /><br />Adressen til dette biblioteket, arkivet eller annet depot. Skriv inn adressen akkurat slik du ville skrevet den på en konvolutt.<br /><br />La dette feltet være tomt hvis du ikke vil inkludere en adresse.";
$pgv_lang["edit_REPO_PHON_help"]	= "~#factarray[REPO:PHON]#~<br /><br />Telefonnummeret til dette biblioteket, arkivet eller annet depot. Tast inn nummeret inkludert land og retningsnummer. For eksempel kan et nummer i Tyskland være +49 25859 56 76 89 og et nummer i USA eller Canada kan være +1 888 555-1212.<br /><br />La dette feltet være tomt hvis du ikke vil inkludere et telefonnummer.";
$pgv_lang["edit_REPO_FAX_help"]		= "~#factarray[REPO:FAX]#~<br /><br />Faksnummeret til dette biblioteket, arkivet eller et annet depot. Tast inn nummeret inkludert land og retningsnummer. For eksempel kan et nummer i Tyskland være +49 25859 56 76 89 og et nummer i USA eller Canada kan være +1 888 555-1212.<br /><br />La dette feltet være tomt hvis du ikke vil inkludere et faksnummer.";
$pgv_lang["edit_REPO_EMAIL_help"]	= "~#factarray[REPO:EMAIL]#~<br /><br />E-postadressen til dette biblioteket, arkivet eller et annet depot. Skriv inn e-postadressen. Eksempel: <b>name@hotmail.com</b><br /><br />La dette feltet være tomt hvis du ikke vil inkludere en e-postadresse.";
$pgv_lang["edit_REPO_WWW_help"]		= "~#factarray[REPO:WWW]#~<br /><br />Internett-hjemmesiden til dette biblioteket, arkivet eller et annet depot. Skriv inn hjemmesideadressen inkludert http:// eller https://. Eksempel: <b>https://www.phpgedview.net/</b><br /><br />La dette feltet være tomt hvis du ikke vil inkludere en hjemmesideadresse.";
$pgv_lang["edit_CALN_help"]			= "~#factarray[CALN]#~<br /><br />En identifikasjons- eller referansebeskrivelse som brukes til å arkivere og hente gjenstander fra beholdningene i et bibliotek, arkiv eller annet depot. Uformelle arkiver trenger vanligvis ikke å bruke et #factarray[CALN]# system.";
$pgv_lang["edit_REPO_help"]			= "~#factarray[REPO]#~<br /><br />Detta är ID-numret för biblioteket, arkivet eller annan depå där det källmaterial som refereras lagras. Titeln på det aktuella arkivet kommer att visas under ID-numret.<br /><br /Du kan ändra ID-numret på arkivet där källmaterialet lagras. För att ta bort arkivreferensen, gör detta fält tomt. Den här åtgärden tar inte bort arkivposten från databasen; endast referensen tas bort.<br /><br />Om du anger önskat arkiv-ID direkt måste arkivposten redan finnas i databasen. Du kan klicka <b>#pgv_lang[find_repository]#</b> för att slå upp ett befintligt arkivs ID-nummer. Klicka <b>#pgv_lang[create_repository]#</b> om du behöver ange en ny arkivpost.";
$pgv_lang["edit_PUBL_help"]			= "~#factarray[PUBL]#~<br /><br />Når og hvor posten ble opprettet. For publiserte arbeider inkluderer dette informasjon som publiseringsbyen, forleggerens navn og utgivelsesåret.<br /><br />For et upublisert verk skal det inneholde datoen registreringen ble opprettet og stedet der det ble skapt. For eksempel fylket og bostedsstaten til en person som avgir en pensjonserklæring eller byen og bostedsstaten til forfatteren av et brev eller en privat familiehistorie.";
$pgv_lang["edit_AUTH_help"]			= "~#factarray[AUTH]#~<br /><br />Personen, byrået eller enheten som opprettet posten. For et publisert verk kan dette være forfatter, kompilator, transkribering, abstraktor eller redaktør. For en upublisert kilde kan dette være et individ, en myndighet, kirkeorganisasjon eller privat organisasjon, etc.";
$pgv_lang["edit_REFN_help"]			= "~#factarray[REFN]#~<br /><br />Dette feltet brukes vanligvis til å registrere friformet tekst for å identifisere denne GEDCOM-posten. For eksempel kan det være et filnummer i et automatisert eller manuelt system, eller det kan være et side- og posisjonsnummer på et stamtavle.<br /></br />Når GEDCOM-konfigurasjonen er innstilt for å tillate brukeren å overstyre det automatisk genererte ID-nummeret for nye personer, angis dette overordnede ID-nummeret her. I dette tilfellet må teksten være i samsvar med reglene som er etablert for ID-nummer. Gyldige ID-nummer kan bare inneholde bokstavene <b>A</b> til <b>Z</b>, <b>a</b> til <b>z</b>, sifre <b>0</b> til <b>9</b>, og spesielle symboler <b>. : -</b> og <b>_</b><br /><br />Alternativet som muliggjør bruk av #factarray[REFN]# i stedet for det automatisk genererte ID-nummeret, finner du i GEDCOM-konfigurasjonen, delen Redigeringsalternativer.";
$pgv_lang["edit_ABBR_help"]			= "~#factarray[ABBR]#~<br /><br />Bruk dette feltet til å lagre en forkortet versjon av en tittel. Dette feltet brukes sammen med tittelfeltet på kilder. Som standard bruker PGV først tittelen og deretter den forkortede tittelen.<br /><br />I henhold til GEDCOM 5.5-spesifikasjonen, \"skal denne oppføringen gi en kort tittel som brukes til å sortere, arkivere og hente kildeposter (s. 62).\"<br /><br />I PhpGedView er den forkortede tittelen valgfri, men i andre slektsprogblokker er det nødvendig.";
$pgv_lang["edit_ROMN_help"]			= "~#factarray[NAME:ROMN]#~<br /><br />#pgv_lang[edit_ROMN_advice]#";
$pgv_lang["edit_ROMN_advice"]		= "I mange kulturer er det vanlig å ha et tradisjonelt navn stavet i de tradisjonelle tegnene og også en romanisert versjon av navnet, da det ville være stavet eller uttalt på språk basert på det latinske alfabetet, for eksempel engelsk eller norsk.<br /><br />Hvis du foretrekker å bruke et ikke-latinsk alfabet, for eksempel hebraisk, gresk, russisk, kinesisk eller arabisk, for å skrive inn navnet i standardnavnfeltene, kan du bruke dette feltet til å angi samme navn ved hjelp av det latinske alfabetet. Begge versjonene av navnet vises i lister og diagblokker.<br /><br />Selv om dette feltet er merket \"Romanisert\", er det ikke begrenset til å inneholde bare tegn basert på det latinske alfabetet. Dette kan være til nytte for japanske navn, der tre forskjellige alfabeter kan forekomme.";
$pgv_lang["edit_ROMN_GIVN_help"]	= "~#pgv_lang[roman_givn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />I dette feltet bør du angi gitt navn på personen. Som et eksempel, i navnet \"John Robert Finlay\", er fornavnene som skal angis her \"John Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]	= "~#pgv_lang[roman_surn]#~<br /><br />#pgv_lang[edit_ROMN_advice]#<br /><br />I dette feltet bør du angi etternavnet til personen. Som et eksempel, i navnet \"John Robert Finlay\", er etternavnet som skal angis her \"Finlay\".<br /><br />Personer med flere etternavn, vanlig i Spania og Portugal, skal skille etternavnene med komma. Dette indikerer at personen skal oppføres under hvert av navnene. For eksempel vil etternavnet \"Cortes,Vega\" være oppført under både <b>C</b> og <b>V</b>, mens etternavnet \"Cortes Vega\" bare vil være oppført under <b>C</b>.";
$pgv_lang["edit__HEB_help"]			= "~#factarray[_HNM]#~<br /><br />#pgv_lang[edit__HEB_advice]#";
$pgv_lang["edit__HEB_advice"]		= "I mange kulturer er det vanlig å ha et tradisjonelt navn stavet i de tradisjonelle tegnene og også en romanisert versjon av navnet, da det ville være stavet eller uttalt på språk basert på det latinske alfabetet, for eksempel engelsk eller norsk.<br /><br />Hvis du foretrekker å bruke det latinske alfabetet til å skrive inn navnet i standardnavnfeltene, kan du bruke dette feltet til å angi samme navn i det ikke-latinske alfabetet, for eksempel gresk, hebraisk, russisk, arabisk eller kinesisk. Begge versjonene av navnet vises i lister og diagblokker.<br /><br />Selv om dette feltet er merket \"hebraisk\", er det ikke begrenset til bare å inneholde hebraiske tegn.";
$pgv_lang["edit__HEB_GIVN_help"]	= "~#pgv_lang[hebrew_givn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />I dette feltet bør du angi gitt navn på personen. Som et eksempel, i navnet \"John Robert Finlay\", er fornavnene som skal angis her \"John Robert\".";
$pgv_lang["edit__HEB_SURN_help"]	= "~#pgv_lang[hebrew_surn]#~<br /><br />#pgv_lang[edit__HEB_advice]#<br /><br />I dette feltet bør du angi etternavnet til personen. Som et eksempel, i navnet \"John Robert Finlay\", er etternavnet som skal angis her \"Finlay\".<br /><br />Personer med flere etternavn, vanlig i Spania og Portugal, skal skille etternavnene med komma. Dette indikerer at personen skal oppføres under hvert av navnene. For eksempel vil etternavnet \"Cortes,Vega\" være oppført under både <b>C</b> og <b>V</b>, mens etternavnet \"Cortes Vega\" bare vil være oppført under <b>C</b>.";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Bruk dette skjemaet for å legge til en person som ikke er knyttet til en familie.<br /><br />Når du legger til en \"frittstående\" person i slektsbasen din, vil personen ikke bli knyttet til noen andre personer før du oppgir slektskapet/familebåndet.  Du kan når som helst knytte personer sammen ved å benytte valget for dette under arkfanen #pgv_lang[relatives]# på siden for #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Angi internettadressen (URL) inkludert http:// først. Eksempel: <b>http://www.phpgedview.net/</b><br /><br />La dette feltet være tomt dersom du ikke ønsker å oppgi en adresse (URL).";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Angi hjemmesiden for websiden inkludert http:// først. Eksempel: <b>http://www.phpgedview.net/</b><br /><br />La dette feltet være tomt dersom du ikke ønsker å oppgi en hjemmesiden for websiden.";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Angi en epost-adresse. Eksempel: <b>navn@hotmail.com</b><br /><br />La dette feltet være tomt dersom du ikke ønsker å oppgi en epost-adresse.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Angi et FAKS-nummer, inkludert landskode og eventuelt retningsnummer. For eksempel kan et FAKS-nummer i Norge være +47&nbsp;35&nbsp;00&nbsp;00&nbsp;01, i Tyskland kan det være +49&nbsp;25859&nbsp;56&nbsp;76&nbsp;89 og i USA eller Canada kan det være +1&nbsp;888&nbsp;555-1212.<br /><br />La dette feltet være tomt dersom du ikke ønsker å oppgi et faksnummer.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Angi et telefonnummer, inlkudert landskode og eventuelt retningsnummer. For eksempel kan et telefonnummer i Norge være +47&nbsp;35&nbsp;00&nbsp;00&nbsp;01, i Tyskland kan det være +49&nbsp;25859&nbsp;56&nbsp;76&nbsp;89 og i USA eller Canada kan det være +1&nbsp;888&nbsp;555-1212.<br /><br />La dette feltet være tomt dersom du ikke ønsker å oppgi et telefonnummer.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Angi en postadresse i feltet på samme måte som du ville gjort på en konvolutt.<br /><br />La dette feltet være tom dersom du ikke ønsker å oppgi en postadresse.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~#factarray[SPFX]#~<br /><br />Angi eller velg fra listen ord som er en del av etternavnet.  Eksempler på slike ord er <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, mm.<br /><br />Under noen omstendigheter kan en adelstittel legges inn her. For eksempel Peter <b>Freiherr von</b> Somewhere. «Freiherr» delen er egentlig en adelstittel, og bør ikke gjentas som et fakta #factarray[TITL]#. Hva som legges inn her er i stor grad avhengig av preferansene til den det gjelder.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Skriv inn giftnavnet for denne personen ved å bruke de samme formateringsreglene som gjelder for Navn-feltet. Dette feltet er valgfritt.<br /><br />For eksempel, hvis Mary Jane Brown giftet seg med John White, kan du komme inn (uten anførselstegn, selvfølgelig)<ul><li>Amerikansk bruk:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Europeisk bruk:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternativ europeisk bruk:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" eller \"Mary Jane /Brown-White/\"</li></ul>Du bør bare gjøre dette hvis Mary Brown begynte å kalle seg selv med det nye navnet etter å ha giftet seg med John White. Noen steder, for eksempel Quebec (Canada), er det ulovlig at navn endres på denne måten.<br /><br />Noen ganger endrer menn navn etter ekteskap, og bruker ofte bindestrekformen, men tar av og til konas etternavn.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />Dette feltet beskriver forholdet til barnet til dets familie. Mulighetene er:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Barnets forhold til familien kan ikke bestemmes. Når dette alternativet er valgt, vil ikke feltet #factarray[PEDI]# bli kopiert til databasen.</li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet indikerer at barnet er i slekt med familien etter fødselen.</li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet indikerer at barnet ble adoptert av familien. Dette indikerer <i>ikke</i> at det ikke er noe blodforhold mellom barnet og dets familie; det viser at barnet ble adoptert av den aktuelle familien en gang etter barnets fødsel.</li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet indikerer at barnet er et fosterbarn av familien. Vanligvis er det ikke noe blodforhold mellom barnet og dets familie.</li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Barnet ble beseglet til familien i en SDH <i>forsegling</i> seremoni. En forsegling av et barn utføres når foreldrene ble forseglet til hverandre etter fødselen av barnet. Barn født etter foreldrenes forsegling blir automatisk forseglet til familien.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />Organisasjonen, institusjonen, selskapet, personen eller annen enhet som har myndighet.<br /><br />For eksempel en arbeidsgiver for en person, eller en kirke som administrerte ritualer eller arrangementer, eller en organisasjon som er ansvarlig for å opprette og / eller arkivere poster.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />Dette feltet beskriver hvilken type forening som dannet familien.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;indikerer at seremonien som formaliserte foreningen av to personer for å danne en familie ble utført av en prest, biskop, kardinal, predikant, rabbiner, sjaman eller lignende person. Seremonien fant ikke nødvendigvis sted i en kirke, synagoge, tempel eller annet innviet sted. Det kunne ha foregått utendørs eller i en privat hjem.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;indikerer at seremonien som formaliserte foreningen av to personer for å danne en familie ble utført av en dommer, sorenskriver, ordfører eller lignende myndighetsperson som ikke er prest, osv. Fullmakten til å utføre slike seremonier gis vanligvis av en regjering. Seremonien fant ikke nødvendigvis sted i en rettssal eller et kontor.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;beskriver forholdet mellom to personer, ikke gift med hverandre, som oppfører seg som om de var en familie. De har <u>ikke</u> deltatt i en vigselsseremoni utført av en prest, en biskop, en dommer, en ordfører eller noen annen person med myndighet til å foreta vigsler. De kan ha avgitt en offentlig erklæring om at de anser seg som gift, men det er ikke et krav.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;indikerer at detaljene om foreningen mellom to personer for å danne en familie ikke er kjent.</li></ul>";

$pgv_lang["context_help"]			= "Mer hjelp er tilgjengelig ved å klikke på <b>?</b> du kan finne etter ulike valg på siden.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Hver person i slektsbasen på dette nettstedet har et unikt ID-nummer.  Dersom du kan ditt eget ID-nummer, kan du oppgi det her.  Hvis du ikke husker ID-nummeret eller ikke kan finne det på grunn av personvern-innstillinger, vær vennlig å oppgi nok informasjon i kommentar-feltet slik at administratoren for nettstedet kan gjenkjenne for å kunne gi deg ID-nummeret ditt.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Bruk dette feltet til å fortelle nettstedsadministratoren hvorfor du ber om en konto og hvordan du er i slekt med slektsforskningen som vises på dette nettstedet. Du kan også bruke dette til å legge inn andre kommentarer du kan ha til nettstedsadministratoren.";
$pgv_lang["utf8_ansi_help"]			= "~#pgv_lang[utf8_to_ansi]#~<br /><br />For at slektsdataene skal vises på den beste måten på Internett, så bruker PhpGedView UTF-8 tegnsett.  Noen progblokker, som for eksempel Family Tree Maker, støtter ikke import av slektsfiler som bruker UTF-8 tegnsett.  Ved å merke denne boksen, så vil slektsfilen bli konvertert fra <b>UTF-8</b> til <b>ANSI</b>.<br /><br />Hvilket tegnsett du velger for slektsfilen som skal laste ned (download), avhenger av programmet du skal importere til. Dersom du ikke er sikker på hvilket tegnsett det støtter, bør du sjekke brukerveiledningen til programmet.<br /><br />Vær oppmerksom på at spesielt særnasjonale tegn/bokstaver kan forsvinne/vises feil ved konvertering. Det er derfor alltid sikrest bevare dataene i UTF-8 og la ditt eget program bruke sin egen metode for import og konvertering av slektsfilen.  Dersom du får problemer, bør du kontakte selgeren eller utvikleren av programmet ditt.<br /><br />Denne <a href='https://no.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikkelen'><b>Wikipedia-artikkelen</b></a> inneholder omfattende informasjon og lenker om UTF-8.";
$pgv_lang["remove_tags_help"]		= "~#pgv_lang[remove_custom_tags]#~<br /><br />Ved å merke av dette valget så vil alle fakta-koder lagt til av PhpGedView bli fjernet.<br /><br />Fakta-koder som PhpGedView bruker er blant annet <b>_PGVU</b> som gjenkjenner brukere som har endret data online og <b>_THUM</b> som forteller PhpGedView at bildet bør brukes som et miniatyrbilde.<br /><br />Egendefinerte koder kan forårsake feil ved import til andre slektsprogram.";
$pgv_lang["download_zipped_help"]	= "~#pgv_lang[zip_files]#~<br /><br />Når du merker av for dette alternativet, blir en kopi av GEDCOM-filen komprimert til ZIP-format før nedlastingen begynner. Dette vil redusere størrelsen betydelig, men du må bruke et kompatibelt Unzip-program (for eksempel WinZIP) for å dekomprimere den sendte GEDCOM-filen før du kan bruke den.<br /><br />Dette er et nyttig alternativ for nedlasting av store GEDCOM-filer. Det er en risiko for at nedlastingstiden for den ukomprimerte filen kan overstige den maksimalt tillatte utførelsestiden, noe som resulterer i ufullstendig nedlastede filer. ZIP-alternativet skal redusere nedlastingstiden med 75%.";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />Angi antall barn som person eller familien har. Dette er et valgfritt felt.";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />Angi tidspunktet for denne hendelsen i 24-timers format med ledende nuller. Midnatt er 00:00. Eksempler: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />Noter er tekst med fri form og vil vises i faktafeltene og under arkfanen Noter.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Delte notater er friformet tekst og vil vises i delen Faktainformasjon på siden.<br /><br />Hvert delte notat kan knyttes til mer enn én person, familie, kilde eller begivenhet.";
$pgv_lang["edit_CEME_help"]			= "~#factarray[CEME]#~<br /><br />Angi navnet på kirkegården eller annet bisettelsessted der personen er stedt til hvile.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Skriv inn GEDCOM ID for personen hvis forholdet til den nåværende personen du ønsker å beskrive.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Velg en #factarray[RELA]# fra listen. Å velge <b>#pgv_lang[godfather]#</b> betyr: <i>Personen som er identifisert i feltet #factarray[ASSO]# er #pgv_lang[godfather]# for den nåværende personen</i>.";
$pgv_lang["show_spouse_help"]		= "~#pgv_lang[show_spouses]#~<br /><br />Som standard vises ikke ektefeller til etterkommere fordi det gjør diagrammet vanskeligere å lese og forstå. Ved å marke av dette valget, vil diagrammet også vise ektefeller.";
$pgv_lang["reorder_families_help"]	= "~#pgv_lang[reorder_families]#~<br /><br />Familier på arkfanen #pgv_lang[relatives]# blir vist i den rekkefølgen som de er lagret i slektsbasen.  Familiene er ikke sortert på datoen for giftemål fordi denne datoen ofte er ukjent til forskjell fra rekkefølgen til giftemål.<br /><br />Dette valget gir deg muligheten til å endre rekkefølgen for hvordan de skal vises på denne siden for #pgv_lang[relatives]#.  Dersom du ønsker å sortere familiene i henhold til dato for giftemål, kan du klikke på knappen for automatisk sortering.";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Når PhpGedView oppdager at GEDCOM-importen krever mer tid enn fristen tillater, vil den vise en <b>#pgv_lang[del_proceed]#</b> knapp som du må trykke for å fortsette importen.<br /><br />Når dette alternativet er satt til <b>#pgv_lang[yes]#</b>, vil PhpGedView automatisk trykke på <b>#pgv_lang[del_proceed]#</b> knappen for deg. Dette bør avlaste kjedsomheten ved å måtte trykke på knappen gjentatte ganger for langvarig import.";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Etternavnet du har valgt har mer enn #GLOBALS[SUBLIST_TRIGGER_I]# personer.<br /><br />For å hjelpe deg med å finne personen du ønsker, er listen delt inn i mindre lister i henhold til første bokstav i personens fornavn. Denne alfabetiske underindeksen fungerer på samme måte som den alfabetiske indeksen for etternavn.<ul><li>Klikk på en bokstav for å se alle fornavnene som begynner med bokstaven.</li><li>Velg <b>#pgv_lang[PN]#</b> for å liste opp alle personene med ukjente fornavn.</li><li>Ved å velge <b>#pgv_lang[all]#</b> vises en liste over alle personer med det tidligere valgte etternavnet.</li></ul>";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Familienavnet du har valgt har mer enn #GLOBALS[SUBLIST_TRIGGER_F]# personer.<br /><br />For å hjelpe deg med å finne familien du ønsker, er listen delt inn i mindre lister i henhold til første bokstav i personens fornavn. Denne alfabetiske underindeksen fungerer på samme måte som den alfabetiske indeksen for navn.<ul><li>Klikk på en bokstav for å se alle fornavnene som begynner med bokstaven.</li><li>Velg <b>#pgv_lang[PN]#</b> for å liste alle personene med ukjente fornavn.</li><li>Ved å velge <b>#pgv_lang[all]#</b> vises en liste over alle familier med det tidligere valgte etternavnet.</li></ul>";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />Feltet #factarray[TYPE]# gir deg mulighet til å angi en bruker-definert hendelse.  Feltet er har ikke bundet format slik at du står fritt til hva innholdet skal være.";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />For SDH-ordinanser registrerer dette feltet tempelet der det ble utført.";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />Dette feltet er et valgfritt statusfelt og er for det meste brukt for hvor langt personen er kommet i SDH TempleReady ordineringsprogrammet.";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Bruk dette feltet for å angi at denne mediafilen er hovedfilen for personen det er knyttet til.  Hovedbildet er det som blir brukt i diagram og på faktasiden til personen.";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Dette alternativet lar deg overstyre det vanlige valget for et miniatyrbilde.<br /><br />GEDCOM har et konfigurasjonsalternativ som spesifiserer om PhpGedView skal sende det store eller det lille bildet til nettleseren når den nåværende siden krever et miniatyrbilde. Alternativet Â«#factarray[_THUM]#Â», når det er satt til <b>#pgv_lang[yes]#</b>, overstyrer midlertidig innstillingen av GEDCOM-konfigurasjonsalternativet, slik at PhpGedView alltid vil sende det store bildet. Du kan ikke tvinge PhpGedView til å sende det lille bildet når GEDCOM-konfigurasjonen angir at store bilder alltid skal brukes.<br /><br />PhpGedView endrer ikke størrelsen på bildet som sendes; nettleseren gjør dette i henhold til sidespesifikasjonene den også har mottatt. Dette kan ha uønskede konsekvenser når bildet som sendes ikke virkelig er et miniatyrbilde der PhpGedView forventer å sende et lite bilde. Dette er ikke en feil: Det er anledninger hvor det kan være ønskelig å vise et stort bilde på steder der man normalt forventer å se et miniatyrstørrelsesbilde.<br /><br />Du bør unngå å sette Â«#factarray[_THUM]#Â» alternativ til <b>#pgv_lang[yes]#</b>. Dette valget vil føre til at store mengder bilderelaterte data blir sendt til nettleseren, bare for at nettleseren skal forkaste det overskytende. Sidelast, spesielt med diagblokker med mange bilder, kan reduseres alvorlig.";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />Angi en tittel for mediafilen du redigerer.  Dersom tittelen er for en multimediafil, angir du en beskrivende tittel som vil også vil vises for besøkende på nettstedet.<br /><br />Hvis du redigerer en persons detaljer, bruk dette feltet til å angi adelsinformasjon som <i>Sir, Lord, Baron, Earl, Hertug, Graf, Freiherr,</i> osv.<br /><br />Profesjonelle betegnelser som <i>Dr., Admiral, Lt.Gen., Rev., Sister,</i> osv. bør angis i underfeltet «#factarray[NPFX]#», mens navnesuffikser som <i>Jr., Sr., III, IV,</i> osv. og akademisk informasjon som <i>PhD, PEng, FImechE, DVM, MD,</i> osv. hører hjemme i underfeltet «#factarray[NSFX]#».";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />Dette er det viktigste feltet for multimediafilen  Det viser hvilken fil som skal brukes. Som et minimum, så må du angi navnet på filen.  Avhengig av hvilke innstillinger du har gjort i PhpGedView, så må du kanskje angi mer informasjon om plasseringen til filen.<br /><br />Du kan bruke valget <b>#pgv_lang[find_media]#</b> som en hjelp for å lokalisere de mediafilene du allerede ligger på nettstedet.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]			= "~#factarray[FORM]#~<br /><br />Dette er et valgfritt felt som kan brukes for å angi formatet til multimedia-filen.  Noen slektsprogram sjekker dette feltet for å bestemme hvordan de skal håndtere filen.  På en annen side, så er ikke dette veldig viktig fordi multimediafiler overføres forholdsvis dårlig mellom ulike datamaskin-plattformer.";
$pgv_lang["generate_thumb_help"]	= "~#pgv_lang[auto_thumbnail]#~<br /><br />Vi har funnet ut at serveren din har mulighet til automatisk å lage miniatyrbilde(r) fra bestemte typer/formater av bilder.  Det kan være støtte for filformatene JPG, BMP, GIF og PNG.  Formatene som serveren din støtter er vist ved siden av avmerkingsboksen.<br /><br />Ved å merke av denne boksen, så forteller du til systemet at laster opp bilder med ett eller flere av disse formatene og at du ønsker at det skal genereres miniatyrbilder for dem.  Dersom du ikke merker av boksen, så må du eventuelt lage miniatyrbilderene selv.";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Denne delen gir deg mulighet til å legge til en ny note for faktopplysninger som du redigerer.  Noter er tekst i fritt format og vil vises i detaljer for fakta på ulike sider.";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Delte notater, som vanlige notater, er tekst i fri form. I motsetning til vanlige notater kan hvert delte notat knyttes til mer enn én person, familie, kilde eller fakta.<br /><br />Ved å klikke på det aktuelle ikonet, kan du opprette en lenke til et eksisterende delt notat eller opprette et nytt delt notat og samtidig koble til det. Hvis en lenke til et eksisterende delt notat allerede er etablert, kan du også redigere innholdet på det notatet.<br /><ul><li><b>Koble til et eksisterende delt notat</b><div style=\"padding-left: 20px;\">Hvis du allerede vet ID-nummeret til ønsket delt notat, kan du skrive det nummeret direkte i feltet.<br /><br />Når du klikker på ikonet <b>#pgv_lang[find_shared_note]#</b>, vil du kunne søke i teksten til alle eksisterende delte notater og deretter velge en av dem. ID-nummeret til det valgte notatet vil automatisk legges inn i feltet.<br /><br />Du må klikke på knappen <b>#pgv_lang[add]#</b> for å oppdatere den opprinnelige posten.</div><br /></li><li><b>Lag et nytt delt notat</b><div style=\"padding-left: 20px;\">Når du klikker på ikonet <b>#pgv_lang[create_shared_note]#</b>, åpnes et nytt vindu. Du kan legge inn teksten i det nye notatet etter ønske. Som med vanlige notater, kan du legge inn nettadresser.<br /><br />Når du klikker på <b>#pgv_lang[save]#</b> knappen, vil du se en melding med ID-nummeret til det nylig opprettede delte notatet. Du bør klikke på denne meldingen for å lukke redigeringsvinduet og også kopiere det nye ID-nummeret direkte til ID-nummerfeltet. Hvis du bare lukker vinduet, blir det nylig opprettede ID-nummeret ikke kopiert automatisk.<br /><br />Du må klikke på <b>#pgv_lang[add]#</b> knappen for å oppdatere den opprinnelige posten.</div><br /></li><li><b>Rediger et eksisterende delt notat</b><div style=\"padding-left: 20px;\">Når du klikker på ikonet <b>#pgv_lang[edit_shared_note]#</b>, åpnes et nytt vindu. Du kan endre teksten i det eksisterende delte notatet etter ønske. Som med vanlige notater, kan du legge inn nettadresser.<br /><br />Når du klikker på <b>#pgv_lang[save]#</b> knappen, vil teksten til det delte notatet bli oppdatert. Du kan lukke vinduet og deretter klikke <b>#pgv_lang[save]#</b> knappen igjen.<br /><br />Når du endrer teksten til et delt notat, gjenspeiles endringen på alle steder som det delte notatet for øyeblikket er knyttet til. Nye lenker du oppretter etter endringen, vil også bruke den oppdaterte teksten.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~BRUKER ASSISTENT GEDFACT~<br /><br />Ved å klikke på ikonet \"+\" åpnes vinduet Assistent GEDFact Delt notat. Du finner spesifikk hjelp der.<br /><br />Når du klikker på \"Lagre\" knappen, limes ID-en til den delte notatet inn her.";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Denne delen gir deg mulighet til å legge til en ny kildehenvisning til den faktopplysningen du redigerer.<br /><br />I kildefeltet angir du IDen til kilden.  Dersom du må opprette en ny kilde, kan du klikke på valget <b>#pgv_lang[create_source]#</b>.  I feltet for henvisnings-detaljer kan du angi sidenummer eller annen informasjon som kan hjelpe noen til finne fram til opplysningene i kilden.  I tekstfeltet kan du også skrive inn direkte tekstutdrag fra kilden.";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# gir deg mulighet til å knytte en faktaopplysning med en tilhørende person i slektsbasen.  Dette er den eneste måten du koble en person som forlover, gudfar og lignende til en annen person.";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Du vil bruke dette feltet til å registrere kvaliteten eller påliteligheten til dataene som finnes i denne kilden. Mange slektsforskningsprogblokker bruker et tall i felt. <b>3</b> kan bety at dataene er en primær kilde, <b>2</b> kan bety at det var en sekundær kilde, <b>1</b> kan bety at informasjonen er tvilsom, og <b>0</b> kan bety at kilden er upålitelig.";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />I siteringsdetaljer-feltet vil du angi sidenummeret eller annen informasjon som kan hjelpe noen med å finne informasjonen i kilden.";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />I dette feltet kan du angi en tekst for henvisningen for denne kilden.  Eksempler på opplysninger kan være et utdrag av kildeteksten eller en beskrivelse av hva som i henvisningen.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Dette er ID-nummeret til kilden for denne fakta. Tittelen på den nåværende kilden vil vises under ID-nummeret.<br /><br />Du kan endre ID-nummeret til kildeposten som dette faktas kildesituation refererer til. For å fjerne hele sitatet, gjør dette feltet tomt. Denne handlingen fjerner ikke kildeposten fra databasen; bare denne referansen fjernes.<br /><br />Hvis du skriver inn ønsket kilde-ID direkte, må den kildeposten allerede eksistere i databasen. Du kan klikke <b>#pgv_lang[find_sourceid]#</b> for å slå opp en eksisterende kildeposts ID-nummer. Klikk <b>#pgv_lang[create_source]#</b> hvis du trenger å legge inn en ny kildepost.";
$pgv_lang["edit_edit_raw_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Denne siden lar deg redigere den rå GEDCOM-posten. Du bør bruke denne siden med forsiktighet; det krever god forståelse av GEDCOM 5.5.1-standarden. For mer informasjon om GEDCOM 5.5.1-standarden, se hjelpemnet <b>GEDCOM-fil</b>.<br /><br />PhpGedView gir mange måter å legge til og redigere informasjon, men det kan være anledninger når du kanskje vil redigere den rå GEDCOM-strukturen. Når det er mulig, bør du bruke de oppgitte skjemaene for å legge til informasjon, men når det er umulig, kan du bruke dette skjemaet. Når du har sendt skjemaet, vil informasjonen din bli kontrollert for å være i samsvar med standarden, og CHAN-posten vil bli oppdatert.";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />Med PhpGedView kan du kopiere opptil 10 fakta, med alle detaljer, til et utklippstavle. Dette utklippstavlen er forskjellig fra utklippsvognen du kan bruke til å eksportere deler av databasen din.<br /><br />Du kan velge noe av fakta fra utklippstavlen og kopiere det valgte faktum til personen, familien, media, Kilde eller lagerregister som for øyeblikket redigeres. Du kan imidlertid ikke kopiere fakta av forskjellige oppføringstyper. Du kan for eksempel ikke kopiere et ekteskapsfakta til en kilde eller en personregistrering, siden ekteskapsfakta bare er knyttet til familieoppføringer.<br /><br />Dette er veldig nyttig når du skriver inn lignende fakta, for eksempel folketelling, for mange personer eller familier.";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Steder bør oppgis i henhold til standardene for slektsforskning. I slektsforskning registreres steder med den mest spesifikke informasjonen om stedet først, og deretter jobber de opp til det minst spesifikke stedet sist, ved hjelp av komma for å skille de forskjellige stednivåene. Nivået der du registrerer stedinformasjonen, skal representere nivåene på regjeringen eller kirken der viktige poster for det stedet oppbevares.<br /><br />For eksempel vil et sted som Salt Lake City bli skrevet inn som \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />La oss undersøke hver del av dette stedet. Den første delen, \"Salt Lake City\", er byen eller byen der hendelsen skjedde. I noen land kan det være kommuner eller distrikter i en by som det er viktig å merke seg. I så fall burde de komme før byen. Den neste delen, \"Salt Lake\", er fylket. \"Utah\" er staten, og \"USA\" er landet. Det er viktig å merke seg hvert sted fordi slektsregister føres av myndighetene på hvert nivå.<br /><br />Hvis et nivå på stedet er ukjent, bør du legge igjen et mellomrom mellom kommaene. Anta at i eksemplet ovenfor kjente du ikke fylket for Salt Lake City. Du bør da spille inn det slik: \"Salt Lake City, , Utah, USA\". Anta at du bare vet at en person ble født i Utah. Du skriver inn informasjonen slik: \", , Utah, USA\".<br /><br />Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> for å hjelpe deg med å finne steder som allerede finnes i databasen.";
$pgv_lang["edit_LATI_help"]			= "~#factarray[LATI]#~<br /><br />Inntasting av spesifikke bredde- og lengdegradskoordinater frarådes vanligvis da det kun tillater kartlegging av tilgang fra utsikten til det spesifikke elementet. Det er bedre å administrere de geografiske stedene.<br /><br />Inntasting av breddegrad og lengdegrad tillater imidlertid mer presis plassering av markøren.";
$pgv_lang["edit_LONG_help"]			= "~#factarray[LONG]#~<br /><br />Inntasting av spesifikke bredde- og lengdegradskoordinater frarådes vanligvis da det kun tillater kartlegging av tilgang fra utsikten til det spesifikke elementet. Det er bedre å administrere de geografiske stedene.<br /><br />Inntasting av breddegrad og lengdegrad tillater imidlertid mer presis plassering av markøren.";
$pgv_lang["edit_add_parent_help"]	= "~Legg til ny mor eller far~<br /><br />På denne siden kan du legge til en ny mor eller far for den valgte personen.  Fyll ut navnet til den nye personen, samt informasjon om fødselsdato og dødsdato dersom dette er kjent.  Har du ikke nok informasjon til å fylle ut alle felt, så går det greit å la noen være tomme.<br /><br />For å legge til andre faktaopplysninger, så må du først lagre de over nevnte opplysningene.  Så kan du gå til den oppdaterte familiesiden og klikke på navnet til personen. Da vil du få fram faktasiden til personen der du kan legge til flere faktaopplysninger.";
$pgv_lang["edit_add_spouse_help"]	= "~Legg til ny ektemann eller hustru~<br /><br />På denne siden kan du legge til en ny ektemann eller hustru til den valgte personen.  Fyll ut navnet til den nye personen, samt informasjon om fødselsdato og dødsdato dersom dette er kjent.  Har du ikke nok informasjon til å fylle ut alle felt, så går det greit å la noen være tomme.<br /><br />For å legge til andre faktaopplysninger, så må du først lagre de over nevnte opplysningene.  Så kan du gå til den oppdaterte familiesiden og klikke på navnet til personen. Da vil du få fram faktasiden til personen der du kan legge til flere faktaopplysninger.";
$pgv_lang["edit_death_help"]		= "~#pgv_lang[death]#~<br /><br />Dette området lar deg legge inn dødsinformasjon. Skriv først inn datoen da personen døde i standarddatoformat for slektsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato. Gå deretter inn på stedet der personen døde. Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> til å velge et sted som allerede eksisterer i databasen.";
$pgv_lang["edit_birth_help"]		= "~#pgv_lang[birth]#~<br /><br />Dette området lar deg legge inn fødselsinformasjonen. Angi først datoen da personen ble født i standarddatoformat for slektsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato. Gå deretter inn på stedet der personen ble født. Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> til å velge et sted som allerede eksisterer i databasen.";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />Velg riktig kjønn fra listen. Alternativet <b>ukjent</b> indikerer at kjønnet er ukjent.";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Dette er det viktigste feltet i en persons navnepost.<br /><br />Dette feltet skal fylles ut automatisk når de andre feltene fylles ut, men det er gitt slik at du kan redigere informasjonen i henhold til din personlige preferanse.<br /><br />Navnet i dette feltet skal skrives inn i henhold til GEDCOM 5.5.1-standardene med etternavnet omgitt av skråstrek \"/\". Som eksempel skal navnet \"John Robert Finlay Jr.\" legges inn slik: \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />I dette feltet bør du angi etternavnet til personen. I navnet \"John Robert Finlay\" er etternavnet som skal angis her \"Finlay\"<br /><br />Personer med flere etternavn, vanlig i Spania og Portugal, skal skille etternavnene med komma. Dette indikerer at personen skal oppføres under hvert av navnene. For eksempel vil etternavnet \"Cortes,Vega\" være oppført under både <b>C</b> og <b>V</b>, mens etternavnet \"Cortes Vega\" bare blir oppført under <b>C</b>.";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />I dette feltet bør du oppgi eventuelle kallenavn for personen. Dette er et valgfritt felt.<br /><br />Måter å legge til et kallenavn på:<ul><li>Velg <b>endre navn</b>, skriv deretter inn kallenavn og lagre</li><li>Velg <b>legg til nytt navn</b>, skriv deretter inn kallenavn OG navn og lagre</li><li>Velg <b>rediger GEDCOM-post</b> for å legge til flere [2&nbsp;NICK] poster underordnet hoved [1&nbsp;NAME] posten.</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />I dette feltet bør du angi de oppgitte navnene på personen. I navnet \"John Robert Finlay\" er fornavnene som skal angis her \"John Robert\"";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NPFX]#~<br /><br />Dette valgfrie feltet lar deg angi et navneprefiks som <i>Dr.</i> eller <i>Adm.</i><br /><br />Adelstitler som <i>Sir, Lord, Baron, Earl, Hertug, Graf, Freiherr,</i> osv. legges inn som et faktum «#factarray[TITL]#».";
$pgv_lang["edit_NSFX_help"]			= "~#factarray[NSFX]#~<br /><br />Dette valgfrie feltet lar deg angi et navnesuffiks som <i>Jr., Sr., III, IV,</i> osv. og akademisk informasjon som <i>PhD, PEng, FImechE, DVM, MD,</i> osv.";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />På denne siden kan du legge til et barn til den valgte familien.  Fyll ut navnet til barnet, samt informasjon om fødselsdato og dødsdato dersom dette er kjent.  Har du ikke nok informasjon til å fylle ut alle felt, så går det greit å la noen være tomme.<br /><br />For å legge til andre faktaopplysninger, så må du først lagre de over nevnte opplysningene.  Så kan du gå til den oppdaterte familiesiden og klikke på navnet til barnet. Da vil du få fram faktasiden til barnet der du kan legge til flere faktaopplysninger.";

$pgv_lang["review_changes_help"]	= "~#pgv_lang[review_changes_block]#~<br /><br />Denne blokken viser alle postene som er endret på nettet og som fortsatt må gjennomgås og aksepteres i databasen.";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Bruk feltene \"Oppdater navn\" for å endre navnet på personen du redigerer. I feltet Fornavn angir du personens fornavn eller fornavn. I feltet Etternavn skriver du inn personens etternavn eller etternavn. For eksempel, hvis navnet du vil skrive inn er \"John Robert Finlay\", vil du skrive \"John Robert\" i feltet Fornavn og \"Finlay\" i Etternavn-feltet.<br /><br />Hvis du fyller ut disse feltene, vil <u>endre</u> navnet på personen; det vil ikke legge til et nytt navn.<br /><br /><i>Merk: Du bør <u>ikke</u> bruke denne metoden hvis navnet endres på grunn av et nytt ekteskap. Bruk i stedet alternativene for å legge til en ny ektemann nedenfor.</i>";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Bruk feltene \"Oppdater fakta\" for å legge til ny faktainformasjon eller endre et eksisterende faktum for posten du redigerer. Velg først et faktum fra listen. Angi deretter datoen da dette skjedde i standarddatoformatet for slektsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato. Gå deretter inn på stedet da det faktum skjedde. Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> til å velge et sted som allerede eksisterer i databasen.<br /><br />Som med alle de andre feltene i dette skjemaet, vil informasjonen din enten erstatte det som allerede er der, eller det vil opprette nye oppføringer etter behov.";
$pgv_lang["quick_update_address_help"]	= "~#pgv_lang[update_address]#~<br /><br />Bruk disse feltene for å endre adressen, telefon-nummeret eller epost-adressen til denne personen.<br /><br />Som i alle de andre feltene i dette skjemaet, så vil opplysningene du oppgir enten erstatte eksisterende innhold eller så vil det bli opprettet en ny faktaopplysning alt ettersom det som er valgt.";
$pgv_lang["quick_update_spouse_help"]	= "~Legg til en ny mann eller kone~<br /><br />Bruk disse feltene når du vil legge til en ny mann eller kone til personen du redigerer. Skriv inn den nye ektefellens navn og fødselsinformasjon i feltene, og skriv deretter inn datoen de ble gift under ekteskapsinformasjonen. Angi datoer i standard datoformat for slektsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato. Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> til å velge et sted som allerede eksisterer i databasen.<br /><br />Disse feltene vil bare legge til en <i> ny </i> partner; de vil ikke oppdatere informasjonen til en gammel. For å redigere informasjonen til noen som allerede er registrert, lukk dette vinduet og klikk på personens navn i fanen #pgv_lang[relatives]#. Klikk deretter på menyen Rediger person for å redigere informasjonen.";
$pgv_lang["quick_update_marriage_help"] = "~Oppdatere ekteskap~<br /><br />Du kan bruke disse feltene sammen med feltene for å legge til en ny ektemann eller kone hvis du vil registrere et nytt ekteskap. Ellers vil innlegging av data i disse feltene endre informasjon om personens siste ekteskap. Angi datoer i standard datoformat for slektsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato. Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> til å velge et sted som allerede eksisterer i databasen.";
$pgv_lang["quick_update_child_help"] 	= "~#pgv_lang[add_new_chil]#~<br /><br />Bruk disse feltene til å legge til et nytt barn til denne personen. Skriv først inn barnets navn og velg kjønn. Angi deretter datoen og stedet der barnet ble født. Angi datoer i standard datoformat for slektsforskning (1&nbsp;JAN&nbsp;2004). Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato. Du kan bruke koblingen <b>#pgv_lang[find_place]#</b> til å velge et sted som allerede finnes i databasen.<br /><br />Disse feltene vil bare legge til en <u>ny</u> barn. De vil ikke oppdatere informasjonen til et barn som allerede er registrert. For å redigere informasjonen til noen som allerede er i databasen, lukk dette vinduet og klikk på personens navn i fanen #pgv_lang[relatives]#. Klikk deretter på Rediger individuell-menyen for å redigere informasjonen.";
$pgv_lang["index_top10_pageviews_help"]	= "~#pgv_lang[top10_pageviews]#~<br /><br />Denne blokken vil vise de personer, familier eller kilder som har blitt sett mest på av besøkende på dette nettstedet. For at denne blokken skal vises, må nettstedsadministratoren ha aktivert trefftellerne.";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Denne blokken viser retningslinjene for informasjonskapsler på dette nettstedet.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />La dette feltet være tomt hvis du ønsker å bruke standardteksten.<br /><br />Hvis du ønsker å bruke standardteksten og også gi en lenke til en tekstfil eller HTML-side som inneholder detaljer om cookiepolitikken som er spesifikk for nettstedet ditt, kan du angi URLen til siden her.<br /><br />For eksempel kan <b>http://foo.bar.com/policy/cookies.txt</b> peke på en ren tekstfil, mens <b>http://foo.bar.com/policy/cookies.htm</b> peker på en HTML-formatert side, og <b>http://foo.bar.com/policy/cookies.doc</b> peker på et dokument i Microsoft Word-format.";
$pgv_lang["cookiepolicy_link_advice"]		= "La stå tomt for å bruke standardteksten.<br /><br />Skriv inn en URL som <b>http://foo.bar.com/policy/cookies.txt</b> for å peke til en nettstedsspesifikk policy-side.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Dette valget gir deg mulighet til å angi hvilken arkfane som skal åpnes automatisk når siden #pgv_lang[indi_info]# blir vist.  Dersom en bruker kan endre kontoen sin, kan de ulike brukerne velge sin egen standard-arkfane.";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br /><br />Dette valget gir deg som bruker mulighet til å angi hvilken arkfane som skal åpnes automatisk når siden #pgv_lang[indi_info]# blir vist.";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br /><br />Barna er vist i den rekkefølgen de ble lagt inn i slektsbasen.Barn blir ikke automatisk sortert etter fødselsdato fordi fødselsdatoene til noen av barna ofte er usikre, men rekkefølgen på fødselen deres <u>er</u> kjent.<br /><br />Dette alternativet lar deg endre rekkefølgen på barna i familiens journal. Siden du kanskje vil sortere barna etter fødselsdato, er det en knapp du kan trykke på for å gjøre dette for deg.<br /><br />Du kan også dra og slippe hvilken som helst informasjonsrute for å endre rekkefølgen på barna. Når du beveger musepekeren over en informasjonsboks, vil formen endres til et par tohodede kryssede piler. Hvis du trykker og holder nede venstre museknapp før du flytter musemarkøren, vil informasjonsboksen følge musemarkøren opp eller ned i listen. Når informasjonsboksen flyttes, vil de andre boksene gi plass. Når du slipper venstre museknapp, vil informasjonsboksen ta sin nye plass i listen.";
$pgv_lang["rss_feed_help"]				= "~#pgv_lang[rss_feeds]#~<br /><br />ATOM / RSS-feeden som er tilgjengelig i PhpGedView tillater alle å se innholdet på nettstedets velkomstside ved hjelp av en passende feedaggregator uten å besøke nettstedet. De fleste aggregatorer vil vise et varsel som lar brukeren få vite når noe har endret seg på en side som overvåkes. Dette lar i det vesentlige alle overvåke PhpGedView-nettstedet ditt uten å måtte besøke det regelmessig.<br /><br />Feed-blokken brukes til å tilpasse lenken til feeden, slik at spesifikke feedtyper tillates (de fleste lesere kan håndtere de fleste typene, slik at dette vanligvis kan stå igjen som standard), og den spesifikke modulen du vil ha i feed. Språket til feedet og GEDCOM som brukes, vil være basert på språket og GEDCOM som er aktivt i PhpGedView når du velger feedet.<br /><br />Typer feed som kan genereres inkluderer ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML og JavaScript. De fire første typene er for feedaggregatorer, mens JavaScript og HTML er ment å muliggjøre inkludering av feedene på andre websider. Merk at tallene på RSS-feedet indikerer forskjellige stiler, ikke en annen versjon.<br /><br />Det er et alternativ å velge autentisering som vil logge inn brukeren, og tillate brukeren å se, ved hjelp av en passende RSS-aggregator, all informasjon som han normalt kan se hvis den er logget inn. Grunnleggende autentisering bruker <i>Grunnleggende HTTP-autentisering</i> for å logge inn brukeren. Fremtidige forbedringer kan tillate <i>Digest Authentication</i>.<br /><br />Denne <a href='https://no.wikipedia.org/wiki/RSS' target='_blank' alt='Wikipedia artikkelen' title='Wikipedia artikkelen'><b>Wikipedia artikkelen</b></a> inneholder omfattende informasjon og lenker om RSS og de forskjellige RSS-formatene. <i>Grunnleggende HTTP-autentisering</i> er diskutert i dette <a href='https://en.wikipedia.org/wiki/Basic_access_authentication' target='_blank' alt='Wikipedia artikkel' title='Wikipedia artikkel'><b>Wikipedia artikkel</b></a>, mens <i>Digest Authentication</i> er diskutert i dette <a href='https://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia artikkel' title='Wikipedia artikkel'><b>Wikipedia artikkel</b></a>.";

$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Velg en fil fra din lokale PC <b>#MEDIA_DIRECTORY#</b> eller i en av undermappene til denne.<br /><br />Navn på mapper du angir vil bli lagt til <b>#MEDIA_DIRECTORY#</b>. Eksempel: <b>#MEDIA_DIRECTORY#minfamilie</b>. Dersom mappen for miniatyrbilder ikke finnes fra før, vil denne bli lagd automatisk.";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />GEDCOM-konfigurasjonen tillater opptil #GLOBALS[MEDIA_DIRECTORY_LEVELS]# katalognivåer utover standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b> der opplastede mediefiler normalt lagres. Dette lar deg organisere mediefilene dine, og du trenger ikke være så opptatt av å opprettholde unike navn for hver mediefil.<br /><br />I dette feltet angir du destinasjonskatalogen på serveren der den opplastede mediefilen skal lagres. Sørg for å være oppmerksom på store og små bokstaver for det du skriver inn eller velger her, siden fil- og katalognavn er mellom store og små bokstaver.<br /><br />Hvis katalognavnet du oppgir her ikke eksisterer, opprettes det automatisk. Hvis du angir mer enn de ytterligere #GLOBALS[MEDIA_DIRECTORY_LEVELS]# katalognivåene som er tillatt av GEDCOM-konfigurasjonen, blir inngangen din avkortet tilsvarende.<br /><br />Miniatyrbilder blir lastet opp eller opprettet i en identisk katalogstruktur, fra og med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />I dette feltet angir du plasseringen og navnet på mediefilen du vil laste opp til serveren på din lokale computer. Du kan bruke knappen <b>Bla gjennom</b> for å søke på den lokale computer din etter ønsket fil.<br /><br />Den opplastede filen vil ha samme navn på serveren, og den vil lastes opp til katalogen som er spesifisert i feltet <b>#pgv_lang[folder]#</b>.<br /><br />Hvis du ikke ser feltet <b>#pgv_lang[folder]#</b> eller ikke kan endre det, har du ikke tilstrekkelige tillatelser eller GEDCOM-konfigurasjonen din er satt til å tillate ingen katalognivåer utover standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  I dette tilfellet vil mediefilen bli lastet opp til katalogen <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />I dette feltet spesifiserer du plasseringen og navnet på min lokale computer for miniatyrfilen du vil laste opp til serveren. Du kan bruke knappen <b>Bla gjennom</b> for å søke på den lokale computer din etter ønsket fil. Når dette feltet er fylt ut, blir boksen <b>#pgv_lang[auto_thumbnail]#</b> ignorert.<br /><br />Hvis feltet <b>#pgv_lang[media_file]#</b> er fylt ut, vil den opplastede miniatyrfilen din bli navngitt i henhold til innholdet i det feltet, uavhengig av hva den heter på din lokale computer. Hvis det feltet er tomt, vil den opplastede miniatyrfilen kopieres til to steder på serveren, en gang til serverkatalogen nevnt i feltet <b>#pgv_lang[folder]#</b>, og deretter igjen til en identisk katalogstruktur som begynner med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Hvis du ikke ser feltet <b>#pgv_lang[folder]#</b> eller ikke kan endre det, har du ikke tilstrekkelige tillatelser, eller GEDCOM-konfigurasjonen din er satt til å tillate ingen katalognivåer utover standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b> der opplastede mediefiler normalt lagres.";


//-- GENERAL
$pgv_lang["help_header"]				= "Informasjon om:"; 
$pgv_lang["privacy_error_help"]			= "~Private opplysninger~<br />Det er flere mulige årsaker for denne meldingen:<br /><ul><li><b>Informasjon om levende personer er satt til \"Privat\"</b><br />Besøkende og registerte brukere som ikke er logget inn, kan bare se informasjon for døde personer. Dersom administrator har åpnet for det, kan du registere deg ved å klikke på 'Logg inn', og deretter på #pgv_lang[requestaccount]#.</li><li><b>Du er en registret bruker med brukernavn og passord...</b><br />Men du har glemt å logge deg inn eller at du ikke har vært aktiv på en stund og blitt logget ut automatisk.</li><li><b>Av hensyn til personvern</b><br />Personen ønsker at faktaopplysninger om seg selv skal være \"Privat\" eller at personen ikke ønsker å bli vist i det hele tatt (skjult). Personvernet kan settes til:<ul><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ul></li><li><b>Ut fra \"Grad av slektskap\"</b><br />Selv om du er en vanlig bruker <i>og</i> logget inn, så kan det fremdeles hende at du vil se denne meldingen hvis personen som du prøver å se på ikke er i <b>nær</b> slekt med deg. Slektskap er definert som et visst antall steg og er bestemt av administratoren til denne slektssiden.<br /><br />Eksempler:<br />Når steglengden for slektskap er satt til <b>1</b>, så kan du bare se detaljene til din egen familie, far, mor, bror og søster (men ikke ektefellene og barn til broren eller søsteren din)<br /><br />Når steglengden for slektsskap er satt til <b>2</b>, så kan du i tillegg se detaljene til dine søkenes ektefeller og deres barn (men ikke ektefeller til deres barn).<br /><br />Jo høyere steglengden for slektsskap er satt, jo flere detaljer for fjernere slektninger kan du se.</li></ul><br />Dersom du mener deg kvalisert til å se visse detaljer, vennligst kontakt administratoren ved å bruke kontaktlinken nederst på sidene.";
$pgv_lang["more_help"]				= "Kontekstuell hjelp er tilgjengelig på hver skjerm; sørg for at alternativet <b>#pgv_lang[show_context_help]#</b> i Hjelp-menyen er på, og klikk på et <b>#pgv_lang[qm]#</b> ved siden av emnet.";
$pgv_lang["start_admin_help"]			= "+++ Start ekstra info for Admin +++";
$pgv_lang["end_admin_help"]				= "--- Slutt ekstra info for Admin ---";
$pgv_lang["multiple_help"]				= "<span class='center'>--- Dette er en generell hjelpetekst for flere sider ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>GENERELL INFORMASJON</b></div>";
$pgv_lang["best_display_help"]			= "~#pgv_lang[resolution]#~<br /><br />PhpGedView tar seg best ut med skjermoppløsning på 1024x768. Med denne oppløsningen vil du kunne se alle deler på en gang.<br /><br />Dersom du har valgt en lavere oppløsningen (for eksempel 800x600), vil du til en viss grad bli tvunget til å bruke den horisontale rullefunksjonen for å se all informasjon.";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br /><br />Hvis du klikker <b>#pgv_lang[print_preview]#</b>, fjernes elementene som ikke ser bra ut på en trykt side (menyer, inndatabokser, ekstra lenker, spørsmålstegnene for kontekstuell hjelp osv.)<br /><br />Du får en knapp <b>#pgv_lang[print]#</b> nederst på den forenklede siden; når du klikker på denne knappen vil systemets utskriftsdialog vises. Etter utskrift klikker du på <b>#pgv_lang[cancel_preview]#</b> og skjermen vil bli gjenoppbygd som normalt.<br /><br />Merk: Selv om dette alternativet fjerner mange koblinger fra siden som vises, er de resterende koblingene fortsatt aktive.";
$pgv_lang["readme_help"]				= "Se i filen <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> for mer informasjon.";
$pgv_lang["is_user_help"]				= "--- Denne hjelpeteksten er den samme teksten som besøkende vil lese. ---<br />--- For å spare plass laget vi ikke en spesiell admintekst for dette elementet. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Når du klikker på denne lenken, åpnes et nytt vindu som inneholder de rå GEDCOM-dataene til detaljene på denne siden.<br /><br />Her kan du redigere GEDCOM-dataene direkte. Sørg for å angi gyldige GEDCOM 5.5.1-data, da det ikke vil bli gjort ytterligere gyldighetskontroller. De endrede eller tilførte dataene vil vises i PhpGedView som \"endringer\", og må godtas av en bruker med godta-rettigheter.";
$pgv_lang["RESN_help_title"]		= "Setter begrensningene på fakta";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />Med unntak av generelle personvern-innstillinger, har PhpGedView muligheten til å angi begrensninger for visning og endring av faktaopplysninger for personer og familier. Begrensningene kan angis av alle som har rett til å endre informasjon, med unntak der personvern eller tidligere innstillinger forbyr dette.<br /><br />Følgende verdier kan brukes:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Administratorer av nettstedet, administratorer av slektsbasen og brukere som har rett til å endre, kan endre informasjon.<br />Faktaopplysninger kan vises i henhold til innstillinger for personvern lagt inn av administratoren.</li><li><b>#pgv_lang[locked]#</b><br />Denne innstillingen har ingen innvirkning på visningen av faktaopplysninger. Den begrenser retten til å endre for administratorer av nettstedet og administratorer av slektsbasen. Dersom opplysningene gjelder brukeren selv, kan han også se og endre disse dersom han har rett til å endre.</li><li><b>#pgv_lang[privacy]#</b><br />Administratorer av nettstedet og administratorer av slektsbasen kan se og endre opplysningene. Dersom opplysningene gjelder brukeren selv, kan han også se og endre disse dersom han har rett til å endre. Opplysningene vil være skjult for alle andre brukere uavhengig av status som bruker.</li><li><b>#pgv_lang[confidential]#</b><br />Bare Administratorer av nettstedet og administratorer av slektsbasen kan se og endre opplysningene. Opplysningene vil være skjult for alle andre brukere uavhengig av status som bruker.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Eier</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Andre</th></tr><tr><th></th><th></th><th>L</th><th>E</th><th></th><th>L</th><th>E</th><th></th><th>L</th><th>E</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : kan lese</li><li>E : kan endre</li><li><img src=\"images/checked_qm.gif\"/> : avhengig av globale personvern-innstillinger</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~#pgv_lang[welcome_page]#~<br /><br />Denne siden er velkomstsiden. Det ønsker deg velkommen til den valgte <a href=\"#def_gedcom\">GEDCOM</a> filen. Du kan gå tilbake til denne siden ved å velge Velkomstside fra toppmenyen. Hvis det er flere GEDCOM-er på dette nettstedet, kan du velge en GEDCOM fra menyen.<br /><br />Denne hjelpesiden inneholder informasjon om:<ul><li><a href=\"#index_portal\"><b>Velkomstside</b></a></li><li><a href=\"#header\"><b>Header Area</b></a></li><li><a href=\"#menu\"><b>Menyer</b></a></li><li><a href=\"#header_general\"><b>Generell informasjon</b></a></li><li><a href=\"#def\"><b>Definisjoner</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]				= "<div class='name_head center'><b>#pgv_lang[header]#</b></div><br />Den øverste delen av sidene (toppfeltet) blir vist på hver side. Her finner du noen nyttige linker som du kan bruke på alle sider.<br /><br />Siden PhpGedView kan ha forskjellig utseende, ved å velge forskjellige <a href=\"#def_theme\">stiler</a>, vil toppfeltet kunne inneholde forskjellige linker / valg.<br /><br />Linker som du kan finne er:<ul><li><a href=\"#header_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#header_lang_select\"><b>#pgv_lang[change_lang]#</b></a></li><li><a href=\"#header_user_links\"><b>#pgv_lang[login]#</b></a></li><li><a href=\"#header_favorites\"><b>#pgv_lang[my_favorites]#</b></a></li><li><a href=\"#header_theme\"><b>#pgv_lang[change_theme]#</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~#pgv_lang[header]# «#pgv_lang[search]#»~<br /><br />Denne søkeboksen er liten, men kraftig. Du kan få PhpGedView til å søke nesten hva som helst for deg. Når du klikker på knappen <b>&gt;</b> eller <b>Søk</b>, blir du lenket til søkesiden for å se resultatene av søket ditt. Du finner omfattende hjelp om søkealternativer på søkesiden.";
$pgv_lang["header_lang_select_help"]	= "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br /><br />En av de viktigste funksjonene i PhpGedView er at flere språk støttes.<br /><br />Språket PhpGedView viser alle sider på bestemmes automatisk i henhold til innstillingen Foretrukket språk i nettleseren. Imidlertid kan nettstedsadministratoren ha begrenset tilgjengeligheten av visse språk.<br /><br />Avhengig av nettstedskonfigurasjon, kan det hende du kan endre språket til PhpGedView ved å velge et mer passende språk fra en liste eller ved å klikke på et flaggikon. Hvis du er en registrert bruker, kan du konfigurere PhpGedView til å bytte til ønsket språk etter at du har logget inn, uavhengig av hva nettleseren din er satt til.";
$pgv_lang["header_user_links_help"]		= "~#pgv_lang[header]# «#pgv_lang[login]#»~<br /><br />Brukerlinkene er en liten blokk med nyttige lenker som finnes på samme sted på hver side. Plasseringen av disse koblingene varierer avhengig av temaet som er i kraft.<br /><br />Når du ikke er logget på, vil du bare se koblingen <b>Logg inn</b>. Etter at du har logget inn, vil du se:<ul><li><b>Logget på som (ditt brukernavn)</b>. Hvis du klikker på denne lenken, kommer du til kontosiden din.</li><li>Klikk <b>Logg ut</b> for å logge av.</li><li>Hvis du har administratorrettigheter, vil du også se <b>Admin</b>. Ved å klikke på denne lenken vil du ta deg direkte til hovedsiden for administrasjon.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br /><br />Favorittlisten viser favorittene du har valgt på din personlige portalside. Den viser også favorittene som nettstedsadministratoren har valgt for den nåværende aktive GEDCOM. Ved å klikke på en av favorittoppføringene, kommer du deg direkte til #pgv_lang[indi_info]# siden til vedkommende.<br /><br />Mer hjelp til å legge til favoritter er tilgjengelig på din personlige portalside.";
$pgv_lang["header_theme_help"]			= "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br /><br />Når denne administratoren er aktivert, viser listen Endre tema deg en liste over temaene du kan bruke til å vise nettstedet.<br /><br />Du kan endre utseendet på nettstedet ved å velge et tema fra listen. Hvis du er logget inn, vil det også endre ditt brukertema til det du valgte, slik at din neste pålogging automatisk velger det samme temaet.";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class='name_head center'><b>MENYEN</b></div><br />Sideoverskriftene har menyer tilknyttet hvert menyikon.<br /><br />Når du beveger musepekeren over et ikon, vises en undermeny, hvis en finnes. Når du klikker på et ikon, blir du ført til det første elementet i undermenyen<br /><br />Følgende menyikoner er vanligvis tilgjengelige:<ul><li><a href=\"#menu_fam\"><b>#pgv_lang[welcome_page]#</b></a></li><li><a href=\"#menu_myged\"><b>#pgv_lang[mygedview]#</b></a></li><li><a href=\"#menu_charts\"><b>#pgv_lang[charts]#</b></a></li><li><a href=\"#menu_lists\"><b>#pgv_lang[lists]#</b></a></li><li><a href=\"#menu_annical\"><b>#pgv_lang[anniversary_calendar]#</b></a></li><li><a href=\"#menu_clip\"><b>#pgv_lang[clippings_cart]#</b></a></li><li><a href=\"#menu_search\"><b>#pgv_lang[search]#</b></a></li><li><a href=\"#menu_help\"><b>#pgv_lang[page_help]#</b></a></li></ul>";
$pgv_lang["menu_famtree_help"]			= "~#pgv_lang[welcome_page]#~<br /><br />PhpGedView kan håndtere flere slektsfiler. Dersom det er lagt inn flere, vil alle tilgjengelige slektsbaser bli vist i en undermeny. Hver slektsbase vil ha sin egen hovedside som vil kunne vise forskjellige blokker og innhold.";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Hvis du er logget inn, kan denne menyen inneholde følgende elementer:<ul><li><a href=\"?help=index_myged_help\"><b>#pgv_lang[mygedview]#</b></a><br />Dette tar deg til din egen tilpassbare startside.</li><li><a href=\"?help=help_edituser.php\"><b>#pgv_lang[editowndata]#</b></a><br />Du kan redigere dine personlige data her.</li><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[my_pedigree]#</b></a><br />Hvis du har valgt en rotperson for denne GEDCOM, vil dette føre deg til stamtavle for den personen.</li><li><a href=\"?help=help_individual.php\"><b>#pgv_lang[my_indi]#</b></a><br />Denne lenken tar deg til siden #pgv_lang[indi_info]#, der alle slektsdata om deg selv og familien din vises.</li></ul>";
$pgv_lang["menu_charts_help"]			= "~#pgv_lang[charts]#~<br /><br />De tilgjengelige kartene er:<ul><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Dette vil koble deg til stamtavle for denne GEDCOM-filen. Stamtavlen starter med personen som er konfigurert av administratoren. Når du er logget inn, kan startpersonen være den du har konfigurert i kontoinnstillingene dine.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Avstamningsdiagrammet er egentlig et <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> i omvendt rekkefølge. Denne sammenligningen er ikke helt riktig, men mens stamtavlen viser deg alle forfedrene til en startperson, viser avstamningskartet deg alle etterkommerne til en startperson.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Her viser du hendelsene til en person langs en tidslinje. Det er interessant å sammenligne hendelsene til to eller flere personer på samme tidslinje.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Her kan du sjekke forholdet til en person til deg selv eller til en annen person.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Dette diagrammet er veldig likt <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men med flere detaljer og alternativ <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> vises.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Dette diagrammet er veldig likt <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men på en mer grafisk måte.</li></ul>";
$pgv_lang["menu_lists_help"]			= "~#pgv_lang[lists]#~<br /><br />Følgende lister er tilgjengelige:<ul><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />I disse to listene kan du bla gjennom alfabetiske lister over enkeltpersoner eller familier i dette GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Dette elementet returnerer en liste over alle kildene som brukes i GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Her kan du se etter folk etter sted.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Du ser dette menyelementet bare hvis det er aktivert av nettstedsadministratoren. Dette vil vise lenker til alle multimediefiler i denne GEDCOM.</li></ul>";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />The #pgv_lang[anniversary_calendar]# viser hendelsene i en GEDCOM for en gitt dato, måned eller år.<ul><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Disse menyelementene tar deg til #pgv_lang[anniversary_calendar]# for å vise en liste over alle hendelsene for gjeldende dag, måned eller år.</li></ul>";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]#~<br /><br />Du vil bare se dette elementet i menylinjen når administratoren har aktivert denne funksjonen.<br /><br />#pgv_lang[clip_cart]# lar deg lagre informasjon om enkeltpersoner, familier og kilder i en midlertidig fil som du kan senere laste ned i GEDCOM 5.5.1-format.";
$pgv_lang["menu_search_help"]			= "~#pgv_lang[search]#~<br /><br />Søkesiden er en kraftigere versjon av søkeboksen du kan finne i hver sideoverskrift.";
$pgv_lang["menu_help_help"]				= "~#pgv_lang[page_help]#~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>#pgv_lang[welcome_page]#</b></div>";
$pgv_lang["index_portal_help"]			= "#pgv_lang[welcome_page]# består av flere separate blokker, og kan tilpasses. På nettsteder som har mer enn en genealogisk database, kan det hende du ser en annen velkomstside for hver. Avhengig av hvordan administratoren tilpasser nettstedet, kan du se en av følgende blokker på velkomstsiden:<ul><li><a href=\"#index_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#index_login\"><b>#pgv_lang[login_block]#</b></a></li><li><a href=\"#index_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#index_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#index_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#index_favorites\"><b>#pgv_lang[gedcom_favorites_block]#</b></a></li><li><a href=\"#index_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#index_common_surnames\"><b>#pgv_lang[block_top10]#</b></a></li><li><a href=\"#index_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#index_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#gedcom_news\"><b>#pgv_lang[gedcom_news_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Velkomstblokken viser gjeldende databasetittel, dato og klokkeslett, og hvis aktivert av administratoren, trefftelleren.<br /><br />Trefftelleren er bare tilgjengelig i velkomstblokken og på #pgv_lang[indi_info]# side. Telleren teller \"treffene\" på disse sidene. Det betyr at det teller hvor mange ganger disse sidene blir besøkt. Telleren sjekker ikke en besøkendes internettadresse; hvert besøk på en side fra <u> hvilken som helst </u> ekstern plassering teller som et nytt treff.";
$pgv_lang["index_login_help"]			= "~#pgv_lang[login_block]#~<br /><br />Du kan logge på nesten alle sider i dette programmet. Du vil vanligvis gjøre det på første side, siden du bare har tilgang til privilegert informasjon når du er logget inn.<br /><br />Du kan logge inn ved å skrive <b>#pgv_lang[username]#</b> og <b>#pgv_lang[password]#</b> og deretter klikke på <b>#pgv_lang[login]#</b> knappen.";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br /><br />Denne blokken viser deg merkedager for hendelser som kommer i nær fremtid.<br /><br />Administratoren bestemmer hvor langt fremover blokken skal se ut. Du kan videre avgrense blokkeringen av kommende hendelser gjennom flere konfigurasjonsalternativer.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~#pgv_lang[todo_block]#~<br /><br />Denne blokken hjelper deg med å holde oversikt over <b>_TODO</b> oppgaver i databasen.<br /><br />For å legge til Å Gjøre oppgaver i postene dine, må du kanskje først endre GEDCOM-konfigurasjonen slik at <b>_TODO</b> fakta er i listen over fakta som kan legges til personopplysningene, familiene, kildene og arkivene. Hver av disse listene, som du finner i delen Rediger alternativer i GEDCOM-konfigurasjonen, er uavhengige. Rekkefølgen på listeoppføringene er ikke viktig; du kan legge til de nye oppføringene på begynnelsen av hver liste.";
$pgv_lang["todo_show_other_help"]     = "Vis oppgaver som er tilordnet andre brukere";
$pgv_lang["todo_show_unassigned_help"]= "Vis oppgaver som ikke er tildelt noen brukere";
$pgv_lang["todo_show_future_help"]= "Vis oppgaver som har en dato i fremtiden. Ellers vises bare varer med en dato tidligere.";
$pgv_lang["yahrzeit_help"]			="~#pgv_lang[yahrzeit_block]#~<br /><br />Denne blokken viser deg Yahrzeiten som kommer opp i nær fremtid.<br /><br />Yahrzeiten (entall: Yahrzeit) er merkedager for en persons død. Disse merkedagene observeres i den jødiske tradisjonen; de er ikke lenger i vanlig bruk i andre tradisjoner. «Yahrzeit» kan også staves «Jahrzeit» eller «Yartzeit».<br /><br />Administratoren bestemmer hvor langt fremover blokken vil se ut. Blokkens visning av kommende Yahrzeiten kan forbedres ytterligere gjennom konfigurasjonsalternativer.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Angi antall dager som skal vises.  Dette tallet kan ikke være større enn <b>#DAYS_TO_SHOW_LIMIT#</b>.  Hvis du angir en større verdi, vil den grensen bli brukt.<br /><br />Grensen som vises er satt av administratoren i GEDCOM-konfigurasjon, Vis og oppsett-delen, Skjul &amp; Vis underavsnitt.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Dette alternativet lar deg bestemme hvilken type media som skal vises.<br /><br />Når du velger <b>#pgv_lang[random_media_persons]#</b>, vises bare medier tilknyttet personer. Vanligvis vil dette være en persons fotografi. Når du velger <b>#pgv_lang[random_media_events]#</b>, vises bare medier tilknyttet fakta eller hendelser. Dette kan være et bilde av et sertifikat. Når du velger <b>#pgv_lang[all]#</b>, vil denne blokken vise alle typer medier.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />Du kan begrense hva Tilfeldige Medier blokken har tillatelse til å vise i henhold til formatet og typen medieelement. Når en gitt avkrysningsrute er merket av, kan Tilfeldige Medier blokken vise medieelementer av det formatet eller typen.<br /><br />Format- eller typekoder som finnes i databasen din, men som ikke er i disse avmerkingslistene, antas å ha den tilhørende avmerkingsboksen. For eksempel, hvis databasen din inneholder medieobjekter i formatet <b><i>pdf</i></b>, har Tilfeldige Medier blokken alltid tillatelse til å vise dem. På samme måte, hvis databasen din inneholder medieobjekter av typen <b><i>special</i></b>, har Tilfeldige Medier blokken alltid tillatelse til å vise dem.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Dette alternativet lar deg eliminere noen daterte hendelser. For eksempel bør #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, osv. dateres.<br /><br />Når du velger <b>#pgv_lang[yes]#</b>, vises bare fødsler, dødsfall og ekteskap. Når du velger <b>#pgv_lang[no]#</b>, vises alle daterte hendelser.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Dette alternativet styrer hvordan informasjonen presenteres.<br /><br />Når du velger <b>#pgv_lang[style1]#</b>, vises informasjonen i tekstform, i likhet med hva du ser i de forskjellige kartboksene. Dette formatet er godt egnet for blokker som skrives ut på høyre side av siden.<br /><br />Når du velger <b>#pgv_lang[style2]#</b>, vises informasjonen i tabellformat, og passer mer til de større blokkene som skrives ut på venstre side av siden.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Dette alternativet styrer hvordan informasjonen sorteres.<br /><br />Når du velger <b>#pgv_lang[by_alpha]#</b>, vises informasjonen i alfabetisk rekkefølge. Når du velger <b>#pgv_lang[by_anniv]#</b>, ordnes informasjonen etter jubileum, med de siste merkedager først.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Dette alternativet styrer om knappen for nedlasting av kalenderhendelser vises til påloggede brukere. Den nedlastede kalenderfilen kan importeres til kompatible progblokker som Microsoft Outlook for å generere automatisk e-postpåminnelser om merkedager.<br /><br />Når den er satt til <b>#pgv_lang[no]#</b>, vil ikke den påloggede brukeren kunne laste ned kalenderfilen. Når den er satt til <b>#pgv_lang[yes]#</b>, vises nedlastningsknappen. Denne knappen vises aldri når brukeren ikke er logget inn.";
$pgv_lang["cal_download_user_help"]			= "Hvis du er logget inn, ser du kanskje ikonet <img src='images/ical.png' alt='' />. Hvis du klikker på ikonet, laster du ned hendelsene som en kalenderfil, som kan importeres til kompatible progblokker som Microsoft Outlook for å generere automatiske e-postpåminnelser om merkedager.<br /><br />Hvis du er logget på og ikke ser dette ikonet, har administratoren deaktivert denne funksjonen. Besøkende som ikke er logget inn vil ikke se dette ikonet og kan ikke laste ned kalenderfilen.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br /><br />Denne blokken tillater et stamtavle-, etterkommere- eller timeglassdiagram på velkomst- eller MyGedView-siden. På grunn av plassbegrensninger, bør kartene bare plasseres på venstre side av siden.<br /><br />Når denne blokken vises på velkomstsiden, bestemmes rotpersonen og typen diagram som skal vises av administratoren. Når denne blokken vises på brukerens personlige MyGedView-side, bestemmes disse alternativene av brukeren.<br /><br />Oppførselen til disse diagrammene er identisk med deres oppførsel når de blir hentet fra menyene. Klikk på boksen til en person for å se mer informasjon om dem.";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[todays_events_block]#~<br /><br />Denne blokken er lik #pgv_lang[upcoming_events_block]# blokken, bortsett fra at den viser dagens hendelser.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites_block]#~<br /><br />Denne blokken er omtrent den samme som #pgv_lang[user_favorites_block]# blokken på #pgv_lang[mygedview]# siden. I motsetning til konfigurasjonen av portalsiden, er det bare administratoren eller en bruker med administratorrettigheter som kan endre listen over favoritter i denne blokken.<br /><br />Hensikten med denne blokken er å trekke den besøkendes oppmerksomhet mot personer av spesiell interesse. GEDCOMs favoritter er tilgjengelige for valg fra en liste i overskriften på hver side.<br /><br />Når du klikker på en av de oppførte nettstedfavorittene, blir du ført til #pgv_lang[indi_info]# siden til vedkommende.";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br /><br />Dette skjemaet lar deg legge til et nytt favorittelement i favorittlisten.<br /><br />Du må oppgi enten en ID for personen, familien eller kilden du vil lagre som favoritt, eller du må oppgi en URL og en tittel. Notatfeltet er valgfritt og kan brukes til å beskrive favoritten. Alt som er oppgitt i Merk-feltet, vises i favorittblokken etter varen.";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats_block]#~<br /><br />I denne blokken vil du se noen statistiske opplysninger om den aktive slektsbasen. Dersom du ønsker mer informasjon, kan du imidlertid sende en forespørsel til kontaktpersonen som du finner nederst på siden.";
$pgv_lang["index_common_names_help"]	= "~#pgv_lang[block_top10]#~<br /><br />Denne blokken vil liste opp de hyppigst forekommende etternavnene, med et antall for hvert. Hvis du klikker på et navn, vil det ta deg til Personer-listen, som allerede er filtrert for navnet du klikket på.<br /><br />Administratoren bestemmer hvor mange navn som faktisk skal vises.";
$pgv_lang["index_common_given_names_help"]		= "~#pgv_lang[block_givn_top10]#~<br /><br />Denne blokken viser de mest gitte navnene. Det viser mannlige og kvinnelige navn i kolonner. En tredje kolonne vises når det er personer som kjønnet ikke er kjent for.<br /><br />Administratoren bestemmer hvor mange navn som faktisk vises.";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br /><br />I denne blokken velger PhpGedView tilfeldig en mediefil som skal vises ved hvert besøk på denne siden.<br /><br />Når du klikker på bildet, vil du se versjonen i full størrelse. Under bildet har du en lenke til personen som er knyttet til bildet. Når du klikker på bildeteksten, vil du se bildet på #pgv_lang[media_list]# siden. Når du klikker på personens navn, blir du ført til #pgv_lang[indi_info]# siden til vedkommende.";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[logged_in_users_block]#~<br /><br />Denne blokken viser brukerne som er pålogget.<br /><br />Hvis du ikke er administrator, er ditt syn på påloggede brukere begrenset til de som har valgt å være synlige mens de er online. For at dette skal fungere, må du også velge å være synlig mens du er online. Online-brukere som er usynlige for deg, regnes som anonyme.";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br /><br />Nyhetsblokken er som et oppslagstavle for denne GEDCOM. Nettstedsadministratoren kan plassere viktige kunngjøringer eller interessante nyhetsmeldinger her.<br /><br />Hvis du har noe interessant å vise, kan du kontakte nettstedsadministratoren; han kan legge meldingen din på dette oppslagstavlen.";
$pgv_lang["recent_changes_help"]		= "~#pgv_lang[recent_changes_block]#~<br /><br />Denne blokken viser deg de aller siste endringer som er gjort i slektsfilen. Dette er knyttet til faktakoden CHAN.";
$pgv_lang["gedcom_news_limit_help"]		= "Du kan begrense antall nyheter som vises, og derved redusere høyden på GEDCOM News-blokken.<br /><br />Dette alternativet avgjør om noen grenser skal brukes, eller om grensen skal være i henhold til artikkelens alder eller i henhold til antall artikler.";
$pgv_lang["gedcom_news_flag_help"]		= "Angi begrensningsverdien her.<br /><br />Hvis du har valgt å begrense visningen av nyhetsartikkelen i henhold til alder, vil enhver artikkel som er eldre enn antall dager som er angitt her, være skjult for visning. Hvis du har valgt å begrense visningen av nyheter om antall, vises bare det angitte antallet nylige artikler, sortert etter alder. De gjenværende artiklene blir skjult fra visningen.<br /><br />Nuller som er angitt her, vil deaktivere grensen, og føre til at alle nyheter vises.";
$pgv_lang["gedcom_news_archive_help"]	= "For å redusere høyden på News-blokken har administratoren skjult noen artikler. Du kan avsløre disse skjulte artiklene ved å klikke på <b>#pgv_lang[gedcom_news_archive]#</b> lenken.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Denne blokken lar administratoren legge til informasjon på indeks- eller portalsiden. Hensikten er lik #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, og #pgv_lang[gedcom_stats_block]# blokker, men administratoren har mer kontroll over utseendet.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />Denne teksten skal være blank eller veldig kort. Når den er blank, vises den avanserte HTML-blokken på indeks- eller portalsiden som en vanlig blokk, akkurat som HTML-blokken gjør. Når det er tekst, vil den avanserte HTML-blokken vises som alle andre blokker, komplett med en blokkerings tittellinje som inneholder teksten du skriver inn her.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />For å hjelpe deg med å komme i gang med denne blokken har vi opprettet flere standardmaler. Når du velger en av disse malene, vil tekstområdet inneholde en kopi som du deretter kan endre for å dekke nettstedets krav.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />I motsetning til #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, og #pgv_lang[gedcom_stats_block]# blokker, har du full kontroll over utseendet til blokken din. Du kan bruke HTML-koder, og blokken bruker CSS-stilark fra det aktive temaet. Henvisninger til informasjon fra den nåværende aktive slektsdatabasen kan inkluderes i teksten.<br /><br />Databasereferanser signaliseres i teksten ved å legge inn nøkkelord i sammenkoblede <b>&#35;</b> symboler. For eksempel representerer <b>&#35;totalFamilies&#35;</b> antall familier i databasen. Noen ganger kan det være lurt å bruke en databasereferanse som tekst i stedet for den sanne betydningen. For å gjøre dette må du erstatte <b>&#35;</b> symbolene som omgir søkeordet med deres symbolske tilsvarende. For eksempel, hvis teksten din inneholder <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b>, vil den i stedet skrives ut som <b>&#35;totalFamilies&#35;</b> av å bli en referanse til databasen.<br /><br />For et fullstendig eksempel på bruk av denne blokken, vennligst undersøk &quot;#pgv_lang[gedcom_stats_block]#&quot; mal funnet i blocks/ katalogen, bruker den de fleste stilene til koder, inkludert språk- og hjelpetekstkoblinger.<br /><br /><b>#pgv_lang[htmlplus_block_keyword]#</b> malen inneholder en fullstendig mal liste over alle støttede nøkkelord.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Aktiver kompatibilitet med eldre versjoner av denne blokken. Når dette er merket av, blir både gamle og nye søkeord gjenkjent og handlet etter.<br /><br />For eksempel blir teksten <b>&#35;TOTAL_FAM&#35;</b> anerkjent som ekvivalent med <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> med <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> med <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />Med mindre det er absolutt nødvendig, bør du ikke bruke kompatibilitetsmodus.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Velg databasen som søkeordene gjelder for.<br /><br />Nettstedet ditt støtter flere databaser. Nøkkelord som <b>&#35;totalFamilies&#35;</b> kan bare referere til en database. Du kan identifisere databasen som skal konsulteres for alle slike nøkkelord. Hver #pgv_lang[htmlplus_block_name]# blokk har bare tilgang til én database.";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br /><br />Skjul eller vis listen over fornavn på personer av ukjent kjønn.<br /><br />Blokken #pgv_lang[block_givn_top10]# skjuler alltid listen over gitte navn når det ikke finnes personer av det kjønnet i databasen din. Dette alternativet lar deg skjule listen over personer av ukjent kjønn, selv når det er slike personer i databasen din.";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Selvfølgelig ville det være ideelt å lage et program så enkelt og enkelt å bruke at det ikke trenger noen forklaring i det hele tatt; det skal være så enkelt som å lese en bok.<br /><br />Selv om PhpGedView er veldig komplisert, bør du ikke legge merke til det når du bruker det; nesten alt kan brukes uten forklaring. Men siden vi kanskje har mange besøkende og brukere som ikke er veldig erfarne med bruk av datamaskin eller med Internett, tilbyr vi deg litt hjelp på bestemte steder.<br /><br />Du finner følgende elementer i Hjelp-menyen:";
$pgv_lang["help_page_help"]				= "<ul><li><b>#pgv_lang[help_for_this_page]#</b><br />For alle sider er det en generell \"Sidehjelp\" tilgjengelig. Du kan klikke på dette elementet i menyen for å få \"Sidehjelp\", der du vil bli informert om elementene på den samme siden.<br /><br />Sidehjelp er ofte kort. Hvis du trenger mer hjelp eller informasjon om et bestemt element på siden enn Page Help gir, kan du bruke \"Kontekstuell hjelp\" funksjonen.</li></ul>";
$pgv_lang["help_content_help"]			= "<ul><li><b>#pgv_lang[help_contents]#</b><br />Når du klikker på dette menyelementet, får du en hjelpeside som viser en indeks over de viktigste hjelpemnene. Mengden tilgjengelig informasjon om hjelp vil bli økt etter hvert som tiden tillater det.</li></ul>";
$pgv_lang["help_faq_help"]			= "<ul><li><b>FAQ-liste</b><br />#pgv_lang[text_faq_help]#</li></ul>";
$pgv_lang["help_HS_help"]			= "<ul><li><b>#pgv_lang[hs_title]#</b><br />#pgv_lang[hs_intro]#</li></ul>";
$pgv_lang["help_qm_help"]				= "<ul><li><b>Skjul / vis kontekstuell hjelp</b><br />Dette siste menyelementet kan være det mest nyttige for deg. Ved å klikke på denne lenken vil du enten slå på eller av \"Kontekstuell hjelp\".<br /><br />Når Kontekstuell hjelp er slått på, kan du finne et spørsmålstegn eller lignende ikon ved siden av noen lenker, ruter eller knapper. Når du klikker på dette ikonet, vil et hjelpeskjermbilde dukke opp. Denne hjelpeskjermen inneholder informasjon om det objektet.<br /><br />Når du klikker \"Skjul kontekstuell hjelp\", vil selvfølgelig alle spørsmålstegnene eller ikonene forsvinne til du klikker \"Vis ....\" en gang til.</li></ul>";

//-- Index-page Definitions
$pgv_lang["def_help"]					= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Her er forklaring på noen ord som er brukt i denne hjelpeteksten:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM (slektsfil)</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Datoer</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF-filformat</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Velkomstside</b></a></li><li><a href=\"#def_theme\"><b>Stil</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Velkomstside~<br /><br />Nettstedets portal er som lobbyen til en restaurant eller et offentlig bibliotek. Det er stedet du går inn, men du kan også finne viktig informasjon som forklaringer, menyer osv.";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM (slektsfil)~<br /><br />Et sitat fra introduksjonen til GEDCOM 5.5.1-standarden:<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Norsk versjon:<div class=\"list_value_wrap\">GEDCOM ble utviklet av Familiehistorisk avdeling for Jesu Kristi Kirke av Siste Dagers Hellige (SDH kirke) for å gi et fleksibelt, enhetlig format for utveksling av datastyrte slektsdata. GEDCOM er et akronym for <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (slektsforskning datakommunikasjon). Hensikten er å fremme deling av genealogisk informasjon og utvikling av et bredt spekter av interoperable programvareprodukter for å hjelpe slektsforskere, historikere og andre forskere.</div><br />En kopi av GEDCOM 5.5.1 <u> utkast </u> Standard, som PhpGedView følger, kan lastes ned i PDF-format her:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Denne standarden er bare tilgjengelig på engelsk.<br /><br />GEDCOM-filen inneholder all informasjon om familien. Her lagres alle fakta, datoer, hendelser osv. GEDCOM-filer må følge strenge regler fordi de må kunne byttes mellom mange progblokker, uavhengig av plattformer eller operativsystemer.";
$pgv_lang["def_gedcom_date_help"]		= "~Datoer i en slektsfil~<br /><br />Selv om datofeltet tillater inntasting av fritt skjema (noe som betyr at du kan skrive inn hva du vil), er det noen regler om hvordan datoer skal skrives inn i henhold til GEDCOM 5.5.1-standarden.<ul><li>En full dato angis i skjemaet DD MMM ÅÅÅÅ. For eksempel <b>01&nbsp;MAR&nbsp;1801</b> eller <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Hvis du mangler en del av datoen, kan du utelate den delen. F.eks. <b>MAR&nbsp;1801</b> eller <b>14&nbsp;DEC</b>.</li><li>Hvis du ikke er sikker, eller datoen ikke er bekreftet, kan du skrive <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = om), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = før), <b>AFT&nbsp;1949</b> (aft = after = etter)</li><li>Datoperioder angis som <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> eller som <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = mellom)<br /><br /><b>FROM</b> indikerer at hendelsen som beskrives skjedde kontinuerlig mellom de angitte datoene og brukes sammen med hendelser som ansettelse. <b>BET</b> indikerer en enkelt forekomst av hendelsen, en gang mellom de oppgitte datoene og brukes sammen med hendelser som fødsel.<br /><br />Ukorrekte datoer, der dagen i måneden eller måneden mangler, tolkes alltid som den første eller siste mulige datoen, avhengig av om den upresise datoen inntreffer før eller etter det separerende nøkkelordet. For eksempel tolkes <b>FEB&nbsp;1804</b> som <b>01&nbsp;FEB&nbsp;1804</b> når det skjer før TO eller AND, og som <b>29&nbsp;FEB&nbsp;1804</b> når det oppstår etter TO eller AND.</li></ul><br /><b>Sørg for å skrive inn datoer og forkortelser på <u>engelsk</u>,</b> for da kan GEDCOM-filen byttes ut og PhpGedView kan oversette alle datoer og forkortelser riktig til det aktive språket. Videre gjør PhpGedView beregninger ved hjelp av disse datoene. Hvis upassende datoer skrives inn i datofelt, vil ikke PhpGedView kunne beregne riktig. Du kan klikke på Kalender-ikonet for å få hjelp til å velge en dato.<br /><br />Følgende forkortelser brukes:<ul><li>JAN = January = Januar</li><li>FEB = February = Februar</li><li>MAR = March = Mars</li><li>APR = April</li><li>MAY = Mai</li><li>JUN = June = Juni</li><li>JUL = July = Juli</li><li>AUG = August</li><li>SEP = September</li><li>OCT = October = Oktober</li><li>NOV = November</li><li>DEC = December = Desember</li><li>bef = before = før</li><li>abt = about = om</li><li>aft = after = etter</li></ul>";
$pgv_lang["def_gramps_help"]		= "~GRAMPS XML-databasefil~<br /><br />Et sitat, på engelsk, fra GRAMPS Project:<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Norsk versjon:<div class=\"list_value_wrap\">GRAMPS hjelper deg med å spore slektstreet ditt. Den lar deg lagre, redigere og undersøke slektsdata. GRAMPS prøver å tilby alle de vanlige egenskapene til andre slektsforskningsprogblokker, men, enda viktigere, å gi en ekstra integrasjonsevne som ikke er felles for disse programmene. Dette er evnen til å legge inn informasjon og biter direkte i GRAMPS og omorganisere / manipulere alle / alle datahendelser i hele databasen (i hvilken som helst rekkefølge eller rekkefølge) for å hjelpe brukeren med å gjøre forskning, analyse og korrelasjon med potensialet. for å fylle hull i forholdet.</div><br />En kopi av GRAMPS XML-format v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">finner du her</a> i både RELAX NG Schema-format og DTD-format.<br /><br />For mer informasjon om GRAMPS-prosjektet besøk <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]				= "~PhpGedView~<br /><br />PhpGedView (eller PGV) legger ikke bare statiske sider på nettet; den er dynamisk og kan tilpasses på mange måter.<br /><br />PhpGedView ble opprettet av John Finlay for å vise GEDCOM-filer online. John begynte å utvikle programmet på egen hånd. Et internasjonalt team av utviklere og oversettere har siden sluttet seg til ham og jobber med å forbedre programmet. Blant de mer betydningsfulle funksjonene som er lagt til eller forbedret i programmet, er dets omfattende støtte for andre språk enn engelsk, og muligheten til å legge til og redigere hendelser online.";
$pgv_lang["def_theme_help"]				= "~Stil~<br /><br />Dette nettstedet kan ha forskjellige \"utseende\", kalt Stiler. Nettstedsadministratoren velger et standardtema som alle som kommer inn på dette nettstedet først vil se.<br /><br />Når administratoren har aktivert denne funksjonen, kan alle brukere velge sine egne stiler. PhpGedView husker det sist valgte stil for hver pålogget bruker, slik at brukeren automatisk ser det stil neste gang han logger på.<br /><br />Stiler kan brukes som en måte å skille mellom forskjellige databaser på det samme nettstedet. Hver database kan ha et annet standardstil.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]			= "~#pgv_lang[mygedview]#~<br /><br />Dette er din personlige #pgv_lang[mgv]#.<br /><br />Her finner du enkle lenker for å få tilgang til dine personlige data, for eksempel <b>Min konto</b>, <b>Min indi</b> (dette er #pgv_lang[indi_info]# siden) og <b>Min stamtavle</b>. Du kan ha blokker med <b>Meldinger</b>, en <b>Journal</b> (som et Notisblokk) og mange flere.<br /><br />Oppsettet til denne siden ligner velkomstsiden du ser når du først åpner dette nettstedet. Mens delene av velkomstsiden er valgt av nettstedsadministratoren, kan du velge hvilke deler som skal inkluderes på denne tilpassede siden. Du finner lenken for å tilpasse denne siden i velkomstblokken eller separat når velkomstblokken ikke er til stede.<br /><br />Du kan velge mellom følgende blokker og lenker:<ul><li><a href=\"#mygedview_welcome\"><b>#pgv_lang[welcome_block]#</b></a></li><li><a href=\"#mygedview_customize\"><b>Tilpass Â«#pgv_lang[mygedview]#Â»</b></a></li><li><a href=\"#mygedview_message\"><b>#pgv_lang[user_messages_block]#</b></a></li><li><a href=\"#mygedview_events\"><b>#pgv_lang[upcoming_events_block]#</b></a></li><li><a href=\"#mygedview_onthisday\"><b>#pgv_lang[todays_events_block]#</b></a></li><li><a href=\"#mygedview_charts\"><b>#pgv_lang[charts_block]#</b></a></li><li><a href=\"#mygedview_favorites\"><b>#pgv_lang[user_favorites_block]#</b></a></li><li><a href=\"#mygedview_stats\"><b>#pgv_lang[gedcom_stats_block]#</b></a></li><li><a href=\"#mygedview_myjournal\"><b>#pgv_lang[user_news_block]#</b></a></li><li><a href=\"#mygedview_media\"><b>#pgv_lang[random_media_block]#</b></a></li><li><a href=\"#mygedview_loggedin\"><b>#pgv_lang[logged_in_users_block]#</b></a></li><li><a href=\"#recent_changes\"><b>#pgv_lang[recent_changes_block]#</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]	= "~Tilpass #pgv_lang[mygedview]#~<br /><br />Da du kom inn her for første gang, hadde du allerede noen blokker på denne siden. Hvis du vil, kan du tilpasse denne portalsiden.<br /><br />Når du klikker på denne lenken, blir du ført til et skjema der du kan legge til, flytte eller slette blokker. Mer forklaring er tilgjengelig på det skjemaet.";
$pgv_lang["mygedview_message_help"]		= "~#pgv_lang[user_messages_block]#~<br /><br />I denne blokken vil du finne beskjedene, sendt til deg av andre brukere, eller fra Admin. Selvsagt kan du også sende dine egne beskjeder til andre brukere eller admin.<br /><br />Postsystemet i PhpGedView er laget med tanke for å ta vare på ditt eget personvern. Du behøver ikke oppgi epost-adressen din her og andre vil ikke kunne se epost-adressen din heller.<br /><br />For å gjøre tillegg i en beskjed kan du klikke på overskriften til beskjeden eller på \"<b>+</b>\" tegnet ved siden av den.  Du kan slette flere beskjeder ved å merke boksen ved siden av beskjedene som du ønsker å slette og deretter klikke på knappen \"Slett valgte beskjeder\".";
$pgv_lang["mygedview_favorites_help"]		= "~#pgv_lang[user_favorites_block]#~<br /><br />Favorittene ligner på bokmerker.<br /><br />Anta at du har noen i slektstreet som du vil sjekke regelmessig. Bare gå til personens #pgv_lang[indi_info]# side og velg alternativet <b>Legg til i Mine favoritter</b> fra favorittlisten. Denne personen er nå bokmerket og lagt til i favorittlisten din.<br /><br />Uansett hvor du er på dette nettstedet, kan du klikke på et navn i \"Mine favoritter\" listen i overskriften. Dette tar deg til #pgv_lang[indi_info]# siden til vedkommende.";
$pgv_lang["mygedview_myjournal_help"]	= "~#pgv_lang[user_news_block]#~<br /><br />Du kan bruke denne notatblokken til å skrive kommentarer eller huskelapper for eget bruk. Selvsagt vil notatet også være der neste gang du besøker siden.<br /><br />Disse notatene vil ikke være synlige for andre.";
$pgv_lang["mygedview_welcome_help"]			= "~#pgv_lang[welcome_block]#~<br /><br />Velkomstblokken viser deg:<ul><li>Gjeldende GEDCOM-fil</li><li>Dato og klokkeslett</li><li>Lenker til:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Merk:</b><br />Du vil bare se lenkene til <b>#pgv_lang[my_indi]#</b> og <b>#pgv_lang[my_pedigree]#</b> hvis du er kjent med den nåværende GEDCOM-filen, mens du er i en annen GEDCOM-fil ikke har post, og følgelig vises ikke disse koblingene.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~stamtavle~<br /><br />En stamtavle er en oppregning av alle forfedrene til startpersonen. Brukere som ikke er innlogget, ser stamtavlen til startpersonen som er valgt av nettstedsadministratoren. Påloggede brukere kan velge sin egen startperson.<br /><br />I denne sammenheng betyr \"Alle forfedre\" far og mor, foreldrene deres og så videre. Stamtavlen vises grafisk; du trenger ikke å slite gjennom sider med tekst for å bestemme dine forfedre.<br /><br />Alle personer vises i Navn-bokser på skjermen.<br /><ul><li><b>Navnebokser på stamtavlen</b><br />Hvis stamtavlesiden er satt til å vise detaljer, vil du se personens navn og fødsels- og dødsdatoer. Du kan klikke på personens navn for å ta deg direkte til #pgv_lang[indi_info]# siden til vedkommende.<br /><br />Når <b>Vis detaljer</b> er på, er det to ikoner inne i navneboks.</li><li><b>Stamtavleikon inne i Navn-boksen</b><br />Når alternativet <b>Vis detaljer</b> er på, ser du et stamtavleikon i Navn-boksen. Avhengig av nettstedsinnstillingene, må du holde markøren over ikonet eller klikke på det. Når du klikker på eller holder markøren over dette ikonet, vises en liten undermeny.<br /><br />Elementene b>#pgv_lang[index_header]#</b> og <b>#pgv_lang[descend_chart]#</b> ligner på elementene i hovedmenyen, men forskjellen er at startpersonen nå er personen som er nevnt i Navn-boksen. Du ser også <b>#pgv_lang[as_spouse]#</b>. Under ser du navnet på ektefellen etterfulgt av navnene på barna. Alle navn er klikkbare.</li><li><b>Forstørrelsesglass inne i Navn-boksen</b><br />Avhengig av nettstedsinnstillingene, må du holde markøren over ikonet eller klikke på det. Dette forstørrer Navn-boksen slik at flere detaljer vises. Du vil se flere datoer og arrangementer. Navnene er klikkbare.</li><li><b>Piler</b><br />Til venstre eller høyre i Navn-boksene til venstre eller Høyre kan du se piler. Når du klikker på disse pilene, vil skjermvisningen skifte i pilens retning.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]				= "~#pgv_lang[show_details]#~<br /><br />Med dette alternativet kan du enten vise eller skjule alle detaljer i Navn-boksene. Du kan vise flere ruter på en skjerm når detaljene er skjult.<br /><br />Når alle detaljer er skjult, vises ikke Zoom-ikonet nedenfor. Imidlertid, hvis administratoren har aktivert Zoom-funksjonen, vil hele boksen fungere som et Zoom-ikon for å avsløre alle detaljer om personen.<br /><br />Når detaljene ikke er skjult og Zoom-funksjonen, identifisert av et forstørrelsesikon, er aktivert av administratoren, kan du avsløre enda flere detaljer om vedkommende. Hvis du normalt må klikke på Zoom-ikonet for å zoome inn, kan du avsløre flere skjulte detaljer ved å klikke på ikonet her. På samme måte, hvis du kan zoome inn ved å sveve over Zoom-ikonet, vil skjulte detaljer bli avslørt ved å sveve over dette ikonet her.<br /><br />Hvis du har klikket på Zoom-ikonet for å avsløre flere detaljer, kan du gjenopprette boksen til det normale detaljnivået ved å klikke på Zoom-ikonet igjen. Hvis du har avslørt flere detaljer ved å bare flytte musepekeren over Zoom-ikonet, vil boksen bli gjenopprettet til sitt normale detaljnivå når du flytter musepekeren vekk fra Zoom-ikonet.";
$pgv_lang["talloffset_help"]			= "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />Med dette alternativet bestemmer du sidelayoutretningen.<br /><br />Endring av denne innstillingen kan være nyttig hvis du vil lage en skjermutskrift eller hvis du har en annen type skjerm.<ul><li><b>#pgv_lang[portrait]#</b>&nbsp;&nbsp;&nbsp;vil gjøre treet høyere, slik at et 4 generasjons diagram skal passe på en enkelt side som er trykt vertikalt.</li><li><b>#pgv_lang[landscape]#</b>&nbsp;&nbsp;&nbsp;vil lage et bredere tre som skal skrives ut på en enkelt side trykt horisontalt.</li><li><b>#pgv_lang[landscape_top]#</b>&nbsp;&nbsp;&nbsp;roterer diagrammet, men ikke boksene, med 90 grader mot klokken, slik at den eldste generasjonen er øverst i diagrammet.</li><li><b>#pgv_lang[landscape_down]#</b>&nbsp;&nbsp;&nbsp;roterer diagrammet, men ikke boksene, med 90 grader med klokken, slik at den eldste generasjonen er nederst i diagrammet.</li></ul>";
$pgv_lang["rootid_help"]				= "~#pgv_lang[rootid]#~<br /><br />Hvis du vil vise et diagram med en ny startperson (rot), blir ID-en til den nye startpersonen skrevet her.<br /><br />Hvis du ikke kjenner ID-en til personen, bruk <b>Finn ID</b>.<br /><br /><b>ID-NUMMER</b><br />ID-numrene som brukes i PhpGedView er <u>ikke</u> identifikasjonsnumrene som er utstedt av forskjellige myndigheter (for eksempel førerkort eller passnummer). ID-nummeret som er referert til her er ganske enkelt et nummer som brukes i databasen for å identifisere hver enkelt person; den ble tildelt av forfedreprogrammet som opprettet GEDCOM-filen som ble importert til PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[generations]#~<br /><br />Her kan du angi antall slektsledd som skal vises på denne siden.<br /><br />Hva som er best for deg avhenger av størrelsen på skjermen din og om du viser detaljer eller ikke. Tiden det tar å vise siden har også sammenheng med antall slektsledd som vises.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~#pgv_lang[login]#~<br /><br />På denne siden kan du logge deg inn, be om et nytt passord eller be om en ny brukerkonto.";
$pgv_lang["username_help"]				= "~#pgv_lang[username]#~<br /><br />I denne boksen skriver du inn brukernavnet ditt.<br /><br /><b>Brukernavnet er mellom store og små bokstaver.</b> Dette betyr at <b>MittNavn</b>er <u>ikke</u> det samme som <b>mittnavn</b> eller <b>MITTNAVN</b>.";
$pgv_lang["password_help"]				= "~#pgv_lang[password]#~<br /><br />I denne boksen skriver du inn passordet ditt.<br /><br /><b>Passordet er mellom store og små bokstaver.</b> Dette betyr at <b>MittPassord</b> er <u>ikke</u> det samme som <b>mittpassord</b> eller <b>MITTPASSORD</b>.";
$pgv_lang["login_buttons_help"]			= "~Logg inn knapper~<br /><br />Her ser du en knapp for å logge inn på systemet.<br /><br />Hvis du klikker på denne knappen, vil du gå tilbake til siden du nettopp var på, men med innloggede rettigheter.<br /><br />Hvis du for eksempel klikker på <b>#pgv_lang[login]#</b> da du var på stamtavlesiden, kommer du tilbake til den samme siden. Hvis du klikker på denne knappen mens du var på hovedvelkomstsiden, blir du ført til «#pgv_lang[mygedview]#» siden, hvor du kan redigere innstillingene, legge til eller redigere favoritter, sende og lese meldinger osv.";
$pgv_lang["login_buttons_aut_help"]		= "~LOGIN BUTTON~<br /><br />Her ser du en knapp for å logge inn på systemet.<br /><br />Hvis du klikker på denne knappen, blir du logget inn og går direkte til «#pgv_lang[mygedview]#» siden, hvor du kan redigere innstillinger, legge til eller redigere favoritter, sende og lese meldinger osv.";
$pgv_lang["new_password_help"]			= "~#pgv_lang[requestpassword]#~<br /><br />Hvis du har glemt passordet ditt, kan du klikke på denne lenken for å be om et nytt passord.<br /><br />Du blir ført til «#pgv_lang[lost_pw_reset]#» siden.";
$pgv_lang["new_user_help"]				= "~#pgv_lang[requestaccount]#~<br /><br />Hvis du er besøkende på dette nettstedet og ønsker å be om en brukerkonto, kan du klikke på denne lenken.<br /><br />Avhengig av hvordan administratoren har satt opp nettstedet, kan e-postklienten din lanseres slik at at du kan sende en e-post til administratoren for å be om en ny påloggings-ID, eller du kan bli ført til «#pgv_lang[requestaccount]#» siden.";
$pgv_lang["mygedview_login_help"]		= "For å få tilgang til «#pgv_lang[mygedview]#» siden, må du være en registrert bruker på systemet. På denne siden kan du bokmerke favorittpersonene dine, føre en brukerjournal, administrere meldinger, se andre påloggede brukere og tilpasse forskjellige aspekter av PhpGedView-sider.<br /><br />Skriv inn brukernavnet og passordet ditt i de aktuelle feltene for å logge inn på «#pgv_lang[mgv]#».";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette feltet må du oppgi fornavnet ditt.<br /><br />Vi trenger både fornavn og etternavn for å finne ut om du kan få en konto på dette nettstedet, og hvilke rettigheter du skal få.  Heløe navnet vil også bli vist til andre innloggede familiemedlemmer og brukere.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette feltet må du oppgi etternavnet ditt.<br /><br />Vi trenger både fornavn og etternavn for å finne ut om du kan få en konto på dette nettstedet, og hvilke rettigheter du skal få.  Heløe navnet vil også bli vist til andre innloggede familiemedlemmer og brukere.";
$pgv_lang["register_info_01"]			= "~#pgv_lang[requestaccount]#~<br /><br />Mengden data som kan vises offentlig på dette nettstedet kan være begrenset på grunn av gjeldende lovgivning om personvern. Mange ønsker ikke at deres personlige data skal være offentlig tilgjengelige på Internett. Personopplysninger kan bli misbrukt til spam eller identitetstyveri.<br /><br />Tilgang til dette nettstedet er tillatt for alle besøkende som har en brukerkonto. Etter at administratoren har bekreftet og godkjent kontosøknaden din, vil du kunne logge inn.<br /><br />Hvis forholdet Personvern er aktivert, vil du bare få tilgang til dine egne nære slektninger private informasjon etter innlogging. Administratoren kan også tillate databaseredigering for visse brukere, slik at de kan endre eller legge til informasjon.<br /><br />Hvis du trenger ytterligere støtte, vennligst bruk lenken nedenfor for å kontakte administratoren.";
$pgv_lang["register_info_02"]			= "~#pgv_lang[requestaccount]#~<br /><br />Mengden data som kan vises offentlig på dette nettstedet kan være begrenset på grunn av gjeldende lovgivning om personvern. Mange ønsker ikke at deres personlige data skal være offentlig tilgjengelige på Internett. Personopplysninger kan bli misbrukt til spam eller identitetstyveri.<br /><br /Tilgang til dette nettstedet er kun tillatt for <u> autoriserte </u> brukere. Etter at administratoren har bekreftet og godkjent kontosøknaden din, vil du kunne logge på og se de private dataene.<br /><br />Hvis forholdet Personvern er aktivert, vil du bare få tilgang til dine egne nære slektninger private informasjon etter innlogging. Administratoren kan også tillate databaseredigering for visse brukere, slik at de kan endre eller legge til informasjon.<br /><br />Hvis du trenger ytterligere støtte, vennligst bruk lenken nedenfor for å kontakte administratoren.";
$pgv_lang["register_info_03"]			= "~#pgv_lang[requestaccount]#~<br /><br />Mengden data som kan vises offentlig på dette nettstedet kan være begrenset på grunn av gjeldende lovgivning om personvern. Mange ønsker ikke at deres personlige data skal være offentlig tilgjengelige på Internett. Personopplysninger kan bli misbrukt til spam eller identitetstyveri.<br /><br />Tilgang til dette nettstedet er bare tillatt for <u>familiemedlemmer</u>. Etter at administratoren har bekreftet og godkjent kontosøknaden din, vil du kunne logge på og se de private dataene.<br /><br />Hvis forholdet Personvern er aktivert, vil du bare få tilgang til dine egne nære slektninger private informasjon etter innlogging. Administratoren kan også tillate databaseredigering for visse brukere, slik at de kan endre eller legge til informasjon.<br /><br />Hvis du trenger ytterligere støtte, vennligst bruk lenken nedenfor for å kontakte administratoren.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~#pgv_lang[descend_chart]#~<br /><br />Denne siden viser etterkommerne til en person.<br /><br />Du kan velge en startende (rot) person for dette etterkommerdiagrammet, eller du kan bli lenket til denne siden ved å klikke på <b>#pgv_lang[descend_chart]#</b> lenke på en annen side. Klikk på pilikonene for å navigere i dette treet i pilens retning. Klikk på kartikonet i en hvilken som helst personboks for å endre roten til treet til den personen.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br /><br />På dette diagrammet kan du vise en eller flere personer langs en horisontal tidslinje. Dette diagrammet lar deg se hvordan livet til forskjellige mennesker overlappet hverandre.<br /><br />Du kan legge til personer i diagrammet individuelt eller etter familiegrupper etter ID-en. Den forrige listen vil bli husket når du legger til flere personer i diagrammet. Du kan når som helst tømme diagrammet med knappen <b>Tøm diagram</b>.<br /><br />Du kan også legge til personer i diagrammet ved å søke etter dem etter datoperiode eller sted.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#<br /><br /><b>Inkluderer Umiddelbar Familie</b><br />Inkluder Umiddelbar Familie er merket av som standard. La sjekket for å se far, mor, ektefelle, søsken og barn til personen som blir lagt til tidslinjen. Fjern avmerkingen hvis du ønsker å utelate nærmeste familie.";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br /><br />På dette diagrammet kan du vise en eller flere personer langs en tidslinje. Du kan for eksempel visualisere statusen til to eller flere personer i et bestemt øyeblikk.<br />Hvis du klikker på koblingen <b>Tidslinje</b> på en annen side, vil du allerede se en person på tidslinjen. Hvis du klikket på menypunktet <b>Tidslinje</b> i en sideoverskrift, må du oppgi startpersonens ID.";
$pgv_lang["add_person_help"]			= "~#pgv_lang[add_another]#~<br /><br />Du kan ha flere personer på tidslinjen.<br /><br />Bruk denne boksen til å skrive inn IDen til personen i slektsbasen. Dersom du ikke kjenner IDen til personen, kan du klikke på linken <b>Finn ID</b> bak boksen.";
$pgv_lang["remove_person_help"]			= "~#pgv_lang[remove_person]#~<br /><br />Klikk på denne linken for å fjerne personen fra tidslinjen.";
$pgv_lang["show_age_marker_help"]		= "~#pgv_lang[show_age]#~<br /><br />Hvis du merker av i denne boksen, ser du en aldersmarkør.<br /><br />Du kan skyve denne aldersmarkøren opp eller ned langs tidslinjen. Den glidende aldersmarkøren er et fint verktøy for å kontrollere alderen til en person ved en bestemt begivenhet. Du kan aktivere eller deaktivere aldersmarkøren individuelt for hver person i diagrammet.";
$pgv_lang["timeline_control_help"] = "~#pgv_lang[timeline_controls]#~<br /><br />~HASTIGHET~<br />Klikk på rullegardinmenyen for å endre hastigheten som tidslinjen ruller på.<br /><br />~Begynn året~<br />Angi startåret for området.<br /><br />~Sluttåret~<br />Angi slutten av året.<br /><br />~Søk~<br />Klikk på Søk knappen for å begynne å søke etter hendelser som har skjedd innenfor området som er identifisert av feltene Begynnelsesår og Sluttår.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~#pgv_lang[relationship_chart]#~<br /><br />På denne siden kan du vise familietilhørigheten mellom to personer. Det er ikke sikkert at disse personene har et direkte slektskap. Enhver tilhørighet vil bli funnet.";
$pgv_lang["relationship_id_help"]		= "~#pgv_lang[id]# :: #pgv_lang[person1]# :: #pgv_lang[person2]#~<br /><br />Hvis du har hoppet fra en annen side til denne ved å klikke på koblingen <b>Forhold til meg</b>, vil du her se forholdet mellom deg selv og den andre personen.<br /><br />Hvis du ankom på denne siden gjennom menypunktet <b>Relasjonskart</b> på en hvilken som helst sidehode, må du skrive inn identifikasjonsnumrene til de to personene hvis forhold du ønsker å se. Hvis du ikke kjenner identifikatoren til ønsket person, kan du klikke koblingen <b>Finn ID</b>.";
$pgv_lang["next_path_help"]				= "~#pgv_lang[next_path]#~<br /><br />Du kan klikke på denne knappen for å se om det er flere slektslinjer mellom de to personene. De andre slektslinjene kan vises på nytt ved å klikke på nummeret til slektslinjen.";
$pgv_lang["follow_spouse_help"]			= "~#pgv_lang[follow_spouse]#~<br /><br />Når denne boksen <b>ikke</b> er merket, blir slektslinjer bare sjekket mellom de som er i direkte slekt. Dersom boksen er avmerket, vil også slektslinjer mellom gifte bli sjekket.  Du vil sannsynligvis finne flest slektslinjer dersom dette valget er merket.";
$pgv_lang["line_up_generations_help"]	= "~#pgv_lang[line_up_generations]#~<br /><br />Når denne avkrysningsruten er merket av, vil diagrammet skrives ut med de samme generasjonene som står horisontalt på siden. Når det ikke er merket av, vil hver generasjon vises nedover på siden uavhengig av type forhold.";
$pgv_lang["oldest_top_help"]          	= "~#pgv_lang[oldest_top]#~<br /><br />Når denne avkrysningsboksen er merket av, vil diagrammet skrives ut med de eldste personene øverst. Når det ikke er merket av, vil de yngste vises øverst.<br /><br />Merk: Dette alternativet fungerer bare hvis <b>#pgv_lang[line_up_generations]#</b> også er merket av.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]# - siden~<br /><br />Forfedersiden er veldig lik <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men med flere detaljer og alternativ <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> vises.<br /><br />Hvert forfedre er vist med et unikt nummer, beregnet i henhold til <i>Sosa-Stradonitz</i> systemet:<div style=\"padding-left: 30px;\"><b>Jevne</b> tall for menn (barn * 2)<br /><b>Odde</b> tall for kvinner (mann + 1) bortsett fra <b>1</b></div><br />Eksempel:<br /><div style=\"padding-left: 30px;\">Rotpersonen er <b>1</b>, uavhengig av kjønn.<br /><b>1</b> far er <b>2</b> (<b>1</b> * 2), mor er <b>3</b> (<b>2</b> + 1).<br /><b>2</b> far er <b>4</b> (<b>2</b> * 2), mor er <b>5</b> (<b>4</b> + 1).<br /><b>3</b> far er <b>6</b> (<b>3</b> * 2), mor er <b>7</b> (<b>6</b> + 1).<br /><b>7</b> far er <b>14</b> (<b>7</b> * 2), mor er <b>15</b> (<b>14</b> +1).<br />etc.</div>";
$pgv_lang["box_width_help"]				= "~#pgv_lang[ancestry_chart]# - Boksbredde~</b><br /><br />Her kan du endre bredden til boksen fra 50% til 300%. Standard verdi er 100%, bredden på hver boks er da omtrent 270 punkter.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />To diagramstiler er tilgjengelige:<ul><li><b>#pgv_lang[chart_list]#</b>&nbsp;&nbsp;&nbsp;Vertikalt tre, med sammenleggbare / utvidbare familier.</li><li><b>#pgv_lang[chart_booklet]#</b>&nbsp;&nbsp;&nbsp;Én familie per side, med foreldre, besteforeldre og alle registrerte barn.<br /><br />Dette formatet er enkelt å skrive ut for å gi til dine slektninger.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]# - Siden~<br /><br />Sirkeldiagrammet er veldig likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men på en mer grafisk måte.<br /><br />The Rotperson vises i sentrum, foreldrene hans på den første ringen, besteforeldrene på den andre ringen, og så videre.<br /><br />Fødsels- og dødsår skrives ut under navnet når det er kjent.<br /><br />Ved å klikke på et navn i diagrammet åpnes en lenke-meny som er spesifikk for vedkommende. Fra denne menyen kan du velge å sentrere diagrammet på vedkommende eller på en av personens nære slektninger, eller du kan hoppe til vedkommendes #pgv_lang[indi_info]# side eller et annet diagram for vedkommende.";
$pgv_lang["fan_width_help"]				= "~#pgv_lang[fan_width]#~</b><br /><br />Her kan du endre bredden på hjulet fra 50% til 300%. Standard verdi er 100%, bredden på bildet er da omtrent 640 punkter.";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]# stil~<br /><br />Dette alternativet styrer utseendet på diagrammet.<ul><li><b>1/2</b>&nbsp;&nbsp;&nbsp;Halvsirkel 180&deg; diagram</li><li><b>3/4</b>&nbsp;&nbsp;&nbsp;Tre fjerdedel 270&deg; diagram, noen ganger kalt <i>englevinge</i></li><li><b>4/4</b>&nbsp;&nbsp;&nbsp;Full sirkel 360&deg; diagram</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Timeglassdiagrammet viser forfedrene og etterkommerne til den valgte rotpersonen på det samme diagrammet. Dette diagrammet er en blanding mellom avstamningskartet og stamtavle.<br /><br />Rotpersonen er sentrert midt på siden med etterkommerne oppført til venstre og forfedrene oppført til høyre. I denne visningen er hver generasjon oppstilt på tvers av siden fra den første generasjonen til den siste.<br /><br />Hvis det er en pil nedover på skjermen under rotpersonen, vil du klikke på den for å vise en liste over rotpersonens nære familiemedlemmer som du kan bruke navigere nedover i diagrammet. Hvis du velger et navn fra denne listen, lastes diagrammet inn på nytt med den valgte personen som den nye rotpersonen.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Dette diagrammet er veldig likt timeglassformat diagrammet. Den viser forfedrene og etterkommerne til den valgte rotpersonen på samme diagram. Det vil også vise etterkommerne til rotpersonen i samme timeglassformat.<br /><br />Rotpersonen er sentrert midt på siden med sine etterkommere oppført til venstre og forfedrene oppført til høyre. I denne visningen er hver generasjon stilt opp på tvers av siden fra den første generasjonen til den siste.<br /><br />Hver etterkommer av rotpersonen blir rotpersonen til et ekstra timeglassdiagram, trykt på samme side. Denne prosessen gjentas til det spesifiserte antall etterkommere generasjoner er skrevet ut.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Denne verdien bestemmer antall etterkommende generasjoner av rotpersonen som skal skrives ut i timeglassformat.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~Personliste siden~<br /><br />På denne siden kan du vise en liste over enkeltpersoner. Navnene vises først med etternavn og sorteres i alfabetisk rekkefølge.<br /><br />Utdataene fra navnelisten avhenger av:<ul><li>Brevet du klikket på i den alfabetiske indeksen.</li><li>Enten du klikket på \"Hopp over\" eller \"Vis\" Etternavneliste.</li></ul>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]					= "~Alfabetisk indeks~<br /><br />Ved å klikke på en bokstav i den alfabetiske indeksen vises en liste med navnene som begynner med bokstaven du klikket på.<br /><br />Det nest siste elementet i den alfabetiske indeksen kan være <b>#pgv_lang[NN]#</b>. Denne oppføringen vil være til stede når det er personer i databasen hvis etternavn ikke er registrert eller ikke inneholder noen gjenkjennelige bokstaver. Ukjente etternavn blir ofte registrert som <b>#pgv_lang[qm]#</b>, og disse blir gjenkjent som <b>#pgv_lang[NN]#</b>. Dette vil også skje hvis personen er ukjent.<br /><br /><b>Merk:</b><br />Etternavn angitt som for eksempel <b>Nn</b>, <b>NN</b>, <b>Ukjent</b> eller til og med <b>N.N.</b> vil <u>ikke</u> bli funnet i <b>#pgv_lang[NN]#</b> listen. I stedet finner du disse personene ved å klikke <b>N</b> eller <b>U</b> fordi dette er de første bokstavene i disse navnene.PhpGedView kan umulig redegjøre for alle mulige måter å skrive inn ukjente etternavn på; det er ingen anerkjent konvensjon for dette.<br /><br />På slutten av den alfabetiske indeksen ser du <b>ALLE</b>. Når du klikker på dette elementet, vil du se en liste over alle etternavn i databasen.<br /><br /><b>Manglende bokstaver?</b><br />Hvis den alfabetiske indeksen din ser ut til å være ufullstendig, med manglende bokstaver, inneholder databasen din ikke etternavn som begynner med den manglende bokstaven.";
$pgv_lang["name_list_help"]				= "~Navneliste~<br /><br />Denne tabellen vil enten vise en liste med etternavn eller en utvidet navneliste. I begge tilfeller vil alle etternavnene start med den samme bokstaven som du klikket på i den alfabetiske indeksen. Selvsagt gjelder ikke det dersom du klikket på <b>ALLE</b><br /><br />Om du vil se en etternavn eller en fullstendig navneliste, avhenger av statusen til lenken <b>Hopp over / vis etternavnlister</b>.";
$pgv_lang["skip_sublist_help"]			= "~HOPP UNDERLISTE~<br /><br />Standardinnstillingen er at etter at du har klikket på en bokstav i den alfabetiske indeksen, vil du få en underliste med etternavn. Hvis du klikker på denne lenken, vises alle personer med etternavn som har den valgte første bokstaven umiddelbart. Deretter vil listen over enkeltpersoner vises direkte hver gang du klikker på en ny første bokstav i den alfabetiske listen.<br /><br />For å reversere denne handlingen, klikk på linken #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~#pgv_lang[show_marnms]#~<br /><br />Sidene til person- og familielisten kan enten inkludere eller ekskludere gifte navn. Dette alternativet kan være nyttig når du søker etter personer eller familier der du bare vet det gifte navnet. Gifte navn kan bare inkluderes hvis de allerede finnes i databasen.<br /><br />På familielisten er denne verdien som standard å ekskludere. På personlisten er standardverdien satt på GEDCOM-konfigurasjonssiden.<br /><br />Når du endrer dette alternativet, vil valget bli husket til du logger av eller økten din avsluttes.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~Familieliste siden~<br /><br />På denne siden kan du vise en liste over familier. Navnene vises først med etternavn og sorteres i alfabetisk rekkefølge.<br /><br />Utdataene fra navnelisten avhenger av:<ul><li>Brevet du klikket på i den alfabetiske indeksen.</li><li>Enten du klikket på \"Hopp over\" eller \"Vis\" Etternavneliste.</li></ul>Du kan søke på mannens eller konens etternavn; begge er inkludert i listen.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~Familie-opplysninger siden~<br /><br />Denne siden viser deg en oversikt over familien du valgte på en forrige side.<br /><br />Fra topp til bunn vil du se Personopplysninger-boksene til mannen og foreldrene hans, kona og hennes foreldre, og barna.<br /><br />Oppsettet og innholdet til personboksene er det samme som boksene du allerede kjenner fra stamtavle og etterkommere.<br /><br />Til høyre for foreldreboksene kan du se en pil hvis det finnes flere forfedre i filen. Når du klikker på pilen, vil du gå opp en generasjon for å vise deg en ny familieside med de tidligere foreldrene som nå er oppført som mann og kone.<br /><br />På høyre side i navnefeltet kan du se et Zoom (forstørrelsesglass) ikon som du kan klikke for å avsløre mer detaljer om personen. Når du klikker på navnet, blir du ført til #pgv_lang[indi_info]# siden til vedkommende.<br /><br />Også på høyre side finner du en liten meny som tar deg til sider med diagrammer eller mer informasjon. Noen av disse menyelementene har også undermenyer som vises når musepekeren nærmer seg overordnet menyelement.<br /><br />Informasjonsboksen for familiegruppen viser alle kjente fakta og informasjon om denne familien, som ekteskap, multimediaobjekter og notater. I faktainformasjonsboksen, når du klikker på et sted, kommer du til Sted-listen, der alle andre familier og enkeltpersoner som er tilknyttet stedet vises. Ved å klikke på en dato hopper du til dagskalenderen, som viser alle hendelsene som skjedde den dagen og måneden i historien. Multimedia-objekter kan klikkes; dette åpner et nytt vindu der objektet vises. Når du klikker på bildeteksten, vil du se bildet på #pgv_lang[media_list]# siden. Hvis du klikker på en kildekobling, vil detaljene for kilden vises på kildesiden.<br /><br />Under navneboksene til barna finner du <b>Legg til et barn i denne familien</b> lenke. Ved siden av navneboksene til barna ser du lenken <b>Familiegruppeinformasjon</b>. Hvis du har nok rettigheter, kan du redigere, slette og legge til data og fakta her.<br /><br />Som med #pgv_lang[indi_info]# siden, vil du se en meny øverst til høyre på siden. Oppføringer i denne menyen tar deg til andre sider der du kan få informasjon om denne familien eller utføre andre oppgaver knyttet til denne familien.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]				= "~Legge til et barn til denne familien~<br /><br />Ved å klikke på denne linken, kan du legge til et barn til denne familien ved å fyll ut feltene i det vinduet som kommer fram.";
$pgv_lang["show_fam_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Informasjonen om familien, slik den er lagret i databasen, vises når du klikker på denne lenken. Skjermen viser rå GEDCOM-data.";
$pgv_lang["add_fam_clip_help"]			= "~LEGG TIL FAMILIEN I KLIPPVOGNEN~<br /><br />Du kan legge til all eller noe av denne familiens informasjon i #pgv_lang[clip_cart]#. På neste side kan du velge nøyaktig hvor mye informasjon du vil legge til:<ul><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ul>";
$pgv_lang["show_fam_timeline_help"]		= "~Vis partnere på en tidsline~<br /><br />Når du klikker på denne lenken, hopper du til tidslinjesiden, der alle fakta om paret vises på en tidslinjeskala.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~Listen med kilder~<br /><br />En liste over kilder vises på denne siden.<br /><br />I motsetning til #pgv_lang[indi_info]# og familiesider, er det ingen alfabetisk indeks.<br /><br />En kilde kan være en person, en offentlig database, en institusjon, en internettressurs osv. På grunn av slektsforskningens helt tilfeldige natur er det umulig å finne en sorteringsrekkefølge som er meningsfull i alle tilfeller. PhpGedView sorterer imidlertid kildenavnene i alfabetisk rekkefølge.<br /><br /><b>KILDER</b><br />Uten kilder kan vi ikke bygge databasen vår. Det er en kilde for hvert element i databasen. Kilden kan være en pårørende, en institusjon, en offentlig database, offentlige eller private poster, en internettressurs osv.<br /><br />En kilde kan lenkes til mange personer. En person kan også knyttes til mange kilder. Du kan ha forskjellige kilder for hver begivenhet, enten det er fødselsdato, yrke, ekteskap, barn, etc.";
$pgv_lang["sourcelist_listbox_help"]	= "~Listen med kilder~<br /><br />I denne boksen ser du navnene på kildene slik de er lagret i GEDCOM.<br /><br />Navnene vises i alfabetisk rekkefølge. Når du klikker på et navn i listen, går du til kildesiden der en liste vises. Denne listen viser hvilke personer eller familier som er knyttet til den kilden.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~Detaljer om kilden~<br /><br />Detaljer om kilden vises på denne siden. Kilder er veldig viktige for slektsforskere, og lar deg følge stien en annen forsker brukte for å finne informasjonen.<br /><br />Du kan se informasjon om kildens tittel, forfatter, publikasjon og depotet hvor kilden ble sett opp. På grunn av de mange forskjellige kildetyper, kan noen kilder ha mer informasjon enn andre.<br /><br />Hvis et multimediaobjekt, for eksempel en skanning av et dokument, er koblet til kilden, kan du se objektet ved å klikke på objektet. Når du klikker på objektnavnet, vil du se objektet på siden #pgv_lang[media_list]#.<br /><br />Etter kildedetaljene er det en liste over alle personer og familier som er knyttet til denne kilden. Dette lar deg identifisere alle elementene som ble hentet fra den datakilden.<br /><br />Når administratoren har aktivert disse funksjonene, vil du ha ett eller to ekstra menyikoner på denne siden:<ul><li><b>#pgv_lang[view_gedcom]#</b><br />som viser informasjonen i GEDCOM-format.</li><li><b>#pgv_lang[add_to_cart]#</b><br />som lar deg lagre denne informasjonen i #pgv_lang[clip_cart]# for senere nedlasting og import til ditt eget slektsforskningsprogram.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~Navn knyttet til denne kilden~<br /><br />I denne listen ser du navn på personer og familier som er knyttet til kilden. Navnene vises i alfabetisk rekkefølge.<br /><br />Dersom du klikker på et navn i tabellen, vil du gå til siden med fakta om den enkelt person eller familie.";
$pgv_lang["show_source_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Ved å klikke på denne linken, vil informasjon om kilden, slik den er lagret i slektsfilen, bli vist i et eget vindu.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Ved å klikke på denne linken kan du kopiere kilden, slik den er lagret i slektsfilen, til #pgv_lang[clip_cart]# din.";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br /><br />Når du klikker på dette alternativet, vil du merke denne kilden som skal slettes fra databasen.<br /><br />Hva betyr det? La oss anta at du har en god grunn til å fjerne denne kilden fra databasen. Du klikker på lenken. Du blir bedt om å bekrefte slettingsforespørselen. Når du fortsetter med besøket, vil du legge merke til at kilden fremdeles er synlig og kan brukes som om slettingen ikke hadde skjedd.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]					= "<b>Dette er <u>ikke</u> en feil.</b> Administratoren vil få en beskjed om at det er gjort en endring i slektsbasen, og at du slettet noe. Administratoren må godkjenne eller avslå endringen din. Først etter at administratoren har godtatt endringen, blir slettingen faktisk permanent. Hvis det er tvil om endringen din, vil administratoren kontakte deg.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~stedhierarki~ (eller Personer per sted)<br /><br />Denne siden viser deg et hierarki over stedene i GEDCOM og hvilke personer eller familier som er tilknyttet et sted.<br /><br />Hvis det er noen forbindelse mellom en person eller familie og en begivenhet på et bestemt sted, PhpGedView finner den.<br /><br />Resultatene vises i en to-kolonneliste, en kolonne for personer og en for familier.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~format av steder~<br /><br /><b>STANDARD</b><br />Dette betyr at det ikke er angitt noe stedskodingsformat i denne GEDCOM-filen, og standardformatet antas.<br /><br />Hvis et annet format hadde blitt funnet, ville det blitt vist mellom <b>(</b> og <b>)</b> på slutten av linjen.";
$pgv_lang["ppp_match_one_help"]			= "~format av steder~<br /><br /><b>GEDCOM</b><br />Stedene antas å være kodet i stedformatet som eksplisitt er deklarert i GEDCOM-filen. Dette overstyrer standardordren.";
$pgv_lang["ppp_numfound_help"]			= "~Koblinger til stedsnavn funnet~<br /><br />Antall treff som blir funnet vises her. Hvis du fremdeles ser en listeboks med steder du ennå ikke har nådd det laveste nivået.<br /><br />Du kan velge å se alle postene som er koblet til dette stedet, eller du kan avgrense søket ved å klikke på et annet sted.";
$pgv_lang["ppp_levels_help"]			= "~nivå for stedsnavn~<br /><br />Dette viser nivåene som vises nå. Listeboksen som viser steder er faktisk en underliste til nivået til venstre.<br /><br />EKSEMPEL:<br /><ul><li>Standardrekkefølgen er #pgv_lang[default_form]#.</li><li>Hvis det nåværende nivået er \"Toppnivå\", vil boksen vise alle landene i databasen.</li><li>Hvis det nåværende nivået er \"USA, toppnivå\", vil ruten vise alle statene i USA</li><li>etc.</li></ul><br />Du kan klikke på et nivå for å gå ett eller flere trinn tilbake.";
$pgv_lang["ppp_placelist_help"]			= "~stedhierarki~<br /><br />I denne listen kan du se stedene som er underordnet den gjeldende plasseringen du har valgt. Hvis du ennå ikke har valgt et sted, vil du se en liste over alle stedene på øverste nivå (f.eks. Land eller stater).<br /><br />Navnene på stedene i listen er klikkbare; ved å klikke på et sted fungerer som et filter, blir du tatt til neste nivå nedover.";
$pgv_lang["ppp_placelist_help2"]		= "~stedhierarki~<br /><br />I denne listen kan du se stedene som er funnet til dette stadiet.<br /><br />Navnene på stedene i listen er klikkbare; ved å klikke på et sted fungerer som et filter, blir du tatt til neste nivå nedover.<br /><br />Først når du er i øverste nivå, vises ikke en navneliste. På alle underordnede nivåer vil du få en liste over familier og personer som er knyttet til dette stedet.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Ved å klikke på denne lenken vises en liste over alle personer og familier som har hendelser som skjer på dette stedet. Når du kommer til slutten av et stedhierarki, som vanligvis er en by eller by, vises navnelisten automatisk.";
$pgv_lang["ppp_name_list_help"]			= "~Listen med navn~<br /><br />Denne ruten viser en komplett liste over enkeltpersoner og familier som er knyttet til stedet.<br /><br />Navnene i listen er klikkbare. Når du klikker på et navn, blir du ført til den aktuelle detaljsiden. Når du klikker på et sted øverst på denne listen, endrer du posisjonsvalget ditt.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~multimediaobjekter listen~<br /><br />Denne siden viser alle multimediaobjekter (MMO) som finnes i denne databasen.<br /><br />For hvert av medieelementene ser du tittelen eller filnavnet på varen, navnene på personene eller familiene som er tilknyttet. til varen, og notater om varen.<br /><br />Å klikke på tittelen eller filnavnet på varen har samme effekt som å klikke på miniatyrbildet. Elementet vil bli åpnet i bildeviseren innebygd i PhpGedView eller i visningen spesifisert i nettleserens konfigurasjon.<br /><br />Når du klikker på \"Vis\" lenken ved siden av personen eller familien, vil du føres til den relevante siden.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~laste opp mediefiler~<br /><br />Å laste opp mediefiler er ganske greit. Her er litt tilleggsinformasjon.<br /><br /><b>Miniatyrbilder</b><br />Miniatyrbilder bør ha en størrelse rundt 100 px bredde. Miniatyrbildet <u>må</u> ha samme navn som fullversjonen. Hvis systemet ditt kan generere miniatyrbilder automatisk, vil du se et varsel om dette på siden Last opp media.<br /><br /><b>Laster opp</b><br />Filer blir lastet opp automatisk til mappen b>#GLOBALS[MEDIA_DIRECTORY]#</b> for fullversjonen og til <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> for miniatyrbildene.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Generell informasjon</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Hendelse</b></a></li><li><a href=\"#calendar_button\"><b>Knappene Vis Dag / Vis måned / Vis år</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>#pgv_lang[anniversary_calendar]# viser personene og familiene som er knyttet til en begivenhet på en bestemt dag eller måned eller i løpet av en viss tidsperiode. Den har et avansert filtreringssystem for å velge riktig dato, periode og hendelser for deg.<dl><dt><b>Se <a href=\"#calendar_day\">dagen</a></b></dt><dd>Dette viser hendelsene på en bestemt dag, uavhengig av det valgte året. Output vil være enten en enkelt liste med navn på personer eller familier, eller en to-kolonneliste med personer på den ene siden og familier på den andre.</dd><dt><b>Vis <a href=\"#calendar_month\">måned</a></b></dt><dd>I denne kalenderen vises navnene på personer og familier i dagsboksen. Kalenderen vises som det var året du skrev inn i År-boksen. Alle hendelser som har skjedd tidligere fram til det året vises.<br /><br />I kombinasjon med alternativet <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, vil det gi en realistisk oversikt over hvordan en kalender for dine forfedre så ut.</dd><dt><b>Vis <a href=\"#calendar_year\">år</a></b></dt><dd>Dette viser hendelsene i et bestemt år eller i løpet av flere år. Utdata vil være en liste med navn på personer eller familier, eller en to-kolonneliste med personer på den ene siden og familier på den andre.</dd></dl>Den viste dagen og måneden er uthevet i kalendermenyen.<br /><br />Alle navn og datoer er klikkbare. Når du klikker på et navn, blir du ført til den relevante informasjonssiden. Ved å klikke på en dato hopper du til \"I dag\" eller \"År\" modus, som viser alle hendelser for dagen og måneden i den klikkede datoen.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~dag velger~<br /><br />Den øverste raden i selektor-tabellen er <b>dag</b> velgeren. Betydningen av den er åpenbar: Du velger en <u>dag</u>.<br /><br />Resultatet av å klikke på en bestemt dag avhenger av om du er i <b>Dag</b> eller i <b>Måned</b> modus.<br /><dl><dt><b>Dag modus</b></dt><dd>I denne modusen klikker du på en dag, skjermen oppdateres og listen for den dagen vises.</dd><dt><b>Måned modus</b></dt><dd>Du har kalenderen for en bestemt måned på skjermen. Du klikker på en dag og skjermen oppdateres, men du vil fremdeles se måneden du hadde på skjermen før. Årsaken til dette er at du fortsatt kan bestemme deg for å velge en annen måned, år eller begivenhet før du enten klikker på <b>#pgv_lang[viewday]#</b> eller <b>#pgv_lang[viewmonth]#</b> knappen.</dd></dl><br />På slutten av Dag-raden vil du se en <b>hurtigkobling</b> med dagens dato. Ved å klikke på <b>Hurtigkobling</b> vises listen for i dag i modus <b>Dag</b>, uansett om du er i <b>Måned</b> eller i <b>Dag</b> modus.";
$pgv_lang["annivers_month_select_help"]	= "~måned velger~<br /><br />Den midterste raden i Selector-tabellen er <b>Måned</b> velgeren. Betydningen av den er åpenbar: Du velger en <u>måned</u>.<br />Resultatet av å klikke på en bestemt måned avhenger av om du er i <b>Dag</b> eller i <b>Måned</b> modus.<br /><dl><dt><b>Dag modus</b></dt><dd>I denne modusen klikker du på en måned, skjermen oppdateres og listen for den måneden vises. Alle andre valg som dag, år og arrangementer vil være uendret.</dd><dt><b>Måned modus</b></dt><dd>Når du har kalenderen på skjermen og klikker en måned i raden <b>Måned</b>, vises kalenderen for den nye måneden.</dd></dl><br />På slutten av raden Måned ser du en <b>Hurtigkobling</b> med dagens måned og år. Ved å klikke på <b>Hurtigkobling</b> vises listen for den måneden i modus <b>Måned</b>, uansett om du er i <b>Måned</b> eller i <b>Dag</b> modus.";
$pgv_lang["annivers_year_select_help"]	= "~år inndataboks~<br /><br />Denne inntastingsboksen lar deg endre det året i kalenderen. Skriv inn et år i boksen og trykk <b>Enter</b> for å endre kalenderen til det året.<br /><br /><b>Avanserte funksjoner</b> til <b>#pgv_lang[viewyear]#</b><dl><dt><b>Mer enn ett år</b></dt><dd>Du kan søke etter datoer i en årrekke.<br /><br />Årsområder er <u>inkludert</u>. Dette betyr at datoperioden strekker seg fra 1. januar det første året i området til 31. desember det siste året som er nevnt. Her er noen eksempler på årserier:<br /><br /><b>1992-5</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 1992 til 1995.<br /><b>1972-89</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 1972 til 1989.<br /><b>1610-759</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 1610 til 1759.<br /><b>1880-1905</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 1880 til 1905.<br /><b>880-1105</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 880 til 1105.<br /><br />For å se alle hendelsene i et gitt tiår eller århundre, kan du bruke <b>#pgv_lang[qm]#</b> i stedet for de siste sifrene. For eksempel,<b>197?</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 1970 til 1979 eller <b>16??</b>&nbsp;&nbsp;&nbsp;for alle hendelsene fra 1600 til 1699.<br /><br />Hvis du velger et årrekke, endres kalenderen til årsvisningen.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~Vis hendelser for...~<br /><br />Følgende alternativer er tilgjengelige:<br /><ul><li><b>Alle mennesker</b><br />Med dette alternativet vises alle personer og familier.</li><li><b>Senere år (&lt; 100 år)</b><br />Med dette alternativet vil du se alle hendelsene for den valgte dagen eller måneden, men ingen hendelser eldre enn 100 år vil bli vist.</li><li><b>Levende mennesker</b><br />Med mindre administratoren har konfigurert PhpGedView slik at levende mennesker er synlige for noen, vil dette alternativet bare være tilgjengelig for deg etter at du har logget inn.<br /><br />Med dette alternativet vises bare hendelser fra levende personer.</li></ul>Når du klikker på et alternativ, vises hendelsene du velger.<br /><br />Innstillingene for dag, måned og år, samt <b>dag</b> eller <b>måned</b> modus, forbli som de var.";
$pgv_lang["annivers_sex_help"]			= "~Velge kjønn~<br /><br />Når du er pålogget eller når administratoren ikke har aktivert alternativet Personvern, kan du velge ett av disse alternativene:<ul><li>Ikonet <b>Alle</b><br />Dette er standardalternativet. Hendelsene til alle personer og familier vises.</li><li>Ikonet <b>Mann</b><br />Bare hendelser av mannlige personer vises. Bare mannlige familiemedlemmer vises med familiebegivenheter.</li><li>Ikonet <b>Kvinne</b><br />Bare hendelser for kvinnelige personer vises. Bare kvinnelige familiemedlemmer vises med familiebegivenheter.</li></ul>Når du klikker på et alternativ, vises hendelsene du velger.<br /><br />Innstillingene for dag, måned og år, samt <b>dag</b> eller <b>måned</b> modus, forbli som de var.";
$pgv_lang["annivers_event_help"]		= "~Velge hendelse~<br /><br />Her kan du velge om du vil se alle hendelser for personer og familier eller bare den hendelsen du velger.<br /><br />Når du klikker på et av valgene, vil skjermbildet bli oppdatert og i forhold til det valg du har gjort.<br /><br />Innstillingene for dag, måned og år, samt <b>dag</b> eller <b>måned</b> modus, forbli som de var.";
$pgv_lang["annivers_tip_help"]			= "~Tips~<br /><br />Juster datovelgeren til hvilken som helst dato tidligere.<br /><br />Når du klikker på en av visningsknappene, vil du se en liste eller kalender for den datoen. Alle aldre, jubileer osv. Er beregnet på nytt og teller nå fra datoen du valgte i Datovelgeren. Du ser nå kalenderen eller listen som din forfader ville ha sett på den datoen for mange år siden.";
$pgv_lang["day_month_help"]				= "~Knappene - Vis dag / Vis måned / Vis år~<br /><br /><ul><li>Knappen <b>Vis dag</b> viser hendelsene til den valgte datoen i en liste. Alle år blir skannet, så bare dag og måned kan angis her. Å endre året vil ikke ha noen effekt. Du kan redusere listen ved å velge alternativet <b>Nyere år</b> eller <b>Levende mennesker</b>.<br /><br />Alder i listen blir beregnet fra inneværende år.</li><li>Knappen <b>Vis måned</b> viser et kalenderdiagram over valgt måned og år. Også her kan du redusere listene ved å velge alternativet <b>Nyere år</b> eller <b>Levende mennesker</b>.<br /><br />Du får et realistisk inntrykk av hva en kalender på veggen til dine forfedre så ut ved å velge et år tidligere i kombinasjon med <b>Nyere år</b>. Alle aldre i kalenderen vises i forhold til året i boksen År.</li><li>Knappen <b>Vis år</b> viser en liste over hendelser for det valgte året. Også her kan du redusere listen ved å velge alternativet <b>Nyere år</b> eller <b>Levende mennesker</b>.<br /><br />Du kan vise hendelser i en årrekke. Bare skriv inn begynnelses- og sluttårene for området, med en bindestrek <b>-</b> mellom dem. Eksempler:<br /><b>1992-4</b> for alle hendelser fra 1992 til 1994<br /><b>1976-1984</b> for alle hendelser fra 1976 til 1984<br /><br />For å se alle hendelsene i et gitt tiår eller århundre, kan du bruke <b>#pgv_lang[qm]#</b> i stedet for de siste sifrene. For eksempel, <b>197?</b> for alle hendelser fra 1970 til 1979 eller <b>16??</b> for alle hendelser fra 1600 til 1699.</li></ul>Når du vil <b>endre året</b>, <b>må</b> du trykke på en av disse tre knappene. Alle andre innstillinger forblir som de var.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~#pgv_lang[clippings_cart]#~<br /><br />#pgv_lang[clip_cart]# lar deg ta utdrag (\"utklipp\") fra dette slektstreet og pakke dem sammen i en enkelt fil for nedlasting og påfølgende import til ditt eget slektsforskningsprogram. Den nedlastbare filen er spilt inn i GEDCOM-format.<br /><ul><li>Hvordan ta utklipp?<br />Dette er veldig enkelt. Når du ser et klikkbart navn (person, familie eller kilde), kan du gå til informasjonssiden for det navnet. Der vil du se alternativet <b>#pgv_lang[add_to_cart]#</b>. Når du klikker på den lenken, vil du bli tilbudt flere alternativer for nedlasting.</li><li>Hvordan laste ned?<br />Når du har varer i handlekurven, kan du laste dem ned ved å klikke på koblingen <b> Last ned nå </b>. Følg instruksjonene og lenkene.</li></ul>";
$pgv_lang["clip_download_help"]			= "~#pgv_lang[download_now]#~<br /><br />Når du klikker på denne lenken, blir du ført til neste side. Hvis noen av utklippene i handlekurven din refererer til multimediaelementer, vil disse elementene også vises på den siden.<br />Bare følg instruksjonene.";
$pgv_lang["empty_cart_help"]			= "~#pgv_lang[empty_cart]#~<br /><br />Når du klikker på denne lenken, blir #pgv_lang[clip_cart]# tømt helt.<br /><br />Hvis du ikke vil fjerne alle personer, familier osv. fra #pgv_lang[clip_cart]#, vil du kan fjerne elementer individuelt ved å klikke <b>Fjern</b> lenken i Navn-boksene. Det er <u>ingen</u> bekreftelsesdialog når du klikker på en av disse koblingene. den forespurte slettingen skjer umiddelbart.";
$pgv_lang["add_by_id_help"]				= "~utklippsmappen LEGG TIL ID~<br /><br />Denne inntastingsboksen lar deg legge inn en persons ID-nummer slik at han kan legges til i utklippsvognen. Når du er lagt til, vil du bli tilbudt muligheter for å koble personens forhold til utklippsvognen din.<br /><br />Hvis du ikke vet ID-nummeret, kan du utføre et søk etter navn ved å trykke på personikonet ved siden av Legg til-knapp.";
$pgv_lang["zip_help"]					= "~ZIP KLIPP~<br /><br />Velg dette alternativet for å lagre utklippene i en ZIP-fil. For mer informasjon om ZIP-filer, besøk <a href=\"https://no.wikipedia.org/wiki/ZIP\" target=\"_blank\">https://no.wikipedia.org/wiki/ZIP</a>.";
$pgv_lang["include_media_help"]			= "~INKLUDER MEDIA~<br /><br />Velg dette alternativet for å inkludere mediefilene som er tilknyttet postene i utklippsvognen din. Hvis du velger dette alternativet, zipes filene automatisk under nedlastingen.";
$pgv_lang["clip_cart_help"]				= "~#pgv_lang[clippings_cart]#~<br /><br />Denne boksen viser innholdet i utklippsmappen din.<ul><li><i>Typer</i> kolonnen angir typen for hver oppføring, som kan være Person (INDI), Familie (FAM), Kilde (SOUR), Oppbevaringssted (REPO), Notat (NOTE) og Media (OBJE); hver er representert med sitt eget ikon.</li><li><i>ID</i> kolonnen viser ID-nummeret for hvert element av den aktuelle typen.</li><li>Kolonnen <i>Navn / Beskrivelse</i> gir enten navnet på familien eller individet, eller en beskrivelse av varen.</li></ul>Fjern-knappen fjerner posten fra Utklippsmappen.  <b>Bekreftelse på å fjerne er IKKE bedt om.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			="~#pgv_lang[review_changes]#~<br /><br />Når du ser denne beskjeden, kan det bety to ting:<ol><li>Noen har gjort endringer i slektsbasen<br />Oppføringer kan ha blitt lagt til, slettet eller endret.</li><li>Endringene er ikke blitt godkjent av administratoren enda.<br />Når endringene er blitt godkjent (eller avslått), vil du ikke se denne beskjeden lengre.</li></ol>Ved å klikke på linken, kan du se hvilke endringer som er gjort. Dersom du mener at en endring ikke er korrekt, vennligst gi beskjed til administratoren til nettstedet.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~Søke siden~<br /><br />Selv om denne siden ser veldig enkel ut, er det en veldig kraftig og komplisert søkemotor bak de to skjemaene. De fleste genealogiske nettsteder lar deg bare søke etter et navn. Med PhpGedView kan du søke etter nesten hva som helst.<br /><br />Søk-boksen til venstre på skjermen er den samme som søkeboksen i hver sideoverskrift.<br /><br />Hvis du leter etter folk i forbindelse med et bestemt år, skriver du bare inn året. Programmet finner alle tilkoblinger for deg.<br /><br />Leter du etter et navn eller sted? Bare skriv inn navnet eller stedet, helt eller bare en del av det, og PhpGedView gjør resten.<br /><br /><b>Soundex søkemetode</b><br />Med søkefeltene til høyre kan du søke etter navn på personer og steder, selv om du ikke vet nøyaktig hvordan du skal skrive navnet.<br /><br />Når det er flere slektsdatabaser på nettstedet ditt og administratoren har aktivert å bytte mellom dem, vil søket ditt returnere resultatene for dem alle.<br /><br />Du finner mer hjelp om disse to boksene ved å klikke på <b>#pgv_lang[qm]#</b> over boksene.";
$pgv_lang["search_enter_terms_help"]	= "~#pgv_lang[enter_terms]#~<br /><br />I denne søkeboksen kan du angi kriterier som datoer, fornavn, etternavn, steder, multimedia osv.<br /><br /><b>Jokertegn</b><br />Jokertegn, som du sikkert kjenner dem (som * eller ?), er ikke tillatt, men programmet vil automatisk anta jokertegn.<br /><br />Anta at du skriver inn søkefeltet følgende: <b>Pete</b>. Resultatet kan bli, forutsatt at navnene er i databasen:<div style=\"padding-left: 30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Jones<br />Will <b>Pete</b>rson<br />noen - Født 1. januar 1901 i <b>Pete</b>rsburg<br />etc.</div><br /><b>Datoer</b><br />Hvis du skriver inn et år i søkefeltet, vil det føre til en liste over personer som på en eller annen måte er koblet til det året.<br /><br />Hvis du skriver <b>1950</b>, blir resultatet alle personer med en hendelse som skjedde i 1950. Disse hendelsene kan være fødsler, dødsfall, ekteskap, Bar Mitzvahs, SDH-forseglinger osv.<br /><br />Hvis du skriver <b>4&nbsp;Dec</b>, er alle personer knyttet til en hendelse som skjedde 4. desember uansett år vil bli oppført. Personer som er tilknyttet et arrangement 14. eller 24. desember vil også bli oppført. Som du ser, antas det alltid jokertegn, så du trenger ikke å skrive dem. Noen ganger kan resultatene være overraskende.<br /><br /><b>Riktige datoer</b><br />PhpGedView søker etter data, ettersom de er lagret i GEDCOM-filen. Hvis du for eksempel vil søke etter en hendelse 14. desember, bør du skrive <b>14&nbsp;dec</b> fordi det er slik datoen lagres i databasen.<br /><br />Hvis du skulle skrive <b>dec&nbsp;14</b>, resultatet kunne være en person som var koblet til en hendelse den 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>. Igjen kan resultatene være overraskende.<br /><br />Du kan bruke vanlige uttrykk i søket ditt hvis du er kjent med dem. Hvis du for eksempel ønsket å finne alle menneskene som har datoer i det 20. århundre, kan du gå inn i søket <b>19[0-9][0-9]</b>, og du vil få alt personer med datoer fra 1900-1999.<br /><br />#pgv_lang[soundex_search_help]#<br /><br />#pgv_lang[search_replace_help]#<br /><br />Hvis du trenger mer hjelp med dette søkesystemet, kan du gi oss beskjed, slik at vi også kan forbedre denne hjelpefilen.";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Her kan du søke etter feilstaving eller annen unøyaktig informasjon og erstatte den med riktig informasjon.<br /><br /><b>Søker</b><br />Denne funksjonen utfører søking akkurat som et <a href=\"help_text.php?help=search_enter_terms_help\">vanlig søk</a>.<br /><br /><b>Erstatte</b><br />Alle forekomster av søkeordet som blir funnet erstattes av erstatningstermet i databasen.<br /><br /><b>For eksempel...</b><br />Anta at du ved et uhell stave feil med bestefaren din, Michael. Du skrev ved et uhell 'Micheal'.<br /><br />Du skriver <b>Micheal</b> i søkefeltet og <b>Michael</b> i Erstatt-boksen.<br />Hver forekomst av \"Micheal\" vil da bli erstattet av \"Michael\".<br /><br /><b>Søk etter...</b><br />Velg omfanget av søket. Du kan begrense søket til navn eller steder, eller ikke bruke noen grense (søk i alt). Alternativet <i>#pgv_lang[search_place_word]#</i> vil bare søke etter begrepet ditt i stedfeltet som et helt ord. Dette betyr at søk etter <i>UT</i> bare vil matche <b>UT</b> og ikke <i>UT</i> med de andre ordene som Connectic<b>ut</b>.<br /><br />Ikke bekymre deg hvis du ved et uhell erstatter noe der du ikke vil. Bare klikk \"Godta / avvis endringer\" nederst på siden for å godta endringene du ønsker, og avvis endringene du ikke vil ha.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex er en metode for koding av ord i henhold til uttalen. Dette lar deg søke i databasen etter navn og steder når du ikke vet nøyaktig hvordan de er skrevet. PhpGedView støtter to forskjellige Soundex-algoritmer som gir vidt forskjellige resultater.<ul><li><b>#pgv_lang[search_russell]#</b><br />Denne metoden, patentert i 1918 av Russell, er veldig enkel og kan gjøres for hånd.<br /><br />Den enkle algoritmen passer ikke godt til navn som opprinnelig var på andre språk enn engelsk, og til og med med engelske navn. resultatene er veldig overraskende. For eksempel vil et enkelt Soundex-søk etter <b>Smith</b> ikke bare returnere <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, som alle er tydelige varianter av <b>Smith</b>, men også <b>Smead, Sneed, Smoote, Sammett, Shand,</b> og <b>Snoddy</b>.</li><br /><li><b>#pgv_lang[search_DM]#</b><br />Denne metoden, utviklet i 1985, er mye mer kompleks enn Simple-metoden og gjøres ikke lett for hånd.<br /><br />Et Soundex-søk med denne metoden gir mye mer nøyaktige resultater.</li></ul>For detaljer om begge Soundex-algoritmene, besøk dette <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> nettside.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />Valget <b>#pgv_lang[search_tagfon]#</b> vil føre til at søkefunksjonen ignorerer følgende GEDCOM koder:<div style=\"padding-left: 30px;\"><b>_PGVU</b> - Siste endring gjort av<br /><b>CHAN</b> - Siste endringsdato<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />I tillegg til disse valgfritt ekskluderte kodene, utelukker søkefunksjonen alltid disse kodene:<div style=\"padding-left: 30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Dette alternativet får PhpGedView til å vise alle personer som er registrert som en tilknytning til denne personen eller familien. Det omvendte er ikke mulig.<br /><br />Eksempel: Anta at person <b>A</b> er gudfar til person <b>B</b>. Dette forholdet er registrert i GEDCOM-posten til person <b>B</b> ved hjelp av en ASSO-tag. Det finnes ingen tilsvarende tag i GEDCOM-posten til person <b>A</b>.<br /><br />Når dette alternativet er satt til <b>#pgv_lang[yes]#</b> og søkeresultatlisten inkluderer <b>B</b>, vil <b>A</b> inkluderes automatisk på grunn av ASSO-taggen i GEDCOM-posten på <b>B</b>. Imidlertid, hvis søkeresultatlisten inneholder <b>A</b>, vil ikke <b>B</b> bli inkludert automatisk siden det ikke er noen samsvarende ASSO-tag i GEDCOM-posten til person <b>A</b>.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Denne funksjonen lar deg søke i de spesifiserte feltene med personposter i din genealogiske database.<br /><br />Når du klikker på <b>#pgv_lang[search]#</b> knappen, er alle feltene som verdier ble angitt for vil bli undersøkt og poster i din genealogiske database som oppfyller <u>alle</u> kriteriene vil bli returnert. Mens den første dialogen tilbyr noen av de mer vanlige feltene, kan du nederst i dialogboksen klikke <b>#pgv_lang[more_fields]#</b> for å utvide listen over felt som skal undersøkes.<br /><br />~Felt som inneholder datoer~<br />Avanserte søk er basert på år, så i motsetning til «#pgv_lang[search_general]#» prosedyren som kan akseptere en dato uten årstall, krever alle disse feltene minst året, men kan også godta spesifikasjoner for hel dag, måned og år. Det er for eksempel ikke mulig å søke etter noe som har skjedd i april noe år.<br /><br />Hver søkedatofeltboks har også en modifikator, slik at du kan søke etter <b>#pgv_lang[exact]#</b> datoen som angitt, eller en relativ dato med <b>+/-</b> en antall år. Hvis du skriver inn et år i datofeltet, velger du en modifikator og klikker <b>#pgv_lang[search]#</b> knappen, vil det resultere i en liste over personer som er knyttet til det året eller det året.<br /><br />Hvis du for eksempel skriver «APR 1950» i fødselsdatofeltet som har <b>#pgv_lang[exact]#</b> modifikatoren, vil resultatet være alle personer med en hendelse som bare skjedde i april 1950. Hvert datofelt vil søke etter datoene som er spesifikke for den hendelsen. Å legge til en <b>+/- 10</b> modifikator vil returnere datoer mellom 1. april 1940 og 31. mars 1960. De andre modifikatorene vil på samme måte endre søkeårsområdene. Ved å angi bare et år, for eksempel «1950», vil søket returnere alle hendelser innenfor det angitte året.<br /><br /><b>Datoformat for søk</b><br />Verken jokertegn eller regulære uttrykk kan brukes i søkedatofeltene dine. Rekkefølgen på dag, måned, år og store bokstaver er irrelevante. «dd MMM åååå» har samme betydning som «åååå MMM dd». Men hvis du ønsker å søke etter en begivenhet 14. desember 1926, bør du skrive den inn som «14 DEC 1926» fordi dette er hvordan datoen er lagret i databasen. For å søke etter en dato på tvers av flere hendelser (dvs. fødsler, dødsfall, ekteskap, bar Mitzvahs, LDS-forseglinger osv.) eller hvis bare dagen eller måneden er kjent, er det bedre å bruke «#pgv_lang[search_general]#» funksjonen.<br /><br />~Felt som inneholder navn~<br />Feltene <b>#pgv_lang[given_name]#</b> og <b>#pgv_lang[surname]#</b> kan brukes til å spesifisere de forskjellige delene av et navn som skal søkes i. Dette filtrerer enkelt navn som kan være både fornavn eller etternavn, for eksempel «Terry» eller «Henry».<br /><br />Navnefeltene har også en modifikator som hjelper med å kvalifisere hva som legges inn kontra det som søkes etter. Modifikatorene inkluderer:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;spesifiserer et søk som skiller mellom store og små bokstaver i hele feltet etter den nøyaktige teksten som er skrevet inn. Søket er også sensitivt for alle innebygde tegn, mellomrom osv. Hvis for eksempel feltet inneholder ett mellomrom, men posten i databasen har to i samme posisjon, vil ikke posten bli funnet.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;spesifiserer et søk som ikke skiller mellom store og små bokstaver for poster der et hvilket som helst navn begynner med det som står i feltet. Hvis et navnefelt inneholder flere navn (som for- og mellomnavn) vil samsvaret gjøres med begynnelsen av hver del av navnet som er atskilt med et mellomrom.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;spesifiserer et søk som ikke skiller mellom store og små bokstaver for poster der de fullstendige dataene i feltet vil bli søkt etter hvor som helst innenfor målpostens navnetekst. Hvis du for eksempel setter et enkelt mellomrom i <b>#pgv_lang[given_name]#</b> søkefeltet med <b>#pgv_lang[contains]#</b> modifikatoren, vil du finne alle poster som må ha et fornavn og minst ett mellomnavn eller initial.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;spesifiserer et søk uten store og små bokstaver etter poster som ligner på det som er i feltet. Dette lar deg søke i databasen etter navn og steder når du ikke vet nøyaktig hvordan de er skrevet.</li></ul><br />~Felt uten modifikatorer~<br />Oppføringer i felt uten modifikatorer er søk som ikke skiller mellom store og små bokstaver. Den angitte teksten vil bli søkt etter hvor som helst innenfor målpostens hendelsestekst.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# siden~<br /><br />Alle detaljer om en person vises på denne siden.<br /><br />Hvis det er et bilde tilgjengelig, vil du se det øverst til venstre. Du vil se navnene på personen ved siden av bildet.<br /><br />Navn kan ha notater og kilder knyttet til seg. Hvis noen av navnene har notater eller kilder, vil du se dem oppført under navnene de forholder seg til.<br /><br />En person kan ha en AKA (kanskje han er kjent under et annet navn). Hvis det er tilfelle, vil det vises.<br /><br />Hvis du har redigeringsrettigheter til denne personen, vil du også se koblingene <b>Rediger</b> og <b>Slett</b> ved siden av elementene du kan redigere.<br /><br />På denne siden ser du faneark for <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, og <b>#pgv_lang[relatives]#</b>.Disse fanearkene viser deg all informasjon om denne personen som er lagret i databasen.<ul><li><b>#pgv_lang[personal_facts]#</b>&nbsp;&nbsp;&nbsp;vil vise deg fakta og detaljer om denne personen og alle fakta fra ekteskapene deres. Hvis du klikker på en hvilken som helst dato i denne kategorien, kommer du til #pgv_lang[anniversary_calendar]# for den datoen, slik at du kan se andre hendelser som skjedde samme dag. Ved å klikke på et sted vil du ta deg til stedshierarkiet der du kan se andre personer som hadde arrangementer på samme sted. For ekteskap og andre familierelaterte fakta, er navnet på personens ektefelle tilgjengelig, slik at du kan se ektefellen, og det er også gitt en lenke til familieoppføringen.</li><li><b>#pgv_lang[notes]#</b>&nbsp;&nbsp;&nbsp;vil vise deg generelle merknader knyttet til denne personen.</li><li><b>#pgv_lang[ssourcess]#</b>&nbsp;&nbsp;&nbsp;vil vise deg alle <u>generelle</u> kildene for denne personen. Disse kildene er <u>ikke</u> knyttet til individuelle fakta, ikke engang personens navn; de er assosiert med personen selv. Når du klikker på tittelen på en kilde, kommer du til en mer detaljert kildeinformasjonsside som viser andre personer som også er koblet til samme kilde.</li><li><b>#pgv_lang[media]#</b>&nbsp;&nbsp;&nbsp;vil liste opp alle bildene og andre medieelementer som er knyttet til denne personen. Ved å klikke på et miniatyrbilde av bildet åpnes en større visning av bildet. Ved å klikke på bildeteksten vises bildet på #pgv_lang[media_list]# siden.</li><li><b>#pgv_lang[relatives]#</b>&nbsp;&nbsp;&nbsp;lister opp denne persons foreldre og søsken, samt alle ektefellene og barna denne personen har hatt. Disse personene vil bli oppført i bokser som ligner på diagrammene du kanskje allerede har sett.</li></ul>På høyre side av skjermen finner du en rute med lenker. Mange av lenkene i ruten er de samme som lenkene i menyene. Hvis du for eksempel klikker på koblingen <b>#pgv_lang[pedigree_chart]#</b> på sidekoblingene, kommer du til Stamtavle for denne personen. Dette er forskjellig fra menykoblingene, fordi ved å klikke på lenken <b>#pgv_lang[pedigree_chart]#</b> i menyen, kommer du tilbake til standard Stamtavle for denne databasen.<br /><br />En av lenkene som kan vises i denne listen hvis den er aktivert av administratoren, er koblingen <b>#pgv_lang[view_gedcom]#</b>. Denne lenken viser deg den rå GEDCOM-posten til denne personen.<br /><br />Hvis #pgv_lang[clip_cart]# er aktivert av administratoren av nettstedet, vil du også ha en lenke som lar deg legge til dette person til #pgv_lang[clip_cart]#.<br /><br />Koblingen <b>#pgv_lang[relationship_to_me]#</b> vises bare hvis du er logget inn og har fått tildelt en ID i GEDCOM. Denne lenken tar deg til stamtavlen og viser deg hvordan du er relatert til denne personen.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br /><br />Når du klikker på dette alternativet, vil du merke denne personen som skal slettes fra databasen.<br /><br />Hva betyr det? La oss anta at du har en god grunn til å fjerne denne personen fra databasen. Du klikker på lenken. Du blir bedt om å bekrefte slettingsforespørselen. Når du fortsetter med besøket ditt, vil du legge merke til at personen fremdeles er synlig og kan brukes som om slettingen ikke hadde skjedd.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]			= "~Endre eller slette navn fra slektsbasen~<br /><br /><b>ENDRE NAVN</b><br />Når du klikker på denne lenken, åpnes et nytt vindu. Der kan du redigere navnet på personen. Bare skriv inn endringene i boksene, og klikk på knappen og lukk vinduet.<br /><br /><b>SLETTE NAVN</b><br />Ved å klikke på dette alternativet vil du merke dette navnet som skal slettes fra databasen. Merk at å slette navnet er helt annerledes enn å slette personen. Slette navnet fjerner bare navnet fra personen. Personen vil <u>ikke</u> bli slettet. Hvis det er en alias du vil slette, har personen fortsatt sine andre navn. Hvis det er det <u>eneste</u> navnet du vil fjerne, blir personen fortsatt ikke slettet, men blir nå registrert som <b>#pgv_lang[NN]#</b>. Personen vil heller ikke kobles fra andre til slektninger, kilder, notater, etc.<br /><br />Hvordan virker det? Du blir bedt om å bekrefte slettingsforespørselen. Når du fortsetter med besøket, vil du legge merke til at navnet fremdeles er synlig og kan brukes som om slettingen ikke hadde skjedd.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~Legge til nytt navn~<br /><br />Dette valget gir deg mulighet til å legge til et nytt navn til denne personen.  Noen ganger hender det at personer er bedre kjent med andre navn eller alias.  Dette valget gjør at du kan gi en person et nytt navn uten å endre det egentlige navnet.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Du kan legge til et barn i denne familien når du klikker på denne lenken. \"Denne familien\", i dette tilfellet, er far og mor til hovedpersonen på dette skjermbildet.<br /><br />Husk at du skal legge til et søsken til den personen. Det er enkelt å legge til en bror eller søster: Bare klikk på lenken, og fyll ut boksene.<br /><br />Hvis du må legge til en sønn eller datter til hovedpersonen, blar du litt ned og klikker lenken i \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Du kan legge til et barn i denne familien når du klikker på denne lenken. \"Denne familien\", i dette tilfellet, er hovedpersonen på denne skjermen og hans eller hennes ektefelle.<br /><br />Husk at du skal legge til en sønn eller datter til den personen. Det er enkelt å legge til en sønn eller datter: Bare klikk på lenken og fyll ut boksene.<br /><br />Hvis du må legge til en bror eller søster til hovedpersonen, blar du opp en lite og klikk på lenken i \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Du kan knytte denne personen som barn til en eksisterende familie når du klikker på denne lenken.<br /><br />Anta at foreldrene til personen på en gang var ukjente, og du oppdaget senere at foreldrene hadde en oversikt over denne databasen.<br /><br />Bare klikk på lenken, skriv inn ID-en til familien, så har du konkurrert med oppgaven. Hvis du ikke kjenner familiens ID, kan du søke etter den.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Dette elementet lar deg koble den nåværende personen som ektemann til en familie som allerede er i databasen. Ved å klikke på denne lenken kan du legge denne personen til en eksisterende familie, som mannen ikke var ukjent før. Denne personen vil ta plassen til den tidligere ukjente ektemannen. Alle arrangementer, ekteskapsinformasjon og barn vil beholde sine eksisterende lenker til familien.<br /><br />Bare klikk på lenken, skriv inn ID-en til familien, så har du konkurrert med oppgaven. Dette er et avansert redigeringsalternativ som bare skal brukes hvis familien du vil koble til allerede eksisterer. Hvis du vil legge til en <u> ny </u> familie til denne personen, bruker du lenken <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Ved å klikke på denne lenken kan du legge til en <u> ny </u> mannlig person og knytte denne personen til hovedpersonen som ny ektemann.<br /><br />Bare klikk på lenken, så får du en popup-vindu for å legge til den nye personen. Fyll ut så mange bokser du kan, og klikk på knappen <b>Lagre</b>.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Dette vil tillate deg å knytte en annen person, som allerede eksisterer, som ny ektemann til denne personen. Dette vil skape en ny familie med mannen du velger. Du vil også ha muligheten til å spesifisere et ekteskap for denne nye familien.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Ved å klikke på denne lenken kan du legge til et <u>nytt</u> barn til denne personen og opprette en familie med en forelder.<br /><br />Bare klikk på lenken, så får du opp et popup-vindu for å legge til den nye personen. Fyll ut så mange bokser du kan, og klikk på <b>Lagre</b> knappen.";
$pgv_lang["link_wife_help"]				= "~#pgv_lang[link_as_wife]#~<br /><br />Dette valget gjør at det mulig å knytte denne personen som en partner til en familie som allerede finnes i slektsbasen.  Dette er et avansert valg som bare bør brukes dersom familien du ønsker å lage en kobling til finnes fra før.  Derrsom du bare ønsker å legge til en ny familie, må du bruke valget <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]				= "~#pgv_lang[add_new_wife]#~<br /><br />Ved å klikke på denne linken, kan du legge til en <u>ny</u> kvinne og knytte denne personen til hovedpersonen som en ny partner.<br /><br />Bare klikk på linken, så vil du få opp et vindu for å legge til den nye personen. Fyll ut så mange bokser du kan, og klikk på knappen <b>Lagre</b>.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Dette vil tillate deg å knytte en annen person, som allerede eksisterer, som en ny kone til denne personen. Dette vil skape en ny familie med kona du velger. Du vil også ha muligheten til å spesifisere et ekteskap for denne nye familien.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~Legge til en ny far eller mor~<br /><br />Det er absolutt mange personer i GEDCOM uten registrering av far eller mor.<br /><br />I så fall på <b>#pgv_lang[indi_info]#</b> siden, fanearket <b>#pgv_lang[relatives]#</b>, tabell <b>#pgv_lang[as_child]#</b>, finner du lenker for å legge til en <u>ny</u> far eller mor til den enkelte.<br /><br />Vær oppmerksom på at disse lenkene er for å legge til en <u> ny </u> far eller mor. Hvis faren eller moren allerede har en post i denne databasen, må du bruke lenken <b>#pgv_lang[link_as_child]#</b>, som du finner på den <b>#pgv_lang[indi_info]#</b> side under siste tabell.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br /><br />Når dette alternativet er merket av, kan du se alle kilde- eller notatoppføringene for denne personen. Når dette alternativet ikke er merket av, vises ikke kilde- eller notatposter som er knyttet til andre fakta for denne personen.";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br /><br />Når dette alternativet er merket av, vil fanen «#pgv_lang[relatives]#» vise datoforskjeller som følger:<ul><li><b>fødselsdatoer for partnere.</b><br />En negativ verdi indikerer at den andre partneren er eldre enn den første.</li><li><b>ekteskapsdato og fødselsdato for det første barnet.</b><br />En negativ verdi her indikerer at barnet ble født før ekteskapsdatoen eller at enten fødselsdatoen eller ekteskapsdatoen er feil.</li><li><b>fødselsdatoer for søsken.</b><br />En negativ verdi her indikerer at enten rekkefølgen til barna er feil, eller at en av fødselsdatoene er feil.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~Legge til nye fakta~<br /><br />Her kan du legge til fakta for en eller flere personer.<br /><br />Velg første en faktaopplysning fra listen og klikk så på knappen <b>Legg til</b>. I listen finner du alle tilgjengelige faktaopplysninger for slektsbasen.";
$pgv_lang["add_custom_facts_help"]		= "~Legge til egne fakta~<br /><br />Dersom du ikke finner den faktaopplysninger som du ønsker å legge til i faktalisten, kan du skrive inn en <b>Egen fakta</b>.<br /><br />Forskjellen fra å legge til fra en forhåndsdefinert faktaopplysning, er at du må gi den nye faktaopplysningen et navn. Du gjør det i det øverste feltet: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~Legge til ny note~<br /><br />Hvis du har et notat å legge til i denne posten, er dette stedet å gjøre det.<br /><br />Bare klikk på lenken, et vindu åpnes og du kan skrive notatet. Når du er ferdig med å skrive, klikker du bare på knappen under boksen og lukker vinduet.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />Når du klikker på lenken <b>#pgv_lang[add_shared_note]#</b>, åpnes et nytt vindu. Du kan velge å koble til et eksisterende delt notat, eller du kan opprette et nytt delt notat og samtidig opprette en lenke til det.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~Legge til ny kildehenvisning~<br /><br />Her kan du legge til en kilde <b>Sitat</b> i denne posten.<br /><br />Bare klikk på lenken, et vindu åpnes og du kan velge kilden fra listen (Finn ID) eller lag en ny kilde og legg deretter til sitatet.<br /><br />Å legge til kilder er en viktig del av slektsforskning fordi det gjør det mulig for andre forskere å verifisere hvor du har fått informasjonen din.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br /><br />Å legge til multimediafiler (MM) til GEDCOM er en veldig fin funksjon. Selv om dette programmet allerede har et flott utseende uten media, vil det bare bli bedre hvis du legger til bilder eller andre MM til dine slektninger.<br /><br /><b>Hva du bør forstå om MM.</b><br />Det er mange formater av MM. Selv om PhpGedView kan håndtere de fleste av dem, er det noen ting du bør vurdere.<br /><ul><li><b>Formater</b><br />Bilder kan redigeres og lagres i mange formater. For eksempel .jpg, .png, .bmp, .gif, etc. Hvis det samme originale bildet ble brukt til å lage hvert av formatene, vil det viste bildet ha samme størrelse uansett hvilket format som brukes. Imidlertid vil bildefilene som er lagret i databasen variere betydelig i størrelse. Generelt anses .jpg-bilder å være de mest effektive når det gjelder lagringsplass.</li><li><b>Bildestørrelse</b><br />Jo større originalbildet er, desto større blir den resulterende filstørrelsen. Bildet skal passe på skjermen uten å bla; maksimal bredde eller høyde skal ikke være mer enn bredden eller høyden på skjermen. PhpGedView er designet for skjermer på 1024x768 piksler, men ikke all denne plassen er tilgjengelig for visning av bilder; bildets størrelse bør settes i samsvar med dette. For å redusere filstørrelser er mindre bilder mer ønskelige.</li><li><b>Oppløsning</b><br />Oppløsningen til et bilde måles vanligvis i \"dpi\" (prikker / tomme), men dette gjelder bare for trykte bilder. Når du vurderer bilder som vises på skjermen, er den eneste riktige måten å bruke totale prikker eller piksler. Når det skrives ut, kan bildet ha en oppløsning på 150 - 300 dpi eller mer, avhengig av skriveren. Skjermoppløsninger er sjelden bedre enn 50 piksler per tomme. Hvis bildet ditt aldri blir skrevet ut, kan du trygt redusere oppløsningen (og følgelig filstørrelsen) uten å påvirke bildekvaliteten. Hvis et bilde med lav oppløsning skrives ut med for stor forstørrelse, vil kvaliteten undergis; det vil ha et kornete utseende.</li><li><b>Fargedybde</b><br />En annen måte å holde en fil liten på er å redusere antall farger du bruker. Antall farger kan variere fra rent svart og hvitt (to farger) til ekte farger (millioner av farger) og alt i mellom. Du kan se at jo flere farger som brukes, jo større blir filene.</li></ul><br /><b>Hvorfor er det viktig å holde filstørrelsen liten?</b><ul><li>Først og fremst: Nettområdet ditt er begrenset. Jo flere store filer det er, jo mer nettplass trenger vi på serveren. Jo mer plass vi trenger, jo høyere blir kostnadene dine.</li><li>Båndbredde. Jo mer data serveren vår må sende til det eksterne stedet (din plassering), jo mer må vi betale. Dette er fordi bæreevnen til serverens tilkobling til Internett er begrenset, og koblingen må deles (og betales for) av alle programmene som kjører på serveren. PhpGedView er et av mange programmer som deler serveren. Kostnaden fordeles normalt i henhold til datamengden hvert program sender og mottar.</li><li>Last ned tid. Hvis du har store filer, må brukeren (også du) vente lenge på siden for nedlasting fra serveren. Ikke alle er velsignet med kabelforbindelse, bredbånd eller DSL.</li></ul><br /><b>Hvordan laste opp MM</b><br />Det er to måter å laste opp media til nettstedet. Hvis du har mange medieelementer å laste opp, bør du kontakte administratoren for å diskutere de beste måtene. Hvis den har blitt aktivert av nettstedsadministratoren, kan du bruke skjemaet Last opp media under #pgv_lang[mgv]# menyen. Du kan også bruke alternativet Last opp i Multimedia-skjemaet for å laste opp medieelementer.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Dette alternativet vil generere miniatyrbilder for alle filer i den aktuelle katalogen som ikke allerede har et miniatyrbilde. Dette er mye mer praktisk enn å klikke på linken <b>#pgv_lang[gen_thumb]#</b> for hver slik fil.<br /><br />Hvis du ønsker å beholde kontrollen over hvilke filer som skal ha tilsvarende miniatyrbilder, bør du ikke bruke dette alternativet. I stedet klikker du på de aktuelle <b>#pgv_lang[gen_thumb]#</b> koblingene.";
$pgv_lang["add_facts_general_help"]      = "~Generell info om å legge til~<br /><br />Når du har lagt til et faktum, en merknad, en kilde eller en multimediefil til en post i databasen, må tillegget fortsatt godkjennes av en bruker som har Aksepter rettigheter.<br /><br />Inntil endringene er akseptert , blir de identifisert som \"ventende\" av en annerledes farget kant. Alle brukere med redigeringsrettigheter kan se disse endringene samt den originale informasjonen. Brukere som ikke har redigeringsrettigheter, vil bare se originalinformasjonen. Når tillegget er akseptert, vil grensene forsvinne og de nye dataene vises normalt, og erstatter de gamle. På den tiden vil brukere uten redigeringsrettigheter også se de nye dataene.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Her kan du endre innstillinger og preferanser.<br /><br />Du kan endre brukernavn, fullt navn, passord, språk, e-postadresse, tema for nettstedet og foretrukket kontaktmetode.<br /><br />Du kan ikke endre GEDCOM INDI-post-ID; det må gjøres av en administrator.";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />I dette feltet kan du endre brukernavnet ditt.<br />Dersom du ikke liker brukernavnet ditt lengre, eller har en annen grunn til å endre det, kan du gjøre det ved hjelp av dette feltet.<br /><br />Brukernavnet er <b>følsomt for bokstavtyper</b>. Det betyr at \"Jon\" ikke er det samme som \"jon\" eller \"JON\".<br /><br />Du bør bare bruke tegn fra alfabetene som PhpGedView støtter. Du kan bruke store og små bokstaver med eller uten diakritiske tegn, tall, bindestrek (-) og understrek (_). Bruk <u>ikke</u> skilletegn eller mellomrom.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I denne boksen kan du endre fornavnet ditt. Dette er navnet andre brukere ser når du er logget inn.<br /><br />Selv om valget av hva du skal legge inn i dette feltet er ditt, bør du informere administratoren når du endrer det. Når andre ser en ukjent person på nettet, kan de lure på og stille spørsmål. Administratoren kan finne ut av det uten å ha mottatt varselet ditt, men du bør redde ham det unødvendige arbeidet.";
$pgv_lang["edituser_lastname_help"]			= "~#pgv_lang[lastname]#~<br /><br />I denne boksen kan du endre etternavn. Dette er navnet andre brukere ser når du er logget inn.<br /><br />Selv om valget av hva du skal legge inn i dette feltet er ditt, bør du informere administratoren når du endrer det. Når andre ser en ukjent person på nettet, kan de lure på og stille spørsmål. Administratoren kan finne ut av det uten å ha mottatt varselet ditt, men du bør redde ham det unødvendige arbeidet.";
$pgv_lang["edituser_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />Dette er et identifikasjonsnummer som knytter deg til dine egne data i databasen.<br /><br />Du kan ikke endre denne ID-en; den er satt av administratoren. Hvis du mener at denne ID-en ikke er riktig, bør du kontakte administratoren for å få den endret.";
$pgv_lang["edituser_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Dette er startpersonen (Rot) til alle diagrammene dine.<br /><br />Hvis du for eksempel skulle klikke på lenken til stamtavlen, ville du se denne rotpersonen i venstre venstre rute. Denne rotpersonen trenger ikke være deg; du kan starte med en hvilken som helst person (din bestefar eller morens tante, for eksempel), så lenge du har rettighetene til å se den personen.<br /><br />Dette alternativet endrer standard Rot person for de fleste diagrammer. Du kan endre rotpersonen som faktisk brukes på mange diagrammer, men det er bare for den siden på det aktuelle tidspunktet.";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />Det er en god praksis å endre passordet ditt regelmessig. Du må huske på at alle som kjenner brukernavnet og passordet ditt, vil ha tilgang til dataene dine.<br /><br />Gjør passordet minst 6 tegn langt, jo lenger jo bedre. Du kan bruke store og små bokstaver med eller uten diakritiske tegn, tall, bindestrek (-) og understrek (_). Bruk <u>ikke</u> skilletegn eller mellomrom. Bruk en kombinasjon av store og små bokstaver, tall og andre tegn. For eksempel:<b>5Z_q\$P4=r9</b>.<br /><br />I likhet med brukernavnet er passordet <u>store og små bokstaver</u>. Det betyr at <b>Hemmelig.Passord!#13</b> ikke er det samme som <b>hemmelig.passord!#13</b> eller <b>HEMMELIG.PASSORD!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Hvis du har endret passordet ditt, må du også bekrefte det. Dette er bare for å være sikker på at du ikke gjorde en skrivefeil i passordfeltet.<br /><br />Hvis passordet og bekreftelsen ikke er identiske, får du en passende feilmelding. Du må skrive inn både det opprinnelige passordet og bekreftelsen på nytt.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Her kan du endre språket PhpGedview vil vise alle sidene og meldingene etter at du har logget på.<br /><br />Når du først får tilgang til nettstedet, antar PhpGedView at du vil se alt på språket som er konfigurert som ønsket språk i nettleseren din. Hvis denne antagelsen er feil, vil du overstyre den her. For eksempel kan nettleseren din være satt til engelsk fordi det er det vanligste språket på Internett. For slektsforskning vil du imidlertid helst se alt på finsk eller hebraisk. Her gjør du det.<br /><br />Administratoren kontrollerer hvilke språkvalg som er tilgjengelige for deg. Hvis preferansen din ikke er oppført, må du kontakte administratoren.<br /><br />Husk at PhpGedView i stor grad er et prosjekt bemannet av et internasjonalt team av ubetalte frivillige. Eksperter kommer og går. Derfor er støtte til andre språk enn engelsk noen ganger ikke så god som den burde være.<br /><br />Hvis du ser noe som ikke er oversatt, er oversatt feil eller kan formuleres bedre, la administratoren din vet. Administratoren vil vite hvordan man kan komme i kontakt med PhpGedView-utviklerteamet for å få tak i dine bekymringer. Enda bedre, frivillig litt av tiden din. Vi kan bruke hjelpen.";
$pgv_lang["edituser_email_help"]			= "~#pgv_lang[emailadress]#~<br /><br />Din korrekte e-postadresse er viktig for oss for å holde kontakten med deg.<br /><br />Hvis du får en ny e-postadresse, som vanligvis skjer når du bytter internettleverandør, ikke glem å endre adressen her også. Du vil ikke motta en bekreftelsesmelding fra dette nettstedet når du endrer denne adressen, men eventuelle fremtidige meldinger som blir rettet til deg, kommer til denne nye adressen.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Dette nettstedet kan ha flere forskjellige utseende eller utseende. Andre programmer kan kalle dem \"skins\", men her er de \"stiler\".<br /><br />Hver stil vil vise de samme dataene, men presentasjonen eller til og med plasseringen på skjermen kan variere. Dette er som å legge et bilde inn i en annen ramme og også henge det i et annet rom. Bildet endres ikke, men måten du ser på det er helt annerledes.<br /><br />Bare prøv det. Sett den til en annen stil. Se på det, prøv en annen. Bytt tilbake til den som passer deg best. Hver gang du logger på, vil du se stilen du sist brukte; du trenger ikke engang å komme til denne konfigurasjonssiden for å endre din foretrukne stil.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView har flere forskjellige kontaktmetoder. Administratoren bestemmer hvilken metode som skal brukes for å kontakte ham. Du har kontroll over metoden som skal brukes til å kontakte <u>deg</u>. Avhengig av nettstedskonfigurasjon, er det mulig at noen av de oppførte metodene ikke er tilgjengelige for deg.";
$pgv_lang["mail_option1_help"]				= "Med dette alternativet vil PhpGedView interne meldingssystem brukes og ingen e-post vil bli sendt.<br /><br />Du vil bare motta <u>interne</u> meldinger fra de andre brukerne. Når en annen nettstedsbruker sender deg en melding, vises meldingen i meldingsblokken på din personlige #pgv_lang[mygedview]# side. Hvis du har fjernet denne blokken fra #pgv_lang[mygedview]# siden din, vil du ikke se noen meldinger. De vil imidlertid dukke opp så snart du konfigurerer #pgv_lang[mygedview]# siden til å ha meldingsblokken igjen.";
$pgv_lang["mail_option2_help"]				= "Dette alternativet er som #pgv_lang[messaging]#, med ett tillegg. Som en ekstra vil en kopi av meldingen også sendes til e-postadressen du konfigurerte på kontosiden.<br /><br />Dette er standard kontaktmetode.";
$pgv_lang["mail_option3_help"]				= "Med dette alternativet vil du bare motta e-postmeldinger på adressen du konfigurerte på kontosiden. Meldingssystemet internt til PhpGedView vil ikke brukes i det hele tatt, og det vil aldri være noen meldinger i meldingsblokken på din personlige #pgv_lang[mygedview]# side.";
$pgv_lang["mail_option4_help"]			="Med dette alternativet vil du ikke motta noen meldinger. Selv administratoren vil ikke kunne nå deg.";

//-- Admin
$pgv_lang["admin_help"]						= "På denne siden finner du lenker til konfigurasjonssidene, administrasjonssidene, dokumentasjonen og loggfilene.<br /><br /><b>#pgv_lang[system_time]#</b>, rett under sidetittelen, viser tidspunktet for serveren der nettstedet ditt er vert. Dette betyr at hvis serveren er lokalisert i New York mens du er i Norge, vil den viste tiden være seks timer mindre enn lokal tid, med mindre selvfølgelig serveren kjører på Greenwich Mean Time (GMT). Tiden som vises er servertiden da du åpnet eller oppdaterte denne siden.<br /><br /><b>ADVARSEL</b><br />Når du ser en rød advarsel under systemtiden, betyr det at <i>config.php</i> fremdeles kan skrives. Etter å ha konfigurert nettstedet ditt, bør du, for <b>sikkerhet</b>, sette tillatelsene til denne filen tilbake til skrivebeskyttet. Du må gjøre dette <u>manuelt</u>, siden PhpGedView ikke kan gjøre dette for deg.";

//-- User Admin
$pgv_lang["useradmin_help"]				="~#pgv_lang[user_admin]#~<br /><br />På denne siden kan du administrere aktiverte og nye brukere.<br /><br /><b>#pgv_lang[current_users]#</b><br />I denne tabellen vises aktiverte brukere med deres status og rettigheter. Du kan <b>slette</b> eller <b>endre</b> kontoen til brukere.<br /><br /><b>#pgv_lang[add_user]#</b><br />Dette skjemaet er nesten tilsvarende de du vil finne under <b>#pgv_lang[editowndata]#</b>.<br /><br />For flere felt er det ikke laget noen egen hjelpetekst for administratorer. For disse vil du se følgende melding:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />#pgv_lang[gedcomid]# identifiserer brukeren. Den må angis av administratoren.<br /><br />Denne ID-en brukes som ID på flere sider, som <b>#pgv_lang[my_indi]#</b> og <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Du kan angi brukerens GEDCOM ID separat for hver GEDCOM. Hvis en bruker ikke har en post i et GEDCOM, lar du boksen være tom.";
$pgv_lang["useradmin_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />For hver slektsdatabase kan du utpeke en <b>rotperson</b> for brukeren.<br /><br />Denne rotpersonen trenger ikke å være brukeren selv; det kan være hvem som helst. Brukeren vil sannsynligvis ønske å starte stamtavle med seg selv. Du kontrollerer det, så vel som standard Root person på andre diagrammer, her.<br /><br />Hvis brukeren har redigeringsrettigheter til sin egen kontoinformasjon, kan han endre denne innstillingen selv.";
$pgv_lang["useradmin_can_admin_help"]		= "~#pgv_lang[can_admin]#~<br /><br />Hvis denne boksen er merket av, vil brukeren ha de samme rettighetene som du har.<br /><br />Disse rettighetene inkluderer:<ul><li>Legg til / fjern / rediger brukere</li><li>Send meldinger til alle brukere</li><li>Rediger velkomstmeldinger</li><li>Rediger og konfigurer språkfiler</li><li>Oppgrader PhpGedView</li><li>Endre program- og GEDCOM-konfigurasjoner</li><li>Administrer GEDCOM</li><li>Endre personverninnstillinger</li><li>Og alt annet som ikke er nevnt her.</li></ul><br />Brukeren kan <u>ikke</u> endre noe på serveren din utenfor PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Hvis denne boksen er merket av og brukeren har tildelt en GEDCOM-post-ID, vil innstillingene for brukerkontoen automatisk synkroniseres med GEDCOM-dataene. Dette betyr at når brukerens GEDCOM-post redigeres, vil noe av informasjonen som e-postadresse og navn kopieres til brukerens konto. Når brukerens konto redigeres, vil tilsvarende informasjon kopieres til GEDCOM-posten.";
$pgv_lang["useradmin_can_edit_help"]		= "~#pgv_lang[can_edit]#~<br /><br />Brukeren kan ha forskjellige tilgangs- og redigeringsrettigheter for hver slektsdatabase i systemet.<ul><li><b>#pgv_lang[none]#:</b>&nbsp;&nbsp;&nbsp;Brukeren har ikke tilgang til de private dataene i denne GEDCOM.</li><li><b>#pgv_lang[access]#:</b>&nbsp;&nbsp;&nbsp;Brukeren kan ikke redigere eller godta data i databasen, men kan se private data.</li><li><b>#pgv_lang[edit]#:</b>&nbsp;&nbsp;&nbsp;Brukeren kan redigere verdier, men en annen bruker med <b>#pgv_lang[accept]#</b> privilegier må godkjenne endringene før de legges til databasen og offentliggjøres.</li><li><b>#pgv_lang[accept]#:</b>&nbsp;&nbsp;&nbsp;Brukeren kan redigere. Han kan også redigere og godkjenne endringer gjort av andre brukere.</li><li><b>#pgv_lang[admin_gedcom]#:</b>&nbsp;&nbsp;&nbsp;Brukeren kan redigere og godkjenne endringer gjort av andre brukere. Brukeren kan også redigere konfigurasjons- og personverninnstillinger for <u>denne</u> GEDCOM.</li></ul>Systemadministratorer, identifisert gjennom <b>#pgv_lang[can_admin]#</b> avkrysningsruten, får automatisk <b>#pgv_lang[admin_gedcom]#</b> rettigheter.";
$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Selvregistrering</b><br />En bruker kan søke om en ny konto ved hjelp av <b>selvregistrering</b> modulen.<br /><br />Når han gjør det, vil han motta en e-postmelding med en lenke for å bekrefte søknaden sin. Etter at søkeren har fulgt instruksjonene i den e-postadressen, vil du se dette feltet, og du kan fortsette med neste trinn <b>#pgv_lang[verified_by_admin]#</b>. Du bør vente med din godkjenning så lenge ikke denne avkrysningsboksen er merket av.<br /><br /><b>Legg til bruker manuelt</b><br />Hvis du bruker dette skjemaet for å legge til en bruker manuelt, vil du merke av i denne boksen.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />Hvis en bruker har brukt selvregistreringsmodulen og har bekreftet seg selv, er det siste trinnet, før kontoen hans blir aktiv, din godkjenning.<br /><br />Etter at du har godkjent brukerens søknad om en ny konto, brukeren vil motta en e-postmelding. Meldingen vil fortelle brukeren at kontoen hans nå er aktiv. Han kan logge inn med brukernavnet og passordet han oppga da han søkte om kontoen.";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />Dette skjemaet brukes av administratoren for å endre en brukers konto<br /><br />Skjemaet ligner veldig på <b>#pgv_lang[add_user]#</b> og <b>#pgv_lang[update_myaccount]#</b> skjemaer.";
$pgv_lang["useradmin_visibleonline_help"]	= "~#pgv_lang[visibleonline]#~<br /><br />Denne boksen kontrollerer synligheten din for andre brukere mens du er online. Den styrer også din evne til å se andre onlinebrukere som er konfigurert til å være synlige.<br /><br />Når denne ruten ikke er merket av, vil du være helt usynlig for andre, og du vil heller ikke kunne se andre online brukere. Når denne ruten er merket av, er det motsatte. Du vil være synlig for andre, og du vil også kunne se andre som er konfigurert til å være synlige.";
$pgv_lang["useradmin_editaccount_help"]		= "~#pgv_lang[editaccount]#~<br /><br />Hvis denne boksen er merket av, vil denne brukeren kunne redigere kontoinformasjonen sin. Selv om dette vanligvis ikke anbefales, kan du opprette et enkelt brukernavn og passord for flere brukere. Når denne boksen ikke er merket av for alle brukere med den delte kontoen, forhindres de i å redigere kontoinformasjonen, og bare en administrator kan endre den kontoen.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Hvis denne boksen er merket av, får brukeren bare tilgang til levende mennesker som de er i slekt med. De vil kunne se alle som er innenfor forholdets banelengde som er angitt av innstillingen <i>#pgv_lang[user_path_length]#</i>. Du kan kreve personvern for forholdet til alle brukerne dine ved å slå på det globale alternativet i GEDCOM-personverninnstillingene.<br /><br />Denne innstillingen krever at brukeren er tilknyttet en GEDCOM ID før de kan se noen levende mennesker.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Dersom <i>#pgv_lang[user_relationship_priv]#</i> er aktivert, vil denne brukeren bare kunne få se eller endre levende personer som er innenfor dette antallet av ledd av slektskap.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Ved å merke denne boksen tillater du at systemet automatisk aksepterer endringer som er gjort av denne brukeren. Brukeren må også ha aksepteringsrettigheter på GEDCOM for denne innstillingen skal tre i kraft.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[link_manage_servers]#~<br /><br />På denne siden kan du legge til eksterne nettsteder og nekte tilgang fra bestemte IP-adresser.<br /><br />Eksterne nettsteder kan legges til ved å gi nettstedets tittel, URL, database-ID (valgfritt), brukernavn og passord for den eksterne webtjenesten.<br /><br />Permanent eller tidsbestemt nektelse av tilgang oppnås ved å gi en eksakt IP-adresse eller et gyldig IP-adresseområde. For eksempel, 212.10.*.* . Eksterne nettsteder innenfor IP-adresseriene i listen vil ikke kunne få tilgang til nettstedet ditt.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~#pgv_lang[label_new_server]#~<br /><br />For å legge til et eksternt nettsted, gi nettstedets tittel, URL til den eksterne webtjenesten, database-ID (valgfritt) og brukernavn og passord. Klikk på Legg (+) knappen for å fullføre prosessen. Hvis den eksterne serveren tillater anonym godkjenning, bør du legge inn brukernavnet og passordet tomt.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]				= "IPv4-adresser består av 4 segmenter skilt av \".\" (punkt) og inneholder desimaltall i området null til 255 uten ledende nuller. Noen eksempler er: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10..29</b> eller <b>212.10.*.29</b> .   De manglende segmentene i disse eksemplene vil bli tolket som \"*\" (stjerne), med det \"*\" symbolet som betyr <i>samsvarer med et hvilket som helst tall i denne posisjonen</i>.<br /><br />IPv6-adresser består av 8 segmenter skilt av \":\" (kolon) og inneholder 4 sifferheksadesimale tall. Disse tallene skal ikke ha ledende nuller, og den første sekvensen av nuller kan bli fjernet og erstattet av et par symboler \":\" (kolon). Hvis du trenger å bruke funksjonen <i>samsvarer med et hvilket som helst nummer i denne posisjonen</i>, må du eksplisitt sette inn \"*\" (stjerne) der. Noen eksempler er: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> eller <b>23:0:*::*:*</b> . I disse eksemplene representerer kolonparet en sekvens på 3 tall, hver av disse er null, slik som: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~#pgv_lang[label_banned_servers]#~<br /><br />For å hindre at bestemte IPv4- eller IPv6-adresser får tilgang til nettstedet ditt, skriv inn en eksakt IP-adresse eller et gyldig IP-adresseområde og klikk på Legg (+) knappen.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_timedban"]				= "~#pgv_lang[label_timedban_servers]#~<br /><br />Når et hackingforsøk blir oppdaget, forhindrer PhpGedView automatisk tilgang fra den IP-adressen i en time.<br /><br />Du kan legge til dine egne tidsbestemte adgangsbegrensninger ved å skrive inn IPv4- eller IPv6-adressen som skal blokkeres sammen med dato og klokkeslett for avsluttet tilgangsbegjennelse i kommentarfeltet. Pass på at du bruker riktig format for utløpsinformasjonen. Hvis utløpsinformasjonen ikke er angitt riktig, utelukker ikke tilgangsbegjennelsen automatisk.<br /><br />Utløpet skal oppgis i følgende format: <b>åååå.mm.dd@tt:mm</b> . For eksempel, <b>2012.12.23@23:59</b> . Legg merke til bruken av 24-timers klokken.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]	= "~#pgv_lang[label_manual_search_engines]#~<br /><br />PhpGedView gir automatisk søkemotorer med mindre datafiler med færre lenker. Dataene er begrenset til den enkelte og nærmeste familie uten å legge til informasjon om storforeldre eller barnebarn. Mange rapporter og server-intensive sider som kalenderen er begrensede for søkemotorer.<br /><br />Mange populære søkemotorer som Google og Bing vil bli oppdaget automatisk. Hvis en søkemotor ikke automatisk gjenkjennes og du ønsker å gi den data til indeks, kan du skrive inn sin IPv4- eller IPv6-adresse her. Hvis du vil ekskludere denne nye søkemotoren fullstendig, opplister du den i delen <i>#pgv_lang[label_banned_servers]#</i>.<br /><br />Hvis du ønsker å se hvilke data som er gitt til søkemotorer for å indeksere, oppgi din egen IP-adresse her.&nbsp; <span class='warning'>ADVARSEL:</span>&nbsp; Dette vil <b>låse deg ut</b> av administrasjonsgrensesnittet, og du må fjerne IP-adressen ved å logge inn fra en annen maskin med en annen IP-adresse eller manuelt redigere <i>#GLOBALS[TBLPREFIX]#ip_address</i> database tabell.<br /><br />#pgv_lang[help_IPv4IPv6]#";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Søkemotor funnet~<br /><br />PhpGedView gir automatisk søkemotorer med mindre datafiler med færre lenker. Dataene er begrenset til personen og nærmeste familie uten å legge til informasjon om storforeldre eller barnebarn. Mange rapporter og server-intensive sider som kalenderen er begrensede for søkemotorer.<br /><br />Forsøk av søkemotorer for å gå til disse sidene, resulterer i å vise denne siden. Hvis du ser denne teksten, mener programvaren at du er en søkemotor. Nedenfor er listen over sider som har adgang til og vil gi forkortede data.<br /><br />Ekte brukere som følger søkemotorkoblinger til dette nettstedet, vil se de fulle sidene og dataene, og ikke denne siden.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br />~#pgv_lang[upload_gedcom]#~<br /><br /><b>Laster opp GEDCOM-filer</b><br />Opplasting av filer kan gjøres online. Du kan laste opp hvor som helst uten å trenge et FTP-program.<br /><br /><b>Legger til GEDCOM-filer</b><br />Hvis en tidligere opplastet fil fremdeles er tilstede i mappen <b>/index</b>, kan du bruke den igjen uten å laste den opp. Noen ganger, på grunn av fil- eller opplastningsstørrelsesbegrensninger, må du bruke Legg til.<br /><br />Legg til og last opp prosedyren kan avsluttes i fire enkle trinn. I begge prosedyrene er bare trinn 1 annerledes.";
$pgv_lang["gedcom_configfile_help"]		="~KONFIGURASJONSFIL TIL SLEKTSFILEN~<br /><br />Dette er filen der alle grunnleggende innstillinger knyttet til slektsdatabasen er lagret. Det er en egen fil for hver slik database.<br /><br />Du finner stien og navnet på hver konfigurasjonsfil i tabellen <b>#pgv_lang[current_gedcoms]#</b> på <b>#pgv_lang[gedcom_adm_head]#</b> side.";
$pgv_lang["default_gedcom_help"]		="~STANDARD SLEKTSFIL~<br /><br />Hvis du har mer enn en genealogisk database, kan du her angi hvilken av dem som skal være standard.<br /><br />Denne standarden vises for alle besøkende og brukere som ennå ikke har logget på.<br /><br />Brukere som kan redigere kontoinnstillingene, kan overstyre denne standardverdien. I så fall vil brukerens foretrukne database vises etter pålogging.";
$pgv_lang["delete_gedcom_help"]			= "~SLETTE SLEKTSFIL~<br /><br />PhpGedView oppretter sin database fra en GEDCOM-fil som tidligere ble lastet opp. Når du velger <b>Slett</b>, vil den delen av databasen bli slettet. Du må bekrefte slettingsforespørselen.<br /><br />Med mindre du bevisst har fjernet den utenfor PhpGedView, forblir den originale GEDCOM-filen i mappen den ble lastet opp i. Hvis du senere vil jobbe med den GEDCOM-filen igjen, trenger du ikke å laste den opp igjen. Du kan velge funksjonen <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Når du bruker funksjonen <b>#pgv_lang[add_gedcom]#</b>, antas det at du allerede har lastet opp GEDCOM-filen til serveren din ved hjelp av et program eller en metode <u>ekstern</u> til PhpGedView, for for eksempel <i>ftp</i> eller <i>nettverkstilkobling</i>. Filen du vil legge til, kan også ha blitt igjen fra en tidligere <b>#pgv_lang[upload_gedcom]#</b> prosedyre.<br /><br />Hvis inngangs-GEDCOM-filen ennå ikke er på serveren din, <u>må</u> du få den der først, før du kan begynne med å legge til.<br /><br />I stedet for å laste opp en GEDCOM-fil, kan du også laste opp en ZIP-fil som inneholder GEDCOM-filen, enten med PhpGedView, eller ved hjelp av et eksternt program. PhpGedView gjenkjenner ZIP-filen automatisk og trekker ut GEDCOM-filen og filnavnet fra ZIP-filen.<br /><br />Hvis det allerede finnes en GEDCOM-fil med samme navn i PhpGedView, blir den overskrevet. Imidlertid vil alle GEDCOM-innstillinger som er gjort tidligere, bevares.<br /><br />Du blir guidet trinn for trinn gjennom prosedyren.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Du kan starte en ny slektsdatabase fra bunnen av.<br /><br />Denne prosedyren krever bare noen få enkle trinn. Trinn 1 er forskjellig fra det du allerede vet om å laste opp og legge til. De andre trinnene vil være kjent.<ol><li><b>Navngi den nye GEDCOM</b><br />Skriv inn navnet på den nye GEDCOM <u>uten</u> utvidelsen <b>.ged</b>. Den nye filen vil bli opprettet i mappen over boksen der du skriver inn navnet. Klikk <b>Legg til</b>.</li><li><b>Konfigurasjonsside</b><br />Du kjenner allerede denne siden; du konfigurerer innstillingene for den nye GEDCOM-filen.</li><li><b>Validere</b><br />Du kjenner allerede denne siden; den nye GEDCOM er sjekket. Siden det ikke er noe i det, vil det være ok.</li><li><b>Importerer poster</b><br />Siden det bare vil være én post å importere, blir dette ferdig veldig raskt.</li></ol>Nå kan du gå til Stamtavle for å se din første person i nye GEDCOM. Klikk på navnet på personen og begynn å redigere. Etter det kan du koble nye individer til første person.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Fra denne siden kan du laste ned din slektsdatabase i GEDCOM-format. Det kan være lurt å importere dataene til et annet slektsforskningsprogram, eller kanskje du vil dele informasjonen med andre.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />#pgv_lang[gedcom_adm_head]# siden er kontrollsenteret for administrasjon av alle dine slektsdatabaser.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />På toppen av tabellen <b>#pgv_lang[current_gedcoms]#</b> ser du en handlingslinje med fire lenker.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />I tabellen <b>#pgv_lang[current_gedcoms]#</b> er hver genealogisk database oppført separat, og du har følgende alternativer for hver av dem:<ul><li>Importere</li><li>Slett</li><li>Last ned</li><li>Rediger konfigurasjonen</li><li>Rediger personvernet</li><li>Søkelogg filer</li></ul>Rediger personvern vises her fordi hver GEDCOM har sin egen personvernfil.<br /><br />Hver linje i denne tabellen skal være selvforklarende. PhpGedView kan konfigureres til å logge alle databasesøk. Søkelogg filene kan inspiseres gjennom lenker på denne siden.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]	= "~KONFIGURERE SLEKTSBASE~<br /><br />Hver slektsdatabase som brukes med PhpGedView har sin egen <b>konfigurasjonsfil</b>.<br /><br />På dette skjemaet konfigurerer du mange alternativer som databasetittel, språk, kalenderformat, e-postalternativer, logging av database søk, HTML META-overskrifter, fjerning av etternavn fra databasens liste over hyppige etternavn osv.";
$pgv_lang["import_gedcom_help"]			= "~IMPORTERE GEDCOM~<br /><br />I de fleste tilfeller er import av en eksternt opprettet GEDCOM-fil ett trinn i prosedyrer som resulterer i store endringer i slektsdatabasen.<br /><br />Disse trinnene er i en logisk rekkefølge og må fullføres i den foreskrevne rekkefølgen slik at at slektsdatabasen er brukbar.<br /><br />Hvis du av en eller annen grunn ikke fullførte disse trinnene i riktig rekkefølge, vil du se en <u>advarsel</u> melding om at GEDCOM ikke er ennå importert. For å løse problemet, klikk på koblingen <b>Importer GEDCOM</b> for å importere filen.<br /><br />Eksisterende GEDCOM-konfigurasjonsinnstillinger endres ikke når du importerer en GEDCOM på nytt. Eksisterende data blir imidlertid overskrevet.";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />I motsetning til funksjonen <b>#pgv_lang[add_gedcom]#</b>, trenger ikke GEDCOM-filen du vil legge til databasen din, på serveren din.<br /><br />I trinn 1 velger du en GEDCOM-fil fra din lokale datamaskin. Skriv inn hele banen og filnavnet i tekstboksen, eller bruk knappen <b>Bla gjennom</b> på siden.<br /><br />Du kan også bruke denne funksjonen til å laste opp en ZIP-fil som inneholder GEDCOM-filen. PhpGedView gjenkjenner ZIP-filen og trekker ut filen og filnavnet automatisk.<br /><br />Hvis en GEDCOM-fil med samme navn allerede eksisterer i PhpGedView, vil den overskrives etter bekreftelsen. Imidlertid vil alle GEDCOM-innstillinger som er gjort tidligere, bevares.<br /><br />Du finner mer hjelp på andre sider i prosedyren.";
$pgv_lang["validate_gedcom_help"]		= "~SJEKK GYLDIGHET TIL GEDCOM~<br /><br />Dette er det tredje trinnet i prosedyren for å legge til eksternt opprettede GEDCOM-data til din slektsdatabase.<br /><br />PhpGedView vil kontrollere inngangsfilen for riktig bruk av datoformat, stedsformat, tegnsett osv. Noen avvik fra GEDCOM 5.5.1-standarden, som PhpGedView følger, kan korrigeres automatisk. Eksempler er Macintosh-linjeavslutninger og feil bruk av Place-format. Når dette skjer, vil du se en melding om at dataene er endret. Ved andre avvik vil du få en advarsel med en anbefalt løsning.<br /><br /><b>Valgfrie verktøy</b><br />For øyeblikket er det bare ett ekstra verktøy: <b>Endre person-ID til ...</b>.<br /><br /><b>Mer hjelp</b><br />#pgv_lang[context_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~KONVERTER ANSI TIL UTF-8~<br /><br />For å sikre at informasjonen i dine GEDCOM-filer blir behandlet og vises riktig, bør disse filene være kodet i UTF-8.<br /><br />Noen av de mer moderne slektsforskningsprogrammene kan eksportere dataene til en GEDCOM-fil i UTF-8-koding. Eldre programmer har ofte ikke denne muligheten. Hvis programmet ikke tilbyr deg dette alternativet, kan PhpGedView konvertere filen for deg.<br /><br />Når PhpGedView validerer inndatafilen, vil den oppdage kodingen av filen og gi deg råd om det.";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI TEGNSETT OPPDAGET~<br /><br />GEDCOM-filen som valideres nå er kodet i ANSI-tegnsettet. Det anbefales at du konverterer filens koding til UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~FEIL DATO-FORMAT OPPDAGET~<br /><br /><b>DATO-FORMAT VIL BLI ENDRET</b><br /><br />Datoformatet som er standard for PhpGedView og også i henhold til GEDCOM 5.5.1 Standard er <b>DD&nbsp;MMM&nbsp;ÅÅÅÅ</b> (f.eks. 01&nbsp;JAN&nbsp;2004)<br /><br />Hvis, etter GEDCOM-filen din er validert, du ser en melding om at feil datoformat er oppdaget. PhpGedView vil konvertere feilformaterte datoer som foreskrevet av standarden.<br /><br />U har imidlertid muligheten til å velge enten \"<b>dag</b> før måned\" (DD&nbsp;MMM&nbsp;ÅÅÅÅ), eller \"<b>måned</b> før dag\" (MMM&nbsp;DD&nbsp;ÅÅÅÅ).<br /><br />Vi anbefaler at du bruker det første formatet (dagen før måneden).";
$pgv_lang["change_indi2id_help"]		= "~BYTT PERSON-ID TIL ....~<br /><br />Dette verktøyet er designet for brukere som har slektsprogrammer som bruker en annen GEDCOM ID for personer hver gang GEDCOM eksporteres. For eksempel, den første gangen GEDCOM eksporteres, kan noen persons ID være I100, men neste gang GEDCOM eksporteres, blir den samme persons ID endret til I234. Disse skiftende IDene gjør det vanskelig å administrere PhpGedView fordi ID er hvordan folk blir referert til.<br /><br />De fleste slektsforskningsprogrammer bruker også RIN- eller REFN-taggen for å gi hver person en unik identifikator som kan brukes til å referere til person. Dette verktøyet erstatter alle IDene i GEDCOM-filen med hvilket felt (RIN eller REFN) du angir.";
$pgv_lang["edit_privacy_help"]			= "På denne siden kan du gjøre alle personverninnstillingene for den valgte GEDCOM.<br /><br />Du kan sjekke under sidetittelen for å se at du redigerer riktig personvernfil. Den vises slik: (sti/navnetpådingedcom_priv.php)<br /><br />Hvis du trenger flere innstillinger, kan du gjøre endringer i personvernfilen manuelt. Du kan lese mer om dette på nettstedet PhpGedView.";
$pgv_lang["BOM_detected_help"]			= "~Bytebestillingsmerke (BOM) oppdaget~<br /><br />GEDCOM-filen du importerer, har en spesiell 3-byte-kode i begynnelsen. Denne spesialkoden brukes av noen progblokker for å indikere at filen er spilt inn i UTF-8 tegnsett.<br /><br />Selv om denne spesialkoden egentlig ikke er en feil, vil ikke PhpGedView fungere ordentlig når inndatafilen inneholder koden. Du bør la PhpGedView fjerne koden.";
$pgv_lang["invalid_header_help"]		= "~UGYLDIG START I GEDCOM-FIL~<br /><br />En GEDCOM-fil må begynne med <b>0&nbsp;HEAD</b>. PhpGedView oppdaget at GEDCOM-filen du importerer ikke har <b>0&nbsp;HEAD</b> som første linje. Når du klikker på oppryddingsknappen, fjernes eventuelle linjer før den første <b>0&nbsp;HEAD</b> linjen.<br /><br />Denne feilen betyr vanligvis at programmet du brukte til å lage GEDCOM ikke gjorde opprett den riktig, eller det er ikke en GEDCOM-fil. Du bør kontrollere at du lastet opp riktig fil, og at den starter med linjen <b>0&nbsp;HEAD</b> og slutter med linjen <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~OPPDAGET MACINSTOSH-FIL~<br /><br />PhpGedView oppdaget at GEDCOM-filen ble opprettet på en Macintosh-datamaskin.<ul><li>Macintosh-filer avslutter hver linje med en CR-kontrollkode. CR er Ctrl+M.</li><li>Unix-filer avslutter hver linje med en LF-kontrollkode. LF er Ctrl+J.</li><li>Windows og DOS bruker en to-kodesekvens, CR etterfulgt av LF.</li></ul>PhpGedView krever at alle filer bruker Unix- eller DOS-linjeavslutninger. Når du klikker på Opprydding-knappen, konverteres linjeavslutningene tilsvarende.";
$pgv_lang["cleanup_places_help"]		= "~RYDD STEDSKODER~<br /><br />PhpGedView oppdaget at GEDCOM-filen din bruker steder på GEDCOM-koder som ikke skal ha steder.<br /><br />Mange slektsforskningsprogrammer, for eksempel Family Tree Maker, vil opprette denne typen GEDCOM-fil. PhpGedView fungerer med disse GEDCOM-filene, men noen ugyldige steder vil dukke opp i stedshierarkiet ditt.<br /><br />For eksempel kan din GEDCOM ha følgende koding<div style=\"padding-left: 30px;\">1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Dataprogrammerer</div><br />I følge GEDCOM 5.5.1 Standard skal dette virkelig vises som<div style=\"padding-left: 30px;\">1 SSN 123-45-6789<br />1 OCCU Dataprogrammerer</div><br />Hvis du velger <b>Ja</b>, vil PhpGedView automatisk korrigere disse kodingsfeilene.";
$pgv_lang["empty_lines_detected_help"]	= "~OPPDAGET TOMME LINJER~<br /><br />PhpGedView oppdaget at det er tomme linjer i GEDCOM-filen din.  Disse linjene kan føre til feil og vil bli fjernet fra GEDCOM-filen før den blir importert.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~Oppsett av PhpGedView~<br /><br />På denne siden konfigurerer du de globale innstillingene for PhpGedView. Du må gjøre dette etter at du har installert PhpGedView og kjører den for første gang.<br /><br />#pgv_lang[review_readme]#<br /><br />Siden disse innstillingene er <b>globale</b>, er de for hele programmet og for alle slektsdatabaser du bruker med PhpGedView.<br /><br />Hver slektsdatabase har også flere konfigurasjonsalternativer som du angir etter å ha klikket koblingen <b>#pgv_lang[admin_gedcoms]#</b> på denne siden.<br /><br />Du kan også få tilgang til funksjonen #pgv_lang[gedcom_adm_head]# fra administrasjonssiden, hvis lenke finnes under #pgv_lang[mgv]# ikonet eller i overskriften på de fleste sider. På administratorsiden heter den aktuelle lenken <b>#pgv_lang[manage_gedcoms]#</b>.";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Denne siden lar deg slå sammen to GEDCOM-poster fra den samme GEDCOM-filen.<br /><br />Dette er nyttig for personer som har slått sammen GEDCOMs og nå har mange personer, familier og kilder som er de samme.<br /><br />Siden består av tre trinn.<br /><ol><li>Du angir to GEDCOM-ID-er. IDene <u>må</u> være av samme type. Du kan for eksempel ikke slå sammen en person og en familie eller familie og kilde.<br />I feltet <b>#pgv_lang[merge_to]#</b> skriver du inn ID-en til posten du vil være den nye posten etter at sammenslåingen er fullført.<br />I <b>#pgv_lang[merge_from]#</b> feltet opp ID-en til posten hvis informasjon blir slått sammen til #pgv_lang[merge_to]# posten. Denne posten vil bli slettet etter sammenslåingen.</li><li>Du velger hvilke fakta du vil beholde fra de to postene når de slås sammen. Bare klikk på boksene ved siden av de du vil beholde.</li><li>Du inspiserer resultatene av sammenslåingen, akkurat som med alle andre endringer som er gjort online.</li></ol>Noen med godta-rettigheter må godkjenne endringene dine for å gjøre dem permanente.";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~#pgv_lang[reports]#~<br /><br />Elementene i rapportmenyen vil generere PDF-filer for utskrift.<br /><br />Det første trinnet er å velge en rapport som skal kjøres. Etter at du har valgt en rapport som skal kjøres, blir du bedt om å gi litt informasjon spesifikk for den rapporten, for eksempel hvilken person eller familie du skal begynne med og om du vil vise bilder eller ikke. Når du er klar til å kjøre rapporten, klikker du på knappen <b>#pgv_lang[download_report]#</b> for å laste ned rapporten til datamaskinen din.<br /><br />#pgv_lang[help_xml_reports]#<br /><br />#pgv_lang[def_pdf_format_help]#<br /><br />#pgv_lang[help_ahnentafel.xml]#<br /><br />#pgv_lang[help_birthlist.xml]#<br /><br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]		= "~PDF filformat~<br /><br />PhpGedView Reporting Engine produserer nedlastbare rapporter i Adobe&reg; PDF-format. GEDCOM 5.5.1-standardspesifikasjonen, nevnt andre steder i denne hjelpefilen, kan også lastes ned som en PDF-fil. PDF er et akronym for <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (bærbart dokumentformat).";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br /><br />Dette er en rapport som viser den valgte personen og tilhørende forfedre vist som et hefte.  Den starter med personen og fortsetter med foreldrene, besteforeldrene osv.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br /><br />Dette er en rapport som kan vise alle personer som er født på et bestemt tidspunkt eller sted.";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br /><br />Denne rapporten vil vise alle pårørende til den valgte personen. Du kan velge hvilken av personens slektninger du vil vise på rapporten.<ul><li><b>#pgv_lang[child-family]#</b>&nbsp;&nbsp;&nbsp;vil vise den valgte personen, foreldrene og brødrene og søstrene.</li><li><b>#pgv_lang[spouse-family]#</b>&nbsp;&nbsp;&nbsp;vil liste opp personen med sine ektefeller og deres barn.</li><li><b>#pgv_lang[direct-ancestors]#</b>&nbsp;&nbsp;&nbsp;vil liste opp personen, foreldrene, besteforeldrene, oldeforeldrene, og fortsette oppover treet som viser alle menneskene som er foreldre i personens slekt.</li><li><b>#pgv_lang[ancestors]#</b>&nbsp;&nbsp;&nbsp;vil liste opp alle menneskene fra #pgv_lang [direkte-forfedre] # -listen, men inkluderer også tanter og onkler og tanter og tanter og onkler, så det vil inkludere søsken til alle forfedrene i denne personens slektstre. Det vil ikke vise barna til søsken (søskenbarn).</li><li><b>#pgv_lang[descendants]#</b>&nbsp;&nbsp;&nbsp;vil liste opp alle denne personens etterkommere (barn, barnebarn, oldebarn osv.).</li><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;dette alternativet er en kombinasjon av #pgv_lang[descendants]# og #pgv_lang[ancestors]# i en enkelt rapport.</li></ul>";
$pgv_lang["help_xml_reports"]			= "~rapporteringsmotor~<br /><br />PhpGedView rapporteringsmotor bruker XML-malfiler for automatisk å generere PDF-rapporter.<br /><br />Rapportene som er tilgjengelige i <b>#pgv_lang[select_report]#</b> listen genereres fra XML-rapportene som finnes i mappen \"reports\". Du kan lage dine egne rapporter ved å lage en kopi av en av malene som er gitt, og endre mal-XML. For å legge til din tilpassede rapport, er det bare å legge den i \"reports\" mappen, og PhpGedView vil automatisk oppdage den og gjøre den tilgjengelig i listen.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>Hjelp Innhold</b>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM informasjon";
$pgv_lang["help_contents_gedcom_places"]	= "Steder i GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	="<b>HJELP INNHOLD<br /><br />ADMINISTRATOR HJELPER VARER</b> lagt til begynnelsen av listen.";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]					= "_Konfigurer PhpGedView";
$pgv_lang["ah3_help"]					="_GEDCOM: Legg til kontra Hente (upload)";
$pgv_lang["ah4_help"]					="_GEDCOM: Konfigurasjonsfil";
$pgv_lang["ah5_help"]					="_GEDCOM: Standard";
$pgv_lang["ah6_help"]					="_GEDCOM: Slette";
$pgv_lang["ah7_help"]					="_GEDCOM: Legg til";
$pgv_lang["ah8_help"]					="_GEDCOM: Lage ny";
$pgv_lang["ah9_help"]					="_GEDCOM: Laste ned (download)";
$pgv_lang["ah10_help"]					="_GEDCOM: Siden Administrasjon";
$pgv_lang["ah11_help"]					="_GEDCOM: Konfigurere";
$pgv_lang["ah12_help"]					="_GEDCOM: Importere";
$pgv_lang["ah13_help"]					="_GEDCOM: Hente (upload)";
$pgv_lang["ah14_help"]					="_GEDCOM: Sjekke gyldighet";
$pgv_lang["ah15_help"]					="_GEDCOM: Konvertere ANSI til UTF-8";
$pgv_lang["ah16_help"]					="_GEDCOM: Personvern-innstillinger";
$pgv_lang["ah17_help"]					="_Brukere og rettigheter";
$pgv_lang["ah18_help"]					="_Administrasjon";
$pgv_lang["ah19_help"]					="_GEDCOM: MediaVerktøy";
$pgv_lang["ah20_help"]					="_GEDCOM: Endre ID til person(er) til ...";
$pgv_lang["ah21_help"]					= "_Språk-filer";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]					= "_Oppsett for støttede språk";
$pgv_lang["ah24_help"]					= "_Konvertering (SQL <<-->> Index)";
$pgv_lang["ah25_help"]					= "_PhpGedView sikkerhetskopi";
$pgv_lang["ah26_help"]					= "_FAQ liste: Rediger";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~Statistikkgraf~<br /><br />Dette er resultatsiden som viser det grafiske plottet av statistikken fra databasen din som definert av inngangene på forrige side.";
$pgv_lang["help_statistics.php"] = "~Statistikkgraf~<br /><br />Denne siden lar deg bestemme kriteriene for å produsere en grafisk visning av ulike statistikker fra databasen din.";
$pgv_lang["stat_help"]					= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br /><br />Det kan produseres en rekke forskjellige statistikkdiagrammer fra databasen din.<br /><br />Velg diagrammet, og juster deretter alternativene fra boksene.<br /><br />Tallene som er inkludert i hvert tomt, avhenger av tilgjengelige data. For eksempel kan individer uten en fødselsmåned (f.eks. Bare 1856) ikke inkluderes i en fødselsplan etter måned.";
$pgv_lang["stat_help_x"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~X AXIS~<br /><br />Følgende alternativer er tilgjengelige for X-aksen (vannrett). Hver vil deretter bli presentert i henhold til alternativene som er angitt for Y- og Z-aksene.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;&nbsp;personer født i hver måned.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;&nbsp;personer som døde i hver måned.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;&nbsp;ekteskap som skjedde i hver måned.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;&nbsp;antall førstefødte for hver familie etter måned.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;&nbsp;antall første ekteskap per måned.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;&nbsp;antall måneder mellom ekteskap og fødsel av første barn til paret.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;&nbsp;alder ved død, relatert til tidsperioden som inkluderer hver persons fødselsår.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;&nbsp;alder ved død, relatert til tidsperioden som inkluderer hver persons dødsår.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;&nbsp;gjennomsnittsalderen for personer på ekteskapstidspunktet<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;&nbsp;gjennomsnittsalderen for personer på tidspunktet for deres første ekteskap.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;&nbsp;gjennomsnittlige familiestørrelser.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;&nbsp;plassering av alle personer eller personer med det angitte navnet, etter land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;&nbsp;fødeland.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;&nbsp;ekteskapsland.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;&nbsp;dødslandet.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;&nbsp;sirkeldiagram over personer med kilder.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;&nbsp;sirkeldiagram over familier med kilder.</p>";
$pgv_lang["stat_help_y"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~Y AXIS~<br /><br />Følgende alternativer er tilgjengelige for Y-aksen (vertikal). Disse alternativene endrer måten elementene som vises på X-aksen vises.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;&nbsp;viser antall personer i hver kategori definert av X-aksen.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;&nbsp;beregner og graderer andelen av hvert element i X-aksekategoriene.</p>";
$pgv_lang["stat_help_z"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~Z AXIS~<br /><br />Følgende alternativer er tilgjengelige for Z-aksen. Disse alternativene gir en underinndeling av kategoriene som er valgt for X-aksen.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;&nbsp;viser elementene som en enkelt kolonne for hver X-aksekategori.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;&nbsp;viser elementene i to kolonner (mann og kvinne) for hver X-aksekategori.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;&nbsp;viser elementene i et antall kolonner relatert til tidsperioder angitt i neste seksjon, for hver X-aksekategori.</p>";
$pgv_lang["stat_help_gwx"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~grenser for X-aksen~<br /><br />Velg ønsket aldersintervall.<br /><br />For eksempel beskriver <b>#pgv_lang[aft_marr]#</b> følgende månedsserier:<div style=\"padding-left: 30px;\">før ekteskapet<br />fra ekteskapet til 8 måneder etter<br />fra 8 til 12<br />fra 12 til 15<br />fra 15 til 18<br />fra 18 til 24<br />fra 24 til 48<br />over 48 måneder etter ekteskapet</div><br />Når du vil vise kvartaler, må du velge <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~grenser for X-aksen~<br /><br />Velg ønsket aldersintervall.<br /><br />For eksempel beskriver <b>intervall 10 år</b> følgende aldersgruppe:<div style=\"padding-left: 30px;\">yngre enn ett år<br />ett år til 5 år<br />6 til 10<br />11 til 20<br />21 til 30<br />31 till 40<br />41 til 50<br />51 til 60<br />61 til 70<br />71 til 80<br />81 til 90<br />91 til 100<br />eldre enn 100 år</div>";
$pgv_lang["stat_help_gbx"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~grenser for X-aksen~<br /><br />Velg ønsket aldersintervall.<br /><br />For eksempel beskriver <b>intervall 2 år</b> følgende aldersgrupper:<div style=\"padding-left: 30px;\">yngre enn 16 år<br />16 til 18<br />19 til 20<br />21 til 22<br />23 til 24<br />25 til 26<br />27 til 28<br />29 til 30<br />31 til 32<br />33 til 35<br />36 til 40<br />41 til 50<br />eldre enn 50 år</div>";
$pgv_lang["stat_help_gcx"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~grenser for X-aksen~<br /><br />Velg ønsket telleintervall.<br /><br />For eksempel beskriver <b>intervall ett barn</b> følgende sett med antall antall barn:<div style=\"padding-left: 30px;\">uten barn<br />et barn<br />to barn<br />3, 4, 5, 6, 7, 8, 9, 10 barn<br />mer enn 10 barn</div>";
$pgv_lang["stat_help_gwz"]		= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br />~grenser for Z-aksen~<br /><br />Velg ønsket startår og intervall<br /><br />For eksempel beskriver <b>fra 1700, intervallet 50 år</b> følgende sett med datoperioder:<div style=\"padding-left: 30px;\">før 1700<br />1700 til 1749<br />1750 til 1799<br />1800 til 1849<br />1850 til 1899<br />1900 til 1949<br />1950 til 1999<br />2000 eller senere</div>";
$pgv_lang["chart_type_help"]	= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br /><br />Velg det du vil se på kartet. Du kan velge:<div style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;viser landene der personer fra denne databasen forekommer.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;&nbsp;viser landene der det angitte etternavnet forekommer.</div>";
$pgv_lang["google_chart_surname_help"]	= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br /><br />Antall forekomster av det angitte navnet vises på kartet. Hvis du lar dette feltet stå tomt, vil det vanligste etternavnet bli brukt.";
$pgv_lang["chart_area_help"]	= "~ALTERNATIVER FOR STATISTIKKGRAFER~<br /><br />Velg det geografiske området du vil se på kartet. Du kan velge:<div style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;&nbsp;viser alle kontinenter.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;&nbsp;viser Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;&nbsp;viser Sør-Amerika.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;&nbsp;viser Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;&nbsp;viser Midtøsten.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;&nbsp;viser Afrika.</div>";

//-- Find Media Help
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br /><br />På denne siden kan du enkelt administrere mediefiler og mapper.<br /><br />Når du oppretter nye mediemapper, vil PhpGedView sørge for at den samme mappestrukturen opprettholdes i <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b mappe. Når du laster opp nye mediefiler, kan PhpGedView automatisk lage miniatyrbildene for deg.<br /><br />Ved siden av hvert bilde i medielisten finner du følgende alternativer. Alternativene som faktisk vises avhenger av gjeldende status for mediefilen.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;&nbsp;Når du klikker på dette alternativet, ser du en side der du kan endre tittelen på Media-objektet. Hvis Media-objektet ennå ikke er knyttet til en person, familie eller kilde i den aktive databasen, kan du opprette denne lenken her. Du kan gi nytt navn til filen eller til og med endre plasseringen i <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mappestruktur. Når det er nødvendig, oppretter PhpGedView automatisk de nødvendige undermappene eller eventuelle manglende miniatyrbilder.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet er bare tilgjengelig når administratoren har aktivert det. Du kan se eller redigere de rå GEDCOM-dataene som er tilknyttet dette Media-objektet. Du bør være veldig forsiktig når du bruker dette alternativet.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet lar deg slette all kunnskap om mediefilen fra gjeldende database. Andre databaser blir ikke berørt. Hvis denne mediefilen ikke er nevnt i noen annen database, blir den og den tilhørende miniatyrbildet slettet.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet lar deg slette all kunnskap om mediefilen fra gjeldende database. Andre databaser blir ikke berørt. Mediefilen og tilhørende miniatyrbilde blir ikke slettet.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet lar deg fjerne alle lenker til medieobjektet fra gjeldende database. Filen vil ikke bli slettet, og Media-objektet som denne filen er kjent for i den gjeldende databasen, blir beholdt. Andre databaser blir ikke berørt.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;&nbsp;Dette alternativet lar deg etablere koblinger mellom mediefilen og personer, familier eller kilder til den gjeldende databasen. Når det er nødvendig, vil PhpGedView også opprette Media-objektet som Media-filen er kjent for i databasen.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;&nbsp;Når du velger dette alternativet, vil PhpGedView opprette den manglende miniatyrbildet.</li></ul>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Enkelt søkefilter basert på de angitte tegnene, ingen jokertegn godtas.";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Miniatyrbilder vil vises dersom du merker av dette valget.";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Her har du muligheten til å søke i mappestrukturen for å finne media-filen som du ønsker å gjøre en kobling til.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Hvert medieelement skal være tilknyttet en eller flere person-, familie- eller kildeposter i databasen din.<br /><br />For å opprette en slik lenke, kan du skrive inn eller søke etter IDen til personen, familien eller kilden samtidig som du oppretter medieelementet. Du kan også opprette lenken senere ved å redigere alternativer på siden Administrer MultiMedia, eller ved å legge til medieelementer via lenken Legg til media som er tilgjengelig på sidene som viser person-, familie- eller kildedetaljer.";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />Mediefilen du laster opp kan være, og sannsynligvis burde være, navngitt på serveren enn den er på din lokale computer. Dette er fordi ofte det lokale filnavnet har betydning for deg, men er mye mindre meningsfullt for andre som besøker dette nettstedet. Tenk også på muligheten for at du og noen andre begge prøver å laste opp forskjellige filer kalt \"bestemor.jpg\".<br /><br />I dette feltet angir du det nye navnet på filen du laster opp. Navnet du skriver inn her, vil også bli brukt til å navngi miniatyrbildet, som kan lastes opp separat eller genereres automatisk. Du trenger ikke å skrive inn filtypen (jpg, gif, pdf, doc, etc.)<br /><br />La dette feltet være tomt for å beholde det opprinnelige navnet på filen du har lastet opp fra din lokale computer.";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratoren har aktivert opptil #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer under standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Dette hjelper til med å organisere mediefilene og reduserer muligheten for navncollisions.<br /><br />I dette feltet angir du målmappen der den opplastede mediefilen skal lagres. Den matchende miniatyrfilen, enten lastet opp separat eller generert automatisk, lagres i en lignende mappestruktur fra og med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> i stedet for <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Du trenger ikke å angi <b>#GLOBALS[MEDIA_DIRECTORY]#</b> delen av navnet på destinasjonsmappen.<br /><br />Hvis du ikke er sikker på hva du skal skrive inn her, bør du kontakte nettstedsadministratoren din for å få råd.";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratoren har aktivert opptil #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer under standard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Dette bidrar til å organisere mediefilene og reduserer muligheten for navnekollisjoner.<br /><br />I dette feltet velger du mediemappen som du vil vise innholdet til. Når du velger <b>#pgv_lang[all]#</b>, vil alle mediefiler vises uten hensyn til mappen der de er lagret. Dette kan gi en veldig lang liste over medieelementer.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En liste med oppbevaringssteder eller arkivat blir vist på denne siden.<br /><br />Navnene er vist i alfabetisk rekkefølge.<br /><br /><b>OPPBEVARINGSSTED</b><br />Uten oppbevaringssteder for kilder kan kan vi ikke lage slektsbasen vår. Det er en kilde for all informasjon lagret her, og kildene oppbevares på et oppbevaringssted. Oppbevaringssteder kan være en person, arkivet til en person, en institusjon, en offentlig database, et offentlig eller kirkelig arkiv, en Internett-kilde, osv. For å få tilgang til en kilde så ønsker vi å vite hvor og på hvilket sted den befinner seg. All nødvendig informasjon for å finne en kilde bør lagres i en liste over oppbevaringssteder.<br /><br />Et oppbevaringssted kan knyttes mot mange kilder.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Detaljer om oppbevaringsstedet blir vist her. Sammen med kilder, er informasjon om oppbevaringsstedene veldig viktig for slektsforskere.  Ved å ha nøyaktig informasjon om kilder og oppbevaringsteder, kan du følge sporene andre slektsforskere brukte for å finne informasjonen.  Du bør kunne finne den samme informasjonen igjen.<br /><br />På denne siden vil du forhåpentligvis kunne se informasjon om navnet på oppbevaringsstedet, adresse, epost og internettside.<br /><br />Etter informasjonen om oppbevaringsstedet, vil du se en liste med alle kilder som er knyttet til dette oppbevaringsstedet. Det gir deg muligheten til å se all informasjon som er funnet på dette bestemte oppbevaringsstedet.<br /><br />Du vil også ha to eller flere meny-valg på denne siden dersom administratoren til nettstedet har aktivert dette:<ul><li><b>#pgv_lang[view_gedcom]#</b>, som viser informasjonen i GEDCOM-format.</li><li><b>#pgv_lang[add_to_cart]#</b>, som gjør det mulig å kopiere informasjonen til #pgv_lang[clip_cart]# ditt. Herfra kan du hente ned (download) informasjonen i GEDCOM fil-format og import den inn i slektsprogrammet ditt på din lokale maskin.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Når du klikke på dette valget, så merker du dette oppbevaringsstedet for å bli slettet i slektsbasen.<br /><br />Hva betyr dette? Tenk deg at du har en god grunn for å fjerne dette oppbevaringsstedet fra slektsbasen. Du klikke på valget for å slette.  Du vil nå bli spurt om du virkelig ønsker å slette den. Dersom du viser listen med oppbevaringssteder på nytt, vil du se at oppbevaringsstedet fortsatt blir vist og kan bli brukt som om den ikke var slettet.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Når du klikke på dette valget,vil informasjon om oppbevaringsstedet, slik det er lagret i slektsbasen, bli vist i et eget vindu.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Når du klikke på dette valget kan du kopiere informasjonen om oppbevaringsstedet, slik det er lagret i slektsbasen, til #pgv_lang[clip_cart]# ditt.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />I denne listen kan du se navnene på oppbevaringsstedene slik de er lagret i slektsbasen. Navnene vises i alfabetisk rekkefølge.<br /><br />Dersom du klikke på et navn i listen, vil du gå til siden #pgv_lang[repo_info]# der du vil se en ny liste med kilder som er knyttet til oppbevaringsstedet.";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />I denne listen kan du se navnene på de kildene som er knyttet til oppbevaringsstedet. Navnene er vist i alfabetisk rekkefølge.<br /><br />Når du klikke på et navn i listen, vil du gå til siden med detaljer for den valgte kilden.";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Flytt listeoppføringer~<br /><br />Bruk disse knappene til å omorganisere rekkefølgen på oppføringene i listen. Blokkene skrives ut i den rekkefølgen de er oppført.<br /><br />Merk oppføringen som skal flyttes, og klikk deretter på en knapp for å flytte oppføringen opp eller ned.";
$pgv_lang["block_move_right_help"]		= "~Flytt listeoppføringer~<br /><br />Bruk disse knappene til å flytte en oppføring fra en liste til en annen.<br /><br />Marker oppføringen som skal flyttes, og klikk deretter på en knapp for å flytte eller kopiere oppføringen i pilens retning. Bruk knappene <b>»</b> og <b>«</b> for å flytte den uthevede oppføringen fra lengst til venstre til listen lengst til høyre eller omvendt. Bruk knappene <b>&gt;</b> og <b>&lt;</b> for å flytte den uthevede oppføringen mellom #pgv_lang[available_blocks]# listen og listen til høyre eller venstre.<br /><br />Oppføringene i #pgv_lang[available_blocks]# listen endres ikke, uavhengig av hva du gjør med knappene #pgv_lang[move_right]# og #pgv_lang[move_left]#. Dette er fordi den samme blokken kan vises flere ganger på samme side. HTML-blokken er et godt eksempel på hvorfor du kanskje vil gjøre dette.";
$pgv_lang["block_default_index"]	= "~Standard blokker for #pgv_lang[welcome]#~<br /><br />Dersom du fjerner alle blokkene fra listene #pgv_lang[main_section]# og #pgv_lang[right_section]# eller klikke på knappen <b>#pgv_lang[reset_default_blocks]#</b>, vil standard oppsett bli brukt:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]	= "~Standard blokker for #pgv_lang[mygedview]# page~<br /><br />Dersom du fjerner alle blokkene fra listene #pgv_lang[main_section]# og #pgv_lang[right_section]# eller klikke på knappen <b>#pgv_lang[reset_default_blocks]#</b>, vil standard oppsett bli brukt:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"] = "~ofte stilte spørsmål~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "FAQ-siden (ofte stilte spørsmål) kan inneholde en oversikt eller en liste med spørsmål og svar om bruken av dette slektssiden.<br /><br />Bruken som FAQ-siden brukes til, er helt opp til nettstedsadministratoren. Nettstedsadministratoren kontrollerer innholdet på hvert element og også rekkefølgen elementene vises på siden.";

// Help search
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Du kan søke i PhpGedViews hjelpesystem. Funksjonen #pgv_lang[hs_title]# gir deg en høy grad av kontroll over måten søket fungerer på; du burde lett kunne finne det du leter etter.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br /><br />Du skriver inn ordene eller uttrykket du ønsker å finne.<br /><br />Søket tar ikke hensyn til saken (øvre eller nedre) av søkeordene eller teksten som undersøkes. Dette betyr at hvis du søker etter <b>person</b>, vil du finne tekst som inneholder <b>person</b>, <b>Person</b> eller <b>PERSON</b>. Du finner også tekst som inneholder <b>personer</b> osv. siden søket leter etter sekvenser av tegn i stedet for ord.<br /><br />Du kan la søket lete etter flere ord samtidig. Skriv inn alle ordene, og skille hver av dem med et mellomrom, slik: <b>person&nbsp;familie&nbsp;barn</b>. Når mer enn ett ord skrives inn, blir betydningen av det du har skrevet, tydeliggjort i feltet #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Du bestemmer omfanget av søket her.<br /><br />Administratorer kan velge å søke i brukerhjelp eller konfigurasjonshjelp eller begge deler. Brukere har ikke dette valget; fordi de ikke har tilgang til noen konfigurasjonsfunksjoner, kan de bare søke i brukerhjelpfilen.<br /><br />Hjelpefilene inneholder ikke bare hjelpetekst, men også visse tekststrenger som brukes til å lage inndatasskjemaer og annet materiale. Dette alternativet lar deg kontrollere om hele hjelpefilen skal undersøkes, eller om bare hjelpeteksten skal sees på.";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br /><br />Du avklarer betydningen av det du har lagt inn i feltet #pgv_lang[hs_keyword]# ved å velge blant mulighetene som presenteres her.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Hvis du har angitt <b>person&nbsp;familie&nbsp;barn</b>, vil dette alternativet finne hjelpetekst som inneholder et av ordene som er oppført. Ordrenes rekkefølge spiller ingen rolle. Betydningen av søket er: \"Finn hjelpetekst som inneholder ordene <b>person</b> <u>eller</u> <b>familie</b> <u>eller</u> <b>barn</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Hvis du har angitt <b>person&nbsp;familie&nbsp;barn</b>, vil dette alternativet finne hjelpetekst som inneholder alle ordene som er oppført. Ordrenes rekkefølge spiller ingen rolle. Betydningen av søket er: \"Finn hjelpetekst som inneholder ordene <b>person</b> <u>og</u> <b>familie</b> <u>og</u> <b>barn</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Hvis du har skrevet inn <b>person&nbsp;familie&nbsp;barn</b>, vil dette alternativet finne hjelpetekst som inneholder alle ordene som er oppført i den angitte rekkefølgen. Betydningen av søket er: \"Finn hjelpetekst som inneholder ordene <b>person&nbsp;familie&nbsp;barn</b> i nøyaktig den rekkefølgen uten andre ord eller tegn mellom\". Du finner sannsynligvis ikke denne spesielle setningen i noen hjelpetekst.</dd></dl><br />Det er noen få begrensninger for denne typen søk. Enkelte spesialtegn som <b>&quot; &lt; &gt;</b> etc. er inneholdt i hjelpeteksten i symbolsk form og vil ikke bli funnet hvis de utgjør en del av teksten du skriver inn. Enkelte hjelpetekster inneholder en spesiell type mellomromstegn representert med <b>&amp;nbsp;</b>, og du finner ikke setninger som inneholder dette tegnet.";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Dette verktøyet kan hjelpe nettstedsadministratorer med å rydde opp i filer i Indeks-katalogen.<br /><br />Hvis de eies av brukeren av webserveren, kan det hende du ikke kan slette dem. Dette verktøyet lar deg slette disse filene, selv når de eies av webserverens brukerkonto.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

// Various quotes -- The actual text is in help_text.en.php
//$pgv_lang["quote_gedcom"]						= "";
//$pgv_lang["quote_gramps"]						= "";
?>
