<?php
/**
 * Polish texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Łukasz Wileński <wooc@users.sourceforge.net>
 * @author Tomasz Babczyński <tomasz.babczynski@gmail.com>
 * @translations by Google Translate (verified by natives)
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.pl.php 7378 2024-11-02 14:25:09Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["useradmin_comment_help"]				= "~#pgv_lang[comment]#~<br /><br />Wpisany tutaj tekst zostanie wyświetlony, gdy wskaźnik myszy najedzie na ikonę Tekst na liście użytkowników. Postaraj się, aby ten tekst był jak najkrótszy.";
$pgv_lang["useradmin_comment_exp_help"]			= "~#pgv_lang[comment_exp]#~<br /><br />Wprowadź datę, po której rekord tego użytkownika powinien być traktowany jako wymagający wglądu przez Administratora. Te rekordy są wyróżnione na liście użytkowników, wyświetlając nazwę użytkownika w kolorze <span class='warning'>czerwonym</span>.<br /><br />Data musi być wpisana w języku angielskim. Przykłady: <b>31&nbsp;DEC&nbsp;2020</b> ; <b>31&nbsp;december&nbsp;2020</b> ; <b>2020.12.31</b> ; <b>31-12-2020</b> ; <b>12/31/2020</b> itd.<br /><br />Gdy numer miesiąca i numer dnia mieszczą się w zakresie od 1 do 12, interpunkcja (myślnik lub ukośnik) określa znaczenie, z myślnikiem <b>-</b> oznaczającym, że pierwsza liczba to dzień miesiąca, a ukośnik <b>/</b> oznacza, że pierwsza liczba to miesiąc.<br /><br / >Jeśli wprowadzone tutaj informacje są bez znaczenia dla programu, zostanie użyte «yesterday» (wczoraj) i ten rekord użytkownika będzie zawsze zaznaczany do podświetlenia. «tomorrow» (jutro) i podobne teksty nie mają znaczenia w tym kontekście i spowodują, że ten rekord użytkownika nigdy nie zostanie wybrany do wyróżnienia.";
$pgv_lang["file_type_help"]						= "~#pgv_lang[choose_file_type]#~<br /><br />Wybierz format pliku, do którego chcesz wyeksportować bazę danych. Twój wybór powinien zależeć od wymagań programu, w którym zamierzasz używać wyeksportowanej bazy. Możesz wybrać:<ul><li>#pgv_lang[def_gedcom_help]#</li><br /><br /><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Gdy ta opcja jest zaznaczona, wyjściowy plik zostanie skontrolowany pod względem ustawionych opcji prywatności. Może to spowodować usunięcie niektórych informacji. Plik wyjściowy będzie zawierał tylko te informacje, które są zazwyczaj widoczne dla użytkowników ze wskazanym poziomem uprawnień.<br /><br />Jeśli posiadasz tylko uprawnienia #pgv_lang[gedadmin]#, nie możesz wybrać poziomu uprawnień #pgv_lang[siteadmin]#.";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Ta opcja określa stałą ścieżkę dostępu do wszystkich multimediów w pliku wyjściowym.<br /><br />Na przykład, jeśli katalog multimediów jest skonfigurowany jako \"/media\" oraz jeśli plik multimedialny, których chcesz wyeksportować ma ścieżkę dostępu \"/media/obrazy/xyz.jpg\" i jeśli wprowadzisz \"c:\\moje obrazy\\moja rodzina\" w to pole, wynikową ścieżką dostępu będzie \"c:\\moje obrazy\\moja rodzina/obrazy/xyz.jpg\".<br /><br />Można zauważyć na tym przykładzie, że:<ul><li>obecna nazwa katalogu multimediów jest usuwana ze ścieżki dostępu</li><li>wynikowa ścieżka dostępu nie ma prawidłowych separatorów nazw folderów.</li></ul><br />Jeśli chcesz zachować katalog multimediów w ścieżkach dostępu wynikowego pliku, należy dołączyć jego nazwę w polu <b>#pgv_lang[convertPath]#</b>.<br /><br />Powinno się również użyć opcji <b>#pgv_lang[convertSlashes]#</b> w celu zagwarantowania, że separatory nazw folderów są spójne i zgadzają się z wymaganiami systemu operacyjnego, na którym będzie używany plik wynikowy.<br /><br />Ścieżki dostępu multimedów zawierające adresy URL nie zostaną zmienione.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Ta opcja określa czy nazwy folderów określone w specyfikacji FILE multimediów powinny być oddzielone przez '/' lub '\\'. Wybór powinien zależeć od wymagań systemu operacyjnego, na jakim będzie używany plik wynikowy.<br /><br /><b>#pgv_lang[forwardSlashes]#</b> są odpowiednie dla większości systemów operacyjnych z wyjątkiem systemu Microsoft Windows. <b>#pgv_lang[backSlashes]#</b> powinno się wybrać, jeśli plik wynikowy będzie używany w systemie operacyjnym Microsoft Windows.<br /><br />Ścieżki dostępu multimedów zawierające adresy URL nie zostaną zmienione.";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br /><br />Gdy jest wybrana ta opcja, #pgv_lang[multi_title]# wyświetli nie tylko pliki znajdujące się w wybranym katalogu z listy w polu #pgv_lang[filter]#, ale równiez ze wszystkich jego podkatalogów. Gdy ta opcje nie zostanie wybrana, zostanie wyświetlona tylko zawartość wybranego katalogu.<br /><br />Tytuły wszystkich plików multimedialnych są poddawane badaniu w celu ustalenia, czy zawierają one tekst wpisany w polu #pgv_lang[filter]#. Wynik tych dwóch działań określa obiekty multimedialne, które mają być wyświetlone.";
$pgv_lang["medialist_unlinked_help"]			= "~#pgv_lang[medialist_unlinked]#~<br /><br />Zostaną pokazane tylko media, które nie są połączone z żadnym rekordem GEDCOM.";
$pgv_lang["medialist_current_dir_help"]			= "~#pgv_lang[medialist_current_dir]#~<br /><br />Wybierz podfolder multimediów, który chcesz wyświetlić.";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br /><br />Wybierz kolejność, w jakiej chcesz zobaczyć listę multimediów.";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br /><br />Użyj Interaktywnego Drzewa, aby zobaczyć drzewo rodowe rodziny z obu stron. Widok drzewa jest podobny do Diagramu klepsydrowego w pokazywaniu potomków i przodków danej osoby. Ten wykres daje bardziej zwarte informacje, pokazując ramki małżonków lub rodzin zamiast pojedynczych osób.<br /><ul><li><b>Przewijanie</b><br />Gdy kursor myszki zmieni ikonkę, możesz kliknąć i przeciągnąć drzewo, by zobaczyć inne jego części. Jak będziesz przesuwać drzewo, kolejne pokolenia będą się automatycznie wyświetlać, dopóki nie zostanie wyświetlone ostatnie pokolenie w danym kierunku.<br /></li><li><b>Powiększanie</b><br />Możesz użyć ikonek znajdujących się po lewej stronie drzewa do powiększania lub pomniejszania widoku drzewa. Pomniejszenie pozwoli na zobaczenie większej ilości pokoleń na ekranie w tym samym czasie. Przy dużym pomniejszeniu tekst może okazać się trudny do przeczytania; kiedy kursor myszki znajduje się nad ramką wyświetlony zostanie dymek z zawartością ramki.<br /></li><li><b>Wyświetlanie Szczegółów</b><br />Kliknięcie na ramkę spowoduje rozszerzenie się jej i wyświetlenie bardziej szczegółowego widoku. Będąc w tym widoku, kliknięcie imienia i nazwiska osoby spowoduje otwarcie się strony #pgv_lang[indi_info]# danej osoby. Gdy klikniesz <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> zostanie pokazane drzewo z daną osobą jako główną. Gdy klikniesz <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> zostanie otwarta strona z informacjami o danej rodzinie.<br /></li><li><b>Widok Współmałżonka</b><br />Ikona <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> znajdująca się pod przyciskami powiększenia/pomniejszenia powoduje włączenie lub wyłączenie widoku drzewa przodków współmałżonka. Gdy widok jest ustawiony, by pokazywać współmałżonka, wszyscy współmałżonkowie będą wyświetleni w ramce razem z daną osobą. Także wszystkie dzieci danej osoby zostaną wyświetlone. Gdy opcja ta jest wyłączona, tylko ostatni współmałżonek i dzieci z nim zostaną wyświetlone.<br /></li><li><b>Duże Drzewo</b><br />#pgv_lang[interactive_tree]# jest dostępne z kilku różnych stron, włączając zakładkę Drzewo na stronie #pgv_lang[indi_info]# i Sekcję Diagramów na stronie głównej. Gdy przeglądasz drzewo na jednej z tych stron, masz ikonkę Drzewa pod ikonami powiększenia/pomniejszenia. Jeśli klikniesz <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> zostaniesz przeniesiony do strony Interaktywnego Drzewa.</li></ul>";

$pgv_lang["move_mediadirs_help"]				= "~#pgv_lang[move_mediadirs]#~<br /><br />Gdy włączony jest Firewall multimediów, pliki multimedialne mogą być przechowywane w folderze, do którego nie ma dostępu z Internetu.<br /><br />Te przyciski pozwalają w łatwy sposób przenieść multimedia pomiędzy katalogami chronionymi <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> i normalnymi <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["setperms_help"]						= "~#pgv_lang[setperms]#~<br /><br />Ustawia atrybuty katalogów chronionych (bez dostępu z Internetu) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> i normalnych <b>#GLOBALS[MEDIA_DIRECTORY]#</b> na zapis dla wszystkich lub tylko do odczytu.";
$pgv_lang["update_CHAN_text"]					= "Administratorzy czasami muszą wyczyścić i poprawić dane przesłane przez użytkowników. Na przykład mogą potrzebować poprawić lokalizację PLAC, aby uwzględnić kraj. Gdy Administratorzy wprowadzają takie poprawki, informacje o oryginalnej zmianie są zwykle zastępowane. Może to nie być pożądane.<br /><br />Gdy ta opcja zostanie wybrana podczas sesji edycji lub korekty administratora, PhpGedView zachowa oryginalne informacje o zmianach, zamiast zastępować je informacjami z bieżącej sesji.";
$pgv_lang["config_update_CHAN_help"]			= "~#pgv_lang[no_update_CHAN]#~<br /><br />Ta opcja kontroluje początkowy stan pola wyboru «#pgv_lang[no_update_CHAN]#», które jest wyświetlane na każdej stronie, na której Administratorzy mogą wprowadzać zmiany lub poprawki w genealogicznej bazie danych.<br /><br />#pgv_lang[update_CHAN_text]#";
$pgv_lang["no_update_CHAN_help"]				= "~#pgv_lang[no_update_CHAN]#~<br /><br />Administratorzy czasem muszą uporządkować i poprawić dane nadesłane przez użytkowników. Na przykład mogą poprawić miejsce (PLAC) przez wstawienie brakującego kraju. Kiedy administratorzy dokonują takich zmian, informacja o poprzedniej zmianie jest zwykle nadpisywana. Może to być zjawisko niepożądane.<br /><br />Wybranie tej opcji powoduje, że PhpGedView zachowuje informację o oryginalnej zmianie, zamiast nadpisywać ją informacją pochodzącą z bieżącej sesji. Kiedy ta opcja jest wybrana, administratorzy mogą również modyfikować i usuwać informację związaną z oryginalnym znacznikiem zmian (CHAN).";
$pgv_lang["edit_SOUR_EVEN_help"]				= "~#pgv_lang[source_events]#~<br /><br />Każde źródło przechowuje informację o konkretnym wydarzeniu, zwykle w określonym przedziale czasowym i dla określonego obszaru administracyjnego. Na przykład dane w spisach zapisują informację o wydarzeniach, a archiwa kościelne odnotowują urodzenia, śluby i zgony.<br /><br />Wybierz z listy wydarzenia, które są odnotowywane przez to źródło. Data powinna być podana w formacie zakresu, np. <i>OD 1900 DO 1910</i>. Obszar administracyjny to nazwa najmniejszej jednostki administracyjnej, która obejmuje wszystkie miejsca w tym źródle. Na przykład dla wydarzeń mających miejsce w różnych miastach powiatu Siedleckiego obszarem byłaby \"Siedlecki, Mazowieckie, Polska\", zaś \"Mazowieckie, Polska\" byłoby odpowiednim obszarem, jeśli wydarzenia zachodziłyby nie tylko w powiecie Siedleckim, ale także w innych powiatach województwa Mazowieckiego.";
$pgv_lang["cache_life_help"]					= "~#pgv_lang[cache_life]#~<br /><br />Aby poprawić szybkość działania systemu, ten blok strony głównej jest przechowywany w pliku pamięci podręcznej (cache). Możesz decydować, jak często plik cache tego bloku ma być odświeżany.<br /><br /><ul><li><b>-1</b> oznacza, że plik cache nie jest nigdy automatycznie odświeżany. Aby otrzymać nową wersję bloku, musisz usunąć wszystkie pliki cache. Możesz to zrobić na stronie Dostosuj stronę główną.</li><li><b>0</b> (zero) oznacza, że ten blok nie jest nigdy zapisywany w pliku cache i, że za każdym razem, kiedy jest wyświetlana na stronie głównej, pobierana jest jego najnowsza wersja. To ustawienie jest domyślne dla bloków, które zmieniają się często, takich jak #pgv_lang[logged_in_users_block]# czy #pgv_lang[random_media_block]#.</li><li><b>1</b> (jeden) oznacza, że plik cache tego bloku jest odświeżany raz dziennie, <b>2</b> oznacza, że jest odświeżany co dwa dni, <b>7</b> - że co tydzień itd.</li></ul>";
$pgv_lang["clear_cache_help"]					= "~#pgv_lang[clear_cache]#~<br /><br />Aby poprawić wydajność systemu, kilka bloków strony głównej jest przechowywanych w plikach pamięci podręcznej (cache) w katalogu indeksowym. Pliki cache dla większości bloków są odświeżane raz dziennie, ale czasem może zajść potrzeba ich ręcznego odświeżenia.<br /><br />Ten przycisk umożliwia odświeżenie plików cache w razie potrzeby.";
$pgv_lang["import_options_help"]				= "Możesz wybrać dodatkowe opcje dla importowania pliku GEDCOM.";
$pgv_lang["verify_gedcom_help"]					= "Tutaj możesz zdecydować, czy chcesz kontynuować pobieranie i import tego pliku GEDCOM, czy też wolisz je anulować.";
$pgv_lang["add_gedcom_instructions"]			= "Wprowadź nazwę pliku dla nowego pliku GEDCOM. Nowy plik zostanie utworzony w katalogu indeksowym #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]		= "~#pgv_lang[random_media_start_slide]#~<br /><br />Czy pokaz slajdów powinien się rozpocząć automatycznie po wczytaniu strony.<br /><br />Pokaz slajdów zmienia zawartość bloku bez uprzedniego pobierania informacji z serwera i bez przeładowywania całej strony.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Ta opcja pozwala pokazać lub ukryć panel kontrolny pokazu slajdów w bloku Losowe multimedia.<br /><br />Panel kontrolny umożliwia użytkownikowi przeskoczenie do innego losowego obiektu oraz przeglądanie losowych multimediów w formie pokazu slajdów. Pokaz slajdów zmienia zawartość bloku bez uprzedniego pobierania informacji z serwera i bez przeładowywania całej strony.";
$pgv_lang["edit_add_unlinked_source_help"]		= "~#pgv_lang[add_unlinked_source]#~<br /><br />Użyj tego odnośnika, aby dodać nowe źródło do twojej bazy danych bez powiązywania źródła z żadnym wpisem.<br /><br />Nowe źródło pojawi się na liście źródeł, ale nie będzie widoczne na żadnych diagramach ani nigdzie indziej, dopóki nie zostanie powiązane z osobą, rodziną lub wydarzeniem.";
$pgv_lang["edit_add_unlinked_note_help"]		= "~#pgv_lang[add_unlinked_note]#~<br /><br />Użyj tego odnośnika, aby dodać nową wspólną notatkę do twojej bazy danych bez powiązywania notatki z żadnym wpisem.<br /><br />Nowa notatka pojawi się na liście wspólnych notatek, ale nie będzie widoczna na żadnych diagramach ani nigdzie indziej, dopóki nie zostanie powiązana z osobą, rodziną lub wydarzeniem.";
$pgv_lang["link_person_id_help"]				= "~#pgv_lang[label_local_id]#~<br /><br />W to pole wprowadzasz identyfikator osoby, do której się odnosisz (np. I100).";
$pgv_lang["link_gedcom_id_help"]				= "~#pgv_lang[label_gedcom_id]#~<br /><br />Użyj tej sekcji, aby wybrać alternatywny identyfikator bazy danych, zawierający osobę, do której się odnosisz.";
$pgv_lang["link_remote_site_help"]				= "~#pgv_lang[label_site]#~<br /><br />W tej sekcji wyszczególniasz parametry, które są niezbędne do połączenia ze stroną zewnętrzną, na której znajdują się dane, do których chcesz się odwołać. Możesz wybrać stronę z listy znanych stron, których użyto wcześniej, lub wprowadzić #pgv_lang[label_site_url2]# oraz #pgv_lang[label_gedcom_id]# dla nowej strony.<br /><br />W polu <b>#pgv_lang[label_site_url2]#</b> wprowadzasz adres URL umożliwiający dostęp do pliku opisu usług sieciowych (WDSL), który mówi PhpGedView, w jaki sposób uzyskać dostęp do danych na zdalnej stronie. Dla zdalnej strony PhpGedView website adres URL wygląda tak: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />W polu <b>#pgv_lang[label_gedcom_id]#</b> może się znaleźć opcjonalny identyfikator bazy danych dla stron, które tego wymagają. Dla stron PhpGedView jest to nazwa pliku GEDCOM.<br /><br />Pola <b>#pgv_lang[label_username_id]#</b> oraz <b>#pgv_lang[label_password_id]#</b> są koniecznie tylko, jeśli wymaga tego baza danych.<br /><br /><i>Uwaga: zdalne strony PhpGedView muszą mieć wersję 4.0 lub nowszą; starsze wersje nie dają możliwości zdalnego łączenia.</i>";
$pgv_lang["link_remote_location_help"]			= "~#pgv_lang[label_location]#~<br /><br />Ta opcja umożliwia określenie, czy dane osoby, do której się odwołujesz, znajdują się na tej samej stronie w innej genealogicznej bazie danych, czy też są one na zupełnie innej stronie, dostępnej przez Internet.<br /><br />Jeśli osoba znajduje się na tej samej stronie, należy wybrać bazę danych i wprowadzić identyfikator osoby.<br /><br />Dla zdalnej strony należy wprowadzić jej URL, identyfikator bazy danych oraz zdalny identyfikator osoby.";
$pgv_lang["link_remote_rel_help"]				= "~#pgv_lang[label_rel_to_current]#~<br /><br />Ta opcja pozwala określić związek pomiędzy osobą z zewnątrz i osobą, z którą ją łączysz. Na przykład wybranie <i>Ojciec</i> oznacza, że osoba z zewnątrz jest ojcem osoby lokalnej, z którą ją łączysz.";
$pgv_lang["link_remote_help"]					= "~#pgv_lang[link_remote]#~<br /><br />Użyj tego formularza, aby powiązać osoby z innymi ludźmi, których dane znajdują się bądź na innej stronie, bądź w innej bazie genealogicznej, do której ma dostęp twój system PhpGedView.<br /><br />Aby dodać takie powiązanie, musisz najpierw wybrać typ pokrewieństwa, następnie wybrać stronę znaną PhpGedView lub zdefiniować nową, a na koniec podać identyfikator osoby na tej stronie, do której chcesz utworzyć odwołanie. PhpGedView automatycznie pobierze potrzebne informacje ze zdalnej strony. Pobrana informacja <u>nie</u> staje się częścią twojej bazy genealogicznej; pozostaje na stronie oryginalnej, ale jest włączona do różnych stron, na których występuje dołączona osoba.<br /><br />Skorzystaj z odnośnika pomocy obok odpowiedniego elementu, aby uzyskać więcej informacji na jego temat. Możesz także przejrzeć kurs w języku angielskim: <a href=\"http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link</a>.";

//-- Edit Interface
$pgv_lang["edit_REPO_NAME_help"]				= "~#factarray[REPO:NAME]#~<br /><br />Nazwa biblioteki, archiwum lub innego repozytorium, w którym przechowywany jest materiał źródłowy.";
$pgv_lang["edit_REPO_ADDR_help"]				= "~#factarray[REPO:ADDR]#~<br /><br />Adres tej biblioteki, archiwum lub innego repozytorium. Wpisz adres w taki sam sposób, w jaki wpisujesz go na kopercie.<br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać adresu.";
$pgv_lang["edit_REPO_PHON_help"]				= "~#factarray[REPO:PHON]#~<br /><br />Numer telefonu tej biblioteki, archiwum lub innego repozytorium. Wprowadź numer wraz z krajem i numerem kierunkowym. Na przykład numer w Niemczech może wynosić +49 25859 56 76 89, a numer w USA lub Kanadzie może wynosić +1 888 555-1212.<br /><br />Pozostaw to pole puste, jeśli nie chcesz uwzględniać numer telefonu.";
$pgv_lang["edit_REPO_FAX_help"]					= "~#factarray[REPO:FAX]#~<br /><br />Numer faksu tej biblioteki, archiwum lub innego repozytorium. Wprowadź numer wraz z krajem i numerem kierunkowym. Na przykład numer w Niemczech może wynosić +49 25859 56 76 89, a numer w USA lub Kanadzie może wynosić +1 888 555-1212.<br /><br />Pozostaw to pole puste, jeśli nie chcesz uwzględniać numer faksu.";
$pgv_lang["edit_REPO_EMAIL_help"]				= "~#factarray[REPO:EMAIL]#~<br /><br />Adres e-mail tej biblioteki, archiwum lub innego repozytorium. Wpisz adres e-mail. Przykład: <b>name@hotmail.com</b><br /><br />Pozostaw to pole puste, jeśli nie chcesz dołączać adresu e-mail.";
$pgv_lang["edit_REPO_WWW_help"]					= "~#factarray[REPO:WWW]#~<br /><br />Strona domowa w Internecie tej biblioteki, archiwum lub innego repozytorium. Wprowadź adres strony głównej wraz z http:// lub https://. Przykład: <b>https://www.phpgedview.net/</b><br /><br />Pozostaw to pole puste, jeśli nie chcesz dołączać adresu strony głównej.";
$pgv_lang["edit_CALN_help"]						= "~#factarray[CALN]#~<br /><br />Identyfikacja lub opis referencyjny używany do archiwizacji i pobierania pozycji z zasobów biblioteki, archiwum lub innego repozytorium. Repozytoria nieformalne zwykle nie muszą używać systemu #factarray[CALN]#.";
$pgv_lang["edit_REPO_help"]						= "~#factarray[REPO]#~<br /><br />Jest to numer identyfikacyjny biblioteki, archiwum lub innego składu, w którym przechowywany jest przywoływany materiał źródłowy. Tytuł aktualnego archiwum zostanie wyświetlony pod numerem ID.<br /><br />Można zmienić numer ID archiwum, w którym przechowywany jest ten materiał źródłowy. Aby usunąć odniesienie do archiwum, pozostaw to pole puste. Ta akcja nie usuwa rekordu archiwum z bazy danych; usuwane jest tylko to odniesienie.<br /><br />Jeśli wprowadzisz bezpośrednio żądany identyfikator archiwum, ten rekord archiwum musi już istnieć w bazie danych. Możesz kliknąć <b>#pgv_lang[find_repository]#</b>, aby wyszukać numer identyfikacyjny istniejącego archiwum. Kliknij <b>#pgv_lang[create_repository]#</b>, jeśli chcesz wprowadzić nowy rekord archiwum.";
$pgv_lang["edit_PUBL_help"]						= "~#factarray[PUBL]#~<br /><br />Kiedy i gdzie utworzono rekord. W przypadku prac opublikowanych obejmuje to takie informacje, jak miasto wydania, nazwa wydawcy i rok wydania.<br /><br />W przypadku pracy nieopublikowanej powinna zawierać datę utworzenia rekordu oraz miejsce, w którym zostało stworzone. Na przykład powiat i stan zamieszkania osoby składającej oświadczenie o emeryturze lub miasto i stan zamieszkania autora listu, lub prywatna historia rodzinna.";
$pgv_lang["edit_AUTH_help"]						= "~#factarray[AUTH]#~<br /><br />Osoba, agencja lub podmiot, który utworzył rekord. W przypadku opublikowanej pracy może to być autor, kompilator, transkrybent, abstraktor lub redaktor. W przypadku nieopublikowanego źródła może to być osoba fizyczna, agencja rządowa, organizacja kościelna lub organizacja prywatna itp.";
$pgv_lang["edit_REFN_help"]						= "~#factarray[REFN]#~<br /><br />To pole jest zwykle używane do zapisu dowolnego tekstu w celu zidentyfikowania tego rekordu GEDCOM. Na przykład może to być numer pliku w zautomatyzowanym lub ręcznym systemie lub może to być numer strony i pozycji na wykresie rodowodowym.<br /></br />Kiedy konfiguracja GEDCOM została ustawiona tak, aby umożliwić użytkownikowi nadpisanie automatycznie generowanego numeru ID dla nowych osób, w tym miejscu wpisuje się nadrzędny numer ID. W takim przypadku tekst musi być zgodny z zasadami ustalonymi dla numerów identyfikacyjnych. Prawidłowe numery identyfikacyjne mogą zawierać tylko litery od <b>A</b> do <b>Z</b>, od <b>a</b> do <b>z</b>, cyfry <b>0</b> do <b>9</b> oraz symbole specjalne <b>. : -</b> i <b>_</b><br /><br />Opcja umożliwiająca użycie #factarray[REFN]# w miejsce automatycznie generowanego numeru ID znajduje się w konfiguracji GEDCOM, sekcja Opcje edycji.";
$pgv_lang["edit_ABBR_help"]						= "~SKRÓT TYTUŁU~<br /><br />Użyj tego pola do wpisania skróconej wersji tytułu. To poje jest wykorzystywane w połączeniu z polem tytułu w źródłach. Domyślnie PhpGedView użyje napierw tytułu, a następnie skrótu.<br /><br />Według specyfikacji GEDCOM 5.5 \"to pole ma za zadanie zapewnić krótki tytuł, wykorzystywany przy sortowaniu, dodawaniu i odszukiwaniu wpisów źródłowych (str. 62).\"<br /><br />PhpGedView nie wymaga skróconego tytułu, ale w innych aplikacjach genealogicznych jest on wymagany.";
$pgv_lang["edit_ROMN_help"]						= "~ZLATYNIZOWANE~<br /><br />W wielu kulturach zwykle zapisuje się imię i nazwisko za pomocą tradycyjnych znaków, a jego zlatynizowaną wersję tak, jak jest pisana i wymawiana w językach opartych na alfabecie łacińskim, takich jak polski.<br /><br />Jeśli wolisz wpisywać swoje dane, korzystając z alfabetu nie-łacińskiego, takiego jak hebrajski, grecki, rosyjski, chiński czy arabski, możesz użyć tego pola do wprowadzenia tych samych danych za pomocą alfabetu łacińskiego. Na listach i diagramach będą pokazywane obie wersje.<br /><br />Nazwa tego pola nie ogranicza jego zawartości do znaków alfabetu łacińskiego. Może to być przydatne na przykład dla imion japońskich, w których mogą występować aż trzy alfabety.";
$pgv_lang["edit_ROMN_advice"]					= "W wielu kulturach zwyczajowo używa się tradycyjnej nazwy pisanej tradycyjnymi literami, a także zlatynizowanej wersji nazwy tak, jak byłaby pisana lub wymawiana w językach opartych na alfabecie łacińskim, takich jak angielski.<br /><br / >Jeśli wolisz używać alfabetu innego niż łaciński, np. hebrajskiego, greckiego, rosyjskiego, chińskiego lub arabskiego, aby wprowadzić nazwę w standardowe pola nazwy, możesz użyć tego pola, aby wprowadzić tę samą nazwę za pomocą alfabetu łacińskiego. Obie wersje nazwy pojawią się na listach i wykresach.<br /><br />Mimo że to pole jest oznaczone jako \"Romanizowane\", nie ogranicza się ono do zawierania tylko znaków opartych na alfabecie łacińskim. Może to być przydatne w przypadku nazw japońskich, w których mogą występować trzy różne alfabety.";
$pgv_lang["edit_ROMN_GIVN_help"]				= "#pgv_lang[edit_ROMN_help]#<br /><br />W tym polu powinieneś podać imię osoby. Na przykład dla osoby nazywającej się \"Jan Robert Kowalski\", imię, które powinno być wprowadzone tutaj to \"Jan Robert\".";
$pgv_lang["edit_ROMN_SURN_help"]				= "#pgv_lang[edit_ROMN_help]#<br /><br />W tym polu powinieneś podać nazwisko osoby. Na przykład dla osoby nazywającej się \"Jan Robert Kowalski\", imię, które powinno być wprowadzone tutaj to \"Kowalski\".<br /><br />Osoby z kilkoma nazwiskami, popularne w Hiszpanii i Portugalii, powinny mieć oddzielone nazwiska przecinkami. Pozwala to na pokazanie osoby na liście pod każdym z tych nazwisk. Na przykład, nazwisko \"Cortes,Vega\" będzie pokazanie na liście pod literą <b>C</b> oraz literą <b>V</b>, podczas gdy nazwisko \"Cortes Vega\" będzie pokazane tylko pod literą <b>C</b>.";
$pgv_lang["edit__HEB_help"]						= "~HEBRAJSKIE~<br /><br />W wielu kulturach zwykle zapisuje się imię i nazwisko za pomocą tradycyjnych znaków, a jego zlatynizowaną wersję tak, jak jest pisana i wymawiana w językach opartych na alfabecie łacińskim, takich jak polski.<br /><br />Jeśli wolisz wpisywać swoje dane, korzystając z alfabetu łacińskiego, możesz użyć tego pola do wprowadzenia tych samych danych za pomocą alfabetu nie-łacińskiego, takiego jak hebrajski, grecki, rosyjski, chiński czy arabski. Na listach i diagramach będą pokazywane obie wersje.<br /><br />Nazwa tego pola nie ogranicza jego zawartości do znaków alfabetu hebrajskiego.";
$pgv_lang["edit__HEB_advice"]					= "W wielu kulturach zwyczajowo używa się tradycyjnej nazwy pisanej tradycyjnymi literami, a także zlatynizowanej wersji nazwy tak, jak byłaby pisana lub wymawiana w językach opartych na alfabecie łacińskim, takich jak angielski.<br /><br / >Jeśli wolisz używać alfabetu łacińskiego do wprowadzania nazwy w standardowych polach imienia, możesz użyć tego pola, aby wprowadzić tę samą nazwę w alfabecie innym niż łaciński, takim jak grecki, hebrajski, rosyjski, arabski lub chiński. Obie wersje nazwy pojawią się na listach i wykresach.<br /><br />Mimo że to pole jest oznaczone jako \"Hebrajskie\", nie ogranicza się ono do zawierania tylko znaków hebrajskich.";
$pgv_lang["edit__HEB_GIVN_help"]				= "#pgv_lang[edit_ROMN_help]#<br /><br />W tym polu powinieneś podać imię osoby. Na przykład dla osoby nazywającej się \"Jan Robert Kowalski\", imię, które powinno być wprowadzone tutaj to \"Jan Robert\".";
$pgv_lang["edit__HEB_SURN_help"]				= "#pgv_lang[edit_ROMN_help]#<br /><br />W tym polu powinieneś podać nazwisko osoby. Na przykład dla osoby nazywającej się \"Jan Robert Kowalski\", imię, które powinno być wprowadzone tutaj to \"Kowalski\".<br /><br />Osoby z kilkoma nazwiskami, popularne w Hiszpanii i Portugalii, powinny mieć oddzielone nazwiska przecinkami. Pozwala to na pokazanie osoby na liście pod każdym z tych nazwisk. Na przykład, nazwisko \"Cortes,Vega\" będzie pokazanie na liście pod literą <b>C</b> oraz literą <b>V</b>, podczas gdy nazwisko \"Cortes Vega\" będzie pokazane tylko pod literą <b>C</b>.";
$pgv_lang["edit_SEX_help"]						= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]						= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]		= "~#pgv_lang[add_unlinked_person]#~<br /><br />Użyj tego formularza do dodania niepowiązanej osoby.<br /><br />Kiedy dodajesz niepowiązaną osobę do drzewa, osoba ta nie zostanie powiązana z nikim innym, dopóki jej nie powiążesz. Możesz powiązać osoby później za pomocą zakładki #pgv_lang[relatives]# na stronie #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]						= "~#factarray[URL]#~<br /><br />Wprowadź adres URL, zaczynając od http://. Przykład: <b>http://www.phpgedview.net/</b><br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać adresu URL.";
$pgv_lang["edit_WWW_help"]						= "~#factarray[WWW]#~<br /><br />Wprowadź adres strony głównej, zaczynając od http://. Przykład: <b>http://www.phpgedview.net/</b><br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać adresu strony głównej.";
$pgv_lang["edit_EMAIL_help"]					= "~#factarray[EMAIL]#~<br /><br />Wprowadź adres email. Przykład: <b>name@hotmail.com</b><br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać adresu email.";
$pgv_lang["edit_FAX_help"]						= "~#factarray[FAX]#~<br /><br />Wprowadź numer faksu wraz z numerem kierunkowym kraju i regionu. Na przykład numer niemiecki mógłby mieć postać +49 25859 56 76 89, a numer w USA lub Kanadzie: +1 888 555-1212.<br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać numeru faks.";
$pgv_lang["edit_PHON_help"]						= "~#factarray[PHON]#~<br /><br />Wprowadź numer telefonu wraz z numerem kierunkowym kraju i regionu. Na przykład numer niemiecki mógłby mieć postać +49 25859 56 76 89, a numer w USA lub Kanadzie: +1 888 555-1212.<br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać numeru telefonu.";
$pgv_lang["edit_ADDR_help"]						= "~#factarray[ADDR]#~<br /><br />Wprowadź adres korespondencyjny tak samo, jak byłby on podany na kopercie.<br /><br />Pozostaw to pole puste, jeśli nie chcesz podawać adresu.";
$pgv_lang["edit_GIVN_help"]						= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]						= "~Przedrostek nazwiska~<br /><br />Wprowadź lub wybierz z listy słowa, które poprzedzają główną część nazwiska. Przykłady takich słów to <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, itp.";
$pgv_lang["edit_SURN_help"]						= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit__MARNM_help"]					= "~#factarray[_MARNM]#~<br /><br />Wprowadź imię i nazwisko tej osoby po ślubie, formatując je tak samo, jak w polu \"Imię i nazwisko\". To pole nie jest obowiązkowe.<br /><br />Na przykład, jeśli Anna Blanka Bułka poślubiła Stefana Suchara, wprowadzasz (oczywiście bez cudzysłowów)<ul><li>Konwencja amerykańska:&nbsp;&nbsp;\"Anna Blanka Bułka /Suchar/\"</li><li>Konwencja europejska:&nbsp;&nbsp;\"Anna Blanka /Suchar/\"</li><li>Inna konwencja europejska:&nbsp;&nbsp;\"Anna Blanka /Bułka-Suchar/\" lub \"Anna Blanka /Bułka-Suchar/\"</li></ul>Należy wypełniać to pole wyłącznie wtedy, kiedy Anna Bułka zaczęła rzeczywiście używać po ślubie nazwiska męża. Gdzieniegdzie, na przykład w Quebec (Kanada), zmienianie nazwiska w ten sposób jest niezgodne z prawem.<br /><br />Mężczyźni mogą również zmienić nazwisko po ślubie, przeważnie łącząc nazwiska myślnikiem, ale czasem przyjmują także nazwisko żony.";
$pgv_lang["edit_PEDI_help"]						= "~#factarray[PEDI]#~<br /><br />To pole opisuje związek między dzieckiem a jego rodziną. Możliwe typy związków to: <ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Związek dziecka z rodziną nie jest ustalony. Wybranie tej opcji powoduje, że pole #factarray[PEDI]# nie jest umieszczane w bazie danych.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Ta opcja wskazuje, że dziecko jest powiązane z rodziną przez urodzenie.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Ta opcja wskazuje, że dziecko zostało zaadoptowane przez rodzinę. Ten fakt <i>nie wyklucza</i> istnienia więzi krwi między dzieckiem a rodziną; mówi tylko, że dziecko zostało zaadoptowane jakiś czas po urodzeniu.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Ta opcja wskazuje, że dziecko jest przybranym dzieckiem w rodzinie. Zwykle nie ma więzi krwi między przybranym dzieckiem, a jego rodziną.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Dziecko zostało przyjęte do rodziny podczas mormońskiej ceremonii <i>naznaczenia</i>. Naznaczenie dziecka ma miejsce, gdy rodzice zostali naznaczeni jako małżonkowie po narodzinach dziecka. Dzieci urodzone po naznaczeniu rodziców są automatycznie przyjęte do rodziny.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]						= "~#factarray[AGNC]#~<br /><br />Gdy to pole opisuje Wykształcenie, należy podać nazwę szkoły lub uczelni. W przypadku opisu Zawodu jest to nazwa miejsca lub zakładu pracy. Natomiast w przypadku Święceń należy podać nazwę Seminarium duchownego lub innej instytucji wyświęcającej. W innych przypadkach należy podać nazwę organizacji, agencji, korporacji, osoby lub innej jednostki mającej znaczenie.";
$pgv_lang["edit_MARR_TYPE_help"]	= "~#factarray[MARR]#: #factarray[TYPE]#~<br /><br />To pole opisuje rodzaj związku, na podstawie którego powstała rodzina.<ul><li><b>#factarray[MARR_RELIGIOUS]#</b>&nbsp;&nbsp;&nbsp;oznacza, że ceremonia, która sformalizowała ten związek dwojga ludzi tworząc rodzinę była celebrowana przez księdza, biskupa, kardynała, pastora, rabina, szamana, itp. Ceremonia niekoniecznie musiała odbywać się w kościele, synagodze, świątyni czy innym miejscu konsekrowanym. Mogła mieć miejsce na zewnątrz lub w prywatnym domu.</li><li><b>#factarray[MARR_CIVIL]#</b>&nbsp;&nbsp;&nbsp;oznacza, że ceremonia, która formalizowała związek dwóch osób w celu założenia rodziny, została przeprowadzona przez sędziego, urzędnika państwowego, burmistrza lub podobną osobę posiadającą władzę, która nie jest księdzem itp. Uprawnienia do przewodniczenia tego typu ceremoniom zwykle nadawane są przez rząd. Ceremonia niekoniecznie musi odbywać się w Urzędzie Stanu Cywilnego czy Ratuszu.</li><li><b>#factarray[MARR_PARTNERS]#</b>&nbsp;&nbsp;&nbsp;opisuje relację dwojga ludzi, nie będących swoimi małżonkami, którzy uważają się za rodzinę. <u>Nie</u> brali ślubu przed księdzem, biskupem, urzędnikiem ani inną osobą uprawnioną do przewodniczenia ceremonii ślubnej. Mogli złożyć publiczną deklarację, że chcą być razem i uważają się za małżeństwo, ale nie jest to konieczne.</li><li><b>#factarray[MARR_UNKNOWN]#</b>&nbsp;&nbsp;&nbsp;oznacza, że szczegóły związku dwojga ludzi nie są znane.</li></ul>";

$pgv_lang["context_help"]						= "Więcej pomocy można uzyskać klikając na znak zapytania <b>?</b> obok elementu na stronie.";

$pgv_lang["register_gedcomid_help"]				= "~#pgv_lang[gedcomid]#~<br /><br />Każda osoba w bazie danych na tej stronie ma swój unikalny numer identyfikatora. Jeśli znasz swój identyfikator, wprowadź go tutaj. Jeśli go nie znasz lub nie możesz go ustalić ze względów ustawień prywatności, wpisz odpowiednią ilość informacji w pole \"Komentarz\", tak, aby administrator mógł cię odnaleźć w drzewie i ustawić twój identyfikator.";
$pgv_lang["register_comments_help"]				= "~#pgv_lang[comments]#~<br /><br />Użyj tego pola, aby poinformować administratora, dlaczego chcesz założyć konto i jakie masz powiązania z genealogią udostępnioną na tej stronie. Możesz także wprowadzić tu dowolny komentarz dla administratora.";
$pgv_lang["utf8_ansi_help"]						= "~PRZEKONWERTUJ Z UTF-8 DO ANSI~<br /><br />PhpGedView korzysta ze standardu kodowania UTF-8, który zapewnia poprawne kodowanie stron internetowych. Niektóre aplikacje, takie jak Family Tree Maker, nie obsługują importowania plików GEDCOM zakodowanych w UTF-8. Zaznaczenie tej opcji spowoduje przekonwertowanie pliku z <b>UTF-8</b> do <b>ANSI (ISO 8859-1)</b>.<br /><br />Format, którego potrzebujesz, zależy od aplikacji, której chcesz używać do pracy z pobranym plikiem GEDCOM. Jeśli nie wiesz, co wybrać, zajrzyj do dokumentacji swojej aplikacji.<br /><br />Pamiętaj, że aby korzystać ze znaków specjalnych, musisz pozostawić plik w formacie UTF-8 i w inny sposób przekonwertować go do sposobu, w jaki twoja aplikacja może obsłużyć te znaki. Skontaktuj się z producentem lub autorem twojej aplikacji.<br /><br />Ten <a href='http://pl.wikipedia.org/wiki/UTF-8' target='_blank' title='Artykuł w Wikipedii na temat UTF-8'><b>artykuł w Wikipedii</b></a> zawiera kompleksowe informacje i odnośniki na temat standardu UTF-8.";
$pgv_lang["remove_tags_help"]					= "~USUŃ ZNACZNIKI PhpGedView~<br /><br />Zaznaczenie tej opcji spowoduje usunięcie wszystkich znaczników dodanych do wpisów przez PhpGedView.<br /><br />Własne znaczniki stosowane przez PhpGedView to na przykład <b>_PGVU</b>, który identyfikuje użytkownika, który edytował dany wpis online, oraz <b>_THUM</b>, który informuje PhpGedView, że ten obrazek ma być użyty do miniaturki.<br /><br />Własne znaczniki PhpGedView mogą powodować błędy przy importowaniu pobranego pliku GEDCOM do innej aplikacji genealogicznej.";
$pgv_lang["download_zipped_help"]				= "~POBIERZ GEDCOM SPAKOWANY ZIPEM~<br /><br />Zaznaczenie tej opcji spowoduje utworzenie kopii pliku GEDCOM, która zostanie skompresowana do pliku ZIP przed rozpoczęciem pobierania. Dzięki temu znacznie zmniejszy się jego wielkość, ale zanim będzie można z niego korzystać, trzeba go będzie rozpakować za pomocą odpowiedniego programu (np. WinZIP).<br /><br />Ta opcja przydaje się w przypadku dużych plików GEDCOM. Istnieje ryzyko, że czas pobierania nieskompresowanego pliku może przekroczyć limit czasu wykonywania, przez co pobrane pliki będą niekompletne. Zastosowanie opcji ZIP powinno zmniejszyć czas pobierania o 75%.";
$pgv_lang["edit_NCHI_help"]						= "~#factarray[NCHI]#~<br /><br />Wprowadź liczbę dzieci dla danej osoby lub rodziny. To pole nie jest obowiązkowe.";
$pgv_lang["edit_TIME_help"]						= "~#factarray[TIME]#~<br /><br />Wprowadź godzinę wydarzenia w formacie 24-godzinnym, poprzedzając wartości mniejsze od 10 zerem. Północ to godzina 00:00. Przykłady: 04:50, 13:00, 20:30.";
$pgv_lang["edit_NOTE_help"]						= "~#factarray[NOTE]#~<br /><br />Notatki są tekstem w dowolnej formie, który pojawi się w sekcji \"Szczegóły faktu\".";
$pgv_lang["edit_SHARED_NOTE_help"]				= "~#pgv_lang[shared_note]#~<br /><br />Wspólne notatki są tekstem w dowolnej formie, który pojawi się w sekcji \"Szczegóły faktu\".<br /><br />Każda wspólna notatka może być połączona z więcej niż jedną osobą, rodziną, więcej niż jednym źródłem lub wydarzeniem.";
$pgv_lang["edit_CEME_help"]						= "~#factarray[CEME]#~<br /><br />Wprowadź nazwę cmentarza lub innego miejsca spoczynku, w którym pochowana jest dana osoba.";
$pgv_lang["edit_ASSO_help"]						= "~#factarray[ASSO]#~<br /><br />Wprowadź identyfikator GEDCOM osoby powiązanej.";
$pgv_lang["edit_RELA_help"]						= "~#factarray[RELA]#~<br /><br />Wybierz z listy nazwę związku. Wybranie <b>Ojciec chrzestny</b> oznacza: <i>Ta osoba powiązana jest ojcem chrzestnym bieżącej osoby</i>.";
$pgv_lang["show_spouse_help"]					= "~#pgv_lang[show_spouses]#~<br /><br />Domyślnie ten diagram nie wyświetla małżonków potomków, ponieważ utrudnia to jego odczytanie i zrozumienie. Włączenie tej opcji spowoduje pokazanie małżonków na diagramie.";
$pgv_lang["reorder_families_help"]				= "~#pgv_lang[reorder_families]#~<br /><br />Na zakładce #pgv_lang[relatives]# rodziny są wyświetlane w kolejności, w jakiej znajdują się we wpisie GEDCOM danej osoby. Rodziny nie są posortowane po dacie ślubu, ponieważ data ślubu jest nieznana, jednak często ich kolejność <u>jest</u> znana.<br /><br />Ta opcja umożliwia zmianę kolejności, w jakiej rodziny są wyświetlane na zakładce #pgv_lang[relatives]#. Jeśli chcesz posortować rodziny według ich dat ślubu, masz do tego odpowiedni przycisk.";
$pgv_lang["autoContinue_help"]					= "~#pgv_lang[autoContinue]#~<br /><br />Gdy PhpGedView wykryje, że importowanie pliku GEDCOM potrzebuje więcej czasu niż jest ustawione wyświetli przycisk <b>#pgv_lang[del_proceed]#</b>, który trzeba przycisnąc, by kontynuować import.<br /><br />Gdy opcja ta jest ustawiona na <b>#pgv_lang[yes]#</b>, PhpGedView automatycznie przyciśnie ten przycisk <b>#pgv_lang[del_proceed]#</b> za Ciebie. Ta opcja wyręcza z nudnego wciskania przycisków przy importowaniu dużych plików.";
$pgv_lang["firstname_i_help"]					= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Wybrane nazwisko nosi ponad #GLOBALS[SUBLIST_TRIGGER_I]# osób.<br /><br />Aby ułatwić odnalezienie szukanej osoby, lista została podzielona na mniejsze listy według pierwszej litery imienia. Ten spis alfabetyczny działa tak samo, jak alfabetyczny spis nazwisk.<br /><ul><li>Kliknij na odpowiednią literę, aby zobaczyć wszystkie imiona, rozpoczynające się od tej litery.</li><li>Wybierz <b>#pgv_lang[NN]#</b> aby wyświetlić wszystkie osoby o nieznanym imieniu.</li><li>Wybranie <b>#pgv_lang[all]#</b> spowoduje wyświetlenie listy wszystkich osób o wybranym nazwisku.</li></ul>Wyświetlenie listy na ekranie może zająć sporo czasu ze względu na dużą liczbę nazwisk.";
$pgv_lang["firstname_f_help"]					= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Wybrane nazwisko nosi ponad #GLOBALS[SUBLIST_TRIGGER_I]# osób.<br /><br />Aby ułatwić odnalezienie szukanej rodziny, lista została podzielona na mniejsze listy według pierwszej litery imienia. Ten spis alfabetyczny działa tak samo, jak alfabetyczny spis nazwisk.<br /><ul><li>Kliknij na odpowiednią literę, aby zobaczyć wszystkie imiona, rozpoczynające się na tą literę.</li><li>Wybierz <b>#pgv_lang[NN]#</b> aby wyświetlić wszystkie osoby o nieznanym imieniu.</li><li>Wybranie <b>#pgv_lang[all]#</b> spowoduje wyświetlenie listy wszystkich rodzin o wybranym nazwisku.</li></ul>Wyświetlenie listy na ekranie może zająć sporo czasu ze względu na dużą liczbę nazwisk.";
$pgv_lang["edit_TYPE_help"]						= "~#factarray[TYPE]#~<br /><br />Pole #factarray[TYPE]# służy do wprowadzania dodatkowych informacji o elemencie. Zwykle to pole ma dowolną formę i możesz wprowadzać informację, jaką zechcesz.";
$pgv_lang["edit_TEMP_help"]						= "~#factarray[TEMP]#~<br /><br />Dla ceremonii mormońskich to pole umożliwia wprowadzenie świątyni, w której ceremonia miała miejsce.";
$pgv_lang["edit_STAT_help"]						= "~#factarray[STAT]#~<br /><br />To jest opcjonalne pole statusu, wykorzystywane głównie dla ceremonii mormońskich przetwarzanych za pomocą programu TempleReady.";
$pgv_lang["edit__PRIM_help"]					= "~#factarray[_PRIM]#~<br /><br />To pole określa, czy dany obiekt multimedialny jest wyróżniony dla osoby, do której jest przypisany. Wyróżniony obiekt pojawia się na diagramach i stronie o osobie.";
$pgv_lang["edit__THUM_help"]					= "~#factarray[_THUM]#~<br /><br />Ta opcja pozwala na pominięcie standardowego wyboru miniaturki obrazu.<br /><br />GEDCOM posiada opcję konfiguracji, która określa, czy PhpGedView powinno wysłać duży lub mały obrazek do przeglądarki za każdym razem, gdy aktualna strona wymaga miniaturki. Opcja &laquo;#factarray[_THUM]#&raquo; z ustawioną wartością <b>#pgv_lang[yes]#</b>, tymczasowo nadpisuje ustawienia konfiguracyjne GEDCOM, aby PhpGedView wyświetliło zawsze duży obraz. Nie możesz narzucić PhpGedView wyświetlania małych obrazów, gdy konfiguracja GEDCOM określa, że powinny być wykorzystywane duże obrazy.<br /><br />PhpGedView nie zmienia rozmiarów wyświetlanych obrazów, czyni to przeglądarka w zależności od specyfikacji otrzymanej strony. Może to mieć niepożądane skutki, gdy wyświetlany obraz nie jest naprawdę miniaturką, a PhpGedView zamierza wyświetlić mały obrazek. To nie jest błąd: W niektórych przypadkach może być pożądane, aby wyświetlić duży obraz w miejscach, gdzie oczekiwane są miniatury.<br /><br />Należy unikać ustawiania opcji &laquo;#factarray[_THUM]#&raquo; na wartość <b>#pgv_lang[yes]#</b>. Ten wybór może spowodować nadmierne ilości danych związanych z obrazem, który ma zostać wysłany do przeglądarki. Szybkość wyświetlania strony, szczególnie wykresów z wieloma obrazami, może być poważnie spowolniony.";
$pgv_lang["edit_TITL_help"]						= "~#factarray[TITL]#~<br /><br />Wprowadź tytuł elementu, który edytujesz. Jeśli jest to tytuł obiektu multimedialnego, podaj opisowy tytuł, który umożliwi użytkownikowi rozpoznanie tego obiektu.";
$pgv_lang["edit_FILE_help"]						= "~#factarray[FILE]#~<br /><br />To jest najważniejsze pole we wpisie obiektu multimedialnego. Wskazuje ono, którego pliku należy użyć. Musisz podać co najmniej samą nazwę pliku. W zależności od ustawień może być potrzebna większa ilość informacji na temat lokalizacji pliku.<br /><br />Możesz skorzystać z odnośnika <b>#pgv_lang[find_media]#</b> aby odnaleźć multimedia, które zostały już wgrane na stronę.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]						= "~#factarray[FORM]#~<br /><br />To jest dodatkowe pole, w którym możesz wpisać format pliku multimedialnego. Niektóre aplikacje genealogiczne mogą korzystać z tego pola, aby określić, w jaki sposób obsłużyć obiekt. Jednak ze względu na to, że multimedia i tak nie są bardzo przenośne pomiędzy systemami, to pole nie jest krytyczne.";
$pgv_lang["generate_thumb_help"]				= "~#pgv_lang[auto_thumbnail]#~<br /><br />Twój system potrafi automatycznie generować miniaturki dla pewnych rodzajów plików graficznych. Mogą to być pliki BMP, JPG, GIF, oraz PNG. Typy obsługiwane przez twój system są wymienione obok opcji wyboru.<br /><br />Zaznaczając tę opcję poinformujesz system, że wgrywasz obrazki tego typu i że chcesz, aby zostały dla nich wygenerowane miniaturki. Nie zaznaczaj tej opcji, jeśli chcesz dostarczyć własne miniaturki.";
$pgv_lang["edit_add_NOTE_help"]					= "~#pgv_lang[add_note]#~<br /><br />Ta sekcja pozwala dodać nową notatkę do faktu, który właśnie edytujesz. Notatki mają dowolną formę i są widoczne w sekcji \"Szczegóły faktu\".";
 $pgv_lang["edit_add_SHARED_NOTE_help"]			= "~#pgv_lang[add_shared_note]#~<br /><br />~#pgv_lang[edit_shared_note]#~<br /><br />Ta sekcja pozwala dodać nową wspólną notatkę do faktu, który właśnie edytujesz. Wspólne notatki tak jak zwykłe notatki mają dowolną formę tekstową i są widoczne w sekcji \"Szczegóły faktu\". Od zwykłych notatek odróżnia je możliwość powiązania ich z większą ilością osób, rodzin, źródeł i wydarzeń.<br /><br />Po kliknięciu odpowiedniego odnośnika będzie można powiązać wydarzenie z istniejąca wspólną notatką lub utworzyć nową wspólną notatkę i jednocześnie ją powiązać. Jeśli istnieje powiązanie ze wspólną notatką możliwa jest edycja zawartości notatki.<br /><ul><li><b>Powiąż z istniejącą wspólną notatką</b><div style=\"padding-left:20px;\">Jeśli znasz identyfikator żądanej wspólnej notatki, możesz wpisać jej numer bezpośrednio w polu.<br /><br />Gdy klikniesz ikonę <b>#pgv_lang[find_shared_note]#</b> będziesz mieć możliwość wyszukania tekstu istniejącej notatki i wybrania odpowiedniej. Identyfikator notatki zostanie automatycznie wprowadzony w tym polu.<br /><br />Musisz kliknąć przycisk <b>#pgv_lang[add]#</b> aby uaktualnić istniejący wpis.</div><br /></li><li><b>Utwórz nową wspólną notatkę.</b><div style=\"padding-left:20px;\">Gdy klikniesz ikonę <b>#pgv_lang[create_shared_note]#</b> otworzy się nowe okno. Możesz wprowadzić tekst nowej notatki. Tak jak w przypadku zwykłych notatek możesz podawać adresy URL.<br /><br />Po kliknięciu przycisku <b>#pgv_lang[save]#</b> zostanie wyświetlony tekst z identyfikatorem nowo utworzonej wspólnej notatki. Należy kliknąć tę wiadomość, aby zamknąć okno edycji oraz skopiować identyfikator do pola wyboru identyfikatora. Jeśli tylko zamkniesz okno, nowo utworzony identyfikator nie zostanie skopiowany automatycznie.<br /><br />Musisz kliknąć przycisk <b>#pgv_lang[add]#</b> aby uaktualnić istniejący wpis.</div><br /></li><li><b>Edytuj istniejącą wspólną notatkę</b><div style=\"padding-left:20px;\">Gdy klikniesz ikonę <b>#pgv_lang[edit_shared_note]#</b> otworzy się nowe okno. Możesz wprowadzić tekst nowej notatki. Tak jak w przypadku zwykłych notatek możesz podawać adresy URL.<br /><br />Po kliknięciu przycisku <b>#pgv_lang[save]#</b> tekst wspólnej notatki zostanie uaktualniony. Możesz zamknąć okno i kliknąć przycisk <b>#pgv_lang[save]#</b> ponownie.<br /><br />Gdy zmienisz tekst wspólnej notatki, Twoje zmiany będą widoczne we wszystkich miejscach, z którymi jest powiązana wspólna notatka. Nowe powiązania, które utworzysz po dokonaniu zmian będą również używać uaktualnionego tekstu.</div></li></ul>";
 $pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~KORZYSTANIE Z ASYSTENTA GEDFACT~<br /><br />Kliknięcie ikony \"+\" otworzy okno Aystenta GEDFact.<br />Tekst pomocy będzie dostępny tutaj.<br /><br />Gdy klikniesz przycisk \"Zapisz\", identyfikator Wspólnej notatki zostanie tutaj wklejony.";
$pgv_lang["edit_add_SOUR_help"]					= "~#pgv_lang[add_source]#~<br /><br />Ta sekcja pozwala dodawać nowe źródło do faktu, który właśnie edytujesz.<br /><br />W polu \"Źródło\" podaj identyfikator źródła. Kliknij odnośnik <b>#pgv_lang[create_source]#</b> jeśli chcesz wprowadzić nowe źródło. W \"Szczegółach źródła\" możesz wprowadzić na przykład numer strony lub inną informację, która pomoże innej osobie odnaleźć informację w źródle. W pole \"Treść\" możesz wprowadzić transkrypcję słowną źródła.";
$pgv_lang["edit_add_ASSO_help"]					= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# pozwala powiązać fakt z odpowiednią osobą na stronie. Jest to jeden ze sposobów, w jaki możesz na przykład zaznaczyć, że ktoś był ojcem chrzestnym pewnej osoby.";
$pgv_lang["edit_QUAY_help"]						= "~#factarray[QUAY]#~<br /><br />Możesz użyć tego pola do określenia jakości lub wiarygodności danych, pochodzących z tego źródła. Wiele aplikacji genealogicznych przechowuje w tym polu wartość liczbową. <b>3</b> może oznaczać, że dane pochodzą z oryginalnego źródła, <b>2</b> może oznaczać, że było to źródło wtórne, <b>1</b> może oznaczać, że informacja jest wątpliwa, a <b>0</b> - że źródło jest niewiarygodne.";
$pgv_lang["edit_PAGE_help"]						= "~#factarray[PAGE]#~<br /><br />W polu \"Szczegóły źródła\" możesz wprowadzić numer strony lub inną informację, która pomoże innej osobie odnaleźć informację w źródle.";
$pgv_lang["edit_TEXT_help"]						= "~#factarray[TEXT]#~<br /><br />W tym polu możesz zacytować tekst tego źródła. Może to być na przykład transkrypcja tekstu ze źródła lub opis tego, co znajdowało się w źródle.";
$pgv_lang["edit_SOUR_help"]						= "~#factarray[SOUR]#~<br /><br />To pole pozwala zmienić wpis źródła, z którym powiązany jest to zdarzenie. Należy tu podać identyfikator źródła. Obok pola będzie wypisany tytuł bieżącego identyfikatora źródła. Skorzystaj z odnośnika <b>#pgv_lang[find_id]#</b> aby odszukać identyfikator źródła. Aby całkowicie usunąć źródło, wyczyść to pole.";
$pgv_lang["edit_edit_raw_help"]					= "~#pgv_lang[edit_raw]#~<br /><br />Ta strona umożliwia edycję nieprzetworzonego wpisu GEDCOM. Używaj tej funkcji ostrożnie; wymaga ona dobrej znajomości standardu GEDCOM 5.5.1 Standard. Aby uzyskać więcej informacji na temat standardu GEDCOM 5.5.1, zajrzyj do tematu pomocy <b>Plik GEDCOM</b>.<br /><br />PhpGedView umożliwia wiele sposobów dodawania i edycji informacji, ale może się zdarzyć, że będziesz chciał(a) edytować nieprzetworzoną strukturę GEDCOM. O ile to możliwe, korzystaj raczej ze standardowych sposobów wprowadzania informacji, w innym przypadku użyj tego formularza. Po jego wysłaniu podane przez ciebie informacje zostaną sprawdzone pod względem zgodności ze standardem i zostanie uaktualniony wpis zmian (CHAN).";
$pgv_lang["add_from_clipboard_help"]			= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView umożliwia kopiowanie maksymalnie 10 faktów ze szczegółami do schowka. Ten schowek jest różny od Kosza Wycinków, którego można używać do eksportu części bazy danych.<br /><br />Możesz wybrać jedno z wydarzeń ze schowka i skopiować do osoby, rodziny, multimediów, źródła lub repozytorium aktualnie edytowanego. Jednakże nie można skopiować wydarzeń różnych typów rekordów. Na przykład, nie możesz skopiować Małżeństwa do Źródła lub Osoby, ponieważ to wydarzenie jest powiązane tylko z Rodziną.<br /><br /> Ta opcja przydaje się przy wprowadzaniu podobnych faktów, takich jak fakty o spisie ludności, do wpisów wielu osób lub rodzin.";
$pgv_lang["edit_PLAC_help"]						= "~#factarray[PLAC]#~<br /><br />Miejsca należy wprowadzać zgodnie ze standardami przyjętymi w genealogii. Miejsca w genealogii zapisuje się, umieszczając najbardziej szczegółową informację na początku, a następnie podając dane coraz bardziej ogólne, rozdzielając przy tym poziomy przecinkami. Poziomy informacji o miejscu powinny odzwierciedlać poziomy hierarchii administracyjnej lub kościelnej, która przechowuje akta.<br /><br />Na przykład informację o wsi Krzyżanowice pod Wrocławiem należy wprowadzić następująco: \"Krzyżanowice, Trzebnicki, Dolnośląskie, Polska\".<br /><br />Przeanalizujmy poszczególne elementy. Pierwsza część, \"Krzyżanowice\", to nazwa miejscowości, w której miało miejsce dane wydarzenie. Czasem może zajść potrzeba wyróżnienia dzielnicy lub innego mniejszego obszaru administracyjnego — w takim przypadku należy go umieścić przed nazwą miasta. Następnym elementem jest nazwa powiatu (\"Trzebnicki\"), województwa (\"Dolnośląskie\") oraz kraju (\"Polska\"). Podanie tak szczegółowej informacji jest ważne, ponieważ dane genealogiczne są przechowywane przez jednostki administracyjne na każdym poziomie.<br /><br />Jeśli brak informacji na którymś poziomie, należy pozostawić wolne miejsce pomiędzy przecinkami. Jeśli na przykład nie wiesz, w którym powiecie znajduje się wieś Krzyżanowice, wpisujesz: \"Krzyżanowice, , Dolnośląskie, Polska\". Jeśli wiesz tylko, że osoba urodziła się w województwie dolnośląskim, możesz wpisać: \", , Dolnośląskie, Polska\". Uwaga: poziomy administracyjne i ich liczba zależy od kraju. Najlepszą metodą jest stosowanie czteropoziomowej hierarchii miejsc (w Polsce: miejscowość, powiat, województwo, kraj).<br /><br />Odnośnik <b>#pgv_lang[find_place]#</b> pomoże ci odnaleźć miejsca wprowadzone wcześniej do bazy danych.";
$pgv_lang["edit_LATI_help"]						= "~#factarray[LATI]#~<br /><br />Wprowadzanie określonych współrzędnych szerokości i długości geograficznej jest zasadniczo odradzane, ponieważ umożliwia dostęp do mapowania tylko z widoku określonego elementu. Lepiej zarządzać miejscami geograficznymi.<br /><br />Jednak wprowadzenie szerokości i długości geograficznej pozwala na bardziej precyzyjne umieszczenie znacznika.";
$pgv_lang["edit_LONG_help"]						= "~#factarray[LONG]#~<br /><br />Wprowadzanie określonych współrzędnych szerokości i długości geograficznej jest zasadniczo odradzane, ponieważ umożliwia dostęp do mapowania tylko z widoku określonego elementu. Lepiej zarządzać miejscami geograficznymi.<br /><br />Jednak wprowadzenie szerokości i długości geograficznej pozwala na bardziej precyzyjne umieszczenie znacznika.";
$pgv_lang["edit_add_parent_help"]				= "~DODAJ NOWEGO OJCA LUB MATKĘ~<br /><br />Ta strona umożliwia dodanie nowego rodzica dla wybranej osoby. Podaj imię i nazwisko oraz informację o urodzeniu i śmieci, jeśli nimi dysponujesz. Jeśli nie znasz części informacji, pozostaw pole puste.<br /><br />Aby dodać więcej faktów, niż urodzenie i śmierć, musisz najpierw dodać tę osobę do bazy danych poprzez zapisanie zmian. Następnie kliknij nazwisko osoby, aby wyświetlić #pgv_lang[indi_info]# dla tej osoby. Bardziej szczegółową informację możesz dodać za pomocą strony #pgv_lang[indi_info]#.";
$pgv_lang["edit_add_spouse_help"]				= "~DODAJ NOWEGO MĘŻA LUB ŻONĘ~<br /><br />Ta strona umożliwia dodanie nowego małżonka dla wybranej osoby. Podaj imię i nazwisko oraz informację o urodzeniu i śmieci, jeśli nimi dysponujesz. Jeśli nie znasz części informacji, pozostaw pole puste.<br /><br />Aby dodać więcej faktów, niż urodzenie i śmierć, musisz najpierw dodać tę osobę do bazy danych poprzez zapisanie zmian. Następnie kliknij nazwisko osoby, aby wyświetlić #pgv_lang[indi_info]# dla tej osoby. Bardziej szczegółową informację możesz dodać za pomocą strony #pgv_lang[indi_info]#.";
$pgv_lang["edit_death_help"]					= "~#pgv_lang[death]#~<br /><br />Ten obszar umożliwia wprowadzenie informacji o śmierci. Najpierw podaj informację o dacie w standardowym genealogicznym formacie daty (1 JAN 2007). Możesz kliknąć ikonkę kalendarza, aby wybrać datę. Następnie wprowadź miejsce zgonu. Skorzystaj z odnośnika <b>#pgv_lang[find_place]#</b> aby wybrać miejsce, które istnieje już w bazie danych.";
$pgv_lang["edit_birth_help"]					= "~#pgv_lang[birth]#~<br /><br />Ten obszar umożliwia wprowadzenie informacji o urodzeniu. Najpierw podaj informację o dacie w standardowym genealogicznym formacie daty (1 JAN 2007). Możesz kliknąć ikonkę kalendarza, aby wybrać datę. Następnie wprowadź miejsce urodzenia. Skorzystaj z odnośnika <b>#pgv_lang[find_place]#</b> aby wybrać miejsce, które istnieje już w bazie danych.";
$pgv_lang["edit_sex_help"]						= "~#pgv_lang[sex]#~<br /><br />Wybierz z listy odpowiednią płeć. Opcja <b>nieznane</b> wskazuje, że brak informacji na temat płci danej osoby.";
$pgv_lang["edit_name_help"]						= "~#pgv_lang[name]#~<br /><br />To jest najważniejsze pole we wpisie o osobie.<br /><br />To pole powinno się wypełnić automatycznie w miarę wprowadzania danych do innych pól, jednak możesz je edytować według własnych potrzeb.<br /><br />Dane w tym polu powinny być wprowadzone zgodnie ze standardem GEDCOM 5.5.1, z nazwiskiem ujętym w ukośniki \"/\". Na przykład dla osoby \"Jan Adalbert Kulczyński Starszy\" należy wprowadzić: \"Jan Adalbert /Kulczyński/ Starszy\".";
$pgv_lang["edit_surname_help"]					= "~#pgv_lang[surname]#~<br /><br />W tym polu wprowadzasz nazwisko osoby. Na przykład dla osoby \"Jan Adalbert Kulczyński\" należy wprowadzić \"Kulczyński\".<br /><br />Osoby z kilkoma nazwiskami, często spotykane w Hiszpanii i Portugalii, powinny mieć rozdzielone nazwiska przecinkiem. Pozwoli to na to, by ta osoba była znajdowana pod każdym nazwiskiem. Na przykład: nazwisko \"Cortes,Vega\" będzie wyświetlane na listach pod <b>C</b> i pod <b>V</b>, podczas gdy nazwisko \"Cortes Vega\" będzie tylko widoczne na liście pod <b>C</b>.";
$pgv_lang["edit_NICK_help"]						= "~#factarray[NICK]#~<br /><br />W to pole należy wprowadzić wszelkie przezwiska danej osoby.<br />To pole nie jest obowiązkowe.<br /><br />Sposoby wprowadzenia przezwiska:<ul><li>Wybierz <b>zmień imię i nazwisko</b>, następnie podaj przezwisko i zapisz zmiany</li><li>Wybierz <b>dodaj nowe imię lub nazwisko</b>, następnie podaj przezwisko ORAZ imię i nazwisko i zapisz zmiany</li><li>Wybierz <b>edytuj wpis GEDCOM</b> i dodaj dodatkowe wpisy [2&nbsp;NICK] do głównego wpisu [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]				= "~#pgv_lang[given_name]#~<br /><br />W to pole należy wprowadzić imiona danej osoby. Na przykład dla \"Jana Adalberta Kulczyńskiego\" należy tutaj wpisać: \"Jan Adalbert\".";
$pgv_lang["edit_NPFX_help"]						= "~Przedrostek imienia~<br /><br />To dodatkowe pole pozwala wpisać takie przedrostki, jak \"Dr\" lub \"Ks.\"";
$pgv_lang["edit_NSFX_help"]						= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit_add_child_help"]				= "~#pgv_lang[add_child]#~<br /><br />Ta strona umożliwia dodanie do wybranej rodziny nowego dziecka. Podaj imię i nazwisko oraz informację o urodzeniu i śmieci, jeśli nimi dysponujesz. Jeśli nie znasz części informacji, pozostaw pole puste.<br /><br />Aby dodać więcej faktów, niż urodzenie i śmierć, musisz najpierw dodać to dziecko do bazy danych poprzez zapisanie zmian. Następnie kliknij nazwisko dziecka, aby wyświetlić #pgv_lang[indi_info]# dla niego. Bardziej szczegółową informację możesz dodać za pomocą strony #pgv_lang[indi_info]#.";

$pgv_lang["review_changes_help"]				= "~NIEZATWIERDZONE ZMIANY~<br /><br />Ten blok wyświetla wszystkie wpisy, które zostały zmienione online, ale nie zostały jeszcze przejrzane i zatwierdzone do wprowadzenia do bazy danych.";
$pgv_lang["quick_update_name_help"]				= "~ZMIEŃ IMIĘ LUB NAZWISKO~<br /><br />Ten formularz pozwala zmienić imię i nazwisko osoby, którą właśnie edytujesz. W polu Imiona wprowadź wszystkie imiona danej osoby. W pole Nazwisko wprowadź nazwisko rodowe. Na przykład dla osoby \"Jan Adalbert Kulczyński\" należy wprowadzić \"Jan Adalbert\" w pole Imiona, a \"Kulczyński\" w pole Nazwisko.<br /><br />Wypełnienie tych pól spowoduje <u>zmianę</u> danych osoby; nie spowoduje dodania nowego imienia lub nazwiska.<br /><br /><i>Uwaga: <u>nie używaj</u> tej metody, jeśli chcesz wprowadzić informację o zmianie nazwiska po ślubie. W tym przypadku skorzystaj z opcji dodania nowego męża poniżej.</i>";
$pgv_lang["quick_update_fact_help"]				= "~ZMIEŃ FAKT~<br /><br />Ten formularz pozwala zmienić aktualną informację o fakcie lub dodać nowy fakt dla wpisu, który właśnie edytujesz. Najpierw wybierz fakt z listy, a następnie wprowadź datę wydarzenia w standardowym genealogicznym formacie daty (1 JAN 2007). Skorzystaj z ikonki kalendarza, aby łatwiej wybrać datę. Na końcu wprowadź miejsce zajścia wydarzenia. Skorzystaj z odnośnika <b>#pgv_lang[find_place]#</b> aby wybrać miejsce już istniejące w bazie danych.<br /><br />Podane informacje albo zastąpią aktualne informacje, albo spowodują dodanie nowych wpisów, jeśli jeszcze ich nie ma.";
$pgv_lang["quick_update_address_help"]			= "~ZMIEŃ ADRES~<br /><br />Ten formularz pozwala zmienić adres, numer telefonu i adres email osoby, którą właśnie edytujesz.<br /><br />Podane informacje albo zastąpią aktualne informacje, albo spowodują dodanie nowych wpisów, jeśli jeszcze ich nie ma.";
$pgv_lang["quick_update_spouse_help"]			= "~DODAJ NOWEGO MĘŻA LUB ŻONĘ~<br /><br />Ten formularz umożliwia dodanie nowego małżonka do osoby, którą właśnie edytujesz. Podaj imię i nazwisko oraz informację o urodzeniu i śmieci, jeśli nimi dysponujesz. Pod informacją o ślubie wprowadź datę ślubu w standardowym genealogicznym formacie daty (1 JAN 2007). Skorzystaj z ikonki kalendarza, aby wybrać datę. Skorzystaj z odnośnika <b>#pgv_lang[find_place]#</b> aby wybrać miejsce, które istnieje już w bazie danych.<br /><br />Ten formularz spowoduje dodanie <i>nowego</i> partnera; nie spowoduje zmiany informacji o poprzednim małżonku. Aby zmienić dane wprowadzonego wcześniej małżonka, zamknij to okno i kliknij nazwisko tej osoby na zakładce #pgv_lang[relatives]#, a następnie wybierz z menu opcję Edytuj osobę.";
$pgv_lang["quick_update_marriage_help"]			= "~ZMIEŃ MAŁŻEŃSTWO~<br /><br />Te pola, wraz z innymi polami, pozwalają dodać nowego małżonka przy wprowadzaniu nowego małżeństwa. W przeciwnym razie wypełnienie tych pól spowoduje zmianę informacji o ostatnim małżeństwie danej osoby. Wprowadź daty w standardowym genealogicznym formacie daty (1 JAN 2007). Skorzystaj z ikonki kalendarza, aby wybrać datę. Skorzystaj z odnośnika <b>#pgv_lang[find_place]#</b> aby wybrać miejsce, które istnieje już w bazie danych.";
$pgv_lang["quick_update_child_help"]			= "~DODAJ NOWE DZIECKO~<br /><br />Te pola pozwalają dodać nowe dziecko do tej osoby. Najpierw wprowadź imię i nazwisko dziecka oraz wybierz jego płeć, a następnie wprowadź datę i miejsce urodzenia. Wprowadź daty w standardowym genealogicznym formacie daty (1 JAN 2007, skrót miesiąca po angielsku!). Skorzystaj z ikonki kalendarza, aby wybrać datę. Skorzystaj z odnośnika <b>#pgv_lang[find_place]#</b> aby wybrać miejsce, które istnieje już w bazie danych.<br /><br />Wypełnienie tych pól spowoduje dodanie <u>nowego</u> dziecka. Nie spowoduje zmiany informacji o wcześniej wprowadzonym dziecku. Aby edytować dane dziecka, które znajduje się już w bazie danych, zamknij to okno i kliknij nazwisko tej osoby na zakładce #pgv_lang[relatives]#, a następnie wybierz z menu opcję Edytuj osobę.";
$pgv_lang["index_top10_pageviews_help"]			= "~BLOK NAJCZĘŚCIEJ ODWIEDZANE~<br /><br />Ten blok wyświetla pierwszą dziesiątkę osób, rodzin lub źródeł pod względem liczby odwiedzających. Aby ten blok był widoczny, administrator strony musi włączyć liczniki odwiedzin.";
$pgv_lang["index_cookiepolicy_help"]			= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Ten blok pokazuje politykę plików cookie tej witryny.";
$pgv_lang["cookiepolicy_link_help"]				= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Pozostaw to pole puste, jeśli chcesz użyć standardowego tekstu.<br /><br />Jeśli chcesz użyć standardowego tekstu, a także podać łącze do pliku tekstowego lub strony HTML zawierającej szczegółowe informacje na temat polityki dotyczącej plików cookie specyficznej dla swoją witrynę, tutaj możesz wprowadzić adres URL tej strony.<br /><br />Na przykład <b>http://foo.bar.com/policy/cookies.txt</b> może wskazywać na zwykły plik tekstowy, a <b>http://foo.bar.com/policy/cookies .htm</b> wskazuje stronę w formacie HTML, a <b>http://foo.bar.com/policy/cookies.doc</b> wskazuje dokument w formacie Microsoft Word.";
$pgv_lang["cookiepolicy_link_advice"]			= "Pozostaw puste, aby użyć standardowego tekstu.<br /><br />Wprowadź adres URL, taki jak <b>http://foo.bar.com/policy/cookies.txt</b>, aby wskazać konkretną witrynę strona zasad.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~DOMYŚLNA ZAKŁADKA UŻYTKOWNIKA~<br /><br />To ustawienie pozwala określić, która zakładka będzie automatycznie otwierana, kiedy ten użytkownik wejdzie na stronę #pgv_lang[indi_info]#. Jeśli użytkownik ma prawo edytować ustawienia swojego konta, będzie mógł później sam zmienić to ustawienie.";
$pgv_lang["edituser_user_default_tab_help"]		= "~DOMYŚLNA ZAKŁADKA UŻYTKOWNIKA~<br /><br />To ustawienie pozwala określić, która zakładka będzie automatycznie otwierana, kiedy wejdziesz na stronę #pgv_lang[indi_info]#.";
$pgv_lang["reorder_children_help"]				= "~#pgv_lang[reorder_children]#~<br /><br />Dzieci są wyświetlane w kolejności, w jakiej znajdują się we wpisie GEDCOM danej osoby. Dzieci nie są posortowane po dacie urodzenia, ponieważ data urodzenia jest nieznana, jednak często kolejność urodzenia <u>jest</u> znana.<br /><br />Ta opcja umożliwia zmianę kolejności dzieci we wpisie rodziny. Jeśli chcesz posortować dzieci według ich dat urodzenia, masz do tego odpowiedni przycisk.<br /><br />Możesz także zmienić kolejność dzieci przeciągając ramkę z informacją. Kiedy najedziesz kursorem na ramkę, kształt kursora zmieni się na skrzyżowane strzałki. Przytrzymanie lewego przycisku myszki spowoduje przesuwanie ramki wraz z kursorem, w górę lub w dół listy. Inne elementy listy rozsuną się, aby wpuścić nową ramkę. Zwolnienie lewego przycisku myszki spowoduje umieszczenie ramki na nowej pozycji w liście.";
$pgv_lang["rss_feed_help"]						= "~USTAWIENIA KANAŁU RSS~<br /><br />Kanał ATOM/RSS dostępny w PhpGedView umożliwia oglądanie za pomocą odpowiedniego agregatora zawartości twojej strony głównej bez potrzeby wchodzenia na stronę. Większość agregatorów wyświetla użytkownikowi małe okienko, kiedy zmienia się zawartość monitorowanej strony. Pozwala to dowolnej osobie monitorować twoją stronę PhpGedView bez potrzeby regularnego wchodzenia na nią.<br /><br />Blok RSS pozwala dostosowywać odnośnik do kanału, umożliwiając wybranie określonych typów kanałów (większość czytników obsługuje większość typów, więc to ustawienie zwykle pozostawia się bez zmiany) i określony moduł kanału. Język i plik GEDCOM zostaną ustalone na podstawie języka i pliku GEDCOM aktywnego w czasie konfigurowania kanału.<br /><br />Typy generowanych kanałów to ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML i JavaScript. Pierwsze cztery typy są przeznaczone dla agregatorów RSS, natomiast JavaScript i HTML pozwalają umieścić kanał na innych stronach internetowych. Zauważ, że numer kanału RSS wskazuje różne style, a nie wersje.<br /><br />Istnieje opcja wyboru metody uwierzytalniania, która zaloguje użytkownika i pozwoli mu przeglądać (za pomocą odpowiedniego agregatora RSS) dane, do których normalnie miałby dostęp po zalogowaniu. Podstawowe uwierzytelnianie korzysta z <i>podstawowego uwierzytelniania HTTP</i> (ang. Basic HTTP Authentication) do zalogowania użytkownika. Przyszłe wersje mogą zostać wzbogacone of <i>rozszerzone uwierzytelnianie</i>(ang. Digest Authentication).<br /><br /><a href=\'http://en.wikipedia.org/wiki/RSS_(file_format)\' target=\'_blank\' alt=\'Artykuł Wikipedii\' title=\'Artykuł Wikipedii\'><b>Ten artykuł w Wikipedii</b></a> zawiera więcej informacji i odnośników na temat RSS i różnych formatów RSS. <i>Podstawowe uwierzytelnianie HTTP</i> omawia <a href=\'http://en.wikipedia.org/wiki/Basic_authentication_scheme\' target=\'_blank\' alt=\'Artykuł Wikipedii\' title=\'Artykuł Wikipedii\'><b>ten artykuł w Wikipedii</b></a>, zaś <i>uwierzytelnianie rozszerzone</i> - <a http://en.wikipedia.org/wiki/Digest_access_authentication\' target=\'_blank\' alt=\'Artykuł Wikipedii\' title=\'Artykuł Wikipedii\'><b>ten artykuł</b></a>.";

$pgv_lang["upload_media_help"]					= "~#pgv_lang[upload_media]#~<br /><br />Wybierz pliki z lokalnego komputera do przesłania na serwer. Wszystkie pliki zostaną przesłane do katalogu <b>#MEDIA_DIRECTORY#</b> lub do jednego z jego podkatalogów.<br /><br />Nazwy folderów, które określisz, zostaną dołączone do <b>#MEDIA_DIRECTORY#</b>. Na przykład <b>#MEDIA_DIRECTORY#mojarodzina</b>. Jeśli katalog miniatur nie istnieje, jest tworzony automatycznie.";
$pgv_lang["upload_media_folder_help"]			= "~#pgv_lang[folder]#~<br /><br />Twoja konfiguracja GEDCOM pozwala na maksymalnie #GLOBALS[MEDIA_DIRECTORY_LEVELS]# poziomów katalogu poza domyślnym katalogiem <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, gdzie są zwykle przechowywane wgrane pliku multimedialne. Dzięki temu możesz organizować swoje multimedia i nie musisz się przejmować dbaniem o unikalną nazwę dla każdego pliku multimedialnego.<br /><br />W tym polu określasz katalog docelowy na serwerze, w którym ma być przechowywany plik wgrany z lokalnego komputera. Zwróć uwagę na wielkie i małe litery, ponieważ mają one znaczenie w nazwach katalogów i plików.<br /><br />Jeśli katalog o podanej nazwie nie istnieje, zostanie on utworzony automatycznie. Jeśli podasz więcej niż #GLOBALS[MEDIA_DIRECTORY_LEVELS]# dodatkowych poziomów katalogu dozwolonych przez twoją konfigurację GEDCOM, wprowadzone dane zostaną automatycznie obcięte.<br /><br />Miniaturki będą wgrywane lub tworzone w identyczniej strukturze katalogów, rozpoczynającej się od <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.";
$pgv_lang["upload_media_file_help"]				= "~#pgv_lang[media_file]#~<br /><br />W tym polu wpisujesz lokalizację i nazwę pliku multimedialnego znajdującego się na Twoim komputerze lokalnym, który chcesz wgrać na serwer. Skorzystaj z przycisku<b>Przeglądaj</b> aby przejrzeć zawartość lokalnego komputera i wybrać odpowiedni plik.<br /><br />Plik zostanie wgrany na serwer pod tą samą nazwą i umieszczony w katalogu podanym w polu <b>#pgv_lang[folder]#</b>. Jeśli nie widzisz tego pola lub nie możesz go zmienić, oznacza to, że nie masz wystarczających uprawnień lub konfiguracja GEDCOM nie dopuszcza dodatkowych poziomów katalogu poza katalogiem <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. W tym wypadku plik multimedialny zostanie wgrany do katalogu <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.";
$pgv_lang["upload_thumbnail_file_help"]			= "~#pgv_lang[thumbnail]#~<br /><br />W tym polu wpisujesz lokalizację i nazwę pliku miniaturki znajdujązego się na Twoim komputerze lokalnym, który chcesz wgrać na serwer. Skorzystaj z przycisku<b>Przeglądaj</b> aby przejrzeć zawartość lokalnego komputera i wybrać odpowiedni plik. Jeśli wypełniono to pole, opcja <b>#pgv_lang[auto_thumbnail]# jest ignorowana.<br /><br />Jeśli wypełniono pole <b>#pgv_lang[media_file]#</b>, twój wgrany plik miniaturki otrzyma nazwę na bazie zawartości tego pola, niezależnie od tego, jak się nazywa na twoim komputerze lokalnym. Jeśli to pole jest puste, wgrany plik miniaturki zostanie skopiowany w dwa miejsca na serwerze: do katalogu wymienionego w polu <b>#pgv_lang[folder]#</b> oraz do identycznej struktury katalogów, rozpoczynającej się od <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Jeśli nie widzisz pola <b>#pgv_lang[folder]#</b> lub nie możesz go zmienić, oznacza to, że nie masz wystarczających uprawnień lub konfiguracja GEDCOM nie dopuszcza dodatkowych poziomów katalogu poza katalogiem <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, gdzie zwykle są przechowywane pliki multimedialne.";


//-- GENERAL
$pgv_lang["help_header"]			= "Informacja na temat:";
$pgv_lang["privacy_error_help"]		= "~DANE PRYWATNE~<br /><br />Jest kilka przyczyn pojawienia się tego komunikatu:<br /><br /><ul><li><b>Informacje o osobach żyjących są ustawione na \"#pgv_lang[private]#\"</b><br />Goście i użytkownicy niezalogowani mają dostęp tylko do informacji na temat osób zmarłych. Jeśli administrator na to zezwala, goście mogą zarejestrować się, klikając przycisk <b>#pgv_lang[login]#</b>, a następnie odnośnik #pgv_lang[requestaccount]#.<br /></li><li><b>Masz swój login i hasło...</b><br />ale nie zalogowałeś(-aś) się poprawnie lub przy dłuższej nieaktywności twoja sesja wygasła.<br /></li><li><b>Ze względu na ochronę prywatności</b><br />Ta osoba nie życzy sobie, aby pokazywać jej dane i poprosiła administratora, aby ustawił je na \"#pgv_lang[private]#\". Ochrona prywatności może zostać ustawiona na:<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>Poza \"Ścieżką pokrewieństwa\"</b><br />Mimo że jesteś zwykłym użytkownikiem <u>i</u> zalogowałeś(-aś) się, nadal może się zdarzyć, że zobaczysz ten komunikat, jeśli próbujesz zobaczyć dane osoby, z którą nie jesteś spokrewniony przez odpowiednio krótką ścieżkę pokrewieństwa, której maksymalną długość określa administrator tego pliku GEDCOM.<br /><br />Przykłady:<br />Kiedy ścieżka pokrewieństwa jest ustawiona na <b>1</b>, widzisz tylko dane własnej rodziny, ojca, matki, brata, siostry (ale nie ich małżonków lub dzieci).<br /><br />Kiedy ścieżka pokrewieństwa jest ustawiona na <b>2</b>, możesz także zobaczyć szczegóły na temat małżonków swojego rodzeństwa i ich dzieci (ale nie małżonków ich dzieci).<br /><br />Im większa wartość, na którą ustawiona jest ścieżka pokrewieństwa, tym bardziej dalekich krewnych możesz zobaczyć.<br /></li></ul><br />Jeśli uważasz, że masz prawo do przeglądania pewnych ukrytych szczegółów, skontaktuj się z administratorem, korzystając z odnośnika kontaktowego na dowolnej stronie.";
$pgv_lang["more_help"]				= "<br />Pomoc kontekstowa jest dostępna na każdym ekranie; upewnij się, że opcja <b>#pgv_lang[show_context_help]#</b> w menu pomocy jest włączona i kliknij znak zapytania <b>?</b> obok elementu.";
$pgv_lang["start_admin_help"]		= "+++ Początek dodatkowej informacji dla administratora +++";
$pgv_lang["end_admin_help"]			= "--- Koniec dodatkowej informacji dla administratora ---";
$pgv_lang["multiple_help"]			= "<span class='center'>--- To jest ogólna pomoc dla wielu stron ---</span>";
$pgv_lang["header_general_help"]	= "<div class='name_head center'><b>INFORMACJE OGÓLNE</b></div>";
$pgv_lang["best_display_help"]		= "~Twój ekran~<br /><br />PhpGedView został zaprojektowany dla ekranu o rozdzielczości 1024x768 pikseli. Jest to minimalna rozdzielczość, przy której wszystko powinno być poprawnie wyświetlane.<br /><br />Jeśli ustawiszmniejszą rozdzielczość ekranu (na przykład 800x600), może zajść potrzeba poziomego przewijania na niektórych stronach.";
$pgv_lang["preview_help"]			= "~#pgv_lang[print_preview]#~<br /><br />Kliknięcie na odnośnik <b>#pgv_lang[print_preview]#</b> spowoduje usunięcie elementów, które nie wyglądają dobrze na wydruku (menu, obramowania pól formularzy, dodatkowe odnośniki, znaki zapytania pomocy kontekstowej itp.).<br /><br />U dołu uproszczonej strony pojawi się odnośnik <b>#pgv_lang[print]#</b>, którego kliknięcie spowoduje otworzenie okna dialogowego drukowania. Po zakończeniu drukowania kliknij odnośnik <b>#pgv_lang[cancel_preview]#</b> aby powrócić do normalnego widoku ekranu.<br /><br />Uwaga: Mimo że wersja do druku usuwa wiele odnośników ze strony, pozostałe odnośniki są nadal aktywne.";
$pgv_lang["readme_help"]			= "Aby uzyskać więcej informacji, zajrzyj do pliku <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a>.";
$pgv_lang["is_user_help"]			= "--- W takiej postaci treść pomocy będzie widoczna dla użytkowników ---<br />--- Dla oszczędności miejsca nie przygotowano osobnej treści dla administratora na temat tego elementu ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~EDYTUJ NIEPRZETWORZONY PLIK GEDCOM~<br /><br />Kliknięcie tego odnośnika spowoduje otworzenie nowego okna, zawierającego nieprzetworzone dane GEDCOM dotyczące informacji na tej stronie.<br /><br />W tym miejscu możesz bezpośrednio edytować dane GEDCOM. Upewnij się, że wprowadzone dane są zgodne ze standardem GEDCOM 5.5.1, ponieważ nie będą później sprawdzane pod tym kątem. Dodane lub zmodyfikowane dane będą widoczne w PhpGedView jako \"zmiany\" i będą oczekiwały na zatwierdzenie przez administratora.";
$pgv_lang["RESN_help_title"]		= "Wprowadzanie ograniczeń dla faktów";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />Poza ogólnymi ustawieniami prywatności PhpGedView daje możliwość wprowadzania ograniczeń na przeglądanie i edytowanie informacji o faktach dla osób i rodzin. Ograniczenia możne wprowadzić każdy, kto ma prawo edycji informacji, chyba że zabrania tego prywatność lub inne wcześniej wprowadzone ograniczenia.<br /><br />Dozwolone są następujące wartości:<br /><ul><li><b>#pgv_lang[none]#</b><br />Informacja może być edytowana przez administratorów strony, administratorów GEDCOM i użytkowników, którzy mają prawo do edycji. Dostęp do informacji o fakcie jest regulowany ustawieniami prywatności, zastosowanymi przez administratora.</li><li><b>#pgv_lang[locked]#</b><br />To ustawienie nie ma wpływu na widoczność danych faktu. Ogranicza ono prawa edycji do administratorów strony i administratorów GEDCOM. Jeśli informacja odnosi się do samego użytkownika, on także może ją widzieć (i edytować, jeśli ma odpowiednie uprawnienia).</li><li><b>#pgv_lang[privacy]#</b><br />Informację mogą widzieć i edytować administratorzy strony i administratorzy GEDCOM. Jeśli informacja odnosi się do samego użytkownika, on także może ją widzieć (i edytować, jeśli ma odpowiednie uprawnienia). Informacja zostanie ukryta przed wszystkimi innymi użytkownikami, zalogowanymi lub nie.</li><li><b>#pgv_lang[confidential]#</b><br />Informację mogą widzieć i edytować tylko administratorzy strony i administratorzy GEDCOM. Informacja zostanie ukryta przed wszystkimi innymi użytkownikami, zalogowanymi lub nie.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Właściciel</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Pozostali</th></tr><tr><th></th><th></th><th>W</th><th>E</th><th></th><th>W</th><th>E</th><th></th><th>W</th><th>E</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>W : może widzieć</li><li>E : może edytować</li><li><img src=\"images/checked_qm.gif\" alt=\"\"/> : zależy od ogólnych ustawień prywatności</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~STRONA GŁÓWNA~<br /><br />To jest strona główna, która wprowadza cię do wybranego pliku <a href=\"#def_gedcom\">GEDCOM</a>. Możesz powrócić do tej strony wybierając opcję \"Strona główna\" z górnego menu. Jeśli na tej stronie znajduje się więcej plików GEDCOM, możesz wybrać jeden z nich z menu rozwijalnego.<br /><br />Ta strona pomocy zawiera informacje na następujące tematy:<ul><li><a href=\"#index_portal\"><b>Strona główna</b></a></li><li><a href=\"#header\"><b>Obszar nagłówka</b></a></li><li><a href=\"#menu\"><b>Menu</b></a></li><li><a href=\"#header_general\"><b>Informacja ogólna</b></a></li><li><a href=\"#def\"><b>Definicje</b></a></li></ul>";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class='name_head center'><b>OBSZAR NAGŁÓWKA</b></div><br />Nagłówek znajduje się u góry każdej strony. Nagłówek zawiera pewne przydatne odnośniki, których można używać z dowolnego miejsca na stronie.<br /><br />Ponieważ ta strona może wyglądać różnie w zależności od wybranego <a href=\"#def_theme\">motywu</a>, nagłówki i odnośniki mogą ulegać zmianie.<br /><br />Odnośniki, które możesz spotkać, to:<ul><li><a href=\"#header_search\"><b>Szukaj</b></a></li><li><a href=\"#header_lang_select\"><b>Wybierz język</b></a></li><li><a href=\"#header_user_links\"><b>Odnośniki użytkownika</b></a></li><li><a href=\"#header_favorites\"><b>Ulubione</b></a></li><li><a href=\"#header_theme\"><b>Zmień motyw</b></a></li></ul>";
$pgv_lang["header_search_help"]		= "~Obszar nagłówka: Szukaj~<br /><br />To niewielkie pole jest bardzo potężnym narzędziem. PhpGedView może odnaleźć prawie dowolną rzecz. Po wciśnięciu przycisku <b>&gt;</b> lub <b>Znajdź</b> zobaczysz stronę z wynikami swojego wyszukiwania. Na stronie wyszukiwania znajdziesz także obszerną pomoc na temat opcji wyszukiwania.";
$pgv_lang["header_lang_select_help"] = "~Obszar nagłówka: Wybierz język~<br /><br />Jedną z najważniejszych cech PhpGedView jest obsługa wielu języków.<br /><br />Język, w którym wyświetlane są wszystkie strony PhpGedView jest ustalony na podstawie ustawienia preferowanego języka w przeglądarce. Jednak administrator strony może ograniczyć dostępność pewnych języków.<br /><br />Jeśli konfiguracja na to pozwala, możesz zmieniać język PhpGedView wybierając inny z listy lub klikając na ikonkę flagi. Jeśli jesteś zarejestrowanym użytkownikiem, możesz skonfigurować PhpGedView tak, aby przechodził na twój ulubiony język po zalogowaniu, niezależnie od ustawień przeglądarki.";
$pgv_lang["header_user_links_help"]	= "~Obszar nagłówka: Odnośniki użytkownika~<br /><br />Odnośniki użytkownika to niewielki obszar z przydatnymi odnośnikami, znajdującymi się w tym samym miejscu na każdej stronie. Rozmieszczenie tych odnośników może się różnić w zależności od wybranego motywu.<br /><br />Niezalogowani użytkownicy widzą w tym miejscu tylko odnośnik <b>Zaloguj</b>. Po zalogowaniu wyświetla się komunikat:<ul><li><b>Użytkownik: (twoja nazwa użytkownika)</b>. Kliknięcie tego odnośnika spowoduje przeniesienie do strony konta.</li><li>Kliknij <b>Wyloguj</b> aby się wylogować.</li><li>Jeśli masz prawa administratora, zobaczysz także odnośnik <b>Admin</b>. Kliknięcie tego odnośnika spowoduje przeniesienie bezpośrednio do strony administracji.</li></ul>";
$pgv_lang["header_favorites_help"]	= "~Obszar nagłówka: Ulubione~<br /><br />Lista rozwijalna Ulubione pokazuje elementy, które dodano do Ulubionych na stronie portalu użytkownika. Wyświetla także elementy wybrane dla danego pliku GEDCOM przez administratora. Kliknięcie elementu spowoduje przeniesienie bezpośrednio do strony #pgv_lang[indi_info]#.<br /><br />Więcej informacji na temat dodawania ulubionych znajduje się na stronie portalu użytkownika.";
$pgv_lang["header_theme_help"]		= "~Obszar nagłówka: Zmień motyw~<br /><br />Jeśli administrator na to zezwoli, ta lista wyświetli motywy, których można użyć do wyświetlania strony.<br /><br />Możesz zmienić wygląd strony wybierając z listy odpowiedni motyw. Jeśli jesteś zalogowany(a), spowoduje to również zmianę twojego motywu użytkownika na wybrany i automatyczny wybór tego motywu, kiedy zalogujesz się następnym razem.";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENU</b></div><br />Nagłówki mają wiele rozwijalnych menu dla każdej ikonki menu.<br /><br />Kiedy najedziesz kursorem na ikonkę, pojawi się podmenu (jeśli istnieje). Kliknięcie ikonki powoduje wybranie pierwszej opcji z listy podmenu.<br /><br />Zwykle dostępne są następujące ikonki menu:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul>";
$pgv_lang["menu_famtree_help"]		= "~Menu Strona główna~<br /><br />W tym menu pojawiają się wszystkie bazy genealogiczne dostępne na tej stronie. Każda baza ma swoją własną stronę główną (taką, jak ta), którą można dostosowywać do własnych potrzeb. Jeśli istnieje tylko jedna baza na stronie, pod ikonką strony głównej nie ma żadnych opcji wyboru.";
$pgv_lang["menu_myged_help"]		= "~Menu #pgv_lang[mygedview]#~<br /><br />Po zalogowaniu to menu może zawierać następujące elementy:<ol><li>#pgv_lang[mygedview]#<br />Ta opcja przenosi cię na twoją własną stronę, którą możesz dostosować do własnych potrzeb.</li><li>#pgv_lang[editowndata]#<br />Dzięki tej opcji możesz edytować swoje dane osobowe.</li><li>#pgv_lang[my_pedigree]#<br />Jeśli wybrano główną osobę dla tego pliku GEDCOM, nastąpi przejście do diagramu rodowego tej osoby.</li><li>#pgv_lang[my_indi]#<br />Ten odnośnik przeniesie cię do twojej strony #pgv_lang[indi_info]#, gdzie znajdują się wszystkie informacje genealogiczne o tobie i twojej rodzinie.</li></ol>";
$pgv_lang["menu_charts_help"]		= "~Menu Diagramy~<br /><br />Dostępne są następujące typy diagramów i wykresów:<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Ta opcja przeniesie cię do diagramu rodowego dla tego pliku GEDCOM. Drzewo rozpoczyna się od osoby wskazanej przez administratora. Po zalogowaniu możesz wybrać tę osobę w opcjach konfiguracyjnych swojego konta.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Diagram potomków to najogólniej <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> w odwrotnej kolejności. To porównanie nie jest do końca poprawne, ale podczas gdy diagram rodowodu pokazuje wszystkich przodków pewnej osoby, diagram potomków wyświetla wszystkich potomków tej osoby.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Tutaj możesz zobaczyć wydarzenia związane z daną osobą na osi czasu. Interesujące może być porównywanie wydarzeń dotyczących dwóch (lub więcej) osób na tej samej osi czasu.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Tutaj możesz sprawdzić stopień pokrewieństwa danej osoby do siebie lub innej osoby.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Ten diagram jest bardzo podobny do diagramu <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, ale pokazuje więcej szczegółów i z innymi stylami: <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a>.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Ten diagram jest bardzo podobny do diagramu <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, ale dane są przedstawione w bardziej graficzny sposób.</li></ol>";
$pgv_lang["menu_lists_help"]		= "~Menu Listy~<br /><br />Dostępne są następujące listy:<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />W obu tych listach możesz przeglądać alfabetyczne spisy osób lub rodzin w aktualnym pliku GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Ta opcja wyświetla listę wszystkich źródeł, z których korzysta aktualny plik GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Tutaj możesz odszukać osobę za pomocą kryterium miejsca. Wynikiem wyszukiwania jest dwukolumnowa lista: po lewej są wymienione osoby, po prawej - rodziny.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Ta opcja jest widoczna tylko, jeśli tak zadecydował administrator. Dzięki niej możesz wyświetlić odnośniki do wszystkich plików multimedialnych w aktualnym pliku GEDCOM.</li></ol>";
$pgv_lang["menu_annical_help"]		= "~Menu #pgv_lang[anniversary_calendar]#~<br /><br />#pgv_lang[anniversary_calendar]# wyświetla wydarzenia z danego pliku GEDCOM dla danego dnia, miesiąca lub roku.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Te elementy menu przeniosą cię do odpowiedniej strony #pgv_lang[anniversary_calendar]# i pokażą listę wydarzeń, które miały miejsce danego dnia, miesiąca, lub roku.</li></ol>";
$pgv_lang["menu_clip_help"]			= "~Menu #pgv_lang[clippings_cart]#~<br /><br />Tę opcję zobaczysz w menu tylko, kiedy włączy ją administrator.<br /><br />Wycinki pozwalają ci przechowywać informacje o osobach, rodzinach i źródłach w pliku tymczasowym, który możesz później pobrać w formacie GEDCOM 5.5.1.";
$pgv_lang["menu_search_help"]		= "~Menu Szukaj~<br /><br />Strona wyszukiwania jest bardziej zaawansowaną wersją wyszukiwarki, która znajduje się w nagłówku każdej strony.";
$pgv_lang["menu_help_help"]						= "~Menu Pomoc~<br /><br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]	= "<div class='name_head center'><b>STRONA GŁÓWNA</b></div><br />|";
$pgv_lang["index_portal_help"]		= "Strona główna składa się z kilku osobnych bloków, które możesz dostosowywać do własnych potrzeb. Na stronach, które mają więcej niż jedną bazę genealogiczną, możesz zobaczyć różne strony główne dla każdej z nich. W zależności od tego, jak administrator skonfigurował ustawienia, możesz zobaczyć następujące bloki na stronie głównej:<ul><li><a href=\"#index_welcome\"><b>Powitanie</b></a></li><li><a href=\"#index_login\"><b>Logowanie</b></a></li><li><a href=\"#index_events\"><b>Nadchodzące wydarzenia</b></a></li><li><a href=\"#index_onthisday\"><b>Tego dnia w naszej historii</b></a></li><li><a href=\"#index_charts\"><b>Diagramy</b></a></li><li><a href=\"#index_favorites\"><b>Ulubione GEDCOM</b></a></li><li><a href=\"#index_stats\"><b>Statystyki GEDCOM</b></a></li><li><a href=\"#index_common_surnames\"><b>Najpopularniejsze nazwiska</b></a></li><li><a href=\"#index_media\"><b>Losowe multimedia</b></a></li><li><a href=\"#index_loggedin\"><b>Zalogowani użytkownicy</b></a></li><li><a href=\"#gedcom_news\"><b>Artykuły GEDCOM</b></a></li><li><a href=\"#recent_changes\"><b>Ostatnie zmiany</b></a></li></ul>";
$pgv_lang["index_welcome_help"]		= "~BLOK POWITANIE~<br /><br />Blok powitania wyświetla tytuł bieżącej bazy danych, datę i godzinę, oraz licznik odwiedzin, jeśli został włączony przez administratora.<br /><br />Licznik odwiedzin jest dostępny tylko w bloku powitania oraz na stronie #pgv_lang[indi_info]#. Licznik zlicza \"wizyty\", czyli liczbę razy, jaką ktokolwiek wszedł na te strony. Licznik nie sprawdza adresu internetowego odwiedzającego; każde wejście na stronie z <u>dowolnego</u> adresu liczy się jako kolejna wizyta.";
$pgv_lang["index_login_help"]		= "~BLOK LOGOWANIE~<br /><br />Możesz się zalogować z prawie każdej strony tego systemu. Zwykle będzie się to działo na pierwszej stronie, ponieważ jako niezalogowany użytkownik nie masz dostępu do chronionych danych.<br /><br />Logujesz się wpisując swój <b>login</b> i <b>hasło</b>, a następnie klikając na przycisk \"Zaloguj\".";
$pgv_lang["index_events_help"]		= "~BLOK NADCHODZĄCE WYDARZENIA~<br /><br />Ten blok wyświetla zbliżające się rocznice wydarzeń.<br /><br />Administrator określa, jak daleko w przyszłość sięga ten blok. Możesz dostosować wygląd bloku za pomocą kilku opcji konfiguracyjnych.";
$pgv_lang["todo_help"] = "~BLOK ZADANIA DO ZROBIENIA~<br /><br />Ten blok wyświetla zadania zapisane w tagach <b>_TODO</b>.<br /><br />Aby dodać zadania do wykonania, musisz najpierw się upewnić, że konfiguracja strony pozwala na dodawanie faktów w tagach <b>_TODO</b>.";
$pgv_lang["todo_show_other_help"]	= "Pokaż &quot;Zadania do wykonania&quot; przypisane innym użytkownikom";
$pgv_lang["todo_show_unassigned_help"] = "Pokaż &quot;Zadania do wykonania&quot; nieprzypisane użytkownikom";
$pgv_lang["todo_show_future_help"]= "Pokaż &quot;Zadania do wykonania&quot; mające przyszłe daty. W przeciwnym razie zostaną wyświetlone tylko zadania mające daty przeszłe.";
$pgv_lang["yahrzeit_help"]			="~BLOK WYDARZENIA YAHRZEIT~<br /><br />Ten blok pokazuje nadchodzące wydarzenia Yahrzeit (rocznice śmierci).<br /><br />Rocznice te występują tylko w kulturze żydowskiej.";
$pgv_lang["days_to_show_help"]		= "~#pgv_lang[days_to_show]#~<br /><br />Wprowadź liczbę dni do wyświetlenia. Liczba nie może być większa niż <b>#DAYS_TO_SHOW_LIMIT#</b>. Jeśli wprowadzisz większą liczbę, zostanie zastosowana maksymalna dozwolona liczba.<br /><br />Limit jest ustawiony przez administratora w konfiguracji GEDCOM, sekcji Wygląd i układ, podsekcji Ukryj i pokaż.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Ta opcja pozwala określić typ multimediów do wyświetlenia.<br /><br />Wybranie <b>#pgv_lang[random_media_persons]#</b> spowoduje wyświetlanie tylko multimediów powiązanych z osobami. Zwykle jest to zdjęcie. Wybranie <b>#pgv_lang[random_media_events]#</b> spowoduje wyświetlenie tylko multimediów powiązanych z faktami lub wydarzeniami. Może to być grafika lub certyfikat. Wybranie <b>#pgv_lang[all]#</b>, ten blok będzie wyświetlał multimedia dowolnego typu.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />Możesz ograniczyć zawartość bloku Losowe multimedia do określonego formatu i typu obiektu multimedialnego. Zaznaczenie odpowiedniej opcji powoduje wyświetlanie w tym bloku obiektów danego formatu i typu.<br /><br />Kody formatów lub typów, które istnieją w bazie danych, ale nie w opcjach, są automatycznie włączane. Na przykład, jeśli twoja baza danych zawiera obiekty multimedialne w formacie <b><i>pdf</i></b>, blok Losowe multimedia będzie zawsze mogół je wyświetlać. Podobnie, jeśli twoja baza danych zawiera obiekty multimedialne typu <b><i>special</i></b>, również będą one zawsze wyświetlane.";
$pgv_lang["basic_or_all_help"]		= "~#pgv_lang[basic_or_all]#~<br /><br />Ta opcja pozwala eliminować niektóre wydarzenia posiadające datę. Na przykład #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, itd. powinny posiadać datę.<br /><br />Wybranie <b>Tak</b> spowoduje wyświetlenie tylko urodzeń, zgonów i ślubów. Wybranie <b>Nie</b> spowoduje wyświetlenie wszystkich wydarzeń z datą.";
$pgv_lang["style_help"]				= "~#pgv_lang[style]#~<br /><br />Ta opcja określa, w jaki sposób informacje są prezentowane.<br /><br />Wybranie <b>#pgv_lang[style1]#</b> powoduje wyświetlenie informacji w formie tekstowej, podobnej do ramek na diagramach. Ten format dobrze nadaje się do bloków, które pojawiają się po prawej stronie strony.<br /><br />Wybranie <b>#pgv_lang[style2]#</b> powoduje wyświetlenie informacji w formie tabeli i lepiej nadaje się do większych bloków, które pojawiają się po lewej stronie strony.";
$pgv_lang["sort_style_help"]		= "~#pgv_lang[sort_style]#~<br /><br />Ta opcja określa, w jaki sposób informacje są prezentowane.<br /><br />Wybranie <b>#pgv_lang[by_alpha]#</b> powoduje wyświetlenie informacji alfabetycznie.<br /><br />Wybranie <b>#pgv_lang[by_anniv]#</b> powoduje wyświetlenie informacji według rocznicy.";
$pgv_lang["cal_dowload_help"]		= "~#pgv_lang[cal_download]#~<br /><br />Ta opcja określa, czy przycisk do pobierania wydarzeń z Kalendarium będzie dostępny dla zalogowanych użytkowników. Pobrany plik kalendarza można zaimportować do odpowiednich programów, takich jak Microsoft Outlook, aby na przykład zdefiniować automatyczne przypomnienia emailowe o rocznicach.<br /><br />Ustawienie na <b>#pgv_lang[no]#</b> spowoduje, że zalogowani użytkownicy nie będą mogli pobierać pliku kalendarza. Ustawienie na <b>#pgv_lang[yes]#</b> spowoduje pokazanie przycisku Pobierz. Tego przycisku nigdy nie widzą niezalogowani użytkownicy.";
$pgv_lang["cal_download_user_help"]				= "Jeśli jesteś zalogowany, możesz zobaczyć ikonę <img src='images/ical.png' alt='' />. Jeśli klikniesz ikonę, pobierzesz wydarzenia jako plik kalendarza, który można zaimportować do kompatybilnych programów, takich jak Microsoft Outlook, na przykład w celu wygenerowania automatycznych przypomnień e-mail o rocznicach.<br /><br /> Jeśli jesteś zalogowany i nie widzisz tej ikony, administrator wyłączył tę funkcję. Odwiedzający, którzy nie są zalogowani, nie zobaczą tej ikony i nie będą mogli pobrać pliku kalendarza.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br /><br />Ten blok pozwala umieścić diagram rodowy, klepsydrowy, lub diagram potomków na stronie głównej lub na stronie portalu. Ze względu na ograniczenia miejsca, diagramy powinny być umieszczanie tylko po lewej stronie. Administratorzy określają osobę-korzeń i typ diagramu wyświetlanego na stronie głównej.<br /><br />Zachowanie tych diagramów jest analogiczne do tego, gdy występują osobno. Kliknięcie ramki osoby pozwala wyświetlić więcej szczegółów na jej temat.";
$pgv_lang["index_onthisday_help"]	= "~BLOK #pgv_lang[on_this_day]#~<br /><br />Ten blok jest podobny do bloku \"Nadchodzące wydarzenia\", ale wyświetla tylko dzisiejsze wydarzenia.";
$pgv_lang["index_favorites_help"]	= "~BLOK ULUBIONE GEDCOM~<br /><br />Blok \"Ulubione GEDCOM\" jest bardzo podobny do bloku \"Moje ulubione\" na stronie #pgv_lang[mygedview]#. Inaczej, niż w przypadku konfiguracji strony portalu, tylko administrator lub użytkownik z prawami administrowania może zmieniać listę ulubionych w tym bloku.<br /><br />Celem bloku \"Ulubione GEDCOM\" jest zwrócenie uwagi użytkowników na osoby o wyjątkowym znaczeniu w tym pliku GEDCOM. Ulubione elementy można wybrać z listy rozwijalnej w nagłówku każdej strony.<br /><br />Kliknięcie na element powoduje przeniesienie do strony #pgv_lang[indi_info]# tej osoby.";
$pgv_lang["index_add_favorites_help"] = "~DODAJ DO ULUBIONYCH~<br /><br />Ten formularz umożliwia dodanie nowego elementu do listy ulubionych. Musisz albo podać identyfikator osoby, rodziny lub źródła, które chcesz przechowywać w ulubionych, albo wprowadzić adres URL i tytuł. Pole komentarza nie jest obowiązkowe i służy do opisania danego elementu. Treść tego pola pojawi się obok elementu w bloku ulubione.";
$pgv_lang["index_stats_help"]		= "~BLOK STATYSTYKI RODZINY~<br /><br />W tym bloku pojawiają się niektóre statystyki na temat bieżącego pliku GEDCOM. Jeśli potrzebujesz więcej informacji, niż jest tu widoczne, skontaktuj się z osobą wskazaną u dołu strony.";
$pgv_lang["index_common_names_help"]	= "~BLOK NAJCZĘSTSZE NAZWISKA~<br /><br />Ta blok wyświetla listę nazwisk, które występują w bazie danych najczęściej. Aby pojawiło się na liście, nazwisko musi wystąpić co najmniej #COMMON_NAMES_THRESHOLD# razy. Administrator może zmieniać tę wartość progową.<br /><br />Kliknięcie na nazwisko z listy spowoduje przeniesienie do strony #pgv_lang[individual_list]#, gdzie zobaczysz więcej szczegółów o danym nazwisku.";
$pgv_lang["index_common_given_names_help"] = "~BLOK NAJCZĘŚCIEJ WYSTĘPUJĄCE IMIONA~<br /><br />Ta blok pokazuje najczęściej występujące imiona. Możesz skonfigurować ile imion zostanie pokazanych na liście.<br /><br />Używa pierwszego i drugiego imienia. Na przykład imię \"Anna Maria\" będzie policzone jako \"Anna\" oraz jako \"Maria\".";
$pgv_lang["index_media_help"]			= "~BLOK LOSOWE ZDJĘCIE~<br /><br />W tym bloku PhpGedView wyświetla losowo wybrany plik multumedialny za każdym razem, kiedy wchodzisz na stronę.<br /><br />Po kliknięciu obrazka zobaczysz jego wersję w pełnym rozmiarze. Poniżej obrazka znajduje się odnośnik do osoby, z którą jest powiązany. Po kliknięciu podpisu obrazka zobaczysz obrazek na stronie #pgv_lang[media_list]#. Kliknięcie nazwiska osoby spowoduje przeniesienie do strony #pgv_lang[indi_info]#.";
$pgv_lang["index_loggedin_help"]		= "~BLOK ZALOGOWANI UŻYTKOWNICY~<br /><br />Ten blok wyświetla użytkowników, którzy są aktualnie zalogowani.<br /><br />Jeśli nie jesteś administratorem, możesz zobaczyć tylko tych zalogowanych użytkowników, którzy zdecydowali, że chcą być widoczni, kiedy są online. Ponadto ty także musisz chcieć być widoczny, kiedy jesteś online. Użytkownicy, którzy nie są widoczni, ale są online, są wliczani do użytkowników anonimowych.";
$pgv_lang["index_gedcom_news_help"]		= "~BLOK ARTYKUŁY~<br /><br />Blok artykułów jest jakby tablicą ogłoszeń dla tego pliku GEDCOM. Administrator strony może w niej umieszczać ważne ogłoszenia lub interesujące wiadomości.<br /><br />Jeśli chcesz się podzielić ciekawą informacją, skontaktuj się z administratorem strony; administrator może umieścić twoją wiadomość na tej tablicy ogłoszeń.";
$pgv_lang["recent_changes_help"]		= "~BLOK OSTATNIE ZMIANY~<br /><br />Ten blok wyświetla ostatnie zmiany wprowadzone do pliku GEDCOM, zarejestrowane przez znacznik CHAN w pliku GEDCOM.";
$pgv_lang["gedcom_news_limit_help"]		= "~OGRANICZ WYŚWIETLANIE~<br /><br />Możesz ograniczyć liczbę wyświetlanych artykułów, zmniejszając w ten sposób wysokość bloku artykułów.<br /><br />Ta opcja określa, czy należy zastosować ograniczenie, i — jeśli tak — czy powinno być ono oparte na wieku artykułu, czy też na liczbie artykułów.";
$pgv_lang["gedcom_news_flag_help"]		= "~OGRANICZENIE~<br /><br />Wprowadź tutaj wartość maksymalną.<br /><br />Jeśli ograniczasz wyświetlanie artykułów na podstawie ich wieku, każdy artykuł starszy od podanej tu liczby dni będzie niewidoczny. Jeśli ograniczasz wyświetlanie artykułów bazując na ich liczbie, pojawi się tylko podana liczba najświeższych artykułów, ułożona według ich wieku; pozostałe artykuły będą niewidoczne.<br /><br />Wprowadzenie zera spowoduje wyłączenie ograniczenia i pokazanie wszystkich artykułów.";
$pgv_lang["gedcom_news_archive_help"]	= "Aby zmniejszyć wysokość bloku artykuły, administrator ukrył niektóre z nich. Możesz wyświetlić niewidoczne artykuły, klikając na odnośnik <b>#pgv_lang[gedcom_news_archive]#</b>.";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br /><br />Ten blok umożliwia administratorowi dodanie informacji do strony indeksowej lub strony portalu. Spełnia podobną funkcję do bloku #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, oraz #pgv_lang[gedcom_stats_block]#, ale administrator ma więcej kontroli nad jego wyglądem.";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br /><br />To pole powinno być puste lub zawierać bardzo krótki tekst. Jeśli jest puste, blok zaawansowanego HTML będzie wyglądać na stronie indeksowej lub portalu tak, jak zwykły blok HTML. Jeśli wprowadzono tu jakiś tekst, blok zaawansowanego HTML będzie wyglądać jak wszystkie inne bloki, włącznie z paskiem tytułu, w którym pojawi się wprowadzony tutaj tekst.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br /><br />Aby pomóc ci w rozpoczęciu pracy nad nowym blokiem, utworzyliśmy kilka standardowych szablonów. Kiedy wybierzesz jeden z szablonów, pole tekstowe będzie zawierać kopię, którą będzie można następnie dopasować do własnych potrzeb.";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br /><br />Inaczej, niż bloki #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, oraz #pgv_lang[gedcom_stats_block]#, masz pełną kontrolę nad wyglądem swojej bloku. Możesz użyć znaczników HTML i arkuszy stylów CSS z bieżącego motywu. Możesz także wstawiać odniesienia do informacji z bieżącej genealogicznej bazy danych.<br /><br />Odniesienia do bazy danych umieszcza się w tekście w formie słów kluczowych, ujętych w pary symboli <b>&#35;</b>. Na przykład <b>&#35;totalFamilies&#35;</b> reprezentuje liczbę rodzin w bazie danych. Czasem może zajść potrzeba wprowadzenia odniesienia jako tekstu, a nie użycia jego prawdziwego znaczenia. W takim przypadku musisz zastąpić symbole <b>&#35;</b> ich odpowiednikami symbolicznymi. Na przykład, jeśli twój tekst zawiera <b>&&#35;35;totalFamilies&&#35;35;</b>, zostanie wyświetlony jako <b>&#35;totalFamilies&#35;</b>, a nie zamieniony na odniesienie do bazy danych.<br /><br />Aby zobaczyć pełen przykład zastosowania tego bloku, przeanalizuj szablon &quot;#pgv_lang[gedcom_stats_block]#&quot; znajdujący się w katalogu blocks/; jest w nim wykorzystana większość styli znaczników, łącznie z odnośnikami językowymi i do tekstu pomocy.<br /><br />Szablon <b>#pgv_lang[htmlplus_block_keyword]#</b> zawiera pełną listę wszystkich obsługiwanych słów kluczowych.";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br /><br />Włącz kompatybilność ze starszymi wersjami tego bloku. Zaznaczenie tej opcji umożliwi rozpoznawanie zarówno starszych, jak i nowszych słów kluczowych i ich odpowiednie działanie.<br /><br />Na przykład tekst <b>&#35;TOTAL_FAM&#35;</b> zostanie rozpoznany jako odpowiednik <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> - <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> - <b>&#35;topTenLargestFamily&#35;</b>, itd.<br /><br />Jeśli nie jest to absolutnie koniecznie, nie powinno się korzystać z trybu kompatybilności.";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br /><br />Wybierz bazę danych, do której mają się odnosić słowa kluczowe.<br /><br />Twoja strona obsługuje kilka baz danych. Słowa kluczowe, takie jak <b>&#35;totalFamilies&#35;</b> mogą się odnosić tylko do jednej z nich. Musisz określić, z której bazy danych należy pobierać wartości dla słów kluczowych tego typu. Każdy blok #pgv_lang[htmlplus_block_name]# może korzystać z pojedynczej bazy danych.";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br /><br />Ukryj lub pokazuj listę imion osób, których płeć nie jest znana.<br /><br />Blok #pgv_lang[block_givn_top10]# zawsze ukrywa listę imion osób o nieznanej płci, gdy w bazie nie istnieją takie osoby. Ta opcja pozwala na ukrywanie tych imion, nawet gdy takie osoby istnieją w bazie.";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Oczywiście, idealnie byłoby stworzyć program tak prosty i łatwy w obsłudze, aby nie wymagał żadnego objaśnienia, a korzystanie z niego było tak nieskomplikowane, jak czytanie książki.<br /><br />Choć PhpGedView jest bardzo złożonym systemem, możesz nie odnieść takiego wrażenia; prawie wszystkich opcji można używać bez specjalnych objaśnień. Jednak ze względu na wielu gości i użytkowników, którzy nie mają doświadczenia w korzystaniu z komputera lub Internetu, w niektórych miejscach udostępniamy pomoc.<br /><br />W menu pomocy znajdziesz następujące opcje:";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Pomoc dla tej strony</b></dt><dd>Dla wszystkich stron dostępna jest ogólna pomoc strony. Po kliknięciu tej opcji menu zobaczysz pomoc strony, w której znajdziesz informację na temat elementów na stronie, którą właśnie odwiedzasz.<br /><br />Pomoc strony jest często krótka. Jeśli potrzebujesz więcej pomocy lub informacji o konkretnym elemencie strony, niż dostarcza pomoc strony, skorzystaj z opcji pomocy kontekstowej.</dd></dl>";
$pgv_lang["help_content_help"]		= "<dl><dt><b>Treść pomocy</b></dt><dd>Po kliknięciu tej opcji menu zobaczysz stronę pomocy ze spisem głównych tematów pomocy. Zakres informacji w pomocy będzie zwiększany w miarę możliwości.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>Lista FAQ</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Ukryj / Pokaż pomoc kontekstową</b></dt><dd>Ta opcja menu może okazać się najbardziej przydatna. Kliknięcie tego odnośnika spowoduje włączenie lub wyłączenie pomocy kontekstowej.<br /><br />Kiedy pomoc kontekstowa jest włączona, znak zapytania lub podobna ikonka pomocy będzie znajdować się obok niektórych odnośników, list, lub przycisków. Kliknięcie tej ikonki spowoduje otworzenie okienka z ekranem pomocy, który będzie zawierał informacja na temat tego elementu.<br /><br />Kiedy klikniesz \"Ukryj pomoc kontekstową\", wszystkie znaki zapytania lub ikonki znikną, dopóki znowu nie klikniesz \"Pokaż...\".</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Oto wyjaśnienia terminów używanych w pomocy:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Daty</b></a></li><li><a href=\"#def_pdf_format\"><b>format PDF</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Motyw</b></a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Portal~<br /><br />Portal tej strony jest jak wejście do restauracji lub biblioteki. Jest to miejsce, przez które zwykle tylko przechodzisz, ale możesz tu także znaleźć ważne informacje, takie jak objaśnienia, menu itp.";
$pgv_lang["def_gedcom_help"]					= "~Plik GEDCOM~<br /><br />Cytat ze Wstępu do standardu GEDCOM 5.5.1 :<div class=\"list_value_wrap\">#pgv_lang[quote_gedcom]#</div><br />Wersja polska :<div class=\"list_value_wrap\">GEDCOM został opracowany przez Departament Historii Rodziny Kościoła Jezusa Chrystusa Świętych w Dniach Ostatnich (LDS Church), aby zapewnić elastyczny, jednolity format wymiany skomputeryzowanych danych genealogicznych.&nbsp; GEDCOM to skrót od <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication (komunikacja danych genealogicznych).&nbsp; Jego celem jest wspieranie dzielenia się informacjami genealogicznymi oraz rozwój szerokiej gamy interoperacyjnego oprogramowania wspomagającego genealogów, historyków i innych badaczy.</div><br />Kopię <u>projektu</u> standardu GEDCOM 5.5.1, którego przestrzega PhpGedView, można pobrać w formacie PDF tutaj:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">Standard GEDCOM 5.5.1</a> Ten standard jest dostępny tylko w języku angielskim.<br /><br />Plik GEDCOM zawiera wszystkie informacje o rodzinie. Tutaj przechowywane są wszystkie fakty, daty, wydarzenia itp. Pliki GEDCOM muszą podlegać ścisłym regułom, ponieważ muszą być wymienialne między wieloma programami, niezależnie od platform lub systemów operacyjnych.";
$pgv_lang["def_gedcom_date_help"]		= "~Daty w pliku GEDCOM~<br /><br />Mimo że pola dat dopuszczają dowolność wprowadzania danych (możesz wpisać, co tylko chcesz), istnieją pewne reguły wprowadzania dat według standardu GEDCOM 5.5.1.<ol><li>Pełną datę wprowadza się w formacie DD MMM RRRR, na przykład <b>01&nbsp;Mar&nbsp;1801</b> lub <b>14&nbsp;Dec&nbsp;1950</b>.</li><li>Jeśli nie znasz części daty, możesz ominąć tę część, na przykład <b>Mar&nbsp;1801</b> lub <b>14&nbsp;Dec</b>.</li><li>Jeśli data jest niepewna lub nie potwierdzona, możesz wpisać <b>abt&nbsp;Mar&nbsp;1801</b> (abt = about, około), <b>bef&nbsp;20&nbsp;Dec&nbsp;1950</b> (bef = before, przed), <b>aft&nbsp;1949</b> (aft = after, po)</li></ol><b>Pamiętaj, żeby wprowadzić daty i skróty po <u>angielsku</u>,</b> ponieważ tylko wtedy plik GEDCOM jest wymienny i PhpGedView może odpowiednio tłumaczyć daty i skróty na bieżący język. PhpGedView przeprowadza także obliczenia, korzystając z tych dat. Jeśli wprowadzone w pola daty dane są niepoprawne, PhpGedView nie będzie mógł wykonać obliczeń poprawnie.<br /><br />Skorzystaj z ikonki kalendarza, aby wybrać datę.";
$pgv_lang["def_gramps_help"]		= "~Plik bazy danych GRAMPS XML~<br /><br />Oto cytat ze strony projektu GRAMPS:<div class=\"list_value_wrap\">#pgv_lang[quote_gramps]#</div><br />Wersja polska :<div class=\"list_value_wrap\">GRAMPS pomaga ci śledzić twoje drzewo genealogiczne. Umożliwia przechowywanie, edytowanie i badanie danych genealogicznych. GRAMPS stara się zapewnić wszystkie znane możliwości innych programów genealogicznych, ale, co więcej, zapewnić dodatkową możliwość integracji, która nie jest typowa dla tych programów. Jest to możliwość wprowadzania dowolnych skrawków informacji bezpośrednio do GRAMPS i przestawiania/manipulowania dowolnymi wydarzeniami w całej bazie danych (w dowolnej kolejności) wspomagając użytkownika w przeprowadzaniu badań, analizie i korelowaniu, dając możliwość uzupełnienia braków.</div><br />Specyfikację formatu XML GRAMPS v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">można znaleźć tutaj</a>, zarówno w formacie RELAX NG Schema, jak i DTD.<br /><br />Aby uzyskać więcej informacji na temat projektu GRAMPS zajrzyj na stronę <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>.";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br /><br />PhpGedView (w skrócie PGV) nie jest zbiorem statycznych stron w sieci; to dynamiczny system, który może być na wiele sposobów dostosowywany do własnych potrzeb.<br /><br />PhpGedView został zaprojektowany przez Johna Finlay'a do przeglądania plików GEDCOM online. John rozpoczął pracę nad programem sam. Od tamtej pory dołączył do niego międzynarodowy zespół deweloperów i tłumaczy, który pracuje nad usprawnieniem programu. Wśród ważnych nowych cech programu są jego zaawansowana obsługa języków innych niż angielski oraz możliwość dodawania i edytowania wydarzeń online.";
$pgv_lang["def_theme_help"]			= "~Motyw~<br /><br />Ta strona może mieć różny wygląd, zwany motywem.<br /><br />Administrator strony wybiera domyślny motyw, widziany przez każdego, kto wejdzie po raz pierwszy na stronę. Jeśli administrator na to zezwoli, każdy użytkownik może wybrać swój własny motyw. PhpGedView zapamiętuje ostatnio wybrany motyw dla każdego zalogowanego użytkownika i wybiera go automatycznie, kiedy ten użytkownik zaloguje się ponownie. Motywy mogą także sygnalizować różne bazy danych na tej samej stronie. Każda baza danych może mieć inny domyślny motyw.";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]	= "~#pgv_lang[mygedview]#~<br /><br />To jest twoja własna strona #pgv_lang[mgv]#<br /><br />Tutaj znajdziesz szybkie odnośniki do informacji na swój temat, takiej jak <b>Moje konto</b>, <b>Mój Indi</b> (twoja strona #pgv_lang[indi_info]#), oraz <b>Mój rodowód</b>. Możesz także mieć blok <b>Wiadomości</b>, <b>Dziennik</b> (jak notatnik) i wiele innych.<br /><br />Układ tej strony jest podobny do strony głównej, którą widzisz, kiedy pierwszy raz wchodzisz do tego serwisu. Podczas gdy części strony głównej aranżuje administrator, to ty możesz wybrać, które bloki umieścić na twojej własnej stronie. Odnośnik do dostosowywania strony znajduje się w bloku powitania lub osobno, jeśli tego bloku nie ma.<br /><br />Dostępne są następujące bloki:<ul><li><a href=\"#mygedview_welcome\"><b>Powitanie</b></a></li><li><a href=\"#mygedview_customize\"><b>Dostosuj MyGedView</b></a></li><li><a href=\"#mygedview_message\"><b>Wiadomości</b></a></li><li><a href=\"#mygedview_events\"><b>Nadchodzące wydarzenia</b></a></li><li><a href=\"#mygedview_onthisday\"><b>Tego dnia w naszej historii</b></a></li><li><a href=\"#mygedview_charts\"><b>Diagramy</b></a></li><li><a href=\"#mygedview_favorites\"><b>Moje ulubione</b></a></li><li><a href=\"#mygedview_stats\"><b>Statystyki GEDCOM</b></a></li><li><a href=\"#mygedview_myjournal\"><b>Mój dziennik</b></a></li><li><a href=\"#mygedview_media\"><b>Losowe multimedia</b></a></li><li><a href=\"#mygedview_loggedin\"><b>Zalogowani użytkownicy</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>Ostatnie zmiany</b></a></li></ul>";
$pgv_lang["mygedview_customize_help"]		= "~DOSTOSUJ #pgv_lang[mygedview]#~<br /><br />Kiedy wejdziesz tu po raz pierwszy, na tej stronie będą umieszczone już pewne bloki. Jeśli chcesz, możesz dostosować tę stronę portalu do własnych potrzeb.<br /><br />Po kliknięciu tego odnośnika zobaczysz formularz, na którym możesz dodawać, przesuwać lub usuwać bloki. Więcej wyjaśnień znajdziesz na tym formularzu.";
$pgv_lang["mygedview_message_help"]		= "~BLOK WIADOMOŚCI~<br /><br />W tym bloku znajdziesz wiadomości, które zostały przysłane do Ciebie od innych użytkowników i administratora. Ty również możesz wysyłać do nich wiadomości.<br /><br />System komunikacji PhpGedView jest zaprojektowany z myślą o ochronie twojej prywatności. Nie musisz podawać swojego adresu email, a inne osoby nie będą miały do niego dostępu.<br /><br />Aby rozwinąć wiadomość, kliknij jej temat lub znak plus \"<b>+</b>\" obok niego. Możesz usunąć kilka wiadomości, jednocześnie zaznaczając je, a następnie klikając przycisk <b>#pgv_lang[delete_selected_messages]#</b>.";
$pgv_lang["mygedview_favorites_help"]		= "~BLOK MOJE ULUBIONE~<br /><br />Ulubione są podobne do zakładek.<br /><br />Załóżmy, że chcesz regularnie sprawdzać wpis o pewnej osobie w twoim drzewie genealogicznym. Wystarczy przejść na stronę #pgv_lang[indi_info]# tej osoby i wybrać opcję <b>Dodaj do moich ulubionych</b> z listy ulubionych. Wybrana osoba zostanie zaznaczona i dodana do twojej listy ulubionych.<br /><br />Z każdego miejsca w serwisie możesz rozwinąć listę \"Moje ulubione\" w nagłówku i wybrać nazwisko. Kliknięcie nazwiska przeniesie cię do strony #pgv_lang[indi_info]# tej osoby.";
$pgv_lang["mygedview_myjournal_help"]	= "~BLOK MÓJ DZIENNIK~<br /><br />Z dziennika możesz korzystać do prowadzenia notatek lub zapisywania przypomnień na własny użytek. Wprowadzone notatki będą tam nadal, kiedy ponownie odwiedzisz serwis.<br /><br />Notatki są prywatne i nie będą widoczne dla innych.";
$pgv_lang["mygedview_welcome_help"]		= "~BLOK POWITANIE~<br /><br />Blok powitania wyświetla:<ul><li>Bieżący plik GEDCOM</li><li>Datę i godzinę</li><li>Odnośniki do:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Uwaga:</b><br />Odnośniki do <b>Mój Indi</b> i <b>Mój rodowód</b> zobaczysz tylko, jeśli występujesz w bieżącym pliku GEDCOM. Jeśli w aktualnym pliku GEDCOM znajduje się wpis z twoimi danymi, wówczas zobaczysz odnośniki <b>Mój Indi</b> i <b>Mój rodowód</b>, jeśli nie masz w nim swojego wpisu — te odnośniki się nie pojawią.";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~STRONA RODOWODU~<br /><br />Rodowód jest wyliczeniem wszystkich przodków wybranej osoby (korzenia). Niezalogowani użytkownicy widzą rodowód osoby wybranej przez administratora. Zalogowani użytkownicy mogą sami wybrać osobę-korzeń drzewa.<br /><br />W tym kontekście \"wszyscy przodkowie\" oznaczają ojca i matkę, ich rodziców itd. Rodowód ma postać graficzną; nie musisz przekopywać się przez tony tekstu, aby dotrzeć do swoich przodków.<br /><br />Wszystkie osoby są pokazane na ekranie w ramkach z nazwiskami.<br /><ul><li><b>Ramki z nazwiskami na diagramie</b><br />Jeśli strona rodowodu jest ustawiona w ten sposób, aby pokazywać szczegóły, zobaczysz imię i nazwisko oraz daty urodzenia i śmierci tej każdej osoby. Po kliknięciu nazwiska osoby znajdziesz się na stronie #pgv_lang[indi_info]# dla tej osoby.<br /><br />Kiedy opcja <b>Pokazuj szczegóły</b> jest włączona, wewnątrz ramki z nazwiskiem znajdują się dwie ikonki.</li><li><b>Ikonka rodowodu wewnątrz ramki z nazwiskiem</b><br />Kiedy opcja <b>Pokazuj szczegóły</b> jest włączona, wewnątrz ramki z nazwiskiem zobaczysz ikonkę rodowodu. Zależnie od ustawień strony, po najechaniu na nią kursorem lub kliknięciu pojawi się małe podmenu.<br /><br />Elementy <b>#pgv_lang[index_header]#</b> i <b>#pgv_lang[descend_chart]#</b> są podobne do tych elementów w menu głównym, z tą różnicą, że początkową osobą dla diagramu jest teraz osoba, której dotyczy ramka. Widzisz także <b>#pgv_lang[as_spouse]#</b>. Pod tym widzisz nazwisko małżonka oraz dzieci. Na wszystkie nazwiska można kliknąć.</li><li><b>Ikonka lupy wewnątrz ramki z nazwiskiem</b><br />Zależnie od ustawień strony, po najechaniu na nią kursorem lub kliknięciu pojawi się małe podmenu. Spowoduje to powiększenie ramki i wyświetlenie większej liczby szczegółów. Zobaczysz więcej dat i wydarzeń. Na wszystkie nazwiska można kliknąć.</li><li><b>Strzałki</b><br />Po prawej lub lewej stronie ramek znajdujących się na prawym lub lewym brzegu możesz zobaczyć strzałki. Kliknięcie ich spowoduje przesunięcie zawartości ekranu w kierunku strzałki.</li></ul><br />#pgv_lang[context_help]#";
$pgv_lang["show_full_help"]			= "~UKRYJ LUB POKAŻ SZCZEGÓŁY~<br /><br />Ta opcja umożliwia pokazywanie lub ukrycie wszystkich szczegółów w ramkach z nazwiskami. Kiedy szczegóły są ukryte, na jednym ekranie może się zmieścić więcej ramek.<br /><br />Kiedy wszystkie szczegóły są ukryte, ikonka powiększania omówiona poniżej nie jest wyświetlana. Jednak jeśli administrator włączył funkcję powiększania, cała ramka będzie działała jak ikonka powiększania, pokazując wszelkie szczegóły na temat danej osoby.<br /><br />Kiedy szczegóły są widoczne i funkcja powiększania, oznaczona ikonką lupy, została włączona przez administratora, możesz wyświetlić jeszcze więcej szczegółów na temat danej osoby. Jeśli normalnie, aby powiększyć, musisz kliknąć ikonkę powiększania, tutaj klikając tę ikonkę, możesz wyświetlić dodatkowe szczegóły. Analogicznie, jeśli możesz powiększać, najeżdżając na ikonkę kursorem, tutaj ukryte szczegóły pojawią się, kiedy najedziesz na tę ikonkę.<br /><br />Po kliknięciu ikonki powiększania możesz przywrócić normalny poziom szczegółowości, ponownie klikając ikonkę powiększania. Jeśli szczegóły pojawiły się po najechaniu na ikonkę kursorem, ramka powróci do normalnego poziomu szczegółowości, kiedy kursor opuści obszar ikonki.";
$pgv_lang["talloffset_help"]		= "~UKŁAD STRONY~<br /><br />Ta opcja pozwala określić orientację układu strony.<br /><br />Zmiana tego ustawienia może przydać się, kiedy chcesz wydrukować zawartość ekranu lub masz nietypowy ekran.<ul><li>Typ orientacji <b>#pgv_lang[portrait]#</b> wydłuża drzewo tak, aby diagram czterech pokoleń zmieścił się na pojedynczej stronie, drukowanej pionowo.</li><li>Typ orientacji <b>#pgv_lang[landscape]#</b> rozszerza drzewo tak, aby całe drzewo zmieściło się na jednej stronie, drukowanej poziomo.</li><li>Opcja <b>#pgv_lang[landscape_top]#</b> wyświetla osoby starsze na górze wykresu.</li><li>Opcja <b>#pgv_lang[landscape_down]#</b> wyświetla osoby starsze na dole wykresu.</li></ul<br />Obie opcje nadają się bardzo dobrze do drukowania poziomych wykresów.";
$pgv_lang["rootid_help"]			= "~NOWA OSOBA GŁÓWNA~<br /><br />Podaj tutaj identyfikator nowej osoby początkowej (korzenia) dla diagramu. Jeśli nie znasz odpowiedniego identyfikatora, skorzystaj z odnośnika <b>Znajdź ID</b>.<br /><br /><b>IDENTYFIKATOR (ID)</b><br />Identyfikatory używane przez PhpGedView <i>nie są</i> numerami identyfikacyjnymi nadanymi przez jakiekolwiek władze (takie jak numery dowodu tożsamości, paszportu czy prawa jazdy). W tym kontekście identyfikator jest po prostu numerem wykorzystywanym w bazie danych do rozróżniania każdej osoby, przypisany przez aplikację genealogiczną, w której został utworzony plik GEDCOM, zaimportowany następnie do PhpGedView.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~LICZBA POKOLEŃ~<br /><br />Tutaj możesz ustawić liczbę pokoleń, która ma się pojawić na tej stronie.<br /><br />Odpowiednia liczba zależy od wielkości twojego ekranu i tego, czy chcesz widzieć szczegóły. Czas przetwarzania będzie tym dłuższy, im więcej pokoleń będzie trzeba wyświetlić.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~STRONA LOGOWANIA~<br /><br />Na tej stronie możesz się zalogować, zamówić nowe hasło lub rozpocząć zakładanie nowego konta.";
$pgv_lang["username_help"]						= "~LOGIN~<br /><br />W to pole wpisujesz swoją nazwę użytkownika (login).<br /><br /><b>Wielkie i małe litery w tym polu mają znaczenie.</b> Oznacza to, że <b>MojeImię</b> to <u>nie</u> to samo, co <b>mojeimię</b> czy <b>MOJEIMIĘ</b>.";
$pgv_lang["password_help"]			= "~HASŁO~<br /><br />W to pole wpisujesz swoje hasło.<br /><br /><b>Małe i wielkie litery w haśle mają znaczenie.</b> Oznacza to, że <b>MojeHasło</b> to <u>nie</u> to samo, co <b>mojehasło</b> czy <b>MOJEHASŁO</b>.";
$pgv_lang["login_buttons_help"]			= "~PRZYCISKI ZALOGUJ~<br /><br />Tutaj zobaczysz dwa przyciski, służące do zalogowania do systemu.<br /><br />Od tego, na który z nich klikniesz po wpisaniu loginu i hasła, zależy, gdzie znajdziesz się po zalogowaniu.<br /><ul><li>Przycisk <b>#pgv_lang[login]#</b><br />Po kliknięciu tego przycisku powrócisz do strony aktualnie odwiedzanej, ale z prawami dostępu zalogowanego użytkownika.<br /><br />Na przykład kliknięcie <b>#pgv_lang[login]#</b> na stronie rodowodu spowoduje powrót na tą samą stronę. Jeśli klikniesz ten przycisk na stronie głównej, po zalogowaniu znajdziesz się na stronie #pgv_lang[mygedview]#.</li><li>Przycisk <b>#pgv_lang[admin]#</b><br />Jeśli masz prawa administratora, kliknięcie tego przycisku przeniesie cię bezpośrednio do głównej strony administracji.</li></ul>";
$pgv_lang["login_buttons_aut_help"]		= "~PRZYCISKI ZALOGUJ W TRYBIE UWIERZYTELNIANIA~<br /><br />Tutaj zobaczysz dwa przyciski, służące do zalogowania do systemu.<br /><br />Od tego, na który z nich klikniesz po wpisaniu loginu i hasła, zależy, gdzie znajdziesz się po zalogowaniu.<br /><ul><li>Przycisk <b>#pgv_lang[login]#</b><br />Po kliknięciu tego przycisku przejdziesz bezpośrednio na stronę #pgv_lang[mygedview]#, gdzie możesz edytować ustawienia, dodawać i usuwać ulubione, wysyłać i czytać wiadomości, itd.</li><li>Przycisk <b>#pgv_lang[admin]#</b><br />Jeśli masz prawa administratora, kliknięcie tego przycisku przeniesie cię bezpośrednio do głównej strony administracji.</li></ul>";
$pgv_lang["new_password_help"]		= "~ZAMÓW NOWE HASŁO~<br /><br />Jeśli nie pamiętasz swojego hasła, skorzystaj z tego odnośnika, aby zamówić nowe hasło.<br /><br />Znajdziesz się na stronie \"Zgubione hasło\".";
$pgv_lang["new_user_help"]			= "~ZAŁÓŻ NOWE KONTO~<br /><br />Jeśli jesteś gościem na tej stronie i chcesz założyć nowe konto, skorzystaj z tego odnośnika.<br /><br />Znajdziesz się na stronie rejestracji.";
$pgv_lang["mygedview_login_help"]		= "Aby uzyskać dostęp do strony #pgv_lang[mygedview]#, musisz być użytkownikiem zarejestrowanym w systemie. Na stronie #pgv_lang[mygedview]# możesz umieszczać zakładki do ulubionych osób, prowadzić dziennik, zarządzać wiadomościami, widzieć innych zalogowanych użytkowników i dostosowywać wiele aspektów stron PhpGedView do własnych potrzeb.<br /><br />Wpisz swój login i hasło w odpowiednie pola, aby się zalogować.";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />W to pole należy wpisać swoje imię.<br /><br />Musimy znać twoje imię i nazwisko, aby móc sprawdzić, czy jesteś odpowiednim kandydatem do otrzymania konta na tej stronie i jakie prawa dostępu należy ci przydzielić. Imię i nazwisko będzie widoczne dla innych zalogowanych członków rodziny i użytkowników.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />W to pole należy wpisać swoje nazwisko.<br /><br />Musimy znać twoje imię i nazwisko, aby móc sprawdzić, czy jesteś odpowiednim kandydatem do otrzymania konta na naszej stronie i jakie prawa dostępu należy ci przydzielić. Imię i nazwisko będzie widoczne dla innych zalogowanych członków rodziny i użytkowników.";
$pgv_lang["register_info_01"]		= "~ZAŁÓŻ NOWE KONTO~<br /><br />Ilość informacji dostępnych publicznie na tej stronie może być ograniczona przez stosowne przepisy o ochronie danych osobowych. Wiele osób nie życzy sobie publicznego udostępniania swoich danych osobowych w sieci. Taka informacja może zostać wykorzystana do spamowania lub kradzieży tożsamości.<br /><br />Dostęp do tej strony ma każdy użytkownik posiadający konto. Będziesz mógł(mogła) się zalogować po weryfikacji i zatwierdzeniu przez administratora twojego zgłoszenia.<br /><br />Jeśli włączono opcję prywatności, po zalogowaniu będziesz mieć dostęp wyłącznie do danych osobowych swoich bliskich krewnych. Administrator może dać niektórym użytkownikom możliwość edytowania bazy danych, tak aby mogli zmieniać lub wprowadzać nowe informacje.<br /><br />Jeśli potrzebujesz więcej pomocy, skorzystaj z odnośnika poniżej, aby skontaktować się z administratorem.";
$pgv_lang["register_info_02"]		= "~ZAŁÓŻ NOWE KONTO~<br /><br />Ilość informacji dostępnych publicznie na tej stronie może być ograniczona przez stosowne przepisy o ochronie danych osobowych. Wiele osób nie życzy sobie publicznego udostępniania swoich danych osobowych w sieci. Taka informacja może zostać wykorzystana do spamowania lub kradzieży tożsamości.<br /><br />Dostęp do tej strony mają tylko <u>autoryzowani</u> użytkownicy. Będziesz mógł(mogła) się zalogować po weryfikacji i zatwierdzeniu przez administratora twojego zgłoszenia.<br /><br />Jeśli włączono opcję prywatności, po zalogowaniu będziesz mieć dostęp wyłącznie do danych osobowych swoich bliskich krewnych. Administrator może dać niektórym użytkownikom możliwość edytowania bazy danych, tak aby mogli zmieniać lub wprowadzać nowe informacje.<br /><br />Jeśli potrzebujesz więcej pomocy, skorzystaj z odnośnika poniżej, aby skontaktować się z administratorem.";
$pgv_lang["register_info_03"]		= "~ZAŁÓŻ NOWE KONTO~<br /><br />Ilość informacji dostępnych publicznie na tej stronie może być ograniczona przez stosowne przepisy o ochronie danych osobowych. Wiele osób nie życzy sobie publicznego udostępniania swoich danych osobowych w sieci. Taka informacja może zostać wykorzystana do spamowania lub kradzieży tożsamości.<br /><br />Dostęp do tej strony mają tylko <u>członkowie rodziny</u>. Będziesz mógł(mogła) się zalogować po weryfikacji i zatwierdzeniu przez administratora twojego zgłoszenia.<br /><br />Jeśli włączono opcję prywatności, po zalogowaniu będziesz mieć dostęp wyłącznie do danych osobowych swoich bliskich krewnych. Administrator może dać niektórym użytkownikom możliwość edytowania bazy danych, tak aby mogli zmieniać lub wprowadzać nowe informacje.<br /><br />Jeśli potrzebujesz więcej pomocy, skorzystaj z odnośnika poniżej, aby skontaktować się z administratorem.";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~STRONA POTOMKÓW~<br /><br />Ta strona wyświetla potomków danej osoby.<br /><br />Możesz wybrać początkową osobę (korzeń) dla tego diagramu potomków, albo wejść na tę stronę z innej strony, klikając na <b>#pgv_lang[descend_chart]#</b>. Użyj ikonek strzałek, aby przesunąć drzewo w kierunku strzałki. Kliknij ikonkę diagramu w dowolnej ramce osoby, aby ustawić ją jako korzeń tego drzewa.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~WYKRES DŁUGOŚCI ŻYCIA~<br /><br />Na tym wykresie można wyświetlić jedną lub więcej osób na poziomej osi czasu. Pozwala on zobaczyć, jak nakładają się na siebie okresy życia różnych osób.<br /><br />Możesz dodawać osoby do tego diagramu pojedynczo lub grupami rodzinnymi podając ich identyfikatory. System zapamięta ostatnią listę osób. W dowolnym momencie możesz wyczyścić wykres za pomocą przycisku <b>Wyczyść wykres</b>.<br /><br />Możesz także dodać osoby do wykresu wyszukując je po zakresie dat lub miejscu.";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#~Opcja Uwzględnij najbliższą rodzinę~<br/>Opcja \"Uwzględnij najbliższą rodzinę\" jest zaznaczona domyślnie. Pozostaw tę opcję włączoną, aby zobaczyć ojca, matkę, małżonka i dzieci osoby, którą dodajesz do osi czasu. Odznacz tę opcję, jeśli chcesz pominąć najbliższą rodzinę.<br/><br/>";
$pgv_lang["help_timeline.php"]			= "~WYKRES OSI CZASU~<br /><br />Na tym wykresie można wyświetlić jedną lub więcej osób na osi czasu. Możesz na przykład przedstawić graficznie status dwóch lub więcej osób w danym momencie.<br /><br />Jeśli znalazłeś(-aś) się na tej stronie klikając odnośnik <b>Oś czasu</b> na innej stronie, na osi czasu zobaczysz już jedną osobę. Jeśli dostałeś(-aś) się na tą stronę wybierając <b>Oś czasu</b> z opcji menu w nagłówku strony, musisz podać identyfikator początkowej osoby.";
$pgv_lang["add_person_help"]			= "~DODAJ OSOBĘ DO WYKRESU~<br /><br />Na osi czasu można wyświetlić jednocześnie wiele osób.<br /><br />Skorzystaj z tego pola, aby wprowadzić identyfikator każdej osoby, którą chcesz dodać. Jeśli go nie znasz, skorzystaj z odnośnika <b>Znajdź identyfikator</b> obok pola.";
$pgv_lang["remove_person_help"]			= "~USUŃ OSOBĘ Z WYKRESU~<br /><br />Kliknij ten odnośnik, aby usunąć daną osobę z osi czasu.";
$pgv_lang["show_age_marker_help"]		= "~POKAŻ ZNACZNIK WIEKU~<br /><br />Zaznaczenie tej opcji spowoduje wyświetlenie znacznika wieku.<br /><br />Możesz przesuwać ten znacznik w górę i w dół po osi czasu. Ruchomy znacznik wieku jest dobrym narzędziem do sprawdzania wieku osoby w czasie pewnego wydarzenia. Możesz włączać lub wyłączać znacznik wieku niezależnie dla każdej osoby na wykresie.";
$pgv_lang["timeline_control_help"] = "~OPCJE WYKRESU DŁUGOŚCI ŻYCIA~<br/><br/>~Prędkość~<br/>Kliknij na menu rozwijalne, aby zmienić prędkość, z jaką przewija się oś czasu.<br/><br/>~Rok początkowy~<br/>Wprowadź początkowy rok wyświetlanego zakresu czasu.<br/><br/>~Rok końcowy~<br/>Wprowadź końcowy rok wyświetlanego zakresu czasu.<br/><br/>~Szukaj~<br/>Kliknij przycisk \"Szukaj\" aby rozpocząć wyszukiwanie wydarzeń, które miały miejsce w zakresie określonym przez pola roku początkowego i roku końcowego.<br/><br/>";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~STRONA POKREWIEŃSTWA~<br /><br />Na tej stronie można zobaczyć związek rodzinny pomiędzy dowolnymi dwoma osobami. Osoby te nie muszą być bezpośrednio związane więzami krwi (prawdziwym pokrewieństwem); może między nimi zachodzić dowolny stopień pokrewieństwa i powinowactwa.";
$pgv_lang["relationship_id_help"]		= "~IDENTYFIKATORY PIERWSZEJ I DRUGIEJ OSOBY~<br /><br />Jeśli znalazłeś(-aś) się na tej stronie po kliknięciu odnośnika <b>#pgv_lang[relationship_to_me]#</b>, zobaczysz związek między sobą a wybraną osobą.<br /><br />Jeśli wszedłeś(weszłaś) na tę stronę wybierając opcję <b>#phv_lang[relationship_chart]#</b> z nagłówka strony, musisz wpisać identyfikatory dwóch osób, dla których chcesz zobaczyć diagram związku. Jeśli nie znasz identyfikatora, skorzystaj z odnośnika <b>Znajdź identyfikator</b>.";
$pgv_lang["next_path_help"]			= "~ZNAJDŹ NASTĘPNĄ ŚCIEŻKĘ~<br /><br />Dzięki temu przyciskowi możesz zobaczyć, czy istnieje inna ścieżka związku pomiędzy dwoma osobami. Poprzednio znalezione ścieżki można ponownie wyświetlić klikając odnośnik z numerem ścieżki.";
$pgv_lang["follow_spouse_help"]			= "~OPCJA UWZGLĘDNIJ POWINOWACTWO~<br /><br />Jeśli ta opcja <b>nie</b> jest zaznaczona, badane są tylko związki pomiędzy krewnymi (pokrewieństwo). Jeśli ta opcja jest włączona, sprawdzane są także więzi poprzez małżeństwo (powinowactwo). Pozostawiając tę opcję zaznaczoną, znajdziesz prawdopodobnie więcej związków.";
$pgv_lang["line_up_generations_help"]	= "~OPCJA WYRÓWNAJ POKOLENIA~<br /><br />Zaznaczenie tej opcji spowoduje wyświetlenie diagramu z odpowiednimi pokoleniami wyrównanymi do tego samego poziomu na stronie. Odznaczenie tej opcji sprawi, że każde pokolenie będzie biegło w dół strony, niezależnie od typu związku.";
$pgv_lang["oldest_top_help"] 	= "~OPCJA POKAŻ NAJSTARSZYCH U GÓRY~<br /><br />Zaznaczenie tej opcji spowoduje wyświetlenie najstarszych osób u góry wykresu. Kiedy opcja nie jest zaznaczona, u góry pojawią się osoby najmłodsze.<br /><br />Uwaga: Ta opcja działa tylko wtedy, gdy jest jednocześnie włączona opcja <b>#pgv_lang[line_up_generations]#</b>.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~Strona #pgv_lang[ancestry_chart]#~<br /><br />Strona przodków jest bardzo podobna do <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale zawiera więcej szczegółów i różne style <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Każdy przodek ma przypisany numer obliczony według <i>systemu Sosy-Stradonitza</i> (Ahnentafel):<div style=\"padding-left: 30px;\"><b>Parzyste</b> numery dla mężczyzn (dziecko*2)<br /><b>Nieparzyste</b> numery dla kobiet (mąż+1) za wyjątkiem <b>1</b></div><br />Przykład:<br /><div style=\"padding-left: 30px;\">Początkowa osoba ma numer <b>1</b>, niezależnie od płci.<br />Ojciec numeru <b>1</b> ma numer <b>2</b> (<b>1</b> * 2), matka to <b>3</b> (<b>2</b> + 1).<br />Ojciec numeru <b>2</b> to <b>4</b> (<b>2</b> * 2), matka to <b>5</b> (<b>4</b> + 1).<br />Ojciec numeru <b>3</b> to <b>6</b> (<b>3</b> * 2), matka to <b>7</b> (<b>6</b> + 1).<br />Ojciec numeru <b>7</b> to <b>14</b> (<b>7</b> * 2), matka to <b>15</b> (<b>14</b> +1).<br />itd.</div>";
$pgv_lang["box_width_help"]		= "~Szerokość ramki: #pgv_lang[ancestry_chart]#~<br /><br />Tutaj możesz zmieniać szerokość ramek na diagramie od 50% do 300%. Przy 100% każda ramka ma około 270 pikseli szerokości.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br /><br />Dostępne są dwa style diagramów:<ul><li><b>#pgv_lang[chart_list]#</b><br />Pionowe drzewo z rozwijalnymi rodzinami.</li><li><b>#pgv_lang[chart_booklet]#</b><br />Jedna rodzina na stronę z rodzicami, dziadkami i wszystkimi dziećmi.<br /><br />Ten format jest łatwy do wydrukowania i pokazania twojej rodzinie.</li></ul>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~Strona #pgv_lang[fan_chart]#~<br /><br />Diagram kołowy jest bardzo podobny do diagramu <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale jest przedstawiony w bardziej graficzny sposób.<br /><br />Osoba-korzeń znajduje się w środku, jej rodzice — na pierwszym pierścieniu okalającym, dziadkowie — na drugim pierścieniu itd.<br /><br />Pod nazwiskami wyświetlane są lata urodzenia i śmierci, jeśli są znane.<br /><br />Kliknięcie na nazwisko na diagramie spowoduje otworzenie menu odnośników, specyficznych dla danej osoby. Możesz z niego wybrać wyśrodkowanie diagramu na tej osobie lub na jednej z jej bliskich krewnych, wejść na stronę #pgv_lang[indi_info]# tej osoby lub zobaczyć jej inny wykres.";
$pgv_lang["fan_width_help"]		= "~Szerokość diagramu kołowego~<br /><br />Tutaj możesz zmieniać szerokość diagramu od 50% do 300%. Ustawienie szerokości na 100% daje obraz o szerokości około 640 pikseli.";
$pgv_lang["fan_style_help"]			= "~Styl diagramu kołowego~<br /><br />Ta opcja określa wygląd diagramu.<ul><li><b>1/2</b> - diagram w kształcie półkola (180&deg;)</li><li><b>3/4</b> - diagram w kształcie trzech czwartych koła (270&deg;), zwany czasem <i>anielskim skrzydłem</i></li><li><b>4/4</b> - diagram w kształcie pełnego koła (360&deg;)</li></ul>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Diagram klepsydrowy pokazuje przodków i potomków wybranej osoby na tym samym diagramie. Jest to połączenie diagramu przodków i diagramu potomków.<br /><br />Główna osoba znajduje się na środku strony, jej potomkowie — po lewej, a przodkowie — po prawej stronie. Na tym widoku każde pokolenie jest wyrównane wzdłuż strony, od najmłodszego do najstarszego.<br /><br />Jeśli pod główną osobą znajduje się strzałka w dół, kliknięcie jej spowoduje wyświetlenie listy jej bliskich członków rodziny, dzięki której możesz przesunąć się w dół diagramu. Wybranie nazwiska z listy spowoduje ponowne wczytanie diagramu, z wybraną osobą w środku.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Ten diagram jest bardzo podobny do diagramu klepsydrowego. Pokazuje przodków i potomków wybranej osoby na jednym diagramie. Umożliwia także pokazanie potomków osoby głównej w takim samym formacie klepsydry.<br /><br />Główna osoba znajduje się na środku strony, jej potomkowie — po lewej, a przodkowie — po prawej stronie. Na tym widoku każde pokolenie jest wyrównanie wzdłuż strony, od najmłodszego do najstarszego.<br /><br />Każdy potomek głównej osoby staje się główną osobą dodatkowego diagramu klepsydrowego, pokazanego na tej samej stronie. Ten proces powtarza się, dopóki nie zostanie wyświetlona zadana liczba pokoleń potomków.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Ta wartość określa liczbę pokoleń potomków głównej osoby, wyświetlanych w formacie klepsydrowym.";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~STRONA LISTY OSÓB~<br /><br />Ta strona wyświetla listę osób. Na pierwszym miejscu znajdują się nazwiska. Lista jest ułożona w porządku alfabetycznym.<br /><br />Zawartość listy nazwisk zależy od:<ol><li>Litery wybranej w spisie alfabetycznym.</li><li>Tego, czy wybrano \"Pomiń\" czy \"Pokaż\" listę nazwisk.</li></ol>#pgv_lang[context_help]#";
$pgv_lang["alpha_help"]				= "~SPIS ALFABETYCZNY~<br /><br />Kliknięcie na literę w spisie alfabetycznym spowoduje wyświetlenie listy nazwisk, które zaczynają się na wybraną literę.<br /><br />Przedostatnim elementem spisu alfabetycznego może być <b>#pgv_lang[NN]#</b>. Ta wartość pojawi się, jeśli w bazie danych istnieją osoby, których nazwiska nie zostały podane lub nie zawierają żadnych rozpoznawanych liter. Nieznane nazwiska wprowadza się często jako znak zapytania <b>?</b>, i ten zapis zostanie potraktowany jako <b>#pgv_lang[NN]#</b>. Może się tak stać również wtedy, gdy osoba jest nieznana.<br /><br /><b>Uwaga:</b><br />Nazwiska wprowadzone jako, na przykład, <b>Nn</b>, <b>NN</b>, <b>Nieznane</b>, czy <b>N.N.</b> <u>nie zostaną</u> wymienione na liście <b>#pgv_lang[NN]#</b>. Znajdziesz je pod literą <b>N</b>, ponieważ to jest pierwsza litera tych nazwisk. PhpGedView nie jest w stanie rozpoznać wszystkich możliwych sposobów wprowadzania nieznanych nazwisk; brak odpowiedniej konwencji.<br /><br />Na końcu spisu alfabetycznego znajduje się element <b>WSZYSTKIE</b>. Kliknięcie tego elementu spowoduje wyświetlenie listy wszystkich nazwisk w bazie danych.<br /><br /><b>Brakujące litery?</b><br />Jeśli w spisie brakuje niektórych liter, oznacza to, że twoja baza danych nie zawiera żadnych nazwisk, zaczynających się na tą literę.";
$pgv_lang["name_list_help"]			= "~LISTA NAZWISK~<br /><br />W tym miejscu pojawia się lista samych nazwisk lub nazwisk wraz z imionami. W obu przypadkach wszystkie nazwiska będą zaczynać się na literę wybraną ze spisu alfabetycznego, chyba że wybrano opcję <b>WSZYSTKIE</b>.<br /><br />To, czy zobaczysz listę nazwisk, czy też nazwisk wraz z imionami, zależy od statusu odnośnika <b>Pomiń / Pokaż listę nazwisk</b>.";
$pgv_lang["skip_sublist_help"]			= "~POMIŃ PODLISTĘ~<br /><br />Domyślne ustawienie powoduje wyświetlenie podlisty z nazwiskami, kiedy klikniesz literę spisu alfabetycznego. Jeśli klikniesz ten odnośnik, zostaną od razu wyświetlone wszystkie osoby z nazwiskami zaczynającymi się na wybraną literę. W ten sposób lista osób zostanie wyświetlona od razu po kliknięciu litery spisu.<br /><br />Aby powrócić do poprzedniego ustawienia, kliknij odnośnik #pgv_lang[show_surnames]#.";
$pgv_lang["show_marnms_help"]			= "~UWZGLĘDNIJ/POMIŃ NAZWISKA PO ŚLUBIE~<br /><br />Strona listy osób i listy rodzin może uwzględniać lub pomijać nazwiska po ślubie. Ta opcja może być pomocna podczas szukania osób lub rodzin, których znasz tylko nazwiska po ślubie. Nazwiska po ślubie mogą być uwzględnione jedynie wtedy, gdy istnieją w bazie.<br /><br />Na stronie listy rodzin wartość domyślnie ustawiona jest na pomijanie nazwisk po ślubie. Na stronie listy osób wartość domyślna jest ustawiana na stronie Konfiguracji GEDCOM.<br /><br />Gdy zmienisz tę opcję, Twój wybór zostanie zapamiętany, dopóki się nie wylogujesz lub do czasu wygaśnięcia sesji.";

//-- Families-page
$pgv_lang["help_famlist.php"]		= "~STRONA LISTY RODZIN~<br /><br />Ta strona wyświetla listę rodzin. Na pierwszym miejscu znajdują się nazwiska. Lista ułożona jest w porządku alfabetycznym.<br /><br />Zawartość listy nazwisk zależy od:<ol><li>Litery wybranej w spisie alfabetycznym.</li><li>Tego, czy wybrano \"Pomiń\" czy \"Pokaż\" listę nazwisk.</li></ol>Możesz szukać po nazwisku męża lub żony; na liście znajdują się oba z nich.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["help_family.php"]			= "~STRONA DANE RODZINY~<br /><br />Ta strona wyświetla przegląd rodziny wybranej na poprzedniej stronie.<br /><br />Ramki z danymi osobowymi męża i jego rodziców, żony i jego rodziców oraz dzieci będą rozmieszczone od góry do dołu.<br /><br />Układ i zawartość ramek jest taka sama, jak ramek na stronach rodowodu i potomków.<br /><br />Po prawej stronie ramek rodziców możesz zobaczyć strzałkę, jeśli w pliku znajduje się większość przodków. Kiedy klikniesz tę strzałkę, przesuniesz się o pokolenie w górę i zobaczysz nową stronę rodziny, z poprzednimi rodzicami na miejscu męża i żony.<br /><br />Po prawej stronie wewnątrz ramki osoby możesz zobaczyć ikonkę powiększania (lupę), która umożliwia wyświetlenie większej liczby szczegółów o osobie. Kliknięcie nazwiska spowoduje przeniesienie do strony #pgv_lang[indi_info]# tej osoby.<br /><br />Również po prawej stronie znajdziesz małe menu, które umożliwia przejście do diagramów lub innych informacji. Niektóre z elementów menu mają podmenu, które pojawia się po najechaniu kursorem na dany element.<br /><br />Ramka informacji o grupie rodzinnej wyświetla wszystkie znane fakty i dane o tej rodzinie, takiej jak ślub, obiekty multimedialne i notatki. W ramce informacji o fakcie kliknięcie miejsca spowoduje przejście do listy miejsc, gdzie pokazane są wszystkie inne rodziny i osoby powiązane z tym miejscem. Kliknięcie daty spowoduje przejście do kalendarium dnia, które wyświetla wszystkie wydarzenia, które zdarzyły się tego dnia i miesiąca w historii. Kliknięcie obiektów multimedialnych spowoduje otworzenie nowego okna, umożliwiającego obejrzenie obiektu. Po kliknięciu podpisu obrazka zobaczysz obrazek na stronie #pgv_lang[media_list]#. Jeśli klikniesz odnośnik źródła, zobaczysz jego szczegóły na stronie źródła.<br /><br />Pod ramkami dzieci znajduje się odnośnik <b>Dodaj dziecko do tej rodziny</b>. Obok ramek dzieci znajduje się odnośnik <b>Informacja o grupie rodzinnej</b>. Jeśli masz odpowiednie uprawnienia, możesz tutaj edytować, usuwać i dodawać dane i fakty.<br /><br />Podobnie, jak na stronie #pgv_lang[indi_info]#, po prawej stronie u góry znajduje się menu, które umożliwia przejście do innych stron z informacją na temat danej rodziny.#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~DODAJ DZIECKO TEJ RODZINY~<br /><br />Klikając na ten odnośnik możesz dodać dziecko do tej rodziny.<br /><br />Dodawanie dziecka jest proste: wystarczy kliknąć odnośnik i wypełnić formularz w wyświetlonym okienku.";
$pgv_lang["show_fam_gedcom_help"]	= "~POKAŻ WPIS GEDCOM~<br /><br />Kiedy klikniesz ten odnośnik, zostaną wyświetlone informacje o rodzinie w postaci, w jakiej znajdują się w bazie danych. Będą to nieprzetworzone dane GEDCOM.";
$pgv_lang["add_fam_clip_help"]		= "~DODAJ RODZINĘ DO WYCINKÓW~<br /><br />Możesz dodać całą lub część informacji o tej rodzinie do swoich Wycinków. Na następnej stronie możesz dokładnie określić, które dane chcesz dodać:<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol>";
$pgv_lang["show_fam_timeline_help"]	= "~POKAŻ PARĘ NA OSI CZASU~<br /><br />Po kliknięciu tego odnośnika pojawi się oś czasu, na której zostaną wyświetlone wszystkie fakty dotyczące danej pary.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~STRONA LISTY ŹRÓDEŁ~<br /><br />Ta strona wyświetla listę źródeł.<br /><br />Inaczej niż strona #pgv_lang[indi_info]# i o rodzinie, nie ma spisu alfabetycznego.<br /><br />Źródłem może być osoba, publiczna baza danych, instytucja, zasób internetowy itp. Ze względu na bardzo zróżnicowaną naturę źródeł genealogicznych, nie istnieje sensowny sposób porządkowania w każdym przypadku. Jednak PhpGedView <u>sortuje</u> nazwy źródeł w porządku alfabetycznym.<br /><br /><b>ŹRÓDŁA</b><br />Bez źródeł nie możemy rozbudowywać naszej bazy danych. Dla każdej informacji w bazie istnieje jej źródło. Źródłem może być krewny, instytucja, publiczna baza danych, archiwa państwowe lub prywatne, zasób internetowy itp.<br /><br />Źródło może być powiązane z wieloma osobami. Jedna osoba może być również powiązana z wieloma źródłami. Może istnieć wiele źródeł dla jednego wydarzenia, takiego jak urodzenie, zawód, ślub, dzieci itp.";
$pgv_lang["sourcelist_listbox_help"]		= "~LISTA ŹRÓDEŁ~<br /><br />W tej ramce zobaczysz nazwy źródeł w postaci, w jakiej przechowywane są w pliku GEDCOM.<br /><br />Nazwy są ułożone alfabetycznie. Kliknięcie nazwy na liście spowoduje przejście do strony źródła, na której znajduje się list osób i rodzin, które są powiązane z danym źródłem.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~STRONA DANE ŹRÓDŁA~<br /><br />Ta strona wyświetla szczegółowe informacje o źródle. Źródła są bardzo ważne dla genealogów i pozwalają prześledzić ścieżkę, którą wcześniejszy badacz dotarł do informacji.<br /><br />Możesz zobaczyć tu informacje takie jak tytuł źródła, autor, publikacja i repozytorium, w którym odszukano źródło. Różne typy źródeł mogą zawierać różną ilość informacji.<br /><br />Jeśli do źródła jest przypisany obiekt multimedialny, taki jak zeskanowany dokument, możesz obejrzeć ten obiekt, klikając go. Kliknięcie nazwy obiektu spowoduje wyświetlenie go na stronie #pgv_lang[media_list]#.<br /><br />Pod informacją o źródle znajduje się lista wszystkich osób i rodzin, które są z nim powiązane. Dzięki temu możesz zidentyfikować wszystkie elementy, które zostały pobrane z tego źródła.<br /><br />W zależności od ustawień administratora możesz zobaczyć dwie dodatkowe ikonki w menu na tej stronie:<ol><li><b>#pgv_lang[view_gedcom]#</b><br />pokazuje informację w formacie GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />pozwala przechowywać informację w bloku #pgv_lang[clip_cart]#, aby móc ją później pobrać i zaimportować do innego programu genealogicznego.</li></ol><br />#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~WPISY POWIĄZANE Z TYM ŹRÓDŁEM~<br /><br />Tutaj zobaczysz nazwiska osób i rodzin, które są powiązane z danym źródłem.<br /><br />Nazwiska są uporządkowane alfabetycznie. Kliknięcie nazwiska z listy spowoduje przejście do odpowiedniej strony ze szczegółami.";
$pgv_lang["show_source_gedcom_help"]	= "~POKAŻ WPIS GEDCOM~<br /><br />Kliknięcie na ten odnośnik spowoduje wyświetlenie wpisów źródła w nieprzetworzonym formacie GEDCOM.";
$pgv_lang["add_source_clip_help"]		= "~DODAJ ŹRÓDŁO DO WYCINKÓW~<br /><br />Ten odnośnik umożliwia dodanie informacji o źródle do Wycinków, skąd możesz ją później pobrać na swój komputer i zaimportować do innego programu genealogicznego.";
$pgv_lang["delete_source_help"]					= "~USUŃ ŹRÓDŁO Z PLIKU GEDCOM~<br /><br />Kliknięcie na tę opcję spowoduje zaznaczenie tego źródła jako elementu do usunięcia z bazy danych.<br /><br />Co to oznacza?<br />Załóżmy, że masz dobry powód, aby usunąć źródło z bazy danych. Klikasz na ten odnośnik. Zostaniesz poproszony(a) o potwierdzenie usunięcia. Nawet jeśli potwierdzisz swój wybór, może upłynąć trochę czasu, zanim zobaczysz komunikat o tym, że źródło zostało usunięte.<br /><br />Poruszając się po stronie zauważysz, że źródło jest nadal widoczne i może być używane tak samo, jakby nigdy nie zostało usunięte.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["no_mistake"]							= "<b>To <u>nie jest</u> błąd.</b> Administrator strony otrzyma wiadomość, że została wprowadzona zmiana do bazy danych i usunięto źródło.<br />Administrator może zatwierdzić lub odrzucić twoją zmianę. Dopiero po zatwierdzeniu przez administratora źródło zostanie faktycznie <u>nieodwracalnie</u> usunięte. Jeśli pojawi się wątpliwość co do twojej zmiany, administrator skontaktuje się z tobą.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~HIERARCHIA MIEJSC~<br /><br />(lub osób na miejscu)<br /><br />Ta strona wyświetla hierarchię miejsc w pliku GEDCOM oraz informację o tym, które osoby i rodziny są powiązane z danym miejscem.<br /><br />PhpGedView wyszukuje dowolne powiązania między osobą lub rodziną i wydarzeniem, które zaszło w określonym miejscu.<br /><br />Wyniki mają postać dwukolumnowej listy, z osobną kolumną dla osób i osobną dla rodzin.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~FORMAT MIEJSCA~<br /><br /><b>DOMYŚLNY FORMAT</b><br />Oznacza to, że w pliku GEDCOM nie ma zdefiniowanego formatu kodowania miejsca i zostanie przyjęty format domyślny.<br /><br />Jeśli zostanie znaleziony inny format, pojawi się ujęty w nawiasy <b>(</b> i <b>)</b> na końcu wiersza.";
$pgv_lang["ppp_match_one_help"]			= "~FORMAT MIEJSCA~<br /><br />FORMAT GEDCOM<br />Miejsca są zakodowane w formacie miejsca zdefiniowanym w pliku GEDCOM. To ustawienie unieważnia format domyślny.";
$pgv_lang["ppp_numfound_help"]			= "~POWIĄZAŃ Z MIEJSCEM~<br /><br />Tutaj wyświetlona jest liczba wyników wyszukiwania. Jeśli nadal widzisz listę miejsc, oznacza to, że nie nie znajdujesz się na najniższym poziomie.<br /><br />Możesz wyświetlić wszystkie wpisy powiązane z tym miejscem lub zaostrzyć kryteria wyszukiwania, klikając na któreś miejsce.";
$pgv_lang["ppp_levels_help"]			= "~POZIOMY MIEJSCA~<br /><br />Pokazuje aktualnie wyświetlane poziomy miejsca. Lista miejsc jest podlistą skrajnie lewego poziomu.<br /><br />Przykład:<br />Domyślny format to #pgv_lang[default_form]#.<br />Jeśli bieżącym poziomem jest \"Najwyższy poziom\", lista będzie zawierać wszystkie kraje w bazie danych.<br />Jeśli bieżącym poziomem jest \"POL, Najwyższy poziom\", lista będzie zawierać wszystkie województwa w Polsce.<br />itd.<br /><br />Kliknij na odpowiedni poziom, aby przesunąć się w górę hierarchii miejsc.";
$pgv_lang["ppp_placelist_help"]			= "~HIERARCHIA MIEJSC~<br /><br />Ta lista wyświetla miejsca przypisane pod bieżące miejsce w hierarchii. Jeśli nie wybrano jeszcze żadnego miejsca, zobaczysz listę miejsc na najwyższym poziomie (np. kraje lub województwa).<br /><br />Na każdą nazwę miejsca można kliknąć; kliknięcie spowoduje przejście do kolejnego poziomu niżej.";
$pgv_lang["ppp_placelist_help2"]		= "~LISTA MIEJSC~<br /><br />Ta lista wyświetla miejsca znalezione na tym etapie.<br /><br />Na każdą nazwę z listy miejsc można kliknąć; kliknięcie spowoduje przejście na niższy poziom.<br /><br />Listy miejsc nie ma tylko na najwyższym poziomie. Na każdym niższym poziomie możesz wyświetlić listę osób i rodzin powiązanych z danym poziomem.";
$pgv_lang["ppp_view_records_help"]		= "~ZOBACZ WSZYSTKIE WPISY~<br /><br />Kliknięcie na ten odnośnik spowoduje wyświetlenie listy wszystkich osób i rodzin, dla których istnieje wydarzenie, które zaszło w danym miejscu. Kiedy dojdziesz na koniec hierarchii miejsc, przeważnie na poziom miasta lub wsi, lista osób i rodzin zostanie wyświetlona automatycznie.";
$pgv_lang["ppp_name_list_help"]			= "~LISTA NAZWISK~<br /><br />W tej ramce pojawia pełna lista osób i rodzin powiązanych z danym miejscem.<br /><br />Na każde nazwisko można kliknąć. Kliknięcie spowoduje przeniesienie do odpowiedniej strony ze szczegółami. Kliknięcie miejsca u góry tej listy spowoduje zmianę wyboru miejsca.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~LISTA OBIEKTÓW MULTIMEDIALNYCH~<br /><br />Ta strona wyświetla wszystkie obiekty multimedialne (MMO) znalezione w bazie danych.<br /><br />Każdy element multimedialny ma tytuł lub nazwę pliku, nazwiska osób lub rodzin powiązane z elementem, oraz komentarze na jego temat.<br /><br />Kliknięcie tytułu lub nazwy pliku elementu to to samo, co kliknięcie jego miniaturki: element zostanie otwarty w przeglądarce obrazów wbudowanej w PhpGedView lub w programie wskazanym w konfiguracji przeglądarki.<br /><br />Kliknięcie odnośnika \"Zobacz\" obok osoby lub rodziny spowoduje przeniesienie do odpowiedniej strony ze szczegółami.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~WGRAJ MULTIMEDIA~<br /><br />Wgrywanie multimediów jest proste. Oto kilka dodatkowych wskazówek.<br /><br /><b>Miniaturki</b><br />Miniaturki powinny mieć ok. 100 pikseli szerokości. Miniaturka <u>musi</u> nazywać się dokładnie tak samo, jak wersja w pełnym rozmiarze. Jeśli twój system potrafi automatycznie generować miniaturki, zobaczysz odpowiedni komunikat na tej stronie.<br /><br /><b>Wgrywanie</b><br />Pliki zostaną wgrane automatycznie do katalogu <b>#GLOBALS[MEDIA_DIRECTORY]#</b> (wersje w pełnym rozmiarze) oraz do katalogu <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> (miniaturki).<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Informacje ogólne</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Wydarzenie</b></a></li><li><a href=\"#calendar_button\"><b>Przyciski \"Pokaż dzień\" / \"Pokaż miesiąc\" / \"Pokaż rok\"</b></a></li><li><a href=\"#calendar_tip\"><b>Wskazówka</b></a></li></ul><br /><a name=\"calendar_general\"></a>#pgv_lang[anniversary_calendar]# wyświetla osoby i rodziny powiązane z wydarzeniem, które miało miejsce w danym dniu, miesiącu, lub określonym przedziale czasu. Zaawansowane opcje umożliwiają wybór odfiltrowanie odpowiedniej daty, okresu lub wydarzeń.<dl><dt><b><a href=\"#calendar_day\">Pokaż dzień</a></b></dt><dd>Pokazuje wydarzenia, które miały miejsce określonego dnia, niezależnie od wybranego roku. Wynikiem jest lista z nazwiskami, która może być rozdzielona na osobne kolumny dla osób i rodzin lub wspólna.</dd><dt><b><a href=\"#calendar_month\">Pokaż miesiąc</a></b></dt><dd>W tym kalendarzu nazwiska osób i rodzin znajdują się w ramkach dni. Kalendarz jest odpowiedni do wybranego roku. Pokazane są wszystkie wydarzenia, które zdarzyły się przed tym rokiem.<br /><br />W połączeniu z opcją <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, umożliwia symulację kalendarza, którego używali twoi przodkowie.</dd><dt><b><a href=\"#calendar_year\">Pokaż rok</a></b></dt><dd>Pokazuje wydarzenia w pewnym roku lub podczas pewnej liczby lat. Wynikiem jest lista z nazwiskami, która może być rozdzielona na osobne kolumny dla osób i rodzin lub wspólna.</dd></dl>Aktualnie wyświetlany dzień i miesiąc są wyróżnione w menu kalendarza.<br /><br />Można klikać na wszystkie nazwiska i daty. Kliknięcie nazwiska spowoduje przejście do odpowiedniej strony z danymi osoby. Kliknięcie daty spowoduje przejście do trybu \"Tego dnia\" lub \"Tego roku\", w którym zostaną pokazane wszystkie wydarzenia dla dnia i miesiąca wybranej daty.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a> #pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a> #pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"></a> #pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"></a> #pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a> #pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a> #pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"></a> #pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"></a> #pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~WYBÓR DNIA~<br /><br />W pierwszym rzędzie tabeli znajduje się opcja wyboru <u>dnia</u>.<br /><br />Efekt kliknięcia na dzień zależy od tego, czy jesteś w trybie <b>dnia</b> czy <b>miesiąca</b>.<br /><dl><dt><b>Tryb dnia</b></dt><dd>W tym trybie kliknięcie dnia spowoduje odświeżenie ekranu i wyświetlenie listy dla tego dnia.</dd><dt><b>Tryb miesiąca</b></dt><dd>Na ekranie masz kalendarz pewnego miesiąca. Po kliknięciu dnia ekran zostanie odświeżony, ale nadal zobaczysz miesiąc, który był tam poprzednio. Dzieje się tak, ponieważ nadal możesz wybrać inny miesiąc, rok lub wydarzenie, zanim klikniesz przycisk <b>#pgv_lang[viewday]#</b> lub <b>#pgv_lang[viewmonth]#</b>.<br /><br />Na końcu rzędu dnia zobaczysz <b>szybki odnośnik</b> z dzisiejszą datą. Kliknięcie tego odnośnika spowoduje wyświetlenie listy dla dzisiejszej daty w trybie <b>dnia</b>, niezależnie od tego, czy jesteś w trybie <b>miesiąca</b> czy <b>dnia</b>.</dd></dl>";
$pgv_lang["annivers_month_select_help"]	= "~WYBÓR MIESIĄCA~<br /><br />W środkowym rzędzie tabeli znajduje się opcja umożliwiająca wybór <u>miesiąca</u>.<br /><br />Efekt kliknięcia na miesiąc zależy od tego, czy jesteś w trybie <b>dnia</b> czy <b>miesiąca</b>.<br /><dl><dt><b>Tryb dnia</b></dt><dd>W tym trybie kliknięcie miesiąca spowoduje odświeżenie ekranu i wyświetlenie listy dla tego miesiąca. Wszelkie inne ustawienia, takie jak dzień, rok i wydarzenia, pozostaną niezmienione.</dd><dt><b>Tryb miesiąca</b></dt><dd>Na ekranie masz kalendarz pewnego miesiąca. Po kliknięciu miesiąca zostanie wyświetlony kalendarz nowego miesiąca.<br /><br />Na końcu rzędu dnia zobaczysz <b>szybki odnośnik</b> z dzisiejszym miesiącem i rokiem. Kliknięcie tego odnośnika spowoduje wyświetlenie listy dla tego miesiąca w trybie <b>miesiąca</b>, niezależnie od tego, czy jesteś w trybie <b>miesiąca</b> czy <b>dnia</b>.</dd></dl>";
$pgv_lang["annivers_year_select_help"]	= "~WPROWADZANIE ROKU~<br /><br />To miejsce pozwala zmienić rok kalendarza w trybie <b>miesiąca</b> lub rok listy w trybie <b>roku</b> mode.<br /><br />Zmiana roku nic nie zmieni w trybie <b>dnia</b>, ponieważ są w nim zawsze wyświetlane wszystkie wydarzenia dla wszystkich lat.<br /><br /><b>Opcje zaawansowane</b> dla <b>#pgv_lang[viewyear]#</b><dl><dt><b>Więcej lat</b></dt><dd>Istnieje możliwość wyszukiwania dat w pewnym przedziale lat.<br /><br />Zakresy lat liczą się <u>włącznie</u>. Oznacza to, że zakres dat rozciąga się od 1 stycznia pierwszego roku do 31 grudnia ostatniego roku. Oto kilka przykładów zakresów lat:<br /><br /><b>1992-5</b> - wydarzenia od 1992 do 1995.<br /><b>1972-89</b> - wydarzenia od 1972 do 1989.<br /><b>1610-759</b> - wydarzenia od 1610 do 1759.<br /><b>1880-1905</b> - wydarzenia od 1880 do 1905.<br /><b>880-1105</b> - wydarzenia od 880 do 1105.<br /><br />Możesz pominąć ostatnie cyfry roku, zastępując je znakiem zapytania.<br /><br />Aby uzyskać wszystkie wydarzenia z dziesięciolecia.<br /><b>197?</b> - wydarzenia od 1970 do 1979.<br />Aby uzyskać wszystkie wydarzenia z wieku.<br /><b>19??-19??</b> - wydarzenia od 1900 do 1999.</dd><dt><br /><b>Daty przybliżone</b></dt><dd>Czasami nieznana jest dokładna data wydarzenia. Aby zaznaczyć nieścisłość, do daty dodaje się terminy \"po\", \"przed\" i \"około\".<br /><br />Takie daty są przechowywane w bazie danych razem z <u>angielskim</u> skrótem terminu. W trybie <b>roku</b> możesz przeprowadzać wyszukiwanie dla tych terminów, z lub bez towarzyszącej im daty. Przykłady wyszukiwania:<br /><br /><b>abt</b> 1800 (<b>abt</b> = about, około)<br /><b>bet</b> 1950-1959 (<b>bet</b> = between, pomiędzy) wprowadź: bet 1950 lub tylko: 1950-59<br /><b>bef</b> 1950 (<b>bef</b> = before, przed)<br /><b>aft</b> 1900 (<b>aft</b> = after, po)<br /><br /><b>Uwaga:</b> PhpGedView szuka ciągu znaków dokładnie w takiej postaci, w jakiej został wprowadzony. Jeśli szukasz <b>abt&nbsp;1850</b>, data wprowadzona jako <b>abt&nbsp;oct&nbsp;1850</b> <u>nie</u> zostanie odnaleziona.<br /><br />Możesz wprowadzić sam skrót, bez roku, aby odnaleźć wszystkie wydarzenia z datą, która zawiera ten skrót.</dd></dl>Ekran nie zostanie odświeżony, kiedy wprowadzisz nowy rok. Ponieważ jest to pole, a nie odnośnik, musisz kliknąć przycisk <b>#pgv_lang[viewmonth]#</b> lub <b>#pgv_lang[viewyear]#</b> zanim będzie można zobaczyć zmianę.";
$pgv_lang["annivers_show_help"]			= "~POKAŻ WYDARZENIA DLA...~<br /><br />Dostępne są następujące opcje:<br /><ol><li><b>Wszystkie osoby</b><br />Ta opcja wyświetla wszystkie osoby i rodziny.</li><li><b>Ostatnie stulecie</b><br />Ta opcja wyświetla wydarzenia dla zadanego dnia lub miesiąca mające miejsce nie dawniej, niż 100 lat temu.</li><li><b>Osoby żyjące</b><br />Jeśli administrator nie skonfigurował PhpGedView w ten sposób, aby pokazywał publicznie żyjące osoby, dostęp do tej opcji uzyskasz dopiero po zalogowaniu.<br /><br />Ta opcja wyświetla tylko wydarzenia związane z żyjącymi osobami.</li></ol>Kliknięcie na opcję spowoduje wyświetlenie wybranych wydarzeń.<br /><br />Ustawienia dnia, miesiąca i roku oraz trybu <b>dnia</b> lub <b>miesiąca</b> pozostaną bez zmian.";
$pgv_lang["annivers_sex_help"]			= "~WYBÓR PŁCI~<br /><br />Po zalogowaniu lub jeśli administrator nie włączył opcji prywatności możesz wybrać jedną z następujących opcji:<ol><li>Ikonka <b>Wszystkie</b><br />To jest ustawienie domyślne. Wyświetla wydarzenia dla wszystkich osób i rodzin.</li><li>Ikonka <b>Mężczyźni</b><br />Wyświetla wyłącznie wydarzenia dotyczące mężczyzn. Przy wydarzeniach dla rodziny również są pokazani tylko mężczyźni.</li><li>Ikonka <b>Kobiety</b><br />Wyświetla wyłącznie wydarzenia dotyczące kobiet. Przy wydarzeniach dla rodziny również są pokazane tylko kobiety.</li></ol>Kliknięcie na opcję spowoduje wyświetlenie wybranych wydarzeń.<br /><br />Ustawienia dnia, miesiąca i roku oraz trybu <b>dnia</b> lub <b>miesiąca</b> pozostaną bez zmian.";
$pgv_lang["annivers_event_help"]		= "~WYBÓR WYDARZEŃ~<br /><br />Tutaj możesz wybrać, czy chcesz zobaczyć wszystkie wydarzenia dla osób i rodzin, czy tylko wybrany typ wydarzeń. Nie możesz wybrać na raz wielu kategorii wydarzeń.<br /><br />Kliknięcie na opcję spowoduje wyświetlenie wybranych wydarzeń.<br /><br />Ustawienia dnia, miesiąca i roku oraz trybu <b>dnia</b> lub <b>miesiąca</b> pozostaną bez zmian.";
$pgv_lang["annivers_tip_help"]			= "~WSKAZÓWKA~<br /><br />Wybierz dowolną datę z przeszłości.<br /><br />Kiedy klikniesz któryś z przycisków \"Pokaż\", zobaczysz listę lub kalendarz dla wybranej daty. Wszystkie rocznice, wiek osób itp. zostaną przeliczone i liczą się teraz od wybranego dnia. W ten sposób widzisz teraz kalendarz, którego używaliby twoi przodkowie tego samego dnia, wiele lat temu.";
$pgv_lang["day_month_help"]				= "~PRZYCISKI POKAŻ DZIEŃ / POKAŻ MIESIĄC / POKAŻ ROK~<br /><br /><ul><li>Przycisk <b>Pokaż dzień</b> służy do wyświetlenia listy wydarzeń, które miały miejsce danego dnia. Przeszukiwane są wszystkie lata, więc można wybrać tu tylko dzień i miesiąc. Zmiana roku nie spowoduje żadnej zmiany. Możesz ograniczyć listę wybierając opcję <b>Ostatnie stulecie</b> lub <b>Osoby żyjące</b>.<br /><br />Wiek osób na liście zostanie wyliczony na podstawie bieżącego roku.</li><li>Przycisk <b>Pokaż miesiąc</b> służy do wyświetlenia diagramu kalendarza dla wybranego miesiąca i roku. Tutaj również możesz ograniczyć listy wybierając opcję <b>Ostatnie stulecie</b> lub <b>Osoby żyjące</b>.<br /><br />Możesz zasymulować kalendarz twoich przodków wybierając rok z przeszłości oraz opcję <b>Ostatnie stulecie</b>. Wiek wszystkich osób zostanie przeliczony względem roku w polu \"Roku\".</li><li>Przycisk <b>Pokaż rok</b> służy do wyświetlenia listy wydarzeń dla wybranego roku. Tutaj również możesz ograniczyć listy wybierając opcję <b>Ostatnie stulecie</b> lub <b>Osoby żyjące</b>.<br /><br />Możesz także zobaczyć wydarzenia dla zakresu lat. Wystarczy wpisać początkowy i końcowy rok zakresu z myślnikiem <b>-</b> pomiędzy nimi. Przykłady:<br /><b>1992-4</b> - wydarzenia od 1992 do 1994<br /><b>1976-1984</b> - wydarzenia od 1976 do 1984<br /><br />Możesz także wprowadzić pierwsze cyfry roku, aby zobaczyć wydarzenia, które miały miejsce w latach rozpoczynających się tymi cyframi, na przykład <b>197?</b> - wszystkie wydarzenia od 1970 do 1979.</li></ul>Jeśli chcesz <b>zmienić rok</b>, <b>musisz</b> kliknąć na jeden z tych trzech przycisków. Inne ustawienia pozostaną bez zmian.";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~WYCINKI~<br /><br />Możesz \"wycinać\" i zbierać skrawki informacji z drzewa genealogicznego. Wycinki są zebrane w jednym pliku GEDCOM, który można następnie pobrać na lokalny komputer i zaimportować do innej aplikacji genealogicznej.<br /><ul><li><i>Jak robić wycinki?</i> Za każdym razem, kiedy widzisz nazwisko lub nazwę, na którą można kliknąć, możesz przejść do strony z danymi osoby, rodziny lub źródła. Znajduje się tam opcja <b>#pgv_lang[add_to_cart]#</b>. Po kliknięciu tego odnośnika pojawi się kilka opcji pobierania.</li><li><i>Jak pobierać wycinki?</i> Kiedy zgromadzisz odpowiednie wycinki, możesz pobrać je na lokalny komputer klikając odnośnik <b>Pobierz teraz</b>. Postępuj zgodnie z instrukcjami.</li></ul>";
$pgv_lang["clip_download_help"]			= "~POBIERZ WYCINKI~<br /><br />Kliknięcie tego odnośnika spowoduje przejście do następnej strony. Jeśli któryś z twoich wycinków jest powiązany z obiektami multimedialnymi, te obiekty również zostaną pokazane na stronie.<br /><br />Postępuj zgodnie z instrukcjami.";
$pgv_lang["empty_cart_help"]			= "~USUŃ WSZYSTKIE WYCINKI~<br /><br />Kliknięcie na ten odnośnik spowoduje usunięcie wszystkich elementów zgromadzonych w \"Wycinkach\".<br /><br />Jeśli nie chcesz usunąć wszystkich elementów naraz, możesz usuwać je pojedynczo, klikając na odnośnik <b>Usuń</b> w odpowiednich ramkach. Po kliknięciu takiego odnośnika <u>nie</u> pojawi się okno dialogowe z prośbą o potwierdzenie; element jest natychmiast usuwany.";
$pgv_lang["add_by_id_help"]				= "~DODAJ DO WYCINKÓW~<br /><br />To pole umożliwia wprowadzenie identyfikatora osoby, rodziny lub źródła, które ma zostać dodane do \"Wycinków\". Po dodaniu wpisu będzie można również dodać do \"Wycinków\" elementy, z którymi jest powiązany.<br /><br />Jeśli nie znasz odpowiedniego identyfikatora, skorzystaj z ikonki osoby, rodziny lub źródła obok przycisku \"Dodaj\" aby go odszukać.";
$pgv_lang["zip_help"]					= "~KOMPRESJA ZIP WYCINKÓW~<br /><br />Wybierz tę opcję, aby spakować i zapisać wycinki w pliku ZIP. Więcej informacji na temat plików ZIP znajdziesz na stronie <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.";
$pgv_lang["include_media_help"]			= "~DOŁĄCZ MULTIMEDIA~<br /><br />Wybierz tę opcję, aby dołączyć pliki multimedialne, powiązane z wpisami dodanymi do wycinków. Wybranie tej opcji spowoduje automatyczne spakowanie plików do pliku ZIP podczas pobierania.";
$pgv_lang["clip_cart_help"]				= "~WYCINKI~<br /><br />Pokazuje wszystkie zgromadzone przez ciebie wycinki. Kolumna <i>Typy</i> wskazuje typ każdego elementu, którym może być osoba (INDI), rodzina (FAM), źródło (SOUR), repozytorium (REPO), Notatka (NOTE) lub obiekt multimedialny (OBJE); każdy typ jest przedstawiony za pomocą odpowiedniej ikonki. Kolumna <i>ID</i> pokazuje identyfikator elementu danego typu. Kolumna <i>Nazwisko / Opis</i> podaje nazwisko osoby lub rodziny, albo opis elementu. Przycisk \"Usuń\" powoduje usunięcie wpisu z wycinków. <b>Usuwanie wycinków nie wymaga potwierdzania.</b>";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~POKAŻ ZMIANY W PLIKU GEDCOM~<br /><br />Ten komunikat oznacza dwie rzeczy:<ol><li>Ktoś wprowadził zmiany do pliku GEDCOM<br />Wpisy mogły zostać dodane, usunięte lub zmodyfikowane.</li><li>Zmiany nie zostały jeszcze zatwierdzone przez administratora.<br />Komunikat zniknie, kiedy zmiany zostaną zatwierdzone lub odrzucone.</li></ol>Po kliknięciu tego odnośnika możesz zobaczyć, jakie zmiany zostały wprowadzone. Jeśli zauważysz, że zmiana jest niepoprawna, zgłoś to do administratora.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~STRONA WYSZUKIWANIA~<br /><br />Mimo że ta strona wygląda niepozornie, za tymi dwoma formularzami kryje się potężna i złożona wyszukiwarka. Większość stron genealogicznych w sieci pozwala ci tylko odnaleźć nazwisko. PhpGedView umożliwia odnalezienie praktycznie wszystkiego.<br /><br />Pole \"Szukaj\" po lewej stronie ekranu jest tym samym polem, który znajduje się w nagłówku każdej strony.<br /><br />Jeśli szukasz osób związanych z konkretnym rokiem, wpisz rok. System wyszuka wszystkie powiązania.<br /><br />Szukasz nazwiska lub miejsca? Wprowadź nazwisko lub miejsce, w całości lub tylko jego fragment, a PhpGedView zrobi resztę.<br /><br /><b>Wyszukiwanie metodą Soundex</b><br />Dzięki polom po prawej stronie ekranu możesz odnaleźć nazwiska i miejsca, nawet jeśli nie wiesz dokładnie, jak się je pisze. Uwaga: Ta funkcja jest przystosowana głównie do języka angielskiego.<br /><br />Jeśli w jednym serwisie znajduje się kilka genealogicznych baz danych i administrator włączy możliwość przełączania pomiędzy nimi, twoje wyszukiwanie będzie przeprowadzone w każdej z nich.<br /><br />Więcej pomocy na temat tych dwóch formularzy uzyskasz po kliknięciu znaku zapytania <b>?</b> nad nimi.";
$pgv_lang["search_enter_terms_help"]		= "~SZUKANE SŁOWA~<br /><br />W to pole możesz wprowadzić szukane terminy, takie jak daty, imiona, nazwiska, miejsca, multimedia itp.<br /><br /><b>Maski</b><br />Stosowanie masek (znaków * lub ? zastępujących ciągi znaków) nie jest dozwolone, jednak system stosuje je automatycznie.<br /><br />Załóżmy, że wprowadzisz w pole \"Szukaj\" wyrażenie <b>Pete</b>. Wynikiem tego wyszukiwania mogą być następujące wpisy z bazy danych:<div style=\"padding-left:30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />ktoś — Urodzenie 01 stycznia 1901 <b>Pete</b>rsburg<br />itp.</div><br /><b>Daty</b><br />Wprowadzenie roku w pole \"Szukaj\" spowoduje wyświetlenie listy osób, które w jakiś sposób są powiązane z tym rokiem.<br /><br />Jeśli wprowadzisz <b>1950</b>, wynikiem będzie lista osób, dla których istnieje wydarzenie, które miało miejsce w roku 1950. Takim wydarzeniem może być urodzenie, śmierć, ślub itp.<br /><br />Jeśli wprowadzisz <b>4 Dec</b> (4 grudnia), zostaną wypisane wszystkie osoby, dla których istnieje wydarzenie, które zaszło 4 grudnia dowolnego roku. Ponadto zostaną wówczas także wypisane osoby, dla których jakieś wydarzenie miało miejsce 14 lub 24 grudnia. Jak widać, maski są używane domyślnie, więc nie trzeba ich podawać jawnie.<br /><br /><b>Właściwe podanie daty</b><br />PhpGedView szuka daty dokładnie w takiej postaci, w jakiej jest zapisana w pliku GEDCOM. Jeśli na przykład chcesz znaleźć wydarzenie, które miało miejsce 14 grudnia, wprowadź <b>14&nbsp;dec</b>, ponieważ tak data jest zapisana w bazie danych.<br /><br />Jeśli podasz <b>dec&nbsp;14</b>, wynikiem może być osoba powiązana z wydarzeniem 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>.<br /><br />Możesz także korzystać z wyrażeń regularnych. Na przykład, jeśli chcesz znaleźć wszystkie osoby powiązane z wydarzeniami w XX wieku, możesz wprowadzić wyrażenie <b>19[0-9][0-9]</b>, co spowoduje wyświetlenie osób, dla których istnieją wydarzenia z przedziału 1900-1999.<br /><br />Jeśli potrzebujesz więcej pomocy na temat systemu wyszukiwania, napisz do nas.<br /><br />#pgv_lang[soundex_search_help]# #pgv_lang[search_replace_help]#";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Tutaj możesz odszukać literówkę lub inną nieścisłość w danych i zastąpić ją poprawnym zapisem.<br /><br /><b>Szukanie</b><br />Działa dokładnie tak, jak <a href=\"help_text.php?help=search_enter_terms_help\">zwykłe wyszukiwanie</a>.<br /><br /><b>Zastępowanie</b><br />Wszystkie znalezione wystąpienia szukanego terminu w bazie danych są zamieniane na podany termin zastępujący.<br /><br /><b>Na przykład</b><br />Załóżmy, że przez przypadek popełniono literówkę imieniu twojej babci Beaty i wprowadzono \"Baeta\".<br /><br />Kiedy wpiszesz w pole \"Szukaj\" <b>Baeta</b>, w pole \"Zamień na\" - <b>Beata</b>, każde wystąpienie \"Baeta\" zostanie zastąpione przez \"Beata\".<br /><br /><b>Szukany typ danych</b><br />Wybierz zakres wyszukiwania. Możesz ograniczyć wyszukiwanie do nazwisk lub miejsc, lub nie stosować ograniczenia. Opcja <i>#pgv_lang[search_place_word]#</i> spowoduje szukanie w polu miejsca całego słowa, wprowadzonego w pole \"Szukane słowa\". Oznacza to, że wyszukiwanie dla <i>UT</i> dopasuje tylko miejsca, w których występuje słowo <b>UT</b>, a nie <i>UT</i> w innych słowach, np. Connectic<b>ut</b>.<br /><br />Nie martw się, jeśli przypadkowo zamienisz coś nie tak. Skorzystaj z odnośników \"Zatwierdź/Odrzuć zmiany\" u dołu strony, aby zatwierdzić dobre zmiany i odrzucić nieprawidłowe.<br /><br />Jeśli potrzebujesz więcej pomocy na temat systemu wyszukiwania, napisz do nas.";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex to metoda kodowania słów ze względu na ich wymowę. Umożliwia odszukanie w bazie danych nazwisk i miejsc, których dokładna pisownia nie jest znana. PhpGedView obsługuje dwa różne algorytmy Soundex, które dają bardzo odmienne rezultaty.<ul><li><b>Podstawowy</b><br />Ten algorytm, opatentowany w 1918 r. przez Russella, jest bardzo prosty i można go stosować ręcznie.<br /><br />Ponieważ algorytm podstawowy zachowuje pierwszą literę nazwy jako część kodu wynikowego, nie zadziała on, jeśli pierwsza litera nie jest właściwa. Algorytm podstawowy nie jest także odpowiedni do nazw w języku innym, niż angielski, a nawet dla języka angielskiego wyniki mogą być zaskakujące. Na przykład wyszukiwanie Soundex typu podstawowego wyrażenia <b>Smith</b> zwróci nie tylko <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, które są oczywiście wariacjami nazwiska <b>Smith</b>, ale także <b>Smead, Sneed, Smoote, Sammett, Shand</b> oraz <b>Snoddy</b>.<br /><br /></li><li><b>Daitch-Mokotoff</b><br />Ten algorytm, opracowany w 1985 r., jest o wiele bardziej złożony od metody podstawowej i niełatwo zastosować go ręcznie.<br /><br />Wyszukiwanie Soundex z użyciem tej metody daje o wiele dokładniejsze wyniki.</li></ul>Więcej szczegółów na temat obu algorytmów znajdziesz na stronie <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Żydowskiego Towarzystwa Genealogicznego</b></a>.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />Wybór <b>#pgv_lang[search_tagfon]#</b> spowoduje zignorowanie przy poszukiwaniu następujących tagów GEDCOM: <div style=\"padding-left:30px;\"><b>_PGVU</b> - Ostatnia zmiana przez<br /><b>CHAN</b> - Data ostatniej zmiany<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Funkcja wyszukiwania zawsze pomija następujące tagi: <div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div>";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Ta opcja pozwala na pokazanie wszystkich osób mających powiązania z osobą lub rodziną znalezioną w wyszukiwaniu.<br /><br />Przykład: niech osoba <b>A</b> będzie ojcem chrzestnym osoby <b>B</b>. To powiązanie jest zapisane w rekordzie osoby <b>B</b> w tagu ASSO. W rekordzie osoby <b>A</b> taki tak nie istnieje.<br /><br />Gdy ta opcja jest włączona <b>#pgv_lang[yes]#</b> i lista wyników wyszukiwania zawiera osobę <b>B</b>, osoba <b>A</b> będzie dołączona automatycznie, ponieważ osoba <b>B</b> posiada tag ASSO w rekordzie. Jednakże, gdy lista wyników wyszukiwania zawiera osobę <b>A</b>, osoba <b>B</b> nie będzie dołączona, bo w rekordzie osoby <b>A</b> nie istnieje tag ASSO.";

//-- Advanced Search-page
$pgv_lang["advanced_search_help"] = "~#pgv_lang[advanced_search]#~<br /><br />Ta funkcja umożliwia wyszukiwanie określonych pól rekordów Person w Twojej bazie danych genealogicznych.<br /><br />Po kliknięciu przycisku <b>#pgv_lang[search]#</b> zostaną sprawdzone wszystkie pola, dla których wprowadzono wartości, a rekordy w Twojej bazie danych genealogicznych, które spełniają <u>wszystkie</u> kryteria, zostaną zwrócone. Podczas gdy początkowe okno dialogowe oferuje niektóre z bardziej powszechnych pól, na dole okna dialogowego możesz kliknąć <b>#pgv_lang[more_fields]#</b>, aby rozwinąć listę pól do sprawdzenia.<br /><br />~Pola zawierające daty~<br />Zaawansowane wyszukiwania są oparte na latach, więc w przeciwieństwie do procedury «#pgv_lang[search_general]#», która może zaakceptować datę bez roku, wszystkie te pola wymagają co najmniej roku, ale mogą również akceptować pełne specyfikacje dnia, miesiąca i roku. Na przykład nie można wyszukiwać czegoś, co wydarzyło się w kwietniu dowolnego roku.<br /><br />Każde pole daty wyszukiwania ma również modyfikator, dzięki czemu możesz wyszukiwać datę <b>#pgv_lang[exact]#</b> zgodnie z wprowadzonym kodem lub datę względną z <b>+/-</b> liczbą lat. Wpisanie roku w polu daty, a następnie wybranie modyfikatora, a następnie kliknięcie przycisku <b>#pgv_lang[search]#</b> spowoduje wyświetlenie listy osób powiązanych z tym rokiem lub zakresem lat.<br /><br />Na przykład, jeśli wpiszesz «APR 1950» w polu daty urodzenia, które ma modyfikator <b>#pgv_lang[exact]#</b>, wynikiem będą wszystkie osoby, których wydarzenie miało miejsce tylko w kwietniu 1950. Każde pole daty będzie przeszukiwać daty specyficzne dla tego wydarzenia. Dodanie modyfikatora <b>+/- 10</b> zwróci daty pomiędzy 1 kwietnia 1940 a 31 marca 1960. Pozostałe modyfikatory podobnie zmienią zakresy lat wyszukiwania. Wpisując tylko rok, na przykład «1950», wyszukiwanie zwróci wszystkie wydarzenia w określonym roku.<br /><br /><b>Format daty dla wyszukiwań</b><br />Ani symbole wieloznaczne, ani wyrażenia regularne nie mogą być używane w polach daty wyszukiwania. Kolejność dnia, miesiąca, roku i kapitalizacja nie mają znaczenia. «dd MMM rrrr» ma to samo znaczenie co «rrrr MMM dd». Jednak jeśli chcesz wyszukać wydarzenie z 14 grudnia 1926 r., powinieneś wpisać je jako «14 DEC 1926», ponieważ w ten sposób data jest przechowywana w bazie danych. Aby wyszukać datę w wielu wydarzeniach (tj. narodzinach, zgonach, małżeństwach, bar micwach, zapieczętowaniach LDS itp.) lub jeśli znany jest tylko dzień lub miesiąc, lepiej jest użyć funkcji «#pgv_lang[search_general]#».<br /><br />~Pola zawierające nazwy~<br />Pola <b>#pgv_lang[given_name]#</b> i <b>#pgv_lang[surname]#</b> mogą być używane do określania różnych części imienia, które mają być przeszukiwane. To z łatwością filtruje imiona, które mogą być zarówno imionami, jak i nazwiskami, na przykład «Terry» lub «Henry».<br /><br />Pola nazw mają również modyfikator, który pomaga w kwalifikowaniu tego, co jest wprowadzane, a co wyszukiwane. Modyfikatory obejmują:<ul><li><b>#pgv_lang[exact]#</b>&nbsp;&nbsp;określa wyszukiwanie całego pola z uwzględnieniem wielkości liter dla dokładnie wprowadzonego tekstu. Wyszukiwanie jest również wrażliwe na wszystkie osadzone znaki, odstępy itp. Na przykład, jeśli pole zawiera jedną spację, ale rekord w bazie danych ma dwie w tej samej pozycji, rekord nie zostanie znaleziony.</li><li><b>#pgv_lang[begins_with]#</b>&nbsp;&nbsp;określa wyszukiwanie bez uwzględniania wielkości liter dla rekordów, w których jakiekolwiek imię zaczyna się od tego, co znajduje się w polu. Jeśli pole nazwy zawiera wiele imion (takich jak pierwsze i drugie imię), dopasowanie zostanie wykonane z początkiem każdej części imienia, która jest oddzielona spacją.</li><li><b>#pgv_lang[contains]#</b>&nbsp;&nbsp;określa wyszukiwanie bez uwzględniania wielkości liter dla rekordów, w których pełne dane wprowadzone w polu będą przeszukiwane w dowolnym miejscu w tekście nazwy rekordu docelowego. Na przykład umieszczenie pojedynczej spacji w polu wyszukiwania <b>#pgv_lang[given_name]#</b> z modyfikatorem <b>#pgv_lang[contains]#</b> spowoduje znalezienie wszystkich rekordów, które muszą zawierać imię i co najmniej jedno drugie imię lub inicjał.</li><li><b>#pgv_lang[sounds_like]#</b>&nbsp;&nbsp;określa wyszukiwanie bez uwzględniania wielkości liter dla rekordów, które są podobne do tego, co znajduje się w polu. Umożliwia to przeszukiwanie bazy danych pod kątem nazw i miejsc, gdy nie wiesz dokładnie, jak są zapisane.</li></ul><br />~Pola bez modyfikatorów~<br />Wpisy w polach bez modyfikatorów są wyszukiwaniami bez uwzględniania wielkości liter. Wprowadzony tekst będzie przeszukiwany w dowolnym miejscu w tekście zdarzenia rekordu docelowego.";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~Strona #pgv_lang[indi_info]#~<br /><br />Ta strona wyświetla wszystkie informacje na temat danej osoby.<br /><br />Jeśli dla tej osoby dostępne jest zdjęcie, pojawi się u góry po lewej stronie. Obok zdjęcia zobaczysz jej imię i nazwisko.<br /><br />Nazwiska mogą mieć przypisane do nich notatki i źródła. W takim przypadku zobaczysz je wypisane pod nazwiskiem, do którego się odnoszą.<br /><br />Osoba może mieć także przezwisko: \"znany(a) także jako\". W takim przypadku ono również zostanie wyświetlone.<br /><br />Jeśli masz prawo do edycji danych tej osoby, zobaczysz również odnośniki <b>Edytuj</b> i <b>Usuń</b> obok elementów, które możesz zmieniać.<br /><br />Na tej stronie znajdują się zakładki <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b> oraz <b>#pgv_lang[relatives]#</b>. Wyświetlają one wszystkie informacje przechowywane w bazie danych na temat danej osoby.<br /><ul><li>Zakładka <b>#pgv_lang[personal_facts]#</b> wyświetla fakty i szczegóły na temat wybranej osoby oraz każdy fakt o jej małżeństwie. Kliknięcie dowolnej daty na tej zakładce spowoduje przeniesienie do #pgv_lang[anniversary_calendar]# tej daty, dzięki czemu zobaczysz inne wydarzenia, które miały miejsce tego samego dnia. Kliknięcie miejsca przeniesie cię do Hierarchii miejsc, gdzie zobaczysz inne osoby, powiązane z wydarzeniami w tym samym miejscu. Przy faktach dotyczących rodziny, na przykład małżeństwa, dostępne są również dane małżonka, dzięki czemu możesz zobaczyć jego szczegóły, oraz odnośnik do wpisu o rodzinie.</li><li>Zakładka <b>#pgv_lang[notes]#</b> wyświetla wszelkie ogólne notatki odnoszące się do danej osoby.</li><li>Zakładka <b>#pgv_lang[ssourcess]#</b> wyświetla wszystkie <u>ogólne</u> źródła dla tej osoby. Są to źródła <u>nie</u> powiązane z żadnymi pojedynczymi faktami, nawet z nazwiskiem osoby; są przypisane z samą osobą. Kliknięcie tytułu źródła spowoduje przeniesienie do bardziej szczegółowej strony informacji o źródle, która wyświetli również inne osoby, powiązane z tym samym źródłem.</li><li>Zakładka <b>#pgv_lang[media]#</b> wyświetli wszystkie zdjęcia i inne obiekty multimedialne przypisane do danej osoby. Kliknięcie miniaturki zdjęcia spowoduje otworzenie zdjęcia w powiększeniu. Kliknięcie podpisu zdjęcia spowoduje otworzenie zdjęcia na stronie #pgv_lang[media_list]#.</li><li>Zakładka <b>#pgv_lang[relatives]#</b> wyświetla rodzeństwo, rodziców, wszystkich małżonków i dzieci danej osoby. Te osoby umieszczone są w ramkach podobnych do tych, które możesz zobaczyć na diagramach.</li></ul>Po prawej stronie ekranu znajduje się ramka z odnośnikami. Wiele z tych odnośników wygląda tak samo, jak odnośniki w menu. Na przykład kliknięcie odnośnika <b>#pgv_lang[pedigree_chart]#</b> przeniesie cię do diagramu rodowego danej osoby. Jednak różni się to od opcji menu, ponieważ wybranie diagramu z menu spowoduje przeniesienie do domyślnego diagramu tej bazy danych.<br /><br />Jeśli ta opcja została włączona przez administratora, możesz także zauważyć odnośnik <b>#pgv_lang[view_gedcom]#</b>. Umożliwia on zobaczenie nieprzetworzonego wpisu GEDCOM tej osoby.<br /><br />Jeśli administrator włączył opcję #pgv_lang[clip_cart]#, zobaczysz także odnośnik pozwalający dodać tę osobę do twoich wycinków.<br /><br />Jeśli jesteś zalogowany(-a) i masz identyfikator GEDCOM, zobaczysz odnośnik <b>#pgv_lang[relationship_to_me]#</b>, który przeniesie Cię do diagramu rodowego i pokaże, w jaki sposób jesteś spokrewniony(-a) z daną osobą.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_person_help"]					= "~USUŃ OSOBĘ Z PLIKU GEDCOM~<br /><br />Kliknięcie tej opcji spowoduje zaznaczenie tej osoby do usunięcia z bazy danych.<br /><br />Co to oznacza?<br />Załóżmy, że masz dobry powód, aby usunąć tę osobę z bazy danych. Klikasz na ten odnośnik. Zostaniesz poproszony(a) o potwierdzenie usunięcia. Nawet jeśli potwierdzisz swój wybór, może upłynąć trochę czasu, zanim zobaczysz komunikat o tym, że osoba została usunięta.<br /><br />Poruszając się po stronie zauważysz, że osoba jest nadal widoczna tak samo, jakby nigdy nie została usunięta.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["delete_name_help"]					= "~EDYTUJ lub USUŃ NAZWISKO W PLIKU GEDCOM~<br /><br /><b>EDYTUJ NAZWISKO</b><br />Kiedy klikniesz ten odnośnik otworzy się nowe okno, w którym możesz edytować nazwisko osoby. Wprowadź zmiany w odpowiednie pola i kliknij przycisk, a następnie zamknij okno.<br /><br /><b>USUŃ NAZWISKO</b><br />Kliknięcie tej opcji spowoduje zaznaczenie tego nazwiska do usunięcia z bazy danych. Zauważ, że jest to zupełnie co innego, niż usuwanie osoby. Usuwanie nazwiska usuwa jedynie nazwisko z wpisu o osobie. Sama osoba <u>nie</u> zostanie usunięta. Jeśli chcesz usunąć przezwisko, osoba nadal zachowa swoje pozostałe imiona i nazwiska. Jeśli chcesz usunąć <u>jedyne</u> nazwisko, jakie posiada dana osoba, ta osoba nadal nie zostanie usunięta, ale zostanie zapisana jako <b>#pgv_lang[NN]#</b>. Zostaną również zachowane jej powiązania z krewnymi, źródłami, notatkami itp.<br /><br />Jak to działa?<br />Zostaniesz poproszony(a) o potwierdzenie usunięcia. Nawet jeśli potwierdzisz swój wybór, może upłynąć trochę czasu, zanim zobaczysz komunikat o tym, że nazwisko zostało usunięte.<br /><br />Poruszając się po stronie zauważysz, że nazwisko jest nadal widoczne tak samo, jakby nigdy nie zostało usunięte.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["add_name_help"]				= "~DODAJ NOWE IMIĘ/NAZWISKO~<br /><br />Ten odnośnik umożliwia dodanie nowego imienia lub nazwiska do danej osoby. Niektórzy używają innych imion, pseudonimów lub aliasów. Ten odnośnik pozwala wpisać dodatkowe imię lub nazwisko bez zmieniania starego.";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Ten odnośnik umożliwia dodanie dziecka do tej rodziny. \"Ta rodzina\" w tym kontekście oznacza ojca i matkę głównej osoby na tym ekranie.<br /><br />Pamiętaj, że dodajesz rodzeństwo tej osoby. Dodawanie jest proste: wystarczy kliknąć odnośnik i wypełnić odpowiednie pola w nowym oknie.<br /><br />Jeśli chcesz dodać syna lub córkę głównej osoby, zejdź w dół i kliknij odnośnik na \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Ten odnośnik umożliwia dodanie dziecka do tej rodziny. \"Ta rodzina\" w tym kontekście oznacza główną osobę na tej stronie oraz jej małżonka.<br /><br />Pamiętaj, że dodajesz dziecko tej osoby. Dodawanie jest proste: wystarczy kliknąć odnośnik i wypełnić odpowiednie pola w nowym oknie.<br /><br />Jeśli chcesz dodać brata lub siostrę głównej osoby, przewiń ekran w górę i kliknij odnośnik na \"#pgv_lang[as_spouse]#\".";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Ten odnośnik umożliwia powiązanie tej osoby jako dziecko z istniejącą rodziną.<br /><br />Załóżmy, że przedtem rodzice danej osoby byli nieznani, ale później odkryłeś(-aś), że znajdują się już w tej bazie danych.<br /><br />Wystarczy teraz kliknąć odnośnik i wprowadzić identyfikator rodziny. Jeśli nie znasz identyfikatora rodziny, możesz go znaleźć za pomocą odpowiedniego odnośnika.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_new_husband]#~<br /><br />Ten odnośnik umożliwia powiązanie tej osoby jako męża z rodziną istniejącą w bazie danych. Kliknięcie tego odnośnika spowoduje dodanie tej osoby do istniejącej rodziny, w której mąż był do tej pory nieznany. Ta osoba zajmie miejsce uprzednio nieznanego męża. Wszystkie wydarzenia, dane małżeństwa i dzieci zachowają swoje powiązania z rodziną.<br /><br />Wystarczy kliknąć odnośnik i wprowadzić identyfikator rodziny. Ta zaawansowana opcja powinna być użyta tylko wtedy, kiedy rodzina już istnieje w bazie danych. Jeśli chcesz dodać <u>nową</u> rodzinę do tej osoby, użyj odnośnika <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Kliknięcie tego odnośnika spowoduje dodanie <u>nowego</u> mężczyzny i powiązanie go z główną osobą w roli nowego męża.<br /><br />Po kliknięciu odnośnika otworzy się nowe okno z formularzem. Wypełnij jak najwięcej pól i kliknij przycisk \"Zapisz\".";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Ten odnośnik umożliwia powiązanie innej osoby, już istniejącej w bazie danych, jako męża z daną osobą. Spowoduje to utworzenie nowej rodziny z wybranym mężem. Możesz także wprowadzić dane małżeństwa dla tej nowej rodziny.";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Klikając to łącze możesz dodać <u>nowe</u> dziecko do tej osoby, tworząc rodzinę z jednym rodzicem.<br /><br />Wystarczy kliknąć link, a pojawi się okno pop-up, w którym będzie można dodać nową osobę. Wypełnij tyle pól, ile tylko jest możliwe, a następnie kliknij przycisk <b>Zapisz</b>.<br /><br />To wszystko.";
$pgv_lang["link_wife_help"]			= "~#pgv_lang[link_as_wife]#~<br /><br />Ten odnośnik umożliwia powiązanie tej osoby jako żony z rodziną istniejącą w bazie danych.<br /><br />Wystarczy kliknąć odnośnik i wprowadzić identyfikator rodziny. Ta zaawansowana opcja powinna być użyta tylko wtedy, kiedy rodzina już istnieje w bazie danych. Jeśli chcesz dodać <u>nową</u> rodzinę do tej osoby, użyj odnośnika <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]			= "~#pgv_lang[add_new_wife]#~<br /><br />Kliknięcie tego odnośnika spowoduje dodanie <u>nowej</u> kobiety i powiązanie jej z główną osobą w roli nowej żony.<br /><br />Po kliknięciu odnośnika otworzy się nowe okno z formularzem. Wypełnij jak najwięcej pól i kliknij przycisk \"Zapisz\".";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Ten odnośnik umożliwia powiązanie innej osoby, już istniejącej w bazie danych, jako żony z daną osobą. Spowoduje to utworzenie nowej rodziny z wybraną żoną. Możesz także wprowadzić dane małżeństwa dla tej nowej rodziny.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~DODAJ NOWEGO OJCA LUB MATKĘ~<br /><br />Na pewno istnieje w pliku GEDCOM wiele osób, których nie ma wprowadzonych informacji o ojcu lub matce.<br /><br />W tym przypadku na stronie <b>#pgv_lang[indi_info]#</b>, na zakładce <b>#pgv_lang[relatives]#</b>, w tabeli <b>#pgv_lang[as_child]#</b> znajdziesz odnośniki do dodania <u>nowego</u> ojca lub matki do danej osoby.<br /><br />Pamiętaj, że te odnośniki służą do dodawania <u>nowego</u> ojca lub matki. Jeśli rodzic istnieje już w bazie danych, musisz użyć odnośnika <b>#pgv_lang[link_as_child]#</b>, który znajdziesz na tej stronie <b>#pgv_lang[indi_info]#</b> poniżej ostatniej tabeli.";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br /><br />~#pgv_lang[show_fact_notes]#~<br /><br />Gdy ta opcja jest włączona, można zobaczyć wszystkie źródła i notatki połączone z daną osobą.";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br /><br />Gdy ta opcja jest zaznaczona w zakładce «#pgv_lang[relatives]#» zostanie pokazana różnica wieku pomiędzy:<br /><ul><li>datami urodzin małżonków.<br />Wartość ujemna wskazuje, że żona jest starsza od męża.<br /><br /></li><li>datą ślubu a urodzinami pierwszego dziecka.<br />Wartość ujemna wskazuje na to, że dziecko urodziło się przed ślubem lub, że podane daty są błędne.<br /><br /></li><li>datami urodzin dzieci.<br />Wartość ujemna wskazuje, że dzieci są wprowadzone w złej kolejności lub mają ustwione nieprawidłowe daty narodzin.</li></ul>";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~DODAJ NOWE FAKTY~<br /><br />Tutaj możesz dodać fakt do edytowanego wpisu.<br /><br />Napierw wybierz fakt z listy, a następnie kliknij przycisk <b>Dodaj</b>. Na tej liście znajdują się wszystkie fakty, jakie możesz dodać.";
$pgv_lang["add_custom_facts_help"]		= "~Dodaj własny fakt~<br /><br />Jeśli nie możesz znaleźć faktu na liście faktów GEDCOM, możesz również wprowadzić <b>własny fakt</b>.<br /><br />Wprowadzanie własnego faktu jest równie proste, jak wybieranie predefiniowanego. Jedyną różnicą jest to, że musisz nazwać ten fakt, zamiast wybierać jego nazwę z listy. Musisz to zrobić w polu <b>#pgv_lang[type]#</b>.";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~DODAJ NOWĄ NOTATKĘ~<br /><br />Tutaj możesz dodać notatkę do danego wpisu.<br /><br />Po kliknięciu odnośnika otworzy się nowe okno, w którym będzie można wprowadzić treść notatki. Następnie kliknij przycisk poniżej i zamknij okno.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br /><br />W tym miejscu możesz dodać wspólną (połączoną) notatkę do wpisu. Gdy klikniesz odnośnik <b>#pgv_lang[add_shared_note]#</b> otworzy się nowe okno. Możesz wybrać powiązanie z istniejącą wspólną notatką lub utworzyć nową notatkę jednocześnie tworząc powiązanie z nią.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]		= "#pgv_lang[multiple_help]#<br />~DODAJ NOWE ŹRÓDŁO~<br /><br />Tutaj możesz wprowadzić <b>źródło</b> dla tego wpisu.<br /><br />Po kliknięciu odnośnika otworzy się nowe okno, w którym będzie można wybrać źródło z listy (\"Znajdź identyfikator\") lub utworzyć nowe źródło i dodać cytat.<br /><br />Dodawanie źródeł jest ważnym elementem genealogii, ponieważ pozwala innym badaczom na weryfikację twojego źródła informacji.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />Jednym z miłych udogodnień jest dodawanie multimediów do pliku GEDCOM. Dodawanie zdjęć i innych multimediów znacznie podnosi atrakcyjność systemu.<br /><br /><b>Co trzeba wiedzieć o multimediach</b><br />Istnieje wiele formatów multimediów. PhpGedView potrafi obsługiwać większość z nich, jednak jest kilka rzeczy, o których należy pamiętać.<br /><ul><li><b>Formaty</b><br />Pliki graficzne można edytować i zapisywać w wielu formatach, takich jak .jpg, .png, .bmp, .gif itp. Jeśli do utworzenia różnych formatów użyto tego samego pliku podstawowego, wyświetlana grafika będzie miała ten sam rozmiar, niezależnie od formatu, jednak pliki przechowywane w bazie danych będą się znacznie różniły rozmiarem. Ogólnie obrazki .jpg są uważane za najbardziej efektywne pod względem zajmowanego miejsca na dysku.</li><li><b>Rozmiar obrazka</b><br />Im większy oryginalny obraz, tym większy rozmiar pliku wynikowego. Obrazek powinien mieścić się na ekranie bez potrzeby przewijania; maksymalna wysokość i szerokość nie powinna być większa od wysokości i szerokości ekranu. PhpGedView jest zaprojektowany dla ekranów o rozdzielczości 1024x768 pikseli, ale obszar wyświetlania obrazków jest nieco mniejszy; rozmiar obrazka powinien być odpowiednio dostosowany. Ze względu na rozmiary plików, preferowane są mniejsze obrazki.</li><li><b>Rozdzielczość</b><br />Rozdzielczość obrazka wyraża się zwykle w jednostkach \"dpi\" (ang. dots per inch, plamek na cal), ale ma to sens tylko dla drukowania. Dla obrazków pokazywanych na ekranie poprawną miarą jest całkowita liczba pikseli. Dla potrzeb druku obraz powinien mieć rozdzielczość ok. 150 - 300 dpi, zależnie od możliwości drukarki. Rozdzielczości ekranu rzadko przekraczają 70 pikseli na cal. Jeśli twój obraz nie będzie nigdy drukowany, możesz bez obawy zmniejszyć jego rozdzielczość (a dzięki temu — rozmiar pliku) nie pogarszając jego jakości. Drukowanie powiększonego obrazu w niskiej rozdzielczości powoduje pogorszenie jakości; będzie miał ziarnisty wygląd.</li><li><b>Głębia koloru</b><br />Innym sposobem zmniejszenia rozmiaru pliku jest zmniejszenie liczby kolorów użytych na obrazku. Głębia kolorów może wahać się od obrazka czarno-białego (dwa kolory) do prawdziwych kolorów (miliony kolorów). Możesz sprawdzić, że im więcej kolorów, tym większy rozmiar pliku.</li></ul><b>Dlaczego rozmiar pliku jest ważny?</b><br /><ul><li>Przestrzeń. Nasza przestrzeń na serwerze jest ograniczona. Im więcej dużych plików, tym więcej potrzeba przestrzeni na serwerze. Im więcej przestrzeni potrzeba, tym wyższe koszty.</li><li>Przepustowość łącza. Im więcej danych nasz serwer musi przesyłać do zdalnych komputerów (takich jak twój), tym wyższe koszty. Dzieje się tak, ponieważ zdolność przesyłania łącza internetowego na serwerze jest ograniczona i musi być ono dzielone (tak jak i koszty) pomiędzy wszystkie aplikacje działające na serwerze.</li><li>Czas pobierania. W przypadku dużych plików użytkownicy (tacy jak ty) muszą czekać dłużej na załadowanie się strony z plikiem. Przy tym nie każdy posiada szybkie łącze internetowe.</li></ul><b>Jak wgrywać multimedia</b><br />Są dwa sposoby wgrywania multimediów na serwer. W przypadku większej liczby multimediów do umieszczenia należy skontaktować się z administratorem i ustalić najlepszą strategię. Jeśli administrator włączył tę opcję, możesz użyć formularza \"Wgraj multimedia\" z menu #pgv_lang[mgv]#. Możesz także skorzystać z opcji \"Wgraj\" na formularzu \"Multimedia\" aby wgrać pojedynczy element.";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br /><br />Ta opcja wygeneruje miniaturki dla wszystkich plików niemających miniaturek i znajdujących się w bieżącym katalogu. To jest wygodniejsze niż klikanie odnośnika <b>#pgv_lang[gen_thumb]#</b> dla każdego pliku oddzielnie.<br /><br />Jeśli chcesz mieć kontrolę nad tym, które pliki powinny mieć miniaturki, nie używaj tej opcji. Zamiast tego użyj odpowiednich odnośników <b>#pgv_lang[gen_thumb]#</b>.";
$pgv_lang["add_facts_general_help"]		= "~Ogólne informacje na temat dodawania~<br /><br />Po dodaniu przez ciebie faktu, notatki, źródła lub pliku multimedialnego do wpisu w bazie danych, dodatek musi zostać zatwierdzony przez użytkownika z odpowiednimi uprawnieniami.<br /><br />Dopóki zmiany nie zostaną zatwierdzone, są wyróżnione jako \"zmiany w toku\" przez kolorowe obramowanie. Każdy użytkownik z prawem edycji może zobaczyć te zmiany wraz z oryginalną informacją. Użytkownicy, którzy nie mają prawa do edycji, zobaczą tylko dane sprzed zmiany. Po zatwierdzeniu obramowania znikną i nowe dane zajmą miejsce starych. Od tego momentu nowe dane są także widoczne dla użytkowników bez prawa edycji.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Tutaj możesz zmieniać swoje ustawienia i preferencje.<br /><br />Możesz zmienić swój login, imię i nazwisko, hasło, język, adres email, motyw strony i preferowaną metodę kontaktu.<br /><br />Nie możesz zmienić swojego indentyfikatora GEDCOM; tej zmiany może dokonać wyłącznie administrator.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />Tutaj możesz zmienić swój login. Jeśli nie lubisz swojego loginu lub masz inny powód, aby go zmienić, skorzystaj z tego formularza.<br /><br />Wielkie i małe litery w loginie <u>mają znaczenie</u>. Oznacza to, że <b>Jan</b> to nie to samo, co <b>jan</b> albo <b>JAN</b>.<br /><br />Należy używać <u>wyłącznie</u> liter z alfabetów obsługiwanych przez PhpGedView. Możesz używać wielkich i małych liter z lub bez znaków diakrytycznych (np. ogonków), cyfr, myślnika (-) i podkreślenia (_). <u>Nie</u> używaj znaków interpunkcyjnych ani spacji.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />Tutaj możesz zmienić swoje imię. Jest to imię, które widzą inni użytkownicy, kiedy jesteś zalogowany(a).<br /><br />Mimo że można wpisać tu dowolną wartość, należy poinformować administratora o wprowadzanej zmianie. Nagłe pojawienie się na stronie nieznanej osoby może wzbudzić niepokój innych użytkowników. Administrator może dowiedzieć się o zmianie bez otrzymania powiadomienia, jednak powinno się oszczędzić mu dodatkowej pracy.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />Tutaj możesz zmienić swoje nazwisko. Jest to nazwisko, które widzą inni użytkownicy, kiedy jesteś zalogowany(a).<br /><br />Mimo że można wpisać tu dowolną wartość, należy poinformować administratora o wprowadzanej zmianie. Nagłe pojawienie się na stronie nieznanej osoby może wzbudzić niepokój innych użytkowników. Administrator może dowiedzieć się o zmianie bez otrzymania powiadomienia, jednak powinno się oszczędzić mu dodatkowej pracy.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />To jest identyfikator, który wiąże się z twoimi danymi w bazie danych.<br /><br />Nie możesz zmienić tego identyfikatora; jest on ustawiony przez administratora. Jeśli uważasz, że ten identyfikator jest niepoprawny i trzeba go zmienić, skontaktuj się w tej sprawie z administratorem.";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />To jest główna osoba (korzeń) dla wszystkich twoich diagramów i wykresów.<br /><br />Jeśli na przykład klikniesz odnośnik do rodowodu, zobaczysz tę osobę w ramce na lewym brzegu diagramu. Tą osobą nie musisz być ty; możesz wybrać dowolną osobę (na przykład dziadka lub ciotkę swojej matki) tak długo, jak masz prawo oglądania danych tej osoby.<br /><br />To ustawienie ma wpływ na większość diagramów i wykresów. Możesz także ustawić główną osobę na stronie każdego diagramu, ale takie ustawienie będzie działało tylko dla tej określonej strony w danym momencie.";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />Dobrym zwyczajem jest regularne zmienianie swojego hasła. Pamiętaj, że każdy, kto zna twój login i hasło może uzyskać dostęp do twoich danych.<br /><br />Hasło powinno mieć przynajmniej 6 znaków; im więcej, tym lepiej. Można używać wielkich i małych liter z lub bez znaków diakrytycznych (np. ogonków), cyfr, myślnika (-) i podkreślenia (_). <u>Nie</u> używaj znaków interpunkcyjnych ani spacji. Najlepiej stosować połączenie wielkich i małych liter, cyfr i innych znaków, na przykład: <b>5Z_q\$P4=r9</b>.<br /><br />Podobnie, jak w loginie, wielkie i małe litery w haśle <u>mają znaczenie</u>. Oznacza to, że <b>Tajne.Hasło!#13</b> to nie to samo, co <b>tajne.hasło!#13</b> ani <b>TAJNE.HASŁO!#13</b>.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Każdą zmianę hasła należy potwierdzić. Jest to zabezpieczenie przed popełnieniem literówki przy wpisywaniu hasła w polu \"Hasło\".<br /><br />Jeśli hasło nie jest identyczne z potwierdzeniem, pojawi się odpowiedni komunikat i będzie trzeba od nowa wpisać zarówno hasło, jak i potwierdzenie.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Tutaj możesz zmienić język, w jakim będą wyświetlane wszystkie strony i komunikaty PhpGedView po zalogowaniu.<br /><br />Kiedy pierwszy raz odwiedzasz ten serwis, PhpGedView zakłada, że chcesz zobaczyć wszystko w języku, który jest ustawiony jako preferowany język twojej przeglądarki. Jeśli to założenie jest niepoprawne, możesz je tutaj skorygować. Na przykład twoja przeglądarka może być ustawiona na język angielski, ponieważ jest to język najczęściej spotykany w sieci, jednak do celów genealogicznych wolisz korzystać z języka polskiego. Tutaj możesz wybrać odpowiedni język.<br /><br />Administrator określa, jakie języki masz do wyboru. Jeśli twojego języka nie ma na liście, musisz skontaktować się z administratorem.<br /><br />Pamiętaj, że PhpGedView jest projektem rozwijanym przez międzynarodowy zespół nieopłacanych wolontariuszy. Eksperci przychodzą i odchodzą. W rezultacie obsługa języków innych niż angielski jest czasem gorszej jakości.<br /><br />Jeśli zauważysz brak tłumaczenia, tłumaczenie niepoprawne lub niezgrabne, powiadom administratora. Administrator skontaktuje się z zespołem PhpGedView i przedstawi twoje spostrzeżenia. A jeszcze lepiej, sam(a) zgłoś się na ochotnika. Przyda nam się każda pomoc.";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Poprawny adres email to podstawa naszego kontaktowania się z tobą.<br /><br />Kiedy dostajesz nowy adres email, na przykład, kiedy zmieniasz dostawcę usług internetowych, nie zapomnij także zmienić adresu w tym miejscu. Nie otrzymasz potwierdzenia, kiedy zmieniasz ten adres, ale wszelkie nowe wiadomości do ciebie będą wysyłane na nowy adres.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Ta strona może mieć różne style wyglądu. W niektórych aplikacjach nazywa się je \"skórkami\", w innych - tak jak u nas - są to \"motywy\".<br /><br />Każdy motyw wyświetla te same dane, ale sposób prezentacji, a nawet rozmieszczenie elementów, może się różnić. Przypomina to wkładanie obrazka do nowej ramki i wieszanie go w innym pokoju. Obrazek się nie zmienia, ale sposób, w jaki go widzisz, jest całkiem inny.<br /><br />Spróbuj. Ustaw inny motyw. Popatrz na niego, wybierz inny. Zmień na ten, który ci najbardziej odpowiada. Kiedy zalogujesz się następnym razem, zobaczysz ostatnio używany motyw; nie musisz nawet wchodzić na tę stronę konfiguracyjną, aby go zmienić.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />PhpGedView ma kilka sposobów kontaktowania się z użytkownikami. Administrator określa metodę kontaktowania się ze sobą. Ty możesz wybrać sposób kontaktowania się innych użytkowników z <u>tobą</u>. W zależności od konfiguracji strony, niektóre z wymienionych sposobów mogą nie być dostępne.";
$pgv_lang["mail_option1_help"]			= "Ta opcja powoduje stosowanie wewnętrznego systemu komunikacji PhpGedView, w którym nie są wysyłane żadne emaile.<br /><br />Otrzymasz wyłącznie <u>wewnętrzne</u> wiadomości od innych użytkowników. Kiedy inny użytkownik wyśle ci wiadomość, pojawi się ona w bloku \"Wiadomości\" na twojej stronie #pgv_lang[mygedview]#. Jeśli ten blok został usunięty przy dostosowywaniu strony #pgv_lang[mygedview]#, nie zobaczysz żadnych wiadomości. Pojawią się, dopiero kiedy skonfigurujesz tę stronę tak, aby wyświetlać ten blok.";
$pgv_lang["mail_option2_help"]			= "Ta opcja jest jak opcja #pgv_lang[messaging]# z jedną różnicą. Dodatkowa kopia wiadomości zostanie również wysłana na adres email podany na stronie konfiguracyjnej twojego konta.<br /><br />To jest domyślny sposób kontaktowania się.";
$pgv_lang["mail_option3_help"]			= "Ta opcja spowoduje wysyłanie wiadomości wyłącznie przez email, na adres podany na stronie konfiguracyjnej twojego konta. Wewnętrzny system komunikacji PhpGedView będzie wyłączony i nigdy nie zobaczysz żadnych wiadomości w bloku \"Wiadomości\" na stronie #pgv_lang[mygedview]#.";
$pgv_lang["mail_option4_help"]			= "Ta opcja spowoduje, że nigdy nie otrzymasz żadnych wiadomości. Będziesz nieosiągalny(a) nawet dla administratora.";

//-- Admin
$pgv_lang["admin_help"]				= "Na tej stronie znajdziesz odnośniki do stron konfiguracji, administracji, dokumentacji i plików loga.<br /><br /><b>#pgv_lang[system_time]#</b>, tuż pod tytułem strony, pokazuje czas serwera, na którym znajduje się twój serwis. Oznacza to, że jeśli serwer znajduje się w Nowym Jorku, podczas kiedy ty jesteś we Francji, pokazany czas będzie o sześć godzin wcześniejszy, niż twój czas lokalny, chyba że serwer jest ustawiony na czas uniwersalny (ang. Greenwich Mean Time, GMT). Czas jest sprawdzany w momencie, kiedy otworzono lub odświeżono tę stronę.<br /><br /><b>Ostrzeżenie</b><br />Jeśli widzisz czerwony komunikat ostrzeżenia pod czasem systemowym, oznacza to, że twój plik <i>config.php</i> nie jest zabezpieczony przed zapisem. Po zakończeniu konfiguracji należy ze względów <b>bezpieczeństwa</b> ustawić prawa tego pliku na tylko-do-odczytu. Musisz zrobić to <u>ręcznie</u>, PhpGedView nie ma takiej możliwości.";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~#pgv_lang[user_admin]#~<br /><br />Na tej stronie możesz zarządzać zarejestrowanymi użytkownikami i dodawać nowych.<br /><br /><b>#pgv_lang[current_users]#</b><br />W tej tabeli są wyświetleni zarejestrowani użytkownicy, ich status i uprawnienia. Możesz <b>usuwać</b> lub <b>edytować</b> użytkowników.<br /><br /><b>#pgv_lang[add_user]#</b><br />Ten formularz jest prawie identyczny z tym, który widzą użytkownicy na stronie <b>#pgv_lang[editowndata]#</b>.<br /><br />Dla kilku tematów nie przygotowano osobnej treści pomocy dla administratora. W takim przypadku zobaczysz komunikat:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />#pgv_lang[gedcomid]# jednoznacznie identyfikuje użytkownika. Musi zostać ustawiony przez administratora.<br /><br />Ten identyfikator jest używany na kilku stronach, takich jak strona <b>#pgv_lang[my_indi]#</b> i <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Możesz ustawić ten identyfikator użytkownika osobno dla każdego pliku GEDCOM. Jeśli użytkownik nie posiada wpisu w danym pliku GEDCOM, pozostaw to pole puste.";
$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Dla każdej bazy genealogicznej i każdego użytkownika możesz wybrać <b>osobę główną (korzeń)</b>.<br /><br />Tą osobą nie musi być dany użytkownik, może to być każdy, choć użytkownik prawdopodobnie wolałby oglądać diagram rodowodu ze swojego punktu widzenia. Tutaj możesz zmieniać ten parametr.<br /><br />Jeśli użytkownik ma prawo edycji własnego konta, będzie mógł później zmienić to ustawienie.";
$pgv_lang["useradmin_can_admin_help"]		= "~OPCJA #pgv_lang[can_admin]#~<br /><br />Jeśli ta opcja jest zaznaczona, użytkownik będzie miał takie same uprawnienia, jak ty.<dl><dt>Są to następujące uprawnienia:</dt><dd>Dodawanie / usuwanie / edycja użytkowników</dd><dd>Wysyłanie wiadomości do wszystkich użytkowników</dd><dd>Edycja komunikatów powitalnych</dd><dd>Edycja i konfiguracja plików językowych</dd><dt></dt><dd>Przejście na nowszą wersję PhpGedView</dd><dd>Zmiana konfiguracji systemu i plików GEDCOM</dd><dd>Zarządzanie plikami GEDCOM</dd><dd>Zmiana ustawień prywatności</dd><dd>i wszelkie inne uprawnienia, nie wymienione tutaj.</dd></dl><br />Użytkownik <u>nie może</u> zmienić niczego na twoim serwerze poza PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~OPCJA #pgv_lang[sync_gedcom]#~<br /><br />Jeśli ta opcja jest zaznaczona i użytkownik posiada przypisany do niego wpis w pliku GEDCOM, ustawienia jego konta będą automatycznie synchronizowane z jego danymi w pliku GEDCOM. Oznacza to, że jeśli zmieni się wpis GEDCOM tego użytkownika, niektóre informacje, takie jak adres email, imię i nazwisko, zostaną skopiowane do konta użytkownika. Z kolei, kiedy edytowane jest konto użytkownika, odpowiednie dane zostaną także skopiowane do wpisu GEDCOM.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />Użytkownik może mieć różne prawa dostępu i edycji dla każdej genealogicznej bazy danych w systemie.<ul><li><b>#pgv_lang[none]#:</b> Użytkownik nie ma dostępu do prywatnych danych w tym pliku GEDCOM.</li><li><b>#pgv_lang[access]#:</b> Użytkownik nie może edytować ani zatwierdzać zmian w bazie danych, ale może przeglądać prywatne dane.</li><li><b>#pgv_lang[edit]#:</b> Użytkownik może edytować dane, ale inny użytkownik, z prawem zatwierdzania, musi zatwierdzić jego zmiany, zanim zostaną wprowadzone do bazy danych i pokazane publicznie.</li><li><b>#pgv_lang[accept]#:</b> Użytkownik moze edytować i zatwierdzać dane. Może także edytować i zatwierdzać zmiany dokonane przez innych użytkowników.</li><li><b>#pgv_lang[admin_gedcom]#:</b> Użytkownik może edytować ustawienia konfiguracyjne i prywatności dla <u>tego</u> pliku GEDCOM.</li></ul>Administratorzy systemu, określeni przez opcję <b>#pgv_lang[can_admin]#</b>, automatycznie otrzymują uprawnienia <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Rejestracja samoobsługowa</b><br />Użytkownik może założyć nowe konto poprzez moduł <b>rejestracji samoobsługowej</b>.<br /><br />Użytkownik zakładający nowe konto otrzymuje email z odnośnikiem do potwierdzenia swojego zgłoszenia. Kiedy użytkownik wykona instrukcje zamieszczone w emailu, ta opcja zostanie zaznaczona, i będzie można przejść do następnego kroku, czyli zatwierdzenia przez administratora. Zaczekaj z zatwierdzeniem, aż ta opcja nie będzie zaznaczona.<br /><br /><b>Dodaj użytkownika ręcznie</b><br />Jeśli skorzystasz z tego formularza, aby dodać użytkownika ręcznie, ta opcja zostanie od razu zaznaczona.<br /><br /";
$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />Jeśli użytkownik skorzystał z modułu Rejestracji samoobsługowej i potwierdził swoje zgłoszenie, ostatnim krokiem przez aktywowaniem jego konta jest zatwierdzenie przez administratora (ciebie).<br /><br />Kiedy zatwierdzisz zgłoszenie użytkownika, otrzyma on wiadomość email mówiącą, że jego konto jest teraz aktywne i będzie mógł się zalogować, korzystając z loginu i hasła, które otrzymał przy rejestracji.";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />Ten formularz służy do zmieniania konta użytkownika przez administratora.<br /><br />Formularz jest bardzo podobny do formularza <b>#pgv_lang[add_user]#</b> i <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]		= "~WIDOCZNY ONLINE~<br /><br />Ta opcja określa twoją widoczność względem innych użytkowników, kiedy wchodzisz do serwisu.<br /><br />Jeśli nie zaznaczysz tej opcji, pozostaniesz całkowicie niewidoczny(a) dla innych i nie będziesz mógł(mogła) zobaczyć innych użytkowników online. Zaznaczenie tej opcji spowoduje odwrócenie tej sytuacji: zobaczysz innych użytkowników widocznych online, a jednocześnie oni zobaczą ciebie.";
$pgv_lang["useradmin_editaccount_help"]			= "~EDYTUJ KONTO~<br /><br />Zaznaczenie tej opcji umożliwi użytkownikowi edytowanie swojego konta. Choć nie jest to zalecane, możesz utworzyć jeden login i hasło dla wielu użytkowników. Dzięki wyłączeniu tej opcji dla wszystkich użytkowników, którzy dzielą konto, nie mogą oni niezależnie zmienić danych konta — konto może być edytowane tylko przez administratora.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Zaznaczenie tej opcji spowoduje, że dany użytkownik będzie miał dostęp tylko do osób żyjących, z którymi jest spokrewniony. Będzie widział jedynie te osoby, które znajdują się w zasięgu długości jego ścieżki pokrewieństwa, podanej przez parametr <i>#pgv_lang[user_path_length]#</i>. Aby wymagać prywatności pokrewieństwa dla wszystkich użytkowników, włącz opcję globalną w ustawieniach prywatności GEDCOM.<br /><br />Ta opcja wymaga przypisania użytkownikowi identyfikatora GEDCOM, zanim zobaczy jakiekolwiek żyjące osoby.";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Jeśli włączona jest opcja <i>#pgv_lang[user_relationship_priv]#</i>, ten użytkownik będzie mógł widzieć lub edytować tylko osoby w podanym zasięgu ścieżki pokrewieństwa.";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Zaznaczenie tej opcji spowoduje automatyczne zatwierdzanie wszelkich zmian, wprowadzanych przez tego użytkownika. Aby to ustawienie zadziałało, użytkownik musi mieć jednocześnie prawo zatwierdzania w pliku GEDCOM.";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~ZARZĄDZAJ STRONAMI~<br /><br />Na tej stronie możesz dodawać zdalne strony i zabraniać wstępu określonym adresom IP.<br /><br />Dodanie zdalnej strony polega na podaniu tytułu, adresu URL, identyfikatora bazy danych (nieobowiązkowe), loginu i hasła dla zdalnej usługi sieciowej.<br /><br />Zabronienie wstępu dla adresu IP odbywa się przez podanie dowolnego poprawnego zakresu adresów IP, na przykład 212.10.*.* Zdalne strony o adresach IP z zakresu z listy zabronionych nie będą miały dostępu na twoją stronę. Możesz także podać konkretny adres IP.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~Dodawanie zdalnych stron~<br /><br />Aby dodać zdalną stronę, podaj jej tytuł, adres URL, identyfikator bazy danych (nieobowiązkowe), login i hasło, a następnie kliknij na przycisk \"Dodaj\". Jeśli zdalny serwer pozwala na uwierzytelnianie anonimowe, należy pozostawić pola loginu i hasła puste.";
//-- IP Address Banning
$pgv_lang["help_IPv4IPv6"]						= "Adresy IPv4 składają się z 4 segmentów oddzielonych znakiem \".\" (kropka) i zawierających liczby dziesiętne z zakresu od zera do 255 bez zer wiodących. Przykładami są: <b>172.252.19.56</b> , <b>212.10.*.*</b> , <b>212.10.</b> , <b>212.10</b> , <b>212.10 ..29</b> lub <b>212.10.*.29</b> . Brakujące segmenty w tych przykładach zostaną zinterpretowane jako \"*\" (gwiazdka), przy czym symbol \"*\" oznacza <i>dopasuj dowolną liczbę w tej pozycji</i>.<br /><br />Adresy IPv6 składają się z 8 segmentów oddzielonych znakiem \":\" (dwukropek) i zawierających 4 cyfry liczb szesnastkowych. Liczby te nie powinny mieć wiodących zer, a pierwszy ciąg zer można usunąć i zastąpić parą symboli \":\" (dwukropek). Jeśli chcesz użyć funkcji <i>dopasuj dowolną liczbę w tej pozycji</i>, musisz wyraźnie wstawić tam \"*\" (gwiazdkę). Przykładami są: <b>23:0:cafe::2:1</b> , <b>23:0:cafe::*:1</b> lub <b>23:0:*::* :*</b> . W tych przykładach para dwukropków reprezentuje sekwencję 3 liczb, z których każda ma wartość zero, na przykład: <b>23:0:cafe:0:0:0:*:1</b>.";
$pgv_lang["help_banning"]				= "~Zabranianie wstępu adresom IP~<br /><br />Aby zabronić wstępu na twój serwis zdalnym stronom, podaj konkretny adres IP lub poprawny zakres adresów, na przykład 212.10.*.*, a następnie kliknij na przycisk \"Zapisz\".";
$pgv_lang["help_timedban"]						= "~#pgv_lang[label_timedban_servers]#~<br /><br />Po wykryciu próby włamania PhpGedView automatycznie uniemożliwi dostęp z tego adresu IP na godzinę.<br /><br />Możesz dodać własne czasowe odmowy dostępu, wprowadzając adres IPv4 lub IPv6, który ma być zablokowany wraz z datą oraz czas wygaśnięcia odmowy dostępu w polu Komentarze. Upewnij się, że używasz prawidłowego formatu informacji o wygaśnięciu. Jeśli informacje o wygaśnięciu nie zostaną wprowadzone poprawnie, odmowa dostępu nie wygaśnie automatycznie.<br /><br />Wygaśnięcie należy wpisać w następującym formacie: <b>rrrr.mm.dd@hh:mm</b > . Na przykład <b>2012.12.23@23:59</b> . Zwróć uwagę na użycie zegara 24-godzinnego.<br /><br />#pgv_lang[help_IPv4IPv6]#";
$pgv_lang["help_manual_search_engines"]				= "~Ręczne znakowanie wyszukiwarek~<br /><br />PhpGedView automatycznie pokazuje wyszukiwarkom pliki danych z mniejszą liczbą odnośników. Dane są ograniczone do pojedynczej osoby i jej najbliższej rodziny, bez informacji o dziadkach czy wnukach. Wiele raportów i stron intensywnie komunikujących się z serwerem, takich jak kalendarz, znajduje się poza zasięgiem wyszukiwarek.<br /><br />Jeśli wyszukiwarka nie zostanie rozpoznana automatycznie, a chcesz dostarczyć jej dane do zindeksowania, możesz ją wpisać tutaj. Jeśli nie chcesz, aby indeksowała dane, dopisz ją do bloku zabronionych adresów IP poniżej.<br /><br />Jeśli chcesz zobaczyć, jakie dane dostępne są do zindeksowania dla wyszukiwarek, wpisz tutaj swój własny adres IP. <span style=\"color: red;\">Ostrzeżenie:</font> Spowoduje to całkowity brak dostępu do interfejsu administratora z tego adresu IP, dopóki adres nie zostanie usunięty po zalogowaniu z innego komputera lub ręczną edycję pliku <i>/index/search_engines.php</i>.<br /><br />Aby ręcznie oznaczyć zdalną stronę jako wyszukiwarkę, podaj konkretny adres IP lub poprawny zakres adresów, na przykład 212.10.*.*, a następnie kliknij przycisk \"Zapisz\". Wiele popularnych wyszukiwarek, takich jak Google i Yahoo, zostanie wykrytych automatycznie.";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Wykryto wyszukiwarkę~<br /><br />PhpGedView automatycznie pokazuje wyszukiwarkom pliki danych z mniejszą liczbą odnośników. Dane są ograniczone do pojedynczej osoby i jej najbliższej rodziny, bez informacji o dziadkach czy wnukach. Wiele raportów i stron intensywnie komunikujących się z serwerem, takich jak kalendarz, znajduje się poza zasięgiem wyszukiwarek.<br /><br />Próba przejścia przez wyszukiwarkę na jedną z takich stron spowoduje pokazanie tej strony. Jeśli widzisz ten komunikat, oznacza to, że system rozpoznaje cię jako wyszukiwarkę. Poniżej znajduje się lista stron z ograniczonymi danymi, do których przeglądarki mają dostęp.<br /><br />Prawdziwi użytkownicy korzystający z odnośników wygenerowanych przez wyszukiwarki zobaczą pełną wersję stron i danych, a nie tę stronę.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~DODAWANIE A WGRYWANIE PLIKU GEDCOM~<dl><dt><b>Wgrywanie plików GEDCOM</b></dt><dd>Pliki mogą być wgrywane przez sieć. Możesz wgrać plik z dowolnego miejsca bez konieczności korzystania z programu ftp.</dd><dt><b>Dodawanie plików GEDCOM</b></dt><dd>Jeśli w twoim katalogu GEDCOM nadal znajduje się wcześniej wgrany plik, możesz użyć go ponownie bez wgrywania. Czasami z powodu ograniczeń na rozmiar pliku może zajść potrzeba użycia funkcji \"Dodaj\".</dd></dl>Procedury \"Dodaj\" i \"Wgraj\" składają się z czterech prostych kroków i różnią się tylko pierwszym z nich.";
$pgv_lang["gedcom_configfile_help"]		= "~PLIK KONFIGURACYJNY GEDCOM~<br /><br />To jest plik, w którym przechowywane są wszystkie podstawowe ustawienia związane z genealogiczną bazą danych. Dla każdej bazy istnieje osobny taki plik.<br /><br />Ścieżkę i nazwę każdego pliku konfiguracyjnego znajdziesz w tabeli <b>#pgv_lang[current_gedcoms]#</b> na stronie <b>#pgv_lang[gedcom_adm_head]#</b>.";
$pgv_lang["default_gedcom_help"]		= "~DOMYŚLNY PLIK GEDCOM~<br /><br />Jeśli masz wiele genealogicznych baz danych, tutaj możesz określić, która z nich będzie aktywna domyślnie.<br /><br />Domyślną bazę danych zobaczą wszyscy goście i niezalogowani użytkownicy.<br /><br />Użytkownicy, którzy mają prawo edycji konta, mogą zmienić to ustawienie dla siebie. W tym przypadku po zalogowaniu zobaczą bazę, którą sami wybrali jako domyślną.";
$pgv_lang["delete_gedcom_help"]			= "~USUŃ PLIK GEDCOM~<br /><br />PhpGedView tworzy swoją bazę danych na podstawie wcześniej wgranego pliku GEDCOM. Kiedy wybierzesz <b>Usuń</b>, ta część bazy danych zostanie usunięta. Musisz potwierdzić swoją decyzję o usunięciu danych.<br /><br />Jeśli oryginalny plik GEDCOM nie został świadomie usunięty spoza PhpGedView, będzie on nadal znajdować się w katalogu, do którego został wgrany. Jeśli później zechcesz znowu pracować z tym plikiem, nie będzie trzeba go ponownie wgrywać. Zamiast tego wybierz opcję <b>#pgv_lang[add_gedcom]#</b>.";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Kiedy używasz funkcji <b>#pgv_lang[add_gedcom]#</b>, zakłada się, że plik GEDCOM został już wgrany na serwer za pomocą programu lub metody <u>spoza</u> PhpGedView, na przykład <i>ftp</i> lub <i>połączenia sieciowego</i>. Plik do dodania może być także wynikiem działania procedury <b>#pgv_lang[upload_gedcom]#</b>.<br /><br />Jeśli odpowiedni plik GEDCOM nie znajduje się jeszcze na twoim serwerze, <u>musisz</u> umieścić go tam, zanim będzie można rozpocząć dodawanie.<br /><br />W miejsce pliku GEDCOM możesz także wgrać plik ZIP zawierający plik GEDCOM, za pomocą PhpGedView lub zewnętrznego programu. PhpGedView automatycznie rozpozna plik ZIP i rozpakuje plik GEDCOM.<br /><br />Jeśli w PhpGedView istnieje już plik GEDCOM o tej samej nazwie, zostanie on nadpisany, jednak wszystkie wcześniejsze dotyczące go ustawienia zostaną zachowane.<br /><br />Zostaniesz przeprowadzony(a) przez całą procedurę krok po kroku.";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Możesz rozpocząć budowanie nowej bazy danych od zera.<br /><br />Ta procedura wymaga tylko kilku prostych kroków. Krok pierwszy różni się od kroków dodawania lub wgrywania, ale inne kroki będą wyglądać znajomo.<ol><li><b>Nazywanie nowego pliku GEDCOM</b><br />Wprowadź nazwę nowego pliku GEDCOM <u>bez</u> rozszerzenia <b>.ged</b>. Nowy plik zostanie utworzony w katalogu wymienionym ponad polem nazwy pliku. Kliknij <b>Dodaj</b>.</li><li><b>Strona konfiguracyjna</b><br />Tę stronę już znasz; konfigurujesz na niej ustawienia dla nowego pliku GEDCOM.</li><li><b>Sprawdzanie poprawności</b><br />Tę stronę już znasz; sprawdzana jest na niej poprawność pliku GEDCOM. Ponieważ jest on pusty, będzie oczywiście poprawny.</li><li><b>Importowanie wpisów</b><br />Importowanie będzie trwało bardzo krótko, ponieważ jest tylko jeden wpis do zaimportowania.</li></ol>To wszystko. Teraz możesz przejść na stronę diagramu rodowodu i zobaczyć pierwszą osobę w nowym pliku GEDCOM. Kliknij nazwisko osoby i rozpocznij edytowanie. Później możesz dodawać powiązania z nowymi osobami.";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Z tej strony możesz pobierać swoją genealogiczną bazę danych w formacie GEDCOM. Dzięki temu możesz zaimportować dane do innej aplikacji genealogicznej lub podzielić się nimi z innymi.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />Strona #pgv_lang[gedcom_adm_head]# służy jako centrum sterowania do zarządzania wszystkimi genealogicznymi bazami danych.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />W nagłówku tabeli <b>#pgv_lang[current_gedcoms]#</b> zobaczysz pasek narzędzi z czterema odnośnikami.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul><br />W tabeli <b>#pgv_lang[current_gedcoms]#</b> wyświetlona jest osobno każda genealogiczna baza danych i dla każdej z nich masz następujące opcje:<ul><li>Importuj</li><li>Usuń</li><li>Pobierz</li><li>Edytuj konfigurację</li><li>Edytuj prywatność</li><li>Pliki SearchLog</li></ul>Edycja prywatności pojawia się tutaj, ponieważ każdy plik GEDCOM ma własny plik ustawień prywatności.<br /><br />Każdy wiersz tej tabeli powinien być zrozumiały. PhpGedView może rejestrować wszystkie przeprowadzane wyszukiwania w pliku SearchLog, który można przejrzeć za pomocą odnośników znajdujących się na tej stronie.<br />#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]		= "~KONFIGURUJ PLIK GEDCOM~<br /><br />Każda genealogiczna baza danych w PhpGedView ma własny <b>plik konfiguracyjny</b>.<br /><br />Na tym formularzu możesz konfigurować wiele opcji, takich jak tytuł bazy danych, język, format kalendarza, opcje emaila, rejestracja wyszukiwania, nagłówki HTML META, usuwanie nazwisk z \"Najczęstszych nazwisk\" itp.";
$pgv_lang["import_gedcom_help"]			= "~IMPORTUJ PLIK GEDCOM~<br /><br />W większości przypadków importowanie pliku GEDCOM utworzonego zewnętrznie jest jednym z kroków w procedurach, które wymagają jednoczesnego wprowadzenia wielu zmian do genealogicznej bazy danych.<br /><br />Te kroki mają logiczną kolejność i muszą zostać wykonane w określonym porządku, aby baza danych działała poprawnie.<br /><br />Jeśli z jakiegoś powodu nie wykonano kroków w poprawnej kolejności, zobaczysz <u>ostrzeżenie</u> o tym, że plik GEDCOM nie został jeszcze zaimportowany. Aby naprawić problem, kliknij odnośnik <b>Importuj plik GEDCOM</b> i zaimportuj plik.<br /><br />Kiedy ponownie importujesz plik GEDCOM o tej samej nazwie, istniejące ustawienia konfiguracyjne pozostaną bez zmian, jednak istniejące dane zostaną nadpisane.";
$pgv_lang["upload_gedcom_help"]					= "~#pgv_lang[upload_gedcom]#~<br /><br />Inaczej niż w przypadku funkcji <b>#pgv_lang[add_gedcom]#</b>, plik GEDCOM, który zamierzasz dodać nie musi znajdować się na twoim serwerze.<br /><br />W pierwszym kroku wybierasz plik GEDCOM ze swojego lokalnego komputera. Wprowadź pełną ścieżkę i nazwę pliku lub skorzystaj z przycisku <b>Przeglądaj</b>.<br /><br />Możesz także skorzystać z tej funkcji do wgrania pliku ZIP zawierającego plik GEDCOM. PhpGedView rozpozna plik ZIP i automatycznie rozpakuje plik GEDCOM.<br /><br />Jeśli w PhpGedView istnieje już plik GEDCOM o tej samej nazwie, zostanie on nadpisany, jednak wszystkie wcześniejsze dotyczące go ustawienia zostaną zachowane.<br /><br />Zostaniesz przeprowadzony(a) przez całą procedurę krok po kroku.";
$pgv_lang["validate_gedcom_help"]				= "~SPRAWDŹ POPRAWNOŚĆ PLIKU GEDCOM~<br /><br />To jest trzeci krok w procedurze dodawania pliku GEDCOM utworzonego zewnętrznie do twojej genealogicznej bazy danych.<br /><br />PhpGedView sprawdzi plik pod względem poprawnego zastosowania formatów daty, miejsca, kodowania znaków itp. Niektóre odstępstwa od standardu GEDCOM 5.5.1, którego przestrzega PhpGedView, można skorygować automatycznie. Przykładami są znaki końca linii generowane przez komputery Macintosh oraz niepoprawny format miejsca. W takim przypadku zobaczysz komunikat mówiący o tym, że dane zostały zmienione. Jeśli problem nie może zostać naprawiony automatycznie, zobaczysz ostrzeżenie z zalecanym sposobem postępowania.<br /><br /><b>Dodatkowe narzędzia</b><br />Na razie dostępne jest tylko jedno dodatkowe narzędzie:<br /><b>Zmień identyfikator osoby na...</b>.<br />#pgv_lang[more_config_help]#";
$pgv_lang["convert_ansi2utf_help"]				= "~PRZEKONWERTUJ ANSI NA UTF-8~<br /><br />Aby dane w twoich plikach GEDCOM były poprawnie przetwarzane i wyświetlane, muszą być zakodowane w formacie UTF-8.<br /><br />Niektóre z nowszych aplikacji genealogicznych potrafią eksportować dane do pliku GEDCOM w kodowaniu UTF-8. Starsze aplikacji często nie dają tej możliwości. Jeśli twoja aplikacja nie oferuje takiej opcji, PhpGedView może przekonwertować twój plik.<br /><br />PhpGedView wykryje kodowanie twojego pliku podczas sprawdzania poprawności i wyświetli odpowiedni komunikat.";
$pgv_lang["detected_ansi2utf_help"]		= "~WYKRYTO KODOWANIE ANSI~<br /><br />Plik GEDCOM, którego poprawność jest właśnie sprawdzana, jest aktualnie zakodowany w systemie ANSI. Zdecydowanie zaleca się przekonwertowanie pliku do kodowania UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~WYKRYTO NIEPOPRAWNY FORMAT DATY~<br /><br /><b>FORMAT DATY ZOSTANIE ZMIENIONY</b><br /><br />Formatem daty przyjętym w standardzie GEDCOM 5.5.1 oraz PhpGedView jest <b>DD&nbsp;MMM&nbsp;RRRR</b> (np. 01&nbsp;JAN&nbsp;2004)<br /><br />Jeśli zobaczysz komunikat o niepoprawnym formacie daty, PhpGedView przekonwertuje niepoprawne daty według standardu.<br /><br />Możesz jednak wybrać, czy umieścić \"<b>dzień</b> przed miesiącem\" (DD&nbsp;MMM&nbsp;RRRR), czy \"<b>miesiąc</b> przed dniem\" (MMM&nbsp;DD&nbsp;RRRR).<br /><br />Zaleca się stosowanie pierwszego formatu (dzień przed miesiącem).";
$pgv_lang["change_indi2id_help"]		= "~ZMIEŃ IDENTYFIKATOR OSOBY NA...~<br /><br />To narzędzie zostało zaprojektowane z myślą o użytkownikach, których aplikacje genealogiczne stosują różny identyfikator osoby za każdym razem, kiedy eksportują plik GEDCOM. Na przykład, kiedy plik jest eksportowany po raz pierwszy, pewna osoba może mieć identyfikator I100, ale następnym razem identyfikator tej samej osoby może się zmienić na I234. Zmienne identyfikatory stanowią problem w zarządzaniu dla PhpGedView, ponieważ identyfikatorów używa się to tworzenia wszelkich powiązań.<br /><br />Większość aplikacji genealogicznych stosuje również znacznik RIN lub REFN, aby nadać każdej osoby jednoznaczny identyfikator. To narzędzie zamieni wszystkie identyfikatory osoby w pliku GEDCOM na podane pole (RIN lub REFN).";
$pgv_lang["edit_privacy_help"]			= "Na tej stronie możesz zmieniać ustawienia prywatności dla wybranego pliku GEDCOM.<br /><br />Sprawdź tytuł strony, aby upewnić się, że edytuje właściwy plik prywatności. Ma on następującą postać: (ścieżka/nazwatwojegoplikugedcom_priv.php)<br /><br />Więcej zmian w ustawieniach pliku prywatności możesz wprowadzić, edytując go ręcznie. Więcej na ten temat znajdziesz na stronie PhpGedView.";
$pgv_lang["BOM_detected_help"]			= "~WYKRYTO ZNAK BOM (BYTE ORDER MARK)~<br /><br />Importowany plik GEDCOM zawiera na początku specjalny 3-bajtowy znacznik, używany przez niektóre aplikacje do oznaczenia, że plik jest zapisany w kodowaniu UTF-8.<br /><br />Choć ten znacznik nie jest tak naprawdę błędem, PhpGedView nie będzie działał poprawnie, gdy znajduje się on na początku pliku. Pozwól PhpGedView usunąć ten znak.";
$pgv_lang["invalid_header_help"]		= "~NIEPOPRAWNY NAGŁÓWEK GEDCOM~<br /><br />Każdy plik GEDCOM musi rozpoczynać się od <b>0&nbsp;HEAD</b>. PhpGedView wykrył, że importowany plik GEDCOM nie posiada <b>0&nbsp;HEAD</b> w pierwszym wierszu. Po kliknięciu przycisku \"Porządkuj\", wszystkie wiersze poprzedzające wiersz <b>0&nbsp;HEAD</b> zostaną usunięte.<br /><br />Ten błąd zwykle oznacza, że aplikacja, której użyto do utworzenia pliku GEDCOM, nie wygenerowała go poprawnie, lub nie jest to plik GEDCOM. Upewnij się, że importujesz odpowiedni plik i że rozpoczyna się on od wiersza <b>0&nbsp;HEAD</b> i kończy wierszem <b>0&nbsp;TRLR</b>.";
$pgv_lang["macfile_detected_help"]		= "~WYKRYTO PLIK MACINTOSHA~<br /><br />PhpGedView wykrył, że twój plik GEDCOM został utworzony na komputerze Macintosh.<br /><br />Pliki generowane na komputerach Macintosh kończą każdy wiersz kodem kontrolnym CR (Ctrl+M).<br />Pliki Unix kończą każdy wiersz kodem kontrolnym LF (Ctrl+J).<br />Windows i DOS używają sekwencji dwóch kodów, CR i LF.<br /><br />PhpGedView wymaga stosowania przez wszystkie pliki końców wiersza typu Unix lub DOS. Kiedy klikniesz przycisk \"Porządkuj\", znaki końca wiersza zostaną odpowiednio przekonwertowane.";
$pgv_lang["cleanup_places_help"]		= "~PORZĄDKUJ MIEJSCA~<br /><br />PhpGedView wykrył, że twój plik GEDCOM używa miejsc przy znacznikach GEDCOM, które nie powinny mieć miejsc.<br /><br />Wiele aplikacji genealogicznych, takich jak Family Tree Maker, generuje właśnie ten typ plików GEDCOM. PhpGedView będzie działał z takimi plikami, ale w hierarchii miejsc mogą pojawić się pewne niepoprawne miejsca.<br /><br />Na przykład w pliku GEDCOM może znaleźć się następujący błędny wpis:<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Programista<br /><br />Według standardu GEDCOM 5.5.1 powinno być wpisane:<br />1 SSN 123-45-6789<br />1 OCCU Programista<br /><br />Jeśli wybierzesz <b>Tak</b>, PhpGedView automatycznie poprawi te błędy.";
$pgv_lang["empty_lines_detected_help"]	= "~WYKRYTO PUSTE WIERSZE~<br /><br />PhpGedView wykrył puste wiersze w twoim pliku. Te wiersze mogą spowodować błędy i zostaną usunięte z pliku przed importem.";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~KONFIGURUJ PhpGedView~<br /><br />Na tej stronie możesz konfigurować globalne ustawienia PhpGedView. Musisz to zrobić po zainstalowaniu i pierwszym uruchomieniu PhpGedView.<br /><br />#pgv_lang[review_readme]# Ponieważ są to ustawienia <b>globalne</b>, dotyczą one całego systemu i wszystkich genealogicznych baz danych, których używasz w PhpGedView.<br /><br />Każda genealogiczna baza danych ma także własne dodatkowe opcje konfiguracyjne, które możesz zmieniać po kliknięciu odnośnika <b>#pgv_lang[admin_gedcoms]#</b> na tej stronie.<br /><br />Dostęp do funkcji #pgv_lang[gedcom_adm_head]# możesz także uzyskać z głównej strony administracji, na którą wchodzisz klikając odnośnik pod ikonką #pgv_lang[mgv]# lub w nagłówku większości stron. Na stronie administracji odpowiedni odnośnik nazywa się <b>#pgv_lang[manage_gedcoms]#.</b>";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Ta strona umożliwia scalanie dwóch wpisów z tego samego pliku GEDCOM.<br /><br />Ta opcja przydaje się, kiedy scalono pliki GEDCOM i teraz istnieje wiele osób, rodzin i źródeł o takich samych danych.<br /><br />Scalanie odbywa się w trzech krokach.<br /><ol><li>Wprowadzasz dwa identyfikatory GEDCOM. Identyfikatory <u>muszą</u> wskazywać na obiekty tego samego typu. Nie możesz na przykład scalić osoby z rodziną ani rodziny ze źródłem.<br />W pole <b>#pgv_lang[merge_to]#</b> wprowadź identyfikator wpisu, który ma się stać nowym wpisem po zakończeniu scalania.<br />W pole <b>#pgv_lang[merge_from]#</b> wprowadź identyfikator wpisu, którego dane mają zostać przepisane do wpisu #pgv_lang[merge_to]#. Po scaleniu ten wpis zostanie usunięty.</li><li>Wybierz, które fakty z obu wpisów mają zostać zachowane. Zaznacz te fakty, które mają pozostać w nowym wpisie.</li><li>Sprawdź poprawność rezultatów scalania, tak jak przy wszystkich innych wprowadzanych zmianach.</li></ol>Zanim zostaną ostatecznie wprowadzone do bazy danych, twoje zmiany muszą zostać zatwierdzone przez użytkownika z prawem zatwierdzania.";

//-- report engine
$pgv_lang["help_reportengine.php"]	= "~RAPORTY~<br /><br />Elementy menu \"Raporty\" generują dokumenty w formacie PDF, które można następnie pobrać i wydrukować.<br /><br />Najpierw wybierasz typ raportu do przygotowania. Po wybraniu typu podajesz parametry specyficzne dla tego raportu, takie jak główna osoba lub rodzina, opcja wyświetlania zdjęć itp. Po określeniu parametrów klikasz na przycisk <b>#pgv_lang[download_report]#</b> aby pobrać raport na swój komputer.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]	= "~FORMAT PDF~<br /><br />System raportowania PhpGedView generuje raporty do pobrania w formacie Adobe&reg; PDF. Wspomniana w innej części \"Pomocy\" specyfikacja standardu GEDCOM 5.5.1 jest również dostępna w postaci pliku PDF. PDF to skrót od \"przenośnego formatu dokumentów\" (ang. <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat).";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br /><br />To jest raport na temat wybranej osoby i jej przodków w formacie broszury. Rozpoczyna się pierwszą osobą, a następnie omawia jej rodziców, dziadków itd.";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br /><br />Ten raport wypisuje listę wszystkich osób urodzonych w określonym czasie lub miejscu.";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br /><br />Ten raport wypisuje listę wszystkich krewnych wybranej osoby. Możesz wybrać, którzy z krewnych powinni znaleźć się w raporcie.<ul><li><b>#pgv_lang[child-family]#</b> wyświetli tylko wybraną osobę, jej rodziców i rodzeństwo.</li><li><b>#pgv_lang[spouse-family]#</b> wyświetli tylko wybraną osobę, jej małżonka i ich dzieci.</li><li><b>#pgv_lang[direct-ancestors]#</b> wyświetli wybraną osobę, jej rodziców, dziadków, pradziadków i innych przodków w linii prostej (rodziców pradziadków, ich rodziców itd.).</li><li><b>#pgv_lang[ancestors]#</b> wyświetli wszystkie osoby z listy #pgv_lang[direct-ancestors]#, a dodatkowo także rodzeństwo wszystkich przodków w drzewie wybranej osoby. Nie wyświetli dzieci rodzeństwa (kuzynów).</li><li><b>#pgv_lang[descendants]#</b> wyświetli listę wszystkich potomków wybranej osoby: dzieci, wnuki, prawnuki itd.</li><li><b>#pgv_lang[all]#</b> to połączenie #pgv_lang[descendants]# i #pgv_lang[ancestors]# w jednym raporcie.</li></ul>";
$pgv_lang["help_xml_reports"]	= "~System raportowania~<br /><br />Do generowania raportów PDF system raportowania PhpGedView wykorzystuje pliki szablonów XML.<br /><br />Raporty dostępne na liście <b>#pgv_lang[select_report]#</b> są generowane na podstawie plików XML, znajdujących się w katalogu \"reports\". Możesz tworzyć własne raporty kopiując dowolny z szablonów i modyfikując plik XML. Aby dodać nowy raport, wystarczy umieścić go w katalogu \"reports\", a PhpGedView automatycznie wykryje go i doda do listy <b>#pgv_lang[select_report]#</b>.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>TREŚĆ POMOCY</b>";
$pgv_lang["help_contents_gedcom_info"]		= "Informacja GEDCOM";
$pgv_lang["help_contents_gedcom_places"]	= "Miejsca w pliku GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>TREŚĆ POMOCY<br /><br />ELEMENTY POMOCY ADMINISTRATORA</b> zostały dodane na początek listy.";
// $pgv_lang["ah1_help"]							= "_Upgrade";
$pgv_lang["ah2_help"]				= "_Konfiguruj PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Dodawanie a wgrywanie";
$pgv_lang["ah4_help"]				= "_GEDCOM: Plik konfiguracyjny";
$pgv_lang["ah5_help"]				= "_GEDCOM: Domyślny";
$pgv_lang["ah6_help"]				= "_GEDCOM: Usuń";
$pgv_lang["ah7_help"]				= "_GEDCOM: Dodaj";
$pgv_lang["ah8_help"]				= "_GEDCOM: Twórz nowy";
$pgv_lang["ah9_help"]				= "_GEDCOM: Pobierz";
$pgv_lang["ah10_help"]				= "_GEDCOM: Strona zarządzania";
$pgv_lang["ah11_help"]				= "_GEDCOM: Konfiguruj";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importuj";
$pgv_lang["ah13_help"]				= "_GEDCOM: Wgraj";
$pgv_lang["ah14_help"]				= "_GEDCOM: Sprawdź poprawność";
$pgv_lang["ah15_help"]				= "_GEDCOM: Konwertuj z ANSI do UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Ustawienia prywatności";
$pgv_lang["ah17_help"]				= "_Zarządzanie użytkownikami";
$pgv_lang["ah18_help"]				= "_Administracja";
$pgv_lang["ah19_help"]				= "_GEDCOM: Narzędzie dodawania multimediów";
$pgv_lang["ah20_help"]				= "_GEDCOM: Zmień identyfikator osoby na...";
$pgv_lang["ah21_help"]				= "_Narzędzia tłumacza";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Konfiguruj dostępne języki";
$pgv_lang["ah24_help"]				= "_Migrator informacji o użytkownikach (Index -->> SQL)";
$pgv_lang["ah25_help"]				= "_Kopia zapasowa PhpGedView";
$pgv_lang["ah26_help"]				= "_Lista FAQ: Edytuj";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~OPCJE WYKRESU STATYSTYK~<br /><br />Ta strona pokazuje wykres statystyk zdefiniowanych na poprzedniej stronie.";
$pgv_lang["help_statistics.php"] = "~OPCJE WYKRESU STATYSTYK~<br /><br />Ta strona pozwala na ustwienie różnych kryteriów wykresu statystyk.";
$pgv_lang["stat_help"]			= "~OPCJE WYKRESU STATYSTYK~<br /><br />Możesz stworzyć kilka różnych wykresów statystyk.<br /><br />Wybierz rodzaj wykresu, a następnie dostosuj opcje wyświetlania wybierając parametry z list rozwijanych.<br /><br />Na przykład osoby z datą urodzenia zawierającą tylko rok ('1956') nie będą pokazane na wykresie dotyczącym miesięcy.";
$pgv_lang["stat_help_x"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~OŚ X~<br /><br />Następujące opcje są dostępne dla osi X (poziomej). Każda będzie prezentowana w zależności od ustawień osi Y i Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;liczba osób urodzonych w każdym miesiącu.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;osoby zmarłe w każdym miesiącu.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;małżeństwa zawarte w każdym miesiącu.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;liczba małżeństw w każdym miesiącu.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;pierwsze dzieci w rodzinie urodzone w każdym miesiącu.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;liczba miesięcy, które upłynęły pomiędzy ślubem a narodzinami pierwszego dziecka.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;liczba lat w chwili śmierci w zależności od roku urodzenia.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;liczba lat w chwili śmierci w zależności od roku śmierci.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;liczba lat w chwili zawarcia małżeństwa.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;liczba lat w chwili zawarcia pierwszego małżeństwa.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;liczebność rodziny.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;rozmieszczenie wszystkich osób lub osób z danym nazwiskiem w zależności od kraju.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;kraj urodzenia osób.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;kraj zawarcia małżeństwa.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;kraj śmierci osób.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;statystyka osób powiązanych ze źródłami.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;statystyka rodzin powiązanych ze źródłami.</p><br />Niektóre opcje mogą być wyłączone przez administratora.";
$pgv_lang["stat_help_y"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~OŚ Y~<br /><br />Następujące opcje są dostępne dla osi Y (pionowej). Te opcje zależą od danych prezentowanych na osi X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;wyświetla liczbę osób w danej kategorii zdefiniowanej przy osi X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;wyświetla proporcje w danej kategorii zdefiniowanej przy osi X.</p>";
$pgv_lang["stat_help_z"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~OŚ Z~<br /><br />Następujące opcje są dostępne dla osi Z. Te opcje są podkategoriami rodzaju wybranego wykresu.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;wyświetla wartości w kolumnach dla każdej kategorii osi X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;wyświetla wartości w 2 kolumnach (mężczyźni i kobiety) dla każdej kategorii osi X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;wyświetla wartości w kolumnach odnoszących się do okresu ustawionego dla osi X.</p>";
$pgv_lang["stat_help_gwx"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~granice dla osi X~<br /><br />Wybierz żądany przedział czasu.<br /><br />Na przykład: <b>#pgv_lang[aft_marr]#</b> opisuje następujące przedziały czasu:<div style=\"padding-left:30px;\">przed ślubem<br />do 8 miesięcy po ślubie<br />od 8 do 12 miesięcy po ślubie<br />od 12 do 18 miesięcy po ślubie<br />od 18 do 24 miesięcy po ślubie<br />od 24 do 48 miesięcy po ślubie<br />więcej niż 48 miesięcy po ślubie</div><br /><br />Jeśli chcesz prezentować kwartały wybierz: <b>#pgv_lang[quarters]#</b>.";
$pgv_lang["stat_help_gax"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~granice dla osi X~<br /><br />Wybierz żądany przedział czasu.<br /><br />Na przykład: <b>co 10 lat</b> opisuje następujące przedziały lat:<div style=\"padding-left:30px;\">do roku<br />od roku do 5 lat<br />od 6 do 10 lat<br />od 11 do 20 lat<br />od 21 do 30 lat<br />od 31 do 40 lat<br />od 41 do 50 lat<br />od 51 do 60 lat<br />od 61 do 70 lat<br />od 71 do 80 lat<br />od 81 do 90 lat<br />od 91 do 100 lat<br />powyżej 100 lat</div>";
$pgv_lang["stat_help_gbx"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~granice dla osi X~<br /><br />Wybierz żądany przedział czasu.<br /><br />Na przykład: <b>co 2 lata</b> opisuje następujące przedziały lat:<div style=\"padding-left:30px;\">do 16 lat<br />od 16 do 18 lat<br />od 19 do 20 lat<br />od 21 do 22 lat<br />od 23 do 24 lat<br />od 25 do 26 lat<br />od 27 do 28 lat<br />od 29 do 30 lat<br />od 31 do 32 lat<br />od 33 do 35 lat<br />od 36 do 40 lat<br />od 41 do 50 lat<br />powyżej 50 lat</div>";
$pgv_lang["stat_help_gcx"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~granice dla osi X~<br /><br />Wybierz żądane grupowanie.<br /><br />Na przykład: <b>pojedynczo</b> opisuje następujące wartości:<div style=\"padding-left:30px;\">bez dzieci<br />jedno dziecko<br />dwoje dzieci<br />troje dzieci<br />czworo dzieci<br />pięcioro dzieci<br />sześcioro dzieci<br />siedmioro dzieci<br />ośmioro dzieci<br />dziewięcioro dzieci<br />dziesięcioro dzieci<br />ponad dziesięcioro dzieci w rodzinie</div><br /><br />Jeśli wybrana jest płeć jako rodzaj danych, wykres prezentuje liczbę dzieci danej płci w rodzinie.";
$pgv_lang["stat_help_gwz"]		= "~OPCJE WYKRESU STATYSTYK~<br /><br />~granice dla osi Z~<br /><br />Wybierz żądany rok początkowy oraz przedział czasu.<br /><br />Na przykład: <b>1700 co 50 lat</b> opisuje następujące zakresy:<div style=\"padding-left:30px;\">wydarzenia przed rokiem 1700<br />od 1700 do 1749 roku<br />od 1750 do 1799 roku<br />od 1800 do 1849 roku<br />od 1850 do 1899 roku<br />od 1900 do 1949 roku<br />od 1950 do 1999 roku<br />wydarzenia od roku 2000</div>";
$pgv_lang["chart_type_help"]	= "~OPCJE WYKRESU STATYSTYK~<br /><br />Wybierz co chcesz zobaczyć na mapie. Do wyboru są następujące opcje:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;pokazuje rozmieszczenie wszystkich osób w zależności od kraju.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;pokazuje rozmieszczenie osób z danym nazwiskiem w zależności od kraju.</p>";
$pgv_lang["google_chart_surname_help"]	= "~OPCJE WYKRESU STATYSTYK~<br /><br />Na wykresie zostaną zaprezentowane tylko osoby z podanym nazwiskiem. Jeśli pozostawisz pole puste, zostaną pokazane osoby noszące najpopularniejsze nazwisko tego drzewa genealogicznego.";
$pgv_lang["chart_area_help"]	= "~OPCJE WYKRESU STATYSTYK~<br /><br />Wybierz jaki obszar geograficzny chcesz zobaczyć na mapie. Do wyboru są następujące obszary:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;pokazuje wszystkie kontynenty.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;pokazuje Europę.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;pokazuje Amerykę Południową.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;pokazuje Azję.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;pokazuje rejon Bliskiego Wschodu.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;pokazuje Afrykę.</p>";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />Na tej stronie możesz w prosty sposób zarządzać plikami i katalogami plików multimedialnych.<br /><br />Kiedy tworzysz nowy podkatalog dla plików multimedialnych, PhpGedView tworzy analogiczną strukturę katalogów wewnątrz katalogu <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>. Kiedy wgrywasz nowe pliki multimedialne, PhpGedView może automatycznie utworzyć dla nich miniaturki i umieścić je w tym katalogu.<br /><br />W zależności od bieżącego statusu obiektu, obok każdego obrazka na liście multimediów możesz znaleźć następujące opcje:<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;Kiedy klikniesz tę opcję, zobaczysz stronę, na której możesz zmieniać tytuł tego obiektu multimedialnego. Jeśli ten obiekt nie jest jeszcze powiązany z osobą, rodziną lub źródłem w bieżącej bazie danych, możesz tutaj utworzyć takie powiązanie. Możesz także zmienić nazwę pliku i jego lokalizację wewnątrz struktury katalogu <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. W razie potrzeby PhpGedView automatycznie utworzy potrzebne podkatalogi lub brakujące miniaturki.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;Ta opcja jest dostępna tylko, jeśli została włączona przez administratora. Dzięki niej możesz oglądać i edytować nieprzetworzony wpis GEDCOM, dotyczący tego obiektu multimedialnego. Używaj tej opcji ostrożnie.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;Ta opcja pozwala usunąć wszelkie informacje o tym pliku multimedialnym z bazy danych. Nie będzie to miało wpływu na inne bazy. Jeśli ten plik nie jest wykorzystywany w innej bazie, zostanie usunięty fizycznie wraz z miniaturką.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;Ta opcja pozwala usunąć wszelkie informacje o tym pliku multimedialnym z bazy danych. Nie będzie to miało wpływu na inne bazy. Plik i jego miniaturka nie zostaną usunięte fizycznie.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;Ta opcja pozwala usunąć z bazy danych wszystkie powiązania z danym obiektem multimedialnym. Plik nie zostanie usunięty. Nie będzie to miało wpływu na inne bazy.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;Ta opcja umożliwia utworzenie powiązania pomiędzy plikiem multimedialnym a osobą, rodziną lub źródłem w bieżącej bazie danych. W razie potrzeby PhpGedView utworzy także obiekt multimedialny, przez który baza będzie połączona z plikiem.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;Wybranie tej opcji spowoduje utworzenie przez PhpGedView brakującej miniaturki.</li></ul>";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Prosty filtr wyszukiwania, oparty na wprowadzonych znakach; maski (np. ?, *) nie są dozwolone.";
$pgv_lang["show_thumb_help"]					= "~#pgv_lang[show_thumbnail]#~<br /><br />Jeśli zaznaczysz tę opcję, będą wyświetlane miniaturki.";
$pgv_lang["find_media_help"]					= "~#pgv_lang[find_media]#~<br /><br />Pozwala przeszukiwać strukturę plików, aby znaleźć obiekt multimedialny, z którym chcesz ustanowić powiązanie.";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]					= "~Identyfikator powiązania~<br /><br />Każdy obiekt multimedialny powinien być powiązany z co najmniej jedną osobą, rodziną lub źródłem w twojej bazie danych.<br /><br />Aby utworzyć takie powiązanie, w momencie tworzenia obiektu multimedialnego należy wprowadzić identyfikator powiązanej osoby, rodziny lub źródła. Możesz także ustanowić powiązanie później, za pomocą opcji edycji na stronie zarządzania multimediami, lub dodając obiekty multimedialne przez odnośnik \"Dodaj multimedia\" na stronie z danymi osoby, rodziny lub źródła.";
$pgv_lang["upload_server_file_help"]			= "~#pgv_lang[server_file]#~<br /><br />Wgrywany plik multimedialny może (i prawdopodobnie powinien) mieć inną nazwę na serwerze, niż miał na twoim komputerze lokalnym. Często lokalna nazwa jest zrozumiała dla ciebie, ale niekoniecznie dla innych osób, które zobaczą ją na stronie. Próbuj unikać sytuacji, w których może zajść niebezpieczeństwo, że zarówno ty, jak ktoś inny będzie chciał wgrać plik o nazwie \"babcia.jpg\".<br /><br />W tym polu podajesz nową nazwę wgrywanego pliku. Ta nazwa stanie się również nazwą miniaturki, która może zostać wgrana osobno lub utworzona automatycznie. Nie musisz wprowadzać rozszerzenia nazwy pliku (jpg, gif, pdf, doc, itd.)<br /><br />Pozostaw to pole puste, jeśli chcesz zachować oryginalną nazwę pliku z twojego komputera lokalnego.";
$pgv_lang["upload_server_folder_help"]			= "~#pgv_lang[server_folder]#~<br /><br />Administrator udostępnił maksymalnie #GLOBALS[MEDIA_DIRECTORY_LEVELS]# poziomów podkatalogów w katalogu <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Pomaga to w organizowaniu plików multimedialnych i zmniejsza ryzyko konfliktu nazw.<br /><br />W tym polu wprowadzasz katalog docelowy, w którym mają być przechowywane wgrany plik multimedialny. Analogiczny plik miniaturki, wgrany osobno lub wygenerowany automatycznie, będzie przechowywany w analogicznej strukturze katalogów, rozpoczynającej się od <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> zamiast <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Nie musisz wprowadzać części <b>#GLOBALS[MEDIA_DIRECTORY]#</b> katalogu docelowego.<br /><br />Jeśli nadal nie wiesz, co tu wpisać, skontaktuj sięz administratorem.";
$pgv_lang["view_server_folder_help"]			= "~#pgv_lang[server_folder]#~<br /><br />Administrator włączył możliwość ustawienia #GLOBALS[MEDIA_DIRECTORY_LEVELS]# poziomów folderów w domyślnym <b>#GLOBALS[MEDIA_DIRECTORY]#</b> folderze multimediów. Pozwala to na lepszą organizacę plików i zmniejsza ryzyko występienia takiej samej nazwy pliku.<br /><br />Tu możesz wybrać folder multimediów, który chcesz przejrzeć. Gdy wybierzesz <b>#pgv_lang[all]#</b>, wszystkie pliki zostaną wyświetlone.";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />Na tej stronie wyświetlona jest lista repozytoriów.<br /><br />Repozytoria są ułożone alfabetycznie według nazwy.<br /><br /><b>REPOZYTORIA</b><br />Bez repozytoriów nie można rozbudowywać naszej bazy danych. Każda informacja ma swoje źródło, a źródło przechowywane jest w repozytorium. Repozytoriami mogą być archiwa osobiste lub publiczne, publiczna baza danych, rejestry urzędowe lub parafialne, zasób internetowy itp. Aby dostać się do źródła, trzeba znać jego położenie. Wszystkie informacje niezbędne do odnalezienia źródła powinny być zawarte we wpisie repozytorium.<br /><br />Repozytorium może być powiązane z wieloma źródłami.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Ta strona wyświetla wszystkie informacje na temat repozytorium. Podobnie, jak źródła, repozytoria są bardzo ważne dla genealogów. Dzięki dokładnej informacji o źródle i repozytorium można prześledzić ścieżkę, którą ktoś inny dotarł do informacji. Dzięki temu każdy powinien być w stanie ponownie zweryfikować tę informację.<br /><br />Na tej stronie możesz zobaczyć informacje na temat tytułu, adresu, strony internetowej i adresu email dla danego repozytorium.<br /><br />Pod informacją o repozytorium znajduje się lista źródeł, które są z nim powiązane. Dzięki temu możesz zobaczyć całą informację, uzyskaną z tego repozytorium.<br /><br />Jeśli ta opcja została włączona przez administratora, możesz zobaczyć na tej stronie jedną lub dwie dodatkowe ikonki:<br /><b>#pgv_lang[view_gedcom]#</b> - pokazuje dane w formacie GEDCOM.<br /><b>#pgv_lang[add_to_cart]#</b> - umożliwia przechowanie tej informacji w wycinkach. Stamtąd możesz ją pobrać w formacie pliku GEDCOM i zaimportować do własnej aplikacji genealogicznej.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]					= "~#pgv_lang[delete_repo]#~<br /><br />Kliknięcie tej opcji spowoduje zaznaczenie tego repozytorium do usunięcia z bazy danych.<br /><br /><br /><br />Co to oznacza?<br />Załóżmy, że masz dobry powód, aby usunąć repozytorium z bazy danych. Klikasz na ten odnośnik. Zostaniesz poproszony(a) o potwierdzenie usunięcia. Nawet jeśli potwierdzisz swój wybór, może upłynąć trochę czasu, zanim zobaczysz komunikat o tym, że repozytorium zostało usunięte.<br /><br />Poruszając się po stronie zauważysz, że repozytorium jest nadal widoczne i może być używane tak samo, jakby nigdy nie zostało usunięte.<br /><br />#pgv_lang[no_mistake]#";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Kliknięcie na ten odnośnik spowoduje otworzenie nowego okna, w którym zostanie wyświetlona informacja o tym repozytorium w dokładnie takiej postaci, w jakiej jest zapisana w bazie danych.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Kliknięcie na ten odnośnik spowoduje dodanie informacji o tym repozytorium do wycinków w postaci, w jakiej jest zapisana w pliku GEDCOM.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />To jest lista nazw repozytoriów przechowywanych w bazie danych.<br /><br />Nazwy są ułożone alfabetycznie.<br /><br />Kliknięcie na nazwę z listy przeniesie cię do strony #pgv_lang[repo_info]#, gdzie zobaczysz listę wszystkich źródeł, powiązanych z danym repozytorium.";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />To jest lista wszystkich źródeł, powiązanych z danym repozytorium.<br /><br />Nazwy są ułożone alfabetycznie.<br /><br />Kliknięcie na nazwę z listy spowoduje przeniesienie na stronę z danymi źródła.";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Przesuń element listy~<br /><br />Użyj tych przycisków do zmienienia kolejności elementów na liście. Sekcje zostaną wyświetlone w tej samej kolejności.<br /><br />Zaznacz element, który chcesz przesunąć, a następnie kliknij odpowiedni przycisk, aby przemieścić go w górę lub w dół.";
$pgv_lang["block_move_right_help"]	= "~Przesuń element listy~<br /><br />Użyj tych przycisków, aby przenieść element z jednej listy na drugą.<br /><br />Zaznacz element, który chcesz przesunąć, a następnie kliknij przycisk, aby przesunąć lub skopiować ten element w kierunku strzałki. Użyj przycisków <b>&raquo;</b> i <b>&laquo;</b> aby przesunąć element ze skrajnie lewej do skrajnie prawej listy i na odwrót. Użyj przycisków <b>&gt;</b> i <b>&lt;</b> aby przesunąć zaznaczony element pomiędzy listą #pgv_lang[available_blocks]# a listami po prawej i lewej stronie.<br /><br />Elementy na liście #pgv_lang[available_blocks]# nie zmieniają się, niezależnie od używania przycisków #pgv_lang[move_right]# i #pgv_lang[move_left]#. Dzieje się tak, ponieważ możesz zechcieć umieścić ten sam blok kilka razy na tej samej stronie. Dobrym przykładem takiego bloku jest blok HTML.";
$pgv_lang["block_default_index"]	= "~Domyślne bloki na stronie głównej~<br /><br />Jeśli usuniesz wszystkie elementy z listy #pgv_lang[main_section]# i #pgv_lang[right_section]#, albo kiedy klikniesz przycisk <b>#pgv_lang[reset_default_blocks]#</b>, lista bloków zostanie ustawiona następująco:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[block_cookiepolicy]#<br />#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";
$pgv_lang["block_default_portal"]	= "~Domyślne bloki na stronie #pgv_lang[mygedview]#~<br /><br />Kiedy usuniesz wszystkie elementy z listy #pgv_lang[main_section]# i #pgv_lang[right_section]#, lub kiedy klikniesz przycisk <b>#pgv_lang[reset_default_blocks]#</b>, lista bloków zostanie ustawiona następująco:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span>";

// FAQ page
$pgv_lang["help_faq.php"] = "~Często zadawane pytania~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] = "Strona FAQ (ang. Frequently Asked Questions, często zadawane pytania) zawiera przegląd pytań i odpowiedzi na temat korzystania z tego serwisu genealogicznego.<br /><br />Wykorzystanie strony FAQ zależy całkowicie od administratora. Administrator decyduje o treści i kolejności elementów na tej stronie.";

// Help search
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Możesz przeszukiwać system pomocy PhpGedView. Opcja #pgv_lang[hs_title]# umożliwia ci szeroki zakres sterowania sposobem wyszukiwania.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br /><br />Tutaj wprowadzasz szukane słowo kluczowe lub wyrażenie.<br /><br />Wielkie i małe litery nie mają znaczenia dla wyszukiwania. Oznacza to, że jeśli szukasz terminu <b>Osoba</b>, znajdziesz tekst zawierający terminy <b>Osoba</b>, <b>osoba</b> oraz <b>OSOBA</b>. Znajdziesz także tekst zawierający <b>PierwszaOsoba</b> itd. ponieważ mechanizm szuka ciągu znaków, a nie pełnych słów.<br /><br />Możesz szukać kilku terminów naraz. Wprowadź wszystkie terminy, oddzielając je spacjami, na przykład: <b>osoba&nbsp;rodzina&nbsp;dziecko</b>. Jeśli wprowadzasz więcej niż jeden termin, dokładne znaczenie jest określone przez pole #pgv_lang[hs_searchhow]#.";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Tutaj określasz zakres wyszukiwania.<br /><br />Administratorzy moga przeszukiwać pomoc użytkownika, pomoc konfiguracyjną lub obie jednocześnie. Zwykli użytkownicy nie mają takiej możliwości; ponieważ nie mają dostępu do opcji konfiguracji, mogą przeszukiwać jedynie pomoc użytkownika.<br /><br />Pliki pomocy zawierają nie tylko treść pomocy, ale także pewne ciągi znaków, wykorzystywane do tworzenia formularzy, i inne elementy. Ta opcja pozwala określić, czy ma być przeszukiwany cały plik pomocy, czy tylko treść pomocy.";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br /><br />Tutaj określasz dokładne znaczenie terminów, które podano w polu #pgv_lang[hs_keyword]# wybierając jedną z poniższych opcji.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Jeśli na przykład podano terminy <b>osoba&nbsp;rodzina&nbsp;dziecko</b>, ta opcja pozwoli odszukać treść pomocy, która zawiera jeden z wprowadzonych terminów. Ich kolejność nie gra roli. Pełne kryterium wyszukiwania to: \"Znajdź treść pomocy zawierającą termin <b>osoba</b> <u>lub</u> <b>rodzina</b> <u>lub</u> <b>dziecko</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Jeśli podano terminy <b>osoba&nbsp;rodzina&nbsp;dziecko</b>, ta opcja pozwoli odszukać treść pomocy zawierającą wszystkie podane terminy. Kolejność terminów nie gra roli. Pełne kryterium wyszukiwania to: \"Znajdź treść pomocy zawierającą termin <b>osoba</b> <u>oraz</u> <b>rodzina</b> <u>oraz</u> <b>dziecko</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Jeśli podano terminy <b>osoba&nbsp;rodzina&nbsp;dziecko</b>, ta opcja pozwoli odszukać treść pomocy zawierającą wszystkie podane terminy w podanej kolejności. Pełne kryterium wyszukiwania to: \"Znajdź treść pomocy zawierającą wyrażenie <b>individual&nbsp;family&nbsp;child</b> w dokładnie takiej kolejności, bez żadnych dodatkowych znaków pomiędzy terminami\". Prawdopodobieństwo znalezienia dokładnie takiego wyrażenia w pomocy jest niewielkie.<br /><br />Ten typ wyszukiwania ma kilka ograniczeń. Pewne znaki specjalne, takie jak <b>&quot; &lt; &gt;</b> itd. występują w pomocy w znaczeniu symboli i nie zostaną odnalezione, jeśli wprowadzisz je jako część wyrażenia do wyszukiwania. Niektóre fragmenty tekstu pomocy zawierają również specjalny symbol spacji <b>&nbsp;</b>, co powoduje, że nie można ich odnaleźć za pomocą wyszukiwania.</dd></dl>";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />To narzędzie pomaga administratorowi w oczyszczeniu katalogu Index ze zbędnych plików.<br /><br />Pozwala na wybranie i usunięcie tylko plików zbędnych, takich jak logi, pliki kopii, czy też stare pliki GEDCOM.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

?>
