<?php
/**
 * Slovak Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Peter Moravcík
 * @version $Id: help_text.sk.php 7371 2024-02-07 01:04:20Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- GENERAL
$pgv_lang["help_header"]			= "Dalšie informácie o:";
$pgv_lang["privacy_error_help"]			= "<b>SÚKROMNÉ ÚDAJE</b><br /><br />Existuje niekolko možných dôvodov, preco sa vám zobrazila táto správa:<br /><br /><b>1. Informácie o žijúcich osobách v tomto GEDCOMe sú oznacené ako \"Súkromné\".</b><br /> Neregistrovaný návštevníci alebo návštevníci, ktorý nie sú prihlásený do systému, si môžu prezerat iba osobné údaje zosnulých osôb. Ak je to umožnené administrátorom, môžete sa zaregistrovat kliknutím na tlacítko \"Prihlásit sa\", potom na odkaz #pgv_lang[requestaccount]#.<br /><br /><b>2. Ste uživatel, ktorý tu má úcet zo svojím uživatelským menom a heslom...</b><br />Ale zabudli ste sa prihlásit alebo ste neboli dlhšiu dobu aktívny, a tak vám vypršala \"životnost\" session.<br /><br /><b>3. Kvôli nastaveniu utajenia</b><br />Osoba, na meno ktorej ste klikli, požiadala admina, aby informácie o nej boli nastavené ako súkromné alebo neboli zobrazené vôbec.<br />Utajenie môže byt nastavené na:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Mimo \"príbuzenskú vzdialenost\"</b><br />I ked ste registrovaným uživatelom <b>a</b> ste prihlásený, môže sa stat, že sa vám zobrazí táto správa. A to v prípade, že osoba, ktorú chcete zobrazit je s vami príbuzná vzdialene – vzdialenejšie, než je administrátorom nastavená Príbuzenská vzdialenost pre tento GEDCOM.<br />Príklady:<br />Ked je Príbuzenská vzdialenost nastavená na <b>1</b>, môžete zobrazit osobné údaje iba svojej najužšej rodiny: otca, matky, brata, sestry (ale nie partnerov vaších súrodencov a ich detí)<br /><br />Ked je Príbuzenská vzdialenost nastavená na <b>2</b>, môžete zobrazit i údaje vašej švagriny a jej detí (ale nie partnerov týchto detí).<br />Cím väcšia je hodnota je nastavená v Príbuzenskej vzdialenosti, tým vzdialenejších príbuzných uvidíte (ich osobné údaje).<br /><br />Ak si myslíte, že môžete získat oprávnenie vidiet urcité údaje, kontaktujte prosím administrátora stránok. Odkaz na neho je na každej stránke.";
$pgv_lang["more_help"]				= "<br />Ak chcete mat k dispozícii kontextovú nápovedu, uistite sa, že je volba <b>#pgv_lang[show_context_help]#</b> zapnutá (v Menu nápovedy), a kliknite na <b>?</b> za textom.";
$pgv_lang["more_config_help"]			= "<br /><b>Dalšia nápoveda</b><br />Dalšia nápoveda je k dispozícii z formulára.<br />Kliknite prosím na <b>?</b> za popiskami.";
$pgv_lang["start_admin_help"]			= "+++ Zaciatok informácií naviac pre Admina +++";
$pgv_lang["end_admin_help"]			= "--- Koniec informácií naviac pre Admina ---";
$pgv_lang["multiple_help"]			= "<span class='center'>--- Toto je všeobecná nápoveda pre viacej stránok ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>VŠEOBECNÉ INFORMÁCIE</b></div>";
$pgv_lang["best_display_help"]			= "~Váš monitor~<br/>PhpGedView je navrhnuté pre rozlíšenie 1024x768 pixelov.<br />Pre správne zobrazenie je teda potrebné, aby vaše rozlíšenie bolo minimálne 1024x768.<br />Ak nastavíte rozlíšenie na nižšiu hodnotu (napr. 800x600 pix.), budete sa musiet v okne vodorovne posúvat.";
$pgv_lang["preview_help"]			= "~Tlac~<br /><br />Ak kliknete na odkaz Tlacový režim, budú zo stránky odstránené všetky položky, ktoré v tlacovej podobe prekážajú (menu, formulárové polícka, odkazy, otázniky pre nápovedu apod.).<br />Dolu na stránke urcenej pre tlac uvidíte odkaz Vytlacit. Kliknite nan a objaví sa dialogové okno tlace.<br />Po vytlacení proste iba kliknete na odkaz <b>Spät</b> a objaví sa opät stránka v normálnom režime.<br /><br /><b>Poznámka:</b><br />I ked sú všetky nadbytocné odkazy v náhladovom režime odstránené, na mená v rámcekoch je možné klikat.";
$pgv_lang["readme_help"]			= "<span class='center'>Ak chcete dalšie informácie, podívajte sa do súboru <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a>.</span>";
$pgv_lang["is_user_help"]			= "--- Tento text je rovnaký ako ten, ktorý bude cítat uživatel (alebo návštevník). --- <br />--- Aby sme ušetrili miesto, nevytvárame u tejto položky špeciálny text pre admina. --";
$pgv_lang["edit_raw_gedcom_help"]		= "~UPRAVIT PRIAMO GEDCOM~<br /><br />Ak kliknete na tento odkaz, otvorí sa nové okno zo \"zdrojovým kódom\" GEDCOMu, konkrétne s údajmi, ktoré sú zobrazené na tejto stránke.<br />Tu môžete upravovat priamo samotný GEDCOM súbor. Dbajte na to, aby ste údaje zapisovali podla štandardu GEDCOM 5.5, pretože tieto záznamy sa už nebudú kontrolovat.<br />Zmenené, alebo pridané údaje sa v PhpGedView zobrazia ako zmeny, a budú teda musiet byt prijaté (potvrdené) uživatelom s právom potvrdzovat zmeny.";
$pgv_lang["RESN_help_title"]		= "Natavenie Reštrikcií pre Údaje";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />Nezávisle na všeobecnom nastavení utajenia, PhpGedView má možnost nastavenia reštrikcií na zobrazenie a editáciu údajov osôb, alebo rodín. Reštrikcie môžu byt nastavené kýmkolvek, kto má oprávnenie editovat údaje, ak mu to dovolujú už nastavené reštrikcie.<br /><br />Môžu byt použité nasledujúce hodnoty:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Administrátorovia stránky, administrátorovia GEDCOM, a uživatelia ktorí majú právo editovat údaje. Údaje môžu byt zobrazené podla nastavenia utajenia nastaveného administrátorom.</li><li><b>#pgv_lang[locked]#</b><br />Toto nastavenie nemá žiadny vplyv na viditelnost dát údajov. Obmedzí právo editácie pre administratorov stránky a administrátorom GEDCOM. Ak údaje patria uživatelovi, on ich môže zobrazit a samozrejme i editovat.</li><li><b>#pgv_lang[privacy]#</b><br />Administrátorovia stránky a GEDCOMu môžu zobrazit a editovat tieto údaje. Ak údaje patria uživatelovi, on ich môže zobrazit a samozrejme i editovat. Ale budú ukryté všetkým dalším uživatelom bez ohladu na ich status prihlásenia.</li><li><b>#pgv_lang[confidential]#</b><br />Iba  administrátorovia stránky a GEDCOMu môžu zobrazit a editovat údaje. Ale budú ukryté všetkým dalším uživatelom bez ohladu na ich status prihlásenia.</li></ul><br /><table><tr><th></th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Admin</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Vlastník</th><th>&nbsp;&nbsp;&nbsp;</th><th colspan=\"2\">Další</th></tr><tr><th></th><th></th><th>C</th><th>E</th><th></th><th>C</th><th>E</th><th></th><th>C</th><th>E</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" />&nbsp;#pgv_lang[none]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" />&nbsp;#pgv_lang[locked]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /><th></th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" />&nbsp;#pgv_lang[privacy]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" />&nbsp;#pgv_lang[confidential]#</td><th></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>C : môže cítat</li><li>E : môže editovat</li><li><img src=\"images/checked_qm.gif\"/> : v závislosti na všeobecnom nastavení utajenia</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~ÚVODNÁ STRANA~<br /><br />Toto je úvodná strana. Uvádza vás do zvoleného súboru <a href=\"#def_gedcom\">GEDCOM</a>. Na túto stránku sa môžete kedykolvek vrátit kliknutím na Úvodnú stránku v hornom menu. Ak je na týchto stránkach k dispozícii viacej GEDCOMov, môžete si zvolit GEDCOM z rolovacieho menu.<br /><b>Táto stránka s nápovedou obsahuje informácie o:</b><ul><li><a href=\"#index_portal\">Úvodnej stránke</a><li><a href=\"#header\">Oblasti záhlaví</a><li><a href=\"#menu\">Menu</a><li><a href=\"#header_general\">Všeobecné informácie</a><li><a href=\"#def\">Definície</a></ul><br />Verzia #VERSION# prináša nový vzhlad <a href=\"#def_pgv\">PhpGedView</a>. Menu, pociatocná strana a mnoho dalších vlastností je vylepšené alebo prepracované.";

//-- Index-page Header
//$pgv_lang["header_help_items"]	is moved to help_text_vars.php
$pgv_lang["header_help"]			= "<div class='name_head center'><b>OBLAST ZÁHLAVIA</b></div><br />Záhlavie je horná cast stránky a objavuje sa na každej stránke.<br />Záhlavie obsahuje užitocné odkazy, ktoré môžete používat pre prechádzanie stránok.<br />Pretože tieto stránky môžu mat rôzný vzhlad v závislosti na zvolenom <a href=\"#def_theme\">Motíve</a>, záhlavia rôzných motívov tým môžu byt ovplyvnené a môžu sa líšit.<br /><br /><b>Odkazy, ktoré tu môžete nájst, sú:</b><ul><li><a href=\"#header_search\">Vyhladávacie polícko</a><li><a href=\"#header_lang_select\">Výber jazyka</a><li><a href=\"#header_user_links\">Uživatelské odkazy</a><li><a href=\"#header_favorites\">Oblúbené</a><li><a href=\"#header_theme\">Zmena motívu</a></ul>";
$pgv_lang["header_search_help"]			= "~Oblast záhlavia: Vyhladávacie polícko~<br /><br />Toto vyhladávacie polícko je síce malé, ale zato možnosti vyhladávania sú široké.<br />Pre vyhladávanie môžete zadat takmer cokolvek. Ked kliknete na tlacítko <b>></b> alebo <b>Hladat</b>, budete presmerovaný na hlavnú stránku vyhladávania, kde uvidíte zoznam nájdených položiek.<br />Podrobnejšiu nápovedu k vyhladávaniu nájdete na hlavnej strane vyhladávania.";
$pgv_lang["header_lang_select_help"]		= "~Oblast záhlavia: Výber jazyka~<br/>Jedna z najdôležitejších vlastností tohoto programu je automatické prepnutie do podporovaného jazyka.<br /><br />Niekdy sa môže stat, že sa program návštevníkovi prepne do iného jazyka, než by si želal (napr. kvôli nesprávnemu nastaveniu jazyka v prehliadaci).<br />Návštevník si ale môže zmenit jazyk pomocou <b>>Výberu jazyka<</b><br />Výber jazyka môže byt zobrazený dvoma odlišnými spôsobmi:<br />Bud uvidíte klasický rolovací zoznam alebo lištu s národnými vlajkami.<br /> Ak ste registrovaným uživatelom, môžete si nakonfigurovat preferovaný jazyk, bez ohladu na nastavenie vašeho prehliadaca. Administrátor môže obmedzit pocet podporovaných jazykov.";
$pgv_lang["header_user_links_help"]		= "~Oblast záhlavia: Uživatelské odkazy~<br /><br />Uživatelské odkazy sú užitocné odkazy zobrazené v malom bloku vždy na rovnakom mieste na stránke (ak nebudete menit motívy)<br />Ak nebudete ešte prihlásený, uvidíte iba odkaz <b>Prihlásit sa</b>.<br />Ked už budete prihlásený, uvidíte: <b>Prihlásený(á) ako (vaše uživatelské meno)</b>. Ak kliknete na tento odkaz, dostanete sa do svojho úctu.<br />Odkaz <b>Odhlásit sa</b> je jasný: urobit presne to.<br />Ak máte práva administrátora, uvidíte tiež <b>Admin</b>. Kliknutie na tento odkaz vás prenesie priamo na hlavnú stránku administrácie.";
$pgv_lang["header_favorites_help"]		= "~Oblast záhlavia: Moje oblúbené~<br /><br />V tomto rolovacom zozname nájdete svoje oblúbené, ktoré ste si vybrali na svojej osobnej vstupnej stránke.<br />Kliknutím na jednu z týchto položiek sa dostanete priamo na stránku s údajmi o tejto osobe.<br />Dalšia nápoveda o pridávaní Oblúbených je k dispozícii na vstupnej stránke.";
$pgv_lang["header_theme_help"]			= "~Oblast hlavicky: Zmenit motív~<br /><br />Ak je to povolené administrátorom, zobrazí sa rolovacie menu s výberom motívu vzhladu pre tieto stránky. Ak si vyberiete jeden z motívov, zmení sa vzhlad stránok. Ak ste naviac prihlásený do systému, zmení sa tiež váš uživatelský motív.";
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENU</b></div><br />V záhlaví stránok máme rolovacie menu.<br />Pohybom myšou cez ikonu menu sa vyvolá podmenu, ak nejaké pre danú položku existuje.<br />Kliknutie na ikonu menu vás presmeruje na stránku, ktorá je prvou položkou v podmenu.<br /><br /><b>Môžete si vybrat z nasledujúcich hlavných položiek:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></ul>";
$pgv_lang["menu_famtree_help"]			= "~Menu úvodnej stránky~</b><br />V menu sú zaradené všetky dostupné GEDCOMy. Každý GEDCOM má svoju vlastnú Úvodnú stránku ako je táto.<br />Ak je na týchto stránkach práve jeden GEDCOM, žiadne podmenu pod ikonkou Úvodnej stránky nenájdete.";
$pgv_lang["menu_myged_help"]			= "~Menu vstupnej brány MyGedView~<br /><br />Ak ste prihlásený, toto menu môže obsahovat nasledujúce položky:<dl><dt> MyGedView</dt><dd>Vás zavedie na vašu vlastnú \"úvodnú stránku\".</dd><dt>Môj úcet</dt><dd>Tu môžete upravovat svoj uživatelský úcet.</dd><dt>Rýchla aktualizácia</dt><dd>Tu môžete upravovat osobné údaje lubovolnej osoby.</dd><dt>Môj vývod</dt><dd>Ak ste zvolili pre tento GEDCOM východiskovú osobu, tento odkaz vás zavedie na stránku s jej vývodom.</dd><dt>Môj osobný záznam</dt><dd>Tento odkaz vás presmeruje na stránku o vašej osobe, kde sú zobrazené všetky genealogické údaje o vás a vašej rodine.</dd></dl>";
$pgv_lang["menu_charts_help"]			= "~Menu schém~<br /><br />Pod touto položkou menu sú zaradené všetky dostupné schémy:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Tento odkaz vás zavedie na stránku s vývodom pre aktuálny GEDCOM. Vývod zacína východiskovou osobou GEDCOMu. Ak ste však prihlásený, východiskovou osobou môžete byt vy alebo niekto iný podla vášho výberu.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Rozrod je viacmenej <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> v obrátenom slede.<br />Toto zrovnanie nije úplne najvhodnejšie, avšak, zatial co vývod zobrazuje všetkých predkov východiskovej osoby, rozrod vám ukáže všetkých potomkov tejto (východiskovej) osoby.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Casová osa</dt><dd>Tu si môžete prezriet udalosti u danej osoby zachytené na casovej ose.<br />Je velmi zaujímavé porovnávat udalosti dvoch ci viacerých osôb na jednej ose.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Tu môžete nájst príbuzenské vztahy nejakej osoby s vami alebo inou osobou.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Velmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale zahrnuje viacej informácií a strieda <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> zobrazenie.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Velmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale z väcším dôrazom na grafickú podobu.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Menu zoznamov~<br /><br />K dispozícii sú nasledujúce zoznamy:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>V týchto dvoch zoznamoch môžete prechádzat abecedný zoznam ludí z tohoto GEDCOMu.<br />Prvý z nich zobrazí zoznam jednotlivcov a druhý zoznam rodín.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Pod touto položkou sa skrývá zoznam všetkých pramenov použitých v GEDCOMe.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Tu môžete vyhladávat ludí podla miesta. Zobrazí sa vám dvojstlpcový zoznam. Osoby sú zoradené vlavo, rodiny vpravo.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Túto položku uvidíte jedine v prípade, že je zapnutá administrátorom.<br />Ak kliknete na nu, zobrazia sa vám odkazy na všetky multimediálne súbory použité v tomto GEDCOMe.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Menu kalendára výrocí~<br /><br />Kalendár výrocí zobrazuje udalosti vztahujúce sa ku zvolenému dátumu, mesiaci ci roku.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Kliknutím na túto položku menu sa dostanete do Kalendára výrocí, ktorý vám ukáže udalosti pre aktuálny den.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Kliknutím na túto položku menu sa dostanete do Kalendára výrocí, ktorý vám ukáže udalosti pre aktuálny mesiac.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Cez tento odkaz sa dostanete do Kalendára výrocí tak, že vám ukáže udalosti pre daný rok.</dd></dl>";
$pgv_lang["menu_clip_help"]			= "~Menu Schránky výstrižkov~<br /><br />Ak je táto volba zapnutá administrátorom, uvidíte ju v lište menu.<br />Schránka výstrižkov vám umožnuje vybrat osoby, rodiny a pramene a uložit si ich ako \"ústrižky rodokmena\" do Schránky výstrižkov, ktorú si potom môžete stiahnút v podobe súboru GEDCOM 5.5.";
$pgv_lang["menu_search_help"]			= "~Menu Hladanie~<br /><br />Vyhladávacia stránka, kam sa dostanete kliknutím na tento odkaz, je to mocnejší vyhladávací nástroj než odkaz Hladat, ktorý môžete nájst v záhlaví.";
$pgv_lang["menu_help_help"]			= "~Menu nápovedy~<br /><br />#pgv_lang[help_help_items]#";
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>ÚVODNÁ STRANA</b></div>";
$pgv_lang["index_portal_help"]			= "Úvodná stránka sa skladá z niekolko oddelených blokov a je možné ju upravovat. Takže pre každý GEDCOM (tzn. ak je dostupných viacej GEDCOMov), môžete vidiet inú úvodnú stranu.<br /><br /><b>V závislosti na tom, ako administrátor nastavil tento systém môžete na úvodnej strane vidiet niektoré z týchto blokov:</b><ul><li><a href=\"#index_welcome\">Úvodný</a><li><a href=\"#index_login\">Prihlasovací</a><li><a href=\"#index_events\">Nadchádzajúce udalosti</a><li><a href=\"#index_onthisday\">Tohoto dna vo vašej histórii...</a><li><a href=\"#index_favorites\">Oblúbené GEDCOMu</a><li><a href=\"#index_stats\">Štatistika GEDCOMu</a><li><a href=\"#index_common_surnames\">Najcastejšie priezviská</a><li><a href=\"#index_media\">Náhodný obrázok</a><li><a href=\"#index_loggedin\">Prihlásený uživatelia</a><li><a href=\"#gedcom_news\">Novinky GEDCOMu</a><li><a href=\"#recent_changes\">Posledné zmeny</a></ul>";
$pgv_lang["index_welcome_help"]			= "~UVÍTACÍ BLOK~<br /><br />Tento uvítací blok vám ukazuje:<br />Aktuálny súbor GEDCOM, dátum a cas a (ak je to povolené adminom) <b>Pocítadlo prístupov</b>.<br />Toto pocítadlo nájdete iba v uvítacom bloku a na stránke s osobnými údajmi.<br />Pocítadlo zaznamenáva pocet prístupov k týmto stránkam. To znamená: kolkokrát boli tieto stránky navštívené.<br />Pocítadlo nekontroluje URL návštevníka, takže, ked niekto stránku po nejakom case znovu navštíví (napr. dva krát za den), bude zapocítaný ako další návštevník.";
$pgv_lang["mygedview_welcome_help"]		= "<dl>~UVÍTACÍ BLOK ~<dt>Tento uvítací blok zobrazuje:</dt><dd>- Aktuálny GEDCOM súbor</dd><dd>- Dátum a cas</dd><dd>- Odkazy na:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (precítajte si komentár)</dd><dd>- - #pgv_lang[my_indi]# (precítajte si komentár)</dd><dd>- - #pgv_lang[customize_page]#</dd></dl><b>Komentár</b><br />Odkazy na \"Môj vývod\" a \"Môj osobný záznam\" uvidíte jedine vtedy, ak je v súbore GEDCOM o váš záznam.<br />Takže je možné, že v jednom GEDCOM súbore ste zapísaný a uvidíte odkazy \"Môj vývod\" a \"Môj osobný záznam\", zatial co v inom GEDCOMe záznam o vás nie je a odkazy \"Môj vývod\" a \"Môj osobný záznam\" potom nebudú zobrazené.";
$pgv_lang["index_login_help"]			= "~PRIHLÁSIT SA~<br /><br />I ked je možné sa prihlásit takmer na každej stránke tohoto programu, je najlepšie prihlásit sa hned na prvej stránke, pretože máte tak prístup k dalším informáciám.<br />Prihlásite sa vložením <b>uživatelského mena</b> a <b>hesla</b> a kliknutím na tlacítko \"Prihlásit sa\".";
$pgv_lang["index_events_help"]			= "~BLOK NADCHÁDZAJÚCICH UDALOSTÍ~<br /><br />V tomto bloku uvidíte udalosti od dneška do konca mesiaca.<br />Sú to všetky udalosti uložené v GEDCOMe.";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Vložte pocet dní ktoré sa majú zobrazit. Toto císlo nesmie byt vacšie než <b>#DAYS_TO_SHOW_LIMIT#</b>. Ak zadáte vacšiu hodnotu, bude použitý limit.<br /><br />Zobrazený limit je nastavený administrátorom v konfigurácii GEDCOMu.";
$pgv_lang["index_onthisday_help"]		= "~BLOK \"TENTO DEN VO VAŠEJ HISTÓRII\"~<br /><br />Tento blok má podobné vlastnosti ako blok Nadchádzajúcich udalostí, tu sa vám však zobrazia iba udalosti viažúce sa ku dnešku.";
$pgv_lang["index_favorites_help"]		= "~BLOK OBLÚBENÝCH GEDCOMU~<br /><br />Blok Oblúbených GEDCOMu je viacmenej podobný bloku \"Moje oblúbené\" na vstupnej bráne MyGedView. Ale v tomto prípade môže pridávat, mazat a menit oblúbené iba administrátor stránok alebo uživatel s právami administrátora.<br />Úcelom Oblúbených GEDCOMu je upozornit na osobu ci osoby zvlášt dôležité.<br />V záhlaví každej strany vašich stránok je k dispozícii rolovací zoznam \"Oblúbené tohoto GEDCOMu\".<br />Tak budete presmerovaný na stránku s údajmi o danej osobe.<br /><br />Rámcek obsahujúci meno oblúbenej osoby je kvôli úspornosti zobrazený s minimom informácií o tejto osobe. V pravej casti rámceka je ikonka lupy, pomocou ktorej môžete získat dalšie informácie.<br />Ak kliknete na meno, presuniete sa na stránku s údajmi o danej osobe.<br />Na pravej strane tiež nájdete menu, ktoré vás môže zaviest na stránky s dalšími informáciami alebo schémami.";
$pgv_lang["index_add_favorites_help"]		= "~PRIDAT OBLÚBENÉ~<br /><br />Tento formulár vám umožnuje pridat do vašeho zoznamu oblúbených novú položku. Musíte zadat ID osoby, rodiny, alebo zdroja ktorý chcete uložit ako oblúbené, alebo musíte zadat URL a názov. Pole Poznámka je nepovinné a môže byt použité na popis. Cokolvek uložené v poli Poznámka bude zobrazené v bloku Oblúbené za položkou.";
$pgv_lang["index_stats_help"]			= "~BLOK ZO ŠTATISTIKOU GEDCOMU~<br /><br />V tomto bloku vidíte štatistické údaje o aktuálnom súbore GEDCOM.<br />Ak chcete viacej informácií, môžete poslat správu na kontaktnú adresu na zápätí stránky.";
$pgv_lang["index_common_names_help"]		= "~BLOK S NAJCASTEJŠÍMI PRIEZVISKAMI~<br /><br />V tomto bloku sú zobrazené priezviská, ktoré sa v tomto GEDCOMe vyskytujú najcastejšie.<br />Minimálnu cetnost výskytu jedného priezviska potrebnú k tomu, aby priezvisko bolo zaradené medzi najcastejšie môže nastavit administrátor.<br />(Súcasné nastavenie tohoto limitu je #COMMON_NAMES_THRESHOLD#)<br />Na mená môžete kliknút. Jedným kliknutím na meno sa dostanete na #pgv_lang[individual_list]#, kde získate dalšie informácie o tomto mene.";
$pgv_lang["index_media_help"]			= "~BLOK S NÁHODNÝM OBRÁZKOM~<br /><br />Program vyberie náhodne mediálny súbor, ktorý vám ukáže v tomto bloku pri návšteve tejto stránky.<br />Ak kliknete na tento obrázok alebo jeho názov, uvidíte ho v pôvodnej velkosti.<br />Pod obrázkom je odkaz na osobu, ku ktorej je obrázok pripojený.<br />Kliknutím na toto meno budete presmerovaný na stránku s údajmi o tejto osobe.";
$pgv_lang["index_loggedin_help"]		= "~BLOK PRIHLÁSENÝCH UŽIVATELOV~<br /><br />V tomto bloku zistíte, kolko uživatelov je práve teraz prihlásených.";
$pgv_lang["index_gedcom_news_help"]		= "~BLOK NOVINIEK GEDCOMU~<br /><br />Blok Noviniek GEDCOMu je nieco ako billboard tohoto GEDCOMu.<br />Administrátor sem môže umiestnit dôležité oznámenia alebo zaujímavé novinky.<br /><br />Ak máte nieco zaujímavého k zobrazeniu, kontaktujte prosím administrátora a on vašu správu bude môct pridat do noviniek.";
$pgv_lang["recent_changes_help"]		= "~BLOK POSLEDNÝCH ZMIEN~<br /><br />V tomto bloku sa objavia posledné zmeny, ktoré boli v GEDCOMe urobené, ako je v súbore GEDCOM zaznamenané pomocou tagov CHAN.";
$pgv_lang["gedcom_news_limit_help"]		= "Môžete obmedzit pocet zobrazený Noviniek pre zredukovanie velkosti bloku Novinky GEDCOMu. Táto volba urcuje ci bude uplatnený nejaký limit a ci bude závislý na veku clánkov, alebo ich pocte.";
$pgv_lang["gedcom_news_flag_help"]		= "Vložte hodnotu limitu.<br /><br />Ak ste sa rohodli obmedzit zobrazenie Noviniek vekom, všetky clánky staršie (v dnoch) než je zadaná hodnota budú skryté. Ak ste sa rohodli obmedzit zobrazenie Noviniek poctom clánkov, bude zobrazený zadaný pocet clánkov zotriedených podla veku. Ostatné clánky budú skryté.<br /><br />Ak zadáte hodnotu nula (0) vypnete limit a budú zobrazené všetky clánky.";
$pgv_lang["gedcom_news_archive_help"]		= "Pre zredukovanie velkosti bloku Novinky, administrator potlacil zobrazenie niektorých clánkov. Môžete zobrazit tieto skyté clánky klinutím na link <b>#pgv_lang[gedcom_news_archive]#</b>";
$pgv_lang["index_htmlplus_help"]		= "~ZDOKONALENÝ HTML BLOK~<br /><br />Tento blok dovoluje administrátorom pridat informácie na Index alebo Portal stránky. Úcel je rovnaký ako u blokov HTML, Novinky a GEDCOM Štatistiky, ale administrátor má viac možností nastavit jeho vzhlad.";
$pgv_lang["index_htmlplus_title_help"]	  	= "Tento text by mal byt prázdny, alebo velmi strucný. Ak je prázdny tak zdokonalený HTML blok bude zobrazený na Index alebo Portal stránke ako prostý blok, presne tak ako je HTML blok urobený. Ak je tu nejaký text tak zdokonalený HTML blok bude zobrazený ako všetky dalšie bloky, kompletný i s titulkom obsahujúcim text, ktorý je tu vložený.";
$pgv_lang["index_htmlplus_template_help"]	= "Pre pomoc pri práci s týmto blokom sme vytvorili niekolko štandardných šablon. Ak si zvolíte niektorú šablonu, textová oblast bude obsahovat predlohu, ktorú môžete zmenit a prispôsobit tak požiadavkám vašich stránok.";
$pgv_lang["index_htmlplus_content_help"]	= "Na rozdiel od blokov HTML, Noviniek a GEDCOM Štatistika, máte neobmedzené možnosti upravit vzhlad vašeho bloku. Môžete použit HTML tagy, blok používá CSS štýly stránky pre práve aktívnu tému. Odkazy na informácie z práve aktívnej genealogickej databázi môžu byt vložené do textu.<br /><br />Databázové odkazy sú oznacené klúcovým slovom uzatvoreným medzi dva symboly <b>&#35;</b>. Napríklad <b>&#35;TOTAL_FAM&#35;</b> predstavuje pocet rodín v databáze. Obcas môžete chciet použit databázový odkaz ak text miesto jeho skutocného významu. Aby ste to mohli urobit, musíte nahradit symboly <b>&#35;</b> uzatvárajúce klúcové slovo ich ekvivalentom. Napríklad, ak vas text obsahuje  <b>&&#35;35;TOTAL_FAM&amp&#35;35;</b> tak bude zobrazený ako <b>&#35;TOTAL_FAM&#35;</b> miesto navratu databázového odkazu.<br /><br />Zoznam klúcových slov nasleduje:<br /><table><tr valign=top><td><ul><li>COMMON_SURNAMES </li><li>TOTAL_INDI </li><li>TOTAL_FAM </li><li>TOTAL_SOUR </li><li>TOTAL_OTHER </li><li>TOTAL_SURNAMES </li><li>TOTAL_MALES </li><li>TOTAL_FEMALES </li><li>TOTAL_UNKNOWN_SEX </li><li>TOTAL_EVENTS </li><li>TOTAL_EVENTS_BIRTH </li><li>TOTAL_EVENTS_DEATH </li><li>TOTAL_EVENTS_MARRIAGE </li><li>TOTAL_EVENTS_OTHER </li><li>TOTAL_USERS </li><li>FIRST_EVENT </li><li>FIRST_EVENT_TYPE </li><li>FIRST_EVENT_NAME </li><li>FIRST_EVENT_YEAR </li><li>LAST_EVENT </li><li>LAST_EVENT_TYPE </li><li>LAST_EVENT_NAME </li><li>LAST_EVENT_YEAR </li><li>FIRST_BIRTH </li><li>FIRST_BIRTH_NAME </li><li>FIRST_BIRTH_YEAR </li></ul></td><td><ul><li>LAST_BIRTH </li><li>LAST_BIRTH_NAME </li><li>LAST_BIRTH_YEAR </li><li>LONG_LIFE </li><li>LONG_LIFE_NAME </li><li>LONG_LIFE_AGE </li><li>TOP10_OLDEST </li><li>AVG_LIFE </li><li>MOST_CHILD </li><li>MOST_CHILD_NAME </li><li>MOST_CHILD_TOTAL </li><li>TOP10_BIGFAM </li><li>AVG_CHILD </li><li>HIGHLIGHT </li><li>GEDCOM </li><li>GEDCOM_ID </li><li>GEDCOM_TITLE </li><li>CREATED_SOFTWARE </li><li>CREATED_VERSION </li><li>CREATED_DATE </li><li>GEDCOM_UPDATED </li><li>GEDCOM_CONTACT </li><li>WEBMASTER_CONTACT </li></ul></td></tr></table><br />|";
$pgv_lang["help_help"]				= "Samozrejme, že by bolo skvelé vyrobit program, ktorého ovládanie by bolo tak jednoduché, že by nepotreboval vôbec žiadne vysvetlivky.<br />Malo by to byt rovnako lahké ako cítanie knihy.<br />I ked je program pomerne zložitý, v uživatelskom rozhraní to nepoznáte. Takmer všetko sa dá použit bez nápovedy.<br />Ale, pretože máme hodne návštevníkov a uživatelov, ktorý nemajú moc skúseností z prácou na pocítaci alebo na internete, ponúkame casto na urcitých miestach nápovedu.<br />V menu nápovedy nájdete nasledujúce položky:";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Nápoveda k tejto stránke</b></dt><dd>Pre všetky stránky je dostupná všeobecná nápoveda.<br />Ked ste na nejakej stránke, môžete kliknút na túto položku v menu a otvorí sa vám okno s nápovedou informujúce o položkách, ktoré nájdete na danej stránke.<br />Nápoveda ku stránke je väcšinou strucná.<br />Ak chcete dalšiu nápovedu alebo informáciu o urcitej položke na stránke, potom je tu tretia volba menu: \"Kontextová nápoveda\".</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Obsah nápovedy</b></dt><dd>Ak kliknete na túto položku menu, vyskocí vám pop-up okno s nápovedou, kde uvidíte index hlavných položiek nápovedy.<br />V indexe bude v dohladnej dobe viacej položiek, pretože budú zahrnuté i ostatné položky.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ zoznam</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Skryt / Ukázat Kontextovú nápovedu</b></dt><dd>Táto posledná položka menu môže byt pre vás najužitocnejšia. Kliknutie na túto volbu bud zapne nebo vypne kontextovú nápovedu.<br />Co je to \"Kontextová nápoveda\"?<br />Ak je zapnutá, nájdete u niektorých odkazov, tlacítok a polícok otáznik. Kliknutie na tento <b>?</b> vyvolá malé okienko s nápovedou k danému objektu.<br />Samozrejme, že ked kliknete na \"Skryt kontextovú nápovedu\", všetky otázniky budú skryté do tej doby, než kliknete znovu na \"Zobrazit...\". </dd></dl>";
$pgv_lang["def_help"]				= "<div class='name_head center'><b>DEFINÍCIE</b></div><br />Definície niektorých výrazov používaných v tejto nápovede:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Dáta</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Vstupná brána (portál)</a><li><a href=\"#def_theme\">Motív</a></ul>";
$pgv_lang["def_portal_help"]			= "~Vstupná brána~<br /><br />Vstupná brána týchto stránok je nieco ako vestibul reštaurácie. Je to miesto, kde môžete nájst dôležité informácie ako vysvetlivky, menu atd..";
$pgv_lang["def_gedcom_help"]			= "~Súbor GEDCOM~<br /><br />Súbor GEDCOM je súbor obsahujúci všetky informácie o rode.<br />Všetky údaje, dátumy, udalosti atd. sú ukladané v súbore GEDCOM.<br />Pre súbor GEDCOM platia prísne pravidlá, pretože musí umožnovat predávanie dát medzi všetkými genealogickými programami nezávisle na platforme ci systéme.";
$pgv_lang["def_gedcom_date_help"]		= "~Dáta v súbore GEDCOM~<br /><br />Pretože formáty v súboroch GEDCOM musia zodpovedat medzinárodným pravidlám, je tam i uvedenie zápisu datumu.<br /><br />I ked polícko pre dátum v GEDCOM súbore môže obsahovat dokonca iba text, tu je vysvetlenie správneho zapisovania dátumov:<br />Celý dátum sa vkladá ako DD MMM YYYY - tj.:<br />01 Mar 1801 alebo 14 Dec 1950<br />Ak vám cast dátumu chýba, môžete ju v zápise vynechat, ako napr.:<br />Mar 1801 nebo 14 Dec<br />Ak si nie ste istý alebo dátum nie je potvrdený, mohli by ste napísat:<br />abt Mar 1801 (abt = okolo)<br />bef 20 Dec 1950 (bef = pred) <br />aft 1949 (aft = po)<br />Uistite sa, že ste zadali tieto dáta a skratky v anglictine, pretože program potom všetko preloží sám do zvoleného jazyka.<br />Naviac program sám musí z dátumami pocítat. Ak budú dátumy zadané v zlom formáte, program nebude schopný s nimi správne pracovat.";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br /><br />PhpGedView (alebo PGV) je program zobrazujúci súbory GEDCOM online, vytvorený Johnom Finlayom.<br />Ako si môžete všimnút, tento program nevytvára obycajné statické webové stránky, ale je dynamický a je možné ho v mnoha smeroch upravovat.<br />John ho zacal vyvíjat sám, ale v súcasnosti na nom pracuje medzinárodný tým vývojárov a prekladatelov.<br />Okrem prezerania súborov GEDCOM, môže dnes uživatel pridávat a upravovat údaje a udalosti online.";
$pgv_lang["def_theme_help"]			= "~Motív~<br /><br />Stránky môžu mat rôzne \"podoby\", ktorým sa hovorí motívy.<br />Administrátor stránok vyberá pociatocný motív.<br />Každý, kto na tieto stránky vstúpi, uvidí rovnaký vzhlad (motív). Ak to administrátor umožní v nastavení programu, môžu si prihlásený uživatelia vybrat svoj vlastný motív.<br />Ak si uživatel vybral iný motív, program si toto nastavenie uloží a uživatel ho uvidí ho ihned po prihlásení.";
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[upper_mygedview]#~<br /><br />Toto je vaša osobná stránka #pgv_lang[mgv]#.<br />Na tejto stránke sú odkazy na vaše osobné údaje, napr. <b>Môj osobný záznam</b> (to je stránka s GEDCOM údajmi o vašej osobe), <b>Môj úcet</b>,<b>Môj vývod</b>.<br />Dalej tu môžete mat blok zo <b>Správami</b>, <b>Denník</b> (ako poznámkový blok) a mnoho dalšieho.<br /><br />Rozvrhnutie tejto stránky je rovnaké ako úvodnej (uvítacej) stránky.<br />Zatial co úvodná strana je spravovaná iba administrátorom, túto stránku si môžete upravit podla seba (vybrat z ponúkaných blokov pre zobrazenie).<br /><br />V úvodnom bloku tejto strany nájdete odkaz pre úpravu tejto stránky.<br /><b>Môžete si vybrat z nasledujúcich blokov:<br /><br /></b><ul><li><a href=\"#mygedview_welcome\">Úvodný</a><li><a href=\"#mygedview_customize\">Upravit MyGedView</a><li><a href=\"#mygedview_message\">Správy</a><li><a href=\"#mygedview_events\">Nadchádzajúce udalosti</a><li><a href=\"#mygedview_onthisday\">Tohoto dna vo vašej histórii...</a><li><a href=\"#mygedview_favorites\">Moje oblúbené</a><li><a href=\"#mygedview_stats\">Štatistika GEDCOMu</a><li><a href=\"#mygedview_myjournal\">Môj denník</a><li><a href=\"#mygedview_media\">Náhodný obrázok</a><li><a href=\"#mygedview_loggedin\">Prihlásený uživatelia</a><li><a href=\"#mygedview_recent_changes\">Posledné zmeny</a></ul>";
$pgv_lang["mygedview_customize_help"]		= "~ÚPRAVA #pgv_lang[upper_mygedview]#~<br /><br />Ked ste sem vstúpili prvý krát, už ste na tejto stránke mali nejaké bloky.<br />Ak chcete, môžete si svoju vstupnú bránu prizpôsobit.<br />Kliknutie na tento odkaz vás prenesie do formulára v pop-up okne, kde budete môct bloky pridat, zmazat alebo presunút.<br />Dalšia nápoveda je k dispozícii na formulári.";
$pgv_lang["mygedview_message_help"]		= "~BLOK SPRÁV~<br /><br />V tomto bloku nájdete správy, ktoré vám poslali ostatný uživatelia alebo administrátor.<br />Samozrejme môžete i vy sami poslat správy ostatným uživatelom alebo adminovi.<br />E-mailový systém PhpGedView je vytvorený tak, aby chránil vaše súkromie. Nemusíte sem zadávat svoju e-mailovú adresu a ostatný uživatelia ju tak neuvidia.<br /><br />Ak chcete e-mail zväcšit, kliknite na znacku \"+\" vedla e-mailu. Ked zaškrtnete polícka vedla správ, ktoré chcete zmazat, a potom kliknete na tlacítko \"Zmazat oznacené správy, odstránite všetky oznacené správy naraz.";
$pgv_lang["mygedview_favorites_help"]		= "~BLOK MOJICH OBLÚBENÝCH~<br /><br />Moje oblúbené fungujú podobne ako záložky v knihe.<br />Predpokladajme, že máte v rodokmeni niekoho, ktorého záznam si chcete prezerat pravidelne.<br />Otvorte stránku tejto osoby a kliknite na odkaz \"Pridat do Mojich oblúbených\". U tejto osoby je teraz záložka a je pridaná do vášho zoznamu Oblúbených.<br />Ak ste kdekolvek na stránkach, môžete kliknút na meno z rolovacieho zoznamu v záhlaví \"Moje oblúbené\".<br />To vás presmeruje na osobnú stránku tejto osoby.<br /><br />Kvoli ušetreniu miesta sú rámceky zobrazené z minimom informácií. Napravo v rámceku uvidíte lupu, pomocou ktorej môžete získat dalšie informácie.<br />Kliknutie na meno vás presmeruje na osobnú stránku tejto osoby.<br />Na pravej strane uvidíte menu, ktoré vás navedie na stránky s dalšími informáciami alebo schémami.";
$pgv_lang["mygedview_myjournal_help"]		= "~BLOK \"MOJ DENNÍK\"~<br /><br />Do tohoto denníku môžete zapisovat poznámky (alebo pripomienky) pre vlastnú potrebu.<br />Samozrejme, že poznámka, ktorú vložíte, tu bude i pri vašej dalšej návšteve.<br /><br />Tieto poznámky sú pre ostatných neviditelné.";
$pgv_lang["help_pedigree.php"]			= "~STRÁNKA S VÝVODOM~<br /><br />Väcšina uživatelov a návštevníkov bude vediet, co je to vývod, ale predsa nieco málo o našom vývode:<br />Vývod je v skutocnosti výcet všetkých predkov východiskovej osoby.<br />Ked ste vstúpili na túto stránku, videli ste vývod osoby, ktorá bola v rámceku úplne vlavo (ked sa prihlásite, môžete si zvolit vlastnú východiskovú osobu).<br /><br />Takže, \"všetci predkovia\" znamená otec a matka a ich rodicia a tak dalej.<br />Na týchto stránkach vidíte vývod v grafickej podobe.<br />Nemusíte sa predierat stranami textu, aby ste zistili, kto sú vaši predkovia.<br />Všetky osoby sú na obrazovke zobrazené v rámcekoch.<br /><br />* RÁMCEKY VO VÝVODE<br />Ak je na stránke s vývodom nastavené zobrazovanie podrobností, uvidíte meno osoby, dátum narodenia a úmrtia.<br />Na meno osoby môžete kliknút a to vás zavedie priamo na stránku s osobnými údajmi.<br />Ked je zapnutá volba \"Zobrazit podrobnosti\", sú v rámceku dve ikonky.<br /><br />* IKONA VÝVODU<br />Ked je zapnutá volba \"Zobrazit podrobnosti\", vidíte vovnútri rámceka ikonku vývodu. V závislosti na nastavení stránok musíte prejst cez ikonu myšou, alebo na nu kliknút.<br />Takže, ked na nu kliknete, alebo cez nu prejdete myšou, objaví sa vám malé podmenu.<br />Položka \"Vývod\" a \"Rozrod\" sa podobajú položkám v hlavnom menu, ale rozdiel je v tom, že v tomto prípade bude východiskovou osobou schémy osoba, ktorej meno je v danom rámceku.<br />Dalej vidíte \"Rodina s partnerom\". Vidíte meno partnera nasledované menami detí.<br />Na všetky mená sa dá kliknút.<br /><br />* LUPA<br />Opät v závislosti na nastavení stránok musíte na ikonu bud kliknút, alebo cez nu prejst myšou.<br />Lupa zväcší rámcek s menom, takže sa zobrazia niektoré dalšie podrobnosti.<br />Uvidíte viacej údajov a udalostí. Na mená môžete kliknút.<br /><br />* ŠÍPKY<br />Nalavo alebo napravo od úplne krajných rámcekov môžete vidiet šípky.<br />Kliknutím na jednu zo šípok posuniete schému v danom smere.<br /><br />Dalšia nápoveda je k dispozícii po kliknutí na <b>?</b> za rámcekmi alebo odkazmi na stránke.";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["show_full_help"]			= "~SKRYTIE ALEBO ZOBRAZENIE PODROBNOSTÍ~<br /><br />Touto volbou môžete podrobnosti v políckach osôb bud zobrazit alebo skryt.<br /> Ak necháte podrobnosti skryt, budete môct na obrazovke zobrazit väctšiu schému (rodokmen).<br /><br />Ak zvolíte skryt podrobnosti, môžete si zobrazit skryté informácie použitím lupy, ak je v normálnom režime (pohlade) zapnutá.<br />To záleží na tom, ako administrátor nakonfiguroval tento program.<br />Ak musíte pre zväcšenie rámceku na lupu kliknút, potom doplnujúce informácie získate tiež kliknutím na rámcek s menom.<br />Ak pre priblíženie stací nájst na ikonku lupy, potom to bude fungovat úplne rovnako, ak postavíte kurzor na \"jednoduchý\" rámcek.";
$pgv_lang["talloffset_help"]			= "~FORMÁT ZOBRAZENIA~<br /><br />Týmto nastavením urcujete formát zobrazenia.<br /> Zmena tohoto nastavenia sa môže hodit, ak chcete tlacit alebo ak máte iný typ obrazovky. Ak zvolíte možnost \"na výšku\", rodokmen bude užší, takže 4-generacná schéma v režime \"na výšku\" by sa mala vojst na jednu stranu. Volba \"na šírku\" zapríciní zobrazenie širšej schémy, ktorá by sa mala vojst na jednu stránku na šírku.";
$pgv_lang["rootid_help"]			= "~NOVÁ VÝCHODISKOVÁ OSOBA~<br /><br />Ak chcete zobrazit rodokmen s inou východiskovou osobou, potom do tohoto polícka môžete napísat ID tejto osoby.<br /> Ak nepoznáte jej ID, použijte odkaz <b>>Nájst ID<</b>.<br /><br /><b>CÍSLO ID</b><br />Císlo ID je jednoznacný identifikátor. Bolo vygenerované programom, v ktorom bol vytvorený tento súbor GEDCOM.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~POCET GENERÁCIÍ~<br /><br />Tu môžete nastavit pocet generácií, ktorý sa má zobrazit v rodokmeni na jednej stránke.<br />Volba císla záleží na velkosti vašej obrazovky a potom, ci si nechávate zobrazovat podrobnosti alebo nie.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~VSTUPNÁ STRÁNKA~<br /><br />Na tejto stránke sa môžete prihlásit do systému, požiadat o nové heslo alebo nový uživatelský úcet.";
$pgv_lang["username_help"]			= "~UŽIVATELSKÉ MENO~<br /><br />Do tohoto polícka napíšte svoje uživatelské meno.<br />Rozlišujú sa velké a malé písmená!";
$pgv_lang["password_help"]			= "~HESLO~<br /><br />Do tohoto polícka napíšte svoje heslo.<br />Rozlišujú sa velké a malé písmená!";
$pgv_lang["login_buttons_help"]			= "~VSTUPNÉ TLACÍTKA~<br /><br />Tu vidíte dve tlacítka, pomocou ktorých sa môžete prihlásit do systému.<br />Zvolte možnost podla toho, ako chcete po prihlásení dalej pokracovat.<br /><br />* Tlacítko <b> #pgv_lang[login]# </b><br />Ak kliknete na toto tlacítko, budete po prihlásení presmerovaný na stránku, z ktorej ste sem prišli.<br />Takže, ked kliknete na \" #pgv_lang[login]# \" a budete práve na stránke s rozrodom, budete po prihlásení presmerovaný zpät na rozrod.<br /><br />* Tlacítko <b> #pgv_lang[mygedview]# </b><br />Ak máte práva administrátora, môžete kliknút na toto tlacítko a dostanete sa na hlavnú stránku administrácie.";
$pgv_lang["login_buttons_aut_help"]		= "~AUTORIZACNÝ REŽIM~<br /><br />VSTUPNÉ TLACÍTKA <br /><br />Tu vidíte dve tlacítka pre prihlásenie do systému.<br />Na výbere tlacítka záleží, ako budete pokracovat.<br /><br />* Tlacítko <b> #pgv_lang[login]# </b><br />Ak kliknete na toto tlacítko, dostanete sa do systému, a to priamo na svoju osobnú stránku, kde si môžete zmenit nastavenie, pridat alebo upravit oblúbené, posielat a cítat správy a tak dalej.<br /><br />* Tlacítko <b> #pgv_lang[mygedview]# </b><br />Ked kliknete na toto lavé tlacítko, dostanete sa do systému, a to priamo na svoju osobnú stránku, kde si môžete upravit svoje nastavenie, pridat alebo upravit oblúbené, posielat a cítat správy a tak dalej.<br /><br />* Tlacítko <b> #pgv_lang[admin]# </b><br />Ak máte práva administrátora, môžete kliknút na toto tlacítko, dostanete sa priamo na hlavnú stránku administrácie.";
$pgv_lang["new_password_help"]			= "~ŽIADOST O NOVÉ HESLO~<br /><br />Ak ste zabudli svoje heslo, môžete kliknút na tento odkaz pre zažiadanie o nové heslo.<br />Budete presmerovaný na \"Stránku s žiadostou o zaslanie hesla\".";
$pgv_lang["new_user_help"]			= "~ŽIADOST O NOVÝ UŽIVATELSKÝ ÚCET~<br /><br />Ak ste len návštevníkom týchto stránok a radi by ste tu mali úcet, kliknite na tento odkaz.<br />Budete presmerovaný na \"Stránku registrácie\".";
$pgv_lang["mygedview_login_help"]		= "Aby ste mali prístup ku vstupnej bráne MyGedView, musíte byt registrovaným uživatelom tohoto systému.<br /><br />Pomocou vstupnej brány MyGedView môžete vytvárat záložky u svojich oblúbených osôb, viest uživatelský denník, spravovat správy, mat prehlad o iných prihlásených uživateloch a lepšie poznávat PhpGedView.<br /><br />Pre prihlásenie do MyGedView zadajte do polícok svoje uživatelské meno a heslo.";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />Do tohoto pola zadajte svoje meno.<br /><br />Potrebujeme vaše meno a priezvisko pre stanovenie ci pre vás môžeme vytvorit úcet na tejto stránke a aké budú vaše oprávnenia. Tieto mená budú zobrazované ostatným prihláseným clenom rodiny a uživatelom.";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />Do tohoto pola vložte svoje priezvisko.<br /><br />Potrebujeme vaše meno a priezvisko pre stanovenie ci pre vás môžeme vytvorit úcet na tejto stránke a aké budú vaše oprávnenia. Tieto mená budú zobrazované ostatným prihláseným clenom rodiny a uživatelom.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~STRÁNKA S ROZRODOM~<br /><br />Táto stránka zobrazí potomkov osoby.<br />Východiskovú osobu tejto schémy si môžete zvolit priamo na tejto stránke, alebo sem môžete byt presmerovaný z inej stránky kliknutím na odkaz \"Rozrod\".<br />Ak sa chcete posunút v schéme nahoru, kliknite na hornú šípku. Ak budete chciet vidiet rozrod inej osoby, kliknite na ikonu schémy v rámceku požadovanej osoby.";
$pgv_lang["desc_rootid_help"]			= "~NOVÁ OSOBA~<br /><br />Ak chcete zobrazit rozrod inej osoby, potom do tohoto polícka môžete zadat ID tejto osoby.<br /> Ak nepoznáte jej ID, použijte odkaz Nájst ID.";
$pgv_lang["desc_generations_help"]		= "~POCET GENERÁCIÍ~<br /><br />Tu môžete nastavit pocet generácií k zobrazeniu na jednej stránke.<br />Co je najlepšie? To záleží na velkosti vašej obrazovky a potom, ci máte zapnuté zobrazovanie podrobností alebo nie.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~STRÁNKA S CASOVOU OSOU~<br /><br />Na tejto stránke si môžete nechat zobrazit jednu, dve ci viacej osôb na casovej ose.<br />Týmto spôsobom si môžete napríklad znázornit stav dvoch ci viacerých osôb v urcitý okamžik.<br /><br />Ak kliknete na odkaz Casová osa na inej stránke, uvidíte jednu osobu na casovej ose už hned po nacítaní stránky.<br />Ak ste klikli na položku z menu v záhlaví, potom musíte napísat do rámceka \"ID\" osoby, s ktorou chcete zacat.";
$pgv_lang["add_person_help"]			= "~PRIDANIE OSOBY NA CASOVÚ OSU~<br /><br />Na casovej ose môžete mat viacej osôb.<br />Do tohoto polícka vložte ID osoby.<br />Ak nepoznáte ID tejto osoby, môžete kliknút na odkaz \"Nájst ID\" za rámcekom.";
$pgv_lang["remove_person_help"]			= "~ODSTRÁNENIE OSOBY Z OSY~<br /><br />Kliknite na tento odkaz, ak chcete odstránit osobu z casovej osy.";
$pgv_lang["show_age_marker_help"]		= "~ZOBRAZENIE VEKU~<br /><br />Ak zaškrtnete toto polícko, uvidíte ukazatel veku, ktorý môžete posúvat po ose.<br />Tento ukazatel veku je dobrý nástroj ku zisteniu veku danej osoby v danom case.<br />Ukazatel veku môžete zapnút alebo vypnút pre ktorúkolvek osobu na ose.";
$pgv_lang["timeline_control_help"] = "~LIFESPAN CONTROLS~<br/><br/>~SPEED~<br/>Click the drop down menu to change the speed at which the timeline scrolls.<br/><br/>~Begin Year~<br/>Enter the starting year of the range.<br/><br/>~End Year~<br/>Enter the ending year of the range.<br/><br/>~Search~<br/>Click the Search button to begin searching for events that occurred within the range identified by the Begin Year and End Year fields.<br/><br/>|";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~STRÁNKA ZO SCHÉMOU VZTAHU~<br /><br />Na tejto stránke si môžete znázornit príbuzenský vztah medzi dvoma osobami.<br />Neznamená to, že by tieto osoby museli byt priamo pokrvne príbuzné.<br />Nájdený bude akýkolvek vztah.";
$pgv_lang["relationship_id_help"]		= "~ID císla 1. a 2. osoby~<br /><br />Ak ste sa sem dostali cez odkaz z inej stránky (napríklad: kliknutím na odkaz \"Vztah ku mne\"), potom tu uvidíte príbuzenský vztah medzi sebou a touto osobou.<br />Inak musíte zadat ID tých dvoch osôb, ktorých vzájomný príbuzenský vztah chcete zobrazit.<br />Ak tieto ID nepoznáte, môžete kliknút na odkaz \"Nájst ID\".";
$pgv_lang["next_path_help"]			= "~DALŠIE VZTAHY~<br /><br />Na toto tlacítko môžete kliknút pre nájdenie dalšieho vztahu medzi týmito dvoma osobami, ak taký existuje.<br />Predchádzajúci nájdený vztah si môžete opätovne zobrazit kliknutím na odkaz s císlom vztahu.";
$pgv_lang["follow_spouse_help"]			= "~KONTROLA PRÍBUZENSTVA SNATKOM – ZAŠKRTÁVACIE POLÍCKO~<br /><br />Ak je toto polícko <b>ne</b>zaškrtnuté, budú sa hladat iba pokrvné príbuzenské vztahy.<br>Ak je zaškrtnuté, budú sa hladat i príbuznosti snatkom. Ak necháte polícko zaškrtnuté, máte väcšiu pravdepodobnost, že nájdete viacej vztahov.";
$pgv_lang["line_up_generations_help"]		= "~VYROVNAT PODLA GENERACNEJ ÚROVNE - ZAŠKRTÁVACIE POLÍCKO~<br /><br />Ak je toto polícko zaškrtnuté, schéma sa vytlací tak, že potomkovia postavený na rovnakej generacnej úrovni, budú na stránke vodorovne zarovnaný. Ak nie je polícko zaškrtnuté, každá generácia sa zobrazí na stránke smerom dolu bez ohladu na to, ci je vo vztahu rodicov alebo detí.";
$pgv_lang["oldest_top_help"]          		= "~ZOBRAZIT NAJSTARŠÍCH HORE - ZAŠKRTÁVACIE POLÍCKO~<br /><br />Ak je toto polícko zaškrtnuté, budú sa schémy tlacit s najstaršími osobami hore.<br />A nie je zaškrtnuté, objavia sa hore najmladší ludia.<br /><br />Poznámka: Táto volba funguje iba, ak je zaškrtnuté <i>#pgv_lang[line_up_generations]#</i>.";
$pgv_lang["help_ancestry.php"]			= "~Stránka #pgv_lang[ancestry_chart]#~<br /><br />Prehlad predkov je velmi podobný na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale obsahuje viacej informácií a alternuje <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> zobrazenie.<br /><br />Každý predok je zobrazený s jedinecným císlom, vypocítaným na základe <i>Sosa-Stradonitzovho</i> systému :<br /> - párne císla pre mužov (dieta*2)<br /> - nepárne císla pre ženy (manžel+1) s výnimkou <b>1</b><br /><br />Príklad:<br /><ul>Východisková osoba je <b>1</b>, bez ohladu na pohlavie<br /><b>1</b> jej otec je <b>2</b> (<b>1</b> * 2), jej matka je <b>3</b> (<b>2</b> + 1).<br /><b>2</b> jej otec je <b>4</b> (<b>2</b> * 2), jej matka je <b>5</b> (<b>4</b> + 1).<br /><b>3</b> jej otec je <b>6</b> (<b>3</b> * 2), jej matka je <b>7</b> (<b>6</b> + 1).<br /><b>7</b> jej otec je <b>14</b> (<b>7</b> * 2), jej matka je <b>15</b> (<b>14</b> +1).<br />atd.</ul>";
$pgv_lang["box_width_help"]			= "~Šírka rámceka pre #pgv_lang[ancestry_chart]#~</b><br /><br />Tu môžete nastavit šírku rámceka od 50% do 300%.<br />Normálna hodnota je 100% : každé polícko je široké asi 270 pixelov.";
$pgv_lang["chart_style_help"]			= "~Štýl #pgv_lang[ancestry_chart]#~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Zvislý strom s rolovatelnými rodinami.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Na jednej stránke je zobrazená jedna rodina - rodicia, prarodicia a všetky zaznamenané deti.<br />Dá sa jednoducho vytlacit a vy ho môžete dat svojim príbuzným.</dd></dl>";
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]# page~<br /><br />Vejárová schéma je velmi podobná na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale s dôrazom na grafickú podobu.<br /><br />Východisková osoba je zobrazená v strede, jej rodicia na prvej kružnici, prarodicia na druhej atd...<br /><br />Ak je známy rok narodenia, snatku a úmrtia, potom je zobrazený pod menom.<br /><br />Ak kliknete na meno v schéme, získate nový obraz, na ktorom bude zvolené meno v strede schémy. Pri východiskovej osobe je šípka zo skrytým menu, z ktorého budete môct vybrat ako novú východiskovú osobu niektoré z detí alebo súrodencov východiskovej osoby, co môžete urobit tiež pomocou <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]			= "~Šírka #pgv_lang[fan_chart]#~</b><br /><br />Tu môžete nastavit šírku vejárovej schémy od 50% do 300%.<br />Normálna hodnota je 100% : výsledný obrázok má na šírku asi 640 pixelov.";
$pgv_lang["fan_style_help"]			= "~Štýl - #pgv_lang[fan_chart]#~<br /><br /><dl><dt>1/2</dt><dd>Oblúkový (180°) vejár</dd><dt>3/4</dt><dd>Troj-štvrtocný (270°) vejár alebo 'Anjelské krídlo'</dd><dt>4/4</dt><dd>Úplný (360°) vejár</dd></dl>";
//-- show_full is used from pedigree

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~STRÁNKA SO ZOZNAMOM OSOB~<br /><br />Na tejto stránke si môžete nechat zobrazit zoznam osôb.<br /><br />Mená budú zobrazené v abecednom poradí, priezvisko na prvom mieste.<br />Výstup zoznamu mien závisí na:<br /><b>1.</b> písmene, na ktoré ste klikli v abecednom indexe.<br /><b>2.</b> na tom, ci ste klikli na \"Preskocit\" alebo \"Zobrazit\" zoznam priezvísk.<br /><br />Ak k tomu potrebujete dalšiu nápovedu, kliknite prosím na <b>?</b> za položkami.";
$pgv_lang["alpha_help"]				= "~ABECEDNÝ INDEX~<br /><br />Po kliknutí na znak v abecednom indexe sa vám zobrazí zoznam mien zacínajúcich na písmeno, na ktoré ste klikli.<br />Na konci indexu môže byt <b>#pgv_lang[NN]#</b>. Táto volba je zobrazená v prípade, že v GEDCOMe sú ludia, u ktorých nebolo zadané priezvisko alebo nezacína na žiadne písmeno abecedy aktuálneho jazyka.<br />Rovnako tak neznámu osobu.<br /><br /><b>Pozor</b><br />Ak je priezvisko osoby v GEDCOM zázname zadané napríklad takto: Nn, NN, Neznámy(a), alebo dokonca N.N., potom sa meno tejto osoby po kliknutí na <b>N.N.</b> <b>ne</b>zobrazí. Tieto osoby nájdete pod \"<b>N</b>\" alebo \"<b>U</b>\" (pre príklad v tomto riadku).<br />Je tomu tak preto, že program kontroluje iba, ci je v GEDCOM zázname zapísané priezvisko.<br /><br />Na konci abecedného indexu vidíte \"<b>VŠETKY</b>\". Ak kliknete na tento odkaz, zobrazí sa vám zoznam všetkých priezvísk v GEDCOMe.<br /><br /><b>Chýbajú niektoré znaky?</b><br />Môže sa stat, že niektoré znaky budú v indexe \"chýbat\".<br />V skutocnosti však nechýbajú. Znamená to proste, že priezviská zacínajúce týmto znakom sa v zozname nevyskytujú.";
$pgv_lang["name_list_help"]			= "~ZOZNAM MIEN~<br /><br />Toto polícko zobrazí bud zoznam priezvisk alebo zoznam celých mien.<br />V oboch prípadoch budú všetky priezviská zacínat znakom, na ktorý ste klikli v abecednom indexe. Ak však nekliknete na \"VŠETKY\"<br /><br />Ci uvidíte zoznam priezvísk, alebo celých mien záleží na stave odkazu pod tabulkou.";
$pgv_lang["skip_sublist_help"]			= "~PRESKOCENIE ZOZNAMU PRIEZVÍSK~<br /><br />Štandardné nastavenie je také, že po kliknutí na písmeno dostanete najskôr zoznam priezvísk.<br />Ak  kliknete na tento odkaz, preskocíte zoznam priezvísk a uvidíte hned zoznam celých mien.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~STRÁNKA SO ZOZNAMOM RODÍN~<br /><br />Na tejto stránke si môžete zobrazit zoznam rodín.<br /><br />Mená budú zobrazené v abecednom poradí, priezviská na prvom mieste.<br />Podoba zobrazeného zoznamu závisí na:<br /><b>1.</b> písmene, na ktoré ste klikli v abecednom indexe.<br /><b>2.</b> na tom, ci ste klikli na \"Preskocit\" alebo \"Zobrazit\" zoznam priezvísk.<br /><br />Môžete hladat ako mužské, tak ženské priezviská. Oboje sú zahrnuté v zoznamu.<br /><br />Ak potrebujete k tomu dalšiu nápovedu, kliknite prosím na ? za položkami.";
$pgv_lang["help_family.php"]			= "~STRÁNKA S PODROBNOSTAMI O RODINE~<br /><br />Táto stránka vám ukáže prehlad o rodine, ktorú ste si vybrali na predchádzajúcej strane.<br />Odhora dolu uvidíte rámceky s týmito menami:<br />Manžel a jeho rodicia.<br />Manželka a jej rodicia<br />a deti.<br /><br />Vzhlad a obsah rámcekov je rovnaký ako na stránke s vývodom a rozrodom.<br />Napravo od rámcekov s manami rodicov uvidíte šípku (ak sú v súbore další predkovia). Kliknutím na šípku sa posuniete o jednu generáciu na novú stránku, kde sú rodicia zobrazený ako manželia.<br />Po pravej strane <i>v</i> rámceku si môžete všimnút lupy, vdaka ktorej môžete získat dalšie informácie o danom jednotlivcovi. Kliknutie na meno vás presmeruje na stránku s osobnými údajmi o tomto clovekovi.<br />Na pravej strane nájdete ešte malé menu, ktoré vás odkáže na stránky s dalšími informáciami alebo schémami.<br /><br />V Rodinných informáciach sú zobrazené všetky známe údaje a informácie o tejto rodine ako snatok, multimediálne súbory a poznámky. Kliknutie na miesto vás presmeruje na zoznam miest, kde uvidíte zoznam všetkých jednotlivcov a rodín, ktoré sú s týmto miestom spojené. Ak kliknete na dátum, dostanete sa do kalendára, kde si budete môct prezriet všetky udalosti, ktoré sa vo vašej histórii stali tohoto dna v tomto mesiaci. Kliknút môžete tiež na multimediálne objekty; tým sa otvorí nové okno, v ktorom si budete môct objekt prezriet. Ak kliknete na odkaz na pramen, zobrazí sa na stránke informácia o tomto prameni.<br /><br />Pod rámcekmi s manami detí nájdete odkaz \"Pridat dieta k tejto rodine\".<br />Vedla rámcekov s menami detí uvidíte odkaz \"Informácie o rodine\".<br />Ak máte príslušné oprávnenia, môžete tu upravovat, mazat a pridávat dátumy a údaje.<br /><br />Na pravej strane obrazovky môžete vidiet, ak je zapnuté administrátorom, tieto ikony a odkazy:<br /><b>Zobrazit priamo záznam GEDCOMu</b>, ktorý zobrazí informácie v GEDCOM formáte.br /><b>Pridat do Schránky výstrižkov</b>, ktorý vám umožní uložit si zvolené informácie do schránky. Odtialto si ich potom môžete stiahnut a naimportovat do svojho genealogického programu.<br /><b>Zobrazit pár na casovej ose</b>, ktorý vás presmeruje na stránku s casovou osou, na ktorej zobrazí všetky údaje o rodine.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~PRIDANIE DIETATA DO RODINY~<br /><br />Kliknutím na tento odkaz môžete pridat k tejto rodine dieta.<br />Pridanie dietata je jednoduché: Proste len kliknite na odkaz, vyplnte polícka v pop-up okne a je to.";
$pgv_lang["show_fam_gedcom_help"]		= "~ZOBRAZIT ZÁZNAM GEDCOMu~<br /><br />Po kliknutí na tento odkaz sa informácie o rodine (tak, ako je uložená v GEDCOMe) zobrazí v pop-up okne.";
$pgv_lang["add_fam_clip_help"]			= "~PRIDAT RODINU DO SCHRÁNKY VÝSTRIŽKOV~<br /><br />Ak kliknete na tento odkaz, budete môct pridat informácie o tejto rodine (tak, ako je uložená v GEDCOMe) do svojej Schránky výstrižkov. Na dalšej stránke si budete moct vybrat, ktoré údaje konkrétne si budete želat pridat: len týchto rodicov, alebo tiež ich rodicov, alebo tiež ich rodicov alebo tiež ich deti alebo všetkých potomkov.";
$pgv_lang["show_fam_timeline_help"]		= "~ZOBRAZIT PÁR NA CASOVEJ OSE~<br /><br />Po kliknutí na tento odkaz sa dostanete na stránku s casovou osou, kde budú údaje o tejto rodine zobrazené v casovom merítku.";
$pgv_lang["help_sourcelist.php"]		= "~STRÁNKA SO ZOZNAMOM PRAMENOV~<br /><br />Na tejto stránke je zobrazený zoznam pramenov.<br />Narozdiel od stránky s osobami a stránky s rodinami, tu chýba abecedný index. Je to z toho dôvodu, že pramen môže byt osoba, ktorá má samozrejme krstné meno a priezvisko, alebo to môže byt verejná databáza alebo inštitúcia atd. <br />To znamená, že je obtiažne vymysliet spôsob radenia. Názvy pramenov sú zoradené v abecednom poradí tak, ako sú uložené v súbore GEDCOM.<br /><br /><b>PRAMENE</b><br />Bez pramenov by sme nemohli vybudovat svoju rodopisnú databázu. Každá informácia uložená v databázi pochádza z nejakého zdroja. Môže jím byt príbuzný danej osoby, inštitúcia, verejná databáza apod.<br />Jeden pramen môže byt spojený s viacerými osobami. Na druhú stranu, jedna osoba môže byt zase spojená s viacerými pramenami. Pre každú udalost môžete mat iný pramen, nech už je to dátum narodenia, profesia, snatok, deti atd. atd.";

//-- same variable as individuals page

//-- Sourcelist-page
$pgv_lang["sourcelist_listbox_help"]		= "~ZOZNAM PRAMENOV~<br /><br />V tejto tabulke môžete vidiet zoznam pramenov, tak ako sú uložené v GEDCOMe.<br />Názvy sú zobrazené v abecednom poradí.<br /><br />Ked kliknete na názov v zozname, dostanete sa na stránku tohoto pramena, kde bude zobrazený zoznam osôb, ktoré sú pripojené k tomuto pramenu.";
$pgv_lang["help_source.php"]			= "~STRÁNKA S PODROBNOSTAMI O PRAMENI~<br /><br />Na tejto stránke sú zobrazené podrobnosti o tomto prameni.<br />Môžete tu nájst informácie o názve, autorovi, vydanie pramena a mieste, kde bol vyhladaný. Pretože existuje mnoho typov pramenov, u niektorých z nich môže byt k dispozícii viacej, u iných menej údajov.<br /><br />Ak je k pramenu pripojený multimediálny objekt (ako naskenovaný dokument), môžete si tento objekt prezriet vo velkom okne kliknutím bud na objekt alebo na názov súboru uvedený vedla neho.<br /><br />Po podrobnostiach o tomto prameni nasleduje zoznam všetkých jednotlivcov a rodín, ktorý sú k tomuto pramenu napojený. Tak máte možnost získat všetky informácie, ktoré boli z daného pramena získané.<br /><br />Ak je to povolené adminom, budete mat na stránke menu s jednou alebo dvoma ikonami:<br /><b>Zobrazit priamo záznam GEDCOMu</b> ukáže údaj v GEDCOM formáte.<br /><b>Pridat do Schránky výstrižkov</b>, ktorá umožnuje ukladat vybrané informácie do schránky. Odtialto ich môžete stiahnút a naimportovat do svojho genealogického programu.<br /><br />Dalšia nápoveda je k dispozícii po kliknutí na <b>?</b>";

//-- Sources-page
$pgv_lang["sources_listbox_help"]		= "~ZÁZNAMY PRIPOJENÉ K TOMUTO PRAMENU~<br /><br />V tejto tabulke si môžete prezriet zoznam mien osôb ci rodín pripojených k tomuto pramenu.<br />Mená sú zobrazené v abecednom poradí.<br /><br />Ked kliknete na meno v zozname, dostanete sa na stránku s podrobnými informáciami o osobe ci rodine.";
$pgv_lang["show_source_gedcom_help"]		= "~ZOBRAZENIE GEDCOM ZÁZNAMOV~<br /><br />Kliknutím na tento odkaz vyvoláte pop-up okno, v ktorom sa vám zobrazí podrobnosti o prameni tak, ako sú uložené v GEDCOM súbore.";
$pgv_lang["add_source_clip_help"]		= "~PRIDANIE PRAMENA DO SCHRÁNKY VÝSTRIŽKOV~<br /><br />Kliknutím na tento odkaz môžete pridat pramen, tak ako je uložený v GEDCOM súbore, do schránky výstrižkov.";
$pgv_lang["delete_source_help"]			= "~VYMAZANIE PRAMENA Z GEDCOMu~<br /><br />Kliknutím na túto volbu, oznacíte pramen, ktorý sa má z GEDCOMu vymazat.<br />Co to znamená?<br />Predpokladajme, že máte dobrý dôvod odstránit tento pramen zo svojho GEDCOMu. Môžete kliknút na odkaz a vyskocí vám pop-up okno s otázkou, ci chcete pramen skutocne vymazat alebo ci chcete príkaz zrušit.<br /><br />Ak budete pokracovat v odstranovaniu pramena, za nejakú chvílu vám vyskocí pop-up okno so správou, že pramen bol vymazaný.<br /><br />Ak budete pokracovat v prezeraní, všimnite si, že pramen je ešte stále v databáze, rovnako ako pred vymazaním.<br /><br />To <b>nie je</b> chyba.<br />Administrátor stránok dostane správu, že v GEDCOMe bola urobená zmena a že ste odstránili pramen.<br />Administrátor musí vašu zmenu prijat (alebo zamietnut). Nie je možné tento proces obrátit.<br />V prípade nejasností vás administrátor bude kontaktovat.";
$pgv_lang["help_placelist.php"]			= "~HIERARCHIE MIEST~<br /><br />(alebo tiež osoby v miestach)<br /><br />Tu sa môžete podívat, ktoré osoby alebo rodiny sú spojené s akým miestom.<br /><br />Ak je medzi osobou alebo rodinou a nejakou udalostou v urcitom mieste nejaké spojenie, program vám ho nájde.<br /><br />Výsledok je zobrazený v dvojstlpcovom zozname:<br />Jeden stlpec je pre osoby a druhý pre rodiny.<br /><br />#pgv_lang[more_help]#";

//-- Persons per Place-page
$pgv_lang["ppp_default_form_help"]		= "~PORADIE MIEST~<br /><br /><b>IMPLICITNÉ PORADIE</b><br />To znamená, že v tomto GEDCOM súbore nie je stanovené žiadne poradie.<br />V takom prípade je nastavené implicitné poradie podla predvolby na tejto stránke.<br /><br />Keby bolo v tomto GEDCOM súbore nájdené iné poradie, bolo by se ukázalo medzi (...) a koncom riadku.";
$pgv_lang["ppp_match_one_help"]			= "~PORADIE MIEST~<br /><br />PORADIE PODLA GEDCOMu<br />Miesta sú v poradí, ktoré bolo nájdené v súbore GEDCOM.<br />To má vyššiu prioritu než implicitné poradie, ktoré sa naopak použije v prípade, že v GEDCOMe žiadne poradie nie je nájdené";
$pgv_lang["ppp_numfound_help"]			= "~NÁJDENÉ VZTAHY K MIESTAM~<br /><br />Tu je zobrazený pocet nájdených odpovedí.<br />Ak ešte stále vidíte tabulku so zoznamom miest, znamená to, že ste doteraz nedosiahli najnižšiu úroven.<br />Môžete zvolit zobrazenie všetkých záznamov nájdených u tohoto miesta alebo zmenit kritéria vyhladávania kliknutím na iné miesto.";
$pgv_lang["ppp_levels_help"]			= "~HIERARCHIA MIEST~<br /><br />Tu sú zobrazené úrovne nájdené do tohoto okamžiku.<br />Tabulka ukazujúca zoznam miest je v skutocnosti podzoznamom úrovne úplne vlavo.<br /><br />PRÍKLAD:<br />(Implicitné) poradie je: #pgv_lang[default_form]#<br />Ak sme teraz na \"hornej úrovni\", potom sa v tabulke zobrazí všetky zeme z GEDCOMu.<br />Ak  stávajúca úroven ukazuje: \"U.S.A., Horná úroven\", potom budú v zozname zobrazené všetky štáty v U.S.A.<br />atd.<br /><br />Môžete kliknút na úroven, aby ste sa dostali spät o jeden ci viacej krokov.";
$pgv_lang["ppp_placelist_help"]			= "~ZOZNAM MIEST~<br /><br />V tomto zozname vidíte miesta nájdená pod zvoleným miestom. Ak ste doteraz nezvolili žiadne miesto, potom vidíte zoznam všetkých miest na najvyššej úrovni (napr. zemí alebo štátov).<br /><br />Názvy miest v zozname sú odkazy, na ktoré môžete kliknút.<br />Kliknutie na miesto funguje ako filter. Prenesie vás na nasledujúcu nižšiu úroven.";
$pgv_lang["ppp_placelist_help2"]		= "~ZOZNAM MIEST~<br /><br />V tomto zozname môžete vidiet miesta, ktoré boli doteraz nájdené.<br />Na názvy miest zo zoznamu môžete klikat.<br />Kliknutie na miesto funguje ako filter. Prenesie vás na nasledujúcu nižšiu úroven.<br />Zoznam mien sa nezobrazí jedine v prípade, že ste na najvyššej úrovni. Na každej inej úrovni dostanete zoznam osôb alebo rodín nájdených v danom mieste.";
$pgv_lang["ppp_view_records_help"]		= "~ZOBRAZIT VŠETKY ZÁZNAMY~<br /><br />Ak kliknete na tento odkaz, zobrazí sa vám zoznam všetkých osôb a rodín, ktoré sú spojené s týmto miestom. Ked sa dostanete na koniec hierarchie miest (napr. mesto), zobrazí sa automaticky zoznam mien.";
$pgv_lang["ppp_name_list_help"]			= "~ZOZNAM MIEN~<br /><br />Táto tabulka bude obsahovat zoznam celých mien osôb alebo rodín, ktoré majú nieco spolocné s týmto miestom.<br /><br />Na miesta v zozname môžete kliknút.<br />Ked na niektorý názov kliknete, dostanete sa na stránku s podrobnostami o tej osobe alebo rodine.<br /><br />Môžete si tiež vybrat zmenu svojho oznacenia – a to kliknutím na miesto hore na tomto zozname.";
$pgv_lang["help_medialist.php"]			= "~ZOZNAM MULTIMÉDIÍ~<br /><br />Zoznam multimediálnych súborov zahrnuje všetky multimediálne objekty (MMO), ktoré sa nachádzajú v tomto GEDCOMe.<br /><br />V políckach MMO nájdete jeho názov a meno osoby alebo rodiny, ku ktorej je tento objekt pripojený. Na oboje môžete kliknút.<br /><br />Ak kliknete na meno osoby alebo rodiny, dostanete sa na stránku s osobnými údajmi alebo stránku o rodine.<br /><br />Kliknutie na názov MMO má rovnaký efekt ako kliknutie na zmenšeninu (náhlad) MMO.<br />V závislosti na formáte MMO (*.gif, *.jpg) sa MMO otvorí v internom PhpGedView-prehliadaci alebo v prehliadaci, ktorý je pripojený k vášmu internetovému prehliadaci.<br /><br />Ak kliknete na odkaz \"Zobrazit\" vedla osôb alebo rodín, dostanete sa na stránku s údajmi o osobe alebo rodine.";
$pgv_lang["help_uploadmedia.php"]		= "~NAHRÁVANIE MEDIÁLNYCH SÚBOROV~<br /><br />Nahrávanie súborov je jednoduché, takže iba doplnujúce informácie.<br /><br /><b>Zmenšeniny</b><br />Zmenšeniny by mali mat velkost približne okolo 100px na šírku.<br />Názov súboru musí byt rovnaký ako u originálu (obr. v pôvodnej velkosti).<br /><br /><b>Nahrávanie</b><br />Originály obrázkov budú uložené automaticky do zložky ../media a zmenšeniny do ../media/thumbs/.<br /><br />#pgv_lang[readme_help]#";

//-- Mulitmedia-page
//-- I did not work multimedia yet, so at this moment I cannot ad something here ;-) (Jans)

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~KALENDÁR VÝROCÍ~<br /><br /><ul><li><a href=\"#calendar_general\">Základné informácie</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Udalost</a><li><a href=\"#calendar_button\">Výber režimu (tlacítka)</a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>Kalendár výrocí zobrazuje osoby a rodiny napojené k udalostiam z urcitého dna alebo mesiaca alebo urcitého casového úseku. Používá dômyselný filtrovací systém k tomu, aby vám ukázal správny dátum alebo období.<dl><dt><b>Zobrazit <a href=\"#calendar_day\">den</a></b></dt><dd>Táto volba ukazuje udalosti, ku ktorým došlo v urcitý den nezávisle na zvolenom roku. Výstupom bude bud jednoduchý zoznam mien osôb alebo rodín, alebo dvojstlpcový zoznam osôb na jednej a rodín na druhej strane.</dd><dt><b>Zobrazit <a href=\"#calendar_month\">mesiac</a></b></dt><dd>V <b>Kalendári</b> sú mená osôb i rodín zobrazená v políckach dní. Kalendár sa zobrazí tak, ako vyzeral v roku, ktorý ste zadali do polícka roku. Zobrazené sú všetky udalosti z minulosti až po zadaný rok.<br />V kombinácii s volbou \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" vám poskytne realistický pohlad na to, ako vyzeral kalendár vašich predkov.</dd><dt><b>Zobrazit <a href=\"#calendar_year\">rok</a></b></dt><dd>Táto volba zobrazí udalosti, ktoré sa stali v urcitom roku alebo v rozmedzí urcitých rokov. Výstupom bude bud jednoduchý zoznam mien osôb alebo rodín, alebo dvojstlpcový zoznam osôb na jednej a rodín na druhej strane.</dd></dl>Práve zobrazovaný den a mesiac sú v menu kalendára zvýraznené.<br /><br />Na mená a dátumy, ktoré sa objavia v zozname alebo v kalendári, môžete kliknút.<br />Kliknutím na meno sa prenesiete na stránku s údajmi o danej osobe ci rodine. Ak kliknete na dátum, dostanete sa do režimu \"Dnes\" (alebo Rok), a tak získate zobrazenie všetkých udalostí tohoto (zvoleného) dna a mesiaca.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~VÝBER DNA~<br /><br />Výber dátumu zahrnuje dve polícka (den a mesiac) a vstupné polícko, do ktorého vložíte požadovaný rok.<br /><br />Ked vstúpite na túto stránku, uvidíte dnešný dátum. Ked kliknete na tlacítko <b>Zobrazit den</b>, uvidíte všetky osoby spojené s nejakou udalostou, ktorá sa odohrala toho dna.<br />Ked kliknete na tlacítko <b>Zobrazit mesiac</b>, uvidíte všetky osoby spojené s nejakou udalostou, ktorá sa odohrala v danom mesiaci.<br />Ktoré osoby uvidíte, záleží na tom, ktorú položku ste zvolili vo výbere <b>Ukázat</b>.<br /><br /><b>TIP</b><br />Predpokladajme, že máme príbuzného narodeného 25. januára 1875.<br />Upravte výber dátumov podla tohoto dátumu.<br />Ked teraz kliknete na jedno z tlacítiek pre zobrazenie, uvidíte zoznam alebo kalendár pre tento den.<br />Všetky veky, výrocia apod. sú prepocítavané podla dátumu, ktorý ste nastavili.<br />Takže vlastne vidíte úplne rovnaký kalendár aký by mal pred sebou váš predok vo vzdialenej minulosti.";
$pgv_lang["annivers_month_select_help"]		= "~VÝBER MESIACA~<br /><br />Prostredný riadok \"Prepínacej tabulky\" je <b>Výber mesiaca</b>.<br />Význam tohoto prvku je rovnako ako u \"Výberu dna\" jasný: Vyberiete mesiac.<br /><br />A rovnako ako pri Výbere dna je rozdiel medzi kliknutím na mesiac v \"Režime den\" a v \"Režime mesiac\".<br /><br /><b>Režim den</b>:<br />V tomto režime, ked kliknete na mesiac, sa obrazovka znovu nacíta a zobrazí sa zoznam dní v danom mesiaci.<br />Všetky ostatné nastavenia ako den, rok a udalosti budú zachované.<br /><br /><b>Režim mesiac</b>:<br />Ak máte na obrazovke kalendár a kliknete na mesiac v riadku \"Mesiac\", zobrazí sa kalendár tohoto nového mesiaca.<br /><br />Na konci riadku Mesiac uvidíte <b>\"rýchly odkaz\"</b> na aktuálny mesiac.<br />Ak kliknete na tento \"rýchly odkaz\", zobrazí sa vám kalendár na tento mesiac bez ohladu na to, ci ste v režime Mesiac, alebo v režime Den.";
$pgv_lang["annivers_year_select_help"]		= "~POLÍCKO PRE ROK~<br /><br />Toto polícko slúži pre prepínanie roku v kalendári v \"režime mesiacov\" alebo v zozname v \"režime rokov\".<br />V \"režime den\" sa zmena roku nijak neprejaví, pretože sú zobrazené udalosti za celý rok.<dl><dt><b>Rozšírené možnosti</b> pre <b>#pgv_lang[viewyear]#:<br />Viacej rokov naraz</b></dt><dd>Môžete hladat viacej než jeden rok zapísaním do polícka roku::<br />- Pr. 1: <b>1992-5</b> pre všetky udalosti od 1992 do 1995.<br />- Pr. 2: <b>1972-89</b> pre všetky udalosti od 1972 do 1989.<br />- Pr. 3: <b>1610-759</b> pre všetky udalosti od 1610 do 1759.<br />- Pr. 4: <b>1880-1905</b> pre všetky udalosti od 1880 do 1905.<br />- Pr. 5: <b>880-1105</b> pre všetky udalosti od 880 do 1105.<br /><br />Tiež môžete vynechat poslednú císlicu roku pre zobrazenie všetkých udalostí za urcité desatrocie.<br />- Pr.: <b>197</b> pre všetky udalosti od 1970 do 1979.</dd><dt><br /><b>Skratky</b></dt><dd>Niekedy nie je úplne jasné, kedy presne sa daná udalost stala. V týchto prípadoch môžu byt k dátumu pridané slová ako \"po\", \"pred\" a \"okolo\". Dátumy sú v GEDCOMe uložené spolocne so skratkou daného termínu. V režime roku môžete zadávat i hladanie týchto termínov s, alebo bez, pridruženého dátumu. Tu je niekolko príkladov takých výberov:<br /><b>abt</b> 1800 (abt = about = OKOLO)<br /><b>bet</b> 1950-1959 (bet = between = MEDZI) zadajte: bet 1950 alebo iba: 1950-59<br /><b>bef</b> 1950 (bef = before = PRED)<br /><b>aft</b> 1900 (aft = after = PO)<br /><br /><b>Poznámka:</b> PhpGedView bude hladat výraz presne tak, ako ho zadáte. Ak hladáte \"abt 1850\", dátum z GEDCOMu ako napr. \"abt oct 1850\" <b>nebude</b> zahrnutý vo výsledoch vyhladávania. - Môžete zadat iba skratku bez roku a získate zoznam všetkých dátumov, ktoré túto skratku obsahujú.</dd></dl>Samotným napísaním roku nespustíte vyhladávanie.<br />Pretože toto polícko nie je odkazom, budete po zapísaní roku musiet kliknút na tlacítko <b>#pgv_lang[viewmonth]#</b> alebo tlacítko <b>#pgv_lang[viewyear]#</b>.";
$pgv_lang["annivers_show_help"]			= "~volba CO UKÁZAT~<br /><br />Ked nie ste prihlásený do systému, môžete si vybrat medzi dvomi možnostami:<br /><br /><b>1. Všetci ludia</b><br />S týmto nastavením budú zobrazené všetky osoby a rodiny.<br /><br /><b>2. Nedávne udalosti (<100 rokov)</b><br />S týmto nastavením uvidíte udalosti, ktoré sa stali v danom dni/mesiaci, však iba mladšie než 100 rokov.<br /><br />Existuje ešte tretia možnost. Aby ste si ju mohli vybrat, musíte byt bud prihlásený alebo musí admin nastavit systém tak, aby si žijúce osoby mohol zobrazit kdokolvek.<br /><br /><b>3. Žijúci ludia</b><br />S týmto nastavením budú zobrazené iba žijúce osoby.<br />Po zvolení jednej z možností sa stránka automaticky znovu nacíta (s novým nastavením).<br />Nastavenie dna, mesiaca, roku a režimu dna alebo mesiaca zostáva rovnaké.";
$pgv_lang["annivers_sex_help"]			= "~VÝBER POHLAVIA~<br /><br />Ak ste prihlásený (alebo ak admin vypol nastavenie utajenia), môžete si vyberat medzi tromi možnostami:<dl><dt><b>1. Všetky ikony</b></dt><dd>V tomto prípade (implicitne) sú zobrazené udalosti všetkých osôb a rodín.</dd><dt><b>2. Ikona - muži</b></dt><dd>Zobrazené sú iba udalosti u mužov. Mužský clenovia rodín budú zobrazený s rodinnými udalostami.</dd><dt><b>3. Ikona - ženy</b></dt><dd>Zobrazia sa iba udalosti ženských osôb. S rodinnými udalosťami sa zobrazia iba členky rodín..</dd></dl>Ak kliknete na niektorú z volieb, dôjde k novému nacítaniu stránky a zobrazí sa požadovaná forma.<br />Ostatné nastavenia dna, mesiaca, roku, udalostí a režimu zostávajú rovnaké.";
$pgv_lang["annivers_event_help"]		= "~VÝBER UDALOSTÍ~<br /><br />Tu si môžete vybrat, ci chcete u osôb a rodín zobrazit všetky udalosti alebo iba nejakú konkrétnu.<br /><br />Ked kliknete na niektorú z volieb, stránka sa nacíta znovu a zobrazí sa tak, ako ste požadovali.<br />Ostatné nastavenia dna, mesiaca, roku, pohlavia a režimu zostávajú rovnaké.";
$pgv_lang["annivers_tip_help"]			= "~TIP~<br /><br />Predpokladajme, že máte v databázi príbuzného, ktorý sa narodil 25. januára 1875.<br />Nastavte tento dátum.<br />Ked teraz kliknete na jedno z dvoch tlacítiek pre zobrazenie, uvidíte zoznam alebo kalendár pre tento dátum.<br />Všetky veky, výrocia, atd. sú prepocítané a pocítané spätne podla dátumu, ktoré ste nastavili.<br />Takže, v skutocnosti, vidíte rovnaký zoznam alebo kalendár ako váš príbuzný v minulosti.";
$pgv_lang["day_month_help"]			= "~TLACÍTKA ZOBRAZIT DEN / ZOBRAZIT MESIAC / ZOBRAZIT ROK~<br /><br />Tlacítko <b>Zobrazit den</b> zobrazí udalosti spojené s dátumom vybraným z kalendára. Prehladávajú sa všetky roky, takže stací zadat den a mesiac. Zmena roku sa nijako neprejaví.<br />Zoznam môžete obmedzit výberom možnosti \"Posledné roky\" alebo, ak je táto možnost k dispozícii, \"Žijúci ludia\".<br />Vek ludí zo zoznamu sa vypocíta k aktuálnemu roku.<br /><br />Tlacítko <b>Zobrazit mesiac</b> ukáže tabulku pre daný mesiac a rok. I tu môžete zoznam obmedzit dodatocným kliknutím na \"Žijúci ludia\" alebo \"Posledné roky\".<br />Výber nejakého roku z minulosti v kombinácii s volbou \"Posledné roky\" vám umožní získat realistický obraz toho, aký kalendár mali na stene vaši predkovia. Vek všetkých ludí v kalendári sa zobrazí vo vztahu k roku zadanému v príslušnom polícku.<br /><br />Tlacítko <b>Zobrazit rok</b> vám ukáže zoznam udalostí, ktoré sa stali v priebehu vybraného roku.<br />Opät môžete zoznam obmedzit dodatocným kliknutím na \"Žijúci ludia\", ak je táto možnost k dispozícii, alebo \"Posledné roky\".<br />Vítanou vlastnostou programu je, že môže zobrazit udalosti i za viacej rokov: Proste iba zapíšte poslednú císlicu koncového roku za pociatocný rok a pomlcku \"-\" (napr.: 1992-4 zaistí zobrazenie všetkých udalostí od roku 1992 do 1994, alebo 1976-1984 pre všetky udalosti medzi rokmi 1976 a 1984 vcetne).<br />- Tiež môžete napísat iba pociatocné císlice požadovaných rokov a zobrazia sa všetky udalosti, ktoré sa stali v rokoch zacínajúcich zadanými císlicami. (napr.: 197 pre všetky udalosti medzi rokmi 1970 a 1979 vcetne)<br /><br />Ked budete chciet <b>zmenit rok</b>, potom <b>musíte</b> stisknút jedno z týchto troch tlacítok.<br /><br />Všetko ostatné nastavenie ostáva rovnaké.";
$pgv_lang["help_clippings.php"]			= "~Schránka výstrižkov~<br /><br />Schránka výstrižkov vám umožnuje robit z tohoto rodokmena \"výstrižky\" a vložit ich do jednoduchého GEDCOM súboru ku stiahnutiu.<br /><br />* Ako urobit výstrižky?<br />To je velmi jednoduché. Kdekolvek uvidíte meno, na ktoré sa dá kliknút (osoba, rodina alebo pramen), môžete na toto meno kliknút a tak sa dostat na stránku s údajmi o tomto mene. Na tejto stránke uvidíte volu \"Pridat do schránky výstrižkov\".<br />Kliknutím na tento odkaz sa dostanete na stránku, kde  budete mat niekolko možností stiahnutia.<br /><br />* Ako súbor stiahnut?<br />Ked budete mat položky v schránke, môžete ich stiahnút jednoducho kliknutím na odkaz \"Stiahnút\".<br>Potom postupujte podla inštrukcií a odkazov.";

//-- Clipping Cart-page
$pgv_lang["clip_download_help"]			= "~STIAHNUTIE VÝSTRIŽKOV~<br /><br />Kliknutím na tento odkaz, budete presmerovaný na dalšiu stránku.<br />Ak bude viacej možností, co stiahnút, budú zobrazené na stránke.<br />Jednoducho postupujte podla pokynov.";
$pgv_lang["empty_cart_help"]			= "~VYPRÁZDNENIE SCHRÁNKY VÝSTRIŽKOV~<br /><br />Kliknutím na tento odkaz bude vaša schránka výstrižkov úplne vyprázdnená.<br /><br /> Ak nechcete odstránit všetky osoby, rodiny atd zo schránky výstrižkov, môžete odstranovat položku za položkou klikaním na odkaz \"Odstránit\" v rámcekoch s menami. ";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]			= "~ZOBRAZENIE ZMIEN V GEDCOME~<br /><br />To, že vidíte túto správu, znamená dve veci:<br /><br />1. Niekto urobil v GEDCOMe zmeny<br />Záznamy mohli byt pridané, zmazané alebo zmenené.<br /><br />2. Zmeny doteraz neboli potvrdené administrátorom.<br />Ked budú tieto zmeny prijaté (alebo zamietnuté), táto správa zmizne.<br /><br /><br />Kliknutím na odkaz sa môžete podívat na zmeny, ktoré boli urobené.<br />Ak zistíte, že zmena nie je správna, oznámte to správcovi.";
$pgv_lang["help_search.php"]			= "~Stránka VYHLADÁVANIE~<br /><br />I ked táto stránka vypadá velmi jednoducho, tie dva formuláre na nej obsluhuje výkonný vyhladávací nástroj.<br /><br />Väcšina genealogických webov vám umožní hladat priezviská (niekedy i mená).<br />Na tejto stránke môžete hladat prakticky cokolvek.<br /><br />Vyhladávacie polícko na lavej strane obrazovky je úplne to isté ako v záhlaví stránky.<br /><br />Ak hladáte ludí spojených s urcitým rokom, napíšte proste rok. Program vám nájde všetky spojenia.<br /><br />Hladáte azda meno alebo miesto?<br />Tak ho zadajte, bud celé alebo iba cast, a program urobí zbytok za vás.<br /><br />Vyhladávacia metóda SOUNDEX.<br />Cez vyhladávacie polícko na pravej strane môžete vyhladávat mená osôb a miest, dokonca i tedy, ked neviete, ako sa píše.<br /><br />Dalšiu nápovedu k týmto dvom políckam nájdete, ak kliknete na <b>?</b> nad políckami.";

//-- Search-page
$pgv_lang["search_enter_terms_help"]		= "~VKLADANIE VÝRAZOV PRE VYHLADÁVANIE~<br /><br />Do tohoto vyhladávacieho polícka môžete zadávat kritéria ako dátumy, krstné mená, priezviská, miesta, multimédia atd.<br /><br /><b>Masky</b><br />Masky, tak ako ich asi poznáte (ako * alebo ?), nie sú povolené, ale program sám vyhladáva pomocou masiek.<br />Co to znamená?<br />Predpokladajme, že ste do polícka zadali nasledujúci retazec: \"<b>Pete</b>\"<br />Výsledok bude (zase predpokladajme, že tieto mená sú v databáze):<br /><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />niekto --narodený 1. januára 1901 <b>Pete</b>rsburg<br />atd., atd.<br /><br /><b>Dátumy</b><br />Napísaním roku do vyhladávacieho polícka dostanete mená všetkých osôb, ktoré sú nejako spojené s týmto rokom.<br />Ak napíšete 1950, potom výsledkom budú ludia, ktorý sa roku 1950 narodili, oženili/vydali, zomreli alebo.... sú akoukolvek inou udalostou s týmto rokom spojený.<br /><br />Ak napíšete \"4 Dec\", potom získate zoznam všetkých ludí spojených z nejakou udalostou z dna 4. decembra ktoréhokolvek roku.<br />Ale tiež osoby, ktorých sa týkajú udalosti z dní 14. ci 24. decembra.<br />Ako vidíte, tiež tu sa uplatnujú masky, takže ich nemusíte písat.<br /><br /><b>Správne dátumy</b><br />Program hladá dátumy tak, ako sú uložené v GEDCOM súbore .<br />Takže, ak chcete hladat nejakú udalost 14. decembra, mali by ste napísat:<br /><b>14 dec</b><br />, pretože toto je formát, v akom sú dátumy ukladané do GEDCOM súboru.<br />Ale ak napíšete \"<b>dec 14</b>\", potom výsledkom bude zoznam ludí spojených s nejakou udalostou - napr. 08 <b>dec</b>ember 18<b>14</b>. Ak chcete a poznáte ich, môžete používat tiež regulárne výrazy. Napríklad, ked budete chciet nájst všetky osoby, ktoré sa narodili v 20. storocí, mohli by ste zadat do vyhladávania 19[0-9][0-9] a dostali by ste všetky osoby s dátumami od 1900 do 1999.<br /><br />Keby ste potrebovali dalšiu nápovedu k tomuto vyhladávaciemu systému, prosím dajte nám vediet, aby sme ju mohli rozšírit.";
$pgv_lang["soundex_search_help"]		= "~HLADANIE MENA PODLA TOHO AKO (SI MYSLÍTE, ŽE) SA PÍŠE (METÓDA SOUNDEX)~<br /><br />Metóda SOUNDEX je velmi užitocná.<br />Najskôr krátke objasnenie pojmu Soundex:<br /><br />Soundex vyhladá priezviská, ktoré znejú podobne, ale píšu sa inak. Soundexový kód zacína prvým písmenom priezviska a po nom nasleduje trojciferný kód predstavujúci prvé tri zo zostávajúcich súhlások. U mien, ktoré nemajú dost znakov, sa do kódu pridajú nuly.<br /><br />V anglictine to znamená:<br />Ak hladáte meno \"Smith\", môžete ako výsledok získat tiež:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote atd.<br /><br />Soundexový kód vás nemusí vôbec zaujímat.<br />Jednoducho iba napíšte meno, ktoré hladáte, a program to urobí.<br /><br />Systém Soundex je velmi vhodné použit v tomto prípade: poznáte meno, ale neviete, ako sa presne píše.<br />Môže to tiež pomôct v prípade, že ten, kto meno vkladal do databázy, urobil chybu.<br />I v takom prípade, za použitia systému Soundex, bude možné meno nájst.<br /><br />Aby ste si na to zvykli, skúste nájst urcité meno, ale napíšte ho v pozmenenej podobe.<br /><br />V tomto soundexovom formulári stací zadat akékolvek meno.<br />Môžete vyhladávat podla krstného mena, priezviska alebo podla názvu miesta.<br />Ak vyplníte viacej než jedno polícko, jednotlivé kritériá sa zretazia pomocou \"AND\" - tj. budú vyhladané iba tie záznamy, ktoré splnujú súcasne všetky zadané podmienky.<br />Výsledky hladania môžete ovplyvnit tiež zadaním roku alebo rozsahu rokov. Napríklad: 1950 alebo 19[5-7][0-9], co znamená 1950 až 1979.<br />Výsledkom vyhladávania budú všetky osoby, u ktorých je zaznamenaná nejaká udalost na danom mieste v zadanom rozsahu rokov.";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~STRÁNKA S ÚDAJMI O OSOBE~<br /><br />Na tejto stránke sú zobrazené všetky údaje o danej osobe.<br /><br />Ak je v databáze obrázok, uvidíte ho nahore po lavej strane. Vedla obrázku uvidíte meno osoby. K menám môžu byt pripojené pramene a poznámky. Ak sú k niektorému z mien pripojené poznámky alebo pramene, uvidíte ich zoradené pod príslušným menom.<br />Clovek môže mat tiež pseudonym. Ak ho má tak, bude tiež zobrazený.<br /><br />Ak máte potrebné práva k tejto osobe, zobrazí sa vám tiež odkazy pre úpravu a vymazanie položiek, ktoré môžete upravovat.<br /><br />Na tejto stránke vidíte záložky \"Osobné údaje\", \"Poznámky\", \"Pramene\", \"Média\", \"Blízky príbuzný\".<br /><br />Pod týmito záložkami nájdete všetky informácie uložené v GEDCOMe.<br /><br />Záložka \"Osobné údaje\" vám ukáže údaje a podrobnosti o danej osobe a údaje o jej manželstvách. Kliknutie na ktorýkolvek dátum vás prepne do Kalendára výrocí s týmto dátomom, takže sa budete môct pozriet, aké dalšie udalosti sa ešta k tomuto dátumu viažu. Kliknutie na miesto vás prepne do Hierarchie miest, kde uvidíte zoznam ludí, v ktorých živote sa nieco odohralo na rovnakom mieste. Pri snatkoch a iných údajoch spojených s rodinou sa zobrazí tiež meno partnera, takže sa budete môct pozriet i na neho a k dispozícii je i odkaz na záznam o rodine.<br /><br />Záložka \"Poznámky\" vám ukáže všetky všeobecné poznámky pripojené k tejto osobe.<br /><br />Záložka \"Pramene\" vám ukáže všetky pramene viažúce sa k tejto osobe. Po kliknutí na názov pramena sa dostanete na stránku s podrobnými údajmi o danom prameni a zoznamom ludí, ktorý sú k tomuto pramenu napojený.<br /><br />Pod záložkou \"Média\" sa zobrazí zoznam všetkých obrázkov a iných multimediálnych súborov pripojených k tejto osobe. Ak kliknete na náhlad obrázku, otvorí sa okno s obrázkom v pôvodnej velkosti.<br /><br />Pod záložkou \"Blízky príbuzný\" sú zoradený rodicia, súrodenci, partneri a deti tejto osoby. Osoby budú zapísané do rámcekov podobných schémam, ktoré ste už videli.<br /><br />Pri pravej strane obrazovky nájdete rámcek s odkazmi.<br />Mnohé z týchto odkazov sú tiež v hornom menu. Napríklad, ak kliknete z postranných odkazov na \"Vývod\", dostanete sa na stránku s vývodom tejto osoby. Zatial co ked kliknete na odkaz \"Vývod\" v hornom menu, zobrazí sa vám stránka s implicitným vývodom tohoto GEDCOMu.<br /><br />Jeden z odkazov, ktoré by sa mohli v zoznamu objavit, ak boli zapnuté adminom, je odkaz \"Zobrazit priamo záznam GEDCOM\". Tento odkaz vám ukáže priamo samotný GEDCOM kód tejto osoby.<br /><br />Ak admin povolil používanie Schránky výstrižkov, uvidíte tiež odkaz, ktorý vám umožní pridat si túto osobu do Schránky výstrižkov.<br /><br />Odkaz \"Vztah ku mne\" sa zobrazí iba v prípade, že ste prihlásený do systému a bolo vám priradené nejaké císlo z aktuálneho GEDCOMu. Po kliknutí na tento odkaz sa ocitnete na stránke s vývodom a vy uvidíte, ako ste príbuzný s touto osobou.<br /><br />Dalšia nápoveda je k dispozícii na stránke po kliknutí na <b>?</b> za odkazmi ci položkami.";
$pgv_lang["delete_person_help"]			= "~VYMAZANIE OSOBY Z GEDCOMU~<br /><br />Kliknutím na túto volbu oznacíte túto OSOBU, aby mohla byt vymazaná z GEDCOMu.<br /><br />Co to znamená?<br />Predpokladajme, že máte dobrý dôvod k odstráneniu tejto osoby zo svojho GEDCOMu. Kliknite na odkaz a zobrazí sa vám pop-up okno a budete vyzvaný k potvrdeniu, ci naozaj chcete akciu vykonat, alebo ju ukoncit.<br /><br />Ak budete pokracovat v odstranovaní osoby, vyskocí vám po chvilke okno so správou, že osoba bola vymazaná.<br /><br />Ked budete pokracovat v prezeraní stránok, všimnete si možno, že osoba je ešte stále v databáze, že sa teda nic nezmenilo.<br /><br />To <b>nie je</b> chyba.<br />Administrátor dostane správu, že v GEDCOMe bola urobená zmena a že ste odstránili túto osobu.<br />Administrátor môže vašu zmenu bud prijat, alebo odmietnút. Iba potom už túto zmenu nie je možné vziat spät.<br />V prípade pochybností vás administrátor bude kontaktovat.";
$pgv_lang["delete_name_help"]			= "~UPRAVENIE alebo VYMAZANIE MENA Z GEDCOMU~<br /><br /><b>ÚPRAVA MENA</b><br />Po kliknutí na tento odkaz sa vám otvorí pop-up okno, v ktorom budete môct upravit meno osoby.<br />Je to velmi jednoduché, skrátka iba napíšete zmeny do polícok, kliknete na tlacítko a zatvoríte okno; a je to.<br /><br /><b>VYMAZAT MENO</b><br />Kliknutím na túto volbu oznacíte toto meno k výmazu z GEDCOMu.<br />Majte na pamäti, že vymazanie mena je nieco úplne iného než vymazanie osoby.<br />Vymazaním mena iba odstránite u tejto osoby meno. Osoba sama vymazaná nebude.<br />Ak vymažete u osoby pseudonym, zostanú jej ostatné mená.<br />Ak má iba jedno meno a vy ho vymažete, osoba nebude vymazaná, ale bude nadalej vedená ako \"Neznámy(a)\".<br />Osoba tiež nebude odpojená od príbuzných, pramenov, poznámok atd.<br /><br />Ako to funguje?<br />Predpokladajme, že máte dobrý dôvod k odstráneniu tohoto mena zo svojho GEDCOMu. Kliknite na odkaz a zobrazí sa vám pop-up okno a budete vyzvaný k potvrdeniu, ci naozaj chcete akciu vykonat, alebo ju ukoncit.<br /><br />Ak budete pokracovat v odstranovaní osoby, vyskocí vám po chvílke okno so správou, že meno bolo vymazané.<br /><br />Ked budete pokracovat v prezeraní stránok, všimnete si možno, že meno je ešte stále v databáze, že sa teda nic nezmenilo.<br /><br />To <b>nie je</b> chyba.<br />Administrátor dostane správu, že v GEDCOMe bola urobená zmena a že ste odstránili toto méno.<br />Administrátor môže vašu zmenu bud prijat, alebo odmietnut. Iba potom už tuto zmenu nemôžete vziat spät.<br />V prípade pochybností vás administrátor bude kontaktovat.";
$pgv_lang["add_name_help"]			= "~PRIDANIE NOVÉHO MENA~<br /><br />Tento odkaz vám umožní pridat tejto osobe dalšie meno. Niektorý ludia sú známi pod inými menami ci aliasy. Tento odkaz vám umožní pridat meno, bez zmeny starého.";
$pgv_lang["add_note_help"]			= "~PRIDANIE NOVEJ POZNÁMKY~<br /><br />Ak chcete k tomuto údaju pridat poznámku, potom toto je miesto, kde tak môžete urobit.<br />Urobit to je jednoduché, kliknite na odkaz. Otvorí sa vám pop-up okno a vy budete môct napísat novú poznámku.<br /><br />Po dokoncení zapísania poznámky kliknite na tlacítko pod rámcekom a zatvorte okno; to je všetko.";
$pgv_lang["add_sibling_help"]			= "~PRIDANIE BRATA ALEBO SESTRY~<br /><br />Kliknutím na tento odkaz môžete pridat dieta do tejto rodiny.<br />\"Táto rodina\" je, v tomto prípade, otec a matka ústrednej osoby tejto stránky.<br />Takže, majte na pamäti, že pridávate brata alebo sestru tejto osoby.<br />Pridanie brata alebo sestry je jednoduché: Jednoducho iba kliknite na odkaz, vyplnte polícka v pop-up okne a je to.<br /><br />Ak potrebujete pridat syna ci dceru ústrednej osoby, posunte sa v okne o nieco dolu a kliknite na odkaz \"Rodina s partnerom\".";
$pgv_lang["add_son_daughter_help"]		= "~PRIDANIE SYNA CI DCÉRY~<br /><br />Kliknutím na tento odkaz môžete pridat dieta k tejto rodine.<br />\"Táto rodina\" je, v tomto prípade, ústredná osoba na tejto stránke a jej partner.<br />Takže majte na pamäti, že sa chystáte pridat syna alebo dcéru tejto osobe.<br />Pridanie syna alebo dcéry je jednoduché: Jednoducho iba kliknite na odkaz, vyplnte polícka v pop-up okne a je to.<br /><br />Ak chcete pridat brata alebo sestru ústrednej osobe, posunte sa na stránke kúsok nahoru a kliknite na odkaz \"Rodina s rodicmi\".";
$pgv_lang["link_child_help"]			= "~PRIPOJENIE TEJTO OSOBY K EXISTUJÚCEJ RODINE AKO DIETA~<br /><br />Kliknutím na tento odkaz môžete túto osobu pripojit ako dieta k existujúcej rodine.<br /><br />Predpokládajme, že rodicia tejto osoby boli neznámy a vy teraz zistíte, že majú svoj záznam v tomto GEDCOMe.<br /><br />Kliknite iba na odkaz, vložte ID rodiny (ak nepoznáte ID, môžete použit okno pre vyhladávanie) a práca je hotová.";
$pgv_lang["link_husband_help"]			= "~PRIPOJENIE TEJTO OSOBY K EXISTUJÚCEJ RODINE AKO MANŽELA~<br /><br />Táto položka vám umožní pripojit túto osobu ako manžela k rodine, ktorá už je zapísaná v GEDCOMe. Kliknutím na tento odkaz pridáte túto osobu k rodine, u ktorej manžel doteraz nebol známy. Táto osoba zaujme miesto tej neznámej osoby. Všetky udalosti, informácie o manželstve a deti zostanú pripojené k rodine tak, ako sú.<br /><br />Iba kliknite na tento odkaz, zadajte ID rodiny (ak nepoznáte ID, môžete ho vyhladat pomocou pop-up okna) a celá operácia je hotová. Toto je špeciálna volba, ktorá by sa mala používat jedine v prípade, že rodina, ku ktorej chcete osobu pripojit, je už v GEDCOMe uložená. Ak chcete pridat novú rodinu, použijte odkaz pre pridanie novej manželky.";
$pgv_lang["add_husband_help"]			= "~PRIDANIE NOVÉHO MANŽELA~<br /><br />Kliknutím na tento odkaz môžete pridat \"nového\" muža a pripojit ho k ústrednej osobe ako manžela.<br /><br />Kliknite jednoducho na odkaz. Objaví sa pop-up okno, v ktorom budete môct novú osobu pridat.<br />Vyplnte co najviac polícok a kliknite na tlacítko \"Uložit\".<br /><br />To je všetko.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br /><br />Toto vám umožnuje pridat osobu, ktorá už existuje, ako nového manžela k tejto osobe. Bude vytvorená nová rodina s manželom, ktorého ste vybrali. Máte tiež možnost špecifikovat udaje o sobáši novej rodiny.";
$pgv_lang["link_wife_help"]			= "~PRIPOJENIE TEJTO OSOBY K EXISTUJÚCEJ RODINE AKO MANŽELKU~<br /><br />Táto položka vám umožní pripojit aktuálnu osobu ako manželku k nejakej rodine, ktorá je už zapísaná v GEDCOMe. Toto je špeciálna volba, ktorá by sa mala používat jedine v prípade, že rodina, ku ktorej chcete osobu pripojit, je už v GEDCOMe uložená. Ak chcete pridat novú rodinu, použijte odkaz pre pridanie nového manžela.";
$pgv_lang["add_wife_help"]			= "~PRIDANIE NOVEJ MANŽELKY~<br /><br />Kliknutím na tento odkaz môžete pridat \"novú\" ženu a pripojit ju k ústrednej osobe ako novú manželku.<br /><br />Kliknite jednoducho na odkaz. Objaví sa pop-up okno, v ktorom budete môct novú osobu pridat.<br />Vyplnte co najviacej polícok a kliknite na tlacítko \"Uložit\".<br /><br />To je všetko.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br /><br />Toto vám umožnuje pridat osobu, ktorá existuje, ak novú manželku tejto osoby.  This will create a new family with the wife you select.  You will also have the option of specifying a marriage for this new family.";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~PRIDANIE NOVÉHO OTCA alebo MATKY~<br /><br />V GEDCOMe nepochybne bude mnoho osôb, u ktorých nie je uvedený otec alebo matka.<br /><br />V takom prípade nájdete na <b>Stránke s osobnými údajmi</b>, tabulke <b>Blízky príbuzný</b>, tabulke <b>Rodina s rodicmi</b> odkazy pre pridanie <b>nového</b> otca alebo matky k danej osobe.<br /><br /><b>POZNÁMKA:</b><br />Majte prosím na pamäti, že tieto odkazy slúžia pre pridanie <b>nového</b> otca alebo matky.<br />Ak už matka alebo otec má v GEDCOMe záznam, potom použijte odkaz: <b>#pgv_lang[link_as_child]#</b>, ktorý nájdete na stránce s osobnými údajmi - pod najspodnejšou tabulkou na stránke.";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~PRIDANIE NOVÝCH ÚDAJOV~<br /><br />Tu môžete k osobe (alebo osobám) pridat nové údaje.<br /><br />Najskôr z \"rolovacieho zoznamu\" vyberte typ údaja, potom kliknite na tlacítko \"Pridat\".<br />V \"rolovacom zozname\" sú už všetky údaje, ktoré je možné pridat do súboru GEDCOM.";
$pgv_lang["add_custom_facts_help"]		= "~Pridat vlastnú udalost~<br /><br />Ak ste v zozname GEDCOM údajov nenašli údaj, ktorý chcete pridat, môžete zadat <b>vlastný údaj</b>.<br />Vloženie vlastného údaja je rovnako jednoduché ako vloženie preddefinovaného údaja.<br />Jediný rozdiel spocíva v tom, že musíte naviac zadat názov údaja. To musíte urobit v hornom polícku: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_source_help"]			= "~PRIDANIE NOVEJ CITÁCIE K PRAMENU~<br /><br />Ak chcete k tomuto údaju pridat nový pramen, môžete kliknút na odkaz.<br />Otvorí sa pop-up okno a vy budete môct zvolit jeden pramen zo zoznamu (Nájst ID) a pridat \"Citáciu\".<br /><br />V tejto chvíli nie je možné pridat úplne nový pramen, takže musíte vybrat jeden z pramenov zo zoznamu.<br /><br />Ak nie je pramen, ktorý chcete upravovat, v zoznamu, upozornite prosím admina (pripíšte údaje o prameni) a on ho pridá do zoznamu.<br />Nabudúce tak už bude váš nový pramen zahrnutý v zoznamu a vy ho budete môct upravovat.<br /><br />Pravdepodobne už v niektorej z budúcich verzií PhpGedView bude možné pridávat pramene priamo.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~PRIDANIE NOVÉHO MÉDIA~<br /><br />Možnost pridávat do GEDCOMu multimediálne súbory je velmi pekná vlastnost.<br />I ked tento program vyzerá pekne i bez médií, po pridaní obrázkov alebo iných multimediálnych súborov k príbuzným to môže byt jedine lepšie.<br /><br /><b>Co by ste si mali predstavit pod týmto pojmom.</b><br />Ako možno viete, existuje neskutocná rada multimediálnych formátov. I ked PhpGedView vie pracovat s väcšinou z nich, mali by ste niektoré veci zvážit.<br /><br /><b>Formáty</b><br />Obrázky môžu byt uložené do mnohých formátov.<br />Napríklad obrazok.jpg / obrazok.png / obrazok.bmp / obrazok.gif / atd.<br />Všetky obrázky z našeho príkladu budú mat na obrazovke rovnakú velkost, ale budú sa podstatne líšit velkostou súboru na disku.<br /><br /><b>Rozlíšenie</b><br />Rozlíšenie obrázkov je dané v jednotkách \"dpi\" (body na palec). Môžete to viacmenej porovnat s klasickou fotografiou a rozdielmi medzi 25ASA - 200ASA - 800ASA.<br />Cím vyššie rozlíšenie, tým lepšia kvalita, ale tiež väcšia velkost súboru na disku.<br />Normálne stací na obrázky na internete 75.<br /><br /><b>Farebná hlbka</b><br />Tretí spôsob, ako zmenšit súbor, je znížit pocet farieb.<br />Pocet farieb môže byt rôzný – od ciste ciernobielej až po true colors a nieco medzi tým.<br />Opät si uvedomte, že, cím viacej farieb použijete, tým väcšia bude velkost súboru.<br /><br /><b>Preco je dôležité, aby boly obrázkové súbory malé?</b><br /><br />Za prvé: Náš webový priestor je obmedzený.<br />Cím väcšie budú súbory, tým viacej diskového priestoru na servere budeme potrebovat. Cím viacej miesta budeme potrebovat, tím viacej za to budeme musiet platit.<br /><br />Za druhé: doba stahovania. Ak budete mat velké súbory, uživatelia (i vy) budú musiet dlho cakat, než sa im stránka so všetkými obrázkami nacíta.<br />Každý nemá to štastie mat kabelové, širokopásmové alebo DSL pripojenie.<br /><br /><b>Ako môžete nahrat svoje súbory na server</b><br />Strucne - nemôžete.<br />Z vyššie zmienených dôvodov nemôžete svoje súbory nahrat priamo do databázy.<br /><br /><b>Teda ako?</b><br />Kontaktujte admina, od ktorého chcete, aby súbory do GEDCOMu pridal. Poradí vám, ktorý formát použit.<br />Ak budete mat obrázky v správnom formáte, budete ich môct poslat adminovi na e-mail. Admin skontroluje formáty a velkosti súborov a nahrá ich do adresára na servere.<br />Potom budete môct tieto súbory pripojit ku svojim príbuzným, a to použitím tohoto odkazu #pgv_lang[mgv]#.";
$pgv_lang["add_facts_general_help"]		= "~Všeobecné informácie o pridávaní~<br /><br />Ked pridáte k osobe ci osobám údaj, poznámku, pramen alebo multimediálny súbor, táto operácia musí byt ešte potvrdená osobou, ktorej admin udelil právo potvrdzovat zmeny v databáze.<br />Než sa tak stane, zmeny sa na stránke zobrazia v rámceku odlišnej farby a to iba uživatelom, ktorý majú právo túto databázu upravovat, obycajným návštevníkom nie. Až budú zmeny potvrdené, rámceky zmiznú a dáta sa zobrazia normálne.";

//-- Edit user
//$pgv_lang["help_edituser.php"]	is moved to help_text_vars.php
$pgv_lang["edituser_my_account_help"]		= "Na tejto stránke môžete zmenit svoje nastavenia a predvolby.<br /><br />Môžete zmenit svoje uživatelské meno, celé meno, heslo, jazyk, e-mailovú adresu, motív (podobu) stránky a uprednostnovanú formu kontaktu.<br /><br />Jediné, co si sami nemôžete zmenit, je osobné ID v GEDCOMe.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />V tomto polícku môžete zmenit svoje uživatelské meno.<br />Ak sa vám už vaše súcasné uživatelské meno nepáci alebo máte iné dôvody ku jeho zmene, môžete tak urobit v tomto formulári.<br /><br />V uživatelskom mene sa rozoznáva velkost písmen. To znamená, že \"Ján\" nie je rovnaké ako \"ján\" nebo \"JÁN\".<br /><br />Mali by ste použit <b>iba</b> znaky z tých abecied, ktoré sú podporované týmto programom (velké a malé písmená), císla, pomlcku (-) a podciarnik (_).<br /><br /><b>Nepoužívajte</b> interpunkcné znamienka, medzery alebo iné znaky než znaky podporovaných abecied.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />V tomto poli môžete zmenit svoje meno. Toto je meno, ktoré vidia ostatný uživatelia, ked ste prihlásený.<br /><br />I ked volba co dáte do tohoto pola je na vás, mali by ste informovat o tejto zmene administrátora. Ak ostatný uživatelia uvidia prihláseného neznámeho uživatela tak by mohli byt udivený a klást otázky administrátorovi. Admin to môže zistit i bez vášho oznámenia ale vy mu môžete ušetrit túto zbytocnú prácu.";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />V tomto poli môžete zmenit svoje priezvisko. Toto je priezvisko, ktoré vidia ostatný uživatelia, ked ste prihlásený.<br /><br />I ked volba co dáte do tohoto pola je na vás, mali by ste informovat o tejto zmene administrátora. Ak ostatný uživatelia uvidia prihláseného neznámeho uživatela tak by mohli byt udivený a klást otázky administrátorovi. Admin to môže zistit i bez vášho oznámenia ale vy mu môžete ušetrit túto zbytocnú prácu.";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Toto je vnútorné (GEDCOM) ID, ktoré vás spája s vašími údajmi v GEDCOMe.<br /><br />Toto ID nemôžete zmenit.<br />To nastavuje administrátor stránok.<br />Ak si myslíte, že toto ID nie je správné, mali by ste kontaktovat administrátora, aby ho zmenil.<br/>";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Toto je východisková osoba všetkých vašich schém.<br />Ked kliknete (napríklad) na odkaz Vývod, potom uvidíte túto osobu v rámceku vlavo úplne hore.<br />Samozrejme nie je nutné, aby ste boli východiskovou osobou vy. Ako východiskovú osobu si môžete stanovit ktorúkolvek osobu, ktorú máte právo vidiet.<br />V niektorých schémach môžete východiskovú osobu menit, ale táto zmena bude platit iba pre danú stránku.";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />Je dobré zvyknút si pravidelne menit heslo.<br />Musíte si uvedomit, že ktokolvek, kto pozná vaše uživatelské meno a heslo, má prístup k vaším dátam.<br />Vytvorte si heslo zložené z aspon 6 znakov. Cím dlhšie, tým lepšie. Môžete použit všetky znaky abecedy, císlice a akékolvek dalšie znaky, ktoré máte na svojej klávesnici.<br /><b>Poznámka:</b> Je lepšie <b>nepoužívat</b> \" (úvodzovky) i ' (apostrofy). Možno by to fungovalo, ale nie je to zarucené.<br /><br /><b>Najlepšia je kombinácia velkých, malých znakov, císlic a dalších znakov</b>. Napríklad: 5Z_q\$P4=r9.<br /><br />Rovnako ako uživatelské meno, tak i heslo je <b>case sensitive</b> (rozlišuje velké/malé písmená). To znamená, že \"Ja5n\" nie je to isté co \"ja5n\" alebo \"JA5N\".";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Ak ste si zmenili heslo, je potrebné ho ešte potvrdit.<br />Je to z toho dôvodu, aby sa vylúcily možné chyby pri zapisovaní hesla.<br />Ak zistí program, že vaše heslo a jeho potvrdenie sa líši, uvidíte túto správu: <b>#pgv_lang[password_mismatch]#</b>.<br />Obsah oboch polícok (hesla a potvrdenia) bude vymazaný a budete musiet zadat heslo do oboch polícok.";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Tu môžete nastavit implicitný jazyk pre svoje stránky.<br />Program je schopný rozoznat <b>jazykové nastavenie</b> vášho prehliadaca, takže väcšinou nie je dôvod menit nastavenie tu.<br />Ale, ked má napríklad váš prehliadac nastavený ako implicitný jazyk anglictinu, ale vy chcete zobrazovat stránky v slovencine alebo nemcine, potom to môžete zariadit práve tu.";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Vaša e-mailová adresa je pre nás samozrejme dôležitá kvôli možnosti vás kontaktovat.<br />Ak zacnete používat inú e-mailovú adresu, napríklad pri zmene poskytovatela, nezabudnite prosím zmenit svoju adresu i tu.<br />Možno máte viacej e-mailových adries a správy od nás chcete dostávat na inú adresu, prosím zmenu urobte tu.";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />K dispozícii máte niekolko motívov.<br />Motív je súhrn nastavení vzhladu jednotlivých prvkov na stránkach. S každým motívom uvidíte rovnaké dáta, ale vzhlad bude iný.<br />Je to podobné, ako by ste obrazu dali iný rám a zavesili ho v inej izbe. Obraz sa nezmenil, ale pozeráte sa teraz na neho úplne inak.<br />Len to skúste. Nastavte si iný motív. Prezrite si ho a skúste další. Nakoniec nastavte ten, ktorý sa vám pácil najviacej.<br />Kedykolvek sa prihlásite, program vám nastaví vami predvolený motív.";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br /><br />Tento systém ponúka dalšie možnosti zasielania správ<br />Spôsob kontaktu je nastavený administrátorom stránok, takže to nemôžete zmenit.<br />Spôsob <b>prijímania</b> správ si však zmenit môžete.<br />V súcasnosti si môžete vybrat zo štyroch možností.";
$pgv_lang["mail_option1_help"]			= "Ak zvolíte túto možnost, bude sa k odosielaniu správ používat vstavaný systém PhpGedView bez použitia e-mailu.<br />Tak budete môct dostávat iba <b>vnútorné správy</b> od ostatných uživatelov.<br />Ked vám niektorý z uživatelov pošle z týchto stránok správu, nájdete ju v bloku správ na svojej stránke MyGedView (ak ste tento blok zo svojej stránky neodstránili)";
$pgv_lang["mail_option2_help"]			= "Táto volba je rovnaká ako #pgv_lang[messaging]# z niecím naviac.<br />Kópia správy bude naviac poslaná na vašu e-mailovú adresu, ktorú ste u svojho úctu zadali.<br />Tento spôsob kontaktu je nastavený implicitne.";
$pgv_lang["mail_option3_help"]			= "Ak je nastavená táto volba, budete dostávat správy iba na svoju e-mailovú adresu.<br />Ostatný uživatelia sa s vami nebudú môct spojit cez vnútorný systém.";
$pgv_lang["mail_option4_help"]			= "Táto volba spôsobí, že nebudete dostávat žiadne správy.";

//-- Add user
$pgv_lang["admin_help"]				= "Na tejto stránke sú všetky odkazy na konfiguracné súbory, administracné stránky, dokumentáciu a log súbory.<br /><br /><b>Systemový cas</b>, umiestnený hned pod titulok stránky, ukazuje cas serveru, na ktorom sú vaše stránky umiestnené. Cas, ktorý vidíte, je cas otvorenia alebo obnovenia stránky.<br /><br /><b>VAROVANIE</b><br />Ak vidíte pod systémovým casom varovnú správu, znamená to, že do vášho súboru <b>config.php</b> je stále možné zapisovat!<br />Z <b>bezpecnostných dôvodov</b> by ste mali po dokoncení konfigurácie stránok nastavit práva súboru spät na \"iba na cítanie\".<br />To musíte urobit <b>rucne</b>, pretože PhpGedView to zatial nedokáže.<br /><br />Okrem volieb Readme, Uživatelský manuál a Log súbory získáte dalšiu nápovedu na zvolených stránkach.";
$pgv_lang["useradmin_help"]			= "~ADMINISTRÁCIA UŽIVATELOV~<br /><br />na tejto stránke môžete administrovat súcasných uživatelov a pridávat nových uživatelov.<br /><br /><b>Zoznam súcasných uživatelov</b><br />V tejto tabulke sú zobrazený súcasný uživatelia, ich stav a ich práva.<br />Uživatela môžete <b>mazat</b> alebo <b>upravovat</b>.<br /><br /><b>Pridat nový uživatelský formulár</b><br />Tento formulár je takmer zhodný s tým, ktorý poznáte z \"Váš úcet\".<br />U niektorých predmetov sme nevytvárali špeciálnu nápovedu pre admina. V týchto prípadoch uvidíte nasledujúcu správu:";
$pgv_lang["useradmin_gedcomid_help"]		= "~ID V GEDCOMU~<br /><br />Toto ID musí nastavit administrátor.<br />Tým bude ID spojené s osobou daného uživatela.<br />To tiež umožní uživatelovi prístup do svojho <b>#pgv_lang[my_indi]#</b> a <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Pre každý GEDCOM, ktorý v tomto programe používate, môžete nastavit pre uživatela jeho ID.<br />Ak uživatel nie je v tomto GEDCOMe, necháte toto polícko prázdne.";
$pgv_lang["useradmin_rootid_help"]		= "~VÝCHODISKOVÁ OSOBA VÝVODU~<br /><br />V každom GEDCOM súbore môžete nastavit ako <b>Východiskovú osobu</b> niektorého uživatela.<br />Uživatelovi sa pravdepodobne bude pácit spustenie programu so svojím vlastným vývodem, ale nie je to nutné.<br /><br />Uživatel si toto nastavenie môže zmenit vo svojom úcte.";
$pgv_lang["useradmin_can_admin_help"]		= "~ZAŠKRTÁVACIE POLÍCKO - UŽIVATEL SMIE ADMINISTROVAT~<br /><br />ak bude toto polícko zaškrtnuté, bude mat uživatel v tomto programe rovnaké práva ako vy.<dl><dt>Jediné, co on/ona nebude môct robit je:</dt><dd>Pridávat / Odstranovat / Upravovat uživatelov.</dd><dd>Posielat správy všetkým uživatelom naraz.</dd><dd>Upravovat uvítacie správy.</dd><dd>Upravovat a konfigurovat jazykové súbory.</dd><dt>Ale tiež:</dt><dd>Aktualizovat program.</dd><dd>Menit nastavenie.</dd><dd>Aministrovat GEDCOMy.</dd><dd>Menit nastavenie utajenia.</dd><dt>A nic dalšieho, co tu nie je zmienené.</dt><dd>Ale nie nastavenie vašich stránok - mimo tento program</dd></dl>";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# CHECK BOX~<br /><br />AK je tento check box zaškrtnutý a uživatel má priradený záznam GEDCOM pomocou ID, tak zmeny úctu tohoto uživatela budú automaticky synchronizované s jeho údajmi v GEDCOMe. To znamená že ked je upravený záznam tohoto uživatela v GEDCOMe, niektoré informácie napríklad ako e-mailová  adresa a meno bude zkopírované do uživatelského úctu. Ak je upravený uživatelský úcet, zodpovedajúce informácie budú zkopírované do Gedcom záznamu.";
$pgv_lang["useradmin_can_edit_help"]		= "~UŽIVATELSKÉ PRÁVA~<br /><br />Ku každému z GEDCOM súborov, dostupných v tomto systéme, môže mat uživatel urcité práva pre prístup a upravovanie.<br /><br />Ak je táto položka nastavená na <b>Žiadna</b>, znamená to, že uživatel nemá prístup k utajeným údajom z tohoto GEDCOMu. Ak je táto položka nastavená na <b>Prístup</b>, potom tento uživatel nemá právo upravovat alebo potvrdzovat úpravy urobené v databáze, ale má prístup k utajeným údajom.<br /><br />Ak zvolíte <b>Úpravy</b>, znamená to, že tento uživatel môže upravovat informácie v databáze, ale iný uživatel s právami <b>Potvrdzovanie</b> musí tieto zmeny potvrdit skôr, než budú definitivne zapísané do databázy a zverejnené.<br /><br />Nastavenie na <b>Potvrdzovanie</b> umožní uživatelovi upravovat databázu a potvrdzovat zmeny urobené inými uživatelmi.<br /><br />Ak vyberiete možnost <b>Spravovat GEDCOM</b>, umožníte tak uživatelovi naviac upravovat konfiguráciu a nastavenie utajenia tohoto GEDCOMu.<br /><br />Administrátori systému majú automaticky práva <b>Spravovat GEDCOM</b>.";
$pgv_lang["useradmin_verified_help"]		= "~UŽIVATEL POTVRDIL REGISTRÁCIU~<br /><br /><b>Automatická registrácia</b><br />Uživatel môže požadovat zavedenie nového úctu pomocou modulu <b>automatickej registrácie</b>.<br />Ak tak urobí, potom obdrží e-mailom správu s odkazom na stránku, kde bude môct svoju registráciu potvrdit.<br />Ak tak už urobil, uvidíte zaškrtnuté polícko a budete môct pristúpit k dalšiemu kroku: <b>Uživatela povolit adminom</b>.<br />Ak uživatel registráciu nepotvrdil, mali by ste zo svojím povolením pockat.<br /><br /><b>Pridat uživatela rucne</b><br />Ak použijete formulár k pridaniu uživatela rucne, uvidíte toto polícko už zaškrtnuté.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~POVOLENIE ADMINOM~<br /><br />Ak uživatel použil modul automatickej registrácie a následne potvrdil registráciu, potom je váš súhlas posledným krokom pred aktivovaním úctu.<br /><br />Po tom, co povolíte aktiváciu úctu, uživatel obdrží e-mailom správu o tom, že jeho úcet je aktívny a že sa môže prihlásit so svojím uživatelským menom a heslem, ktoré použil, ked žiadal o zavedenie úctu.";
$pgv_lang["useradmin_edit_user_help"]		= "~AKTUALIZÁCIA UŽIVATELSKÉHO ÚCTU~<br /><br />Tento formulár používá admin k tomu, aby zmenil uživatelský úcet.<br /><br />Formulár je podobný formuláru \"Pridat uživatela\" alebo \"Môj úcet\".";
$pgv_lang["useradmin_visibleonline_help"]	= "~VIDITELNÝ ONLINE~<br /><br />Ak je toto polícko zaškrtnuté, ostatný prihlásený uživatelia uvidia, ci ste v daný okamžik online a vy uvidíte, ci sú online ostatný. Ak nechcete, aby vás ostatný videli online, vyškrtnite toto polícko. Ale ani vy nebudete môct zistit, ci sú ostatný uživatelia online.";
$pgv_lang["useradmin_editaccount_help"]		= "~UPRAVOVANIE ÚCTU~<br /><br />Ak je toto polícko zaškrtnuté, potom dotycný uživatel bude môct upravovat informácie o svojom úcte. Ak nie je polícko zaškrtnuté, potom mu to nebude umožnené. To vám umožní vytvorit jedno uživatelské meno a heslo pre viacej uživatelov a pritom nepripustit, aby ktorýkolvek z nich tento úcet menil.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Ak je tento check box zaškrtnutý, uživatel bude mat povolený prístup iba na žijúce osoby které sú s ním v príbuzenskom pomere. Bude môct vidiet kohokolvek v rámci nastavenie pásma príbuzných v <i>#pgv_lang[user_path_length]#</i>. Môžete požadovat nastavenie utajenia príbuzných nastavením globálnej volby v nastavení GEDCOM utajenia.<br /><br />Toto nastavenie vyžaduje aby bol uživatel asociovaný s GEDCOM ID predtým než bude môct zobrazit ktorúkolvek žijúcu osobu.";
$pgv_lang["useradmin_path_length_help"]		= "~#pgv_lang[user_path_length]#~<br /><br />Ak je povolené <i>#pgv_lang[user_relationship_priv]#</i>, tak tento uživatel je schopný iba zobrazit, alebo editovat žijúce osoby v rámci zadaného rozsahu príbuzných.";
$pgv_lang["useradmin_auto_accept_help"]		= "~#pgv_lang[user_auto_accept]#~<br /><br />Zaškrtnutím tohoto boxu povolíte aby program automaticky akceptoval zmeny vykonané týmto uživatelomr. Uživatel musí mat tiež oprávnenie akcetovat zmeny pre tento GEDCOM aby táto volba bola funkcná.";
$pgv_lang["add_upload_gedcom_help"]		= "~PRIDÁVANIE versus NAHRÁVANIE GEDCOMOV~<dl><dt>Nahrávanie GEDCOM súborov</dt><dd>Nahrávanie súborov sa môže robit online.<br />Súbor môžete nahrat z akéhokolvek miesta, bez toho že by ste museli použit ftp program.</dd><dt>Pridávanie GEDCOM súborov</dt><dd>Ak je váš súbor ešte stále vo vašej GEDCOM zložke (na servere), nemusíte ho opät nahrávat.<br />Niekdy je potreba použit možnost Pridat miesto nahrat - to kvôli velkosti súboru alebo limitom pre uploadovanie.</dd></dl>Obe procedúry (Pridat i Nahrat) sa dajú urobit v 4 jednoduchých krokoch.<br />U oboch procedúr sa líši iba krok c. 1.";
$pgv_lang["gedcom_configfile_help"]		= "~KONFIGURACNÝ SÚBOR GEDCOMU~<br /><br />V tomto súbore sú uložené všetky základné nastavenia súboru GEDCOM.<br /><br />Na stránke administrácie GEDCOMu je v stlpci \"Konfiguracný súbor\" zobrazená cesta a názov konfiguracného súboru.";
$pgv_lang["default_gedcom_help"]		= "~IMPLICITNÝ GEDCOM~<br /><br />Ak máte v programe viacej než 1 GEDCOM, môžete tu nastavit, ktorý GEDCOM bude <b>implicitný</b>.<br /><br />Tj. ten GEDCOM, ktorý sa zobrazí všetkým návštevníkom, ktorý ešte nie sú prihlásený.<br /><br />Uživatelia si môžu vo svojom úcte nastavit ako implicitný ktorýkolvek GEDCOM v programe.";
$pgv_lang["delete_gedcom_help"]			= "~ZMAZANIE GEDCOMU~<br /><br />PhpGedView importuje záznamy zo súboru GEDCOM. Ked kliknete na <b>Zmazat</b>, program zmaže tie záznamy, ktoré boli importované z GEDCOMu.<br />Samotný súbor GEDCOM zostane v zložke, do ktorej bol nahraný.<br /><br />Ak budete chciet neskoršie s týmto súborom opät pracovat, nebudete ho musiet znovu nahrávat. Miesto toho môžete zvolit možnost <b>Pridat GEDCOM</b>.<br /><br />Po kliknutí na Zmazat budete musiet svoju volbu <b>potvrdit</b> v popup okne.";
$pgv_lang["add_gedcom_help"]			= "~PRIDANIE GEDCOMU~<br /><br />Ked použijete volbu Pridat GEDCOM, predpokladá sa, že váš GEDCOM súbor je už nahraný na servere - <i>s využitím externého programu</i>, napríklad pre <b>ftp</b> alebo <b>sietové</b> spojenie.<br />Ak ešte váš súbor GEDCOM nie je na servere, <b>musíte</b> ho pred pridávaním najskôr nahrat.<br /><br />Program vás povedie krok po kroku celou procedúrou.";
$pgv_lang["add_new_gedcom_help"]		= "~VYTVORENIE NOVÉHO GEDCOMU~<br /><br />Máte možnost vytvorit úplne nový súbor GEDCOM.<br /><br />Tento proces môžete vykonat v niekolko málo krokoch. Krok 1 sa od iných spôsobov pridávania a nahrávania, ktoré už poznáte, líši. Ostatné kroky sú podobné.<dl><dt>Krok 1: Pomenovanie nového GEDCOMu</dt><dd>Napíšte názov nového GEDCOMu bez prípony '.ged'. Súbor bude vytvorený v zložke, ktorej názov je zobrazený nad políckom pre vloženie názvu.<br />Kliknite na <b>Pridat</b>.</dd><dt>Krok 2: Stránka konfigurácie.</dt><dd>Túto stránku už poznáte z konfigurácie GEDCOM súborov.</dd><dt>Krok 3: Validácia</dt><dd>Tiež tento krok je vám už iste známy. Nový GEDCOM bude prekontrolovaný.</dd><dt>Krok 4: Importovanie záznamov</dt><dd>Pretože budete importovat iba jeden záznam, tento krok prebehne velmi rýchlo.</dd><dt>Vytváranie hotové.</dt><dd>Teraz môžete íst na stránku s vývodom a uvidíte prvú osobu v GEDCOMe. Úpravy zacnete kliknutím na meno osoby. Potom môžete k prvej osobe zacat pridávat dalšie osoby.</dd></dl>";
$pgv_lang["edit_gedcoms_help"]			= "~ADMINISTRÁCIA GEDCOMU~<br /><br />Stránka administrácie GEDCOMu je kontrolným centrom administrácie vašich <b>súcasných</b> a <b>nových</b> GEDCOM súborov.<br /><dl><b>SÚCASNÉ GEDCOMY</b><br /><dt>V tabulke <b>Súcasné GEDCOMy</b> máte nasledujúce volby:</dt><dd>Vymazat GEDCOM</dd><dd>Upravit GEDCOM</dd><dl><dt>Upravit utajenie</dt><dd>Upravenie utajenia je tiež súcastou tejto tabulky, pretože každý GEDCOM má svoj vlastný súbor s nastavením utajenia.</dd></dl><dd>Nastavit implicitný GEDCOM</dd><dd>Importovat GEDCOM</dd><dd>Stiahnút GEDCOM</dd><dt>sú tam 3 stlpce s nasledujúcimi informáciami:</dt><dd>Súbor GEDCOM</dd><dd>Názov GEDCOMu</dd><dd>Konfiguracný súbor</dd></dl><dl><b>NOVÉ GEDCOM SÚBORY</b><dt>Na tejto stránke máte nasledujúce možnosti pridania <b>nových</b> alebo <b>existujúcich</b> GEDCOM súborov do systému.</dt><dd>Pridat GEDCOM</dd><dd>Nahrat GEDCOM</dd><dd>Vytvorit nový GEDCOM</dd></dl>#pgv_lang[more_help]#";
$pgv_lang["edit_config_gedcom_help"]		= "~KONFIGURÁCIA GEDCOMU~<br /><br />Každý GEDCOM, ktorý v tomto programe používate, má svoj vlastný <b>konfiguracný súbor</b>.<br /><br />V tomto formulári môžete zvolit základné nastavenie ako napríklad: jazyk, formát kalendára, nastavenie e-mailu atd. adt.";
$pgv_lang["import_gedcom_help"]			= "~IMPORTOVANIE GEDCOMU~<br /><br />Vo väcšine prípadov prebieha importovanie GEDCOMu v jednom kroku ako napríklad pridávanie alebo nahrávanie GEDCOMu.<br /><br />Tieto kroky sú usporiadané do logického sledu a musia byt dokoncené, aby bolo možné s GEDCOMom pracovat.<br />V prípade, že ste túto procedúru nedokoncili, uvidíte <b>varovnú</b> správu o tom, že GEDCOM zatial nebol importovaný. V takom prípade kliknite na odkaz pre (znovu-)importovanie GEDCOM súboru.<br /><br /><b>Importovanie</b><br /><br />Konfiguracné nastavenie GEDCOMu sa re-importovaním nezmení.<br />Doterajšie údaje v databáze budú prepísané.";
$pgv_lang["upload_gedcom_help"]			= "~NAHRANIE GEDCOMU~<br /><br />Na rozdiel od možnosti \"Pridat GEDCOM\", v tomto prípade nemusíte mat ešte GEDCOM súbor na servere.<br /><br />V 1. kroku zvolte jeden GEDCOM súbor uložený na svojom (domácom) pocítaci. Do polícka napíšte celú cestu vcetne názvu súboru alebo použijte tlacítko <b>Prechádzat</b>.<br /><br />Na dalších stránkach nájdete v priebehu tohoto procesu dalšiu nápovedu.";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Mal by spustit slideshow automaticky pri nacítaní stránky.<br /><br />Slideshow mení obsah bloku bez nového nacítania informácií zo serveru a bez nového nacítania celej stránky.";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Môžete použit na nastavenia zobrazenia alebo ukrytia ovládacích prvkov slideshow v bloku náhodných médií.<br /><br />Tieto ovládace umožnujú užívatelom preskocit na další náhodný objekt alebo prehrávat náhodne vybrané médiá ako slideshow. Slideshow mení obsah bloku bez predchádzajúceho nacítania informácií zo serveru a bez úplného nacítania stránky.";
$pgv_lang["validate_gedcom_help"]		= "~VALIDÁCIA GEDCOMU~<br /><br />Validácia GEDCOMu, ktorý nahrávate alebo pridávate, je tretí krok procedúry, ktorá má zaistit, že systém s vašim súborom bude vediet správne pracovat.<br /><br />Program súbor skontroluje na správnost použitia: datového formátu, formátu miest, znakovej sady a dalších položiek.<br />Niektoré z týchto odchyliek, programom nájdených, budú automaticky opravené. Príkladom sú MacIntošove zakoncenia riadkov a nesprávny formát miest.<br />V týchto prípadoch uvidíte správu o tom, že program zmenil dáta.<br />V prípade iných odchyliek sa objaví varovná správa s návrhom riešenia.<br /><br /><b>Volitelné nástroje</b><br />V tejto chvíli sú k dispozícii dalšie dva nástroje:<br /><b>Zmenit i ID císla osôb...</b> a <b>Nástroj pridania médií</b>.<br />Tento posledný nástroj je dostupný iba v režime <b>MySQL</b>. Ak máte uložený svoj GEDCOM v režime <b>Index</b>, táto volba bude skrytá.<br /><br /><b>Dalšia nápoveda</b> je k dispozícii vo formulári.#pgv_lang[more_help]#";
$pgv_lang["convert_ansi2utf_help"]		= "~PREVEDENIE ANSI NA UTF-8~<br /><br />Aby program správne spracovával s vašími dátami, súbory by mali byt zapísané v kódovaní UTF-8.<br /><br />Väcšina genealogických programov vie GEDCOMy exportovat s týmto kódovaním (UTF-8).<br />Ak však váš program túto možnost neponúka, môže to urobit PhpGedView.<br /><br />Ked PhpGedview kontroluje nahraný (alebo pridaný) súbor, program zistí, ci je súbor zapísaný v ANSI (kódovaní).";
$pgv_lang["detected_ansi2utf_help"]		= "~ROZOZNANÉ KÓDOVANIE ANSI~<br /><br />Súbor GEDCOM, ktorý práve prechádza kontrolou, je zapísaný v kódování ANSI.<br />Dôrazne doporucujeme, aby bolo kódovanie prevedené na UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~ROZOZNANÝ ZLÝ FORMÁT DÁTUMU:~<br /><br /><b>FORMÁT DÁTUMU BUDE ZMENENÝ</b><br /><br />Štandardný formát dátumu programu PhpGedview a tiež podla <b>štandardov GEDCOM 5.5</b> je: DD MMM YYYY (napr.: 01 JAN 2004)<br /><br />Ak uvidíte po skontrolovaní (validácii) svojho GEDCOMu správu o tom, že bol rozoznaný zlý formát dátumu, program prevedie dátumy do štandardného tvaru.<br /><br />Vy však máte možnost zvolit zobrazenie bud \"<b>den</b> pred mesiacom\" (DD MMM YYYY), alebo \"<b>mesiac</b> pred dnom\" (MMM DD YYYY).<br />Doporucujeme ponechat navrhnuté nastavenie na prvej možnosti.";
$pgv_lang["addmedia_tool_help"]			= "~NÁSTROJ PRE PRIDANIE MÉDIÍ~<br /><br />Iba v režime MySQL</b><br /><br />Nástroj Pridanie médií bol navrhnutý pre uživatelov, ktorých genealogický program neexportuje GEDCOMy s odkazmi na médiá. Tým je dobre známy napr. Family Tree Maker. <br /><br />Nástroj Pridanie médií vám umožnuje uchovávat zoznam odkazov na mediálne súbory mimo súbore GEDCOM a oddelene od normálnych tabuliek PhpGedView. Pretože sú dáta uchovávané v samostatnej tabulke, stací ich zadat iba raz. Tým sa administrátorom zjednodušuje práca s genealogickými dátami v ich klasickom programe, exportovanie nového súboru GEDCOM a následné spúštanie nástroja Pridanie médií pre tento súbor ako súcast importu, takže sa im pridajú rovnaké odkazy na obrázky vždy, ked vytvoria nový GEDCOM.<br /><br />Ak chcete používat nástroj Pridanie médií, najskôr vytvorte zoznam mediálnych položiek vyplnením polícok a kliknutím na tlacítko Pridat média pre každú mediálnu položku, ktorú chcete zaclenit do svojho GEDCOMu. Polícko \"#pgv_lang[gedcomid]#\" obsahuje ID GEDCOM záznamu, ku ktorému chcete obrázok pridat, napr. I100. Do polícka \"Externý súbor\" napíšte názov súboru (obrázku), ktorý chcete použit. Do polícka \"#pgv_lang[extension]#\" zadajte príponu súboru. Polícko \"#pgv_lang[highlighted]#\" použijte pre oznacenie, ci je daný obrázok pre danú osobu primárny (uprednostnovaný). Primárny obrázok sa zobrazí vedla mena osoby na stránke s osobnými údajmi. Do polícka \"#pgv_lang[title]#\" doplnte popisok k danému obrázku. Polícko \"#pgv_lang[order]#\" použijte pre špecifikovanie poradia, v ktorom sa majú obrázky objavit v tabulke obrázkov danej osoby. A konecne polícko \"#pgv_lang[gedcom_file]#\" hovorí, pre ktorý GEDCOM je obrázok urcený. To vám umožní použit obrázok pre viacej GEDCOMov.<br /><br />Ked je zoznam hotový, kliknite na tlacítko \"#pgv_lang[click_to_add_media]#\", aby sa dáta uložili do GEDCOM súboru. Ked budete nabudúce aktualizovat svoj GEDCOM, bude stacit, ked spustíte nástroj Pridanie médií a stisknete toto tlacítko.";
$pgv_lang["change_indi2id_help"]		= "~ZMENIT ID OSOBY NA ....~</b><br /><br />Tento nástroj bol navrhnutý pre uživatelov, ktorých genealogický program používa pri každom exporte iné GEDCOM ID. Napríklad, ked je GEDCOM exportovaný prvýkrát, ID osoby je I100, ale pri dalšom exporte má osoba ID I234. Tieto zmeny ID císiel znacne komplikujú administráciu PhpGedView, pretože podla ID sa vytvárajú odkazy na osoby.<br /><br />Ale väcšina genealogických programov používa ako jednoznacné identifikátory tagy RIN alebo REFN. Tento nástroj prepíše ID všetkých osôb hodnotami, ktoré urcíte. Môžete zvolit medzi RIN alebo REFN.";
$pgv_lang["edit_privacy_help"]			= "Na tejto stránke môžete vybrat nastavenie utajenia pre zvolený GEDCOM (ak ich máte viacej).<br />Pod titulkom stránky si môžete overit, ci upravujete správny súbor utajenia.<br />Je tam zobrazené nieco takého: (cesta/nazovvashogedcomu_priv.php)<br /><br />Ak potrebujete zmenit nejaké dalšie nastavenia, môžete tak urobit rucne v súbore utajenia. Viacej sa o tom dozviete na internetových stránkach projektu PhpGedView.";
$pgv_lang["invalid_header_help"]		= "~NEPLATNÁ HLAVICKA GEDCOM~<br /><br />Súbor GEDCOM musí zacínat riadkom 0 HEAD. PhpGedView zistilo, že váš GEDCOM súbor týmto riadkom nezacína. Potom, co kliknete na tlacítko Pokracovat, všetky riadky pred riadkom 0 HEAD budú z GEDCOMu odstránené.<br /><br />Táto chyba väcšinou znamená to, že váš genealogický program nevytvoril správny súbor GEDCOM alebo tento súbor nie je súborom GEDCOM. Mali by ste si overit, ci ste na server pridali správny súbor GEDCOM a ci zacína riadkom 0 HEAD a koncí riadkom 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~ROZOZNANÝ SÚBOR PRE MACINSTOSH~<br /><br />PhpGedView zistilo, že váš súbor GEDCOM bol vytvorený na pocítaci Macintosh. Súbory pre Macintosh obsahujú iné ukoncenie riadkov (r) než Unix (n) alebo Windows (rn). Funkcie PHP, ktoré používa systém PhpGedView, vie pracovat iba zo súbormi pre Unix alebo DOS. Ked kliknete na tlacítko Pokracovat, váš súbor bude prevedený na súbor pre DOS.";
$pgv_lang["cleanup_places_help"]		= "~OPRAVA MIEST~<br /><br />PhpGedView zistilo že vo vašom súbore GEDCOM sú miesta priradené k údajom, kde by podla špecifikácie nemali byt. Takéto súbory vytvára mnoho genealogických programov, ako napr. Family Tree Maker. PhpGedView s týmito súbormi vie pracovat, ale niektoré nesprávne zaradené miesta sa zobrazí ve vašej hierarchii miest. <br /><br />Napríklad, váš GEDCOM môže obsahovat nasledujúci záznam<br />1 SSN<br />2 PLAC 123-45-6789<br />Podla špecifikácie GEDCOM by tento údaj mal byt zobrazený ako<br />1 SSN 123-45-6789<br />Ak zvolíte Ano, PhpGedView automaticky vyhladá a opraví všetky tieto chyby v zakoncení.";
$pgv_lang["empty_lines_detected_help"]		= "~NÁJDENÉ PRÁZDNE RIADKY~<br /><br />PhpGedView zistilo, že vo vašom GEDCOMe sú prázdne riadky. Tieto riadky môžu spôsobit chyby, a preto budú odstránené ešte pred importom GEDCOMu.";
$pgv_lang["skip_cleanup_help"]			= "~PRESKOCENIE CISTENIA~<br /><br />Je velmi doporucené povolit PhpGedView pred importovaním opravit váš GEDCOM súbor. Ak sa tak nestane, niektoré funkcie možno nebudú pracovat správne.<br /><br />Ale, ak chcete, môžete kliknút na toto tlacítko, súbor sa nebude opravovat a bude naimportovaný tak, ako je.";
$pgv_lang["help_editconfig.php"]		= "~KONFIGURÁCIA PhpGedView~<br /><br />Na tejto stránke musíte v prípade, že ste práve nainštalovali PhpGedView na svoj server a prvý krát ho spúštate, zvolit globálne nastavenie programu.<br />#pgv_lang[review_readme]#<br /><br />Pretože toto nastavenie je <b>globálne</b>, platí pre celý program a pre všetky GEDCOMy v nom používané.<br />Pre každý GEDCOM si však môžete vytvorit vlastné nastavenie.<br />Pretože sa nachádzate na stránke Konfigurácia, môžete kliknút na odkaz pre administráciu GEDCOMov (hned nad formulárom).<br />Na všetkých ostatných stránkach nájdete tento odkaz v menu, pod ikonou MyGedView.";
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Táto stránka vám umožnuje zlúcit dva GEDCOM záznamy v tom istom GEDCOM súbore.<br /><br />To je velká pomoc pre uživatelov, ktorý zlúcili viacej GEDCOM súborov a teraz majú vela duplicitných záznamov osôb, rodín a zdrojov.<br /><br />Postup zlúcenia má tri kroky.<br /><ol><li>Zadajte dva GEDCOM ID. ID <u>musia</u> byt rovnakého typu. Nemôžete zlúcit osobu s rodinou a rodinu so zdrojom, napríklad.<br />Do pola <b>#pgv_lang[merge_to]#</b> zadajte ID výsledného záznamu.<br />Do pola  <b>#pgv_lang[merge_from]#</b> zadajte ID záznamu z ktorého chcete data vložit do záznamu #pgv_lang[merge_to]#. Tento záznam bude po zlúcení zmazaný.</li><br /><li>Vyberte z oboch záznamov údaje, ktoré chcete zlúcit. Jednoducho kliknite na zaškrtávacie polícko vedla údaja.</li><br /><li>Môžete si prezriet výsledok zlúcenia ako i dalšie zmeny, ktoré ste urobili online.</li></ol>Niekto s oprávnením autorizácie musí vaše zmeny akceptovat.</li></ul>";

//-- Download GEDCOM
$pgv_lang["download_gedcom_help"]		= "~STIAHNUTIE GEDCOMU~<br /><br />Zo svojich stránok si môžete stiahnút GEDCOM.<br /><br />Na stránke \"Stiahnutie GEDCOMu\", máte možnost zmenit kódovanie z <b>UTF-8</b> na <b>ANSI (ISO-8859-1)</b>.<br />Výber formátu závisí na tom, v akom programe potom chcete zo súborom pracovat.<br />Ak si nie ste istý, nahliadnite do dokumentácie k danému programu.";

//-- GDBI Changes

//-- Language Editor
$pgv_lang["help_reportengine.php"]		= "~SPRÁVY~<br /><br />Nástroj pre vytváranie správ v PhpGedView používa šablony XML pre automatické generovanie PDF správ. Správy dostupné zo zoznamu, sú generované zo správ nájdených v zložke \"reports\". Ked zvolíte správu, ktorá sa má vytvorit, budete požiadaný o informácie špecifické pre daný typ správy, napr. východiskovú osobu alebo rodinu a ci sa majú zobrazit fotky. Ak máte všetko zvolené kliknite na tlacítko \"#pgv_lang[download_report]#\", ak chcete správu rovno stiahnút na svoj disk.<br /><br />Môžete si vytvorit vlastný typ správy tak, že vytvoríte kópiu niektorého zo súborov s XML šablonou a upravíte ho. Túto novú šablonu potom vložte do zložky \"reports\". PhpGedView ju sám nájde a zaradí ju do rolovacieho menu pre výber správy.";
$pgv_lang["def_pdf_format_help"]		= "~PDF FILE FORMAT~<br /><br />Generátor reportov PhpGedView vytvára stiahnutelné reporty v Adobe&reg; PDF formáte. GEDCOM 5.5.1 Standard špecifikácia, uvádzaná na viacerých miestach tejto Nápovedy, je tiež stiahnutelná ako PDF súbor. PDF je skratka pre <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.";
$pgv_lang["help_ahnentafel.xml"]		= "~#pgv_lang[ahnentafel_report]#~<br /><br />Toto je správa vybranej osoby a jej predkov zobrazená vo formáte brožúry. Zacíná vybranou osobou a pokracuje jej rodicmi, starými rodicmi, prarodicmi atd.<br /><br />Poznámka: ahnentafel je v súcasnosti dostupný iba v anglickej verzii.";
$pgv_lang["help_birthlist.xml"]			= "~#pgv_lang[birth_report]#~<br /><br />S týmto reportom si môžete zobrazit zoznam všetkých osôb, ktoré sa narodili v urcitý cas, alebo na urcitom mieste.";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br /><br />Táto správa zobrazí zoznam všetkých príbuzných vybranej osoby. Môžete vybrat ktorý príbuzný budú zobrazený.<ul><li><b>#pgv_lang[child-family]#</b> zobrazí zvolenú osobu, jej rodicov a jej bratov a sestry.</li><li><b>#pgv_lang[spouse-family]#</b> zobrazí zvolenú osobu, jej partnerov a ich deti.</li><li><b>#pgv_lang[direct-ancestors]#</b> zobrazí osobu jej rodicov, starých rodicov, prastarých rodicov a tak dalej celý strom všetkých rodicov tejto osoby v celej línii.</li><li><b>#pgv_lang[ancestors]#</b> zobrazí zoznam všetkých osôb z #pgv_lang[direct-ancestors]# ale obsahuje aj strýkov a tety a prastrýkov a pratety, tiež obsahuje súrodencov všetkých predkov v tejto rodovej línii. Neobsahuje ale deti súrodencov (sestranice a bratrancov).</li><li><b>#pgv_lang[descendants]#</b> zobrazí pre všetky tieto osoby ich potomkov (deti, vnukov, pravnukov, atd.).</li><li><b>#pgv_lang[all]#</b> táto volba je kombináciou #pgv_lang[descendants]# a #pgv_lang[ancestors]# v jednej správe.</li></ul>";
$pgv_lang["help_xml_reports"]			= "~REPORTY~<br /><br />Nástroj pre vytváranie správ v PhpGedView používa šablony XML pre automatické generovanie PDF správ. Správy dostupné zo zoznamu <b>#pgv_lang[select_report]#</b>, sú generované XML súborov nájdených v zložke \"reports\". Ked zvolíte správu, ktorá sa má vytvorit, budete požiadaný o informácie špecifické pre daný typ správy, napr. východiskovú osobu alebo rodinu a ci sa majú zobrazit fotky. Ak máte všetko zvolené kliknite na tlacítko \"#pgv_lang[download_report]#\", ak chcete správu rovno stiahnút na svoj disk.<br /><br />Môžete si vytvorit vlastný typ správy tak, že vytvoríte kópiu niektorého zo súborov s XML šablonou a upravíte ho. Túto novú šablonu potom vložte do zložky \"reports\". PhpGedView ju sám nájde a zaradí ju do rolovacieho menu pre výber správy.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>OBSAH NÁPOVEDY</b>";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM info";
$pgv_lang["help_contents_gedcom_places"]	= "Miesta v GEDCOMe";
$pgv_lang["admin_help_contents_head_help"]	= "<b>OBSAH NÁPOVEDY<br /><br />POLOŽKY ADMINISTRÁTORSKEJ NÁPOVEDY</b> boli pridané na zaciatok zoznamu.";
$pgv_lang["ah2_help"]				= "_Konfigurácia PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Pridanie x Nahranie";
$pgv_lang["ah4_help"]				= "_GEDCOM: Konfiguracný súbor";
$pgv_lang["ah5_help"]				= "_GEDCOM: Implicitný";
$pgv_lang["ah6_help"]				= "_GEDCOM: Zmazanie";
$pgv_lang["ah7_help"]				= "_GEDCOM: Pridanie";
$pgv_lang["ah8_help"]				= "_GEDCOM: Vytvorenie nového";
$pgv_lang["ah9_help"]				= "_GEDCOM: Stiahnutie";
$pgv_lang["ah10_help"]				= "_GEDCOM: Stránka administrácie";
$pgv_lang["ah11_help"]				= "_GEDCOM: Konfigurovanie";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importovanie";
$pgv_lang["ah13_help"]				= "_GEDCOM: Nahranie";
$pgv_lang["ah14_help"]				= "_GEDCOM: Skontrolovanie";
$pgv_lang["ah15_help"]				= "_GEDCOM: Prevod z ANSI na UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Nastavenie utajenia";
$pgv_lang["ah17_help"]				= "_Administrácia uživatelov";
$pgv_lang["ah18_help"]				= "_Administrácia";
$pgv_lang["ah19_help"]				= "_GEDCOM: Nástroj médií";
$pgv_lang["ah20_help"]				= "_GEDCOM: Zmena ID osôb na .......";
$pgv_lang["ah21_help"]				= "_Jazykové súbory";
$pgv_lang["ah23_help"]				= "_Konfigurácia podporovaných jazykov";
$pgv_lang["ah24_help"]				= "_Uživatelské informácie - presun (Index -->> SQL)";
$pgv_lang["ah25_help"]				= "_PhpGedView záloha";
$pgv_lang["ah26_help"]				= "_FAQ zoznam: Editácia";
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br /><br />Toto je druhý krok v riadení nahrávania mediálnych súborov ked máte nakonfigurované adresáre v default adresári médií.<br /><br />Ako uživatel s administrátorskými právami môžete vytvorit štruktúru adresárov v ktorej budete ukladat mediálne súbory. Založenie adresárov z tejto stránky zabezpecí, že adresáre s náhladmi obrázkov budú založené so zodpovedajúcimi súbormi index.php v každom adresári.<br /><br />Môžete presúvat súbory medzi adresármi pomocou linku Presunút do --> link. Náhlady sú tiež presunuté tak aby štruktúra súborov zostala zhodná.<br /><br />Ak ste neurobili nacítanie súborov s náhladmi alebo ste zabudli zaznacit checkbox <b>#pgv_lang[gen_thumb]#</b> v priebehu nacítania, máte možnost vytvorit náhlady tu. Oznacte box <b>#pgv_lang[show_thumbnail]#</b>; ak náhlad nebol nájdený môžete kliknút na link <b>#pgv_lang[gen_thumb]#</b> a vytvorit ho.";
$pgv_lang["simple_filter_help"]			= "~#pgv_lang[filter]#~<br /><br />Jednoduchý vyhladávací filter založený na vložených znakoch, globálne vyhladávacie znaky (tzv. wildcards - * ?) nie sú akceptované.";
$pgv_lang["show_thumb_help"]			= "~#pgv_lang[show_thumbnail]#~<br /><br />Náhlady budú zobrazené, ak zaškrtnete tento check box.";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Ak uživatel s právami administrátora môžete vytvorit adresárovú štruktúru v ktorej chcete ukladat vaše mediálne súbory. Vytvorenie adresárov z tejto stránky zarucí, že adresáre z náhladmi obrázkov sú založené súcasne so zodpovedajúcimi súbormi index.php v každom adresári.<br /><br />Kliknite na link a vložte meno adresára, ktorý chcete založit.";
$pgv_lang["find_media_help"]			= "~#pgv_lang[find_media]#~<br /><br />Umožnuje vám prechádzat štruktúru súborov a vyhladat položky médií, ktoré chcete priradit.";
$pgv_lang["alive_in_year_help"]			= "~#pgv_lang[alive_in_year]#~<br /><br />Táto volba vám umožní zobrazit osoby žijúce v zadanom roku.<br /><br />Ak máte pre osobu vyplnený rok narodenia a úmrtia, a zadaný rok spadá do tohoto obdobia, osoba je oznacená ako žíjúca v tomto roku. <br /><br />Vložte iný rok a kliknite na tlacítko <b>Zobrazit</b> ku zobrazeni osôb žijúcich v tomto roku. Zbytok stránky funguje rovnako ako Zoznam osôb.";
$pgv_lang["year_help"]				= "~#pgv_lang[alive_in_year]#~<br /><br />Vložte rok, pre ktorý chcete vyhladat ludí žijúcich v tomto roku.";
$pgv_lang["help_repolist.php"]			= "~#pgv_lang[repo_list]#~<br /><br />Na tejto stránke je zobrazený zoznam pramenov.<br /><br /> Mená pramenov su triedené abecedne.<br /><br /><b>PRAMENE</b><br />Bez pramenov nemôžete budovat svoju databázu. To je zdroj všetkých informácií uložených v databáze, a tieto zdroje sú uložené v pramenoch. Pramene môžu byt archívy a to ako súkromné tak i verejné, verejné databázy, štátne alebo cirkevné matriky, informácie z Internetu a pod. Pre prístup k zdrojom musíte vediet kde a v akej forme sú uložené. Všetky potrebné informácie, ktoré ste našli v pramenoch musia byt uložené v záznamoch Pramenov v databáze.<br /><br />Pramen môže byt zviazaný z mnohými zdrojmi.";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Tu su zobrazené detailné informácie o Prameni. Spolocne zo Zdrojmi sú Pramene najdôležitejšie zdroje informácií pre genealogické bádanie. Pomocou presných informácií Zdrojov a Pramenov budete môct sledovat cesty dalších bádatelov pri vyhladávaní informácií. Mali by ste byt schopný nájst rovnaké informácie ako oni.<br /><br />Na tejto stránke môžete vidiet údaje o Prameni ako titul, adresu, e-mail, internetovú stránku.<br /><br />Za detailnými informáciami o Prameni je zoznam všetkých Zdrojov spojených s týmto Pramenom. To vám umožnuje vidiet všetky informácie získaných z jednotlivého Pramena.<br /><br />Ak to je povolené administrátorom stránky, uvidíte jednu alebo dve ikony na tejto stránke:<br /><b>#pgv_lang[view_gedcom]#</b>, ktorá zobrazí informácie v GEDCOM formáte, <br /><b>#pgv_lang[add_to_cart]#</b>, ktorá vám umožní uložit tieto informácie do  #pgv_lang[clip_cart]#. Odtial môžete stiahnut informácie do  GEDCOM súboru a importovat do vašeho vlastného genealogického programu.<br /><br />#pgv_lang[context_help]#";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Ak kliknete na túto volbu, oznacíte tento Pramen na zmazanie.<br /><br />Co to znamená?<br />Predpokladajme, že máte dobrý dôvod k zmazaniu pramena z databázy. Kliknite na link. Budete vyzvaný k potvrdeniu požiadavku. Ak budete pokracovat uvidíte za chvilku správu, že pramen bol zmazaný.<br /><br />Ak budete pokracovat v práci s rodokmenom, zistíte, že pramen je nadalej vidiet ako keby nebol zmazaný.<br /><br /><b>To <u>nie je</u> chyba.</b> Administrátor stránky dostane správu o zmene v databáze a potom zmaže pramen.<br />Administrátor môže akceptovat alebo zamietnut váš požiadavok. Až po akceptovaní administrátorom bude váš požiadavok na zmazanie <br /><u>nevratne</u> vykonaný. V prípade nejakej pochybnosti o vašom požiadavku vás bude administrátor kontaktovat.";
$pgv_lang["show_repo_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Ak kliknete na tento link, zobrazia sa vám v novom okne informácie o prameni, ktorý je uložený vo vašej databáze.";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Ak kliknete na tento link, môžete pridat pramen, ktorý je uložený vo vašej databáze, do vášho #pgv_lang[clip_cart]#.";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />V tomto boxe vidíte zobrazené mená pramenov uložených v tejto databáze.<br /><br />Mená súzobrazené v abecednom poriadku.<br /><br />Ak kliknete na meno v zozname, dostanete sa na stránku #pgv_lang[repo_info]#, kde môžete vidiet zoznam zdrojov pripojených k tomuto pramenu.";
$pgv_lang["repos_listbox_help"]			= "~#pgv_lang[other_repo_records]#~<br /><br />V tomto boxe vidíte zobrazené mená zdrojov, ktoré sú zviazané z pramenmi.<br /><br />Mená sú zobrazené v abecednom poriadku.<br /><br />Ak kliknete na meno v zozname, otvoríte si detailné zobrazenie zdroja.";
$pgv_lang["block_move_up_help"]			= "~Presun položiek zoznamu~<br /><br />Použite toto tlacítko ku zmene poradia položiek zoznamu. Bloky budú zobrazené v poradí v akom su zoradené na zozname.<br /><br />Oznacte položku ktorú chcete presunút a potom kliknite na tlacítko šípky hore alebo dole.";
$pgv_lang["help_faq.php"] 			= "~FAQ - Casto sa opakujúce otázky~<br /><br />#pgv_lang[text_faq_help]#";
$pgv_lang["text_faq_help"] 			= "FAQ (Frequently Asked Questions) stránka obsahuje prehlad otázok a odpovedí k tejto genealogickej stránke.<br /><br /> Použitie stránky FAQ nastavuje výhradne administrátor. Administrátor nastavuje obsah položiek a tiež poradie v ktorom sa zobrazujú na stránke.";
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br /><br />Tu urcíte rozsah hladania.<br /><br />Administrátorovia majú možnost hladat v Uživatelskej nápovede alebo v Nápovede konfigurácie, prípadne v oboch. Uživatelia túto možnost nemajú, pretože nemajú prístup na žiadnu funkcnost konfigurácie, preto môžu hladat iba v Uživatelskej nápovede.<br /><br />Súbory nápovedy neobsahujú iba nápovedu ale tiež urcité textové retazce používané vo formulároch a dalších materiáloch. Táto volba vám dáva možnost urcit ci bude prehladávaný celý súbor nápovedy, alebo ci bude prehladávaný iba text nápovedy.";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />Vložte pocet detí tejto osoby, alebo rodiny. Toto je nepovinné pole.<br /><br />|";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />Vložte cas pre túto udalost v 24-hodinovom formáte s vedúcimi nulami. Polnoc je 00:00. Príklad: 04:50 13:00 20:30.";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />Poznamky sú neformatované texty, ktoré sa zobrazia na stránke v sekcii Detail udalosti.";
$pgv_lang["edit_CEME_help"]			= "~#factarray[CEME]#~<br /><br />Vložte meno cintorína, alebo miesta odpocinku, kde je osoba pochovaná.";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Vložte GEDCOM ID príbuzného.";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Vyberte názov vztahu zo zoznamu. Výber <b>Dedko</b> znamená: <i>Tento príbuzný je dedkom tejto osoby</i>.";
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Schéma presýpacích hodín zobrazí predkov a potomkov zvolenej východiskovej osoby v jednej schéme. Táto schéma je spojením Vývodu a Rozrodu.<br /><br />Východisková osoba je umiestnená v strede stránky a jej potomkovia sú zobrazený vlavo a predkovia vpravo. Na tomto pohlade je každá generácia zoradená napriec stránkou pocínajúc najmladšou a konciac najstaršou.";
$pgv_lang["help_familybook.php"]		= "~#pgv_lang[familybook_chart]#~<br /><br />Táto schéma ja velmi podobná schéme presýpacích hodín. Zobrazuje predkov a potomkov zvolenej východiskovej osoby v jednej schéme. Tiež zobrazuje potomkov východiskovej osoby v formáte schémy presýpacích hodín.<br /><br />Východisková osoba je umiestnená v strede stránky, jej potomkovia sú zobrazený vlavo a predkovia vpravo. V tomto zobrazení sú všetky generácie zoradené napriec stránkou pocínajúc najstaršou a konciac najmladšou.<br /><br />Všetci potomkovia východiskovej osoby sa stávajú východiskovou osobou dodatocných schém presýpacích hodín, ktoré sú zobrazené na tej istej stránke. Tento proces sa opakuje v závislosti na hodnote parametru pocet generácií potomkov, zadanom na výberovej obrazovke.";
$pgv_lang["fambook_descent_help"]		= "~#pgv_lang[descent_steps]#~<br /><br />Táto hodnota urcuje pocet generácií potomkov východiskovej osoby, ktoré budú samostatne zobrazené vo forme schémy presýpacích hodín.";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Implicitne táto schéma nezobrazuje partnerov potomkov, pretože zobrazenie je potom neprehladné a nezrozumitelné. Zapnutím tejto volby zobrazíte partnerov v tejto schéme.";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Rodiny na záložke #pgv_lang[relatives]# sú zobrazené v takom poradí v akom boli zadané do záznamu osoby v GEDCOMe. Rodiny nie sú zoradené podla dátumu snatku pretože casto je neznámy, ale poradie snatkov <u>známe je</u>.<br /><br />Táto volba vám umožnuje zmenit poradie rodín, ktoré sú zobrazené na záložke #pgv_lang[relatives]#. Ak chcete triedit rodiny podla dátumu ich snatku, kliknite na tlacítko, ktoré tu je a triedenie bude prebiehat automaticky.";
$pgv_lang["import_marr_names_help"]		= "~#pgv_lang[import_marr_names]#~<br /><br />Ak vyberiete možnost importovat mená žien po snatku PhpGedView bude kontrolovat záznamy žien vo vašom GEDCOM súbore a automaticky generovat pole s menom po snatku v ich zázname v GEDCOM súbore. Mená sú generované z mien manželov posledného manželstva. Toto vám umožní hladat tieto ženy podla ich mena po snatku alebo podla rodného mena.<br /><br />Táto volba vám umožnuje zobrazit meno po skratku na stránke osoby a zozname osôb ak povolíte volbu <b>#pgv_lang[SHOW_MARRIED_NAMES]#</b> v nastavení konfigurácie GEDCOMu.";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />Pole #factarray[TYPE]# umožnuje špecifikovat uživatelskú udalost. Je to volne definovatelné pole, do ktorého možete zapísat lubovolný text.";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />Pre LDS obrad, toto pole odsahuje údaj o chráme kde bol obrad vykonaný.";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />Toto je nepovinné pole zo stavom používané hlavne pre LDS obrady tak ako prebiehaju v TempleReady programe.";
$pgv_lang["edit__PRIM_help"]			= "~#factarray[_PRIM]#~<br /><br />Použite toto pole k oznaceniu, že táto mediálna položka je primárna, alebo zdôraznená, pre osobu ku ktorej je priradená. Zvýraznený obrázok bude použitý v schémach a na individuálnej stránke osoby.";
$pgv_lang["edit__THUM_help"]			= "~#factarray[_THUM]#~<br /><br />Toto je uživatelské PhpGedView pole, ktoré vám umožní špecifikovat zvýraznený obrázok pre použitie v schémach i ked náhlad pre obrázok neexistuje.";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />Vložte titulok položky ktorú práve editujete. Ak je to titulok pre multimediálnu položku, vložte popisný titulok ktorý bude identifikovat ktorému uživatelovi (osobe) patrí.";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />Toto je najdôležitejšie pole v zázname multimediálneho objektu. Oznacuje ktorý súbor sa používa. Musíte zadat minimálne meno súboru. V závislosti na vašom nastavení môžu byt užitocné i informácie o uložení súboru.<br /><br />Môžete použit link <b>#pgv_lang[find_media]#</b> pre nájdenie súborov, ktoré už boli nacítané na stránku.<br /><br />#pgv_lang[readme_help]#";
$pgv_lang["edit_FORM_help"]			= "~#factarray[FORM]#~<br /><br />Toto je volitelné pole ktoré môže byt použité na vloženie formátu multimediálneho objektu. Niektoré genealogické programy môžu brat v úvahu toto pole pri spracovaní objektu. Avšak, pretože média nie je možné prenášat medzi pocítacovými systémami príliš dobre, toto pole nie je velmi dôležité.";
$pgv_lang["generate_thumb_help"]		= "~VYTVORIT NÁHLADY~<br /><br />Zistili sme, že váš systém má možnost automaticky generovat náhlady z niektorých typov obrázkov. Napríklad pre JPG, GIF, a PNG súbory. Typy, ktoré váš systém podporuje, sú zobrazené vedla checkboxu.<br /><br />Zaznacením tohoto boxu, signalizujete systému, že ste nacítali obrázky tohoto typu a chcete skúsit generovat pre ne náhlady. Ponechajte checkbox nezaznacený ak chcete nacítat vaše vlastné náhlady.";
$pgv_lang["edit_add_NOTE_help"]			= "~#pgv_lang[add_note]#~<br /><br />Táto sekcia vám umožnuje pridat novú Poznámku k udalosti, ktorú práve editujete. Je to volne definovatelné pole, do ktorého možete zapísat lubovolný text.";
$pgv_lang["edit_add_SOUR_help"]			= "~#pgv_lang[add_source]#~<br /><br />Táto sekcia vám umožnuje pridat novú citáciu zdroja k udalosti, ktorú práve editujete.<br /><br />Do pola Zdroj vložte ID príslušného zdroja. Kliknite na link <b>#pgv_lang[create_source]#</b> ak potrebujete založit nový zdroj. Do pola Detail citácie môžete vložit císlo stránky zdroja, alebo inú informáciu, ktorá môže pomôct komukolvek nájst informáciu v zdroji. Do pola Text môžete vložit opis textu zo zdroja.";
$pgv_lang["edit_add_ASSO_help"]			= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# umožní vám spojit nejakú udalost s nejakou pridruženou osobou. To je jeden zo spôsobou ako vy môžete zaznamenat napríklad to, že niekto je dedkom nejake inej osoby.";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Môžete použit toto pole k vyjadreniu kvality, alebo spolahlivosti údajov nájdených v tomto zdroji. Mnoho genealogických aplikácií na to používa císla. <b>1</b> môže znamenat, že údaje sú kvalitné, <b>2</b> môže znamenat, že údaje sú menej kvalitné, <b>3</b> môže znamenat, že údaje sú nespolahlivé.";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />V poli Detail citácie môžete uložit císlo stránky, alebo nejakú inú informáciu, ktorá môže niekomu pomôct nájst informáciu v zdroji.";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />Do tohoto pole môžete vložit text citácie z tohoto zdroja. Napríklad to môže byt prepis textu zo zdroja, alebo popis toho co bolo v citácii.";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Toto pole vám umožní zmenit  záznam o zdroji z ktorého je táto citácia. Pole obsahuje ID zdroja. Vedla pola je zobrazený názov aktuálneho zdroja. Použite link <b>#pgv_lang[find_id]#</b> k vyhladaniu ID zdroja. Ak chcete odstránit citáciu, vymažte odsah pola.";
$pgv_lang["edit_edit_raw_help"]			= "~#pgv_lang[edit_raw]#~<br /><br />Táto stránka vám umožnuje editovat priamo záznam v GEDCOMe. Používajte túto stránku opatrne, vyžaduje to dobru znalost štandardu GEDCOM 5.5.1. Pre dalšie informácie o GEDCOM 5.5.1 štandarde sa môžete podívat na heslo nápovedy <b>GEDCOM súbor</b>.<br /><br />PhpGedView poskytuje vela možností ako pridat a editovat informácie, ale môžete mat dôvod editovat priamo záznam GEDCOMu. Obvykle by ste mali používat štandardné formuláre na pridávanie informácií, ale ak to nieje možné môžete použit i tento formulár. Po uložení formulára budú vaše údaje skontrolované na zhodu s GEDCOM štandardom a následne bude aktualizovaný záznam CHAN.";
$pgv_lang["add_from_clipboard_help"]		= "~#pgv_lang[add_from_clipboard]#~<br /><br />PhpGedView vám umožnuje kopírovat udalosti do schránky. Môžete zkopírovat až 5 udalostí a uložit ich do schránky. Z rozbalovacieho menu Pridat novú udalost môžete zvolit volbu Vložit a vložit jedenu z udalostí do záznamu osoby. To je velmi užitocná funkcia na vkladanie rovnakých udalostí, ako napríklad scítanie ludu, pre vela osôb.";
$pgv_lang["edit_PLAC_help"]			= "#factarray[PLAC]#~<br /><br />Miesta musia byt zapisovane podla genealogického štandardu. V genealógii sú miesta zaznamenávané s najdôležitejšou informáciou na prvej pozícii až po nejmenej dôležitejšiu informáciu na poslednej pozícii, na oddelenie rôznych úrovní miest sa používa ciarka. Úroven by mala zodpovedat úrovni miesta podla hierarchie cirkve alebo štátu a odkazovat na miesto kde sú uchované dôležité záznamy.<br /><br />Napríklad miesto ako Salt Lake City má byt zaznamenané ako \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Vysvetlime si každú cast tohoto záznamu. Prvá cast, \"Salt Lake City,\" je mesto alebo mestská štvrt, kde sa udalost stala. V niektorých krajinách môže byt ešte samosprávna obec, alebo mestský obvod. V tom prípade musia byt pred mestom. Dalšia cast, \"Salt Lake,\" je kraj. \"Utah\" je štát, a \"USA\" je krajina (republika). Je dôležité zaznamenat každé miesto, lebo genealogické záznamy sú uchovávané úradmi na všetkých úrovniach.<br /><br />Ak je úroven miesta neznáma, vynechajte ho a nechajte medzeru medzi ciarkami. Predpokladajme, že pre vyššie uvedený príklad ste nevedeli kraj pre Salt Lake City. Záznam by vyzeral takto: \"Salt Lake City, , Utah, USA\". Predpokladajme, že viete iba to, že osoba sa narodila v Utahu. V tom prípade by záznam vyzeral takto: \", , Utah, USA\". <br /><br />Môžete použit link <b>#pgv_lang[find_place]#</b> pre nájdenie miesta ak už existuje v databáze.";
$pgv_lang["edit_add_parent_help"]		= "~PRIDAT NOVÚ MATKU ALEBO OTCA~<br /><br />Táto stránka vám umožnuje pridat novú matku alebo otca pre vybranú osobu. Vyplnte pre novú osobu meno a dátum narodenia a úmrtia ak ich poznáte. Ak neviete dalšie údaje ponechajte polia prázdne.<br /><br />Ak chcete pridat dalšie udalosti okrem dátumu narodenia a úmrtia uložte najskôr novú osobu do databázy. Potom otvorte stránku Rodina alebo záložku #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#. Na stránke #pgv_lang[indi_info]# môžete pridat dalšie detailné informácie.";
$pgv_lang["edit_add_spouse_help"]		= "~PRIDAT NOVÉHO MANŽELA ALEBO MANŽELKU~<br /><br />Na tejto stránke môžete pridat nového manžela alebo manželku vybranej osobe. Vyplnte pre novú osobu meno a dátum narodenia a úmrtia ak ich poznáte. Ak neviete dalšie údaje ponechajte polia prázdne.<br /><br />Ak chcete pridat dalšie udalosti okrem dátumu narodenia a úmrtia uložte najskôr novú osobu do databázy. Potom otvorte stránku Rodina alebo záložku #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#. Na stránke #pgv_lang[indi_info]# môžete pridat dalšie detailné informácie.";
$pgv_lang["edit_death_help"] 			= "~#pgv_lang[death]#~<br /><br />Táto oblast vám umožnuje vložit informácie o úmrtí. Najskôr vyplnte dátum kedy osoba zomrela v štandardnom formáte dátumu pre genealógiu (1 JAN 2004). Môžete kliknút na ikonu kalendára a dátum vybrat. Potom vyplnte miesto kde osoba zomrela. Ak miesto existuje v databáze, môžete použit na vyhladanie link <b>#pgv_lang[find_place]#</b>.";
$pgv_lang["edit_birth_help"] 			= "~#pgv_lang[birth]#~<br /><br />Táto oblast vám umožnuje vložit informácie o narodení. Najskôr vyplnte dátum kedy sa osoba narodila v štandardnom formáte dátumu pre genealógiu (1 JAN 2004). Môžete kliknút na ikonu kalendára a dátum vybrat. Potom vyplnte miesto kde sa osoba narodila. Ak miesto existuje v databáze, môžete použit na vyhladanie link <b>#pgv_lang[find_place]#</b>.";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />Vyberte zodpovedajúce pohlavie zo zoznamu. <b>Neznáme</b> indikuje, že pohlavie osoby nám nieje známe.";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Toto je najdôležitejšie pole v zázname Meno osoby. Malo by byt vyplnené automaticky ked vyplnujete dalšie polia, ale môžete editovat údaje podla vlastného uváženia. Meno je pole ktoré musí byt vyplnené podla  GEDCOM 5.5.1 štandardu s priezviskom uzavretým lomítkami \"/\". Napríklad meno \"John Robert Finlay Jr.\" musí byt vyplnené takto: \"John Robert /Finlay/ Jr.\".";
$pgv_lang["edit_suffix_help"]			= "~#pgv_lang[suffix]#~<br /><br />Do tohoto nepovinného pola môžete vložit príponu k menu osoby. Príklady prípon mien sú \"St.\", \"Ml.\", \"III\" atd.";
$pgv_lang["edit_surname_help"]			= "#pgv_lang[surname]#~<br /><br />Do tohoto pola vložte priezvisko tejto osoby. Napríklad, pre meno \"John Robert Finlay\",  priezvisko ktoré môžete sem vložit je \"Finlay\"";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />Do tohoto pola môžete vložit prezývku (nicknames) osoby.<br />Toto pole je nepovinné.<br /><br />Ako pridat prezývky:<ul><li>Vyberte <b>Upravit meno</b> potom vložte prezývku a uložte záznam</li><li>Vyberte <b>Pridat nové meno</b> potom vložte dalšiu prezývku A MENO a uložte záznam </li><li>Vyberte<b>Upravit GEDCOM záznam</b> pre pridanie viacerých [2&nbsp;NICK] záznamov podriadených hlavnému záznamu [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]		= "~#pgv_lang[given_name]#~<br /><br />Do tohoto pola vložte krstné meno tejto osoby. Napríklad, pre meno \"John Robert Finlay\",  krstné meno ktoré môžete sem vložit je \"John Robert\"";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />Toto nepovinné pole môžete použit na zadanie titulu, napríklad \"Dr.\" or \"ing.\"";
$pgv_lang["edit_add_child_help"]		= "~#pgv_lang[add_child]#~<br /><br />Táto stránka vám umožnuje pridat nové dieta pre vybranú rodinu. Vyplnte pre nové dieta meno a dátum narodenia a úmrtia ak ich poznáte. Ak neviete dalšie údaje ponechajte polia prázdne.<br /><br />Ak chcete pridat dalšie údaje okrem dátumu narodenia a úmrtia uložte najskôr nové dieta do databázy. Potom otvorte stránku Rodina alebo záložku #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#. Na stránke #pgv_lang[indi_info]# môžete pridat dalšie detailné informácie.";
$pgv_lang["review_changes_help"]		= "~NEAKCEPTOVANÉ ZMENY~<br /><br />Tento blok zobrazuje zoznam záznamov, ktoré boli zmenené v režime online a doteraz neboli zkontrolované a akceptované pre zápis do databázy.";
$pgv_lang["quick_update_name_help"] 		= "~AKTUALIZÁCIA MENA~<br /><br />Použite polia \"Aktualizácia mena\" ku zmene mena osoby, ktorú práve editujete. Do pola Rodné meno zadajte rodné meno (prvé meno) osoby. Do pola Priezvisko zadajte priezvisko (druhé meno) osoby. Napríklad ak je meno ktoré chcete napísat \"John Robert Finlay\" tak vložte \"John Robert\" od pola rodné meno a \"Finlay\" do pola priezvisko.<br /><br />Vyplnenie týchto polí <u>zmení</u> meno osoby; nebude pridané nové meno.<br /><br /><i>Poznámka: <u>nepoužívajte</u> tento postup na zmenu mena ak vkladáte záznam o novom snatku. Naopak, použijte túto volbu k založeniu nového manžela.</i>";
$pgv_lang["quick_update_fact_help"] 		= "~AKTUALIZÁCIA UDALOSTI~<br /><br />Použite polia \"Aktualizácia udalosti\" ku zmene informácií o udalosti alebo zmene existujúcej udalosti pre osobu ktorú editujete. Najskôr vyberte udalost zoz zoznamu. Potom vložte dátum kedy sa udalost stala v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknút na ikonu kalendára a vybrat datum. Potom vložte miesto kde sa udalost stala. Môžete použit link  <b>#pgv_lang[find_place]#</b> pre výber miesta ak existuje v databázer.<br /><br />Tak ako všetky dalšie polia tohoto formulára, vaše údaje prepíšu už existujúce alebo založia nové podla požiadavku.";
$pgv_lang["quick_update_photo_help"] 		= "~AKTUALIZÁCIA FOTOGRAFIE~<br /><br />Použite polia \"Aktualizácia fotografie\" k nacítaniu obrázku pre osobu ktorú práve editujete. Do pola Titulok napíšte výstižný popis pre obrázok, napríklad ako \"John Finlay 2004\". Potom kliknite na tlacítko <b>Zobrazit</b> pre nájdenie obrázku vo vašom PC. Ak osoba ktorú editujete už má obrázok, môžete pomocou zaškrtávacieho polícka urcit ci chcete obrázok prepísat alebo pridat nový.";
$pgv_lang["quick_update_address_help"] 		= "~AKTUALIZÁCIA ADRESY~<br /><br />Použijte pole \"Aktualizácia adresy\" ku zmene adresy, císla telefónu, alebo e-mail adresu osoby, ktorú práve editujete.<br /><br />Tak ako všetky polia na tomto formulári, vaše informácie prepíšu už existujúce, alebo založia nové záznamy podla požiadavku.";
$pgv_lang["quick_update_spouse_help"] 		= "~PRIDAT NOVÉHO MANŽELA ALEBO MANŽELKU~<br /><br />Použite toto pole ak chcete pridat nového manžela alebo manželku osobe ktorú práve upravujete. Vyplnte pre nového partnera meno a dátum narodenia a potom zadajte dátum snatku. Dátum zadajte v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknút na ikonu kalendára a dátum vybrat. Môžete použit link <b>#pgv_lang[find_place]#</b> na vyhladanie miesta ak existuje v databáze. br /><br />Toto pole je iba na pridanie <i>nového</i> partnera, nie je na aktualizáciu údajov už existujúceho. Pre aktualizáciu údajov niekoho, kto už je založený v databáze, zatvorte toto okno a kliknite na meno osoby v záložke #pgv_lang[relatives]#. Potom kliknite na volbu Upravit v menu.";
$pgv_lang["quick_update_marriage_help"] 	= "~AKTUALIZOVAT SNATOK~<br /><br />Môžete použit toto pole súcasne s polom na pridanie nového manžela alebo manželky ak chcete založit nový záznam o snatku. Inak údaje vložené do tohoto pola zmenia informácie o poslednom snatku tejto osoby. Vložte dátum v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknút na ikonu kalendára a vybrat dátum. Môžete použit link <b>#pgv_lang[find_place]#</b> pre vybranie miesta ak existuje v databáze.";
$pgv_lang["quick_update_child_help"] 		= "~PRIDAT NOVÉ DIETA~<br /><br />Použijte toto pole na pridanie nového dietata pre túto osobu. Najskôr zadajte meno dietata a vyberte pohlavie. Potom vložte dátum a miesto narodenia. Dátum vložte v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknút na ikonu kalendára a dátum vybrat. Ak miesto narodenia existuje v databáze môžete použit link <b>#pgv_lang[find_place]#</b> k výberu miesta zo zoznamu.<br /><br />Toto pole pole je iba pre pridanie <u>nového</u> dietata. Neumožnuje aktualizovat údaje pre už existujúci záznam. Pre aktualizáciu údajov niekoho kto už existuje v databáze, zatvorte toto okno a kliknite na jeho meno v záložke #pgv_lang[relatives]#. Potom kliknite na volbu Upravit v menu.";
$pgv_lang["index_top10_pageviews_help"]		= "~BLOK NAJCASTEJŠIE ZOBRAZENÝCH POLOŽIEK~<br /><br />Tento blok zobrazuje zoznam Top 10 osôb, rodín, alebo zdrojov ktoré boli zobrazené návštevníkmi týchto stránok. Pre zobrazenie tohoto bloku musí administrátor stránok zapnút pocitadlo prístupov k položkám.";
$pgv_lang["useradmin_user_default_tab_help"]	= "~NASTAVENIE IMPLICITNÝCH ZÁLOŽIEK UŽIVATELA~<br /><br />Umožnuje vám definovat, ktoré záložky budú zobrazené automaticky ked otvoríte stránku #pgv_lang[indi_info]#. Ak máte povolené editovat tento úcet možete si zmenit toto nastavenie.";
$pgv_lang["edituser_user_default_tab_help"]	= "~NASTAVENIE IMPLICITNÝCH ZÁLOŽIEK UŽIVATELA~<br /><br />Umožnuje vám definovat, ktoré záložky budú zobrazené automaticky ked otvoríte stránku #pgv_lang[indi_info]#.";
$pgv_lang["reorder_children_help"]		= "~PRETRIEDIT DETI~<br /><br />Deti sú zobrazené  v poradí v akom boli zadané do záznamu o rodine. Deti nie sú zoradené podla dátumu narodenia, pretože casto nie je známy, ale podla poradia ich narodenia ktoré <u>známe je</u>.<br /><br />Táto volba vám umožnuje zmenit poradie v ktorom sú zobrazené deti v GEDCOM zázname o rodine. Ak chcete odteraz zoradit deti podla ich dátumu narodenia, kliknite na tlacítko ktoré tu je umiestnené a triedenie bude prebiehat automaticky.";
$pgv_lang["rss_feed_help"]			= "~NASTAVENIE RSS~<br /><br />RSS správy dostupné v  PhpGedView vám umožnia vidiet dôležité novinky z vašej úvodnej stránky pomocu vašeho oblúbeného prehliadaca RSS bez toho aby ste museli navštívit internetové stránky rodokmena. Väcšina prehliadacov zobrazí upozornenie ak sa nieco zmenilo na stránke. To vám v podstate umožní sledovat stránky PhpGedView bez pravidelnej návštevy. V bloku RSS správy, nastavujete pripojenie k správam, umožnuje vám tiež definovat typ správy (väcšina prehliadacov most môže pracovat s väcšinou typov, takže môžete ponechat implicitné nastavenie), a špecifikovat modul pre vaše správy. Jazyk správy bude totožný z aktívnym jazykom stránky PhpGedView  v momente ked nastavujete RSS. Typy správ ktoré môžu byt generované sú RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML a JavaScript. Prvé 4 typy sú pre prehliadace RSS správ, zatial co  JavaScript a HTML sú urcené pre umožnenie zaradenia správ do iných web stránok.<br /><br />Poznámka: rôzne císla verzií RSS správ oznacuje rôzne druhy a nie rozne verzie.";
$pgv_lang["edit_SEX_help"]			= "~Edit #factarray[SEX]#~<br /><br />Použite toto pole na špecifikáciu ci je osoba <b>#pgv_lang[male]#</b> alebo <b>#pgv_lang[female]#</b>. Vyberte <b>#pgv_lang[unknown]#</b> iba v prípade ak nie ste si istý pohlavím osoby.";
$pgv_lang["edit_NAME_help"]			= "~Edit #factarray[NAME]#~<br /><br />Mená by mali byt napísané s lomítkami \"/\" uzatvárajúcimi priezvisko.<br /><br />Vezmite v úvahu následujúci príklad:<ul><li>Krstné meno /Priezvisko/</li><li>Krstné meno /Priezvisko/ ml.</li><li>Krstné meno /von Priezvisko/ jr.</li></ul>";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Použijte tento formulár na pridanie nezávislej osoby.<br /><br />Ak pridáte nezávislú osobu do vášho rodokmena, táto osoba nebude mat žiadny vztah k ostatným osobám až dokial ho nevytvoríte. Neskoršie môžete vytvorit vztah medzi osobami z tabulky #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Vložte URL adresu vcetne http://. Príklad: <b>http://www.phpgedview.net/</b><br /><br />Ponechajte pole prázdne ak nechcete zadat URL.";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Vložte adresu domovskej stránky vcetne http://. Príklad: <b>http://www.phpgedview.net/</b><br /><br />Ponechajte pole prázdne ak nechcete zadat adresu domovskej stránky.";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Vložte e-mailovú adresu. Príklad: <b>name@hotmail.com</b><br /><br />Ponechajte toto pole prázdné ak nechcete zadat e-mailovú adresu.";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Vložte císlo FAXu vcetne kódu štátu a oblasti. Napríklad císlo pre Nemecko môže byt +49 25859 56 76 89 a císlo pre USA môže byt +1 888 555-1212.<br /><br />Ponechajte toto pole prázdné ak nechcete zadat císlo FAXu.";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Vložte telefónne císlo vcetne kódu štátu a oblasti. Napríklad císlo pre Nemecko môže byt +49 25859 56 76 89 a císlo pre USA môže byt +1 888 555-1212.<br /><br />Ponechajte toto pole prázdné ak nechcete zadat císlo telefónu.";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Vložte do tohoto pola poštovú adresu presne v tom tvare v akom ju chcete tlacit na obálku.<br /><br />Ponechajte toto pole prázdne ak nechcete zadat adresu.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Prefix Priezviska~<br /><br />Vložte, alebo vyberte zo zoznamu prefix, ktorý je umiestnený pred hlavnou castou priezviska. Napríklad <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, atd.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]			= "~#factarray[_MARNM]#~<br /><br />Vložte meno po sobáši pre túto osobu, použite rovnaké formátovacie pravidlá ako pre pole Meno. Toto pole je nepovinné.<br /><br />Napríklad ak sa Mary Jane Brown vydá za Johna White, môžete vložit (samozrejme bez uvodzoviek)<ul><li>Americká  verzia:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Európska verzia:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternatívna Európska verzia:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" alebo \"Mary Jane /Brown-White/\"</li></ul>Toto môžete urobit iba ak si Mary Brown zmenímeno po sobáši s Johnom White. Na niektorých miestach, napríklad v Quebecu (Canada), je nelegálne zmenit meno týmto spôsobom.<br /><br />Muži niekedy zmenia svoje meno po sobáši, najcastejšie použijú formu /Brown-White/ ale obcas prevezmú priezvisko manželky.";
$pgv_lang["context_help"]			= "Dalšiu nápovedu získate kliknutím na <b>?</b> vedla textu na stránke.";
$pgv_lang["register_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Každá osoba v databáze má unikátny ID kód. Ak poznáte svoje ID, prosím vložte ho sem. Ak ho nepoznáte, alebo ho nemozete vyhladat z dôvodu nastavenia utajenie, napíšte do pola Komentáre dostatok informácií, ktoré pomôžu administrátorovi identifikovat kto ste a aké máte ID. Toto ID vám potom nastaví administrátor.";
$pgv_lang["register_comments_help"]		= "~#pgv_lang[comments]#~<br /><br />Použijte toto pole k tomu, aby ste administrátorovi zdôvodnili preco žiadate o založenie uživatelského úctu a aký je váš vztah k rodokmenu zobrazenému na tejto stránke. Tiež môžete napísat dalšie informácie potrebné administrátorovi.";
$pgv_lang["utf8_ansi_help"]			= "~KONVERZIA Z UTF-8 NA ANSI~<br /><br />Pre optimálne zobrazenie na internete, používa PhpGedView sadu znakov UTF-8. Niektoré programy, napríklad Family Tree Maker, nepodporujú import súborov GEDCOM kódovaných v UTF-8. Oznacte tento check box ak chcete zkonvertovat súbor z <b>UTF-8</b> na <b>ANSI (ISO-8859-1)</b>.<br /><br />Formát ktorý potrebujete, je závislý na programe v ktorom chcete pracovat z downloadovaným GEDCOM súborom. Ak nie ste si istý formátom, overte kódovanie v dokumentácii použitého programu.<br /><br />Pozor. Ak chcete ponechat špeciálne znaky nezmenené, musíte súbor ponechat v kódovaní UTF-8 a zmenit spôsob spracovania týchto znakov vo vašom programe nejakým iným spôsobom. Poradte sa s dodávatelom, alebo autorom programu.<br /><br /> ";
$pgv_lang["remove_tags_help"]			= "~ODSTRÁNIT UŽIVATELSKÉ PGV TAGY~<br /><br />Výberom tejto volby odstránite uživatelské TAGy, ktoré mohli byt pridané k záznamom PhpGedView.<br /><br />Uživatelské tagy použité PhpGedView vcetne <b>_PGVU</b> tagu, identifikujúceho uživatela , ktorý zmenil záznam v režime online a <b>_THUM</b> tagu ktorý urcuje pre PhpGedView ktorý obrázok bude použitý ako náhlad.<br /><br />Vlastné značky môžu spôsobiť chyby pri importe stiahnutého GEDCOM-u do inej genealogickej aplikácie.";
$pgv_lang["download_zipped_help"]		= "~NACÍTAT GEDCOM AKO ZIP SÚBOR~<br /><br />Ak zvolíte túto možnost, zkopírovaný súbor GEDCOM bude komprimovaný do formátu ZIP než zacne nacítanie. To podstatne redukuje jeho velkost, ale budete musiet použit kompatibilný Unzip program (WinZIP, napríklad) na dekomprimovanie preneseného GEDCOM súboru, než ho budete môct použit.<br /><br />Toto je užitocná volba pre nacítanie velkých GEDCOM súborov. Je tu riziko, že cas nacítania nekomprimovaného súboru prekrocí maximálny povolený cas, dôsledkom toho by bol nekompletný import súboru. Volba ZIP môže zredukovat cas nacítania o  75%.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Použite tento link na pridanie nového zdroja do vašej databázi bez odkazu na citáciu alebo iný záznam. Nový zdroj bude zobrazený v zozname zdrojov, ale nebude zobrazený v žiadnej schéme ani kdekolvek inde v programe pokial nebude vytvorený odkaz na citáciu zdroja.";
$pgv_lang["link_person_id_help"]		= "~#pgv_lang[label_local_id]#~<br /><br />Do tohoto pola vložte  ID osoby s ktorou ste spojený (napr. I100).";
$pgv_lang["link_gedcom_id_help"]		= "~#pgv_lang[label_gedcom_id]#~<br /><br />Použite túto sekciu k výberu alternatívneho databázového identifikátora ktorý obsahuje osobu s ktorou ste spojený.";
$pgv_lang["add_gedcom_instructions"]		= "Zadajte meno súboru pre tento nový GEDCOM. Gedcom súbor bude vytvorený v Index adresári: #INDEX_DIRECTORY#";
$pgv_lang["import_options_help"] 	= "Môžete vybrat dodatocné volby, ktoré budú použité pri importe GEDCOMu.";
$pgv_lang["verify_gedcom_help"]	= "Tu môžete zvolit bud pokracovanie v nacítaní a importe tohoto GEDCOMu alebo prerušenie nacítania a importu.";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />Za úcelom zlepšenia výkonu, niektoré bloky z Úvodnej stránky PhpGedView sú uchované ako cache súbory v adresári index. Cache súbory pre väcšinu blokov sú obnovené jeden krát za den, ale môže nastat situácia ked ich budete chciet obnovit manuálne.<br /><br />Toto tlacidlo vám umožní obnovit cache súbory ked to je potrebné.";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br /><br />Administrátor niekedy potrebuje vycistit a upravit údaje zaslané užívatelmi. Napríklad môže potrebovat upravit polohu PLAC. Ak adminitrátor urobí takúto opravu, informácia o povôde zmeny je normálne prepísaná. To je ale nežiadúce.<br /><br />Ak je táto možnost zvolená,  PhpGedView uchová informáciu o pôvode zmeny miesto nahradenia z aktuálnej session. Po výbere tejto možnosti majú správcovia tiež možnosť upravovať alebo mazať informácie spojené s pôvodnou značkou CHAN.";
?>
