<?php
/**
 * Arabic Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Ezz (sfezz)
 * @translator Samar A Kadhi
 * @version $Id: lang.ar.php 7371 2024-02-07 01:04:20Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}


$pgv_lang["gedcomid"]			= "GEDCOM INDI record ID";
$pgv_lang["exact"]			= "مطابق";
$pgv_lang["sounds_like"]		= "مشابه ل";
$pgv_lang["install_step_8"] 		= "بدء";
$pgv_lang["parent_family"]		= "أسرة الوالدين";
$pgv_lang["step_parent_family"]		= "أسرة زوج الأب أو الأم";
$pgv_lang["immediate_family"]		= "الأسرة المباشرة";

$pgv_lang["ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["multi_site_search"] 		= "البحث لدى أكثر من موقع";
$pgv_lang["differences"]		= "الفروقات";
$pgv_lang["changedate1"]		= "نهاية نطاق تواريخ التعييرات";
$pgv_lang["changedate2"]		= "بداية نطاق تواريخ التعييرات";
$pgv_lang["search_place_word"]		= "مطابقة الكلمة بالكامل فقط";
$pgv_lang["cache_life"]			= "Cache file life";
$pgv_lang["genealogy"]			= "علم الأنساب";
$pgv_lang["deactivate"]			= "تعطيل";
$pgv_lang["play"]			= "تشغيل";
$pgv_lang["stop"]			= "إيقاف";
$pgv_lang["random_media_start_slide"]	= "بدء تشغيل العرض عند تحميل الصفحة؟";
$pgv_lang["random_media_ajax_controls"]	= "عرض عناصر التحكم للعرض؟";
$pgv_lang["description"]		= "الوصف";
$pgv_lang["current_dir"]		= "المجلد الحالي";
$pgv_lang["SHOW_ID_NUMBERS"]		= "عرض رقم المعرف بجانب الأسماء";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "عرض الصور في صناديق الأشخاص";
$pgv_lang["view_img_details"]		= "عرض تفاصيل الصور";
$pgv_lang["server_folder"]		= "اسم المجلد على الخادم";
$pgv_lang["medialist_recursive"]	= "عرض ملفات الوسائط الموجودة في المجلدات الفرعية";
$pgv_lang["media_options"]		= "خيارات ملفات الوسائط المرافقة للشجرة";
$pgv_lang["confirm_password"]		= "يجب تأكيد كلمة السر";
$pgv_lang["children"]			= "أطفال";
$pgv_lang["lchildren"]			= "أطفال";
$pgv_lang["child"]			= "ولد";
$pgv_lang["family"] 			= "عائلة";
$pgv_lang["as_child"]			= "أسرة مع الوالدين";
$pgv_lang["shared_note_menu"]		= "خيارات الملاحظات المشتركة";
$pgv_lang["source_menu"]		= "خيارات للمصدر";
$pgv_lang["repo_menu"]			= "خيارات مستودع البيانات";
$pgv_lang["other_records"]		= "سجلات مرتبطة بهذا المصدر:";
$pgv_lang["other_repo_records"]		= "السجلات المرتبطة بهذا المستودع:";
$pgv_lang["repo_info"]			= "معلومات المستودع";
$pgv_lang["enter_terms"]		= "أدخل مصطلحات البحث";
$pgv_lang["search_asso_label"]		= "شركاء";  //translation for Associates?
$pgv_lang["search_asso_text"]		= "عرض الأقارب";
$pgv_lang["search_fams"]		= "العوائل";
$pgv_lang["search_gedcom"]		= "بحث قواعد البيانات";
$pgv_lang["search_geds"]		= "اختر قواعد البيانات المطلوبة للبحث";
$pgv_lang["search_indis"]		= "الأفراد";
$pgv_lang["search_notes"]		= "الملاحظات المشتركة";
$pgv_lang["search_inrecs"]		= "البحث عن";
$pgv_lang["search_prtall"]		= "جميع الأسماء";
$pgv_lang["search_prthit"]		= "Names with hit";
$pgv_lang["results_per_page"]		= "النتائج المعروضة لكل صفحة";
$pgv_lang["firstname_search"]		= "الاسم الأول";
$pgv_lang["search_prtnames"]		= "الأفراد <br /> طباعة أسماء:";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"] 		= "تسجيل دخول المستخدمين";
$pgv_lang["for_support"]		= "للدعم الفني الرجاء التواصل مع";
$pgv_lang["for_contact"]		= "للدعم المتعلق بالأنساب الرجاء التواصل مع";
$pgv_lang["for_all_contact"]		= "للدعم الفني أو الدعم المتعلق بالأنساب الرجاء التواصل مع";
$pgv_lang["username"]			= "اسم المستخدم";
$pgv_lang["invalid_username"]		= "اسم المستخدم يحتوي على أحرف غير صالحة";
$pgv_lang["choose_password"]		= "كلمة السر المرغوبة";
$pgv_lang["admin"]			= "مدير النظام";
$pgv_lang["logged_in_as"]		= "مسجل دخولا باسم المستخدم  ";
$pgv_lang["my_pedigree"]		= "نسبي";
$pgv_lang["my_indi"]			= "سجل بياناتي";
$pgv_lang["yes"]			= "نعم";
$pgv_lang["no"] 			= "لا";
$pgv_lang["change_theme"]		= "تغيير الخلقية";

//-- Admin File Messages
$pgv_lang["password_mismatch"]		= "لم تتطابق كلمات السر المدخلة";
$pgv_lang["enter_username"] 		= "يجب إدخال اسم المستخدم";
$pgv_lang["enter_password"] 		= "يجب إدخال كلمة السر";
$pgv_lang["save"]			= "حفظ";
$pgv_lang["saveandgo"]		        = "حفظ مع انتقال إلى سجل آخر";
$pgv_lang["delete"] 			= "حذف";
$pgv_lang["edit"]			= "تعديل";
$pgv_lang["no_login"]			= "غير قادر على التحقق من المستخدم.";
$pgv_lang["basic_realm"]		= "نظام التحقق من المستخدمين";
$pgv_lang["basic_auth_failure"]		= "يجب عليك إدخال تسجيل الدخول للاطلاع على هذه البيانات";
$pgv_lang["basic_auth"]			= "Basic Authentication";
$pgv_lang["digest_auth"]		= "Digest Authentication"; //not used in code yet
$pgv_lang["no_auth_needed"]		= "بدون تحقق من المستخدمين";
$pgv_lang["file_not_exists"]		= "اسم الملف المدخل غير موجود";
$pgv_lang["research_assistant"]		= "أدوات البحث";
$pgv_lang["utf8_to_ansi"]		= "تحويل من UTF-8 إلى ANSI (ISO-8859-1)";
$pgv_lang["media_linked"]		= " ملف الوسائط هذا مرتبط بالتاليين:";
$pgv_lang["media_not_linked"]		= "ملف الوسائط هذا غير مرتبط بأي شخص في قاعدة بيانات شجرة العائلة";
$pgv_lang["media_dir_1"]		= "ملف الوسائط هذا متواجد في خادم خارجي";
$pgv_lang["media_dir_2"]		= "ملف الوسائط هذا متواجد في مجلد عام";
$pgv_lang["media_dir_3"]		= "ملف الوسائط هذا متواجد في مجلد خاص";
$pgv_lang["thumb_dir_1"]		= "هذه الصورة المصغرة متواجدة في خادم خارجي";
$pgv_lang["thumb_dir_2"]		= "هذه الصورة المصغرة متواجدة في مجلد عام";
$pgv_lang["thumb_dir_3"]		= "هذه الصورة المصغرة متواجدة في مجلد خاص";
$pgv_lang["moveto_2"]			= "نقل إلي مجلد خاص";
$pgv_lang["moveto_3"]			= "نقل إلي مجلد عام";
$pgv_lang["move_standard"]		= "نقل إلى عام";
$pgv_lang["move_protected"]		= "نقل إلى خاص";
$pgv_lang["move_mediadirs"]		= "نقل المجلدات";
$pgv_lang["setperms"]			= "تحديد ضوابط الملفات";
$pgv_lang["setperms_fix"]		= "تصحيح صلاحيات القراءة / الكتابة / التنفيذ ";
$pgv_lang["setperms_success"]		= "تم تحديد الصلاحيات";
$pgv_lang["setperms_failure"]		= "لم يتم تحديد الصلاحيات";
$pgv_lang["setperms_time_exceeded"]	= "انتهت مدة التنفيذ المسموحة. حاول الأمر مرة أخرى باستخدام مجلد أصغر.";
$pgv_lang["move_time_exceeded"]		= " انتهت مدة التنفيذ المسموحة. حاول الأمر مرة أخرى لتحريك بقية الملفات.";
$pgv_lang["media_firewall_rootdir_no_exist"]	= "المجلد الجذري المطلوب لجدار الحماية غير متواجد. عليك إنشاؤه.";
$pgv_lang["media_firewall_protected_dir_no_exist"]= "لا يمكن إنشاء مجلد خاص داخل المجلد الجذري لجدار الحماية. عليك إنشاء هذا المجلد وتفعيل صلاحية الكتابة لدى الكل للمجلد أولاً.";

$pgv_lang["media_firewall_protected_dir_not_writable"]	= "صلاحية الكتابة لدى الكل غير مفعلة للمجلد الخاص المتواجد داخل المجلد الجذري لجدار الحماية";
$pgv_lang["media_firewall_invalid_dir"]	= "خطأ: تم إطلاق جدار حماية من مجلد غير مجلد ملفات الوسائط المتعددة.";


//-- user self registration module
$pgv_lang["lost_password"]		= "نسيت كلمة السر؟";
$pgv_lang["requestpassword"]		= "طلب كلمة سر جديدة";
$pgv_lang["no_account_yet"] 		= "ليس لديك حساب؟";
$pgv_lang["requestaccount"] 		= "طلب إنشاء حساب جديد";
$pgv_lang["emailadress"]		= "عنوان البريد الالكتروني";
$pgv_lang["mandatory"] 			= "الحقول ذات علامة * إجبارية.";
$pgv_lang["mail01_line01"]		= "مرحباً #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "تم استلام طلب في #PGV_SERVER_NAME##PGV_SCRIPT_PATH# لإنشاء حساب جديد لعنوان البريد الإلكتروني #user_email#.";
$pgv_lang["mail01_line03"]		= "يمكنك مشاهدة المعلومات المتعلقة بهذا الطلب في الرابط أدناه.";
$pgv_lang["mail01_line04"]		= "الرجاء النقر على الرابط التالي ومن ثم القيام بتعبئة البيانات المطلوبة لتأكيد طلبك وعنوانك البريدي الإلكتروني.";
$pgv_lang["mail01_line05"]		= "إن كنت لم تطلب إنشاء حساب جديد، يمكنك حذف هذه الرسالة.";
$pgv_lang["mail01_line06"]		= "لن يتم إرسال آية رسائل أخرى على عنوانك البريدي الإلكتروني من هذا الموقع، حيث سيتم حذف طلب الحساب تلقائيا بعد سبعة أيام.";
$pgv_lang["mail01_subject"] 		= "تسجيلك في #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["mail02_line01"]		= "مرحباً بمدير النظام...";
$pgv_lang["mail02_line02"]		= "قام مستخدم جديد بتسجيل نفسه في موقع شجرة العائلة في #PGV_SERVER_NAME##PGV_SCRIPT_PATH#.";
$pgv_lang["mail02_line03"]		= "لقد تلقى المستخدم رسالة بالبريد الالكتروني تتضمن المعلومات الضرورية لتأكيد طلبه .";
$pgv_lang["mail02_line04"]		= "وسيتم إعلامك عن طريق البريد الإلكتروني عند تأكيد العضو لطلبه. ومن ثم يمكنك إكمال العملية من خلال تفعيل اسم المستخدم الجديد حيث لن يكون العضو قادرا على تسجيل الدخول حتى تقوم بتفعيل حسابه.";
$pgv_lang["mail02_line04a"]		= "سيتم إعلامك عن طريق البريد الإلكتروني عند تأكيد العضو لطلبه. ومن ثم سيكون المستخدم قادرا على تسجيل الدخول للموقع دون الحاجة لاتخاذ أي إجراء من جانبك.";
$pgv_lang["mail02_subject"] 		= "تسجيل جديد في #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["hashcode"]			= "رمز التحقق:";
$pgv_lang["thankyou"]			= "مرحبا بكم #user_fullname#  ... <br /> شكراَ على تسجيلك.";
$pgv_lang["pls_note06"] 		= "سيتم إرسال رسالة تأكيد بالبريد الإلكتروني حالاً إلى العنوان <b> #user_email# </b>.  عليك التحقق من طلب حسابك عن طريق اتباع الإرشادات الموجودة في رسالة البريد الإلكتروني. إذا لم تقم بتأكيد طلب حسابك في غضون سبعة أيام، سيتم رفض طلبك تلقائياً مما سيتطلب إعادة إرسال طلب جديد . <br /> <br /> وبعد اتباعك للتعليمات الواردة في البريد الإلكتروني، سيقوم مدير النظام بمراجعة طلبك ولن تتمكن من استخدام حسابك قبل الحصول على الموافقة من قبل مدير النظام. <br /> <br />";

$pgv_lang["pls_note06a"] 			= "سنقوم الآن بإرسال رسالة تأكيد بالبريد الإلكتروني إلى العنوان <b> #user_email# </b>. يجب عليك التحقق من الطلب الخاص بحسابك عن طريق اتباع الإرشادات الموجودة في رسالة البريد التأكيدية. في حال عدم قيامك بتأكيد طلبك في غضون سبعة أيام، سيتم رفض طلبك تلقائياً مما سيتطلب برفعك لطلب جديد. <br /> <br /> عند تأكيدك للحساب ستتمكن من الدخول للموقع باستخدام اسم المستخدم وكلمة المرور الخاصة بك.<br /><br />";

$pgv_lang["registernew"]			= "إقرار بإنشاء حساب جديد";
$pgv_lang["user_verify"]			= "التحقق من مستخدم";
$pgv_lang["send"]				= "إرسال";

$pgv_lang["pls_note07"] 			= "~#pgv_lang[user_verify]#~ <br /> <br /> لتأكيد طلب حسابك الجديد، يرجى ادخال اسم مستخدم وكلمة المرور،  مع رمز التحقق الذي تلقيته عن طريق البريد الإلكتروني.";
$pgv_lang["pls_note08"] 			= "<b> #user_name# </b> تم التحقق من البيانات الخاصة بالمستخدم .";

$pgv_lang["mail03_line01"]			= "مرحباً مدير النظام...";
$pgv_lang["mail03_line02"]			= "قام المستخدم  #newuser[username]# (#newuser[FULLNAME]#) بتأكيد طلبه للحصول على حساب.";
$pgv_lang["mail03_line03"]			= "الرجاء الضغط على الرابط أدناه لتسجيل الدخول إلى الموقع. يجب عليك تفعيل حساب المستخدم ليتمكن من الدخول للموقع.";
$pgv_lang["mail03_line03a"]			= "ليس عليك اتخاذ أي إجراء. يمكن للمستخدم تسجيل الدخول الآن.";
$pgv_lang["mail03_subject"] 		        = "مستخدم جديد في #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pls_note09"] 			= "لقد أكدت طلبك لمستخدم جديد بنجاح.";
$pgv_lang["pls_note10"] 			= "تم ابلاغ المسؤول. بمجرد أن يعطيك صلاحية للدخول، ستتمكن من الدخول للموقع مع اسم المستخدم وكلمة المرور.";
$pgv_lang["pls_note10a"]			= "يمكنك الدخول الآن مع اسم المستخدم وكلمة المرور.";
$pgv_lang["data_incorrect"] 		        = "البيانات المدخلة غير صحيحة، فضلاً المحاولة مرة أخرى";
$pgv_lang["user_not_found"] 		        = "لا يمكن التحقق من بيناتك المدخلة. يرجى المحاولة مرة أخرى أو الاتصال بمسؤول الموقع للمساعدة.";

$pgv_lang["lost_pw_reset"]			= "طلب للحصول على كلمة المرور المفقودة";
$pgv_lang["pls_note11"] 			= "لإعادة تعيين كلمة المرور الخاصة بك، أدخل اسم المستخدم الخاص بك. <br /> <br /> سنقوم بإرسال بريد إلكتروني إلى العنوان المسجل لدينا متضمنا رابط الكتروني ورمز التأكيد لحسابك. عند دخولك للرابط المذكور ستتمكن من تغيير كلمة المرور وتسجيل الدخول إلى هذا الموقع. لأسباب أمنية، يجب أن لا تعطي رمز التأكيد لأي شخص. <br /> <br /> إذا كنت تحتاج للمساعدة، يرجى النواصل مع المسؤول عبر الرابط أدناه.";

$pgv_lang["mail04_line01"]			= "مرحبا #user_fullname# ...";
$pgv_lang["mail04_line02"]			= "تم طلب كلمة مرور جديدة لاسم المستخدم الخاص بك.";
$pgv_lang["mail04_line03"]			= "توصية:";
$pgv_lang["mail04_line04"]			= "الرجاء الضغط على الرابط أدناه، ثم قم بتسجيل الدخول باستخدام كلمة المرور الجديدة، وتغييره فورا للحفاظ على أمن بياناتك .";
$pgv_lang["mail04_line05"]			= "بعد تسجيل الدخول، اضغط على رابط «#pgv_lang[editowndata]#» تحت قائمة «#pgv_lang[mygedview]#» وقم بتعبئة حقول كلمة المرور لتغيير كلمة المرور الخاصة بك.";
$pgv_lang["mail04_subject"] 		        = "طلب بيانات في #PGV_SERVER_NAME##PGV_SCRIPT_PATH#";

$pgv_lang["pwreqinfo"]				= "السلام عليكم...<br /><br />لقد تم إرسال بريد إلكتروني يحتوي على كلمة المرور الجديدة إلى العنوان المسجل لدينا للمستخدم <b>#user[email]#</b>.<br /><br />يرجى مراجعة حساب البريد الإلكتروني الخاص بك؛ ستتلقى رسالتنا قريباً<br /><br />توصية:<br />يرجى تسجيلك الدخول للموقع مع كلمة المرور الجديدة في أقرب وقت ممكن، كما نوصي بتغييرك لكلمة المرور للحفاظ على أمن البيانات الخاصة بك.";

$pgv_lang["myuserdata"] 			= "حسابي";
$pgv_lang["user_theme"] 			= "خلفية بوابتي";
$pgv_lang["mgv"]				= "بوابتي";
$pgv_lang["mygedview"]				= "بوابتي لشجرة العائلة";
$pgv_lang["passwordlength"] 		= "يجب أن تحتوي كلمة السر على ما لا يقل عن ٦ أحرف";
$pgv_lang["welcome_text_auth_mode_1"]	= "<span class='center'> <a class=\"title\" style=\"bold\"> مرحبا بكم في موقع أنساب العائلة </a> /span> <br /><br />  للاطلاع على بيانات شجرة العائلة ينبغي أن يكون لديك حساب مستخدم. <br /> <br /> إذا كان لديك حساب مستخدم، يمكنك تسجيل الدخول هنا. إذا لم يكن لديك حساب مستخدم، يمكنك تقديم طلب خلال النقر على الرابط أدناه. <br /> <br />  ومن ثم سيقوم مدير النظام بتفعيل حسابك بعد التحقق من بياناتك. سوف تتلقى رسالة بريد إلكتروني عندما يتم الموافقة على طلبك.";

$pgv_lang["welcome_text_auth_mode_2"]	= "<span class='center'><b>مرحبا بكم في موقع أنساب العائلة </b></span><br />Access to this site is permitted to <u>authorized</u> users only.<br /><br />إذا كان لديك حساب مستخدم، يمكنك تسجيل الدخول هنا. إذا لم يكن لديك حساب مستخدم، يمكنك تقديم طلب خلال النقر على الرابط أدناه.<br /><br />ومن ثم سيقوم مدير النظام بتفعيل حسابك بعد التحقق من بياناتك. سوف تتلقى رسالة بريد إلكتروني عندما يتم الموافقة على طلبك.";

$pgv_lang["welcome_text_auth_mode_3"]	= "<span class='center'><b>مرحبا بكم في موقع أنساب العائلة </b></span><br />Access to this site is permitted to <u>family members only</u>.<br /><br />إذا كان لديك حساب مستخدم، يمكنك تسجيل الدخول هنا. إذا لم يكن لديك حساب مستخدم، يمكنك تقديم طلب خلال النقر على الرابط أدناه.<br /><br />ومن ثم سيقوم مدير النظام بتفعيل حسابك بعد التحقق من بياناتك. سوف تتلقى رسالة بريد إلكتروني عندما يتم الموافقة على طلبك.";

$pgv_lang["welcome_text_cust_head"] 	= "<span class='center'><b>مرحبا بكم في موقع أنساب العائلة </b></span><br />للاطلاع على بيانات شجرة العائلة ينبغي أن يكون لديك حساب مستخدم وكلمة سر <br />";

$pgv_lang["acceptable_use"]		= "<br /><br /><br /><div class=\"largeError\">تنويه:</div><div class=\"error\">عند استكمالك وتقديم هذا النموذج، فإنك توافق على التالي:<ul><li>حماية بيانات والمحافظة على خصوصية الأشخاص المدرجة أسماؤهم في موقعنا،</li><li>تدوين علاقتك بالعائلة في خانة الملاحظات.</li></ul></div>";

//-- CONFIG FILE MESSAGES
$pgv_lang["yes"]          = "نعم";
$pgv_lang["no"]           = "لا";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["birth"]        = "الولادة:";
$pgv_lang["death"]        = "الوفاة:";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["male"]         = "ذكر";
$pgv_lang["female"]       = "أنثي";
$pgv_lang["name"]         = "اسم";
$pgv_lang["given_name"]   = "الاِسم الأول:";
$pgv_lang["surname"]      = "إسم العائلة:";
$pgv_lang["sex"]          = "الجنس";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "العمر";
$pgv_lang["husb_age"]			= "عمر الزوج";
$pgv_lang["wife_age"]			= "عمر الزوجة";
$pgv_lang["year1"]			= "سنة";
$pgv_lang["years2"]			= "سنين";	// For Polish 2,3,4 or 22,23,24 or 32,33,34 etc.
$pgv_lang["years"]			= "سنين";
$pgv_lang["month1"]			= "شهر";
$pgv_lang["months"]			= "أشهر";
$pgv_lang["week1"]			= "أسبوع";
$pgv_lang["weeks"]			= "أسابيع";
$pgv_lang["day1"]			= "يوم";
$pgv_lang["days"]			= "أيام";
$pgv_lang["after_death"]        	= "بعد الوفاة";
$pgv_lang["at_death_day"]      		= "في تاريخ الوفاة";
$pgv_lang["timeline_title"] 		= "الجدول الزمني";
$pgv_lang["timeline_chart"] 		= "رسم الجدول الزمني";
$pgv_lang["remove_person"]		= "حذف شخص";
$pgv_lang["show_age"]			= "إظهار مؤشر العمر";
$pgv_lang["add_another"]		= "إضافة الشخص التالي للرسم البياني:<br />رقم المعرف :";
$pgv_lang["find_id"]			= "العثور على رقم المعرف";
$pgv_lang["show"]			= "إظهار";
$pgv_lang["year"]			= "سنة:";
$pgv_lang["zoom_in"]			= "تكبير";
$pgv_lang["zoom_out"]			= "تصغير";
$pgv_lang["timeline_beginYear"]         = "يبتدئ في عام";
$pgv_lang["timeline_endYear"]           = "ينتهي في عام";
$pgv_lang["timeline_scrollSpeed"]       = "سرعة";
$pgv_lang["timeline_controls"]          = "عناصر التحكم بالرسم الزمني";
$pgv_lang["include_family"]             = "تشمل الأسرة المباشرة";
$pgv_lang["lifespan_chart"]             = "رسم الأعمار";

//-- MONTH NAMES
$pgv_lang["jan"]          = "يناير";
$pgv_lang["feb"]          = "فبراير";
$pgv_lang["mar"]          = "مارس";
$pgv_lang["apr"]          = "ابريل";
$pgv_lang["may"]          = "مايو";
$pgv_lang["jun"]          = "يونيو";
$pgv_lang["jul"]          = "يوليو";
$pgv_lang["aug"]          = "اغسطس";
$pgv_lang["sep"]          = "سبتمبر";
$pgv_lang["oct"]          = "اكتوبر";
$pgv_lang["nov"]          = "نوفمبر";
$pgv_lang["dec"]          = "ديسمبر";

$pgv_lang["apx"]          = "زهاء تقريبا";

$pgv_lang["jan_1st"]      = "يناير";
$pgv_lang["feb_1st"]      = "فبراير";
$pgv_lang["mar_1st"]      = "مارس";
$pgv_lang["apr_1st"]      = "ابريل";
$pgv_lang["may_1st"]      = "مايو";
$pgv_lang["jun_1st"]      = "يونيو";
$pgv_lang["jul_1st"]      = "يوليو";
$pgv_lang["aug_1st"]      = "اغسطس";
$pgv_lang["sep_1st"]      = "سبتمبر";
$pgv_lang["oct_1st"]      = "اكتوبر";
$pgv_lang["nov_1st"]      = "نوفمبر";
$pgv_lang["dec_1st"]      = "ديسمبر";

$pgv_lang["muhar"]        = "محرّم";
$pgv_lang["safar"]        = "صفر";
$pgv_lang["rabia"]        = "ربيع الأول";
$pgv_lang["rabit"]        = "ربيع الثانى";
$pgv_lang["jumaa"]        = "جمادى الأول";
$pgv_lang["jumat"]        = "جمادى الثاني";
$pgv_lang["rajab"]        = "رجب";
$pgv_lang["shaab"]        = "شعبان";
$pgv_lang["ramad"]        = "رمضان";
$pgv_lang["shaww"]        = "شوّال";
$pgv_lang["dhuaq"]        = "ذو القعدة";
$pgv_lang["dhuah"]        = "ذو الحجة";

$pgv_lang["sunday"]       = "الأحد";
$pgv_lang["monday"]       = "الأثنين";
$pgv_lang["tuesday"]      = "الثلاثاء";
$pgv_lang["wednesday"]    = "الأربعاء";
$pgv_lang["thursday"]     = "الخميس";
$pgv_lang["friday"]       = "الجمعه";
$pgv_lang["saturday"]     = "السبت";

$pgv_lang["sunday_1st"]   = "الأحد";
$pgv_lang["monday_1st"]   = "الأثنين";
$pgv_lang["tuesday_1st"]  = "الثلاثاء";
$pgv_lang["wednesday_1st"]= "الأربعاء";
$pgv_lang["thursday_1st"] = "الخميس";
$pgv_lang["friday_1st"]   = "الجمعه";
$pgv_lang["saturday_1st"] = "السبت";

$pgv_lang["clustrmaps_locations"]	= "مواقع زوار الصفحة";
$pgv_lang["sortby"]			= "الترتيب";
$pgv_lang["begins_with"]		= "يبدأ ب";
$pgv_lang["contains"]			= "يحتوي على";
$pgv_lang["advanced_search"] 		= "بحث متقدم";
$pgv_lang["more_fields"]		= "إضافة خانات جديدة";
$pgv_lang["load_full_tree"]		= "مشاهدة الشجرة التفاعلية في كامل الصفحة";
$pgv_lang["hide_show_spouses"]		= "إظهار أو إخفاء تعدد الأزواج";
$pgv_lang["interactive_tree"]		= "الشجرة التفاعلية";
$pgv_lang["example"]			= "مثال:";
$pgv_lang["tree"]			= "شجرة";
$pgv_lang["showUnknown"]		= "إظهار مجهولي الجنس";
$pgv_lang["count"]			= "العدد";
$pgv_lang["age_differences"]		= "إظهار الفرق بالتواريخ";
$pgv_lang["switch_lifespan"]		= "الرسم البياني للأعمار";
$pgv_lang["switch_timeline"]		= "الرسم البياني للجدول الزمني";
$pgv_lang["charts_block"]		= "صندوق الرسم البياني";
$pgv_lang["charts_block_descr"]		= "تمكنك صناديق الرسومات البيانية من وضع رسم بياني على الصفحة الترحيبية أو صفحة بوابتك الخاصة. يمكنك تكوين كتلة لتظهر الأجداد، نسل ، أو عرض الساعة الرملية . يمكنك أيضا اختيار الشخص الجذري للرسم البياني.";
$pgv_lang["hadith_block"]		= "صندوق الحديث النبوي الشريف";
$pgv_lang["hadith_block_descr"]		= "يعرض صندوق الحديث النبوي الشريف حديث للرسول صلى الله عليه وسلم يخص الأنساب";
$pgv_lang["charts_click_box"]		= "انقر على أي من المربعات للحصول على مزيد من المعلومات المتعلقة بهذا الشخص.";
$pgv_lang["chart_type"]			= "نوع الرسم البياني";
$pgv_lang["invalid_search_input"] 	= "الرجاء إدخال الاسم الأول والآخر ، أو المكان بالإضافة إلى السنة";
$pgv_lang["duplicate_username"] 	= "اسم المستخدم متكرر. يوجد مستخدم آخر بنفس اسم المستخدم. الرجاء اختيار اسم مستخدم آخر";
$pgv_lang["activate"]		        = "تفعيل";
$pgv_lang["enter_email"]		= "يجب إدخال عنوان البريد الإلكتروني.";
$pgv_lang["enter_fullname"] 		= "يجب إدخال الاسم الأول واسم العائلة ";
$pgv_lang["name"]			= "الإسم";
$pgv_lang["names"]			= "الأسماء";
$pgv_lang["welcome"]			= "مرحباً بك";
$pgv_lang["son"]			= "ابن";
$pgv_lang["daughter"]			= "ابنة";
$pgv_lang["editowndata"]		= "إدارة حسابي";
$pgv_lang["result_page"]		= "صفحة النتائج";
$pgv_lang["ex-wife"]                    = "زوجة سابقة";
$pgv_lang["ex-husband"]                 = "زوج سابق";
$pgv_lang["stat_avg_age_at_death"]	= "متوسط الأعمار عند الوفاة";
$pgv_lang["cancel"]			= "الغاء";
$pgv_lang["delete_family"]		= "حذف عائلة";
$pgv_lang["halfbrother"]		= "أخ غير شقيق";
$pgv_lang["halfsister"]			= "أخت غير شقيقة";
$pgv_lang["update_name"]                = "تعديل الاسم";
$pgv_lang["stepdad"]			= "زوج الأم";
$pgv_lang["stepmom"]			= "زوجة الأب";
$pgv_lang["page_help"]			= "المساعدة";
$pgv_lang["qm"] 			= "؟";
$pgv_lang["qm_ah"]			= "؟";
$pgv_lang["grandchildren"]		= "الأحفاد";
$pgv_lang["choose_username"]		= "اسم المستخدم المرغوب";
$pgv_lang["firstname"]			= "الاسم الأول";
$pgv_lang["lastname"]			= "اسم العائلة";
$pgv_lang["password"]			= "كلمة السر";
$pgv_lang["confirm"]			= "تأكيد كلمة السر";
$pgv_lang["login"]			= "تسجيل دخول";
$pgv_lang["logout"] 			= "تسجيل خروج";
$pgv_lang["parents"]			= "الوالدين";
$pgv_lang["gparents"]			= "الأجداد";
$pgv_lang["siblings"]			= "الإخوة";
$pgv_lang["father"] 			= "الوالد";
$pgv_lang["mother"] 			= "الوالدة";
$pgv_lang["father_age"]			= "عمر الوالد";
$pgv_lang["mother_age"]			= "عمر الوالدة";
$pgv_lang["enter_person_generations"] = "عدد الأجيال:";
$pgv_lang["other_searches"]		= "بحث آخر";
$pgv_lang["add_to_cart"]		= "أضف الى سلة قصاصات الشجرة";
$pgv_lang["view_gedcom"]		= "عرض سجل GEDCOM الخاص به";
$pgv_lang["welcome_page"]		= "الرئيسية";
$pgv_lang["user_admin"] 		= "إدارة المستخدمين";
$pgv_lang["manage_media"]		= "إدارة ملفات الوسائط المتعددة المرتبطة";
$pgv_lang["search_general"]		= "بحث عام";
$pgv_lang["clipping_privacy"]		= "لا يمكن إضافة بعض العناصر نظرا لقيود الخصوصية";
$pgv_lang["chart_new"]			= "شجرة العائلة";
$pgv_lang["loading"]			= "جاري التحميل...";
$pgv_lang["clear_chart"]		= "مسح الرسم البياني";
$pgv_lang["file_information"]		= "معلومات الملف";
$pgv_lang["choose_file_type"]		= "نوع الملف";
$pgv_lang["add_individual_by_id"]	= "إضافة شخص باستخدام رقم المعرف";
$pgv_lang["advanced_options"]		= "خيارات متقدمة";
$pgv_lang["zip_files"]			= "الملفات المضغوطة";
$pgv_lang["include_media"]		= "تشمل ملفات الوسائط المتعددة (سيتم تحويل الملفات إلى ملف مضغوط)";
$pgv_lang["roman_surn"]			= "اسم العائلة بالانجليزية";
$pgv_lang["roman_givn"]			= "الاسم الأول بالانجليزية";
$pgv_lang["include"]			= "تتضمن:";
$pgv_lang["page_x_of_y"]		= " الصفحة #GLOBALS[currentPage]#  من #GLOBALS[lastPage]#";
$pgv_lang["options"]			= "خيارات:";
$pgv_lang["config_update_ok"]		= "تم تحديث الإعدادات بنجاح";
$pgv_lang["page_size"]			= "حجم الصفحة";
$pgv_lang["font"]			= "الخط";
$pgv_lang["use_colors"]			= "إستخدام ألوان";
$pgv_lang["record_not_found"]		= "تعذر العثور على السجل المطلوب. قد يكون سبب ذلك هو رابط غير صالح لشخص في الشجرةأو تلف في ملف  الشجرة.";
$pgv_lang["edit_media"]			= "تعديل ملف الوسائط المتعددة  (#GLOBALS[pid]#)";
$pgv_lang["wiki_main_page"]		= "صفحة Wiki الرئيسية";
$pgv_lang["wiki_users_guide"]		= "دليل المستخدم للموقع";
$pgv_lang["wiki_admin_guide"]		= "دليل مدير النظام للموقع";
$pgv_lang["no_search_for"]		= "فضلاً تأكد من تحديد خيارات البحث .";
$pgv_lang["no_search_site"]		= "يرجى تحديد موقع واحد على الأقل .";
$pgv_lang["search_sites"] 		= "بحث المواقع التالية";
$pgv_lang["site_list"]			= "الموقع: ";
$pgv_lang["site_had"]			= " تشتمل على الآتي";
$pgv_lang["label_search_engine_detected"]  = "تم العثور على عنكبوت محرك البحث";

$pgv_lang["noemail"] 			= "عنواين لا تحتوي على بريد الكتروني";
$pgv_lang["onlyemail"] 			= "فقط عنواين تحتوي على بريد الكتروني";
$pgv_lang["maxviews_exceeded"]		= "تم تجاوز معدل عرض الصفحات المسموح  #GLOBALS[MAX_VIEWS]# في #GLOBALS[MAX_VIEW_TIME]# ثواني.";
$pgv_lang["broadcast_not_logged_6mo"]	= "مراسلة المستخدمين الذين لم يقوموا بتسجيل الدخول منذ ٦ أشهر";
$pgv_lang["broadcast_never_logged_in"]	= "مراسلة المستخدمين الذين لم يقوموا بتسجيل الدخول أبدا ";
$pgv_lang["stats_to_show"]		= "تحديد الإحصائات التي تود إظهارها في هذا الصندوق";
$pgv_lang["stat_longest_life"]		= "الشخص الذي عاش أطول مدة";
$pgv_lang["stat_most_children"]		= "الأسرة التي لديها أكبر عدد من الأولاد";
$pgv_lang["stat_average_children"]	= "متوسط عدد الأولاد لكل عائلة";
$pgv_lang["stat_events"]		= "إجمالي عدد الأحداث";
$pgv_lang["stat_media"]			= "عناصر ملفات الوسائط المتعددة";
$pgv_lang["stat_surnames"]		= "إجمالي عدد العوائل";
$pgv_lang["stat_users"]			= "إجمالي عدد المستخدمين";
$pgv_lang["no_family_facts"]		= "لا توجد معلومات متعلقة بهذه الأسرة";
$pgv_lang["stat_males"]			= "الذكور";
$pgv_lang["stat_females"]		= "الإناث";
$pgv_lang["stat_unknown"]		= "مجهولي الجنس";
$pgv_lang["stat_link"]			= "عرض الإحصائات على شكل رسومات بيانية";
$pgv_lang["print_stat_link"]		= "اظهار الرابط للرسوم البيانية الإحصائية؟";


$pgv_lang["edit_source"]		= "تعديل المصادر";
$pgv_lang["edit_shared_note"]		= "تعديل الملاحظات المشتركة";
$pgv_lang["familybook_chart"]		= "رسم دفتر العائلة";
$pgv_lang["family_of"]			= "أسرة من &nbsp;";
$pgv_lang["descent_steps"]		= "مرتبات النسب";

$pgv_lang["cookie_help"]	        = "يستخدم الموقع الكوكيز لتعقب حالة تسجيل الدخول الخاصة بك. <br /> <br /> ولكن إعدادات الكوكيز غير مفعلة لديك في المتصفح. يجب عليك تفعيل الكوكيز في المتصفح قبل أن تتمكن من تسجيل الدخول.";

//new stuff
//Individual
$pgv_lang["indi_is_remote"]	      = "وتم ربط المعلومات الخاصة بهذا الشخص عن طريق موقع خارجي.";
$pgv_lang["link_remote"]              = "ربط شخص خارجي"; //Link remote person?
//Add Remote Link
$pgv_lang["title_search_link"]        = "إضافة رابط محلي";
$pgv_lang["label_site_url2"]          = "رابط الموقع";
//new stuff

$pgv_lang["delete_family_confirm"]	= " سيتم فك ارتباط جميع أفراد هذه العائلة عن بعضهم البعض كنتيجة لحذف اسم العائلة دون حذف الأفراد. هل متأكد أنك تريد حذف هذه العائلة ؟";
$pgv_lang["add_favorite"]		= "إضافة مفضلة جديدة";
$pgv_lang["url"]			= "رابط";
$pgv_lang["add_fav_enter_note"]		= "أدخل ملاحظة اختيارية متعلقة بهذه المفضلة";
$pgv_lang["add_fav_or_enter_url"]	= "OR<br />\nEnter a URL and a title";
$pgv_lang["add_fav_enter_id"]		= "الرجاء إدخال شخص أو عائلة أو معرف لمصدر";
$pgv_lang["next_email_sent"]		= "سيتم إرسال بريد إلكتروني تذكيري بعد";
$pgv_lang["last_email_sent"]		= "تم إرسال آخر بريد الكتروني تذكيري في";
$pgv_lang["remove_child"]		= "حذف هذا الولد من الأسرة";
$pgv_lang["link_new_husb"]		= "إضافة الزوج باستخدام شخص موجود";
$pgv_lang["link_new_wife"]		= "إضافة الزوجة باستخدام شخص موجود";
$pgv_lang["address_labels"]		= "ملصقات بريدية";
$pgv_lang["filter_address"]		= "إظهار العنواوين المشتملة على:";
$pgv_lang["address_list"]		= "قائمة العناوين";
$pgv_lang["index_edit_advice"]		= "قم باختيار اسم الصندوق المرغوب، ثم انقر على أحد الأسهم لتحريك الصندوق المختار في الاتجاه المشار إليه.";
$pgv_lang["changelog"]			= "#VERSION# تغييرات النسخة";
$pgv_lang["html_block_descr"]		= "يستخدم صندوق HTML المبسط لإضافة أي رسالة مرغوبة على الصفحة الخاصة بك .";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>ضع عنوانك هنا</b></p><br /><p>يرجى الضغط على زر الاعدادات";
$pgv_lang["html_block_sample_part2"]	= "لتغيير ما هو مكتوب هنا.</p>";


$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Advanced HTML";
$pgv_lang["htmlplus_block_descr"]	= "يستخدم صندوق HTML   كما يمكنك من إدراج روابط إلى معلومات محددة متواجدة في ملف GEDCOM الخاص بك في نص HTML.. لإضافة أي رسالة مرغوبة على الصفحة الخاصة بك .";
$pgv_lang["htmlplus_block_templates"]   = "نماذج";
$pgv_lang["htmlplus_block_content"]     = "المحتوى";
$pgv_lang["htmlplus_block_narrative"]   = "Narrative style (English only)";
$pgv_lang["htmlplus_block_custom"]	= "Custom";
$pgv_lang["htmlplus_block_keyword"]	= "Keyword Examples (English only)";
$pgv_lang["htmlplus_block_taglist"]	= "Tag List";
$pgv_lang["htmlplus_block_compat"]	= "Compatibility Mode";
$pgv_lang["htmlplus_block_ui"]		= "الواجهة الموسعة";
$pgv_lang["htmlplus_block_current"]	= "الحالي";
$pgv_lang["htmlplus_block_default"]	= "الاافتراضي";
$pgv_lang["htmlplus_block_gedcom"]	= "شجرة عائلة";
$pgv_lang["htmlplus_block_birth"]	= "ولادة";
$pgv_lang["htmlplus_block_death"]	= "وفاة";
$pgv_lang["htmlplus_block_marrage"]	= "زواج";
$pgv_lang["htmlplus_block_adoption"]    = "تبني";
$pgv_lang["htmlplus_block_burial"]	= "دفن";
$pgv_lang["htmlplus_block_census"]	= "تم إضافة الإحصاء السكاني"; //census added?
$pgv_lang["num_to_show"]		= "عدد العناصر المعروضة";
$pgv_lang["days_to_show"]		= "عدد الأيام المعروضة";
$pgv_lang["before_or_after"]		= "وضع تعداد قبل أو بعد الاسم؟";
$pgv_lang["before"]			= "قبل";
$pgv_lang["after"]			= "بعد";
$pgv_lang["config_block"]		= "Configure";
$pgv_lang["enter_comments"]		= "الرجاء إدخال علاقتك بالبيانات في حقل الملاحظات.";
$pgv_lang["comments"]			= "ملاحظات";
$pgv_lang["child-family"]		= "الوالدين والإخوة";
$pgv_lang["spouse-family"]		= "الزوج والأولاد";
$pgv_lang["direct-ancestors"]		= "الأسلاف ذات العلاقة المباشرة";
$pgv_lang["ancestors"]			= "الأسلاف المباشرين وأسرهم";
$pgv_lang["descendants"]		= "السلالة";
$pgv_lang["choose_relatives"]		= "اختيار الأقارب";
$pgv_lang["relatives_report"]		= "تقارير الأقارب";
$pgv_lang["total_unknown"]		= "غير معروفين";
$pgv_lang["total_living"]		= "أحياء";
$pgv_lang["total_dead"]			= "أموات";
$pgv_lang["remove_custom_tags"]		= "Remove custom PGV tags? (eg. _PGVU, _THUM)";
$pgv_lang["fams_with_surname"]		= "الأسر ذات اللقب #surname#";
$pgv_lang["support_contact"]		= "التواصل مع الدعم التقني";
$pgv_lang["genealogy_contact"]		= "التواصل مع مشرف شجرة الأنساب";
$pgv_lang["common_upload_errors"]	= "هذا الخطأ يعني بان الملف الذي حاولت تحميله غالباً تجاوز الحجم المسموح وهو ٢ ميجابايت. يمكنك التواصل مع الدعم لزيادة الحد أو تحميل الملف باستخدام FTP. يمكنك اضافة الملف الذي قمت بتحميله عن طريق <a href=\"uploadgedcom.php؟action=add_form\"> <b>  باستخدام FTP.";
$pgv_lang["total_memory_usage"]		= "كمية الذاكرة المستخدمة :";
$pgv_lang["mothers_family_with"]	= "عائلة الأم المشتركة مع ";
$pgv_lang["fathers_family_with"]	= "عائلة الأب المشتركة مع";
$pgv_lang["family_with"]		= "العائلة المشتركة مع";
$pgv_lang["halfsibling"]		= "اخوة غير أشقاء";
$pgv_lang["family_timeline"]		= "إظهار العائلة في رسم الجدول الزمني";
$pgv_lang["children_timeline"]		= "إظهار الأولاد على الرسم البياني الزمني";
$pgv_lang["other"]			= "خيارات آخرى";
$pgv_lang["others"]			= "آخرين";
$pgv_lang["sort_by_marriage"]		= "ترتيب بحسب تاريخ الزواج";
$pgv_lang["reorder_families"]		= "إعادة تصنيف العوائل";
$pgv_lang["indis_with_surname"]		= "الأفراد من عائلة: #surname#";
$pgv_lang["first_letter_name"]		= "اختر حرف لإظهار جميع أسماء العوائل التي تبدأ بهذا الحرف";
$pgv_lang["first_letter_sfname"]	= "اختر حرف لإظهار الأسر التي يكون فيها اسم الزوج يبدأ بهذا الحرف.";
$pgv_lang["first_letter_iname"]		= "اختر حرف لإظهار الأفراد الذين تبدأ أسماء عوائلهم بهذا الحرف.";
$pgv_lang["first_letter_fname"]		= "اختر حرف لإظهار الأفراد الذين تبدأأسماءهم بهذا الحرف.";
$pgv_lang["total_names"]		= "إجمالي الأسماء";
$pgv_lang["total_changes"]		= "إجمالي التغيرات";
$pgv_lang["total_links"]		= "إجمالي عدد الروابط";
$pgv_lang["top10_pageviews_nohits"]	= "لا يوجد أي زوار للموقع حتى الآن";
$pgv_lang["top10_pageviews_msg"]	= "يجب تفعيل عدادات زوار الموقع في من خلال إعدادات ملف شجرة العائلة، في القسم الخاص بالعرض والتصميم.";
$pgv_lang["review_changes_descr"]	= "يعرض صندوق قيد التغييرات لأصحاب الصلاحية قائمة بالسجلات التي تم تعديلها من قبل المستخدمين والتي لا تزال بحاجة إلى مراجعة أو موافقة صاحب الصلاحية. وتعتبر هذه التغييرات معلقة الى حين القبول أو الرفض. <br /> <br /> في حال تم تفعيل هذا الصندوق، سيتلقى صاحب الصلاحية رسالة بريد إلكتروني في كل يوم بقائمة التغييرات التي تتطلب مراجعتهم.";
$pgv_lang["review_changes_block"]	= "التغيرات المعلقة";
$pgv_lang["review_changes_email"]	= "إرسال رسائل البريد الإلكتروني التذكيرية ؟";
$pgv_lang["review_changes_email_freq"]	= "معدل إرسال الايميلات تذكيرية (بالأيام)";
$pgv_lang["review_changes_subject"]	= "مراجعة التغييرات في شجرة العائلة";
$pgv_lang["review_changes_body"]	= "تم إجراء تعديلات لقاعدة بيانات الأنساب. تتطلب هذه التعديلات مراجعة من قبل صاحب الصلاحية ومن ثم قبولها لكي تظهر التعديلات لجميع المستخدمين. الرجاء استخدام الرابط أدناه للدخول الى الموقع ومراجعة التعديلات.";
$pgv_lang["show_pending"]		= "إظهار جميع طلبات التعديل";
$pgv_lang["show_spouses"]		= "إظهار الأزواج";
$pgv_lang["quick_update_title"]         = "تحديث سريع";
$pgv_lang["quick_update_instructions"] = " تسمح لك هذه الصفحة بتحديث معلومات المتعلقة بالفرد بسرعة. ما عليك سوى تعبئة البيانات الجديدة. ومن ثم سيتم مراجعة التغيرات من قبل مدير النظام من قبل أن تظهر في الموقع.";
$pgv_lang["update_fact"]                = "تحديث معلومة";
$pgv_lang["update_fact_restricted"]     = "تحديث هذه الحقائق مقتصر على :";
$pgv_lang["select_fact"]               = "اختر معلومة...";
$pgv_lang["update_address"]             = "تحديث العنوان";
$pgv_lang["top10_pageviews_descr"]	= "يعرض هذا الصندوق السجلات ال١٠ الأكثر مشاهدة. يتطلب استخدام هذا الصندوق تمكين عدادات زوار الموقع في إعدادات  GEDCOM.";
$pgv_lang["top10_pageviews"]		= "العناصر الأكثر مشاهدة هي:";
$pgv_lang["top10_pageviews_block"]	= "السجلات الأكثر مشاهدة هي";
$pgv_lang["stepparent"]			= "زوج الأم أو الأب";
$pgv_lang["stepsister"]			= "ابنة زوج الأم أو الأب";
$pgv_lang["stepbrother"]		= "ابن زوج الأم أو الأب";
$pgv_lang["fams_charts"]		= "الخيارات المتاحة للعوائل";
$pgv_lang["indis_charts"]		= "الخيارات المتاحة للأفراد";
$pgv_lang["none"]			= "لا يوجد";
$pgv_lang["facts"]			= "الحقائق";
$pgv_lang["locked"]			= "لا تغير";
$pgv_lang["privacy"]			= "الخصوصية";
$pgv_lang["number_sign"]		= "#";


//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]	= "عرض التفاصيل...";
$pgv_lang["view_fam_nav_notes"]		= "عرض الملاحظات...";
$pgv_lang["view_fam_nav_sources"]	= "عرض المصادر...";
$pgv_lang["view_fam_nav_media"]		= "عرض ملفات الوسائط المتعددة المرتبطة بالشخص...";
$pgv_lang["view_fam_nav_album"]		= "عرض ألبوم...";
$pgv_lang["view_fam_nav_relatives"]	= "عرض الأقارب...";
$pgv_lang["view_fam_nav_tree"]		= "عرض الشجرة...";
$pgv_lang["view_fam_nav_research"]	= "عرض الأبحاث المتعلقة ب...";
$pgv_lang["view_fam_nav_map"]		= "عرض الخريطة...";
$pgv_lang["view_fam_nav_spare"]		= "عرض المعلومات الإضافية الخاصة ب:";
$pgv_lang["navigator"]			= "Navigator";
$pgv_lang["fam_navigator"]		= "Family Navigator";

$pgv_lang["relationship_chart"] 	= "رسم للعلاقات";
$pgv_lang["person1"]				= "شخص ١";
$pgv_lang["person2"]				= "شخص ٢";
$pgv_lang["no_link_found"]			= "لا توجد علاقة تربط بين هاذين الشخصين";
$pgv_lang["no_other_link_found"]	= "لا توجد علاقة أخرى تربط بين هاذين الشخصين";
$pgv_lang["sibling"]			= "إخوة";
$pgv_lang["follow_spouse"]		= "بحث القرابة عن طريق الزواج";
$pgv_lang["timeout_error"]		= "تم انتهاء المهلة قبل التمكن من العثور على قرابة.";
$pgv_lang["grandson"]			= "حفيد";
$pgv_lang["granddaughter"]		= "حفيدة";
$pgv_lang["brother"]			= "أخ";
$pgv_lang["sister"] 			= "أخت";
$pgv_lang["aunt"]			= "عمة أو خالة";
$pgv_lang["uncle"]			= "عم أو خال";
$pgv_lang["nephew"]			= "ابن الأخ أو الأخت";
$pgv_lang["niece"]			= "ابنة الأخ أو الأخت";
$pgv_lang["relationship_to_me"] 	= "العلاقة بي";
$pgv_lang["rela_husb"]			= "العلاقة بالزوج";
$pgv_lang["rela_wife"]			= "العلاقة بالزوجة";
$pgv_lang["next_path"]			= "Find next path";
$pgv_lang["show_path"]			= "Show path";
$pgv_lang["line_up_generations"]	= "صف أعضاء الجيل الواحد في نفس الصف";
$pgv_lang["oldest_top"]			= "إظهار الأقدم في الأعلى";


$pgv_lang["mother_in_law"]		= "حماة";
$pgv_lang["father_in_law"]		= "حمو";
$pgv_lang["brother_in_law"]		= "أخو الزوج";
$pgv_lang["sister_in_law"]		= "أخت الزوج";
$pgv_lang["brothers_wife"]		= "زوجة الأخ"; // brother's wife
$pgv_lang["son_in_law"]			= "زوج الابنة";
$pgv_lang["daughter_in_law"]	         = "زوجة الابن";
$pgv_lang["step_son"]			= "ابن الزوج";
$pgv_lang["step_daughter"]		= "ابنة الزوج";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.

// 1st generation
$pgv_lang["bosa_brothers_offspring_2"]		= "ابن الأخ";             // brother's son
$pgv_lang["bosa_brothers_offspring_3"]		= "ابنة الأخ";              // brother's daughter

// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.

// 1st generation
$pgv_lang["bosa_sisters_offspring_2"]		= "ابن الأخت";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"]		= "ابنة الأخت";              // sister's daughter


// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.

// 1st generation
$pgv_lang["bosa_2"] 				= "ابن";                   // son
$pgv_lang["bosa_3"] 				= "ابنة";              // daughter


// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles

// 1st generation
$pgv_lang["sosa_uncle_2"] 		= "عم";            // father's brother
$pgv_lang["sosa_uncle_3"] 		= "خال";            // mother's brother

// 2nd generation
$pgv_lang["sosa_uncle_4"] 		= "عم الأب";      // fathers's father's brother
$pgv_lang["sosa_uncle_5"] 		= "خال الأب";      // father's mother's brother
$pgv_lang["sosa_uncle_6"] 		= "عم الأم";      // mother's father's brother
$pgv_lang["sosa_uncle_7"] 		= "خال الأم";      // mother's mother's brother

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts

// 1st generation
$pgv_lang["sosa_aunt_2"] 		= "عمة";            // father's sister
$pgv_lang["sosa_aunt_3"] 		= "خالة";            // mother's sister

// 2nd generation
$pgv_lang["sosa_aunt_4"] 		= "عمة الأب";      // fathers's father's sister
$pgv_lang["sosa_aunt_5"] 		= "خالة الأب";      // father's mother's sister
$pgv_lang["sosa_aunt_6"] 		= "عمة الأم";      // mother's father's sister
$pgv_lang["sosa_aunt_7"] 		= "خالة الأم";      // mother's mother's sister

//-- calendar.php messages
$pgv_lang["bdm"]				= "ولادات، وفيات، زواج";
$pgv_lang["on_this_day"]			= "في مثل هذا اليوم...";
$pgv_lang["in_this_month"]			= "في هذا الشهر...";
$pgv_lang["in_this_year"]			= "في هذه السنة...";
$pgv_lang["year_anniversary"]		        = "#year_var# الذكرى السنوية";
$pgv_lang["today"]				= "اليوم";
$pgv_lang["day"]				= "اليوم:";
$pgv_lang["month"]				= "الشهر:";
$pgv_lang["showcal"]				= "عرض الأحداث التالية";
$pgv_lang["anniversary"]			= "الذكرى السنوية";
$pgv_lang["anniversary_calendar"]	        = "تقويم الذكرى السنوية";
$pgv_lang["sunday"] 				= "الأحد";
$pgv_lang["monday"] 				= "الاثنين";
$pgv_lang["tuesday"]				= "الثلاثاء";
$pgv_lang["wednesday"]				= "الأربعاء";
$pgv_lang["thursday"]				= "الخميس";
$pgv_lang["friday"] 				= "الجمعة";
$pgv_lang["saturday"]				= "السبت";
$pgv_lang["viewday"]				= "أحداث اليوم";
$pgv_lang["viewmonth"]				= "أحداث الشهر";
$pgv_lang["viewyear"]				= "أحداث السنة";
$pgv_lang["all_people"] 			= "جميع الأشخاص";
$pgv_lang["living_only"]			= "الأشخاص الأحياء";
$pgv_lang["recent_events"]			= "السنوات الأخيرة (&lt; 100 yrs)";
$pgv_lang["day_not_set"]			= "لم يتم تحديد تاريخ";


//-- mygedview page
$pgv_lang["upcoming_events"]		= "الأحداث القادمة";
$pgv_lang["living_or_all"]		= "إظهار الأحداث المتعلقة بالأشخاص الأحياء فقط؟";
$pgv_lang["basic_or_all"]		= "حصر الأحداث بأحداث ولادة أو وفاة أو زواج؟";
$pgv_lang["style"]			= "نمط العرض";
$pgv_lang["style1"]			= "القوائم";
$pgv_lang["style2"]			= "جدول";
$pgv_lang["style3"]			= "Tagcloud";
$pgv_lang["sort_style"]			= "نوع التصنيف";
$pgv_lang["by_anniv"]			= "حسب الذكرى السنوية";
$pgv_lang["by_alpha"]			= "أبجديا";
$pgv_lang["cal_download"]		= "السماح بتحميل الأحداث التي في التقويم؟";
$pgv_lang["no_events_living"]		= "لا توجد أحداث للناس الأحياء في الأيام #pgv_lang[global_num1]#  المقبلة.";
$pgv_lang["no_events_living1"]		= "لا توجد أيةأحداث متعلقة بالأفراد الأحياء ليوم غد .";
$pgv_lang["no_events_all"]		= "لا توجد أي أحداث للأيام ال #pgv_lang[global_num1]# المقبلة.";
$pgv_lang["no_events_all1"]		= "لا توجد أحداث ليوم غد .";
$pgv_lang["no_events_privacy"]		= "توجد أحداث للأيام #pgv_lang[global_num1]# المقبلة، ولكن صلاحياتك لا تسمح برؤيتها.";
$pgv_lang["no_events_privacy1"]		= "توجد أحداث ليوم غد ، ولكن قيود الخصوصية تمنعك من رؤيتهم.";
$pgv_lang["more_events_privacy"]	= "<br /> يوجد المزيد من الأحداث للأيام #pgv_lang[global_num1]# المقبلة، ولكن صلاحياتك لا تسمح برؤيتها.";
$pgv_lang["more_events_privacy1"]	= "<br /> يوجد المزيد من الأحداث ليوم غد، ولكن صلاحياتك لا تسمح برؤيتها.";
$pgv_lang["none_today_living"]		= "لا توجد أيةأحداث للأفراد الأحياء لليوم .";
$pgv_lang["none_today_all"]		= "لا توجد أيةأحداث لليوم .";
$pgv_lang["none_today_privacy"]		= "توجد أحداث لليوم ، ولكن قيود الخصوصية تمنعك من رؤيتهم.";
$pgv_lang["more_today_privacy"]		= "<br />يوجد المزيد من الأحداث لهذا اليوم ، ولكن قيود الخصوصية تمنعك من رؤيتهم.";
$pgv_lang["chat"]			= "دردشة";
$pgv_lang["users_logged_in"]		= "المستخدمين المسجلين دخولاً";
$pgv_lang["anon_user"]			= "مستخدم ١ مجهول";
$pgv_lang["anon_users"]			= "#pgv_lang[global_num1]# عدد المستخدمين المجهولين الحاليين على الموقع";
$pgv_lang["login_user"]			= "مستخدم ١";
$pgv_lang["login_users"]		= "#pgv_lang[global_num1]# عدد المستخدمين المسجلين دخولاً حالياً";
$pgv_lang["no_login_users"]		= "لا يوجد أي مستخدمين على الموقع";
$pgv_lang["message"]			= "إرسال";
$pgv_lang["my_messages"]		= "صندوق رسائلي";
$pgv_lang["date_created"]		= "تاريخ الإرسال:";
$pgv_lang["message_from"]		= "عنوان البريد الاكتروني:";
$pgv_lang["message_from_name"]		= "اسمك:";
$pgv_lang["message_to"] 		= "المرسل إليه:";
$pgv_lang["message_subject"]		= "الموضوع:";
$pgv_lang["message_body"]		= "نص الرسالة:";
$pgv_lang["no_to_user"] 		= "لا يمكن الاستمرار بسبب عدم تحديد المرسل إليه";
$pgv_lang["provide_email"]		= "يرجى إدخال بريدك الإلكتروني لنتمكن من الرد على رسالتك وإلا فلن نتمك من الرد عليك.";
$pgv_lang["reply"]			= "رد";
$pgv_lang["message_deleted"]		= "تم حـذف الرسالة";
$pgv_lang["message_sent"]		= "تم إرسال الرسالة إلى المستخدم #TO_USER# بنجاح";
$pgv_lang["reset"]			= "مسح";
$pgv_lang["site_default"]		= "الإعدادات الأصلية للموقع";
$pgv_lang["mygedview_desc"] 		= "هذه الصفحة الخاصة بك بحيث تمكنك بوابتك الخاصة بشجرة العائلة من إنشاء قائمة بالأشخاص المفضلة لديك، وتتبع الأحداث المقبلة، ومشاركة المستخدمين الآخرين.";
$pgv_lang["no_messages"]		= "لا توجد أي رسائل جديدة";
$pgv_lang["clicking_ok"]		= "عند نقرك على كلمة موافق، سيتم فتح نافذة أخرى والتي ستمكنك من التواصل مع #user[fullname]#";
$pgv_lang["favorites"]			= "المفضلة";
$pgv_lang["my_favorites"]		= "قائمة المفضلة الخاصة بي";
$pgv_lang["no_favorites"]		= "لم تقم بتحديد المفضلة. <br /> <br /> لإضافة أي شخص، أو أسرة، أو مصدر إلى المفضلة لديك، اضغط على رابط <b>#pgv_lang[add_favorite]#</b> للكشف عن حقول تمكنك من البحث عن رقم معرف محدد.";
$pgv_lang["add_to_my_favorites"]	= "أضف إلى قائمة المفضلة";
$pgv_lang["gedcom_favorites"]		= "قائمة المفضلة الخاصة بشجرة العائلة";
$pgv_lang["kadhi_branches"]             = "أجداد فروع شجرة عائلة ";
$pgv_lang["no_gedcom_favorites"]	= "لا يوجد أية إضافات لقائمة المفضلة. بإمكان مدير النظام أن يضيف إلى هذه القائمة.";
$pgv_lang["confirm_fav_remove"] 	= "هل متأكد أنك تريد إزالة هذا العنصر من قائمة المفضلة؟";
$pgv_lang["invalid_email"]		= "يرجى إدخال عنوان بريد إلكتروني صالح";
$pgv_lang["enter_subject"]		= "يرجى إدخال موضوع الرسالة.";
$pgv_lang["enter_body"] 		= "الرجاء إدخال نص الرسالة قبل إرسالها .";
$pgv_lang["confirm_message_delete"]     = "هل أنت متأكد أنك تريد حذف هذه الرسالة؟ حيث لا يمكن استرجاعها لاحقاً .";
$pgv_lang["message_email1"] 		= "تم استلام الرسالة التالية على حساب المستخدم الخاص بك من";
$pgv_lang["message_email2"] 		= "تم إرسال الرسالة التالية إلي مستخدم نظام شجرة العائلة:";
$pgv_lang["message_email3"] 		= "تم إرسال الرسالة التالية إلي مدير نظام شجرة العائلة:";
$pgv_lang["viewing_url"]		= "تم إرسال هذه الرسالة أثناء التصفح على الصفحة التالية:";
$pgv_lang["messaging2_help"]		= "عند إرسالك لهذه الرسالة سوف تصلك نسخة من الرسالة على بريدك الاكتروني الذي قمت بإدخاله";
$pgv_lang["random_picture"] 		= "صورة عشوائية";
$pgv_lang["message_instructions"]	= "<b> الرجاء ملاحظة الآتي:  </b> سيتم منح صلاحية الاطلاع على المعلومات الخاصة للأقارب والمقربين فقط. سيتم التحقق من بياناتك من قبل اتاحة الاطلاع . <br /> <br />  . عند الاقدام على اجراء أي تعديلات على بيانات الأنساب أن تشتمل ذكر لمصادرالحصول على هذه البيانات. <br /> <br />";
$pgv_lang["sending_to"] 		= "سوف يتم إرسال هذه الرسالة إلى المستخدم #TO_USER#";
$pgv_lang["preferred_lang"] 		= "يرغب هذا المستخدم بتلقي الرسائل باللغة #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "تم إنشاء ملف شجرة العائلة باستخدام <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "تم إنشاء ملف شجرة العائلة في <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " في <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]		= "إحصاءات شجرة العائلة";
$pgv_lang["stat_individuals"]		= "الأفراد";
$pgv_lang["stat_families"]		= "العوائل";
$pgv_lang["stat_sources"]		= "المصادر";
$pgv_lang["stat_other"] 		= "سجلات أخرى";
$pgv_lang["stat_earliest_birth"] 	= "أقدم سنة ولادة";
$pgv_lang["stat_latest_birth"] 	        = "أحدث سنة ولادة";
$pgv_lang["stat_earliest_death"] 	= "أقدم سنة للوفاة";
$pgv_lang["stat_latest_death"] 	        = "أحدث سنة للوفاة";
$pgv_lang["customize_page"] 		= "تعديل بوابتي";
$pgv_lang["customize_gedcom_page"]	= "تعديل الصفحة الترحيبية";
$pgv_lang["customize_title"]            = "الصفحة الترحيبية";
$pgv_lang["upcoming_events_block"]	= "أحداث قادمة";
$pgv_lang["upcoming_events_descr"]	= "يعرض صندوق الأحداث القادمة الذكرى السنوية للأحداث التي ستحدث في المستقبل القريب. يمكنك تعديل مدى التفصيل للأحداث المعروضة.";
$pgv_lang["todays_events_block"]	= "أحداث حصلت في مثل هذا اليوم...";
$pgv_lang["todays_events_descr"]	= "يعرض صندوق أحداث حصلت في مثل هذا اليوم الخاص بك ... الذكرى السنوية لأحداث هذا اليوم. يمكنك تحديد كمية التفاصيل الظاهرة.";
$pgv_lang["todo_block"]                 = "مهمات &quot;To Do&quot;";
$pgv_lang["todo_descr"]                 = "يعرض صندوق قائمة المهمات جميع عناصر _TODO المعلقة في قاعدة البيانات.";
$pgv_lang["todo_show_other"]            = "إظهار مهام المستخدمين الآخرين";
$pgv_lang["todo_show_unassigned"]       = "عرض المهام التي لم توكل لأحد بعد";
$pgv_lang["todo_show_future"]           = "إظهار المهام المستقبلية";
$pgv_lang["todo_nothing"]               = "لا توجد مهام &quot;To Do&quot;.";
$pgv_lang["logged_in_users_block"]	= "المستخدمين الموجودين حاليا";
$pgv_lang["logged_in_users_descr"]	= " يظهر صندوق المستخدمين الموجودين حاليا لائحة المستخدمين الذين قاموا بتسجيل الدخول حاليا.";
$pgv_lang["user_messages_block"]	= "رسائل المستخدم";
$pgv_lang["user_messages_descr"]	= "يمكنك صندوق رسائل المستخدم من الاطلاع علي الرسائل المرسلة للمستخدم";
$pgv_lang["user_favorites_block"]	= "قائمة الأشخاص المفضلة ";
$pgv_lang["user_favorites_descr"]	= "يمكن صندوق قائمة الأشخاص المفضلة للمستخدم بالاطلاع على جميع الأشخاص المفضلين لديه في قاعدة البيانات.";
$pgv_lang["welcome_block"]		= "ترحيب الأعضاء";
$pgv_lang["welcome_descr"]		= "يعرض صندوق الأعضاءالترحيبي للمستخدم التاريخ والوقت الحالي، وروابط سريعة لتعديل حسابه أو لعرض مخطط النسب الخاصة به، بالإضافة الى رابط صفحته الخاصة.";
$pgv_lang["random_media_block"] 	= "الصور العشوائية";
$pgv_lang["random_media_descr"] 	= "يتم عن خلال صندوق الصور العشوائية عرض الصور عشوائيا أوالملفات الصوتية والصورية الأخرى من قاعدة البيانات المفعلة .";
$pgv_lang["random_media_persons_or_all"]= "عرض الأشخاص فقط، والأحداث، أم كل شيء؟";
$pgv_lang["random_media_persons"]	= "أشخاص";
$pgv_lang["random_media_events"]	= "أحداث";
$pgv_lang["gedcom_block"]		= "تعديل الصفحة الترحيبية";
$pgv_lang["gedcom_descr"]		= "يعرض صندوق تعديل الصفحة الترحيبية اسم قاعدة البيانات النشطة حاليا بالإضافة إلى التاريخ والوقت الحالي";
$pgv_lang["gedcom_favorites_block"]     = "مختارات شجرة العائلة المفضلة";
$pgv_lang["gedcom_favorites_descr"]     = " يمكن صندوق مختارات شجرة العائلة المفضلة مدير النظام من تحديد الأشخاص المهمة في قاعدة البيانات الشجرة بحيث تكون معلوماتهم متاحة بسهولة لجميع المستخدمين. فبهذا تكون وسيلة جيدة لتسليط الضوء على الأجداد المهمين في تاريخ عائلتك.";
$pgv_lang["gedcom_stats_block"] 	= "إحصائيات الشجرة";
$pgv_lang["gedcom_stats_descr"] 	= "يعرض صندوق إحصائيات الشجرة للزائر بعض المعلومات الأساسية حول قاعدة البيانات الشجرة، مثل تاريخ الانشاء، وعدد الأشخاص. <br /> <br /> كما أن كما يتم عرض أسماء العوائل الأكثر شيوعا في الشجرة .";
$pgv_lang["gedcom_stats_show_surnames"]	= "عرض أسماء العوائل الأكثر شيوعا؟";
$pgv_lang["portal_config_instructions"]	= "~#pgv_lang[customize_page]#~<br />~#pgv_lang[customize_gedcom_page]#~<br /><br /> يمكنك تعديل الصفحة عن طريق تغيير أماكن تواجد الصناديق على الصفحة. تنقسم الصفحة الى  <b>رئيسية</b> و <b>يمنى</b>. <br /> <br /> ولكل قسم قائمتها الخاصة من الصناديق المتوفرة للعرض على الصفحة وتحريكها حسب رغبتك. . <br /> <br />";
$pgv_lang["login_block"]		= "تسجيل دخول";
$pgv_lang["login_descr"]		= "صندوق تسجيل الدخول يسمح للمستخدمين بادخال اسم المستخدم و كلمة المرور.";
$pgv_lang["theme_select_block"] 	= "اختيار الخلفية";
$pgv_lang["theme_select_descr"] 	= "يعرض صندوق اختيار الخلفية الخيارات المتاحة لتغيير الخلفية حتى في حالة تعطيل امكانية تغيير الخلفية من قبل مدير النظام.";
$pgv_lang["block_top10_title"]		= "أكبر ١٠ عوائل";
$pgv_lang["block_top10"]		= "أكبر ١٠ عوائل";
$pgv_lang["block_top10_descr"]		= "يعرض هذا الصندوق قائمة أكبر ١٠ عوائل في قاعدة بيانات شجرة العائلة. وبإمكان مدير النظام تغيير عدد الأسماء التي تظهر";
$pgv_lang["block_givn_top10_title"]	= "أكثر ١٠ أسماء شيوعاً";
$pgv_lang["block_givn_top10"]		= "أكثر ١٠ أسماء شيوعاً";
$pgv_lang["block_givn_top10_descr"]	= "يعرض هذا الصندوق قائمة أكثر ١٠ أسماء شيوعاً في قاعدة البيانات. وبإمكان مدير النظام تغيير عدد الأسماء التي تظهر.";
$pgv_lang["kadhi_branches_block"]	= "فروع شجرة عائلة ";
$pgv_lang["kadhi_branches_descr"]	= "يعرض صندوق فروع شجرة العائلة أجداد كل فرع من العائلة لجميع المستخدمين.";
$pgv_lang["kadhi_branches_content"]	= "";
$pgv_lang["kadhi_welcome_block"]	= "ترحيب لموقع شجرة عائلة ";
$pgv_lang["kadhi_welcome_descr"]	= "يعرض صندوق ترحيب لموقع شجرة العائلة رسالة ترحيبية لجميع المستخدمين وتعريف بالعائلة.";
$pgv_lang["website_family_name"]        = "العائلة";

$pgv_lang["gedcom_news_block"]		= "أخبار شجرة العائلة";
$pgv_lang["gedcom_news_descr"]		= "يعرض صندوق أخبار شجرة العائلة للزوار أو المقالات التي نشرت من قبل مشرف المستخدم. <br /> <br /> كتلة أخبار هو مكان جيد للإعلان عن تحديث قاعدة بيانات هامة، لم شمل الأسرة، أو ولادة طفل.";
$pgv_lang["gedcom_news_limit"]		= "الحد الأقصى للعرض:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "بلا حدود";
$pgv_lang["gedcom_news_limit_date"]	= "تاريخ الخبر";
$pgv_lang["gedcom_news_limit_count"]	= "عدد الأخبار";
$pgv_lang["gedcom_news_flag"]		= "الحد الأقصى:";
$pgv_lang["gedcom_news_archive"] 	= "عرض الأرشيف";
$pgv_lang["user_news_block"]		= "دفتر يومية المستخدم";
$pgv_lang["user_news_descr"]		= "يتيح صندوق دفتر اليومية للمستخدم بتسجيل وحفظ مذكراته اليومية على الموقع .";
$pgv_lang["my_journal"] 		= "دفتر يومياتي";
$pgv_lang["no_journal"] 		= "لم تقم بإدخال أي إضافات في دفتر يومياتك";
$pgv_lang["confirm_journal_delete"]     = "هل متأكد أنك تريد حذف هذا العنصر من دفتر اليوميات ؟";
$pgv_lang["add_journal"]		= "إدخال إضافة لدفتر يومياتي";
$pgv_lang["gedcom_news"]		= "أخبار شجرة العائلة";
$pgv_lang["confirm_news_delete"]	= "هل أنت متأكد أنك تريد حذف هذه الإضافة من الأخبار؟";
$pgv_lang["add_news"]			= "إضافة مادة أخبار";
$pgv_lang["no_news"]			= "لم يتم إضافة مقالات للأخبار.";
$pgv_lang["edit_news"]			= "إضافة / تحرير لدفتر اليوميات و الأخبار";
$pgv_lang["enter_title"]		= "الرجاء إدخال عنوان";
$pgv_lang["enter_text"] 		= "الرجاء ادخال نص الإضافة أو الخبر";
$pgv_lang["news_saved"] 		= "تم حفظ الإضافة الجديدة بنجاح";
$pgv_lang["article_text"]		= "نص الإضافة:";
$pgv_lang["main_section"]		= "صناديق القسم الرئيسي";
$pgv_lang["right_section"]		= "صناديق القسم الأيمن";
$pgv_lang["available_blocks"]		= "الصناديق المتوفرة";
$pgv_lang["move_up"]			= "تحريك للأعلى";
$pgv_lang["move_down"]			= "تحريك للأسفل";
$pgv_lang["move_right"] 		= "تحريك لليمين";
$pgv_lang["move_left"]			= "تحريك لليسار";
$pgv_lang["broadcast_all"]		= "بث لجميع المستخدمين";
$pgv_lang["hit_count"]			= "عدد الزوار للموقع:";
$pgv_lang["phpgedview_message"] 	= "رسالة موقع الشجرة";
$pgv_lang["common_surnames"]		= "أكبر العوائل في الشجرة";
$pgv_lang["default_news_title"] 	= "مرحبا بكم في موقع شجرة العائلة";
$pgv_lang["default_news_text"]		= "تقدم هذه الصفحة مقدمة ونظرة عامة عن موقع شجرة العائلة. <br /> <br /> يمكنك الابتداء باختيار عرض احدى الرسوم البيانية، عرض القوائم الفردية، أو البحث عن اسم محدد. <br /> <br /> إذا واجهت مشكلة في استخدام الموقع، يمكنك الضغط على أيقونة المساعدة لإعطائك معلومات عن كيفية استخدام الصفحة المحددة. <br /> <br />شكرا لزيارتك للموقع.";
$pgv_lang["reset_default_blocks"]	= "إعادة الصناديق الى الأماكن الأصلية";
$pgv_lang["recent_changes"] 		= "آخر التعديلات";
$pgv_lang["recent_changes_block"]	= "آخر التعديلات";
$pgv_lang["recent_changes_descr"]	= "سيتم عن خلال صندوق آخر التعديلات سرد لكافة التغييرات التي تم إجراؤها على قاعدة البيانات في الشهر الماضي.";
$pgv_lang["recent_changes_none"]	= "لم تكن هناك أي تغييرات في الأيام ال #pgv_lang[global_num1]# الأخيرة. </b><br />";
$pgv_lang["recent_changes_some"]	= "التغييرات التي تم إجراؤها في خلال آخر #pgv_lang[global_num1]# أيام </b><br />";
$pgv_lang["show_empty_block"]		= "هل تريد إخفاء هذا الصندوق عندما يكون فارغاً؟";
$pgv_lang["hide_block_warn"]		= "عند قيامك بإخفاء صندوق فارغ، لن تتمكن من تغيير اعداداته الى حين أن يصبح مرئيا مرة أخرى كونه لم يعد فارغاً.";
$pgv_lang["delete_selected_messages"]	= "حذف الرسائل المحددة";
$pgv_lang["use_blocks_for_default"]	= "هل تود استخدام الصناديق المختارة كالوضع الافتراضي لكافة مستخدمي الموقع؟";
$pgv_lang["block_not_configure"]	= "لا يمكن تغيير اعدادات هذا الصندوق";


//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php

$pgv_lang["employee"]                   = "موظف";
$pgv_lang["employer"]                   = "مدير";
$pgv_lang["foster_child"]               = "طفل متبنى";
$pgv_lang["foster_father"]              = "والد المتبنى";
$pgv_lang["foster_mother"]              = "والدة المتبنى";
$pgv_lang["twin"]                       = "توأم";
$pgv_lang["twin_brother"]               = "أخ توأم";
$pgv_lang["twin_sister"]                = "أخت توأم";


//-- statistics utility
$pgv_lang["stat_create"]		= "إنشاء رسمك البياني الخاص بك";
$pgv_lang["statutci"]			= "تعذر انشاء الفهرس";
$pgv_lang["statnnames"]			= "عدد الأفراد";
$pgv_lang["statnfam"]			= "إجمالي عدد العوائل";
$pgv_lang["statnmale"]			= "إجمالي عدد الذكور";
$pgv_lang["statnfemale"]		= "إجمالي عدد الاناث";
$pgv_lang["with_sources"]		= "لديها مصادر";
$pgv_lang["without_sources"]	        = "بدون مصادر";
$pgv_lang["stat_sindi"]			= "أشخاص تحتوي سجلاتهم على مصادر";
$pgv_lang["stat_sfam"]			= "عوائل تحتوي سجلاتهم على مصادر";
$pgv_lang["statvars"]			= "قم بتعبئة البارامترات التالية للرسم";
$pgv_lang["statlxa"]			= "حدد نوع الرسم البياني:";
$pgv_lang["statlya"]			= "عرض النتائج:";
$pgv_lang["statlza"]			= "الفئات:";
$pgv_lang["map_type"]			= "نوع الخريطة";
$pgv_lang["stat_1_map"]			= "توزيع الأفراد";
$pgv_lang["stat_2_map"]			= "حسب دولة الولادة";
$pgv_lang["stat_3_map"]			= "حسب دولة الوفاة";
$pgv_lang["stat_4_map"]			= "حسب دولة الزواج";
$pgv_lang["stat_5_birth"]		= "الولادات في كل قرن";
$pgv_lang["stat_6_death"]		= "الوفيات في كل قرن";
$pgv_lang["stat_7_marr"]		= "الزواجات في كل قرن";
$pgv_lang["stat_7_div"]			= "حالات الطلاق في كل قرن";
$pgv_lang["stat_8_fam"]			= "عوائل تحتوي سجلاتهم على مصادر";
$pgv_lang["stat_9_indi"]		= "أشخاص تحتوي سجلاتهم على مصادر";
$pgv_lang["stat_10_none"]		= "لا يوجد";
$pgv_lang["stat_11_mb"]			= "شهر الولادة";
$pgv_lang["stat_12_md"]			= "شهر الوفاة";
$pgv_lang["stat_13_mm"]			= "شهر الزواج";
$pgv_lang["stat_14_mb1"]		= "شهر ولادة الطفل الأول";
$pgv_lang["stat_15_mm1"]		= "شهر أول زواج";
$pgv_lang["stat_16_mmb"]		= "عدد الأشهر فيما بين تاريخ الزواج وولادة أول ولد";
$pgv_lang["stat_17_arb"]		= "علاقة العمر بسنة الميلاد";
$pgv_lang["stat_18_ard"]		= "علاقة العمر بسنة الوفاة";
$pgv_lang["stat_18_aard"]		= "متوسط العمر في القرن المتوفي فيه";
$pgv_lang["stat_19_arm"]		= "العمر في سنة الزواج";
$pgv_lang["stat_19_aarm"]		= "متوسط العمر في القرن المتزوج فيه";
$pgv_lang["stat_20_arm1"]		= "العمر في سنة أول الزواج";
$pgv_lang["stat_21_nok"]		= "عدد الأولاد";
$pgv_lang["stat_22_fwok"]		= "عدد الأسر بدون أولاد";
$pgv_lang["stat_200_none"]		= "الكل (أو فارغة)";
$pgv_lang["stat_201_num"]		= "أرقام";
$pgv_lang["stat_202_perc"]		= "نسبة";
$pgv_lang["stat_300_none"]		= "لا يوجد";
$pgv_lang["stat_301_mf"]		= "الجنس";
$pgv_lang["stat_302_cgp"]		= "الفترات الزمنية";
$pgv_lang["century"]			= "قرن";
$pgv_lang["stat_age"]			= "عمر";
$pgv_lang["no_date_fam"]		= "غير معروف";
$pgv_lang["statar_xgp"]			= "حدود الفترات:";
$pgv_lang["statar_xgl"]			= "حدود الأعمار:";
$pgv_lang["statar_xgm"]			= "حدود الشهر:";
$pgv_lang["statar_xga"]			= "حدود الأرقام:";
$pgv_lang["statar_zgp"]			= "حدود فترات التاريخ:";
$pgv_lang["less"]			= "أقل من";
$pgv_lang["over"]			= "أكثر من";
$pgv_lang["interval"]			= "فاصل";
$pgv_lang["aft_marr"]			= "أشهر بعد الزواج";
$pgv_lang["bef_marr"]			= "أشهر قبل وبعد الزواج";
$pgv_lang["quarters"]			= "quarters after marriage";
$pgv_lang["half_year"]			= "half-year after marriage";
$pgv_lang["one_child"]			= "interval one child";
$pgv_lang["two_children"]		= "interval two children";
$pgv_lang["statreset"]			= "إعادة";
$pgv_lang["statsubmit"]			= "عرض الرسم";
$pgv_lang["stat_largest_families"]      = "أكبر العوائل";

$pgv_lang["stat_own_charts"]		= "الرسوم البيانية الخاصة";
$pgv_lang["statnliving"]		= "إجمالي عدد الأحياء";
$pgv_lang["statndead"]			= "إجمالي عدد المتوفيين";
$pgv_lang["stat_births"]		= "إجمالي عدد الولادات";
$pgv_lang["stat_marriages"]		= "إجمالي عدد حالات الزواج";
$pgv_lang["stat_divorces"]		= "إجمالي عدد حالات الطلاق";
$pgv_lang["stat_deaths"]		= "إجمالي الوفيات";
$pgv_lang["stat_first_birth"]		= "أقدم ولادة";
$pgv_lang["stat_first_marriage"]	= "أقدم زواج";
$pgv_lang["stat_first_divorce"]		= "أقدم طلاق";
$pgv_lang["stat_first_death"]		= "أقدم وفاة";
$pgv_lang["stat_last_birth"]		= "أحدث ولادة";
$pgv_lang["stat_last_marriage"]		= "أحدث زواج";
$pgv_lang["stat_last_divorce"]		= "أحدث طلاق";
$pgv_lang["stat_last_death"]		= "أحدث وفاة";
$pgv_lang["stat_lifespan"]		= "عمر";
$pgv_lang["stat_lived_longest"]		= "أكبر سن عند الوفاة";
$pgv_lang["stat_live_longest"]		= "أكبر شخص سناً مازال حياً";
$pgv_lang["stat_marr_age"]		= "مدة الزواج";
$pgv_lang["stat_long_marr_age"]		= "أطول مدة زواج";
$pgv_lang["stat_short_marr_age"]	= "أقصر مدة زواج";
$pgv_lang["stat_youngest_male"]		= "أصغر ذكر سناً";
$pgv_lang["stat_youngest_female"]	= "أصغر أنثى سناً";
$pgv_lang["stat_oldest_male"]		= "أكبر ذكر سناً";
$pgv_lang["stat_oldest_female"]		= "أكبر أنثى سناً";
$pgv_lang["stat_childbirth_age"]	= "العمر عند ولادة الابن/ الابنة";
$pgv_lang["stat_youngest_father"]	= "أصغر أب سناً";
$pgv_lang["stat_youngest_mother"]	= "أصغر أم سناً";
$pgv_lang["stat_oldest_father"]		= "أكبر أب سناً";
$pgv_lang["stat_oldest_mother"]		= "أكبر أم سناً";
$pgv_lang["stat_children_in_fam"]	= "عدد الأولاد في الأسرة";
$pgv_lang["stat_largest_gfamilies"]	= "أكبر أسرة حسب عدد الأحفاد";
$pgv_lang["stat_age_difference"]	= "فارق العمر";
$pgv_lang["stat_age_siblings"]		= "فارق العمر بين الإخوة";
$pgv_lang["stat_top_age_siblings"]	= "أكبر فارق عمر بين الإخوة";
$pgv_lang["stat_age_mf_spouse"]		= "فارق العمر بين الزوج وزوجه";
$pgv_lang["stat_age_fm_spouse"]		= "فارق العمر بين الزوجة وزوجها";
$pgv_lang["stat_names"]			= "الأسماء";
$pgv_lang["statnsurnames"]		= "إجمالي عدد العوائل";
$pgv_lang["statngivennames"]		= "إجمالي عدد الأسماء";
$pgv_lang["top_surnames"]		= "أكبر العوائل";
$pgv_lang["top_givennames"]		= "الأسماء الأكثر شيوعاً";
$pgv_lang["events"]			= "الأحداث";
$pgv_lang["stat_records"]		= "السجلات";
$pgv_lang["stat_notes"]			= "الملاحظات";
$pgv_lang["stat_first_event"]		= "أول حدث";
$pgv_lang["stat_last_event"]		= "آخر حدث";
$pgv_lang["stat_places"]			= "الأماكن";
$pgv_lang["stat_birth_places"]		= "أماكن الولادة";
$pgv_lang["stat_marriage_places"]	= "أماكن الزواج";
$pgv_lang["stat_death_places"]		= "أماكن الوفاة";
$pgv_lang["stat_countries"]		= "الأحداث حسب الدول";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]			= "هل متأكد أنك تريد حذف هذه المعلومة؟";
$pgv_lang["access_denied"]			= "<b> ممنوع </b><br /> ليست لديك الصلاحية.";
$pgv_lang["changes_exist"]			= "تم تعديل الملف";
$pgv_lang["find_place"] 			= "إيجاد مكان";
$pgv_lang["close_window"]			= "اغلاق";
$pgv_lang["close_window_without_refresh"]       = "إغلاق النافذة بدون إعادة تحميل";
$pgv_lang["place_contains"] 		        = "المكان يحتوي على:";
$pgv_lang["add"]				= "إضافة";
$pgv_lang["custom_event"]			= "حدث مخصص"; //custom event?
$pgv_lang["delete_person"]			= "حذف هذا الفرد";
$pgv_lang["confirm_delete_person"]	        = "هل متأكد أنك تريد حذف هذا الشخص؟";
$pgv_lang["find_media"] 			= "العثور على ملفات الوسائط المتعددة";
$pgv_lang["set_link"]				= "ضبط الرابط";
$pgv_lang["delete_source"]			= "حذف هذا المصدر";
$pgv_lang["delete_shared_note"]		        = "حذف هذه الملاحظة المشتركة";
$pgv_lang["confirm_delete_source"]	        = "هل متأكد أنك تريد حذف هذا المصدر ؟";
$pgv_lang["confirm_delete_shared_note"]		= "هل متأكد من حذف هذه الملاحظة المشتركة؟";
$pgv_lang["find_family"]			= "العثور على عائلة";
$pgv_lang["find_fam_list"]			= "العثور على قائمة عائلية";
$pgv_lang["edit_name"]				= "تعديل الاسم";
$pgv_lang["delete_name"]			= "حذف الاسم";
$pgv_lang["select_date"]			= "تحديد تاريخ";
$pgv_lang["user_cannot_edit"]		        = "لا يسمح لاسم المستخدم هذا بتعديل ملف الشجرة.";
$pgv_lang["gedcom_editing_disabled"]	        = "تم تعطيل إمكانية تعديل ملف الشجرة من قبل المسؤول.";
$pgv_lang["privacy_not_granted"]	        = "ليس لديك صلاحية ل";
$pgv_lang["privacy_prevented_editing"]	        = "إعدادات الخصوصية تمنعك من تعديل هذا السجل.";
$pgv_lang["ged_noshow"]				= "تم تعطيل امكانية عرض هذه الصفحة من قبل المسؤول عن الموقع.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]			= "شجرة نسب";
$pgv_lang["gen_ped_chart"]			= "#PEDIGREE_GENERATIONS# الرسم البياني للنسب";
$pgv_lang["generations"]			= "عدد الأجيال";
$pgv_lang["view"]				= "عرض";
$pgv_lang["fam_spouse"] 			= "عرض الزوج في شجرة نسبي";
$pgv_lang["rootid"] 				= "الشخص الجذري في شجرة نسبي";
$pgv_lang["root_person"]			= "رقم المعرف الخاص بالشخص الجذري";
$pgv_lang["hide_details"]			= "إخفاء التفاصيل";
$pgv_lang["show_details"]			= "عرض التفاصيل";
$pgv_lang["zoom_box"]				= "تكبير وتصغير";
$pgv_lang["orientation"]			= "توجيه الصفحة";
$pgv_lang["portrait"]				= "عمودي";
$pgv_lang["landscape"]				= "أفقي";
$pgv_lang["landscape_top"]			= "الأجداد في أعلى الصفحة";
$pgv_lang["landscape_down"]			= "الأجداد في أسفل الصفحة";
$pgv_lang["start_at_parents"]		        = "البدء عند الوالدين";
$pgv_lang["charts"] 				= "الرسومات البيانية";
$pgv_lang["lists"]				= "القوائم";
$pgv_lang["box_width"] 				= "عرض الصندوق";
$pgv_lang["random_surn"]			= "اسم عائلة عشوائية";
$pgv_lang["generation_number"]		        = "عدد الأجيال";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "رسم الساعة الرملية";

//-- report engine
$pgv_lang["choose_report"]		= "حدد التقرير الذي ترغب بتشغيله";
$pgv_lang["enter_report_values"]	= "ادخال القيم الخاصة بالتقرير";
$pgv_lang["selected_report"]		= "التقرير المختار";
$pgv_lang["select_report"]		= "اختيار التقرير";
$pgv_lang["download_report"]		= "تحميل التقرير";
$pgv_lang["reports"]			= "التقارير";
$pgv_lang["pdf_reports"]		= "PDF تقارير";
$pgv_lang["html_reports"]		= "HTML تقارير";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "تعذر العثور على أسرة برقم المعرف";
$pgv_lang["unable_to_find_record"]	= "تعذر العثور على سجل برقم المعرف";
$pgv_lang["title"]			= "العنوان:";
$pgv_lang["living"] 			= "الأحياء";
$pgv_lang["private"]			= "خاص";
$pgv_lang["birth"]			= "ولادة:";
$pgv_lang["death"]			= "وفاة:";
$pgv_lang["descend_chart"]		= "رسم السلالة";
$pgv_lang["individual_list"]		= "الأشخاص";
$pgv_lang["family_list"]		= "العوائل";
$pgv_lang["branch_list"]		= "الفروع";
$pgv_lang["source_list"]		= "المصادر";
$pgv_lang["shared_note_list"]		= "الملاحظات المشتركة";
$pgv_lang["place_list"] 		= "التسلسل الهرمي للأماكن";
$pgv_lang["place_list_aft"] 		= "Place Hierarchy after";
$pgv_lang["media_list"] 		= "ملفات الوسائط المتعددة";
$pgv_lang["repo_list"]			= "مستودعات البيانات";
$pgv_lang["search"] 			= "البحث";
$pgv_lang["clippings_cart"] 		= "سلة قصاصات شجرة العائلة";
$pgv_lang["print_preview"]		= "نسخة صالحة للطباعة";
$pgv_lang["cancel_preview"] 		= "العودة للشاشة العادية";
$pgv_lang["change_lang"]		= "تغيير لغة الموقع";
$pgv_lang["print"]			= "طباعة";
$pgv_lang["total_queries"]		= "إجمالي عدد الاستعلامات لقاعدة بيانات:";
$pgv_lang["total_privacy_checks"]	= "عدد مرات تدقيق الخصوصية: ";
$pgv_lang["back"]			= "العودة";

//-- FAN CHART
$pgv_lang["compact_chart"]		= "رسم بياني موجز";
$pgv_lang["fan_chart"]			= "الرسم الدائري";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# الرسم التخطيطي الدائري للأجيال";
$pgv_lang["fan_width"]			= "العرض";
$pgv_lang["gd_library"]			= "PHP server misconfiguration: GD 2.x library required to use image functions.";
$pgv_lang["gd_freetype"]		= "PHP server misconfiguration: FreeType library required to use TrueType fonts.";
$pgv_lang["gd_helplink"]		= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]		= "لم يتم العثور على الخط المطلوب في الخادم";
$pgv_lang["fanchart_IE"]		= "لا يمكن طباعة هذا الرسم مباشرة من متصفح الانترنت. اضغط زر الماوس الأيمن لحفظ الصورة ثم طباعتها.";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]	        = "مخطط الاحصاءات";
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplinfo"]			= "تفاصيل المخطط:";
$pgv_lang["stpltype"]			= "نوع:";
$pgv_lang["stplnoim"]			= " لم تنفذ:";
$pgv_lang["stplmf"]		        = " حسب الجنس";
$pgv_lang["stplipot"]			= " حسب الفترة الزمنية";
$pgv_lang["stplmonth"]			= "شهر";
$pgv_lang["stplnumbers"]		= "أرقام";
$pgv_lang["stplnuch"]			= "أولاد";
$pgv_lang["stplage"]			= "العمر";
$pgv_lang["stplperc"]			= "نسبة";
$pgv_lang["stplnumof"]			= "عدادات ";
$pgv_lang["stplmarrbirth"]		= "المدة فيما بين الزواج وولادة أول ولد";
$pgv_lang["indi_distribution_chart"]	= "الرسم البياني لتوزيع الأفراد";
$pgv_lang["surname_distribution_chart"]	= "الرسم البياني توزيع العوائل";
$pgv_lang["g_chart_high"]		= "أعلى عدد من السكان";
$pgv_lang["g_chart_low"]		= "أدنى عدد من السكان";
$pgv_lang["g_chart_nobody"]		= "لا أحد";
$pgv_lang["area_chart"]			= "المنطقة الجغرافية";
$pgv_lang["europe_chart"]		= "أوروبا";
$pgv_lang["s_america_chart"]	        = "أمريكا الجنوبية";
$pgv_lang["asia_chart"]			= "آسيا";
$pgv_lang["middle_east_chart"]	        = "الشرق الأوسط";
$pgv_lang["africa_chart"]		= "أفريقيا";
$pgv_lang["world_chart"]		= "العالم";


//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "تقرير النسب";
$pgv_lang["ahnentafel_generation"]	= "الجيل ";
$pgv_lang["ahnentafel_pronoun_m"]	= "هو ";
$pgv_lang["ahnentafel_pronoun_f"]	= "هي ";
$pgv_lang["ahnentafel_born_m"]		= "ولد";			// male
$pgv_lang["ahnentafel_born_f"]		= "ولدت";			// female
$pgv_lang["ahnentafel_married_m"]	= "متزوج";			// male
$pgv_lang["ahnentafel_married_f"]	= "متزوجة";			// female
$pgv_lang["ahnentafel_married_post"]    = "&nbsp;";
$pgv_lang["ahnentafel_died_m"]		= "متوفي";			// male
$pgv_lang["ahnentafel_died_f"]		= "متوفية";			// female

$pgv_lang["ahnentafel_buried_m"]	= "دفن";			// male
$pgv_lang["ahnentafel_buried_f"]	= "دفنت";			// female
$pgv_lang["ahnentafel_place"]		= " في ";			// place name follows this
$pgv_lang["ahnentafel_no_details"]	= " ولكن التفاصيل غير معروفة";
$pgv_lang["ahnentafel_on"]		= " ";

//-- Changes report
$pgv_lang["changes_report"]		= "تقرير التغييرات";
$pgv_lang["changes_pending_tot"]	= "إجمالي عدد التغيرات المعلقة:";
$pgv_lang["changes_accepted_tot"]	= "إجمالي عدد التغيرات المقبولة:";

//-- Descendancy report
$pgv_lang["descend_report"]		= "تقرير السلالة";
$pgv_lang["son_of"]			= "ابن";
$pgv_lang["daughter_of"]		= "ابنة";
$pgv_lang["child_of"]			= "ابن";
$pgv_lang["children_of"]		= "ابناء";
$pgv_lang["descendancy_pronoun_m"]	= "هو ";
$pgv_lang["descendancy_pronoun_f"]	= "هي ";

$pgv_lang["family_group_report"]	= "تقرير مجموعة الأسرة";
$pgv_lang["page"]			= "صفحة";
$pgv_lang["of"] 			= "من";
$pgv_lang["enter_famid"]		= "أدخل رقم المعرف الخاص بالأسرة";
$pgv_lang["show_sources"]		= "إظهار المصادر؟";
$pgv_lang["show_notes"] 		= "إظهار الملاحظات؟";
$pgv_lang["show_photos"]		= "إظهار الصور؟";
$pgv_lang["relatives_report_ext"]	= "تقرير الأقارب الموسع";
$pgv_lang["with"]			= "مع";
$pgv_lang["on"]				= "في تاريخ";		// for precise dates
$pgv_lang["in"]				= "في";			// for imprecise dates
$pgv_lang["individual_report"]		= "تقرير الأفراد";
$pgv_lang["individual_with_rela_report"]	= "تقرير الأقارب المباشرين";
$pgv_lang["enter_pid"]			= "أدخل المعرف الخاص بالفرد";
$pgv_lang["generated_by"]		= "تم إنشاؤها بواسطة";
$pgv_lang["birth_report"]		= "تقرير تاريخ ومكان المولد";
$pgv_lang["birthplace"]			= "مكان الولادة يحتوي على كلمة";
$pgv_lang["birthdate1"]			= "نطاق تاريخ الولادة يبتدئ من";
$pgv_lang["birthdate2"]			= "نطاق تاريخ الولادة ينتهي في";
$pgv_lang["death_report"]		= "تقرير تاريخ ومكان الوفاة";
$pgv_lang["deathplace"]			= "مكان الوفاة يحتوي على كلمة";
$pgv_lang["deathdate1"]			= "نطاق تاريخ الوفاة يبتدئ من";
$pgv_lang["deathdate2"]			= "نطاق تاريخ الوفاة ينتهي في";
$pgv_lang["marr_report"]		= "تقرير تاريخ ومكان الزواج";
$pgv_lang["marrplace"]			= "مكان الزواج يحتوي على كلمة";
$pgv_lang["marrdate1"]			= "نطاق تاريخ الزواج يبتدئ من";
$pgv_lang["marrdate2"]			= "نطاق تاريخ الزواج ينتهي في";
$pgv_lang["sort_by"]			= "الترتيب حسب";
$pgv_lang["cemetery_report"]		= "تقرير المدفن";
$pgv_lang["burialplace"]		= "مكان الدفن يحتوي على كلمة";
$pgv_lang["fact_sources_report"]	= "مصادر الحقائق";
$pgv_lang["missing_facts_report"]	= "الحقائق الغير مكتملة للأقارب";
$pgv_lang["sources_to_events"]		= "مصادر للأحداث";

$pgv_lang["cleanup"]			= "تنظيف";

// Media import
$pgv_lang["choose"]                     = "اختر: ";
$pgv_lang["account_information"]        = "معلومات الحساب";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"]                = "ملف صوتي";
$pgv_lang["TYPE__book"]                 = "كتاب";
$pgv_lang["TYPE__card"]                 = "بطاقة";
$pgv_lang["TYPE__certificate"]          = "شهادة";
$pgv_lang["TYPE__coat"]                 = "شعار العائلة";
$pgv_lang["TYPE__document"]             = "مستند";
$pgv_lang["TYPE__electronic"]           = "الكتروني";
$pgv_lang["TYPE__fiche"]                = "الميكروفيش";
$pgv_lang["TYPE__film"]                 = "فيلم";
$pgv_lang["TYPE__magazine"]             = "مجلة";
$pgv_lang["TYPE__manuscript"]           = "مخطوطة";
$pgv_lang["TYPE__map"]                  = "خريطة";
$pgv_lang["TYPE__newspaper"]            = "جريدة";
$pgv_lang["TYPE__photo"]                = "صورة";
$pgv_lang["TYPE__tombstone"]            = "بلاطة القبر";
$pgv_lang["TYPE__video"]                = "فيديو";
$pgv_lang["TYPE__painting"]             = "لوحة فنية";
$pgv_lang["TYPE__other"]                = "غير ذلك";


// FAQ Page
$pgv_lang["add_faq_header"]             = "عنوان للأسئلة الأكثر شيوعاً";
$pgv_lang["add_faq_body"]               = "نص للأسئلة الأكثر شيوعاً";
$pgv_lang["add_faq_order"]              = "موقع الأسئلة الأكثر شيوعاً";
$pgv_lang["add_faq_visibility"]         = "مرئية الأسئلة الأكثر شيوعاً";
$pgv_lang["no_faq_items"]               = "قائمة الأسئلة الأكثر شيوعاً فارغة";
$pgv_lang["position_item"]              = "تحريك";
$pgv_lang["faq_list"]                   = "قائمة الأسئلة الأكثر شيوعاً";
$pgv_lang["confirm_faq_delete"]         = "هل أنت متأكد أنك تريد حذف هذه التعليمات من الأسئلة الأكثر شيوعاً؟";
$pgv_lang["preview"]                    =  "معاينة";
$pgv_lang["no_id"]                      = "لم يتم تحديد المعرف الخاص بالأسئلة الأكثر شيوعاً !";

//-- Help system
$pgv_lang["definitions"]		= "تعريفات";

// Help search
$pgv_lang["hs_title"]			= "بحث تعليمات المساعدة";
$pgv_lang["hs_search"]			= "بحث";
$pgv_lang["hs_close"]			= "إغلاق";
$pgv_lang["hs_results"]			= "نتائج البحث:";
$pgv_lang["hs_keyword"]			= "البحث عن:";
$pgv_lang["hs_searchin"]		= "ابحث في:";
$pgv_lang["hs_searchuser"]		= "مساعدة المستخدم";
$pgv_lang["hs_searchmodules"]	        = "Modules Help";
$pgv_lang["hs_searchconfig"]	        = "مساعدة مدير النظام";
$pgv_lang["hs_searchhow"]		= "نوعية البحث";
$pgv_lang["hs_searchall"]		= "جميع كلمات البحث";
$pgv_lang["hs_searchany"]		= "نوعية البحث";
$pgv_lang["hs_searchsentence"]	        = "نتائج مطابقة للعبارة";
$pgv_lang["hs_intruehelp"]		= "بحث تعليمات المساعدة فقط";
$pgv_lang["hs_inallhelp"]		= "النص كاملاً";

//-- GENERAL HELP MESSAGES

$pgv_lang["help_for_this_page"] 	= "مساعدة خاصة بهذه الصفحة";
$pgv_lang["help_contents"]		= "محتوى المساعدة";
$pgv_lang["show_context_help"]		= "عرض التعليمات السياقية";
$pgv_lang["hide_context_help"]		= "إخفاء التعليمات السياقية";
$pgv_lang["sorry"]			= "<b> عذرا، تعليمات المساعدة لهذه الصفحة غير متوفرة. </b>";
$pgv_lang["help_not_exist"] 		= "<b> تعليمات المساعدة لهذه الصفحة غير متوفرة. </b>";
$pgv_lang["var_not_exist"]		= "<span style=\"font-weight: bold\"> متغير اللغة غير موجود. الرجاء الإبلاغ عن هذا الخطأ. </span>";
$pgv_lang["resolution"] 		= "دقة الشاشة";
$pgv_lang["menu"]			= "القائمة";
$pgv_lang["header"] 			= "عنوان";
$pgv_lang["imageview"]			= "عارض الصور";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]			= "كنية أو لقب";
$pgv_lang["male"]			= "زكر";
$pgv_lang["males"]			= "ذكور";
$pgv_lang["female"]			= "أنثى";
$pgv_lang["females"]			= "إناث";
$pgv_lang["temple"]			= "معبد المورمون";
$pgv_lang["temple_code"]		= "رمز معبد المورمون:";
$pgv_lang["status"] 			= "الحالة";
$pgv_lang["source"] 			= "مصدر";
$pgv_lang["text"]			= "نص المصدر:";
$pgv_lang["note"]			= "ملاحظة";
$pgv_lang["NN"] 				= "(الاسم الأخير غير معروف)";
$pgv_lang["PN"] 				= "(الاسم الأول غير معروف)";
$pgv_lang["NNPN"] 				= "(الاسم غير معروف)";
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NNother"] 				= "(الاسم الأخير غير معروف)";
$pgv_lang["PNother"] 				= "(الاسم الأول غير معروف)";
$pgv_lang["NNPNother"] 				= "(الاسم غير معروف)";
$pgv_lang["unrecognized_code"]		= "رمز غير معروف";
$pgv_lang["unrecognized_code_msg"]	= "الرجاء إبلاغنا عن هذا الخطأ";
$pgv_lang["indi_info"]			= "معلومات الفرد";
$pgv_lang["pedigree_chart"] 		= "شجرة نسبي";
$pgv_lang["individual"]			= "فرد";
$pgv_lang["as_spouse"]			= "الأسرة مع الزوج";
$pgv_lang["privacy_error"]		= "هذه المعلومات خاصة ولا يمكن عرضها.";
$pgv_lang["more_information"]		= "لمزيد من المعلومات الرجاء التواصل مع";
$pgv_lang["given_name"] 		= "الإسم الأول:";
$pgv_lang["surname"]			= "اسم العائلة:";
$pgv_lang["suffix"] 			= "Suffix:";
$pgv_lang["sex"]			= "الجنس";
$pgv_lang["personal_facts"] 		= "حقائق والتفاصيل الشخصية";
$pgv_lang["type"]			= "نوع";
$pgv_lang["parent"] 			= "والد";
$pgv_lang["parent_age"] 		= "عمر الوالد";
$pgv_lang["self"] 			= "النفس";
$pgv_lang["relatives"]			= "الأقارب";
$pgv_lang["relatives_events"]		= "أحداث متعلقة بالأقارب";
$pgv_lang["historical_facts"]		= "حقائق تاريخية";
$pgv_lang["partner"] 			= "شريك";
$pgv_lang["spouse"] 			= "زوج";
$pgv_lang["spouses"] 			= "أزواج";
$pgv_lang["surnames"]			= "Surnames";
$pgv_lang["adopted"]			= "متبنى";
$pgv_lang["foster"] 			= "التبني";
$pgv_lang["sealing"]			= "ختم";
$pgv_lang["challenged"]			= "تم الاعتراض";
$pgv_lang["disproved"]			= "دحضت";
$pgv_lang["infant"]			= "رضيع";
$pgv_lang["stillborn"]			= "جهيض";
$pgv_lang["deceased"]			= "متوفي";
$pgv_lang["link_as_wife"]		= "ربط هذا الشخص لعائلة كزوجة";
$pgv_lang["no_tab1"]			= "لا توجد حقائق متوفرة لهذا الشخص.";
$pgv_lang["no_tab2"]			= "لا توجد ملاحظات متوفرة لهذا الشخص.";
$pgv_lang["no_tab3"]			= "There are no Source citations for this individual.";
$pgv_lang["no_tab4"]			= "لا توجد ملفات الوسائط المتعددة متعلقة بهذا الشخص.";
$pgv_lang["no_tab5"]			= "ليس لهذا الشخص أقارب مسجلين";
$pgv_lang["no_tab6"]			= "لا توجد سجلات ابحاث تابعة لهذا الشخص.";
$pgv_lang["show_fact_sources"]		= "عرض جميع المصادر";
$pgv_lang["show_fact_notes"]		= "عرض جميع الملاحظات";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "تفاصيل الأسرة";
$pgv_lang["family_group_info"]		= "معلومات متعلقة بالأسرة";
$pgv_lang["husband"]			= "زوج";
$pgv_lang["wife"]			= "زوجة";
$pgv_lang["marriage"]			= "زواج:";
$pgv_lang["lds_sealing"]		= "ختم المورمون:";
$pgv_lang["marriage_license"]		= "رخصة زواج:";
$pgv_lang["no_children"]		= "بدون أطفال";
$pgv_lang["known_child"]		= "ولد واحد";
$pgv_lang["known_children"]		= "الاولاد";
$pgv_lang["childless_family"]		= "بقيت هذه الأسرة بلا أطفال";
$pgv_lang["parents_timeline"]		= "عرض الزوجين على الرسم البياني الزمني";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "سلة القصاصات";
$pgv_lang["which_links"]		= "ما هي الروابط الأخرى من هذه العائلةالتي تود إضافتها؟";
$pgv_lang["just_family"]		= "إضافة السجل الخاص بهذه الأسرة فقط.";
$pgv_lang["parents_and_family"] 	= "إضافة سجلات الوالدين بالاضافة لسجل الأسرة.";
$pgv_lang["parents_and_child"]		= "إضافة سجلات الوالدين والأطفال بالاضافة لسجل الأسرة.";
$pgv_lang["parents_desc"]		= "إضافة الوالدين وسجلات السلالة بالاضافة لسجل الأسرة.";
$pgv_lang["continue"]			= "الاستمرار بالإضافة";
$pgv_lang["which_p_links"]		= "ما هي الروابط الخاصة بهذا الشخص الذي تود إضافتها؟";
$pgv_lang["just_person"]		= "إضافة هذا الشخص فقط.";
$pgv_lang["person_parents_sibs"]	= "إضافة هذا الشخص مع والديه وأشقاءه.";
$pgv_lang["person_ancestors"]		= "إضافة هذا الشخص مع أسلافه المباشرين.";
$pgv_lang["person_ancestor_fams"]	= "إضافة هذا الشخص مع أسلافه المباشرين وأسرهم.";
$pgv_lang["person_spouse"]		= "إضافة هذا الشخص مع زوجه وأطفاله.";
$pgv_lang["person_desc"]		= "إضافة هذا الشخص مع زوجه وجميع أحفاده.";
$pgv_lang["which_s_links"]		= "أي السجلات االمرتبطة بهذا المصدر تود إضافتها؟";
$pgv_lang["just_source"]		= "إضافة هذا المصدر فقط.";
$pgv_lang["linked_source"]		= "إضافة هذا المصدر مع الأسر والأشخاص المرتبطة بها.";
$pgv_lang["person_private"] 		= "التفاصيل المتعلقة بهذا الشخص خاصة. لن يتم تضمينها.";
$pgv_lang["family_private"] 		= "التفاصيل المتعلقة بهذه العائلة خاصة. لن يتم تضمينها.";
$pgv_lang["media_private"] 		= "تفاصيل المتعلقة بهذه الوسائط خاصة. لن يتم تضمينها.";
$pgv_lang["download"]			= "انقر بزر الماوس الأيمن على الروابط أدناه لحفظ وتحميل الملفات.";
$pgv_lang["cart_is_empty"]		= "سلة القصاصات فارغة.";
$pgv_lang["id"] 			= "المعرف";
$pgv_lang["ID"] 			= "المعرف";
$pgv_lang["name_description"]		= "الاسم / الوصف";
$pgv_lang["remove"] 			= "حذف";
$pgv_lang["empty_cart"] 		= "Empty Cart";
$pgv_lang["download_now"]		= "تحميل الآن";
$pgv_lang["download_file"]		= "تحميل الملف #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "تم تحميل هذا الشخص من:";
$pgv_lang["family_downloaded_from"]     = "تم تحميل هذه العائلة من:";
$pgv_lang["source_downloaded_from"]     = "تم تحميل هذا المصدر من:";
$pgv_lang["convertPath"]		= "Convert media path to";
$pgv_lang["convertSlashes"]		= "Convert media folder separators to";
$pgv_lang["forwardSlashes"]		= "Forward slashes : /";
$pgv_lang["backSlashes"]		= "Backslashes : \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "تم العثور على روابط لأماكن";
$pgv_lang["top_level"]			= "أعلى مستوى";
$pgv_lang["form"]			= "تم ترميز الأماكن بالشكل التالي:";
$pgv_lang["default_form"]		= "المدينة، المقاطعة، الولاية / المنطقة الدولة";
$pgv_lang["default_form_info"]		= "(افتراضي)";
$pgv_lang["unknown"]			= "غير معروف";
$pgv_lang["individuals"]		= "الأفراد";
$pgv_lang["view_records_in_place"]	= "عرض جميع السجلات الموجودة في هذا المكان";
$pgv_lang["place_list2"] 		= "قائمة الأماكن";
$pgv_lang["show_place_hierarchy"]	= "عرض الأماكن في التسلسل الهرمي";
$pgv_lang["show_place_list"]		= "عرض جميع الأماكن في قائمة";
$pgv_lang["total_unic_places"]		= "إجمالي أماكن الفريدة";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "عناصر خارجية";
$pgv_lang["multi_title"]		= "عناصر الوسائط المتعددة";
$pgv_lang["media_found"]		= "تم العثور على عناصر للوسائط المتعددة";
$pgv_lang["view_person"]		= "عرض بيانات الشخص";
$pgv_lang["view_family"]		= "عرض العائلة";
$pgv_lang["view_source"]		= "عرض المصدر";
$pgv_lang["view_object"]		= "عرض العنصر";
$pgv_lang["prev"]			= "&lt; ؛ سابق";
$pgv_lang["next"]			= "التالي &gt;";
$pgv_lang["next_image"]			= "الصورة التالية";
$pgv_lang["file_not_found"] 		= "لم يتم العثور على الملف.";
$pgv_lang["medialist_show"] 		= "عرض";
$pgv_lang["per_page"]			= "عدد عناصر الوسائط المتعددة المعروضة لكل صفحة";
$pgv_lang["media_format"]		= "صيغة الوسائط المتعددة";
$pgv_lang["image_size"]			= "أبعاد الصورة";
$pgv_lang["media_id"]			= "معرف ملف الوسائط المتعددة";
$pgv_lang["invalid_id"]			= "لا يوجد ملف برقم المعرف المذكور.";
$pgv_lang["record_updated"]		= "تم تحديث رقم السجل #pid# بنجاح.";
$pgv_lang["record_not_updated"]		= "تعذر تحديث رقم السجل #pid#.";
$pgv_lang["record_removed"]		= "تم حذف السجل #xref# بنجاح.";
$pgv_lang["record_not_removed"]		= "تعذر حذف السجل #xref#.";
$pgv_lang["record_added"]		= "تم إضافة السجل #xref# بنجاح.";
$pgv_lang["record_not_added"]		= "تعذر إضافة السجل #xref#.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"] 		= "Search the way you think the name is written (Soundex)";
$pgv_lang["sources"]			= "مصادر";
$pgv_lang["shared_notes"]		= "ملاحظات مشتركة";
$pgv_lang["lastname_search"]		= "اسم العائلة";
$pgv_lang["search_place"]		= "المكان";
$pgv_lang["search_year"]		= "العام";
$pgv_lang["no_results"] 		= "لا توجد نتائج.";
$pgv_lang["search_soundex"]		= "Soundex Search";
$pgv_lang["search_replace"]		= "بحث واستبدال";
$pgv_lang["search_sources"]		= "مصادر";
$pgv_lang["search_shared_notes"]	= "ملاحظات مشتركة";
$pgv_lang["search_more_chars"]          = "يرجى إدخال أكثر من حرف واحد";
$pgv_lang["search_soundextype"]		= "Soundex type:";
$pgv_lang["search_russell"]		= "Basic";
$pgv_lang["search_tagfilter"]		= "Exclude Filter";
$pgv_lang["search_tagfon"]		= "Exclude some non-genealogical data";
$pgv_lang["search_tagfoff"]		= "Off";
$pgv_lang["associate"]			= "ربط";
$pgv_lang["search_record"]		= "سجل كامل";
$pgv_lang["search_to"]			= "الى";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]		= "العناوين";
$pgv_lang["find_source"]		= "العثور على مصدر";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 		= "مستودع بيانات";
$pgv_lang["repos_found"]		= "تم العثور على مستودعات للبيانات";
$pgv_lang["find_repository"]		= "العثور على مستودع للبيانات";
$pgv_lang["total_repositories"]		= "إجمالي عدد مستودعات البيانات";
$pgv_lang["confirm_delete_repo"]	= "هل أنت متأكد أنك تريد حذف هذا السجل؟";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "معلومات المصدر";
$pgv_lang["people"] 			= "الناس";
$pgv_lang["families"]			= "الأسر";
$pgv_lang["total_sources"]		= "مجموع المصادر";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]		= "ملاحظات مشتركة";
$pgv_lang["shared_notes_found"]		= "توجد ملاحظات مشتركة";
$pgv_lang["find_shared_note"]		= "البحث عن ملاحظات مشتركة";
$pgv_lang["shared_note_info"]		= "معلومات الملاحظات المشتركة";
$pgv_lang["total_shared_notes"]		= "إجمالي عدد الملاحظات المشتركة";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]	        = "صيغة الملف غير صالح";
$pgv_lang["exec_time"]			= "مدة التنفيذ:";
$pgv_lang["unable_to_create_index"]     = "تعذر إنشاء ملفات الفهرس. يجب التحقق من صلاحية التعديل لمجلد PhpGedView. يمكن إعادة الصلاحيات الى وضعها بمجرد إنشاء الملفات المطلوبة.";
$pgv_lang["changes_present"]		= " توجد تغييرات في معلقة لملف شجرة العائلة. في حال رفع ملف جديد سيتم إلغاء التغييرات المعلقة. يرجى مراجعة التغييرات قبل الاستمرار .";
$pgv_lang["sec"]			= "ثانية";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"] 			= "إجمالي عدد العوائل";
$pgv_lang["total_indis"]			= "إجمالي عدد الأفراد";
$pgv_lang["notes"]				= "الملاحظات";
$pgv_lang["ssourcess"]				= "المصادر";
$pgv_lang["media"]				= "ملفات الوسائط المتعددة";
$pgv_lang["name_contains"]			= "الاسم يحتوي على:";
$pgv_lang["filter"] 				= "تصفية";
$pgv_lang["apply_filter"]			= "تطبيق تصفية";
$pgv_lang["find_individual"]		        = "العثور على معرف الشخص";
$pgv_lang["find_familyid"]			= "العثور على معرف العائلة";
$pgv_lang["find_sourceid"]			= "العثور على معرف المصدر";
$pgv_lang["find_specialchar"]		        = "العثور على الأحرف الخاصة";
$pgv_lang["magnify"]				= "تكبير";
$pgv_lang["skip_surnames"]			= "تخطي قوائم اسم العائلة";
$pgv_lang["show_surnames"]			= "عرض قوائم اسم العائلة";
$pgv_lang["skip_marnms"]			= "استبعاد الاسم بعد الزواج";
$pgv_lang["show_marnms"]			= "ادراج الاسم بعد الزواج";
$pgv_lang["all"]				= "جميع";
$pgv_lang["hidden"]				= "إخفاء";
$pgv_lang["confidential"]			= "سري";
$pgv_lang["alpha_index"]			= "الفهرس الأبجدي";
$pgv_lang["name_list"] 				= "قائمة الأسماء";
$pgv_lang["firstname_alpha_index"] 	        = "الفهرس الأبجدي للاسم الأول";
$pgv_lang["roots"]		 	        = "جذور الشجرة";
$pgv_lang["leaves"] 				= "أوراق الشجرة";
$pgv_lang["widow"] 				= "أرملة";
$pgv_lang["widower"] 				= "أرمل";
$pgv_lang["show_parents"] 			= "عرض الوالدين";



// calendar conversion options
$pgv_lang["cal_none"]                 = "بدون تحويل التقويم";
$pgv_lang["cal_gregorian"]            = "ميلادي";
$pgv_lang["cal_julian"]               = "جوليان";
$pgv_lang["cal_french"]               = "فرنسي";
$pgv_lang["cal_jewish"]               = "يهودية";
$pgv_lang["cal_hebrew"]               = "العبرية";
$pgv_lang["cal_jewish_and_gregorian"] = "اليهودية والميلادية";
$pgv_lang["cal_hebrew_and_gregorian"] = "العبرية وميلادية";
$pgv_lang["cal_hijri"]                = "هجري";
$pgv_lang["cal_arabic"]               = "عربي";


// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]         = "صباحاً";
$pgv_lang["p.m."]         = "مساءً";
$pgv_lang["noon"]         = "ظهراً";
$pgv_lang["midn"]         = "ليلاً";

$pgv_lang["b.c."]         = "قبل الميلاد";

$pgv_lang["abt"]		       = "حول";
$pgv_lang["aft"]		     = "بعد";
$pgv_lang["and"]			= "و";
$pgv_lang["bef"]			= "قبل";
$pgv_lang["bet"]			= "بين";
$pgv_lang["cal"]			= "احتساب";
$pgv_lang["est"]			= "يقدر ب";
$pgv_lang["from"]			= "من";
$pgv_lang["int"]			= "يفسر ك";
$pgv_lang["to"] 			= "إلى";
$pgv_lang["cir"]			= "حوالي";
$pgv_lang["apx"]			= "تقريبا";



//-- validate GEDCOM
$pgv_lang["add_media_tool"] 		= "إضافة أداة للوسائط";



//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"]			= "الإحصاءات";
$pgv_lang["show_stats_charts"]		= "عرض رسم الإحصاءات";
$pgv_lang["decade_birth"]		= "عقد الولادة";
$pgv_lang["decade_death"]		= "عقد الوفاة";
$pgv_lang["decade_marriage"]		= "عقد الزواج";
$pgv_lang["avg_age"]			= "متوسط العمر";

//-- Merge Records
$pgv_lang["merge_same"] 		= "السجلات ليست من نفس النوع. لا يمكن دمج سجلات ليست من نفس النوع.";
$pgv_lang["merge_step1"]		= "خطوة الدمج 1 من 3";
$pgv_lang["merge_step2"]		= "خطوة الدمج 2 من 3";
$pgv_lang["merge_step3"]		= "خطوة الدمج 3 من 3";
$pgv_lang["select_gedcom_records"]	= "الرجاء اختيار السجلين المراد دمجها. يجب أن تكون السجلات من نفس النوع.";
$pgv_lang["merge_to"]			= "دمج الى للمعرف:";
$pgv_lang["merge_from"] 		= "دمج من للمعرف:";
$pgv_lang["merge_facts_same"]		= "الحقائق التالية متطابقة تماما في كلا السجلين وسيتم دمجهما تلقائيا.";
$pgv_lang["no_matches_found"]		= "No matching facts found";
$pgv_lang["unmatching_facts"]		= "الحقائق التالية غير متطابقة. يرجى تحديد المعلومات التي ترغب في الاحتفاظ بها.";
$pgv_lang["record"] 			= "سجل";
$pgv_lang["adding"] 			= "بصدد الإضافة";
$pgv_lang["updating_linked"]		= "بصدد تحديث السجل";
$pgv_lang["merge_more"] 		= "دمج سجلات إضافية.";
$pgv_lang["same_ids"]			= "لقد أدخلت نفس المعرفات. لا يمكنك دمج نفس السجلات.";
$pgv_lang["updated_favorites"] 		= "تم تحديث قائمة المفضلة";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "رسم الأصول (سلسلة النسب)";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# الرسم البياني للنسب";
$pgv_lang["chart_style"]		= "نمط الرسم البياني";
$pgv_lang["chart_list"]			= "قائمة";
$pgv_lang["chart_booklet"]   		= "كتيب";
$pgv_lang["show_cousins"]		= "عرض أبناء العم";
// 1st generation
$pgv_lang["sosa_2"] 			= "أب";
$pgv_lang["sosa_3"] 			= "أم";
// 2nd generation
$pgv_lang["sosa_4"] 			= "جد";
$pgv_lang["sosa_5"] 			= "جدة";
$pgv_lang["sosa_6"] 			= "جد";
$pgv_lang["sosa_7"] 			= "جدة";


//-- RSS Feed
$pgv_lang["rss_descr"]			= "أخبار وروابط من موقع #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]		= "Feed created by PhpGedView";
$pgv_lang["rss_feeds"]			= "RSS Feeds";
$pgv_lang["no_feed_title"]		= "Feed not available";
$pgv_lang["no_feed"]			= "There is no RSS feed available for this PhpGedView site";
$pgv_lang["feed_login"]			= "إذا كان لديك حساب يمكنك PhpGedView، <a href=\"#AUTH_URL#\">تسجيل الدخول</a> لعرض المعلومات الخاصة.";
$pgv_lang["authenticated_feed"]	        = "Authenticated Feed";


//-- alive in year
$pgv_lang["alive_in_year"]		= "على قيد الحياة في السنة";
$pgv_lang["is_alive_in"]		= "هو على قيد الحياة في #YEAR#";
$pgv_lang["alive"]			= "على قيد الحياة ";
$pgv_lang["dead"]			= "متوفى ";
$pgv_lang["maybe"]			= "ربما ";
$pgv_lang["both_alive"]			= "كلاهما على قيد الحياة";
$pgv_lang["both_dead"]			= "كلاهما متوفى";



//-- Index_edit
$pgv_lang["block_desc"]			= "وصف الصناديق";
$pgv_lang["click_here"]			= "إضغط هنا للاستمرار";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br /> اضغط على هذا الزر لحفظ التغييرات. <br /><br /> سيتم إعادتك إلى #pgv_lang[welcome]# أو#pgv_lang[mygedview]# ولكن قد لا تظهر تغييراتك حتى تقوم بإعادة تحميل المتصفح.";

$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br /> هنا شرح موجزا لكل الصناديق المتاحة لصفحتك #pgv_lang[welcome]# أو #pgv_lang[mygedview]#.<br /><br /><table border='1' width='95%'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#GLOBALS[blockSummaries]#</table>";

//-- Find page
$pgv_lang["total_places"]		= "Places found";
$pgv_lang["media_contains"]		= "تحتوي الوسائط على:";
$pgv_lang["repo_contains"]		= "يحتوي المستودع على:";
$pgv_lang["shared_note_contains"]	= "تحتوي الملاحظة المشتركة على:";
$pgv_lang["source_contains"]		= "يحتوي المصدر على:";
$pgv_lang["display_all"]		= "عرض الجميع";



//-- Other media suff
$pgv_lang["view_slideshow"]		= "مشاهدة عرض للصور";
$pgv_lang["download_image"]		= "تحميل الملف";
$pgv_lang["no_media"]			= "للم يتم العثور على وسائط";
$pgv_lang["media_privacy"]		= "قيود الخصوصية تمنعك من مشاهدة هذا العنصر";
$pgv_lang["relations_heading"]		= "الصورة متعلقة ب:";
$pgv_lang["file_size"]			= "حجم الملف";
$pgv_lang["img_size"]			= "حجم الصورة";
$pgv_lang["media_broken"]		= "هذا الملف مكسور ولا يمكن وضع علامة مائية عليه";
$pgv_lang["unknown_mime"]		= "Media Firewall error: >Unknown Mimetype< for file";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] = "إجراء غير معروف: [action].";
$pgv_lang["module_error_unknown_type"]      = "Unknown module type.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"]        = "عرض الأشخاص على قيد الحياة في السنة المشار إليها.";
$pgv_lang["button_BIRT_Y100"]            = "عرض الأشخاص الذين ولدوا في خلال السنوات ال 100 الماضية.";
$pgv_lang["button_BIRT_YES"]             = "عرض الأشخاص الذين ولدوا قبل أكثر من 100 سنة.";
$pgv_lang["button_DEAT_H"]               = "عرض الأزواج التي متوفى فيها الرجل.";
$pgv_lang["button_DEAT_N"]               = "عرض الناس الذين هم على قيد الحياة أو الأزواج اللذان كلاهما على قيد الحياة.";
$pgv_lang["button_DEAT_W"]               = "عرض الأزواج التي متوفية فيها المرأة.";
$pgv_lang["button_DEAT_Y"]               = "عرض الناس المتوفيين أو الأزواج اللذان كلاهما متوفي.";
$pgv_lang["button_DEAT_Y100"]            = "تبين للناس الذين ماتوا في خلال السنوات ال 100 الماضية.";
$pgv_lang["button_DEAT_YES"]             = "تبين للناس الذين ماتوا منذ أكثر من 100 سنة.";
$pgv_lang["button_MARR_DIV"]             = "عرض الأزواج المطلقين.";
$pgv_lang["button_MARR_U"]               = "عرض الأزواج بتاريخ زواج مجهول.";
$pgv_lang["button_MARR_Y100"]            = "عرض الأزواج الذين تزوجوا في خلال السنوات ال 100 الماضية.";
$pgv_lang["button_MARR_YES"]             = "عرض الأزواج الذين تزوجوا قبل أكثر من 100 سنة.";
$pgv_lang["button_reset"]                = "إعادة القائمة للوضع الافتراضاي.";
$pgv_lang["button_SEX_F"]                = "عرض الإناث فقط.";
$pgv_lang["button_SEX_M"]                = "عرض الذكور فقط.";
$pgv_lang["button_SEX_U"]                = "عرض الأشخاص مجهولي جنس.";
$pgv_lang["button_TREE_L"]               = "عرض «الأوراق» من الأزواج أو الأفراد. هم الأفراد الذين هم على قيد الحياة ولكن ليس لديهم أطفال مسجلين في قاعدة البيانات.";
$pgv_lang["button_TREE_R"]               = "عرض «الجذور» من الأزواج أو الأفراد. هم الأفراد الذين ليس لديهم آباء المسجلة في قاعدة البيانات.";
$pgv_lang["sort_column"]                 = "الترتيب حسب هذا العمود.";


?>
