<?php
/**
 * Turkish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Kurt Norgaz
 * @author Adem GENÇ uzayuydu@gmail.com http://www.muttafi.com
 * @translator Google Translate
 * @version $Id: lang.tr.php 7371 2024-02-07 01:04:20Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["birth_M"]				= "#name#'un doğum günü";		// For male persons
$pgv_lang["birth_F"]				= "#name#'un doğum günü";		// For female persons
$pgv_lang["born_in_M"]				= "#date#'de #place#'da dünyaya geldi";		// For male persons
$pgv_lang["born_in_F"]				= "#date#'de #place#'da dünyaya geldi";		// For female persons
$pgv_lang["born_on_M"]				= "O #date#'de doğdu";		// For male persons
$pgv_lang["born_on_F"]				= "O #date#'de doğdu";		// For female persons
$pgv_lang["death_M"]				= "#name#'un ölüm yıldönümü";		// For male persons
$pgv_lang["death_F"]				= "#name#'un ölüm yıldönümü";		// For female persons
$pgv_lang["died_in_M"]				= "#date#'de #place#'da öldü";		// For male persons
$pgv_lang["died_in_F"]				= "#date#'de #place#'da öldü";		// For female persons
$pgv_lang["died_on_M"]				= "#date#'de öldü";		// For male persons
$pgv_lang["died_on_F"]				= "#date#'de öldü";		// For female persons
$pgv_lang["anniversary_of"]			= "#husband# ve #wife#'nin evlilik yıldönümü";
$pgv_lang["married_in"]				= "#date#'de #place#'da evlendi";
$pgv_lang["married_on"]				= "#date# tarihinde evlendi";
$pgv_lang["clustrmaps_locations"]	= "Bu sayfadaki ziyaretçilerin konumları";
$pgv_lang["gedcomid"]				= "GEDCOM INDI(kişi) kayıt ID";
$pgv_lang["sortby"]				= "Ard arda";
$pgv_lang["exact"]				= "Aynısı";
$pgv_lang["begins_with"]		= "İle başlayan";
$pgv_lang["contains"]			= "İçerikler";
$pgv_lang["sounds_like"]		= "Buna benzer";
$pgv_lang["advanced_search"] 	= "Gelişmiş Arama";
$pgv_lang["more_fields"]		= "Daha Fazla Alan Ekle";
$pgv_lang["install_step_8"] 		= "Kullanmaya Başla";
$pgv_lang["parent_family"]			= "Ebeveyn Aile";
$pgv_lang["step_parent_family"]		= "Üvey-Ebeveyn Aile";
$pgv_lang["immediate_family"]		= "En Yakın Aile";

$pgv_lang["load_full_tree"]			= "Bu ağacı tam sayfa etkileşimli ağacında görüntüle";
$pgv_lang["hide_show_spouses"]		= "Çoklu eşleri göster veya gizle";
$pgv_lang["interactive_tree"]		= "Etkileşimli Ağaç";
$pgv_lang["example"]				= "Örnek:";
$pgv_lang["tree"]					= "Ağaç";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["showUnknown"]			= "Bilinmeyen cinsiyeti göster";
$pgv_lang["count"]					= "Sayı";
$pgv_lang["age_differences"]		= "Yaş Farklarını Göster";
$pgv_lang["multi_site_search"] 		= "Çoklu Site Ara";
$pgv_lang["switch_lifespan"]		= "Ömrü çizelgesii göster";
$pgv_lang["switch_timeline"]		= "Zaman çizelgesi grafik göster";
$pgv_lang["differences"]			= "Farklar";
$pgv_lang["charts_block"]			= "Blok Çizelgeleri";
$pgv_lang["charts_block_descr"]		= "Grafikler bloğu Hoş Geldiniz veya MyGedView portal sayfasına bir grafik yerleştirmenize izin verir. Bu blok bir ataları, torunları ya da kum saati görünümü göstermek için yapılandırabilirsiniz. Ayrıca grafik için kök kişi seçebilirsiniz.";
$pgv_lang["charts_click_box"]		= "Kişi hakkında daha detaylı bilgi için kişinin kutusunu tıklayın.";
$pgv_lang["chart_type"]				= "Çizelge Tipi";
$pgv_lang["changedate1"]			= "Değişen tarihlerin bitiş aralığı";
$pgv_lang["changedate2"]			= "Değişen tarihlerin başlama aralığı";
$pgv_lang["search_place_word"]		= "Sadece tam sözcükler";
$pgv_lang["invalid_search_input"]	= "Lütfen Yıl için ek olarak bir Verilen adı, Soyadı yada Yer giriniz.";
$pgv_lang["duplicate_username"]		= "Kullanılan Kullanıcı adı. Bu kullanıcı adı ile bir kullanıcı zaten var. Lütfen başka bir kullanıcı adı seçin.";
$pgv_lang["cache_life"]				= "Önbellek dosyası ömrü";
$pgv_lang["genealogy"]					= "soyağacı";
$pgv_lang["activate"]					= "Aktif";
$pgv_lang["deactivate"]					= "Aktif değil";
$pgv_lang["play"]					= "Slayt başlat";
$pgv_lang["stop"]					= "Slayt durdur";
$pgv_lang["random_media_start_slide"]	= "Otomatik Slayt gösterimi başlat?";
$pgv_lang["random_media_ajax_controls"]	= "Slay gösterme kontrolleri göster?";
$pgv_lang["description"]		= "Açıklaması";
$pgv_lang["current_dir"]			= "Geçerli dizin";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Üyelerin GEDCOM Numaraları Göster";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Şahısların kutularında resimleri göster";
$pgv_lang["view_img_details"]		= "Resim detaylarını görüntüle";
$pgv_lang["server_folder"]				= "Sunucudaki klasör adı";
$pgv_lang["medialist_recursive"]	= "Altklasördeki dosyaları listele";
$pgv_lang["media_options"]			= "Media Seçenekleri";
$pgv_lang["confirm_password"]		= "Şifreyi tekrarlamalısınız.";
$pgv_lang["enter_email"]		= "Bir email adresini girmelisiniz.";
$pgv_lang["enter_fullname"]		= "Adı ve Soyadı girmelisiniz.";
$pgv_lang["name"]			= "Adı";
$pgv_lang["names"]					= "Adı";
$pgv_lang["children"]			= "Çocuklar";
$pgv_lang["lchildren"]				= "çocuklar";
$pgv_lang["child"]			= "Çocuk";
$pgv_lang["grandchildren"]			= "torunlar";
$pgv_lang["family"]			= "Aile";
$pgv_lang["as_child"]			= "Ebeveynlerle Aile";
$pgv_lang["shared_note_menu"]		= "Paylaşılan not için seçenekler";
$pgv_lang["source_menu"]			= "Kaynak için seçenekler";
$pgv_lang["repo_menu"]			= "Depo için Seçenekler";
$pgv_lang["other_records"]		= "Bu kaynağa bağlantılı kayıtlar:";
$pgv_lang["other_repo_records"]		= "Bu depoya bağlantılı kayıtlar:";
$pgv_lang["repo_info"]				= "Depo Bilgisi";
$pgv_lang["enter_terms"]		= "Arama terimleri girin";
$pgv_lang["search_asso_label"]		= "İştirakler";
$pgv_lang["search_asso_text"]		= "İlişkili kişileri/aileleri göster";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["search_fams"]			= "Aileler";
$pgv_lang["search_gedcom"]		= "Veritabanları ara";
$pgv_lang["search_geds"]			= "GEDCOM larin içinde ara";
$pgv_lang["search_indis"]			= "Kişiseller";
$pgv_lang["search_notes"]			= "Paylaşılan Notlar";
$pgv_lang["search_inrecs"]			= "İçin ara";
$pgv_lang["search_prtall"]			= "Tüm adlar";
$pgv_lang["search_prthit"]			= "Hit ile adlar";
$pgv_lang["results_per_page"]		= "Her sayfadaki sonuçlar";
$pgv_lang["firstname_search"]		= "Verilen ad";
$pgv_lang["search_prtnames"]		= "Bireyler'<br />yazdırılacak adlar:";
$pgv_lang["other_searches"]			= "Diğer Aramalar";
$pgv_lang["add_to_cart"]		= "Kupürleri Sepete Ekle";
$pgv_lang["view_gedcom"]		= "GEDCOM kaydı göster";
$pgv_lang["welcome"]			= "Hoş geldiniz";
$pgv_lang["son"]			= "Oğul";
$pgv_lang["daughter"]			= "Kız evlat";
$pgv_lang["welcome_page"]		= "Hoşgeldin sayfası";
$pgv_lang["editowndata"]		= "Profil Ayarlarım";
$pgv_lang["user_admin"]			= "Kullanıcı Yönetimi";
$pgv_lang["manage_media"]			= "Media Yönetimi";
$pgv_lang["search_general"]			= "Genel Arama";
$pgv_lang["clipping_privacy"]		= "Gizlilik kısıtlamaları nedeniyle bazı öğeler eklenemedi";
$pgv_lang["chart_new"]				= "Aile Ağacı Çizelgesi";
$pgv_lang["loading"]				= "Yükleniyor...";
$pgv_lang["clear_chart"]			= "Grafiği Temizle";
$pgv_lang["file_information"]		= "Dosya Bilgisi";
$pgv_lang["choose_file_type"]		= "Dosya Tipi";
$pgv_lang["add_individual_by_id"]		= "Bireysel ID Olarak Ekle";
$pgv_lang["advanced_options"]		= "Gelişmiş Seçenekler";
$pgv_lang["zip_files"]				= "Zip Dosyası";
$pgv_lang["include_media"]			= "Medyaları İçer (otomatikman zip dosyası)";
$pgv_lang["roman_surn"]				= "Latince Soyadı";
$pgv_lang["roman_givn"]				= "Latince Verilen Ad";
$pgv_lang["include"]				= "İçer:";
$pgv_lang["page_x_of_y"]				= "Sayfa #GLOBALS[currentPage]# son #GLOBALS[lastPage]#";
$pgv_lang["options"]			= "Seçenekler:";
$pgv_lang["config_update_ok"]		= "Yapılandırma dosyanız başarı ile güncelleştirilmiştir.";
$pgv_lang["page_size"]					= "Sayfa boyutu";
$pgv_lang["font"]					= "Yazı Tipi";
$pgv_lang["use_colors"]				= "Renkler kullan";
$pgv_lang["record_not_found"]			= "İstenen GEDCOM kaydı bulunamadı. Bunun nedeni, geçersiz bir kişi için bir bağlantı veya bozuk GEDCOM dosya olabilir.";
$pgv_lang["result_page"]				= "Sonuç Sayfası";
$pgv_lang["edit_media"]					= "Medya Öğesi Düzenle (#GLOBALS[pid]#)";
$pgv_lang["wiki_main_page"]				= "Wiki Ana Sayfa";
$pgv_lang["wiki_users_guide"]			= "Wiki Kullanıcının Kılavuzu";
$pgv_lang["wiki_admin_guide"]			= "Wiki Yöneticinin Kılavuzu";
$pgv_lang["no_search_for"]			= "Ara seçeneğini seçtiğinizden emin olun.";
$pgv_lang["no_search_site"]			= "En az bir uzak siteyi seçtiğinizden emin olun.";
$pgv_lang["search_sites"] 			= "Aranacak siteler";
$pgv_lang["site_list"]				= "Site: ";
$pgv_lang["site_had"]				= "Aşağıda bulunan";
$pgv_lang["label_search_engine_detected"]  = "Arama Motoru Örümcek Algılandı";

$pgv_lang["ex-spouse"] = "Eski-Eş";
$pgv_lang["ex-wife"] = "Eski-Hanım";
$pgv_lang["ex-husband"] = "Eski-Koca";
$pgv_lang["noemail"] 				= "Emailler olmadan adresleri";
$pgv_lang["onlyemail"] 				= "Sadece emailler ile adresleri";
$pgv_lang["maxviews_exceeded"]		= "İzin verilen sayfa görüntüleme oranı sayfa başına #GLOBALS[MAX_VIEW_TIME]# saniye toplam #GLOBALS[MAX_VIEWS]# süre aşmıştır.";
$pgv_lang["broadcast_not_logged_6mo"]	= "6 ay boyunca giriş yapmayan kullanıcılara mesaj gönder";
$pgv_lang["broadcast_never_logged_in"]	= "Hiç giriş yapmayan kullanıcılara mesaj gönder";
$pgv_lang["stats_to_show"]			= "Bu blok içinde göstermek için istatistikleri seçin";
$pgv_lang["stat_avg_age_at_death"]	= "Ortalama ölüm yaşı";
$pgv_lang["stat_longest_life"]		= "En uzun yaşayan kişi";
$pgv_lang["stat_most_children"]		= "En çok çocuklu aile";
$pgv_lang["stat_average_children"]	= "Aile başına ortalama çocuk sayısı";
$pgv_lang["stat_events"]			= "Toplam hadiseler";
$pgv_lang["stat_media"]				= "Medya öğeleri";
$pgv_lang["stat_surnames"]			= "Toplam soyadılar";
$pgv_lang["stat_users"]				= "Toplam kullanıcılar";
$pgv_lang["no_family_facts"]		= "Bu aile için hiçbir olgu yok.";
$pgv_lang["stat_males"]				= "Erkekler";
$pgv_lang["stat_females"]			= "Kadınlar";
$pgv_lang["stat_unknown"]			= "Bilinmiyor";
$pgv_lang["stat_link"]				= "İstatistikleri grafik olarak görüntüle";
$pgv_lang["print_stat_link"]		= "İstatistik çizelgelerinde linkleri göster?";

$pgv_lang["sunday_1st"]					= "Pz";
$pgv_lang["monday_1st"]					= "P";
$pgv_lang["tuesday_1st"]				= "Sl";
$pgv_lang["wednesday_1st"]				= "Ç";
$pgv_lang["thursday_1st"]				= "Pş";
$pgv_lang["friday_1st"]					= "C";
$pgv_lang["saturday_1st"]				= "Ct";

$pgv_lang["jan_1st"]					= "Oca";
$pgv_lang["feb_1st"]					= "Şub";
$pgv_lang["mar_1st"]					= "Mar";
$pgv_lang["apr_1st"]					= "Nis";
$pgv_lang["may_1st"]				= "May";
$pgv_lang["jun_1st"]					= "Haz";
$pgv_lang["jul_1st"]					= "Tem";
$pgv_lang["aug_1st"]					= "Ağu";
$pgv_lang["sep_1st"]					= "Eyl";
$pgv_lang["oct_1st"]					= "Eki";
$pgv_lang["nov_1st"]					= "Kas";
$pgv_lang["dec_1st"]					= "Ara";

$pgv_lang["edit_source"]			= "Kaynağı Düzenle";
$pgv_lang["edit_shared_note"]		= "Paylaşılan Notu Düzenle";
$pgv_lang["familybook_chart"]		= "Ayrı Ayrı Aile Çizelgesi";
$pgv_lang["family_of"]				= "Aile&nbsp;";
$pgv_lang["descent_steps"]			= "Derinlik Adımları";

$pgv_lang["cancel"]					= "Vazgeç";
$pgv_lang["cookie_help"]			= "Bu site giriş durumların kayıtlarını tutmak için çerezleri kullanır.<br /><br />Tarayıcınızda çerezler etkin olmadığı görünüyor. Bu siteye giriş yapmanız için önce çerezleri etkinleştirmeniz gerekir. Etkinleştirilen çerez bilgileri için tarayıcınızın yardım dokümanına bakınız.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]			= "Bu kişi için uzak siteden bağlanan bilgi.";
$pgv_lang["link_remote"]            = "Uzak siteden bağlanan kişi";
//Add Remote Link
$pgv_lang["title_search_link"]      = "Yerel Bağlantı Ekle";
$pgv_lang["label_site_url2"]        = "Site URL";
//new stuff

$pgv_lang["delete_family_confirm"]	= "Bu aileyi silerseniz buna bağlı çocukları, eşleri ve fertler hiç kimse ile bağlantıları kalmayıp ortada kalacaktır. Yinede siz bu aileyi silmek istediğinizden eminmisiniz?";
$pgv_lang["delete_family"]			= "Aileyi sil";
$pgv_lang["add_favorite"]			= "Yeni favori ekle";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Bu favoriyle ilgili bir not girin(isteğe bağlı)";
$pgv_lang["add_fav_or_enter_url"]	= "YADA<br />Bir URL ve bir başlık girin";
$pgv_lang["add_fav_enter_id"]		= "Bir Kişi, Aile, yada Kaynak ID girn";
$pgv_lang["next_email_sent"]		= "Sonraki hatırlatıcı email gönderileceği zaman ";
$pgv_lang["last_email_sent"]		= "Son hatırlatıcı email gönderilme zamanı ";
$pgv_lang["remove_child"]			= "Aileden bu çocuğu kaldır";
$pgv_lang["link_new_husb"]			= "Bu kişiye var olan bir koca ekle";
$pgv_lang["link_new_wife"]			= "Var olan kişiden yeni hanım eş ekle";
$pgv_lang["address_labels"]			= "Adres Etiketleri";
$pgv_lang["filter_address"]			= "İçeren adresleri göster:";
$pgv_lang["address_list"]			= "Adres Listesi";
$pgv_lang["index_edit_advice"]		= "Bir blok adı vurgulayın ve vurgulanan bu blok belirtilen yönde taşımak için ok simgelerden birini tıklatın.";
$pgv_lang["changelog"]			= "Versiyon #VERSION# değişenler";
$pgv_lang["html_block_descr"]		= "Bu basit HTML bloku sayfanıza herhangi bir mesajınızı yerleştirmenize imkan sağlayacaktır.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Başlığınızı buraya yerleştirin</b></p><br /><p>Yapılandırma düğmesini tıklayın";
$pgv_lang["html_block_sample_part2"]	= "açılacak sayfada mesajınızı yazın.</p>";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Gelişmiş HTML";
$pgv_lang["htmlplus_block_descr"]	= "Bu gelişmiş HTML bloku sayfanıza herhangi bir mesajınızı yerleştirmenize imkan sağlayacaktır. Ayrıca GEDCOM dan referansları kullanabilirsiniz.";
$pgv_lang["htmlplus_block_templates"] = "Şablonlar";
$pgv_lang["htmlplus_block_content"] = "İçerik";
$pgv_lang["htmlplus_block_narrative"] = "Öykü stili(Sadece İngilizce)";
$pgv_lang["htmlplus_block_custom"]	= "Özel";
$pgv_lang["htmlplus_block_keyword"]	= "Kelime Örnekleri (Sadece İngilizce)";
$pgv_lang["htmlplus_block_taglist"]	= "Tag Listesi";
$pgv_lang["htmlplus_block_compat"]	= "Uygunluk Modu";
$pgv_lang["htmlplus_block_ui"]		= "Genişletilmiş Arayüz";
$pgv_lang["htmlplus_block_current"]	= "Şu anki";
$pgv_lang["htmlplus_block_default"]	= "Varsayılan";
$pgv_lang["htmlplus_block_gedcom"]	= "Aile Ağacı";
$pgv_lang["htmlplus_block_birth"]	= "doğum";
$pgv_lang["htmlplus_block_death"]	= "vefat";
$pgv_lang["htmlplus_block_marrage"]	= "evlilik";
$pgv_lang["htmlplus_block_adoption"]= "evlât edinme";
$pgv_lang["htmlplus_block_burial"]	= "defin";
$pgv_lang["htmlplus_block_census"]	= "nüfüs sayımı eklendi";
$pgv_lang["num_to_show"]			= "Gösterilecek öğe sayısı";
$pgv_lang["days_to_show"]			= "Gösterilecek gün sayısı";
$pgv_lang["before_or_after"]		= "Ad sayısı adın öncesi yada sonrası?";
$pgv_lang["before"]					= "önce";
$pgv_lang["after"]					= "sonra";
$pgv_lang["config_block"]			= "Yapılandırma";
$pgv_lang["enter_comments"]			= "Lütfen Yorum alanına ilişki verinizi giriniz.";
$pgv_lang["comments"]				= "Çok detaylı kendinizi tanıtın:";
$pgv_lang["child-family"]			= "Ebeveynler ve Kardeşler";
$pgv_lang["spouse-family"]			= "Eş ve çocuklar";
$pgv_lang["direct-ancestors"]		= "Direk atalara doğru";
$pgv_lang["ancestors"]				= "Direk atalara doğru ve onların aileleri";
$pgv_lang["descendants"]			= "Zürriyet";
$pgv_lang["choose_relatives"]		= "Yakınlıkları seç";
$pgv_lang["relatives_report"]		= "Yakınlıklar Raporu";
$pgv_lang["total_unknown"]			= "Bilinmiyor";
$pgv_lang["total_living"]			= "Yaşayan";
$pgv_lang["total_dead"]				= "Ölü";
$pgv_lang["total_not_born"]			= "Ölü doğan";
$pgv_lang["remove_custom_tags"]		= "Özel PGV etiketleri kaldır? (örnek. _PGVU, _THUM)";
$pgv_lang["fams_with_surname"]		= "Soyadı ile aileler #surname#";
$pgv_lang["support_contact"]		= "Teknik yardımı için iletişim";
$pgv_lang["genealogy_contact"]		= "Soyağacı için iletişim";
$pgv_lang["common_upload_errors"]	= "Bu hata büyük ihtimalle sizin yüklemeye çalıştığınız dosya en fazla dosya yükleme kotası aştığı anlama gelir. PHP de varsayılan dosya yükleme kotası 2MB tir. Bu değeri artırmak için sunucu firmanızla görüşerek php.ini dosya içindeki yükleme kotasını artırmasını isteyebilir, Ayrıca dosyayı FTP ile yükleyebilirsiniz. <a href=\"uploadgedcom.php?action=add_form\"><b>GEDCOM Ekle</b></a>";
$pgv_lang["total_memory_usage"]		= "Toplam Kullanılan Hafıza";
$pgv_lang["mothers_family_with"]	= "Annenin Aile ile ";
$pgv_lang["fathers_family_with"]	= "Babanın Aile ile";
$pgv_lang["family_with"]			= "Aile ile";
$pgv_lang["halfsibling"]			= "Üvey-Kardeş";
$pgv_lang["halfbrother"]			= "Üvey-Erkek Kardeş";
$pgv_lang["halfsister"]				= "Üvey-Kız Kardeş";
$pgv_lang["family_timeline"]		= "Zaman çizgi çizelgesinde aileyi göster";
$pgv_lang["children_timeline"]		= "Zaman çizgi çizelgesinde çocukları göster";
$pgv_lang["other"]			= "Diğer";
$pgv_lang["others"]					= "Diğerleri";
$pgv_lang["sort_by_marriage"]		= "Evlilik tarihe göre sırala";
$pgv_lang["reorder_families"]		= "Aileleri Yeniden Sırala";
$pgv_lang["indis_with_surname"]		= "Soyadı ile bireyler #surname#";
$pgv_lang["first_letter_name"]		= "Aileleri göstermek için adının baş harfini seçin.";
$pgv_lang["first_letter_sfname"]	= "Aileleri göstermek için bir eşin adının baş harfini seçin.";
$pgv_lang["first_letter_iname"]		= "Bireyleri göstermek için soyadının baş harfini seçin.";
$pgv_lang["first_letter_fname"]		= "Bireyleri göstermek için adının baş harfini seçin.";
$pgv_lang["total_names"]			= "Toplam Adlar";
$pgv_lang["total_changes"]			= "Toplam değişenler";
$pgv_lang["total_links"]			= "Toplam linkler";
$pgv_lang["top10_pageviews_nohits"]	= "Göstermek için güncel hiçbir hit yok.";
$pgv_lang["top10_pageviews_msg"]	= "Hit sayaçları GEDCOM yapılandırılmasını Gösterme ve Yerleşim bölümü, Gizle ve Grup gösterme etkinleştirilmedir.";
$pgv_lang["review_changes_descr"]	= "Bekleyen Değişiklikler blokta çevrimiçi kayıtları Düzeltme haklarına sahip kullanıcıların değiştirecekleri kayıtların bir listesini vererek gözden geçirmelerini sağlayacaktır. Bu değişiklikler onaylanması veya reddedilmesi için bekliyor olacaktır.<br /><br />Eğer bu blok etkinleştirilirse Onaylama yetkisi olan kullanıcılara değişiklikleri gözden geçirilmesi gerektiğini bildiren günde bir email mesajı alırlar.";
$pgv_lang["review_changes_block"]	= "Bekleyen Değişiklikler";
$pgv_lang["review_changes_email"]	= "Hatırlatıcı emailler gönder?";
$pgv_lang["review_changes_email_freq"]	= "Hatırlatıcı email aralığı (gün)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Değişenleri Tekrar Görüntüle";
$pgv_lang["review_changes_body"]	= "Soyağacı veritabanında çevrimiçi değişiklikler yapıldı. Bu değişiklikler tüm kullanıcılara görünmesi için önce gözden geçirilip onaylanması gerekir. Lütfen aşağıdaki URL'yi kullanarak PhpGedView sitesindeki değişiklikleri incelemek ve giriş için kullanın.";
$pgv_lang["show_pending"]		= "Bekleyen değişiklikleri göster";
$pgv_lang["show_spouses"]		= "Eşleri göster";
$pgv_lang["quick_update_title"]		= "Hızlı Güncelleme";
$pgv_lang["quick_update_instructions"] = "Bu sayfa hızlı birey bilgilerinizi güncellemek için size izin verir. Veritabanında mevcut bilgilerinizi değiştirmek veya yeni bilgiler eklemek için gerek duyabilirsiniz. Değişiklikler gönderildikten sonra kullanıcılara görünmeden önce yönetici tarafından gözden geçirilip onaylanması gerekmektedir.";
$pgv_lang["update_name"] = "Adı Güncelle";
$pgv_lang["update_fact"]		= "Bir Olguyu Güncelle";
$pgv_lang["update_fact_restricted"] = "Bu olgunun güncellenmesi kısıtlanmış:";
$pgv_lang["select_fact"]		= "Bir olgu seç...";
$pgv_lang["update_address"]		= "Adresi Güncelle";
$pgv_lang["top10_pageviews_descr"]	= "Bu blok en çok gürüntülenen 10 kaydı gösterir. Bu blok GEDCOM yapılandırma ayarlarında Hit Sayaçları etkinleştirilmesi gerektirir.";
$pgv_lang["top10_pageviews"]		= "Ençok Görüntülenenler";
$pgv_lang["top10_pageviews_block"]		= "Ençok Görüntülenenler";
$pgv_lang["stepparent"] = "Üvey Ebeveyn";
$pgv_lang["stepdad"]				= "Üvey-Baba";
$pgv_lang["stepmom"]				= "Üvey-Anne";
$pgv_lang["stepsister"]				= "Üvey-Kız Kardeş";
$pgv_lang["stepbrother"]			= "Üvey-Erkek Kardeş";
$pgv_lang["fams_charts"]			= "Aile için seçenekler";
$pgv_lang["indis_charts"]		= "Birey için seçenekler";
$pgv_lang["none"]					= "Hiçbiri";
$pgv_lang["facts"]					= "Olgular";
$pgv_lang["locked"]					= "Değiştirilemez";
$pgv_lang["privacy"]				= "Mahremiyet";
$pgv_lang["number_sign"]			= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]					= "?";
$pgv_lang["page_help"]			= "Yardım";
$pgv_lang["help_for_this_page"]		= "Bu sayfa üzerine yardım";
$pgv_lang["help_contents"]		= "Yardım İçeriği";
$pgv_lang["show_context_help"]		= "Yardım <img border=\"0\" src=\"images/small/help.gif\" width=\"14\" height=\"17\"> ikonu göster";
$pgv_lang["hide_context_help"]		= "Yardım <img border=\"0\" src=\"images/small/help.gif\" width=\"14\" height=\"17\"> ikonu gizle";
$pgv_lang["sorry"]			= "<b>Üzgünüz, Bu sayfa veya öğe için yardım metni henüz kullanılabilir değil.</b>";
$pgv_lang["help_not_exist"]		= "<b>Bu sayfa veya öğe için Yardım metni henüz kullanılabilir değil.</b>";
$pgv_lang["var_not_exist"]			= "<span style=font-weight: bold>Dil değişkeni mevcut değil. Lütfen bu hata olduğu gibi rapor edin.</span>";
$pgv_lang["resolution"]			= "Ekran Çözünürlüğü";
$pgv_lang["menu"]			= "Menü";
$pgv_lang["header"]			= "Üst Başlık";
$pgv_lang["imageview"]				= "Resim Görüntüleyicisi";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]			= "PhpGedView Kullanıcı Girişi";
$pgv_lang["for_support"]		= "Teknik destek ve bilgi irtibat";
$pgv_lang["for_contact"]		= "Soyağacı soruları ile yardım için irtibat";
$pgv_lang["for_all_contact"]		= "Teknik destek yada soyağacı soruları için lütfen irtibat kurun";
$pgv_lang["choose_username"]		= "Kullanıcı adı";
$pgv_lang["username"]			= "Kullanıcı adı";
$pgv_lang["invalid_username"]		= "Kullanıcı adında geçersiz karakterler içeriyor";
$pgv_lang["firstname"]				= "Adı";
$pgv_lang["lastname"]				= "Soyadı";
$pgv_lang["choose_password"]		= "Şifre";
$pgv_lang["password"]			= "Şifre";
$pgv_lang["confirm"]			= "Şifreyi Tekrarla";
$pgv_lang["login"]			= "Giriş";
$pgv_lang["logout"]			= "Çıkış";
$pgv_lang["admin"]			= "Yönetici";
$pgv_lang["logged_in_as"]		= "Giriş yapılan kullanıcı adı ";
$pgv_lang["my_pedigree"]		= "Benim Soyağacı";
$pgv_lang["my_indi"]			= "Benim Birey Kayıtlar";
$pgv_lang["yes"]			= "Evet";
$pgv_lang["no"]				= "Hayır";
$pgv_lang["change_theme"]		= "Temayı Değiştir ";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Soyağacı Ağaç Çizelgesi";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# Nesil Soyağacı Çizgesi";
$pgv_lang["generations"]		= "Nesil";
$pgv_lang["view"]			= "Göster";
$pgv_lang["fam_spouse"]			= "Eş ile aile";
$pgv_lang["rootid"] 				= "Soyağacı Çizgesi Kök Kişi";
$pgv_lang["root_person"]		= "Kök Kişi ID";
$pgv_lang["hide_details"]		= "Detayları Gizle";
$pgv_lang["show_details"]		= "Detayları Göster";
$pgv_lang["zoom_box"]			= "Bu kutuyu yakınlaştır/uzaklaştır.";
$pgv_lang["orientation"]			= "Yönlendirme";
$pgv_lang["portrait"]			= "Portre";
$pgv_lang["landscape"]			= "Peyzaj";
$pgv_lang["landscape_top"]			= "Eneski üste";
$pgv_lang["landscape_down"]			= "Eneski altta";
$pgv_lang["start_at_parents"]		= "Ebeveynlerle başla";
$pgv_lang["charts"]			= "Çizgeler";
$pgv_lang["lists"]			= "Listeler";
$pgv_lang["box_width"]			= "Kutu genişliği";
$pgv_lang["random_surn"]					= "Rastgele soyadı";
$pgv_lang["generation_number"]		= "Nesiller";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "ID ile aile bulunamıyor";
$pgv_lang["unable_to_find_record"]	= "ID ile kayıt bulunamıyor";
$pgv_lang["title"]			= "Başlık";
$pgv_lang["living"]			= "Yaşayan";
$pgv_lang["private"]			= "Özel";
$pgv_lang["birth"]			= "Doğum:";
$pgv_lang["death"]			= "Ölü:";
$pgv_lang["descend_chart"]		= "Şahsı İzleyen Nesiller Çizelgesi";
$pgv_lang["individual_list"]		= "Bireyler";
$pgv_lang["family_list"]		= "Aileler";
$pgv_lang["branch_list"]			= "Dallar";
$pgv_lang["source_list"]		= "Kaynaklar";
$pgv_lang["shared_note_list"]		= "Paylaşılan Notlar";
$pgv_lang["place_list"]			= "Hiyerarşi Yerler";
$pgv_lang["place_list_aft"] 		= "Hiyerarşi Yerler sonra";
$pgv_lang["media_list"]			= "Çoklumedya";
$pgv_lang["repo_list"]			= "Havuzlar";
$pgv_lang["search"]			= "Ara";
$pgv_lang["clippings_cart"]		= "Aile Ağacı Kupürleri Çizelgesi";
$pgv_lang["print_preview"]		= "Yazdırma Önizleme";
$pgv_lang["cancel_preview"]		= "Normal görüntüye geri dön";
$pgv_lang["change_lang"]		= "Lisan Değiştir";
$pgv_lang["print"]			= "Yazdır";
$pgv_lang["total_queries"]		= "Toplam Veritabanı Sorgusu: ";
$pgv_lang["total_privacy_checks"]	= "Toplam mahremiyet kontrolü: ";
$pgv_lang["back"]			= "geri dön";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]					= "Olarak da bilinir";
$pgv_lang["male"]			= "Erkek";
$pgv_lang["males"]					= "Erkekler";
$pgv_lang["female"]			= "Kadın";
$pgv_lang["females"]				= "Kadınlar";
$pgv_lang["temple"]			= "SZA Tapınak";
$pgv_lang["temple_code"]		= "SZA Tapınak kodu:";
$pgv_lang["status"]			= "Durumu";
$pgv_lang["source"]			= "Kaynak";
$pgv_lang["text"]			= "Kaynak Metin:";
$pgv_lang["note"]			= "Not";
$pgv_lang["NN"]				= "(Soyadı bilinmiyor)";
$pgv_lang["PN"]				= "(Adı bilinmiyor)";
$pgv_lang["NNPN"]			= "(İsim bilinmiyor)";
// $pgv_lang["NNhebrew"] 		use value from lang.en.php
// $pgv_lang["PNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNPNhebrew"] 		use value from lang.en.php
// $pgv_lang["NNarabic"] 		use value from lang.en.php
// $pgv_lang["PNarabic"] 		use value from lang.en.php
// $pgv_lang["NNPNarabic"] 		use value from lang.en.php
// $pgv_lang["NNgreek"] 		use value from lang.en.php
// $pgv_lang["PNgreek"] 		use value from lang.en.php
// $pgv_lang["NNPNgreek"] 		use value from lang.en.php
// $pgv_lang["NNrussian"] 		use value from lang.en.php
// $pgv_lang["PNrussian"] 		use value from lang.en.php
// $pgv_lang["NNPNrussian"] 	use value from lang.en.php
// $pgv_lang["NNchinese"] 		use value from lang.en.php
// $pgv_lang["PNchinese"] 		use value from lang.en.php
// $pgv_lang["NNPNchinese"] 	use value from lang.en.php
// $pgv_lang["NNvietnamese"] 	use value from lang.en.php
// $pgv_lang["PNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNPNvietnamese"] 	use value from lang.en.php
// $pgv_lang["NNthai"] 			use value from lang.en.php
// $pgv_lang["PNthai"] 			use value from lang.en.php
// $pgv_lang["NNPNthai"] 		use value from lang.en.php
$pgv_lang["NNother"]			= "(Soyadı bilinmiyor)";
$pgv_lang["PNother"]			= "(Adı bilinmiyor)";
$pgv_lang["NNPNother"]			= "(İsim bilinmiyor)";
$pgv_lang["unrecognized_code"]		= "Tanınmayan GEDCOM kodu";
$pgv_lang["unrecognized_code_msg"]	= "Bu bir hatadır ve biz bunu düzeltmek istiyoruz. Lütfen bu hata rapor edin";
$pgv_lang["indi_info"]			= "Birey Bilgi";
$pgv_lang["pedigree_chart"]		= "Soyağacı Ağaç Çizelgesi";
$pgv_lang["individual"]				= "Birey";
$pgv_lang["as_spouse"]			= "Eş ile Aile";
$pgv_lang["privacy_error"]		= "Bu bilgiler özel veya giriş yamadınız.";
$pgv_lang["more_information"]		= "Daha fazla bilgi için irtibat:";
$pgv_lang["given_name"]			= "Adı:";
$pgv_lang["surname"]			= "Soyadı:";
$pgv_lang["suffix"]			= "Sonek:";
$pgv_lang["sex"]			= "Cinsiyet";
$pgv_lang["personal_facts"]		= "Kişisel Olgular ve Detaylar";
$pgv_lang["type"]			= "Tipi";
$pgv_lang["parents"]			= "Ebeveynler";
$pgv_lang["gparents"]				= "Büyükebeveynler";
$pgv_lang["siblings"] 			= "Kardeşler";
$pgv_lang["father"]			= "Baba";
$pgv_lang["mother"]			= "Anne";
$pgv_lang["parent"] 				= "Ebeveyn";
$pgv_lang["parent_age"] 			= "Ebeveynin yaşı";
$pgv_lang["father_age"]				= "Babanın yaşı";
$pgv_lang["mother_age"]				= "Annenin yaşı";
$pgv_lang["self"] 					= "Kendi";
$pgv_lang["relatives"]			= "Yakın Akrabalar";
$pgv_lang["relatives_events"]		= "Yakın akrabaların hadiseleri";
$pgv_lang["historical_facts"]		= "Tarihi olgular";
$pgv_lang["partner"] 				= "Ortak";
$pgv_lang["spouse"]			= "Eş";
$pgv_lang["spouses"] 				= "Eşler";
$pgv_lang["surnames"]			= "Soyadlar";
$pgv_lang["adopted"]			= "Evlatlık";
$pgv_lang["foster"]			= "Besleme";
$pgv_lang["sealing"]				= "Kapatma";
$pgv_lang["challenged"]				= "Meydan okuyan";
$pgv_lang["disproved"]				= "Yalanlanmış";
$pgv_lang["infant"]					= "Bebek";
$pgv_lang["stillborn"]				= "Ölü doğan";
$pgv_lang["deceased"]				= "Merhum";
$pgv_lang["link_as_wife"]			= "Bu kişiyi mevcut aileye hanım eş olarak bağla";
$pgv_lang["no_tab1"]				= "Bu birey için hiçbir Olgu mevcut değil.";
$pgv_lang["no_tab2"]				= "Bu birey için hiçbir Not mevcut değil.";
$pgv_lang["no_tab3"]				= "Bu birey için hiçbir Kaynak atıfları mevcut değil.";
$pgv_lang["no_tab4"]				= "Bu birey için hiçbir Medya öğeleri mevcut değil.";
$pgv_lang["no_tab5"]				= "Bu birey için hiçbir Yakın akrabaları mevcut değil.";
$pgv_lang["no_tab6"]				= "Bu birey için hiçbir Eklentili araştırma günlükleri mevcut değil.";
$pgv_lang["show_fact_sources"]		= "Tüm kaynakları göster";
$pgv_lang["show_fact_notes"]		= "Tüm notları göster";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Aile bilgisi";
$pgv_lang["family_group_info"]		= "Aile Grup Bilgisi";
$pgv_lang["husband"]			= "Koca";
$pgv_lang["wife"]			= "Hanım";
$pgv_lang["marriage"]			= "Nikah:";
$pgv_lang["lds_sealing"]			= "SZA Kapatma:";
$pgv_lang["marriage_license"]		= "Evlilik Cüzdanı:";
$pgv_lang["no_children"]		= "Çocuk yok";
$pgv_lang["known_child"]			= "1 çocuk";
$pgv_lang["known_children"]			= "çocuklar";
$pgv_lang["childless_family"]		= "Bu aile çocuksuz kaldı";
$pgv_lang["parents_timeline"]		= "Çifti zaman çizelgesinde göster";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Küpüler Sepeti";
$pgv_lang["which_links"]		= "Bu aileden olan diğer bağlantılar eklemek istiyor musunuz?";
$pgv_lang["just_family"]		= "Sadece bu aile kaydı ekle.";
$pgv_lang["parents_and_family"]		= "Bu aile kaydı ile birlikte ebeveynler kayıtları ekle.";
$pgv_lang["parents_and_child"]		= "Bu aile kaydı ile birlikte ebeveynler ve çocuklar kayıtları ekle.";
$pgv_lang["parents_desc"]		= "Bu aile kaydı ile birlikte ebeveynler ve zürriyetliler kayıtları ekle.";
$pgv_lang["continue"]			= "Eklemeye Devam";
$pgv_lang["which_p_links"]		= "Bu kişiden hangi bağlantıları eklemek istiyorsunuz?";
$pgv_lang["just_person"]		= "Sadece bu kişiyi ekle.";
$pgv_lang["person_parents_sibs"]	= "Bu kişiyi, ebeveyni, ve kardeşlerini ekle.";
$pgv_lang["person_ancestors"]		= "Bu kişiyi ve doğrudan atalarına kadar ekle.";
$pgv_lang["person_ancestor_fams"]	= "Bu kişiyi, doğrudan atalarına kadar ve ailelerini ekle.";
$pgv_lang["person_spouse"]		= "Bu kişiyi, eşini, ve çocuklarını ekle.";
$pgv_lang["person_desc"]		= "Bu kişiyi, eşini, ve tüm zürriyetlerini ekle.";
$pgv_lang["which_s_links"]			= "Bu kaynaklar hangi kayıtlara bağlanması için ekensin?";
$pgv_lang["just_source"]		= "Sadece bu kaynağı ekle.";
$pgv_lang["linked_source"]		= "Bu kaynağı ve bağlanan kişi veya ailelere ekle.";
$pgv_lang["person_private"]		= "Bu kişi hakkında detaylar özeldir. Kişisel detaylar içeremez.";
$pgv_lang["family_private"]		= "Bu aile hakkında detaylar özeldir. Aile detayları içeremez.";
$pgv_lang["media_private"] 			= "Bu medya alanı özeldir. Medya detayları içeremez.";
$pgv_lang["download"]			= "Dosyaları indirmek için aşağıdaki linklere sağ tıklatın (Macintosh üzerinde control-click) seçin ve &quot;Hedefi Farklı Kaydet&quot;.";
$pgv_lang["cart_is_empty"]		= "Kupürler Sepetiniz boş.";
$pgv_lang["id"]				= "ID";
$pgv_lang["ID"] 					= "ID";
$pgv_lang["name_description"]		= "Adı / Açıklama";
$pgv_lang["remove"]			= "Kaldır";
$pgv_lang["empty_cart"]			= "Sepeti Boşalt";
$pgv_lang["download_now"]		= "Şimdi İndir";
$pgv_lang["download_file"]			= "Dosya indir #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "Bu bireyin bilgileri buradan indirildi:";
$pgv_lang["family_downloaded_from"]	= "Bu ailenin bilgileri buradan indirildi:";
$pgv_lang["source_downloaded_from"]	= "Bu kaynağın bilgileri buradan indirildi:";
$pgv_lang["enter_person_generations"] = "Nesillerin sayısı";
$pgv_lang["convertPath"]			= "Medya yolu dönüştür";
$pgv_lang["convertSlashes"]			= "Medya klasör ayırıcıları dönüştür";
$pgv_lang["forwardSlashes"]			= "Sağa eğik çizgi : /";
$pgv_lang["backSlashes"]			= "Sola eğik çizgi : \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Yer bağlantıları bulundu";
$pgv_lang["top_level"]			= "Üst Düzey";
$pgv_lang["form"]			= "Yerler bu şekilde kodlanır: ";
$pgv_lang["default_form"]		= "Semt, İlçe, İl, Ülke";
$pgv_lang["default_form_info"]		= "(Varsayılan)";
$pgv_lang["unknown"]			= "bilinmiyor";
$pgv_lang["individuals"]		= "Bireyler";
$pgv_lang["view_records_in_place"]	= "Bu yerin bulunan tüm kayıtları göster";
$pgv_lang["place_list2"]		= "Yer listesi";
$pgv_lang["show_place_hierarchy"]	= "Hiyerarşide Yerleri Göster";
$pgv_lang["show_place_list"]		= "Bir Listede Tüm Yerleri Göster";
$pgv_lang["total_unic_places"]		= "Toplam Benzersiz Yerler";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "Dış öğeler";
$pgv_lang["multi_title"]		= "ÇokluMedya Öğeleri";
$pgv_lang["media_found"]		= "Bulunan medya öğeleri";
$pgv_lang["view_person"]		= "Kişiyi Görüntüle";
$pgv_lang["view_family"]		= "Aileyi Görüntüle";
$pgv_lang["view_source"]		= "Kaynağı Görüntüle";
$pgv_lang["view_object"]			= "Öğeyi Görüntüle";
$pgv_lang["first_page"]				= "İlk sayfa";
$pgv_lang["previous_page"]			= "Önceki sayfa";
$pgv_lang["next_page"]				= "Sonraki sayfa";
$pgv_lang["last_page"]				= "Son sayfa";
$pgv_lang["next_image"]				= "Sonraki resim";
$pgv_lang["file_not_found"]		= "Dosya bulunamadı";
$pgv_lang["medialist_show"] 		= "Göster";
$pgv_lang["per_page"]			= "Sayfa başı medya öğeleri";
$pgv_lang["media_format"]			= "Medya Biçimi";
$pgv_lang["image_size"]				= "Resim Boyutları";
$pgv_lang["media_id"]			= "Medya ID";
$pgv_lang["invalid_id"]			= "Bu GEDCOM dosyada böyle mevcut ID yok.";
$pgv_lang["record_updated"]			= "Kayıt #pid# başarıyla güncellendi.";
$pgv_lang["record_not_updated"]		= "Kayıt #pid# güncelleştirilmedi.";
$pgv_lang["record_removed"]			= "Kayıt #xref# GEDCOM dan başarıyla kaldırıldı.";
$pgv_lang["record_not_removed"]		= "Kayıt #xref# GEDCOM dan kaldırılamadı.";
$pgv_lang["record_added"]			= "Kayıt #xref# GEDCOM a başarıyla eklendi.";
$pgv_lang["record_not_added"]		= "Kayıt #xref# GEDCOM a eklenemedi.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"]		= "Adı yazılı olduğunu düşündüğünüz gibi arayın (Soundex)";
$pgv_lang["sources"]			= "Kaynaklar";
$pgv_lang["shared_notes"]			= "Paylaşılan Notlar";
$pgv_lang["lastname_search"]		= "Soyadı";
$pgv_lang["search_place"]		= "Yer";
$pgv_lang["search_year"]		= "Yıl";
$pgv_lang["no_results"]			= "Hiçbir sonuç bulunmadı.";
$pgv_lang["search_soundex"]			= "Soundex Ara";
$pgv_lang["search_replace"]			= "Ara ve Değiştir";
$pgv_lang["search_sources"]			= "Kaynaklar";
$pgv_lang["search_shared_notes"]	= "Paylaşılan Notlar";
$pgv_lang["search_more_chars"]      = "Lütfen birden fazla karakter giriniz";
$pgv_lang["search_soundextype"]		= "Soundex tipi:";
$pgv_lang["search_russell"]			= "Temel";
$pgv_lang["search_tagfilter"]		= "Filtre Hariç";
$pgv_lang["search_tagfon"]			= "Soyağacına ait olmayan bazı veriler hariç";
$pgv_lang["search_tagfoff"]			= "Kapalı";
$pgv_lang["associate"]				= "ilişkilendir";
$pgv_lang["search_record"]			= "Tam kayıt";
$pgv_lang["search_to"]				= "için";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]			= "Başlıklar";
$pgv_lang["find_source"]			= "Kaynak Bul";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 			= "Havuz";
$pgv_lang["repos_found"]		= "Havuzlar bulundu";
$pgv_lang["find_repository"]		= "Havuzu Bul";
$pgv_lang["total_repositories"]		= "Toplam Havuzlar";
$pgv_lang["confirm_delete_repo"]	= "Bu Havuzu silmek istediğinizden emin misiniz?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Kaynak Bilgisi";
$pgv_lang["people"]			= "Kişi";
$pgv_lang["families"]			= "Aileler";
$pgv_lang["total_sources"]		= "Toplam Kaynaklar";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]				= "Paylaşılan Not";
$pgv_lang["shared_notes_found"]			= "Paylaşılan Notlar bulundu";
$pgv_lang["find_shared_note"]			= "Paylaşılan Notu Bul";
$pgv_lang["shared_note_info"]			= "Paylaşılan Not Bilgisi";
$pgv_lang["total_shared_notes"]			= "Toplam Paylaşılan Notlar";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]		= "Geçersiz GEDCOM biçimi";
$pgv_lang["exec_time"]			= "Çalışma süresi:";
$pgv_lang["unable_to_create_index"]	= "Dizin dosyaları oluşturulamıyor. PhpGedView dizin izinlerinin ayarlandığından emin olunuz. Dizin dosyası yazıabilir izni verildikten sonra tekra geri alınabilir.";
$pgv_lang["changes_present"]		= "Geçerli GEDCOM dosyada son değişiklikler beklemede incelenmeye hazır. Eğer içeri aktarmaya devam ederseniz son değişiklikler çıkartılacaktır. İçeri aktarmadan önce son değişiklikler incelenmeliydi.";
$pgv_lang["sec"]			= "saniye.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Toplam aileler";
$pgv_lang["total_indis"]		= "Toplam bireyler";
$pgv_lang["notes"]			= "Notlar";
$pgv_lang["ssourcess"]			= "Kaynaklar";
$pgv_lang["media"]			= "Medya";
$pgv_lang["name_contains"]		= "Adı içerdiği:";
$pgv_lang["filter"]			= "Filtre";
$pgv_lang["apply_filter"]			= "Filtreyi uygula";
$pgv_lang["find_individual"]		= "Birey ID Bul";
$pgv_lang["find_familyid"]		= "Aile ID Bul";
$pgv_lang["find_sourceid"]		= "Kaynak ID Bul";
$pgv_lang["find_specialchar"]		= "Özel Karakterler Bul";
$pgv_lang["magnify"]				= "Büyütme";
$pgv_lang["skip_surnames"]		= "Soyadı listesini atla";
$pgv_lang["show_surnames"]		= "Soyadı listesini göster";
$pgv_lang["skip_marnms"]			= "Evli adlar hariç";
$pgv_lang["show_marnms"]			= "Evli adlar dahil";
$pgv_lang["all"]			= "HEPSİ";
$pgv_lang["hidden"]			= "Gizli";
$pgv_lang["confidential"]		= "Gizli";
$pgv_lang["alpha_index"]				= "Alfabetik Dizin";
$pgv_lang["name_list"] 				= "Adı Listesi";
$pgv_lang["firstname_alpha_index"] 	= "Alfabetik Dizin Adı";
$pgv_lang["roots"]		 				= "Kökler";
$pgv_lang["leaves"] 					= "Ayrılmalar";
$pgv_lang["widow"] 					= "Dul kadın";
$pgv_lang["widower"] 				= "Dul erkek";
$pgv_lang["show_parents"] 			= "Ebeveynleri göster";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Yaş";
$pgv_lang["husb_age"]				= "Kocanın yaşı";
$pgv_lang["wife_age"]				= "Hanımın yaşı";
$pgv_lang["year1"]					= "Yıl";
$pgv_lang["years2"]					= "yıl";
$pgv_lang["years"]					= "yıl";
$pgv_lang["month1"]					= "ay";
$pgv_lang["months"]					= "ay";
$pgv_lang["week1"]					= "hafta";
$pgv_lang["weeks"]					= "hafta";
$pgv_lang["day1"]					= "gün";
$pgv_lang["days"]					= "gün";
$pgv_lang["after_death"]        ="ölümden sonra";
$pgv_lang["at_death_day"]      		= "ölümün tarihinde";
$pgv_lang["timeline_title"]		= "PhpGedView zaman çizelgesi";
$pgv_lang["timeline_chart"]		= "Zaman çizgideki Çizelgesi";
$pgv_lang["remove_person"]		= "Kişiyi Kaldır";
$pgv_lang["show_age"]			= "Yaş İşaretleyici Göster";
$pgv_lang["add_another"]		= "Çizelgeye başka kişi ekle:<br />Kişi ID:";
$pgv_lang["find_id"]			= "ID Bul";
$pgv_lang["show"]			= "Göster";
$pgv_lang["year"]			= "Yıl:";
$pgv_lang["zoom_in"]			= "Yakınlaştır";
$pgv_lang["zoom_out"]			= "Uzaklaştır";
$pgv_lang["timeline_beginYear"] = "Başlangıç Yılı";
$pgv_lang["timeline_endYear"] = "Bitiş Yılı";
$pgv_lang["timeline_scrollSpeed"] = "Hız";
$pgv_lang["timeline_controls"] = "Zaman çizgi Kontrolleri";
$pgv_lang["include_family"] = "Çekirdek Aile İçer";
$pgv_lang["lifespan_chart"] = "Ömür Çizelgesi";

// calendar conversion options
$pgv_lang["cal_none"]                 = "Takvim dönüştürme hayır";
$pgv_lang["cal_gregorian"]            = "Miladi";
$pgv_lang["cal_julian"]               = "Rumi";
$pgv_lang["cal_french"]               = "Fransız";
$pgv_lang["cal_jewish"]               = "Yahudi";
$pgv_lang["cal_hebrew"]               = "İbrani";
$pgv_lang["cal_jewish_and_gregorian"] = "Yahudi ve Miladi";
$pgv_lang["cal_hebrew_and_gregorian"] = "İbrani ve Miladi";
$pgv_lang["cal_hijri"]                = "Hicri";
$pgv_lang["cal_arabic"]               = "Arapça";

// some religious dates
$pgv_lang["easter"]     = "Paskalya";
$pgv_lang["ascension"]  = "Miraç";
$pgv_lang["pentecost"]  = "Hamsin bayramı";
$pgv_lang["assumption"] = "Varsayım";
$pgv_lang["all_saints"] = "Tüm azizler";
$pgv_lang["christmas"]  = "Noel";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]         = "öö";
$pgv_lang["p.m."]         = "ös";
$pgv_lang["noon"]         = "öğle";
$pgv_lang["midn"]         = "ge-ya";

//-- MONTH NAMES
$pgv_lang["jan"]			= "Ocak";
$pgv_lang["feb"]			= "Şubat";
$pgv_lang["mar"]			= "Mart";
$pgv_lang["apr"]			= "Nisan";
$pgv_lang["may"]			= "Mayıs";
$pgv_lang["jun"]			= "Haziran";
$pgv_lang["jul"]			= "Temmuz";
$pgv_lang["aug"]			= "Ağustos";
$pgv_lang["sep"]			= "Eylül";
$pgv_lang["oct"]			= "Ekim";
$pgv_lang["nov"]			= "Kasım";
$pgv_lang["dec"]			= "Aralık";

// $pgv_lang["vend"]			use value from lang.en.php
// $pgv_lang["brum"]			use value from lang.en.php
// $pgv_lang["frim"]			use value from lang.en.php
// $pgv_lang["nivo"]			use value from lang.en.php
// $pgv_lang["pluv"]			use value from lang.en.php
// $pgv_lang["vent"]			use value from lang.en.php
// $pgv_lang["germ"]			use value from lang.en.php
// $pgv_lang["flor"]			use value from lang.en.php
// $pgv_lang["prai"]			use value from lang.en.php
// $pgv_lang["mess"]			use value from lang.en.php
// $pgv_lang["ther"]			use value from lang.en.php
// $pgv_lang["fruc"]			use value from lang.en.php
// $pgv_lang["comp"]			use value from lang.en.php

// $pgv_lang["tsh"]				use value from lang.en.php
// $pgv_lang["csh"]				use value from lang.en.php
// $pgv_lang["ksl"]				use value from lang.en.php
// $pgv_lang["tvt"]				use value from lang.en.php
// $pgv_lang["shv"]				use value from lang.en.php
// $pgv_lang["adr"]				use value from lang.en.php
// $pgv_lang["adr_leap_year"]	use value from lang.en.php
// $pgv_lang["ads"]				use value from lang.en.php
// $pgv_lang["nsn"]				use value from lang.en.php
// $pgv_lang["iyr"]				use value from lang.en.php
// $pgv_lang["svn"]				use value from lang.en.php
// $pgv_lang["tmz"]				use value from lang.en.php
// $pgv_lang["aav"]				use value from lang.en.php
// $pgv_lang["ell"]				use value from lang.en.php

// $pgv_lang["muhar"]			use value from lang.en.php
// $pgv_lang["safar"]			use value from lang.en.php
// $pgv_lang["rabia"]			use value from lang.en.php
// $pgv_lang["rabit"]			use value from lang.en.php
// $pgv_lang["jumaa"]			use value from lang.en.php
// $pgv_lang["jumat"]			use value from lang.en.php
// $pgv_lang["rajab"]			use value from lang.en.php
// $pgv_lang["shaab"]			use value from lang.en.php
// $pgv_lang["ramad"]			use value from lang.en.php
// $pgv_lang["shaww"]			use value from lang.en.php
// $pgv_lang["dhuaq"]			use value from lang.en.php
// $pgv_lang["dhuah"]			use value from lang.en.php

$pgv_lang["b.c."]         = "M.Ö.";

$pgv_lang["abt"]			= "civarında";
$pgv_lang["aft"]			= "sonra";
$pgv_lang["and"]			= "ve";
$pgv_lang["bef"]			= "önce";
$pgv_lang["bet"]			= "arasında";
$pgv_lang["cal"]			= "hesaplanmış";
$pgv_lang["est"]			= "tahmini";
$pgv_lang["from"]			= "bundan";
$pgv_lang["int"]			= "yorumlanmış";
$pgv_lang["to"]				= "için";
$pgv_lang["cir"]			= "aşağı yukarı";
$pgv_lang["apx"]			= "yaklaşık.";

//-- Admin File Messages
$pgv_lang["password_mismatch"]		= "Şifreler birbirine uymuyor.";
$pgv_lang["enter_username"]		= "Kullanıcı adı girmelisiniz.";
$pgv_lang["enter_password"]		= "Şifre girmelisiniz.";
$pgv_lang["save"]			= "Kaydet";
$pgv_lang["saveandgo"]		= "Kaydet ve yeni kayıda git";
$pgv_lang["delete"]			= "Sil";
$pgv_lang["edit"]			= "Düzelt";
$pgv_lang["no_login"]			= "Giriş Başarısız, Olası nedenler.<br />1. Kullanıcı Adı veya Şifre yanlış giriyorsunuz.<br />2. Hesabinizi Siz veya Yönetici tarafından onaylanmadı.<br />3. Böyle bir hesap mevcut değildir.<br />Eğer bunlardan biri değil ise lütfen sayfa dibindeki yönetici bağlantısı ile bağlantı kurun.";
$pgv_lang["basic_realm"]			= "PhpGedView Denetim Sistemi";
$pgv_lang["basic_auth_failure"]		= "Bu kaynağa erişmek için bir geçerli giriş ID ve şifre girmeniz gerekir";
$pgv_lang["basic_auth"]				= "Temel Doğrulama";
$pgv_lang["digest_auth"]				= "Doğrulamayı Kabul et";
$pgv_lang["no_auth_needed"]			= "Doğrulama Yok";
$pgv_lang["file_not_exists"]		= "Girilen dosya adı mevcut değil.";
$pgv_lang["research_assistant"]		= "Araştırma Asıstanı";
$pgv_lang["utf8_to_ansi"]		= "UTF-8 den ANSI (ISO-8859-1) dönüştür";
$pgv_lang["media_linked"]			= "Bu medya öğesi aşağıdakilere bağlıdır:";
$pgv_lang["media_not_linked"]		= "Bu medya öğesi herhangi bir GEDCOM kaydına bağlı değildir.";
$pgv_lang["media_dir_1"]			= "Bu medya öğesi dış sunucuda barınıyor";
$pgv_lang["media_dir_2"]			= "Bu medya öğesi standart medya klasöründedir";
$pgv_lang["media_dir_3"]			= "Bu medya öğesi korumalı medya klasöründedir";
$pgv_lang["thumb_dir_1"]			= "Bu tırnak önizeme dış sunucuda barınıyor";
$pgv_lang["thumb_dir_2"]			= "Bu tırnak önizleme standart medya klasöründedir";
$pgv_lang["thumb_dir_3"]			= "Bu tırnak önizleme korumalı medya klasöründedir";
$pgv_lang["moveto_2"]				= "Korumalı klasöre taşı";
$pgv_lang["moveto_3"]				= "Standart klasöre taşı";
$pgv_lang["move_standard"]			= "Standarda taşı";
$pgv_lang["move_protected"]		= "Korumalıya taşı";
$pgv_lang["move_mediadirs"]			= "Medya klasörüne taşı";
$pgv_lang["setperms"]				= "Medya İzinleri Ayarla";
$pgv_lang["setperms_fix"]			= "Okuma/yazma/yürütme izinleri düzelt";
$pgv_lang["setperms_success"]		= "İzinleri Ayarla";
$pgv_lang["setperms_failure"]		= "İzinler Ayarlı Değil";
$pgv_lang["setperms_time_exceeded"]	= "Yürütme süre sınırına ulaşmıştır. Küçük bir dizin komutu yeniden deneyin.";
$pgv_lang["move_time_exceeded"]	= "Yürütme süre sınırına ulaşmıştır.Komut dosyaları geri kalanı taşımak için tekrar deneyin.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "Rica edilen Medya Güvenlik Duvarı kök klasörü mevcut değil. Önce oluşturanız gerekir.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "Medya Güvenlik Duvarı kök klasörü korumalı medya klasörü oluşturulamadı. Lütfen global-yazılabilir yaparak ve bu klasörü oluşturun.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Medya Güvenlik Duvarı kök klasöründe korumalı medya klasörü global-yazılabilir değildir.";
$pgv_lang["media_firewall_invalid_dir"]	= "Not: Medya Güvenlik Duvarı medya klasörü başka bir klasöre başlatıldı.";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]	= "Detaylar için Görüntüle ...";
$pgv_lang["view_fam_nav_notes"]		= "Notlar için Görüntüle ...";
$pgv_lang["view_fam_nav_sources"]	= "Kaynaklar için Görüntüle ...";
$pgv_lang["view_fam_nav_media"]		= "Medya için Görüntüle ...";
$pgv_lang["view_fam_nav_album"]		= "Albüm için Görüntüle ...";
$pgv_lang["view_fam_nav_relatives"]	= "Akrabaları için Görüntüle ...";
$pgv_lang["view_fam_nav_tree"]		= "Ağaç için Görüntüle ...";
$pgv_lang["view_fam_nav_research"]	= "Araştırma için Görüntüle ...";
$pgv_lang["view_fam_nav_map"]		= "Harita için Görüntüle ...";
$pgv_lang["view_fam_nav_spare"]		= "Yedek-bilgi için Görüntüle ...";
$pgv_lang["navigator"]				= "Navigasyon";
$pgv_lang["fam_navigator"]			= "Aile Navigasyonu";

$pgv_lang["relationship_great"]		= "Büyük";
$pgv_lang["relationship_chart"]		= "Akrabalık Bağı Çizelgesi";
$pgv_lang["person1"]			= "Kişi 1";
$pgv_lang["person2"]			= "Kişi 2";
$pgv_lang["no_link_found"]		= "Iki birey arasında herhangi bir bağlantı bulunamadı.";
$pgv_lang["no_other_link_found"]	= "Diğer iki birey arasında hiçbir bağlantı bulunamadı.";
$pgv_lang["sibling"]			= "Kardeş";
$pgv_lang["follow_spouse"]		= "Evlilik yoluyla akrabalık bağı kontrol et";
$pgv_lang["timeout_error"]		= "Bir ilişki bulamadan önce script zaman aşımına uğradı.";
$pgv_lang["grandchild"]				= "Torun";
$pgv_lang["grandson"]				= "Erkek torun";
$pgv_lang["granddaughter"]			= "Kız torun";
$pgv_lang["greatgrandchild"]		= "Büyük torun";
$pgv_lang["greatgrandson"]			= "Büyük erkek torun";
$pgv_lang["greatgranddaughter"]		= "Büyük kız torun";
$pgv_lang["brother"]			= "Erkek kardeş";
$pgv_lang["sister"]			= "Kız kardeşi";
$pgv_lang["aunt"]					= "Teyze";
$pgv_lang["uncle"]				= "Amca";
$pgv_lang["nephew"]				= "Erkek yeğen";
$pgv_lang["niece"]				= "Kız yeğen";
$pgv_lang["firstcousin"]			= "İlk kuzen";
$pgv_lang["femalecousin"]			= "Kadın kuzen";
$pgv_lang["malecousin"]				= "Erkek kuzen";
$pgv_lang["relationship_to_me"]		= "Benimle akrabalık bağı";
$pgv_lang["rela_husb"]				= "Kocayla akrabalık bağı";
$pgv_lang["rela_wife"]				= "Hanımla akrabalık bağı";
$pgv_lang["next_path"]				= "Sonraki yolu bul";
$pgv_lang["show_path"]				= "Yolu göster";
$pgv_lang["line_up_generations"]	= "Ayni kuşaktan olan şahısları bir seviyede göster";
$pgv_lang["oldest_top"]			= "En yaşlıları en üstte göster";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%3\$s kişinin %2\$s %1\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%3\$s kişinin %2\$s %1\$s.";

$pgv_lang["mother_in_law"]		    = "Kayınvalidesi";
$pgv_lang["father_in_law"]		    = "Kayınpederi";
$pgv_lang["brother_in_law"]		    = "Kayınbiraderi-";
$pgv_lang["sister_in_law"]		    = "Baldız-Elti-Görümce-Genge biridir";
$pgv_lang["brothers_wife"]		= "Yengesi veya Gelini"; // brother's wife
$pgv_lang["son_in_law"]		        = "Damadı";
$pgv_lang["daughter_in_law"]		= "Gelini";
$pgv_lang["uncle_in_law"]			= "Eniştesi";
$pgv_lang["aunt_in_law"]			= "Yengesi";
$pgv_lang["cousin_in_law"]		= "Kuzeni";
$pgv_lang["m_cousin_in_law"]		= "Kuzenin annesi";
$pgv_lang["f_cousin_in_law"]		= "Kuzenin babası";
$pgv_lang["step_son"]		        = "üvey oğlu";
$pgv_lang["step_daughter"]	    	= "üvey kızı";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"] 				= "erkek yeğeni";
$pgv_lang["bosa_brothers_offspring_3"] 				= "kız yeğeni";
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"] 				= "büyük erkek yeğeni";
$pgv_lang["bosa_brothers_offspring_5"] 				= "büyük kız yeğeni";
$pgv_lang["bosa_brothers_offspring_6"] 				= "büyük erkek yeğeni";
$pgv_lang["bosa_brothers_offspring_7"] 				= "büyük kız yeğeni";
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x büyük erkek yeğeni";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x büyük kız yeğeni";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"] 				= "erkek yeğeni";
$pgv_lang["bosa_sisters_offspring_3"] 				= "kız yeğeni";
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"] 				= "büyük erkek yeğeni";
$pgv_lang["bosa_sisters_offspring_5"] 				= "büyük kız yeğeni";
$pgv_lang["bosa_sisters_offspring_6"] 				= "büyük erkek yeğeni";
$pgv_lang["bosa_sisters_offspring_7"] 				= "büyük kız yeğeni";
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x büyük erkek yeğeni";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x büyük kız yeğeni";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= "oğlu";
$pgv_lang["bosa_3"] 				= "kız evladı";
// 2nd generation
$pgv_lang["bosa_4"] 				= "erkek torunu";
$pgv_lang["bosa_5"] 				= "kız torunu";
$pgv_lang["bosa_6"] 				= "erkek torunu";
$pgv_lang["bosa_7"] 				= "kız torunu";
// 3rd generation
$pgv_lang["bosa_8"] 				= "büyük erkek torunu";
$pgv_lang["bosa_9"] 				= "büyük kız torunu";
$pgv_lang["bosa_10"] 				= "büyük erkek torunu";
$pgv_lang["bosa_11"] 				= "büyük kız torunu";
$pgv_lang["bosa_12"] 				= "büyük erkek torunu";
$pgv_lang["bosa_13"] 				= "büyük kız torunu";
$pgv_lang["bosa_14"] 				= "büyük erkek torunu";
$pgv_lang["bosa_15"] 				= "büyük kız torunu";
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x büyük erkek torunu";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x büyük kız torunu";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x büyük erkek torunu";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x büyük kız torunu";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= "amcası";
$pgv_lang["sosa_uncle_3"] 				= "dayısı";
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "büyük amca";
$pgv_lang["sosa_uncle_5"] 				= "büyük dayısı";
$pgv_lang["sosa_uncle_6"] 				= "büyük amca";
$pgv_lang["sosa_uncle_7"] 				= "büyük dayısı";
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x büyük amcası";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x büyük dayısı";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= "halası";
$pgv_lang["sosa_aunt_3"] 				= "teyzesi";
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "büyük halası";
$pgv_lang["sosa_aunt_5"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_6"] 				= "büyük halası";
$pgv_lang["sosa_aunt_7"] 				= "büyük teyze";
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x büyük halası";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x büyük teyzesi";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 				= "amcası";
$pgv_lang["sosa_uncle_bm_3"] 				= "dayısı";
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 				= "büyük amcası";
$pgv_lang["sosa_uncle_bm_5"] 				= "büyük dayısı";
$pgv_lang["sosa_uncle_bm_6"] 				= "büyük amcası";
$pgv_lang["sosa_uncle_bm_7"] 				= "büyük dayısı";
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x büyük amcası";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x büyük dayısı";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 				= "halası";
$pgv_lang["sosa_aunt_bm_3"] 				= "teyzesi";
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 				= "büyük halası";
$pgv_lang["sosa_aunt_bm_5"] 				= "büyük teyzesi";
$pgv_lang["sosa_aunt_bm_6"] 				= "büyük halası";
$pgv_lang["sosa_aunt_bm_7"] 				= "büyük teyzesi";
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x büyük halası";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x büyük teyzesi";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              = "ilk kuzeni";
$pgv_lang["male_cousin_2"]              = "ikinci kuzeni";
$pgv_lang["male_cousin_3"]              = "üçüncü kuzeni";
$pgv_lang["male_cousin_4"]              = "dördüncü kuzeni";
$pgv_lang["male_cousin_5"]              = "beşinci kuzeni";
$pgv_lang["male_cousin_6"]              = "altıncı kuzeni";
$pgv_lang["male_cousin_7"]              = "yedinci kuzeni";
$pgv_lang["male_cousin_8"]              = "sekizinci kuzeni";
$pgv_lang["male_cousin_9"]              = "dokuzuncu kuzeni";
$pgv_lang["male_cousin_10"]             = "onuncu kuzeni";
$pgv_lang["male_cousin_11"]             = "onbirinci kuzeni";
$pgv_lang["male_cousin_12"]             = "onikinci kuzeni";
$pgv_lang["male_cousin_13"]             = "onüçüncü kuzeni";
$pgv_lang["male_cousin_14"]             = "ondördüncü kuzeni";
$pgv_lang["male_cousin_15"]             = "onbeşinci kuzeni";
$pgv_lang["male_cousin_16"]             = "onaltıncı kuzeni";
$pgv_lang["male_cousin_17"]             = "onyedinci kuzeni";
$pgv_lang["male_cousin_18"]             = "onsekizinci kuzeni";
$pgv_lang["male_cousin_19"]             = "ondokuzuncu kuzeni";
$pgv_lang["male_cousin_20"]             = "yirminci kuzeni";
$pgv_lang["male_cousin_n"]              = "%d x kuzeni";
$pgv_lang["female_cousin_1"]            = "ilk kuzeni";
$pgv_lang["female_cousin_2"]            = "ikinci kuzeni";
$pgv_lang["female_cousin_3"]            = "üçüncü kuzeni";
$pgv_lang["female_cousin_4"]            = "dördüncü kuzeni";
$pgv_lang["female_cousin_5"]            = "beşinci kuzeni";
$pgv_lang["female_cousin_6"]            = "altıncı kuzeni";
$pgv_lang["female_cousin_7"]            = "yedinci kuzeni";
$pgv_lang["female_cousin_8"]            = "sekizinci kuzeni";
$pgv_lang["female_cousin_9"]            = "dokuzuncu kuzeni";
$pgv_lang["female_cousin_10"]           = "onuncu kuzeni";
$pgv_lang["female_cousin_11"]           = "onbirinci kuzeni";
$pgv_lang["female_cousin_12"]           = "onikinci kuzeni";
$pgv_lang["female_cousin_13"]           = "onüçüncü kuzeni";
$pgv_lang["female_cousin_14"]           = "ondördüncü kuzeni";
$pgv_lang["female_cousin_15"]           = "onbeşinci kuzeni";
$pgv_lang["female_cousin_16"]           = "onaltıncı kuzeni";
$pgv_lang["female_cousin_17"]           = "onyedinci kuzeni";
$pgv_lang["female_cousin_18"]           = "onsekizinci kuzeni";
$pgv_lang["female_cousin_19"]           = "ondokuzuncu kuzeni";
$pgv_lang["female_cousin_20"]           = "yirminci kuzeni";
$pgv_lang["female_cousin_n"]            = "%d x kuzeni";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]   = " birkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_2"]   = " ikikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_3"]   = " üçkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_4"]   = " dörtkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_5"]   = " beşkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_6"]   = " altıkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_7"]   = " yedikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_8"]   = " sekizkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_9"]   = " dokuzkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_10"]  = " onkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_11"]  = " onbirkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_12"]  = " onikikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_13"]  = " onüçkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_14"]  = " ondörtkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_15"]  = " onbeşkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_16"]  = " onaltikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_17"]  = " onyedikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_18"]  = " onsekizkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_19"]  = " ondokuzkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_20"]  = " yirmikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_descending_1"]  = " birkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_2"]  = " ikikez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_3"]  = " üçkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_4"]  = " dörtkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_5"]  = " beşkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_6"]  = " altikez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_7"]  = " yedikez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_8"]  = " sekizkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_9"]  = " dokuzkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_10"] = " onkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_11"] = " onbirkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_12"] = " onikikez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_13"] = " onüçkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_14"] = " ondörtkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_15"] = " onbeşkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_16"] = " onaltikez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_17"] = " onyedikez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_18"] = " onsekizkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_19"] = " ondokuzkez eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_20"] = " yirmikez eskiden-yeniye kaldırıldı";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "Bu olguları silmek istediğinizden emin misiniz?";
$pgv_lang["access_denied"]			= "<b>Erişim Reddedildi</b><br />Bu kaynağa erişme izniniz yok.";
$pgv_lang["changes_exist"]		= "Bu GEDCOM'da değişiklikler yapılmıştır.";
$pgv_lang["find_place"]			= "Yer Bul";
$pgv_lang["close_window"]		= "Pencereyi Kapat";
$pgv_lang["close_window_without_refresh"]	= "Pencereyi Tazelemeden Kapat";
$pgv_lang["place_contains"]		= "Aranacak Yer:";
$pgv_lang["add"]			= "Ekle";
$pgv_lang["custom_event"]		= "Özel Hadise";
$pgv_lang["delete_person"]		= "Bu bireyi sil";
$pgv_lang["confirm_delete_person"]	= "Bu bireyi silmek istediğinizden emin misiniz?";
$pgv_lang["find_media"]			= "Medya Bul";
$pgv_lang["set_link"]			= "Bağlantı ayarla";
$pgv_lang["delete_source"]		= "Bu kaynağı sil";
$pgv_lang["delete_shared_note"]		= "Bu Paylaşılan Notu Sil";
$pgv_lang["confirm_delete_source"]	= "Bu Kaynağı silmek istediğinizden emin misiniz?";
$pgv_lang["confirm_delete_shared_note"]		= "Bu Paylaşılan Notu silmek istediğinizden emin misiniz?";
$pgv_lang["find_family"]		= "Aile Bul";
$pgv_lang["find_fam_list"]		= "Aile Listesi Bul";
$pgv_lang["edit_name"]			= "Adı Düzelt";
$pgv_lang["delete_name"]		= "Adı Sil";
$pgv_lang["select_date"]		= "Bir tarih seç";
$pgv_lang["user_cannot_edit"]		= "Bu kullanıcı adlı ile bu GEDCOM düzenleyemezsiniz.";
$pgv_lang["gedcom_editing_disabled"]	= "Bu GEDCOM düzenleme yönetici tarafından devredişi bırakımıştır.";
$pgv_lang["privacy_not_granted"]	= "için erişmeye sahip değilsiniz";
$pgv_lang["privacy_prevented_editing"]	= "Bu kaydı düzenlerken sizi mahremiyet ayarları engelleyebilir.";
$pgv_lang["ged_noshow"]				= "Bu sayfa yönetici tarafından devredişi birakıldı.";

//-- calendar.php messages
$pgv_lang["bdm"]					= "Doğumlar, Ölümler, Evlilikler";
$pgv_lang["on_this_day"]		= "Bugünkü hadiseler...";
$pgv_lang["in_this_month"]		= "Bu Ay içinde...";
$pgv_lang["in_this_year"]		= "Bu Yıl içinde ...";
$pgv_lang["year_anniversary"]		= "#year_var#. yıl dönümü";
$pgv_lang["today"]			= "Bugün";
$pgv_lang["day"]			= "Gün:";
$pgv_lang["month"]			= "Ay:";
$pgv_lang["showcal"]			= "Hadiseleri göster:";
$pgv_lang["anniversary"]			= "Yıldönümü";
$pgv_lang["anniversary_calendar"]	= "Yıldönümü Takvimi";
$pgv_lang["sunday"]			= "Pazar";
$pgv_lang["monday"]			= "Pazartesi";
$pgv_lang["tuesday"]			= "Salı";
$pgv_lang["wednesday"]			= "Çarşamba";
$pgv_lang["thursday"]			= "Perşembe";
$pgv_lang["friday"]			= "Cuma";
$pgv_lang["saturday"]			= "Cumartesi";
$pgv_lang["viewday"]			= "Günü Görüntüle";
$pgv_lang["viewmonth"]			= "Ayı Görüntüle";
$pgv_lang["viewyear"]			= "Yılı Görüntüle";
$pgv_lang["all_people"]			= "Tüm Kişiler";
$pgv_lang["living_only"]		= "Yaşayan Kişiler";
$pgv_lang["recent_events"]		= "Son Yıl (&lt; 100 yıl)";
$pgv_lang["day_not_set"]			= "Gün ayarlanmadı";

//-- user self registration module
$pgv_lang["lost_password"]		= "Şifrenizi mi unuttunuz?";
$pgv_lang["requestpassword"]		= "Yeni şifre iste";
$pgv_lang["no_account_yet"]		= "Üye değil misiniz?";
$pgv_lang["requestaccount"]		= "Şimdi Kayıt Ol";
$pgv_lang["emailadress"]		= "Email Adresi";
$pgv_lang["mandatory"] 			= "* İşaretli alanların doldurulması zorunludur.";
$pgv_lang["mail01_line01"]		= "Merhaba: #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Bu #user_email# email adresi ile #PGV_SERVER_NAME##PGV_SCRIPT_PATH# PhpGedView sitede üyelik hesabi açılmıştır.";
$pgv_lang["mail01_line03"]		= "Üyelik hakkında bilgiler aşağıdaki linkin altında gösterilmiştir.";
$pgv_lang["mail01_line04"]		= "Üyelik işlemi tamamlamak için lütfen aşağıdaki inki tıklayıp istekleri doldurup onaylayın.";
$pgv_lang["mail01_line05"]		= "Eğer bu üyelik siz oluşturmadınız ise bu mesajı silip unutabilirsiniz.";
$pgv_lang["mail01_line06"]		= "Çünkü onaylanmayan hesaplar otomatik olarak yedi gün sonra silinecek ve bu siteden bir daha email mesajı almayacaksınız.";
$pgv_lang["mail01_subject"]		= "#PGV_SERVER_NAME##PGV_SCRIPT_PATH# sitedeki üyeliğiniz";

$pgv_lang["mail02_line01"]		= "Merhaba Yönetici ...";
$pgv_lang["mail02_line02"]		= "#PGV_SERVER_NAME##PGV_SCRIPT_PATH# PhpGedView sitede bir kullanıcı kaydolmuştur ve bekliyor.";
$pgv_lang["mail02_line03"]		= "Kullanıcıya üyelik işlemini tamamlaması için gerekli bilgiler gönderilmiştir.";
$pgv_lang["mail02_line04"]		= "Kullanıcı hesabini onayladıktan sonra onayladığına dair tekrar email mesajı ile bilgilendirileceksiniz. Kullanıcı siteye giriş yapabilmesi için yönetici onayı gerekecektir.";
$pgv_lang["mail02_line04a"]			= "Kullanıcı kendi hesabini onayladıktan sonra yönetici onayına gerek duymadan siteye giriş yapabilecek.";
$pgv_lang["mail02_subject"]		= "#PGV_SERVER_NAME##PGV_SCRIPT_PATH# sitede yeni kullanıcı kaydolmuştur";

$pgv_lang["hashcode"]			= "Doğrulama kodu:";
$pgv_lang["thankyou"]			= "Merhaba #user_fullname# ...<br />Kaydolduğunuz için teşekkür ederiz.";
$pgv_lang["pls_note06"]			= "Üyelik sırasında verdiğiniz <b>#user_email#</b> email adresinize onay mesajı gönderdik. Şimdi verdiğiniz email adresinizin mesaj kutusuna giderek hesabinizi onaylamak için gönderdiğimiz yönergeleri takip ederek hesabinizi onaylayın. Eğer hesabinizi yedi(7) gün içinde onaylamaz iseniz hesabiniz otomatikman silinecektir. Tekrar kaydolmak zorunda kalacaksınız.<br /><br /><br />Bu siteye giriş yapmak için kullanıcı adı ve şifre bilinmesi gerekir.<br /><br />";
$pgv_lang["pls_note06a"] 			= "Üyelik sırasında verdiğiniz <b>#user_email#</b> email adresinize onay mesajı gönderdik. Şimdi verdiğiniz email adresinizin mesaj kutusuna giderek hesabinizi onaylamak için gönderdiğimiz yönergeleri takip ederek hesabinizi onaylayın. Eğer hesabinizi yedi(7) gün içinde onaylamaz iseniz hesabiniz otomatikman silinecektir. Tekrar kaydolmak zorunda kalacaksınız.<br /><br />Onay mesajdaki yönergeleri uyguladıktan sonra artik siteye giriş yapabilirsiniz.<br /><br />Bu siteye giriş yapmak için kullanıcı adı ve şifreyi bilmeniz gerecektir.<br /><br />";

$pgv_lang["registernew"]		= "Yeni hesap doğrulama";
$pgv_lang["user_verify"]		= "Kullanıcı doğrulama";
$pgv_lang["send"]			= "Gönder";

$pgv_lang["pls_note07"]			= "Lütfen üyelik isteminizin tamamlanması ve tasdik edilmesi için, size bu siteden gönderiliş olan harf ile elinize geçen kullanıcı adı, şifrenizi ve tasdik kodunuzu işleyin.";
$pgv_lang["pls_note08"]			= "Kullanıcı adı <b>#user_name#</b> üyelik verileriniz kontrol edildi.";

$pgv_lang["mail03_line01"]		= "Merhaba Yönetici ...";
$pgv_lang["mail03_line02"]		= "Kullanıcı #newuser[username]# (#newuser[fullname]#) kendisine gönderilen verileri onaylamıştır.";
$pgv_lang["mail03_line03"]		= "Kullanıcının hesabını aktif etmek için yada kullanıcıyı düzenlemek için sitenize giriş yapabilirsiniz. Lütfen aşağıdaki sitenizin linkini tıklayın.";
$pgv_lang["mail03_line03a"]			= "Herhangi bir işlem yapmanıza gerek yok; kullanıcı şimdi giriş yapabilir.";
$pgv_lang["mail03_subject"]		= "#PGV_SERVER_NAME##PGV_SCRIPT_PATH# kullanıcı kendini onayladı";

$pgv_lang["pls_note09"]			= "Kayıtlı bir kullanıcı olma isteğiniz onaylanmıştır.";
$pgv_lang["pls_note10"]			= "Üyeliğinizi onayladığınızı söyleyen bir mesaj Yöneticiye gönderilmiştir.<br />Yönetici üyeliğinizi kontrol edip onayladığında siteye giriş yapabileceğinizi söyleyen ikinci email mesajı aldıktan sonra Kullanıcı adı ve şifrenizi kullanarak siteye giriş yapabilirsiniz.";
$pgv_lang["pls_note10a"]			= "Şimdi kullanıcı adı ve şifre ile giriş yapabilirsiniz.";
$pgv_lang["data_incorrect"]		= "Verileriniz geçerli değildi, lütfen tekrar deneyin";
$pgv_lang["user_not_found"]		= "Girdiğiniz bilgiler doğrulayamadı. Lütfen yeniden deneyin yada daha fazla bilgi için site yöneticisine başvurun.";

$pgv_lang["lost_pw_reset"]		= "Yeni şifre isteği";
$pgv_lang["pls_note11"]			= "Size yeni bir şifre yollanmasını istiyorsaniz, üyelik hesabınızın kullanıcı adınızı ve E-posta adresini işleyin.<br /><br />Bundan sonra biz size E-posta yolu ile hesabınızı onaylayıcı bilgi içeren özel bir URL yollayacağız.<br />Yollanan bu URL adresini ziyaret ettiğinizde bu siteye giriş için gerekli olan şifrenizi değiştirmenize izin verilecektir.<br />Güvenlik nedenleri yüzünden bu özel URL adresini (bu sitenin yöneticileri dahil) kimseye göstermemeniz rica olunur.<br />Biz zaten böyle bir istekte bulunmayız...<br /><br />Bu sitenin yöneticisi tarafından yardıma ihtiyacınız varsa lütfen direk ona danışın.";

$pgv_lang["mail04_line01"]		= "Merhaba #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Kullanıcı adınız için yeni bir şifre istenmiştir.";
$pgv_lang["mail04_line03"]		= "Tavsiye:";
$pgv_lang["mail04_line04"]		= "Lütfen aşağıdaki linki tıklayın veya URL adresi tarayıcınıza yapıştırın. Yeni şifreniz giriş yaparak hesabinizi korumak için hemen şifrenizi değiştirin.";
$pgv_lang["mail04_line05"]			= "Giriş yaptıktan sonra «#pgv_lang[mygedview]#» menüsü altında «#pgv_lang[editowndata]#» bağlantısını seçin ve şifrenizi değiştirmek için her iki alana yeni şifrenizi girerek kaydedin.";
$pgv_lang["mail04_subject"] 		= "#PGV_SERVER_NAME##PGV_SCRIPT_PATH# siteden yeni şifre";

$pgv_lang["pwreqinfo"]				= "Merhaba ...<br /><br /><b>#user[email]#</b> hesabi için yeni şifre talebiniz hesapta kayıtlı email adresine gönderilmiştir.<br /><br />Email hesabinizi kontrol edin; yeni şifre içeren mesajınız şimdi almış olmalısınız.<br /><br />Tavsiye:<br />Hesabinizi korumak için mümkün olan en kısa süre içinde yeni şifre ile siteye giriş yaparak hemen şifrenizi değiştirmeniz gerekir.";

$pgv_lang["myuserdata"]			= "Profil ayarlarım";
$pgv_lang["user_theme"]			= "Benim Tema";
$pgv_lang["mgv"]			= "Benim GedView";
$pgv_lang["mygedview"]			= "GedView Portalım";
$pgv_lang["passwordlength"]		= "Şifreler en az 6 karakter içermelidir.";
$pgv_lang["welcome_text_auth_mode_1"]	= "<span class='center'><b>Bu soyağacı web siyesine hoş geldiniz</b></span><br /> permitted to every visitor who has a user account.<br /><br />If you have a user account, you can login on this page. If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying your application, the site administrator will activate your account. You will receive an email when your application has been approved.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<span class='center'><b>Bu Soyağacı Web Sitesine Hoş Geldiniz</b></span><br /> Bu soyağacı web sitesine erişim sadece <u>kayıtlı</u> kullanıcılara izin veriliyor.<br /><br /> Eğer siz bir kullanıcı hesaba sahip iseniz giriş yapabilirsiniz.<br /><br /> Eğer sizin bir kullanıcı hesabınız yoksa aşağıdaki uygun linki tıklatarak kayıt olabilirsiniz.<br /><br /> Kayıt sonrası hesabınızı doğruladıktan sonra son olarak yönetici hesabınızı onaylayacak veya reddedecektir. <br /><br />Yönetici hesabınıza uygulamadan sonra email ile size mesaj gönderilecektir.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<span class='center'><b>Bu soyağacı websitesine hoş geldiniz</b></span><br />Bu siteye giriş sadece <u>aile üyelerine</u> giriş izni verilir.<br /><br />If you have a user account you can login on this page. If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying the information you provide, the administrator will either approve or decline your request for an account. You will receive an email when your request is approved.";
$pgv_lang["welcome_text_cust_head"] 	= "<span class='center'><b>Soyağacı Websitesine Hoş Geldiniz</b></span><br />Bu websiteye erişmek için bir hesap ve bir şifreye sahip olan kullanıcılara izin verilmektedir.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">ÖNEMLİ LÜTFEN ÜYE OLMADAN ÖNCE OKUYUN: <br /><br /></div><div class=\"error\">Bize katılın: bu soyağacında listelenen bilgilerin gizliliğini korumak için üye olmanız gerekiyor, üye olmak için aşağıdaki formu doğru bilgilerle doldurmanız gerekir.<br /><br /> Bu sitede listelenen soyağacına mensup biri iseniz üye olarak soyağacındaki eksikliklerin veya yanlışların düzeltilmesinde yardım olabileceğiniz gibi soyunuzu daha iyi öğrenmenizi sağlayacaktır.<br /><br />Lütfen aşağıdaki <b>Kendinizi tanıtın</b> alanına bu siteye kabul edilebilmeniz için kendinizi yönetici tanıyabilecek şeklinde çok detaylı yazmanız gerekir aksı taktirde üyeliğinizi onaylayamayacaktır.</div>";


//-- mygedview page
$pgv_lang["upcoming_events"]		= "Gelecek Hadiseler";
$pgv_lang["living_or_all"]			= "Sadece yaşayan insanların hadiselerini göster?";
$pgv_lang["basic_or_all"]			= "Sadece Doğumları, Ölümleri, ve Evlilikleri göster?";
$pgv_lang["style"]					= "Sunuş Stili";
$pgv_lang["style1"]					= "Liste";
$pgv_lang["style2"]					= "Tablo";
$pgv_lang["style3"]					= "Etiket kümesi";
$pgv_lang["sort_style"]				= "Göre Sıralama Stili";
$pgv_lang["by_anniv"]				= "Yıldönümü";
$pgv_lang["by_alpha"]				= "Alfabetik";
$pgv_lang["cal_download"]			= "Takvim hadiseleri indirme izni?";
$pgv_lang["no_events_living"]		= "Yaşayan insanlar için sonraki #pgv_lang[global_num1]# gün boyunca hadiseler mevcut değil.";
$pgv_lang["no_events_living1"]		= "Yarın yaşayan insan için hadiseler mevcut değil.";
$pgv_lang["no_events_all"]			= "Sonraki #pgv_lang[global_num1]# gün için hadiseler mevcut değil.";
$pgv_lang["no_events_all1"]			= "Yarın için hadise mevcut değil.";
$pgv_lang["no_events_privacy"]		= "Sonraki #pgv_lang[global_num1]# gün için hadiseler mevcut, ancak mahremiyet ayarlarından dolayı görmenizi engelliyor.";
$pgv_lang["no_events_privacy1"]		= "Yarın için hadise mevcut, ancak mahremiyet ayarlarından dolayı görmenizi engelliyor.";
$pgv_lang["more_events_privacy"]	= "<br />Sonraki #pgv_lang[global_num1]# gün için daha fazla hadiseler mevcut, ancak mahremiyet ayarlarından dolayı görmenizi engelliyor.";
$pgv_lang["more_events_privacy1"]	= "<br />Yarın için daha fazla hadiseler mevcut, ancak mahremiyet ayarlarından dolayı görmenizi engelliyor.";
$pgv_lang["none_today_living"]		= "Yaşayan insanın bugün için hadise mevcut değil.";
$pgv_lang["none_today_all"]			= "Bugün için hadise mevcut değil.";
$pgv_lang["none_today_privacy"]		= "Bugün hadiseler mevcut, ancak mahremiyet ayarlarından dolayı görmenizi engelliyor.";
$pgv_lang["more_today_privacy"]		= "<br />Bugün için daha fazla hadiseler mevcut, ancak mahremiyet ayarlarından dolayı görmenizi engelliyor.";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Çevrimiçi kullanıcılar";
$pgv_lang["anon_user"]				= "1 anonim kullanıcı çevrimiçi";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# anonim kullanıcı çevrimiçi";
$pgv_lang["login_user"]				= "1 kayıtlı kullanıcı çevrimiçi";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# kayıtlı kullanıcı çevrimiçi";
$pgv_lang["no_login_users"]			= "Kayıtlı veya anonim kullanıcı yok";
$pgv_lang["message"]			= "Mesaj Gönder";
$pgv_lang["my_messages"]		= "Benim Mesajlarım";
$pgv_lang["date_created"]		= "Gönderme Tarihi:";
$pgv_lang["message_from"]		= "Email Adresi:";
$pgv_lang["message_from_name"]		= "Adınız:";
$pgv_lang["message_to"]			= "Mesajı Gönderen:";
$pgv_lang["message_subject"]		= "Konu:";
$pgv_lang["message_body"]		= "Gövde:";
$pgv_lang["no_to_user"] 		= "Alacak kullanıcı sağlanmadığı için Devam edemiyor. ";
$pgv_lang["provide_email"]			= "Lütfen bu mesajınıza cevap verebilmemiz için email adresinizi girin. Eğer email adresinizi vermez iseniz sorunuza cevap vermemiz mümkün olmayacaktır. Email adresiniz bu sorunuza cevap dışında başka bir yerde kullanılmayacaktır.";
$pgv_lang["reply"]			= "Cevapla";
$pgv_lang["message_deleted"]		= "Mesaj Silindi";
$pgv_lang["message_sent"]		= "#TO_USER# mesajı gönderildi";
$pgv_lang["message_failed"]		= "İleti gönderilemedi";
$pgv_lang["message_error"]		= "PHPMailer hatası: ";
$pgv_lang["message_invalid_from"]	= "Geçersiz gönderen adresi: &lt;#email#&gt;";
$pgv_lang["message_invalid_to"]		= "Geçersiz alıcı adresi: &lt;#email#&gt;";
$pgv_lang["reset"]			= "Sıfırla";
$pgv_lang["site_default"]		= "Site Varsayılan";
$pgv_lang["mygedview_desc"]		= "Benim GedView sayfanızda favorilere sevdiklerinizi ekleyerek gelecek yıldönümleri/hadiseleri izlemeyi ve diğer PhpGedView kullanıcılarıyla işbirliği sağlar.";
$pgv_lang["no_messages"]		= "Bekleyen mesajınız yok.";
$pgv_lang["clicking_ok"]		= "Tamam'ı tıkladığınızda başka bir pencere açılacak ve #user[fullname]# ile irtibata geçebilirsiniz.";
$pgv_lang["favorites"]				= "Favoriler";
$pgv_lang["my_favorites"]		= "Benim Favorilerim";
$pgv_lang["no_favorites"]		= "Herhangi bir favoriler seçmediniz. <br /><br />Favorilerinize bir birey, bir aile, yada bir kaynak eklemek için <b>#pgv_lang[add_favorite]#</b> linkini tıklayın bazı veri giriş alanları yada ID numara için arama seçenekleri göreceksiniz.";
$pgv_lang["add_to_my_favorites"]	= "Benim Favorilere Ekle";
$pgv_lang["gedcom_favorites"]		= "Bu GEDCOM'un Favorileri";
$pgv_lang["no_gedcom_favorites"]	= "\"Sık kullanılanlar\" bölümüne daha ekleme yapılmamıştır. Buraya ancak sitenin yöneticisi ekleme yapabilir.";
$pgv_lang["confirm_fav_remove"]		= "Bu öğeyi Favoriler listenizden kaldırmak istediğinizden emin misiniz?";
$pgv_lang["invalid_email"]		= "Lütfen geçerli bir email adresi girin.";
$pgv_lang["enter_subject"]		= "Lütfen bir mesaj konusu girin.";
$pgv_lang["enter_body"]			= "Lütfen göndermeden önce mesaj metni girin.";
$pgv_lang["confirm_message_delete"]	= "Bu mesajı silmek istediğinizden emin mısınız? Daha sonra geri alınamaz.";
$pgv_lang["message_email1"]		= "Aşağıdaki mesaj PhpGedView kullanıcısının hesabından gönderildi. Gönderen hesap ";
$pgv_lang["message_email2"]		= "Aşağıdaki mesajı bir PhpGedView kullanıcıya gönderdiniz:";
$pgv_lang["message_email3"]		= "Aşağıdaki mesajı bir PhpGedView yöneticisine gönderdiniz:";
$pgv_lang["viewing_url"]		= "Bu mesaj aşağıdaki URL görüntülerken gönderildi: ";
$pgv_lang["messaging2_help"]		= "Bu mesajı gönderdiğinizde verdiğiniz email adresine bir kopyası gönderilecektir.";
$pgv_lang["random_picture"]		= "Rastgele Resim";
$pgv_lang["message_instructions"]	= "<b>Lütfen Not:</b> Bu soyağacının kurallar çerçevesine göre değişebilen kurala göre genel olarak bireylerin yaşam özel bilgileri yalnızca aile, akraba ve yakın arkadaşına verilebilir. Herhangi bir özel veri almadan önce bu kişinin ilişki durumu doğrulanması istenir. Ölü kişilerinde verileri bazen gizli olabilir. Çünkü bu durumda yeterli bilgi belirlemek için kişi hakkında bilinen veya hayatta değildir ve bebeğin yanındaki bu kişi hakkında daha fazla bilgi olmayabilir.<br /><br /> Soru sormadan önce lütfen tarihleri, yerleri kontrol ederek doğru kişi hakkında sorunuzu sorun ve akraba kapat. Eğer nesiller verisinde yanlışları değiştirilmesi için bilgi gönderiyorsanız lütfen verinin kayak yerini belirtin.<br /><br />";
$pgv_lang["sending_to"]			= "Bu mesaj #TO_USER# kullanıcıya gönderilecek.";
$pgv_lang["preferred_lang"]		= "Bu kullanıcı mesajlarını #USERLANG# dilinde okumayı tercih ediyor.";
$pgv_lang["gedcom_created_using"]	= "Bu GEDCOM <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b> kullanılarak oluşturuldu";
$pgv_lang["gedcom_created_on"]		= "Bu GEDCOM <b>#CREATED_DATE#</b> tarihinde oluşturuldu.";
$pgv_lang["gedcom_created_on2"]		= " tarihi: <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]		= "GEDCOM İstatistikleri";
$pgv_lang["stat_individuals"]		= "Bireyler";
$pgv_lang["stat_families"]		= "Aileler";
$pgv_lang["stat_sources"]		= "Kaynaklar";
$pgv_lang["stat_other"]			= "Diğer kayıtlar";
$pgv_lang["stat_earliest_birth"] 	= "İlk doğum yılı";
$pgv_lang["stat_latest_birth"] 	= "Son doğum yılı";
$pgv_lang["stat_earliest_death"] 	= "İlk vefat yılı";
$pgv_lang["stat_latest_death"] 	= "Son vefat yılı";
$pgv_lang["customize_page"]		= "Benim GedView Portalı Özelleştir";
$pgv_lang["customize_gedcom_page"]	= "Bu GEDCOM Karşılama sayfası Özelleştir";
$pgv_lang["upcoming_events_block"]	= "Gelecek Hadiseler";
$pgv_lang["upcoming_events_descr"]	= "Gelecek Hadise blok yakın gelecekte hadiselerin yıldönümlerini gösterir. Gösterme detaylarının miktarlarını yapılandırabilirsiniz ve yönetici bu blok ne kadar gelecek zamanını yapılandırabilir.";
$pgv_lang["todays_events_block"]	= "Bugünkü";
$pgv_lang["todays_events_descr"]	= "Bugünkü. Tarihiniz içinde blok hadiselerin yıldönümleri için bugünü gösterir. Gösterilen detayların miktarlarını yapılandırabilirsiniz.";
$pgv_lang["todo_block"] = "&quot;To Do&quot; görevler";
$pgv_lang["todo_descr"] = "Bloğu yapmak veritabanında tüm seçkin _TODO niteliklerini listeler.";
$pgv_lang["todo_show_other"]     = "Diğer kullanıcıların görevlerini göster";
$pgv_lang["todo_show_unassigned"]= "Atanmamış görevleri göster";
$pgv_lang["todo_show_future"]    = "Gelecek görevleri göster";
$pgv_lang["todo_nothing"]        = "Hiçbir &quot;To Do&quot; görevleri yok.";
$pgv_lang["yahrzeit_block"]			= "Gelecek Yahrzeiten";
$pgv_lang["yahrzeit_descr"]			= "Gelecek Yahrzeiten blok yakın zaman için gelecek ölüm yıldönümlerini gösterir. Gösterilecek dönemler yapılandırılabilir ve yönetici ne kadar gelecek zamanın ölüm yıldönümleri yapılandırabilirsiniz.";
$pgv_lang["logged_in_users_block"]	= "Kimler Çevrimiçi";
$pgv_lang["logged_in_users_descr"]	= "Kimler Çevrimiçi blok siteye giriş yapan kullanıcıların bir listesini gösterir.";
$pgv_lang["user_messages_block"]	= "Kullanıcı Mesajları";
$pgv_lang["user_messages_descr"]	= "Kullanıcı Mesajları blok aktif kullanıcıya gönderilen mesajların bir listesini gösterir.";
$pgv_lang["user_favorites_block"]	= "Kullanıcı Favorileri";
$pgv_lang["user_favorites_descr"]	= "Kullanıcı Favoriler blok kullanıcıya veritabanından sevdiği kişileri favori listesine ekleyerek onlara daha kolay bağlantı kurması için liste gösterir.";
$pgv_lang["welcome_block"]		= "Kullanıcı Hoş Geldin";
$pgv_lang["welcome_descr"]			= "Kullanıcı Hoş Geldin blok geçerli tarih ve saati, hızlı linkler hesabını düzenlemek yada kendi soyağacı çizelgesi ve bu Benim GedView Portalı Özelleştir linki kullanıcıya gösterir.";
$pgv_lang["random_media_block"]		= "Rastgele Medya";
$pgv_lang["random_media_descr"] 	= "Rastgele Medya blok şu anda aktif bir veritabanından rastgele bir fotoğraf ya da diğer medya öğe seçer ve kullanıcıya gösterir.<br /><br />Yönetici bu blok kişi ya da olayları ile ilgili medya öğeleri göstermeyi yapılandırabilir.";
$pgv_lang["random_media_persons_or_all"]	= "Sadece kişileri, hadiseleri, yada tümü göster?";
$pgv_lang["random_media_persons"]	= "Kişiler";
$pgv_lang["random_media_events"]	= "Hadiseler";
$pgv_lang["gedcom_block"]		= "GEDCOM Hoş Geldiniz";
$pgv_lang["gedcom_descr"]			= "GEDCOM Hoş Geldiniz blok aynı Kullanıcı Hoş Geldiniz blok şeklinde çalışır. Bu site ziyaretçi ağırlamaktadır ve aktif veritabanı olarak geçerli tarih ve saat başlığı görüntüler.";
$pgv_lang["gedcom_favorites_block"]	= "GEDCOM Favorileri";
$pgv_lang["gedcom_favorites_descr"] = "GEDCOM Favoriler blok yöneticilere veritabanından bireyleri ekleyip herkese kolay erişebilir yapmasına imkan sağlar. Bu sizin veya soyağacının tarihteki önemli kişileri ziyaretçilere dikkat çekmesi için bir yoldur.";
$pgv_lang["gedcom_stats_block"]		= "GEDCOM İstatistikleri";
$pgv_lang["gedcom_stats_descr"] 	= "GEDCOM İstatistik blok ziyaretçilere veritabanından temel bilgileri oluşturan ve tarihi, kaç kişi var gibi gösterir.<br /><br />Ayrıca en sık kullanılan adların bir listesi gösterir. En sık kullanılan Soyadılar listesini göstermek değil bu bloğu isteğinize göre GEDCOM'u yapılandırarak istediğiniz seçenekleri ekleyip kaldırabilirsiniz. Bu listeye GEDCOM yapılandırırken gerçekleşme sınırlamaları yapılandırabilirsiniz.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Ortak soyadları göster?";
$pgv_lang["portal_config_instructions"]	= "~#pgv_lang[customize_page]#~<br />~#pgv_lang[customize_gedcom_page]#~<br /><br />Bunları istediğiniz gibi sayfaya blokları yerleştirerek sayfayı ihtiyacınıza göre özelleştirebilirsiniz.<br /><br /> Sayfa <b>Ana</b> ve <b>Sağ</b> bölümler içine bölünür. <b>Ana</b> bölüm blokları geniş belirirler ve sayfa başlığın altında belirir. <b>Sağ</b> bölüm sağda belirir ve sayfa başlığın altının sağında listelenir.<br /><br />Her bir bölüm listelendiği düzende sayfada yazılan blokların kendi listesine sahip olur.<br /><br />Blok listelerinin biri boş olduğunda kalan bloklar sayfanın tümünün genişliğini kapsayacaktır.<br /><br />";
$pgv_lang["login_block"]		= "Giriş";
$pgv_lang["login_descr"]			= "Giriş blok kullanıcılar giriş için bir kullanıcı adı ve şifre girebilecekleri alanları gösterir.";
$pgv_lang["theme_select_block"]		= "Tema Seç";
$pgv_lang["theme_select_descr"] 	= "Tema Seç blok kullanıcılara Tema Değiştirme özelliği devredişi olsa bile Tema seçici gösterecek.";
$pgv_lang["block_top10_title"]		= "Ençok Kullanılan 10 Soyadılar";
$pgv_lang["block_top10"]		= "Ençok Kullanılan 10 Soyadılar";
$pgv_lang["block_top10_descr"]		= "Ençok Kullanılan 10 Soyadılar blok en çok kullanılan soyadları veritabanında 10 tablosunda gösterir. Bu blok içinde gösterilecek soyadların sayılarını yapılandırabilir. Bu listeden adları yapılandırmak için GEDCOM'u yapılandırabilirsiniz.";
$pgv_lang["block_givn_top10_title"]		= "Ençok verilen 10 adlar";
$pgv_lang["block_givn_top10"]			= "Ençok verilen 10 adlar";
$pgv_lang["block_givn_top10_descr"]		= "Ençok Verilen 10 Adlar blok en çok kullanılan adları veritabanında 10 tablosunda gösterir. Bu blok içinde gösterilecek adların sayılarını yapılandırabilirsiniz.";

$pgv_lang["gedcom_news_block"]		= "GEDCOM Haberler";
$pgv_lang["gedcom_news_descr"]		= "GEDCOM Haberler blok bir yönetici tarafından yayınlanan ziyaretçi haber bültenleri ya da kullanıcı makaleler gösterir.<br /><br />Haberler bloğunda önemli bir veritabanı güncelleme, aile birleşimi ya da bir çocuğun doğumu duyurmak için iyi bir yerdir.";
$pgv_lang["gedcom_news_limit"]		= "Olarak göstermeyi kısıtla:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Kısıtlama yok";
$pgv_lang["gedcom_news_limit_date"]		= "Öğenin yaşı";
$pgv_lang["gedcom_news_limit_count"]	= "Öğenin numarası";
$pgv_lang["gedcom_news_flag"]		= "Kota:";
$pgv_lang["gedcom_news_archive"] 	= "Arşivi görüntüle";
$pgv_lang["user_news_block"]		= "Kullanıcı Günlüğü";
$pgv_lang["user_news_descr"]		= "Kullanıcı Günlüğü blok kullanıcı notlarını yada çevrimiçin günlük tutmasını sağlar.";
$pgv_lang["my_journal"]			= "Benim Günlüğüm";
$pgv_lang["no_journal"] 			= "Herhangi bir günlük öğelerini oluşturmadınız.";
$pgv_lang["confirm_journal_delete"] = "Bu günlük girdisi silmek istediğinizden emin misiniz?";
$pgv_lang["add_journal"]		= "Yeni bir Günlük girdisi ekle";
$pgv_lang["gedcom_news"]		= "Haberler";
$pgv_lang["confirm_news_delete"]	= "Bu Haber girişi silmek istediğinizden emin misiniz?";
$pgv_lang["add_news"]			= "Bir Haber makalesi ekle";
$pgv_lang["no_news"]			= "Şimdilik Haber makaleleri gönderilmedi.";
$pgv_lang["edit_news"]			= "Ekle/Düzelt Günlük/Haber gir";
$pgv_lang["enter_title"]		= "Lütfen bir başlık girin.";
$pgv_lang["enter_text"] 			= "Lütfen bu Haber veya Günlük girdisi için metin girin.";
$pgv_lang["news_saved"] 		= "Haber/Günlük girişi başarıyla kaydedildi.";
$pgv_lang["article_text"]		= "Metin Girin:";
$pgv_lang["main_section"]		= "Ana Bölüm Blokları";
$pgv_lang["right_section"]		= "Sağ Bölüm Blokları";
$pgv_lang["available_blocks"]		= "kullanılabilir Bloklar";
$pgv_lang["move_up"]			= "Yukarı Taşı";
$pgv_lang["move_down"]			= "Aşağı Taşı";
$pgv_lang["move_right"]			= "Sağa Taşı";
$pgv_lang["move_left"]			= "Sola Taşı";
$pgv_lang["broadcast_all"]		= "Tüm üyelere mesaj gönder";
$pgv_lang["hit_count"]			= "Sayaç:";
$pgv_lang["phpgedview_message"]		= "PhpGedView Mesajı";
$pgv_lang["common_surnames"]		= "Ençok Ortak Soyadılar";
$pgv_lang["default_news_title"]		= "Soyağacınıza Hoş Geldiniz";
$pgv_lang["default_news_text"]		= "Bu sitede bulunan seçere bilgileri <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a> yazılımı ile gösterilmektedir. Bu sayfada bu soyağacını tanıtan bilgiler bulunmaktadır. Bu bilgilere ulaşmak için 'Çizgeler' menüsünden bir çizgeyi seçin, ya da 'Listeler' menüsünden şahıs listesine gidin, veyahut sizi ilgilendiren bir soy ismini ya da yeri arayın.<br /><br />Bu siteyi gezerken bir sorunla karşılaşacak olursanız yardım simgesine tıklayıp bulunduğunuz sayfa hakkında gerekli yardımı bulabilirsiniz.<br /><br />Bu siteyi ziyaret ettiğiniz için teşekkür ederiz.";
$pgv_lang["reset_default_blocks"]	= "Blokları Varsayılana Sıfırla";
$pgv_lang["recent_changes"]		= "Son Değişiklikler";
$pgv_lang["recent_changes_block"]	= "Son Değişiklikler";
$pgv_lang["recent_changes_descr"]	= "Son Değişiklikler blok veritabanına son bir ay içinde yapılmış olan tüm değişikliklerin listesini verir. Bu blok yapılmış değişikliklerle güncel tutmaya yardımcı olabilir. Değişiklikler GEDCOM Standard tanımlanan CHAN etiketi kullanarak otomatik olarak algılanır.";
$pgv_lang["recent_changes_none"]	= "<b>Son #pgv_lang[global_num1]# gün içinde herhangi bir değişiklik olmamıştır.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Son #pgv_lang[global_num1]# gün içinde yapılan değişiklikler</b><br />";
$pgv_lang["show_empty_block"]		= "Bu blok boş olduğu zaman gizlensin mi?";
$pgv_lang["hide_block_warn"]		= "Eğer boş bir blok gizlenirse blok dolu olanakadar yapılandırmasını değiştirmek mümkün olmayacaktır.";
$pgv_lang["delete_selected_messages"]	= "Seçilen Mesajı Sil";
$pgv_lang["use_blocks_for_default"]	= "Bu blokları tüm kullanıcılar için varsayılan blok yapılandırma olarak kullan?";
$pgv_lang["block_not_configure"]	=	"Bu blok yapılandırılamaz.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"]		= "Medya Araçları Ekle";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Kum Saati Çizelgesi";

//-- report engine
$pgv_lang["choose_report"]		= "Çalıştırmak için bir rapor seçin";
$pgv_lang["enter_report_values"]	= "Rapor değerleri girin";
$pgv_lang["selected_report"]		= "Seçilen Rapor";
$pgv_lang["select_report"]		= "Rapor seç";
$pgv_lang["download_report"]		= "Raporu indir";
$pgv_lang["reports"]			= "Raporlar";
$pgv_lang["pdf_reports"]		= "PDF raporları";
$pgv_lang["html_reports"]		= "HTML raporları";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "Soyağacı Raporu";
$pgv_lang["ahnentafel_generation"]	= "Nesil";
$pgv_lang["ahnentafel_pronoun_m"]	= "Erkek ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Kadın ";
$pgv_lang["ahnentafel_born_m"]		= "doğdu";
$pgv_lang["ahnentafel_born_f"]		= "doğdu";
$pgv_lang["ahnentafel_christened_m"] = "vaftiz edildi";
$pgv_lang["ahnentafel_christened_f"] = "vaftiz edildi";
$pgv_lang["ahnentafel_married_m"]	= "evli";
$pgv_lang["ahnentafel_married_f"]	= "evli";
$pgv_lang["ahnentafel_married_post"]= "&nbsp;";
$pgv_lang["ahnentafel_died_m"]		= "öldü";
$pgv_lang["ahnentafel_died_f"]		= "öldü";
$pgv_lang["ahnentafel_cremated_m"]	= "yakıldı";		// male
$pgv_lang["ahnentafel_cremated_f"]	= "yakıldı";		// female
$pgv_lang["ahnentafel_buried_m"]	= "gömüldü";
$pgv_lang["ahnentafel_buried_f"]	= "gömüldü";
$pgv_lang["ahnentafel_place"]		= " yeri ";
$pgv_lang["ahnentafel_no_details"]	= " ancak detayları bilinmiyor";
$pgv_lang["ahnentafel_on"]			= " ";

//-- Changes report
$pgv_lang["changes_report"]			= "Değişiklikler Raporu";
$pgv_lang["changes_pending_tot"]	= "Toplam bekleyen değişiklikler: ";
$pgv_lang["changes_accepted_tot"]	= "Toplam kabul edilen değişiklikler: ";

//-- Descendancy report
$pgv_lang["descend_report"]		= "Şahsı İzleyen Nesiller Raporu";
$pgv_lang["son_of"]					= "oğlu";
$pgv_lang["daughter_of"]			= "kızı";
$pgv_lang["child_of"]				= "Çocuğu ";
$pgv_lang["children_of"]			= "Çocukları ";
$pgv_lang["descendancy_pronoun_m"]	= "Erkek ";
$pgv_lang["descendancy_pronoun_f"]	= "Kadın ";

$pgv_lang["family_group_report"]	= "Aile Grup Raporu";
$pgv_lang["page"]					= "Sayfa";
$pgv_lang["of"] 					= "son";
$pgv_lang["enter_famid"]		= "Aile ID Gir";
$pgv_lang["show_sources"]		= "Kaynakları göster?";
$pgv_lang["show_notes"]			= "Notları göster?";
$pgv_lang["show_abbr_notes"] 		= "Kısaltılmış notları göster?";
$pgv_lang["show_photos"]		= "Fotoğrafları göster?";
$pgv_lang["relatives_report_ext"]	= "Genişletilmiş Akrabalık Bağı Raporu";
$pgv_lang["with"]					= "ile";
$pgv_lang["on"]						= "de";
$pgv_lang["in"]						= "içinde";
$pgv_lang["individual_report"]		= "Birey Raporu";
$pgv_lang["individual_with_rela_report"]		= "Akrabalık Bağı Raporu Kapat";
$pgv_lang["enter_pid"]			= "Birey ID Girin";
$pgv_lang["generated_by"]		= "Üreten";
$pgv_lang["birth_report"]		= "Doğum Tarihi ve Yeri Raporu";
$pgv_lang["birthplace"]				= "Doğum Yeri içerenler";
$pgv_lang["birthdate1"]				= "Doğum Tarihinden Başla";
$pgv_lang["birthdate2"]				= "Doğum Tarihinde Bitir";
$pgv_lang["death_report"]			= "Ölüm Tarihi ve Yeri Raporu";
$pgv_lang["deathplace"]				= "Ölüm Yeri içerenler";
$pgv_lang["deathdate1"]				= "Ölüm Tarihinden Başla";
$pgv_lang["deathdate2"]				= "Ölüm Tarihinden Bitir";
$pgv_lang["marr_report"]			= "Evlilik Tarihi ve Yeri Raporu";
$pgv_lang["marrplace"]				= "Evlilik Yeri içeren";
$pgv_lang["marrdate1"]				= "Evlilik Tarihinden Başla";
$pgv_lang["marrdate2"]				= "Evlilik Tarihinden Bitir";
$pgv_lang["sort_by"]			= "Olarak sırala";
$pgv_lang["cemetery_report"]		= "Mezarlık Raporu";
$pgv_lang["burialplace"]			= "Mezar Yeri içeren";
$pgv_lang["fact_sources_report"]	= "Olgu Kaynakları";
$pgv_lang["missing_facts_report"]	= "Eksik akrabalık bağı olguları";
$pgv_lang["sources_to_events"]		= "Hadiseler için kaynaklar";

$pgv_lang["cleanup"]			= "Temizle";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"]			= "İstatistikler";
$pgv_lang["show_stats_charts"]		= "İstatistikler çizelgeleri göster";
$pgv_lang["decade_birth"]			= "Doğumun on yılı";
$pgv_lang["decade_death"]			= "Ölümün on yılı";
$pgv_lang["decade_marriage"]		= "Evliliğin on yılı";
$pgv_lang["avg_age"]				= "Ortalama yaş";

//-- Merge Records
$pgv_lang["merge_same"] 			= "Kayıtlar aynı tip değiller. Aynı tip olmayan kayıtları birleştirilmez.";
$pgv_lang["merge_step1"]		= "Birleştirme Adımı 1-3";
$pgv_lang["merge_step2"]		= "Birleştirme Adımı 2-3";
$pgv_lang["merge_step3"]		= "Birleştirme Adımı 3-3";
$pgv_lang["select_gedcom_records"]	= "Birleştirmek için iki GEDCOM kaydı seçin. Kayıtlar ayni tipten olmalılar.";
$pgv_lang["merge_to"]				= "Kimle Birleşecek ID:";
$pgv_lang["merge_from"] 			= "Kimden Birleşecek ID:";
$pgv_lang["merge_facts_same"]		= "Aşağıdaki olgular her ikisi için aynı kaydı olduğundan otomatikman birleştirilecek.";
$pgv_lang["no_matches_found"]		= "Eşlenen olgular bulunamadı";
$pgv_lang["unmatching_facts"]		= "Aşağıdaki olgular eşleşmiyor. Tutmak istediğiniz bilgileri seçin.";
$pgv_lang["record"]			= "Kayıt";
$pgv_lang["adding"] 				= "Ekleniyor";
$pgv_lang["updating_linked"]		= "Bağlanan kayıt güncelleniyor";
$pgv_lang["merge_more"]			= "Daha fazla kayıtları birleştir. ";
$pgv_lang["same_ids"]				= "Aynı IDleri girdiniz. Aynı kayıtlar birleştirilmez.";
$pgv_lang["updated_favorites"] 			= "favoriler güncellendi.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]		= "Atalara Doğru Çizelgesi";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# Soyağacı Atalar Çizelgesi";
$pgv_lang["chart_style"]		= "Çizelge stili";
$pgv_lang["chart_list"]			= "Liste";
$pgv_lang["chart_booklet"]   	= "Broşür";
$pgv_lang["show_cousins"]			= "Kuzenleri göster";
// 1st generation
$pgv_lang["sosa_2"]			= "Babası";
$pgv_lang["sosa_3"]			= "Annesi";
// 2nd generation
$pgv_lang["sosa_4"]			= "Büyükbabası";
$pgv_lang["sosa_5"]			= "Babaannesi";
$pgv_lang["sosa_6"]			= "Dedesi";
$pgv_lang["sosa_7"]			= "Anneannesi";
// 3rd generation
$pgv_lang["sosa_8"]			= "Büyükbabanın babası";
$pgv_lang["sosa_9"]			= "Büyükbabanın annesi";
$pgv_lang["sosa_10"]			= "Babaannenin babası";
$pgv_lang["sosa_11"]			= "Babaannenin annesi";
$pgv_lang["sosa_12"]			= "Dedenin babası";
$pgv_lang["sosa_13"]			= "Dedenin annesi";
$pgv_lang["sosa_14"]			= "Anneannenin babası";
$pgv_lang["sosa_15"]			= "Anneannenin annesi";
// 4th generation
$pgv_lang["sosa_16"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_17"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_18"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_19"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_20"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_21"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_22"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_23"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_24"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_25"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_26"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_27"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_28"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_29"]				= "Büyük-büyük-büyükannesi";
$pgv_lang["sosa_30"]				= "Büyük-büyük-büyükbabası";
$pgv_lang["sosa_31"]				= "Büyük-büyük-büyükannesi";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x büyük büyükbabası";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x büyük büyükbabaannesi";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x büyük büyükdedesi";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x büyük büyükanneannesi";

//-- FAN CHART
$pgv_lang["compact_chart"]			= "Sıkıştırılmış Çizelgesi";
$pgv_lang["fan_chart"]			= "Daire Çizelgesi";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# Nesil Daire Çizelgesi";
$pgv_lang["fan_width"]			= "Genişlik";
$pgv_lang["gd_library"]				= "PHP sunucu yanlış yapılandırılmış: GD 2.x kütüphanesi resim fonksyonlarını kullanabilmek için gereklidir.";
$pgv_lang["gd_freetype"]			= "PHP sunucu yanlış yapılandırılmış: FreeType kütüphanesi TrueType yazı tiplerini kullanmak için gereklidir.";
$pgv_lang["gd_helplink"]			= "http://tr.php.net/gd";
$pgv_lang["fontfile_error"]		= "Yazı tipi dosyası PHP sunucusunda bulunamadı";
$pgv_lang["fanchart_IE"]			= "Bu Fanshart resmi doğrudan tarayıcınız üzerinden yazdıramazsınız. Resmi sağ tıklayın kaydedin ve yazdırın.";

//-- RSS Feed
$pgv_lang["rss_descr"]			= "#GEDCOM_TITLE# sitesinden haberler ve bağlantılar";
$pgv_lang["rss_logo_descr"]		= "Besleme PhpGedView ile oluşturuldu";
$pgv_lang["rss_feeds"]				= "RSS Beslemeleri";
$pgv_lang["no_feed_title"]			= "Kullanılabilir besleme yok";
$pgv_lang["no_feed"]				= "Bu PhpGedView sitesi için herhangi bir RSS beslemesi yok";
$pgv_lang["feed_login"]				= "Eğer bu PhpGedView sitesinde bir hesabiniz varsa özel bilgileri görüntülemek için Teme HTTP Onaylanmış hesap bilgilerinizi kullanarak sunucuya <a href=\"#AUTH_URL#\">giriş</a> yapabilirsiniz.";
$pgv_lang["authenticated_feed"]		= "Onaylanmış Besleme";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"] = "Bakıcı";
$pgv_lang["attending"] = "Katılıyor";
$pgv_lang["best_man"] = "Sağdıç";
$pgv_lang["bridesmaid"] = "Geline eşlik eden";
$pgv_lang["buyer"] = "Alıcı";
$pgv_lang["circumciser"] = "Sünnetçi";
$pgv_lang["civil_registrar"] = "Nüfus Şefi";
$pgv_lang["employee"] = "Hizmetli";
$pgv_lang["employer"] = "İşveren";
$pgv_lang["foster_child"] = "Evlatlık";
$pgv_lang["foster_father"] = "Süt Baba";
$pgv_lang["foster_mother"] = "Süt Anne";
$pgv_lang["friend"] = "Arkadaş";
$pgv_lang["godfather"] = "Manevi Baba";
$pgv_lang["godmother"] = "Manevi Anne";
$pgv_lang["godparent"] = "Manevi Ebeveyn";
$pgv_lang["godson"]		= "Manevi Oğul";
$pgv_lang["goddaughter"] = "Manevi Kızı";
$pgv_lang["godchild"]	= "Manevi Çocuk";
$pgv_lang["guardian"]	= "Veli";
$pgv_lang["informant"] = "Bilgiveren";
$pgv_lang["lodger"] = "Pansiyoner";
$pgv_lang["nanny"] = "Dadı";
$pgv_lang["nurse"] = "Hastabakıcı";
$pgv_lang["owner"] = "Sahibi";
$pgv_lang["priest"] = "Papaz";
$pgv_lang["rabbi"] = "Haham";
$pgv_lang["registry_officer"] = "Evlendirme Dairesi";
$pgv_lang["seller"] = "Satıcı";
$pgv_lang["servant"] = "Odacı";
$pgv_lang["slave"] = "Köle";
$pgv_lang["twin"] = "İkiz";
$pgv_lang["twin_brother"] = "İkiz erkek kardeş";
$pgv_lang["twin_sister"] = "İkiz kız kardeş";
$pgv_lang["ward"] = "Koğuş";
$pgv_lang["witness"] = "Şahit";

//-- statistics utility
$pgv_lang["stat_create"]		= "Kendi çizelgeni oluştur";
$pgv_lang["statutci"]			= "Dizin oluşturulamıyor";
$pgv_lang["statnnames"]			= "Toplam bireyler";
$pgv_lang["statnfam"]			= "Taplam aileler";
$pgv_lang["statnmale"]			= "Toplam erkekler";
$pgv_lang["statnfemale"]		= "Toplam kadınlar";
$pgv_lang["with_sources"]		= "Kaynaklar ile";
$pgv_lang["without_sources"]	= "Kaynakları olmadan";
$pgv_lang["stat_sindi"]			= "Kaynaklar ile bireyler";
$pgv_lang["stat_sfam"]			= "Kaynaklar ile aileler";
$pgv_lang["statvars"]			= "Çizelge için aşağıdaki parametreleri doldurun";
$pgv_lang["statlxa"]			= "Çizelge tipi seç:";
$pgv_lang["statlya"]			= "sonuçlar:";
$pgv_lang["statlza"]			= "Kategoriler:";
$pgv_lang["map_type"]			= "Harita tipi";
$pgv_lang["stat_1_map"]			= "Birey dağılım";
$pgv_lang["stat_2_map"]			= "Ülkelere göre doğum";
$pgv_lang["stat_3_map"]			= "Ülkelere göre ölüm";
$pgv_lang["stat_4_map"]			= "Ülkelere göre evlilik";
$pgv_lang["stat_5_birth"]		= "Yüzyıla göre doğumlar";
$pgv_lang["stat_6_death"]		= "Yüzyıla göre ölümler";
$pgv_lang["stat_7_marr"]		= "Yüzyıla göre evlilikler";
$pgv_lang["stat_7_div"]			= "Yüzyıla göre boşanmalar";
$pgv_lang["stat_8_fam"]			= "Kaynaklar ile aileler";
$pgv_lang["stat_9_indi"]		= "Kaynaklar ile bireyler";
$pgv_lang["stat_10_none"]		= "Hiçbiri";
$pgv_lang["stat_11_mb"]			= "Doğum ayı";
$pgv_lang["stat_12_md"]			= "Ölüm ayı";
$pgv_lang["stat_13_mm"]			= "Evlenme ayı";
$pgv_lang["stat_14_mb1"]		= "Bir ilişkide ilk çocuğun doğum ayı";
$pgv_lang["stat_15_mm1"]		= "İlk evlliğin ayı";
$pgv_lang["stat_16_mmb"]		= "Evlilik ve ilk çocuğun arasındaki ayı";
$pgv_lang["stat_17_arb"]		= "Doğum yılına ilişkin yaşı";
$pgv_lang["stat_18_ard"]		= "Ölüm yılına ilişkin yaşı";
$pgv_lang["stat_18_aard"]		= "Ölüm yüzyıla ilişkili ortalama yaşı";
$pgv_lang["stat_19_arm"]		= "Evlilik yılın yaşı";
$pgv_lang["stat_19_aarm"]		= "Evliliğin yüzyıl içindeki ortalama yaşı";
$pgv_lang["stat_20_arm1"]		= "İlk evliliğin yılın içindeki yaşı";
$pgv_lang["stat_21_nok"]		= "Çocuk sayısı";
$pgv_lang["stat_22_fwok"]		= "Çocuklar olmadan aile sayısı";
$pgv_lang["stat_200_none"]		= "hepsi (yada boşluk)";
$pgv_lang["stat_201_num"]		= "sayılar";
$pgv_lang["stat_202_perc"]		= "yüzde";
$pgv_lang["stat_300_none"]		= "hiçbiri";
$pgv_lang["stat_301_mf"]		= "cinsiyet";
$pgv_lang["stat_302_cgp"]		= "tarih dönemleri";
$pgv_lang["century"]			= "yüzyıl";
$pgv_lang["stat_age"]			= "Yaş";
$pgv_lang["no_date_fam"]		= "bilinmiyor";
$pgv_lang["statar_xgp"]			= "dönemler için sınırlama:";
$pgv_lang["statar_xgl"]			= "yaşlar için sınırlama:";
$pgv_lang["statar_xgm"]			= "aylar için sınırlama:";
$pgv_lang["statar_xga"]			= "sayılar için sınırlama:";
$pgv_lang["statar_zgp"]			= "tarih dönemleri için sınırlama:";
$pgv_lang["less"]				= "den az";
$pgv_lang["over"]				= "üzerinde";
$pgv_lang["interval"]			= "arası";
$pgv_lang["aft_marr"]			= "evlilikten sonra ay";
$pgv_lang["bef_marr"]			= "evlilikten önce ve sonra ay";
$pgv_lang["quarters"]			= "evlilikten sonra çeyrek";
$pgv_lang["half_year"]			= "evlilikten sonra yarım yıl";
$pgv_lang["one_child"]			= "bir çocuk arası";
$pgv_lang["two_children"]		= "iki çocuk arası";
$pgv_lang["statreset"]			= "sıfırla";
$pgv_lang["statsubmit"]			= "çizelgeyi göster";
$pgv_lang["stat_largest_families"] = "En geniş aileler";

$pgv_lang["stat_own_charts"]		= "Kendi çizelgelerin";
$pgv_lang["statnliving"]			= "Toplam yaşayan";
$pgv_lang["statndead"]				= "Toplam ölü";
$pgv_lang["stat_births"]			= "Toplam doğumlar";
$pgv_lang["stat_marriages"]			= "Toplam evlilikler";
$pgv_lang["stat_divorces"]			= "Toplam boşanmalar";
$pgv_lang["stat_deaths"]			= "Toplam vefatlar";
$pgv_lang["stat_first_birth"]		= "En erken doğan";
$pgv_lang["stat_first_marriage"]	= "En erken evlilik";
$pgv_lang["stat_first_divorce"]		= "En erken boşanan";
$pgv_lang["stat_first_death"]		= "En erken vefat";
$pgv_lang["stat_last_birth"]		= "En son doğum";
$pgv_lang["stat_last_marriage"]		= "En son evlilik";
$pgv_lang["stat_last_divorce"]		= "En son boşanma";
$pgv_lang["stat_last_death"]		= "En son vefat";
$pgv_lang["stat_lifespan"]			= "Ömür";
$pgv_lang["stat_lived_longest"]		= "En yaşlı vefat yaşı";
$pgv_lang["stat_live_longest"]		= "En yaşlı yaşayan kişi";
$pgv_lang["stat_marr_age"]			= "Evliliğin süresi";
$pgv_lang["stat_long_marr_age"]		= "En uzun evlilik";
$pgv_lang["stat_short_marr_age"]	= "En kısa evlilik";
$pgv_lang["stat_youngest_male"]		= "En genç erkek";
$pgv_lang["stat_youngest_female"]	= "En genç kadın";
$pgv_lang["stat_oldest_male"]		= "En yaşlı erkek";
$pgv_lang["stat_oldest_female"]		= "En yaşlı kadın";
$pgv_lang["stat_childbirth_age"]	= "Çocuğun doğum yaşı";
$pgv_lang["stat_youngest_father"]	= "En genç baba";
$pgv_lang["stat_youngest_mother"]	= "En genç anne";
$pgv_lang["stat_oldest_father"]		= "En yaşlı baba";
$pgv_lang["stat_oldest_mother"]		= "En yaşlı anne";
$pgv_lang["stat_children_in_fam"]	= "Ailenin çocukları";
$pgv_lang["stat_largest_gfamilies"]	= "En geniş büyük aileler";
$pgv_lang["stat_age_difference"]	= "Yaş farkı";
$pgv_lang["stat_age_siblings"]		= "Kardeşler arasındaki yaş";
$pgv_lang["stat_top_age_siblings"]	= "Kardeşler arasındaki en çok yaş farkı";
$pgv_lang["stat_age_mf_spouse"]		= "Koca ve Hanım arasındaki yaş";
$pgv_lang["stat_age_fm_spouse"]		= "Hanım ve Koca arasındaki yaş";
$pgv_lang["stat_names"]				= "Adlar";
$pgv_lang["statnsurnames"]			= "Toplam soyadılar";
$pgv_lang["statngivennames"]		= "Toplam verilen adlar";
$pgv_lang["top_surnames"]			= "En çok ortak soyadılar";
$pgv_lang["top_givennames"]			= "En çok verilen adlar";
$pgv_lang["events"]					= "Hadiseler";
$pgv_lang["stat_records"]			= "Kayıtlar";
$pgv_lang["stat_notes"]				= "Notlar";
$pgv_lang["stat_first_event"]		= "İlk hadise";
$pgv_lang["stat_last_event"]		= "Son hadise";
$pgv_lang["stat_places"]			= "Yerler";
$pgv_lang["stat_birth_places"]		= "Doğum yerleri";
$pgv_lang["stat_marriage_places"]	= "Evlilik yerleri";
$pgv_lang["stat_death_places"]		= "Vefat yerleri";
$pgv_lang["stat_countries"]			= "Ülkelerdeki hadiseler";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]	= "Çizelge İstatistikleri";
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplinfo"]			= "çizelgenin bilgisi:";
$pgv_lang["stpltype"]			= "tipi:";
$pgv_lang["stplnoim"]			= " gerçekleşmedi:";
$pgv_lang["stplmf"]			= " her cinsiyet";
$pgv_lang["stplipot"]			= " her zaman dönemi";
$pgv_lang["stplmonth"]			= "ay";
$pgv_lang["stplnumbers"]		= "sayı";
$pgv_lang["stplnuch"]			= "çocuklar";
$pgv_lang["stplage"]			= "yaş";
$pgv_lang["stplperc"]			= "yüzde";
$pgv_lang["stplnumof"]			 = "Sayılan";
$pgv_lang["stplmarrbirth"]		 = "İlk çocuğun doğum ve evlilik arasındaki ay";
$pgv_lang["indi_distribution_chart"]	= "Birey dağılım çizelgesi";
$pgv_lang["surname_distribution_chart"]	= "Soyadı dağılım çizelgesi";
$pgv_lang["g_chart_high"]		= "En yüksek nüfus";
$pgv_lang["g_chart_low"]		= "En düşük nüfus";
$pgv_lang["g_chart_nobody"]		= "Hiç kimse";
$pgv_lang["area_chart"]			= "Coğrafi bölge";
$pgv_lang["europe_chart"]		= "Evrupa";
$pgv_lang["s_america_chart"]	= "Güney Amerika";
$pgv_lang["asia_chart"]			= "Asya";
$pgv_lang["middle_east_chart"]	= "Orta Doğu";
$pgv_lang["africa_chart"]		= "Afrika";
$pgv_lang["world_chart"]		= "Dünya";

//-- alive in year
$pgv_lang["alive_in_year"]			= "Yılda Yaşayan";
$pgv_lang["is_alive_in"]			= "#YEAR# yılında yaşayan";
$pgv_lang["alive"]					= "Yaşayan";
$pgv_lang["dead"]					= "Ölü";
$pgv_lang["maybe"]					= "Belki";
$pgv_lang["both_alive"]					= "Her ikisi yaşayan ";
$pgv_lang["both_dead"]					= "Her ikisi ölü ";

//-- Help system
$pgv_lang["definitions"]		= "Tanımlar";

//-- Index_edit
$pgv_lang["block_desc"]				= "Blok Açıklamaları";
$pgv_lang["click_here"]				= "Devam etmek için burayı tıklayın";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Değişikliklerinizi kurtarması için bu düğmeyi tıklayın.<br /><br />#pgv_lang[welcome]# veya #pgv_lang[mygedview]# sayfasına dönmüş olacaksınız, ama değişikliklerinizi gösterilmeyebilir. Sayfanın uygun şekilde değişikliklerinizi görmeniz için tarayıcınızın görevini tekrar doldurduğunu kullanmaya ihtiyaç duyabilirsin.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Sizin #pgv_lang[welcome]# veya #pgv_lang[mygedview]# sayfasında yerleştirebileceğiniz blokların her birinin kısa bir tanımlaması buradadır.<br /><br /><table border='1' width='95%'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#GLOBALS[blockSummaries]#</table>";

//-- Find page
$pgv_lang["total_places"]			= "Bulunan yerler";
$pgv_lang["media_contains"]			= "Medya içerikleri:";
$pgv_lang["repo_contains"]			= "Havuz içerikleri:";
$pgv_lang["shared_note_contains"]	= "Paylaşılan Not içerikleri:";
$pgv_lang["source_contains"]		= "Kaynak içerkleri:";
$pgv_lang["display_all"]			= "Tümü göster";

// FAQ Page
$pgv_lang["add_faq_header"] = "SSS Başlık";
$pgv_lang["add_faq_body"] = "SSS Gövde";
$pgv_lang["add_faq_order"] = "SSS Konumu";
$pgv_lang["add_faq_visibility"] = "SSS Görülebilir";
$pgv_lang["no_faq_items"] = "SSS listesi boş.";
$pgv_lang["position_item"] = "Konum öğesi";
$pgv_lang["faq_list"] = "SSS Listesi";
$pgv_lang["confirm_faq_delete"] = "Bu SSS girdisini silmek istediğiniz emin misiniz?";
$pgv_lang["preview"] =  "Önizleme";
$pgv_lang["no_id"] = "SSS ID belirlenmedi !";

// Help search
$pgv_lang["hs_title"] 			= "Yardım Metni Ara";
$pgv_lang["hs_search"] 			= "Ara";
$pgv_lang["hs_close"] 			= "Pencereyi kapat";
$pgv_lang["hs_results"] 		= "Bulunan sonuçlar:";
$pgv_lang["hs_keyword"] 		= "İçin ara";
$pgv_lang["hs_searchin"]		= "Aranacak yer";
$pgv_lang["hs_searchuser"]		= "Kullanıcı Yardım";
$pgv_lang["hs_searchmodules"]	= "Yardım Modülleri";
$pgv_lang["hs_searchconfig"]	= "Yönetici Yardım";
$pgv_lang["hs_searchhow"]		= "Arama tipi";
$pgv_lang["hs_searchall"]		= "Tüm kelimeler";
$pgv_lang["hs_searchany"]		= "Herhangi bir kelime";
$pgv_lang["hs_searchsentence"]	= "Tam tabir";
$pgv_lang["hs_intruehelp"]		= "Sadece yardım metni";
$pgv_lang["hs_inallhelp"]		= "Tüm metin";

// Media import
$pgv_lang["choose"] = "Seçin: ";
$pgv_lang["account_information"] = "Hesap Bilgileri";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] = "Ses";
$pgv_lang["TYPE__book"] = "Kitap";
$pgv_lang["TYPE__card"] = "Kart";
$pgv_lang["TYPE__certificate"] = "Sertifika";
$pgv_lang["TYPE__coat"] = "Arma";
$pgv_lang["TYPE__document"] = "Belge";
$pgv_lang["TYPE__electronic"] = "Elektronik";
$pgv_lang["TYPE__fiche"] = "Mikrofiş";
$pgv_lang["TYPE__film"] = "Mikrofilm";
$pgv_lang["TYPE__magazine"] = "Magazin";
$pgv_lang["TYPE__manuscript"] = "El yazması";
$pgv_lang["TYPE__map"] = "Harita";
$pgv_lang["TYPE__newspaper"] = "Gazete";
$pgv_lang["TYPE__photo"] = "Fotoğraf";
$pgv_lang["TYPE__tombstone"] = "Mezartaşı";
$pgv_lang["TYPE__video"] = "Video";
$pgv_lang["TYPE__painting"] = "Boyama";
$pgv_lang["TYPE__other"] = "Diğer";

//-- Other media suff
$pgv_lang["view_slideshow"] = "Slayt olarak görüntüle";
$pgv_lang["download_image"]			= "Dosya İndir";
$pgv_lang["no_media"]				= "Medya Bulunamadı";
$pgv_lang["media_privacy"]			= "Bu öğeyi görüntülerken gizlilik kısıtlamasından dolayı engeller";
$pgv_lang["relations_heading"]		= "Resimle ilişkili:";
$pgv_lang["file_size"]				= "Dosya Boyutu";
$pgv_lang["img_size"]				= "Resim Boyutu";
$pgv_lang["media_broken"]			= "Bu medya dosyası bozuk ve filigranlaşmaz";
$pgv_lang["unknown_mime"]			= "Medya Güvenlik Duvarı hatası: dosya için >Bilinmeyen Mimetype<";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] = "Bilinmeyen eylem: [action].";
$pgv_lang["module_error_unknown_type"] = "Bilinmeyen modül tipi.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] = "Belirtilen yılda yaşayan kişileri göster.";
$pgv_lang["button_BIRT_Y100"] = "Son 100 yıl içinde doğmuş kişileri göster.";
$pgv_lang["button_BIRT_YES"] = "100 yıldan daha fazla önce doğmuş kişileri göster";
$pgv_lang["button_DEAT_H"] = "Sadece erkek ortağı ölmüş çiftleri nerede göster.";
$pgv_lang["button_DEAT_N"] = "Yaşayan kişiyi veya yaşayan her iki eşi göster.";
$pgv_lang["button_DEAT_W"] = "Sadece kadın ortağı ölmüş çiftleri nerede göster.";
$pgv_lang["button_DEAT_Y"] = "Ölü kişiyi veya ölmüş her iki eşi göster.";
$pgv_lang["button_DEAT_Y100"] = "Son 100 yıl içinde ölmüş kişileri göster.";
$pgv_lang["button_DEAT_YES"] = "100 yıldan daha fazla önce  ölmüş kişileri göster.";
$pgv_lang["button_MARR_DIV"] = "Boşanmış çiftleri göster.";
$pgv_lang["button_MARR_U"] = "Evlilik tarihleri bilinmeyen çiftleri göster.";
$pgv_lang["button_MARR_Y100"] = "Son 100 yıl içinde evlenen çiftleri göster.";
$pgv_lang["button_MARR_YES"] = "100 yıldan daha fazla önce evlenen çiftleri göster.";
$pgv_lang["button_reset"] = "Listeyi varsayılana sıfırla.";
$pgv_lang["button_SEX_F"] = "Sadece kadınları göster.";
$pgv_lang["button_SEX_M"] = "Sadece erkekleri göster.";
$pgv_lang["button_SEX_U"] = "Sadece cinsiyeti bilinmeyen kişileri göster.";
$pgv_lang["button_TREE_L"] = "«yapraklar» çiftleri yada bireyleri göster. Bu bireyler yaşıyor ancak veritabanına hiçbir çocuğu kaydedilmemiş.";
$pgv_lang["button_TREE_R"] = "«kökler» çiftleri yada bireyleri göster. Bu kişiye «aile reisi» denebilir. Onlar veritabanında hiçbir ebeveynleri kayıtlı olmayan bireylerdir.";
$pgv_lang["sort_column"] = "Buna göre sırala";


?>
