<?php
/**
 * Danish language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.da.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.da.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Nogle programmer giver dig mulighed for at indtaste forskningsopgaver som TODO-elementer i din genealogiske database. Denne mulighed vil søge gennem din genealogiske database og automatisk konvertere hvert TODO-element til en forskningsopgave.";
$pgv_lang["ra_mytasks_block_descr"]		= "«#pgv_lang[ra_my_tasks]#» blokken viser opgaver for den aktuelle bruger. Det kan konfigureres til at vise udførte opgaver eller til at vise opgaver, der ikke er tildelt i øjeblikket.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Sådan organiseres opgaver~<br /><br />Opgaverne er organiseret i mapper. Der skal eksistere mindst én mappe, før nogen opgaver kan oprettes.<br /><br />Du kan oprette og organisere dine mapper, som du vil. Du vil sandsynligvis organisere dine onlinemapper, som du organiserer papirkopier af din forskning. Mange forskere organiserer deres mapper efter familielinje, efternavn eller geografiske placeringer.";
$pgv_lang["ra_whataretasks_words"]		= "~Hvad er opgaver?~<br /><br />#pgv_lang[ra_RA_name]# modulet er centreret om forskningsopgaven. En forskningsopgave ligner en TODO-vare og sporer en bestemt slægtsforskningsopgave, der skal udføres. Et eksempel på en opgavetitel kan være «Find Joe's fødselsjournal», mens detaljerne i beskrivelsen ville indikere «Find Joe's fødselsjournal i Ottawa county Fødselsoptegnelser».<br /><br />Opgaver kan tildeles specifikke brugere. Ved at tildele opgaver til brugere ved alle, hvilken forskning de skal arbejde med, og hvem der arbejder med andre forskningsopgaver.<br /><br />Opgaver kan også omfatte handlinger mod kildemateriale eller relateret til en eller flere personer i dine data. Med #pgv_lang[ra_RA_name]# modulet installeret, vil du se en «#pgv_lang[ra_RA_name]#» sektion på hver «#pgv_lang[personal_facts]#» side og også en opgavesektion på hver kildedataside.<br /><br />Opgaver oprettes i tilstanden <b>#pgv_lang[ra_incomplete]#</b>, hvilket indikerer, at arbejdet med dem er i gang. Alle opgaver bør tildeles en bruger, der kan redigere og opdatere posterne med resultaterne. Når alt arbejdet er udført, skal opgaven indsendes som <b>#pgv_lang[ra_complete]#</b>. Dette vil fjerne det fra de aktivt synlige (dvs. #pgv_lang[ra_incomplete]#) opgavelister. Ved at bruge menuen «#pgv_lang[ra_my_tasks]#» kan hver bruger se deres tildelte opgaver, både #pgv_lang[ra_incomplete]# og #pgv_lang[ra_complete]#.<br /><br />Hver opgave har en kommentarsektion, hvor diskussioner om data og forskning eller mulige resultater kan forekomme. Dette gør det muligt for opgaven at forblive målorienteret, mens kommentarerne er fremskridts- og resultatorienterede.";
$pgv_lang["ra_sortcol_words"]		= "Denne kolonne kan sorteres ved at klikke på kolonneoverskriften.";
$pgv_lang["ra_folder_words"]			= "Mapper er et opgavestyringsværktøj, der tillader gruppering af opgaver sammen. Mapper kan være indeholdt i andre mapper. Hvis der er en overordnet mappe, vil den blive vist i venstre side af menuerne ovenfor. Hvis dette område er tomt, er disse mapper på det øverste niveau.";
$pgv_lang["ra_view_task_words"]		= "Opgaver er måder at administrere forskningsopgaver eller handlinger til opfølgning på. Opgaven er opsummeret med dens titel, mens beskrivelsesfeltet definerer flere detaljer om, hvad der kræves. Nogle gange kan opfølgningen til beslutningen også indgå i beskrivelsesfeltet. Under «#pgv_lang[ra_Task_View]#» tabellen er der en «#pgv_lang[ra_comments]#» tabel, der kan bruges til at spore fremskridt og til at beskrive opgaveløsninger.";
$pgv_lang["ra_special_char_words"]		= "Nogle gange skal din tekst muligvis vise symboler, der har særlige betydninger for browseren eller for PhpGedView, bortset fra at være almindelig tekst. Når sådanne symboler skal forekomme i din tekst, skal du indtaste dem i et format, der indikerer, at det er tekst uden særlig betydning.<ul><li><b>&amp;</b>&nbsp;&nbsp;Dette symbol signalerer starten på en HTML-entitet. For at angive, at dette symbol er almindelig tekst, kan du enten sikre, at det altid efterfølges af et mellemrum, eller du kan indtaste det i dets HTML-entitetsform <b>&amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Dette symbol bruges i hjælpesystemet til PhpGedView. For at angive, at dette symbol er almindelig tekst, kan du enten sikre, at det altid efterfølges af et mellemrum, eller du kan indtaste det i dets numeriske form <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Dette symbol bruges i hjælpesystemet til PhpGedView. For at angive, at dette symbol er almindelig tekst, kan du enten sikre, at det altid efterfølges af et mellemrum, eller du kan indtaste det i dets numeriske form <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Dette symbol fortolkes af browseren til at betyde, at det følgende symbol er tekst. For at angive, at dette symbol er almindelig tekst, skal du indtaste to af dem <b>&#92;&#92;</b> eller du kan indtaste det i dets numeriske form <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Dette symbol fortolkes af browseren til at angive starten på et HTML-tag. For at angive, at dette symbol er almindelig tekst, skal du indtaste det i dets HTML-entitetsform <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Dette symbolet fortolkes af browseren til at angive slutningen af et HTML-tag. For at angive, at dette symbol er almindelig tekst, skal du indtaste det i dets HTML-entitetsform <b>&amp;gt;</b></li></ul>Du kan oprette lister over elementer i en beskrivelse. Hvis du vil have nummererede eller punktopstillede lister, skal du begynde din indtastning af disse listeelementer med <b>&lt;ul&gt;</b> for en punktopstilling eller <b>&lt;ol&gt;</b> for en nummereret liste.<br /><br />Hvert listeelement skal begynde med <b>&lt;li&gt;</b> og afslutte med <b>&lt;/li&gt;</b>. Det sidste listepunkt skal afsluttes som alle de andre og bør efterfølges af <b>&lt;/ul&gt;</b> for at lukke punktlisten eller <b>&lt;/ol&gt;</b> for at lukke den nummererede liste.<br /><br />De foregående bemærkninger om indtastning af symbolerne «Mindre end» <b>&lt;</b> og «Større end» <b>&gt;</b>, der normalt omslutter HTML-tags, da tekst ikke gælder, da du i dette tilfælde faktisk skal indtaste HTML-tags.";
$pgv_lang["ra_add_task_words"]		= "Før nogen opgaver kan oprettes, <u>skal</u> du have oprettet en mappe til at indeholde den pågældende opgave.<br /><br />Opgaver er måder at administrere forskningsopgaver eller handlinger til opfølgning på. Disse opgaver er opsummeret med deres titler og bruger beskrivelsesfelterne til at definere mere detaljeret, hvad der kræves. Opgaver kan også have noget kildemateriale, der skal undersøges, så dette kan vedhæftes, og hvis der er en eller flere personer, som denne opgave er tilknyttet, skal de også knyttes til denne nye opgave.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />«#pgv_lang[ra_my_tasks]#» listen viser forskningsopgaver for den aktuelle bruger. Som standard viser opgavelisten åbne eller ufuldstændige opgaver for den aktuelle bruger. Dette kan konfigureres til yderligere at vise udførte opgaver og til at vise opgaver, der i øjeblikket ikke er tildelt. Den resulterende tabel kan derefter bruges til hurtigt at se på de forskningsopgaver, der skal styres.<ul><li>Når du klikker på et <b>#pgv_lang[ra_title]#</b>, vil du blive ført til et «#pgv_lang[ra_Task_View]#» for flere detaljer om den specifikke opgave.</li><li>#pgv_lang[ra_Start_Date]# angiver, hvornår opgaven oprindeligt var oprettet.</li><li>Når du klikker på <b>#pgv_lang[ra_edit]#</b> i slutningen af hver opgaves række, vil du blive ført til «#pgv_lang[ra_edit_task]#» visningen for den specifikke opgave opgave for at opdatere eller fuldføre den.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Dette område viser potentielle manglende oplysninger om en persons journal. Dette kan for eksempel omfatte en manglende fødselskilde eller det faktum, at personen var i live under en militær konflikt, men mangler en militær indrejse. #pgv_lang[ra_RA_name]# vil inspicere personens genealogiske databasepost for mulige manglende oplysninger og producere en liste over potentielle opfølgningsopgaver, som kan oprettes.<br /><br />Før eventuelle manglende opgaver kan oprettes, <u>skal</u> du have oprettet en mappe til at indeholde opgaverne.<br /><br />Tabellen viser en liste over potentielle nye opgaver, der kunne oprettes eller tidligere genereres opgaver at se.<ul><li>For at oprette en opgave for at spore nogle manglende oplysninger, skal du markere afkrydsningsfeltet ud for den. Når alle ønskede opgaver er valgt, og en mappe til gruppering af disse nye opgaver er valgt, skal du klikke på <b>#pgv_lang[ra_AddTask]#</b> for at oprette opgaver til de manglende elementer.</li><li>Eksisterende opgaver vil vise <b>#pgv_lang[ra_view]#</b> i stedet for et afkrydsningsfelt, som, når du klikker på det, vil tage dig direkte til at se opgaven.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Den viste tabel er en liste over forskningsopgaver, der er knyttet til denne persons journal. Kun opgaver, der ikke er markeret som afsluttede, vises. De kunne være blevet oprettet manuelt eller genereret ved at bruge tabellen «#pgv_lang[ra_missing_info]#», men hver opgave har denne person tilknyttet.<br /><br />Klik på opgavens titel for at se yderligere detaljer om det.</br>Klik på knappen <b>#pgv_lang[ra_task_entry]#</b> nederst i tabellen for manuelt at oprette en ny opgave knyttet til denne persons post.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Dette er en liste over alle opgaver, der er knyttet til denne kilde. Kun opgaver, der ikke er markeret som afsluttede, vises. Meddelelsen «#pgv_lang[ra_no_sour_tasks]#» vises, når ingen opgaver har linket til denne kilde. Når der er en tilknyttet opgave, skal du klikke på opgavens titel for at starte «#pgv_lang[ra_view_task]#» siden for at få flere detaljer om den.<br /><br /><b>Bemærk</b>: Nye opgaver kan ikke oprettes i «#pgv_lang[ra_source]#» posten. Brug funktionen <b>#pgv_lang[ra_AddTask]#</b>, hvis det er nødvendigt specifikt for en kilde, der ikke er knyttet til en person.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Denne tabel er en liste over opgaver. Kolonnerne omfatter:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;En oversigtstitel for opgaven. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er en detaljeret beskrivelse af den opgave, der er nødvendig for forskning eller handlinger til opfølgning. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Dette er oprettelsesdatoen for opgaven. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Dette angiver, om en opgave er fuldført eller ej. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Denne post angiver, hvem der ejer en forskningsopgave. Denne kolonne vises ikke i «#pgv_lang[ra_my_tasks]#» visningen, da du er ejer af alle disse opgaver.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Hvis du er ejeren af denne opgave eller har administrationsrettigheder, indeholder denne post et <u>link</u> , som vil tage dig til at redigere opgaven, ellers vil den være tom.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Hvis du er ejer af denne opgave eller har administrationsrettigheder, indeholder denne post et <u>link</u> , som vil tage dig til at slette opgaven, ellers bliver den tom.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Hvis du er ejer af denne opgave eller har administrationsrettigheder, indeholder denne post et <u>link</u> , som vil tage dig til straks at lukke en opgave, hvis den ikke er fuldført i øjeblikket, ellers vil dette felt være tomt. Denne kolonne vil kun blive vist i «#pgv_lang[ra_my_tasks]#» visningen, da du er ejer af alle disse opgaver.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Denne tabel opsummerer én specifik opgave.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dette er titlen på opgaven.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Dette er den mappe, som opgaven er grupperet i.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Dette er forsker, som opgaven på nuværende tidspunkt er tildelt.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er den detaljerede beskrivelse af opgaven, der er nødvendig for forskning eller handlinger til opfølgning.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Enhver kilde, der er nødvendig for forskning eller handlinger for opfølgning på opgaven.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Dette er en liste over personer fra stamtræet, som er tilknyttet opgaven. Dette felt kan indeholde flere poster. Kun personer i stamtræet vises.</li></ul><br />Hvis du er den tildelte ejer af opgaven eller har administrationsrettigheder, vil en knap blive vist, og du kan klikke på <b>#pgv_lang[ra_edit_task]#</b> for at redigere detaljerne for opgaven.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Formularens felter omfatter:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dette bør indeholde en kort oversigt, typisk mindre end 30 tegn i længden, af den opgave, du tilføjer.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Vælg den mappe, hvor du vil administrere din nye opgave. Kun eksisterende mapper vises. Hvis du vil tildele denne nye opgave til en ny mappe, skal du bruge funktionen <b>#pgv_lang[ra_add_folder]#</b> fra hovedmenuen #pgv_lang[ra_RA_name]# først.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Vælg fra listen over brugere med redigeringstilladelser en person, der kan eje eller opdatere opgaven og eventuelle poster forbundet med den. Generelt må dette felt aldrig være tomt (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Indtast en detaljeret beskrivelse af den opgave, du vil tilføje.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Vedhæft eventuelle kilder, du har til opgaven. Dette felt kan indeholde flere poster.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Vælg alle personer, der er knyttet til denne opgave. Dette felt kan indeholde flere poster, men kun personer fra din genealogiske database kan vælges og vises i dette felt.</li></ul><br />Når du opretter en ny opgave, kan den gemmes ved at klikke på knappen <b>#pgv_lang[ra_submit]#</b>, som holder den åben og i tilstanden #pgv_lang[ra_incomplete]# for yderligere opdateringer. Opgaven kan gemmes og markeres som #pgv_lang[ra_complete]# på samme tid ved at klikke på knappen <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Formularens felter omfatter:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dette skal indeholde titlen eller resuméet af den opgave, som du redigerer.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;I dette felt kan du vælge den mappe, hvor du vil administrere din nye opgave.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Indtast en detaljeret beskrivelse af den opgave, du vil tilføje.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Vedhæft eventuelle kilder, du har til opgaven. Dette felt kan indeholde flere poster.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Vælg alle personer, der er tilknyttet denne opgave. Dette felt kan indeholde flere poster, men kun personer kan vælges fra din genealogiske database og vises i dette felt.</li></ul><br />Efter at have ændret en eksisterende opgave, kan den indsendes til fremtidige opdateringer ved at klikke på knappen <b>#pgv_lang[ra_save]#</b>. Opgaven kan også gemmes og markeres som #pgv_lang[ra_completed]# (der forventes ingen fremtidige opdateringer), ved at klikke på knappen <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Dette vil indeholde eventuelle kommentarer relateret til en forskningsopgave.<br /><br />Når du er i «#pgv_lang[ra_RA_name]#» sektionen for en person, er disse kommentarer knyttet til den specifikke post for denne person og kun synlige her. Hvis en kommentar vises under en opgave, er denne kommentar specifik for den pågældende opgave. I hvert tilfælde kan der være flere uafhængige kommentarer. Hver enkelt kan redigeres eller slettes uafhængigt med den seneste kommentar altid vist øverst.<br /><br />Klik på <b>#pgv_lang[ra_add_new_comment]#</b> for at tilføje nye kommentarer til denne liste.<br /><br /><span class='warning'>Hvis du, mens du redigerer en opgave, tilføjer en ny kommentere, før du gemmer din redigerede opgave, vil alle ikke-gemte opgaveændringer gå tabt.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dette er en liste over mapper og beskrivelser af deres brug.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Denne kolonne indeholder navnene på alle de mapper på dette niveau, som du har skabt. Ved at vælge mappenavnet vil du blive navigeret til et nyt display, der viser eventuelle undermapper og alle opgaver, der er knyttet til denne mappe. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Denne kolonne indeholder en mere detaljeret beskrivelse af brugen af disse mapper. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Denne kolonne har et <u>link</u> for at tillade redigering af mappens navn, beskrivelse eller hierarki.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Denne formular understøtter oprettelsen af en ny mappe, dens beskrivelse af brug og hierarkiet af andre mapper, som denne mappe passer ind i.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Titlen opsummerer brugen af den mappe, du tilføjer.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Du kan angive, om mappen er på højeste eller rodniveau (#pgv_lang[ra_No_Parent]#) eller som en undermappe til en anden mappe.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er den detaljerede beskrivelse af den mappe, du tilføjer.</li></ul>Hvis du klikker på knappen <b>#pgv_lang[ra_add]#</b>, sendes oplysningerne for at oprette en ny mappe. Hvis du klikker på knappen <b>#pgv_lang[ra_reset]#</b>, kasseres eventuelle ændringer i beskrivelsesfeltet.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Denne formular understøtter redigering af en eksisterende mappe, dens beskrivelse af brug og hierarkiet af andre mapper, som denne mappe passer ind i.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;title opsummerer brugen af den mappe, du tilføjer.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Du kan angive, om mappen enten er på det højeste niveau (# pgv_lang[ra_No_Parent]#) eller som en undermappe til en anden mappe.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er den detaljerede beskrivelse af den mappe, du er tilføjer.</li></ul><br />Knappen <b>#pgv_lang[ra_add]#</b> sender oplysningerne for at oprette en ny mappe. Knappen <b>#pgv_lang[ra_reset]#</b> vil kassere eventuelle ændringer i beskrivelsesfeltet siden sidst gemt. Når en mappe er tom, vises knappen <b>#pgv_lang[ra_delete]#</b> for at tillade fjernelse af denne mappe fra mappehierarkiet, ellers vil du blive advaret om, at sletning ikke er tilladt med opgaver, der stadig er til stede i den.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Baseret på den valgte person vil denne funktion automatisk udtrække forskellige vitale og faktaoplysninger fra din genealogiske database og give dig mulighed for at bestemme, hvilke af disse der skal videregives til en ekstern slægtsforskningswebsteds søgemaskine. Forskellige websteder kan vælges, herunder Ancestry, FamilySearch, Findagrave og mere. Resultaterne af disse søgninger kan bruges til at tilføje eller opdatere oplysninger i din genealogiske database.<br /><br />Når du er i «#pgv_lang[ra_RA_name]#» sektionen på en persons «#pgv_lang[personal_facts]#» side, vil søgningen være baseret på den pågældende person. Hvis den startes fra #pgv_lang[ra_RA_name]# hovedmenuerne, skal en person først vælges ved at klikke på personikonet for at vælge en person eller indtaste personens identifikationsnummer i feltet.<br /><br />Vælg navnet på det slægtsforskningssted, du ønsker at forespørge på, fra listen. Du får vist en liste over oplysninger, der kan vælges. Angiv med flueben ved siden af hvert element (navn, fødsels- eller dødsdato osv.) de elementer, der vil blive sendt til den valgte søgemaskine, efter at <b>#pgv_lang[ra_autosearch_search]#</b> knappen er blevet klikket. Den eksterne hjemmesides søgemaskine lanceres på en ny side. Brug #pgv_lang[ra_task_list]# administrationsfaciliteten til at identificere yderligere resultater til opfølgning.<br /><br />Bemærk venligst, at søgemaskinerne konstant udvikler sig, så når de først er på et slægtsforskningswebsted, kan de oprindelige muligheder der tilbyde flere søgekriterier, som kan opdateres for at berige din forskning.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Denne side analyserer dataene i din genealogiske database og viser sammenhængene mellem forskellige dataelementer.<br /><br />Der kan for eksempel være en 95 % korrelation på, at efternavnet i en lokal post er det samme som efternavnet i faderens optegnelse. Dette ville betyde, at 95% af personerne i denne genealogiske database deler det samme efternavn som deres far. I denne version af #pgv_lang[ra_RA_name]# modulet bliver disse beregninger brugt til at hjælpe med at identificere manglende oplysninger til en persons optegnelser. De bruges ikke i andre områder af programmet; de er kun givet som en hjælp til dig i din forskning.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Nogle genealogiske programmer giver dig mulighed for at indtaste forskningsopgaver som TODO-elementer i deres database. Når de eksporterer denne genealogiske information til andre programmer, vil de eksportere databaseposterne til en fil formateret i henhold til GEDCOM-anbefalingen. PhpGedView-softwaren bruger den GEDCOM-formaterede fil som input, så disse TODO-elementer er indlejret i dine data. Denne mulighed vil søge i din genealogiske database og automatisk konvertere alle importerede TODO-elementer til forskningsopgaver.<br /><br />Ved at klikke på <b>#pgv_lang[ra_generate]#</b> knappen nederst i formularen oprettes en liste over potentielle opgaver fra de importerede TODO-elementer. Fra denne liste kan du vælge elementer til at generere opgaver.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Markér hver opgave, der skal genereres, og generer derefter denne opgave.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;De første 30 tegn i opgavebeskrivelsen bliver opgavens navn. Du kan ændre eller rette dette, når du redigerer opgaven.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Beskrivelsen af opgaven vil blive givet, kopieret fra den komplette tekst af TODO-elementet i din genealogiske database. Du kan ændre eller rette dette, når du redigerer opgaven.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Klik på linket for at redigere denne opgave.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Vælg den mappe, hvor de genererede opgaver skal placeres.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;omdirigerer dig til #pgv_lang[ra_Folder_View]# siden.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Denne formular giver dig mulighed for at redigere de opgaver, der blev oprettet ud fra TODO-elementer i din genealogiske database.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;For at vælge den person, som du vil tilknytte dig til opgaven.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Klik på linket for at vælge den kilde, som opgaven skal knyttes til.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Gemmer alle dine ændringer og omdirigerer dig til #pgv_lang[ra_gen_tasks]# siden.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Kasserer alle dine ændringer og omdirigerer dig til #pgv_lang[ra_gen_tasks]# side.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Som administrator af dit PhpGedView-websted har du mulighed for at kontrollere synligheden af forskellige funktioner i #pgv_lang[ra_RA_name]# modulet. Denne dialog viser de tilgængelige funktionsblokke og beder dig om at vælge synlighed ved at vælge adgangskontrol for hver.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Den angivne funktionsblok er tilgængelig for alle.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Den angivne funktionsblok er kun tilgængelig for godkendte brugere.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Den angivne funktionsblokering er kun tilgængelig for brugere med administratorrettigheder.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Den angivne funktionsblok er ikke tilgængelig for nogen.</li></ul></ul>";
?>
