<?php
/**
 * Spanish language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.es.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.es.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Algunos programas le permiten ingresar tareas de investigación como elementos de TODO en su base de datos genealógica. Esta opción buscará en su base de datos genealógica y convertirá automáticamente cada elemento de TODO en una tarea de investigación.";
$pgv_lang["ra_mytasks_block_descr"]		= "El bloque «#pgv_lang[ra_my_tasks]#» muestra las tareas del usuario actual. Se puede configurar para mostrar las tareas completadas o las tareas que no están asignadas actualmente.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Cómo organizar tareas~<br /><br />Las tareas se organizan en carpetas. Debe existir al menos una carpeta para poder crear cualquier tarea.<br /><br />Puede crear y organizar sus carpetas como desee. Probablemente desee organizar sus carpetas en línea como organiza las copias impresas de su investigación. Muchos investigadores organizan sus carpetas por línea familiar, apellido o ubicación geográfica.";
$pgv_lang["ra_whataretasks_words"]		= "~¿Qué son las tareas?~<br /><br />El módulo #pgv_lang[ra_RA_name]# se centra en la tarea de investigación. Una tarea de investigación es similar a un elemento TODO y hace un seguimiento de una tarea de investigación genealógica particular que debe realizarse. Un ejemplo de título de tarea podría ser «Buscar el registro de nacimiento de Joe», mientras que los detalles en la descripción indicarían «Buscar el registro de nacimiento de Joe en los registros de nacimiento del condado de Ottawa».<br /><br />Se pueden asignar tareas a usuarios específicos. Al asignar tareas a los usuarios, todos saben en qué investigación deberían estar trabajando y quién está trabajando en otras tareas de investigación.<br /><br />Las tareas también pueden incluir acciones contra material de origen o relacionadas con una o más personas en sus datos. Con el módulo #pgv_lang[ra_RA_name]# instalado, verá una sección «#pgv_lang[ra_RA_name]#» en cada página «#pgv_lang[personal_facts]#» y también una sección Tareas en cada página de datos de origen.<br /><br />Las tareas se crean en el estado <b>#pgv_lang[ra_incomplete]#</b>, lo que indica que el trabajo en ellas está en curso. Todas las tareas deben asignarse a un usuario que pueda editar y actualizar los registros con los hallazgos. Una vez que se haya realizado todo el trabajo, la tarea debe enviarse como <b>#pgv_lang[ra_complete]#</b>. Esto la eliminará de las listas de tareas visibles de forma activa (es decir, #pgv_lang[ra_incomplete]#). Al utilizar el menú «#pgv_lang[ra_my_tasks]#», cada usuario puede ver las tareas que tiene asignadas, tanto #pgv_lang[ra_incomplete]# como #pgv_lang[ra_complete]#.<br /><br />Cada tarea tiene una sección de comentarios donde pueden tener lugar debates sobre los datos y la investigación o los posibles resultados. Esto permite que la tarea siga estando orientada a los objetivos, mientras que los comentarios están orientados al progreso y los resultados.";
$pgv_lang["ra_sortcol_words"]		= "Esta columna se puede ordenar haciendo clic en el encabezado de la columna.";
$pgv_lang["ra_folder_words"]			= "Las carpetas son una herramienta de gestión de tareas que permite agrupar tareas. Las carpetas pueden estar dentro de otras carpetas. Si hay una carpeta principal, se mostrará en el lado izquierdo de los menús de arriba. Si esa área está en blanco, estas carpetas se encuentran en el nivel superior.";
$pgv_lang["ra_view_task_words"]		= "Las tareas son formas de gestionar las tareas pendientes de investigación o las acciones de seguimiento. La tarea se resume en su título, mientras que el campo de descripción define más detalles sobre lo que se requiere. A veces, el seguimiento de la resolución también se puede incluir en el campo de descripción. Debajo de la tabla «#pgv_lang[ra_Task_View]#» hay una tabla «#pgv_lang[ra_comments]#» que se puede utilizar para realizar un seguimiento del progreso y para describir las resoluciones de las tareas.";
$pgv_lang["ra_special_char_words"]		= "En ocasiones, es posible que su texto deba mostrar símbolos que tienen significados especiales para el navegador o para PhpGedView, además de ser texto normal. Cuando dichos símbolos deben aparecer en su texto, debe ingresarlos en un formato que indique que son texto sin un significado especial.<ul><li><b>&amp;</b>&nbsp;&nbsp;Este símbolo señala el inicio de una entidad HTML. Para indicar que este símbolo es texto normal, puede asegurarse de que siempre esté seguido de un espacio o puede introducirlo en su forma de entidad HTML <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Este símbolo se utiliza en el sistema de ayuda de PhpGedView. Para indicar que este símbolo es texto normal, puede asegurarse de que siempre esté seguido de un espacio o puede introducirlo en su forma numérica. <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Este símbolo se utiliza en el sistema de ayuda de PhpGedView. Para indicar que este símbolo es texto normal, puede asegurarse de que siempre esté seguido de un espacio o puede introducirlo en su forma numérica. <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Este símbolo es interpretado por el navegador para indicar que el símbolo que sigue es texto. Para indicar que este símbolo es texto normal, debe introducir dos de ellos <b>&#92;&#92;</b> o puede introducirlo en su forma numérica <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Este símbolo es interpretado por el navegador para indicar el inicio de una etiqueta HTML. Para indicar que este símbolo es texto normal, debe introducirlo en su forma de entidad HTML <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Este símbolo es interpretado por el navegador para indicar el final de una etiqueta HTML. Para indicar que este símbolo es texto normal, debe introducirlo en su forma de entidad HTML <b>&amp;gt;</b></li></ul>Puede crear listas de elementos en una descripción. Si desea crear listas numeradas o con viñetas, comience la entrada de estos elementos de lista con <b>&lt;ul&gt;</b> para una lista con viñetas o con <b>&lt;ol&gt;</b> para una lista numerada.<br /><br />Cada elemento de lista debe comenzar con <b>&lt;li&gt;</b> y terminar con <b>&lt;/li&gt;</b>. El último elemento de la lista debe terminar como todos los demás y debe ser seguido por <b>&lt;/ul&gt;</b> para cerrar la lista con viñetas o <b>&lt;/ol&gt;</b> para cerrar la lista numerada.<br /><br />Las notas anteriores sobre cómo ingresar símbolos «Menor que» <b>&lt;</b> y «Mayor que» <b>&gt;</b>, que generalmente encierran etiquetas HTML, como texto, no se aplican ya que en este caso realmente necesita ingresar etiquetas HTML.";
$pgv_lang["ra_add_task_words"]		= "Antes de poder crear cualquier tarea, <u>debe</u> haber establecido una carpeta para contener esa tarea.<br /><br />Las tareas son formas de gestionar las tareas de investigación pendientes o las acciones de seguimiento. Estas tareas se resumen por título y utilizan los campos de descripción para definir con más detalle lo que se requiere. Las tareas también pueden tener algún material fuente para investigar, por lo que se puede adjuntar y, si hay una o más personas con las que está asociada esta tarea, también deben adjuntarse a esta nueva tarea.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />La lista «#pgv_lang[ra_my_tasks]#» muestra las tareas de investigación del usuario actual. De forma predeterminada, la lista de tareas muestra las tareas abiertas o incompletas del usuario actual. Esto se puede configurar para que muestre además las tareas completadas y las tareas que actualmente no están asignadas. La tabla resultante se puede utilizar para ver rápidamente las tareas de investigación que se deben gestionar.<ul><li>Cuando hace clic en un <b>#pgv_lang[ra_title]#</b>, se lo llevará a una «#pgv_lang[ra_Task_View]#» para obtener más detalles sobre la tarea específica.</li><li>#pgv_lang[ra_Start_Date]# indica cuándo se creó originalmente la tarea.</li><li>Cuando hace clic en <b>#pgv_lang[ra_edit]#</b> al final de la fila de cada tarea, se lo llevará a la vista «#pgv_lang[ra_edit_task]#» de esa tarea específica para actualizarla o completarla.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Esta área muestra información potencialmente faltante sobre el registro de una persona. Por ejemplo, podría incluir una fuente de nacimiento faltante o el hecho de que la persona estaba viva durante un conflicto militar pero le falta una entrada militar. #pgv_lang[ra_RA_name]# inspeccionará el registro de la base de datos genealógica de la persona para detectar la posible información faltante y generará una lista de posibles tareas de seguimiento que se pueden crear.<br /><br />Antes de poder crear cualquier tarea faltante, <u>debe</u> haber establecido una carpeta para contener las tareas.<br /><br />La tabla presenta una lista de posibles nuevas tareas que podrían crearse o tareas generadas previamente para ver.<ul><li>Para crear una tarea para realizar un seguimiento de la información faltante, seleccione la casilla de verificación que se encuentra junto a ella. Cuando haya seleccionado todas las tareas deseadas y haya elegido una carpeta para agrupar estas nuevas tareas, haga clic en <b>#pgv_lang[ra_AddTask]#</b> para crear tareas para los elementos faltantes.</li><li>Las tareas existentes mostrarán <b>#pgv_lang[ra_view]#</b> en lugar de una casilla de verificación que, al hacer clic, lo llevará directamente a ver esa tarea.</li></ul>pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />La tabla que se muestra es una lista de tareas de investigación asociadas con el registro de esta persona. Solo se muestran las tareas que no están marcadas como completadas. Podrían haberse creado manualmente o generado mediante la tabla «#pgv_lang[ra_missing_info]#», pero cada tarea tiene asociada a esta persona.<br /><br />Haga clic en el título de la tarea para ver más detalles sobre ella. Haga clic en el botón <b>#pgv_lang[ra_task_entry]#</b> en la parte inferior de la tabla para crear manualmente una nueva tarea vinculada al registro de esta persona.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Esta es una lista de todas las tareas asociadas con esta fuente. Solo las tareas que no están asociadas con esta fuente. Cuando haya una tarea asociada, haga clic en el título de la tarea para iniciar la página «#pgv_lang[ra_view_task]#» y obtener más detalles al respecto.<br /><br /><b>Nota</b>: No se pueden crear nuevas tareas dentro de la entrada «#pgv_lang[ra_source]#». Utilice la función <b>#pgv_lang[ra_AddTask]#</b> si es necesario específicamente para una fuente que no está vinculada a una persona.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Esta tabla es una lista de tareas. Las columnas incluyen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Un título resumido para la tarea. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta es una descripción detallada de la tarea necesaria para la investigación o acciones de seguimiento. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Esta es la fecha de creación de la tarea. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Esto indica si una tarea está completada o no. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Esta entrada indica quién es el propietario de una tarea de investigación. Esta columna no se muestra en la vista «#pgv_lang[ra_my_tasks]#» ya que usted es el propietario de todas estas tareas.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Si usted es el propietario de esta tarea o tiene derechos de administración, esta entrada contiene un <u>enlace</u> que lo llevará a editar la tarea; de lo contrario, estará en blanco.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Si usted es el propietario de esta tarea o tiene derechos de administración, esta entrada contiene un <u>enlace</u> que lo llevará a eliminar la tarea; de lo contrario, aparecerá en blanco.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Si usted es el propietario de esta tarea o tiene derechos de administración, esta entrada contiene un <u>enlace</u> que lo llevará a cerrar inmediatamente una tarea si no está completa actualmente; de lo contrario, este campo estará en blanco. Esta columna solo se mostrará en la vista «#pgv_lang[ra_my_tasks]#» ya que usted es el propietario de todas estas tareas.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Esta tabla resume una tarea específica.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Este es el título de la tarea.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Esta es la carpeta en la que se agrupa la tarea.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Este es el investigador a quien está asignada actualmente la tarea.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta es la descripción detallada de la tarea necesaria para la investigación o las acciones para el seguimiento.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Cualquier fuente necesaria para la investigación o las acciones de seguimiento de la tarea.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Esta es una lista de personas del árbol genealógico que están asociadas con la tarea. Este campo puede contener varias entradas. Solo se muestran las personas del árbol genealógico.</li></ul><br />Si usted es el propietario asignado de la tarea o tiene derechos de administración, se presentará un botón y podrá hacer clic en <b>#pgv_lang[ra_edit_task]#</b> para editar los detalles de la tarea.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Los campos del formulario incluyen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Debe contener un breve resumen, normalmente de menos de 30 caracteres, de la tarea que está agregando.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Seleccione la carpeta en la que desea administrar su nueva tarea. Solo se muestran las carpetas existentes. Si desea asignar esta nueva tarea a una nueva carpeta, primero debe usar la función <b>#pgv_lang[ra_add_folder]#</b> del menú principal #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Seleccione de la lista de usuarios con permisos de edición a alguien que pueda poseer o actualizar la tarea y cualquier registro asociado a ella. En general, este campo nunca debe estar en blanco (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Introduzca una descripción detallada de la tarea que desea agregar.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Adjunte cualquier fuente que tenga para la tarea. Este campo puede contener varias entradas.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Seleccione a todas las personas asociadas con esta tarea. Este campo puede contener varias entradas, pero solo se pueden seleccionar y mostrar en este campo personas de su base de datos genealógica.</li></ul><br />Al crear una nueva tarea, se puede guardar haciendo clic en el botón <b>#pgv_lang[ra_submit]#</b>, que la mantendrá abierta y en el estado #pgv_lang[ra_incomplete]# para futuras actualizaciones. La tarea se puede guardar y marcar como #pgv_lang[ra_complete]# al mismo tiempo haciendo clic en el botón <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Los campos del formulario incluyen:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Esto debe contener el título o resumen de la tarea que está editando.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;En este campo puede seleccionar la carpeta en la que desea administrar su nueva tarea.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Ingrese una descripción detallada de la tarea que desea agregar.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Adjunte todas las fuentes que tenga para la tarea. Este campo puede contener varias entradas.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Seleccione todas las personas asociadas con esta tarea. Este campo puede contener varias entradas, pero solo se pueden seleccionar personas de su base de datos genealógica y mostrarlas en este campo.</li></ul><br />Después de modificar una tarea existente, se puede enviar para futuras actualizaciones haciendo clic en el botón <b>#pgv_lang[ra_save]#</b>. La tarea también se puede guardar y marcar como #pgv_lang[ra_completed]# (no se esperan futuras actualizaciones), haciendo clic en el botón <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Aquí se incluirán todos los comentarios relacionados con una tarea de investigación.<br /><br />Cuando se encuentran en la sección «#pgv_lang[ra_RA_name]#» de una persona, estos comentarios están vinculados al registro específico de esta persona y solo son visibles aquí. Si se muestra un comentario debajo de una tarea, ese comentario es específico de esa tarea. En cada caso, puede haber varios comentarios independientes. Cada uno puede editarse o eliminarse de forma independiente y el comentario más reciente siempre se muestra en la parte superior.<br /><br />Haga clic en <b>#pgv_lang[ra_add_new_comment]#</b> para agregar nuevos comentarios a esta lista.<br /><br /><span class='warning'>Si, mientras edita una tarea, agrega un nuevo comentario antes de guardar la tarea editada, se perderán todos los cambios no guardados.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Esta es una lista de carpetas y descripciones de su uso.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Esta columna contiene los nombres de todas las carpetas de este nivel que ha creado. Al seleccionar el nombre de la carpeta, accederá a una nueva pantalla que muestra todas las subcarpetas y todas las tareas asociadas con esta carpeta. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta columna contiene una descripción más detallada del uso de estas carpetas. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Esta columna tiene un <u>enlace</u> que permite editar el nombre, la descripción o la jerarquía de la carpeta.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Este formulario admite la creación de una nueva carpeta, su descripción de uso y la jerarquía de otras carpetas en las que encaja esta carpeta.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;El título resume el uso de la carpeta que está agregando.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Puede especificar si la carpeta está en el nivel más alto o raíz (#pgv_lang[ra_No_Parent]#) o como una subcarpeta de otra carpeta.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta es la descripción detallada de la carpeta que está agregando.</li></ul>Al hacer clic en el botón <b>#pgv_lang[ra_add]#</b> se enviará la información para crear una nueva carpeta. Al hacer clic en el botón <b>#pgv_lang[ra_reset]#</b> se descartarán los cambios realizados en el campo de descripción.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Este formulario permite editar una carpeta existente, su descripción de uso y la jerarquía de otras carpetas en las que encaja esta carpeta.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;El título resume el uso de la carpeta que está agregando.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Puede especificar si la carpeta está en el nivel más alto (#pgv_lang[ra_No_Parent]#) o como una subcarpeta de otra carpeta.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Esta es la descripción detallada de la carpeta que está agregando.</li></ul><br />El botón <b>#pgv_lang[ra_add]#</b> enviará la información para crear una nueva carpeta. El botón <b>#pgv_lang[ra_reset]#</b> descartará cualquier cambio en el campo de descripción realizado desde la última vez que se guardó. Cuando una carpeta está vacía, aparecerá el botón <b>#pgv_lang[ra_delete]#</b> para permitir la eliminación de esta carpeta de la jerarquía de carpetas; de lo contrario, se le advertirá que no se permite la eliminación si todavía hay tareas presentes en ella.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />En función de la persona elegida, esta función extraerá automáticamente información vital y datos de su base de datos genealógica y le permitirá determinar cuáles de ellos desea enviar al motor de búsqueda de un sitio web de genealogía externo. Se pueden elegir varios sitios, incluidos Ancestry, FamilySearch, Findagrave y más. Los resultados de estas búsquedas se pueden utilizar para agregar o actualizar información en su base de datos genealógica.<br /><br />Cuando se está en la sección «#pgv_lang[ra_RA_name]#» de la página «#pgv_lang[personal_facts]#» de una persona, la búsqueda se basará en esa persona. Si se inicia desde los menús principales #pgv_lang[ra_RA_name]#, primero se debe elegir a una persona haciendo clic en el ícono de persona para seleccionarla o ingresando el número de identificación de la persona en el campo.<br /><br />Seleccione de la lista el nombre del sitio de genealogía que desea consultar. Se le mostrará una lista de información que puede seleccionar. Indique mediante marcas de verificación junto a cada elemento (nombre, fecha de nacimiento o defunción, etc.) los elementos que se pasarán al motor de búsqueda elegido después de hacer clic en el botón <b>#pgv_lang[ra_autosearch_search]#</b>. El motor de búsqueda del sitio web externo se inicia en una nueva página. Utilice la función de gestión #pgv_lang[ra_task_list]# para identificar hallazgos adicionales para su seguimiento.<br /><br />Tenga en cuenta que los motores de búsqueda evolucionan constantemente, por lo que una vez en un sitio de genealogía, las capacidades nativas pueden ofrecer más criterios de búsqueda que pueden actualizarse para enriquecer su investigación.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Esta página analiza los datos de su base de datos genealógica y muestra las correlaciones entre los diferentes elementos de datos.<br /><br />Por ejemplo, podría haber una correlación del 95 % de que el apellido en un registro local es el mismo que el apellido en el registro del padre. Esto significaría que el 95 % de las personas en esta base de datos genealógica comparten el mismo apellido que su padre. En esta versión del módulo #pgv_lang[ra_RA_name]#, estos cálculos se utilizan para ayudar a identificar la información faltante en los registros de una persona. No se utilizan en otras áreas del programa; solo se proporcionan como una ayuda para su investigación.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Algunos programas genealógicos permiten introducir tareas de investigación como elementos TODO en su base de datos. Al exportar esta información genealógica a otros programas, estos exportarán los registros de la base de datos a un archivo con formato de acuerdo con la recomendación GEDCOM. El software PhpGedView utiliza el archivo con formato GEDCOM como entrada, por lo que estos elementos TODO se incorporan a sus datos. Esta opción buscará en su base de datos genealógica y convertirá automáticamente todos los elementos TODO importados en tareas de investigación.<br /><br />Al hacer clic en el botón <b>#pgv_lang[ra_generate]#</b> en la parte inferior del formulario, se creará una lista de tareas potenciales a partir de los elementos TODO importados. De esta lista, puede seleccionar elementos para generar tareas.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Marque cada tarea que desee generar y luego genere esa tarea.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Los primeros 30 caracteres de la descripción de la tarea se convertirán en el nombre de la tarea. Puede cambiar o corregir esto cuando edite la tarea.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;La descripción que se le dará a la tarea, copiada del texto completo del elemento TODO en su base de datos genealógica. Puede cambiar o corregir esto cuando edite la tarea.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Haga clic en el enlace para editar esa tarea.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Seleccione la carpeta en la que desea colocar las tareas generadas.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;lo redirecciona a la página #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Este formulario le permite editar las tareas que se crearon a partir de los elementos TODO en su base de datos genealógica.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Para seleccionar la persona con la que asociar la tarea.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Haga clic en el enlace para seleccionar la fuente con la que asociar la tarea.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Guarda todos los cambios y lo redirecciona a la página #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Descarta todos los cambios y lo redirecciona a la página #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Como administrador de su sitio PhpGedView, tiene la capacidad de controlar la visibilidad de las diferentes funcionalidades del módulo #pgv_lang[ra_RA_name]#. Este cuadro de diálogo presenta los bloques funcionales disponibles y le solicita que seleccione la visibilidad eligiendo los controles de acceso para cada uno.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;El bloque funcional especificado está disponible para todos.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;El bloque funcional especificado solo está disponible para usuarios autenticados.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;El bloque funcional especificado solo está disponible para usuarios con derechos de administrador.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;El bloque funcional especificado no está disponible para nadie.</li></ul></ul>";
?>
