<?php
/**
 * French language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.fr.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.fr.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Certains programmes vous permettent de saisir des tâches de recherche comme éléments TODO dans votre base de données généalogique. Cette option effectuera une recherche dans votre base de données généalogique et convertira automatiquement chaque élément TODO en tâche de recherche.";
$pgv_lang["ra_mytasks_block_descr"]		= "Le bloc «#pgv_lang[ra_my_tasks]#» affiche les tâches de l'utilisateur actuel. Il peut être configuré pour afficher les tâches terminées ou pour afficher les tâches qui ne sont pas actuellement attribuées.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Comment organiser les tâches~<br /><br />Les tâches sont organisées en dossiers. Au moins un dossier doit exister avant de pouvoir créer une tâche.<br /><br />Vous pouvez créer et organiser vos dossiers comme vous le souhaitez. Vous souhaiterez probablement organiser vos dossiers en ligne comme vous organisez les copies papier de vos recherches. De nombreux chercheurs organisent leurs dossiers par lignée familiale, nom de famille ou emplacement géographique.";
$pgv_lang["ra_whataretasks_words"]		= "~Quelles sont les tâches?~<br /><br />Le module #pgv_lang[ra_RA_name]# est centré sur la tâche de recherche. Une tâche de recherche est similaire à un élément TODO et suit une tâche de recherche généalogique particulière qui doit être effectuée. Un exemple de titre de tâche peut être «&nbsp;Trouver l'acte de naissance de Joe&nbsp;», tandis que les détails dans la description indiqueraient «&nbsp;Trouver l'acte de naissance de Joe dans les actes de naissance du comté d'Ottawa&nbsp;».<br /><br />Les tâches peuvent être attribuées à des utilisateurs spécifiques. En attribuant des tâches aux utilisateurs, chacun sait sur quelle recherche il doit travailler et qui travaille sur d'autres tâches de recherche.<br /><br />Les tâches peuvent également inclure des actions sur le matériel source ou liées à une ou plusieurs personnes dans vos données. Une fois le module #pgv_lang[ra_RA_name]# installé, vous verrez une section «#pgv_lang[ra_RA_name]#» sur chaque page «#pgv_lang[personal_facts]#» ainsi qu'une section Tâches sur chaque page de données sources.<br /><br />Les tâches sont créées dans l'état <b>#pgv_lang[ra_incomplete]#</b>, ce qui indique que le travail sur celles-ci est en cours. Toutes les tâches doivent être attribuées à un utilisateur qui peut modifier et mettre à jour les enregistrements avec les résultats. Une fois tout le travail effectué, la tâche doit être soumise sous l'état <b>#pgv_lang[ra_complete]#</b>. Cela la supprimera des listes de tâches activement visibles (c'est-à-dire #pgv_lang[ra_incomplete]#). En utilisant le menu «#pgv_lang[ra_my_tasks]#», chaque utilisateur peut voir les tâches qui lui sont attribuées, à la fois #pgv_lang[ra_incomplete]# et #pgv_lang[ra_complete]#.<br /><br />Chaque tâche dispose d'une section de commentaires où des discussions concernant les données et la recherche ou les résultats possibles peuvent avoir lieu. Cela permet à la tâche de rester orientée vers l'objectif tandis que les commentaires sont orientés vers la progression et les résultats.";
$pgv_lang["ra_sortcol_words"]		= "Cette colonne peut être triée en cliquant sur l'en-tête de la colonne.";
$pgv_lang["ra_folder_words"]			= "Les dossiers sont un outil de gestion des tâches qui permet de regrouper des tâches. Les dossiers peuvent être contenus dans d'autres dossiers. S'il existe un dossier parent, il sera affiché sur le côté gauche des menus ci-dessus. Si cette zone est vide, ces dossiers sont au niveau le plus élevé.";
$pgv_lang["ra_view_task_words"]		= "Les tâches sont des moyens de gérer les tâches de recherche à effectuer ou les actions de suivi. La tâche est résumée par son titre, tandis que le champ de description définit plus en détail ce qui est requis. Parfois, le suivi de la résolution peut également être inclus dans le champ de description. Sous le tableau «#pgv_lang[ra_Task_View]#» se trouve un tableau «#pgv_lang[ra_comments]#» qui peut être utilisé pour suivre la progression et pour décrire les résolutions de tâches.";
$pgv_lang["ra_special_char_words"]		= "Il peut arriver que votre texte doive comporter des symboles ayant une signification particulière pour le navigateur ou pour PhpGedView, autre que du texte ordinaire. Lorsque de tels symboles doivent apparaître dans votre texte, vous devez les saisir dans un format indiquant qu'il s'agit de texte sans signification particulière.<ul><li><b>&amp;</b>&nbsp;&nbsp;Ce symbole signale le début d'une entité HTML. Pour indiquer que ce symbole est du texte ordinaire, vous pouvez soit vous assurer qu'il est toujours suivi d'un espace, soit vous pouvez le saisir sous sa forme d'entité HTML <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Ce symbole est utilisé dans le système d'aide de PhpGedView. Pour indiquer que ce symbole est du texte ordinaire, vous pouvez soit vous assurer qu'il est toujours suivi d'un espace, soit vous pouvez le saisir sous sa forme numérique <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Ce symbole est utilisé dans le système d'aide de PhpGedView. Pour indiquer que ce symbole est du texte ordinaire, vous pouvez soit vous assurer qu'il est toujours suivi d'un espace, soit le saisir sous sa forme numérique <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Ce symbole est interprété par le navigateur comme signifiant que le symbole qui suit est du texte. Pour indiquer que ce symbole est du texte ordinaire, vous devez en saisir deux <b>&#92;&#92;</b> ou vous pouvez le saisir sous sa forme numérique <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Ce symbole est interprété par le navigateur pour indiquer le début d'une balise HTML. Pour indiquer que ce symbole est du texte ordinaire, vous devez le saisir dans sa forme d'entité HTML <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Ce symbole est interprété par le navigateur pour indiquer la fin d'une balise HTML. Pour indiquer que ce symbole est du texte ordinaire, vous devez le saisir dans sa forme d'entité HTML <b>&amp;gt;</b></li></ul>Vous pouvez créer des listes d'éléments dans une description. Si vous souhaitez créer des listes numérotées ou à puces, commencez la saisie de ces éléments de liste par <b>&lt;ul&gt;</b> pour une liste à puces ou par <b>&lt;ol&gt;</b> pour une liste numérotée.<br /><br />Chaque élément de liste doit commencer par <b>&lt;li&gt;</b> et se terminer par <b>&lt;/li&gt;</b>. Le dernier élément de la liste doit être terminé comme tous les autres et doit être suivi de <b>&lt;/ul&gt;</b> pour fermer la liste à puces ou de <b>&lt;/ol&gt;</b> pour fermer la liste numérotée.<br /><br />Les notes précédentes sur la saisie des symboles «Inférieur à» <b>&lt;</b> et «Supérieur à» <b>&gt;</b>, qui entourent généralement les balises HTML, sous forme de texte ne s'appliquent pas puisque dans ce cas, vous devez réellement saisir des balises HTML.";
$pgv_lang["ra_add_task_words"]		= "Avant de pouvoir créer une tâche, vous devez avoir créé un dossier pour la contenir.<br /><br />Les tâches sont des moyens de gérer les recherches à effectuer ou les actions à suivre. Ces tâches sont résumées par leur titre et utilisent les champs de description pour définir plus en détail ce qui est requis. Les tâches peuvent également contenir des documents sources à rechercher, qui peuvent être joints. Si une ou plusieurs personnes sont associées à cette tâche, elles doivent également être jointes à cette nouvelle tâche.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />La liste «#pgv_lang[ra_my_tasks]#» affiche les tâches de recherche pour l'utilisateur actuel. Par défaut, la liste des tâches affiche les tâches ouvertes ou incomplètes pour l'utilisateur actuel. Elle peut être configurée pour afficher en plus les tâches terminées et les tâches qui ne sont pas actuellement attribuées. Le tableau résultant peut ensuite être utilisé pour consulter rapidement les tâches de recherche à gérer.<ul><li>Lorsque vous cliquez sur un <b>#pgv_lang[ra_title]#</b>, vous serez redirigé vers une «#pgv_lang[ra_Task_View]#» pour plus de détails sur la tâche spécifique.</li><li>#pgv_lang[ra_Start_Date]# indique la date de création initiale de la tâche.</li><li>Lorsque vous cliquez sur <b>#pgv_lang[ra_edit]#</b> à la fin de la ligne de chaque tâche, vous serez redirigé vers la vue «#pgv_lang[ra_edit_task]#» de cette tâche spécifique pour la mettre à jour ou la terminer.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Cette zone affiche les informations potentiellement manquantes concernant le dossier d'une personne. Par exemple, il peut s'agir d'une source de naissance manquante ou du fait que la personne était en vie pendant un conflit militaire mais qu'il manque une entrée militaire. #pgv_lang[ra_RA_name]# inspectera le dossier de la base de données généalogique de la personne pour détecter d'éventuelles informations manquantes et produira une liste de tâches de suivi potentielles qui peuvent être créées.<br /><br />Avant de pouvoir créer des tâches manquantes, vous <u>devez</u> avoir créé un dossier pour contenir les tâches.<br /><br />Le tableau présente une liste de nouvelles tâches potentielles qui pourraient être créées ou de tâches précédemment générées à afficher.<ul><li>Pour créer une tâche pour suivre certaines informations manquantes, cochez la case à côté. Lorsque toutes les tâches souhaitées ont été sélectionnées et qu'un dossier pour regrouper ces nouvelles tâches a été choisi, cliquez <b>#pgv_lang[ra_AddTask]#</b> pour créer des tâches pour les éléments manquants.</li><li>Les tâches existantes afficheront <b>#pgv_lang[ra_view]#</b> au lieu d'une case à cocher qui, une fois cliquée, vous amènera directement à la visualisation de cette tâche.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Le tableau affiché est une liste de tâches de recherche associées au dossier de cette personne. Seules les tâches non marquées comme terminées sont affichées. Elles peuvent avoir été créées manuellement ou générées à l'aide du tableau «#pgv_lang[ra_missing_info]#», mais chaque tâche est associée à cette personne.<br /><br />Cliquez sur le titre de la tâche pour voir plus de détails à son sujet.</br>Cliquez le bouton <b>#pgv_lang[ra_task_entry]#</b> en bas du tableau pour créer manuellement une nouvelle tâche liée à l'enregistrement de cette personne.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Il s'agit d'une liste de toutes les tâches associées à cette source. Seules les tâches non marquées comme terminées sont affichées. Le message «&nbsp;#pgv_lang[ra_no_sour_tasks]#&nbsp;» apparaîtra lorsqu'aucune tâche n'est liée à cette source. Lorsqu'une tâche est associée, cliquez sur le titre de la tâche pour lancer la page «#pgv_lang[ra_view_task]#» pour plus de détails à son sujet.<br /><br /><b>Remarque</b>&nbsp;: Nouvelles tâches ne peuvent pas être créées dans l'entrée «#pgv_lang[ra_source]#». Utilisez la fonction <b>#pgv_lang[ra_AddTask]#</b> si nécessaire, spécifiquement pour une source qui n'est pas liée à une personne.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Ce tableau est une liste de tâches. Les colonnes comprennent&nbsp;:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Un titre récapitulatif pour la tâche. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Il s'agit d'une description détaillée de la tâche nécessaire à la recherche ou aux actions de suivi. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Il s'agit de la date de création de la tâche. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Cela indique si une tâche est terminée ou non. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Cette entrée indique à qui appartient une tâche de recherche. Cette colonne n'est pas affichée dans la vue «#pgv_lang[ra_my_tasks]#» car vous êtes le propriétaire de toutes ces tâches.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Si vous êtes le propriétaire de cette tâche ou si vous disposez de droits d'administrateur, cette entrée contient un <u>lien</u> qui vous permettra de modifier la tâche, sinon elle sera vide.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Si vous êtes le propriétaire de cette tâche ou si vous disposez de droits d'administrateur, cette entrée contient un <u>lien</u> qui vous permettra de supprimer la tâche, sinon elle sera vide.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Si vous êtes le propriétaire de cette tâche ou si vous disposez de droits d'administrateur, cette entrée contient un <u>lien</u> qui vous permettra de fermer immédiatement une tâche si elle n'est pas actuellement terminée, sinon ce champ sera vide. Cette colonne ne sera affichée que dans la vue «#pgv_lang[ra_my_tasks]#» car vous êtes le propriétaire de toutes ces tâches.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Ce tableau résume une tâche spécifique.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Il s'agit du titre de la tâche.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Il s'agit du dossier dans lequel la tâche est regroupée.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Il s'agit du chercheur à qui la tâche est actuellement attribuée.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Il s'agit de la description détaillée de la tâche nécessaire à la recherche ou aux actions de suivi.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Toutes les sources nécessaires à la recherche ou aux actions de suivi de la tâche.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Il s'agit d'une liste de personnes de l'arbre généalogique qui sont associées à la tâche. Ce champ peut contenir plusieurs entrées. Seules les personnes de l'arbre généalogique sont affichées.</li></ul><br />Si vous êtes le propriétaire désigné de la tâche ou si vous disposez de droits d'administration, un bouton sera présenté et vous pourrez cliquer <b>#pgv_lang[ra_edit_task]#</b> pour modifier les détails de la tâche.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Les champs du formulaire incluent&nbsp;:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Ce champ doit contenir un bref résumé, généralement de moins de 30 caractères, de la tâche que vous ajoutez.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Sélectionnez le dossier dans lequel vous souhaitez gérer votre nouvelle tâche. Seuls les dossiers existants sont affichés. Si vous souhaitez affecter cette nouvelle tâche à un nouveau dossier, vous devez d'abord utiliser la fonction <b>#pgv_lang[ra_add_folder]#</b> du menu principal #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Sélectionnez dans la liste des utilisateurs disposant des autorisations de modification une personne pouvant posséder ou mettre à jour la tâche et tous les enregistrements qui lui sont associés. En général, ce champ ne doit jamais être vide (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Entrez une description détaillée de la tâche que vous souhaitez ajouter.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Joignez toutes les sources dont vous disposez pour la tâche. Ce champ peut contenir plusieurs entrées.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Sélectionnez toutes les personnes associées à cette tâche. Ce champ peut contenir plusieurs entrées, mais seules les personnes de votre base de données généalogique peuvent être sélectionnées et affichées dans ce champ.</li></ul><br />Lors de la création d'une nouvelle tâche, vous pouvez l'enregistrer en cliquant le bouton <b>#pgv_lang[ra_submit]#</b>, ce qui la maintiendra ouverte et dans l'état #pgv_lang[ra_incomplete]# pour les mises à jour ultérieures. La tâche peut être enregistrée et marquée comme #pgv_lang[ra_complete]# en même temps en cliquant le bouton <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Les champs du formulaire incluent&nbsp;:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Ce champ doit contenir le titre ou le résumé de la tâche que vous modifiez.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Dans ce champ, vous pouvez sélectionner le dossier dans lequel vous souhaitez gérer votre nouvelle tâche.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Entrez une description détaillée de la tâche que vous souhaitez ajouter.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Joignez toutes les sources dont vous disposez pour la tâche. Ce champ peut contenir plusieurs entrées.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Sélectionnez toutes les personnes associées à cette tâche. Ce champ peut contenir plusieurs entrées, mais seules les personnes peuvent être sélectionnées dans votre base de données généalogique et affichées dans ce champ.</li></ul><br />Après avoir modifié une tâche existante, elle peut être soumise à des mises à jour ultérieures en cliquant <b>#pgv_lang[ra_save]#</b>. La tâche peut également être enregistrée et marquée comme #pgv_lang[ra_completed]# (aucune mise à jour future n'est prévue), en cliquant <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Ceci contiendra tous les commentaires liés à une tâche de recherche.<br /><br />Lorsque vous êtes dans la section «#pgv_lang[ra_RA_name]#» pour une personne, ces commentaires sont liés à l'enregistrement spécifique de cette personne et visibles uniquement ici. Si un commentaire est affiché sous une tâche, ce commentaire est spécifique à cette tâche. Dans chaque cas, il peut y avoir plusieurs commentaires indépendants. Chacun peut être modifié ou supprimé indépendamment, le commentaire le plus récent étant toujours affiché en haut.<br /><br />Cliquez <b>#pgv_lang[ra_add_new_comment]#</b> pour ajouter de nouveaux commentaires à cette liste.<br /><br /><span class='warning'>Si, lors de la modification d'une tâche, vous ajoutez un nouveau commentaire avant d'enregistrer votre tâche modifiée, toutes les modifications de tâche non enregistrées seront perdues.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Il s'agit d'une liste de dossiers et de descriptions de leur utilisation.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Cette colonne contient les noms de tous les dossiers de ce niveau que vous avez créés. En sélectionnant le nom du dossier, vous serez dirigé vers un nouvel affichage affichant tous les sous-dossiers et toutes les tâches associées à ce dossier. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Cette colonne contient une description plus détaillée de l'utilisation de ces dossiers. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Cette colonne contient un <u>lien</u> permettant de modifier le nom, la description ou la hiérarchie du dossier.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Ce formulaire prend en charge la création d'un nouveau dossier, sa description d'utilisation et la hiérarchie des autres dossiers dans lesquels ce dossier s'intègre.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Le titre résume l'utilisation du dossier que vous ajoutez.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Vous pouvez spécifier si le dossier est au niveau le plus élevé ou racine (#pgv_lang[ra_No_Parent]#) ou en tant que sous-dossier d'un autre dossier.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Il s'agit de la description détaillée du dossier que vous ajoutez.</li></ul>Cliquez <b>#pgv_lang[ra_add]#</b> pour envoyer les informations nécessaires à la création d'un nouveau dossier. Cliquez <b>#pgv_lang[ra_reset]#</b> pour annuler toutes les modifications apportées au champ de description.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Ce formulaire prend en charge l'édition d'un dossier existant, sa description d'utilisation et la hiérarchie des autres dossiers dans lesquels ce dossier s'intègre.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Le titre résume l'utilisation du dossier que vous ajoutez.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Vous pouvez spécifier si le dossier est au niveau le plus élevé (#pgv_lang[ra_No_Parent]#) ou en tant que sous-dossier d'un autre dossier.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Il s'agit de la description détaillée du dossier que vous ajoutez.</li></ul><br />Le bouton <b>#pgv_lang[ra_add]#</b> soumettra les informations pour créer un nouveau dossier. Le bouton <b>#pgv_lang[ra_reset]#</b> annulera toutes les modifications apportées au champ de description depuis le dernier enregistrement. Lorsqu'un dossier est vide, le bouton <b>#pgv_lang[ra_delete]#</b> apparaîtra pour permettre de supprimer ce dossier de la hiérarchie des dossiers, sinon vous serez averti que la suppression n'est pas autorisée si des tâches y sont encore présentes.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />En fonction de la personne choisie, cette fonction extrait automatiquement diverses informations vitales et factuelles de votre base de données généalogique et vous permet de déterminer lesquelles d'entre elles doivent être transmises au moteur de recherche d'un site Web de généalogie externe. Différents sites peuvent être choisis, notamment Ancestry, FamilySearch, Findagrave et bien d'autres. Les résultats de ces recherches peuvent être utilisés pour ajouter ou mettre à jour des informations dans votre base de données généalogique.<br /><br />Lorsque vous vous trouvez dans la section «#pgv_lang[ra_RA_name]#» de la page «#pgv_lang[personal_facts]#» d'une personne, la recherche sera basée sur cette personne. Si elle est lancée à partir des menus principaux #pgv_lang[ra_RA_name]#, une personne doit d'abord être choisie en cliquant sur l'icône de la personne pour sélectionner une personne ou en saisissant numéro d'identification de la personne dans le champ.<br /><br />Choisissez dans la liste le nom du site de généalogie que vous souhaitez interroger. Une liste d'informations pouvant être sélectionnées s'affiche. Indiquez par des coches à côté de chaque élément (nom, date de naissance ou de décès, etc.) les éléments qui seront transmis au moteur de recherche choisi après avoir cliqué le bouton <b>#pgv_lang[ra_autosearch_search]#</b>. Le moteur de recherche du site externe est lancé dans une nouvelle page. Utilisez la fonction de gestion #pgv_lang[ra_task_list]# pour identifier des résultats supplémentaires à suivre.<br /><br />Veuillez noter que les moteurs de recherche évoluent constamment, donc une fois sur un site de généalogie, les capacités natives peuvent offrir davantage de critères de recherche qui peuvent être mis à jour pour enrichir vos recherches.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Cette page analyse les données de votre base de données généalogique et montre les corrélations entre les différents éléments de données.<br /><br />Par exemple, il pourrait y avoir une corrélation de 95 % entre le nom de famille dans un registre local et le nom de famille dans le registre du père. Cela signifierait que 95 % des personnes de cette base de données généalogique partagent le même nom de famille que leur père. Dans cette version du module #pgv_lang[ra_RA_name]#, ces calculs sont utilisés pour aider à identifier les informations manquantes dans les registres d'une personne. Ils ne sont pas utilisés dans d'autres domaines du programme. Ils sont uniquement fournis pour vous aider dans vos recherches.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Certains programmes généalogiques vous permettent de saisir des tâches de recherche comme éléments TODO dans leur base de données. Lorsque vous exportez ces informations généalogiques vers d'autres programmes, ils exportent les enregistrements de la base de données dans un fichier formaté selon la recommandation GEDCOM. Le logiciel PhpGedView utilise le fichier formaté GEDCOM comme entrée, de sorte que ces éléments TODO sont intégrés dans vos données. Cette option recherchera dans votre base de données généalogique et convertira automatiquement tous les éléments TODO importés en tâches de recherche.<br /><br />Cliquez le bouton <b>#pgv_lang[ra_generate]#</b> en bas du formulaire pour créer une liste de tâches potentielles à partir des éléments TODO importés. À partir de cette liste, vous pouvez sélectionner les éléments pour générer des tâches.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Marquez chaque tâche à générer, puis générez cette tâche.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Les 30 premiers caractères de la description de la tâche deviendront le nom de la tâche. Vous pouvez modifier ou corriger cela lorsque vous modifiez la tâche.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;La description de la tâche sera copiée à partir du texte complet de l'élément TODO dans votre base de données généalogique. Vous pouvez la modifier ou la corriger lorsque vous éditez la tâche.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Cliquez sur le lien pour éditer cette tâche.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Sélectionnez le dossier dans lequel placer les tâches générées.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;vous redirige vers la page #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Ce formulaire vous permet de modifier les tâches qui ont été créées à partir d'éléments TODO dans votre base de données généalogique.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Pour sélectionner la personne à laquelle associer la tâche.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Cliquez sur le lien pour sélectionner la source à laquelle associer la tâche.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Enregistre toutes vos modifications et vous redirige vers la page #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Annule toutes vos modifications et vous redirige vers la page #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />En tant qu'administrateur de votre site PhpGedView, vous avez la possibilité de contrôler la visibilité des différentes fonctionnalités du module #pgv_lang[ra_RA_name]#. Cette boîte de dialogue présente les blocs fonctionnels disponibles et vous demande de sélectionner la visibilité en choisissant des contrôles d'accès pour chacun.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Le bloc fonctionnel spécifié est accessible à tous.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Le bloc fonctionnel spécifié est disponible uniquement pour les utilisateurs disposant de droits d'administrateur.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Le bloc fonctionnel spécifié n'est accessible à personne.</li></ul></ul>";
?>
