<?php
/**
 * Italian language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.it.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.it.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Alcuni programmi consentono di inserire attività di ricerca come elementi TODO nel database genealogico. Questa opzione eseguirà una ricerca nel database genealogico e convertirà automaticamente ogni elemento TODO in un'attività di ricerca.";
$pgv_lang["ra_mytasks_block_descr"]		= "Il blocco «#pgv_lang[ra_my_tasks]#» mostra le attività per l'utente corrente. Può essere configurato per mostrare le attività completate o per mostrare le attività che al momento non sono assegnate.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Come organizzare le attività~<br /><br />Le attività sono organizzate in cartelle. Deve esistere almeno una cartella prima che qualsiasi attività possa essere creata.<br /><br />Puoi creare e organizzare le tue cartelle come preferisci. Probabilmente vorrai organizzare le tue cartelle online come organizzi le copie cartacee della tua ricerca. Molti ricercatori organizzano le loro cartelle per linea di famiglia, cognome o posizione geografica.";
$pgv_lang["ra_whataretasks_words"]		= "~Cosa sono i task?~<br /><br />Il modulo #pgv_lang[ra_RA_name]# è incentrato sul Task di ricerca. Un Task di ricerca è simile a un elemento TODO e tiene traccia di un particolare incarico di ricerca genealogica che deve essere svolto. Un titolo di esempio del task potrebbe essere «Trova il certificato di nascita di Joe», mentre i dettagli nella descrizione indicherebbero «Trova il certificato di nascita di Joe nei registri di nascita della contea di Ottawa».<br /><br />I task possono essere assegnati a utenti specifici. Assegnando i task agli utenti, tutti sanno a quale ricerca dovrebbero lavorare e chi sta lavorando ad altri task di ricerca.<br /><br />Le attività possono anche includere azioni contro il materiale sorgente o relative a una o più persone nei tuoi dati. Con il modulo #pgv_lang[ra_RA_name]# installato, vedrai una sezione «#pgv_lang[ra_RA_name]#» su ogni pagina «#pgv_lang[personal_facts]#» e anche una sezione Attività su ogni pagina dei dati sorgente.<br /><br />Le attività vengono create nello stato <b>#pgv_lang[ra_incomplete]#</b>, a indicare che il lavoro è in corso. Tutte le attività devono essere assegnate a un utente che può modificare e aggiornare i record con i risultati. Una volta completato tutto il lavoro, l'attività deve essere inviata come <b>#pgv_lang[ra_complete]#</b>. Ciò la rimuoverà dagli elenchi delle attività visibili attivamente (ad es. #pgv_lang[ra_incomplete]#). Utilizzando il menu «#pgv_lang[ra_my_tasks]#», ogni utente può vedere le attività assegnate, sia #pgv_lang[ra_incomplete]# che #pgv_lang[ra_complete]#.<br /><br />Ogni attività ha una sezione commenti in cui possono avvenire discussioni riguardanti i dati e la ricerca o i possibili risultati. Ciò consente all'attività di rimanere orientata all'obiettivo mentre i commenti sono orientati ai progressi e ai risultati.";
$pgv_lang["ra_sortcol_words"]		= "Questa colonna può essere ordinata cliccando sull'intestazione della colonna.";
$pgv_lang["ra_folder_words"]			= "Le cartelle sono uno strumento di gestione delle attività che consente di raggruppare le attività insieme. Le cartelle possono essere contenute in altre cartelle. Se c'è una cartella padre, questa verrà visualizzata sul lato sinistro dei menu in alto. Se quell'area è vuota, queste cartelle si trovano al livello più alto.";
$pgv_lang["ra_view_task_words"]		= "I task sono modi per gestire le attività di ricerca o le azioni di follow-up. Il task è riassunto dal suo titolo, mentre il campo descrizione definisce maggiori dettagli su ciò che è richiesto. A volte il follow-up per la risoluzione può anche essere incluso nel campo descrizione. Sotto la tabella «#pgv_lang[ra_Task_View]#» c'è una tabella «#pgv_lang[ra_comments]#» che può essere utilizzata per tracciare i progressi e per descrivere le risoluzioni dei task.";
$pgv_lang["ra_special_char_words"]		= "A volte, il testo potrebbe dover mostrare simboli che hanno significati speciali per il browser o per PhpGedView, oltre a essere testo ordinario. Quando tali simboli devono comparire nel testo, è necessario immetterli in un formato che indichi che si tratta di testo senza significato speciale.<ul><li><b>&amp;</b>&nbsp;&nbsp;Questo simbolo segnala l'inizio di un'entità HTML. Per indicare che questo simbolo è un testo ordinario, puoi assicurarti che sia sempre seguito da uno spazio oppure puoi immetterlo nella sua forma di entità HTML <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Questo simbolo è utilizzato nel sistema di aiuto di PhpGedView. Per indicare che questo simbolo è un testo ordinario, puoi assicurarti che sia sempre seguito da uno spazio oppure puoi immetterlo nella sua forma numerica <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Questo simbolo è utilizzato nel sistema di aiuto di PhpGedView. Per indicare che questo simbolo è un testo ordinario, puoi assicurarti che sia sempre seguito da uno spazio oppure puoi immetterlo nella sua forma numerica <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Questo simbolo viene interpretato dal browser per indicare che il simbolo che segue è testo. Per indicare che questo simbolo è testo ordinario, devi immetterne due <b>&#92;&#92;</b> oppure puoi immetterlo nella sua forma numerica <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Questo simbolo viene interpretato dal browser per indicare l'inizio di un tag HTML. Per indicare che questo simbolo è testo ordinario, devi immetterlo nella sua forma Entità HTML <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Questo simbolo viene interpretato dal browser per indicare la fine di un tag HTML. Per indicare che questo simbolo è testo ordinario, devi immetterlo nella sua forma Entità HTML <b>&amp;gt;</b></li></ul>Puoi creare elenchi di elementi in una descrizione. Se vuoi creare elenchi numerati o puntati, inizia l'inserimento di questi elementi di elenco con <b>&lt;ul&gt;</b> per un elenco puntato o <b>&lt;ol&gt;</b> per un elenco numerato.<br /><br />Ogni elemento di elenco dovrebbe iniziare con <b>&lt;li&gt;</b> e terminare con <b>&lt;/li&gt;</b>. L'ultimo elemento di elenco dovrebbe terminare come tutti gli altri e dovrebbe essere seguito da <b>&lt;/ul&gt;</b> per chiudere l'elenco puntato o <b>&lt;/ol&gt;</b> per chiudere l'elenco numerato.<br /><br />Le note precedenti sull'inserimento dei simboli «Minore di» <b>&lt;</b> e «Maggiore di» <b>&gt;</b>, che solitamente racchiudono i tag HTML, come testo non sono valide, poiché in questo caso è effettivamente necessario inserire i tag HTML.";
$pgv_lang["ra_add_task_words"]		= "Prima di poter creare qualsiasi task, <u>devi</u> aver creato una cartella per contenere tale task.<br /><br />I task sono modi per gestire le ricerche da fare o le azioni di follow-up. Questi task sono riepilogati dai loro titoli e utilizzano i campi di descrizione per definire in modo più dettagliato cosa è richiesto. I task possono anche avere del materiale di origine da ricercare in modo che possa essere allegato e, se ci sono una o più persone a cui questo task è associato, dovrebbero anche essere allegati a questo nuovo task.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />L'elenco «#pgv_lang[ra_my_tasks]#» mostra le attività di ricerca per l'utente corrente. Per impostazione predefinita, l'elenco delle attività mostra le attività aperte o incomplete per l'utente corrente. Questo può essere configurato per mostrare anche le attività completate e per mostrare le attività che al momento non sono assegnate. La tabella risultante può quindi essere utilizzata per esaminare rapidamente le attività di ricerca da gestire.<ul><li>Quando fai clic su <b>#pgv_lang[ra_title]#</b> verrai indirizzato a «#pgv_lang[ra_Task_View]#» per maggiori dettagli sull'attività specifica.</li><li>#pgv_lang[ra_Start_Date]# indica quando l'attività è stata creata originariamente.</li><li>Quando fai clic su <b>#pgv_lang[ra_edit]#</b> alla fine di ogni riga di attività, verrai indirizzato alla vista «#pgv_lang[ra_edit_task]#» per quell'attività specifica per aggiornarla o completarla.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Quest'area mostra potenziali informazioni mancanti sul record di una persona. Ad esempio, questo potrebbe includere una fonte di nascita mancante o il fatto che la persona era in vita durante un conflitto militare ma manca una voce militare. #pgv_lang[ra_RA_name]# ispezionerà il record del database genealogico della persona per possibili informazioni mancanti e produrrà un elenco di potenziali attività di follow-up che possono essere create.<br /><br />Prima di poter creare attività mancanti, è necessario aver creato una cartella in cui inserirle.<br /><br />La tabella presenta un elenco di potenziali nuove attività che potrebbero essere create o di attività generate in precedenza da visualizzare.<ul><li>Per creare un'attività per tracciare alcune informazioni mancanti, seleziona la casella di controllo accanto ad essa. Quando tutte le attività desiderate sono state selezionate e una cartella per raggruppare queste nuove attività è stata scelta, fai clic su <b>#pgv_lang[ra_AddTask]#</b> per creare attività per gli elementi mancanti.</li><li>Le attività esistenti mostreranno <b>#pgv_lang[ra_view]#</b> invece di una casella di controllo che, se cliccata, ti porterà direttamente a visualizzare quell'attività.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />La tabella mostrata è un elenco di attività di ricerca associate al record di questa persona. Vengono mostrate solo le attività non contrassegnate come completate. Potrebbero essere state create manualmente o generate utilizzando la tabella «#pgv_lang[ra_missing_info]#», ma ogni attività ha questa persona associata.<br /><br />Fai clic sul titolo dell'attività per visualizzare ulteriori dettagli.</br>Fai clic sul pulsante <b>#pgv_lang[ra_task_entry]#</b> in fondo alla tabella per creare manualmente una nuova attività collegata al record di questa persona.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Questo è un elenco di tutte le attività associate a questa fonte. Vengono mostrate solo le attività non contrassegnate come completate. Il messaggio «#pgv_lang[ra_no_sour_tasks]#» apparirà quando nessuna attività ha questa fonte collegata. Quando c'è un'attività associata, clicca sul titolo dell'attività per avviare la pagina «#pgv_lang[ra_view_task]#» per ulteriori dettagli al riguardo.<br /><br /><b>Nota</b>: non è possibile creare nuove attività all'interno della voce «#pgv_lang[ra_source]#». Utilizzare la funzione <b>#pgv_lang[ra_AddTask]#</b> se necessario specificamente per una fonte che non è collegata a una persona.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Questa tabella è un elenco di attività. Le colonne includono:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Un titolo riassuntivo per l'attività. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Questa è una descrizione dettagliata dell'attività necessaria per la ricerca o le azioni di follow-up. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Questa è la data di creazione dell'attività. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Indica se un'attività è stata completata o meno. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Questa voce indica chi possiede un'attività di ricerca. Questa colonna non viene mostrata nella vista «#pgv_lang[ra_my_tasks]#» perché sei il proprietario di tutte queste attività.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Se sei il proprietario di questa attività o hai diritti di amministrazione, questa voce contiene un <u>link</u> che ti porterà a modificare l'attività, altrimenti sarà vuota.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Se sei il proprietario di questa attività o hai diritti di amministrazione, questa voce contiene un <u>link</u> che ti porterà a eliminare l'attività, altrimenti sarà vuoto.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Se sei il proprietario di questa attività o hai diritti di amministrazione, questa voce contiene un <u>link</u> che ti porterà a chiudere immediatamente un'attività se non è attualmente completata, altrimenti questo campo sarà vuoto. Questa colonna verrà mostrata solo nella vista «#pgv_lang[ra_my_tasks]#» perché sei il proprietario di tutte queste attività.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Questa tabella riassume un'attività specifica.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Questo è il titolo dell'attività.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Questa è la cartella in cui è raggruppata l'attività.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Questo è il ricercatore a cui è attualmente assegnata l'attività.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Questa è la descrizione dettagliata dell'attività necessaria per la ricerca o le azioni di follow-up.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Eventuali fonti necessarie per la ricerca o azioni di follow-up per l'attività.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Questo è un elenco di persone dall'albero genealogico che sono associate all'attività. Questo campo può contenere più voci. Vengono mostrate solo le persone nell'albero genealogico.</li></ul><br />Se sei il proprietario assegnato dell'attività o hai diritti di amministrazione, verrà visualizzato un pulsante e puoi fare clic su <b>#pgv_lang[ra_edit_task]#</b> per modificare i dettagli dell'attività.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />I campi del modulo includono:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Questo dovrebbe contenere un breve riepilogo, in genere lungo meno di 30 caratteri, dell'attività che stai aggiungendo.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Seleziona la cartella in cui desideri gestire la tua nuova attività. Vengono visualizzate solo le cartelle esistenti. Se desideri assegnare questa nuova attività a una nuova cartella, devi prima utilizzare la funzione <b>#pgv_lang[ra_add_folder]#</b> dal menu principale #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Seleziona dall'elenco degli utenti con autorizzazioni di modifica qualcuno che può possedere o aggiornare l'attività e tutti i record ad essa associati. In generale, questo campo non dovrebbe mai essere vuoto (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Inserisci una descrizione dettagliata dell'attività che desideri aggiungere.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Allega tutte le fonti che hai per l'attività. Questo campo può contenere più voci.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Seleziona tutte le persone associate alla nuova attività. Questo campo può contenere più voci, ma solo le persone nel tuo database genealogico sono selezionabili e possono essere mostrate in questo campo.</li></ul><br />Quando si crea un nuovo task, è possibile salvarlo cliccando sul pulsante <b>#pgv_lang[ra_submit]#</b>, che lo manterrà aperto e nello stato #pgv_lang[ra_incomplete]# per ulteriori aggiornamenti. Il task può essere salvato e contrassegnato come #pgv_lang[ra_complete]# contemporaneamente cliccando sul pulsante <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />I campi del modulo includono:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dovrebbe contenere il titolo o il riepilogo dell'attività che stai modificando.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;In questo campo puoi selezionare la cartella in cui desideri gestire la tua nuova attività.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Inserisci una descrizione dettagliata dell'attività che desideri aggiungere.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Allega tutte le fonti che hai per l'attività. Questo campo può contenere più voci.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Seleziona tutte le persone associate a questa attività. Questo campo può contenere più voci, ma solo le persone del tuo database genealogico possono essere selezionate e mostrate in questo campo.</li></ul><br />Dopo aver modificato un'attività esistente, è possibile inviarla per aggiornamenti futuri cliccando sul pulsante <b>#pgv_lang[ra_save]#</b>. L'attività può anche essere salvata e contrassegnata come #pgv_lang[ra_completed]# (non sono previsti aggiornamenti futuri), cliccando sul pulsante <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Questo conterrà tutti i commenti relativi a un'attività di ricerca.<br /><br />Quando ci si trova nella sezione «#pgv_lang[ra_RA_name]#» per una persona, questi commenti sono collegati al record specifico di questa persona e visibili solo qui. Se un commento viene mostrato sotto un'attività, quel commento è specifico per quell'attività. In ogni caso possono esserci più commenti indipendenti. Ognuno può essere modificato o eliminato in modo indipendente con il commento più recente sempre visualizzato in alto.<br /><br />Fai clic su <b>#pgv_lang[ra_add_new_comment]#</b> per aggiungere nuovi commenti a questo elenco.<br /><br /><span class='warning'>Se durante la modifica di un'attività aggiungi un nuovo commento prima di salvare l'attività modificata, tutte le modifiche non salvate andranno perse.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Questo è un elenco di cartelle e descrizioni del loro utilizzo.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Questa colonna contiene i nomi di tutte le cartelle a questo livello che hai creato. Selezionando il nome della cartella, verrai indirizzato a una nuova visualizzazione che mostra tutte le sottocartelle e tutte le attività associate a questa cartella. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Questa colonna contiene una descrizione più dettagliata dell'utilizzo di queste cartelle. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Questa colonna ha un <u>link</u> per consentire la modifica del nome, della descrizione o della gerarchia della cartella.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Questo modulo supporta la creazione di una nuova cartella, la descrizione del suo utilizzo e la gerarchia delle altre cartelle in cui si inserisce questa cartella.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Il titolo riassume l'utilizzo della cartella che stai aggiungendo.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;È possibile specificare se la cartella si trova al livello più alto o radice (#pgv_lang[ra_No_Parent]#) oppure come sottocartella di un'altra cartella.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Questa è la descrizione dettagliata della cartella che stai aggiungendo.</li></ul>Cliccando sul pulsante <b>#pgv_lang[ra_add]#</b> verranno inviate le informazioni per creare una nuova cartella. Cliccando sul pulsante <b>#pgv_lang[ra_reset]#</b> verranno ignorate tutte le modifiche al campo descrizione.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Questo modulo supporta la modifica di una cartella esistente, la sua descrizione di utilizzo e la gerarchia delle altre cartelle in cui si inserisce questa cartella.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Il titolo riassume l'utilizzo della cartella che stai aggiungendo.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Puoi specificare se la cartella si trova al livello più alto (#pgv_lang[ra_No_Parent]#) o come sottocartella di un'altra cartella.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Questa è la descrizione dettagliata della cartella che stai aggiungendo.</li></ul><br />Il pulsante <b>#pgv_lang[ra_add]#</b> invierà le informazioni per creare una nuova cartella. Il pulsante <b>#pgv_lang[ra_reset]#</b> eliminerà tutte le modifiche apportate al campo descrizione dall'ultimo salvataggio. Quando una cartella è vuota, apparirà il pulsante <b>#pgv_lang[ra_delete]#</b> per consentire la rimozione di questa cartella dalla gerarchia delle cartelle, altrimenti verrai avvisato che l'eliminazione non è consentita con le attività ancora presenti in essa.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />In base alla persona scelta, questa funzione estrarrà automaticamente varie informazioni vitali e fattuali dal tuo database genealogico e ti consentirà di determinare quali di queste passare al motore di ricerca di un sito web di genealogia esterno. È possibile scegliere vari siti, tra cui Ancestry, FamilySearch, Findagrave e altri. I risultati di queste ricerche possono essere utilizzati per aggiungere o aggiornare le informazioni nel tuo database genealogico.<br /><br />Quando ci si trova nella sezione «#pgv_lang[ra_RA_name]#» della pagina «#pgv_lang[personal_facts]#» di una persona, la ricerca si baserà su quella persona. Se avviata dai menu principali #pgv_lang[ra_RA_name]#, una persona deve essere prima scelta cliccando sull'icona della persona per selezionarla o inserendo il numero di identificazione della persona nel campo.<br /><br />Scegli dall'elenco il nome del sito genealogico che desideri interrogare. Ti verrà mostrato un elenco di informazioni che possono essere selezionate. Indica con dei segni di spunta accanto a ogni elemento (nome, data di nascita o morte, ecc.) gli elementi che saranno passati al motore di ricerca scelto dopo che è stato cliccato il pulsante <b>#pgv_lang[ra_autosearch_search]#</b>. Il motore di ricerca del sito web esterno viene avviato in una nuova pagina. Utilizza la funzione di gestione #pgv_lang[ra_task_list]# per identificare ulteriori risultati da seguire.<br /><br />Tieni presente che i motori di ricerca sono in continua evoluzione, quindi una volta su un sito di genealogia, le funzionalità native potrebbero offrire più criteri di ricerca che possono essere aggiornati per arricchire la tua ricerca.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Questa pagina analizza i dati presenti nel tuo database genealogico e mostra le correlazioni tra diversi elementi di dati.<br /><br />Ad esempio, potrebbe esserci una correlazione del 95% che il cognome in un record locale sia lo stesso del cognome nel record del padre. Ciò significherebbe che il 95% delle persone in questo database genealogico condividono lo stesso cognome del padre. In questa versione del modulo #pgv_lang[ra_RA_name]#, questi calcoli vengono utilizzati per aiutare a identificare le informazioni mancanti nei record di una persona. Non vengono utilizzati in altre aree del programma; vengono forniti solo come aiuto per la tua ricerca.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Alcuni programmi genealogici consentono di inserire attività di ricerca come elementi TODO nel loro database. Quando si esportano queste informazioni genealogiche in altri programmi, questi esporteranno i record del database in un file formattato secondo la raccomandazione GEDCOM. Il software PhpGedView utilizza il file formattato GEDCOM come input, quindi questi elementi TODO sono incorporati nei tuoi dati. Questa opzione cercherà nel tuo database genealogico e convertirà automaticamente tutti gli elementi TODO importati in attività di ricerca.<br /><br />Cliccando sul pulsante <b>#pgv_lang[ra_generate]#</b> in fondo al modulo verrà creato un elenco di potenziali attività dagli elementi TODO importati. Da questo elenco puoi selezionare gli elementi per generare attività.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Contrassegna ogni task da generare e poi genera quel task.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;I primi 30 caratteri della descrizione del task diventeranno il nome del task. Puoi cambiarlo o correggerlo quando modifichi il task.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;La descrizione del task verrà fornita, copiata dal testo completo dell'elemento TODO nel tuo database genealogico. Puoi cambiare o correggere questo quando modifichi l'attività.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Fai clic sul collegamento per modificare l'attività.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Seleziona la cartella in cui inserire le attività generate.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;ti reindirizza alla pagina #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Questo modulo consente di modificare le attività create dagli elementi TODO nel database genealogico.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Per selezionare la persona a cui associare l'attività.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Clicca sul collegamento per selezionare la fonte a cui associare l'attività.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Salva tutte le modifiche e ti reindirizza alla pagina #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Ignora tutte le modifiche e ti reindirizza alla pagina #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Come amministratore del tuo sito PhpGedView, hai la possibilità di controllare la visibilità di diverse funzionalità del modulo #pgv_lang[ra_RA_name]#. Questa finestra di dialogo presenta i blocchi funzionali disponibili e ti chiede di selezionare la visibilità scegliendo i controlli di accesso per ciascuno.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Il blocco funzionale specificato è disponibile a tutti.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Il blocco funzionale specificato è disponibile solo per gli utenti autenticati.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Il blocco funzionale specificato è disponibile solo per gli utenti con diritti di amministratore.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Il blocco funzionale specificato non è disponibile per nessuno.</li></ul></ul>";
?>
