<?php
/**
 * Norwegian language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.no.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.no.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Noen programmer lar deg legge inn forskningsoppgaver som TODO-elementer i din genealogiske database. Dette alternativet vil søke gjennom din genealogiske database og automatisk konvertere hvert TODO-element til en forskningsoppgave.";
$pgv_lang["ra_mytasks_block_descr"]		= "«#pgv_lang[ra_my_tasks]#» blokken viser oppgaver for gjeldende bruker. Den kan konfigureres til å vise fullførte oppgaver eller til å vise oppgaver som for øyeblikket ikke er tildelt.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Hvordan organisere oppgaver~<br /><br />Oppgaver er organisert i mapper. Minst én mappe må eksistere før noen oppgaver kan opprettes.<br /><br />Du kan opprette og organisere mappene dine slik du vil. Du vil sannsynligvis organisere online-mappene dine slik du organiserer papirkopier av forskningen din. Mange forskere organiserer mappene sine etter familielinje, etternavn eller geografiske steder.";
$pgv_lang["ra_whataretasks_words"]		= "~Hva er oppgaver?~<br /><br />#pgv_lang[ra_RA_name]# modulen er sentrert om forskningsoppgaven. En forskningsoppgave ligner på et TODO-element og sporer en bestemt slektsforskningsoppgave som må gjøres. Et eksempel på en oppgavetittel kan være «Finn Joes fødselsregister», mens spesifikasjonene i beskrivelsen vil indikere «Finn Joes fødselsregister i Ottawa-fylkets fødselsregister».<br /><br />Oppgaver kan tildeles spesifikke brukere. Ved å tildele oppgaver til brukere vet alle hvilken forskning de skal jobbe med, og hvem som jobber med andre forskningsoppgaver.<br /><br />Oppgaver kan også omfatte handlinger mot kildemateriale eller relatert til en eller flere personer i dataene dine. Med #pgv_lang[ra_RA_name]#» modulen installert, vil du se en «#pgv_lang[ra_RA_name]#» seksjon på hver «#pgv_lang[personal_facts]#» side og også en Oppgave-seksjon på hver kildedataside.<br /><br />Oppgaver opprettes i tilstanden <b>#pgv_lang[ra_incomplete]#</b>, noe som indikerer at arbeidet med det pågår. Alle oppgaver bør tildeles en bruker som kan redigere og oppdatere postene med funnene. Når alt arbeidet er gjort, skal oppgaven sendes inn som <b>#pgv_lang[ra_complete]#</b>. Dette vil fjerne det fra de aktivt synlige (dvs. #pgv_lang[ra_incomplete]#) oppgavelistene. Ved å bruke «#pgv_lang[ra_my_tasks]#» menyen kan hver bruker se sine tildelte oppgaver, både #pgv_lang[ra_incomplete]# og #pgv_lang[ra_complete]#.<br /><br />Hver oppgave har en kommentarseksjon der diskusjoner angående data og forskning eller mulige utfall kan forekomme. Dette gjør at oppgaven kan forbli målrettet mens kommentarene er fremdrifts- og resultatorienterte.";
$pgv_lang["ra_sortcol_words"]		= "Denne kolonnen kan sorteres ved å klikke på kolonneoverskriften.";
$pgv_lang["ra_folder_words"]			= "Mapper er et oppgavestyringsverktøy som tillater gruppering av oppgaver sammen. Mapper kan være inneholdt i andre mapper. Hvis det er en overordnet mappe vil den vises på venstre side av menyene ovenfor. Hvis dette området er tomt, er disse mappene på det øverste nivået.";
$pgv_lang["ra_view_task_words"]		= "Oppgaver er måter å administrere forskningsoppgaver eller handlinger for oppfølging. Oppgaven er oppsummert med tittelen, mens beskrivelsesfeltet definerer mer detaljer om hva som kreves. Noen ganger kan også oppfølgingen av vedtaket inkluderes i beskrivelsesfeltet. Under «#pgv_lang[ra_Task_View]#» tabellen er det en «#pgv_lang[ra_comments]#» tabell som kan brukes til å spore fremdrift og for å beskrive oppgaveløsninger.";
$pgv_lang["ra_special_char_words"]		= "Noen ganger kan det hende at teksten din må vise symboler som har spesiell betydning for nettleseren eller for PhpGedView, annet enn å være vanlig tekst. Når slike symboler må forekomme i teksten din, må du skrive dem inn i et format som indikerer at det er tekst uten spesiell betydning.<ul><li><b>&amp;</b>&nbsp;&nbsp;Dette symbolet signaliserer starten på en HTML-enhet. For å indikere at dette symbolet er vanlig tekst, kan du enten sørge for at det alltid følges av et mellomrom, eller du kan skrive det inn i HTML-entitetsskjemaet <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Dette symbolet brukes i hjelpesystemet til PhpGedView. For å indikere at dette symbolet er vanlig tekst, kan du enten sørge for at det alltid følges av et mellomrom, eller du kan skrive det inn i numerisk form <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Dette symbolet brukes i hjelpesystemet til PhpGedView. For å indikere at dette symbolet er vanlig tekst, kan du enten sørge for at det alltid følges av et mellomrom, eller du kan skrive det inn i numerisk form <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Dette symbolet tolkes av nettleseren til å bety at symbolet som følger er tekst. For å indikere at dette symbolet er vanlig tekst, må du skrive inn to av dem <b>&#92;&#92;</b> eller du kan skrive det inn i numerisk form <b>&amp;&#35;92; </b></li><li><b>&lt;</b>&nbsp;&nbsp;Dette symbolet tolkes av nettleseren for å indikere starten på en HTML-tag. For å indikere at dette symbolet er vanlig tekst, må du skrive det inn i HTML-entitetsskjemaet <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Dette symbolet tolkes av nettleseren for å indikere slutten på en HTML-tag. For å indikere at dette symbolet er vanlig tekst, må du skrive det inn i HTML-entitetsskjemaet <b>&amp;gt;</b></li></ul>Du kan lage lister over elementer i en beskrivelse. Hvis du ønsker å opprette nummererte eller punktlister, kan du begynne å legge inn disse listeelementene med <b>&lt;ul&gt;</b> for en punktliste eller <b>&lt;ol&gt;</b> for en nummerert liste.<br /><br />Hvert listeelement bør begynne med <b>&lt;li&gt;</b> og avslutter med <b>&lt;/li&gt;</b>. Det siste listeelementet skal avsluttes som alle de andre og bør følges av <b>&lt;/ul&gt;</b> for å lukke punktlisten eller <b>&lt;/ol&gt;</b> for å lukke den nummererte listen.<br /><br />De foregående merknadene om å skrive inn symbolene «Mindre enn» <b>&lt;</b> og «Større enn» <b>&gt;</b>, som vanligvis omslutter HTML-tagger, siden tekst ikke gjelder siden du i dette tilfellet faktisk må skrive inn HTML-tagger.";
$pgv_lang["ra_add_task_words"]		= "Før noen oppgaver kan opprettes, <u>må</u> du ha opprettet en mappe som inneholder den oppgaven.<br /><br />Oppgaver er måter å administrere forskningsoppgaver eller handlinger for oppfølging. Disse oppgavene er oppsummert med titlene og bruker beskrivelsesfeltene til å definere mer detaljert hva som kreves. Oppgaver kan også ha noe kildemateriale som skal forskes på slik at dette kan legges ved, og dersom det er en eller flere personer denne oppgaven er knyttet til bør de også knyttes til denne nye oppgaven.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />«#pgv_lang[ra_my_tasks]#» listen viser forskningsoppgaver for gjeldende bruker. Som standard viser oppgavelisten åpne eller ufullstendige oppgaver for gjeldende bruker. Dette kan konfigureres til å vise fullførte oppgaver i tillegg og for å vise oppgaver som for øyeblikket ikke er tildelt. Den resulterende tabellen kan deretter brukes til raskt å se på forskningsoppgavene som skal administreres.<ul><li>Når du klikker på en <b>#pgv_lang[ra_title]#</b> vil du bli ført til en «#pgv_lang[ra_Task_View]#» for flere detaljer på den spesifikke oppgaven.</li><li>#pgv_lang[ra_Start_Date]# indikerer når oppgaven opprinnelig ble opprettet.</li>Når du klikker på <b>#pgv_lang[ra_edit]#</b> på slutten av hver oppgaves rad, blir du ført til «#pgv_lang[ra_edit_task]#» visningen for den spesifikke oppgaven for å oppdatere eller fullføre den.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Dette området viser potensiell manglende informasjon om en persons post. Dette kan for eksempel inkludere en manglende fødselskilde eller det faktum at personen var i live under en militær konflikt, men mangler en militær oppføring. #pgv_lang[ra_RA_name]# vil inspisere personens genealogiske databasepost for mulig manglende informasjon og produsere en liste over potensielle oppfølgingsoppgaver som kan opprettes.<br /><br />Før noen manglende oppgaver kan opprettes, <u>må</u> du ha opprettet en mappe som inneholder oppgavene.<br /><br />Tabellen viser en liste over potensielle nye oppgaver som kan opprettes eller tidligere generert oppgaver å vise.<ul><li>For å opprette en oppgave for å spore manglende informasjon, merk av i avmerkingsboksen ved siden av den. Når alle ønskede oppgaver er valgt og en mappe for gruppering av disse nye oppgavene er valgt, klikker du <b>#pgv_lang[ra_AddTask]#</b> for å opprette oppgaver for de manglende elementene.</li><li>Eksisterende oppgaver. vil vise <b>#pgv_lang[ra_view]#</b> i stedet for en avmerkingsboks som, når du klikker, tar deg direkte til oppgaven.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Tabellen som vises er en liste over forskningsoppgaver som er knyttet til denne personens journal. Kun oppgaver som ikke er merket som fullført vises. De kunne ha blitt opprettet manuelt eller generert ved å bruke «#pgv_lang[ra_missing_info]#» tabellen, men hver oppgave har denne personen knyttet til seg.<br /><br />Klikk på oppgavens tittel for å se flere detaljer om den.</br>Klikk på knappen <b>#pgv_lang[ra_task_entry]#</b> nederst i tabellen for å manuelt opprette en ny oppgave knyttet til denne personens post.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Dette er en liste over alle oppgaver som er knyttet til denne kilden. Kun oppgaver som ikke er merket som fullført vises. Meldingen «#pgv_lang[ra_no_sour_tasks]#» vises når ingen oppgaver har denne kilden koblet. Når det er en tilknyttet oppgave, klikk på oppgavens tittel for å starte «#pgv_lang[ra_view_task]#» siden for mer informasjon om den.<br /><br /><b>Merk</b>: Nye oppgaver kan ikke opprettes i «#pgv_lang[ra_source]#» oppføringen. Bruk <b>#pgv_lang[ra_AddTask]#</b> funksjonen om nødvendig spesielt for en kilde som ikke er knyttet til en person.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />enne tabellen er en liste over oppgaver. Kolonnene inkluderer:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;En sammendragstittel for oppgaven. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er en detaljert beskrivelse av oppgaven som trengs for forskning eller handlinger for oppfølging. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Dette er opprettelsesdatoen for oppgaven. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Dette indikerer om en oppgave er fullført eller ikke. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Denne oppføringen angir hvem som eier en forskningsoppgave. Denne kolonnen vises ikke i «#pgv_lang[ra_my_tasks]#» visningen siden du er eieren av alle disse oppgavene.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Hvis du er eier av denne oppgaven eller har administrasjonsrettigheter, inneholder denne oppføringen en <u>lenke</u> som tar deg til å redigere oppgaven, ellers vil den være tom.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Hvis du er eieren av denne oppgaven eller har administrasjonsrettigheter, inneholder denne oppføringen en <u>link</u> som tar deg til å slette oppgaven, ellers vil være tom.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Hvis du er eieren av denne oppgaven eller har administrasjonsrettigheter, inneholder denne oppføringen en <u>link</u> som tar deg til å lukke en oppgave umiddelbart hvis den ikke er fullført for øyeblikket, ellers vil dette feltet være tomt. Denne kolonnen vil kun vises i «#pgv_lang[ra_my_tasks]#» visningen siden du er eieren av alle disse oppgavene.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Denne tabellen oppsummerer én spesifikk oppgave.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dette er tittelen på oppgaven.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Dette er mappen som oppgaven er gruppert i.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Dette er forsker som oppgaven er tildelt for øyeblikket.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er den detaljerte beskrivelsen av oppgaven som trengs for forskning eller handlinger for oppfølging.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Eventuelle kilder som trengs for forskning eller handlinger for oppfølging av oppgaven.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Dette er en liste over personer fra slektstreet som er knyttet til oppgaven. Dette feltet kan inneholde flere oppføringer. Kun personer i slektstreet vises.</li></ul><br />Hvis du er den tildelte eieren av oppgaven eller har administrasjonsrettigheter, vil en knapp vises og du kan klikke <b>#pgv_lang[ra_edit_task]#</b> for å redigere detaljene for oppgaven.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Skjemaets felt inkluderer:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dette bør inneholde et kort sammendrag, vanligvis mindre enn 30 tegn, av oppgaven du legger til.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Velg mappen der du vil administrere den nye oppgaven. Bare eksisterende mapper vises. Hvis du vil tilordne denne nye oppgaven til en ny mappe, må du først bruke <b>#pgv_lang[ra_add_folder]#</b> funksjonen fra #pgv_lang[ra_RA_name]# menyen.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Velg fra listen over brukere med redigeringstillatelser noen som kan eie eller oppdatere oppgaven og eventuelle poster knyttet til den. Generelt skal dette feltet aldri være tomt (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Skriv inn en detaljert beskrivelse av oppgaven du vil legge til.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Legg ved eventuelle kilder du har for oppgaven. Dette feltet kan inneholde flere oppføringer.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Velg alle personer knyttet til denne oppgaven. Dette feltet kan inneholde flere oppføringer, men kun personer fra din genealogiske database kan velges og vises i dette feltet.</li></ul><br />Når du oppretter en ny oppgave, kan den lagres ved å klikke <b>#pgv_lang[ra_submit]#</b> knappen, som vil holde den åpen og i #pgv_lang[ra_incomplete]# tilstanden for ytterligere oppdateringer. Oppgaven kan lagres og merkes som #pgv_lang[ra_complete]# samtidig ved å klikke <b>#pgv_lang[ra_save_and_complete]#</b> knappen.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Skjemaets felt inkluderer:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Dette bør inneholde tittelen eller sammendraget av oppgaven du redigerer.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;I dette feltet kan du velge mappen der du vil administrere den nye oppgaven din.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Skriv inn en detaljert beskrivelse av oppgaven du vil legge til.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Legg ved eventuelle kilder du har for oppgaven. Dette feltet kan inneholde flere oppføringer.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Velg alle personer som er knyttet til denne oppgaven. Dette feltet kan inneholde flere oppføringer, men kun personer kan velges fra din genealogiske database og vises i dette feltet.</li></ul><br />Etter å ha modifisert en eksisterende oppgave, kan den sendes inn for fremtidige oppdateringer ved å klikke <b>#pgv_lang[ra_save]#</b> knappen. Oppgaven kan også lagres og merkes som #pgv_lang[ra_completed]# (ingen fremtidige oppdateringer forventes), ved å klikke <b>#pgv_lang[ra_save_and_complete]#</b> knappen.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Dette vil inneholde eventuelle kommentarer relatert til en forskningsoppgave.<br /><br />Når du er i «#pgv_lang[ra_RA_name]#» delen for en person, er disse kommentarene knyttet til den spesifikke posten til denne personen og kun synlige her. Hvis en kommentar vises under en oppgave, er den kommentaren spesifikk for den oppgaven. I hvert tilfelle kan det være flere uavhengige kommentarer. Hver kan redigeres eller slettes uavhengig med den nyeste kommentaren alltid vist øverst.<br /><br />Klikk <b>#pgv_lang[ra_add_new_comment]#</b> for å legge til nye kommentarer til denne listen.<br /><br /><span class='warning'>Hvis du legger til en ny mens du redigerer en oppgave kommentere før du lagrer den redigerte oppgaven, vil eventuelle ulagrede oppgaveendringer gå tapt.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dette er en liste over mapper og beskrivelser av bruken.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Denne kolonnen inneholder navnene på alle mappene på dette nivået du har skapt. Ved å velge mappenavnet vil du bli navigert til en ny skjerm som viser eventuelle undermapper og alle oppgaver knyttet til denne mappen. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Denne kolonnen inneholder en mer detaljert beskrivelse av bruken av disse mappene. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Denne kolonnen har en <u>link</u> for å tillate redigering av mappens navn, beskrivelse eller hierarki.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dette skjemaet støtter opprettelsen av en ny mappe, beskrivelsen av bruken og hierarkiet til andre mapper som denne mappen passer inn i.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Tittelen oppsummerer bruken av mappen du legger til.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Du kan spesifisere om mappen er på høyeste eller rotnivå (#pgv_lang[ra_No_Parent]#) eller som en undermappe til en annen mappe.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er den detaljerte beskrivelsen av mappen du legger til.</li></ul>Klikk på <b>#pgv_lang[ra_add]#</b> knappen vil sende informasjonen for å opprette en ny mappe. Hvis du klikker <b>#pgv_lang[ra_reset]#</b> knappen, forkastes eventuelle endringer i beskrivelsesfeltet.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Dette skjemaet støtter redigering av en eksisterende mappe, beskrivelsen av bruken og hierarkiet til andre mapper som denne mappen passer inn i.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;tittel oppsummerer bruken av mappen du legger til.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Du kan spesifisere om mappen er enten på høyeste nivå (# pgv_lang[ra_No_Parent]#) eller som en undermappe til en annen mappe.</li<li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Dette er den detaljerte beskrivelsen av mappen du legger til.</li></ul><br /><b>#pgv_lang[ra_add]#</b> knappen vil sende informasjonen for å opprette en ny mappe. <b>#pgv_lang[ra_reset]#</b> knappen vil forkaste eventuelle endringer i beskrivelsesfeltet siden sist lagring. Når en mappe er tom, vil <b>#pgv_lang[ra_delete]#</b> knappen vises for å tillate fjerning av denne mappen fra mappehierarkiet, ellers vil du bli advart om at sletting ikke er tillatt med oppgaver som fortsatt finnes i den.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Basert på den valgte personen, vil denne funksjonen automatisk trekke ut ulike viktige og faktaopplysninger fra din genealogiske database og tillate deg å bestemme hvilke av disse som skal overføres til en ekstern slektssides søkemotor. Ulike nettsteder kan velges, inkludert Ancestry, FamilySearch, Findagrave og mer. Resultatene av disse søkene kan brukes til å legge til eller oppdatere informasjon i din genealogiske database.<br /><br />Når du er i «#pgv_lang[ra_RA_name]#» delen av en persons «#pgv_lang[personal_facts]#» side, vil søket være basert på denne personen. Hvis det startes fra #pgv_lang[ra_RA_name]# hovedmenyene, må en person først velges ved å klikke på personikonet for å velge en person eller skrive inn personens identifikasjonsnummer i feltet.<br /><br />Velg navnet på slektsområdet du ønsker å spørre fra listen. Du vil bli vist en liste over informasjon som kan velges. Angi med hake ved siden av hvert element (navn, fødsel eller dødsdato, osv.) elementene som vil bli sendt til den valgte søkemotoren etter at <b>#pgv_lang[ra_autosearch_search]#</b> knappen har blitt klikket. Den eksterne nettsidens søkemotor lanseres på en ny side. Bruk #pgv_lang[ra_task_list]# administrasjonsfunksjonen for å identifisere ytterligere funn for oppfølging.<br /><br />Vær oppmerksom på at søkemotorer er i stadig utvikling, så når du først er på et slektsforskningsnettsted, kan de opprinnelige egenskapene der tilby flere søkekriterier som kan oppdateres for å berike forskningen din.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Denne siden analyserer dataene i din genealogiske database og viser korrelasjonene mellom ulike dataelementer.<br /><br />For eksempel kan det være en 95 % korrelasjon på at etternavnet i en lokal post er det samme som etternavnet i farens journal. Dette vil bety at 95 % av personene i denne genealogiske databasen deler samme etternavn som sin far. I denne versjonen av #pgv_lang[ra_RA_name]# modulen brukes disse beregningene for å hjelpe med å identifisere manglende informasjon for en persons poster. De brukes ikke i andre områder av programmet; de er kun gitt som en hjelp til deg i din forskning.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Noen genealogiske programmer lar deg oppgi forskningsoppgaver som TODO elementer i databasen deres. Når de eksporterer denne genealogiske informasjonen til andre programmer, vil de eksportere databasepostene til en fil formatert i henhold til GEDCOM anbefalingen. PHPGEDVIEW programvaren bruker GEDCOM formatert fil som input, så disse TODO elementene er innebygd i dataene dine. Dette alternativet vil søke i din genealogiske database og automatisk konvertere alle importerte TODO elementer til forskningsoppgaver.<br /><br />Ved å klikke på <b>#pgv_lang[ra_generate]#</b> knappen nederst i skjemaet vil du lage en liste over potensielle oppgaver fra de importerte TODO-elementene. Fra denne listen kan du velge elementer for å generere oppgaver.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Merk hver oppgave som skal genereres og generer deretter den oppgaven.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;De første 30 tegnene i oppgavebeskrivelsen vil bli oppgavens navn. Du kan endre eller rette dette når du redigerer oppgaven.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Beskrivelsen oppgaven vil bli gitt, kopiert fra den fullstendige teksten til TODO-elementet i din genealogiske database. Du kan endre eller rette dette når du redigerer oppgaven.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Klikk på koblingen for å redigere den oppgaven.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Velg mappen der de genererte oppgavene skal legges inn.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;omdirigerer deg til #pgv_lang[ra_Folder_View]# siden.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Dette skjemaet lar deg redigere oppgavene som ble opprettet fra TODO-elementer i din genealogiske database.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;For å velge personen du vil knytte til oppgaven.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Klikk på lenken for å velge kilden du vil knytte oppgaven til.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Lagrer alle endringene dine og omdirigerer deg til #pgv_lang[ra_gen_tasks]# siden.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Forkaster alle endringene dine og omdirigerer deg til #pgv_lang[ra_gen_tasks]# siden.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Som administrator for PhpGedView-nettstedet ditt har du muligheten til å kontrollere synligheten til forskjellige funksjoner i #pgv_lang[ra_RA_name]# modulen. Denne dialogboksen presenterer de tilgjengelige funksjonsblokkene og ber deg velge synlighet ved å velge tilgangskontroller for hver.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Den angitte funksjonsblokken er tilgjengelig for alle.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Den angitte funksjonsblokken er kun tilgjengelig for autentiserte brukere.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Den angitte funksjonsblokken er kun tilgjengelig for brukere med administratorrettigheter.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Den angitte funksjonsblokken er ikke tilgjengelig for noen.</li></ul></ul>";
?>
