<?php
/**
 * Polish language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.pl.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.pl.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Niektóre programy pozwalają na wprowadzanie zadań badawczych jako elementów TODO w bazie danych genealogicznych. Ta opcja przeszuka bazę danych genealogicznych i automatycznie przekonwertuje każdy element TODO na zadanie badawcze.";
$pgv_lang["ra_mytasks_block_descr"]		= "Blok «#pgv_lang[ra_my_tasks]#» pokazuje zadania dla bieżącego użytkownika. Można go skonfigurować tak, aby pokazywał ukończone zadania lub zadania, które są obecnie nieprzypisane.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Jak organizować zadania~<br /><br />Zadania są organizowane w folderach. Przed utworzeniem jakichkolwiek zadań musi istnieć co najmniej jeden folder.<br /><br />Możesz tworzyć i organizować swoje foldery w dowolny sposób. Prawdopodobnie będziesz chciał organizować swoje foldery online w taki sam sposób, w jaki organizujesz kopie papierowe swoich badań. Wielu badaczy organizuje swoje foldery według linii rodzinnej, nazwiska lub lokalizacji geograficznej.";
$pgv_lang["ra_whataretasks_words"]		= "~Czym są zadania?~<br /><br />Moduł #pgv_lang[ra_RA_name]# koncentruje się na zadaniu badawczym. Zadanie badawcze jest podobne do elementu TODO i śledzi konkretne zadanie genealogiczne, które należy wykonać. Przykładowy tytuł zadania może brzmieć: «Znajdź akt urodzenia Joego», podczas gdy szczegóły w opisie wskazywałyby: «Znajdź akt urodzenia Joego w aktach urodzenia hrabstwa Ottawa».<br /><br />Zadania mogą być przypisane konkretnym użytkownikom. Dzięki przypisaniu zadań użytkownikom wszyscy wiedzą, nad jakimi badaniami powinni pracować i kto pracuje nad innymi zadaniami badawczymi.<br /><br />Zadania mogą również obejmować działania dotyczące materiału źródłowego lub odnoszące się do jednej lub więcej osób w Twoich danych. Po zainstalowaniu modułu #pgv_lang[ra_RA_name]# zobaczysz sekcję «#pgv_lang[ra_RA_name]#» na każdej stronie «#pgv_lang[personal_facts]#», a także sekcję Zadania na każdej stronie danych źródłowych.<br /><br />Zadania są tworzone w stanie <b>#pgv_lang[ra_incomplete]#</b>, co wskazuje, że praca nad nimi jest w toku. Wszystkie zadania powinny być przypisane użytkownikowi, który może edytować i aktualizować rekordy za pomocą ustaleń. Po zakończeniu całej pracy zadanie powinno zostać przesłane jako <b>#pgv_lang[ra_complete]#</b>. Spowoduje to usunięcie go z aktywnie widocznych (tj. #pgv_lang[ra_incomplete]#) list zadań. Używając menu «#pgv_lang[ra_my_tasks]#» każdy użytkownik może zobaczyć swoje przypisane zadania, zarówno #pgv_lang[ra_incomplete]#, jak i #pgv_lang[ra_complete]#.<br /><br />Każde zadanie ma sekcję komentarzy, w której mogą odbywać się dyskusje dotyczące danych i badań lub możliwych wyników. Dzięki temu zadanie pozostaje zorientowane na cel, a komentarze są zorientowane na postęp i wyniki.";
$pgv_lang["ra_sortcol_words"]		= "Kolumnę tę można sortować, klikając na jej nagłówek.";
$pgv_lang["ra_folder_words"]			= "Foldery to narzędzie do zarządzania zadaniami, które umożliwia grupowanie zadań. Foldery mogą być zawarte w innych folderach. Jeśli istnieje folder nadrzędny, będzie on wyświetlany po lewej stronie menu powyżej. Jeśli ten obszar jest pusty, te foldery znajdują się na najwyższym poziomie.";
$pgv_lang["ra_view_task_words"]		= "Zadania to sposoby zarządzania zadaniami badawczymi lub działaniami do wykonania. Zadanie jest podsumowane przez jego tytuł, podczas gdy pole opisu definiuje więcej szczegółów na temat tego, co jest wymagane. Czasami działania następcze dla rozwiązania mogą być również zawarte w polu opisu. Poniżej tabeli «#pgv_lang[ra_Task_View]#» znajduje się tabela «#pgv_lang[ra_comments]#», która może być używana do śledzenia postępów i opisywania rozwiązań zadań.";
$pgv_lang["ra_special_char_words"]		= "Czasami tekst może wymagać wyświetlania symboli, które mają specjalne znaczenie dla przeglądarki lub PhpGedView, inne niż zwykły tekst. Gdy takie symbole muszą wystąpić w tekście, należy wprowadzić je w formacie, który wskazuje, że są tekstem bez specjalnego znaczenia.<ul><li><b>&amp;</b>&nbsp;&nbsp;Ten symbol sygnalizuje początek encji HTML. Aby wskazać, że ten symbol jest zwykłym tekstem, możesz albo upewnić się, że zawsze następuje po nim spacja, albo możesz wprowadzić go w jego formie encji HTML <b>&amp;amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Ten symbol jest używany w systemie pomocy PhpGedView. Aby wskazać, że ten symbol jest zwykłym tekstem, możesz albo upewnić się, że zawsze następuje po nim spacja, albo możesz wprowadzić go w jego formie numerycznej <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Ten symbol jest używany w systemie pomocy PhpGedView. Aby wskazać, że ten symbol jest zwykłym tekstem, możesz albo upewnić się, że zawsze następuje po nim spacja, albo możesz wprowadzić go w jego formie numerycznej <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Przeglądarka interpretuje ten symbol jako oznaczający, że następujący po nim symbol jest tekstem. Aby wskazać, że ten symbol jest zwykłym tekstem, należy wprowadzić dwa z nich <b>&#92;&#92;</b> lub wprowadzić go w jego formie numerycznej <b>&amp;&#35;92;</b></li><li><b>&lt;</b>&nbsp;&nbsp;Przeglądarka interpretuje ten symbol jako wskazujący początek znacznika HTML. Aby wskazać, że ten symbol jest zwykłym tekstem, należy wprowadzić go w jego formie encji HTML <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Przeglądarka interpretuje ten symbol jako wskazujący koniec znacznika HTML. Aby wskazać, że ten symbol jest zwykłym tekstem, należy wprowadzić go w jego formie encji HTML <b>&amp;gt;</b></li></ul>Możesz tworzyć listy elementów w opisie. Jeśli chcesz utworzyć listy numerowane lub wypunktowane, rozpocznij wprowadzanie tych elementów listy od <b>&lt;ul&gt;</b> w przypadku listy wypunktowanej lub <b>&lt;ol&gt;</b> w przypadku listy numerowanej.<br /><br />Każdy element listy powinien zaczynać się od <b>&lt;li&gt;</b> i kończyć się <b>&lt;/li&gt;</b>. Ostatni element listy powinien zostać zakończony tak jak wszystkie pozostałe i zakończony znakiem <b>&lt;/ul&gt;</b> w celu zamknięcia listy wypunktowanej lub <b>&lt;/ol&gt;</b> w celu zamknięcia listy numerowanej.<br /><br />Poprzednie uwagi dotyczące wprowadzania symboli «mniejszych niż» <b>&lt;</b> i «większych niż» <b>&gt;</b>, które zwykle obejmują znaczniki HTML, nie mają zastosowania jako tekst, ponieważ w tym przypadku należy wprowadzić znaczniki HTML.";
$pgv_lang["ra_add_task_words"]		= "Zanim będzie można utworzyć jakiekolwiek zadania, <u>musisz</u> utworzyć folder, w którym będzie przechowywane to zadanie.<br /><br />Zadania to sposoby zarządzania zadaniami badawczymi lub działaniami następczymi. Zadania te są podsumowywane według ich tytułów i wykorzystują pola opisu, aby dokładniej określić, co jest wymagane. Zadania mogą również zawierać materiały źródłowe do zbadania, więc można je dołączyć, a jeśli jest jedna lub więcej osób, z którymi to zadanie jest powiązane, powinny one również zostać dołączone do tego nowego zadania.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />Lista «#pgv_lang[ra_my_tasks]#» pokazuje zadania badawcze dla bieżącego użytkownika. Domyślnie lista zadań pokazuje otwarte lub nieukończone zadania dla bieżącego użytkownika. Można to skonfigurować, aby dodatkowo pokazywać ukończone zadania i zadania, które są obecnie nieprzypisane. Następnie można użyć tabeli wynikowej, aby szybko przejrzeć zadania badawcze, którymi należy zarządzać.<ul><li>Po kliknięciu <b>#pgv_lang[ra_title]#</b> zostaniesz przeniesiony do «#pgv_lang[ra_Task_View]#», aby uzyskać więcej szczegółów na temat konkretnego zadania.</li><li>#pgv_lang[ra_Start_Date]# wskazuje, kiedy zadanie zostało pierwotnie utworzone.</li><li>Po kliknięciu <b>#pgv_lang[ra_edit]#</b> na końcu wiersza każdego zadania zostaniesz przeniesiony do widoku «#pgv_lang[ra_edit_task]#» dla tego konkretnego zadania, aby je zaktualizować lub ukończyć.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Obszar ten pokazuje potencjalnie brakujące informacje o rekordzie osoby. Na przykład może to obejmować brakujące źródło urodzenia lub fakt, że osoba żyła w czasie konfliktu zbrojnego, ale brakuje jej wpisu wojskowego. Moduł #pgv_lang[ra_RA_name]# sprawdzi rekord bazy danych genealogicznej osoby pod kątem możliwych brakujących informacji i wygeneruje listę potencjalnych zadań uzupełniających, które można utworzyć.<br /><br />Zanim będzie można utworzyć jakiekolwiek brakujące zadania, <u>musisz</u> utworzyć folder, w którym będą przechowywane zadania.<br /><br />Tabela przedstawia listę potencjalnie nowych zadań, które można utworzyć, lub zadań wcześniej wygenerowanych do przejrzenia.<ul><li>Aby utworzyć zadanie śledzenia brakujących informacji, zaznacz pole wyboru obok niego. Gdy wszystkie żądane zadania zostaną wybrane i folder do grupowania tych nowych zadań zostanie wybrany, kliknij <b>#pgv_lang[ra_AddTask]#</b>, aby utworzyć zadania dla brakujących elementów.</li><li>Istniejące zadania będą wyświetlać <b>#pgv_lang[ra_view]#</b> zamiast pola wyboru, które po kliknięciu przeniesie Cię bezpośrednio do wyświetlenia tego zadania.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Pokazana tabela to lista zadań badawczych, które są powiązane z rekordem tej osoby. Pokazywane są tylko zadania, które nie zostały oznaczone jako ukończone. Mogły zostać utworzone ręcznie lub wygenerowane przy użyciu tabeli «#pgv_lang[ra_missing_info]#», ale każde zadanie ma powiązaną z nim tę osobę.<br /><br />Kliknij tytuł zadania, aby zobaczyć więcej szczegółów na jego temat.</br>Kliknij przycisk <b>#pgv_lang[ra_task_entry]#</b> na dole tabeli, aby ręcznie utworzyć nowe zadanie powiązane z rekordem tej osoby.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Oto lista wszystkich zadań powiązanych z tym źródłem. Wyświetlane są tylko zadania nieoznaczone jako ukończone. Wiadomość «#pgv_lang[ra_no_sour_tasks]#» pojawi się, gdy żadne zadanie nie będzie miało powiązanego tego źródła. Gdy istnieje powiązane zadanie, kliknij tytuł zadania, aby uruchomić stronę «#pgv_lang[ra_view_task]#», aby uzyskać więcej szczegółów na jego temat.<br /><br /><b>Uwaga</b>: Nie można tworzyć nowych zadań w ramach wpisu «#pgv_lang[ra_source]#». Użyj funkcji <b>#pgv_lang[ra_AddTask]#</b>, jeśli jest to potrzebne specjalnie dla źródła, które nie jest powiązane z osobą.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Ta tabela to lista zadań. Kolumny obejmują:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Podsumowujący tytuł zadania. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;To szczegółowy opis zadania potrzebnego do badań lub działań następczych. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;To data utworzenia zadania. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;To wskazuje, czy zadanie zostało ukończone. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Ten wpis wskazuje, kto jest właścicielem zadania badawczego. Ta kolumna nie jest wyświetlana w widoku «#pgv_lang[ra_my_tasks]#», ponieważ jesteś właścicielem wszystkich tych zadań.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Jeśli jesteś właścicielem tego zadania lub masz uprawnienia administratora, ten wpis zawiera <u>link</u> , który przeniesie Cię do edycji zadania, w przeciwnym razie będzie pusty.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Jeśli jesteś właścicielem tego zadania lub masz uprawnienia administratora, ten wpis zawiera <u>link</u> , który przeniesie Cię do usunięcia zadania, w przeciwnym razie będzie pusty.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Jeśli jesteś właścicielem tego zadania lub masz uprawnienia administratora, ten wpis zawiera <u>link</u> , który przeniesie Cię do natychmiastowego zamknięcia zadania, jeśli nie jest ono obecnie ukończone, w przeciwnym razie to pole będzie puste. Ta kolumna będzie wyświetlana tylko w widoku «#pgv_lang[ra_my_tasks]#», ponieważ jesteś właścicielem wszystkich tych zadań.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Ta tabela podsumowuje jedno konkretne zadanie.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;To jest tytuł zadania.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;To jest folder, w którym zadanie jest pogrupowane.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;To jest badacz, któremu zadanie jest aktualnie przypisane.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;To jest szczegółowy opis zadania potrzebnego do badań lub działań następczych.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Wszelkie źródła potrzebne do badań lub działań następczych dla zadania.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;To jest lista osób z drzewa genealogicznego, które są powiązane z zadaniem. To pole może zawierać wiele wpisów. Wyświetlane są tylko osoby z drzewa genealogicznego.</li></ul><br />Jeśli jesteś wyznaczonym właścicielem zadania lub posiadasz uprawnienia administratora, zostanie wyświetlony przycisk, który możesz kliknąć, klikając <b>#pgv_lang[ra_edit_task]#</b>, aby edytować szczegóły zadania.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Pola formularza obejmują:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Powinno zawierać krótkie podsumowanie, zazwyczaj krótsze niż 30 znaków, dodawanego zadania.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Wybierz folder, w którym chcesz zarządzać nowym zadaniem. Wyświetlane są tylko istniejące foldery. Jeśli chcesz przypisać to nowe zadanie do nowego folderu, musisz najpierw użyć funkcji <b>#pgv_lang[ra_add_folder]#</b> z głównego menu #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Wybierz z listy użytkowników z uprawnieniami do edycji osobę, która może posiadać lub aktualizować zadanie oraz wszelkie powiązane z nim rekordy. Zasadniczo to pole nigdy nie powinno być puste (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Wprowadź szczegółowy opis zadania, które chcesz dodać.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Dołącz wszystkie źródła, które masz dla zadania. To pole może zawierać wiele wpisów.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Wybierz wszystkie osoby powiązane z tym zadaniem. To pole może zawierać wiele wpisów, ale tylko osoby z Twojej bazy genealogicznej mogą być wybrane i wyświetlone w tym polu.</li></ul><br />Podczas tworzenia nowego zadania można je zapisać, klikając przycisk <b>#pgv_lang[ra_submit]#</b>, co spowoduje, że pozostanie ono otwarte i w stanie #pgv_lang[ra_incomplete]# w celu dalszych aktualizacji. Zadanie można zapisać i oznaczyć jako #pgv_lang[ra_complete]# w tym samym czasie, klikając przycisk <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Pola formularza obejmują:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Powinno to zawierać tytuł lub podsumowanie zadania, które edytujesz.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;W tym polu możesz wybrać folder, w którym chcesz zarządzać nowym zadaniem.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Wprowadź szczegółowy opis zadania, które chcesz dodać.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Dołącz wszelkie źródła, które masz dla zadania. To pole może zawierać wiele wpisów.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Wybierz wszystkie osoby powiązane z tym zadaniem. To pole może zawierać wiele wpisów, ale tylko osoby mogą być wybrane z Twojej bazy genealogicznej i pokazane w tym polu.</li></ul><br />Po zmodyfikowaniu istniejącego zadania, można je przesłać do przyszłych aktualizacji, klikając przycisk <b>#pgv_lang[ra_save]#</b>. Zadanie można również zapisać i oznaczyć jako #pgv_lang[ra_completed]# (nie oczekuje się żadnych przyszłych aktualizacji), klikając przycisk <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Będzie zawierać wszelkie komentarze związane z zadaniem badawczym.<br /><br />Gdy znajdujesz się w sekcji «#pgv_lang[ra_RA_name]#» dla osoby, komentarze te są powiązane ze szczegółowym rekordem tej osoby i widoczne tylko tutaj. Jeśli komentarz jest wyświetlany pod zadaniem, jest on specyficzny dla tego zadania. W każdym przypadku może być wiele niezależnych komentarzy. Każdy z nich można niezależnie edytować lub usunąć, a najnowszy komentarz zawsze jest wyświetlany na górze.<br /><br />Kliknij <b>#pgv_lang[ra_add_new_comment]#</b>, aby dodać nowe komentarze do tej listy.<br /><br /><span class='warning'>Jeśli podczas edycji zadania dodasz nowy komentarz przed zapisaniem edytowanego zadania, wszelkie niezapisane zmiany zadania zostaną utracone.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Oto lista folderów i opis ich zastosowania.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Ta kolumna zawiera nazwy wszystkich folderów na tym poziomie, które utworzyłeś. Wybierając nazwę folderu, zostaniesz przeniesiony do nowego wyświetlacza pokazującego wszystkie podfoldery i wszystkie zadania skojarzone z tym folderem. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Ta kolumna zawiera bardziej szczegółowy opis zastosowania tych folderów. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Ta kolumna zawiera <u>link</u> umożliwiający edycję nazwy, opisu lub hierarchii folderu.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Ten formularz obsługuje tworzenie nowego folderu, opis jego zastosowania oraz hierarchię innych folderów, do których pasuje ten folder.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Tytuł podsumowuje zastosowanie dodawanego folderu.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Możesz określić, czy folder znajduje się na najwyższym lub głównym poziomie (#pgv_lang[ra_No_Parent]#) czy jako podfolder innego folderu.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Oto szczegółowy opis dodawanego folderu.</li></ul>Kliknięcie przycisku <b>#pgv_lang[ra_add]#</b> spowoduje przesłanie informacji w celu utworzenia nowego folderu. Kliknięcie przycisku <b>#pgv_lang[ra_reset]#</b> spowoduje odrzucenie wszelkich zmian w polu opisu.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Ten formularz obsługuje edycję istniejącego folderu, opis jego zastosowania i hierarchię innych folderów, do których pasuje ten folder.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Tytuł podsumowuje zastosowanie dodawanego folderu.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Możesz określić, czy folder znajduje się na najwyższym poziomie (#pgv_lang[ra_No_Parent]#), czy jako podfolder innego folderu.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;To jest szczegółowy opis dodawanego folderu.</li></ul><br />Przycisk <b>#pgv_lang[ra_add]#</b> prześle informacje w celu utworzenia nowego folderu. Przycisk <b>#pgv_lang[ra_reset]#</b> odrzuci wszelkie zmiany w polu opisu wprowadzone od ostatniego zapisania. Gdy folder jest pusty, pojawi się przycisk <b>#pgv_lang[ra_delete]#</b>, aby zezwolić na usunięcie tego folderu z hierarchii folderów, w przeciwnym razie zostaniesz ostrzeżony, że usuwanie nie jest dozwolone, ponieważ zadania nadal w nim są.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Na podstawie wybranej osoby ta funkcja automatycznie wyodrębni różne istotne i faktyczne informacje z Twojej bazy danych genealogicznych i pozwoli Ci określić, które z nich przekazać do wyszukiwarki zewnętrznej witryny genealogicznej. Można wybrać różne witryny, w tym Ancestry, FamilySearch, Findagrave i inne. Wyniki tych wyszukiwań można wykorzystać do dodawania lub aktualizowania informacji w Twojej bazie danych genealogicznych.<br /><br />Gdy jesteś w sekcji «#pgv_lang[ra_RA_name]#» strony «#pgv_lang[personal_facts]#» danej osoby, wyszukiwanie będzie oparte na tej osobie. Jeśli uruchomisz z głównego menu #pgv_lang[ra_RA_name]#, najpierw musisz wybrać osobę, klikając ikonę osoby, aby wybrać osobę lub wpisując numer identyfikacyjny osoby w polu.<br /><br />Wybierz z listy nazwę witryny genealogicznej, którą chcesz przeszukać. Zostanie wyświetlona lista informacji, które można wybrać. Zaznacz znacznikami obok każdego elementu (nazwisko, data urodzenia lub śmierci itp.) elementy, które zostaną przekazane do wybranej wyszukiwarki po kliknięciu przycisku <b>#pgv_lang[ra_autosearch_search]#</b>. Wyszukiwarka zewnętrznej witryny zostanie uruchomiona na nowej stronie. Użyj funkcji zarządzania #pgv_lang[ra_task_list]#, aby zidentyfikować dodatkowe ustalenia do dalszych działań.<br /><br />Należy pamiętać, że wyszukiwarki stale się rozwijają, dlatego po wejściu na stronę genealogiczną jej natywne funkcje mogą oferować dodatkowe kryteria wyszukiwania, które można aktualizować w celu wzbogacenia swoich badań.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Ta strona analizuje dane w Twojej bazie genealogicznej i pokazuje korelacje między różnymi elementami danych.<br /><br />Na przykład, może istnieć 95% korelacja, że nazwisko w lokalnym rekordzie jest takie samo jak nazwisko w rekordzie ojca. Oznaczałoby to, że 95% osób w tej bazie genealogicznej ma takie samo nazwisko jak ich ojciec. W tej wersji modułu #pgv_lang[ra_RA_name]# obliczenia te są używane w celu pomocy w identyfikacji brakujących informacji w rekordach danej osoby. Nie są używane w innych obszarach programu; są udostępniane wyłącznie jako pomoc w Twoich badaniach.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Niektóre programy genealogiczne pozwalają na wprowadzanie zadań badawczych jako elementów TODO w ich bazie danych. Podczas eksportowania tych informacji genealogicznych do innych programów eksportują one rekordy bazy danych do pliku sformatowanego zgodnie z zaleceniami GEDCOM. Oprogramowanie PhpGedView używa pliku sformatowanego w formacie GEDCOM jako danych wejściowych, więc te elementy TODO są osadzone w Twoich danych. Ta opcja przeszuka Twoją bazę danych genealogicznych i automatycznie przekonwertuje wszystkie zaimportowane elementy TODO na zadania badawcze.<br /><br />Kliknięcie przycisku <b>#pgv_lang[ra_generate]#</b> na dole formularza spowoduje utworzenie listy potencjalnych zadań z zaimportowanych elementów TODO. Z tej listy możesz wybrać elementy, aby wygenerować zadania.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Oznacz każde zadanie do wygenerowania, a następnie wygeneruj to zadanie.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Pierwsze 30 znaków opisu zadania stanie się nazwą zadania. Możesz to zmienić lub poprawić podczas edycji zadania.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Opis, który zostanie podany zadaniu, skopiowany z pełnego tekstu elementu TODO w Twojej bazie danych genealogicznych. Możesz to zmienić lub poprawić podczas edycji zadania.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Kliknij link, aby edytować to zadanie.</li><li><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Wybierz folder, do którego chcesz umieścić wygenerowane zadania.</li><li><b>#pgv_lang[ra_done]#</b>&nbsp;&nbsp;przekierowuje do strony #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Ten formularz umożliwia edycję zadań utworzonych z pozycji TODO w bazie danych genealogicznej.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Aby wybrać osobę, z którą chcesz powiązać zadanie.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Kliknij łącze, aby wybrać źródło, z którym chcesz powiązać zadanie.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Zapisuje wszystkie zmiany i przekierowuje do strony #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Anuluje wszystkie zmiany i przekierowuje do strony #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Jako administrator witryny PhpGedView masz możliwość kontrolowania widoczności różnych funkcjonalności modułu #pgv_lang[ra_RA_name]#. To okno dialogowe przedstawia dostępne bloki funkcjonalne i prosi o wybranie widoczności poprzez wybranie kontroli dostępu dla każdego z nich.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Określony blok funkcjonalny jest dostępny dla każdego.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Określony blok funkcjonalny jest dostępny wyłącznie dla uwierzytelnionych użytkowników.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Określony blok funkcjonalny jest dostępny wyłącznie dla użytkowników z uprawnieniami administratora.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Podany blok funkcjonalny nie jest dostępny dla nikogo.</li></ul></ul>";
?>
