<?php
/**
 * Swedish language Help file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: help_text.sv.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is lang.sv.php, which contains most of the brief texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- Miscellaneous advisories and instructions
$pgv_lang["ra_auto_gen_inst"]		= "Vissa program låter dig ange forskningsuppgifter som TODO objekt i din genealogiska databas. Det här alternativet kommer att söka igenom din genealogiska databas och automatiskt konvertera varje TODO objekt till en forskningsuppgift.";
$pgv_lang["ra_mytasks_block_descr"]		= "Blocket «#pgv_lang[ra_my_tasks]#» visar uppgifter för den aktuella användaren. Den kan konfigureras för att visa slutförda uppgifter eller för att visa uppgifter som för närvarande inte är tilldelade.";

//-- RA HELP MESSAGES
// - Variables with *_help are the actual help texts. *_words are useful text blocks that can be used multiple times in different help texts 

$pgv_lang["ra_organizetasks_words"]		= "~Hur man organiserar uppgifter~<br /><br />Uppgifterna är organiserade i mappar. Minst en mapp måste finnas innan några uppgifter kan skapas.<br /><br />Du kan skapa och organisera dina mappar hur du vill. Du kommer förmodligen att vilja organisera dina onlinemappar som du organiserar papperskopior av din forskning. Många forskare organiserar sina mappar efter släktlinje, efternamn eller geografiska platser.";
$pgv_lang["ra_whataretasks_words"]		= "~Vad är uppgifter?~<br /><br />#pgv_lang[ra_RA_name]# modulen är centrerad på forskningsuppgiften. En forskningsuppgift liknar ett TODO-objekt och spårar en särskild släktforskningsuppgift som behöver göras. Ett exempel på uppgiftsrubrik kan vara «Hitta Joes födelseregister», medan detaljerna i beskrivningen skulle indikera «Hitta Joes födelsebok i Ottawa county födelseregister».<br /><br />Uppgifter kan tilldelas specifika användare. Genom att tilldela uppgifter till användare vet alla vilken forskning de ska arbeta med, och vem som arbetar med andra forskningsuppgifter.<br /><br />Uppgifter kan också innefatta åtgärder mot källmaterial eller relaterade till en eller flera personer i din data. Med #pgv_lang[ra_RA_name]# modulen installerad kommer du att se en «#pgv_lang[ra_RA_name]#» sektion på varje «#pgv_lang[personal_facts]#» sida och även en uppgiftssektion på varje källdatasida.<br /><br />Uppgifter skapas i tillståndet <b>#pgv_lang[ra_incomplete]#</b>, vilket indikerar att arbetet med dem pågår. Alla uppgifter bör tilldelas en användare som kan redigera och uppdatera posterna med resultaten. När allt arbete är klart ska uppgiften skickas in som <b>#pgv_lang[ra_complete]#</b>. Detta tar bort det från de aktivt synliga (d.v.s. #pgv_lang[ra_incomplete]#) uppgiftslistorna. Genom att använda menyn «#pgv_lang[ra_my_tasks]#» kan varje användare se sina tilldelade uppgifter, både #pgv_lang[ra_incomplete]# och #pgv_lang[ra_complete]#.<br /><br />Varje uppgift har en kommentarsektion där diskussioner om data och forskning eller möjliga resultat kan förekomma. Detta gör att uppgiften förblir målorienterad medan kommentarerna är framstegs- och resultatorienterade.";
$pgv_lang["ra_sortcol_words"]		= "Denna kolumn kan sorteras genom att klicka på kolumnrubriken.";
$pgv_lang["ra_folder_words"]			= "Mappar är ett uppgiftshanteringsverktyg som tillåter gruppering av uppgifter tillsammans. Mappar kan finnas i andra mappar. Om det finns en överordnad mapp kommer den att visas på vänster sida av menyerna ovan. Om det området är tomt, är dessa mappar på den översta nivån.";
$pgv_lang["ra_view_task_words"]		= "Uppgifter är sätt att hantera forskningsuppgifter eller åtgärder för uppföljning. Uppgiften sammanfattas med dess titel, medan beskrivningsfältet definierar mer detaljer om vad som krävs. Ibland kan även uppföljningen av resolutionen finnas med i beskrivningsfältet. Under «#pgv_lang[ra_Task_View]#» tabellen finns en «#pgv_lang[ra_comments]#» tabell som kan användas för att spåra framsteg och för att beskriva uppgiftslösningar.";
$pgv_lang["ra_special_char_words"]		= "Ibland kan din text behöva visa symboler som har speciell betydelse för webbläsaren eller för PhpGedView, förutom att vara vanlig text. När sådana symboler måste förekomma i din text måste du skriva in dem i ett format som indikerar att det är text utan särskild betydelse.<ul><li><b>&amp;</b>&nbsp;&nbsp;Denna symbol signalerar starten på en HTML-enhet. För att indikera att den här symbolen är vanlig text kan du antingen se till att den alltid följs av ett blanksteg, eller så kan du ange den i dess HTML Entity-form <b>&amp;</b></li><li><b>&#35;</b>&nbsp;&nbsp;Denna symbol används i hjälpsystemet för PhpGedView. För att indikera att denna symbol är vanlig text kan du antingen se till att den alltid följs av ett mellanslag, eller så kan du skriva in den i dess numeriska form <b>&amp;&#35;35;</b></li><li><b>&#126;</b>&nbsp;&nbsp;Denna symbol används i hjälpsystemet för PhpGedView. För att indikera att denna symbol är vanlig text kan du antingen se till att den alltid följs av ett mellanslag eller så kan du skriva in den i dess numeriska form <b>&amp;&#35;126;</b></li><li><b>&#92;</b>&nbsp;&nbsp;Denna symbol tolkas av webbläsaren som att symbolen som följer är text. För att indikera att denna symbol är vanlig text måste du ange två av dem <b>&#92;&#92;</b> eller så kan du skriva in den i dess numeriska form <b>&amp;&#35;92; </b></li><li><b>&lt;</b>&nbsp;&nbsp;Denna symbol tolkas av webbläsaren för att indikera början på en HTML tagg. För att indikera att den här symbolen är vanlig text måste du ange den i dess HTML Entity-form <b>&amp;lt;</b></li><li><b>&gt;</b>&nbsp;&nbsp;Detta symbolen tolkas av webbläsaren för att indikera slutet på en HTML tagg. För att indikera att den här symbolen är vanlig text måste du ange den i dess HTML Entity-form <b>&amp;gt;</b></li></ul>Du kan skapa listor med objekt i en beskrivning. Om du vill använda numrerade eller punktlistor, börja din inmatning av dessa listobjekt med <b>&lt;ul&gt;</b> för en punktlista eller <b>&lt;ol&gt;</b> för en numrerad lista.<br /><br />Varje lista bör börja med <b>&lt;li&gt;</b> och avsluta med <b>&lt;/li&gt;</b>. Det sista listobjektet bör avslutas som alla andra och bör följas av <b>&lt;/ul&gt;</b> för att stänga punktlistan eller <b>&lt;/ol&gt;</b> för att stänga den numrerade listan.<br /><br />De föregående anmärkningarna om att ange symbolerna «Mindre än» <b>&lt;</b> och «Större än» <b>&gt;</b>, som vanligtvis omsluter HTML taggar, eftersom text inte gäller eftersom du i det här fallet faktiskt behöver ange HTML taggar.";
$pgv_lang["ra_add_task_words"]		= "Innan några uppgifter kan skapas <u>måste</u> du ha skapat en mapp som innehåller den uppgiften.<br /><br />Uppgifter är sätt att hantera forskningsuppgifter eller åtgärder för uppföljning. Dessa uppgifter sammanfattas med sina rubriker och använder beskrivningsfälten för att definiera mer i detalj vad som krävs. Uppgifter kan också ha en del källmaterial som ska undersökas så att detta kan bifogas, och om det finns en eller flera personer som denna uppgift är kopplad till bör de också kopplas till denna nya uppgift.";


$pgv_lang["ra_mytasks_help"]			= "<ul>~#pgv_lang[ra_my_tasks]#~<br /><br />«#pgv_lang[ra_my_tasks]#» listan visar forskningsuppgifter för den aktuella användaren. Som standard visar uppgiftslistan öppna eller ofullständiga uppgifter för den aktuella användaren. Detta kan konfigureras för att ytterligare visa slutförda uppgifter och för att visa uppgifter som för närvarande inte är tilldelade. Den resulterande tabellen kan sedan användas för att snabbt titta på de forskningsuppgifter som ska hanteras.<ul><li>När du klickar på en <b>#pgv_lang[ra_title]#</b> kommer du att föras till en «#pgv_lang[ra_Task_View]#» för mer information på den specifika uppgiften.</li><li>#pgv_lang[ra_Start_Date]# anger när uppgiften ursprungligen skapades.</li><li>När du klickar på <b>#pgv_lang[ra_edit]#</b> i slutet av varje uppgiftsrad, kommer du att tas till «#pgv_lang[ra_edit_task]#» vyn för den specifika uppgiften för att uppdatera eller slutföra den.</li></ul></ul>";
$pgv_lang["ra_missing_info_help"]		= "<ul>~#pgv_lang[ra_missing_info]#~<br /><br />Det här området visar potentiell saknad information om en persons register. Det kan till exempel inkludera en försvunnen födelsekälla eller det faktum att personen levde under en militär konflikt men saknar ett militärt inträde. Modulen #pgv_lang[ra_RA_name]# kommer att inspektera personens genealogiska databaspost för eventuell saknad information och skapa en lista över potentiella uppföljningsuppgifter som kan skapas.<br /><br />Innan några saknade uppgifter kan skapas <u>måste</u> du ha skapat en mapp för att innehålla uppgifterna.<br /><br />Tabellen visar en lista över potentiella nya uppgifter som kan skapas eller tidigare genereras uppgifter att visa.<ul><li>För att skapa en uppgift för att spåra viss information som saknas, markera kryssrutan bredvid den. När alla önskade uppgifter har valts och en mapp för att gruppera dessa nya uppgifter har valts, klicka på <b>#pgv_lang[ra_AddTask]#</b> för att skapa uppgifter för de saknade objekten.</li><li>Befintliga uppgifter. visar <b>#pgv_lang[ra_view]#</b> istället för en kryssruta som, när du klickar på den, tar dig direkt till den uppgiften.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_person_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Tabellen som visas är en lista över forskningsuppgifter som är kopplade till denna persons register. Endast uppgifter som inte markerats som slutförda visas. De kunde ha skapats manuellt eller genererats med hjälp av tabellen «#pgv_lang[ra_missing_info]#», men varje uppgift har denna person kopplad till sig.<br /><br />Klicka på uppgiftens titel för att se ytterligare detaljer om det.</br>Klicka på knappen <b>#pgv_lang[ra_task_entry]#</b> längst ner i tabellen för att manuellt skapa en ny uppgift kopplad till denna persons post.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_sources_task_list_help"]		= "<ul>~#pgv_lang[ra_task_list]#~<br /><br />Detta är en lista över alla uppgifter som är associerade med den här källan. Endast uppgifter som inte markerats som slutförda visas. Meddelandet «#pgv_lang[ra_no_sour_tasks]#» kommer att visas när inga uppgifter har denna källa länkad. När det finns en associerad uppgift, klicka på uppgiftens titel för att öppna «#pgv_lang[ra_view_task]#» sidan för mer information om den.<br /><br /><b>Obs</b>: Nya uppgifter kan inte skapas i posten «#pgv_lang[ra_source]#». Använd funktionen <b>#pgv_lang[ra_AddTask]#</b> om det behövs specifikt för en källa som inte är länkad till en person.<br /><br />#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_view_tasklist_help"]		= "<ul>~#pgv_lang[ra_Task_View]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Den här tabellen är en lista över uppgifter. Kolumnerna innehåller:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;En sammanfattningstitel för uppgiften. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Detta är en detaljerad beskrivning av uppgiften som behövs för forskning eller åtgärder för uppföljning. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_Start_Date]#</b>&nbsp;&nbsp;Detta är datumet då uppgiften skapades. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_completed]#</b>&nbsp;&nbsp;Detta indikerar om en uppgift är slutförd eller inte. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Den här posten anger vem som äger en forskningsuppgift. Den här kolumnen visas inte i «#pgv_lang[ra_my_tasks]#» vyn eftersom du är ägare till alla dessa uppgifter.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Om du är ägare till denna uppgift eller har administratörsrättigheter, innehåller denna post en <u>länk</u> som tar dig att redigera uppgiften, annars kommer den att vara tom.</li><li><b>#pgv_lang[ra_delete]#</b>&nbsp;&nbsp;Om du är ägaren till den här uppgiften eller har administratörsrättigheter, innehåller den här posten en <u>länk</u> som tar dig till att ta bort uppgiften, annars blir den tom.</li><li><b>#pgv_lang[ra_complete]#</b>&nbsp;&nbsp;Om du är ägare till den här uppgiften eller har administratörsrättigheter, innehåller den här posten en <u>länk</u> som tar dig till att omedelbart stänga en uppgift om den för närvarande inte är klar, annars kommer detta fält att vara tomt. Den här kolumnen kommer endast att visas i «#pgv_lang[ra_my_tasks]#» vyn eftersom du är ägare till alla dessa uppgifter.</li></ul>#pgv_lang[ra_whataretasks_words]#<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_task_view_help"]		= "<ul>~#pgv_lang[ra_view_task]#~<br /><br />#pgv_lang[ra_view_task_words]#<br /><br />Den här tabellen sammanfattar en specifik uppgift.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Detta är titeln på uppgiften.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Detta är mappen som uppgiften är grupperad i.</li><li><b>#pgv_lang[ra_assigned]#</b>&nbsp;&nbsp;Detta är forskare som uppgiften för närvarande är tilldelad.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Detta är den detaljerade beskrivningen av uppgiften som behövs för forskning eller åtgärder för uppföljning.</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Eventuella källor som behövs för forskning eller åtgärder för uppföljning av uppgiften.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Detta är en lista över personer från släktträdet som är kopplade till uppgiften. Detta fält kan innehålla flera poster. Endast personer i släktträdet visas.</li></ul><br />Om du är den tilldelade ägaren av uppgiften eller har administratörsrättigheter kommer en knapp att visas och du kan klicka på <b>#pgv_lang[ra_edit_task]#</b> för att redigera uppgifterna för uppgiften.</ul>";
$pgv_lang["ra_add_task_help"]		= "<ul>~#pgv_lang[ra_add_new_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Formulärets fält inkluderar:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Detta bör innehålla en kort sammanfattning, vanligtvis mindre än 30 tecken lång, av uppgiften som du lägger till.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;Välj mappen där du vill hantera din nya uppgift. Endast befintliga mappar visas. Om du vill tilldela den här nya uppgiften till en ny mapp måste du först använda funktionen <b>#pgv_lang[ra_add_folder]#</b> från huvudmenyn #pgv_lang[ra_RA_name]#.</li><li><b>#pgv_lang[ra_assign_task]#</b>&nbsp;&nbsp;Välj från listan över användare med redigeringsbehörighet någon som kan äga eller uppdatera uppgiften och alla poster som är kopplade till den. I allmänhet bör detta fält aldrig vara tomt (#pgv_lang[ra_mytasks_unassigned]#).</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Ange en detaljerad beskrivning av uppgiften du vill lägga till.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Bifoga eventuella källor som du har för uppgiften. Det här fältet kan innehålla flera poster.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Välj alla personer som är kopplade till denna uppgift. Detta fält kan innehålla flera poster, men endast personer från din genealogiska databas kan väljas och visas i detta fält.</li></ul><br />När du skapar en ny uppgift kan den sparas genom att klicka på knappen <b>#pgv_lang[ra_submit]#</b>, som håller den öppen och i #pgv_lang[ra_incomplete]# läget för ytterligare uppdateringar. Uppgiften kan sparas och markeras som #pgv_lang[ra_complete]# samtidigt genom att klicka på knappen <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_edit_task_help"]		= "<ul>~#pgv_lang[ra_edit_task]#~<br /><br />#pgv_lang[ra_add_task_words]#<br /><br />Formulärets fält inkluderar:<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;Detta bör innehålla titeln eller sammanfattningen av uppgiften som du redigerar.</li><li><b>#pgv_lang[ra_Folder]#</b>&nbsp;&nbsp;I det här fältet kan du välja mappen där du vill hantera din nya uppgift.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Ange en detaljerad beskrivning av uppgiften du vill lägga till.<br /><br />#pgv_lang[ra_special_char_words]#</li><li><b>#pgv_lang[ra_sources]#</b>&nbsp;&nbsp;Bifoga eventuella källor som du har för uppgiften. Detta fält kan innehålla flera poster.</li><li><b>#pgv_lang[ra_people]#</b>&nbsp;&nbsp;Välj alla personer som är kopplade till denna uppgift. Detta fält kan innehålla flera poster, men endast personer kan väljas från din genealogiska databas och visas i detta fält.</li></ul><br />Efter att ha modifierat en befintlig uppgift kan den skickas in för framtida uppdateringar genom att klicka på knappen <b>#pgv_lang[ra_save]#</b>. Uppgiften kan också sparas och markeras som #pgv_lang[ra_completed]# (inga framtida uppdateringar förväntas), genom att klicka på knappen <b>#pgv_lang[ra_save_and_complete]#</b>.</ul>";
$pgv_lang["ra_comments_help"]		= "<ul>~#pgv_lang[ra_comments]#~<br /><br />Detta kommer att innehålla alla kommentarer relaterade till en forskningsuppgift.<br /><br />När i «#pgv_lang[ra_RA_name]#» sektionen för en person, är dessa kommentarer länkade till den specifika posten för denna person och endast synliga här. Om en kommentar visas under en uppgift är den kommentaren specifik för den uppgiften. I varje fall kan det finnas flera oberoende kommentarer. Var och en kan redigeras eller raderas oberoende med den senaste kommentaren alltid visas högst upp.<br /><br />Klicka på <b>#pgv_lang[ra_add_new_comment]#</b> för att lägga till nya kommentarer till den här listan.<br /><br /><span class='warning'>Om du lägger till en ny när du redigerar en uppgift kommentera innan du sparar din redigerade uppgift, kommer alla osparade uppgiftsändringar att gå förlorade.</span></ul>";
$pgv_lang["ra_folder_view_help"]		= "<ul>~#pgv_lang[ra_Folder_View]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Det här är en lista över mappar och beskrivningar av deras användning.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Denna kolumn innehåller namnen på alla mappar på denna nivå som du har skapat. Genom att välja mappnamnet navigeras du till en ny skärm som visar eventuella undermappar och alla uppgifter som är associerade med denna mapp. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Denna kolumn innehåller en mer detaljerad beskrivning av användningen av dessa mappar. #pgv_lang[ra_sortcol_words]#</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Den här kolumnen har en <u>länk</u> för att tillåta redigering av mappens namn, beskrivning eller hierarki.</li></ul><br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_add_folder_help"]		= "<ul>~#pgv_lang[ra_Add_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Det här formuläret stöder skapandet av en ny mapp, dess användningsbeskrivning och hierarkin för andra mappar som den här mappen passar in i.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Titeln sammanfattar användningen av mappen som du lägger till.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Du kan ange om mappen är på högsta eller rotnivå (#pgv_lang[ra_No_Parent]#) eller som en undermapp till en annan mapp.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Detta är den detaljerade beskrivningen av mappen du lägger till.</li></ul>Om du klickar på knappen <b>#pgv_lang[ra_add]#</b> skickas informationen för att skapa en ny mapp. Om du klickar på knappen <b>#pgv_lang[ra_reset]#</b> ignoreras alla ändringar i beskrivningsfältet.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_edit_folder_help"]		= "<ul>~#pgv_lang[ra_Edit_folder]#~<br /><br />#pgv_lang[ra_folder_words]#<br /><br />Det här formuläret stöder redigering av en befintlig mapp, dess beskrivning av användning och hierarkin för andra mappar som denna mapp passar in i.<ul><li><b>#pgv_lang[ra_Folder_Name]#</b>&nbsp;&nbsp;Titeln sammanfattar användningen av mappen som du lägger till.</li><li><b>#pgv_lang[ra_Parent_Folder]#</b>&nbsp;&nbsp;Du kan ange om mappen är antingen på högsta nivån (#pgv_lang[ra_No_Parent]#) eller som en undermapp till en annan mapp.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Detta är den detaljerade beskrivningen av mappen du är lägga till.</li></ul><br />Knappen <b>#pgv_lang[ra_add]#</b> skickar informationen för att skapa en ny mapp. Knappen <b>#pgv_lang[ra_reset]#</b> tar bort alla ändringar i beskrivningsfältet som gjorts sedan senast sparades. När en mapp är tom visas knappen <b>#pgv_lang[ra_delete]#</b> för att tillåta borttagning av denna mapp från mapphierarkin, annars kommer du att få en varning om att radering inte är tillåten med uppgifter som fortfarande finns kvar i den.<br /><br />#pgv_lang[ra_organizetasks_words]#</ul>";
$pgv_lang["ra_auto_search_help"]		= "<ul>~#pgv_lang[ra_auto_search_text]#~<br /><br />Baserat på den valda personen kommer denna funktion automatiskt att extrahera olika viktig information och faktainformation från din genealogiska databas och låta dig bestämma vilken av dessa som ska skickas till en extern släktforskningswebbplats sökmotor. Olika webbplatser kan väljas, inklusive Ancestry, FamilySearch, Findagrave och mer. Resultaten av dessa sökningar kan användas för att lägga till eller uppdatera information i din genealogiska databas.<br /><br />När du befinner dig i «#pgv_lang[ra_RA_name]#» sektionen på en persons «#pgv_lang[personal_facts]#» sida kommer sökningen att baseras på den personen. Om den startas från huvudmenyerna #pgv_lang[ra_RA_name]# måste en person först väljas genom att klicka på personikonen för att välja en person eller ange personens identifikationsnummer i fältet.<br /><br />Välj från listan namnet på den släktforskningswebbplats du vill fråga. Du kommer att se en lista med information som kan väljas. Ange med bockmarkeringar bredvid varje objekt (namn, födelse- eller dödsdatum, etc) de objekt som kommer att skickas till den valda sökmotorn efter att <b>#pgv_lang[ra_autosearch_search]#</b> knappen har klickats. Den externa webbplatsens sökmotor lanseras på en ny sida. Använd #pgv_lang[ra_task_list]# hanteringsfunktionen för att identifiera ytterligare resultat för uppföljning.<br /><br />Observera att sökmotorer ständigt utvecklas så en gång på en släktforskningswebbplats kan de inhemska funktionerna där erbjuda fler sökkriterier som kan uppdateras för att berika din forskning.</ul>";
$pgv_lang["ra_ViewProb_help"]		= "<ul>~#pgv_lang[ra_analyze_database]#~<br /><br />Den här sidan analyserar data i din genealogiska databas och visar sambanden mellan olika dataelement.<br /><br />Till exempel kan det finnas en 95 % korrelation att efternamnet i en lokal post är detsamma som efternamnet i faderns journal. Detta skulle innebära att 95 % av personerna i denna genealogiska databas delar samma efternamn som sin far. I den här versionen av #pgv_lang[ra_RA_name]# modulen används dessa beräkningar för att hjälpa till att identifiera saknad information för en persons register. De används inte i andra delar av programmet; de tillhandahålls endast som hjälp för dig i din forskning.</ul>";
$pgv_lang["ra_GenerateTasks_help"]		= "<ul>~#pgv_lang[ra_gen_tasks]#~<br /><br />Vissa genealogiska program låter dig ange forskningsuppgifter som TODO objekt i deras databas. När de exporterar denna genealogiska information till andra program kommer de att exportera databasposterna till en fil formaterad enligt GEDCOM rekommendationen. PhpGedView mjukvaran använder den GEDCOM formaterade filen som indata, så dessa TODO objekt är inbäddade i dina data. Det här alternativet kommer att söka i din genealogiska databas och automatiskt konvertera alla importerade TODO -objekt till forskningsuppgifter.<br /><br />Om du klickar på knappen <b>#pgv_lang[ra_generate]#</b> längst ner i formuläret skapas en lista över potentiella uppgifter från importerade TODO artiklar. Från den här listan kan du välja objekt för att generera uppgifter.<ul><li><b>#pgv_lang[ra_generate]#</b>&nbsp;&nbsp;Markera varje uppgift som ska genereras och generera sedan den uppgiften.</li><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;De första 30 tecknen i uppgiftsbeskrivningen kommer att bli uppgiftens namn. Du kan ändra eller korrigera detta när du redigerar uppgiften.</li><li><b>#pgv_lang[ra_description]#</b>&nbsp;&nbsp;Beskrivningen som uppgiften kommer att ges, kopierad från den fullständiga texten i TODO-posten i din genealogiska databas. Du kan ändra eller korrigera detta när du redigerar uppgiften.</li><li><b>#pgv_lang[ra_edit]#</b>&nbsp;&nbsp;Klicka på länken för att redigera uppgiften.</li><li ><b>#pgv_lang[ra_SelectFolder]#</b>&nbsp;&nbsp;Välj mappen där de genererade uppgifterna ska placeras.</li><li><b>#pgv_lang[ra_done]#</b> &nbsp; omdirigerar dig till sidan #pgv_lang[ra_Folder_View]#.</li></ul></ul>";
$pgv_lang["ra_EditGenerateTasks_help"]	= "<ul>~#pgv_lang[ra_Edit_Gen_Task]#~<br /><br />Det här formuläret låter dig redigera uppgifterna som skapades från TODO-objekt i din genealogiska databas.<ul><li><b>#pgv_lang[ra_title]#</b>&nbsp;&nbsp;För att välja den person som du vill associera med uppgiften.</li><li><b>#pgv_lang[ra_source]#</b>&nbsp;&nbsp;Klicka på länken för att välja källan som du vill koppla uppgiften till.</li><li><b>#pgv_lang[ra_save]#</b>&nbsp;&nbsp;Spara alla dina ändringar och omdirigerar dig till sidan #pgv_lang[ra_gen_tasks]#.</li><li><b>#pgv_lang[ra_cancel]#</b>&nbsp;&nbsp;Slänger alla dina ändringar och omdirigerar dig till sidan #pgv_lang[ra_gen_tasks]#.</li></ul></ul>";
$pgv_lang["ra_configure_privacy_help"]		= "<ul>~#pgv_lang[ra_configure_privacy]#~<br /><br />Som administratör för din PhpGedView-webbplats har du möjlighet att kontrollera synligheten för olika funktioner i #pgv_lang[ra_RA_name]# modulen. hans dialogruta presenterar tillgängliga funktionsblock och ber dig att välja synlighet genom att välja åtkomstkontroller för varje.<ul><li><b>#pgv_lang[PRIV_PUBLIC]#</b>&nbsp;&nbsp;Det angivna funktionsblocket är tillgängligt för alla.</li><li><b>#pgv_lang[PRIV_USER]#</b>&nbsp;&nbsp;Det angivna funktionsblocket är endast tillgängligt för autentiserade användare.</li><li><b>#pgv_lang[PRIV_NONE]#</b>&nbsp;&nbsp;Det angivna funktionsblocket är endast tillgängligt för användare med administratörsrättigheter.</li><li><b>#pgv_lang[PRIV_HIDE]#</b>&nbsp;&nbsp;Det angivna funktionsblocket är inte tillgängligt för någon.</li></ul></ul>";
?>
