<?php
/**
 * Catalan language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.ca.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.ca.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Veure";
$pgv_lang["ra_description"]			= "Descripció";
$pgv_lang["ra_source"]			= "Font";
$pgv_lang["ra_sources"]			= "Fonts";
$pgv_lang["ra_people"]			= "Persones";
$pgv_lang["ra_comments"]			= "Comentaris";
$pgv_lang["ra_edit"]			= "Editeu";
$pgv_lang["ra_save"]			= "Desa";
$pgv_lang["ra_cancel"]			= "Cancel·la";
$pgv_lang["ra_delete"]			= "Suprimeix";
$pgv_lang["ra_no"]				= "No";
$pgv_lang["ra_yes"]				= "Sí";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Afegeix";
$pgv_lang["ra_close_window"]		= "Tanca la finestra";
$pgv_lang["ra_config_block"]			= "Ajustar";
$pgv_lang["ra_page"]			= "Pàgina";
$pgv_lang["ra_reset"]			= "Restableix";
$pgv_lang["ra_title"]			= "Títol";
$pgv_lang["ra_add_media"]			= "Afegeix un nou element multimèdia";
$pgv_lang["ra_choose_search_site"]		= "Trieu un lloc de cerca";
$pgv_lang["ra_pid_search_for"]		= "Sobre qui voleu cercar informació en llocs externs de Genealogia?";
$pgv_lang["ra_manage_research"]		= "Gestionar la investigació";
$pgv_lang["ra_analyze_database"]		= "Analitzar base de dades";
$pgv_lang["ra_analyze_data"]			= "Analitza meves dades";
$pgv_lang["ra_missing_info"] 			= "Falta informació";
$pgv_lang["ra_auto_search_text"]		= "Cerca a fonts web externes";
$pgv_lang["ra_task_list"]			= "Tasques";
$pgv_lang["ra_next"]			= "Següent";
$pgv_lang["ra_DataCorrelations"]		= "Correlacions de dades";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Meves tasques";
$pgv_lang["ra_add_task"]			= "Afegeix tasca";
$pgv_lang["ra_view_folders"]			= "Veure carpetes";
$pgv_lang["ra_view_probabilities"]		= "Veure probabilitats";
$pgv_lang["ra_up_folder"]			= "Més alt";
$pgv_lang["ra_edit_folder"]			= "Afegeix o edita carpeta";
$pgv_lang["ra_Add_folder"]			= "Afegeix carpeta";
$pgv_lang["ra_Edit_folder"]			= "Edita carpeta";
$pgv_lang["ra_gen_tasks"]			= "Crea automàticament tasques";
$pgv_lang["ra_generate"]			= "Crea";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Auxiliar de Recerca";
$pgv_lang["ra_edit_task"]			= "Edita tasca";
$pgv_lang["ra_completed"]			= "Completa";
$pgv_lang["ra_complete"]			= "Completa";
$pgv_lang["ra_incomplete"]			= "Incompleta";
$pgv_lang["ra_created"]			= "Creat";
$pgv_lang["ra_details"]			= "Detalls";
$pgv_lang["ra_result"]			= "Resultat";
$pgv_lang["ra_okay"]			= "D'acord";
$pgv_lang["ra_editform"]			= "Edita dades del formulari";
$pgv_lang["ra_FilterBy"]			= "Filtra per";
$pgv_lang["ra_Recalculate"]			= "Recalcular";
$pgv_lang["ra_LocalData"]			= "Dades locals";
$pgv_lang["ra_RelatedRecord"]		= "Registre relacionat";
$pgv_lang["ra_RelatedData"]			= "Dades relacionades";
$pgv_lang["ra_Fields"]			= "Nombre de camps";
$pgv_lang["ra_FieldName"]			= "Nom del camp";
$pgv_lang["ra_InputType"]			= "Tipus d'entrada";
$pgv_lang["ra_FormBuilder"]			= "Creador de formularis";
$pgv_lang["ra_FormName"]			= "Introduïu el nom del formulari";
$pgv_lang["ra_MultiplePeople"]		= "El formulari s'aplica a diverses persones?";
$pgv_lang["ra_FormDescription"]		= "Introduïu una descripció del formulari";
$pgv_lang["ra_FormGeneration"]		= "Creació del formulari completada!";
$pgv_lang["ra_CustomField"]			= "Nom del camp personalitzat";
$pgv_lang["ra_txt"]				= "Text";
$pgv_lang["ra_checkbox"]			= "Casilla";
$pgv_lang["ra_radiobutton"]			= "Botó de ràdio";
$pgv_lang["ra_EnterResults"]			= "Introduïu els resultats";
$pgv_lang["ra_generate_tasks"]		= "Crea tasques des de TODO";
$pgv_lang["ra_SelectFolder"]			= "Trieu carpeta";
$pgv_lang["ra_done"]			= "Fet";
$pgv_lang["ra_LocalPercent"]			= "Percentatge local";
$pgv_lang["ra_GlobalPercent"]		= "Percentatge global";
$pgv_lang["ra_Average"]			= "Mitjana";
$pgv_lang["ra_NoData"]			= "Sense dades!";
$pgv_lang["ra_NotEnoughData"]		= "No hi ha prou dades!";
$pgv_lang["ra_IncompleteDate"]	= "Data incompleta <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Hi ha un %PERCENT% de possibilitats que el lloc de naixement sigui és&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Hi ha un %PERCENT% de possibilitats que el lloc de la mort sigui és&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Hi ha un %PERCENT% de possibilitats que el cognom sigui és&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Hi ha un %PERCENT% de possibilitats que el lloc del matrimoni sigui és&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Hi ha un %PERCENT% de possibilitats que el nom sigui és&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Tots";
$pgv_lang["ra_More"]			= "Més";
$pgv_lang["ra_ThereIsChance"]		= "Les possibles fonts poden incloure";
$pgv_lang["ra_TheMostLikely"]		= "El lloc més probable per a aquesta font és&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Carpeta";
$pgv_lang["ra_Edit_Gen_Task"]		= "Edita la tasca generada";
$pgv_lang["ra_Start_Date"]			= "Data d'inici";
$pgv_lang["ra_Folder_View"]			= "Vista de carpeta";
$pgv_lang["ra_Task_View"]			= "Vista de tasques";
$pgv_lang["ra_page_header"]			= "Carpetes ".$pgv_lang["ra_RA_name"];
$pgv_lang["ra_no_folder_name"]		= "El camp del nom de la carpeta s'ha d'omplir.";
$pgv_lang["ra_add_folder"]			= "Afegeix una carpeta";
$pgv_lang["ra_Folder_Name"]			= "Nom de la carpeta";
$pgv_lang["ra_Parent_Folder"]		= "Carpeta pare";
$pgv_lang["ra_No_Parent"]			= "No hi ha carpeta parer";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Els noms de les carpetes han de ser únics.";
$pgv_lang["ra_folder_submitted"]		= "S'ha enviat la teva carpeta";
$pgv_lang["ra_folder_problem"]		= "S'ha produït un problema en afegir la vostra carpeta, torneu-ho a provar";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Crea una tasca nova";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "No existeix cap carpeta. Creeu una carpeta nova primer.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Veure la tasca";
$pgv_lang["ra_no_indi_tasks"]		= "No hi ha cap tasca associada amb aquesta persona";
$pgv_lang["ra_no_sour_tasks"]		= "No hi ha cap tasca associada amb aquesta font";
$pgv_lang["ra_assigned"]			= "Assignat";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Afegeix una tasca nova";
$pgv_lang["ra_submit"]			= "Envia";
$pgv_lang["ra_save_and_complete"]		= "Guarda i completa";
$pgv_lang["ra_assign_task"]			= "Assigna una tasca";
$pgv_lang["ra_AddTask"]			= "Afegeix una tasca";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Comenta";
$pgv_lang["ra_add_new_comment"]		= "Afegeix un nou comentari";
$pgv_lang["ra_edit_comment"]		= "Edita el comentari";
$pgv_lang["ra_comment_success"]		= "El teu comentari s'ha afegit correctament.";
$pgv_lang["ra_comment_delete_check"]	= "Esteu segur que voleu suprimir aquest comentari?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Configura Privadesa";
$pgv_lang["ra_show_my_tasks"]		= "Mostra «Meves tasques»";
$pgv_lang["ra_show_add_task"]		= "Mostra «Afegeix una tasca»";
$pgv_lang["ra_show_auto_gen_task"]		= "Mostra «Generació automàtica de tasca»";
$pgv_lang["ra_show_view_folders"]		= "Mostra «Mostra les carpetes»";
$pgv_lang["ra_show_add_folder"]		= "Mostra «Afegeix una carpeta»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Mostra «Afegeix una font sense enllaç»";
$pgv_lang["ra_show_view_probabilities"]	= "Mostra «Veure probabilitats»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Nombre de files";
$pgv_lang["ra_state"]			= "Estat";
$pgv_lang["ra_call/url"]			= "Número de catàleg o URL";
$pgv_lang["ra_enumDate"]			= "Data d'enumeració";
$pgv_lang["ra_county"]			= "Comtat";
$pgv_lang["ra_city"]			= "Ciutat";
$pgv_lang["ra_complete_title"]		= "Completa una tasca";
$pgv_lang["ra_select_form"]			= "Trieu Formulari";
$pgv_lang["ra_choose_form_label"]		= "Trieu el formulari de recerca conjunta";
$pgv_lang["ra_book"]			= "Llibre";
$pgv_lang["ra_folio"]			= "Foli";
$pgv_lang["ra_uk_county"]			= "Comtat";
$pgv_lang["ra_uk_boro"]			= "Ciutat o districte";
$pgv_lang["ra_uk_place"]			= "Lloc";

$pgv_lang["ra_AssIndiFacts"]			= "Associar-se Fets de la persona";
$pgv_lang["ra_AssFamFacts"]			= "Associar-se Fets familiars";
$pgv_lang["ra_facts"]			= "Fets";
$pgv_lang["ra_fact"]			= "Fet";
$pgv_lang["ra_remove"]			= "eliminar";
$pgv_lang["ra_inferred_facts"]		= "Fets inferits";
$pgv_lang["ra_person"]			= "Persona";
$pgv_lang["ra_reason"]			= "Raó";
$pgv_lang["ra_success"]			= "Èxit!";

$pgv_lang["ra_registration_number"]		= "Número de registre";
$pgv_lang["ra_serial_number"]		= "Número de sèrie";
$pgv_lang["ra_number"]			= "Número";
$pgv_lang["ra_order_number"]		= "Número de comanda";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Edita";
$pgv_lang["ra_mytasks_unassigned"]		= "No assignade";
$pgv_lang["ra_mytask_show_tasks"]		= "Mostra les tasques no assignades?";
$pgv_lang["ra_mytask_show_completed"]	= "Mostra les tasques completades?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Cognom";
$pgv_lang["ra_autosearch_givenname"]		= "Noms de pila";
$pgv_lang["ra_autosearch_fullname"]		= "Nom";
$pgv_lang["ra_autosearch_firstname"]		= "Nom de pila";
$pgv_lang["ra_autosearch_middlename"]	= "Mitjans noms";
$pgv_lang["ra_autosearch_byear"]		= "Any de naixement";
$pgv_lang["ra_autosearch_bloc"]		= "Lloc de naixement";
$pgv_lang["ra_autosearch_myear"]		= "Any de matrimoni";
$pgv_lang["ra_autosearch_mloc"]		= "Lloc del matrimoni";
$pgv_lang["ra_autosearch_dyear"]		= "Any de la mort";
$pgv_lang["ra_autosearch_dloc"]		= "Lloc de la mort";
$pgv_lang["ra_autosearch_gender"]		= "Gènere";
$pgv_lang["ra_autosearch_ssurname"]		= "Cognom del cònjuge";
$pgv_lang["ra_autosearch_sgivennames"]	= "Noms de pila del cònjuge";
$pgv_lang["ra_autosearch_sfullname"]		= "Nom del cònjuge";
$pgv_lang["ra_autosearch_fsurname"]		= "Cognom del pare";
$pgv_lang["ra_autosearch_fgivennames"]	= "Noms de pila del pare";
$pgv_lang["ra_autosearch_ffullname"]		= "Nom del pare";
$pgv_lang["ra_autosearch_msurname"]		= "Cognom de la mare";
$pgv_lang["ra_autosearch_mgivennames"]	= "Noms de pila de la mare";
$pgv_lang["ra_autosearch_mfullname"]		= "Nom de la mare";
$pgv_lang["ra_autosearch_country"]		= "País";
$pgv_lang["ra_autosearch_cemetery"]		= "Cementiri";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Connector";
$pgv_lang["ra_autosearch_search"]		= "Cerca";
$pgv_lang["ra_autosearch_keywords"]		= "Paraules clau";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "La carpeta conté tasques i no es pot suprimir";
$pgv_lang["ra_has_folders"]			= "La carpeta compta amb carpetes i no es pot suprimir";
?>
