<?php
/**
 * German language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.de.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.de.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Sehen";
$pgv_lang["ra_description"]			= "Beschreibung";
$pgv_lang["ra_source"]			= "Quelle";
$pgv_lang["ra_sources"]			= "Quellen";
$pgv_lang["ra_people"]			= "Personen";
$pgv_lang["ra_comments"]			= "Kommentare";
$pgv_lang["ra_edit"]			= "Bearbeiten";
$pgv_lang["ra_save"]			= "Speichern";
$pgv_lang["ra_cancel"]			= "Abbrechen";
$pgv_lang["ra_delete"]			= "Löschen";
$pgv_lang["ra_no"]				= "Nein";
$pgv_lang["ra_yes"]				= "Ja";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Hinzufügen";
$pgv_lang["ra_close_window"]		= "Fenster schließen";
$pgv_lang["ra_config_block"]			= "Anpassen";
$pgv_lang["ra_page"]			= "Seite";
$pgv_lang["ra_reset"]			= "Zurücksetzen";
$pgv_lang["ra_title"]			= "Titel";
$pgv_lang["ra_add_media"]			= "Neues Medienobjekt hinzufügen";
$pgv_lang["ra_choose_search_site"]		= "Suchsite wählen";
$pgv_lang["ra_pid_search_for"]		= "Über wen möchten Sie auf externen Genealogie-Websites nach Informationen suchen?";
$pgv_lang["ra_manage_research"]		= "Forschung verwalten";
$pgv_lang["ra_analyze_database"]		= "Datenbank analysieren";
$pgv_lang["ra_analyze_data"]			= "Meine Daten analysieren";
$pgv_lang["ra_missing_info"] 			= "Fehlende Informationen";
$pgv_lang["ra_auto_search_text"]		= "Externe Webquellen durchsuchen";
$pgv_lang["ra_task_list"]			= "Aufgaben";
$pgv_lang["ra_next"]			= "Nächster";
$pgv_lang["ra_DataCorrelations"]		= "Datenkorrelationen";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Meine Aufgaben";
$pgv_lang["ra_add_task"]			= "Aufgabe hinzufügen";
$pgv_lang["ra_view_folders"]			= "Ordner zeigen";
$pgv_lang["ra_view_probabilities"]		= "Wahrscheinlichkeiten zeigen";
$pgv_lang["ra_up_folder"]			= "Höher";
$pgv_lang["ra_edit_folder"]			= "Ordner hinzufügen oder bearbeiten";
$pgv_lang["ra_Add_folder"]			= "Ordner hinzufügen";
$pgv_lang["ra_Edit_folder"]			= "Ordner bearbeiten";
$pgv_lang["ra_gen_tasks"]			= "Aufgaben automatisch erstellen";
$pgv_lang["ra_generate"]			= "Erstellen";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Forschungsassistent";
$pgv_lang["ra_edit_task"]			= "Aufgabe bearbeiten";
$pgv_lang["ra_completed"]			= "Vollendet";
$pgv_lang["ra_complete"]			= "Vollendet";
$pgv_lang["ra_incomplete"]			= "Unvollendet";
$pgv_lang["ra_created"]			= "Erstellt";
$pgv_lang["ra_details"]			= "Details";
$pgv_lang["ra_result"]			= "Resultat";
$pgv_lang["ra_okay"]			= "Okay";
$pgv_lang["ra_editform"]			= "Formulardaten bearbeiten";
$pgv_lang["ra_FilterBy"]			= "Filtern nach";
$pgv_lang["ra_Recalculate"]			= "Neu berechnen";
$pgv_lang["ra_LocalData"]			= "Lokale Daten";
$pgv_lang["ra_RelatedRecord"]		= "Zugehöriger Datensatz";
$pgv_lang["ra_RelatedData"]			= "Zugehörige Daten";
$pgv_lang["ra_Fields"]			= "Anzahl der Felder";
$pgv_lang["ra_FieldName"]			= "Feldname";
$pgv_lang["ra_InputType"]			= "Eingabetyp";
$pgv_lang["ra_FormBuilder"]			= "Formularersteller";
$pgv_lang["ra_FormName"]			= "Den Formularnamen eingeben";
$pgv_lang["ra_MultiplePeople"]		= "Gilt das Formular für mehrere Personen?";
$pgv_lang["ra_FormDescription"]		= "Die Beschreibung des Formulars eingeben";
$pgv_lang["ra_FormGeneration"]		= "Formularerstellung abgeschlossen!";
$pgv_lang["ra_CustomField"]			= "Benutzerdefinierter Feldname";
$pgv_lang["ra_txt"]				= "Text";
$pgv_lang["ra_checkbox"]			= "Kästchen";
$pgv_lang["ra_radiobutton"]			= "Radioknopf";
$pgv_lang["ra_EnterResults"]			= "Ergebnisse eingeben";
$pgv_lang["ra_generate_tasks"]		= "Aufgaben aus TODO erstellen";
$pgv_lang["ra_SelectFolder"]			= "Ordner wählen";
$pgv_lang["ra_done"]			= "Fertig";
$pgv_lang["ra_LocalPercent"]			= "Lokaler Prozentsatz";
$pgv_lang["ra_GlobalPercent"]		= "Globaler Prozentsatz";
$pgv_lang["ra_Average"]			= "Durchschnitt";
$pgv_lang["ra_NoData"]			= "Keine Daten!";
$pgv_lang["ra_NotEnoughData"]		= "Nicht genügend Daten!";
$pgv_lang["ra_IncompleteDate"]	= "Unvollständiges Datum <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Es besteht eine Wahrscheinlichkeit von %PERCENT%, dass der Geburtsort&nbsp;<i>%INF_FACT%</i>&nbsp;ist.";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Es besteht eine Wahrscheinlichkeit von %PERCENT%, dass der Sterbeort&nbsp;<i>%INF_FACT%</i>&nbsp;ist.";
$pgv_lang["ra_InferIndvSurn"]			= "Es besteht eine Wahrscheinlichkeit von %PERCENT%, dass der Nachname&nbsp;<i>%INF_FACT%</i>&nbsp;ist.";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Es besteht eine Wahrscheinlichkeit von %PERCENT%, dass der Ort der Trauung&nbsp;<i>%INF_FACT%</i>&nbsp;ist.";
$pgv_lang["ra_InferIndvGivn"]			= "Es besteht eine Wahrscheinlichkeit von %PERCENT%, dass der Vornamename&nbsp;<i>%INF_FACT%</i>&nbsp;ist.";
$pgv_lang["ra_All"]				= "Alle";
$pgv_lang["ra_More"]			= "Mehr";
$pgv_lang["ra_ThereIsChance"]		= "Mögliche Quellen können sein";
$pgv_lang["ra_TheMostLikely"]		= "Der wahrscheinlichste Ort für diese Quelle&nbsp;<i>%INF_FACT%</i>&nbsp;ist.";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Ordner";
$pgv_lang["ra_Edit_Gen_Task"]		= "Generierte Aufgabe bearbeiten";
$pgv_lang["ra_Start_Date"]			= "Startdatum";
$pgv_lang["ra_Folder_View"]			= "Ordneransicht";
$pgv_lang["ra_Task_View"]			= "Aufgabenansicht";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Ordner";
$pgv_lang["ra_no_folder_name"]		= "Das Feld »Ordnername« muss ausgefüllt werden.";
$pgv_lang["ra_add_folder"]			= "Ordner hinzufügen";
$pgv_lang["ra_Folder_Name"]			= "Ordnername";
$pgv_lang["ra_Parent_Folder"]		= "Übergeordneter Ordner";
$pgv_lang["ra_No_Parent"]			= "Kein übergeordneter Ordner";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Ordnernamen müssen eindeutig sein.";
$pgv_lang["ra_folder_submitted"]		= "Ihr Ordner wurde übermittelt";
$pgv_lang["ra_folder_problem"]		= "Beim Hinzufügen Ihres Ordners ist ein Problem aufgetreten. Bitte versuchen Sie es erneut.";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Neue Aufgabe erstellen";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Es ist kein Ordner vorhanden. Erstellen Sie zuerst einen neuen Ordner.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Aufgabe zeigen";
$pgv_lang["ra_no_indi_tasks"]		= "Dieser Person sind keine Aufgaben zugeordnet";
$pgv_lang["ra_no_sour_tasks"]		= "Mit dieser Quelle sind keine Aufgaben verknüpft";
$pgv_lang["ra_assigned"]			= "Zugewiesen";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Neue Aufgabe hinzufügen";
$pgv_lang["ra_submit"]			= "Einreichen";
$pgv_lang["ra_save_and_complete"]		= "Speichern und abschließen";
$pgv_lang["ra_assign_task"]			= "Aufgabe zuweisen";
$pgv_lang["ra_AddTask"]			= "Aufgabe hinzufügen";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Kommentar";
$pgv_lang["ra_add_new_comment"]		= "Neuen Kommentar hinzufügen";
$pgv_lang["ra_edit_comment"]		= "Kommentar bearbeiten";
$pgv_lang["ra_comment_success"]		= "Ihr Kommentar wurde erfolgreich hinzugefügt.";
$pgv_lang["ra_comment_delete_check"]	= "Möchten Sie diesen Kommentar wirklich löschen?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Datenschutz konfigurieren";
$pgv_lang["ra_show_my_tasks"]		= "Zeige »Meine Aufgaben«";
$pgv_lang["ra_show_add_task"]		= "Zeige »Aufgabe hinzufügen«";
$pgv_lang["ra_show_auto_gen_task"]		= "Zeige »Aufgabe automatisch erstellen";
$pgv_lang["ra_show_view_folders"]		= "Zeige »Ordner zeigen«";
$pgv_lang["ra_show_add_folder"]		= "Zeige »Ordner hinzufügen«";
$pgv_lang["ra_show_add_unlinked_source"]	= "Zeige »Nicht verknüpfte Quelle hinzufügen«";
$pgv_lang["ra_show_view_probabilities"]	= "Zeige »Wahrscheinlichkeiten zeigen«";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Anzahl der Zeilen";
$pgv_lang["ra_state"]			= "Staat";
$pgv_lang["ra_call/url"]			= "Katalognummer oder URL";
$pgv_lang["ra_enumDate"]			= "Zähldatum";
$pgv_lang["ra_county"]			= "County";
$pgv_lang["ra_city"]			= "Stadt";
$pgv_lang["ra_complete_title"]		= "Aufgabe erledigen";
$pgv_lang["ra_select_form"]			= "Formular wählen";
$pgv_lang["ra_choose_form_label"]		= "Gemeinsames Forschungsformular wählen";
$pgv_lang["ra_book"]			= "Buch";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "County";
$pgv_lang["ra_uk_boro"]			= "Stadt oder Ortsteil";
$pgv_lang["ra_uk_place"]			= "Ort";

$pgv_lang["ra_AssIndiFacts"]			= "Personendaten zuordnen";
$pgv_lang["ra_AssFamFacts"]			= "Familienfakten zuordnen";
$pgv_lang["ra_facts"]			= "Fakten";
$pgv_lang["ra_fact"]			= "Faktum";
$pgv_lang["ra_remove"]			= "entfernen";
$pgv_lang["ra_inferred_facts"]		= "Abgeleitete Fakten";
$pgv_lang["ra_person"]			= "Person";
$pgv_lang["ra_reason"]			= "Grund";
$pgv_lang["ra_success"]			= "Erfolg!";

$pgv_lang["ra_registration_number"]		= "Registrierungsnummer";
$pgv_lang["ra_serial_number"]		= "Seriennummer";
$pgv_lang["ra_number"]			= "Nummer";
$pgv_lang["ra_order_number"]		= "Bestellnummer";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Bearbeiten";
$pgv_lang["ra_mytasks_unassigned"]		= "Nicht zugewiesen";
$pgv_lang["ra_mytask_show_tasks"]		= "Nicht zugewiesene Aufgaben zeigen?";
$pgv_lang["ra_mytask_show_completed"]	= "Erledigte Aufgaben zeigen?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Nachname";
$pgv_lang["ra_autosearch_givenname"]		= "Vornamen";
$pgv_lang["ra_autosearch_fullname"]		= "Name";
$pgv_lang["ra_autosearch_firstname"]		= "Vorname";
$pgv_lang["ra_autosearch_middlename"]	= "Zweitnamen";
$pgv_lang["ra_autosearch_byear"]		= "Geburtsjahr";
$pgv_lang["ra_autosearch_bloc"]		= "Geburtsort";
$pgv_lang["ra_autosearch_myear"]		= "Ehejahr";
$pgv_lang["ra_autosearch_mloc"]		= "Eheort";
$pgv_lang["ra_autosearch_dyear"]		= "Todesjahr";
$pgv_lang["ra_autosearch_dloc"]		= "Sterbeort";
$pgv_lang["ra_autosearch_gender"]		= "Geschlecht";
$pgv_lang["ra_autosearch_ssurname"]		= "Ehepartners Nachname";
$pgv_lang["ra_autosearch_sgivennames"]	= "Ehepartners Vornamen";
$pgv_lang["ra_autosearch_sfullname"]		= "Ehepartners Name";
$pgv_lang["ra_autosearch_fsurname"]		= "Vaters Nachname";
$pgv_lang["ra_autosearch_fgivennames"]	= "Vaters Vornamen";
$pgv_lang["ra_autosearch_ffullname"]		= "Vaters Name";
$pgv_lang["ra_autosearch_msurname"]		= "Mutters Nachname";
$pgv_lang["ra_autosearch_mgivennames"]	= "Mutters Vornamen";
$pgv_lang["ra_autosearch_mfullname"]		= "Mutters Name";
$pgv_lang["ra_autosearch_country"]		= "Land";
$pgv_lang["ra_autosearch_cemetery"]		= "Friedhof";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Suchen";
$pgv_lang["ra_autosearch_keywords"]		= "Schlagwörter";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "Der Ordner enthält Aufgaben und kann nicht gelöscht werden";
$pgv_lang["ra_has_folders"]			= "Der Ordner enthält Ordner und kann nicht gelöscht werden";
?>
