<?php
/**
 * English language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.en.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.en.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "View";
$pgv_lang["ra_description"]			= "Description";
$pgv_lang["ra_source"]			= "Source";
$pgv_lang["ra_sources"]			= "Sources";
$pgv_lang["ra_people"]			= "Persons";
$pgv_lang["ra_comments"]			= "Comments";
$pgv_lang["ra_edit"]			= "Edit";
$pgv_lang["ra_save"]			= "Save";
$pgv_lang["ra_cancel"]			= "Cancel";
$pgv_lang["ra_delete"]			= "Delete";
$pgv_lang["ra_no"]				= "No";
$pgv_lang["ra_yes"]				= "Yes";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Add";
$pgv_lang["ra_close_window"]		= "Close Window";
$pgv_lang["ra_config_block"]			= "Configure";
$pgv_lang["ra_page"]			= "Page";
$pgv_lang["ra_reset"]			= "Reset";
$pgv_lang["ra_title"]			= "Title";
$pgv_lang["ra_add_media"]			= "Add a new Media item";
$pgv_lang["ra_choose_search_site"]		= "Choose a search site";
$pgv_lang["ra_pid_search_for"]		= "About whom do you want to search external Genealogy sites for information?";
$pgv_lang["ra_manage_research"]		= "Manage Research";
$pgv_lang["ra_analyze_database"]		= "Analyze Database";
$pgv_lang["ra_analyze_data"]			= "Analyze My Data";
$pgv_lang["ra_missing_info"] 			= "Missing Information";
$pgv_lang["ra_auto_search_text"]		= "Search External Web Sources";
$pgv_lang["ra_task_list"]			= "Tasks";
$pgv_lang["ra_next"]			= "Next";
$pgv_lang["ra_DataCorrelations"]		= "Data Correlations";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "My Tasks";
$pgv_lang["ra_add_task"]			= "Add Task";
$pgv_lang["ra_view_folders"]			= "View Folders";
$pgv_lang["ra_view_probabilities"]		= "View Probabilities";
$pgv_lang["ra_up_folder"]			= "Up Folder";
$pgv_lang["ra_edit_folder"]			= "Add or Edit Folder";
$pgv_lang["ra_Add_folder"]			= "Add Folder";
$pgv_lang["ra_Edit_folder"]			= "Edit Folder";
$pgv_lang["ra_gen_tasks"]			= "Auto Generate Tasks";
$pgv_lang["ra_generate"]			= "Generate";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]			= "Research Assistant";
$pgv_lang["ra_edit_task"]			= "Edit Task";
$pgv_lang["ra_completed"]			= "Completed";
$pgv_lang["ra_complete"]			= "Complete";
$pgv_lang["ra_incomplete"]			= "Incomplete";
$pgv_lang["ra_created"]			= "Created";
$pgv_lang["ra_details"]			= "Details";
$pgv_lang["ra_result"]			= "Result";
$pgv_lang["ra_okay"]			= "Okay";
$pgv_lang["ra_editform"]			= "Edit Form Data";
$pgv_lang["ra_FilterBy"]			= "Filter By";
$pgv_lang["ra_Recalculate"]			= "Recalculate";
$pgv_lang["ra_LocalData"]			= "Local Data";
$pgv_lang["ra_RelatedRecord"]		= "Related Record";
$pgv_lang["ra_RelatedData"]			= "Related Data";
$pgv_lang["ra_Fields"]			= "Number of Fields";
$pgv_lang["ra_FieldName"]			= "Field Name";
$pgv_lang["ra_InputType"]			= "Input Type";
$pgv_lang["ra_FormBuilder"]			= "FormBuilder";
$pgv_lang["ra_FormName"]			= "Enter the form name";
$pgv_lang["ra_MultiplePeople"]		= "Does the form apply to multiple persons?";
$pgv_lang["ra_FormDescription"]		= "Please enter a description of the form";
$pgv_lang["ra_FormGeneration"]		= "Form Generation Complete!";
$pgv_lang["ra_CustomField"]			= "Custom Field Name";
$pgv_lang["ra_txt"]				= "Text";
$pgv_lang["ra_checkbox"]			= "Check Box";
$pgv_lang["ra_radiobutton"]			= "Radio Button";
$pgv_lang["ra_EnterResults"]			= "Enter Results";
$pgv_lang["ra_generate_tasks"]		= "Generate Tasks from TODO";
$pgv_lang["ra_SelectFolder"]			= "Select Folder";
$pgv_lang["ra_done"]			= "Done";
$pgv_lang["ra_LocalPercent"]			= "Local Percentage";
$pgv_lang["ra_GlobalPercent"]		= "Global Percentage";
$pgv_lang["ra_Average"]			= "Average";
$pgv_lang["ra_NoData"]			= "No Data!";
$pgv_lang["ra_NotEnoughData"]		= "Not Enough Data!";
$pgv_lang["ra_IncompleteDate"]	= "Incomplete Date <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "There is a %PERCENT% chance that the birth place is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "There is a %PERCENT% chance that the death place is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "There is a %PERCENT% chance that the surname is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]		= "There is a %PERCENT% chance that the marriage place is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "There is a %PERCENT% chance that the given name is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "All";
$pgv_lang["ra_More"]			= "More";
$pgv_lang["ra_ThereIsChance"]		= "Possible Sources may include";
$pgv_lang["ra_TheMostLikely"]		= "The most likely place for this source is&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Folder";
$pgv_lang["ra_Edit_Gen_Task"]		= "Edit Generated Task";
$pgv_lang["ra_Start_Date"]			= "Start Date";
$pgv_lang["ra_Folder_View"]			= "Folder View";
$pgv_lang["ra_Task_View"]			= "Task View";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Folders";
$pgv_lang["ra_no_folder_name"]		= "Folder name field must be filled in.";
$pgv_lang["ra_add_folder"]			= "Add Folder";
$pgv_lang["ra_Folder_Name"]			= "Folder Name";
$pgv_lang["ra_Parent_Folder"]		= "Parent Folder";
$pgv_lang["ra_No_Parent"]			= "No Parent Folder";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Folder names must be unique.";
$pgv_lang["ra_folder_submitted"]		= "Your folder has been submitted";
$pgv_lang["ra_folder_problem"]		= "There has a been problem with adding your folder, please try again";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Create new task";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "No folder exists. Please create a new folder first.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "View Task";
$pgv_lang["ra_no_indi_tasks"]		= "No tasks are associated with this person";
$pgv_lang["ra_no_sour_tasks"]		= "No tasks are associated with this source";
$pgv_lang["ra_assigned"]			= "Assigned";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Add New Task";
$pgv_lang["ra_submit"]			= "Submit";
$pgv_lang["ra_save_and_complete"]		= "Save and Complete";
$pgv_lang["ra_assign_task"]			= "Assign Task";
$pgv_lang["ra_AddTask"]			= "Add Task";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Comment";
$pgv_lang["ra_add_new_comment"]		= "Add New Comment";
$pgv_lang["ra_edit_comment"]		= "Edit Comment";
$pgv_lang["ra_comment_success"]		= "Your comment was successfully added.";
$pgv_lang["ra_comment_delete_check"]	= "Are you sure you want to delete this comment?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Configure Privacy";
$pgv_lang["ra_show_my_tasks"]		= "Show «My Tasks»";
$pgv_lang["ra_show_add_task"]		= "Show «Add Task»";
$pgv_lang["ra_show_auto_gen_task"]		= "Show «Auto Generate Task»";
$pgv_lang["ra_show_view_folders"]		= "Show «View Folders»";
$pgv_lang["ra_show_add_folder"]		= "Show «Add Folder»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Show «Add Unlinked Source»";
$pgv_lang["ra_show_view_probabilities"]	= "Show «View Probabilities»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Number of Rows";
$pgv_lang["ra_state"]			= "State";
$pgv_lang["ra_call/url"]			= "Catalog number or URL";
$pgv_lang["ra_enumDate"]			= "Enumeration Date";
$pgv_lang["ra_county"]			= "County";
$pgv_lang["ra_city"]			= "City";
$pgv_lang["ra_complete_title"]		= "Complete A Task";
$pgv_lang["ra_select_form"]			= "Select Form";
$pgv_lang["ra_choose_form_label"]		= "Choose a common research form";
$pgv_lang["ra_book"]			= "Book";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "County";
$pgv_lang["ra_uk_boro"]			= "City or Borough";
$pgv_lang["ra_uk_place"]			= "Place";

$pgv_lang["ra_AssIndiFacts"]			= "Associate Person Facts";
$pgv_lang["ra_AssFamFacts"]			= "Associate Family Facts";
$pgv_lang["ra_facts"]			= "Facts";
$pgv_lang["ra_fact"]			= "Fact";
$pgv_lang["ra_remove"]			= "remove";
$pgv_lang["ra_inferred_facts"]		= "Inferred Facts";
$pgv_lang["ra_person"]			= "Person";
$pgv_lang["ra_reason"]			= "Reason";
$pgv_lang["ra_success"]			= "Success!";

$pgv_lang["ra_registration_number"]		= "Registration Number";
$pgv_lang["ra_serial_number"]		= "Serial Number";
$pgv_lang["ra_number"]			= "Number";
$pgv_lang["ra_order_number"]		= "Order Number";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Edit";
$pgv_lang["ra_mytasks_unassigned"]		= "Unassigned";
$pgv_lang["ra_mytask_show_tasks"]		= "Show unassigned tasks?";
$pgv_lang["ra_mytask_show_completed"]	= "Show completed tasks?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Surname";
$pgv_lang["ra_autosearch_givenname"]		= "Given names";
$pgv_lang["ra_autosearch_fullname"]		= "Name";
$pgv_lang["ra_autosearch_firstname"]		= "First name";
$pgv_lang["ra_autosearch_middlename"]	= "Middle names";
$pgv_lang["ra_autosearch_byear"]		= "Birth year";
$pgv_lang["ra_autosearch_bloc"]		= "Birth place";
$pgv_lang["ra_autosearch_myear"]		= "Marriage year";
$pgv_lang["ra_autosearch_mloc"]		= "Marriage place";
$pgv_lang["ra_autosearch_dyear"]		= "Death year";
$pgv_lang["ra_autosearch_dloc"]		= "Death place";
$pgv_lang["ra_autosearch_gender"]		= "Gender";
$pgv_lang["ra_autosearch_ssurname"]		= "Spouse's surname";
$pgv_lang["ra_autosearch_sgivennames"]	= "Spouse's given names";
$pgv_lang["ra_autosearch_sfullname"]		= "Spouse's name";
$pgv_lang["ra_autosearch_fsurname"]		= "Father's surname";
$pgv_lang["ra_autosearch_fgivennames"]	= "Father's given names";
$pgv_lang["ra_autosearch_ffullname"]		= "Father's name";
$pgv_lang["ra_autosearch_msurname"]		= "Mother's surname";
$pgv_lang["ra_autosearch_mgivennames"]	= "Mother's given names";
$pgv_lang["ra_autosearch_mfullname"]		= "Mother's name";
$pgv_lang["ra_autosearch_country"]		= "Country";
$pgv_lang["ra_autosearch_cemetery"]		= "Cemetery";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Search";
$pgv_lang["ra_autosearch_keywords"]		= "Keywords";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "The folder contains tasks and cannot be deleted";
$pgv_lang["ra_has_folders"]			= "The folder contains folders and cannot be deleted";
?>
