<?php
/**
 * French language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.fr.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.fr.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Voir";
$pgv_lang["ra_description"]			= "Description";
$pgv_lang["ra_source"]			= "Source";
$pgv_lang["ra_sources"]			= "Sources";
$pgv_lang["ra_people"]			= "Personnes";
$pgv_lang["ra_comments"]			= "Commentaires";
$pgv_lang["ra_edit"]			= "Modifier";
$pgv_lang["ra_save"]			= "Retenir";
$pgv_lang["ra_cancel"]			= "Annuler";
$pgv_lang["ra_delete"]			= "Supprimer";
$pgv_lang["ra_no"]				= "Non";
$pgv_lang["ra_yes"]				= "Oui";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Ajouter";
$pgv_lang["ra_close_window"]		= "Fermer la fenêtre";
$pgv_lang["ra_config_block"]			= "Personnaliser";
$pgv_lang["ra_page"]			= "Page";
$pgv_lang["ra_reset"]			= "Réinitialiser";
$pgv_lang["ra_title"]			= "Titre";
$pgv_lang["ra_add_media"]			= "Ajouter un nouvel élément multimédia";
$pgv_lang["ra_choose_search_site"]		= "Choisissez un site de recherche";
$pgv_lang["ra_pid_search_for"]		= "À propos de qui souhaitez-vous rechercher des informations sur des sites de généalogie externes&nbsp;?";
$pgv_lang["ra_manage_research"]		= "Gérer la recherche";
$pgv_lang["ra_analyze_database"]		= "Analyser la base de données";
$pgv_lang["ra_analyze_data"]			= "Analyser mes données";
$pgv_lang["ra_missing_info"] 			= "Informations manquantes";
$pgv_lang["ra_auto_search_text"]		= "Rechercher dans des sources Web externes";
$pgv_lang["ra_task_list"]			= "Tâches";
$pgv_lang["ra_next"]			= "Suivant";
$pgv_lang["ra_DataCorrelations"]		= "Corrélations de données";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= "&nbsp;:";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Mes tâches";
$pgv_lang["ra_add_task"]			= "Ajouter tâche";
$pgv_lang["ra_view_folders"]			= "Afficher dossiers";
$pgv_lang["ra_view_probabilities"]		= "Afficher probabilités";
$pgv_lang["ra_up_folder"]			= "Plus haut";
$pgv_lang["ra_edit_folder"]			= "Ajouter ou modifier dossier";
$pgv_lang["ra_Add_folder"]			= "Ajouter dossier";
$pgv_lang["ra_Edit_folder"]			= "Modifier dossier";
$pgv_lang["ra_gen_tasks"]			= "Créer automatiquement des tâches";
$pgv_lang["ra_generate"]			= "Créer";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Assistante de Recherche";
$pgv_lang["ra_edit_task"]			= "Modifier tâche";
$pgv_lang["ra_completed"]			= "Complète";
$pgv_lang["ra_complete"]			= "Complète";
$pgv_lang["ra_incomplete"]			= "Incomplète";
$pgv_lang["ra_created"]			= "Crée";
$pgv_lang["ra_details"]			= "Détails";
$pgv_lang["ra_result"]			= "Résultat";
$pgv_lang["ra_okay"]			= "D'accord";
$pgv_lang["ra_editform"]			= "Modifier données du formulaire";
$pgv_lang["ra_FilterBy"]			= "Filtrer par";
$pgv_lang["ra_Recalculate"]			= "Recalculer";
$pgv_lang["ra_LocalData"]			= "Données locales";
$pgv_lang["ra_RelatedRecord"]		= "Enregistrement associé";
$pgv_lang["ra_RelatedData"]			= "Données associées";
$pgv_lang["ra_Fields"]			= "Nombre de champs";
$pgv_lang["ra_FieldName"]			= "Nom du champ";
$pgv_lang["ra_InputType"]			= "Type d'entrée";
$pgv_lang["ra_FormBuilder"]			= "Générateur de formulaires";
$pgv_lang["ra_FormName"]			= "Entrez le nom du formulaire";
$pgv_lang["ra_MultiplePeople"]		= "Le formulaire s’applique-t-il à plusieurs personnes&nbsp;?";
$pgv_lang["ra_FormDescription"]		= "Entrez une description du formulaire";
$pgv_lang["ra_FormGeneration"]		= "Création du formulaire terminée&nbsp;!";
$pgv_lang["ra_CustomField"]			= "Nom du champ personnalisé";
$pgv_lang["ra_txt"]				= "Texte";
$pgv_lang["ra_checkbox"]			= "Case à cocher";
$pgv_lang["ra_radiobutton"]			= "Bouton radio";
$pgv_lang["ra_EnterResults"]			= "Entrez les résultats";
$pgv_lang["ra_generate_tasks"]		= "Créer des tâches à partir de TODO";
$pgv_lang["ra_SelectFolder"]			= "Choisir un dossier";
$pgv_lang["ra_done"]			= "Fini";
$pgv_lang["ra_LocalPercent"]			= "Pourcentage local";
$pgv_lang["ra_GlobalPercent"]		= "Pourcentage mondial";
$pgv_lang["ra_Average"]			= "Moyenne";
$pgv_lang["ra_NoData"]			= "Aucune donnée&nbsp;!";
$pgv_lang["ra_NotEnoughData"]		= "Pas assez de données&nbsp;!";
$pgv_lang["ra_IncompleteDate"]	= "Date incomplète <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Il y a une chance de %PERCENT% que le lieu de naissance soit&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Il y a une chance de %PERCENT% que le lieu du décès soit&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Il y a une chance de %PERCENT% que le nom de famille soit&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Il y a une chance de %PERCENT% que le lieu du mariage soit&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Il y a une chance de %PERCENT% que le prénom soit&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Toutes";
$pgv_lang["ra_More"]			= "Plus";
$pgv_lang["ra_ThereIsChance"]		= "Les sources possibles peuvent inclure";
$pgv_lang["ra_TheMostLikely"]		= "L'endroit le plus probable pour cette source est&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Dossier";
$pgv_lang["ra_Edit_Gen_Task"]		= "Modifier la tâche générée";
$pgv_lang["ra_Start_Date"]			= "Date de début";
$pgv_lang["ra_Folder_View"]			= "Vue du dossier";
$pgv_lang["ra_Task_View"]			= "Vue de la tâche";
$pgv_lang["ra_page_header"]			= "Dossiers ".$pgv_lang["ra_RA_name"];
$pgv_lang["ra_no_folder_name"]		= "Le champ du nom du dossier doit être rempli.";
$pgv_lang["ra_add_folder"]			= "Ajouter un dossier";
$pgv_lang["ra_Folder_Name"]			= "Nom du dossier";
$pgv_lang["ra_Parent_Folder"]		= "Dossier parent";
$pgv_lang["ra_No_Parent"]			= "Pas de dossier parent";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Les noms de dossier doivent être uniques.";
$pgv_lang["ra_folder_submitted"]		= "Votre dossier a été soumis";
$pgv_lang["ra_folder_problem"]		= "Il y a eu un problème lors de l'ajout de votre dossier, veuillez réessayer";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Créer une nouvelle tâche";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Aucun dossier n'existe. Veuillez d'abord créer un nouveau dossier.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Afficher la tâche";
$pgv_lang["ra_no_indi_tasks"]		= "Aucune tâche n'est associée à cette personne";
$pgv_lang["ra_no_sour_tasks"]		= "Aucune tâche n'est associée à cette source";
$pgv_lang["ra_assigned"]			= "Assignée";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Ajouter une nouvelle tâche";
$pgv_lang["ra_submit"]			= "Soumettre";
$pgv_lang["ra_save_and_complete"]		= "Enregistrer et terminer";
$pgv_lang["ra_assign_task"]			= "Attribuer une tâche";
$pgv_lang["ra_AddTask"]			= "Ajouter une tâche";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Commentaire";
$pgv_lang["ra_add_new_comment"]		= "Ajouter un nouveau commentaire";
$pgv_lang["ra_edit_comment"]		= "Modifier le commentaire";
$pgv_lang["ra_comment_success"]		= "Votre commentaire a été ajouté avec succès.";
$pgv_lang["ra_comment_delete_check"]	= "Etes-vous sûr de vouloir supprimer ce commentaire&nbsp;?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Configurer la confidentialité";
$pgv_lang["ra_show_my_tasks"]		= "Afficher «&nbsp;Mes tâches&nbsp;»";
$pgv_lang["ra_show_add_task"]		= "Afficher «&nbsp;Ajouter une tâche&nbsp;»";
$pgv_lang["ra_show_auto_gen_task"]		= "Afficher «&nbsp;Générer automatiquement la tâche&nbsp;»";
$pgv_lang["ra_show_view_folders"]		= "Afficher «&nbsp;Afficher les dossiers&nbsp;»";
$pgv_lang["ra_show_add_folder"]		= "Afficher «&nbsp;Ajouter un dossier&nbsp;»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Afficher «&nbsp;Ajouter une source non liée&nbsp;»";
$pgv_lang["ra_show_view_probabilities"]	= "Afficher «&nbsp;Afficher les probabilités&nbsp;»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Nombre de lignes";
$pgv_lang["ra_state"]			= "État";
$pgv_lang["ra_call/url"]			= "Numéro de catalogue ou URL";
$pgv_lang["ra_enumDate"]			= "Date de recensement";
$pgv_lang["ra_county"]			= "Comté";
$pgv_lang["ra_city"]			= "Ville";
$pgv_lang["ra_complete_title"]		= "Terminer une tâche";
$pgv_lang["ra_select_form"]			= "Choisissez le formulaire";
$pgv_lang["ra_choose_form_label"]		= "Sélectionnez le formulaire de recherche conjointe";
$pgv_lang["ra_book"]			= "Livre";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "Comté";
$pgv_lang["ra_uk_boro"]			= "Ville ou arrondissement";
$pgv_lang["ra_uk_place"]			= "Lieu";

$pgv_lang["ra_AssIndiFacts"]			= "Associer les faits personnels";
$pgv_lang["ra_AssFamFacts"]			= "Associer les faits familiaux";
$pgv_lang["ra_facts"]			= "Faits";
$pgv_lang["ra_fact"]			= "Fait";
$pgv_lang["ra_remove"]			= "retirer";
$pgv_lang["ra_inferred_facts"]		= "Faits déduits";
$pgv_lang["ra_person"]			= "Personne";
$pgv_lang["ra_reason"]			= "Raison";
$pgv_lang["ra_success"]			= "Succès!";

$pgv_lang["ra_registration_number"]		= "Numéro d'enregistrement";
$pgv_lang["ra_serial_number"]		= "Numéro de série";
$pgv_lang["ra_number"]			= "Nombre";
$pgv_lang["ra_order_number"]		= "Numéro de commande";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Modifier";
$pgv_lang["ra_mytasks_unassigned"]		= "Non attribué";
$pgv_lang["ra_mytask_show_tasks"]		= "Afficher les tâches non attribuées&nbsp;?";
$pgv_lang["ra_mytask_show_completed"]	= "Afficher les tâches terminées&nbsp;?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Nom de famille";
$pgv_lang["ra_autosearch_givenname"]		= "Prénoms";
$pgv_lang["ra_autosearch_fullname"]		= "Nom";
$pgv_lang["ra_autosearch_firstname"]		= "Prénom";
$pgv_lang["ra_autosearch_middlename"]	= "Deuxième prénom";
$pgv_lang["ra_autosearch_byear"]		= "Année de naissance";
$pgv_lang["ra_autosearch_bloc"]		= "Lieu de naissance";
$pgv_lang["ra_autosearch_myear"]		= "Année du mariage";
$pgv_lang["ra_autosearch_mloc"]		= "Lieu du mariage";
$pgv_lang["ra_autosearch_dyear"]		= "Année de décès";
$pgv_lang["ra_autosearch_dloc"]		= "Lieu de décès";
$pgv_lang["ra_autosearch_gender"]		= "Genre";
$pgv_lang["ra_autosearch_ssurname"]		= "Nom de famille du conjoint";
$pgv_lang["ra_autosearch_sgivennames"]	= "Prénoms du conjoint";
$pgv_lang["ra_autosearch_sfullname"]		= "Nom du conjoint";
$pgv_lang["ra_autosearch_fsurname"]		= "Nom de famille du père";
$pgv_lang["ra_autosearch_fgivennames"]	= "Prénoms du père";
$pgv_lang["ra_autosearch_ffullname"]		= "Nom du père";
$pgv_lang["ra_autosearch_msurname"]		= "Nom de famille de la mère";
$pgv_lang["ra_autosearch_mgivennames"]	= "Prénoms de la mère";
$pgv_lang["ra_autosearch_mfullname"]		= "Nom de la mère";
$pgv_lang["ra_autosearch_country"]		= "Pays";
$pgv_lang["ra_autosearch_cemetery"]		= "Cimetière";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plugin";
$pgv_lang["ra_autosearch_search"]		= "Recherche";
$pgv_lang["ra_autosearch_keywords"]		= "Mots clés";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "Le dossier contient des tâches et ne peut pas être supprimé";
$pgv_lang["ra_has_folders"]			= "Le dossier contient des dossiers et ne peut pas être supprimé";
?>
