<?php
/**
 * Dutch language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.nl.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.nl.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Bekijken";
$pgv_lang["ra_description"]			= "Beschrijving";
$pgv_lang["ra_source"]			= "Bron";
$pgv_lang["ra_sources"]			= "Bronnen";
$pgv_lang["ra_people"]			= "Personen";
$pgv_lang["ra_comments"]			= "Kommentarer";
$pgv_lang["ra_edit"]			= "Bewerk";
$pgv_lang["ra_save"]			= "Opslaan";
$pgv_lang["ra_cancel"]			= "Annuleer";
$pgv_lang["ra_delete"]			= "Verwijder";
$pgv_lang["ra_no"]				= "Nee";
$pgv_lang["ra_yes"]				= "Ja";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Toevoegen";
$pgv_lang["ra_close_window"]		= "Venster sluiten";
$pgv_lang["ra_config_block"]			= "Aanpassen";
$pgv_lang["ra_page"]			= "Pagina";
$pgv_lang["ra_reset"]			= "Terugzetten";
$pgv_lang["ra_title"]			= "Titel";
$pgv_lang["ra_add_media"]			= "Voeg een nieuw media-item toe";
$pgv_lang["ra_choose_search_site"]		= "Kies een zoeksite";
$pgv_lang["ra_pid_search_for"]		= "Over wie wilt u externe genealogiesites doorzoeken naar informatie?";
$pgv_lang["ra_manage_research"]		= "Onderzoek beheren";
$pgv_lang["ra_analyze_database"]		= "Database analyseren";
$pgv_lang["ra_analyze_data"]			= "Analyseer mijn gegevens";
$pgv_lang["ra_missing_info"] 			= "Ontbrekende informatie";
$pgv_lang["ra_auto_search_text"]		= "Zoeken in externe webbronnen";
$pgv_lang["ra_task_list"]			= "Taken";
$pgv_lang["ra_next"]			= "Volgende";
$pgv_lang["ra_DataCorrelations"]		= "Gegevenscorrelaties";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Mijn taken";
$pgv_lang["ra_add_task"]			= "Taak toevoegen";
$pgv_lang["ra_view_folders"]			= "Mappen bekijken";
$pgv_lang["ra_view_probabilities"]		= "Bekijk waarschijnlijkheden";
$pgv_lang["ra_up_folder"]			= "Hoger";
$pgv_lang["ra_edit_folder"]			= "Map toevoegen of bewerken";
$pgv_lang["ra_Add_folder"]			= "Map toevoegen";
$pgv_lang["ra_Edit_folder"]			= "Map bewerken";
$pgv_lang["ra_gen_tasks"]			= "Automatisch taken aanmaken";
$pgv_lang["ra_generate"]			= "Aanmaken";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Onderzoeksassistent";
$pgv_lang["ra_edit_task"]			= "Taak bewerken";
$pgv_lang["ra_completed"]			= "Volledig";
$pgv_lang["ra_complete"]			= "Volledig";
$pgv_lang["ra_incomplete"]			= "Onvolledig";
$pgv_lang["ra_created"]			= "Gemaakt";
$pgv_lang["ra_details"]			= "Details";
$pgv_lang["ra_result"]			= "Resultaat";
$pgv_lang["ra_okay"]			= "Oké";
$pgv_lang["ra_editform"]			= "Formuliergegevens bewerken";
$pgv_lang["ra_FilterBy"]			= "Filteren op";
$pgv_lang["ra_Recalculate"]			= "Herberekenen";
$pgv_lang["ra_LocalData"]			= "Lokale gegevens";
$pgv_lang["ra_RelatedRecord"]		= "Gerelateerd record";
$pgv_lang["ra_RelatedData"]			= "Gerelateerde gegevens";
$pgv_lang["ra_Fields"]			= "Aantal velden";
$pgv_lang["ra_FieldName"]			= "Veldnaam";
$pgv_lang["ra_InputType"]			= "Invoertype";
$pgv_lang["ra_FormBuilder"]			= "Formulierbouwer";
$pgv_lang["ra_FormName"]			= "Voer de formuliernaam in";
$pgv_lang["ra_MultiplePeople"]		= "Is het formulier geldig voor meerdere personen?";
$pgv_lang["ra_FormDescription"]		= "Voer een beschrijving van het formulier in";
$pgv_lang["ra_FormGeneration"]		= "Formulier aanmaken voltooid!";
$pgv_lang["ra_CustomField"]			= "Gepersonaliseerde veldnaam";
$pgv_lang["ra_txt"]				= "Tekst";
$pgv_lang["ra_checkbox"]			= "Vakje";
$pgv_lang["ra_radiobutton"]			= "Keuzerondje";
$pgv_lang["ra_EnterResults"]			= "Resultaten invoeren";
$pgv_lang["ra_generate_tasks"]		= "Taken maken vanuit TODO";
$pgv_lang["ra_SelectFolder"]			= "Kies map";
$pgv_lang["ra_done"]			= "Klaar";
$pgv_lang["ra_LocalPercent"]			= "Lokaal percentage";
$pgv_lang["ra_GlobalPercent"]		= "Wereldwijd percentage";
$pgv_lang["ra_Average"]			= "Gemiddeld";
$pgv_lang["ra_NoData"]			= "Geen gegevens!";
$pgv_lang["ra_NotEnoughData"]		= "Niet genoeg gegevens!";
$pgv_lang["ra_IncompleteDate"]	= "Onvolledige datum <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Er is een kans van %PERCENT% dat de geboorteplaats is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Er is een kans van %PERCENT% dat de plaats van overlijden is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Er is een kans van %PERCENT% dat de achternaam is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Er is een kans van %PERCENT% dat de trouwlocatie is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Er is een kans van %PERCENT% dat de opgegeven naam is&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Alle";
$pgv_lang["ra_More"]			= "Meer";
$pgv_lang["ra_ThereIsChance"]		= "Mogelijke bronnen kunnen zijn:";
$pgv_lang["ra_TheMostLikely"]		= "De meest waarschijnlijke plaats voor deze bron is&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Map";
$pgv_lang["ra_Edit_Gen_Task"]		= "Bewerk gegenereerde taak";
$pgv_lang["ra_Start_Date"]			= "Startdatum";
$pgv_lang["ra_Folder_View"]			= "Mapweergave";
$pgv_lang["ra_Task_View"]			= "Taakweergave";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Mappen";
$pgv_lang["ra_no_folder_name"]		= "Het veld Mapnaam moet worden ingevuld.";
$pgv_lang["ra_add_folder"]			= "Map toevoegen";
$pgv_lang["ra_Folder_Name"]			= "Mapnaam";
$pgv_lang["ra_Parent_Folder"]		= "Bovenliggende map";
$pgv_lang["ra_No_Parent"]			= "Geen bovenliggende map";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Mapnamen moeten uniek zijn.";
$pgv_lang["ra_folder_submitted"]		= "Uw map is verzonden";
$pgv_lang["ra_folder_problem"]		= "Er is een probleem opgetreden bij het toevoegen van uw map. Probeer het opnieuw.";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Nieuwe taak maken";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Er bestaat geen map. Maak eerst een nieuwe map.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Taak bekijken";
$pgv_lang["ra_no_indi_tasks"]		= "Er zijn geen taken gekoppeld aan deze persoon";
$pgv_lang["ra_no_sour_tasks"]		= "Er zijn geen taken gekoppeld aan deze bron";
$pgv_lang["ra_assigned"]			= "Toegewezen";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Nieuwe taak toevoegen";
$pgv_lang["ra_submit"]			= "Indienen";
$pgv_lang["ra_save_and_complete"]		= "Opslaan en voltooien";
$pgv_lang["ra_assign_task"]			= "Taak toewijzen";
$pgv_lang["ra_AddTask"]			= "Taak toevoegen";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Commentaar";
$pgv_lang["ra_add_new_comment"]		= "Nieuwe commentaar toevoegen";
$pgv_lang["ra_edit_comment"]		= "Bewerken commentaar";
$pgv_lang["ra_comment_success"]		= "Uw ocommentaar is succesvol toegevoegd.";
$pgv_lang["ra_comment_delete_check"]	= "Weet u zeker dat u deze commentaar wilt verwijderen?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Privacy configureren";
$pgv_lang["ra_show_my_tasks"]		= "Toon «Mijn taken»";
$pgv_lang["ra_show_add_task"]		= "Toon «Taak toevoegen»";
$pgv_lang["ra_show_auto_gen_task"]		= "Toon «Automatisch taak genereren»";
$pgv_lang["ra_show_view_folders"]		= "Toon «Mappen weergeven»";
$pgv_lang["ra_show_add_folder"]		= "Toon «Map toevoegen»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Toon «Voeg niet-gekoppelde bron toe»";
$pgv_lang["ra_show_view_probabilities"]	= "Toon «Bekijk waarschijnlijkheden»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Aantal rijen";
$pgv_lang["ra_state"]			= "Staat";
$pgv_lang["ra_call/url"]			= "Catalogusnummer of URL";
$pgv_lang["ra_enumDate"]			= "Enumeratiedatum";
$pgv_lang["ra_county"]			= "District";
$pgv_lang["ra_city"]			= "Stad";
$pgv_lang["ra_complete_title"]		= "Taak voltooien";
$pgv_lang["ra_select_form"]			= "Kies formulier";
$pgv_lang["ra_choose_form_label"]		= "Gezamenlijke onderzoeksvorm selecteren";
$pgv_lang["ra_book"]			= "Boek";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "District";
$pgv_lang["ra_uk_boro"]			= "Stad of gemeente";
$pgv_lang["ra_uk_place"]			= "Plaats";

$pgv_lang["ra_AssIndiFacts"]			= "Associeer Persoon Feiten";
$pgv_lang["ra_AssFamFacts"]			= "Associeer Familie Feiten";
$pgv_lang["ra_facts"]			= "Feiten";
$pgv_lang["ra_fact"]			= "Feit";
$pgv_lang["ra_remove"]			= "verwijder";
$pgv_lang["ra_inferred_facts"]		= "Afgeleide feiten";
$pgv_lang["ra_person"]			= "Persoon";
$pgv_lang["ra_reason"]			= "Reden";
$pgv_lang["ra_success"]			= "Succes!";

$pgv_lang["ra_registration_number"]		= "Registratienummer";
$pgv_lang["ra_serial_number"]		= "Serienummer";
$pgv_lang["ra_number"]			= "Nummer";
$pgv_lang["ra_order_number"]		= "Bestelnummer";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Bewerking";
$pgv_lang["ra_mytasks_unassigned"]		= "Niet toegewezen";
$pgv_lang["ra_mytask_show_tasks"]		= "Niet-toegewezen taken weergeven?";
$pgv_lang["ra_mytask_show_completed"]	= "Voltooide taken weergeven?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Achternaam";
$pgv_lang["ra_autosearch_givenname"]		= "Voornamen";
$pgv_lang["ra_autosearch_fullname"]		= "Naam";
$pgv_lang["ra_autosearch_firstname"]		= "Voornaam";
$pgv_lang["ra_autosearch_middlename"]	= "Middelste namen";
$pgv_lang["ra_autosearch_byear"]		= "Geboortejaar";
$pgv_lang["ra_autosearch_bloc"]		= "Geboorteplaats";
$pgv_lang["ra_autosearch_myear"]		= "Huwelijksjaar";
$pgv_lang["ra_autosearch_mloc"]		= "Huwelijksplaats";
$pgv_lang["ra_autosearch_dyear"]		= "Overlijdensjaar";
$pgv_lang["ra_autosearch_dloc"]		= "Plaats van overlijden";
$pgv_lang["ra_autosearch_gender"]		= "Geslacht";
$pgv_lang["ra_autosearch_ssurname"]		= "Echtgenoots achternaam";
$pgv_lang["ra_autosearch_sgivennames"]	= "Voornamen van de Echtgenoots ";
$pgv_lang["ra_autosearch_sfullname"]		= "Echtgenoots naam";
$pgv_lang["ra_autosearch_fsurname"]		= "Vaders achternaam ";
$pgv_lang["ra_autosearch_fgivennames"]	= "Vaders voornamen";
$pgv_lang["ra_autosearch_ffullname"]		= "Vaders naam";
$pgv_lang["ra_autosearch_msurname"]		= "Moeders achternaam";
$pgv_lang["ra_autosearch_mgivennames"]	= "Moeders voornamen";
$pgv_lang["ra_autosearch_mfullname"]		= "Moeders naam";
$pgv_lang["ra_autosearch_country"]		= "Land";
$pgv_lang["ra_autosearch_cemetery"]		= "Begraafplaats";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Zoeken";
$pgv_lang["ra_autosearch_keywords"]		= "Trefwoorden";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "De map bevat taken en kan niet worden verwijderd";
$pgv_lang["ra_has_folders"]			= "De map bevat mappen en kan niet worden verwijderd";
?>
