<?php
/**
 * Norwegian language file for PhpGedView Research Assistant module
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Research_Assistant
 * @version $Id: lang.no.php 7377 2024-10-18 13:50:13Z canajun2eh $
 *
 * The companion file to this is help_text.no.php, which contains most of the lengthy texts.
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- To avoid having references to $pgv_lang["whatever"], copy the definitions from the original PGV language files to our own
$pgv_lang["ra_view"]			= "Se";
$pgv_lang["ra_description"]			= "Beskrivelse";
$pgv_lang["ra_source"]			= "Kilde";
$pgv_lang["ra_sources"]			= "Kilder";
$pgv_lang["ra_people"]			= "Personer";
$pgv_lang["ra_comments"]			= "Kommentarer";
$pgv_lang["ra_edit"]			= "Rediger";
$pgv_lang["ra_save"]			= "Lagre";
$pgv_lang["ra_cancel"]			= "Avbryt";
$pgv_lang["ra_delete"]			= "Slett";
$pgv_lang["ra_no"]				= "Nei";
$pgv_lang["ra_yes"]				= "Ja";
$pgv_lang["ra_ellipsis"]			= "\xE2\x80\xA6";
$pgv_lang["ra_add"]			= "Legge til";
$pgv_lang["ra_close_window"]		= "Lukk vinduet";
$pgv_lang["ra_config_block"]			= "Justere";
$pgv_lang["ra_page"]			= "Side";
$pgv_lang["ra_reset"]			= "Tilbakestill";
$pgv_lang["ra_title"]			= "Tittel";
$pgv_lang["ra_add_media"]			= "Legg til et nytt medieelement";
$pgv_lang["ra_choose_search_site"]		= "Velg et søkenettsted";
$pgv_lang["ra_pid_search_for"]		= "Om hvem ønsker du å søke på eksterne slektssider for informasjon?";
$pgv_lang["ra_manage_research"]		= "Administrer forskning";
$pgv_lang["ra_analyze_database"]		= "Analyser databasen";
$pgv_lang["ra_analyze_data"]			= "Analyser mine data";
$pgv_lang["ra_missing_info"] 			= "Manglende informasjon";
$pgv_lang["ra_auto_search_text"]		= "Søk i eksterne nettkilder";
$pgv_lang["ra_task_list"]			= "Oppgaver";
$pgv_lang["ra_next"]			= "Neste";
$pgv_lang["ra_DataCorrelations"]		= "Datakorrelasjoner";

/*
 *		Special handling of colons that either precede text in RTL languages or follow text in LTR languages
 *		Depending on the active language, either one of the following two variables must contain that colon symbol,
 *		and the other must be empty. To use this, you should code something like
 *			$output = "{$pgv_lang['ra-colon_rtl']}{$text}{$pgv_lang['ra-colon_ltr']}";
 *		or
 *			$output = $pgv_lang["ra-colon_rtl"].$text.$pgv_lang["ra-colon_ltr"];
 */
$pgv_lang["ra_colon_rtl"]			= "";		// Use this to put that colon to the left of text in RTL languages
$pgv_lang["ra_colon_ltr"]			= ":";		// Use this to put that colon to the right of text in LTR languages

// -- MENU ITEM MESSAGES
$pgv_lang["ra_my_tasks"]			= "Mine oppgaver";
$pgv_lang["ra_add_task"]			= "Legg til oppgave";
$pgv_lang["ra_view_folders"]			= "Vis mapper";
$pgv_lang["ra_view_probabilities"]		= "Vis sannsynligheter";
$pgv_lang["ra_up_folder"]			= "Høyere";
$pgv_lang["ra_edit_folder"]			= "Legg til eller rediger mappe";
$pgv_lang["ra_Add_folder"]			= "Legg til mappe";
$pgv_lang["ra_Edit_folder"]			= "Rediger mappe";
$pgv_lang["ra_gen_tasks"]			= "Skape oppgaver automatisk";
$pgv_lang["ra_generate"]			= "Skape";

// -- RA GENERAL MESSAGES
$pgv_lang["ra_RA_name"]				= "Forskningsassistent";
$pgv_lang["ra_edit_task"]			= "Rediger oppgave";
$pgv_lang["ra_completed"]			= "Fullstendig";
$pgv_lang["ra_complete"]			= "Fullstendig";
$pgv_lang["ra_incomplete"]			= "Ufullstendig";
$pgv_lang["ra_created"]			= "Opprettet";
$pgv_lang["ra_details"]			= "Detaljer";
$pgv_lang["ra_result"]			= "Resultatet";
$pgv_lang["ra_okay"]			= "Ok";
$pgv_lang["ra_editform"]			= "Rediger skjemadata";
$pgv_lang["ra_FilterBy"]			= "Filtrer etter";
$pgv_lang["ra_Recalculate"]			= "Beregn på nytt";
$pgv_lang["ra_LocalData"]			= "Lokale data";
$pgv_lang["ra_RelatedRecord"]		= "Relatert post";
$pgv_lang["ra_RelatedData"]			= "Relaterte data";
$pgv_lang["ra_Fields"]			= "Antall felt";
$pgv_lang["ra_FieldName"]			= "Feltnavn";
$pgv_lang["ra_InputType"]			= "Inndatatype";
$pgv_lang["ra_FormBuilder"]			= "Skjemabygger";
$pgv_lang["ra_FormName"]			= "Skriv inn skjemanavnet";
$pgv_lang["ra_MultiplePeople"]		= "Gjelder skjemaet for flere personer?";
$pgv_lang["ra_FormDescription"]		= "Skriv inn en beskrivelse av skjemaet";
$pgv_lang["ra_FormGeneration"]		= "Skjemaoppretting fullført!";
$pgv_lang["ra_CustomField"]			= "Egendefinert feltnavn";
$pgv_lang["ra_txt"]				= "Tekst";
$pgv_lang["ra_checkbox"]			= "Avmerkingsboks";
$pgv_lang["ra_radiobutton"]			= "Radioknapp";
$pgv_lang["ra_EnterResults"]			= "Skriv inn resultater";
$pgv_lang["ra_generate_tasks"]		= "Lag oppgaver fra TODO";
$pgv_lang["ra_SelectFolder"]			= "Velg mappe";
$pgv_lang["ra_done"]			= "Ferdig";
$pgv_lang["ra_LocalPercent"]			= "Lokal prosentandel";
$pgv_lang["ra_GlobalPercent"]		= "Global prosentandele";
$pgv_lang["ra_Average"]			= "Gjennomsnittlig";
$pgv_lang["ra_NoData"]			= "Ingen data!";
$pgv_lang["ra_NotEnoughData"]		= "Ikke nok data!";
$pgv_lang["ra_IncompleteDate"]	= "Ufullstendig dato <i>(%INF_FACT%)</i>";
$pgv_lang["ra_InferIndvBirthPlac"]		= "Det er en %PERCENT% sjanse for at fødestedet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvDeathPlac"]		= "Det er en %PERCENT% sjanse for at dødsstedet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvSurn"]			= "Det er en %PERCENT% sjanse for at etternavnet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvMarriagePlace"]	= "Det er en %PERCENT% sjanse for at ekteskapsstedet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_InferIndvGivn"]			= "Det er en %PERCENT% sjanse for at det gitte navnet er&nbsp;<i>%INF_FACT%</i>";
$pgv_lang["ra_All"]				= "Alle";
$pgv_lang["ra_More"]			= "Flere";
$pgv_lang["ra_ThereIsChance"]		= "Mulige kilder kan inkludere";
$pgv_lang["ra_TheMostLikely"]		= "Det mest sannsynlige stedet for denne kilden er&nbsp;<i>%INF_FACT%</i>";

// -- RA_FOLDER MESSAGES
$pgv_lang["ra_Folder"]			= "Mappe";
$pgv_lang["ra_Edit_Gen_Task"]		= "Rediger generert oppgave";
$pgv_lang["ra_Start_Date"]			= "Startdato";
$pgv_lang["ra_Folder_View"]			= "Mappevisning";
$pgv_lang["ra_Task_View"]			= "Oppgavevisning";
$pgv_lang["ra_page_header"]			= $pgv_lang["ra_RA_name"]." Mapper";
$pgv_lang["ra_no_folder_name"]		= "Feltet for mappenavn må fylles ut.";
$pgv_lang["ra_add_folder"]			= "Legg til mappe";
$pgv_lang["ra_Folder_Name"]			= "Mappenavn";
$pgv_lang["ra_Parent_Folder"]		= "Overordnet mappe";
$pgv_lang["ra_No_Parent"]			= "Ingen overordnet mappe";
$pgv_lang["ra_Folder_names_must_be_unique"]	= "Mappenavn må være unike.";
$pgv_lang["ra_folder_submitted"]		= "Mappen din er sendt inn";
$pgv_lang["ra_folder_problem"]		= "Det har oppstått et problem med å legge til mappen din, prøv igjen";

// -- RA_TAB MISSING INFO BUTTON
$pgv_lang["ra_task_entry"]			= "Opprett ny oppgave";

//-- ERROR MESSAGES
$pgv_lang["ra_no_folder"]			= "Det finnes ingen mappe. Opprett en ny mappe først.";

//-- RA_VIEWTASK MESSAGES
$pgv_lang["ra_view_task"]			= "Vis oppgave";
$pgv_lang["ra_no_indi_tasks"]		= "Ingen oppgaver er knyttet til denne personen";
$pgv_lang["ra_no_sour_tasks"]		= "Ingen oppgaver er knyttet til denne kilden";
$pgv_lang["ra_assigned"]			= "Tildelt";

//-- RA_ADDTASK MESSAGES
$pgv_lang["ra_add_new_task"]		= "Legg til ny oppgave";
$pgv_lang["ra_submit"]			= "Send inn";
$pgv_lang["ra_save_and_complete"]		= "Lagre og fullfør";
$pgv_lang["ra_assign_task"]			= "Tilordne oppgave";
$pgv_lang["ra_AddTask"]			= "Legg til oppgave";

//-- RA_COMMENT MESSAGES
$pgv_lang["ra_comment_body"]		= "Kommentar";
$pgv_lang["ra_add_new_comment"]		= "Legg til ny kommentar";
$pgv_lang["ra_edit_comment"]		= "Rediger kommentar";
$pgv_lang["ra_comment_success"]		= "Kommentaren din ble lagt til.";
$pgv_lang["ra_comment_delete_check"]	= "Er du sikker på at du vil slette denne kommentaren?";

//-- RA_CONFIGURE PRIVACY MESSAGES
$pgv_lang["ra_configure_privacy"]		= "Konfigurer konfidensialitet";
$pgv_lang["ra_show_my_tasks"]		= "Vis «Mine oppgaver»";
$pgv_lang["ra_show_add_task"]		= "Vis «Legg til oppgave»";
$pgv_lang["ra_show_auto_gen_task"]		= "Vis «Autogenerer oppgave»";
$pgv_lang["ra_show_view_folders"]		= "Vis «Vis mapper»";
$pgv_lang["ra_show_add_folder"]		= "Vis «Legg til mappe»";
$pgv_lang["ra_show_add_unlinked_source"]	= "Vis «Legg til frakoblet kilde»";
$pgv_lang["ra_show_view_probabilities"]	= "Vis «Vis sannsynligheter»";

//-- Census Forms
$pgv_lang["ra_rows"]			= "Antall rader";
$pgv_lang["ra_state"]			= "Staten";
$pgv_lang["ra_call/url"]			= "Katalognummer eller URL";
$pgv_lang["ra_enumDate"]			= "Opptellingsdato";
$pgv_lang["ra_county"]			= "Fylke";
$pgv_lang["ra_city"]			= "By";
$pgv_lang["ra_complete_title"]		= "Fullfør en oppgave";
$pgv_lang["ra_select_form"]			= "Velg Skjema";
$pgv_lang["ra_choose_form_label"]		= "Velg felles forskningsskjema";
$pgv_lang["ra_book"]			= "Bok";
$pgv_lang["ra_folio"]			= "Folio";
$pgv_lang["ra_uk_county"]			= "Fylke";
$pgv_lang["ra_uk_boro"]			= "By eller bydel";
$pgv_lang["ra_uk_place"]			= "Sted";

$pgv_lang["ra_AssIndiFacts"]			= "Tilknytt personfakta";
$pgv_lang["ra_AssFamFacts"]			= "Knytt familiefakta";
$pgv_lang["ra_facts"]			= "Fakta";
$pgv_lang["ra_fact"]			= "Faktum";
$pgv_lang["ra_remove"]			= "fjerne";
$pgv_lang["ra_inferred_facts"]		= "Utledede fakta";
$pgv_lang["ra_person"]			= "Person";
$pgv_lang["ra_reason"]			= "Grunn";
$pgv_lang["ra_success"]			= "Suksess!";

$pgv_lang["ra_registration_number"]		= "Registreringsnummer";
$pgv_lang["ra_serial_number"]		= "Serienummer";
$pgv_lang["ra_number"]			= "Nummer";
$pgv_lang["ra_order_number"]		= "Bestillingsnummer";

//-- MY TASK BLOCK
$pgv_lang["ra_mytasks_block"]		= $pgv_lang["ra_RA_name"];
$pgv_lang["ra_mytasks_edit"]			= "Redigere";
$pgv_lang["ra_mytasks_unassigned"]		= "Ikke tilordnet";
$pgv_lang["ra_mytask_show_tasks"]		= "Vise ikke-tildelte oppgaver?";
$pgv_lang["ra_mytask_show_completed"]	= "Vise fullførte oppgaver?";

//-- Auto Search Assistant 
$pgv_lang["ra_autosearch_surname"]		= "Etternavn";
$pgv_lang["ra_autosearch_givenname"]		= "Fornavn";
$pgv_lang["ra_autosearch_fullname"]		= "Navn";
$pgv_lang["ra_autosearch_firstname"]		= "Fornavn";
$pgv_lang["ra_autosearch_middlename"]	= "Mellomnavn";
$pgv_lang["ra_autosearch_byear"]		= "Fødselsår";
$pgv_lang["ra_autosearch_bloc"]		= "Fødested";
$pgv_lang["ra_autosearch_myear"]		= "Ekteskapsår";
$pgv_lang["ra_autosearch_mloc"]		= "Ekteskapssted";
$pgv_lang["ra_autosearch_dyear"]		= "Dødsår";
$pgv_lang["ra_autosearch_dloc"]		= "Dødssted";
$pgv_lang["ra_autosearch_gender"]		= "Kjønn";
$pgv_lang["ra_autosearch_ssurname"]		= "Ektefellens etternavn";
$pgv_lang["ra_autosearch_sgivennames"]	= "Ektefellens fornavn";
$pgv_lang["ra_autosearch_sfullname"]		= "Ektefellens navn";
$pgv_lang["ra_autosearch_fsurname"]		= "Fars etternavn";
$pgv_lang["ra_autosearch_fgivennames"]	= "Fars fornavn";
$pgv_lang["ra_autosearch_ffullname"]		= "Fars navn";
$pgv_lang["ra_autosearch_msurname"]		= "Mors etternavn";
$pgv_lang["ra_autosearch_mgivennames"]	= "Mors fornavn";
$pgv_lang["ra_autosearch_mfullname"]		= "Mors navn";
$pgv_lang["ra_autosearch_country"]		= "Land";
$pgv_lang["ra_autosearch_cemetery"]		= "Gravplass";
$pgv_lang["ra_autosearch_plugin_name"]	= "";
$pgv_lang["ra_autosearch_plugin"]		= "#pgv_lang[ra_autosearch_plugin_name]# Plug-in";
$pgv_lang["ra_autosearch_search"]		= "Søk";
$pgv_lang["ra_autosearch_keywords"]		= "Nøkkelord";

//Folder deletion error messages
$pgv_lang["ra_has_tasks"]			= "Mappen inneholder oppgaver og kan ikke slettes";
$pgv_lang["ra_has_folders"]			= "Mappen inneholder mapper og kan ikke slettes";
?>
