<?php
/**
 * Search Plug-in for www.ancestry.com
 *	Original URL: 'http://search.ancestry.com/cgi-bin/sse.dll?'
 *	Original Parameters: 'gsfn'='givenname' (ie given first name), 'gsln'='surname' (ie given last name),
 *		'gsby'='byear' (ie birth year), 'msbpn__ftp'='bloc' (ie birth location), 
 *		'gsdy'='dyear' (ie death year), 'msdpn__ftp'='dloc' (ie death location),
 *		'_8000C000'='ffullname' (ie fathers full name),
 *		'_80008000'='mfullname' (ie mothers full name),
 *		'_80018000'='sfullname' (ie spouses full name),
 *		'gskw'='keywords'
 *
 *	New URL: 'https://www.ancestry.ca/search/?count=50&'
 *	New Parameters: 'name'='fullname' (ie first name '+' middle name '_' last name),
 *		birth='byear'.'_'.'bloc' (ie birth year concatentated with birth location via underscore),
 *		death='dyear'.'_'.'dloc' (ie death year concatentated with death location via underscore),
 *		'father'='ffullname' (ie fathers full name),
 *		'mother'='mfullname' (ie mothers full name),
 *		'spouse'='sfullname' (ie spouses full name),
 *		'keyword'='keywords'
 *	Unused Parameters: 'gender'='gender' (ie m for male, f for female)
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: ancestry.php 7377 2024-10-18 13:50:13Z canajun2eh $
 * @package PhpGedView
 * @subpackage Research Assistant
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

require_once PGV_ROOT.'modules/research_assistant/search_plugin/base_autosearch.php';

class AutoSearch extends Base_AutoSearch {
	function __construct() {
		parent::__construct(
			// Name of this file, without the extension.
			// NB must also define this in $pgv_lang["autosearch_plugin_name_XXXX"]
			basename(__FILE__, '.php'),
			// Plug-in name displayed 
			"Ancestry.com", 
			// Search engine URL, ending in "?" or "&"
			'https://www.ancestry.ca/search/?count=50&',
			// Form method: GET or POST
			'GET',
			// Array keys are field names for the URL.
			// Array values are:
			//  function = defined in Base_AutoSearch and $pgv_lang["autosearch_XXXX"]
			//  extra    = extra html to add to the checkbox
			array(
				'name'=>array('function'=>'fullname', 'extra'=>'checked="checked"'),
				'birthconc'=>array('concatenate'=>'_'),
				'birth'=>array('function'=>'byear', 'extra'=>'checked="checked"'),
				'msbpn__ftp'=>array('function'=>'bloc'),
				'deathconc'=>array('concatenate'=>'_'),
				'death'=>array('function'=>'dyear'),
				'msdpn__ftp'=>array('function'=>'dloc'),
				'father'=>array('function'=>'ffullname'),
				'mother'=>array('function'=>'mfullname'),
				'spouse'=>array('function'=>'sfullname'),
				'keywords'=>array('function'=>'keywords')
			)
		);
	}
}

?>
