<?php
/**
 * Search Plug-in for www.findagrave.com
 *	Original URL: 'https://www.findagrave.com/memorial/search?includeMaidenName=true&'
 *	Original Parameters:
 *		'firstname'='firstname' (ie given first name),
 *		'middlename'='middlename' (ie middle names),
 *		'lastname'='surname' (ie given last name),
 *		birth='byear' (ie birth year),
 *		death='dyear' (ie death year),
 *		'linkedToName'='ffullname' (ie check linkage of grave to fathers full name),
 *
 *	Unused Parameters: 
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: findagrave.php 7377 2024-10-18 13:50:13Z canajun2eh $
 * @package PhpGedView
 * @subpackage Research Assistant
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

require_once PGV_ROOT.'modules/research_assistant/search_plugin/base_autosearch.php';

class AutoSearch extends Base_AutoSearch {
	function __construct() {
		parent::__construct(
			// Name of this file, without the extension.
			// NB must also define this in $pgv_lang["autosearch_plugin_name_XXXX"]
			basename(__FILE__, '.php'),
			// Plug-in name displayed 
			"Findagrave.com",  // basename(__FILE__, '.php'),
			// Search engine URL, ending in "?" or "&"
			'https://www.findagrave.com/memorial/search?includeMaidenName=true&',
			// Form method: GET or POST
			'GET',
			// Array keys are field names for the URL.
			// Array values are:
			//  function = defined in Base_AutoSearch and $pgv_lang["autosearch_XXXX"]
			//  extra    = extra html to add to the checkbox
			array(
				'firstname'=>array('function'=>'firstname', 'extra'=>'checked="checked"'),
				'middlename'=>array('function'=>'middlename'),
				'lastname'=>array('function'=>'surname', 'extra'=>'checked="checked"'),
				'birthyear'=>array('function'=>'byear',     'extra'=>'checked="checked"'),
				'deathyear'=>array('function'=>'dyear',     'extra'=>'checked="checked"'),
				'linkedToName'=>array('function'=>'ffullname'),
				'location'=>array('function'=>'cemetery')
			)
		);
	}
}

?>
