<?php
/**
 * Search Plug-in for www.werelate.org
 * 	Old URL: 'http://www.werelate.org/search?hitsPerPage=10&'
 *	Old Parameters: givenname, surname, keywords
 *	New URL: 'https://www.werelate.org/wiki/Special:Search?sort=score&ns=All&a=&st=&rows=20&'
 *	New Parameters: g (for givenname), s (for surname), k (for keywords)
 *	Unused New Parameters: p (for Place), bd (birth date), br (+/- X years from birth date, value 1,2,5), bp (birth place)
 *		dd (death date), dr (+/- X years from death date, value 1,2,5), dp (death place)
 *		fg (fathers given name), fs (fathers surname), mg (mothers given name), ms (mothers surname)
 *		sg (spouses given name), ss (spouses surname), 
 *		hg (husband given name), hs (husband surname), wg (wife given name), ws (wife surname),
 *		md (marriage date), mr (+/- X years from marriage date, value 1,2,5), mp (marriage place)
 *		unknown (&pn=&li=&su=&sa=&t=&k=&ecp=c)
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2008 Greg Roach. All rights reserved.
 * Copyright (C) 2008 to 2024 PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: werelate.php 7377 2024-10-18 13:50:13Z canajun2eh $
 * @package PhpGedView
 * @subpackage Research Assistant
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

require_once PGV_ROOT.'modules/research_assistant/search_plugin/base_autosearch.php';

class AutoSearch extends Base_AutoSearch {
	function __construct() {
		parent::__construct(
			// Name of this file, without the extension.
			// NB must also define this in $pgv_lang["autosearch_plugin_name_XXXX"]
			basename(__FILE__, '.php'),
			// Plug-in name displayed 
			"Werelate.org",  // basename(__FILE__, '.php'),
			// Search engine URL, ending in "?" or "&"
			'https://www.werelate.org/wiki/Special:Search?sort=score&ns=All&a=&st=&rows=20&',
			// Form method: GET or POST
			'GET',
			// Array keys are field names for the URL.
			// Array values are:
			//  function = defined in Base_AutoSearch and $pgv_lang["autosearch_XXXX"]
			//  extra    = extra html to add to the checkbox
			array(
				'g'=>array('function'=>'givenname', 'extra'=>'checked="checked"'),
				's'  =>array('function'=>'surname',   'extra'=>'checked="checked"'),
				'k' =>array('function'=>'keywords')
			)
		);
	}
}

?>
