<?php
/**
 * Footer for Xenea theme
 *
 * PhpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2022  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Themes
 * @version $Id: footer.php 7357 2022-11-08 00:10:56Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

global $SEARCH_SPIDER;

echo "</div> <!-- closing div id=\"content\" -->\n";//FIXME uncomment as soon as ready
echo "<div id=\"footer\" class=\"$TEXT_DIRECTION\">";
echo "\n\t<div align=\"center\" style=\"width:99%;\">";
echo contact_links();
echo '<br /><a href="', PGV_PHPGEDVIEW_URL, '" target="_blank"><img src="', $PGV_IMAGE_DIR, '/', $PGV_IMAGES['gedview']['other'], '" width="100" height="45" border="0" alt="', PGV_PHPGEDVIEW, PGV_USER_IS_ADMIN? (" - " .PGV_VERSION_TEXT): "", '" title="', PGV_PHPGEDVIEW, PGV_USER_IS_ADMIN? (" - " .PGV_VERSION_TEXT): "", '" /></a><br />';
echo "\n\t<br /><br />";
if (empty($SEARCH_SPIDER)) {	// Don't show "Printer-friendly version" link, execution stats, or pending changes link to search engines
	if (showPrinterFriendly()) {
		$query = '&amp;' . get_query_string();
		if ($query == '&amp;') $query = '';		// Make sure the URL doesn't end with an orphan ampersand
		print_help_link("preview_help", "qm");
		echo '<a href="', PGV_SCRIPT_NAME, '?view=preview', $query, '"><button type="button">', $pgv_lang['print_preview'], '</button></a>';
		echo "<br />";
	}
	if ($SHOW_STATS || PGV_DEBUG) {
		echo execution_stats();
		echo "<br />";
	}
	if (exists_pending_change()) {
		echo $pgv_lang["changes_exist"], " <a href=\"javascript:;\" onclick=\"window.open('edit_changes.php', '_blank', 'width=600, height=500, resizable=1, scrollbars=1'); return false;\">", $pgv_lang["accept_changes"], "</a>\n";
		echo "<br />";
	}
	echo "<br /><br />";
}
echo "</div>";
echo "</div> <!-- close div id=\"footer\" -->\n";
?>
